"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "printRoutesCommand", {
    enumerable: true,
    get: function() {
        return printRoutesCommand;
    }
});
const _commander = require("commander");
const _ApplicationContext = require("../ApplicationContext");
const _createApp = require("../createApp");
const _env = require("../env");
function getRouteName(regexp) {
    return regexp.toString().replace(/\\\//g, '/').replace(/^\/\^(.*)\/i$/, '$1').replace('/?(?=/|$)', '');
}
function getRoutes(router, prefix = '') {
    let routes = [];
    for (const { route, name, handle, regexp } of router.stack){
        if (route) {
            routes.push(`${prefix}${route.path.replace(/(\$|\/)$/, '')}`);
        } else if (name === 'router') {
            routes = [
                ...routes,
                ...getRoutes(handle, `${prefix}${getRouteName(regexp)}`)
            ];
        }
    }
    return routes;
}
async function printRoutes() {
    const context = await new _ApplicationContext.ApplicationContext().init();
    (0, _env.setupEnv)();
    const { express: app } = await (0, _createApp.createApp)(context);
    // console instead of log.info is fine here because the aim is to output the
    // routes without wrapping, supressing, or transporting the output
    // eslint-disable-next-line no-console
    console.log(getRoutes(app._router).join('\n'));
    context.close();
    process.exit(0);
}
const printRoutesCommand = new _commander.Command('printRoutes').description('Debug: print the routes the server mounts').action(printRoutes);

//# sourceMappingURL=printRoutes.js.map