"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    startApi: function() {
        return startApi;
    },
    startApiCommand: function() {
        return startApiCommand;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _timeZoneCheck = require("@tamanu/shared/utils/timeZoneCheck");
const _createApp = require("../createApp");
const _ApplicationContext = require("../ApplicationContext");
const _serverInfo = require("../serverInfo");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const startApi = async ({ skipMigrationCheck })=>{
    _logging.log.info(`Starting central server version ${_serverInfo.version}`);
    _logging.log.info(`Process info`, {
        execArgs: process.execArgs || '<empty>'
    });
    const context = await new _ApplicationContext.ApplicationContext().init({
        appType: 'api'
    });
    const { store } = context;
    await store.sequelize.assertUpToDate({
        skipMigrationCheck
    });
    const { server } = await (0, _createApp.createApp)(context);
    await (0, _timeZoneCheck.performTimeZoneChecks)({
        sequelize: store.sequelize,
        config: _config.default
    });
    const minConnectionPoolSnapshotHeadroom = 4;
    const connectionPoolSnapshotHeadroom = _config.default.db?.pool?.max - _config.default?.sync?.numberConcurrentPullSnapshots;
    if (connectionPoolSnapshotHeadroom < minConnectionPoolSnapshotHeadroom) {
        _logging.log.warn(`WARNING: config.db.pool.max is dangerously close to config.sync.numberConcurrentPullSnapshots (within ${minConnectionPoolSnapshotHeadroom} connections)`, {
            'config.db.pool.max': _config.default.db?.pool?.max,
            'config.sync.numberConcurrentPullSnapshots': _config.default.sync?.numberConcurrentPullSnapshots,
            connectionPoolSnapshotHeadroom
        });
    }
    let { port } = _config.default;
    if (+process.env.PORT) {
        port = +process.env.PORT;
    }
    server.listen(port, ()=>{
        _logging.log.info(`Server is running on port ${port}!`);
    });
    context.onClose(()=>server.close());
    for (const sig of [
        'SIGINT',
        'SIGTERM'
    ]){
        process.once(sig, ()=>{
            _logging.log.info(`Received ${sig}, closing HTTP server`);
            context.close();
        });
    }
    await context.waitForClose();
};
const startApiCommand = new _commander.Command('startApi').alias('serve') // deprecated
.description('Start the Tamanu Central API server').option('--skipMigrationCheck', 'skip the migration check on startup').action(startApi);

//# sourceMappingURL=startApi.js.map