"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    startTasks: function() {
        return startTasks;
    },
    startTasksCommand: function() {
        return startTasksCommand;
    }
});
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _ApplicationContext = require("../ApplicationContext");
const _tasks = require("../tasks");
const _CentralSyncManager = require("../sync/CentralSyncManager");
const _packagejson = /*#__PURE__*/ _interop_require_default(require("../../package.json"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const startTasks = async ({ skipMigrationCheck })=>{
    _logging.log.info(`Starting Central tasks runner version ${_packagejson.default.version}`);
    const context = await new _ApplicationContext.ApplicationContext().init({
        appType: 'tasks'
    });
    await context.store.sequelize.assertUpToDate({
        skipMigrationCheck
    });
    context.centralSyncManager = new _CentralSyncManager.CentralSyncManager(context);
    const stopScheduledTasks = await (0, _tasks.startScheduledTasks)(context);
    for (const sig of [
        'SIGINT',
        'SIGTERM'
    ]){
        process.once(sig, async ()=>{
            _logging.log.info(`Received ${sig}, stopping scheduled tasks`);
            stopScheduledTasks();
            context.close();
        });
    }
    await context.waitForClose();
};
const startTasksCommand = new _commander.Command('startTasks').alias('tasks') // deprecated
.description('Start the Tamanu Central tasks runner').option('--skipMigrationCheck', 'skip the migration check on startup').action(startTasks);

//# sourceMappingURL=startTasks.js.map