"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "resolver", {
    enumerable: true,
    get: function() {
        return resolver;
    }
});
const _constants = require("@tamanu/constants");
const _resources = require("@tamanu/shared/utils/fhir/resources");
const _sleepAsync = require("@tamanu/shared/utils/sleepAsync");
async function resolver(_, { log, sequelize, models }) {
    await (0, _sleepAsync.sleepAsync)(3000); // sleep for 3 seconds to allow materialisation jobs to complete
    const materialisableResources = (0, _resources.resourcesThatCanDo)(models, _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE);
    log.debug('Starting resolve');
    await sequelize.transaction(async ()=>{
        for (const Resource of materialisableResources){
            await Resource.resolveUpstreams();
        }
    });
    log.debug('Done resolving');
}

//# sourceMappingURL=resolver.js.map