import { SettingPath } from '../types';
import { Models } from './readers/SettingsDBReader';
export declare const KEYS_EXPOSED_TO_FRONT_END: readonly ["ageDisplayFormat", "customisations", "features", "fields", "imagingCancellationReasons", "imagingPriorities", "insurer", "customisations", "printMeasures", "invoice", "labsCancellationReasons", "templates", "layouts", "triageCategories", "upcomingVaccinations", "vaccinations", "vitalEditReasons"];
export declare class ReadSettings<Path = SettingPath> {
    models: Models;
    facilityId?: string;
    constructor(models: Models, facilityId?: string);
    get(key: Path): Promise<string | number | object>;
    getFrontEndSettings(): Promise<{
        [x: string]: string | number | object;
    }>;
    getAll(): Promise<{
        [x: string]: string | number | object;
    }>;
}
