import * as yup from 'yup';
export declare const facilitySettings: {
    name: string;
    description: string;
    properties: {
        certifications: {
            properties: {
                covidClearanceCertificate: {
                    properties: {
                        after: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        daysSinceSampleTime: {
                            description: string;
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                        };
                        labTestCategories: {
                            description: string;
                            type: yup.ArraySchema<yup.StringSchema<string, import("yup/lib/types").AnyObject, string>, import("yup/lib/types").AnyObject, string[], string[]>;
                            defaultValue: any[];
                        };
                        labTestTypes: {
                            description: string;
                            type: yup.ArraySchema<yup.StringSchema<string, import("yup/lib/types").AnyObject, string>, import("yup/lib/types").AnyObject, string[], string[]>;
                            defaultValue: any[];
                        };
                        labTestResults: {
                            description: string;
                            type: yup.ArraySchema<yup.StringSchema<string, import("yup/lib/types").AnyObject, string>, import("yup/lib/types").AnyObject, string[], string[]>;
                            defaultValue: string[];
                        };
                    };
                };
            };
        };
        questionCodeIds: {
            deprecated: boolean;
            description: string;
            properties: {
                passport: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: string;
                };
                nationalityId: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: string;
                };
                email: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: any;
                };
            };
        };
        sync: {
            description: string;
            highRisk: boolean;
            properties: {
                syncAllLabRequests: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                urgentIntervalInSeconds: {
                    name: string;
                    unit: string;
                    description: string;
                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                    defaultValue: number;
                };
            };
        };
        vaccinations: {
            name: string;
            description: string;
            properties: {
                defaults: {
                    description: string;
                    properties: {
                        locationGroupId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: any;
                        };
                        locationId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: any;
                        };
                        departmentId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: any;
                        };
                    };
                };
                givenElsewhere: {
                    properties: {
                        defaults: {
                            properties: {
                                locationGroupId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                                    defaultValue: any;
                                };
                                locationId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                                    defaultValue: any;
                                };
                                departmentId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                                    defaultValue: any;
                                };
                            };
                        };
                    };
                };
            };
        };
        survey: {
            name: string;
            description: string;
            properties: {
                defaultCodes: {
                    description: string;
                    properties: {
                        department: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        location: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        templates: {
            description: string;
            properties: {
                letterhead: {
                    description: string;
                    properties: {
                        title: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        subTitle: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
    };
};
export declare const facilityDefaults: any;
