import * as yup from 'yup';
import { SettingsSchema } from '../types';
export declare const getScopedSchema: (scope: string) => {
    name: string;
    description: string;
    properties: {
        certifications: {
            properties: {
                covidClearanceCertificate: {
                    properties: {
                        after: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        daysSinceSampleTime: {
                            description: string;
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                        };
                        labTestCategories: {
                            description: string;
                            type: yup.ArraySchema<yup.StringSchema<string, import("yup/lib/types").AnyObject, string>, import("yup/lib/types").AnyObject, string[], string[]>;
                            defaultValue: any[];
                        };
                        labTestTypes: {
                            description: string;
                            type: yup.ArraySchema<yup.StringSchema<string, import("yup/lib/types").AnyObject, string>, import("yup/lib/types").AnyObject, string[], string[]>;
                            defaultValue: any[];
                        };
                        labTestResults: {
                            description: string;
                            type: yup.ArraySchema<yup.StringSchema<string, import("yup/lib/types").AnyObject, string>, import("yup/lib/types").AnyObject, string[], string[]>;
                            defaultValue: string[];
                        };
                    };
                };
            };
        };
        questionCodeIds: {
            deprecated: boolean;
            description: string;
            properties: {
                passport: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: string;
                };
                nationalityId: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: string;
                };
                email: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: any;
                };
            };
        };
        sync: {
            description: string;
            highRisk: boolean;
            properties: {
                syncAllLabRequests: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                urgentIntervalInSeconds: {
                    name: string;
                    unit: string;
                    description: string;
                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                    defaultValue: number;
                };
            };
        };
        vaccinations: {
            name: string;
            description: string;
            properties: {
                defaults: {
                    description: string;
                    properties: {
                        locationGroupId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: any;
                        };
                        locationId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: any;
                        };
                        departmentId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: any;
                        };
                    };
                };
                givenElsewhere: {
                    properties: {
                        defaults: {
                            properties: {
                                locationGroupId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                                    defaultValue: any;
                                };
                                locationId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                                    defaultValue: any;
                                };
                                departmentId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                                    defaultValue: any;
                                };
                            };
                        };
                    };
                };
            };
        };
        survey: {
            name: string;
            description: string;
            properties: {
                defaultCodes: {
                    description: string;
                    properties: {
                        department: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        location: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        templates: {
            description: string;
            properties: {
                letterhead: {
                    description: string;
                    properties: {
                        title: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        subTitle: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
    };
} | {
    title: string;
    description: string;
    properties: {
        auth: {
            highRisk: boolean;
            description: string;
            properties: {
                restrictUsersToFacilities: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
            };
        };
        ageDisplayFormat: {
            description: string;
            type: import("yup/lib/array").OptionalArraySchema<import("yup/lib/object").OptionalObjectSchema<{
                as: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                range: import("yup/lib/object").RequiredObjectSchema<{
                    min: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                    max: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                    min: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                    max: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                }>>;
            }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                as: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                range: import("yup/lib/object").RequiredObjectSchema<{
                    min: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                    max: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                    min: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                    max: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                }>>;
            }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
                as: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                range: import("yup/lib/object").RequiredObjectSchema<{
                    min: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                    max: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                    min: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                    max: import("yup/lib/object").OptionalObjectSchema<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        duration: import("yup/lib/object").OptionalObjectSchema<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                            years: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            months: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            days: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                        }>>;
                        exclusive: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    }>>;
                }>>;
            }>[]>;
            defaultValue: ({
                as: string;
                range: {
                    min: {
                        duration: {
                            days: number;
                            months?: undefined;
                            years?: undefined;
                        };
                        exclusive: boolean;
                    };
                    max: {
                        duration: {
                            days: number;
                            months?: undefined;
                            years?: undefined;
                        };
                        exclusive: boolean;
                    };
                };
            } | {
                as: string;
                range: {
                    min: {
                        duration: {
                            days: number;
                            months?: undefined;
                            years?: undefined;
                        };
                        exclusive?: undefined;
                    };
                    max: {
                        duration: {
                            months: number;
                            days?: undefined;
                            years?: undefined;
                        };
                        exclusive: boolean;
                    };
                };
            } | {
                as: string;
                range: {
                    min: {
                        duration: {
                            months: number;
                            days?: undefined;
                            years?: undefined;
                        };
                        exclusive?: undefined;
                    };
                    max: {
                        duration: {
                            years: number;
                            days?: undefined;
                            months?: undefined;
                        };
                        exclusive: boolean;
                    };
                };
            } | {
                as: string;
                range: {
                    min: {
                        duration: {
                            years: number;
                            days?: undefined;
                            months?: undefined;
                        };
                        exclusive?: undefined;
                    };
                    max?: undefined;
                };
            })[];
        };
        features: {
            description: string;
            properties: {
                mandateSpecimenType: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                enableAppointmentsExtentions: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                enableVaccineConsent: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                filterDischargeDispositions: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                editPatientDetailsOnMobile: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                quickPatientGenerator: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                enableInvoicing: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                registerNewPatient: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                hideOtherSex: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                enablePatientDeaths: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                enableNoteBackdating: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                enableCovidClearanceCertificate: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                editPatientDisplayId: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                enablePatientInsurer: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                patientPlannedMove: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                onlyAllowLabPanels: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                displayProcedureCodesInDischargeSummary: {
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                displayIcd10CodesInDischargeSummary: {
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                mandatoryVitalEditReason: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                enableVitalEdit: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                reminderContactModule: {
                    properties: {
                        enabled: {
                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                            defaultValue: boolean;
                        };
                    };
                };
                idleTimeout: {
                    description: string;
                    properties: {
                        enabled: {
                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                            defaultValue: boolean;
                        };
                        timeoutDuration: {
                            description: string;
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        warningPromptDuration: {
                            description: string;
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        refreshInterval: {
                            description: string;
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                    };
                };
                tableAutoRefresh: {
                    description: string;
                    properties: {
                        enabled: {
                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                            defaultValue: boolean;
                            unit: string;
                        };
                        interval: {
                            description: string;
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                    };
                };
            };
        };
        customisations: {
            name: string;
            description: string;
            properties: {
                componentVersions: {
                    description: string;
                    type: import("yup/lib/object").OptionalObjectSchema<import("yup/lib/object").ObjectShape, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<import("yup/lib/object").ObjectShape>>;
                    defaultValue: {};
                };
            };
        };
        fhir: {
            name: string;
            description: string;
            properties: {
                worker: {
                    name: string;
                    description: string;
                    properties: {
                        heartbeat: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        assumeDroppedAfter: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        fields: {
            name: string;
            description: string;
            properties: {
                emergencyContactName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                emergencyContactNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                displayId: {
                    name: string;
                    description: string;
                    properties: {
                        pattern: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                firstName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                middleName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                lastName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                culturalName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                sex: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                email: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                bloodType: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                title: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                placeOfBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                countryOfBirthId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                maritalStatus: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                primaryContactNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                secondaryContactNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                socialMedia: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                settlementId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                streetVillage: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                cityTown: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                subdivisionId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                divisionId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                countryId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                medicalAreaId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                nursingZoneId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                nationalityId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                ethnicityId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                occupationId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                educationalLevel: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                villageName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                villageId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthCertificate: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                insurerId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                insurerPolicyNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                drivingLicense: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                passport: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                religionId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                patientBillingTypeId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                motherId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                fatherId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthWeight: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthLength: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthDeliveryType: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                gestationalAgeEstimate: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                apgarScoreOneMinute: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                apgarScoreFiveMinutes: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                apgarScoreTenMinutes: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                timeOfBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                attendantAtBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                nameOfAttendantAtBirth: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthType: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                birthFacilityId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                healthCenterId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                registeredBirthPlace: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                referralSourceId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                arrivalModeId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                prescriber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                prescriberId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                facility: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dischargeDisposition: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                notGivenReasonId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                markedForSync: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfBirthFrom: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfBirthTo: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfBirthExact: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                dateOfDeath: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                age: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                clinician: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                diagnosis: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                locationId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                locationGroupId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                circumstanceId: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                date: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                registeredBy: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                status: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                conditions: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                programRegistry: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                reminderContactName: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
                reminderContactNumber: {
                    name: string;
                    description: string;
                    properties: Record<string, import("../types").Setting<any>>;
                };
            };
        };
        integrations: {
            name: string;
            description: string;
            properties: {
                imaging: {
                    description: string;
                    properties: {
                        enabled: {
                            description: string;
                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                            defaultValue: boolean;
                        };
                        provider: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        invoice: {
            properties: {
                slidingFeeScale: {
                    name: string;
                    description: string;
                    type: import("yup/lib/array").OptionalArraySchema<import("yup/lib/array").OptionalArraySchema<yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>, import("yup/lib/types").AnyObject, number[]>, import("yup/lib/types").AnyObject, number[][]>;
                    defaultValue: number[][];
                };
            };
        };
        imagingCancellationReasons: {
            description: string;
            type: import("yup/lib/array").OptionalArraySchema<import("yup/lib/object").OptionalObjectSchema<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                hidden: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
            }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                hidden: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
            }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                hidden: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
            }>[]>;
            defaultValue: {
                value: string;
                label: string;
                hidden: boolean;
            }[];
        };
        imagingPriorities: {
            name: string;
            description: string;
            type: import("yup/lib/array").OptionalArraySchema<import("yup/lib/object").OptionalObjectSchema<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }>[]>;
            defaultValue: {
                value: string;
                label: string;
            }[];
        };
        labsCancellationReasons: {
            description: string;
            type: import("yup/lib/array").OptionalArraySchema<import("yup/lib/object").OptionalObjectSchema<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }>[]>;
            defaultValue: {
                value: string;
                label: string;
            }[];
        };
        printMeasures: {
            description: string;
            properties: {
                labRequestPrintLabel: {
                    description: string;
                    properties: {
                        width: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                        };
                    };
                };
                stickerLabelPage: {
                    description: string;
                    properties: {
                        pageWidth: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        pageHeight: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        pageMarginTop: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        pageMarginLeft: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        columnWidth: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        columnGap: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        rowHeight: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        rowGap: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                    };
                };
                idCardPage: {
                    description: string;
                    properties: {
                        cardMarginTop: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                        cardMarginLeft: {
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                            unit: string;
                        };
                    };
                };
            };
        };
        layouts: {
            description: string;
            properties: {
                mobilePatientModules: {
                    description: string;
                    properties: {
                        programRegistries: {
                            description: string;
                            properties: {
                                hidden: {
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        diagnosisAndTreatment: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        vitals: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        programs: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        referral: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        vaccine: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        tests: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                    };
                };
                patientTabs: {
                    description: string;
                    properties: {
                        history: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                            };
                        };
                        details: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                            };
                        };
                        results: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        referrals: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        programs: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        documents: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        vaccines: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        medication: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                        invoices: {
                            description: string;
                            properties: {
                                sortPriority: {
                                    description: string;
                                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                    defaultValue: number;
                                };
                                hidden: {
                                    description: string;
                                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                    defaultValue: boolean;
                                };
                            };
                        };
                    };
                };
                sidebar: {
                    description: string;
                    properties: {
                        patients: {
                            description: string;
                            properties: {
                                patientsInpatients: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                patientsEmergency: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                patientsOutpatients: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        scheduling: {
                            description: string;
                            properties: {
                                schedulingAppointments: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                schedulingCalendar: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                schedulingNew: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        medication: {
                            description: string;
                            properties: {
                                medicationAll: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        imaging: {
                            description: string;
                            properties: {
                                imagingActive: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                imagingCompleted: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        labs: {
                            description: string;
                            properties: {
                                labsAll: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                labsPublished: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        immunisations: {
                            description: string;
                            properties: {
                                immunisationsAll: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                        facilityAdmin: {
                            description: string;
                            properties: {
                                reports: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                                bedManagement: {
                                    properties: {
                                        sortPriority: {
                                            description: string;
                                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                                            defaultValue: number;
                                        };
                                        hidden: {
                                            description: string;
                                            type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                                            defaultValue: boolean;
                                        };
                                    };
                                };
                            };
                        };
                    };
                };
            };
        };
        templates: {
            description: string;
            properties: {
                letterhead: {
                    description: string;
                    properties: {
                        title: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        subTitle: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                signerRenewalEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                vaccineCertificateEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                covidVaccineCertificateEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                covidTestCertificateEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                covidClearanceCertificateEmail: {
                    description: string;
                    properties: {
                        subject: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        body: {
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                vaccineCertificate: {
                    description: string;
                    properties: {
                        emailAddress: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        contactNumber: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        healthFacility: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                covidTestCertificate: {
                    description: string;
                    properties: {
                        laboratoryName: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        clearanceCertRemark: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
                plannedMoveTimeoutHours: {
                    description: string;
                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                    defaultValue: number;
                    unit: string;
                };
            };
        };
        triageCategories: {
            name: string;
            description: string;
            type: import("yup/lib/array").OptionalArraySchema<import("yup/lib/object").OptionalObjectSchema<{
                level: import("yup/lib/number").RequiredNumberSchema<number, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                color: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                level: import("yup/lib/number").RequiredNumberSchema<number, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                color: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
                level: import("yup/lib/number").RequiredNumberSchema<number, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                color: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }>[]>;
            defaultValue: {
                level: number;
                label: string;
                color: string;
            }[];
        };
        upcomingVaccinations: {
            name: string;
            description: string;
            properties: {
                ageLimit: {
                    description: string;
                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                    defaultValue: number;
                };
                thresholds: {
                    description: string;
                    type: import("yup/lib/array").OptionalArraySchema<import("yup/lib/object").OptionalObjectSchema<{
                        threshold: import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>;
                        status: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                        threshold: import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>;
                        status: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                    }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
                        threshold: import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>;
                        status: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                    }>[]>;
                    defaultValue: ({
                        threshold: number;
                        status: string;
                    } | {
                        threshold: string;
                        status: string;
                    })[];
                };
            };
        };
        vitalEditReasons: {
            description: string;
            type: import("yup/lib/array").OptionalArraySchema<import("yup/lib/object").OptionalObjectSchema<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }>>, import("yup/lib/types").AnyObject, import("yup/lib/object").TypeOfShape<{
                value: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
                label: import("yup/lib/string").RequiredStringSchema<string, import("yup/lib/types").AnyObject>;
            }>[]>;
            defaultValue: {
                value: string;
                label: string;
            }[];
        };
    };
} | {
    name: string;
    description: string;
    properties: {
        disk: {
            name: string;
            description: string;
            properties: {
                freeSpaceRequired: {
                    name: string;
                    description: string;
                    properties: {
                        gigabytesForUploadingDocuments: {
                            name: string;
                            description: string;
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                        };
                    };
                };
            };
        };
        questionCodeIds: {
            deprecated: boolean;
            description: string;
            properties: {
                passport: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: any;
                };
                nationalityId: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: any;
                };
                email: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: any;
                };
            };
        };
        reportProcess: {
            properties: {
                timeOutDurationSeconds: {
                    description: string;
                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                    defaultValue: number;
                    unit: string;
                };
                runInChildProcess: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                processOptions: {
                    description: string;
                    type: import("yup/lib/array").OptionalArraySchema<yup.StringSchema<string, import("yup/lib/types").AnyObject, string>, import("yup/lib/types").AnyObject, string[]>;
                    defaultValue: any;
                };
                childProcessEnv: {
                    description: string;
                    type: import("yup/lib/object").OptionalObjectSchema<import("yup/lib/object").ObjectShape, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<import("yup/lib/object").ObjectShape>>;
                    defaultValue: any;
                };
                sleepAfterReport: {
                    description: string;
                    properties: {
                        duration: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        ifRunAtLeast: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
    };
};
export declare const validateSettings: ({ settings, scope, schema, }: {
    settings: Record<string, unknown>;
    scope?: string;
    schema?: SettingsSchema;
}) => Promise<void>;
/**
 * Applies default values to all settings in the given scope that are not already set.
 */
export declare const applyDefaults: (settings: Record<string, unknown>, scope: string) => any;
