// NOTE ABOUT IMPORTING CONFIG IN THIS MIGRATION
// Generally you shouldn't import things into migrations, because then you rely on that import
// keeping a stable API
// We import config here in a departure from that rule of thumb, but please don't copy blindly:
// - It's probably not okay to use config if the schema is altered (not the case here, only data)
// - Consider the case when the config you're using were to go missing - would this be ok for the
//   migration? (here, missing serverFacilityIds is just a no-op)
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _configSelectors = require("../utils/configSelectors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const LAST_SUCCESSFUL_SYNC_PULL = 'lastSuccessfulSyncPull';
async function up(query) {
    const isFacilityServer = !!(0, _configSelectors.selectFacilityIds)(_config.default);
    if (!isFacilityServer) {
        return; // probably a central server, this migration is not required
    }
    const [patientRows] = await query.sequelize.query(`
    SELECT COUNT(*) as count FROM patients
  `);
    const [localSystemFactRows] = await query.sequelize.query(`
    SELECT id FROM local_system_facts where key = '${LAST_SUCCESSFUL_SYNC_PULL}'
  `);
    // Insert default lastSuccessfulSyncPull = 0
    // if the server already has synced data and is being upgraded
    // AND lastSuccessfulSyncPull does not exist
    if (patientRows[0]?.count && parseInt(patientRows[0]?.count, 10) && !localSystemFactRows[0]?.id) {
        await query.sequelize.query(`
      INSERT INTO local_system_facts (id, created_at, updated_at, key, value)
      VALUES (uuid_generate_v4(), NOW(), NOW(), '${LAST_SUCCESSFUL_SYNC_PULL}', 0)
    `);
    }
}
async function down(query) {
    const isFacilityServer = !!(0, _configSelectors.selectFacilityIds)(_config.default);
    if (!isFacilityServer) {
        return; // probably a central server, this migration is not required
    }
    await query.sequelize.query(`
    DELETE FROM local_system_facts
    WHERE key = '${LAST_SUCCESSFUL_SYNC_PULL}'
  `);
}

//# sourceMappingURL=1669158892937-addDefaultLastSuccessfulSyncPull.js.map