"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _sequelize = require("sequelize");
const _configSelectors = require("../utils/configSelectors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DEFAULT_SETTINGS = {
    'fhir.worker.heartbeat': '1 minute',
    'fhir.worker.assumeDroppedAfter': '10 minutes'
};
async function up(query) {
    // only write defaults to central
    const isFacilityServer = !!(0, _configSelectors.selectFacilityIds)(_config.default);
    if (isFacilityServer) return;
    for (const [key, value] of Object.entries(DEFAULT_SETTINGS)){
        const [{ count }] = await query.sequelize.query('SELECT count(*) FROM settings WHERE key = $key AND facility_id IS NULL AND deleted_at IS NULL', {
            bind: {
                key
            },
            type: _sequelize.QueryTypes.SELECT
        });
        if (count > 0) continue;
        await query.sequelize.query('INSERT INTO settings (key, value) VALUES ($key, $value)', {
            bind: {
                key,
                value: JSON.stringify(value)
            }
        });
    }
}
async function down() {
// these apply defaults to the settings table,
// so we can't undo them without potentially losing data
}

//# sourceMappingURL=1673867012625-settingsDefaultsJobs.js.map