"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoicePriceChangeType", {
    enumerable: true,
    get: function() {
        return InvoicePriceChangeType;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let InvoicePriceChangeType = class InvoicePriceChangeType extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            itemId: _sequelize.Sequelize.STRING,
            itemType: _sequelize.Sequelize.STRING,
            name: _sequelize.Sequelize.TEXT,
            percentageChange: _sequelize.Sequelize.STRING
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'itemId',
            as: 'patientBillingType',
            constraints: false
        });
    }
    static getFullLinkedItemsInclude(models) {
        return [
            {
                model: models.ReferenceData,
                on: {
                    itemId: _sequelize.Sequelize.where(_sequelize.Sequelize.col('invoicePriceChangeType->patientBillingType.id'), '=', _sequelize.Sequelize.col('invoicePriceChangeType.item_id')),
                    itemType: _sequelize.Sequelize.where(_sequelize.Sequelize.col('invoicePriceChangeType->patientBillingType.type'), '=', 'patientBillingType')
                },
                as: 'patientBillingType'
            }
        ];
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=InvoicePriceChangeType.js.map