"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabTestType", {
    enumerable: true,
    get: function() {
        return LabTestType;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("../errors");
const _Model = require("./Model");
function optionStringToArray(s) {
    if (!s) return undefined;
    const trimmed = s.trim();
    if (!trimmed) return undefined;
    return trimmed.split(', ').map((x)=>x.trim()).filter((x)=>x);
}
let LabTestType = class LabTestType extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            name: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false,
                defaultValue: ''
            },
            unit: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false,
                defaultValue: ''
            },
            maleMin: _sequelize.Sequelize.FLOAT,
            maleMax: _sequelize.Sequelize.FLOAT,
            femaleMin: _sequelize.Sequelize.FLOAT,
            femaleMax: _sequelize.Sequelize.FLOAT,
            rangeText: _sequelize.Sequelize.STRING,
            resultType: {
                type: _sequelize.Sequelize.ENUM(Object.values(_constants.LAB_TEST_RESULT_TYPES)),
                allowNull: false,
                defaultValue: _constants.LAB_TEST_RESULT_TYPES.NUMBER
            },
            options: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: true
            },
            visibilityStatus: {
                type: _sequelize.Sequelize.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            },
            externalCode: _sequelize.Sequelize.TEXT
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            validate: {
                mustHaveValidOptions () {
                    const parsed = optionStringToArray(this.options);
                    if (!parsed) return;
                    if (!Array.isArray(parsed)) {
                        throw new _errors.InvalidOperationError('Options must be a comma-separated array');
                    }
                },
                mustHaveCategory () {
                    if (!this.deletedAt && !this.labTestCategoryId) {
                        throw new _errors.InvalidOperationError('A lab test type must belong to a category');
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'labTestCategoryId',
            as: 'category'
        });
        this.hasMany(models.LabTestPanelLabTestTypes, {
            foreignKey: 'labTestTypeId',
            as: 'panelRelations'
        });
        this.belongsToMany(models.LabTestPanel, {
            through: 'LabTestPanelLabTestTypes'
        });
    }
    forResponse() {
        const { options, ...rest } = super.forResponse();
        return {
            ...rest,
            options: optionStringToArray(options)
        };
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=LabTestType.js.map