"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientCarePlan", {
    enumerable: true,
    get: function() {
        return PatientCarePlan;
    }
});
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _dateTimeTypes = require("./dateTimeTypes");
const _buildPatientSyncFilterViaPatientId = require("./buildPatientSyncFilterViaPatientId");
const _dateTime = require("../utils/dateTime");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let PatientCarePlan = class PatientCarePlan extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _dateTimeTypes.dateTimeType)('date', {
                defaultValue: _dateTime.getCurrentDateTimeString,
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'carePlanId',
            as: 'carePlan'
        });
        this.belongsTo(models.User, {
            foreignKey: 'examinerId',
            as: 'examiner'
        });
        this.hasMany(models.Note, {
            foreignKey: 'recordId',
            as: 'notes',
            constraints: false,
            scope: {
                recordType: this.name
            }
        });
    }
    static getListReferenceAssociations() {
        return [
            'carePlan',
            'examiner'
        ];
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
    static buildPatientSyncFilter = _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId;
};

//# sourceMappingURL=PatientCarePlan.js.map