"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientContact", {
    enumerable: true,
    get: function() {
        return PatientContact;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("./buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let PatientContact = class PatientContact extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: false
            },
            method: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: false
            },
            connectionDetails: _sequelize.Sequelize.JSONB
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'relationshipId',
            as: 'relationship'
        });
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
    static buildPatientSyncFilter = _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId;
    static getListReferenceAssociations() {
        return [
            'relationship'
        ];
    }
};

//# sourceMappingURL=PatientContact.js.map