"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientFieldValue", {
    enumerable: true,
    get: function() {
        return PatientFieldValue;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("./buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let PatientFieldValue = class PatientFieldValue extends _Model.Model {
    static init(options) {
        super.init({
            id: {
                // patient field value records use a generated primary key that enforces one per patient,
                // even across a distributed sync system
                type: `TEXT GENERATED ALWAYS AS (REPLACE("patient_id", ';', ':') || ';' || REPLACE("definition_id", ';', ':')) STORED`,
                set () {
                // any sets of the convenience generated "id" field can be ignored
                }
            },
            patientId: {
                type: _sequelize.DataTypes.STRING,
                primaryKey: true,
                references: {
                    model: 'patients',
                    key: 'id'
                }
            },
            definitionId: {
                type: _sequelize.DataTypes.STRING,
                primaryKey: true,
                references: {
                    model: 'patient_field_definitions',
                    key: 'id'
                }
            },
            // values are saved as strings, types are used for validation and UI
            value: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            indexes: [
                // these are used for querying values, to avoid a sequential scan
                {
                    name: 'patient_field_values_patient_id',
                    fields: [
                        'patient_id'
                    ]
                },
                {
                    name: 'patient_field_values_definition_id',
                    fields: [
                        'definition_id'
                    ]
                },
                {
                    name: 'patient_field_values_updated_at',
                    fields: [
                        'updated_at'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.PatientFieldDefinition, {
            foreignKey: 'definitionId',
            as: 'definition'
        });
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
    static buildPatientSyncFilter = _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId;
};

//# sourceMappingURL=PatientFieldValue.js.map