"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientSecondaryId", {
    enumerable: true,
    get: function() {
        return PatientSecondaryId;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("./buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let PatientSecondaryId = class PatientSecondaryId extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            value: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.Sequelize.TEXT,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'typeId',
            as: 'type'
        });
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
    static buildPatientSyncFilter = _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId;
};

//# sourceMappingURL=PatientSecondaryId.js.map