"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Survey", {
    enumerable: true,
    get: function() {
        return Survey;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let Survey = class Survey extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: _sequelize.Sequelize.STRING,
            name: _sequelize.Sequelize.STRING,
            surveyType: {
                type: _sequelize.Sequelize.STRING,
                defaultValue: _constants.SURVEY_TYPES.PROGRAMS
            },
            isSensitive: {
                type: _sequelize.Sequelize.BOOLEAN,
                defaultValue: false,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.Sequelize.STRING,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT,
                allowNull: false
            },
            notifiable: {
                type: _sequelize.Sequelize.BOOLEAN,
                defaultValue: false,
                allowNull: false
            },
            notifyEmailAddresses: {
                type: _sequelize.Sequelize.ARRAY(_sequelize.Sequelize.STRING),
                allowNull: false,
                defaultValue: []
            }
        }, {
            ...options,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ],
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Program, {
            foreignKey: 'programId',
            as: 'program'
        });
        this.hasMany(models.SurveyScreenComponent, {
            as: 'components',
            foreignKey: 'surveyId'
        });
    }
    static getAllReferrals() {
        return this.findAll({
            where: {
                surveyType: _constants.SURVEY_TYPES.REFERRAL
            }
        });
    }
    static getVitalsSurvey() {
        return this.findOne({
            where: {
                surveyType: _constants.SURVEY_TYPES.VITALS
            }
        });
    }
    static async getResponsePermissionCheck(id) {
        const vitalsSurvey = await this.getVitalsSurvey();
        if (vitalsSurvey && id === vitalsSurvey.id) {
            return 'Vitals';
        }
        return 'SurveyResponse';
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Survey.js.map