"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Vitals", {
    enumerable: true,
    get: function() {
        return Vitals;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let Vitals = class Vitals extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            dateRecorded: (0, _dateTimeTypes.dateTimeType)('dateRecorded', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            }),
            temperature: _sequelize.Sequelize.FLOAT,
            weight: _sequelize.Sequelize.FLOAT,
            height: _sequelize.Sequelize.FLOAT,
            sbp: _sequelize.Sequelize.FLOAT,
            dbp: _sequelize.Sequelize.FLOAT,
            heartRate: _sequelize.Sequelize.FLOAT,
            respiratoryRate: _sequelize.Sequelize.FLOAT,
            spo2: _sequelize.Sequelize.FLOAT,
            avpu: _sequelize.Sequelize.ENUM(_constants.AVPU_OPTIONS.map((x)=>x.value)),
            gcs: _sequelize.Sequelize.FLOAT,
            hemoglobin: _sequelize.Sequelize.FLOAT,
            fastingBloodGlucose: _sequelize.Sequelize.FLOAT,
            urinePh: _sequelize.Sequelize.FLOAT,
            urineLeukocytes: _sequelize.Sequelize.STRING,
            urineNitrites: _sequelize.Sequelize.STRING,
            urobilinogen: _sequelize.Sequelize.FLOAT,
            urineProtein: _sequelize.Sequelize.STRING,
            bloodInUrine: _sequelize.Sequelize.STRING,
            urineSpecificGravity: _sequelize.Sequelize.FLOAT,
            urineKetone: _sequelize.Sequelize.STRING,
            urineBilirubin: _sequelize.Sequelize.STRING,
            urineGlucose: _sequelize.Sequelize.FLOAT
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            validate: {
                mustHaveEncounter () {
                    if (!this.encounterId) {
                        throw new Error('A vitals reading must be attached to an encounter.');
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildPatientLinkedLookupFilter.buildEncounterPatientIdSelect)(this),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=Vitals.js.map