"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getValues", {
    enumerable: true,
    get: function() {
        return getValues;
    }
});
const _fhirTypes = require("../../../services/fhirTypes");
async function getValues(upstream, models) {
    const { User } = models;
    if (upstream instanceof User) return getValuesFromUser(upstream);
    throw new Error(`Invalid upstream type for practitioner ${upstream.constructor.name}`);
}
async function getValuesFromUser(upstream) {
    return {
        lastUpdated: new Date(),
        identifier: identifiers(upstream),
        name: [
            new _fhirTypes.FhirHumanName({
                text: upstream.displayName
            })
        ],
        telecom: [
            new _fhirTypes.FhirContactPoint({
                system: 'email',
                value: upstream.email
            })
        ],
        resolved: true
    };
}
function identifiers(user) {
    const practitionerIdentifiers = [
        new _fhirTypes.FhirIdentifier({
            use: 'secondary',
            value: user.id
        })
    ];
    if (user.displayId) {
        practitionerIdentifiers.push(new _fhirTypes.FhirIdentifier({
            use: 'usual',
            value: user.displayId
        }));
    }
    return practitionerIdentifiers;
}

//# sourceMappingURL=getValues.js.map