"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirServiceRequest", {
    enumerable: true,
    get: function() {
        return FhirServiceRequest;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("../Resource");
const _getQueryOptions = require("./getQueryOptions");
const _getValues = require("./getValues");
const _getQueryToFindUpstreamIds = require("./getQueryToFindUpstreamIds");
const _searchParameters = require("./searchParameters");
let FhirServiceRequest = class FhirServiceRequest extends _Resource.FhirResource {
    static init(options, models) {
        super.init({
            identifier: _sequelize.DataTypes.JSONB,
            status: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            intent: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            category: _sequelize.DataTypes.JSONB,
            priority: _sequelize.DataTypes.TEXT,
            code: _sequelize.DataTypes.JSONB,
            orderDetail: _sequelize.DataTypes.JSONB,
            subject: {
                type: _sequelize.DataTypes.JSONB,
                allowNull: false
            },
            encounter: _sequelize.DataTypes.JSONB,
            occurrenceDateTime: _sequelize.DataTypes.TEXT,
            requester: _sequelize.DataTypes.JSONB,
            locationCode: _sequelize.DataTypes.JSONB,
            note: _sequelize.DataTypes.JSONB,
            specimen: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.ImagingRequest,
            models.LabRequest
        ];
        this.upstreams = [
            models.ImagingRequest,
            models.ImagingRequestArea,
            models.ImagingAreaExternalCode,
            models.Encounter,
            models.Facility,
            models.Location,
            models.LocationGroup,
            models.Patient,
            models.ReferenceData,
            models.User,
            models.LabRequest,
            models.LabTest,
            models.LabTestType,
            models.LabTestPanelRequest,
            models.LabTestPanel,
            models.Note
        ];
    }
    static CAN_DO = new Set([
        _constants.FHIR_INTERACTIONS.INSTANCE.READ,
        _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
        _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
    ]);
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _getQueryOptions.getQueryOptions)(this.sequelize.models));
        const values = await (0, _getValues.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { ImagingRequest, LabRequest } = this.sequelize.models;
        if (upstreamTable === ImagingRequest.tableName) {
            return (0, _getQueryToFindUpstreamIds.fromImagingRequests)(this.sequelize.models, table, id);
        }
        if (upstreamTable === LabRequest.tableName) {
            return (0, _getQueryToFindUpstreamIds.fromLabRequests)(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._searchParameters.searchParameters
        };
    }
};

//# sourceMappingURL=FhirServiceRequest.js.map