"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ENV: function() {
        return ENV;
    },
    HOSTNAME: function() {
        return HOSTNAME;
    },
    PROCESS_ID: function() {
        return PROCESS_ID;
    },
    serviceContext: function() {
        return serviceContext;
    },
    serviceName: function() {
        return serviceName;
    }
});
const _semanticconventions = require("@opentelemetry/semantic-conventions");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _shortid = /*#__PURE__*/ _interop_require_default(require("shortid"));
const _os = /*#__PURE__*/ _interop_require_default(require("os"));
const _configSelectors = require("../../utils/configSelectors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const ENV = process.env.NODE_ENV ?? 'development';
const PROCESS_ID = (0, _shortid.default)();
const HOSTNAME = _os.default.hostname();
const SemanticAttributes = {
    ..._semanticconventions.SemanticAttributes,
    DEPLOYMENT_NAME: 'deployment.name',
    DEPLOYMENT_ENVIRONMENT: 'deployment.environment',
    DEPLOYMENT_FACILITY: 'deployment.facility',
    SERVICE_TYPE: 'service.type',
    SERVICE_VERSION: 'service.version',
    SOURCE_BRANCH: 'source.branch',
    SOURCE_COMMIT_HASH: 'source.commit.hash',
    SOURCE_COMMIT_SUBJECT: 'source.commit.subject',
    SOURCE_DATE: 'source.date',
    SOURCE_DATE_EPOCH: 'source.date.epoch',
    SOURCE_DATE_ISO: 'source.date.iso'
};
function serviceContext() {
    const { serverType = 'unknown', version = '0.0.0' } = global?.serverInfo || {};
    const deploymentHost = _config.default?.canonicalHostName || _config.default?.sync?.host;
    const deployment = deploymentHost && new URL(deploymentHost).hostname.replace(/[^a-z0-9]+/gi, '-');
    const serverFacilityIds = (0, _configSelectors.selectFacilityIds)(_config.default);
    const facilityLoggingKey = serverFacilityIds && (serverFacilityIds.length === 1 ? serverFacilityIds[0] : `multi-facility:${serverFacilityIds.join(';')}`);
    const facilityId = facilityLoggingKey?.replace(/([^a-z0-9]+|^(ref\/)?facility[-/])/gi, '');
    const context = {
        [SemanticAttributes.NET_HOST_NAME]: HOSTNAME,
        [SemanticAttributes.PROCESS_ID]: PROCESS_ID,
        [SemanticAttributes.DEPLOYMENT_NAME]: deployment,
        [SemanticAttributes.DEPLOYMENT_ENVIRONMENT]: process.env.NODE_ENV,
        [SemanticAttributes.DEPLOYMENT_FACILITY]: facilityId,
        [SemanticAttributes.SERVICE_TYPE]: serverType,
        [SemanticAttributes.SERVICE_VERSION]: version
    };
    // These can be set by the container image or runtime in production
    for (const [key, value] of Object.entries(process.env)){
        if (!key.startsWith('OTEL_CONTEXT_')) continue;
        const contextKey = key.replace(/^OTEL_CONTEXT_/, '').toLowerCase().replace(/_/g, '.');
        context[contextKey] = value;
    }
    return context;
}
function serviceName(context) {
    if (!context[SemanticAttributes.DEPLOYMENT_NAME]) return null;
    return [
        context[SemanticAttributes.DEPLOYMENT_NAME],
        context[SemanticAttributes.SERVICE_TYPE],
        context[SemanticAttributes.DEPLOYMENT_FACILITY]
    ].filter(Boolean).join('-');
}

//# sourceMappingURL=context.js.map