"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getCovidClearanceCertificateFilter", {
    enumerable: true,
    get: function() {
        return getCovidClearanceCertificateFilter;
    }
});
const _datefns = require("date-fns");
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _dateTime = require("./dateTime");
const getCovidClearanceCertificateFilter = async (models)=>{
    const { after = '2022-09-01', daysSinceSampleTime = 13, labTestCategories = [], labTestTypes = [], labTestResults = [
        'Positive'
    ] } = await models.Setting.get('certifications.covidClearanceCertificate') || {};
    // mandatory filters
    const labRequestsWhere = {
        status: _constants.LAB_REQUEST_STATUSES.PUBLISHED,
        sampleTime: {
            [_sequelize.Op.lt]: (0, _dateTime.toDateTimeString)((0, _datefns.subDays)((0, _datefns.startOfDay)(new Date()), daysSinceSampleTime)),
            [_sequelize.Op.gt]: after
        },
        '$tests.result$': {
            [_sequelize.Op.in]: labTestResults
        }
    };
    if (labTestCategories.length) {
        labRequestsWhere.labTestCategoryId = {
            [_sequelize.Op.in]: labTestCategories
        };
    }
    if (labTestTypes.length) {
        labRequestsWhere['$tests.lab_test_type_id$'] = {
            [_sequelize.Op.in]: labTestTypes
        };
    }
    return labRequestsWhere;
};

//# sourceMappingURL=getCovidClearanceCertificateFilter.js.map