"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getAddress: function() {
        return getAddress;
    },
    getClinician: function() {
        return getClinician;
    },
    getDOB: function() {
        return getDOB;
    },
    getDOBWithAge: function() {
        return getDOBWithAge;
    },
    getDateOfDeath: function() {
        return getDateOfDeath;
    },
    getEthnicity: function() {
        return getEthnicity;
    },
    getLocationName: function() {
        return getLocationName;
    },
    getName: function() {
        return getName;
    },
    getNationality: function() {
        return getNationality;
    },
    getPassportNumber: function() {
        return getPassportNumber;
    },
    getPatientWeight: function() {
        return getPatientWeight;
    },
    getPlaceOfBirth: function() {
        return getPlaceOfBirth;
    },
    getSex: function() {
        return getSex;
    },
    getTimeOfDeath: function() {
        return getTimeOfDeath;
    },
    getVillageName: function() {
        return getVillageName;
    }
});
const _lodash = require("lodash");
const _getDisplayDate = require("./patientCertificates/getDisplayDate");
const _dateTime = require("./dateTime");
const getName = ({ firstName, lastName })=>`${firstName} ${lastName}`;
const getSex = ({ sex })=>`${(0, _lodash.capitalize)(sex)}`;
const getDOB = ({ dateOfBirth }, getLocalisation)=>dateOfBirth ? (0, _getDisplayDate.getDisplayDate)(dateOfBirth, 'dd/MM/yyyy', getLocalisation) : 'Unknown';
const getDOBWithAge = ({ dateOfBirth })=>{
    if (!dateOfBirth) return 'Unknown';
    const dob = (0, _dateTime.formatShort)(dateOfBirth);
    const age = (0, _dateTime.ageInYears)(dateOfBirth);
    return `${dob} (${age} years)`;
};
const getDateOfDeath = ({ dateOfDeath }, getLocalisation)=>{
    if (!dateOfDeath) return 'Unknown';
    return (0, _getDisplayDate.getDisplayDate)(dateOfDeath, 'd MMM yyyy', getLocalisation);
};
const getTimeOfDeath = ({ dateOfDeath }, getLocalisation)=>{
    if (!dateOfDeath) return 'Unknown';
    return (0, _getDisplayDate.getDisplayDate)(dateOfDeath, 'hh:mma', getLocalisation).toLowerCase();
};
const getPlaceOfBirth = ({ additionalData })=>(additionalData || {}).placeOfBirth;
const getNationality = ({ additionalData })=>((additionalData || {}).nationality || {}).name;
const getPassportNumber = ({ additionalData })=>(additionalData || {}).passport;
const getAddress = ({ additionalData })=>{
    let address = 'N/A';
    const { streetVillage, cityTown, country } = additionalData || {};
    if (streetVillage && cityTown && country) {
        address = `${streetVillage}, ${cityTown}, ${country.name}`;
    }
    return address;
};
const getLocationName = ({ location })=>location.locationGroup ? `${location.locationGroup.name}, ${location.name}` : location.name;
const getVillageName = ({ village })=>village?.name;
const getPatientWeight = ({ patientWeight }, getTranslation)=>patientWeight ? `${patientWeight}${getTranslation('general.localisedField.weightUnit.label', 'kg')}` : '';
const getEthnicity = ({ additionalData })=>additionalData?.ethnicity?.name;
const getClinician = ({ clinician })=>clinician?.displayName;

//# sourceMappingURL=patientAccessors.js.map