"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "BirthNotificationCertificate", {
    enumerable: true,
    get: function() {
        return BirthNotificationCertificate;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _Layout = require("./Layout");
const _dateTime = require("../dateTime");
const _LetterheadSection = require("./LetterheadSection");
const _constants = require("@tamanu/constants");
const _Footer = require("./printComponents/Footer");
const _getDisplayDate = require("./getDisplayDate");
const _patientAccessors = require("../patientAccessors");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const borderStyle = '1 solid black';
const topStyles = _renderer.StyleSheet.create({
    container: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginTop: 15
    },
    cell: {
        flexDirection: 'row',
        marginBottom: 10
    },
    key: {
        fontSize: 9,
        fontFamily: 'Helvetica-Bold',
        marginRight: 2
    },
    value: {
        fontSize: 9
    }
});
const TopSection = ({ facilityName, childDisplayId })=>{
    const date = (0, _dateTime.getCurrentDateString)();
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: topStyles.container
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: topStyles.cell
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: topStyles.key
    }, "Facility:"), /*#__PURE__*/ _react.default.createElement(P, {
        style: topStyles.value
    }, facilityName)), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: topStyles.cell
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: topStyles.key
    }, "Notification date:"), /*#__PURE__*/ _react.default.createElement(P, {
        style: topStyles.value
    }, (0, _getDisplayDate.getDisplayDate)(date))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: topStyles.cell
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: topStyles.key
    }, "Child ID:"), /*#__PURE__*/ _react.default.createElement(P, {
        style: topStyles.value
    }, childDisplayId)));
};
const tableStyles = _renderer.StyleSheet.create({
    table: {
        flexDirection: 'column',
        marginBottom: 15
    },
    row: {
        flexDirection: 'row',
        justifyContent: 'space-evenly',
        borderTop: borderStyle,
        borderBottom: borderStyle,
        borderRight: borderStyle,
        marginBottom: -1
    },
    baseCell: {
        flexDirection: 'row',
        borderLeft: borderStyle,
        alignItems: 'center',
        padding: 5
    },
    flexCell: {
        flex: 1
    },
    leftCell: {
        width: '125pt'
    },
    p: {
        fontSize: 9
    }
});
const Table = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: tableStyles.table,
        ...props
    });
const Row = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: tableStyles.row,
        ...props
    });
const P = ({ style = {}, bold, children })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: bold,
        style: [
            tableStyles.p,
            style
        ]
    }, children);
const FlexCell = ({ children, style = {}, bold = false })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.baseCell,
            tableStyles.flexCell,
            style
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, {
        bold: bold
    }, children));
const Cell = ({ children, style = {}, bold })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, {
        bold: bold
    }, children));
const LeftCell = ({ children })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            tableStyles.baseCell,
            tableStyles.leftCell
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, {
        bold: true
    }, children));
const getLabelFromValue = (mapping, v)=>{
    const entry = mapping.find((e)=>e.value === v);
    return entry ? entry.label : '';
};
const getFullName = (patient)=>`${patient?.firstName ?? ''} ${patient?.lastName ?? ''}`;
const ChildSection = ({ data })=>{
    const causeOfDeath = data?.deathData?.causes?.primary?.condition?.name ?? 'N/A';
    return /*#__PURE__*/ _react.default.createElement(Table, null, /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(FlexCell, {
        bold: true
    }, "Child")), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Name (if known)"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, getFullName(data))), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Gestation (weeks)"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 50
        }
    }, data?.birthData?.gestationalAgeEstimate), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 80
        },
        bold: true
    }, "Delivery type"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 70
        }
    }, getLabelFromValue(_constants.BIRTH_DELIVERY_TYPE_OPTIONS, data?.birthData?.birthDeliveryType)), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 100
        },
        bold: true
    }, "Single/plural births"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, getLabelFromValue(_constants.BIRTH_TYPE_OPTIONS, data?.birthData?.birthType))), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Birth Weight (kg)"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 50
        }
    }, data?.birthData?.birthWeight), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 80
        },
        bold: true
    }, "Birth date"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 70
        }
    }, data?.dateOfBirth ? (0, _getDisplayDate.getDisplayDate)(data?.dateOfBirth) : ''), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 100
        },
        bold: true
    }, "Birth time"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, data?.birthData?.timeOfBirth ? (0, _getDisplayDate.getDisplayDate)(data?.birthData?.timeOfBirth, 'hh:mm a') : '')), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Place of birth"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, getLabelFromValue(_constants.PLACE_OF_BIRTH_OPTIONS, data?.birthData?.registeredBirthPlace))), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Sex"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 130
        }
    }, getLabelFromValue(_constants.SEX_OPTIONS, data?.sex)), /*#__PURE__*/ _react.default.createElement(FlexCell, {
        bold: true
    }, "Ethnicity"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, (0, _patientAccessors.getEthnicity)(data))), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Attendant at birth"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 130
        }
    }, getLabelFromValue(_constants.ATTENDANT_OF_BIRTH_OPTIONS, data?.birthData?.attendantAtBirth)), /*#__PURE__*/ _react.default.createElement(FlexCell, {
        bold: true
    }, "Name of attendant"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, data?.birthData?.nameOfAttendantAtBirth)), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Cause of foetal death"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, causeOfDeath)));
};
const ParentSection = ({ parentType, data = {} })=>{
    return /*#__PURE__*/ _react.default.createElement(Table, null, /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(FlexCell, {
        bold: true
    }, parentType)), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Name"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 150
        }
    }, getFullName(data)), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Nationality"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, data?.additionalData?.nationality?.name)), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Ethnicity"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 150
        }
    }, (0, _patientAccessors.getEthnicity)(data)), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Marital status"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, getLabelFromValue(_constants.MARITAL_STATUS_OPTIONS, data?.additionalData?.maritalStatus))), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Date of birth"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.dateOfBirth ? (0, _getDisplayDate.getDisplayDate)(data?.dateOfBirth) : ''), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Age"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, data?.dateOfBirth ? (0, _dateTime.ageInYears)(data.dateOfBirth) : '')), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Occupation"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.occupation?.name), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Patient ID"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, data?.displayId)), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Address"), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.additionalData?.streetVillage), /*#__PURE__*/ _react.default.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Phone number"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, data?.additionalData?.primaryContactNumber)), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Mother's name"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, getFullName(data?.mother))), /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(LeftCell, null, "Father's name"), /*#__PURE__*/ _react.default.createElement(FlexCell, null, getFullName(data?.father))));
};
const signatureStyles = _renderer.StyleSheet.create({
    container: {
        flexDirection: 'row',
        marginTop: 10
    },
    leftCell: {
        flexDirection: 'row',
        marginBottom: 15,
        paddingRight: 10
    },
    rightCell: {
        flexDirection: 'row',
        marginBottom: 15,
        paddingLeft: 10
    },
    leftText: {
        width: 90,
        marginRight: 10,
        fontFamily: 'Helvetica-Bold'
    },
    rightText: {
        width: 30,
        marginRight: 10,
        fontFamily: 'Helvetica-Bold'
    },
    line: {
        flex: 1,
        borderBottom: '1 solid black'
    }
});
const SignatureSection = ()=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signatureStyles.container
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            flex: 1
        }
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signatureStyles.leftCell
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: signatureStyles.leftText
    }, "Certified correct by:"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signatureStyles.line
    })), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signatureStyles.leftCell
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: signatureStyles.leftText
    }, "Circle applicable:"), /*#__PURE__*/ _react.default.createElement(P, {
        bold: true
    }, "Doctor/midwife/nurse"))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            flex: 1
        }
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signatureStyles.rightCell
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: signatureStyles.rightText
    }, "Signed:"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signatureStyles.line
    })), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signatureStyles.rightCell
    }, /*#__PURE__*/ _react.default.createElement(P, {
        style: signatureStyles.rightText
    }, "Date:"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signatureStyles.line
    }))));
};
const BirthNotificationCertificateComponent = ({ motherData, fatherData, childData, facility, certificateData })=>{
    const { logo, watermark } = certificateData;
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, watermark && /*#__PURE__*/ _react.default.createElement(_Layout.Watermark, {
        src: watermark
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        certificateTitle: "Birth Notification",
        letterheadConfig: certificateData
    })), /*#__PURE__*/ _react.default.createElement(TopSection, {
        facilityName: facility?.name,
        childDisplayId: childData?.displayId
    }), /*#__PURE__*/ _react.default.createElement(ParentSection, {
        parentType: "Mother",
        data: motherData
    }), /*#__PURE__*/ _react.default.createElement(ParentSection, {
        parentType: "Father",
        data: fatherData
    }), /*#__PURE__*/ _react.default.createElement(ChildSection, {
        data: childData
    }), /*#__PURE__*/ _react.default.createElement(SignatureSection, null), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, null)));
};
const BirthNotificationCertificate = (0, _languageContext.withLanguageContext)(BirthNotificationCertificateComponent);

//# sourceMappingURL=BirthNotificationCertificate.js.map