"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "DischargeSummaryPrintout", {
    enumerable: true,
    get: function() {
        return DischargeSummaryPrintout;
    }
});
const _renderer = require("@react-pdf/renderer");
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _Layout = require("./Layout");
const _PatientDetailsWithAddress = require("./printComponents/PatientDetailsWithAddress");
const _constants = require("@tamanu/constants");
const _EncounterDetailsExtended = require("./printComponents/EncounterDetailsExtended");
const _Typography = require("./Typography");
const _LetterheadSection = require("./LetterheadSection");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const borderStyle = '1 solid black';
const tableLabelWidth = 150;
const tablePadding = 10;
const generalStyles = _renderer.StyleSheet.create({
    tableContainer: {
        marginVertical: 5
    },
    sectionContainer: {
        marginVertical: 7
    }
});
const TableContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.tableContainer,
        ...props
    });
const SectionContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.sectionContainer,
        ...props
    });
const infoBoxStyles = _renderer.StyleSheet.create({
    row: {
        flexDirection: 'row',
        border: borderStyle
    },
    labelCol: {
        borderRight: borderStyle,
        width: tableLabelWidth,
        padding: tablePadding
    },
    dataCol: {
        flex: 1,
        padding: tablePadding
    },
    labelText: {
        fontFamily: 'Helvetica-Bold',
        fontSize: 10,
        fontWeight: 500
    },
    infoText: {
        fontFamily: 'Helvetica',
        fontSize: 10,
        fontWeight: 400
    }
});
const InfoBoxRow = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: infoBoxStyles.row,
        ...props
    });
const InfoBoxLabelCol = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: infoBoxStyles.labelCol,
        ...props
    });
const InfoBoxDataCol = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: infoBoxStyles.dataCol,
        ...props
    });
const medicationsTableStyles = _renderer.StyleSheet.create({
    row: {
        flexDirection: 'row'
    },
    col: {
        flexDirection: 'column'
    },
    tableBorder: {
        border: borderStyle
    },
    titleCol: {
        width: tableLabelWidth,
        borderRight: borderStyle,
        padding: tablePadding
    },
    labelCol: {
        borderRight: borderStyle,
        width: 71,
        padding: tablePadding
    },
    dataCol: {
        flex: 1,
        padding: tablePadding
    }
});
const MedicationsTableBorder = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            medicationsTableStyles.tableBorder,
            medicationsTableStyles.row
        ],
        ...props
    });
const MedicationsTableTitleCol = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: medicationsTableStyles.titleCol,
        ...props
    });
const notesSectionStyles = _renderer.StyleSheet.create({
    notesBox: {
        border: borderStyle,
        minHeight: 76,
        padding: 10
    },
    title: {
        fontFamily: 'Helvetica-Bold',
        marginBottom: 3,
        fontSize: 11,
        fontWeight: 500
    }
});
const extractOngoingConditions = (patientConditions)=>patientConditions.map((item)=>item?.diagnosis?.name);
const extractDiagnosesInfo = ({ diagnoses, getSetting })=>{
    const displayIcd10Codes = getSetting('features.displayIcd10CodesInDischargeSummary');
    if (!displayIcd10Codes) {
        return diagnoses.map((item)=>item?.diagnosis?.name);
    } else {
        return diagnoses.map((item)=>`${item?.diagnosis?.name} (${item?.diagnosis?.code})`);
    }
};
const extractProceduresInfo = ({ procedures, getSetting })=>{
    const displayProcedureCodes = getSetting('features.displayProcedureCodesInDischargeSummary');
    if (!displayProcedureCodes) {
        return procedures.map((item)=>item?.procedureType?.name);
    } else {
        return procedures.map((item)=>`${item?.procedureType?.name} (${item?.procedureType?.code})`);
    }
};
const InfoBox = ({ label, info })=>/*#__PURE__*/ _react.default.createElement(InfoBoxRow, null, /*#__PURE__*/ _react.default.createElement(InfoBoxLabelCol, null, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: infoBoxStyles.labelText
    }, label)), /*#__PURE__*/ _react.default.createElement(InfoBoxDataCol, null, info.map((item, index)=>{
        return /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: infoBoxStyles.infoText,
            key: index
        }, item);
    })));
const DiagnosesTable = ({ title, diagnoses, getSetting })=>/*#__PURE__*/ _react.default.createElement(InfoBox, {
        label: title,
        info: extractDiagnosesInfo({
            diagnoses,
            getSetting
        })
    });
const ProceduresTable = ({ procedures, getSetting })=>/*#__PURE__*/ _react.default.createElement(InfoBox, {
        label: "Procedures",
        info: extractProceduresInfo({
            procedures,
            getSetting
        })
    });
const NotesSection = ({ notes })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, "Discharge planning notes"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: notesSectionStyles.notesBox
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: infoBoxStyles.infoText
    }, notes)));
const MedicationsTableInfoBox = ({ label, info, hasBottomBorder = false })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            ...medicationsTableStyles.row,
            borderBottom: hasBottomBorder ?? borderStyle
        }
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: medicationsTableStyles.labelCol
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: infoBoxStyles.infoText
    }, label)), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: medicationsTableStyles.dataCol
    }, info.map((item, index)=>{
        return /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: infoBoxStyles.infoText,
            key: index
        }, item);
    })));
const MedicationsTable = ({ medications })=>{
    const currentMedications = medications.filter((m)=>!m.discontinued);
    const discontinuedMedications = medications.filter((m)=>m.discontinued);
    return /*#__PURE__*/ _react.default.createElement(MedicationsTableBorder, null, /*#__PURE__*/ _react.default.createElement(MedicationsTableTitleCol, null, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: infoBoxStyles.labelText
    }, "Medications")), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            flexDirection: 'column',
            flex: 1
        }
    }, /*#__PURE__*/ _react.default.createElement(MedicationsTableInfoBox, {
        label: "Current",
        info: currentMedications.map((item)=>item?.medication?.name),
        hasBottomBorder: true
    }), /*#__PURE__*/ _react.default.createElement(MedicationsTableInfoBox, {
        label: "Discontinued",
        info: discontinuedMedications.map((item)=>item?.medication?.name),
        hasBottomBorder: false
    })));
};
const DischargeSummaryPrintoutComponent = ({ patientData, encounter, discharge, patientConditions, certificateData, getLocalisation, getTranslation, getSetting })=>{
    const { logo } = certificateData;
    const clinicianText = getTranslation('general.localisedField.clinician.label.short', 'Clinician');
    const { diagnoses, procedures, medications } = encounter;
    const visibleDiagnoses = diagnoses.filter(({ certainty })=>!_constants.DIAGNOSIS_CERTAINTIES_TO_HIDE.includes(certainty));
    const primaryDiagnoses = visibleDiagnoses.filter((d)=>d.isPrimary);
    const secondaryDiagnoses = visibleDiagnoses.filter((d)=>!d.isPrimary);
    const notes = discharge?.note;
    const { facilityName, facilityAddress, facilityTown } = discharge;
    // change header if facility details are present in discharge
    if (facilityName && facilityAddress && certificateData?.title) {
        certificateData = {
            ...certificateData,
            title: facilityName,
            subTitle: facilityTown ? `${facilityAddress}, ${facilityTown}` : facilityAddress
        };
    }
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        certificateTitle: "Patient discharge summary",
        letterheadConfig: certificateData,
        logoSrc: logo
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_PatientDetailsWithAddress.PatientDetailsWithAddress, {
        patient: patientData,
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_EncounterDetailsExtended.EncounterDetailsExtended, {
        encounter: encounter,
        discharge: discharge,
        clinicianText: clinicianText
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, patientConditions.length > 0 && /*#__PURE__*/ _react.default.createElement(TableContainer, null, /*#__PURE__*/ _react.default.createElement(InfoBox, {
        label: "Ongoing conditions",
        info: extractOngoingConditions(patientConditions)
    })), primaryDiagnoses.length > 0 && /*#__PURE__*/ _react.default.createElement(TableContainer, null, /*#__PURE__*/ _react.default.createElement(DiagnosesTable, {
        title: "Primary diagnoses",
        diagnoses: primaryDiagnoses,
        getSetting: getSetting
    })), secondaryDiagnoses.length > 0 && /*#__PURE__*/ _react.default.createElement(TableContainer, null, /*#__PURE__*/ _react.default.createElement(DiagnosesTable, {
        title: "Secondary diagnoses",
        diagnoses: secondaryDiagnoses,
        getSetting: getSetting
    })), procedures.length > 0 && /*#__PURE__*/ _react.default.createElement(TableContainer, null, /*#__PURE__*/ _react.default.createElement(ProceduresTable, {
        procedures: procedures,
        getSetting: getSetting
    })), medications.length > 0 && /*#__PURE__*/ _react.default.createElement(TableContainer, null, /*#__PURE__*/ _react.default.createElement(MedicationsTable, {
        medications: medications
    }))), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(NotesSection, {
        notes: notes
    }))));
};
const DischargeSummaryPrintout = (0, _languageContext.withLanguageContext)(DischargeSummaryPrintoutComponent);

//# sourceMappingURL=DischargeSummaryPrintout.js.map