"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "IDLabelPrintout", {
    enumerable: true,
    get: function() {
        return IDLabelPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _patientAccessors = require("../patientAccessors");
const _PrintableBarcode = require("./printComponents/PrintableBarcode");
const _Typography = require("./Typography");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const fontSize = 11;
const mmToPt = (mm)=>mm * 2.835;
const styles = _renderer.StyleSheet.create({
    idLabel: {
        display: 'flex',
        flexDirection: 'column',
        padding: '2mm',
        justifyContent: 'center'
    },
    row: {
        flexDirection: 'row'
    },
    col: {
        flexDirection: 'column',
        flexGrow: 1
    },
    text: {
        color: '#444444',
        fontFamily: 'Courier',
        lineHeight: 1.2
    },
    barcodeContainer: {
        flexDirection: 'column'
    },
    barcodeText: {
        fontFamily: 'Courier-Bold',
        color: '#444444',
        lineHeight: 1.2
    },
    barcode: {
        margin: 0,
        marginBottom: 2,
        textAlign: 'left',
        displayValue: false
    }
});
const Row = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.row,
        ...props
    });
const Col = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.col,
        ...props
    });
const BarcodeContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.barcodeContainer,
        ...props
    });
const IDLabel = ({ patient })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.idLabel
    }, /*#__PURE__*/ _react.default.createElement(Row, null, /*#__PURE__*/ _react.default.createElement(BarcodeContainer, null, /*#__PURE__*/ _react.default.createElement(_PrintableBarcode.PrintableBarcode, {
        barHeight: "24px",
        id: patient.displayId,
        fontSize: fontSize,
        barcodeStyle: styles.barcode,
        width: "92px"
    }), /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        mb: 0,
        fontSize: fontSize,
        style: styles.barcodeText
    }, patient.displayId)), /*#__PURE__*/ _react.default.createElement(Col, {
        style: {
            marginLeft: mmToPt(3)
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        mb: 2,
        fontSize: fontSize,
        style: styles.text
    }, (0, _patientAccessors.getSex)(patient)), /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        mb: 0,
        fontSize: fontSize,
        style: styles.text
    }, (0, _patientAccessors.getDOB)(patient)))), /*#__PURE__*/ _react.default.createElement(Col, {
        style: {
            marginTop: -1
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        mb: 0,
        mt: 0,
        fontSize: fontSize,
        style: styles.text
    }, (0, _patientAccessors.getName)(patient))));
};
const IDLabelPrintoutComponent = ({ patient, measures })=>{
    const pageStyles = _renderer.StyleSheet.create({
        grid: {
            display: 'flex',
            flexWrap: 'wrap',
            flexDirection: 'row',
            width: '100%',
            columnGap: mmToPt(measures.columnGap),
            rowGap: mmToPt(measures.rowGap),
            position: 'absolute',
            left: mmToPt(measures.pageMarginLeft),
            top: mmToPt(measures.pageMarginTop) + mmToPt(3)
        },
        gridItem: {
            width: mmToPt(measures.columnWidth),
            height: mmToPt(measures.rowHeight)
        }
    });
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: {
            width: mmToPt(measures.pageWidth),
            height: mmToPt(measures.pageHeight)
        }
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: pageStyles.grid,
        wrap: false
    }, [
        ...Array(30)
    ].map((_, i)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: pageStyles.gridItem,
            key: `label-${i}`
        }, /*#__PURE__*/ _react.default.createElement(IDLabel, {
            patient: patient,
            key: i
        }))))));
};
const IDLabelPrintout = (0, _languageContext.withLanguageContext)(IDLabelPrintoutComponent);

//# sourceMappingURL=IDLabelPrintout.js.map