"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Footer", {
    enumerable: true,
    get: function() {
        return Footer;
    }
});
const _renderer = require("@react-pdf/renderer");
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _dateTime = require("../../dateTime");
const _Text = require("../../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const styles = _renderer.StyleSheet.create({
    footer: {
        position: 'absolute',
        flexDirection: 'row',
        justifyContent: 'space-between',
        bottom: 25,
        left: 50,
        right: 50,
        color: '#888888',
        borderTop: '1px solid #888888',
        paddingTop: 2
    },
    footerLeftContent: {
        flexDirection: 'row',
        flexWrap: 'wrap'
    },
    footerRightContent: {
        flexDirection: 'row',
        textAlign: 'right'
    },
    labelText: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica-Bold'
    },
    valueText: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica'
    }
});
const LabelText = ({ children, ...props })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: styles.labelText,
        ...props
    }, children);
const ValueText = ({ children, ...props })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: styles.valueText,
        ...props
    }, children);
const Footer = ({ printDate, printFacility, printedBy, style })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            styles.footer,
            style
        ],
        fixed: true
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.footerLeftContent
    }, /*#__PURE__*/ _react.default.createElement(LabelText, null, "Print date: "), /*#__PURE__*/ _react.default.createElement(ValueText, null, (0, _dateTime.formatShort)(printDate || (0, _dateTime.getCurrentDateString)()), " "), printFacility && /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(ValueText, null, " |"), /*#__PURE__*/ _react.default.createElement(LabelText, null, "Print facility: "), /*#__PURE__*/ _react.default.createElement(ValueText, null, printFacility, " ")), printedBy && /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(ValueText, null, " |"), /*#__PURE__*/ _react.default.createElement(LabelText, null, "Printed by: "), /*#__PURE__*/ _react.default.createElement(ValueText, null, printedBy))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.footerRightContent
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: styles.valueText,
        render: ({ pageNumber, totalPages })=>`${pageNumber} of ${totalPages}`
    })));
};

//# sourceMappingURL=Footer.js.map