"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    MultiPageHeader: function() {
        return MultiPageHeader;
    },
    useTextStyles: function() {
        return useTextStyles;
    }
});
const _renderer = require("@react-pdf/renderer");
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _flattenStyles = require("../../pdf/flattenStyles");
const _languageContext = require("../../pdf/languageContext");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const styles = _renderer.StyleSheet.create({
    header: {
        flexDirection: 'row',
        display: 'flex',
        alignSelf: 'flex-end',
        marginBottom: 20
    },
    labelText: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica-Bold',
        color: '#888888'
    },
    valueText: {
        fontSize: 8,
        fontWeight: 400,
        fontFamily: 'Helvetica',
        color: '#888888'
    }
});
const useTextStyles = (styles)=>{
    const { makeIntlStyleSheet } = (0, _languageContext.useLanguageContext)();
    const mergedStyle = (0, _flattenStyles.flatten)(styles);
    return makeIntlStyleSheet(mergedStyle);
};
const MultiPageHeader = ({ documentName, documentSubname, patientName, patientId })=>{
    const valueStyles = useTextStyles(styles.valueText);
    const labelStyles = useTextStyles(styles.labelText);
    const ValueText = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.Text, {
            style: valueStyles,
            ...props
        });
    const LabelText = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.Text, {
            style: labelStyles,
            ...props
        });
    const HeaderContent = ()=>/*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(LabelText, null, `${documentName} `), documentSubname && /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(ValueText, null, "|"), /*#__PURE__*/ _react.default.createElement(LabelText, null, " ", documentSubname, " ")), /*#__PURE__*/ _react.default.createElement(ValueText, null, "|"), /*#__PURE__*/ _react.default.createElement(LabelText, null, " Patient name"), /*#__PURE__*/ _react.default.createElement(ValueText, null, ": ", patientName, " "), /*#__PURE__*/ _react.default.createElement(ValueText, null, "|"), /*#__PURE__*/ _react.default.createElement(LabelText, null, " Patient ID"), /*#__PURE__*/ _react.default.createElement(ValueText, null, ": ", patientId));
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.header,
        render: ({ pageNumber })=>pageNumber > 1 && /*#__PURE__*/ _react.default.createElement(HeaderContent, null),
        fixed: true
    });
};

//# sourceMappingURL=MultiPageHeader.js.map