"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    convertBinaryToYesNo: function() {
        return convertBinaryToYesNo;
    },
    getResultName: function() {
        return getResultName;
    },
    getSurveyAnswerRows: function() {
        return getSurveyAnswerRows;
    },
    separateColorText: function() {
        return separateColorText;
    }
});
const _constants = require("@tamanu/constants");
const shouldShow = (component)=>{
    switch(component.dataElement.type){
        case _constants.PROGRAM_DATA_ELEMENT_TYPES.INSTRUCTION:
            return false;
        case _constants.PROGRAM_DATA_ELEMENT_TYPES.SURVEY_LINK:
            return false;
        default:
            return true;
    }
};
const convertBinaryToYesNo = (value)=>{
    switch(value){
        case 'true':
        case '1':
            return 'Yes';
        case 'false':
        case '0':
            return 'No';
        default:
            return value;
    }
};
const getSurveyAnswerRows = ({ components, answers })=>components.filter(shouldShow).map((component)=>{
        const { dataElement, id, screenIndex } = component;
        const { type, name } = dataElement;
        const answerObject = answers.find((a)=>a.dataElementId === dataElement.id);
        const answer = answerObject?.body;
        return {
            id,
            type,
            answer,
            name,
            screenIndex
        };
    }).filter((r)=>r.answer !== undefined);
const separateColorText = (resultText)=>{
    for (const [key, color] of Object.entries(_constants.RESULT_COLORS)){
        // only match colors at the end that follow a result
        // "90% GREEN" -> "90%"
        // "blue ribbon" -> "blue ribbon"
        // "reduced risk" -> "reduced risk"
        const re = RegExp(` ${key}$`, 'i');
        if (resultText.match(re)) {
            const strippedResultText = resultText.replace(re, '').trim();
            return {
                color,
                strippedResultText
            };
        }
    }
    return {
        strippedResultText: resultText
    };
};
const getResultName = (components)=>{
    const resultComponent = components.find((component)=>component.dataElement.type === 'Result');
    return resultComponent?.dataElement.defaultText;
};

//# sourceMappingURL=surveyAnswers.js.map