import React from 'react';
import { Document, StyleSheet, View } from '@react-pdf/renderer';
import { CertificateHeader, styles, Watermark } from './Layout';
import { ageInYears, getCurrentDateString } from '../dateTime';
import { LetterheadSection } from './LetterheadSection';
import { ATTENDANT_OF_BIRTH_OPTIONS, BIRTH_DELIVERY_TYPE_OPTIONS, BIRTH_TYPE_OPTIONS, MARITAL_STATUS_OPTIONS, PLACE_OF_BIRTH_OPTIONS, SEX_OPTIONS } from '@tamanu/constants';
import { Footer } from './printComponents/Footer';
import { getDisplayDate } from './getDisplayDate';
import { getEthnicity } from '../patientAccessors';
import { withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
import { Text } from '../pdf/Text';
const borderStyle = '1 solid black';
const topStyles = StyleSheet.create({
    container: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginTop: 15
    },
    cell: {
        flexDirection: 'row',
        marginBottom: 10
    },
    key: {
        fontSize: 9,
        fontFamily: 'Helvetica-Bold',
        marginRight: 2
    },
    value: {
        fontSize: 9
    }
});
const TopSection = ({ facilityName, childDisplayId })=>{
    const date = getCurrentDateString();
    return /*#__PURE__*/ React.createElement(View, {
        style: topStyles.container
    }, /*#__PURE__*/ React.createElement(View, {
        style: topStyles.cell
    }, /*#__PURE__*/ React.createElement(P, {
        style: topStyles.key
    }, "Facility:"), /*#__PURE__*/ React.createElement(P, {
        style: topStyles.value
    }, facilityName)), /*#__PURE__*/ React.createElement(View, {
        style: topStyles.cell
    }, /*#__PURE__*/ React.createElement(P, {
        style: topStyles.key
    }, "Notification date:"), /*#__PURE__*/ React.createElement(P, {
        style: topStyles.value
    }, getDisplayDate(date))), /*#__PURE__*/ React.createElement(View, {
        style: topStyles.cell
    }, /*#__PURE__*/ React.createElement(P, {
        style: topStyles.key
    }, "Child ID:"), /*#__PURE__*/ React.createElement(P, {
        style: topStyles.value
    }, childDisplayId)));
};
const tableStyles = StyleSheet.create({
    table: {
        flexDirection: 'column',
        marginBottom: 15
    },
    row: {
        flexDirection: 'row',
        justifyContent: 'space-evenly',
        borderTop: borderStyle,
        borderBottom: borderStyle,
        borderRight: borderStyle,
        marginBottom: -1
    },
    baseCell: {
        flexDirection: 'row',
        borderLeft: borderStyle,
        alignItems: 'center',
        padding: 5
    },
    flexCell: {
        flex: 1
    },
    leftCell: {
        width: '125pt'
    },
    p: {
        fontSize: 9
    }
});
const Table = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: tableStyles.table,
        ...props
    });
const Row = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: tableStyles.row,
        ...props
    });
const P = ({ style = {}, bold, children })=>/*#__PURE__*/ React.createElement(Text, {
        bold: bold,
        style: [
            tableStyles.p,
            style
        ]
    }, children);
const FlexCell = ({ children, style = {}, bold = false })=>/*#__PURE__*/ React.createElement(View, {
        style: [
            tableStyles.baseCell,
            tableStyles.flexCell,
            style
        ]
    }, /*#__PURE__*/ React.createElement(P, {
        bold: bold
    }, children));
const Cell = ({ children, style = {}, bold })=>/*#__PURE__*/ React.createElement(View, {
        style: [
            tableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ React.createElement(P, {
        bold: bold
    }, children));
const LeftCell = ({ children })=>/*#__PURE__*/ React.createElement(View, {
        style: [
            tableStyles.baseCell,
            tableStyles.leftCell
        ]
    }, /*#__PURE__*/ React.createElement(P, {
        bold: true
    }, children));
const getLabelFromValue = (mapping, v)=>{
    const entry = mapping.find((e)=>e.value === v);
    return entry ? entry.label : '';
};
const getFullName = (patient)=>`${patient?.firstName ?? ''} ${patient?.lastName ?? ''}`;
const ChildSection = ({ data })=>{
    const causeOfDeath = data?.deathData?.causes?.primary?.condition?.name ?? 'N/A';
    return /*#__PURE__*/ React.createElement(Table, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(FlexCell, {
        bold: true
    }, "Child")), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Name (if known)"), /*#__PURE__*/ React.createElement(FlexCell, null, getFullName(data))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Gestation (weeks)"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 50
        }
    }, data?.birthData?.gestationalAgeEstimate), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 80
        },
        bold: true
    }, "Delivery type"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 70
        }
    }, getLabelFromValue(BIRTH_DELIVERY_TYPE_OPTIONS, data?.birthData?.birthDeliveryType)), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 100
        },
        bold: true
    }, "Single/plural births"), /*#__PURE__*/ React.createElement(FlexCell, null, getLabelFromValue(BIRTH_TYPE_OPTIONS, data?.birthData?.birthType))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Birth Weight (kg)"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 50
        }
    }, data?.birthData?.birthWeight), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 80
        },
        bold: true
    }, "Birth date"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 70
        }
    }, data?.dateOfBirth ? getDisplayDate(data?.dateOfBirth) : ''), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 100
        },
        bold: true
    }, "Birth time"), /*#__PURE__*/ React.createElement(FlexCell, null, data?.birthData?.timeOfBirth ? getDisplayDate(data?.birthData?.timeOfBirth, 'hh:mm a') : '')), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Place of birth"), /*#__PURE__*/ React.createElement(FlexCell, null, getLabelFromValue(PLACE_OF_BIRTH_OPTIONS, data?.birthData?.registeredBirthPlace))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Sex"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 130
        }
    }, getLabelFromValue(SEX_OPTIONS, data?.sex)), /*#__PURE__*/ React.createElement(FlexCell, {
        bold: true
    }, "Ethnicity"), /*#__PURE__*/ React.createElement(FlexCell, null, getEthnicity(data))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Attendant at birth"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 130
        }
    }, getLabelFromValue(ATTENDANT_OF_BIRTH_OPTIONS, data?.birthData?.attendantAtBirth)), /*#__PURE__*/ React.createElement(FlexCell, {
        bold: true
    }, "Name of attendant"), /*#__PURE__*/ React.createElement(FlexCell, null, data?.birthData?.nameOfAttendantAtBirth)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Cause of foetal death"), /*#__PURE__*/ React.createElement(FlexCell, null, causeOfDeath)));
};
const ParentSection = ({ parentType, data = {} })=>{
    return /*#__PURE__*/ React.createElement(Table, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(FlexCell, {
        bold: true
    }, parentType)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Name"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, getFullName(data)), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Nationality"), /*#__PURE__*/ React.createElement(FlexCell, null, data?.additionalData?.nationality?.name)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Ethnicity"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, getEthnicity(data)), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Marital status"), /*#__PURE__*/ React.createElement(FlexCell, null, getLabelFromValue(MARITAL_STATUS_OPTIONS, data?.additionalData?.maritalStatus))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Date of birth"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.dateOfBirth ? getDisplayDate(data?.dateOfBirth) : ''), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Age"), /*#__PURE__*/ React.createElement(FlexCell, null, data?.dateOfBirth ? ageInYears(data.dateOfBirth) : '')), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Occupation"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.occupation?.name), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Patient ID"), /*#__PURE__*/ React.createElement(FlexCell, null, data?.displayId)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Address"), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 150
        }
    }, data?.additionalData?.streetVillage), /*#__PURE__*/ React.createElement(Cell, {
        style: {
            width: 90
        },
        bold: true
    }, "Phone number"), /*#__PURE__*/ React.createElement(FlexCell, null, data?.additionalData?.primaryContactNumber)), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Mother's name"), /*#__PURE__*/ React.createElement(FlexCell, null, getFullName(data?.mother))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(LeftCell, null, "Father's name"), /*#__PURE__*/ React.createElement(FlexCell, null, getFullName(data?.father))));
};
const signatureStyles = StyleSheet.create({
    container: {
        flexDirection: 'row',
        marginTop: 10
    },
    leftCell: {
        flexDirection: 'row',
        marginBottom: 15,
        paddingRight: 10
    },
    rightCell: {
        flexDirection: 'row',
        marginBottom: 15,
        paddingLeft: 10
    },
    leftText: {
        width: 90,
        marginRight: 10,
        fontFamily: 'Helvetica-Bold'
    },
    rightText: {
        width: 30,
        marginRight: 10,
        fontFamily: 'Helvetica-Bold'
    },
    line: {
        flex: 1,
        borderBottom: '1 solid black'
    }
});
const SignatureSection = ()=>{
    return /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.container
    }, /*#__PURE__*/ React.createElement(View, {
        style: {
            flex: 1
        }
    }, /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.leftCell
    }, /*#__PURE__*/ React.createElement(P, {
        style: signatureStyles.leftText
    }, "Certified correct by:"), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.line
    })), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.leftCell
    }, /*#__PURE__*/ React.createElement(P, {
        style: signatureStyles.leftText
    }, "Circle applicable:"), /*#__PURE__*/ React.createElement(P, {
        bold: true
    }, "Doctor/midwife/nurse"))), /*#__PURE__*/ React.createElement(View, {
        style: {
            flex: 1
        }
    }, /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.rightCell
    }, /*#__PURE__*/ React.createElement(P, {
        style: signatureStyles.rightText
    }, "Signed:"), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.line
    })), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.rightCell
    }, /*#__PURE__*/ React.createElement(P, {
        style: signatureStyles.rightText
    }, "Date:"), /*#__PURE__*/ React.createElement(View, {
        style: signatureStyles.line
    }))));
};
const BirthNotificationCertificateComponent = ({ motherData, fatherData, childData, facility, certificateData })=>{
    const { logo, watermark } = certificateData;
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: styles.page
    }, watermark && /*#__PURE__*/ React.createElement(Watermark, {
        src: watermark
    }), /*#__PURE__*/ React.createElement(CertificateHeader, null, /*#__PURE__*/ React.createElement(LetterheadSection, {
        logoSrc: logo,
        certificateTitle: "Birth Notification",
        letterheadConfig: certificateData
    })), /*#__PURE__*/ React.createElement(TopSection, {
        facilityName: facility?.name,
        childDisplayId: childData?.displayId
    }), /*#__PURE__*/ React.createElement(ParentSection, {
        parentType: "Mother",
        data: motherData
    }), /*#__PURE__*/ React.createElement(ParentSection, {
        parentType: "Father",
        data: fatherData
    }), /*#__PURE__*/ React.createElement(ChildSection, {
        data: childData
    }), /*#__PURE__*/ React.createElement(SignatureSection, null), /*#__PURE__*/ React.createElement(Footer, null)));
};
export const BirthNotificationCertificate = withLanguageContext(BirthNotificationCertificateComponent);

//# sourceMappingURL=BirthNotificationCertificate.js.map