import React from 'react';
import { StyleSheet, View, Document } from '@react-pdf/renderer';
import { getDOB, getName, getSex } from '../patientAccessors';
import { PrintableBarcode } from './printComponents/PrintableBarcode';
import { P } from './Typography';
import { withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
const fontSize = 11;
const mmToPt = (mm)=>mm * 2.835;
const styles = StyleSheet.create({
    idLabel: {
        display: 'flex',
        flexDirection: 'column',
        padding: '2mm',
        justifyContent: 'center'
    },
    row: {
        flexDirection: 'row'
    },
    col: {
        flexDirection: 'column',
        flexGrow: 1
    },
    text: {
        color: '#444444',
        fontFamily: 'Courier',
        lineHeight: 1.2
    },
    barcodeContainer: {
        flexDirection: 'column'
    },
    barcodeText: {
        fontFamily: 'Courier-Bold',
        color: '#444444',
        lineHeight: 1.2
    },
    barcode: {
        margin: 0,
        marginBottom: 2,
        textAlign: 'left',
        displayValue: false
    }
});
const Row = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.row,
        ...props
    });
const Col = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.col,
        ...props
    });
const BarcodeContainer = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.barcodeContainer,
        ...props
    });
const IDLabel = ({ patient })=>{
    return /*#__PURE__*/ React.createElement(View, {
        style: styles.idLabel
    }, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(BarcodeContainer, null, /*#__PURE__*/ React.createElement(PrintableBarcode, {
        barHeight: "24px",
        id: patient.displayId,
        fontSize: fontSize,
        barcodeStyle: styles.barcode,
        width: "92px"
    }), /*#__PURE__*/ React.createElement(P, {
        mb: 0,
        fontSize: fontSize,
        style: styles.barcodeText
    }, patient.displayId)), /*#__PURE__*/ React.createElement(Col, {
        style: {
            marginLeft: mmToPt(3)
        }
    }, /*#__PURE__*/ React.createElement(P, {
        mb: 2,
        fontSize: fontSize,
        style: styles.text
    }, getSex(patient)), /*#__PURE__*/ React.createElement(P, {
        mb: 0,
        fontSize: fontSize,
        style: styles.text
    }, getDOB(patient)))), /*#__PURE__*/ React.createElement(Col, {
        style: {
            marginTop: -1
        }
    }, /*#__PURE__*/ React.createElement(P, {
        mb: 0,
        mt: 0,
        fontSize: fontSize,
        style: styles.text
    }, getName(patient))));
};
const IDLabelPrintoutComponent = ({ patient, measures })=>{
    const pageStyles = StyleSheet.create({
        grid: {
            display: 'flex',
            flexWrap: 'wrap',
            flexDirection: 'row',
            width: '100%',
            columnGap: mmToPt(measures.columnGap),
            rowGap: mmToPt(measures.rowGap),
            position: 'absolute',
            left: mmToPt(measures.pageMarginLeft),
            top: mmToPt(measures.pageMarginTop) + mmToPt(3)
        },
        gridItem: {
            width: mmToPt(measures.columnWidth),
            height: mmToPt(measures.rowHeight)
        }
    });
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: {
            width: mmToPt(measures.pageWidth),
            height: mmToPt(measures.pageHeight)
        }
    }, /*#__PURE__*/ React.createElement(View, {
        style: pageStyles.grid,
        wrap: false
    }, [
        ...Array(30)
    ].map((_, i)=>/*#__PURE__*/ React.createElement(View, {
            style: pageStyles.gridItem,
            key: `label-${i}`
        }, /*#__PURE__*/ React.createElement(IDLabel, {
            patient: patient,
            key: i
        }))))));
};
export const IDLabelPrintout = withLanguageContext(IDLabelPrintoutComponent);

//# sourceMappingURL=IDLabelPrintout.js.map