import { Document, StyleSheet, View } from '@react-pdf/renderer';
import React from 'react';
import { DRUG_ROUTE_LABELS } from '@tamanu/constants';
import { CertificateContent, CertificateHeader, Col, Signature, styles } from './Layout';
import { PatientDetailsWithBarcode } from './printComponents/PatientDetailsWithBarcode';
import { Table } from './Table';
import { DataSection } from './printComponents/DataSection';
import { DataItem } from './printComponents/DataItem';
import { getDisplayDate } from './getDisplayDate';
import { getCurrentDateString } from '../dateTime';
import { LetterheadSection } from './LetterheadSection';
import { P } from './Typography';
import { withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
const columns = [
    {
        key: 'medication',
        title: 'Medication',
        accessor: ({ medication })=>(medication || {}).name,
        customStyles: {
            minWidth: 100
        }
    },
    {
        key: 'prescription',
        title: 'Instructions',
        customStyles: {
            minWidth: 100
        }
    },
    {
        key: 'route',
        title: 'Route',
        accessor: ({ route })=>DRUG_ROUTE_LABELS[route] || ''
    },
    {
        key: 'quantity',
        title: 'Quantity'
    },
    {
        key: 'repeats',
        title: 'Repeats'
    }
];
const prescriptonSectionStyles = StyleSheet.create({
    tableContainer: {
        marginTop: 12
    }
});
const notesSectionStyles = StyleSheet.create({
    notesContainer: {
        border: '1px solid black',
        height: 69
    }
});
const signingSectionStyles = StyleSheet.create({
    container: {
        marginTop: 22
    }
});
const generalStyles = StyleSheet.create({
    container: {
        marginVertical: 8
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: generalStyles.container,
        ...props
    });
const PrescriptionsSection = ({ prescriptions, prescriber, facility, getLocalisation, getSetting })=>{
    return /*#__PURE__*/ React.createElement(View, null, /*#__PURE__*/ React.createElement(DataSection, {
        hideBottomRule: true,
        title: "Prescription details"
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: "Date",
        value: getDisplayDate(getCurrentDateString())
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: "Prescriber",
        value: prescriber?.displayName
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: "Prescriber ID",
        value: prescriber?.displayId ?? 'n/a'
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: "Facility",
        value: facility?.name
    }))), /*#__PURE__*/ React.createElement(View, {
        style: prescriptonSectionStyles.tableContainer
    }, /*#__PURE__*/ React.createElement(Table, {
        columns: columns,
        data: prescriptions,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })));
};
const PrescriptionSigningSection = ()=>/*#__PURE__*/ React.createElement(View, {
        style: signingSectionStyles.container
    }, /*#__PURE__*/ React.createElement(Signature, {
        fontSize: 9,
        lineThickness: 0.5,
        text: "Signed"
    }), /*#__PURE__*/ React.createElement(Signature, {
        fontSize: 9,
        lineThickness: 0.5,
        text: "Date"
    }));
const NotesSection = ()=>/*#__PURE__*/ React.createElement(View, null, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, "Notes"), /*#__PURE__*/ React.createElement(View, {
        style: notesSectionStyles.notesContainer
    }));
const PrescriptionPrintoutComponent = ({ patientData, prescriptions, prescriber, certificateData, facility, getLocalisation, getSetting })=>{
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: styles.page
    }, /*#__PURE__*/ React.createElement(CertificateHeader, null, /*#__PURE__*/ React.createElement(LetterheadSection, {
        letterheadConfig: certificateData,
        logoSrc: certificateData.logo,
        certificateTitle: "Prescription"
    }), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PatientDetailsWithBarcode, {
        patient: patientData,
        getLocalisation: getLocalisation
    }))), /*#__PURE__*/ React.createElement(CertificateContent, null, /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PrescriptionsSection, {
        prescriptions: prescriptions,
        prescriber: prescriber,
        facility: facility,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(NotesSection, null)), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PrescriptionSigningSection, null)))));
};
export const PrescriptionPrintout = withLanguageContext(PrescriptionPrintoutComponent);

//# sourceMappingURL=PrescriptionPrintout.js.map