(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsGrc = factory();
  }
})(this, function () {
  var patterns =
    '{"α":[{"ι":[{},[0,2]],"ί":[{},[0,2]],"ί":[{},[0,2]],"ὶ":[{},[0,2]],"ῖ":[{},[0,2]],"ἰ":[{},[0,2]],"ἴ":[{},[0,2]],"ἲ":[{},[0,2]],"ἶ":[{},[0,2]],"ἱ":[{},[0,2]],"ἵ":[{},[0,2]],"ἳ":[{},[0,2]],"ἷ":[{"σ":[{"τ":[{"ι":[{"σ":[{"ι":[{},[0,0,2,1]]}]}]}]}],"ϲ":[{"τ":[{"ι":[{"ϲ":[{"ι":[{},[0,0,2,1]]}]}]}]}]},[0,2]],"υ":[{},[0,2]],"ύ":[{},[0,2]],"ύ":[{},[0,2]],"ὺ":[{},[0,2]],"ῦ":[{},[0,2]],"ὐ":[{"τ":[{"έ":[{"κ":[{"μ":[{},[0,0,0,0,2,1]]}]}],"έ":[{"κ":[{"μ":[{},[0,0,0,0,2,1]]}]}],"ε":[{"κ":[{"μ":[{},[0,0,0,0,2,1]]}],"ξ":[{},[0,0,0,0,2,1]]}]}]},[0,2]],"ὔ":[{},[0,2]],"ὒ":[{},[0,2]],"ὖ":[{},[0,2]],"ὑ":[{},[0,2]],"ὕ":[{},[0,2]],"ὓ":[{},[0,2]],"ὗ":[{},[0,2]]},[0,1]],"ε":[{"ι":[{},[0,2]],"ί":[{},[0,2]],"ί":[{},[0,2]],"ὶ":[{},[0,2]],"ῖ":[{},[0,2]],"ἰ":[{"ν":[{"ό":[{"δ":[{},[0,0,2,1]]}],"ό":[{"δ":[{},[0,0,2,1]]}],"ο":[{"δ":[{},[0,0,2,1]]}]}],"σ":[{"ί":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ί":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ὶ":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ι":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ό":[{"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]},[0,0,3,2]]}],"ό":[{"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]},[0,0,3,2]]}],"ο":[{"ί":[{"μ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}],"σ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}]}]}]}],"ί":[{"μ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}],"σ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}]}]}]}],"μ":[{"έ":[{"ν":[{},[0,0,3,2]]}],"έ":[{"ν":[{},[0,0,3,2]]}]}]}],"ά":[{"σ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ω":[{"ν":[{},[0,0,3,2]]},[0,0,3,2]]}]}],"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}],"ν":[{},[0,0,3,2]]}]}]}],"ά":[{"σ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ω":[{"ν":[{},[0,0,3,2]]},[0,0,3,2]]}]}],"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}],"ν":[{},[0,0,3,2]]}]}]}],"ώ":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"ώ":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"α":[{"ί":[{"μ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"ί":[{"μ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"μ":[{"έ":[{"ν":[{},[0,0,3,2]]}],"έ":[{"ν":[{},[0,0,3,2]]}]}]}]},[0,0,2,1]],"ϲ":[{"ί":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ί":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ὶ":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ι":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ό":[{"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]},[0,0,3,2]]}],"ό":[{"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]},[0,0,3,2]]}],"ο":[{"ί":[{"μ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}]}]}]}],"ί":[{"μ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}]}]}]}],"μ":[{"έ":[{"ν":[{},[0,0,3,2]]}],"έ":[{"ν":[{},[0,0,3,2]]}]}]}],"ά":[{"ϲ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ω":[{"ν":[{},[0,0,3,2]]},[0,0,3,2]]}]}],"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}],"ν":[{},[0,0,3,2]]}]}]}],"ά":[{"ϲ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ω":[{"ν":[{},[0,0,3,2]]},[0,0,3,2]]}]}],"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}],"ν":[{},[0,0,3,2]]}]}]}],"ώ":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"ώ":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"α":[{"ί":[{"μ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"ί":[{"μ":[{"η":[{"ν":[{},[0,0,3,2]]}],"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"μ":[{"έ":[{"ν":[{},[0,0,3,2]]}],"έ":[{"ν":[{},[0,0,3,2]]}]}]}]},[0,0,2,1]]},[0,2]],"ἴ":[{"σ":[{"ο":[{"μ":[{},[0,0,3,2]],"ν":[{"τ":[{"α":[{"ι":[{},[0,0,3,2]]}]}]}],"ι":[{"ο":[{},[0,0,3,2]],"τ":[{"ο":[{},[0,0,3,2]]}],"σ":[{"θ":[{"ο":[{"ν":[{},[0,0,3,2]]}],"ε":[{},[0,0,3,2]]}]}],"ν":[{"τ":[{"ο":[{},[0,0,3,2]]}]}]}]}],"ῃ":[{".":[{},[0,0,3,2]]}],"ε":[{"ι":[{".":[{},[]]}],"τ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"σ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}],"α":[{"ι":[{},[0,0,3,2]]}]}]}]}],"ά":[{"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}],"ά":[{"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}],"ω":[{"μ":[{"α":[{"ι":[{},[0,0,3,2]]}]}],"ν":[{"τ":[{"α":[{"ι":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]],"α":[{"τ":[{"ο":[{},[0,0,3,2]]}],"σ":[{"θ":[{"ο":[{"ν":[{},[0,0,3,2]]}],"ε":[{},[0,0,3,2]],"α":[{"ι":[{},[0,0,3,2]]}]}]}],"ν":[{"τ":[{"ο":[{},[0,0,3,2]]}]}],"ι":[{"ο":[{},[0,0,3,2]],"τ":[{"ο":[{},[0,0,3,2]]}],"σ":[{"θ":[{"ο":[{"ν":[{},[0,0,3,2]]}],"ε":[{},[0,0,3,2]]}]}],"ν":[{"τ":[{"ο":[{},[0,0,3,2]]}]}]}],"ί":[{"σ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}]}]}]}],"ί":[{"σ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}]}]}]}]}],"η":[{"σ":[{"θ":[{"ο":[{"ν":[{},[0,0,3,2]]}],"ε":[{},[0,0,3,2]]}]}]}]},[0,0,2,1]],"ϲ":[{"ο":[{"μ":[{},[0,0,3,2]],"ν":[{"τ":[{"α":[{"ι":[{},[0,0,3,2]]}]}]}],"ι":[{"ο":[{},[0,0,3,2]],"τ":[{"ο":[{},[0,0,3,2]]}],"ϲ":[{"θ":[{"ο":[{"ν":[{},[0,0,3,2]]}],"ε":[{},[0,0,3,2]]}]}],"ν":[{"τ":[{"ο":[{},[0,0,3,2]]}]}]}]}],"ῃ":[{".":[{},[0,0,3,2]]}],"ε":[{"ι":[{".":[{},[]]}],"τ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}],"α":[{"ι":[{},[0,0,3,2]]}]}]}]}],"ά":[{"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}],"ά":[{"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}],"ω":[{"μ":[{"α":[{"ι":[{},[0,0,3,2]]}]}],"ν":[{"τ":[{"α":[{"ι":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]],"α":[{"τ":[{"ο":[{},[0,0,3,2]]}],"ϲ":[{"θ":[{"ο":[{"ν":[{},[0,0,3,2]]}],"ε":[{},[0,0,3,2]],"α":[{"ι":[{},[0,0,3,2]]}]}]}],"ν":[{"τ":[{"ο":[{},[0,0,3,2]]}]}],"ι":[{"ο":[{},[0,0,3,2]],"τ":[{"ο":[{},[0,0,3,2]]}],"ϲ":[{"θ":[{"ο":[{"ν":[{},[0,0,3,2]]}],"ε":[{},[0,0,3,2]]}]}],"ν":[{"τ":[{"ο":[{},[0,0,3,2]]}]}]}],"ί":[{"ϲ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}]}]}]}],"ί":[{"ϲ":[{"θ":[{"η":[{"ν":[{},[0,0,3,2]]}]}]}]}]}],"η":[{"ϲ":[{"θ":[{"ο":[{"ν":[{},[0,0,3,2]]}],"ε":[{},[0,0,3,2]]}]}]}]},[0,0,2,1]]},[0,2]],"ἲ":[{},[0,2]],"ἶ":[{},[0,2]],"ἱ":[{},[0,2]],"ἵ":[{},[0,2]],"ἳ":[{},[0,2]],"ἷ":[{},[0,2]],"υ":[{},[0,2]],"ύ":[{},[0,2]],"ύ":[{},[0,2]],"ὺ":[{},[0,2]],"ῦ":[{},[0,2]],"ὐ":[{"ε":[{"ξ":[{"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"ι":[{},[0,0,0,3,2]]},[0,0,0,2,1]]}],"π":[{"ρ":[{"ό":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}],"ό":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}],"ο":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}]}]}],"σ":[{"ύ":[{"ν":[{},[0,0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,0,2,1]]}]}],"ϲ":[{"ύ":[{"ν":[{},[0,0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,0,2,1]]}]}],"ξ":[{"ύ":[{"ν":[{},[0,0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,0,2,1]]}]}]},[0,2]],"ὔ":[{},[0,2]],"ὒ":[{},[0,2]],"ὖ":[{},[0,2]],"ὑ":[{},[0,2]],"ὕ":[{},[0,2]],"ὓ":[{},[0,2]],"ὗ":[{},[0,2]]},[0,1]],"η":[{"υ":[{},[0,2]],"ύ":[{},[0,2]],"ύ":[{},[0,2]],"ὺ":[{},[0,2]],"ῦ":[{},[0,2]],"ὐ":[{},[0,2]],"ὔ":[{},[0,2]],"ὒ":[{},[0,2]],"ὖ":[{},[0,2]],"ὑ":[{},[0,2]],"ὕ":[{},[0,2]],"ὓ":[{},[0,2]],"ὗ":[{},[0,2]]},[0,1]],"ι":[{"σ":[{"χ":[{"ί":[{"λ":[{"ι":[{"ο":[{"ι":[{".":[{},[0,2,1]]}]}],"α":[{"ι":[{".":[{},[0,2,1]]}],".":[{},[0,2,1]]}]}]}]}],"ί":[{"λ":[{"ι":[{"ο":[{"ι":[{".":[{},[0,2,1]]}]}],"α":[{"ι":[{".":[{},[0,2,1]]}],".":[{},[0,2,1]]}]}]}]}],"ι":[{"λ":[{"ί":[{"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"ο":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"υ":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"α":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ί":[{"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"ο":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"υ":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"α":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ι":[{"ο":[{"σ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"κ":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}]}],"ά":[{"κ":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}]}]}]}]}]}],"μ":[{"ύ":[{"ρ":[{"ι":[{"ο":[{"ι":[{".":[{},[0,2,1]]}]}],"α":[{"ι":[{".":[{},[0,2,1]]}],".":[{},[0,2,1]]}]}]}]}],"ύ":[{"ρ":[{"ι":[{"ο":[{"ι":[{".":[{},[0,2,1]]}]}],"α":[{"ι":[{".":[{},[0,2,1]]}],".":[{},[0,2,1]]}]}]}]}],"υ":[{"ρ":[{"ί":[{"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"ο":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"υ":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"α":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ί":[{"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"ο":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"υ":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"α":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ι":[{"ο":[{"σ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"κ":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}]}],"ά":[{"κ":[{"ι":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}]}]}]}]}]}]}],"ϲ":[{"χ":[{"ί":[{"λ":[{"ι":[{"ο":[{"ι":[{".":[{},[0,2,1]]}]}],"α":[{"ι":[{".":[{},[0,2,1]]}],".":[{},[0,2,1]]}]}]}]}],"ί":[{"λ":[{"ι":[{"ο":[{"ι":[{".":[{},[0,2,1]]}]}],"α":[{"ι":[{".":[{},[0,2,1]]}],".":[{},[0,2,1]]}]}]}]}],"ι":[{"λ":[{"ί":[{"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"ο":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}],"υ":[{"ϲ":[{".":[{},[0,2,1]]}]}]}],"α":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}],"ϲ":[{".":[{},[0,2,1]]}]}]}],"ί":[{"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"ο":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}],"υ":[{"ϲ":[{".":[{},[0,2,1]]}]}]}],"α":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}],"ϲ":[{".":[{},[0,2,1]]}]}]}],"ι":[{"ο":[{"ϲ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"κ":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}]}]}],"ά":[{"κ":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}]}]}]}]}]}]}],"μ":[{"ύ":[{"ρ":[{"ι":[{"ο":[{"ι":[{".":[{},[0,2,1]]}]}],"α":[{"ι":[{".":[{},[0,2,1]]}],".":[{},[0,2,1]]}]}]}]}],"ύ":[{"ρ":[{"ι":[{"ο":[{"ι":[{".":[{},[0,2,1]]}]}],"α":[{"ι":[{".":[{},[0,2,1]]}],".":[{},[0,2,1]]}]}]}]}],"υ":[{"ρ":[{"ί":[{"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"ο":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}],"υ":[{"ϲ":[{".":[{},[0,2,1]]}]}]}],"α":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}],"ϲ":[{".":[{},[0,2,1]]}]}]}],"ί":[{"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"ο":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}],"υ":[{"ϲ":[{".":[{},[0,2,1]]}]}]}],"α":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}],"ϲ":[{".":[{},[0,2,1]]}]}]}],"ι":[{"ο":[{"ϲ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"κ":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}]}]}],"ά":[{"κ":[{"ι":[{"ϲ":[{".":[{},[0,2,1]]}]}]}]}]}]}]}]}]}]},[0,1]],"ο":[{"ι":[{},[0,2]],"ί":[{},[0,2]],"ί":[{},[0,2]],"ὶ":[{},[0,2]],"ῖ":[{},[0,2]],"ἰ":[{"σ":[{"π":[{"ώ":[{"τ":[{},[0,0,2,1]]}],"ώ":[{"τ":[{},[0,0,2,1]]}],"ω":[{"τ":[{},[0,0,2,1]]}]}]}],"ϲ":[{"π":[{"ώ":[{"τ":[{},[0,0,2,1]]}],"ώ":[{"τ":[{},[0,0,2,1]]}],"ω":[{"τ":[{},[0,0,2,1]]}]}]}]},[0,2]],"ἴ":[{},[0,2]],"ἲ":[{},[0,2]],"ἶ":[{},[0,2]],"ἱ":[{"ο":[{"ν":[{"ε":[{"ί":[{".":[{},[0,0,0,2,1]]}],"ί":[{".":[{},[0,0,0,2,1]]}],"ὶ":[{".":[{},[0,0,0,2,1]]}]}]}]}],"ό":[{"σ":[{},[0,0,0,2,1]],"ϲ":[{},[0,0,0,2,1]]}],"ό":[{"σ":[{},[0,0,0,2,1]],"ϲ":[{},[0,0,0,2,1]]}]},[0,2]],"ἵ":[{},[0,2]],"ἳ":[{},[0,2]],"ἷ":[{"σ":[{"τ":[{"ι":[{"σ":[{"ι":[{},[0,0,2,1]]}]}]}]}],"ϲ":[{"τ":[{"ι":[{"ϲ":[{"ι":[{},[0,0,2,1]]}]}]}]}]},[0,2]],"υ":[{"ι":[{},[0,0,3]],"ί":[{},[0,3]],"ί":[{},[0,3]],"ῖ":[{},[0,3]]},[0,2]],"ύ":[{},[0,2]],"ύ":[{},[0,2]],"ὺ":[{},[0,2]],"ῦ":[{},[0,2]],"ὐ":[{"δ":[{"ε":[{"ν":[{"ό":[{"σ":[{"ω":[{},[0,0,0,0,0,0,2,1]]}],"ϲ":[{"ω":[{},[0,0,0,0,0,0,2,1]]}]}],"ό":[{"σ":[{"ω":[{},[0,0,0,0,0,0,2,1]]}],"ϲ":[{"ω":[{},[0,0,0,0,0,0,2,1]]}]}],"ο":[{"σ":[{"ώ":[{},[0,0,0,0,0,0,2,1]],"ώ":[{},[0,0,0,0,0,0,2,1]]}],"ϲ":[{"ώ":[{},[0,0,0,0,0,0,2,1]],"ώ":[{},[0,0,0,0,0,0,2,1]]}]}]}]}]}]},[0,2]],"ὔ":[{},[0,2]],"ὒ":[{},[0,2]],"ὖ":[{},[0,2]],"ὑ":[{},[0,2]],"ὕ":[{"σ":[{"τ":[{"ι":[{"ν":[{"α":[{"ς":[{},[0,0,2,1]]}]}]}]}]}],"ϲ":[{"τ":[{"ι":[{"ν":[{"α":[{"ϲ":[{},[0,0,2,1]]}]}]}]}]}]},[0,2]],"ὓ":[{},[0,2]],"ὗ":[{},[0,2]]},[0,1]],"υ":[{"ι":[{},[0,2]],"ί":[{},[0,2]],"ί":[{},[0,2]],"ὶ":[{},[0,2]],"ῖ":[{},[0,2]],"ἰ":[{},[0,2]],"ἴ":[{},[0,2]],"ἲ":[{},[0,2]],"ἶ":[{},[0,2]],"ἱ":[{},[0,2]],"ἵ":[{},[0,2]],"ἳ":[{},[0,2]],"ἷ":[{},[0,2]]},[0,1]],"ω":[{},[0,1]],"ϊ":[{},[0,1]],"ϋ":[{},[0,1]],"ἀ":[{"ι":[{},[0,3]],"υ":[{},[0,3]],"γ":[{"ω":[{"ν":[{"ά":[{"ρ":[{},[0,0,0,2,1]]}],"ά":[{"ρ":[{},[0,0,0,2,1]]}],"α":[{"ρ":[{},[0,0,0,2,1]]}]}]}]}],"δ":[{"ι":[{"έ":[{"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"ξ":[{},[0,0,0,0,2,1]]}],"ε":[{"ξ":[{},[0,0,0,0,2,1]]}]}],"υ":[{"σ":[{"ώ":[{},[0,0,0,2,1]],"ώ":[{},[0,0,0,2,1]],"ω":[{},[0,0,0,2,1]]}],"ϲ":[{"ώ":[{},[0,0,0,2,1]],"ώ":[{},[0,0,0,2,1]],"ω":[{},[0,0,0,2,1]]}]}]}],"μ":[{"π":[{"α":[{"λ":[{"ί":[{"ν":[{},[0,0,0,0,0,0,2,1]]}],"ί":[{"ν":[{},[0,0,0,0,0,0,2,1]]}],"ι":[{"ν":[{},[0,0,0,0,0,0,2,1]]}]}]}]}],"φ":[{"ί":[{"σ":[{"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ω":[{},[0,0,0,0,2,1]]}],"ϲ":[{"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ω":[{},[0,0,0,0,2,1]]}]}],"ί":[{"σ":[{"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ω":[{},[0,0,0,0,2,1]]}],"ϲ":[{"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ω":[{},[0,0,0,0,2,1]]}]}],"ι":[{"σ":[{"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ώ":[{},[0,0,0,0,2,1]],"ώ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ώ":[{},[0,0,0,0,2,1]],"ώ":[{},[0,0,0,0,2,1]]}]}]}]}],"ν":[{"α":[{"γ":[{"ή":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ή":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ὴ":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ο":[{},[0,2,1]],"ε":[{"ῖ":[{".":[{},[0,2,1]],"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ῆ":[{".":[{},[0,2,1]]},[0,2,1]],"έ":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]],"ι":[{},[0,2,1]]}]}],"έ":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]],"ι":[{},[0,2,1]]}]}],"ὲ":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ῶ":[{"ν":[{".":[{},[0,2,1]]}]}],"κ":[{"ύ":[{},[0,2,1]],"ύ":[{},[0,2,1]]}],"ν":[{"ά":[{},[0,3,2]],"ά":[{},[0,3,2]],"ω":[{},[0,3,2]],"ώ":[{},[0,3,2]],"ώ":[{},[0,3,2]]},[0,2,1]],"ρ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ῖ":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"ώ":[{"γ":[{"ι":[{},[0,3,2]]},[0,2,1]]}],"ώ":[{"γ":[{"ι":[{},[0,3,2]]},[0,2,1]]}],"ω":[{"γ":[{"ί":[{"α":[{},[0,4,3]]},[0,3,2]],"ί":[{"α":[{},[0,4,3]]},[0,3,2]]}]}]}],"δ":[{"έ":[{"λ":[{},[0,2,1]]}],"έ":[{"λ":[{},[0,2,1]]}]}],"έ":[{"λ":[{"π":[{},[0,2,1]]}]}],"έ":[{"λ":[{"π":[{},[0,2,1]]}]}],"ί":[{"δ":[{},[0,2,1]],"μ":[{},[0,2,1]],"σ":[{"θ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"ϲ":[{"θ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"τ":[{},[0,2,1]]}],"ί":[{"δ":[{},[0,2,1]],"μ":[{},[0,2,1]],"σ":[{"θ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"ϲ":[{"θ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"τ":[{},[0,2,1]]}],"ι":[{"δ":[{},[0,2,1]],"μ":[{},[0,2,1]],"σ":[{"θ":[{},[0,2,1]],"ι":[{},[0,2,1]],"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"ϲ":[{"θ":[{},[0,2,1]],"ι":[{},[0,2,1]],"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"τ":[{},[0,2,1]]}],"κ":[{"ά":[{"ν":[{},[0,2,1]]}],"ά":[{"ν":[{},[0,2,1]]}],"ό":[{"λ":[{"ο":[{},[0,2,1]]}]}],"ό":[{"λ":[{"ο":[{},[0,2,1]]}]}],"ο":[{"λ":[{"ο":[{},[0,2,1]]}]}]}],"λ":[{"γ":[{},[0,2,1]],"δ":[{"α":[{},[0,3,2]],"ή":[{"σ":[{"κ":[{},[0,3,2]]}],"ϲ":[{"κ":[{},[0,3,2]]}]}],"ή":[{"σ":[{"κ":[{},[0,3,2]]}],"ϲ":[{"κ":[{},[0,3,2]]}]}]},[0,2,1]],"ε":[{"ί":[{"π":[{},[0,2,1]],"φ":[{},[0,2,1]]}],"ί":[{"π":[{},[0,2,1]],"φ":[{},[0,2,1]]}],"ι":[{"φ":[{},[0,2,1]]}]}],"ή":[{"θ":[{},[0,2,1]]}],"ή":[{"θ":[{},[0,2,1]]}],"η":[{"θ":[{},[0,2,1]]}],"θ":[{},[0,2,1]],"ί":[{"π":[{},[0,2,1]],"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"ί":[{"π":[{},[0,2,1]],"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"κ":[{},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{},[0,2,1]]}],"μ":[{"ά":[{"ξ":[{},[0,2,1]],"ρ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"ξ":[{},[0,2,1]],"ρ":[{"τ":[{},[0,2,1]]}]}],"α":[{"ξ":[{},[0,2,1]],"ρ":[{"τ":[{},[0,2,1]]}]}],"έ":[{"λ":[{"γ":[{},[0,2,1]]}]}],"έ":[{"λ":[{"γ":[{},[0,2,1]]}]}],"ε":[{"λ":[{"γ":[{},[0,2,1]]}]}],"π":[{},[0,2,1]],"φ":[{"ι":[{"σ":[{},[0,0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,0,2,1]]}]},[0,2,1]]}],"ν":[{"ά":[{"γ":[{"κ":[{},[0,2,1]]}]}],"ά":[{"γ":[{"κ":[{},[0,2,1]]}]}],"α":[{"γ":[{"κ":[{},[0,2,1]]}]}],"θ":[{"έ":[{"ς":[{".":[{},[0,4,3]]}],"ϲ":[{".":[{},[0,4,3]],"ι":[{},[0,4,3]]}],"σ":[{".":[{},[0,4,3]],"ι":[{},[0,4,3]]}]},[0,3,2]],"έ":[{"ς":[{".":[{},[0,4,3]]}],"ϲ":[{".":[{},[0,4,3]],"ι":[{},[0,4,3]]}],"σ":[{".":[{},[0,4,3]],"ι":[{},[0,4,3]]}]},[0,3,2]],"ὲ":[{"ς":[{".":[{},[0,4,3]]}],"ϲ":[{".":[{},[0,4,3]]}],"σ":[{".":[{},[0,4,3]]}]}]},[0,2,1]],"ί":[{"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"ί":[{"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"τ":[{"α":[{"γ":[{},[0,2,1]],"π":[{},[0,2,1]]}],"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ι":[{},[0,2,1]]}]}],"ξ":[{"α":[{"γ":[{},[0,0,0,2,1]],"ν":[{},[0,0,0,2,1]]}],"ά":[{"ν":[{},[0,0,0,2,1]],"ρ":[{},[0,0,0,2,1]]}],"ά":[{"ν":[{},[0,0,0,2,1]],"ρ":[{},[0,0,0,2,1]]}],"ί":[{"π":[{},[0,0,0,2,1]],"ο":[{},[0,2,1]],"ω":[{},[0,2,1]],"α":[{},[0,2,1]]}],"ί":[{"π":[{},[0,0,0,2,1]],"ο":[{},[0,2,1]],"ω":[{},[0,2,1]],"α":[{},[0,2,1]]}],"ι":[{"ό":[{"λ":[{},[0,2,1]],"π":[{},[0,2,1]]}],"ό":[{"λ":[{},[0,2,1]],"π":[{},[0,2,1]]}],"ο":[{"λ":[{},[0,2,1]],"π":[{},[0,2,1]]}]}],"ῖ":[{"α":[{},[0,2,1]]}]}],"π":[{"ά":[{"λ":[{"λ":[{"α":[{},[0,2,1]]}]}],"ρ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"λ":[{"λ":[{"α":[{},[0,2,1]]}]}],"ρ":[{"τ":[{},[0,2,1]]}]}],"α":[{"λ":[{"λ":[{"ά":[{},[0,2,1]],"ά":[{},[0,2,1]]}]}],"ρ":[{"τ":[{},[0,2,1]]}],"ύ":[{"δ":[{},[0,2,1]]}],"ύ":[{"δ":[{},[0,2,1]]}],"υ":[{"δ":[{},[0,2,1]]}]}],"ό":[{"β":[{},[0,2,1]],"ϐ":[{},[0,2,1]],"γ":[{},[0,2,1]],"δ":[{"ο":[{},[0,2,1]],"ρ":[{},[0,2,1]]}],"λ":[{"α":[{"υ":[{},[0,2,1]]}],"υ":[{},[0,2,1]]}],"ν":[{},[0,2,1]],"π":[{},[0,2,1]],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]],"τ":[{"ε":[{},[0,2,1]],"μ":[{},[0,2,1]],"ρ":[{},[0,2,1]]}]}],"ό":[{"β":[{},[0,2,1]],"ϐ":[{},[0,2,1]],"γ":[{},[0,2,1]],"δ":[{"ο":[{},[0,2,1]],"ρ":[{},[0,2,1]]}],"λ":[{"α":[{"υ":[{},[0,2,1]]}],"υ":[{},[0,2,1]]}],"ν":[{},[0,2,1]],"π":[{},[0,2,1]],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]],"τ":[{"ε":[{},[0,2,1]],"μ":[{},[0,2,1]],"ρ":[{},[0,2,1]]}]}],"ο":[{"β":[{},[0,2,1]],"ϐ":[{},[0,2,1]],"γ":[{},[0,2,1]],"δ":[{"ή":[{},[0,2,1]],"ή":[{},[0,2,1]],"η":[{},[0,2,1]],"ό":[{},[0,2,1]],"ό":[{},[0,2,1]],"ρ":[{},[0,2,1]]}],"λ":[{"α":[{"ύ":[{},[0,2,1]],"ύ":[{},[0,2,1]]}],"ό":[{},[0,2,1]],"ό":[{},[0,2,1]],"ο":[{},[0,2,1]],"ύ":[{},[0,2,1]],"ύ":[{},[0,2,1]]}],"ν":[{},[0,2,1]],"π":[{},[0,2,1]],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]],"τ":[{"ε":[{},[0,2,1]],"μ":[{},[0,2,1]],"ρ":[{},[0,2,1]]}]}]}],"ρ":[{"ά":[{},[0,2,1]],"ά":[{},[0,2,1]],"α":[{},[0,2,1]],"ί":[{"τ":[{},[0,3,2]]}],"ί":[{"τ":[{},[0,3,2]]}],"ῖ":[{"τ":[{},[0,3,2]]}],"ι":[{"τ":[{},[0,3,2]]}],"π":[{},[0,3,2]],"ρ":[{"α":[{"γ":[{},[0,4,3]]}]},[0,3,2]],"τ":[{},[0,3,2]],"ύ":[{"τ":[{},[0,3,2]]}],"ύ":[{"τ":[{},[0,3,2]]}]},[0,2,1]],"σ":[{"κ":[{"ή":[{},[0,2,1]],"ή":[{},[0,2,1]]}],"π":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}],"σ":[{"ά":[{"τ":[{},[0,2,1]]}],"ά":[{"τ":[{},[0,2,1]]}]}],"τ":[{"ε":[{"ί":[{"β":[{},[0,3,2]],"ϐ":[{},[0,3,2]],"ρ":[{},[0,3,2]],"χ":[{},[0,3,2]]},[0,2,1]],"ί":[{"β":[{},[0,3,2]],"ϐ":[{},[0,3,2]],"ρ":[{},[0,3,2]],"χ":[{},[0,3,2]]},[0,2,1]]}]}]}],"ϲ":[{"κ":[{"ή":[{},[0,2,1]],"ή":[{},[0,2,1]]}],"π":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}],"ϲ":[{"ά":[{"τ":[{},[0,2,1]]}],"ά":[{"τ":[{},[0,2,1]]}]}],"τ":[{"ε":[{"ί":[{"β":[{},[0,3,2]],"ϐ":[{},[0,3,2]],"ρ":[{},[0,3,2]],"χ":[{},[0,3,2]]},[0,2,1]],"ί":[{"β":[{},[0,3,2]],"ϐ":[{},[0,3,2]],"ρ":[{},[0,3,2]],"χ":[{},[0,3,2]]},[0,2,1]]}]}]}],"τ":[{"ε":[{"ὶ":[{".":[{},[0,2,1]]}],"ί":[{".":[{},[0,2,1]]}],"ί":[{".":[{},[0,2,1]]}]}],"ὶ":[{".":[{},[0,2,1]]}],"ί":[{".":[{},[0,2,1]]}],"ί":[{".":[{},[0,2,1]]}],"τ":[{},[0,2,1]]}],"ύ":[{"γ":[{},[0,2,1]],"δ":[{},[0,2,1]],"λ":[{},[0,2,1]],"ξ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"ύ":[{"γ":[{},[0,2,1]],"δ":[{},[0,2,1]],"λ":[{},[0,2,1]],"ξ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"υ":[{"γ":[{},[0,2,1]],"δ":[{"ί":[{},[0,3,2]],"ί":[{},[0,3,2]],"ι":[{},[0,3,2]]},[0,2,1]],"ξ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"φ":[{"α":[{"ί":[{"ρ":[{},[0,2,1]]}],"ί":[{"ρ":[{},[0,2,1]]}],"ι":[{"ρ":[{},[0,2,1]]}]}],"ή":[{},[0,2,1]],"ή":[{},[0,2,1]],"ὴ":[{},[0,2,1]],"ο":[{"ῦ":[{},[0,2,1]],"ῖ":[{},[0,2,1]]}],"ῆ":[{"ν":[{},[0,3,2]]},[0,2,1]],"ε":[{"ῖ":[{},[0,2,1]]}],"έ":[{},[0,2,1]],"έ":[{},[0,2,1]],"ὲ":[{},[0,2,1]],"ρ":[{"ό":[{"δ":[{},[0,2,1]]}],"ό":[{"δ":[{},[0,2,1]]}],"ο":[{"δ":[{},[0,2,1]]}]}]}],"χ":[{"ύ":[{"ρ":[{},[0,2,1]]}],"ύ":[{"ρ":[{},[0,2,1]]}],"υ":[{"ρ":[{},[0,2,1]]}]}]}],"ά":[{"γ":[{"κ":[{"υ":[{},[0,2,1]]}],"ν":[{"ω":[{},[0,3,2]]},[0,2,1]],"ω":[{"γ":[{},[0,2,1]]}]}],"δ":[{"ε":[{"λ":[{},[0,2,1]]}]}],"ε":[{"λ":[{"π":[{},[0,2,1]]}]}],"θ":[{"λ":[{},[0,2,1]]}],"κ":[{"α":[{"ν":[{},[0,2,1]]}]}],"λ":[{"ε":[{"ι":[{"π":[{},[0,2,1]],"φ":[{},[0,2,1]]}]}],"θ":[{},[0,2,1]],"ι":[{"π":[{},[0,2,1]],"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"κ":[{},[0,2,1]],"λ":[{"ο":[{},[0,3,2]],"ε":[{},[0,3,2]]},[0,2,1]],"μ":[{},[0,2,1]],"ο":[{"υ":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"ῳ":[{".":[{},[0,2,1]]}],"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"τ":[{},[0,2,1]]}],"μ":[{"π":[{},[0,2,1]]}],"ν":[{"δ":[{},[0,2,1]],"ι":[{"ο":[{},[0,2,1]]}]}],"ξ":[{"α":[{"ν":[{},[0,0,0,2,1]],"ρ":[{},[0,0,0,2,1]]}],"ι":[{"π":[{},[0,0,0,2,1]],"ο":[{},[0,2,1]]}]}],"ρ":[{"ρ":[{},[0,3,2]]},[0,2,1]],"σ":[{"κ":[{"η":[{},[0,2,1]]}],"σ":[{"α":[{"τ":[{},[0,2,1]]}]}],"τ":[{"ε":[{"ι":[{"ρ":[{},[0,3,2]],"χ":[{},[0,3,2]]},[0,2,1]]}]}]}],"ϲ":[{"κ":[{"η":[{},[0,2,1]]}],"ϲ":[{"α":[{"τ":[{},[0,2,1]]}]}],"τ":[{"ε":[{"ι":[{"ρ":[{},[0,3,2]],"χ":[{},[0,3,2]]},[0,2,1]]}]}]}],"τ":[{"ο":[{"υ":[{".":[{},[0,2,1]]}],"ι":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ω":[{},[0,2,1]],"τ":[{},[0,2,1]]}],"φ":[{"ρ":[{},[0,2,1]]}]}],"ά":[{"γ":[{"κ":[{"υ":[{},[0,2,1]]}],"ν":[{"ω":[{},[0,3,2]]},[0,2,1]],"ω":[{"γ":[{},[0,2,1]]}]}],"δ":[{"ε":[{"λ":[{},[0,2,1]]}]}],"ε":[{"λ":[{"π":[{},[0,2,1]]}]}],"θ":[{"λ":[{},[0,2,1]]}],"κ":[{"α":[{"ν":[{},[0,2,1]]}]}],"λ":[{"ε":[{"ι":[{"π":[{},[0,2,1]],"φ":[{},[0,2,1]]}]}],"θ":[{},[0,2,1]],"ι":[{"π":[{},[0,2,1]],"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"κ":[{},[0,2,1]],"λ":[{"ο":[{},[0,3,2]],"ε":[{},[0,3,2]]},[0,2,1]],"μ":[{},[0,2,1]],"ο":[{"υ":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"ῳ":[{".":[{},[0,2,1]]}],"ω":[{"ν":[{".":[{},[0,2,1]]}]}],"τ":[{},[0,2,1]]}],"μ":[{"π":[{},[0,2,1]]}],"ν":[{"δ":[{},[0,2,1]],"ι":[{"ο":[{},[0,2,1]]}]}],"ξ":[{"α":[{"ν":[{},[0,0,0,2,1]],"ρ":[{},[0,0,0,2,1]]}],"ι":[{"π":[{},[0,0,0,2,1]],"ο":[{},[0,2,1]]}]}],"ρ":[{"ρ":[{},[0,3,2]]},[0,2,1]],"σ":[{"κ":[{"η":[{},[0,2,1]]}],"σ":[{"α":[{"τ":[{},[0,2,1]]}]}],"τ":[{"ε":[{"ι":[{"ρ":[{},[0,3,2]],"χ":[{},[0,3,2]]},[0,2,1]]}]}]}],"ϲ":[{"κ":[{"η":[{},[0,2,1]]}],"ϲ":[{"α":[{"τ":[{},[0,2,1]]}]}],"τ":[{"ε":[{"ι":[{"ρ":[{},[0,3,2]],"χ":[{},[0,3,2]]},[0,2,1]]}]}]}],"τ":[{"ο":[{"υ":[{".":[{},[0,2,1]]}],"ι":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ω":[{},[0,2,1]],"τ":[{},[0,2,1]]}],"φ":[{"ρ":[{},[0,2,1]]}]}],"ε":[{"φ":[{"ῶ":[{"ν":[{".":[{},[0,2,1]]}]}],"ά":[{"λ":[{},[0,3,2]]}],"ά":[{"λ":[{},[0,3,2]]}],"έ":[{"λ":[{},[0,3,2]]}],"έ":[{"λ":[{},[0,3,2]]}]},[0,2,1]],"γ":[{"γ":[{},[0,2,1]],"έ":[{"ρ":[{"τ":[{},[0,2,1]]}]}],"έ":[{"ρ":[{"τ":[{},[0,2,1]]}]}],"κ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"δ":[{"ά":[{},[0,2,1]],"ά":[{},[0,2,1]],"α":[{},[0,2,1]],"έ":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"έ":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ρ":[{"ά":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ά":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}]}]}],"έ":[{"ρ":[{},[0,2,1]]}],"έ":[{"ρ":[{},[0,2,1]]}],"ε":[{"ρ":[{},[0,2,1]]}],"θ":[{"έ":[{"λ":[{},[0,2,1]]}],"έ":[{"λ":[{},[0,2,1]]}],"ε":[{"λ":[{},[0,2,1]]}],"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}],"ί":[{"δ":[{"ε":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"κ":[{"α":[{},[0,2,1]]}],"μ":[{"α":[{},[0,2,1]]}],"σ":[{"α":[{"κ":[{},[0,2,1,0,2,1]]}],"ο":[{},[0,2,1,0,2,1]],"φ":[{"ο":[{"ρ":[{},[0,2,1,0,2,1]]}]}]}],"ϲ":[{"α":[{"κ":[{},[0,2,1,0,2,1]]}],"ο":[{},[0,2,1,0,2,1]],"φ":[{"ο":[{"ρ":[{},[0,2,1,0,2,1]]}]}]}]}],"ί":[{"δ":[{"ε":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"κ":[{"α":[{},[0,2,1]]}],"μ":[{"α":[{},[0,2,1]]}],"σ":[{"α":[{"κ":[{},[0,2,1,0,2,1]]}],"ο":[{},[0,2,1,0,2,1]],"φ":[{"ο":[{"ρ":[{},[0,2,1,0,2,1]]}]}]}],"ϲ":[{"α":[{"κ":[{},[0,2,1,0,2,1]]}],"ο":[{},[0,2,1,0,2,1]],"φ":[{"ο":[{"ρ":[{},[0,2,1,0,2,1]]}]}]}]}],"ι":[{"δ":[{"έ":[{},[0,2,1]],"έ":[{},[0,2,1]],"ώ":[{},[0,2,1]],"ώ":[{},[0,2,1]]}],"κ":[{"ά":[{},[0,2,1]],"ά":[{},[0,2,1]],"ό":[{},[0,2,1]],"ό":[{},[0,2,1]],"ο":[{},[0,2,1]]}],"λ":[{"ε":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ι":[{},[0,2,1]]}]}],"σ":[{"ά":[{"κ":[{},[0,2,1,0,2,1]]}],"ά":[{"κ":[{},[0,2,1,0,2,1]]}],"ό":[{},[0,2,1,0,2,1]],"ό":[{},[0,2,1,0,2,1]],"φ":[{"ο":[{"ρ":[{},[0,2,1,0,2,1]]}],"ό":[{"ρ":[{},[0,2,1,0,2,1]]}],"ό":[{"ρ":[{},[0,2,1,0,2,1]]}]}]}],"ϲ":[{"ά":[{"κ":[{},[0,2,1,0,2,1]]}],"ά":[{"κ":[{},[0,2,1,0,2,1]]}],"ό":[{},[0,2,1,0,2,1]],"ό":[{},[0,2,1,0,2,1]],"φ":[{"ο":[{"ρ":[{},[0,2,1,0,2,1]]}],"ό":[{"ρ":[{},[0,2,1,0,2,1]]}],"ό":[{"ρ":[{},[0,2,1,0,2,1]]}]}]}]}],"κ":[{"ά":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}],"ά":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}],"ὰ":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}],"τ":[{"ί":[{"τ":[{},[0,4,3,2,1]]}],"ί":[{"τ":[{},[0,4,3,2,1]]}]},[0,3,2]],"λ":[{"ι":[{"π":[{},[0,0,0,2,1]]}],"ό":[{},[0,0,0,2,1]],"ό":[{},[0,0,0,2,1]],"ο":[{},[0,0,0,2,1]]}]},[0,2,1]],"λ":[{"α":[{"ι":[{},[0,2,1]],"τ":[{},[0,2,1]]}],"ά":[{"τ":[{},[0,2,1]]}],"ά":[{"τ":[{},[0,2,1]]}],"έ":[{"γ":[{"κ":[{},[0,2,1]]}],"η":[{},[0,2,1]],"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"έ":[{"γ":[{"κ":[{},[0,2,1]]}],"η":[{},[0,2,1]],"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"ε":[{"γ":[{"ξ":[{},[0,2,1]]}],"ή":[{},[0,2,1]],"ή":[{},[0,2,1]]}],"κ":[{"ή":[{},[0,2,1]],"ή":[{},[0,2,1]],"ὴ":[{},[0,2,1]],"ο":[{},[0,2,1]],"ῆ":[{},[0,2,1]],"έ":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]},[0,2,1]],"σ":[{".":[{},[0,2,1]]},[0,2,1]]}],"έ":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]},[0,2,1]],"σ":[{".":[{},[0,2,1]]},[0,2,1]]}],"ὲ":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ε":[{},[0,2,1]],"ῶ":[{},[0,2,1]],"ώ":[{},[0,2,1]],"ώ":[{},[0,2,1]]}],"π":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}],"ύ":[{"τ":[{"ρ":[{},[0,2,1]]}]}],"ύ":[{"τ":[{"ρ":[{},[0,2,1]]}]}]}],"μ":[{"β":[{},[0,2,1]],"ϐ":[{},[0,2,1]],"έ":[{"τ":[{},[0,2,1]]}],"έ":[{"τ":[{},[0,2,1]]}],"π":[{},[0,2,1]],"φ":[{},[0,2,1]]}],"ν":[{"ή":[{},[0,3,2]],"ή":[{},[0,3,2]]},[0,2,1]],"ξ":[{"ί":[{"κ":[{"α":[{},[0,3,2,3,2]]}]}],"ί":[{"κ":[{"α":[{},[0,3,2,3,2]]}]}],"ι":[{"κ":[{"ά":[{},[0,3,2,3,2]],"ά":[{},[0,3,2,3,2]]}]}]},[0,2,1,2,1]],"ό":[{"ρ":[{},[0,2,1]]}],"ό":[{"ρ":[{},[0,2,1]]}],"π":[{"ν":[{},[0,3,2]],"τ":[{},[0,3,2]]},[0,2,1]],"ρ":[{"α":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"γ":[{},[0,2,1]],"ε":[{"ί":[{"κ":[{},[0,2,1]],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ί":[{"κ":[{},[0,2,1]],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ύ":[{"ν":[{"η":[{"τ":[{},[0,2,1]]}]}]}],"ύ":[{"ν":[{"η":[{"τ":[{},[0,2,1]]}]}]}],"υ":[{"ν":[{"ή":[{"τ":[{},[0,2,1]]}],"ή":[{"τ":[{},[0,2,1]]}]}]}]}],"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ι":[{},[0,2,1]],"υ":[{"θ":[{"ρ":[{"ί":[{"α":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}]}],"ί":[{"α":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}]}],"ι":[{"ά":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}]}]}]}]}]}],"σ":[{"τ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}]}],"ϲ":[{"τ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}]}],"τ":[{"α":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}],"ο":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}],"υ":[{},[0,2,1]],"ύ":[{},[0,2,1]],"ύ":[{},[0,2,1]]}],"ύ":[{"θ":[{},[0,2,1]],"κ":[{},[0,2,1]],"ρ":[{"ε":[{"τ":[{},[0,2,1]]}]}],"χ":[{},[0,2,1]],"ξ":[{},[0,2,1]]}],"ύ":[{"θ":[{},[0,2,1]],"κ":[{},[0,2,1]],"ρ":[{"ε":[{"τ":[{},[0,2,1]]}]}],"χ":[{},[0,2,1]],"ξ":[{},[0,2,1]]}],"υ":[{"θ":[{},[0,2,1]],"λ":[{},[0,2,1]],"ρ":[{"έ":[{"τ":[{},[0,2,1]]}],"έ":[{"τ":[{},[0,2,1]]}]}],"φ":[{"ή":[{"μ":[{"η":[{"τ":[{},[0,2,1]]}]}]}],"ή":[{"μ":[{"η":[{"τ":[{},[0,2,1]]}]}]}],"η":[{"μ":[{"ή":[{"τ":[{},[0,2,1]]}],"ή":[{"τ":[{},[0,2,1]]}]}]}]}],"χ":[{},[0,2,1]],"ξ":[{},[0,2,1]],"κ":[{"τ":[{},[0,2,1]]}]}],"χ":[{"έ":[{},[0,2,1]],"έ":[{},[0,2,1]],"ε":[{},[0,2,1]]}],"ψ":[{"ά":[{},[0,2,1]],"ά":[{},[0,2,1]]}]}],"δ":[{"ρ":[{"ό":[{"σ":[{"α":[{},[0,0,0,0,0,2,1]]}],"ϲ":[{"α":[{},[0,0,0,0,0,2,1]]}]}],"ό":[{"σ":[{"α":[{},[0,0,0,0,0,2,1]]}],"ϲ":[{"α":[{},[0,0,0,0,0,2,1]]}]}],"ο":[{"σ":[{"α":[{},[0,0,0,0,0,2,1]]}],"ϲ":[{"α":[{},[0,0,0,0,0,2,1]]}]}]}]}],"έ":[{"γ":[{"γ":[{},[0,2,1]],"ε":[{"ρ":[{"τ":[{},[0,2,1]]}]}],"κ":[{},[0,2,1]]}],"δ":[{"ε":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ρ":[{"α":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}]}]}],"θ":[{"ι":[{},[0,2,1]]}],"κ":[{"α":[{},[0,3,2]],"τ":[{"ι":[{"τ":[{},[0,4,3,2,1]]}]}]},[0,2,1]],"λ":[{"α":[{"ι":[{},[0,2,1]]}],"ε":[{"γ":[{"κ":[{},[0,2,1]]}],"ο":[{},[0,2,1]],"ε":[{},[0,2,1]]}],"κ":[{"τ":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"λ":[{},[0,2,1]],"π":[{"ι":[{},[0,2,1]]}],"υ":[{"τ":[{"ρ":[{},[0,2,1]]}]}]}],"μ":[{"β":[{},[0,2,1]],"ϐ":[{},[0,2,1]],"ε":[{"τ":[{},[0,2,1]]}],"π":[{},[0,2,1]],"φ":[{},[0,2,1]]}],"ν":[{"ε":[{"ι":[{},[0,3,2]]}],"τ":[{"ε":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}]}]},[0,2,1]],"ο":[{"ρ":[{},[0,2,1]]}],"ρ":[{"α":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"γ":[{},[0,2,1]],"ε":[{"ι":[{"κ":[{},[0,2,1]],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}]}]}],"σ":[{"τ":[{"ι":[{},[0,2,1]]}]}],"ϲ":[{"τ":[{"ι":[{},[0,2,1]]}]}],"τ":[{"α":[{"ι":[{},[0,2,1]]}],"ο":[{"ι":[{},[0,2,1]]}],"υ":[{},[0,2,1]]}],"φ":[{"ε":[{"λ":[{},[0,3,2]]}]},[0,2,1]],"ψ":[{"α":[{},[0,2,1]]}]}],"έ":[{"γ":[{"γ":[{},[0,2,1]],"ε":[{"ρ":[{"τ":[{},[0,2,1]]}]}],"κ":[{},[0,2,1]]}],"δ":[{"ε":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ρ":[{"α":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}]}]}],"θ":[{"ι":[{},[0,2,1]]}],"κ":[{"α":[{},[0,3,2]],"τ":[{"ι":[{"τ":[{},[0,4,3,2,1]]}]}]},[0,2,1]],"λ":[{"α":[{"ι":[{},[0,2,1]]}],"ε":[{"γ":[{"κ":[{},[0,2,1]]}],"ο":[{},[0,2,1]],"ε":[{},[0,2,1]]}],"κ":[{"τ":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"λ":[{},[0,2,1]],"π":[{"ι":[{},[0,2,1]]}],"υ":[{"τ":[{"ρ":[{},[0,2,1]]}]}]}],"μ":[{"β":[{},[0,2,1]],"ϐ":[{},[0,2,1]],"ε":[{"τ":[{},[0,2,1]]}],"π":[{},[0,2,1]],"φ":[{},[0,2,1]]}],"ν":[{"ε":[{"ι":[{},[0,3,2]]}],"τ":[{"ε":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}]}]},[0,2,1]],"ο":[{"ρ":[{},[0,2,1]]}],"ρ":[{"α":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"γ":[{},[0,2,1]],"ε":[{"ι":[{"κ":[{},[0,2,1]],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}]}]}],"σ":[{"τ":[{"ι":[{},[0,2,1]]}]}],"ϲ":[{"τ":[{"ι":[{},[0,2,1]]}]}],"τ":[{"α":[{"ι":[{},[0,2,1]]}],"ο":[{"ι":[{},[0,2,1]]}],"υ":[{},[0,2,1]]}],"φ":[{"ε":[{"λ":[{},[0,3,2]]}]},[0,2,1]],"ψ":[{"α":[{},[0,2,1]]}]}],"η":[{"υ":[{"ξ":[{},[0,2,1]],"γ":[{},[0,2,1]]}],"ῦ":[{"γ":[{},[0,2,1]]}],"γ":[{"ε":[{"μ":[{},[0,2,1]]}]}],"δ":[{},[0,2,1]],"κ":[{"έ":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"έ":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ό":[{},[0,2,1]],"ό":[{},[0,2,1]],"ο":[{},[0,2,1]]}],"λ":[{"ά":[{"κ":[{},[0,2,1]],"τ":[{"ο":[{"υ":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"ω":[{},[0,2,1]]}]}],"ά":[{"κ":[{},[0,2,1]],"τ":[{"ο":[{"υ":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"ω":[{},[0,2,1]]}]}],"α":[{"κ":[{},[0,2,1]]}],"ε":[{"γ":[{},[0,2,1]],"ή":[{},[0,2,1]],"ή":[{},[0,2,1]],"ὴ":[{},[0,2,1]],"ο":[{},[0,2,1]],"ε":[{},[0,2,1]],"ῶ":[{},[0,2,1]],"έ":[{},[0,2,1]],"έ":[{},[0,2,1]],"ὲ":[{},[0,2,1]],"ῆ":[{},[0,2,1]],"ί":[{"π":[{},[0,2,1]]}],"ί":[{"π":[{},[0,2,1]]}],"ῖ":[{},[0,2,1]]}],"έ":[{"η":[{},[0,2,1]]},[0,2,1]],"έ":[{"η":[{},[0,2,1]]},[0,2,1]],"ή":[{},[0,2,1]],"ή":[{},[0,2,1]],"ὴ":[{},[0,2,1]],"ο":[{"ῦ":[{},[0,2,1]],"ῖ":[{},[0,2,1]]}],"ῆ":[{},[0,2,1]],"ὲ":[{},[0,2,1]],"ῶ":[{},[0,2,1]],"ί":[{"κ":[{},[0,2,1]],"ο":[{},[0,2,1]],"ω":[{},[0,2,1]],"π":[{},[0,2,1]]}],"ί":[{"κ":[{},[0,2,1]],"ο":[{},[0,2,1]],"ω":[{},[0,2,1]],"π":[{},[0,2,1]]}],"ι":[{"φ":[{},[0,2,1]]}]}],"μ":[{},[0,2,1]],"ν":[{"ύ":[{},[0,2,1]],"ύ":[{},[0,2,1]]}],"ρ":[{"ε":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"μ":[{},[0,2,1]],"φ":[{},[0,2,1]]}],"έ":[{"μ":[{},[0,2,1]]}],"έ":[{"μ":[{},[0,2,1]]}],"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ό":[{"τ":[{},[0,2,1]]}],"ό":[{"τ":[{},[0,2,1]]}]}],"σ":[{"σ":[{},[0,2,1]]}],"ϲ":[{"ϲ":[{},[0,2,1]]}],"τ":[{"τ":[{},[0,2,1]]}],"φ":[{"α":[{},[0,2,1]]}]}],"ή":[{"δ":[{},[0,2,1]],"κ":[{"ε":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ο":[{},[0,2,1]]}],"λ":[{"α":[{"τ":[{"ο":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}],"ν":[{".":[{},[0,2,1]]}],"ι":[{},[0,2,1]]}],"ε":[{".":[{},[0,2,1]]}],"α":[{},[0,2,1]]}]}],"ε":[{"ι":[{"π":[{},[0,2,1]]}]}],"ι":[{"κ":[{},[0,2,1]],"ο":[{},[0,2,1]],"α":[{},[0,2,1]],"π":[{},[0,2,1]]}]}],"μ":[{},[0,2,1]],"ν":[{"υ":[{},[0,2,1]]}],"ρ":[{"ε":[{"ι":[{},[0,2,1]]}],"ι":[{},[0,2,1]],"ο":[{"τ":[{},[0,2,1]]}]}],"σ":[{"σ":[{},[0,2,1]]}],"ϲ":[{"ϲ":[{},[0,2,1]]}],"τ":[{"τ":[{},[0,2,1]]}],"φ":[{"α":[{},[0,2,1]]}]}],"ή":[{"δ":[{},[0,2,1]],"κ":[{"ε":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ο":[{},[0,2,1]]}],"λ":[{"α":[{"τ":[{"ο":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}],"ν":[{".":[{},[0,2,1]]}],"ι":[{},[0,2,1]]}],"ε":[{".":[{},[0,2,1]]}],"α":[{},[0,2,1]]}]}],"ε":[{"ι":[{"π":[{},[0,2,1]]}]}],"ι":[{"κ":[{},[0,2,1]],"ο":[{},[0,2,1]],"α":[{},[0,2,1]],"π":[{},[0,2,1]]}]}],"μ":[{},[0,2,1]],"ν":[{"υ":[{},[0,2,1]]}],"ρ":[{"ε":[{"ι":[{},[0,2,1]]}],"ι":[{},[0,2,1]],"ο":[{"τ":[{},[0,2,1]]}]}],"σ":[{"σ":[{},[0,2,1]]}],"ϲ":[{"ϲ":[{},[0,2,1]]}],"τ":[{"τ":[{},[0,2,1]]}],"φ":[{"α":[{},[0,2,1]]}]}],"ί":[{"α":[{"τ":[{},[0,2,1]]}],"δ":[{"ι":[{"ο":[{},[0,2,1]],"α":[{},[0,2,1]]}],"ρ":[{"ο":[{"υ":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"ω":[{},[0,2,1]],"υ":[{"τ":[{},[0,2,1]]}]}]}],"ε":[{"ρ":[{},[0,2,1]]}],"κ":[{"η":[{},[0,3,2]]},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{"α":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}]}],"ο":[{"υ":[{},[0,2,1]]}],"π":[{"π":[{},[0,2,1]]}],"σ":[{"τ":[{},[0,3,2]],"χ":[{"υ":[{},[0,4,3]]},[0,3,2]]},[0,2,1]],"ϲ":[{"τ":[{},[0,3,2]],"χ":[{"υ":[{},[0,4,3]]},[0,3,2]]},[0,2,1]],"χ":[{},[0,2,1]],"ψ":[{},[0,2,1]]}],"ί":[{"α":[{"τ":[{},[0,2,1]]}],"δ":[{"ι":[{"ο":[{},[0,2,1]],"α":[{},[0,2,1]]}],"ρ":[{"ο":[{"υ":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"ω":[{},[0,2,1]],"υ":[{"τ":[{},[0,2,1]]}]}]}],"ε":[{"ρ":[{},[0,2,1]]}],"κ":[{"η":[{},[0,3,2]]},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{"α":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}]}],"ο":[{"υ":[{},[0,2,1]]}],"π":[{"π":[{},[0,2,1]]}],"σ":[{"τ":[{},[0,3,2]],"χ":[{"υ":[{},[0,4,3]]},[0,3,2]]},[0,2,1]],"ϲ":[{"τ":[{},[0,3,2]],"χ":[{"υ":[{},[0,4,3]]},[0,3,2]]},[0,2,1]],"χ":[{},[0,2,1]],"ψ":[{},[0,2,1]]}],"ι":[{"ά":[{"τ":[{},[0,2,1]]}],"ά":[{"τ":[{},[0,2,1]]}],"δ":[{"ί":[{"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"ί":[{"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}],"ι":[{"τ":[{},[0,2,1]]}],"ρ":[{"ύ":[{"τ":[{},[0,2,1]]}],"ύ":[{"τ":[{},[0,2,1]]}],"ω":[{"τ":[{},[0,2,1]]}],"ώ":[{"τ":[{},[0,2,1]]}],"ώ":[{"τ":[{},[0,2,1]]}]}]}],"έ":[{"ρ":[{"ω":[{},[0,3,2]]},[0,2,1]]}],"έ":[{"ρ":[{"ω":[{},[0,3,2]]},[0,2,1]]}],"ε":[{"ρ":[{"ά":[{"τ":[{},[0,2,1]]}],"ά":[{"τ":[{},[0,2,1]]}]}]}],"κ":[{"ή":[{},[0,3,2]],"ή":[{},[0,3,2]]},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{"ά":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}],"ά":[{"σ":[{"τ":[{},[0,2,1]]}],"ϲ":[{"τ":[{},[0,2,1]]}]}]}],"ο":[{"ύ":[{},[0,2,1]],"ύ":[{},[0,2,1]]}],"σ":[{"ᾶ":[{"τ":[{},[0,3,2]]}],"ά":[{"τ":[{},[0,3,2]]}],"ά":[{"τ":[{},[0,3,2]]}],"τ":[{"ο":[{"ρ":[{"η":[{},[0,4,3]],"ή":[{},[0,4,3]],"ή":[{},[0,4,3]]}]}],"ό":[{"ρ":[{"η":[{},[0,4,3]]}]}],"ό":[{"ρ":[{"η":[{},[0,4,3]]}]}]},[0,3,2]]},[0,2,1]],"ϲ":[{"ᾶ":[{"τ":[{},[0,3,2]]}],"ά":[{"τ":[{},[0,3,2]]}],"ά":[{"τ":[{},[0,3,2]]}],"τ":[{"ο":[{"ρ":[{"η":[{},[0,4,3]],"ή":[{},[0,4,3]],"ή":[{},[0,4,3]]}]}],"ό":[{"ρ":[{"η":[{},[0,4,3]]}]}],"ό":[{"ρ":[{"η":[{},[0,4,3]]}]}]},[0,3,2]]},[0,2,1]],"χ":[{"ν":[{"ε":[{"ύ":[{"τ":[{},[0,2,1]]}],"ύ":[{"τ":[{},[0,2,1]]}]}]}]}],"ψ":[{},[0,2,1]]}],"ό":[{"δ":[{"ε":[{},[0,2,1]]}],"ζ":[{},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{"β":[{"ρ":[{"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}]}],"ϐ":[{"ρ":[{"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}]}],"ι":[{"χ":[{},[0,2,1]]}],"ο":[{"υ":[{".":[{},[0,3,2]],"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}],"ι":[{"ν":[{".":[{},[0,2,2]]}],"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}]},[0,2,1]],"ῳ":[{".":[{},[0,3,2]]}],"ω":[{".":[{},[0,3,2]],"ν":[{".":[{},[0,3,2]]}]}]}],"ν":[{},[0,2,1]],"π":[{},[0,2,1]],"ρ":[{"θ":[{},[0,3,2]]},[0,2,1]],"σ":[{"ι":[{},[0,2,1]],"μ":[{},[0,2,1]],"φ":[{"ρ":[{},[0,2,1]]}]}],"ϲ":[{"ι":[{},[0,2,1]],"μ":[{},[0,2,1]],"φ":[{"ρ":[{},[0,2,1]]}]}],"χ":[{"ε":[{"υ":[{"τ":[{},[0,2,1]]}]}],"λ":[{},[0,2,1]]}],"ψ":[{},[0,2,1]]}],"ό":[{"δ":[{"ε":[{},[0,2,1]]}],"ζ":[{},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{"β":[{"ρ":[{"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}]}],"ϐ":[{"ρ":[{"ο":[{},[0,2,1]],"ω":[{},[0,2,1]]}]}],"ι":[{"χ":[{},[0,2,1]]}],"ο":[{"υ":[{".":[{},[0,3,2]],"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}],"ι":[{"ν":[{".":[{},[0,2,2]]}],"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}]},[0,2,1]],"ῳ":[{".":[{},[0,3,2]]}],"ω":[{".":[{},[0,3,2]],"ν":[{".":[{},[0,3,2]]}]}]}],"ν":[{},[0,2,1]],"π":[{},[0,2,1]],"ρ":[{"θ":[{},[0,3,2]]},[0,2,1]],"σ":[{"ι":[{},[0,2,1]],"μ":[{},[0,2,1]],"φ":[{"ρ":[{},[0,2,1]]}]}],"ϲ":[{"ι":[{},[0,2,1]],"μ":[{},[0,2,1]],"φ":[{"ρ":[{},[0,2,1]]}]}],"χ":[{"ε":[{"υ":[{"τ":[{},[0,2,1]]}]}],"λ":[{},[0,2,1]]}],"ψ":[{},[0,2,1]]}],"ο":[{"δ":[{"έ":[{},[0,2,1]],"έ":[{},[0,2,1]]}],"ι":[{"κ":[{"ε":[{},[0,2,1]],"ο":[{"ν":[{},[0,2,1]]}],"τ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}]}],"μ":[{"ώ":[{"κ":[{},[0,2,1]]}],"ώ":[{"κ":[{},[0,2,1]]}],"ω":[{"κ":[{},[0,2,1]]}]}],"ν":[{},[0,2,1]]}],"ί":[{"κ":[{"τ":[{},[0,2,1]]},[0,2,1]],"μ":[{"ω":[{"κ":[{},[0,2,1]]}]}],"ν":[{},[0,2,1]],"σ":[{"τ":[{"ρ":[{},[0,2,1]]}]}],"ϲ":[{"τ":[{"ρ":[{},[0,2,1]]}]}]}],"ί":[{"κ":[{"τ":[{},[0,2,1]]},[0,2,1]],"μ":[{"ω":[{"κ":[{},[0,2,1]]}]}],"ν":[{},[0,2,1]],"σ":[{"τ":[{"ρ":[{},[0,2,1]]}]}],"ϲ":[{"τ":[{"ρ":[{},[0,2,1]]}]}]}],"λ":[{"κ":[{},[0,3,2]],"ο":[{},[0,3,2]]},[0,2,1]],"μ":[{"β":[{"ρ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ῖ":[{},[0,2,1]]}]}],"ϐ":[{"ρ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ῖ":[{},[0,2,1]]}]}],"ή":[{"λ":[{},[0,2,1]]}],"ή":[{"λ":[{},[0,2,1]]}],"η":[{"λ":[{},[0,2,1]]}],"ί":[{"λ":[{},[0,2,1]]}],"ί":[{"λ":[{},[0,2,1]]}],"ι":[{"λ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"ό":[{},[0,2,1]],"ό":[{},[0,2,1]],"ο":[{"θ":[{},[0,3,2]]},[0,2,1]]}],"ν":[{},[0,2,1]],"ρ":[{"γ":[{"ά":[{"ζ":[{},[0,3,2]]}],"ά":[{"ζ":[{},[0,3,2]]}]}],"μ":[{"ά":[{},[0,3,2]],"ά":[{},[0,3,2]]}],"τ":[{},[0,3,2]],"ύ":[{},[0,3,2]],"ύ":[{},[0,3,2]]},[0,2,1]],"σ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ι":[{},[0,2,1]],"φ":[{"ρ":[{},[0,2,1]]}]}],"ϲ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"ι":[{},[0,2,1]],"φ":[{"ρ":[{},[0,2,1]]}]}],"ύ":[{"α":[{},[0,2,1]],"σ":[{"ι":[{},[0,2,1]]}],"ϲ":[{"ι":[{},[0,2,1]]}],"τ":[{},[0,2,1]]}],"ύ":[{"α":[{},[0,2,1]],"σ":[{"ι":[{},[0,2,1]]}],"ϲ":[{"ι":[{},[0,2,1]]}],"τ":[{},[0,2,1]]}],"υ":[{"ά":[{},[0,2,1]],"ά":[{},[0,2,1]],"σ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}],"ϲ":[{"ί":[{},[0,2,1]],"ί":[{},[0,2,1]]}],"τ":[{},[0,2,1]]}],"φ":[{"θ":[{},[0,2,1]]}],"χ":[{"ε":[{"ύ":[{"τ":[{},[0,2,1]]}],"ύ":[{"τ":[{},[0,2,1]]}]}]}],"ψ":[{},[0,2,1]]}],"τ":[{"α":[{"ν":[{"ι":[{"σ":[{},[0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,2,1]]}],"ί":[{"σ":[{},[0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,2,1]]}],"ί":[{"σ":[{},[0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,2,1]]}]}]}],"ε":[{"ι":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}],"κ":[{},[0,0,0,0,2,1]],"ν":[{},[0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,2,1]]}],"ι":[{"δ":[{"υ":[{"σ":[{},[0,0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,0,2,1]]}]}],"π":[{"α":[{"ρ":[{"ε":[{"κ":[{},[0,0,0,0,0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,0,0,0,0,2,1]]}]}]}],"ρ":[{"ο":[{"σ":[{"κ":[{"υ":[{},[0,0,0,0,0,0,0,0,3,2]]}]},[0,0,0,0,0,0,0,2,1]],"ϲ":[{"κ":[{"υ":[{},[0,0,0,0,0,0,0,0,3,2]]}]},[0,0,0,0,0,0,0,2,1]]}]}]}],"σ":[{"ύ":[{"ν":[{},[0,0,0,0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,0,0,0,2,1]]}]}],"ϲ":[{"ύ":[{"ν":[{},[0,0,0,0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,0,0,0,2,1]]}]}]}]}],"ύ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]},[0,2,1]],"ύ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]},[0,2,1]],"υ":[{"μ":[{},[0,3,2]],"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]],"π":[{"έ":[{"ρ":[{},[0,2,1,0,0,2,1]]}],"έ":[{"ρ":[{},[0,2,1,0,0,2,1]]}],"ε":[{"ρ":[{},[0,2,1,0,0,2,1]]}]}]},[0,2,1]],"ῴ":[{"δ":[{},[0,2,1]]}],"ώ":[{"δ":[{"υ":[{},[0,2,1]]}],"ι":[{},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{},[0,2,1]],"ν":[{},[0,2,1]],"ρ":[{},[0,2,1]],"τ":[{"ο":[{},[0,2,1]]}],"χ":[{"υ":[{},[0,2,1]]}]}],"ώ":[{"δ":[{"υ":[{},[0,2,1]]}],"ι":[{},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{},[0,2,1]],"ν":[{},[0,2,1]],"ρ":[{},[0,2,1]],"τ":[{"ο":[{},[0,2,1]]}],"χ":[{"υ":[{},[0,2,1]]}]}],"ω":[{"δ":[{"ύ":[{},[0,2,1]],"ύ":[{},[0,2,1]]}],"ί":[{},[0,2,1]],"ί":[{},[0,2,1]],"λ":[{},[0,2,1]],"μ":[{},[0,2,1]],"ν":[{},[0,2,1]],"ρ":[{},[0,2,1]],"φ":[{"έ":[{"λ":[{},[0,2,1]]}],"έ":[{"λ":[{},[0,2,1]]}],"ε":[{"λ":[{},[0,2,1]]}]}],"χ":[{"ύ":[{},[0,2,1]],"ύ":[{},[0,2,1]]}]}]}],"π":[{"α":[{"ν":[{"α":[{"ι":[{},[0,0,0,2,1]]}],"ο":[{"ύ":[{"ρ":[{},[0,0,0,2,1]]}],"ύ":[{"ρ":[{},[0,0,0,2,1]]}]}]}]}],"ά":[{"ν":[{"ο":[{"υ":[{},[0,0,0,2,1]]}]}]}],"ά":[{"ν":[{"ο":[{"υ":[{},[0,0,0,2,1]]}]}]}],"ε":[{"κ":[{"λ":[{},[0,0,0,2,1]]}]}],"ο":[{"σ":[{"υ":[{"ν":[{},[0,0,0,0,0,2,1]]}]}],"ϲ":[{"υ":[{"ν":[{},[0,0,0,0,0,2,1]]}]}]}],"ρ":[{"ό":[{"σ":[{"κ":[{"ε":[{},[0,0,0,0,3,2]],"ο":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]],"ϲ":[{"κ":[{"ε":[{},[0,0,0,0,3,2]],"ο":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]]}],"ό":[{"σ":[{"κ":[{"ε":[{},[0,0,0,0,3,2]],"ο":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]],"ϲ":[{"κ":[{"ε":[{},[0,0,0,0,3,2]],"ο":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]]}],"ο":[{"σ":[{"κ":[{"έ":[{},[0,0,0,0,3,2]],"έ":[{},[0,0,0,0,3,2]],"ό":[{},[0,0,0,0,3,2]],"ό":[{},[0,0,0,0,3,2]]}],"τ":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"ϲ":[{"κ":[{"έ":[{},[0,0,0,0,3,2]],"έ":[{},[0,0,0,0,3,2]],"ό":[{},[0,0,0,0,3,2]],"ό":[{},[0,0,0,0,3,2]]}],"τ":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]]}]}]}],"ρ":[{"ρ":[{"ε":[{"ν":[{"ω":[{},[0,0,0,0,2,1]]}]}]}],"χ":[{"ι":[{"σ":[{"υ":[{"ν":[{},[0,0,0,0,0,0,2,1]]}]}],"ϲ":[{"υ":[{"ν":[{},[0,0,0,0,0,0,2,1]]}]}]}]}]}],"σ":[{"τ":[{"ε":[{"ρ":[{"ω":[{},[0,0,0,0,2,1]]}]}]}],"ύ":[{"ν":[{},[0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,2,1]]}]}],"ϲ":[{"τ":[{"ε":[{"ρ":[{"ω":[{},[0,0,0,0,2,1]]}]}]}],"ύ":[{"ν":[{},[0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,2,1]]}]}],"ξ":[{"ύ":[{"ν":[{},[0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,2,1]]}]}],"ω":[{"σ":[{"φ":[{},[0,0,2,1]]}],"ϲ":[{"φ":[{},[0,0,2,1]]}]}]},[0,1]],"ἁ":[{"ι":[{},[0,3]],"υ":[{},[0,3]],"λ":[{"ό":[{"σ":[{},[0,0,0,2,1]],"ϲ":[{},[0,0,0,2,1]]}],"ό":[{"σ":[{},[0,0,0,2,1]],"ϲ":[{},[0,0,0,2,1]]}],"ο":[{"σ":[{},[0,0,0,2,1]],"ϲ":[{},[0,0,0,2,1]]}]}],"π":[{"α":[{"ξ":[{},[0,0,0,2,1]]}],"ε":[{"ρ":[{},[0,0,0,2,1]]}]}],"ρ":[{"π":[{"α":[{"ξ":[{},[0,0,0,0,2,1]]}]}]}]},[0,1]],"ἂ":[{},[0,1]],"ἃ":[{},[0,1]],"ἄ":[{"ν":[{"α":[{"γ":[{"ν":[{},[0,2,1]]}],"θ":[{"λ":[{},[0,2,1]]}],"ι":[{"μ":[{},[0,2,1]]}],"λ":[{"κ":[{},[0,2,1]],"μ":[{},[0,2,1]],"ο":[{},[0,2,1]],"ε":[{".":[{},[0,2,1]]}],"τ":[{},[0,2,1]]}],"ν":[{"δ":[{},[0,2,1]]}],"ρ":[{},[0,2,1]],"σ":[{"π":[{"ι":[{},[0,2,1]]}]}],"ϲ":[{"π":[{"ι":[{},[0,2,1]]}]}],"τ":[{"ο":[{"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}],"ν":[{".":[{},[0,2,1]]}],"ι":[{".":[{},[0,2,1]]}]}],"ε":[{},[0,2,1]]}],"υ":[{"δ":[{},[0,2,1]],"λ":[{},[0,2,1]]}],"φ":[{"ρ":[{},[0,2,1]]}]}],"ε":[{"λ":[{"κ":[{"τ":[{},[0,2,1]]}]}],"ρ":[{"γ":[{},[0,2,1]]}],"υ":[{"κ":[{},[0,2,1]]}]}],"ι":[{"δ":[{"ρ":[{"ο":[{"ς":[{},[0,2,1]],"ϲ":[{},[0,2,1]],"σ":[{},[0,2,1]],"ν":[{},[0,2,1]],"ι":[{},[0,2,1]]}],"ε":[{},[0,2,1]]}]}],"κ":[{},[0,2,1]],"π":[{"π":[{},[0,2,1]]}],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]],"χ":[{},[0,2,1]]}],"ο":[{"ζ":[{},[0,2,1]],"ι":[{"κ":[{"τ":[{},[0,2,1]]},[0,2,1]],"ν":[{},[0,2,1]],"σ":[{"τ":[{"ρ":[{},[0,2,1]]}]}],"ϲ":[{"τ":[{"ρ":[{},[0,2,1]]}]}]}],"λ":[{},[0,2,1]],"μ":[{"β":[{"ρ":[{"ο":[{},[0,2,1]],"α":[{},[0,2,1]]}]}],"ϐ":[{"ρ":[{"ο":[{},[0,2,1]],"α":[{},[0,2,1]]}]}]}],"π":[{},[0,2,1]],"ρ":[{"θ":[{},[0,3,2]]},[0,2,1]],"σ":[{"μ":[{},[0,2,1]]}],"ϲ":[{"μ":[{},[0,2,1]]}],"χ":[{"λ":[{},[0,2,1]]}],"ψ":[{},[0,2,1]]}],"ῳ":[{"δ":[{},[0,2,1]]}],"ω":[{"ρ":[{},[0,2,1]],"τ":[{"ο":[{},[0,2,1]]}]}]}]},[0,1]],"ἅ":[{"σ":[{"τ":[{"ι":[{"ν":[{"α":[{"ς":[{},[0,2,1]]}]}]}]}]}],"ϲ":[{"τ":[{"ι":[{"ν":[{"α":[{"ϲ":[{},[0,2,1]]}]}]}]}]}]},[0,1]],"ἆ":[{},[0,1]],"ἇ":[{},[0,1]],"ἐ":[{"ι":[{},[0,3]],"υ":[{},[0,3]],"δ":[{"υ":[{"σ":[{"τ":[{},[0,0,0,2,1]]}],"ϲ":[{"τ":[{},[0,0,0,2,1]]}]}]}],"κ":[{"λ":[{"ή":[{"θ":[{"η":[{},[0,3,2]]}],"ρ":[{},[0,3,2]]}],"ή":[{"θ":[{"η":[{},[0,3,2]]}],"ρ":[{},[0,3,2]]}],"ά":[{"ζ":[{},[0,3,2]],"γ":[{},[0,3,2]],"ο":[{},[0,3,2]],"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]],"π":[{"τ":[{},[0,4,3]]},[0,3,2]]}],"ά":[{"ζ":[{},[0,3,2]],"γ":[{},[0,3,2]],"ο":[{},[0,3,2]],"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]],"π":[{"τ":[{},[0,4,3]]},[0,3,2]]}],"α":[{"ί":[{},[0,3,2]],"ί":[{},[0,3,2]],"ύ":[{},[0,3,2]],"ύ":[{},[0,3,2]],"π":[{"τ":[{},[0,4,3]]},[0,3,2]]}],"ε":[{"ί":[{"π":[{},[0,4,3]],"ψ":[{},[0,4,3]]},[0,3,2]],"ί":[{"π":[{},[0,4,3]],"ψ":[{},[0,4,3]]},[0,3,2]],"φ":[{},[0,3,2]]}],"ῄ":[{},[0,3,2]],"έ":[{"φ":[{},[0,3,2]]}],"έ":[{"φ":[{},[0,3,2]]}],"η":[{"ρ":[{},[0,3,2]]}],"ί":[{"ν":[{},[0,3,2]]}],"ί":[{"ν":[{},[0,3,2]]}],"ι":[{"ν":[{},[0,3,2]]}],"ύ":[{"σ":[{"ε":[{"ω":[{},[0,4,3]],"ι":[{},[0,4,3]],"ο":[{"ι":[{},[0,4,3]]}],"σ":[{"ι":[{},[0,4,3]]}]}]}],"ϲ":[{"ε":[{"ω":[{},[0,4,3]],"ι":[{},[0,4,3]],"ο":[{"ι":[{},[0,4,3]]}],"ϲ":[{"ι":[{},[0,4,3]]}]}]}]},[0,3,2]],"ύ":[{"σ":[{"ε":[{"ω":[{},[0,4,3]],"ι":[{},[0,4,3]],"ο":[{"ι":[{},[0,4,3]]}],"σ":[{"ι":[{},[0,4,3]]}]}]}],"ϲ":[{"ε":[{"ω":[{},[0,4,3]],"ι":[{},[0,4,3]],"ο":[{"ι":[{},[0,4,3]]}],"ϲ":[{"ι":[{},[0,4,3]]}]}]}]},[0,3,2]],"ό":[{"μ":[{},[0,3,2]]}],"ό":[{"μ":[{},[0,3,2]]}]},[0,2,1]],"κ":[{"λ":[{"έ":[{"π":[{},[0,3,2]],"ψ":[{},[0,3,2]]}],"έ":[{"π":[{},[0,3,2]],"ψ":[{},[0,3,2]]}],"ώ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ώ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}]}]}],"μ":[{},[0,2,1]],"ν":[{"α":[{"ί":[{},[0,3,2]],"ί":[{},[0,3,2]]}],"ή":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ή":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"υ":[{},[0,3,2]]},[0,2,1]],"ρ":[{"ά":[{"δ":[{},[0,3,2]],"ζ":[{},[0,3,2]],"γ":[{},[0,3,2]],"τ":[{},[0,3,2]],"ν":[{},[0,3,2]],"α":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"ά":[{"δ":[{},[0,3,2]],"ζ":[{},[0,3,2]],"γ":[{},[0,3,2]],"τ":[{},[0,3,2]],"ν":[{},[0,3,2]],"α":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"α":[{"δ":[{},[0,3,2]],"τ":[{},[0,3,2]],"ύ":[{"γ":[{},[0,3,2]]}],"ύ":[{"γ":[{},[0,3,2]]}],"υ":[{"γ":[{},[0,3,2]]}],"ί":[{},[0,3,2]],"ί":[{},[0,3,2]],"ά":[{},[0,3,2]],"ά":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"ή":[{"η":[{},[0,3,2]],"μ":[{},[0,3,2]]}],"ή":[{"η":[{},[0,3,2]],"μ":[{},[0,3,2]]}],"έ":[{"κ":[{},[0,3,2]],"ξ":[{},[0,3,2]],"μ":[{},[0,3,2]]}],"έ":[{"κ":[{},[0,3,2]],"ξ":[{},[0,3,2]],"μ":[{},[0,3,2]]}],"ε":[{"μ":[{},[0,3,2]]}],"η":[{"μ":[{},[0,3,2]]}],"ί":[{"ν":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"ί":[{"ν":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"ό":[{"τ":[{},[0,3,2]]}],"ό":[{"τ":[{},[0,3,2]]}],"ο":[{"τ":[{},[0,3,2]],"ύ":[{},[0,3,2]],"ύ":[{},[0,3,2]]}],"ύ":[{"π":[{},[0,3,2]],"ψ":[{},[0,3,2]],"β":[{},[0,3,2]],"ϐ":[{},[0,3,2]],"φ":[{},[0,3,2]]}],"ύ":[{"π":[{},[0,3,2]],"ψ":[{},[0,3,2]],"β":[{},[0,3,2]],"ϐ":[{},[0,3,2]],"φ":[{},[0,3,2]]}],"υ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ώ":[{"ζ":[{},[0,3,2]],"ξ":[{},[0,3,2]]}],"ώ":[{"ζ":[{},[0,3,2]],"ξ":[{},[0,3,2]]}]},[0,2,1]],"τ":[{"α":[{"θ":[{},[0,2,1]],"ν":[{},[0,2,1]],"ρ":[{},[0,2,1]]}],"ά":[{"μ":[{"ν":[{},[0,2,1]]}],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ά":[{"μ":[{"ν":[{},[0,2,1]]}],"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}],"ε":[{"ί":[{"ν":[{},[0,3,2]]}],"ί":[{"ν":[{},[0,3,2]]}]},[0,2,1]],"έ":[{},[0,2,1]],"έ":[{},[0,2,1]],"ή":[{"κ":[{},[0,2,1]]}],"ή":[{"κ":[{},[0,2,1]]}],"ι":[{},[0,2,1]],"ί":[{"ζ":[{},[0,3,2]],"σ":[{"α":[{},[0,3,2]]}],"ϲ":[{"α":[{},[0,3,2]]}]},[0,2,1]],"ί":[{"ζ":[{},[0,3,2]],"σ":[{"α":[{},[0,3,2]]}],"ϲ":[{"α":[{},[0,3,2]]}]},[0,2,1]],"ό":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]},[0,2,1]],"ό":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]},[0,2,1]],"ο":[{},[0,2,1]],"ὸ":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}],"ρ":[{},[0,2,1]],"ύ":[{"π":[{"ο":[{"υ":[{".":[{},[0,2,1]],"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ι":[{".":[{},[0,2]],"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ῳ":[{".":[{},[0,2,1]]}],"ω":[{".":[{},[0,2,1]],"ν":[{".":[{},[0,2,1]]}]}]}]}],"ύ":[{"π":[{"ο":[{"υ":[{".":[{},[0,2,1]],"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}],"ι":[{".":[{},[0,2]],"ς":[{".":[{},[0,2,1]]}],"ϲ":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}],"ῳ":[{".":[{},[0,2,1]]}],"ω":[{".":[{},[0,2,1]],"ν":[{".":[{},[0,2,1]]}]}]}]}],"υ":[{},[0,2,1]]}]}],"ν":[{"ά":[{"κ":[{"ι":[{"ς":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}]}],"ρ":[{"ω":[{"ν":[{".":[{},[0,3,2]]}]}],"ο":[{"ι":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}]}],"ε":[{"ε":[{},[0,3,2]]}],"ι":[{"ε":[{},[0,3,2]]}]}],"σ":[{"σ":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"ϲ":[{"ϲ":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"τ":[{},[0,3,2]]}],"ά":[{"κ":[{"ι":[{"ς":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}]}],"ρ":[{"ω":[{"ν":[{".":[{},[0,3,2]]}]}],"ο":[{"ι":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}]}],"ε":[{"ε":[{},[0,3,2]]}],"ι":[{"ε":[{},[0,3,2]]}]}],"σ":[{"σ":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"ϲ":[{"ϲ":[{},[0,3,2]],"θ":[{},[0,3,2]]}],"τ":[{},[0,3,2]]}],"α":[{"κ":[{"ι":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ό":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ό":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ο":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}]}],"ρ":[{"η":[{"φ":[{},[0,3,2]]}],"α":[{"ρ":[{},[0,4,3]]}],"έ":[{"ω":[{},[0,3,2]],"α":[{},[0,3,2]]}],"έ":[{"ω":[{},[0,3,2]],"α":[{},[0,3,2]]}],"ε":[{"ά":[{},[0,3,2]],"ά":[{},[0,3,2]]}],"ί":[{"ω":[{},[0,3,2]],"α":[{},[0,3,2]]}],"ί":[{"ω":[{},[0,3,2]],"α":[{},[0,3,2]]}],"ι":[{"ά":[{},[0,3,2]],"ά":[{},[0,3,2]]}]}],"σ":[{"θ":[{},[0,3,2]]}],"ϲ":[{"θ":[{},[0,3,2]]}]}],"δ":[{"υ":[{"σ":[{"τ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"τ":[{},[0,0,0,0,2,1]]}]}]}],"έ":[{"γ":[{"κ":[{},[0,3,2]]}],"π":[{"ε":[{"ι":[{},[0,3,2]]}]}],"χ":[{"θ":[{},[0,3,2]]}]}],"έ":[{"γ":[{"κ":[{},[0,3,2]]}],"π":[{"ε":[{"ι":[{},[0,3,2]]}]}],"χ":[{"θ":[{},[0,3,2]]}]}],"ε":[{"γ":[{"κ":[{},[0,3,2]]}],"ῖ":[{"κ":[{},[0,3,2]]}],"ι":[{"κ":[{},[0,3,2]]}],"ί":[{"κ":[{},[0,3,2]],"μ":[{},[0,3,2]]}],"ί":[{"κ":[{},[0,3,2]],"μ":[{},[0,3,2]]}],"μ":[{"έ":[{"σ":[{"σ":[{},[0,3,2]]}],"ϲ":[{"ϲ":[{},[0,3,2]]}]}],"έ":[{"σ":[{"σ":[{},[0,3,2]]}],"ϲ":[{"ϲ":[{},[0,3,2]]}]}],"ή":[{"θ":[{},[0,3,2]]}],"ή":[{"θ":[{},[0,3,2]]}]}],"ν":[{"ή":[{},[0,3,2]],"ή":[{},[0,3,2]]}],"ό":[{},[0,3,2]],"ό":[{},[0,3,2]],"ὸ":[{},[0,3,2]],"ο":[{},[0,3,2]],"ῶ":[{},[0,3,2]],"ά":[{},[0,3,2]],"ά":[{},[0,3,2]],"ὰ":[{},[0,3,2]],"ᾶ":[{},[0,3,2]],"ύ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ύ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"χ":[{"θ":[{},[0,3,2]]}]}],"ή":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]],"ν":[{"ο":[{},[0,3,2]]}]}],"ή":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]],"ν":[{"ο":[{},[0,3,2]]}]}],"η":[{"ή":[{},[0,3,2]],"ή":[{},[0,3,2]],"ὴ":[{},[0,3,2]],"ε":[{"ί":[{},[0,3,2]],"ί":[{},[0,3,2]]}],"ο":[{},[0,3,2]],"ῶ":[{},[0,3,2]],"έ":[{},[0,3]],"έ":[{},[0,3]]}],"ί":[{"δ":[{"ρ":[{},[0,4,3]]}],"ζ":[{},[0,4,3]],"η":[{},[0,4,3]],"ε":[{"μ":[{"ε":[{"ν":[{".":[{},[0,4,3]]}]}]}]}],"ω":[{".":[{},[0,4,3]]}],"π":[{"π":[{},[0,4,3]],"τ":[{},[0,4,3]]}],"ψ":[{},[0,4,3]],"σ":[{"σ":[{},[0,4,3]],"τ":[{},[0,4,3]],"χ":[{},[0,4,3]]}],"ϲ":[{"ϲ":[{},[0,4,3]],"τ":[{},[0,4,3]],"χ":[{},[0,4,3]]}]},[0,3,2]],"ί":[{"δ":[{"ρ":[{},[0,4,3]]}],"ζ":[{},[0,4,3]],"η":[{},[0,4,3]],"ε":[{"μ":[{"ε":[{"ν":[{".":[{},[0,4,3]]}]}]}]}],"ω":[{".":[{},[0,4,3]]}],"π":[{"π":[{},[0,4,3]],"τ":[{},[0,4,3]]}],"ψ":[{},[0,4,3]],"σ":[{"σ":[{},[0,4,3]],"τ":[{},[0,4,3]],"χ":[{},[0,4,3]]}],"ϲ":[{"ϲ":[{},[0,4,3]],"τ":[{},[0,4,3]],"χ":[{},[0,4,3]]}]},[0,3,2]],"ι":[{"α":[{"ύ":[{"σ":[{},[0,5,4]],"ϲ":[{},[0,5,4]]},[0,4,3]],"ύ":[{"σ":[{},[0,5,4]],"ϲ":[{},[0,5,4]]},[0,4,3]],"υ":[{"σ":[{},[0,5,4]],"ϲ":[{},[0,5,4]]}]}],"δ":[{"ρ":[{},[0,4,3]]}],"έ":[{"τ":[{"ο":[{"ν":[{".":[{},[0,4,3]]}]}]}]}],"έ":[{"τ":[{"ο":[{"ν":[{".":[{},[0,4,3]]}]}]}]}],"π":[{"π":[{},[0,4,3]]}],"σ":[{"τ":[{},[0,4,3]],"χ":[{},[0,4,3]]}],"ϲ":[{"τ":[{},[0,4,3]],"χ":[{},[0,4,3]]}]},[0,3,2]],"ό":[{"σ":[{"ε":[{},[0,3,2]]}],"ϲ":[{"ε":[{},[0,3,2]]}]}],"ό":[{"σ":[{"ε":[{},[0,3,2]]}],"ϲ":[{"ε":[{},[0,3,2]]}]}],"υ":[{"ά":[{"λ":[{},[0,3,2]]}],"ά":[{"λ":[{},[0,3,2]]}],"α":[{"λ":[{},[0,3,2]]}],"ξ":[{},[0,3,2]],"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]],"ώ":[{},[0,3,2]],"ώ":[{},[0,3,2]],"ὼ":[{},[0,3,2]],"ό":[{"ο":[{},[0,3,2]]}],"ό":[{"ο":[{},[0,3,2]]}],"ο":[{"ῦ":[{"ς":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}]}]}],"ύ":[{"ξ":[{},[0,3,2]],"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ύ":[{"ξ":[{},[0,3,2]],"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}]},[0,2,1]],"ξ":[{"ή":[{"ρ":[{},[0,3,2]]}],"ή":[{"ρ":[{},[0,3,2]]}],"η":[{"ρ":[{},[0,3,2]]}],"υ":[{"ν":[{},[0,3,2,2,1]],"ρ":[{},[0,3,2]]}],"ύ":[{"ρ":[{},[0,3,2]]}],"ύ":[{"ρ":[{},[0,3,2]]}]},[0,2,1]],"π":[{"ε":[{"ί":[{"σ":[{"α":[{"τ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,3,2]],"ε":[{},[0,0,0,0,3,2]]}],"μ":[{"ε":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}],"σ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,0,0,3,2]]}]}]}]}],"ω":[{".":[{},[0,0,0,0,3,2]]}],"θ":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"ϲ":[{"α":[{"τ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,3,2]],"ε":[{},[0,0,0,0,3,2]]}],"μ":[{"ε":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,0,0,3,2]]}]}]}]}],"ω":[{".":[{},[0,0,0,0,3,2]]}],"θ":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]]}],"ί":[{"σ":[{"α":[{"τ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,3,2]],"ε":[{},[0,0,0,0,3,2]]}],"μ":[{"ε":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}],"σ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,0,0,3,2]]}]}]}]}],"ω":[{".":[{},[0,0,0,0,3,2]]}],"θ":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"ϲ":[{"α":[{"τ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,3,2]],"ε":[{},[0,0,0,0,3,2]]}],"μ":[{"ε":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,0,0,3,2]]}]}]}]}],"ω":[{".":[{},[0,0,0,0,3,2]]}],"θ":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]]}],"ι":[{"σ":[{"ά":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,0,0,3,2]]}]}]}]}]}],"ά":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,0,0,3,2]]}]}]}]}]}],"θ":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"ϲ":[{"ά":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,0,0,3,2]]}]}]}]}]}],"ά":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,0,0,3,2]]}]}]}]}]}],"θ":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]]}],"κ":[{"τ":[{"ε":[{"ί":[{},[0,0,0,2,1]],"ί":[{},[0,0,0,2,1]]}],"ρ":[{},[0,0,0,2,1]]}]}],"ξ":[{},[0,0,0,2,1]],"σ":[{"β":[{},[0,0,0,2,1]],"ϐ":[{},[0,0,0,2,1]]}],"ϲ":[{"β":[{},[0,0,0,2,1]],"ϐ":[{},[0,0,0,2,1]]}]}],"έ":[{"κ":[{"τ":[{"ε":[{"ι":[{},[0,0,0,2,1]]}],"ρ":[{},[0,0,0,2,1]]}]}]}],"έ":[{"κ":[{"τ":[{"ε":[{"ι":[{},[0,0,0,2,1]]}],"ρ":[{},[0,0,0,2,1]]}]}]}],"ι":[{"π":[{"ρ":[{"ό":[{"σ":[{"θ":[{},[0,0,0,0,0,0,2,1]]}],"ϲ":[{"θ":[{},[0,0,0,0,0,0,2,1]]}]}],"ό":[{"σ":[{"θ":[{},[0,0,0,0,0,0,2,1]]}],"ϲ":[{"θ":[{},[0,0,0,0,0,0,2,1]]}]}],"ο":[{"σ":[{"θ":[{},[0,0,0,0,0,0,2,1]]}],"ϲ":[{"θ":[{},[0,0,0,0,0,0,2,1]]}]}]}]}],"σ":[{"υ":[{"ν":[{},[0,0,0,0,0,2,1]]}]}],"ϲ":[{"υ":[{"ν":[{},[0,0,0,0,0,2,1]]}]}]}]}],"σ":[{"ά":[{"ω":[{},[0,3,2]]}],"ά":[{"ω":[{},[0,3,2]]}],"η":[{"μ":[{},[0,3,2]]}],"θ":[{"έ":[{"σ":[{},[0,4,3]]}],"έ":[{"σ":[{},[0,4,3]]}]},[0,3,2]],"ι":[{"γ":[{},[0,3,2]]}],"κ":[{"ά":[{},[0,4,3]],"ά":[{},[0,4,3]],"α":[{},[0,4,3]]},[0,3,2]],"μ":[{"ὲ":[{"ν":[{".":[{},[0,3,2]]}]}],"έ":[{"ν":[{".":[{},[0,3,2]]}]}],"έ":[{"ν":[{".":[{},[0,3,2]]}]}]}],"τ":[{},[0,3,2]],"ό":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,3,2]]}]}]},[0,3,2]]}],"ό":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,3,2]]}]}]},[0,3,2]]}],"ο":[{"ί":[{"μ":[{"η":[{"ν":[{},[0,3,2]]}]}]}],"ί":[{"μ":[{"η":[{"ν":[{},[0,3,2]]}]}]}],"μ":[{},[0,3,2]],"ῦ":[{},[0,3,2]],"ύ":[{},[0,3,2]],"ύ":[{},[0,3,2]],"υ":[{},[0,3,2]]}],"υ":[{"ν":[{},[0,0,0,2,1]]},[0,3,2]],"ύ":[{"ν":[{},[0,0,0,2,1]]},[0,3,2]],"ύ":[{"ν":[{},[0,0,0,2,1]]},[0,3,2]],"χ":[{"έ":[{},[0,4,3]],"έ":[{},[0,4,3]]},[0,3,2]],"ώ":[{},[0,3,2]],"ώ":[{},[0,3,2]],"ω":[{},[0,3,2]]},[0,2,1]],"ϲ":[{"ά":[{"ω":[{},[0,3,2]]}],"ά":[{"ω":[{},[0,3,2]]}],"η":[{"μ":[{},[0,3,2]]}],"θ":[{"έ":[{"ϲ":[{},[0,4,3]]}],"έ":[{"ϲ":[{},[0,4,3]]}]},[0,3,2]],"ι":[{"γ":[{},[0,3,2]]}],"κ":[{"ά":[{},[0,4,3]],"ά":[{},[0,4,3]],"α":[{},[0,4,3]]},[0,3,2]],"μ":[{"ὲ":[{"ν":[{".":[{},[0,3,2]]}]}],"έ":[{"ν":[{".":[{},[0,3,2]]}]}],"έ":[{"ν":[{".":[{},[0,3,2]]}]}]}],"τ":[{},[0,3,2]],"ό":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,3,2]]}]}]},[0,3,2]]}],"ό":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,3,2]]}]}]},[0,3,2]]}],"ο":[{"ί":[{"μ":[{"η":[{"ν":[{},[0,3,2]]}]}]}],"ί":[{"μ":[{"η":[{"ν":[{},[0,3,2]]}]}]}],"μ":[{},[0,3,2]],"ῦ":[{},[0,3,2]],"ύ":[{},[0,3,2]],"ύ":[{},[0,3,2]],"υ":[{},[0,3,2]]}],"υ":[{"ν":[{},[0,0,0,2,1]]},[0,3,2]],"ύ":[{"ν":[{},[0,0,0,2,1]]},[0,3,2]],"ύ":[{"ν":[{},[0,0,0,2,1]]},[0,3,2]],"χ":[{"έ":[{},[0,4,3]],"έ":[{},[0,4,3]]},[0,3,2]],"ώ":[{},[0,3,2]],"ώ":[{},[0,3,2]],"ω":[{},[0,3,2]]},[0,2,1]],"ω":[{"σ":[{"φ":[{},[0,0,2,1]]}],"ϲ":[{"φ":[{},[0,0,2,1]]}]}]},[0,1]],"ἑ":[{"ι":[{},[0,3]],"υ":[{},[0,3]],"λ":[{"λ":[{"ή":[{"σ":[{"π":[{},[0,0,0,0,2,1]]}],"ϲ":[{"π":[{},[0,0,0,0,2,1]]}]}],"ή":[{"σ":[{"π":[{},[0,0,0,0,2,1]]}],"ϲ":[{"π":[{},[0,0,0,0,2,1]]}]}],"η":[{"σ":[{"π":[{},[0,0,0,0,2,1]]}],"ϲ":[{"π":[{},[0,0,0,0,2,1]]}]}]}]}],"ξ":[{"ή":[{"ρ":[{"ε":[{"τ":[{"μ":[{},[0,2,1]]}]}]}]}],"ή":[{"ρ":[{"ε":[{"τ":[{"μ":[{},[0,2,1]]}]}]}]}],"η":[{"ρ":[{"έ":[{"τ":[{"μ":[{},[0,2,1]]}]}],"έ":[{"τ":[{"μ":[{},[0,2,1]]}]}]}]}]}]},[0,1]],"ἒ":[{},[0,1]],"ἓ":[{},[0,1]],"ἔ":[{"κ":[{"λ":[{"ε":[{"ι":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]},[0,2,1]]}],"υ":[{"σ":[{},[0,2,1]],"ϲ":[{},[0,2,1]]}]}],"μ":[{},[0,2,1]],"ν":[{"α":[{"ι":[{},[0,3,2]]}],"η":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}]},[0,2,1]],"ρ":[{"α":[{"ζ":[{},[0,3,2]],"γ":[{},[0,3,2]],"ι":[{},[0,3,2]],"ν":[{},[0,3,2]]}],"ε":[{"κ":[{},[0,3,2]],"ξ":[{},[0,3,2]]}],"ι":[{"ν":[{},[0,3,2]]}],"ο":[{"υ":[{},[0,3,2]]}],"υ":[{"π":[{},[0,3,2]],"ψ":[{},[0,3,2]]}],"ω":[{"ζ":[{},[0,3,2]],"ξ":[{},[0,3,2]]}]},[0,2,1]],"τ":[{"α":[{"μ":[{"ε":[{".":[{},[0,2,1]]}]}]}],"ι":[{"ζ":[{},[0,3,2]],"σ":[{"α":[{},[0,3,2]]}],"ϲ":[{"α":[{},[0,3,2]]}]},[0,2,1]],"ο":[{},[0,2,1]],"υ":[{"π":[{"ο":[{},[0,2,1]],"ε":[{".":[{},[0,2,1]]}],"α":[{".":[{},[0,2,1]]}]}]}]}]}],"ν":[{"α":[{"ρ":[{"α":[{".":[{},[0,3,2]]}]}],"σ":[{"σ":[{},[0,3,2]]}],"ϲ":[{"ϲ":[{},[0,3,2]]}],"τ":[{},[0,3,2]]}],"ε":[{"ι":[{"κ":[{},[0,3,2]],"μ":[{},[0,3,2]]}],"ρ":[{"θ":[{"ε":[{},[0,3,2]]}]}],"υ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}]}],"η":[{"σ":[{".":[{},[0,3,2]]},[0,3,2]],"ϲ":[{".":[{},[0,3,2]]},[0,3,2]],"ν":[{".":[{},[0,3,2]]}],"ς":[{".":[{},[0,3,2]]}],".":[{},[0,3,2]]}],"ι":[{},[0,3,2]],"ο":[{"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]],"ι":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]],"ι":[{},[0,3,2]]}],"υ":[{".":[{},[0,3,2]]}],"ν":[{".":[{},[0,3,2]]}],"ι":[{".":[{},[0,3,2]],"ς":[{".":[{},[0,3,2]]}],"ϲ":[{".":[{},[0,3,2]]}],"σ":[{".":[{},[0,3,2]]}]}]}],"ω":[{},[0,3,2]],"ῃ":[{".":[{},[0,3,2]]}],"υ":[{"ξ":[{},[0,3,2]]}]},[0,2,1]],"ξ":[{"υ":[{"σ":[{},[0,3,2]],"ϲ":[{},[0,3,2]]}],"ω":[{".":[{},[0,3,2]]}]},[0,2,1]],"σ":[{"ο":[{"π":[{},[0,2,1]]}]}],"ϲ":[{"ο":[{"π":[{},[0,2,1]]}]}]},[0,1]],"ἕ":[{},[0,1]],"ἠ":[{"υ":[{},[0,3]],"ν":[{"ό":[{"π":[{},[0,2,1]]}],"ό":[{"π":[{},[0,2,1]]}]}]},[0,1]],"ἡ":[{"υ":[{},[0,3]],"τ":[{"ι":[{"σ":[{"ο":[{"ῦ":[{"ν":[{".":[{},[0,0,0,2,1]]}]}]}]}],"ϲ":[{"ο":[{"ῦ":[{"ν":[{".":[{},[0,0,0,2,1]]}]}]}]}]}]}]},[0,1]],"ἢ":[{},[0,1]],"ἣ":[{},[0,1]],"ἤ":[{"ν":[{"ο":[{"ψ":[{".":[{},[0,2,1]]}],"π":[{},[0,2,1]]}]}]},[0,1]],"ἥ":[{},[0,1]],"ἦ":[{},[0,1]],"ἧ":[{"σ":[{"τ":[{"ι":[{"ν":[{"ο":[{"ς":[{},[0,2,1]]}]}]}]}]}],"ϲ":[{"τ":[{"ι":[{"ν":[{"ο":[{"ϲ":[{},[0,2,1]]}]}]}]}]}]},[0,1]],"ἰ":[{},[0,1]],"ἱ":[{},[0,1]],"ἲ":[{},[0,1]],"ἳ":[{},[0,1]],"ἴ":[{},[0,1]],"ἵ":[{},[0,1]],"ἶ":[{},[0,1]],"ἷ":[{},[0,1]],"ὀ":[{"ι":[{},[0,3]],"υ":[{"ι":[{},[0,0,4]]},[0,3]]},[0,1]],"ὁ":[{"ι":[{},[0,3]],"υ":[{"ι":[{},[0,0,4]]},[0,3]],"λ":[{"ο":[{"ν":[{"έ":[{"ν":[{".":[{},[0,0,0,2,1]]}]}],"έ":[{"ν":[{".":[{},[0,0,0,2,1]]}]}],"ὲ":[{"ν":[{".":[{},[0,0,0,2,1]]}]}]}]}]}],"π":[{"ω":[{"σ":[{},[0,0,0,2,1]],"ϲ":[{},[0,0,0,2,1]]}],"ο":[{"ι":[{"ο":[{"υ":[{"σ":[{"τ":[{"ι":[{"ν":[{"α":[{"σ":[{"ο":[{"ῦ":[{"ν":[{".":[{},[0,0,0,0,0,0,2,1,0,0,0,2,1]]}]}]}]}]}]}]}]}]}],"ϲ":[{"τ":[{"ι":[{"ν":[{"α":[{"ϲ":[{"ο":[{"ῦ":[{"ν":[{".":[{},[0,0,0,0,0,0,2,1,0,0,0,2,1]]}]}]}]}]}]}]}]}]}]}]}]}]}]}],"σ":[{"ο":[{"ν":[{"ῶ":[{"ν":[{".":[{},[0,0,0,2,1]]}]}]}]}],"τ":[{"ι":[{"σ":[{"ο":[{"ῦ":[{"ν":[{".":[{},[0,2,1,0,2,1]]}]}]}]}]}]}]}],"ϲ":[{"ο":[{"ν":[{"ῶ":[{"ν":[{".":[{},[0,0,0,2,1]]}]}]}]}],"τ":[{"ι":[{"ϲ":[{"ο":[{"ῦ":[{"ν":[{".":[{},[0,2,1,0,2,1]]}]}]}]}]}]}]}]},[0,1]],"ὂ":[{},[0,1]],"ὃ":[{},[0,1]],"ὄ":[{},[0,1]],"ὅ":[{"σ":[{"γ":[{"ε":[{".":[{},[0,2,1]]}]}],"π":[{"ε":[{"ρ":[{".":[{},[0,2,1]]}]}]}],"τ":[{"ι":[{"ς":[{},[0,2,1]]}]}]}],"ϲ":[{"γ":[{"ε":[{".":[{},[0,2,1]]}]}],"π":[{"ε":[{"ρ":[{".":[{},[0,2,1]]}]}]}],"τ":[{"ι":[{"ϲ":[{},[0,2,1]]}]}]}]},[0,1]],"ὐ":[{"ι":[{},[0,3]]},[0,1]],"ὑ":[{"ι":[{},[0,3]],"ο":[{"σ":[{"κ":[{},[0,0,2,1]]}],"ϲ":[{"κ":[{},[0,0,2,1]]}]}],"π":[{"ε":[{"ί":[{"σ":[{"α":[{"ς":[{},[0,0,0,0,3,2]],"σ":[{},[0,0,0,0,3,2]],"ν":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]],"ϲ":[{"α":[{"ϲ":[{},[0,0,0,0,3,2]],"ν":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]]}],"ί":[{"σ":[{"α":[{"ς":[{},[0,0,0,0,3,2]],"σ":[{},[0,0,0,0,3,2]],"ν":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]],"ϲ":[{"α":[{"ϲ":[{},[0,0,0,0,3,2]],"ν":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]]}],"ι":[{"σ":[{"ά":[{"ν":[{},[0,0,0,0,3,2]],"σ":[{},[0,0,0,0,3,2]]}],"ά":[{"ν":[{},[0,0,0,0,3,2]],"σ":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]],"ϲ":[{"ά":[{"ν":[{},[0,0,0,0,3,2]],"ϲ":[{},[0,0,0,0,3,2]]}],"ά":[{"ν":[{},[0,0,0,0,3,2]],"ϲ":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,1]]}],"κ":[{"λ":[{"α":[{"μ":[{},[0,0,0,2,1]]}],"ή":[{"ψ":[{},[0,0,0,2,1]]}],"ή":[{"ψ":[{},[0,0,0,2,1]]}]}],"τ":[{},[0,0,0,2,1]]}],"ν":[{},[0,0,0,2,1]],"ξ":[{},[0,0,0,2,1]],"ρ":[{"ῶ":[{"ν":[{".":[{},[0,0,0,3,2]]}]},[0,0,0,3,2]],"ε":[{"θ":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"κ":[{"τ":[{"ε":[{},[0,0,0,0,0,2,1]],"ί":[{},[0,0,0,0,0,2,1]],"ί":[{},[0,0,0,0,0,2,1]]}]}],"π":[{"τ":[{},[0,0,0,3,2]]}],"ψ":[{},[0,0,0,3,2]],"ῖ":[{"ς":[{".":[{},[0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,3,2]]}],".":[{},[0,0,0,3,2]],"τ":[{},[0,0,0,3,2]]}]}],"έ":[{"θ":[{},[0,0,0,3,2]],"π":[{"τ":[{},[0,0,0,3,2]]}],"ψ":[{},[0,0,0,3,2]],"ω":[{},[0,0,0,3,2]],"ε":[{},[0,0,0,3,2]],"ο":[{},[0,0,0,3,2]]}],"έ":[{"θ":[{},[0,0,0,3,2]],"π":[{"τ":[{},[0,0,0,3,2]]}],"ψ":[{},[0,0,0,3,2]],"ω":[{},[0,0,0,3,2]],"ε":[{},[0,0,0,3,2]],"ο":[{},[0,0,0,3,2]]}],"ύ":[{"θ":[{},[0,0,0,3,2]]}],"ύ":[{"θ":[{},[0,0,0,3,2]]}],"υ":[{"θ":[{},[0,0,0,3,2]]}],"ο":[{"ῦ":[{},[0,0,0,3,2]]}],"ώ":[{},[0,0,0,3,2]],"ώ":[{},[0,0,0,3,2]],"ω":[{},[0,0,0,3,2]]},[0,0,0,2,1]]}],"έ":[{"ρ":[{"α":[{".":[{},[0,0,0,3,2]],"ν":[{".":[{},[0,0,0,3,2]]}],"ι":[{".":[{},[0,0,0,3,2]],"ς":[{".":[{},[0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,3,2]]}]}],"ς":[{".":[{},[0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,3,2]]}]}],"η":[{"ς":[{".":[{},[0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,3,2]]}]}],"ᾳ":[{".":[{},[0,0,0,3,2]]}],"υ":[{"θ":[{},[0,0,0,3,2]]}]},[0,0,0,2,1]]}],"έ":[{"ρ":[{"α":[{".":[{},[0,0,0,3,2]],"ν":[{".":[{},[0,0,0,3,2]]}],"ι":[{".":[{},[0,0,0,3,2]],"ς":[{".":[{},[0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,3,2]]}]}],"ς":[{".":[{},[0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,3,2]]}]}],"η":[{"ς":[{".":[{},[0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,3,2]]}]}],"ᾳ":[{".":[{},[0,0,0,3,2]]}],"υ":[{"θ":[{},[0,0,0,3,2]]}]},[0,0,0,2,1]]}]}],"σ":[{"τ":[{"ρ":[{},[0,2,1]]}]}],"ϲ":[{"τ":[{"ρ":[{},[0,2,1]]}]}]},[0,1]],"ὒ":[{},[0,1]],"ὓ":[{},[0,1]],"ὔ":[{},[0,1]],"ὕ":[{"σ":[{"τ":[{"ρ":[{},[0,2,1]]}]}],"ϲ":[{"τ":[{"ρ":[{},[0,2,1]]}]}]},[0,1]],"ὖ":[{},[0,1]],"ὗ":[{},[0,1]],"ὠ":[{},[0,1]],"ὡ":[{"σ":[{"α":[{"ν":[{"ε":[{"ί":[{".":[{},[0,2,1,2,1]]}],"ί":[{".":[{},[0,2,1,2,1]]}],"ὶ":[{".":[{},[0,2,1,2,1]]}]}]}],"ύ":[{"τ":[{"ω":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}]}],"ύ":[{"τ":[{"ω":[{"ς":[{".":[{},[0,2,1]]}],"σ":[{".":[{},[0,2,1]]}]}]}]}]}],"ε":[{"ί":[{".":[{},[0,2,1]]}],"ί":[{".":[{},[0,2,1]]}],"ὶ":[{".":[{},[0,2,1]]}]}],"π":[{"ε":[{"ρ":[{"ε":[{"ί":[{".":[{},[0,2,1,0,2,1]]}],"ί":[{".":[{},[0,2,1,0,2,1]]}],"ὶ":[{".":[{},[0,2,1,0,2,1]]}]}]}]}]}]}],"ϲ":[{"α":[{"ν":[{"ε":[{"ί":[{".":[{},[0,2,1,2,1]]}],"ί":[{".":[{},[0,2,1,2,1]]}],"ὶ":[{".":[{},[0,2,1,2,1]]}]}]}],"ύ":[{"τ":[{"ω":[{"ϲ":[{".":[{},[0,2,1]]}]}]}]}],"ύ":[{"τ":[{"ω":[{"ϲ":[{".":[{},[0,2,1]]}]}]}]}]}],"ε":[{"ί":[{".":[{},[0,2,1]]}],"ί":[{".":[{},[0,2,1]]}],"ὶ":[{".":[{},[0,2,1]]}]}],"π":[{"ε":[{"ρ":[{"ε":[{"ί":[{".":[{},[0,2,1,0,2,1]]}],"ί":[{".":[{},[0,2,1,0,2,1]]}],"ὶ":[{".":[{},[0,2,1,0,2,1]]}]}]}]}]}]}]},[0,1]],"ὢ":[{},[0,1]],"ὣ":[{},[0,1]],"ὤ":[{},[0,1]],"ὥ":[{"σ":[{"π":[{"ε":[{"ρ":[{".":[{},[0,2,1]]}]}]}],"τ":[{"ε":[{},[0,2,1]]}]}],"ϲ":[{"π":[{"ε":[{"ρ":[{".":[{},[0,2,1]]}]}]}],"τ":[{"ε":[{},[0,2,1]]}]}]},[0,1]],"ὦ":[{},[0,1]],"ὧ":[{},[0,1]],"ὰ":[{},[0,1]],"ὲ":[{},[0,1]],"ὴ":[{},[0,1]],"ὶ":[{},[0,1]],"ὸ":[{},[0,1]],"ὺ":[{},[0,1]],"ὼ":[{},[0,1]],"ᾀ":[{},[0,1]],"ᾁ":[{},[0,1]],"ᾂ":[{},[0,1]],"ᾃ":[{},[0,1]],"ᾄ":[{},[0,1]],"ᾅ":[{},[0,1]],"ᾆ":[{},[0,1]],"ᾇ":[{},[0,1]],"ᾐ":[{},[0,1]],"ᾑ":[{},[0,1]],"ᾒ":[{},[0,1]],"ᾓ":[{},[0,1]],"ᾔ":[{},[0,1]],"ᾕ":[{},[0,1]],"ᾖ":[{},[0,1]],"ᾗ":[{},[0,1]],"ᾠ":[{},[0,1]],"ᾡ":[{},[0,1]],"ᾢ":[{},[0,1]],"ᾣ":[{},[0,1]],"ᾤ":[{},[0,1]],"ᾥ":[{},[0,1]],"ᾦ":[{},[0,1]],"ᾧ":[{},[0,1]],"ᾲ":[{},[0,1]],"ᾳ":[{},[0,1]],"ᾴ":[{},[0,1]],"ᾶ":[{"ι":[{},[0,3]],"υ":[{},[0,3]]},[0,1]],"ᾷ":[{},[0,1]],"ῂ":[{},[0,1]],"ῃ":[{},[0,1]],"ῄ":[{},[0,1]],"ῆ":[{"υ":[{},[0,3]]},[0,1]],"ῇ":[{},[0,1]],"ῒ":[{},[0,1]],"ῖ":[{},[0,1]],"ῗ":[{},[0,1]],"ῢ":[{},[0,1]],"ῦ":[{"ι":[{},[0,3]]},[0,1]],"ῧ":[{},[0,1]],"ῲ":[{},[0,1]],"ῳ":[{},[0,1]],"ῴ":[{},[0,1]],"ῶ":[{},[0,1]],"ῷ":[{},[0,1]],"ά":[{"ι":[{},[0,3]],"υ":[{},[0,3]]},[0,1]],"έ":[{"ι":[{},[0,3]],"υ":[{},[0,3]]},[0,1]],"ή":[{"υ":[{},[0,3]]},[0,1]],"ί":[{},[0,1]],"ό":[{"ι":[{},[0,3]],"υ":[{"ι":[{},[0,0,4]]},[0,3]]},[0,1]],"ύ":[{"ι":[{},[0,3]]},[0,1]],"ώ":[{},[0,1]],"ΐ":[{},[0,1]],"ΰ":[{},[0,1]],"ά":[{"ι":[{},[0,3]],"υ":[{},[0,3]]},[0,1]],"έ":[{"ι":[{},[0,3]],"υ":[{},[0,3]]},[0,1]],"ή":[{"υ":[{},[0,3]]},[0,1]],"ί":[{},[0,1]],"ό":[{"ι":[{},[0,3]],"υ":[{"ι":[{},[0,0,4]]},[0,3]]},[0,1]],"ύ":[{"ι":[{},[0,3]]},[0,1]],"ώ":[{},[0,1]],"ΐ":[{},[0,1]],"ΰ":[{},[0,1]],"β":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"β":[{},[2,1]],"γ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"δ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"λ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"ϐ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"δ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"λ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"γ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"γ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"δ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"λ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"δ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"δ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"λ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ύ":[{"σ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}],"μ":[{"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"σ":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ε":[{"ι":[{"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}],"α":[{"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}]}],"σ":[{"θ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ι":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}],"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}],"ο":[{".":[{},[0,0,3,2]]}],"ω":[{},[0,0,3,2]]}],"ο":[{"μ":[{"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"υ":[{"σ":[{"ι":[{"ν":[{".":[{},[0,0,3,2]]}]}]},[0,0,3,2]]}],"ι":[{"μ":[{"ι":[{".":[{},[0,0,3,2]]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}]}]}],".":[{},[0,0,3,2]],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ο":[{".":[{},[0,0,3,2]]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}]}]}],"ν":[{".":[{},[0,0,3,2]],"τ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]]}],"ῃ":[{},[0,0,3,2]],"η":[{"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"σ":[{"θ":[{"ε":[{".":[{},[0,0,3,2]]}]}]}]}],"α":[{"ι":[{"μ":[{"ι":[{".":[{},[0,0,3,2]]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]}],".":[{},[0,0,3,2]],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ε":[{"ν":[{},[0,0,3,2]]}],"ο":[{".":[{},[0,0,3,2]]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}]}]}],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ς":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]],"τ":[{"ο":[{".":[{},[0,0,3,2]]}]},[0,0,3,2]]}],"σ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]]}],"ι":[{"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}]}],"ϲ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}],"μ":[{"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ε":[{"ι":[{"ϲ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}],"α":[{"ϲ":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ϲ":[{"θ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ι":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}],"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}],"ο":[{".":[{},[0,0,3,2]]}],"ω":[{},[0,0,3,2]]}],"ο":[{"μ":[{"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"υ":[{"ϲ":[{"ι":[{"ν":[{".":[{},[0,0,3,2]]}]}]},[0,0,3,2]]}],"ι":[{"μ":[{"ι":[{".":[{},[0,0,3,2]]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}]}]}],".":[{},[0,0,3,2]],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ο":[{".":[{},[0,0,3,2]]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}]}]}],"ν":[{".":[{},[0,0,3,2]],"τ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]]}],"ῃ":[{},[0,0,3,2]],"η":[{"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"ε":[{".":[{},[0,0,3,2]]}]}]}]}],"α":[{"ι":[{"μ":[{"ι":[{".":[{},[0,0,3,2]]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]}],".":[{},[0,0,3,2]],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ε":[{"ν":[{},[0,0,3,2]]}],"ο":[{".":[{},[0,0,3,2]]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}]}]}],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ϲ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]],"τ":[{"ο":[{".":[{},[0,0,3,2]]}]},[0,0,3,2]]}]}],"ι":[{"ϲ":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}]}]}],"ύ":[{"σ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}],"μ":[{"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"σ":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ε":[{"ι":[{"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}],"α":[{"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}]}],"σ":[{"θ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ι":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}],"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}],"ο":[{".":[{},[0,0,3,2]]}],"ω":[{},[0,0,3,2]]}],"ο":[{"μ":[{"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"υ":[{"σ":[{"ι":[{"ν":[{".":[{},[0,0,3,2]]}]}]},[0,0,3,2]]}],"ι":[{"μ":[{"ι":[{".":[{},[0,0,3,2]]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}]}]}],".":[{},[0,0,3,2]],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ο":[{".":[{},[0,0,3,2]]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}]}]}],"ν":[{".":[{},[0,0,3,2]],"τ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]]}],"ῃ":[{},[0,0,3,2]],"η":[{"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"σ":[{"θ":[{"ε":[{".":[{},[0,0,3,2]]}]}]}]}],"α":[{"ι":[{"μ":[{"ι":[{".":[{},[0,0,3,2]]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]}],".":[{},[0,0,3,2]],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ε":[{"ν":[{},[0,0,3,2]]}],"ο":[{".":[{},[0,0,3,2]]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}]}]}],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ς":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]],"τ":[{"ο":[{".":[{},[0,0,3,2]]}]},[0,0,3,2]]}],"σ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]]}],"ι":[{"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}]}],"ϲ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}],"μ":[{"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ε":[{"ι":[{"ϲ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}],"α":[{"ϲ":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ϲ":[{"θ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ι":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}],"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}],"ο":[{".":[{},[0,0,3,2]]}],"ω":[{},[0,0,3,2]]}],"ο":[{"μ":[{"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"υ":[{"ϲ":[{"ι":[{"ν":[{".":[{},[0,0,3,2]]}]}]},[0,0,3,2]]}],"ι":[{"μ":[{"ι":[{".":[{},[0,0,3,2]]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}]}]}],".":[{},[0,0,3,2]],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ο":[{".":[{},[0,0,3,2]]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}]}]}],"ν":[{".":[{},[0,0,3,2]],"τ":[{"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]]}],"ῃ":[{},[0,0,3,2]],"η":[{"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"ε":[{".":[{},[0,0,3,2]]}]}]}]}],"α":[{"ι":[{"μ":[{"ι":[{".":[{},[0,0,3,2]]}],"ε":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"ϲ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]}],".":[{},[0,0,3,2]],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ε":[{"ν":[{},[0,0,3,2]]}],"ο":[{".":[{},[0,0,3,2]]}],"ν":[{"τ":[{"ο":[{".":[{},[0,0,3,2]]}]}]}]}],"τ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ε":[{".":[{},[0,0,3,2]]}]}],"ϲ":[{".":[{},[0,0,3,2]],"θ":[{"ο":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{".":[{},[0,0,3,2]]}],"α":[{"ι":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]],"τ":[{"ο":[{".":[{},[0,0,3,2]]}]},[0,0,3,2]]}]}],"ι":[{"ϲ":[{".":[{},[0,0,3,2]]}],"ν":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}]}]}],"υ":[{"σ":[{"ο":[{"ί":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}],"σ":[{"θ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ί":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}],"σ":[{"θ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ύ":[{"σ":[{},[0,0,3,2]]}],"ύ":[{"σ":[{},[0,0,3,2]]}]}],"ό":[{"ν":[{},[0,0,3,2]],"μ":[{"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ό":[{"ν":[{},[0,0,3,2]],"μ":[{"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}]}],"α":[{"ί":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}],"σ":[{"θ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ί":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}],"σ":[{"θ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}]}],"ά":[{"τ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}],"ν":[{"τ":[{"ω":[{"ν":[{".":[{},[0,0,3,2]]}]}]},[0,0,3,2]]}],"σ":[{"θ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]],"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]}]}],"ά":[{"τ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}],"ν":[{"τ":[{"ω":[{"ν":[{".":[{},[0,0,3,2]]}]}]},[0,0,3,2]]}],"σ":[{"θ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]],"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]}]}],"ώ":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"ώ":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"σ":[{"α":[{"μ":[{"έ":[{"ν":[{},[0,0,0,3,2]]}],"έ":[{"ν":[{},[0,0,0,3,2]]}]}]}]}],"έ":[{"ο":[{"ι":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}],"έ":[{"ο":[{"ι":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ϲ":[{"ο":[{"ί":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}],"ϲ":[{"θ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ί":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}],"ϲ":[{"θ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ύ":[{"ϲ":[{},[0,0,3,2]]}],"ύ":[{"ϲ":[{},[0,0,3,2]]}]}],"ό":[{"ν":[{},[0,0,3,2]],"μ":[{"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ό":[{"ν":[{},[0,0,3,2]],"μ":[{"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}]}],"α":[{"ί":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}],"ϲ":[{"θ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}],"ί":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}],"μ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ε":[{"θ":[{"α":[{".":[{},[0,0,3,2]]}]}]}]}],"ϲ":[{"θ":[{"η":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}]}],"ά":[{"τ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}],"ν":[{"τ":[{"ω":[{"ν":[{".":[{},[0,0,3,2]]}]}]},[0,0,3,2]]}],"ϲ":[{"θ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]],"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]}]}],"ά":[{"τ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}],"ν":[{"τ":[{"ω":[{"ν":[{".":[{},[0,0,3,2]]}]}]},[0,0,3,2]]}],"ϲ":[{"θ":[{"ω":[{".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}]}]},[0,0,3,2]],"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]}]}],"ώ":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"ώ":[{"μ":[{"ε":[{"θ":[{"α":[{},[0,0,3,2]]}]}]}]}],"ϲ":[{"α":[{"μ":[{"έ":[{"ν":[{},[0,0,0,3,2]]}],"έ":[{"ν":[{},[0,0,0,3,2]]}]}]}]}],"έ":[{"ο":[{"ι":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}],"έ":[{"ο":[{"ι":[{"ν":[{".":[{},[0,0,3,2]]}]}]}]}]}]}]}],"ζ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ζ":[{},[2,1]],"β":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]},[2,1]],"ϐ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"λ":[{},[2,1]],"μ":[{},[2,1]],"ν":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"ρ":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]]}],"θ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"θ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"κ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"λ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"κ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"κ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"λ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"τ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"λ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"λ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]},[2,1]],"ν":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"ρ":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]]}],"μ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"μ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"λ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"ρ":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"ν":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ν":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"λ":[{},[2,1]],"μ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"ρ":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{".":[{},[2]]},[2,1]],"ς":[{".":[{},[2]]}],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]]}],"ξ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"λ":[{},[2,1]],"μ":[{},[2,1]],"ν":[{},[2,1]],"π":[{},[2,1]],"ρ":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]]}],"π":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"π":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"ξ":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"λ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"τ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"α":[{"ρ":[{"έ":[{"ξ":[{"ω":[{".":[{},[0,0,0,0,3,2]]}],"ε":[{"ι":[{"ς":[{".":[{},[0,0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,0,3,2]]}],".":[{},[0,0,0,0,3,2]]}],"τ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}],"α":[{"ι":[{".":[{},[0,0,0,0,3,2]]}]}]}],"σ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}]}]}]}],"ο":[{"μ":[{"ε":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"α":[{"ι":[{},[0,0,0,0,3,2]]}]}],"υ":[{"σ":[{"ι":[{".":[{},[0,0,0,0,3,2]]}]}],"ϲ":[{"ι":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ν":[{"τ":[{"α":[{"ι":[{".":[{},[0,0,0,0,3,2]]}]}]}]}]}],"ῃ":[{},[0,0,0,0,3,2]]}]}],"έ":[{"ξ":[{"ω":[{".":[{},[0,0,0,0,3,2]]}],"ε":[{"ι":[{"ς":[{".":[{},[0,0,0,0,3,2]]}],"ϲ":[{".":[{},[0,0,0,0,3,2]]}],"σ":[{".":[{},[0,0,0,0,3,2]]}],".":[{},[0,0,0,0,3,2]]}],"τ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}],"α":[{"ι":[{".":[{},[0,0,0,0,3,2]]}]}]}],"σ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ϲ":[{"θ":[{"ο":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"ε":[{".":[{},[0,0,0,0,3,2]]}]}]}]}],"ο":[{"μ":[{"ε":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}],"α":[{"ι":[{},[0,0,0,0,3,2]]}]}],"υ":[{"σ":[{"ι":[{".":[{},[0,0,0,0,3,2]]}]}],"ϲ":[{"ι":[{".":[{},[0,0,0,0,3,2]]}]}]}],"ν":[{"τ":[{"α":[{"ι":[{".":[{},[0,0,0,0,3,2]]}]}]}]}]}],"ῃ":[{},[0,0,0,0,3,2]]}]}],"ε":[{"ξ":[{"έ":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}]}],"έ":[{"τ":[{"η":[{"ν":[{".":[{},[0,0,0,0,3,2]]}]}]}]}],"ό":[{"μ":[{"ε":[{"θ":[{"α":[{".":[{},[0,0,0,0,3,2]]}]}]}]}]}],"ό":[{"μ":[{"ε":[{"θ":[{"α":[{".":[{},[0,0,0,0,3,2]]}]}]}]}]}]}]}]}]}]}],"ρ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ρ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"λ":[{},[2,1]],"μ":[{},[2,1]],"ν":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]]}],"σ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"σ":[{},[2,1]],"δ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]},[2,1]],"ζ":[{},[2,1]],"λ":[{},[2,1]],"ν":[{},[2,1]],"ξ":[{},[2,1]],"ρ":[{},[2,1]],"ψ":[{},[2,1]],"β":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ϐ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"γ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"θ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"κ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"π":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"τ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"φ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"χ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"ϲ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ϲ":[{},[2,1]],"δ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]},[2,1]],"ζ":[{},[2,1]],"λ":[{},[2,1]],"ν":[{},[2,1]],"ξ":[{},[2,1]],"ρ":[{},[2,1]],"ψ":[{},[2,1]],"β":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ϐ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"γ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"θ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"κ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"π":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"τ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"φ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"χ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"ς":[{".":[{},[4]]}],"τ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"τ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]]}],"φ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"φ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"κ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"χ":[{},[2,1]],"ψ":[{},[2,1]],"θ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"λ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"χ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"χ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"κ":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"ψ":[{},[2,1]],"θ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"λ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"μ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ν":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}],"ρ":[{"\'":[{},[4]],"’":[{},[4]],"ʼ":[{},[4]],"᾽":[{},[4]],"᾿":[{},[4]]}]}],"ψ":[{".":[{},[4]],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],"ψ":[{},[2,1]],"β":[{},[2,1]],"ϐ":[{},[2,1]],"γ":[{},[2,1]],"δ":[{},[2,1]],"ζ":[{},[2,1]],"θ":[{},[2,1]],"κ":[{},[2,1]],"λ":[{},[2,1]],"μ":[{},[2,1]],"ν":[{},[2,1]],"ξ":[{},[2,1]],"π":[{},[2,1]],"ρ":[{},[2,1]],"σ":[{},[2,1]],"ϲ":[{},[2,1]],"τ":[{},[2,1]],"φ":[{},[2,1]],"χ":[{},[2,1]]}],"\'":[{},[4]],"ʼ":[{},[4]],"᾿":[{},[4]],".":[{"β":[{},[0,4]],"ϐ":[{},[0,4]],"γ":[{"ε":[{"ρ":[{"α":[{"σ":[{"φ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"φ":[{},[0,0,0,0,2,1]]}]}]}]}]},[0,4]],"δ":[{"α":[{"σ":[{"π":[{},[0,0,2,1]]}],"ϲ":[{"π":[{},[0,0,2,1]]}]}],"ι":[{"α":[{"μ":[{"φ":[{"ι":[{"σ":[{"β":[{},[0,0,0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,0,0,2,1]]}],"ϲ":[{"β":[{},[0,0,0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,0,0,2,1]]}]}]}]}]}],"έ":[{"κ":[{"ρ":[{"ο":[{},[0,0,0,2,1]]}]}],"ξ":[{},[0,0,0,2,1]]}],"έ":[{"κ":[{"ρ":[{"ο":[{},[0,0,0,2,1]]}]}],"ξ":[{},[0,0,0,2,1]]}],"ε":[{"κ":[{"ρ":[{"ό":[{},[0,0,0,2,1]],"ό":[{},[0,0,0,2,1]]}]}],"ξ":[{},[0,0,0,2,1]]}],"κ":[{"α":[{"σ":[{"π":[{},[0,0,0,0,2,1]]}],"ϲ":[{"π":[{},[0,0,0,0,2,1]]}]}]}],"ό":[{"σ":[{"κ":[{},[0,0,0,2,1]],"π":[{},[0,0,0,2,1]]}],"ϲ":[{"κ":[{},[0,0,0,2,1]],"π":[{},[0,0,0,2,1]]}]}],"ό":[{"σ":[{"κ":[{},[0,0,0,2,1]],"π":[{},[0,0,0,2,1]]}],"ϲ":[{"κ":[{},[0,0,0,2,1]],"π":[{},[0,0,0,2,1]]}]}],"ο":[{"σ":[{"κ":[{},[0,0,0,2,1]],"π":[{},[0,0,0,2,1]]}],"ϲ":[{"κ":[{},[0,0,0,2,1]],"π":[{},[0,0,0,2,1]]}]}],"σ":[{"ά":[{},[0,0,2,1]],"ά":[{},[0,0,2,1]],"ή":[{},[0,0,2,1]],"ή":[{},[0,0,2,1]],"ε":[{},[0,0,2,1]],"θ":[{},[0,0,2,1]]}],"ϲ":[{"ά":[{},[0,0,2,1]],"ά":[{},[0,0,2,1]],"ή":[{},[0,0,2,1]],"ή":[{},[0,0,2,1]],"ε":[{},[0,0,2,1]],"θ":[{},[0,0,2,1]]}]}],"ί":[{"σ":[{"α":[{},[0,0,2,1]],"η":[{},[0,0,2,1]],"ε":[{},[0,0,2,1]]}],"ϲ":[{"α":[{},[0,0,2,1]],"η":[{},[0,0,2,1]],"ε":[{},[0,0,2,1]]}]}],"ί":[{"σ":[{"α":[{},[0,0,2,1]],"η":[{},[0,0,2,1]],"ε":[{},[0,0,2,1]]}],"ϲ":[{"α":[{},[0,0,2,1]],"η":[{},[0,0,2,1]],"ε":[{},[0,0,2,1]]}]}],"ύ":[{"σ":[{"ε":[{"τ":[{},[0,0,3,2]],"σ":[{},[0,0,3,2]]}],"κ":[{"ε":[{},[0,0,3,2]]}],"τ":[{"α":[{"ν":[{},[0,0,3,2]]}]}]},[0,0,2,1]],"ϲ":[{"ε":[{"τ":[{},[0,0,3,2]],"ϲ":[{},[0,0,3,2]]}],"κ":[{"ε":[{},[0,0,3,2]]}],"τ":[{"α":[{"ν":[{},[0,0,3,2]]}]}]},[0,0,2,1]]}],"ύ":[{"σ":[{"ε":[{"τ":[{},[0,0,3,2]],"σ":[{},[0,0,3,2]]}],"κ":[{"ε":[{},[0,0,3,2]]}],"τ":[{"α":[{"ν":[{},[0,0,3,2]]}]}]},[0,0,2,1]],"ϲ":[{"ε":[{"τ":[{},[0,0,3,2]],"ϲ":[{},[0,0,3,2]]}],"κ":[{"ε":[{},[0,0,3,2]]}],"τ":[{"α":[{"ν":[{},[0,0,3,2]]}]}]},[0,0,2,1]]}],"υ":[{"σ":[{"ό":[{"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]}]}],"ό":[{"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]}]}],"ο":[{"μ":[{"έ":[{"ν":[{},[0,0,3,2]]}],"έ":[{"ν":[{},[0,0,3,2]]}]}]}],"ε":[{"ί":[{"σ":[{"β":[{},[0,0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,0,2,1]]}]}],"ί":[{"σ":[{"β":[{},[0,0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,0,2,1]]}]}],"ι":[{"σ":[{"β":[{},[0,0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,0,2,1]]}]}],"κ":[{},[0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"κ":[{},[0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"κ":[{},[0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,2,1]]}],"ι":[{"θ":[{},[0,0,3,2]]}],"μ":[{"ή":[{".":[{},[0,0,3,2]]}],"ή":[{".":[{},[0,0,3,2]]}],"ὴ":[{".":[{},[0,0,3,2]]}],"ῆ":[{"ς":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ῇ":[{},[0,0,3,2]],"ᾶ":[{},[0,0,3,2]],"α":[{},[0,0,3,2]],"ῶ":[{},[0,0,3,2]]}],"ξ":[{"ύ":[{"ν":[{},[0,0,0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,0,0,2,1]]}]}],"τ":[{"ά":[{"ν":[{},[0,0,3,2]]}],"ά":[{"ν":[{},[0,0,3,2]]}],"η":[{"ν":[{},[0,0,3,2]]}],"ή":[{"ν":[{},[0,0,3,2]]}],"ή":[{"ν":[{},[0,0,3,2]]}]}]},[0,0,2,1]],"ϲ":[{"ό":[{"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]}]}],"ό":[{"μ":[{"ε":[{"ν":[{},[0,0,3,2]]}]}]}],"ο":[{"μ":[{"έ":[{"ν":[{},[0,0,3,2]]}],"έ":[{"ν":[{},[0,0,3,2]]}]}]}],"ε":[{"ί":[{"ϲ":[{"β":[{},[0,0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,0,2,1]]}]}],"ί":[{"ϲ":[{"β":[{},[0,0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,0,2,1]]}]}],"ι":[{"ϲ":[{"β":[{},[0,0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,0,2,1]]}]}],"κ":[{},[0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"κ":[{},[0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"κ":[{},[0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,2,1]]}],"ι":[{"θ":[{},[0,0,3,2]]}],"μ":[{"ή":[{".":[{},[0,0,3,2]]}],"ή":[{".":[{},[0,0,3,2]]}],"ὴ":[{".":[{},[0,0,3,2]]}],"ῆ":[{"ϲ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]]}],"ῇ":[{},[0,0,3,2]],"ᾶ":[{},[0,0,3,2]],"α":[{},[0,0,3,2]],"ῶ":[{},[0,0,3,2]]}],"ξ":[{"ύ":[{"ν":[{},[0,0,0,0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,0,0,0,2,1]]}],"υ":[{"ν":[{},[0,0,0,0,0,2,1]]}]}],"τ":[{"ά":[{"ν":[{},[0,0,3,2]]}],"ά":[{"ν":[{},[0,0,3,2]]}],"η":[{"ν":[{},[0,0,3,2]]}],"ή":[{"ν":[{},[0,0,3,2]]}],"ή":[{"ν":[{},[0,0,3,2]]}]}]},[0,0,2,1]]}]},[0,4]],"ζ":[{},[0,4]],"θ":[{"ε":[{"μ":[{"ι":[{"σ":[{"κ":[{"ρ":[{},[0,0,0,0,2,1]]}]}],"ϲ":[{"κ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}]}],"ό":[{"σ":[{"δ":[{},[0,0,0,2,1]]}],"ϲ":[{"δ":[{},[0,0,0,2,1]]}]}],"ό":[{"σ":[{"δ":[{},[0,0,0,2,1]]}],"ϲ":[{"δ":[{},[0,0,0,2,1]]}]}],"ο":[{"σ":[{"δ":[{},[0,0,0,2,1]]}],"ϲ":[{"δ":[{},[0,0,0,2,1]]}],"ι":[{"σ":[{"ε":[{"χ":[{"θ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}]}],"ϲ":[{"ε":[{"χ":[{"θ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}]}]}]}]}],"η":[{"ρ":[{"α":[{"γ":[{"ρ":[{},[0,0,2,1]]}]}]}]}],"υ":[{"ο":[{"σ":[{"κ":[{},[0,0,0,2,1]]}],"ϲ":[{"κ":[{},[0,0,0,2,1]]}]}]}]},[0,4]],"κ":[{"α":[{"θ":[{"υ":[{"π":[{"ε":[{"ρ":[{},[0,0,0,0,0,0,2,1]]}]}]}]}],"λ":[{"ω":[{"σ":[{"ο":[{"ρ":[{},[0,0,0,0,2,1]]}],"ό":[{"ρ":[{},[0,0,0,0,2,1]]}],"ό":[{"ρ":[{},[0,0,0,0,2,1]]}]}],"ϲ":[{"ο":[{"ρ":[{},[0,0,0,0,2,1]]}],"ό":[{"ρ":[{},[0,0,0,0,2,1]]}],"ό":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}]}],"ν":[{"ε":[{"ί":[{"ς":[{".":[{},[0,0,2,1]]}],"ϲ":[{".":[{},[0,0,2,1]]}],"σ":[{".":[{},[0,0,2,1]]}]}],"ί":[{"ς":[{".":[{},[0,0,2,1]]}],"ϲ":[{".":[{},[0,0,2,1]]}],"σ":[{".":[{},[0,0,2,1]]}]}],"ὶ":[{"ς":[{".":[{},[0,0,2,1]]}],"ϲ":[{".":[{},[0,0,2,1]]}],"σ":[{".":[{},[0,0,2,1]]}]}],"ν":[{},[0,0,2,1]]}],"έ":[{"ν":[{},[0,0,2,1]]}],"έ":[{"ν":[{},[0,0,2,1]]}]}],"τ":[{"α":[{"δ":[{"υ":[{"σ":[{"ω":[{"π":[{},[0,0,0,0,0,0,2,1]]}]}],"ϲ":[{"ω":[{"π":[{},[0,0,0,0,0,0,2,1]]}]}]}]}]}],"ε":[{"δ":[{"υ":[{"σ":[{"ώ":[{"π":[{},[0,0,0,0,0,0,2,1]]}],"ώ":[{"π":[{},[0,0,0,0,0,0,2,1]]}]}],"ϲ":[{"ώ":[{"π":[{},[0,0,0,0,0,0,2,1]]}],"ώ":[{"π":[{},[0,0,0,0,0,0,2,1]]}]}]}]}],"ι":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}],"ν":[{"α":[{"ί":[{},[0,0,0,0,2,1]],"ί":[{},[0,0,0,0,2,1]]}],"ή":[{},[0,0,0,0,2,1]],"ή":[{},[0,0,0,0,2,1]]}],"ξ":[{"α":[{"ν":[{"ί":[{},[0,0,0,0,2,1,2,1]],"ί":[{},[0,0,0,0,2,1,2,1]],"έ":[{"σ":[{},[0,0,0,0,2,1,2,1]],"ϲ":[{},[0,0,0,0,2,1,2,1]]}],"έ":[{"σ":[{},[0,0,0,0,2,1,2,1]],"ϲ":[{},[0,0,0,0,2,1,2,1]]}]}]}]}]}]}]}],"ε":[{"ρ":[{"α":[{"σ":[{"φ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"φ":[{},[0,0,0,0,2,1]]}]}]}]}],"ρ":[{"ά":[{"σ":[{"π":[{},[0,0,0,2,1]]}],"ϲ":[{"π":[{},[0,0,0,2,1]]}]}],"ά":[{"σ":[{"π":[{},[0,0,0,2,1]]}],"ϲ":[{"π":[{},[0,0,0,2,1]]}]}],"α":[{"σ":[{"π":[{},[0,0,0,2,1]]}],"ϲ":[{"π":[{},[0,0,0,2,1]]}]}]}],"υ":[{"ν":[{"ό":[{"σ":[{"α":[{},[0,0,0,0,2,1]],"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ο":[{},[0,0,0,0,2,1]]}],"ϲ":[{"α":[{},[0,0,0,0,2,1]],"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ο":[{},[0,0,0,0,2,1]]}]}],"ό":[{"σ":[{"α":[{},[0,0,0,0,2,1]],"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ο":[{},[0,0,0,0,2,1]]}],"ϲ":[{"α":[{},[0,0,0,0,2,1]],"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ο":[{},[0,0,0,0,2,1]]}]}],"ο":[{"σ":[{"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ο":[{},[0,0,0,0,2,1]],"φ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"β":[{},[0,0,0,0,2,1]],"ϐ":[{},[0,0,0,0,2,1]],"ο":[{},[0,0,0,0,2,1]],"φ":[{},[0,0,0,0,2,1]]}]}]}]}]},[0,4]],"λ":[{},[0,4]],"μ":[{"ε":[{"λ":[{"α":[{"ν":[{"ά":[{"γ":[{},[0,0,0,0,2,1]],"ε":[{},[0,0,0,0,2,1]]}],"ά":[{"γ":[{},[0,0,0,0,2,1]],"ε":[{},[0,0,0,0,2,1]]}],"α":[{"γ":[{},[0,0,0,0,2,1]],"έ":[{},[0,0,0,0,2,1]],"έ":[{},[0,0,0,0,2,1]],"θ":[{},[0,0,0,0,2,1]],"ι":[{"γ":[{},[0,0,0,0,2,1]]}],"υ":[{"γ":[{},[0,0,0,0,2,1]]}]}],"ε":[{"ί":[{"μ":[{},[0,0,0,0,2,1]]}],"ί":[{"μ":[{},[0,0,0,0,2,1]]}],"ῖ":[{"μ":[{},[0,0,0,0,2,1]]}]}],"ί":[{"π":[{"π":[{},[0,0,0,0,2,1]]}]}],"ί":[{"π":[{"π":[{},[0,0,0,0,2,1]]}]}],"ό":[{"μ":[{"μ":[{},[0,0,0,0,2,1]]}],"σ":[{"σ":[{},[0,0,0,0,2,1]],"τ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"ϲ":[{},[0,0,0,0,2,1]],"τ":[{},[0,0,0,0,2,1]]}]}],"ό":[{"μ":[{"μ":[{},[0,0,0,0,2,1]]}],"σ":[{"σ":[{},[0,0,0,0,2,1]],"τ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"ϲ":[{},[0,0,0,0,2,1]],"τ":[{},[0,0,0,0,2,1]]}]}],"ο":[{"μ":[{"μ":[{},[0,0,0,0,2,1]]}],"ύ":[{"ρ":[{},[0,0,0,0,2,1]]}],"ύ":[{"ρ":[{},[0,0,0,0,2,1]]}],"υ":[{"ρ":[{},[0,0,0,0,2,1]]}]}],"ύ":[{},[0,0,0,0,2,1]],"ύ":[{},[0,0,0,0,2,1]]}]}],"ά":[{"ν":[{"ι":[{"π":[{"π":[{},[0,0,0,0,2,1]]}]}],"ο":[{"σ":[{"σ":[{},[0,0,0,0,2,1]],"τ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"ϲ":[{},[0,0,0,0,2,1]],"τ":[{},[0,0,0,0,2,1]]}],"υ":[{"ρ":[{},[0,0,0,0,2,1]]}]}],"υ":[{},[0,0,0,0,2,1]]}]}],"ά":[{"ν":[{"ι":[{"π":[{"π":[{},[0,0,0,0,2,1]]}]}],"ο":[{"σ":[{"σ":[{},[0,0,0,0,2,1]],"τ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"ϲ":[{},[0,0,0,0,2,1]],"τ":[{},[0,0,0,0,2,1]]}],"υ":[{"ρ":[{},[0,0,0,0,2,1]]}]}],"υ":[{},[0,0,0,0,2,1]]}]}]}],"τ":[{"ε":[{"ξ":[{"α":[{},[0,0,0,0,2,1]],"έ":[{},[0,0,0,0,2,1]],"έ":[{},[0,0,0,0,2,1]],"ε":[{},[0,0,0,0,2,1]]}]}]}]}],"ο":[{"γ":[{"ι":[{"σ":[{},[0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,2,1]]}],"ο":[{"σ":[{"τ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"τ":[{},[0,0,0,0,2,1]]}]}]}]}],"υ":[{"σ":[{"π":[{},[0,0,2,1]],"ε":[{"π":[{},[0,0,2,1]]}]}],"ϲ":[{"π":[{},[0,0,2,1]],"ε":[{"π":[{},[0,0,2,1]]}]}]}]},[0,4]],"ν":[{"ε":[{"ώ":[{"σ":[{"ο":[{"ι":[{"κ":[{},[0,0,0,2,1]]}]}]}],"ϲ":[{"ο":[{"ι":[{"κ":[{},[0,0,0,2,1]]}]}]}]}],"ώ":[{"σ":[{"ο":[{"ι":[{"κ":[{},[0,0,0,2,1]]}]}]}],"ϲ":[{"ο":[{"ι":[{"κ":[{},[0,0,0,2,1]]}]}]}]}],"ω":[{"σ":[{"ο":[{"ί":[{"κ":[{},[0,0,0,2,1]]}],"ί":[{"κ":[{},[0,0,0,2,1]]}]}]}],"ϲ":[{"ο":[{"ί":[{"κ":[{},[0,0,0,2,1]]}],"ί":[{"κ":[{},[0,0,0,2,1]]}]}]}]}]}],"ο":[{"υ":[{"ν":[{"ε":[{},[0,0,0,2,1]]}]}]}]},[0,4]],"ξ":[{"υ":[{"ν":[{"α":[{"γ":[{},[0,0,2,1]]}],"ε":[{"ώ":[{},[0,0,3,2]],"ώ":[{},[0,0,3,2]],"ῶ":[{},[0,0,3,2]]},[0,0,2,1]],"έ":[{},[0,0,2,1]],"έ":[{},[0,0,2,1]],"ῆ":[{"κ":[{},[0,0,2,1]]}],"ί":[{},[0,0,2,1]],"ί":[{},[0,0,2,1]]}]}],"ύ":[{"ν":[{"ε":[{},[0,0,2,1]],"ι":[{},[0,0,2,1]]}]}],"ύ":[{"ν":[{"ε":[{},[0,0,2,1]],"ι":[{},[0,0,2,1]]}]}]},[0,4]],"π":[{"α":[{"λ":[{"ι":[{"ν":[{},[0,0,0,0,2,1]]}],"ί":[{"ν":[{},[0,0,0,0,2,1]]}],"ί":[{"ν":[{},[0,0,0,0,2,1]]}]}],"ν":[{"ό":[{"ς":[{".":[{},[0,0,3,2]]}],"ϲ":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ό":[{"ς":[{".":[{},[0,0,3,2]]}],"ϲ":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ὸ":[{"ς":[{".":[{},[0,0,3,2]]}],"ϲ":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}],".":[{},[0,0,3,2]],"ν":[{".":[{},[0,0,3,2]]}]}],"ί":[{".":[{},[0,0,3,2]],"σ":[{"δ":[{},[0,0,3,2]]}],"ϲ":[{"δ":[{},[0,0,3,2]]}]}],"ί":[{".":[{},[0,0,3,2]],"σ":[{"δ":[{},[0,0,3,2]]}],"ϲ":[{"δ":[{},[0,0,3,2]]}]}],"ὶ":[{".":[{},[0,0,3,2]]}],"ῶ":[{"ν":[{".":[{},[0,0,3,2]]}]}],"ι":[{"κ":[{},[0,0,3,2]],"σ":[{"δ":[{},[0,0,3,2]]}],"ϲ":[{"δ":[{},[0,0,3,2]]}]}],"ο":[{"ῦ":[{".":[{},[0,0,3,2]]}],"ί":[{".":[{},[0,0,3,2]]}],"ί":[{".":[{},[0,0,3,2]]}],"ὶ":[{".":[{},[0,0,3,2]]}],"ῖ":[{"ς":[{".":[{},[0,0,3,2]]}],"ϲ":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}]}],"ύ":[{"ς":[{".":[{},[0,0,3,2]]}],"ϲ":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}]}],"ύ":[{"ς":[{".":[{},[0,0,3,2]]}],"ϲ":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}]}],"ὺ":[{"ς":[{".":[{},[0,0,3,2]]}],"ϲ":[{".":[{},[0,0,3,2]]}],"σ":[{".":[{},[0,0,3,2]]}]}]}],"ῷ":[{".":[{},[0,0,3,2]]}],"έ":[{".":[{},[0,0,3,2]]}],"έ":[{".":[{},[0,0,3,2]]}],"ὲ":[{".":[{},[0,0,3,2]]}]},[0,0,2,1]],"ρ":[{"α":[{"ν":[{"ί":[{"σ":[{"χ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"χ":[{},[0,0,0,0,2,1]]}]}],"ί":[{"σ":[{"χ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"χ":[{},[0,0,0,0,2,1]]}]}]}]}],"ε":[{"ί":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}],"ί":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}],"ι":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}],"κ":[{"λ":[{},[0,0,0,0,2,1]],"τ":[{"ρ":[{},[0,0,0,0,2,1]]}]}],"ν":[{"ε":[{"ῖ":[{},[0,0,0,0,2,1]]}],"ο":[{},[0,0,0,0,2,1]]}],"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"ξ":[{},[0,0,0,0,2,1]]}]}]}],"ά":[{"ν":[{"α":[{".":[{},[]]}]},[0,0,2,1]]}],"ά":[{"ν":[{"α":[{".":[{},[]]}]},[0,0,2,1]]}],"λ":[{"ε":[{"ο":[{"ν":[{"έ":[{},[0,0,0,0,2,1]],"έ":[{},[0,0,0,0,2,1]],"ε":[{},[0,0,0,0,2,1]]}]}]}]}],"ρ":[{"ο":[{"ε":[{"ι":[{"σ":[{},[0,0,0,0,0,2,1]],"ϲ":[{},[0,0,0,0,0,2,1]]}],"κ":[{},[0,0,0,0,2,1]],"ν":[{},[0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"ξ":[{},[0,0,0,0,2,1]]}],"έ":[{"ξ":[{},[0,0,0,0,2,1]]}],"σ":[{"ά":[{"β":[{},[0,0,0,3,2]],"ϐ":[{},[0,0,0,3,2]]}],"ά":[{"β":[{},[0,0,0,3,2]],"ϐ":[{},[0,0,0,3,2]]}],"α":[{"β":[{},[0,0,0,3,2]],"ϐ":[{},[0,0,0,3,2]]}],"ε":[{"ι":[{"σ":[{},[0,0,0,0,0,0,2,1]]}],"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"σ":[{"ε":[{"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]]}]}],"ν":[{},[0,0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,0,2,1]]}],"έ":[{"σ":[{"ε":[{"ι":[{},[0,0,0,3,2]]}]}]}],"έ":[{"σ":[{"ε":[{"ι":[{},[0,0,0,3,2]]}]}]}],"θ":[{"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"ι":[{"γ":[{},[0,0,0,4,3]]}]}],"κ":[{"ό":[{"π":[{},[0,0,0,3,2]]}],"ό":[{"π":[{},[0,0,0,3,2]]}]}],"τ":[{"α":[{"σ":[{},[0,0,0,3,2]],"τ":[{},[0,0,0,3,2]],"υ":[{},[0,0,0,3,2]]}],"ά":[{"τ":[{},[0,0,0,3,2]]}],"ά":[{"τ":[{},[0,0,0,3,2]]}],"ε":[{"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"ν":[{},[0,0,0,3,2]],"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"έ":[{"ν":[{},[0,0,0,3,2]],"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"έ":[{"ν":[{},[0,0,0,3,2]],"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"ή":[{"σ":[{},[0,0,0,3,2]]}],"ή":[{"σ":[{},[0,0,0,3,2]]}],"ό":[{"μ":[{},[0,0,0,3,2]]}],"ό":[{"μ":[{},[0,0,0,3,2]]}],"ο":[{"μ":[{},[0,0,0,3,2]]}],"ῴ":[{},[0,0,0,3,2]]}],"υ":[{"γ":[{},[0,0,0,3,2]],"μ":[{},[0,0,0,3,2]],"ν":[{},[0,0,0,3,2,2,1]]}],"φ":[{"ά":[{"γ":[{"μ":[{},[0,0,0,3,2]]}],"ζ":[{},[0,0,0,3,2]],"τ":[{"τ":[{},[0,0,0,3,2]]}]}],"ά":[{"γ":[{"μ":[{},[0,0,0,3,2]]}],"ζ":[{},[0,0,0,3,2]],"τ":[{"τ":[{},[0,0,0,3,2]]}]}]}],"χ":[{"ή":[{"μ":[{},[0,0,0,3,2]]}],"ή":[{"μ":[{},[0,0,0,3,2]]}]}],"ώ":[{"τ":[{},[0,0,0,3,2]]}],"ώ":[{"τ":[{},[0,0,0,3,2]]}],"ω":[{"τ":[{},[0,0,0,3,2]]}]},[0,0,0,2,1]],"ϲ":[{"ά":[{"β":[{},[0,0,0,3,2]],"ϐ":[{},[0,0,0,3,2]]}],"ά":[{"β":[{},[0,0,0,3,2]],"ϐ":[{},[0,0,0,3,2]]}],"α":[{"β":[{},[0,0,0,3,2]],"ϐ":[{},[0,0,0,3,2]]}],"ε":[{"ι":[{"ϲ":[{},[0,0,0,0,0,0,2,1]]}],"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"ϲ":[{"ε":[{"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]]}]}],"ν":[{},[0,0,0,0,0,2,1]],"ξ":[{},[0,0,0,0,0,2,1]]}],"έ":[{"ϲ":[{"ε":[{"ι":[{},[0,0,0,3,2]]}]}]}],"έ":[{"ϲ":[{"ε":[{"ι":[{},[0,0,0,3,2]]}]}]}],"θ":[{"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"ι":[{"γ":[{},[0,0,0,4,3]]}]}],"κ":[{"ό":[{"π":[{},[0,0,0,3,2]]}],"ό":[{"π":[{},[0,0,0,3,2]]}]}],"τ":[{"α":[{"ϲ":[{},[0,0,0,3,2]],"τ":[{},[0,0,0,3,2]],"υ":[{},[0,0,0,3,2]]}],"ά":[{"τ":[{},[0,0,0,3,2]]}],"ά":[{"τ":[{},[0,0,0,3,2]]}],"ε":[{"ί":[{},[0,0,0,3,2]],"ί":[{},[0,0,0,3,2]],"ν":[{},[0,0,0,3,2]],"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"έ":[{"ν":[{},[0,0,0,3,2]],"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"έ":[{"ν":[{},[0,0,0,3,2]],"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"ή":[{"ϲ":[{},[0,0,0,3,2]]}],"ή":[{"ϲ":[{},[0,0,0,3,2]]}],"ό":[{"μ":[{},[0,0,0,3,2]]}],"ό":[{"μ":[{},[0,0,0,3,2]]}],"ο":[{"μ":[{},[0,0,0,3,2]]}],"ῴ":[{},[0,0,0,3,2]]}],"υ":[{"γ":[{},[0,0,0,3,2]],"μ":[{},[0,0,0,3,2]],"ν":[{},[0,0,0,3,2,2,1]]}],"φ":[{"ά":[{"γ":[{"μ":[{},[0,0,0,3,2]]}],"ζ":[{},[0,0,0,3,2]],"τ":[{"τ":[{},[0,0,0,3,2]]}]}],"ά":[{"γ":[{"μ":[{},[0,0,0,3,2]]}],"ζ":[{},[0,0,0,3,2]],"τ":[{"τ":[{},[0,0,0,3,2]]}]}]}],"χ":[{"ή":[{"μ":[{},[0,0,0,3,2]]}],"ή":[{"μ":[{},[0,0,0,3,2]]}]}],"ώ":[{"τ":[{},[0,0,0,3,2]]}],"ώ":[{"τ":[{},[0,0,0,3,2]]}],"ω":[{"τ":[{},[0,0,0,3,2]]}]},[0,0,0,2,1]],"ϋ":[{"π":[{"ε":[{"ξ":[{},[0,0,0,0,0,0,2,1]]}]}]}]}],"ό":[{"σ":[{"θ":[{"ι":[{},[0,0,0,3,2]]}],"κ":[{"ο":[{"π":[{},[0,0,0,3,2]]}]}],"τ":[{"ε":[{"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"ῳ":[{},[0,0,0,3,2]]}],"φ":[{"α":[{"γ":[{"μ":[{},[0,0,0,3,2]]}]}]}],"χ":[{"η":[{"μ":[{},[0,0,0,3,2]]}]}],"ω":[{".":[{},[0,0,0,3,2]],"θ":[{"ε":[{"ν":[{".":[{},[0,0,0,3,2]]}]}]}]}]}],"ϲ":[{"θ":[{"ι":[{},[0,0,0,3,2]]}],"κ":[{"ο":[{"π":[{},[0,0,0,3,2]]}]}],"τ":[{"ε":[{"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"ῳ":[{},[0,0,0,3,2]]}],"φ":[{"α":[{"γ":[{"μ":[{},[0,0,0,3,2]]}]}]}],"χ":[{"η":[{"μ":[{},[0,0,0,3,2]]}]}],"ω":[{".":[{},[0,0,0,3,2]],"θ":[{"ε":[{"ν":[{".":[{},[0,0,0,3,2]]}]}]}]}]}]}],"ό":[{"σ":[{"θ":[{"ι":[{},[0,0,0,3,2]]}],"κ":[{"ο":[{"π":[{},[0,0,0,3,2]]}]}],"τ":[{"ε":[{"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"ῳ":[{},[0,0,0,3,2]]}],"φ":[{"α":[{"γ":[{"μ":[{},[0,0,0,3,2]]}]}]}],"χ":[{"η":[{"μ":[{},[0,0,0,3,2]]}]}],"ω":[{".":[{},[0,0,0,3,2]],"θ":[{"ε":[{"ν":[{".":[{},[0,0,0,3,2]]}]}]}]}]}],"ϲ":[{"θ":[{"ι":[{},[0,0,0,3,2]]}],"κ":[{"ο":[{"π":[{},[0,0,0,3,2]]}]}],"τ":[{"ε":[{"ρ":[{"ν":[{},[0,0,0,3,2]]}]}],"ῳ":[{},[0,0,0,3,2]]}],"φ":[{"α":[{"γ":[{"μ":[{},[0,0,0,3,2]]}]}]}],"χ":[{"η":[{"μ":[{},[0,0,0,3,2]]}]}],"ω":[{".":[{},[0,0,0,3,2]],"θ":[{"ε":[{"ν":[{".":[{},[0,0,0,3,2]]}]}]}]}]}]}]}],"υ":[{"ρ":[{"ά":[{"γ":[{},[0,0,2,1]]}],"ά":[{"γ":[{},[0,0,2,1]]}],"α":[{"γ":[{},[0,0,2,1]],"ί":[{"θ":[{},[0,0,2,1]]}],"ί":[{"θ":[{},[0,0,2,1]]}],"ι":[{"θ":[{},[0,0,2,1]]}],"κ":[{},[0,0,2,1]],"ύ":[{},[0,0,2,1]],"ύ":[{},[0,0,2,1]],"υ":[{},[0,0,2,1]]}],"ῆ":[{"θ":[{},[0,0,2,1]]}],"η":[{"θ":[{},[0,0,2,1]],"ν":[{"έ":[{"μ":[{},[0,0,2,1]]}],"έ":[{"μ":[{},[0,0,2,1]]}]}]}],"ή":[{"θ":[{},[0,0,2,1]],"ν":[{"ε":[{"μ":[{},[0,0,2,1]]}]}]}],"ή":[{"θ":[{},[0,0,2,1]],"ν":[{"ε":[{"μ":[{},[0,0,2,1]]}]}]}],"ω":[{"π":[{},[0,0,2,1]]}]}]}],"ύ":[{"ρ":[{"α":[{"υ":[{},[0,0,2,1]]}]}]}],"ύ":[{"ρ":[{"α":[{"υ":[{},[0,0,2,1]]}]}]}]},[0,4]],"ρ":[{},[0,4]],"σ":[{"ε":[{"λ":[{"α":[{"σ":[{"φ":[{"ό":[{},[0,0,0,0,2,1]],"ό":[{},[0,0,0,0,2,1]],"ο":[{},[0,0,0,0,2,1]]}]}]}]}]}],"υ":[{"μ":[{"π":[{"α":[{"ρ":[{"ε":[{"ι":[{"σ":[{},[0,0,0,0,0,0,0,0,2,1]]}]}]}]}]}]}],"ν":[{"δ":[{"ι":[{"έ":[{"ξ":[{},[0,0,0,0,0,0,2,1]]}],"έ":[{"ξ":[{},[0,0,0,0,0,0,2,1]]}],"ε":[{"ξ":[{},[0,0,0,0,0,0,2,1]]}]}],"υ":[{"σ":[{},[0,0,0,0,0,2,1]]}]}],"ε":[{"ξ":[{},[0,0,0,0,2,1]]}]},[0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,2,1]]}]},[0,4]],"ϲ":[{"ε":[{"λ":[{"α":[{"ϲ":[{"φ":[{"ό":[{},[0,0,0,0,2,1]],"ό":[{},[0,0,0,0,2,1]],"ο":[{},[0,0,0,0,2,1]]}]}]}]}]}],"υ":[{"μ":[{"π":[{"α":[{"ρ":[{"ε":[{"ι":[{"ϲ":[{},[0,0,0,0,0,0,0,0,2,1]]}]}]}]}]}]}],"ν":[{"δ":[{"ι":[{"έ":[{"ξ":[{},[0,0,0,0,0,0,2,1]]}],"έ":[{"ξ":[{},[0,0,0,0,0,0,2,1]]}],"ε":[{"ξ":[{},[0,0,0,0,0,0,2,1]]}]}],"υ":[{"ϲ":[{},[0,0,0,0,0,2,1]]}]}],"ε":[{"ξ":[{},[0,0,0,0,2,1]]}]},[0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,2,1]]}],"ύ":[{"ν":[{},[0,0,2,1]]}]},[0,4]],"τ":[{"ε":[{"σ":[{"σ":[{"α":[{"ρ":[{"ε":[{"σ":[{"κ":[{},[0,0,0,0,0,0,0,2,1]]}]}]}]}]}]}],"ϲ":[{"ϲ":[{"α":[{"ρ":[{"ε":[{"ϲ":[{"κ":[{},[0,0,0,0,0,0,0,2,1]]}]}]}]}]}]}]}],"ρ":[{"ε":[{"ι":[{"σ":[{"κ":[{},[0,0,0,0,2,1]]}],"ϲ":[{"κ":[{},[0,0,0,0,2,1]]}]}]}],"ι":[{"σ":[{"μ":[{"ό":[{},[0,0,0,3,2]],"ό":[{},[0,0,0,3,2]],"ο":[{},[0,0,0,3,2]],"ῶ":[{},[0,0,0,3,2]]}],"π":[{},[0,0,0,3,2]],"τ":[{},[0,0,0,3,2]],"ώ":[{},[0,0,0,3,2]],"ώ":[{},[0,0,0,3,2]],"ω":[{},[0,0,0,3,2]]},[0,0,0,2,1]],"ϲ":[{"μ":[{"ό":[{},[0,0,0,3,2]],"ό":[{},[0,0,0,3,2]],"ο":[{},[0,0,0,3,2]],"ῶ":[{},[0,0,0,3,2]]}],"π":[{},[0,0,0,3,2]],"τ":[{},[0,0,0,3,2]],"ώ":[{},[0,0,0,3,2]],"ώ":[{},[0,0,0,3,2]],"ω":[{},[0,0,0,3,2]]},[0,0,0,2,1]]}],"ί":[{"σ":[{"τ":[{},[0,0,0,3,2]]}],"ϲ":[{"τ":[{},[0,0,0,3,2]]}]}],"ί":[{"σ":[{"τ":[{},[0,0,0,3,2]]}],"ϲ":[{"τ":[{},[0,0,0,3,2]]}]}]}]},[0,4]],"φ":[{"α":[{"ε":[{"σ":[{"φ":[{},[0,0,0,2,1]]}],"ϲ":[{"φ":[{},[0,0,0,2,1]]}]}]}],"ω":[{"σ":[{"φ":[{},[0,0,2,1]]}],"ϲ":[{"φ":[{},[0,0,2,1]]}]}]},[0,4]],"χ":[{"α":[{"ρ":[{"ι":[{"σ":[{"α":[{"ν":[{"δ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}],"ά":[{"ν":[{"δ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}],"ά":[{"ν":[{"δ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}]}],"ϲ":[{"α":[{"ν":[{"δ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}],"ά":[{"ν":[{"δ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}],"ά":[{"ν":[{"δ":[{"ρ":[{},[0,0,0,0,2,1]]}]}]}]}]}]}]}],"ε":[{"ι":[{"ρ":[{"ά":[{"γ":[{},[0,0,0,2,1]],"ν":[{},[0,0,0,2,1]]}],"ά":[{"γ":[{},[0,0,0,2,1]],"ν":[{},[0,0,0,2,1]]}],"α":[{"γ":[{},[0,0,0,2,1]],"π":[{},[0,0,0,2,1]],"ψ":[{},[0,0,0,2,1]],"ν":[{},[0,0,0,2,1]]}],"ο":[{"υ":[{},[0,0,0,2,1]]}],"ῶ":[{"ν":[{},[0,0,0,2,1]]}]}]}]}],"η":[{"ν":[{"ν":[{"α":[{"λ":[{},[0,0,2,1]]}]}]}]}]},[0,4]],"ψ":[{},[0,4]]}],"ῤ":[{"ῥ":[{},[2,1]]}]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
