(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsHu = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"a":[{"d":[{"a":[{"t":[{"á":[{"t":[{"a":[{},[0,0,0,0,0,0,1,2]]}]}],"e":[{},[0,0,0,2,1,2]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,1]],"z":[{},[0,0,0,2,3]]}]}],"y":[{"é":[{".":[{},[0,0,1]]}],"i":[{},[0,0,1]]}]}],"g":[{"o":[{"s":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,2]]}],"y":[{"a":[{"g":[{"g":[{},[0,0,0,0,0,1]]}]}],"á":[{"r":[{"a":[{"m":[{},[0,0,0,1,2]]}],"t":[{},[0,0,0,1]]}]}],"e":[{},[0,0,0,1,2]],"o":[{"n":[{},[0,0,0,0,0,1]]},[0,0,0,0,2]],"ó":[{},[0,0,0,1,2]],"ű":[{},[0,0,0,1,2]]}]}],"k":[{"á":[{"c":[{"c":[{},[0,0,0,0,1]],"s":[{},[0,0,0,2]]}]}],"h":[{},[0,0,2]],"o":[{},[0,0,0,2]],"t":[{"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"o":[{"r":[{"r":[{},[0,0,2,1]]}]}],"ő":[{},[0,0,2,1,2]]}],"u":[{"p":[{},[0,0,0,1,2]]}]}],"l":[{"a":[{"g":[{},[0,0,0,2,1]],"k":[{"a":[{},[0,0,0,0,1,2]],"ö":[{},[0,0,0,2,1,2]],"ő":[{},[0,0,0,2,1,2]]}],"p":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2,1]]}]}],"e":[{"g":[{},[0,0,1]]}],"i":[{"s":[{},[0,0,1]]}],"j":[{"á":[{"r":[{"n":[{},[0,0,2]]}]}],"e":[{"l":[{"ö":[{},[0,0,0,0,0,1,2]]},[0,0,2,1]]},[0,0,0,0,2]]}],"o":[{"m":[{},[0,0,0,2,1]],"s":[{},[0,0,1]]}],"t":[{"a":[{"k":[{},[0,0,2,1,2]]}],"e":[{"r":[{"j":[{},[0,0,2,1]]}]}],"é":[{"n":[{},[0,0,2]],"r":[{"n":[{},[0,0,2]],"t":[{},[0,0,2]]}]}],"i":[{"n":[{},[0,0,2]]}]}]}],"m":[{"a":[{"k":[{},[0,0,1]]}]}],"n":[{"g":[{"o":[{"l":[{"ó":[{},[0,0,0,0,2,1,2]]}]}]}],"t":[{"h":[{},[0,0,1]],"i":[{"s":[{},[0,0,0,0,1]]}]}]}],"p":[{"a":[{"p":[{},[0,0,0,1,2]]}],"á":[{"l":[{"y":[{"á":[{"z":[{},[0,0,0,2,0,1,2]]}]}]}]}]}],"r":[{"a":[{"n":[{"y":[{"e":[{},[0,0,0,2,0,1,2]]}]}],"s":[{"z":[{"e":[{},[0,0,0,2]]}]}]}],"á":[{"c":[{},[0,0,1,2]]}],"c":[{"a":[{"l":[{},[0,0,2]]}],"c":[{},[0,0,0,3]],"e":[{},[0,0,2,1,2]],"é":[{"l":[{},[0,0,2]]}],"h":[{"á":[{},[0,0,2,3]],"o":[{"z":[{},[0,0,2,3]]}]}],"i":[{"n":[{},[0,0,2]],"o":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"s":[{},[0,0,2,3]]}],"k":[{"h":[{},[0,0,1]]}]}],"t":[{"h":[{},[0,0,2]]}],"z":[{"a":[{},[0,0,1,2]],"á":[{"m":[{},[0,0,1]]}],"e":[{},[0,0,0,2]],"ó":[{},[0,0,1,2]]}]},[0,2]],"á":[{"c":[{"s":[{"é":[{"k":[{},[0,0,0,1]]}]}]}],"g":[{"á":[{"r":[{"n":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"ó":[{},[0,0,1,2]],"y":[{"a":[{"l":[{"a":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,0,1]]}]}],"á":[{"r":[{"t":[{},[0,0,0,1]]}],"z":[{},[0,0,0,1,2]]}]}]}],"l":[{"a":[{},[0,0,1,2]],"é":[{},[0,0,1]],"i":[{"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]}]}]},[0,0,1,2]],"l":[{"a":[{"l":[{"j":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"i":[{"n":[{},[0,0,2]]}]}],"o":[{"k":[{},[0,0,1,2]]}],"ú":[{},[0,0,1]]}],"r":[{"a":[{"j":[{},[0,0,1]],"k":[{"t":[{"á":[{},[0,0,1]]}]}],"l":[{},[0,0,1,2]],"m":[{"e":[{},[0,0,0,2,1]]}],"p":[{},[0,0,1,2]],"s":[{"z":[{"ó":[{},[0,0,1]]},[0,0,0,2]]}]}],"á":[{"c":[{},[0,0,1]],"l":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"d":[{},[0,0,1,2]],"e":[{"m":[{},[0,0,1]]},[0,0,0,2]],"é":[{},[0,0,0,2]],"i":[{"r":[{},[0,0,1]]}],"n":[{"y":[{"e":[{"l":[{},[0,0,2]]}]}]}],"o":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"s":[{},[0,0,1,2]],"t":[{"r":[{},[0,0,1,2]]}]}],"s":[{"z":[{"á":[{"l":[{},[0,0,0,1]],"r":[{"b":[{},[0,0,0,1]],"é":[{},[0,0,0,1,2]],"i":[{},[0,0,0,1,2]],"o":[{},[0,0,0,1,2]]}]}]}]}],"t":[{"a":[{"d":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"l":[{"t":[{},[0,0,1]]}],"n":[{},[0,0,1,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"á":[{},[0,0,1,2]],"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"i":[{},[0,0,1,2]],"o":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"ó":[{"h":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]],"ö":[{},[0,0,1,2]],"u":[{},[0,0,1]],"ü":[{},[0,0,1,2]],"ű":[{},[0,0,1]]}]},[0,2]],"b":[{"a":[{"b":[{"a":[{"r":[{"á":[{},[0,0,2,1,2]]}]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"o":[{"l":[{},[0,0,2]]}]}],"j":[{"á":[{"r":[{"a":[{"t":[{},[0,0,2,1,2]]}]}]}],"e":[{},[0,0,2,1]]}],"k":[{"a":[{"s":[{"z":[{"t":[{},[0,0,0,1]]}]}]}],"á":[{"l":[{},[0,0,2]],"r":[{"o":[{},[0,0,2,1,2]]}]}],"é":[{},[0,0,0,0,2]],"ö":[{},[0,0,2,1,2]],"u":[{"r":[{},[0,0,2]]}]}],"l":[{"e":[{"g":[{},[0,0,2,1,2]]}]}],"t":[{"s":[{},[0,0,1]]}],"u":[{},[0,0,2]]}],"á":[{"l":[{"ó":[{},[0,0,2,1,2]]}],"r":[{"a":[{},[0,0,0,1]]}],"t":[{"h":[{},[0,0,1]]}]}],"e":[{"a":[{"t":[{".":[{},[0,0,2]]}]}],"d":[{},[0,0,1,2]],"i":[{},[0,0,0,2]],"k":[{"r":[{},[0,0,1]]}],"s":[{"t":[{"r":[{},[0,0,1]]}],"z":[{"k":[{},[0,0,1]]}]}],"t":[{"é":[{"t":[{"e":[{"l":[{},[0,0,0,0,2,1,2]]}]}]}],"r":[{},[0,0,1]]}]}],"é":[{"r":[{"c":[{"s":[{"í":[{},[0,0,0,2,3]]}]}],"o":[{},[0,0,2,1]]}]}],"i":[{"k":[{"e":[{},[0,0,2]]}],"o":[{"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"t":[{"a":[{"g":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"o":[{"r":[{"r":[{},[0,0,2,1]]}]}],"u":[{"r":[{},[0,0,2]]}]}]}],"o":[{"g":[{"ó":[{},[0,0,2,1,2]]}],"l":[{"t":[{"a":[{},[0,0,0,2]]}],"y":[{"ó":[{},[0,0,2,0,1,2]]}]}],"n":[{"a":[{"v":[{},[0,0,2]]}]}],"r":[{"a":[{"j":[{},[0,0,2]],"n":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{"c":[{},[0,0,2]],"l":[{},[0,0,2]]}],"o":[{"d":[{"v":[{},[0,0,2,1]]}]}],"s":[{"é":[{"t":[{},[0,0,0,2]]}]}],"t":[{},[0,0,0,0,2]]}],"t":[{"á":[{},[0,0,2]]}]}],"r":[{"a":[{"i":[{},[0,0,0,2]]}]}],"u":[{"s":[{"z":[{"e":[{},[0,0,2,0,1]]}]}]}]},[0,2]],"c":[{"e":[{"n":[{"t":[{"á":[{},[0,0,0,2,1]],"ó":[{},[0,0,0,2,1,2]]}]}],"t":[{"e":[{"l":[{},[0,0,2,1,2]]}],"ű":[{},[0,0,2,1]]}]}],"é":[{"l":[{"e":[{},[0,0,2,1,2]]}]}],"i":[{"n":[{"á":[{},[0,0,2,1,2]]}],"t":[{"o":[{},[0,0,0,0,1]]}]}],"s":[{"a":[{"k":[{},[0,0,0,2,1]],"p":[{"á":[{"g":[{},[0,0,0,2,1,2]]}]}],"t":[{"é":[{},[0,0,0,2,1,2]]}]}],"e":[{"l":[{"ő":[{"r":[{},[0,0,0,2,1,2]]}]}]}]},[0,0,2]]},[0,2]],"d":[{"a":[{"c":[{"c":[{},[0,0,0,1]],"s":[{},[0,0,2,3]]}],"i":[{},[0,0,2]],"l":[{"a":[{"n":[{},[0,0,0,1]]}],"á":[{"s":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"é":[{"k":[{},[0,0,2,1]],"n":[{},[0,0,2]]}],"í":[{},[0,0,2,1,2]],"o":[{"l":[{},[0,0,3]]}],"ó":[{},[0,0,2,1,2]]}],"n":[{"n":[{},[0,0,0,1]]}],"u":[{},[0,0,2]]}],"e":[{"n":[{"g":[{},[0,0,0,2,1]]}]}],"é":[{"l":[{"a":[{},[0,0,2]]}],"r":[{"e":[{"s":[{},[0,0,2]]},[0,0,0,0,2]]}],"s":[{"a":[{},[0,0,2]]}]}],"i":[{"a":[{"f":[{"o":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]]}],"l":[{},[0,0,2]]}],"c":[{"s":[{"á":[{},[0,0,2]]}]}],"ó":[{"m":[{"á":[{},[0,0,2]]}]}]}],"ó":[{"m":[{"o":[{"r":[{},[0,0,2]]}]}]}],"ú":[{"r":[{"a":[{},[0,0,2]]}]}]},[0,2]],"e":[{"b":[{"e":[{"g":[{},[0,0,1]]}],"i":[{"r":[{},[0,0,1]]}],"í":[{},[0,0,1]],"u":[{},[0,0,1,2]]}],"g":[{"é":[{},[0,0,2]],"r":[{"e":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"y":[{"a":[{},[0,0,0,1,2]],"á":[{},[0,0,0,1,2]],"e":[{"l":[{"ő":[{"r":[{},[0,0,0,1,2]]}]}],"v":[{},[0,0,0,1]]}],"i":[{"n":[{},[0,0,0,1]]}],"ö":[{},[0,0,0,1,2]],"ü":[{"l":[{},[0,0,0,1,2]]}]}]}],"l":[{"a":[{"k":[{},[0,0,1,2]],"n":[{},[0,0,1]],"p":[{},[0,0,1]],"s":[{"s":[{},[0,0,1]],"z":[{"n":[{},[0,0,1]],"o":[{},[0,0,1]],"v":[{},[0,0,1]]}]},[0,0,0,2]]}],"á":[{},[0,0,1,2]],"e":[{"c":[{},[0,0,1,2]],"g":[{"e":[{"r":[{},[0,0,1]]}],"y":[{"á":[{},[0,0,0,2]]}]}],"h":[{},[0,0,1,2]],"j":[{"t":[{},[0,0,1]]}],"l":[{},[0,0,1,2]],"m":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{"g":[{},[0,0,0,2]],"l":[{"e":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,2]]}],"é":[{"s":[{},[0,0,1,2]]}]}],"n":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{"e":[{},[0,0,1,2]],"é":[{"s":[{},[0,0,1,2]]}],"h":[{},[0,0,1]],"i":[{},[0,0,1,2]],"n":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]],"é":[{"l":[{},[0,0,1]]}],"ü":[{},[0,0,1]]}],"ü":[{},[0,0,1,2]],"v":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"t":[{},[0,0,1,2]],"v":[{"e":[{"t":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"i":[{},[0,0,1]]}]}],"é":[{"d":[{"e":[{},[0,0,1]]},[0,0,0,2]],"g":[{"e":[{"k":[{},[0,0,1,2]]}]}],"h":[{},[0,0,1]],"k":[{"e":[{"z":[{},[0,0,1]]}]}],"l":[{"e":[{},[0,0,1,2]]}],"n":[{"e":[{},[0,0,1]]},[0,0,0,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{"e":[{"t":[{".":[{},[0,0,1,2]]}]}]}],"v":[{},[0,0,1,2]]}],"i":[{"d":[{},[0,0,1]],"g":[{},[0,0,1]],"h":[{},[0,0,1,2]],"k":[{},[0,0,1]],"m":[{"i":[{"t":[{},[0,0,1,2]]}]}],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1,2]],"t":[{"o":[{},[0,0,0,2,1]],"t":[{"a":[{".":[{},[0,0,1]]}],"á":[{"k":[{},[0,0,1]]}]}]}],"z":[{"z":[{},[0,0,1]]}]}],"í":[{},[0,0,1]],"l":[{"e":[{"g":[{"e":[{},[0,0,0,0,0,0,2]]}]}]}],"o":[{"k":[{"k":[{},[0,0,1]],"o":[{},[0,0,1]]}],"r":[{},[0,0,1]]},[0,0,0,2]],"ó":[{},[0,0,1,2]],"ö":[{"k":[{},[0,0,1]],"l":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1]],"j":[{".":[{},[0,0,1]],"e":[{},[0,0,1]],"é":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]],"é":[{".":[{},[0,0,1]],"m":[{},[0,0,1]]}],"i":[{},[0,0,1]]}],"ő":[{},[0,0,1]],"t":[{".":[{},[0,0,1]],"e":[{},[0,0,1]],"é":[{},[0,0,1]],"n":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"ü":[{"n":[{},[0,0,1]]}],"v":[{},[0,0,1]]}],"v":[{},[0,0,1]]},[0,0,0,2]],"ő":[{"é":[{},[0,0,0,0,2]]}],"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"u":[{},[0,0,1]],"ü":[{"l":[{".":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1]],"j":[{},[0,0,1]],"n":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]]}],"v":[{},[0,0,1]]}]},[0,0,0,2]],"v":[{"e":[{"l":[{},[0,0,2,1]]}],"é":[{"g":[{".":[{},[0,0,2,1]]}]}]}]}],"s":[{"e":[{"r":[{},[0,0,1]],"t":[{"e":[{"l":[{},[0,0,0,2]]}]}]}],"t":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1]],"é":[{"k":[{"e":[{".":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]]}]}]}]}]}],"t":[{"h":[{},[0,0,2]],"i":[{"l":[{"é":[{"n":[{"g":[{},[0,0,0,0,0,0,1,2]]}]}]}]}]}],"v":[{"é":[{"s":[{"s":[{},[0,0,0,0,1]]}]}]}],"x":[{"e":[{"l":[{},[0,0,1]]}]}],"z":[{"á":[{},[0,0,1]],"e":[{"l":[{},[0,0,1,2]]}]}]},[0,2]],"é":[{"d":[{"e":[{"s":[{"s":[{},[0,0,0,0,3]]}]}]}],"g":[{"a":[{},[0,0,1,2]],"e":[{"g":[{},[0,0,1]],"r":[{"e":[{"i":[{},[0,0,1,2]]}]}],"s":[{"z":[{},[0,0,1]]},[0,0,0,2]]}],"é":[{"r":[{".":[{},[0,0,1]],"é":[{},[0,0,1,2]],"n":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{"b":[{},[0,0,1]],"e":[{},[0,0,1]],"é":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]},[0,0,0,2]]}]}],"ö":[{},[0,0,1,2]],"u":[{},[0,0,1,2]]}],"h":[{"é":[{"v":[{},[0,0,1]]}]}],"j":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"e":[{"l":[{},[0,0,1]]}],"u":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1]],"e":[{"s":[{"s":[{},[0,0,0,0,1]]}]}],"i":[{"r":[{},[0,0,1]]}],"o":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1,2]],"c":[{"i":[{},[0,0,2,1]]}],"i":[{"k":[{"e":[{},[0,0,1]]},[0,0,0,2]]}],"v":[{"á":[{},[0,0,2,1,2]]}]}],"p":[{"e":[{"s":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,2]],"e":[{"l":[{},[0,0,2,1]]}],"é":[{},[0,0,2]],"o":[{},[0,0,2]]}]}],"r":[{"a":[{"n":[{},[0,0,1,2]]}],"c":[{"e":[{"l":[{},[0,0,2,1,2]]}],"é":[{"j":[{},[0,0,2,1,2]],"k":[{},[0,0,2]]}],"s":[{"í":[{},[0,0,2,3]]}]}],"e":[{"l":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"é":[{"s":[{"z":[{"é":[{},[0,0,1]]},[0,0,0,2]]}],"t":[{},[0,0,1,2]]}],"ü":[{"l":[{},[0,0,1]]},[0,0,0,2]],"v":[{"a":[{"d":[{},[0,0,2]],"l":[{},[0,0,2]]}],"é":[{"g":[{".":[{},[0,0,2,1]]}]}]}]}],"s":[{"z":[{"a":[{"l":[{},[0,0,0,1,2]]}],"á":[{},[0,0,0,1]],"e":[{"l":[{},[0,0,0,1]],"m":[{},[0,0,0,1]],"s":[{},[0,0,0,1]]},[0,0,0,0,2]],"é":[{"k":[{},[0,0,0,1,2]]}],"i":[{"g":[{"a":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"o":[{},[0,0,0,1]],"ő":[{},[0,0,0,1,2]],"t":[{"ö":[{"r":[{"v":[{},[0,0,0,2,1]]}]}]}],"ü":[{"l":[{"ő":[{},[0,0,0,1]]}]},[0,0,0,0,2]]}]}],"v":[{"á":[{"g":[{},[0,0,1,2]]}],"e":[{"s":[{"s":[{"z":[{},[0,0,1]]}]}]}],"é":[{"g":[{},[0,0,1,2]],"k":[{},[0,0,1,2]]}]}]},[0,2]],"f":[{"a":[{"i":[{"t":[{".":[{},[0,0,2]]}]}],"l":[{"e":[{"g":[{},[0,0,2]]}]}],"n":[{"é":[{"v":[{},[0,0,2,1]]}]}],"r":[{"o":[{"n":[{"t":[{},[0,0,2,1]]}]}]}],"s":[{"t":[{},[0,0,1]]},[0,0,0,2]],"t":[{"r":[{},[0,0,1]]},[0,0,0,2]]}],"e":[{"l":[{"e":[{"m":[{"e":[{},[0,0,2]]}],"s":[{"s":[{"z":[{},[0,0,2,1]]}]}],"v":[{},[0,0,2]]}]}]}],"é":[{"k":[{"e":[{"l":[{},[0,0,2,1,2]]}]}],"m":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]]}]}],"i":[{"l":[{"m":[{"é":[{"r":[{"é":[{},[0,0,0,2]]}]}]}]}],"n":[{"g":[{"e":[{},[0,0,0,2]]}]}]}],"o":[{"g":[{"ó":[{"s":[{"z":[{"á":[{},[0,0,0,0,2,3]]}]}]}]}],"l":[{"t":[{"a":[{},[0,0,0,2,1,2]]}]}]}],"ö":[{"l":[{"ő":[{},[0,0,2]],"ü":[{"l":[{".":[{},[0,0,2]],"e":[{},[0,0,0,0,0,1,2]]}]}]}]}]},[0,2]],"g":[{"a":[{"z":[{"a":[{"n":[{},[0,0,2]]}]}]}],"á":[{"t":[{"a":[{"l":[{},[0,0,0,1]]}],"e":[{},[0,0,2]]}],"z":[{"ó":[{},[0,0,2,1,2]],"s":[{"u":[{},[0,0,2]]},[0,0,0,0,2]],"z":[{},[0,0,0,1]]}]}],"e":[{"n":[{"e":[{"a":[{},[0,0,0,0,2]]}]}],"o":[{"d":[{},[0,0,2]],"s":[{},[0,0,2]]}],"s":[{"z":[{"t":[{"í":[{},[0,0,0,0,2,1]]}]}]}]}],"é":[{"d":[{},[0,0,2,1]],"n":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"n":[{},[0,0,0,3]]}],"p":[{"e":[{"l":[{"e":[{"m":[{},[0,0,2,0,2]]}]}]}],"i":[{"p":[{},[0,0,2,1,2]]}]}]}],"i":[{"g":[{"a":[{"s":[{},[0,0,0,0,1]]}]}]}],"o":[{"n":[{"o":[{"r":[{"r":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,0,1]]}]}]}],"ó":[{"c":[{"e":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2]],"s":[{},[0,0,2,1,2]]}],"i":[{"g":[{"a":[{},[0,0,2,1]]},[0,0,0,0,2]],"s":[{},[0,0,2]]}]}]}],"ő":[{"z":[{"á":[{},[0,0,2,1,2]],"e":[{"n":[{},[0,0,2]]}],"ő":[{},[0,0,2,1]],"s":[{},[0,0,2]]}]}],"u":[{"i":[{},[0,0,2]]}]},[0,2]],"h":[{"a":[{"b":[{"e":[{},[0,0,2,1,2]],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"ő":[{},[0,0,2,1]],"u":[{},[0,0,2,1]]}],"d":[{"a":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"i":[{"k":[{},[0,0,2]]}],"j":[{"e":[{},[0,0,2,1,2]],"o":[{"m":[{},[0,0,2]]}]}],"l":[{"á":[{"c":[{},[0,0,2]],"l":[{"ó":[{},[0,0,0,0,2,1,2]]}],"r":[{"v":[{},[0,0,2]]}]}],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"p":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2,1,2]]}],"i":[{"s":[{},[0,0,2]]}]}],"n":[{"g":[{"a":[{"d":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]]}]}],"s":[{"o":[{"r":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,0,3]]}]}],"t":[{"a":[{"g":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"e":[{},[0,0,2,1,2]],"o":[{"l":[{"d":[{},[0,0,2]]}]}]}]}],"á":[{"m":[{"a":[{},[0,0,2,1]]}],"n":[{"y":[{"i":[{"n":[{},[0,0,2,0,1]]}]}]}],"r":[{"o":[{"m":[{"e":[{},[0,0,0,0,2,1]]}]}]}],"t":[{"a":[{"l":[{"j":[{},[0,0,2,1]]}]}],"u":[{"s":[{},[0,0,2]]}]}],"z":[{"o":[{"l":[{},[0,0,2]]}],"ó":[{},[0,0,2]]}]}],"e":[{"i":[{},[0,0,2]]}],"é":[{"t":[{"e":[{"z":[{},[0,0,2,1]]}],"o":[{},[0,0,2,1]]}]}],"i":[{"t":[{"a":[{},[0,0,0,1]],"i":[{"s":[{},[0,0,2]]}]}]}],"o":[{"d":[{"á":[{"s":[{},[0,0,0,0,0,1]]}]}],"l":[{"l":[{},[0,0,0,1]],"t":[{"e":[{},[0,0,0,2,1]]}]}],"n":[{"e":[{},[0,0,2]]}]}],"ő":[{"s":[{"á":[{},[0,0,2]]}]}]},[0,2]],"i":[{"k":[{"e":[{"r":[{"i":[{},[0,0,0,2,1]],"ü":[{"l":[{"é":[{},[0,0,0,2,1]]}]},[0,0,0,0,0,2]]}]}],"o":[{"n":[{"s":[{},[0,0,0,0,1]]}]}]}],"m":[{"a":[{"s":[{},[0,0,0,1]]}],"p":[{"l":[{"a":[{},[0,0,1,2]]}]}]}],"n":[{"a":[{"k":[{"t":[{"í":[{},[0,0,1]]}]}]}],"g":[{"i":[{"n":[{},[0,0,2]]}]}],"t":[{"e":[{"r":[{"a":[{},[0,0,0,0,2,1]]}]}]}]}],"o":[{"n":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"e":[{},[0,0,2]],"n":[{},[0,0,0,3]]}]}],"p":[{"a":[{"r":[{"e":[{},[0,0,0,2]]}]}]}],"z":[{"o":[{"m":[{"é":[{"r":[{"t":[{},[0,0,0,2,1]]}]}]}]}]}]},[0,2]],"í":[{"j":[{"á":[{"t":[{"o":[{},[0,0,1]]},[0,0,0,2]]}]}],"n":[{"e":[{},[0,0,1]]}],"r":[{"á":[{"s":[{"á":[{"g":[{},[0,0,0,2,1]]}],"z":[{},[0,0,0,2,3]]}]}]}],"v":[{"a":[{},[0,0,1,2]],"á":[{"r":[{},[0,0,1,2]]}],"e":[{"l":[{"l":[{},[0,0,1]]}]}]}],"z":[{"a":[{},[0,0,1]],"i":[{"n":[{},[0,0,1]]}]}]},[0,2]],"j":[{"a":[{"k":[{"é":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"o":[{"v":[{},[0,0,2]]}]}]}],"á":[{"r":[{"m":[{"ű":[{"k":[{"á":[{},[0,0,0,0,0,0,0,2]]}]}]}]}],"s":[{"z":[{"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}]}],"e":[{"g":[{"y":[{"a":[{},[0,0,2,0,1,2]],"á":[{},[0,0,2,0,1,2]]}]}],"l":[{"a":[{},[0,0,2,1]],"e":[{"g":[{},[0,0,2]],"v":[{},[0,0,2]]}]}]}],"o":[{"b":[{"b":[{"o":[{"l":[{},[0,0,0,2,1]]}]}]}]}],"ó":[{"d":[{"a":[{"l":[{},[0,0,2]]}]}],"s":[{"e":[{},[0,0,2,1,2]]}],"t":[{"á":[{},[0,0,2,1]]}]}]},[0,2]],"k":[{"a":[{"l":[{"e":[{"i":[{},[0,0,0,0,2]]}]}],"n":[{"a":[{"r":[{},[0,0,2]]}],"e":[{},[0,0,2,1]]}],"p":[{"o":[{"l":[{"c":[{},[0,0,0,0,0,0,1]]}]}]}],"r":[{"a":[{"l":[{"a":[{},[0,0,2]]}],"s":[{},[0,0,2]]}],"á":[{"s":[{},[0,0,2,1,2]]}],"c":[{"s":[{"e":[{},[0,0,0,2,3]]}]}],"e":[{"m":[{},[0,0,2]]},[0,0,0,0,2]],"é":[{"k":[{},[0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,2]]}]}],"í":[{},[0,0,2]],"ó":[{"r":[{"a":[{},[0,0,2,0,2]],"á":[{"k":[{},[0,0,2,1,2]]}]}]}],"ü":[{},[0,0,2,1]]}],"t":[{"h":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"á":[{"r":[{"a":[{"d":[{},[0,0,0,1,2]]}]}],"s":[{"a":[{"l":[{},[0,0,0,0,3]]}]},[0,0,0,2]]}],"e":[{"c":[{"s":[{"ó":[{},[0,0,2]]}]}],"l":[{"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2,1,2]],"v":[{"e":[{},[0,0,2,1,2]]}]}],"ö":[{},[0,0,0,1]]}],"r":[{"t":[{"a":[{},[0,0,0,2]]}]}]}],"é":[{"n":[{"é":[{"t":[{},[0,0,2]]}]}],"p":[{"é":[{"s":[{},[0,0,2,1]]}]}],"t":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2]],"g":[{},[0,0,2,1]],"k":[{"a":[{},[0,0,2]]}],"l":[{},[0,0,2]],"n":[{},[0,0,2]],"p":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]],"u":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"l":[{"e":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"o":[{},[0,0,2,1,2]]}],"z":[{"e":[{"l":[{},[0,0,2,1]],"m":[{},[0,0,2]]},[0,0,0,0,2]],"s":[{},[0,0,2]],"z":[{},[0,0,0,1]]}]}],"i":[{"á":[{},[0,0,0,2]],"g":[{},[0,0,1,2]],"k":[{"r":[{"á":[{},[0,0,1]]}]}],"ó":[{},[0,0,0,2]],"s":[{"á":[{"g":[{},[0,0,2]]}]}],"ű":[{},[0,0,0,2]]}],"l":[{"a":[{"u":[{"z":[{},[0,0,0,2]]}]}],"e":[{"i":[{},[0,0,0,2]]}],"ó":[{"r":[{"e":[{},[0,0,0,2]]}]}]}],"o":[{"r":[{"á":[{"c":[{},[0,0,2]]}],"í":[{},[0,0,2]]}],"s":[{"i":[{"s":[{},[0,0,2]]}]}]}],"ó":[{"d":[{"a":[{},[0,0,2,1,2]]}],"r":[{"e":[{},[0,0,2,1]],"é":[{"s":[{},[0,0,2,1,2]]}]}]}],"ö":[{"b":[{"ö":[{"l":[{},[0,0,2,1]]}]}],"d":[{"ő":[{},[0,0,2,1]]}],"z":[{"i":[{"s":[{},[0,0,2]]}],"ő":[{},[0,0,2,1]],"z":[{},[0,0,0,1]]}]}],"r":[{},[0,0,2]],"u":[{"n":[{"a":[{},[0,0,0,1]]}]}],"v":[{"a":[{"r":[{"k":[{".":[{},[0,0,0,0,3]]}]}]}]}]},[0,2]],"l":[{"a":[{"k":[{"a":[{"d":[{},[0,0,0,1,2]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1]]}],"é":[{"p":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2]]}],"ő":[{},[0,0,2]]}],"n":[{"t":[{"e":[{},[0,0,0,2,1]],"ó":[{},[0,0,0,2,1,2]]}]}],"p":[{"a":[{"l":[{},[0,0,2]]}],"á":[{"c":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]]}],"e":[{},[0,0,2,1,2]],"o":[{"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2]]}]}],"á":[{"b":[{"e":[{},[0,0,2,1,2]],"i":[{"l":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2]]}]}],"n":[{"c":[{"s":[{},[0,0,0,2,3]]}],"y":[{"a":[{"n":[{},[0,0,2]]}],"e":[{},[0,0,2,0,1,2]]}]}],"p":[{"e":[{},[0,0,2,1]],"i":[{"l":[{},[0,0,2,1]]}]}],"z":[{"ó":[{},[0,0,2,1,2]],"s":[{},[0,0,2,3]]}]}],"e":[{"d":[{"é":[{},[0,0,3]]}],"g":[{"a":[{"l":[{"i":[{},[0,0,3,2]]}]}],"e":[{"l":[{"é":[{"s":[{},[0,0,3,2]]}]}],"s":[{"l":[{"e":[{"g":[{"e":[{"s":[{"l":[{"e":[{"g":[{},[0,0,3,2,0,0,0,3,2,0,0,0,2,1]]}]}]}]}]},[0,0,3,2,0,0,0,2,1]]}]}]}],"t":[{},[0,0,0,0,2]]}],"é":[{"n":[{"e":[{},[0,0,4]]}]}],"g":[{},[0,0,0,3]],"y":[{},[0,0,3]]},[0,0,2,1]],"i":[{"d":[{},[0,0,0,2]]}],"í":[{"r":[{"o":[{},[0,0,0,2]],"ó":[{"d":[{},[0,0,0,2]]}],"u":[{},[0,0,0,2]]}]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"m":[{"e":[{"z":[{"z":[{},[0,0,0,0,0,1]]}]}]}],"p":[{"r":[{"é":[{},[0,0,1,2]]}]}],"s":[{"m":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"ü":[{},[0,0,0,2]]}],"é":[{"c":[{"s":[{},[0,0,2,3]]}],"g":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"e":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"é":[{"r":[{},[0,0,2]]}],"o":[{},[0,0,2]],"y":[{"á":[{},[0,0,2,0,1,2]]}]}],"p":[{"a":[{},[0,0,2,1,2]],"ü":[{"l":[{"é":[{},[0,0,0,1]]}]},[0,0,0,0,2]]}],"t":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"l":[{"e":[{"k":[{},[0,0,0,1]]}],"é":[{},[0,0,2,1,2]]}]}],"é":[{"r":[{"d":[{},[0,0,2,1]]}]}],"ö":[{"r":[{},[0,0,2]]}]}]}],"i":[{"s":[{"z":[{"t":[{"a":[{},[0,0,0,0,2]],"á":[{},[0,0,0,0,2,1,2]],"e":[{"r":[{},[0,0,0,0,2]]}]}]}]}],"t":[{"o":[{"s":[{},[0,0,0,0,1]]}]}]}],"o":[{"b":[{"e":[{},[0,0,0,1]],"i":[{"n":[{},[0,0,2]]},[0,0,0,0,2]]}],"m":[{"a":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]]}],"á":[{},[0,0,2,1]],"b":[{"e":[{},[0,0,0,2,1,2]]}],"e":[{},[0,0,2]],"é":[{"t":[{},[0,0,2,1,2]]}]}],"n":[{"c":[{"s":[{"i":[{},[0,0,0,2]]}]}]}]}],"ó":[{"f":[{"o":[{"g":[{"a":[{"d":[{},[0,0,0,0,2,1,2]]}]}]}]}]}],"ő":[{"c":[{"s":[{"ö":[{"v":[{},[0,0,2,0,1,2]]}]}]}],"r":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}]}]}],"y":[{"o":[{},[0,0,1]]}]},[0,2]],"m":[{"a":[{"e":[{},[0,0,2]],"g":[{"a":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"g":[{},[0,0,0,1]],"ó":[{"r":[{},[0,0,2]]},[0,0,0,0,2]]}],"i":[{"n":[{".":[{},[0,0,2]]}]}],"r":[{"á":[{"c":[{},[0,0,2,1]]}],"i":[{"n":[{"g":[{},[0,0,2,1]]}]}]}],"s":[{"z":[{"k":[{"o":[{"r":[{},[0,0,0,0,2,1]]}],"ö":[{},[0,0,0,0,2,1]]}]}]}],"t":[{"h":[{},[0,0,1]]}],"u":[{"z":[{},[0,0,2]]}]}],"á":[{"r":[{"i":[{"s":[{},[0,0,2,1]]}]}]}],"e":[{"g":[{"e":[{},[0,0,2,1,2]],"é":[{},[0,0,2,1,2]],"i":[{"f":[{},[0,0,0,1]]}],"o":[{},[0,0,0,0,2]],"ő":[{},[0,0,2,1,2]]}],"i":[{},[0,0,2]],"l":[{"l":[{"á":[{},[0,0,0,2]]}]}],"n":[{"y":[{"u":[{},[0,0,2,0,1,2]]}]}],"z":[{"á":[{},[0,0,2]]}]}],"é":[{"d":[{"i":[{"a":[{"f":[{},[0,0,0,0,2]]}]}]}],"n":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]]}],"s":[{"z":[{"a":[{},[0,0,2]],"e":[{"t":[{},[0,0,2]]}],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}]}],"z":[{"i":[{"s":[{},[0,0,2]]}]}]}],"i":[{"r":[{"á":[{},[0,0,3]]}]}],"o":[{"l":[{"y":[{"a":[{"n":[{},[0,0,2]]}]}]}]}],"ű":[{"i":[{},[0,0,0,2]],"k":[{"r":[{},[0,0,1]]}],"s":[{},[0,0,1]]}]},[0,2]],"n":[{"a":[{"g":[{"y":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"ú":[{},[0,0,2]]}]}],"p":[{"a":[{"p":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1]],"é":[{"s":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,1,2]]}],"ö":[{},[0,0,2]]}]}],"e":[{"m":[{"a":[{},[0,0,2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]]}],"i":[{"n":[{},[0,0,2]]}]}],"o":[{"l":[{},[0,0,2]]}],"s":[{"z":[{"á":[{},[0,0,2]]}]}],"t":[{"t":[{"a":[{},[0,0,0,2,1,2]]}]}],"u":[{"m":[{},[0,0,2]]}]}],"é":[{"g":[{"y":[{"á":[{},[0,0,2]]}]}],"p":[{"a":[{},[0,0,2]]}],"v":[{"á":[{"l":[{},[0,0,2,1]]}],"e":[{"l":[{},[0,0,2]]}]}]}],"o":[{"r":[{},[0,0,2,1]]}],"y":[{"a":[{"k":[{"á":[{"r":[{"o":[{},[0,0,0,2,1,2]]}]}],"e":[{},[0,0,0,2,1,2]],"ö":[{},[0,0,0,2,1,2]]}]}],"o":[{"l":[{"c":[{"a":[{"n":[{},[0,0,0,0,2,1]]}]}]}]}]}]},[0,2]],"o":[{"d":[{"a":[{},[0,0,0,1]]}],"k":[{"a":[{"d":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"k":[{"a":[{},[0,0,0,0,2]]}]}],"l":[{"a":[{"j":[{"e":[{},[0,0,0,2,1,2]]}],"s":[{"z":[{"ó":[{},[0,0,0,2,0,1,2]]}]}]}],"d":[{"a":[{"l":[{"ú":[{"t":[{},[0,0,0,0,2,1]]}]}]}]}]}],"r":[{"r":[{"a":[{"j":[{},[0,0,2,1]],"l":[{"t":[{},[0,0,2,1]]}],"n":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"é":[{"s":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"v":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2,1]],"i":[{"s":[{},[0,0,2]]},[0,0,0,0,2]]}]}],"t":[{"t":[{"r":[{},[0,0,1]]}]}]},[0,2]],"ó":[{"l":[{"o":[{"m":[{"a":[{},[0,0,0,2,1]]}]}]}],"m":[{"e":[{"g":[{},[0,0,0,3,2]]}]}],"n":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"e":[{},[0,0,1,2]],"é":[{"v":[{},[0,0,1]]}]}],"v":[{"á":[{"s":[{"á":[{"r":[{"t":[{},[0,0,0,2,1]]}]}]}]}]}]},[0,2]],"ö":[{"n":[{"d":[{},[0,0,1,2]],"e":[{},[0,0,1,2]],"i":[{},[0,0,0,2]],"í":[{},[0,0,1]],"k":[{},[0,0,1,2]],"n":[{},[0,0,3]],"o":[{},[0,0,1]],"ő":[{},[0,0,1]],"s":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"s":[{"s":[{"z":[{"a":[{},[0,0,0,0,1]],"á":[{},[0,0,0,0,1]]}]}]}],"t":[{"e":[{"g":[{},[0,0,1]],"l":[{},[0,0,1]]},[0,0,0,2]],"t":[{},[0,0,1,2]]}],"v":[{"e":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"ő":[{},[0,0,1,2]]}]},[0,2]],"ő":[{"a":[{"l":[{},[0,0,3]]}],"i":[{"r":[{},[0,0,3]]}],"r":[{"a":[{"b":[{},[0,0,1]],"n":[{},[0,0,1]]}],"e":[{"g":[{},[0,0,1,2]]}],"é":[{"g":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"i":[{"s":[{"t":[{},[0,0,1]]}]}],"o":[{},[0,0,1]],"s":[{"á":[{"g":[{},[0,0,2,1]]}]}],"u":[{},[0,0,1,2]],"ü":[{"g":[{},[0,0,1]]}]}],"s":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"e":[{"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"é":[{"g":[{},[0,0,1,2]],"r":[{"t":[{},[0,0,1]]}]}],"í":[{},[0,0,1,2]],"o":[{},[0,0,1]],"ó":[{},[0,0,1,2]],"p":[{},[0,0,1]],"t":[{"r":[{},[0,0,1]]}],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1]],"z":[{"a":[{},[0,0,0,1,2]],"á":[{},[0,0,0,1]],"e":[{"g":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1]],"m":[{},[0,0,0,1]],"n":[{"e":[{},[0,0,3]],"é":[{},[0,0,3]]}]}]}]}],"z":[{"a":[{},[0,0,1,2]],"e":[{"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"t":[{"e":[{},[0,0,1]]},[0,0,0,2]]}],"é":[{"k":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]]}]}],"ő":[{},[0,0,1]],"s":[{},[0,0,3]],"u":[{},[0,0,1]]}]},[0,2]],"p":[{"a":[{"d":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,1,2]],"i":[{"n":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]]}],"i":[{},[0,0,2]],"p":[{"a":[{"r":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2]]}],"r":[{"a":[{"f":[{"r":[{},[0,0,0,0,1,2]]}]}],"k":[{"e":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"t":[{"a":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}]}]}]}],"á":[{"c":[{"s":[{},[0,0,2,3]]}],"n":[{"t":[{"a":[{},[0,0,0,2]]}]}],"r":[{"t":[{"ö":[{},[0,0,0,2,1]]}]}]}],"e":[{"n":[{"n":[{"y":[{},[0,0,0,3]]}]}],"r":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"e":[{"n":[{"c":[{},[0,0,2,1]]}]}],"o":[{"k":[{},[0,0,2]]}],"ü":[{"l":[{},[0,0,2]]}]}],"s":[{},[0,0,2]]}],"i":[{"a":[{"c":[{"s":[{},[0,0,0,2,3]]}]}],"n":[{"a":[{},[0,0,0,0,1]],"t":[{"ó":[{},[0,0,0,2,1]]}]}]}],"l":[{"e":[{"i":[{},[0,0,0,2]]}]}],"o":[{"n":[{"t":[{"a":[{},[0,0,0,0,0,2]],"e":[{},[0,0,0,2]]}]}],"r":[{"a":[{"d":[{},[0,0,2]],"l":[{},[0,0,2]],"n":[{},[0,0,2]]}],"á":[{"c":[{},[0,0,2]],"l":[{},[0,0,2]]}],"e":[{},[0,0,2]],"u":[{"s":[{},[0,0,2,1]]}]}]}],"ó":[{"k":[{"i":[{"s":[{},[0,0,2]]}],"ö":[{},[0,0,2,1]]}],"r":[{"á":[{"s":[{},[0,0,2]]}]}],"t":[{"e":[{},[0,0,2,1]],"é":[{},[0,0,2,1]]}]}],"r":[{"e":[{"k":[{},[0,0,0,1,2]]}],"é":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"o":[{"t":[{"o":[{"p":[{},[0,0,0,0,0,1,2]]}]}]}]}]},[0,2]],"q":[{},[0,2]],"r":[{"a":[{"b":[{"a":[{"s":[{},[0,0,2,1]]}],"á":[{},[0,0,2,1]],"e":[{},[0,0,2]],"i":[{"c":[{},[0,0,0,0,0,1]],"l":[{},[0,0,2,1]],"z":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"o":[{"r":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]]}],"g":[{"a":[{"l":[{},[0,0,2]]}]}],"j":[{"ö":[{},[0,0,2,1,2]],"t":[{"ó":[{"r":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}]}],"á":[{"c":[{"s":[{"á":[{"z":[{},[0,0,2,0,1,2]]}]}]}],"d":[{"r":[{},[0,0,1]]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{},[0,0,0,2]],"n":[{"c":[{"e":[{},[0,0,0,2,1]]}],"y":[{},[0,0,0,0,2]]}],"s":[{"p":[{"r":[{},[0,0,1]]}],"t":[{},[0,0,1,2]]}],"t":[{"k":[{},[0,0,1]],"r":[{},[0,0,1]]},[0,0,0,2]]}],"e":[{"k":[{"r":[{"e":[{},[0,0,1,2]]}]}],"n":[{"d":[{"a":[{},[0,0,0,2,1,2]],"ő":[{},[0,0,0,2,1,2]]}]}],"p":[{"r":[{"i":[{},[0,0,1,2]],"o":[{"d":[{},[0,0,1]]},[0,0,0,2]]}]}],"t":[{"e":[{"k":[{},[0,0,0,0,2,1]]}]}]}],"é":[{"m":[{"e":[{"m":[{"b":[{},[0,0,2,1]]}]}],"u":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,3,2]]}],"s":[{"a":[{},[0,0,2]],"s":[{"z":[{"e":[{"r":[{},[0,0,0,3]]}]}]}],"z":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,0,0,2]],"e":[{"l":[{"e":[{},[0,0,2,0,1,2]],"l":[{},[0,0,2]]}],"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ő":[{},[0,0,2]]}]}],"t":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]]}],"v":[{"á":[{},[0,0,2,1]]}],"z":[{"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2]],"t":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2]]}],"o":[{},[0,0,2,1]],"z":[{},[0,0,0,1]]}]}],"i":[{"z":[{"s":[{"o":[{},[0,0,2]],"z":[{},[0,0,0,0,3]]}]}]}],"í":[{"m":[{"á":[{},[0,0,2]]}]}],"o":[{"c":[{"k":[{"o":[{"s":[{},[0,0,1,2]]}]}]}],"m":[{"é":[{"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"n":[{},[0,0,2]],"s":[{},[0,0,2]]}]}],"s":[{"t":[{"e":[{},[0,0,0,2,1,2]]}]}]}],"u":[{"g":[{"g":[{},[0,0,0,1]]}],"m":[{"a":[{},[0,0,2,1]],"i":[{"l":[{},[0,0,2]]}]}]}],"ú":[{"d":[{"e":[{},[0,0,2]]}]}]},[0,2]],"s":[{"a":[{"h":[{"a":[{},[0,0,2,1]]}],"j":[{"t":[{"e":[{},[0,0,0,2]]}]}],"s":[{"o":[{"r":[{},[0,0,2,1]]}]}],"v":[{"a":[{"d":[{},[0,0,2]],"r":[{"a":[{},[0,0,2,1]]}]}],"á":[{"l":[{},[0,0,2,1]],"r":[{"i":[{},[0,0,2]]}]}],"e":[{},[0,0,2,1,2]],"é":[{},[0,0,2,1,2]]}]}],"á":[{"r":[{"ó":[{},[0,0,2,1]],"ú":[{},[0,0,2]]}],"s":[{"s":[{},[0,0,0,1]],"z":[{},[0,0,2,3]]}],"v":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"c":[{},[0,0,2]],"e":[{"b":[{"a":[{"l":[{},[0,0,2]]}],"á":[{},[0,0,2,1]],"e":[{"l":[{},[0,0,2]],"s":[{"z":[{},[0,0,2]]}]}],"o":[{},[0,0,2,1]]}]}],"é":[{"f":[{"i":[{},[0,0,2]]}]}],"g":[{"r":[{},[0,3]]}],"i":[{"e":[{"m":[{},[0,0,2]]}],"ó":[{"k":[{},[0,0,2]]}]}],"í":[{"n":[{"n":[{},[0,0,0,3]]}],"p":[{"ő":[{},[0,0,2,1,2]]}],"r":[{"a":[{},[0,0,2,1,2]],"á":[{"t":[{},[0,0,2]]}]}]}],"k":[{},[0,0,2]],"o":[{"k":[{"é":[{"l":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]}]}],"m":[{"a":[{"g":[{},[0,0,2,1]],"t":[{},[0,0,2]]}]}],"n":[{"y":[{},[0,0,1,0,2]]}],"r":[{"a":[{"l":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}]}]}],"ö":[{"r":[{"e":[{"g":[{},[0,0,0,1,2]]}]}]}],"p":[{"o":[{"r":[{"t":[{"á":[{},[0,0,0,0,2,1,2]]}]}]}]},[0,0,2]],"t":[{"a":[{"r":[{"t":[{"a":[{},[0,0,0,0,2,1,2]]}]}]}]},[0,0,2]],"z":[{"a":[{"b":[{"a":[{"d":[{"e":[{},[0,0,0,0,0,2,1]]}]}]}],"k":[{"a":[{"t":[{},[0,0,0,2,1]]}],"á":[{"s":[{},[0,0,0,2,1]]}],"e":[{},[0,0,0,2,1]],"ö":[{},[0,0,0,2]],"ü":[{},[0,0,0,2,1]]}]}],"á":[{"l":[{"ó":[{},[0,0,0,2,1,2]]}],"z":[{"z":[{},[0,0,0,0,1]]}]}],"e":[{"g":[{"é":[{"r":[{".":[{},[0,0,0,0,1]]}]}],"í":[{},[0,0,0,2]]}],"i":[{},[0,0,0,2]],"m":[{"á":[{},[0,0,0,2,1]],"é":[{"r":[{".":[{},[0,0,0,2,1]],"i":[{},[0,0,0,2,1,2]]}]}]}],"r":[{"á":[{"g":[{},[0,0,0,2,1]]}],"v":[{"a":[{"d":[{},[0,0,0,0,2,1,2]]}],"e":[{"v":[{},[0,0,0,0,2,1,2]]}]}]}],"s":[{"z":[{"á":[{},[0,0,0,2]],"e":[{"g":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2,0,1,2]]}]}]}],"é":[{"f":[{"a":[{},[0,0,0,2]]}],"n":[{"n":[{},[0,0,0,0,1]]}],"t":[{"e":[{},[0,0,0,0,0,2]]},[0,0,0,2,1]]}],"í":[{"n":[{"n":[{},[0,0,0,0,3]]}]}],"k":[{},[0,0,0,2]],"o":[{"l":[{"ó":[{},[0,0,0,2,1]]}]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"s":[{"z":[{"a":[{"k":[{},[0,0,0,2]]}],"ö":[{"v":[{},[0,0,0,2,0,1]]},[0,0,0,0,0,0,2]]}]}]}],"t":[{},[0,0,0,2]]},[0,0,2]]},[0,2]],"t":[{"a":[{"g":[{"a":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1,2]]}],"á":[{},[0,0,2,1]],"e":[{},[0,0,2,1]],"é":[{"p":[{},[0,0,2]]}],"g":[{},[0,0,0,1]],"i":[{"n":[{},[0,0,2,1,2]]}],"ö":[{},[0,0,2]]}],"n":[{"a":[{"g":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2]]}],"d":[{},[0,0,0,1,2]],"e":[{},[0,0,2,1,2]],"é":[{"v":[{"e":[{},[0,0,0,0,2]]},[0,0,2,1]]}],"i":[{"s":[{},[0,0,2]]}],"n":[{},[0,0,0,1]],"ó":[{},[0,0,2,1,2]],"t":[{},[0,0,0,0,2]],"u":[{"s":[{},[0,0,2,1,2]]}]}],"r":[{"á":[{},[0,0,3]]}],"t":[{"á":[{"l":[{},[0,0,2,1]],"r":[{"a":[{"i":[{},[0,0,2,1]]}]}]}],"e":[{},[0,0,2,1,2]],"í":[{},[0,0,2,1]],"o":[{"r":[{},[0,0,2]]}],"u":[{"r":[{},[0,0,2]]}]}]}],"á":[{"l":[{"ó":[{},[0,0,2,1,2]]}],"n":[{"c":[{"s":[{"e":[{},[0,0,0,2]]}]}]}],"p":[{"o":[{"l":[{},[0,0,2,1]]}]}],"r":[{"s":[{"o":[{"r":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2,1,2]]}],"t":[{"e":[{"s":[{},[0,0,0,2,1]]}],"ö":[{"l":[{"t":[{},[0,0,0,2,1]]}]}]}]}],"v":[{"a":[{},[0,0,2,1]],"i":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]]}]}],"b":[{"c":[{},[0,0,0,1]]}],"e":[{"a":[{"k":[{"a":[{},[0,0,2]]}],"r":[{},[0,0,2]]}],"j":[{"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2,1]]}]}],"r":[{"a":[{"p":[{"e":[{},[0,0,0,0,0,0,2]]}]}],"v":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1,2]]}]}],"s":[{"t":[{"é":[{"k":[{},[0,0,0,2]]}],"ö":[{"l":[{},[0,0,0,2,1]]}]}]}],"t":[{"r":[{"a":[{"é":[{},[0,0,0,0,0,0,2]]}]}]}],"z":[{"a":[{},[0,0,0,0,2]]}]}],"é":[{"k":[{},[0,0,3]],"n":[{"y":[{"e":[{"m":[{},[0,0,2]]}],"í":[{},[0,0,2]]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"t":[{},[0,0,2]]}],"i":[{"n":[{"t":[{},[0,0,0,1]]}]}]}]}],"í":[{"z":[{"ó":[{},[0,0,2,1,2]],"s":[{},[0,0,2]],"ü":[{},[0,0,0,0,2]]}]}],"o":[{"k":[{"á":[{"r":[{"o":[{},[0,0,2]]}]}]}],"l":[{"l":[{"e":[{},[0,0,0,2]]}]}],"p":[{"a":[{"u":[{},[0,0,0,0,3,2]]}]}],"r":[{"á":[{"l":[{},[0,0,2,1,2]]}],"o":[{"d":[{"v":[{},[0,0,2,1]]}]}],"z":[{"s":[{"e":[{},[0,0,0,2,3]]}]}]}]}],"ó":[{"s":[{"t":[{},[0,0,1]]}],"t":[{"é":[{"r":[{".":[{},[0,0,2,1]]}]}]}]}],"ö":[{"n":[{"k":[{"a":[{},[0,0,0,2,1]]}]}]}],"ő":[{"a":[{},[0,0,0,2]],"e":[{},[0,0,0,2]],"g":[{"y":[{"a":[{},[0,0,2]]}]}],"r":[{"é":[{"s":[{"s":[{},[0,0,2,1]],"z":[{},[0,0,2,1,2]]}]}]}]}],"r":[{"a":[{"u":[{},[0,0,0,2]]}]}],"u":[{"r":[{"n":[{"u":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}]}],"s":[{"s":[{},[0,0,0,3]],"z":[{"á":[{},[0,0,0,3]]},[0,0,2]]}]}],"ú":[{"r":[{"a":[{"t":[{"t":[{},[0,0,2,1]]}]}]}]}],"ű":[{"z":[{"é":[{"r":[{"t":[{},[0,0,2,1]]}]}],"ő":[{"r":[{},[0,0,2,1,2]]}],"s":[{"e":[{},[0,0,2]]}]}]}],"y":[{"ú":[{"k":[{"a":[{},[0,0,0,2]]}]}]}]},[0,2]],"u":[{"g":[{"r":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}]}],"n":[{"i":[{"n":[{},[0,0,1]],"o":[{},[0,0,0,2]]}]}],"t":[{"a":[{"s":[{"s":[{},[0,0,0,0,1]]}]}],"á":[{"s":[{},[0,0,0,0,4]]}],"o":[{},[0,0,0,2]],"ó":[{"d":[{"ö":[{},[0,0,0,2,1]]}]}]}]},[0,2]],"ú":[{"j":[{"a":[{"s":[{},[0,0,1]]}],"e":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"e":[{},[0,0,1]]}],"s":[{"z":[{"ó":[{"s":[{"p":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}]}]}],"t":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"e":[{},[0,0,1,2]],"o":[{"l":[{},[0,0,1]]}],"ő":[{},[0,0,1]],"ü":[{},[0,0,1,2]]}]},[0,2]],"ü":[{"g":[{"y":[{"é":[{"r":[{".":[{},[0,0,0,1]]}]}]}]}],"k":[{"a":[{},[0,0,1,2]]}],"s":[{"t":[{"ö":[{"l":[{"ő":[{},[0,0,2,1]]},[0,0,0,0,2]]}]}]}],"t":[{"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}]}]}],"v":[{"e":[{"g":[{"e":[{"l":[{},[0,0,0,2,1,2]]}]}]}]}]},[0,2]],"ű":[{"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"e":[{},[0,0,1,2]],"é":[{"s":[{},[0,0,1,2]],"t":[{"e":[{},[0,0,1]]}]}],"i":[{"t":[{"a":[{},[0,0,1]]}]},[0,0,0,2]],"ö":[{"s":[{"s":[{},[0,0,1]]}]}],"s":[{},[0,0,1]],"t":[{},[0,0,0,2]]}]},[0,2]],"v":[{"a":[{"d":[{"a":[{"l":[{},[0,0,2,1]]}],"á":[{"r":[{},[0,0,2]]}],"é":[{"t":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,1,2]]}],"ó":[{"v":[{},[0,0,2]]}],"ö":[{},[0,0,2,1]],"z":[{},[0,0,2,3]]}],"g":[{"y":[{"i":[{},[0,0,2,0,1]]}]}],"j":[{"e":[{},[0,0,2,1]]}],"k":[{"a":[{"k":[{},[0,0,2,1]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2,1]]}],"e":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1]]}],"r":[{"a":[{"k":[{},[0,0,2]]}],"á":[{"s":[{},[0,0,2,1,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"n":[{"g":[{},[0,0,2,1]]}]}]}],"s":[{"a":[{"b":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{"o":[{"m":[{},[0,0,2,1,2]]}]}]}],"á":[{"g":[{},[0,0,2,1,2]],"r":[{"k":[{},[0,0,2]]}],"s":[{},[0,0,2]]}],"e":[{},[0,0,2,1]],"é":[{"k":[{},[0,0,2]]}],"i":[{"r":[{},[0,0,2,1,2]]}],"o":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"ó":[{},[0,0,2]],"s":[{},[0,0,0,3]],"t":[{"r":[{},[0,0,0,1]]}],"ü":[{},[0,0,2,1]],"z":[{},[0,0,2,3]]}]}],"á":[{"c":[{"s":[{},[0,0,0,0,1]]}],"d":[{"á":[{},[0,0,2]],"e":[{},[0,0,2,1]]}],"m":[{"a":[{},[0,0,2]]}],"r":[{"a":[{"d":[{"á":[{},[0,0,0,1,2]]}]}],"i":[{"s":[{},[0,0,2,1,2]]}],"o":[{"l":[{},[0,0,2,1]]}]}]}],"e":[{"r":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"s":[{"é":[{"g":[{},[0,0,0,2,1]]}],"o":[{},[0,0,0,2,1]],"z":[{},[0,0,0,2]]}]}]}],"é":[{"g":[{"é":[{"k":[{},[0,0,2,1,2]]}],"o":[{},[0,0,2,1]]}],"n":[{"y":[{"e":[{"l":[{},[0,0,2]]}]}]}],"r":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2]],"e":[{"b":[{},[0,0,2,1]],"g":[{},[0,0,2,1]]}],"i":[{"k":[{},[0,0,2]]}],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"t":[{"é":[{"k":[{},[0,0,0,2,1]]}]}],"u":[{},[0,0,2]]}],"s":[{"z":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2,0,1,2]]}]}]}],"i":[{"g":[{"n":[{},[0,0,1,2]]}]}],"í":[{"z":[{"e":[{"d":[{},[0,0,2]],"m":[{},[0,0,2]]}]}]}],"o":[{"n":[{"a":[{"t":[{"ú":[{"t":[{},[0,0,0,0,2,1]]}]}]}],"z":[{"e":[{},[0,0,0,2,1,2]]}]}]}]},[0,2]],"w":[{},[0,2]],"x":[{},[0,2]],"y":[{},[0,2]],"z":[{"a":[{"b":[{"e":[{},[0,0,2]],"i":[{"n":[{},[0,0,2,1,2]]}]}],"i":[{},[0,0,0,2]],"j":[{"e":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1]],"u":[{"t":[{},[0,0,2]]}]}]}],"á":[{"r":[{"a":[{"d":[{"á":[{},[0,0,2,1,2]]}]}],"e":[{},[0,0,2,1]],"ó":[{"r":[{"a":[{},[0,0,2,1,2]]}]}],"t":[{"a":[{"n":[{"y":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"é":[{},[0,0,0,2,1]],"ö":[{"v":[{},[0,0,0,2,1,2]]}]}]}]}],"e":[{"i":[{},[0,0,2]]}],"é":[{"t":[{},[0,0,2,1]]}],"s":[{},[0,0,2]],"ű":[{"r":[{"ő":[{},[0,0,2,1]]}]}]},[0,2]]}],"a":[{".":[{},[2]],"a":[{"b":[{"e":[{},[0,0,2]]}],"c":[{"é":[{},[0,0,2]],"h":[{},[0,0,2]]}],"d":[{"a":[{},[0,0,2]],"á":[{"s":[{"s":[{"z":[{},[0,0,2]]},[0,0,0,0,0,1]]}]}],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"f":[{"o":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"ó":[{},[0,0,2]],"y":[{},[0,0,2]]}],"j":[{"á":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}],"l":[{".":[{},[0,2]],"a":[{"g":[{},[0,0,0,0,2,1]]},[0,0,2]],"á":[{},[0,0,2]],"e":[{"g":[{},[0,0,0,1]]}],"é":[{},[0,0,2]],"m":[{"a":[{"n":[{"a":[{"c":[{},[0,0,0,0,0,0,0,0,3]]},[0,0,0,0,0,0,0,2]]}]}]}],"o":[{"s":[{},[0,0,0,1]]},[0,0,2]],"u":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,2]]}],"n":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"s":[{},[0,2]],"y":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"l":[{},[0,2]],"o":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"o":[{},[0,0,2]],"y":[{},[0,0,2]]}],"u":[{"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]],"o":[{},[0,2]]}],"z":[{"o":[{},[0,0,2]]}]},[0,1]],"á":[{"b":[{"é":[{},[0,0,2]]}],"c":[{"s":[{},[0,0,2]]}],"f":[{"á":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"í":[{},[0,0,2]]}],"j":[{"u":[{},[0,0,2]]}],"l":[{".":[{},[0,2]],"a":[{},[0,0,2]],"o":[{},[0,0,2]]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2,1,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"s":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{},[0,0,2,1,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2,1,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"z":[{"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}]},[0,1]],"b":[{"a":[{"b":[{},[2]],"d":[{"ó":[{},[0,0,1]],"z":[{},[0,0,0,2]]}],"j":[{"g":[{},[1,2]]}],"k":[{"k":[{},[0,0,1]]}],"l":[{},[2]],"n":[{"a":[{"l":[{},[0,0,0,2]]}]},[2]],"p":[{"r":[{},[0,0,0,1]]}],"r":[{"a":[{"t":[{},[0,0,0,2]]}],"á":[{"b":[{},[0,2,1,2]]}]},[2]],"u":[{},[0,2,1]]}],"á":[{"b":[{"u":[{"r":[{},[0,0,0,2,1,2]]}]},[2]],"d":[{},[2]],"n":[{},[2]],"p":[{},[0,2,1]],"r":[{"a":[{"k":[{},[0,0,0,2]]}],"o":[{"n":[{},[0,0,1,2]]}],"ú":[{},[0,0,1,2]]}],"z":[{},[2]]}],"b":[{"a":[{"h":[{},[1]]},[0,0,0,2]]}],"e":[{"a":[{},[2]],"á":[{},[0,0,0,0,2]],"b":[{},[0,2,1,2]],"c":[{},[2]],"d":[{"é":[{},[0,0,1]]}],"é":[{},[2]],"f":[{},[2]],"h":[{},[2]],"i":[{},[2]],"j":[{"t":[{},[0,0,1]]},[2]],"l":[{"a":[{},[0,0,1]],"á":[{},[0,0,1,2]],"e":[{"m":[{},[0,0,0,2]]},[2]],"s":[{"z":[{},[0,0,1]]},[2]],"t":[{},[0,2,1]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,0,1]]},[2]],"r":[{"d":[{},[0,2,1]]}],"t":[{"á":[{},[2]],"e":[{},[2]],"é":[{},[2]],"o":[{},[2]],"ö":[{},[2]]}],"v":[{},[2]],"x":[{},[0,2,1]]}],"é":[{"k":[{},[2]],"l":[{},[2]],"n":[{"e":[{},[0,2,1,2]]},[2]],"p":[{},[0,2,1]],"r":[{"z":[{},[0,2,1]]},[2]],"t":[{"á":[{},[2]]}],"v":[{"e":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"c":[{},[2]],"d":[{"o":[{},[0,0,1,2]]}],"e":[{},[2]],"k":[{"e":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"n":[{"a":[{"i":[{},[0,2,1,2]]}],"á":[{"b":[{},[0,0,0,2]]}],"g":[{},[0,2,1]]}],"r":[{"k":[{"á":[{"i":[{},[0,0,1]]}]}]},[2]],"s":[{"m":[{},[0,0,1]]}],"t":[{"a":[{},[0,2,1,2]]},[2]],"z":[{},[2]]}],"í":[{"j":[{},[0,2,1]],"r":[{"n":[{},[0,0,1]]}]}],"k":[{"r":[{},[0,0,1]]}],"l":[{"a":[{"k":[{"á":[{},[1]],"h":[{},[1]],"k":[{},[1]],"o":[{"s":[{},[1]]}],"r":[{},[1]]}]}],"o":[{},[2]],"ú":[{},[0,1,2]]}],"o":[{"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"l":[{"t":[{"ó":[{},[0,0,1]]},[2]]}],"m":[{},[2]],"r":[{"a":[{"k":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]]}],"i":[{"n":[{},[0,0,0,2]]}]}],"t":[{},[2]]}],"ö":[{"b":[{},[0,2,1]],"l":[{"ő":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,2]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{"l":[{},[0,0,1]]}]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"e":[{"k":[{},[0,0,2]]}],"i":[{"k":[{"e":[{},[0,1,2]]}],"n":[{},[0,0,2]],"t":[{},[0,1,2]]},[2]],"ó":[{"k":[{},[0,0,2]]},[2]]}],"s":[{"t":[{},[0,0,1]]}],"u":[{"r":[{"d":[{},[0,2,1]]}]}],"ú":[{"r":[{".":[{},[0,0,1]],"t":[{},[0,0,1]]}],"s":[{"á":[{},[0,0,0,2,1]],"z":[{},[0,0,1]]}]}],"ü":[{"l":[{},[0,0,1,2]],"s":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1]]}]}],"c":[{"a":[{"l":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2,1,2]],"é":[{"t":[{},[0,0,0,2]]}]}],"n":[{},[0,2,1,2]],"t":[{"á":[{},[0,0,0,2]]}]}],"á":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]]}],"c":[{"i":[{"ó":[{},[0,0,0,0,2]]}],"ö":[{},[0,0,2]],"s":[{"e":[{},[0,0,3]],"í":[{},[0,0,3]],"ü":[{},[0,0,3]],"z":[{},[0,0,0,3]]}]}],"e":[{".":[{},[0,2]],"b":[{"é":[{},[0,0,1]]}],"g":[{},[0,2,1]],"l":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"h":[{},[0,2,1]],"l":[{"e":[{},[0,0,1]]}],"m":[{},[0,2,1]],"o":[{},[0,2,1]],"v":[{},[0,2,1]]},[0,0,0,2]],"m":[{"b":[{},[0,0,1]]}],"n":[{},[2]],"t":[{"a":[{},[0,0,0,2]]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"é":[{"l":[{"á":[{},[0,2]],"e":[{},[0,0,0,0,1,2]],"é":[{},[0,2]]}],"p":[{},[0,2,1]],"r":[{"e":[{},[0,2,1,2]],"t":[{"e":[{},[0,2,1]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"h":[{"á":[{},[0,2]],"é":[{"j":[{},[0,0,3]]}],"í":[{},[0,0,3]],"o":[{"z":[{},[0,2,3]]}],"ó":[{},[0,0,3]],"ö":[{},[0,2,3]],"ú":[{},[0,2,3]]}],"i":[{"d":[{"e":[{},[0,0,1]]}],"g":[{"á":[{},[0,2,1,2]],"é":[{},[0,2,1,2]]}],"k":[{"e":[{},[0,2,1]]}],"n":[{".":[{},[2]],"d":[{},[0,2,1]],"f":[{},[0,0,1]]}],"s":[{"t":[{},[0,2,1]]}]}],"í":[{"r":[{},[0,2,1]],"v":[{},[0,0,1]]}],"k":[{"a":[{"r":[{"o":[{},[0,0,0,1]]}]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"v":[{},[0,0,2,1,2]]}],"é":[{"r":[{"e":[{},[0,0,2,1]]},[0,0,0,0,2]],"t":[{"e":[{},[0,0,0,1]]}]}],"i":[{"l":[{},[0,0,2]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{"s":[{},[0,0,2]]}],"ű":[{},[0,0,2]]}],"l":[{"u":[{},[0,0,2]]}],"o":[{"p":[{},[0,2,1]]}],"ö":[{"s":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"a":[{"l":[{"j":[{".":[{},[0,0,0,1]]}]},[2]],"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]]}]}],"t":[{"k":[{},[0,2,0,1]]}]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}],"r":[{"u":[{},[0,2]]}]}],"e":[{"c":[{},[0,0,0,0,2]],"g":[{"y":[{},[0,0,0,1]]}],"m":[{"l":[{},[0,0,3]]}]}],"é":[{"b":[{},[1,2]],"k":[{},[0,2,0,1]]}],"i":[{},[2]],"í":[{},[2]],"o":[{"n":[{},[2]],"r":[{"m":[{},[0,0,0,1]]}]}],"ö":[{"c":[{},[0,2,0,1]]}],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,3]]}],"ú":[{"l":[{},[0,2]],"r":[{},[0,2,0,1]]}],"ü":[{"l":[{},[0,0,0,0,2]],"t":[{},[0,2]]}],"z":[{"á":[{},[0,0,3]],"e":[{},[0,0,3]],"ö":[{},[0,0,3]]}]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"d":[{},[0,2,1]],"l":[{"a":[{},[2]]}],"t":[{},[0,2,1]]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"g":[{},[0,0,1]],"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,3]],"á":[{},[0,0,3]],"e":[{},[0,0,3]],"s":[{},[0,0,3]],"u":[{},[0,0,3]]}]}],"d":[{"a":[{"d":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2]]}],"g":[{".":[{},[1,2]],"á":[{},[0,0,0,2]],"b":[{},[1,2]],"g":[{},[0,2]],"h":[{},[1,2]],"i":[{},[1]],"j":[{},[1,2]],"n":[{},[1,2]],"o":[{},[1,2]],"r":[{},[1,2]],"t":[{},[1,2]],"u":[{},[1]],"ú":[{},[1,2]]}],"k":[{"t":[{"á":[{},[0,2,1]]}]}],"l":[{"a":[{"p":[{},[0,0,0,2]]}],"e":[{"s":[{},[0,0,0,2,1]]}],"é":[{"n":[{},[0,0,0,2]]},[1]],"o":[{"s":[{"z":[{},[0,0,0,2,1]]}]}],"ó":[{},[0,0,0,2,1,2]],"ú":[{"t":[{},[0,0,0,2,1]]}]}],"n":[{"a":[{},[0,2,1]],"n":[{},[0,2,1]]}],"p":[{"t":[{},[1]]}],"r":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"é":[{"s":[{},[0,0,0,2,1]]}],"i":[{"n":[{},[0,0,0,2,1]]}],"u":[{"t":[{},[0,0,0,2]]}]},[2]],"t":[{"a":[{"b":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1,2]]}],"á":[{"r":[{".":[{},[0,0,0,2,1]],"a":[{"k":[{},[0,0,0,2,1,2]],"m":[{},[0,0,0,2,1,2]],"t":[{},[0,0,0,2,1,2]]}],"á":[{},[0,0,0,2,1,2]],"b":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]],"u":[{},[0,0,0,2,1,2]]}],"u":[{},[1,2]]}],"e":[{"g":[{},[0,0,0,2,1,2]],"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]]}],"é":[{"r":[{"d":[{},[0,0,0,2,1]],"ő":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"i":[{"n":[{"t":[{},[0,0,0,2]]},[1,2]],"s":[{},[0,0,0,2]]}],"í":[{"v":[{},[0,0,0,2]]}],"m":[{},[0,2]],"o":[{"l":[{"d":[{},[0,0,0,2,1]]}]}],"ö":[{"l":[{},[0,0,0,2,1]]}],"ő":[{},[0,0,0,2,1]],"v":[{},[0,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"g":[{},[0,2,1]],"r":[{"a":[{"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"i":[{"s":[{},[0,0,0,2]]}]}]}],"d":[{"e":[{"l":[{},[0,0,2]]}]}],"e":[{"g":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]],"y":[{},[0,0,1]]},[0,0,0,2]],"i":[{},[0,0,0,2]],"j":[{},[0,2,1]],"l":[{"e":[{"j":[{},[0,0,0,0,1]]}],"h":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"ő":[{},[0,2,1,2]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"m":[{"b":[{},[0,2,1]],"é":[{},[0,0,1,2]],"l":[{},[0,2,1]],"u":[{},[0,2,1]]}],"n":[{"g":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"r":[{"d":[{},[0,2]],"ő":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,0,2]]}],"u":[{},[0,2]],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"é":[{"k":[{"a":[{"t":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"é":[{"s":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]}],"ü":[{},[0,0,0,2]],"ű":[{},[0,0,0,2]]}],"l":[{"e":[{},[0,0,1]]}],"m":[{"o":[{"n":[{"t":[{},[2]]}]}]}],"p":[{},[0,2,1]],"r":[{"z":[{},[0,2,1]]}],"s":[{},[0,0,0,2]],"t":[{"e":[{},[0,0,0,2]]}],"v":[{"e":[{},[0,2,1,2]]}]}],"f":[{"l":[{},[0,0,1]],"o":[{"k":[{"ú":[{"t":[{},[0,0,0,0,2,1]]}]}]}]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"é":[{},[1]]}],"i":[{"a":[{"n":[{},[0,0,0,0,2]]},[2]],"b":[{"o":[{},[0,0,1,2]]}],"d":[{},[2]],"k":[{"u":[{"t":[{},[0,0,0,2]]}]}],"n":[{"a":[{".":[{},[0,0,1,2]],"i":[{},[0,0,1,2]]}],"d":[{},[0,0,1]],"g":[{},[0,2,1]]},[2]],"o":[{"g":[{"r":[{"a":[{},[0,0,0,2,1,2]]}]}]}],"p":[{},[2]],"s":[{},[2]],"v":[{},[2]]}],"í":[{"z":[{},[0,2,1,2]]}],"j":[{"i":[{},[0,0,2]]}],"k":[{"a":[{"n":[{"a":[{},[0,0,0,0,2]]}]}],"r":[{},[0,0,1]]}],"o":[{"b":[{},[2]],"c":[{},[2]],"k":[{"k":[{"e":[{},[0,2,1]]}]}],"l":[{"a":[{},[0,0,1]]},[2]],"m":[{"á":[{},[1,2]],"b":[{},[2]],"i":[{},[2]]}],"p":[{},[1,2]],"r":[{"c":[{},[0,2,1]],"g":[{},[0,2,1]],"h":[{},[2]],"i":[{"a":[{"n":[{},[2]]}],"g":[{},[2]]}],"v":[{},[0,0,1]],"z":[{},[0,2,1]]}],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"g":[{"u":[{},[0,2]]}],"k":[{"u":[{},[1,2]]}],"m":[{"é":[{},[0,2]]}],"r":[{"á":[{},[0,2]]}],"s":[{"a":[{"t":[{},[1,2]]}],"i":[{".":[{},[2]]}]}],"v":[{"á":[{"s":[{},[0,0,1,2]]}]}],"z":[{"ó":[{},[1,2]]}]}],"ö":[{"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"r":[{"d":[{},[0,0,1]]}],"s":[{},[0,2,1]]}],"ő":[{"r":[{"a":[{},[0,0,0,0,1]],"e":[{"l":[{},[0,0,0,2]]}]}],"s":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"c":[{},[0,1,2]],"m":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"m":[{},[0,0,2]]},[2]],"o":[{"g":[{},[0,0,2]]},[2]],"ó":[{"t":[{},[0,1,2]]}],"u":[{"k":[{},[0,0,2]]}]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"u":[{"g":[{},[2]],"m":[{},[2]],"p":[{},[2]],"r":[{"á":[{},[0,0,1,2]]}]}],"ú":[{"s":[{"z":[{},[0,0,1]]}],"t":[{"o":[{},[0,2,1]]},[0,0,0,2]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"é":[{},[0,0,1,2]]}],"t":[{},[0,2,1]],"z":[{},[0,0,1]]}],"ű":[{"r":[{},[0,2,1]],"z":[{},[0,0,1]]}],"y":[{"é":[{"h":[{},[0,0,1]],"r":[{},[0,0,1]]}]}],"z":[{"a":[{"b":[{},[0,0,3]],"v":[{},[0,0,3]]}],"á":[{"r":[{},[0,0,3]]}],"e":[{"l":[{},[0,0,3]]}],"ó":[{"n":[{},[0,0,3]]}],"ö":[{},[0,2,3]],"s":[{"í":[{},[0,0,3]]}]}]}],"e":[{"b":[{"é":[{},[0,0,2]]}],"c":[{"e":[{},[0,0,2]],"s":[{},[0,0,2]]}],"d":[{"é":[{},[0,0,2]],"z":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"e":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"j":[{},[0,0,0,1]],"n":[{},[0,0,3]]},[0,0,2]],"é":[{"r":[{"h":[{},[0,0,0,1]]}]}],"í":[{},[0,0,2,1,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2,1,2]],"ő":[{},[0,0,2]],"u":[{},[0,0,2]]}],"m":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"u":[{},[0,0,2]]}],"n":[{"e":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"e":[{"d":[{},[0,0,2]]}],"é":[{},[0,0,2]],"o":[{"s":[{},[0,0,0,0,1]]}],"ó":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"s":[{"e":[{"r":[{},[0,0,0,1]]},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"x":[{"e":[{},[0,0,2]]}],"z":[{"ü":[{},[0,0,2]]}]},[0,1]],"é":[{"d":[{"e":[{"r":[{"v":[{},[0,0,2]]}]}]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"h":[{"e":[{},[0,0,2]]}],"j":[{"e":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"n":[{"e":[{},[0,0,2]]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"d":[{"e":[{"m":[{},[0,0,0,0,0,2,1]]}]}],"i":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[0,1]],"f":[{"a":[{".":[{},[2]],"j":[{".":[{},[2]],"a":[{},[2]],"á":[{},[2]],"b":[{},[2]],"e":[{},[2,0,0,2,1,2]],"j":[{},[2]],"n":[{},[2]],"o":[{},[2]],"t":[{".":[{},[2]]}],"u":[{},[2]],"z":[{},[2]]}],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"o":[{},[2]],"r":[{},[2]],"s":[{},[2]]}],"e":[{"l":[{"e":[{"m":[{},[0,0,0,2,1,2]]}]}]}],"é":[{"k":[{},[2]],"l":[{"i":[{},[2]],"ő":[{},[2]],"t":[{},[2]]}],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]]}],"f":[{"é":[{},[1]]}],"i":[{"a":[{"p":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,2]]}]}],"k":[{"e":[{},[0,0,0,2]]}],"t":[{"a":[{},[0,0,0,2,1,2]],"e":[{},[0,0,0,2,1,2]]}]}],"l":[{"e":[{},[0,0,2]],"o":[{},[0,1,2]],"ó":[{},[0,1,2]],"ö":[{},[0,1,2]],"u":[{},[0,1,2]]}],"o":[{"c":[{},[2]],"g":[{},[2]],"k":[{},[2]],"l":[{},[2]],"n":[{},[2]],"r":[{"d":[{},[2]],"g":[{},[2]],"m":[{"á":[{"c":[{},[2]],"l":[{},[2]],"t":[{"u":[{},[2]]}],"z":[{},[2]]}],"u":[{},[2]]}],"r":[{},[2]]}],"s":[{},[2]],"t":[{},[2]]}],"r":[{"a":[{"k":[{},[0,0,2]]}],"e":[{},[2,1,2]],"i":[{"z":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"n":[{},[0,0,2]]},[2]],"ö":[{},[2,1,2]]}],"t":[{"á":[{},[0,0,3]]}],"u":[{"s":[{"s":[{},[0,0,0,0,3]]}]}]}],"g":[{"a":[{"b":[{"l":[{},[0,2,1]],"r":[{},[0,0,1]]}],"c":[{"é":[{},[0,0,1,2]]}],"g":[{"a":[{},[0,0,1]]}],"k":[{"a":[{},[0,2,1,2]],"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"l":[{"a":[{"k":[{},[0,2,1,2]],"p":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"j":[{},[0,2,1]],"m":[{},[0,2,1]],"o":[{"m":[{},[0,0,0,2]]}],"t":[{},[0,2,1]]},[2]],"n":[{"g":[{},[0,0,1]],"o":[{},[0,0,1,2]],"t":[{},[0,0,1]],"y":[{},[0,2]]}],"p":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]]},[0,2]],"r":[{"c":[{},[0,2,1]],"é":[{},[0,2,1]],"o":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"t":[{"o":[{"m":[{},[0,0,0,2]]}],"ó":[{},[0,0,1,2]]}],"u":[{"r":[{},[0,2,1,2]],"t":[{},[0,0,1]]}],"v":[{"a":[{},[0,2,1]]}],"z":[{"o":[{"n":[{},[0,0,1,2]]}]},[2]]}],"á":[{"c":[{"s":[{".":[{},[0,2,1]],"i":[{},[0,2,1]]}]},[0,0,0,2]],"g":[{"a":[{},[0,0,1,2]]}],"k":[{},[1,2]],"l":[{"a":[{},[0,3]],"m":[{},[0,2,1]],"y":[{"a":[{"n":[{},[0,0,0,2]]}]}]}],"p":[{},[0,2,1]],"r":[{".":[{},[0,2]],"a":[{"d":[{},[0,2,1]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"á":[{},[0,2,0,2]],"b":[{},[0,2]],"c":[{},[0,2,1]],"e":[{},[0,2]],"é":[{"v":[{},[0,0,0,2]]},[0,2]],"f":[{},[0,2]],"h":[{},[0,2]],"i":[{},[0,2,0,2]],"j":[{},[0,2]],"k":[{},[0,2]],"m":[{},[0,2]],"n":[{"á":[{},[0,0,1]]},[0,2]],"o":[{},[0,2]],"r":[{},[0,2]],"s":[{},[0,2]],"t":[{},[0,2]],"u":[{},[0,2,1,2]],"ú":[{},[0,2,1,2]]}],"s":[{"v":[{},[0,0,1]]}],"t":[{"á":[{},[0,2,1]],"e":[{},[0,2,1,2,1,2]],"f":[{"e":[{},[0,0,1]]}],"h":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"o":[{"l":[{},[0,0,0,2]]}],"s":[{},[0,2,1]],"ü":[{},[0,0,1]],"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"e":[{"l":[{},[0,0,2]]}],"í":[{"j":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1,2]]}]}]}]}]}],"e":[{".":[{},[0,2]],"c":[{"s":[{},[0,0,1,2]]}],"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"l":[{"a":[{},[0,2,1]],"b":[{},[0,0,1]],"d":[{},[0,0,1]],"e":[{},[0,0,1]],"é":[{},[0,0,1]],"f":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,2,1]],"ő":[{},[0,2,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"ű":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]},[0,0,0,2]],"m":[{},[0,2,1,2]],"n":[{"g":[{},[0,0,1]],"y":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"d":[{},[0,2,1]],"e":[{"d":[{},[0,0,0,2]]}],"k":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"s":[{},[0,0,0,2]],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]],"z":[{},[0,2,1]]}],"é":[{"j":[{},[0,2,1,2]],"k":[{".":[{},[0,2,1]],"n":[{},[0,2,1]]}],"l":[{},[0,2,1,2]],"n":[{"é":[{},[0,0,0,2]]}],"p":[{"i":[{"p":[{},[0,0,0,2,1,2]]}],"ü":[{"l":[{},[0,2,1,2]]}]}],"r":[{".":[{},[0,2,1]],"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]],"h":[{},[0,0,1]],"ő":[{},[0,2,1]]}]}],"s":[{"z":[{},[0,0,1]]}],"t":[{"e":[{},[0,2,1]]}],"v":[{"e":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{".":[{},[1]],"a":[{"t":[{"y":[{},[0,0,2,1,2]]}]}],"e":[{"m":[{},[0,0,2,1]]}],"i":[{"t":[{},[0,0,2]]}],"l":[{},[1]],"o":[{"d":[{},[1]],"k":[{},[1]]}],"y":[{"a":[{"r":[{},[0,0,3]]}],"e":[{},[0,0,3]],"i":[{},[0,0,3]],"o":[{},[0,0,3]],"ü":[{},[0,0,3]]}]}],"i":[{"a":[{},[0,0,0,3]],"d":[{"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,2,1,2]],"e":[{},[0,2,1]],"é":[{},[0,2,1]]}],"k":[{"e":[{},[0,0,1]]}],"l":[{"l":[{},[0,2]]}],"n":[{"f":[{},[0,0,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]]}],"o":[{"n":[{"i":[{},[0,2,1,2]]}]}],"ó":[{},[0,0,0,2]],"p":[{},[0,2,1]],"r":[{"o":[{},[0,0,1]]}],"s":[{"t":[{},[0,2,1]],"z":[{},[0,0,0,2]]}],"t":[{"a":[{},[0,2]]}],"z":[{"é":[{},[0,0,1]],"m":[{},[0,0,1]]}]}],"í":[{"j":[{},[0,2,1]],"n":[{},[0,0,1]],"r":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1]]}],"k":[{"á":[{"r":[{"o":[{"k":[{},[0,0,0,0,2]]}]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"n":[{"e":[{".":[{},[0,0,2]]}],"o":[{"n":[{},[0,1,2]]}]}],"o":[{"b":[{},[0,2,1]],"l":[{"t":[{"ó":[{},[0,0,1]]}],"y":[{"a":[{},[0,0,0,2,0,1,2]]}]}],"m":[{},[2]],"n":[{"a":[{},[2]],"n":[{},[0,0,0,0,3]],"o":[{"s":[{"z":[{},[0,0,0,2,1]]}]}]}],"p":[{},[0,2,1]],"r":[{"g":[{},[0,2,1]],"j":[{},[0,0,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"t":[{"t":[{"h":[{},[0,2,1]]}]}]}],"ó":[{"r":[{"á":[{"i":[{},[0,0,0,2]]}]}]}],"ö":[{"l":[{},[0,2,1,2]],"n":[{"k":[{},[0,0,1]],"t":[{},[0,0,1]]}],"r":[{"ö":[{},[0,2,1]],"v":[{},[0,0,1]]}],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,2,1]],"s":[{},[0,2,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"m":[{"m":[{"j":[{},[2]]}]}],"v":[{},[0,1,2]]}],"á":[{},[2]],"ó":[{"f":[{},[0,1,2]]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{"t":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"n":[{"d":[{},[0,2,1]]}],"r":[{"a":[{"m":[{},[0,2]],"t":[{},[0,0,0,2]]}],"á":[{},[0,0,1,2]],"n":[{},[0,0,1]]}],"t":[{"á":[{},[0,0,1,2]]}]}],"ú":[{"j":[{},[0,2,1]],"t":[{"a":[{},[0,0,1]],"i":[{},[0,2,1]],"t":[{},[0,0,1]]}]}],"ü":[{"l":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"y":[{"a":[{"c":[{},[0,2,0,1,2]],"d":[{"ó":[{},[0,0,0,1,2]]},[0,2]],"g":[{"y":[{"a":[{},[0,0,0,1,2]]}]}],"j":[{},[0,2]],"k":[{".":[{},[1,2]],"b":[{},[0,2]]}],"l":[{"a":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]],"g":[{},[0,0,0,1]],"j":[{},[0,2]],"k":[{"o":[{},[0,0,0,1]]}],"m":[{},[0,0,0,1]]}],"m":[{},[1,2]],"n":[{"a":[{},[0,0,0,1]],"y":[{},[0,2,0,1]]}],"p":[{"a":[{},[0,2,0,1]],"j":[{"a":[{},[0,0,0,1]],"á":[{},[0,0,0,1]]}],"ó":[{},[0,2,0,1,2]],"r":[{},[0,2,0,1]]}],"s":[{"z":[{"ó":[{},[0,2,0,1]]},[0,0,0,0,2]]}]}],"á":[{"l":[{},[0,2]],"r":[{"v":[{},[0,0,0,1]]}]}],"e":[{"c":[{},[0,2,0,1,2]],"g":[{},[0,0,0,1,2]],"l":[{},[0,2,0,1]],"m":[{},[0,0,0,1]],"s":[{"t":[{},[0,0,0,1]],"z":[{},[0,0,0,1]]}],"v":[{},[0,2]],"z":[{},[0,2,0,1]]}],"é":[{"k":[{".":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"k":[{},[0,0,0,1]]}],"r":[{".":[{},[0,0,0,1]],"e":[{},[0,2,0,1,2]],"n":[{},[0,0,0,1]],"r":[{},[0,0,0,1]],"s":[{},[0,0,0,1]]}]}],"i":[{"m":[{"a":[{},[0,2]]}]}],"n":[{"y":[{"á":[{},[0,0,0,2]]}]}],"o":[{"r":[{"o":[{},[0,2,0,1]],"r":[{},[0,2]]},[0,0,0,0,2]]}],"ö":[{"l":[{},[0,2,0,1,2]]}],"ő":[{"r":[{},[0,2,0,1,2]]}],"u":[{"r":[{"á":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ú":[{".":[{},[1,2]],"a":[{},[1,2]],"n":[{},[0,2]],"r":[{".":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,0,1,2]]}],"t":[{},[0,2]]}],"ű":[{},[2]]}]}],"h":[{"a":[{"l":[{"e":[{},[0,0,0,2,1]]}],"s":[{"á":[{"b":[{"r":[{},[0,0,0,2]]}]}]}]}],"e":[{"l":[{"y":[{"ü":[{"k":[{"ü":[{},[0,0,0,0,0,0,2]]}]}]}]}],"r":[{"t":[{"z":[{"e":[{},[0,0,0,0,1]]}]},[0,0,0,0,0,2]]}]}],"é":[{"j":[{"ú":[{"t":[{},[0,0,0,2,1]]}]}]}],"i":[{"p":[{"s":[{},[0,0,1]]}],"t":[{"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"o":[{"v":[{"i":[{},[0,0,1,2]]}]}],"ú":[{"s":[{"á":[{"r":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]]}]}]}],"i":[{"b":[{"o":[{},[0,0,2]]}],"d":[{"e":[{},[2,0,2]],"o":[{"m":[{},[0,0,2]]}],"ő":[{},[2,0,2]]}],"é":[{"k":[{},[0,2]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"i":[{"a":[{},[0,0,2]],"b":[{},[0,0,2]],"h":[{},[0,0,2]],"j":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"j":[{"e":[{},[0,0,2]]}],"k":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2,1]],"e":[{"l":[{},[0,0,0,1]]},[0,0,2,0,2]],"i":[{"k":[{},[0,0,2]],"s":[{},[0,0,2]]},[0,0,0,0,2]],"o":[{"l":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}]}],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"l":[{"b":[{},[0,2]],"e":[{},[0,2]],"l":[{"e":[{".":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]]},[2]]}],"m":[{"a":[{".":[{},[0,0,2]]}],"á":[{},[2,0,2]],"i":[{"t":[{},[0,0,2]]},[2]],"p":[{},[2]]}],"n":[{"a":[{".":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,1]]},[0,0,2,0,2]],"s":[{},[2,0,2]]}],"á":[{"l":[{"o":[{},[0,0,2,1]]}],"r":[{},[0,0,2]]},[0,0,0,0,2]],"d":[{},[2]],"e":[{},[0,0,2]],"é":[{"l":[{},[0,0,2]]}],"f":[{},[2]],"g":[{},[2]],"i":[{"n":[{},[0,0,2,1]]}],"o":[{"l":[{},[0,0,2]]}],"p":[{},[2]],"s":[{},[2]],"t":[{},[2]],"ü":[{},[0,0,2]]}],"o":[{"n":[{"b":[{},[0,0,2]],"n":[{},[0,0,2]],"o":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}]}],"p":[{"a":[{},[0,0,2]]}],"r":[{".":[{},[0,2]],"a":[{"m":[{},[0,0,2]],"t":[{},[2,0,2]]}],"á":[{},[2,0,2]],"e":[{".":[{},[0,0,2]]}],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{"d":[{},[0,0,2]]},[2]]}],"s":[{"e":[{},[0,2,2]],"i":[{},[0,0,2]],"k":[{},[2]],"m":[{},[2]],"t":[{},[2]],"z":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]]},[2]]}],"t":[{"a":[{},[2,0,2]]}],"v":[{"a":[{"d":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"s":[{},[0,0,2]]}],"ó":[{},[2,0,2]]}],"z":[{"é":[{},[0,0,2]],"o":[{"m":[{},[0,0,2]]}]}]},[0,1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"j":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"t":[{"é":[{},[0,0,2]]}],"v":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ó":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[0,1]],"j":[{"a":[{"d":[{"ó":[{},[0,2,1,2]],"u":[{},[0,2,1]]}],"g":[{"a":[{},[0,0,1]],"r":[{},[0,0,1]]}],"k":[{"o":[{"l":[{},[0,0,0,2]]}],"ó":[{},[0,2,1]],"ú":[{},[0,0,0,2]]}],"n":[{"a":[{},[0,2,1]],"t":[{},[0,2,1]],"y":[{},[0,2,1]]}],"p":[{"r":[{},[0,0,1]]}]}],"á":[{"a":[{},[0,2,1]],"c":[{},[0,0,0,2]],"g":[{"o":[{},[0,0,1,2]]}],"n":[{"d":[{},[1,2]],"l":[{},[1]]}],"p":[{},[0,2,1]],"r":[{"b":[{},[0,2,1]],"c":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]],"r":[{},[0,2,1]]},[2]],"s":[{"á":[{},[0,0,1]],"v":[{},[0,0,1]]}],"t":[{"e":[{},[0,2,1,2,1,2]]}],"z":[{"á":[{},[0,0,1]]},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"a":[{"l":[{"m":[{},[0,0,2,1]],"o":[{"m":[{".":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}]}]}]}]}],"e":[{"c":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"é":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1]],"e":[{"m":[{"e":[{},[0,0,0,2]]}]}],"f":[{},[0,2,1]],"l":[{"á":[{},[0,0,1]]}],"o":[{},[0,2,1]],"ő":[{},[0,0,1]],"v":[{"á":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"m":[{},[0,2,1,2]],"n":[{"e":[{},[0,0,1]],"z":[{},[0,0,1]]}],"r":[{},[0,2,1,2]],"s":[{"e":[{},[0,0,1,2]]}],"x":[{},[0,2,1]],"z":[{},[0,2,1]]}],"é":[{"g":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,0,1]]}],"k":[{},[0,2,1,2]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{"e":[{},[0,2,1]]},[0,0,0,2]],"t":[{"e":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"d":[{},[0,2,1,2]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{"t":[{},[0,2,1]]}],"o":[{},[0,2,1]],"p":[{},[0,2,1]],"z":[{},[0,2,1]]}],"í":[{"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"ú":[{".":[{},[1]]}]}],"o":[{"b":[{"b":[{"o":[{},[0,0,0,0,0,1]]}]}],"g":[{"á":[{"s":[{"z":[{"a":[{},[0,0,0,2,1,2]]}]}]}]}],"l":[{"a":[{},[0,2,1]],"d":[{},[0,0,1]]}],"v":[{},[0,2,1,2]]}],"ó":[{"c":[{"s":[{"k":[{"á":[{"s":[{},[0,2,1]]}]}]}]}],"s":[{"á":[{"r":[{},[0,0,0,2]]}]}]}],"ö":[{"b":[{},[0,0,1]],"k":[{},[0,2,1]],"r":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ő":[{"r":[{},[0,0,1]],"s":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"h":[{},[0,0,1]],"k":[{},[0,0,1]],"p":[{},[0,0,1]]}],"t":[{"á":[{"g":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2]]}],"é":[{"t":[{},[0,0,2,1,2]]}],"o":[{"r":[{"g":[{},[0,0,0,1]]}]}]}],"u":[{"h":[{"i":[{},[0,0,0,2]]}]}],"ú":[{"j":[{},[0,2,1]],"s":[{"z":[{},[0,0,1]]}],"t":[{"o":[{},[0,2,1]],"r":[{},[0,2,1]]}]}],"ü":[{"g":[{},[0,0,1]],"l":[{},[0,0,1]],"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ű":[{"z":[{},[0,0,1]]}],"z":[{"a":[{"k":[{"a":[{},[0,0,0,1]]}],"t":[{"l":[{},[0,0,0,1]]}]}],"e":[{"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}],"k":[{"a":[{"b":[{},[2]],"c":[{"s":[{"e":[{},[0,0,0,2]]}]}],"d":[{"a":[{"g":[{},[0,2]],"t":[{"a":[{},[0,2,1,2]],"b":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}]}],"á":[{"l":[{},[1]]}],"é":[{"m":[{},[1,2]]}],"m":[{},[0,2,1]]}],"g":[{"a":[{},[0,2,1]]}],"l":[{"a":[{"g":[{},[0,0,1,2]],"k":[{},[0,2,1,2]],"p":[{"ú":[{},[0,0,0,2]]}]}],"e":[{"g":[{},[0,2,1]]}],"k":[{"o":[{},[0,0,1]]}]},[2]],"m":[{},[2]],"n":[{},[2]],"o":[{},[2]],"p":[{"á":[{"d":[{},[0,0,0,2]]}],"p":[{},[0,0,1]]},[2]],"r":[{"a":[{"i":[{},[0,0,1,2]],"s":[{"z":[{},[0,0,1]]}]}],"á":[{"b":[{},[0,2,1,2]],"k":[{},[0,2,1,2]]}],"c":[{"h":[{},[0,2]]},[2]],"d":[{},[2]],"é":[{"n":[{},[0,0,1,2]]}],"i":[{},[2]],"r":[{},[2]]}],"s":[{"í":[{},[2]],"t":[{},[2]],"z":[{"a":[{"j":[{},[0,0,0,2]],"t":[{},[0,0,1,2]]}],"e":[{"l":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2]],"t":[{"r":[{},[0,2,1]]}]}]}],"t":[{"a":[{"b":[{},[0,0,0,2]]},[2]],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]},[2]],"i":[{"k":[{},[0,0,0,2]],"m":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"u":[{"t":[{"ó":[{},[0,2,1]]}]},[2]],"v":[{},[2]],"z":[{},[2]]}],"á":[{"c":[{".":[{},[1]]}],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{"a":[{},[0,0,0,2,1]],"i":[{"s":[{},[0,0,0,2]]}],"l":[{"ó":[{},[0,2,1]]}]}],"r":[{"a":[{"d":[{},[0,0,1]]}],"b":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2]],"o":[{"k":[{"n":[{},[0,0,0,2]]}]}],"t":[{"ó":[{},[0,2,1]]}],"u":[{},[0,2,1,2]]}],"s":[{"a":[{"d":[{},[0,0,0,2]],"j":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"á":[{"s":[{"t":[{},[0,0,0,2]]}]}],"s":[{},[0,0,0,0,3]],"z":[{"á":[{"n":[{},[0,0,1,2]]}],"u":[{"n":[{},[0,2,1]]},[0,0,0,2]]}]}],"t":[{"a":[{},[0,0,0,0,1]],"l":[{"a":[{},[0,2,1]]}]}]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"i":[{"ó":[{"s":[{"ű":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"e":[{".":[{},[0,2]],"c":[{"s":[{},[0,0,0,2]]}],"d":[{"z":[{},[0,2,1,2]]}],"g":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]]}],"l":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"e":[{"m":[{},[0,0,0,2]]}],"h":[{},[0,0,1]],"j":[{},[0,2,1]],"o":[{},[0,2,1]],"ő":[{"k":[{},[0,0,0,2]]}],"r":[{},[0,2,1]],"v":[{},[0,2,1]]}],"m":[{"b":[{},[0,2,1]],"e":[{"l":[{},[0,0,1,2]]}]}],"r":[{"d":[{},[0,2]],"e":[{"i":[{},[0,0,1,2]]}],"ó":[{},[0,2,1,2]],"ő":[{},[0,2,1,2]]}],"s":[{"p":[{},[0,2]],"t":[{},[0,2,1]],"z":[{"k":[{},[0,0,1]],"m":[{},[0,0,1]]}]}],"t":[{"e":[{},[0,2,1,2]],"i":[{},[0,0,1,2]]}],"v":[{"e":[{"z":[{},[0,2,1,2]]}]}]}],"é":[{"k":[{"e":[{"m":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"é":[{},[0,2,1,2]],"h":[{},[0,2,1]],"r":[{"ő":[{},[0,0,1]]}]}],"m":[{},[2]],"n":[{"y":[{},[2]]}],"p":[{".":[{},[2]],"b":[{},[2]],"e":[{},[2]],"é":[{},[2]],"h":[{},[2]],"k":[{},[2]],"l":[{},[2]],"n":[{},[2]],"p":[{"e":[{"l":[{},[2]]}],"é":[{},[2]]}],"r":[{},[2]],"t":[{},[2]],"ü":[{},[2]],"z":[{},[2]]}],"r":[{"c":[{},[0,2,1]],"d":[{"e":[{"k":[{},[0,2]]}]},[2]],"e":[{},[2]],"é":[{},[2]],"m":[{},[0,2,1]],"ő":[{"i":[{},[0,2,1,2]],"j":[{},[0,2,1,2]]},[2]],"r":[{},[0,2,1]],"t":[{"e":[{"k":[{"e":[{},[0,2]]}],"l":[{},[0,2,1]],"t":[{},[0,2,1]]}],"ő":[{},[0,2,1]]}],"v":[{},[2]],"z":[{},[0,2,1]]}],"s":[{"z":[{"a":[{},[0,2,1]]}]},[2]],"t":[{"e":[{},[0,2,1,2]],"s":[{},[2]],"t":[{},[0,2,1]]}],"z":[{},[2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"e":[{"r":[{"i":[{"n":[{"c":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"r":[{},[0,0,1]]}],"i":[{"a":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{"é":[{},[0,2,1,2]],"i":[{},[0,0,1]]},[2]],"e":[{},[2,0,0,0,2]],"é":[{},[2]],"f":[{},[2]],"g":[{"a":[{},[0,0,1]],"é":[{},[0,2,1]],"y":[{},[2]]}],"h":[{},[2]],"í":[{},[2]],"j":[{},[2]],"l":[{"l":[{},[0,2,1]],"y":[{},[0,0,1]]},[2]],"m":[{"á":[{},[0,2,1,2]],"i":[{},[0,2,1]]},[2]],"n":[{"d":[{},[0,0,1]],"g":[{},[0,2,1]],"s":[{},[0,2,1]]},[2]],"o":[{"n":[{},[0,2,1]]}],"r":[{"o":[{"m":[{},[0,0,0,2]]}]},[2]],"s":[{"i":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,0,1]],"t":[{},[0,2,1]]},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{"m":[{},[0,2,1]]},[2]]}],"í":[{"t":[{"é":[{},[0,2]]}],"z":[{},[0,2,1,2]]}],"k":[{"a":[{"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2]],"l":[{"a":[{},[0,0,2,1,2]],"k":[{},[0,0,0,1]]}],"r":[{"c":[{},[0,0,2,1]]}]}],"á":[{"l":[{},[0,0,2]],"p":[{},[0,0,2,1,2]]}],"e":[{"d":[{},[0,0,2,1]],"l":[{"l":[{},[0,0,0,1]],"m":[{},[0,0,2]],"t":[{},[0,0,0,1]]}],"m":[{},[0,0,2]],"r":[{"ó":[{},[0,0,2,1]]}],"s":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{},[0,0,2]]}],"o":[{"l":[{"a":[{},[0,0,2]]}],"r":[{"d":[{},[1]]}]}],"ö":[{"l":[{"t":[{},[0,0,0,1]]}],"s":[{},[0,0,2,1]]}],"ő":[{"r":[{},[0,0,2]]}],"u":[{".":[{},[1]],"m":[{},[1]]}]}],"l":[{"a":[{"u":[{},[0,0,2]],"v":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2]]}],"ó":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]]}]}],"n":[{"a":[{"i":[{},[1]]}],"á":[{"b":[{},[1]],"h":[{},[1]],"i":[{},[1]],"k":[{"a":[{},[1]],"o":[{},[1]]}],"s":[{},[1]],"t":[{".":[{},[1]]}],"v":[{},[1]],"z":[{},[1]]}]}],"o":[{"a":[{},[2]],"b":[{"j":[{},[0,0,1]]}],"c":[{},[2]],"f":[{},[2]],"k":[{"t":[{},[2]]}],"l":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,0,3]]}]}],"d":[{"a":[{},[0,2,1]]}],"y":[{},[0,2,1,2]]}],"m":[{},[2]],"n":[{"c":[{},[2]],"d":[{},[2]],"f":[{},[2]],"g":[{},[2]],"k":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"y":[{},[2]],"z":[{},[2]]}],"o":[{},[2]],"p":[{"e":[{},[0,2,1,2]]},[2]],"r":[{"a":[{"t":[{},[0,0,1,2]]}],"b":[{},[2]],"d":[{},[2]],"g":[{},[0,2,1]],"i":[{},[2]],"j":[{},[0,2,1]],"l":[{},[2]],"m":[{},[2]],"o":[{},[2]],"p":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"u":[{},[2]],"ú":[{},[2]],"v":[{},[0,2,1]]}],"s":[{},[2]]}],"ó":[{"n":[{"i":[{},[2]]}],"p":[{},[2,0,0,1,2]],"r":[{"á":[{},[0,2,1,2]],"ó":[{"d":[{},[0,0,1,2]]}]}],"z":[{"á":[{},[1,2]]}]}],"ö":[{"s":[{"s":[{"z":[{},[0,0,1]]}]}],"z":[{"é":[{"l":[{},[0,0,0,2,1,2]]}],"r":[{"e":[{"a":[{},[0,0,0,0,0,0,0,3]]}]}]}]}],"ő":[{"r":[{".":[{},[0,0,1]]}],"s":[{".":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"á":[{"d":[{"i":[{},[0,0,0,0,0,0,2]]}],"t":[{},[0,0,2]]}],"e":[{"a":[{},[0,0,2]]},[2]],"é":[{"m":[{"e":[{},[0,1,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}]},[2]],"i":[{"t":[{},[0,1,2]]},[2]],"í":[{"z":[{},[0,0,2]]},[2]],"o":[{"b":[{},[1]]}],"ó":[{"n":[{"i":[{"k":[{},[2]]}]}]}]}],"s":[{"p":[{},[0,0,1]],"z":[{"t":[{},[0,0,1,0,2]]}]}],"t":[{"a":[{"u":[{},[0,0,2,1]]}],"á":[{"r":[{"s":[{"a":[{"d":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"e":[{"m":[{"b":[{},[0,0,0,1]]}]}],"i":[{".":[{},[1]],"m":[{},[0,0,2]]}],"í":[{"v":[{"b":[{},[1]],"e":[{".":[{},[0,0,2,1]]},[0,0,0,0,2]],"k":[{},[1]],"o":[{},[1]],"s":[{},[1]],"t":[{},[1]]}]}],"o":[{"r":[{"á":[{"l":[{},[0,0,0,0,2,1]]}]}],"s":[{"z":[{},[0,0,0,1]]}]}],"r":[{"á":[{},[0,0,1]]}],"u":[{"a":[{},[1]]}],"ú":[{".":[{},[1]]}]}],"u":[{"d":[{"v":[{},[0,2,1]]}],"j":[{"j":[{},[0,2,1]]}],"n":[{},[2]],"p":[{"u":[{},[1]]}]}],"ú":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{"r":[{},[0,2,1]]}]}],"ü":[{"g":[{},[0,2,1]],"l":[{"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"n":[{},[0,2,1]]}],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]]}],"y":[{"a":[{},[0,0,1]]}]}],"l":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"c":[{"c":[{},[0,0,0,0,1]],"e":[{},[0,0,0,0,0,2]],"i":[{"t":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"o":[{"r":[{},[0,0,0,2]]}],"s":[{"é":[{},[0,2]],"ö":[{},[0,0,0,2,3]],"ü":[{},[0,0,0,2]]}]}],"d":[{"a":[{"g":[{},[0,2]],"t":[{"á":[{},[0,2,1,2]]}]}]}],"g":[{"á":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"é":[{"p":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"y":[{"a":[{},[0,0,0,2]]}]}],"j":[{"a":[{"d":[{},[0,0,0,2,1,2]],"s":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]]}],"k":[{"a":[{"d":[{},[0,2]],"n":[{},[0,0,0,2,1]],"s":[{},[0,2,1,2]]}],"á":[{"l":[{},[0,0,0,2]],"p":[{},[0,0,0,2,1]]}],"e":[{"s":[{},[0,0,0,2]]}],"í":[{},[1,2]],"n":[{"a":[{".":[{},[0,2,1]]}],"á":[{"k":[{},[0,2]],"t":[{},[0,2]]}]}],"o":[{"l":[{},[0,0,0,2]]}],"ó":[{"d":[{},[0,2,1,2]]}],"ö":[{"l":[{},[0,0,0,2,1]]}],"t":[{"u":[{},[0,2,1]]}],"u":[{"l":[{".":[{},[0,2]],"t":[{},[0,2]]}]},[1]]}],"l":[{"g":[{},[0,0,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"o":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,0,2,1]],"n":[{"y":[{},[1,2]]}],"y":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,0,1,2]]},[0,2]]}],"p":[{"a":[{"d":[{},[0,0,0,2,1,2]],"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"n":[{},[0,2]]}],"á":[{"r":[{},[0,0,0,2,1,2]]}],"e":[{},[0,0,0,2,1,2]],"i":[{"l":[{"l":[{},[0,0,0,2]]}],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"í":[{"t":[{"v":[{},[1,2]]}]}],"o":[{"l":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,2,1]]}]}],"ó":[{},[0,0,0,0,1,2]],"p":[{},[0,0,0,0,1]]}],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"g":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,0,1,2]],"z":[{"p":[{},[0,2,1]],"t":[{"a":[{"l":[{},[0,0,0,0,0,0,0,2]]}]}]}]}],"t":[{"a":[{"n":[{"y":[{},[0,0,0,0,1]]}]}],"á":[{"t":[{"a":[{},[0,0,0,0,0,0,1,2]]}]}],"e":[{"v":[{},[0,0,0,2,1,2]]}],"i":[{"n":[{"f":[{},[0,0,0,2,1]]}]}],"í":[{"v":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2,1]]}],"ó":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"t":[{"a":[{"k":[{},[0,2,1]]}],"i":[{},[1,2]]}],"ü":[{},[0,0,0,2,1,2]]}],"v":[{"a":[{},[0,0,1]]}],"z":[{"ú":[{"r":[{},[0,0,0,2]]}]}]}],"á":[{"a":[{},[1,2]],"á":[{},[1,2]],"b":[{"a":[{"d":[{"a":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"r":[{"á":[{},[0,0,1]]}],"ú":[{"j":[{},[1,2]]}]}],"d":[{"a":[{"l":[{},[0,0,0,2]],"p":[{},[0,0,0,2,1]]}]}],"f":[{},[1,2]],"g":[{".":[{},[0,2,1]],"a":[{},[0,2]],"á":[{},[0,0,1,2]],"b":[{},[0,0,1]],"g":[{},[0,2,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1,2]],"k":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1,2]],"r":[{},[0,2,1]],"t":[{},[0,0,1]],"ú":[{},[0,0,1,2]],"y":[{"a":[{},[0,0,1]]}]}],"í":[{},[1,2]],"m":[{"o":[{},[1,2]]}],"r":[{"a":[{"d":[{},[0,2,1]],"k":[{},[0,2]]}],"á":[{"r":[{},[0,0,0,2]]},[0,2]],"k":[{},[0,2,1]]}],"s":[{"t":[{"e":[{"l":[{},[0,0,0,0,2]]},[0,0,0,0,0,0,2]],"é":[{"r":[{".":[{},[0,0,0,0,2,1]]}]}]}]}],"t":[{"d":[{},[0,2,1]],"e":[{},[0,2]],"é":[{"p":[{},[0,0,1]]},[0,2]],"f":[{},[0,2,1]],"i":[{},[0,0,0,2]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"ö":[{},[0,2]],"r":[{},[0,2]],"ú":[{},[0,2]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"u":[{"m":[{},[1]]}]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{".":[{},[0,2]],"a":[{},[2]],"b":[{"é":[{},[0,0,1]]},[2]],"c":[{"e":[{},[0,0,1]]},[2]],"g":[{"e":[{"l":[{"é":[{},[0,0,0,2,1,2]]}]}],"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]},[0,0,1]]}],"y":[{"s":[{},[0,0,1]],"ü":[{},[0,2]]}]}],"h":[{},[2]],"í":[{},[2,0,0,0,2]],"j":[{},[2]],"k":[{"a":[{},[0,0,0,2,1]]}],"l":[{"a":[{},[0,2,1]],"á":[{"g":[{},[0,2,1]]}],"d":[{},[0,2,1]],"e":[{"d":[{},[0,0,1,2]],"m":[{".":[{},[0,0,0,2]],"b":[{},[0,0,0,2]],"e":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"m":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}]}],"g":[{},[0,2,1]],"h":[{},[0,2,1]],"m":[{},[0,0,1]],"n":[{},[0,2,1]],"ő":[{"k":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"é":[{},[0,0,1]]}],"v":[{},[0,2,1]]}],"m":[{"b":[{},[0,2,1]],"e":[{"l":[{},[0,2,1,2]]}],"é":[{},[0,0,1,2]],"l":[{},[0,2,1]]},[2]],"n":[{"e":[{},[0,2,1]]},[2]],"p":[{"e":[{".":[{},[0,0,0,2]]}]},[2]],"r":[{"d":[{},[0,2]],"e":[{},[0,2,1,2]],"k":[{},[0,2,1]],"n":[{},[0,2,1]]}],"s":[{"e":[{"m":[{},[0,0,1]]}],"i":[{"k":[{},[0,0,0,2]]},[0,2]]},[2]],"t":[{"e":[{"t":[{},[0,0,0,2]]}],"t":[{"e":[{"s":[{"t":[{},[0,0,0,0,2,1]]}]}]}]}],"ü":[{},[0,0,0,0,2]],"v":[{"o":[{"l":[{},[0,0,0,2]]}],"ő":[{"i":[{},[0,0,0,2]]}]},[2]],"x":[{"p":[{},[0,2,1]]},[2]]}],"é":[{"c":[{},[2]],"g":[{"ő":[{},[0,0,1]]},[2]],"k":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]],"t":[{},[0,0,0,2]]}],"e":[{"m":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"o":[{"r":[{},[0,0,0,2]]}]}],"l":[{".":[{},[0,2]],"e":[{"n":[{},[0,0,1,2]],"t":[{},[0,2,1,2]]}],"é":[{},[0,2,1]],"l":[{},[0,2,1]],"ő":[{},[0,0,1,2]],"ü":[{},[0,2,1]]}],"n":[{"e":[{"k":[{"e":[{},[0,2]]}]}]},[2]],"r":[{"d":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"t":[{"e":[{"k":[{},[0,0,0,2]],"l":[{},[0,2,1,2]]}],"l":[{},[0,0,1]]},[2]],"v":[{"i":[{},[0,2,1]]}]}],"f":[{"á":[{"s":[{},[1]]}]}],"g":[{"á":[{"s":[{"a":[{"t":[{},[1]]}]}]}],"o":[{"r":[{},[1]]}],"r":[{},[0,0,1]]}],"i":[{"c":[{},[2]],"d":[{"e":[{},[0,0,1]],"é":[{},[0,2]],"o":[{},[0,0,1,2]]}],"f":[{"j":[{},[0,0,1]]}],"g":[{"é":[{},[0,2,1]]}],"k":[{},[2]],"l":[{"l":[{},[0,0,1]]}],"m":[{"á":[{},[0,2,1,2]]},[2]],"n":[{"a":[{"s":[{},[0,2]]}],"i":[{"n":[{},[0,0,0,2]]}]}],"ó":[{"r":[{"a":[{},[0,0,0,0,2]]}]}],"p":[{"a":[{},[0,0,1,2]]}],"r":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]]}],"s":[{"i":[{},[0,2,1,2]],"m":[{},[0,2]],"p":[{"o":[{},[0,0,0,1,2]]}],"t":[{"e":[{},[0,0,1]]}]}],"t":[{"e":[{},[2]]}],"z":[{"m":[{"a":[{},[0,0,1]]}]}]}],"í":[{"j":[{},[0,0,1]],"v":[{},[0,2,1,2]]}],"j":[{"a":[{"i":[{"k":[{"é":[{},[0,0,0,0,2]]}]}],"k":[{"a":[{},[1]],"b":[{},[1]],"é":[{},[1]],"k":[{},[1]],"o":[{},[1]]}],"s":[{},[1]]}],"á":[{"i":[{},[1]],"r":[{"n":[{"a":[{},[0,0,0,1]]}],"o":[{},[0,0,2,1,2]]}]}],"b":[{},[1]],"c":[{},[1]],"d":[{},[1]],"e":[{"r":[{},[1]]}],"f":[{},[1]],"g":[{},[1]],"h":[{},[1]],"i":[{"a":[{},[1]]}],"í":[{},[0,0,2]],"j":[{},[1]],"k":[{},[1]],"l":[{},[1]],"m":[{},[1]],"n":[{},[1]],"r":[{},[1]],"s":[{},[1]],"t":[{},[1]],"ú":[{},[1]],"ü":[{},[1,0,2]],"v":[{},[1]],"z":[{},[1]]}],"k":[{"a":[{"p":[{"ó":[{},[0,0,2,1,2]]}]}],"e":[{"l":[{"e":[{},[0,0,0,0,0,0,2]]}]}],"í":[{"m":[{},[1]]}],"o":[{"h":[{},[1]],"t":[{"á":[{},[1]],"m":[{},[1]],"ó":[{},[1]]}]}],"r":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"u":[{".":[{},[1]],"d":[{},[1]],"n":[{},[1]]}]}],"l":[{"a":[{"j":[{},[0,0,2,1]],"k":[{"t":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"l":[{"a":[{},[0,0,2,1]],"k":[{},[0,0,2]]},[0,0,0,0,2]],"u":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}],"z":[{"s":[{},[0,0,0,1]]}]}],"e":[{"d":[{},[0,0,2]],"g":[{"y":[{},[0,0,0,1]]}],"m":[{"b":[{},[0,0,0,1]]}],"r":[{"g":[{},[1]]}],"s":[{"e":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"v":[{"ő":[{},[0,0,0,1,2]]}]}],"é":[{"j":[{"é":[{},[0,0,0,1,2]]}]}],"i":[{"d":[{},[0,0,2,1]],"m":[{},[0,0,2]],"n":[{"t":[{},[0,0,0,1]]}],"p":[{},[0,0,2]],"s":[{"k":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2]],"ó":[{"r":[{"i":[{},[0,0,0,1]]}]}],"ö":[{"s":[{},[0,0,2]]}],"ő":[{},[0,0,2,1,2]],"ü":[{},[0,0,2]],"ű":[{},[1]]}],"m":[{"á":[{"d":[{},[1]]}]}],"o":[{"b":[{"e":[{},[0,0,1]]},[2]],"g":[{"o":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}],"ó":[{},[0,0,0,2,1,2]]}],"k":[{"t":[{"a":[{},[0,2,1]]}]}],"l":[{"d":[{".":[{},[0,0,2]]}]}],"m":[{"a":[{"d":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2,1]],"p":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{"c":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2,1]]}],"e":[{"r":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"p":[{},[0,0,0,0,1,2]],"ú":[{},[0,0,0,2,1]]}],"n":[{"á":[{},[0,0,0,2,1]],"d":[{},[0,0,0,0,1,2]],"n":[{},[0,0,0,0,3]]}],"p":[{"c":[{},[0,0,1]],"e":[{},[0,2,1]]},[2]],"r":[{"a":[{},[0,0,1,2]],"c":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1,2]],"r":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]],"t":[{"á":[{},[0,2,1]]}],"z":[{"l":[{},[0,2,1]]}]}],"v":[{},[2]]}],"ó":[{"c":[{"s":[{"e":[{},[0,0,0,2,3]]}]}],"g":[{"u":[{"s":[{"e":[{"s":[{},[3]]}]}]}]}],"i":[{"g":[{"a":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}],"k":[{"o":[{},[0,0,0,0,2]]}]}],"l":[{"o":[{},[0,0,1,2]]}],"n":[{"n":[{},[0,0,1]]}],"ó":[{},[0,0,0,0,2]],"r":[{"á":[{"j":[{},[0,0,0,2]],"k":[{},[0,0,0,2]]}]}],"z":[{"a":[{"n":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]}]}]}],"ö":[{"b":[{},[0,2,1]],"l":[{},[0,2,1,2]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"p":[{"e":[{"l":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{"z":[{},[0,0,2]]}]}],"s":[{"h":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"p":[{},[0,0,1]],"z":[{"t":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"a":[{"d":[{"a":[{},[0,0,2]]}],"l":[{"a":[{"p":[{},[0,0,2,1]]}]}],"n":[{"y":[{"a":[{},[0,0,0,1]]}]}]}],"e":[{"l":[{"v":[{},[0,0,0,1]]}],"m":[{"b":[{},[0,0,0,1]]}],"p":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1,2]]}],"é":[{"k":[{},[0,0,2,1,2]],"n":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{"n":[{"e":[{},[0,0,0,1]]}],"ő":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"t":[{"ő":[{},[0,0,0,1]]}]}]}],"i":[{"m":[{},[0,0,2,1,2]],"n":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"p":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1]]}],"o":[{"l":[{"d":[{},[0,0,2,1]]}],"n":[{"k":[{},[1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"c":[{},[0,0,2]]}],"ö":[{"n":[{},[0,0,2]]}],"r":[{"a":[{"k":[{},[0,0,1]],"n":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"u":[{"r":[{},[0,0,2]]}],"ú":[{"t":[{},[0,0,2,1]]}],"ü":[{"r":[{},[0,0,2]]}],"v":[{"é":[{},[1]]}],"y":[{},[0,0,1]]}],"u":[{"p":[{},[0,0,0,1]],"s":[{"s":[{},[1,2]],"t":[{"r":[{},[0,0,0,1]]}]}]}],"ú":[{"j":[{},[0,2,1]],"r":[{".":[{},[0,0,1]],"b":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"t":[{"é":[{},[0,2,1]],"h":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"ü":[{"g":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1]]}],"ű":[{"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"v":[{"e":[{"o":[{},[1]]}],"ó":[{},[1]]}],"y":[{"a":[{"p":[{},[0,2,0,1]],"r":[{},[0,2]]}],"á":[{"l":[{},[0,2]]}],"e":[{},[0,2,0,1,2]],"é":[{"v":[{},[0,2]]}],"i":[{"d":[{},[0,2,0,1]],"m":[{},[0,2]],"s":[{},[0,2]]}],"ö":[{},[0,2]],"u":[{"g":[{},[0,2]]}],"ü":[{},[0,2,0,1,2]]}]}],"m":[{"a":[{"b":[{"b":[{},[0,0,1]],"l":[{},[0,0,1]]}],"d":[{"a":[{"t":[{},[0,2,1,2]]}],"á":[{"s":[{},[0,0,1,2]]}],"m":[{},[0,2,1]],"ó":[{},[0,2,1,2]],"u":[{},[0,2,1,2]]},[2]],"g":[{"á":[{"t":[{},[0,0,0,2]]}]},[2]],"j":[{"t":[{},[0,0,1]]},[2]],"k":[{"a":[{"r":[{},[0,0,0,2]]}],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"l":[{"a":[{"k":[{},[0,2,1,2]],"p":[{},[0,0,1,2]]}],"e":[{},[0,2,1,2,1]]}],"n":[{"y":[{"a":[{},[0,0,0,2]]}]}],"ó":[{},[0,0,0,0,2]],"p":[{},[2]],"s":[{"z":[{"a":[{"k":[{},[0,0,0,2,0,1,2]]}],"e":[{"g":[{},[0,0,0,2]],"m":[{},[0,0,0,2,0,1]]}],"é":[{"l":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2]]}]},[2]],"t":[{"a":[{"d":[{},[0,0,0,2]],"n":[{},[0,0,0,0,0,2]]}],"á":[{"r":[{"á":[{},[0,0,0,2]]}]}],"e":[{"l":[{},[0,0,0,2]]}],"o":[{"l":[{"d":[{},[0,0,0,2]]}],"s":[{"z":[{},[0,0,0,2,1]]}]}],"ó":[{},[0,0,0,2,1,2]]}],"u":[{},[0,2,1,2]],"z":[{"o":[{},[0,2]]}]}],"á":[{"l":[{"m":[{},[0,2,1]]}],"r":[{"a":[{"i":[{},[0,2,1,2]],"k":[{},[0,2,1,2]]}],"á":[{},[0,0,0,2]]}],"t":[{"a":[{"d":[{"ó":[{".":[{},[0,0,0,0,1,2]]}]}]}],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"b":[{"a":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"á":[{"s":[{"z":[{"á":[{},[0,0,2,1]]}]}]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,2,1,2]]}],"p":[{},[0,0,2]],"t":[{"e":[{},[0,0,2,1,2]]}]}],"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"u":[{"l":[{"a":[{},[1]]}]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{".":[{},[0,2]],"c":[{"e":[{},[0,0,1,2]]}],"g":[{},[2]],"l":[{"á":[{},[0,0,1]],"e":[{"m":[{},[0,0,1,2]]}],"i":[{},[0,2,1,2,1]],"j":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1]],"ő":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"m":[{"e":[{},[0,2,1,2]]}],"n":[{"g":[{},[0,2,1]],"n":[{},[2]],"s":[{"s":[{},[0,0,0,0,0,1]]}],"t":[{"á":[{"r":[{"o":[{},[0,0,0,0,2,1,2]]}]}]}]}],"r":[{"d":[{},[0,2,1]],"ő":[{},[0,2,1,2]]}],"s":[{"k":[{},[0,2]],"t":[{},[2]]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]],"z":[{"r":[{},[0,0,1]]}]}],"é":[{"h":[{"e":[{"s":[{},[0,0,0,2]]}]}],"k":[{"é":[{},[0,0,1]]},[0,0,0,2]],"l":[{"e":[{"t":[{},[0,0,0,2]]}]}],"p":[{},[0,2,1]],"r":[{"d":[{},[0,2,1]],"t":[{"e":[{"k":[{},[0,2,1]],"l":[{},[0,2]]}]}]}],"t":[{"k":[{},[0,2,1]]}],"v":[{"é":[{},[0,2,1]]}]}],"f":[{"o":[{"r":[{"á":[{},[1]]}]}],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{"i":[{},[0,0,0,0,1,2]]}],"g":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"m":[{"á":[{},[0,2]],"i":[{},[0,0,1]],"p":[{},[0,0,1]]}],"n":[{"a":[{".":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"t":[{"é":[{},[0,2,1]]}]}],"ó":[{},[0,0,0,0,2]],"r":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]]}],"s":[{"e":[{"l":[{},[0,0,0,2]],"p":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"z":[{},[0,0,0,2]]}],"t":[{"b":[{"o":[{},[1]]}],"h":[{"a":[{},[1,2]]}],"m":[{},[1,2]],"ö":[{},[1,2]],"r":[{"o":[{},[1]],"ú":[{},[1]]}],"s":[{},[1,2]],"t":[{"á":[{},[1,2]],"ö":[{},[1,2]]}]}]}],"í":[{"g":[{},[0,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"m":[{"e":[{"g":[{"y":[{},[0,0,2,1]]},[0,0,0,0,2]],"t":[{"a":[{},[0,0,2]]}]}],"é":[{"t":[{},[0,0,2,1,2]]}]}],"o":[{"d":[{},[2]],"k":[{"e":[{},[0,2,1]],"m":[{},[0,2,1]],"o":[{"z":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,0,1]],"d":[{},[0,2,1]],"t":[{"á":[{},[0,2,1]]}]}],"p":[{},[0,2,1]],"r":[{"s":[{},[0,2,1]],"t":[{},[1,2]],"v":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]]},[2]],"t":[{},[2]],"z":[{},[2]]}],"ó":[{"r":[{"i":[{},[0,0,1,2]]}]}],"ö":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"p":[{"l":[{"a":[{},[0,0,1]]}],"r":[{},[0,0,1,2]],"u":[{"t":[{},[1]]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"n":[{"i":[{},[0,2]]},[2]],"r":[{"i":[{"z":[{},[0,0,0,2]]}]}],"s":[{"l":[{},[0,0,0,1]]}],"t":[{"a":[{"s":[{},[0,2,1,2]]}]}]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"n":[{"a":[{"d":[{"a":[{"t":[{},[0,2,1,2]]}],"u":[{},[0,2,1]]},[2]],"g":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"y":[{"a":[{},[0,0,1,2]]}]}],"h":[{},[0,2,1]],"i":[{},[2]],"k":[{"r":[{},[1,2]]}],"l":[{"a":[{"p":[{},[0,0,0,2]]}],"í":[{},[1]],"k":[{},[0,0,1]],"m":[{},[0,0,1]],"ó":[{},[1,2]]}],"m":[{"o":[{},[0,0,1,2]]}],"n":[{"a":[{},[0,2,1]],"á":[{},[1,2]],"n":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"p":[{"a":[{".":[{},[0,0,1]]},[0,0,0,2,0,2]],"á":[{},[0,2,1]],"ó":[{},[0,2,1,2]],"p":[{"o":[{},[0,0,1]]}]},[2]],"r":[{"a":[{"b":[{},[0,0,1,2]]}],"á":[{},[0,0,1,2]],"c":[{},[0,2]]}],"s":[{"z":[{"e":[{},[0,0,0,2,0,1,2]],"é":[{"n":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"í":[{},[0,0,0,2,0,1,2]],"ó":[{},[0,0,0,2]],"ü":[{},[0,0,0,2]]}]}],"t":[{"e":[{},[0,0,0,2,1]],"ö":[{},[0,0,0,2]]}],"v":[{"a":[{},[0,2,1,2]]},[2]],"z":[{},[0,2,1]]}],"á":[{"g":[{},[0,2,1]],"l":[{"m":[{"i":[{},[0,2,1]]}],"o":[{"m":[{},[0,2,1,2]]}]}],"p":[{},[0,2,1,2]],"s":[{"a":[{"t":[{},[0,2]]}]}],"t":[{"a":[{},[0,2,1]],"k":[{},[0,2,1]],"r":[{},[0,2,1]]},[2]]}],"b":[{"r":[{},[0,0,1]]}],"c":[{"a":[{"u":[{},[0,0,0,0,3]]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{".":[{},[0,0,2]]},[0,0,0,0,2]],"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"h":[{"i":[{"t":[{},[0,0,2,3]]}],"o":[{},[0,0,2]]}],"i":[{"a":[{"l":[{},[0,0,0,0,2]]}]}],"ó":[{},[0,0,2,1,2]],"s":[{"a":[{"j":[{},[0,0,2]],"r":[{},[0,0,2]]}],"e":[{"l":[{"l":[{},[0,0,0,0,1]]}],"m":[{"b":[{},[0,0,0,0,1]]}],"n":[{},[0,0,2,0,1]],"p":[{},[0,0,0,0,1,2]],"t":[{},[0,0,0,0,1]]}],"é":[{"r":[{"é":[{},[0,0,2]]}]}],"i":[{"l":[{"l":[{},[0,0,2,0,1]]}],"z":[{},[0,0,2]]}],"í":[{"z":[{},[0,0,2,0,1,2]]}],"o":[{"r":[{},[0,0,2,0,1]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,0,0,0,2]],"t":[{},[0,0,0,0,1]],"u":[{"t":[{},[0,0,2]]}],"ü":[{},[0,0,2,0,1]]}]}],"d":[{"a":[{"l":[{"k":[{},[0,0,2,1]]}],"s":[{},[0,0,0,0,1]],"t":[{"l":[{},[0,0,0,1]]}]}],"e":[{"l":[{"e":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1]],"ő":[{},[0,0,2,1]],"s":[{},[0,0,0,1]]}],"r":[{"d":[{},[0,0,2]]}],"s":[{},[0,0,2,1]],"z":[{},[1]]}],"é":[{"l":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2]]}],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2,1,2]],"ú":[{"s":[{},[0,0,2]]}],"ü":[{"n":[{},[0,0,2]]}],"ű":[{},[0,0,2]],"y":[{},[0,0,1]],"z":[{"á":[{},[0,0,2]]}]}],"e":[{"b":[{},[0,2,1]],"d":[{"d":[{},[0,0,1]]}],"g":[{"é":[{},[0,0,1,2]]}],"k":[{"d":[{},[1,2]]}],"l":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2,1,2]],"m":[{"b":[{},[0,0,0,2,1]]}]}],"é":[{"l":[{},[0,0,0,2]]}],"ő":[{},[0,0,0,2]]}],"m":[{"u":[{},[0,0,1]]},[2]],"r":[{"e":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"u":[{},[2]],"v":[{},[2]],"x":[{},[0,2,1]],"z":[{".":[{},[0,0,1]],"e":[{},[0,2,1]],"é":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]},[0,0,0,2]]}],"é":[{"k":[{"é":[{},[0,2,1,2]]}],"l":[{"e":[{},[0,2,1]]}],"p":[{"í":[{},[0,0,1]]}],"r":[{"i":[{},[0,2,1]],"v":[{},[0,2,1]]}],"t":[{"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"v":[{"c":[{},[0,2,1]],"e":[{"m":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]}],"é":[{"b":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"t":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"h":[{"a":[{},[0,0,1]]}],"i":[{"g":[{},[0,0,0,2]]}],"k":[{"e":[{},[0,0,1]],"ö":[{},[0,0,1]]}],"ü":[{},[0,2,1]],"z":[{},[0,2]]}]}],"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,2,1,2]]}]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"a":[{"d":[{"a":[{},[0,0,2,1]],"o":[{},[0,0,2,1]]},[0,0,0,0,2]],"l":[{"a":[{},[0,0,2,1]]}],"r":[{"a":[{},[0,0,2,1,2]]}],"s":[{"s":[{},[0,0,2,1]]}],"z":[{"o":[{},[0,0,0,1]]}]}],"á":[{"c":[{},[0,0,2,1]],"l":[{"l":[{},[0,0,2,1]]}],"r":[{"a":[{"d":[{},[0,0,0,0,0,1,2]]}]}],"t":[{"a":[{},[0,0,0,1]],"j":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"e":[{"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"l":[{"f":[{},[0,0,2,1]],"h":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]],"t":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"m":[{"b":[{},[0,0,0,1]]},[0,0,2]],"n":[{"g":[{},[0,0,0,1]]}],"r":[{},[0,0,2,1,2]],"s":[{"e":[{},[0,0,0,1]]}]}],"é":[{"l":[{"e":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]}],"n":[{"e":[{},[0,0,2,1,2]]}],"r":[{".":[{},[0,0,2,1]],"ő":[{},[0,0,0,1]]}],"s":[{},[0,0,2,1]]}],"i":[{"m":[{},[0,0,2]],"z":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{"i":[{},[0,0,2,1]]}]}],"ö":[{"l":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"ő":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,0,1]]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]],"y":[{"e":[{"l":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]],"é":[{"k":[{},[0,0,2]]}]}]}],"i":[{"d":[{"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,2,1,2]]}],"n":[{"d":[{},[0,0,1]],"f":[{},[0,2,1]]}],"o":[{"n":[{},[0,0,1,2]]}],"p":[{"a":[{},[0,2,1,2]]},[2]],"r":[{"á":[{},[0,0,1,2]],"o":[{},[0,2,1]]}],"s":[{"i":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]]}],"t":[{"a":[{},[0,2]],"t":[{},[0,0,1]]}]}],"í":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"v":[{},[2]],"z":[{},[0,2,1]]}],"k":[{"a":[{"b":[{"l":[{},[0,0,0,1]]}],"j":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1,2]],"r":[{"c":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}],"t":[{"l":[{},[0,0,2,1]]}],"u":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"g":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1,2]],"r":[{"e":[{"i":[{"t":[{},[0,0,2,1,2]]}]}],"j":[{},[0,0,2,1]]}],"s":[{},[0,0,2,1]]}],"é":[{"r":[{"d":[{"e":[{},[0,0,0,1]]}],"e":[{"m":[{},[0,0,0,1]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2,1]]}]}]}],"i":[{"d":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1,2]]}],"l":[{"u":[{},[0,0,1]]}],"o":[{"l":[{"d":[{},[0,0,2,1]]}],"s":[{"z":[{"t":[{},[0,0,0,1]]}]}]}],"ö":[{"r":[{"ö":[{"m":[{"b":[{},[0,0,2,1,2]]}]}]}],"s":[{},[0,0,2]],"v":[{},[0,0,2,1,2]]}],"ő":[{"r":[{},[0,0,2]]}],"t":[{},[0,0,0,1,2]],"ü":[{},[0,0,2,1]]}],"n":[{"e":[{".":[{},[0,0,2]]}],"y":[{".":[{},[0,0,3]],"e":[{},[0,0,3]],"o":[{},[0,0,3]]}]}],"o":[{"j":[{},[0,2,1]],"k":[{"t":[{"a":[{},[0,2,1]]}]}],"l":[{"d":[{},[0,2,1]]}],"m":[{"á":[{},[1,2]]}],"r":[{"o":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,2,1]]},[2]],"s":[{},[2]],"t":[{"t":[{},[0,2,1]]}]}],"ó":[{"d":[{"d":[{},[0,2]],"o":[{},[0,2]]}],"g":[{},[0,0,0,1,2]],"n":[{"i":[{},[0,2,1]],"o":[{},[0,2,1]]}],"r":[{"á":[{},[0,2,1,2]],"i":[{},[0,0,1]]}]}],"ö":[{"l":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"e":[{"l":[{},[0,0,2,1,2]]}],"k":[{"a":[{},[0,0,1]]}],"ö":[{},[0,0,2]],"p":[{},[0,0,1,2]],"s":[{"z":[{"e":[{},[0,0,0,3]]}]}],"t":[{"a":[{},[0,0,1]]}],"z":[{"a":[{"l":[{},[0,0,2]]}],"á":[{"b":[{"ó":[{},[0,0,2,0,1,2]]}],"h":[{},[0,0,2,0,1,2]],"r":[{},[0,0,2]]}],"e":[{"s":[{},[0,0,0,0,1]]}],"é":[{"l":[{},[0,0,2]],"n":[{},[0,0,2,0,1]],"p":[{},[0,0,2,0,1,2]]}],"i":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"t":[{},[0,0,0,0,1,2]],"ü":[{"l":[{},[0,0,0,0,1,2]]}]}]}],"t":[{"a":[{"b":[{"l":[{},[0,0,2,1]]}],"g":[{"a":[{},[0,0,0,1]]}]}],"e":[{"g":[{},[0,0,2,1]],"n":[{},[1]],"s":[{"e":[{},[0,0,2,1,2]],"z":[{},[0,0,0,1]]}]}],"i":[{"l":[{"l":[{"á":[{"t":[{},[0,0,0,0,1]]}]}]}],"n":[{"g":[{},[0,0,2,1]]}]}],"r":[{"e":[{},[0,0,1,2]]}]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[2]],"r":[{},[0,2,1,2]],"s":[{"z":[{"i":[{},[0,0,0,2]]}]}],"t":[{},[0,2,1,2]]}],"ú":[{"g":[{},[0,2,1]]}],"ü":[{"g":[{},[0,0,1,2]],"l":[{"ő":[{},[0,2,1]]},[0,0,0,2]],"z":[{},[0,0,1,2]]}],"ű":[{"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"y":[{"a":[{"d":[{"ó":[{},[0,0,0,1,2]]}],"g":[{"á":[{"r":[{".":[{},[0,0,0,0,0,1]],"r":[{},[0,0,0,0,0,1]]}]}],"b":[{},[1]],"é":[{},[1,2]],"g":[{},[0,0,0,0,0,1]],"h":[{},[1]],"k":[{},[1]],"m":[{},[1]],"r":[{},[1]],"t":[{},[1]],"ú":[{},[1]]}],"k":[{"a":[{"d":[{},[0,2]],"s":[{},[0,2,0,1,2]]}]}],"l":[{"k":[{},[0,2,0,1]],"l":[{},[0,2,0,1]]}],"s":[{"s":[{},[0,2,0,1]],"z":[{"t":[{},[0,0,0,1]]}]}],"t":[{"o":[{"m":[{},[0,2,0,1,2]]}]}],"z":[{},[0,2]]}],"á":[{"d":[{"t":[{},[1]]}],"é":[{"k":[{},[1]]}],"l":[{"o":[{},[0,0,0,1]]}],"r":[{"á":[{},[0,2,0,1]],"b":[{},[0,2,0,1]],"f":[{},[0,2,0,1]],"k":[{},[0,0,0,1]],"n":[{},[0,2,0,1]],"o":[{},[0,2,0,1,2]],"r":[{},[0,2,0,1]]}],"s":[{"z":[{},[0,0,0,1,2]]}]}],"d":[{},[0,0,0,1]],"e":[{"c":[{},[0,2,0,1,2]],"d":[{},[0,2,0,1]],"g":[{"é":[{},[0,0,0,1]],"y":[{},[0,0,0,1]]},[0,2]],"k":[{},[0,2,0,1,2]],"l":[{"a":[{},[0,2]],"e":[{"m":[{"e":[{},[0,0,0,0,2]]}],"v":[{},[0,0,0,1]]}],"l":[{},[0,2,0,1]],"o":[{},[0,2,0,1]]}],"m":[{},[0,2,0,1]],"n":[{},[0,2,0,1]],"r":[{"e":[{".":[{},[0,0,0,1,2]],"i":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]]}],"é":[{"n":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"ő":[{"m":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]]}]}]},[2]],"é":[{"g":[{},[0,2,0,1]],"h":[{"e":[{},[0,2]]}],"j":[{},[0,2,0,1,2]],"k":[{},[0,2,0,1]],"l":[{"v":[{},[0,0,0,1]]}],"r":[{".":[{},[0,2,0,1]],"b":[{},[0,2,0,1]],"c":[{},[0,2,0,1]],"d":[{},[0,2,0,1]],"e":[{},[0,2,0,1]],"g":[{},[0,2,0,1]],"h":[{},[0,2,0,1]],"i":[{},[0,2,0,1,2]],"k":[{},[0,2,0,1]],"m":[{},[0,2,0,1]],"n":[{},[0,2,0,1]],"ő":[{},[0,2]],"p":[{},[0,2,0,1]],"r":[{},[0,2,0,1]],"s":[{},[0,2,0,1]],"t":[{"e":[{},[0,2,0,1]],"é":[{},[0,2]],"ő":[{},[0,2,0,1]]}],"v":[{},[0,2,0,1]]}],"v":[{"e":[{},[0,2]],"é":[{},[0,2]]}]}],"h":[{"a":[{"j":[{"ó":[{"n":[{},[0,0,0,0,0,2,1]],"r":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"i":[{"g":[{"a":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}],"n":[{"g":[{},[0,0,0,1]]}],"o":[{},[0,2,0,1]]},[2]],"í":[{},[2]],"o":[{"l":[{"d":[{},[0,0,0,1]]}],"r":[{},[0,2,0,1,2]]},[2]],"ó":[{"r":[{"á":[{},[0,0,0,1]]}]}],"ö":[{"k":[{},[0,0,0,1]],"r":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1]]}],"ő":[{},[0,2,0,1,2]],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"r":[{},[0,2]]}],"ú":[{},[2]],"ü":[{"l":[{},[0,0,0,1]]},[2]]}]}],"o":[{"á":[{"z":[{},[0,0,2]]}],"b":[{"e":[{},[0,0,2]]}],"c":[{"s":[{},[0,0,2]]}],"d":[{"a":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"l":[{"a":[{"j":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}]}]},[0,0,2]]}],"m":[{"o":[{},[0,0,2]]}],"p":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]]}],"s":[{"o":[{},[0,0,2]]}],"u":[{"t":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]]}],"x":[{"i":[{},[0,0,2]]}]},[0,1]],"ó":[{"á":[{"r":[{},[0,0,0,2]]}],"b":[{"a":[{"r":[{},[0,2]]}],"á":[{},[0,2]],"i":[{},[0,2]],"o":[{},[0,2]]}],"c":[{"e":[{},[0,0,2]]}],"d":[{"á":[{},[0,0,2]],"i":[{},[0,2]]}],"f":[{"á":[{},[0,2]],"e":[{},[0,2]],"o":[{},[0,2]],"ő":[{},[0,2]],"ü":[{},[0,2]]}],"h":[{"é":[{},[0,2]],"i":[{},[0,2]],"ü":[{},[0,2]]}],"i":[{"l":[{},[0,2]],"s":[{},[0,2]],"v":[{},[0,2,0,2]]}],"k":[{"á":[{},[0,2]],"e":[{},[0,2]],"r":[{"é":[{},[0,0,1]]}],"u":[{},[0,2]]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}],"m":[{"a":[{"g":[{},[0,2]],"r":[{},[0,2]],"s":[{},[0,2]]}],"e":[{},[0,2]],"i":[{},[0,2]],"o":[{},[0,2]]}],"n":[{"é":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]]}],"r":[{"á":[{},[0,0,2]],"é":[{},[0,2]],"i":[{},[0,0,2]]}],"s":[{"í":[{},[0,2]],"ű":[{},[0,2]]}],"t":[{"a":[{},[0,2]],"e":[{},[0,2]],"é":[{},[0,2]]}],"v":[{"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]},[0,1]],"ö":[{"b":[{"ö":[{},[0,0,2]]}],"c":[{"s":[{},[0,0,2]]}],"d":[{"é":[{},[0,0,2]]}],"k":[{"o":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"n":[{"á":[{},[0,0,2]]}],"r":[{"ö":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"ö":[{},[0,0,2]]}]},[0,1]],"ő":[{"r":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]],"z":[{},[0,0,2]]}]},[0,1]],"p":[{"a":[{"c":[{"s":[{"a":[{"v":[{},[0,0,0,2,0,1,2]]}],"i":[{},[0,0,0,2,0,1]]}]}],"d":[{"a":[{},[0,2,1,2]]}],"g":[{"a":[{},[0,2,1]]}],"j":[{"á":[{},[0,2,1]]}],"k":[{"c":[{},[0,2,1]]}],"l":[{"a":[{"g":[{},[0,0,0,2]],"k":[{},[0,0,0,2]]}],"b":[{},[0,2,1]],"j":[{},[0,2,1]],"t":[{},[0,2,1]]},[2]],"m":[{"a":[{"s":[{},[0,0,0,2]]}]}],"n":[{"t":[{},[0,2,1]]}],"p":[{"á":[{"n":[{},[0,0,0,2]]}]},[2]],"r":[{"á":[{"n":[{},[0,0,1,2]]}]}],"s":[{"á":[{},[1]],"p":[{},[0,2,1]]}],"t":[{"a":[{"d":[{},[0,0,0,2]],"l":[{"a":[{},[0,0,0,2,1]]}],"n":[{},[0,0,0,0,0,2]],"s":[{},[0,0,0,2,1]]}],"á":[{"l":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2,1]]}],"u":[{"t":[{},[0,0,1]]}],"v":[{"a":[{},[0,2]]},[2]],"z":[{"o":[{},[0,0,1,2]]}]}],"á":[{"j":[{"ú":[{},[0,2]]}],"l":[{"l":[{"a":[{"p":[{},[0,0,1]]}],"á":[{},[0,2,1]],"o":[{},[0,2,1]]}]}],"n":[{"n":[{},[0,0,0,0,1]]}],"r":[{"a":[{"d":[{},[0,2,1,2]],"i":[{},[0,0,1,2]],"k":[{},[0,2,1,2]],"m":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"á":[{"é":[{},[0,0,0,2]],"h":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"b":[{"a":[{},[0,0,0,0,0,0,2]]}],"e":[{},[0,2,1]],"é":[{},[0,2,1,2]],"f":[{},[0,2,1]],"k":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"y":[{},[0,2,1]]}],"t":[{"ó":[{},[0,0,1]]}],"u":[{},[0,2,1]],"ú":[{},[0,2,1,2]]}],"s":[{"k":[{"á":[{},[0,0,0,0,0,0,2]]}]}],"t":[{"ú":[{"r":[{},[0,0,0,2]]}]}],"u":[{},[1,2]]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{".":[{},[0,2]],"d":[{"é":[{},[0,0,1,2]]}],"g":[{},[0,2,1,2]],"l":[{"a":[{},[0,0,1,2,1]],"b":[{},[0,0,1]],"é":[{},[0,0,1,2]],"f":[{},[0,2,1]],"g":[{},[0,0,1]],"h":[{},[0,2,1]],"j":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,2]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"r":[{},[0,0,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"m":[{"b":[{},[0,0,1]],"e":[{},[0,0,1]]},[0,0,0,2]],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"r":[{"ő":[{},[0,0,1,2]]}],"s":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]],"ő":[{},[0,0,1]]},[0,0,0,2]],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"é":[{"h":[{"e":[{},[0,2,1,2]]}],"j":[{"e":[{},[0,2,1]]}],"l":[{"e":[{},[0,2,1,2]],"l":[{},[0,2,1]],"m":[{},[0,0,1]]}],"n":[{"e":[{},[0,2,1,2]]}],"p":[{"ü":[{},[0,0,1]]}],"r":[{".":[{},[0,2,1]]}],"s":[{"z":[{"l":[{},[0,0,1]]}]}],"t":[{"e":[{},[0,2,1]]}],"v":[{"e":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,2,1]],"é":[{},[0,2]]}],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"k":[{"o":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"n":[{"á":[{"r":[{},[0,2,1,2]]}],"d":[{},[0,0,1]],"j":[{},[0,0,1]],"s":[{},[0,2,1]]}],"r":[{"a":[{"t":[{},[0,0,1,2]]}],"á":[{},[0,2,1,2]],"k":[{},[0,2,1]]}],"s":[{"m":[{},[0,2,1]]}]}],"í":[{"g":[{},[0,2,1]],"n":[{},[0,2,1]],"t":[{"é":[{},[0,2]]}],"v":[{},[0,0,1]],"z":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"l":[{"a":[{"z":[{},[0,0,2]]}],"é":[{"d":[{},[0,0,2]]}]}],"m":[{"e":[{"g":[{},[0,0,0,0,0,1]]}],"ű":[{"t":[{},[0,0,0,0,0,2]]},[0,0,0,0,1]]}],"o":[{"b":[{},[0,2,1]],"l":[{"a":[{"j":[{},[0,0,1,2]]}],"t":[{"á":[{"r":[{},[0,0,1]]}]}]}],"p":[{"c":[{},[0,0,1]],"e":[{},[0,0,1]],"t":[{},[0,0,1]]}],"r":[{"a":[{"d":[{},[0,0,0,2]]}],"c":[{"á":[{},[0,0,1]]}],"s":[{"ó":[{},[0,0,1]]}],"t":[{"ő":[{},[0,0,0,0,2,1,2]]}]}],"t":[{"á":[{"l":[{},[0,0,0,2,1]]}]}],"v":[{},[0,2,1]]}],"ó":[{"k":[{"á":[{},[1,2]]}],"l":[{"o":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]]}]}],"ö":[{"b":[{},[0,2,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{"v":[{},[0,0,1]]}],"s":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"a":[{"r":[{"á":[{},[1]]}]}],"á":[{"r":[{"n":[{},[0,0,2,1]]}]}],"h":[{},[0,0,1]],"i":[{"n":[{"g":[{},[0,0,0,1]]}]}],"l":[{"a":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,1]],"ó":[{},[0,0,1]]}],"s":[{},[0,0,1,2]],"y":[{},[0,0,1]]}],"r":[{"e":[{"s":[{},[0,0,2]]}],"é":[{"d":[{},[0,0,2]],"m":[{},[0,1,2]],"s":[{".":[{},[0,0,2]]}]}],"í":[{"m":[{},[0,1,2]]}],"o":[{"c":[{},[0,0,2]],"d":[{},[0,1,2]]},[2]],"ó":[{"d":[{},[1]],"z":[{"ó":[{},[1]]}]}]}],"s":[{"i":[{"k":[{"o":[{"n":[{},[0,0,2,1,2]]}]}]}],"í":[{"z":[{},[0,0,2]]}],"o":[{"r":[{"k":[{},[0,0,0,1]]}]}],"z":[{"e":[{"r":[{"t":[{},[0,0,0,0,1]]}]}],"f":[{},[0,0,1]],"t":[{},[0,0,0,0,2]]}]}],"t":[{"á":[{"r":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}]}]}],"r":[{},[0,0,1,2]]}],"u":[{"á":[{},[0,0,0,0,2]],"d":[{"v":[{},[0,2,1]]}],"p":[{},[0,0,0,1,2]],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"a":[{"s":[{},[0,2,1,2]]}],"á":[{"n":[{},[0,2,1]]}],"c":[{},[0,2]]}]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{},[0,2,1,2]],"n":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"r":[{},[0,0,1]]}],"w":[{"h":[{},[0,0,1]]}]}],"r":[{"a":[{"b":[{"á":[{"r":[{},[0,0,0,2,1]]}],"í":[{},[0,0,0,2,1,2]],"l":[{"a":[{},[0,0,1]]}]}],"d":[{"a":[{"t":[{"a":[{},[0,0,1,2]],"o":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}]}]},[2]],"g":[{"e":[{},[0,0,0,2,1]]},[2]],"j":[{"k":[{"á":[{"r":[{"ó":[{},[0,0,1]]}]}]}]},[2]],"k":[{"o":[{"l":[{},[0,2,1,2]]}],"ó":[{"h":[{},[0,0,0,2]],"i":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"t":[{".":[{},[0,2,1]]}]},[2]],"l":[{"k":[{},[0,0,1]],"m":[{},[0,2,1]]}],"n":[{"a":[{},[0,2,1]],"n":[{},[1,2]],"y":[{"a":[{"g":[{"á":[{},[0,0,0,0,0,1,2]]}],"l":[{},[0,0,0,2]]}],"b":[{},[1]],"h":[{},[1]],"í":[{},[0,0,0,2]],"k":[{},[1]],"n":[{},[1]],"r":[{},[1]],"s":[{},[1]]}]}],"p":[{"a":[{".":[{},[0,0,0,2]]}]}],"r":[{"c":[{},[0,0,1]]}],"s":[{"z":[{".":[{},[1]],"t":[{"e":[{},[0,0,0,0,0,2,1]]}],"ú":[{},[0,0,1]]}]}],"t":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"ő":[{},[0,0,0,2,1,2]],"ű":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"u":[{"l":[{},[0,0,1]]}],"v":[{"a":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"w":[{},[1,2]],"z":[{"o":[{"n":[{},[0,0,0,2]]}]}]}],"á":[{"c":[{".":[{},[0,2,1]],"s":[{"i":[{},[0,2,1,2]],"o":[{"m":[{},[0,2]]}]}]},[2]],"g":[{".":[{},[0,2,1]],"a":[{".":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"n":[{},[0,2]],"t":[{},[0,2,1,2]]}],"á":[{"b":[{},[0,0,0,2]],"h":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"b":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"o":[{"n":[{},[0,0,0,2]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{"k":[{},[0,2,1,2]],"n":[{},[0,2,1,2]]}],"ú":[{},[0,2,1,2]],"y":[{},[0,2,1,2]]}],"l":[{"c":[{},[0,0,1]],"l":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]]}]}],"m":[{"e":[{},[0,0,0,2,1,2]]},[2]],"n":[{"y":[{"e":[{},[0,0,0,2]]}]}],"r":[{"a":[{"k":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"k":[{},[0,2,1]],"r":[{},[0,2,1]],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1]],"v":[{},[0,0,1]]}],"s":[{"z":[{"e":[{},[0,0,0,2]],"o":[{"k":[{"i":[{},[0,2,1,2]]}]}]}]}],"t":[{"a":[{"l":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2,1]]}],"z":[{"s":[{"á":[{"l":[{},[0,0,0,2]]}],"i":[{},[0,0,0,0,0,0,2]],"z":[{},[0,0,0,0,0,3]]},[0,0,0,0,4]]}]}],"c":[{"a":[{"d":[{},[0,0,2,1,2]],"g":[{"y":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,0,0,1]]}],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2]],"s":[{},[0,0,2,1]],"v":[{},[0,0,2]]}],"é":[{"h":[{},[0,0,2,1,2]],"l":[{".":[{},[0,0,0,1]],"b":[{},[0,0,0,1]],"l":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"h":[{"í":[{},[1]]}],"i":[{"n":[{"g":[{},[0,0,0,1]],"t":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"o":[{"l":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"ó":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"a":[{"l":[{"a":[{},[0,0,0,0,1]]}]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"r":[{"e":[{},[0,0,0,3]]}]}],"i":[{"p":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,3]]}]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"d":[{"a":[{"c":[{"é":[{},[0,0,0,1]]}],"l":[{"j":[{},[0,0,2,1]]}]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}]}],"e":[{"l":[{"e":[{},[0,0,0,1]],"ő":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"m":[{},[0,0,2,1,2]]}],"é":[{"l":[{},[0,0,2,1,2]]}],"i":[{"n":[{"a":[{},[0,0,2,1]],"g":[{},[0,0,2,1]]}]}],"o":[{"r":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"u":[{"r":[{},[0,0,2,1]]}],"ü":[{},[0,0,2]]}],"e":[{"d":[{"z":[{},[0,2,1,2]]}],"g":[{"é":[{"s":[{},[0,0,1]]}],"y":[{},[0,2,1,2]]}],"i":[{"l":[{},[0,0,0,0,0,2]]},[0,0,0,2]],"l":[{"e":[{},[0,2,1,2]],"h":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"ü":[{},[0,0,1]],"ű":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,2,1]],"e":[{"l":[{},[0,0,1]]}],"é":[{"s":[{},[0,0,1,2]]}],"u":[{},[0,2]]}],"r":[{},[0,2,1,2]],"s":[{"e":[{},[0,0,1,2]],"ő":[{},[0,0,1,2]],"z":[{"e":[{"k":[{},[0,2,1]]}],"é":[{},[0,2,1]],"ü":[{},[0,2,1]]}]}],"t":[{"ű":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]]}],"w":[{},[0,2]]}],"é":[{"é":[{},[0,0,0,0,2]],"g":[{".":[{},[0,0,1]],"e":[{},[0,0,1,2]]}],"k":[{"a":[{"l":[{},[0,0,0,2,1,2]]}],"e":[{"k":[{},[0,0,0,2]]}]}],"l":[{".":[{},[0,0,1]],"t":[{},[0,0,1]]}],"m":[{},[2]],"n":[{"e":[{"k":[{},[0,0,0,2]]}]}],"p":[{"ü":[{},[0,2,1]]},[0,0,0,1]],"r":[{"i":[{},[0,2,1,2]],"ő":[{},[0,2,1]]}],"s":[{"z":[{"j":[{},[0,0,1]],"t":[{"á":[{},[0,0,0,1,0,2]]}]}]}],"t":[{"r":[{"a":[{},[0,0,0,1]]}]}]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"h":[{"a":[{},[0,0,1]]}]}],"i":[{".":[{},[2]],"a":[{},[2]],"d":[{"e":[{},[0,0,1,2]],"é":[{},[0,2]]}],"g":[{"a":[{},[0,2,1,2]]}],"m":[{"á":[{"d":[{},[0,2]]}],"i":[{},[0,0,1,2]]}],"n":[{"a":[{".":[{},[0,2,1,2]],"k":[{"é":[{},[0,2,1,2]]}],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"á":[{"b":[{},[0,2,1,2]],"h":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]]}],"g":[{"é":[{},[0,2,1]]}],"i":[{"t":[{},[0,0,0,2]]}],"k":[{},[0,0,0,0,0,2]],"t":[{"é":[{},[0,2,1]]}],"ü":[{},[0,0,0,2]]}],"o":[{"n":[{"o":[{},[0,0,1,2]]}]}],"ó":[{"n":[{},[0,2,1,2]]}],"p":[{},[2]],"s":[{"p":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"z":[{"f":[{},[0,0,0,1]]}]}],"z":[{"o":[{"m":[{},[0,0,0,2]]}]},[2]]}],"í":[{"t":[{"é":[{},[0,0,1,2]]}]}],"j":[{"á":[{"z":[{},[0,0,2,1]]}],"e":[{"r":[{},[0,0,2,1]]}]}],"k":[{"a":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"á":[{"p":[{},[0,0,0,0,2]],"s":[{},[0,0,0,0,2]]}],"e":[{"g":[{},[0,0,2,1]],"l":[{"á":[{},[0,0,0,1]]}]}],"é":[{"j":[{},[0,0,2]],"p":[{"ü":[{},[0,0,2]]}],"r":[{"d":[{},[0,0,2,1]]}]}],"i":[{"n":[{".":[{},[0,0,2,1]]}],"o":[{"n":[{"t":[{},[0,0,2,1,2]]}]}],"z":[{},[0,0,2]]}],"o":[{"r":[{"m":[{},[0,0,2,1]]}],"v":[{"i":[{},[0,0,2,1]]}]}],"u":[{"d":[{},[0,0,2]],"s":[{},[0,0,2,1,2]]}]}],"l":[{"e":[{"s":[{},[0,0,2]]}]}],"m":[{"a":[{"g":[{"y":[{},[0,0,2,1,2]]}],"t":[{"e":[{},[0,0,0,0,2]]}]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}]}],"e":[{".":[{},[0,0,2]],"o":[{},[0,0,2]],"s":[{},[0,0,0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,0,1]]}],"s":[{},[0,0,2,1]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2,1]],"ü":[{},[0,0,2]]}],"n":[{"i":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}]}],"o":[{"k":[{"a":[{"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1,2]],"e":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2]]}]}],"l":[{"d":[{"a":[{},[0,2,1]]}]}],"m":[{"á":[{"t":[{},[1,2]]}],"i":[{"s":[{},[0,0,0,2]]}]}],"p":[{"t":[{},[0,2,1]]}],"r":[{"g":[{},[0,0,1]],"o":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"v":[{"i":[{},[0,2,1]]}]}],"ó":[{"p":[{},[0,0,0,1]],"r":[{"a":[{"k":[{},[0,2,1,2]]}],"á":[{"j":[{},[0,2,1,2]],"m":[{},[0,2,1,2]]}]}],"s":[{"z":[{"á":[{"r":[{},[0,0,0,2,3]]}]}]}],"v":[{"á":[{"r":[{},[0,0,0,2]]}]}],"z":[{"d":[{},[0,0,1]]}]}],"ö":[{"b":[{},[0,2,1,2]],"k":[{},[0,2,1]],"l":[{},[0,2,1,2]],"n":[{"g":[{},[0,0,1]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"y":[{},[0,0,1]]}],"s":[{"k":[{"a":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{},[0,0,1]]}]}],"t":[{".":[{},[2]],"a":[{"b":[{"l":[{},[0,0,0,1]]}],"l":[{"a":[{"p":[{},[0,0,2,1,2]]}]}],"n":[{"á":[{"s":[{},[0,0,0,0,2,1,2]]}]}],"s":[{"z":[{"t":[{},[0,0,0,1]]}]}],"u":[{},[0,0,2,1,2]]}],"á":[{"l":[{"l":[{"a":[{},[0,0,2,1]]}]}]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"ő":[{},[0,0,0,1,2]]}],"m":[{"b":[{},[0,0,0,1]]}],"r":[{"e":[{"i":[{},[0,0,0,1,2]]}]}]}],"é":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"r":[{"p":[{},[0,0,2,1]]}]}],"i":[{"n":[{"a":[{".":[{},[0,0,2,1,2]]}],"á":[{"t":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1,2]]}]}]}],"o":[{"r":[{"z":[{},[0,0,0,1]]}]}],"ö":[{"v":[{},[0,0,2,1,2]]}],"u":[{"t":[{},[0,0,2,1]]}],"v":[{"i":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"y":[{},[0,0,1,0,2]]}],"u":[{"m":[{"l":[{},[0,2,1]]}],"n":[{"i":[{},[0,2]]}],"t":[{"a":[{"s":[{},[0,0,0,2]]}]}]}],"ú":[{"j":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}],"t":[{"j":[{},[0,0,1]],"r":[{},[0,0,1]]}]}],"ü":[{"t":[{},[0,2,1]],"z":[{},[0,0,1]]}],"ű":[{"z":[{},[0,0,1,2]]}],"v":[{"a":[{"l":[{"a":[{},[0,0,2]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"á":[{"g":[{"y":[{},[0,0,0,1]]}],"r":[{"h":[{},[0,0,2,1]],"i":[{},[0,0,2,1,2]]}]}]}]}],"s":[{"a":[{"b":[{"l":[{},[2]],"r":[{},[0,0,1]]}],"d":[{"a":[{"g":[{},[0,2]]}]}],"g":[{"a":[{},[0,0,1]],"g":[{},[0,0,1]],"y":[{},[0,0,1,2]]},[0,0,0,0,2]],"j":[{},[2]],"k":[{"a":[{"r":[{},[0,2,1,2]]}]}],"l":[{"a":[{"b":[{},[0,0,1]],"p":[{},[0,2,1,2]]}],"f":[{},[0,0,1]],"j":[{"á":[{"n":[{},[0,2,1]]}],"i":[{},[0,2,1]]}],"k":[{},[0,2,1]],"m":[{},[0,0,1]]},[2]],"n":[{"ó":[{},[0,2,1]],"t":[{},[0,2,1]],"y":[{},[0,2,1,2]]}],"p":[{"r":[{},[0,0,1]]},[2]],"r":[{"a":[{"n":[{},[0,0,1]]}],"á":[{},[0,2,1,2]]},[2]],"t":[{"ó":[{},[0,0,0,2,1,2]],"y":[{},[0,0,1,2]]}],"v":[{"o":[{},[0,0,0,2]]},[2]]}],"á":[{"c":[{},[0,2,1,2]],"g":[{"i":[{"k":[{"r":[{},[0,0,0,2,1]]}]}]}],"l":[{"l":[{},[0,0,1]]}],"m":[{},[2]],"r":[{"n":[{"a":[{"k":[{},[0,2,1]]}]}],"o":[{},[0,2,1,2]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,2,1,2]]}],"s":[{"s":[{},[0,0,0,0,1]],"v":[{"á":[{},[0,0,1]]}]}],"t":[{"h":[{},[0,0,1]],"o":[{},[2]]}],"v":[{},[2]]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"d":[{},[0,2,1,2]],"g":[{"e":[{},[0,0,1]],"y":[{},[0,2,1,2]]}],"k":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]]},[0,0,0,2]],"l":[{"l":[{},[0,0,1]]}],"m":[{"b":[{},[0,2,1]]}],"n":[{},[0,2,1,2]],"r":[{"d":[{},[0,2]],"é":[{},[0,0,1,2]],"ő":[{},[0,0,1]]}],"s":[{},[0,2,1]],"t":[{"i":[{},[0,0,1]]},[0,0,0,2]],"z":[{},[0,2,1]]}],"é":[{"h":[{"e":[{},[0,2,1]]}],"k":[{"e":[{},[0,2,1]]}],"l":[{},[0,2,1,2]],"m":[{},[2]],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"b":[{},[0,0,1]],"c":[{},[0,0,1]],"d":[{},[0,2,1]]},[2]],"s":[{},[0,0,0,1,2]],"t":[{"v":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,1,2]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]]}],"n":[{"j":[{},[0,0,1]]}],"o":[{},[0,2,1,2]],"v":[{},[2]],"z":[{"é":[{},[0,0,1]],"o":[{},[0,0,1,2]]}]}],"í":[{"j":[{},[0,2,1]],"k":[{},[2]],"n":[{},[2]],"r":[{"t":[{"a":[{"l":[{},[0,0,0,0,2]]},[0,0,0,0,0,0,2]]}]},[2]],"v":[{},[0,2,1,2]],"z":[{"ü":[{},[0,0,1]]}]}],"k":[{"á":[{},[2]],"l":[{},[0,0,1]],"o":[{"s":[{"a":[{"r":[{"á":[{},[0,0,0,0,2,1,2]]}]}],"á":[{},[0,0,0,0,2,1]]}],"z":[{},[0,0,2]]}],"r":[{},[0,0,1,2]]}],"l":[{"u":[{"k":[{},[0,0,2]]}]}],"m":[{"á":[{"r":[{},[0,0,2]]}]}],"o":[{"d":[{"r":[{},[2]]}],"f":[{},[0,2,1]],"k":[{"k":[{"e":[{},[0,0,1]]}],"l":[{},[0,0,1]],"o":[{"s":[{},[0,0,1]]}],"s":[{},[2]],"t":[{"a":[{},[0,0,1]]}]}],"m":[{"o":[{"r":[{},[0,0,0,0,1]]}]}],"n":[{"é":[{},[0,0,0,2]]}],"r":[{"d":[{},[0,2,1]],"m":[{},[0,2,1]]},[2]],"s":[{"z":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"ó":[{"p":[{},[0,0,0,1,2]],"r":[{"á":[{},[0,0,1,2]]}]}],"ö":[{"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"r":[{"d":[{},[0,0,1]],"v":[{},[0,0,1]]}],"s":[{},[0,2,1]],"v":[{"e":[{},[0,0,1,2]]}]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1,2]],"o":[{"t":[{},[0,0,2]]}],"r":[{},[0,0,0,2]],"u":[{},[0,1,2]]}],"s":[{"p":[{},[0,0,1,2]],"z":[{"a":[{"b":[{"á":[{},[0,0,3]]}]}],"i":[{"n":[{},[0,0,3]]}],"í":[{"v":[{"e":[{".":[{},[0,0,0,0,1]],"k":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]],"n":[{"e":[{},[0,0,0,0,1]]}]}]}],"o":[{"c":[{},[1]],"n":[{"y":[{},[1]]}]}],"ü":[{},[0,0,3]],"ű":[{},[0,0,3]]}]}],"t":[{"a":[{"n":[{"d":[{},[0,1]]}]},[2]],"á":[{"d":[{},[0,1,2]]},[2]],"i":[{"l":[{},[0,0,0,0,0,2]],"m":[{},[0,0,2]]},[2]],"í":[{},[2]],"o":[{"p":[{},[0,0,2]]},[2]],"r":[{"a":[{"g":[{},[0,0,1]],"v":[{},[0,0,1]]}],"u":[{},[0,1,0,2]]},[2]],"ú":[{},[2]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[2]],"j":[{},[0,2,1]],"l":[{"y":[{},[2]]}],"r":[{"a":[{},[0,0,1]],"n":[{},[0,0,1]]},[0,0,0,2]],"s":[{"z":[{},[0,2,1,2]]}],"t":[{"a":[{"k":[{},[0,0,1,2]],"s":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"u":[{},[0,0,1,2]]}]}],"ú":[{"s":[{},[0,2,1,2]],"t":[{"a":[{},[0,0,0,0,1,2]]},[0,2,1,2]]}],"ü":[{"d":[{},[0,2,1]],"l":[{"ő":[{},[0,2,1,2]]}],"s":[{"t":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,0,1]]}],"z":[{"a":[{"b":[{},[2]],"d":[{},[0,2,0,1,2]],"k":[{"c":[{},[0,2,0,1]],"e":[{},[0,0,0,0,2,1]],"t":[{},[0,2,0,1]],"ü":[{},[0,0,0,0,2,1]]},[2]],"l":[{"k":[{},[0,2,0,1]],"ó":[{},[1]]}],"s":[{"p":[{},[0,0,0,1]],"s":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,0,0,0,2,1,2]],"e":[{},[0,0,0,0,2,1]],"h":[{},[0,2]],"i":[{},[0,2]]}],"v":[{},[2]]}],"á":[{"g":[{".":[{},[0,2,0,1]],"a":[{},[0,0,0,1,2]],"á":[{},[0,0,0,1,2]],"b":[{},[0,0,0,1]],"g":[{},[0,0,0,1]],"i":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1]],"o":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"l":[{"c":[{},[0,2]],"m":[{},[0,2]]}],"m":[{},[2]],"r":[{"a":[{"d":[{"a":[{},[0,0,0,0,2]]}],"m":[{},[0,2]]}],"n":[{"y":[{"é":[{},[0,0,0,1]]}]}],"p":[{},[0,2]]}],"t":[{"a":[{},[0,2]],"h":[{},[0,2]],"l":[{},[0,0,0,1]],"o":[{},[0,2,0,1,2]],"s":[{},[0,0,0,1]]}]}],"e":[{"d":[{},[2]],"g":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]},[2]],"h":[{},[0,0,0,1]],"k":[{},[2]],"l":[{"e":[{"m":[{},[0,0,0,1,2]]}],"j":[{},[0,0,0,1]]},[2]],"m":[{"c":[{},[2]],"e":[{},[2]],"é":[{},[2]],"p":[{},[2]],"u":[{},[0,2]],"ü":[{},[2]],"ű":[{},[2]]}],"n":[{"g":[{},[0,2,0,1]]},[2]],"p":[{"i":[{},[0,0,0,1,2]]}],"r":[{".":[{},[2]],"e":[{"j":[{},[0,2,0,1]]},[2]],"é":[{},[2]],"k":[{},[2]],"n":[{},[2]],"o":[{},[0,2,0,1]],"ő":[{},[0,2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]]}],"s":[{"e":[{},[0,2,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"z":[{},[2]]}],"é":[{"k":[{"e":[{"l":[{},[0,0,0,0,2,1]]}]},[2]],"l":[{"e":[{"t":[{},[0,0,0,1,2]]}],"é":[{"s":[{},[0,0,0,1]]}]}],"n":[{"é":[{"g":[{},[0,0,0,0,2,1]]}],"n":[{},[0,0,0,0,0,1]]}],"r":[{"e":[{},[0,2,0,1,2]],"é":[{},[0,0,0,1]]}],"t":[{},[2]]}],"f":[{"é":[{"r":[{},[0,0,0,2]]}]}],"i":[{"l":[{"l":[{},[0,2,0,1]]}],"n":[{"f":[{},[0,2,0,1]],"g":[{},[0,0,0,1]]},[2]],"r":[{},[2]],"s":[{"m":[{},[0,2,0,1]],"t":[{},[0,0,0,1]]}],"v":[{},[2]],"z":[{},[0,2,0,1]]}],"í":[{"r":[{},[0,2,0,1]],"v":[{"i":[{},[0,0,0,1,2]]}]},[2]],"k":[{"a":[{"r":[{"c":[{},[0,0,0,2]]}]}],"á":[{"p":[{},[0,0,0,2,1]]}],"e":[{"l":[{"l":[{},[0,0,0,2]]}],"s":[{},[0,0,0,2]]}]}],"o":[{"b":[{},[2]],"c":[{},[2]],"f":[{},[2]],"n":[{"n":[{},[0,0,0,0,0,1]],"o":[{},[0,0,0,0,2,1]]}],"r":[{"r":[{},[0,2,0,1]],"s":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,2,0,1]]}]}],"ó":[{"a":[{},[1]],"d":[{"á":[{},[0,0,0,1,2]]}],"t":[{},[2]]}],"ö":[{"k":[{},[2]],"l":[{"t":[{},[0,0,0,1]]}],"n":[{},[0,2,0,1]],"r":[{},[2]],"s":[{"s":[{},[0,0,0,1]]}],"t":[{},[0,2]],"v":[{},[2]]}],"ő":[{"l":[{"ő":[{"é":[{},[0,0,0,0,0,0,0,2]]}]}]},[2]],"s":[{"u":[{},[0,0,0,3]]}],"t":[{"a":[{"b":[{},[0,0,0,2]],"p":[{"o":[{},[0,0,0,2,1]]}]}],"á":[{"c":[{},[0,0,0,2]],"l":[{"l":[{},[0,0,0,2]]}]}],"e":[{"m":[{"b":[{},[0,0,0,2,1]]}]}],"é":[{"n":[{"e":[{},[0,0,0,2]]}],"s":[{},[0,0,0,2,1]]}],"i":[{"n":[{"g":[{},[0,0,0,2,1]]}]}],"o":[{"l":[{"t":[{},[0,0,0,2,1]]}],"r":[{"o":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2]]}],"s":[{"z":[{},[0,0,0,2,1]]}]}],"ö":[{"v":[{},[0,0,0,2]]}],"ő":[{"s":[{},[0,0,0,2]]}],"ü":[{"l":[{},[0,0,0,2,1]]}],"v":[{"í":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"u":[{"r":[{},[2]]}],"ú":[{"s":[{},[1]],"t":[{"r":[{},[0,0,0,1]]}]}],"ü":[{"g":[{"g":[{},[0,0,0,1]]},[0,0,0,0,2]],"z":[{},[0,2,0,1,2]]},[2]],"ű":[{},[2]],"v":[{"i":[{"t":[{},[0,0,0,2]]}]}],"z":[{},[0,0,0,1]]}]}],"t":[{"a":[{"b":[{"l":[{"a":[{},[0,0,1]]}]},[2]],"c":[{"é":[{},[0,2,1,2]]}],"d":[{"a":[{"t":[{},[0,0,0,2]]}],"ó":[{},[0,0,1,2]]}],"g":[{"y":[{"a":[{},[0,2,1]]}]},[2]],"j":[{"á":[{"n":[{},[0,2]]}]}],"k":[{"a":[{"r":[{"a":[{},[0,2,1]]}]}],"á":[{"r":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"p":[{"e":[{"s":[{},[0,0,0,2,1,2]]}]}]}],"ö":[{"v":[{},[0,0,0,2,1,2]]}],"t":[{"u":[{},[0,2,1]]}]},[2]],"l":[{"a":[{"g":[{},[0,0,1,2]],"p":[{".":[{},[0,0,0,2]],"b":[{},[0,0,0,2]],"j":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"p":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"ú":[{},[0,0,0,2]]}],"t":[{},[0,0,0,2]]}],"e":[{"g":[{},[0,2,1]]}],"i":[{"k":[{},[0,0,0,2]]}],"l":[{"e":[{},[0,2,1]]}],"m":[{"á":[{"s":[{},[0,2,1]]}]}]}],"n":[{"a":[{"l":[{},[0,2,1]]}],"ó":[{},[0,0,0,2]],"y":[{"a":[{"g":[{},[0,0,1,2]]}],"á":[{"s":[{},[0,0,1,2]]}]}]},[2]],"p":[{"p":[{},[0,0,1]],"u":[{"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}]},[2]],"r":[{"a":[{"b":[{},[0,2,1,2]],"n":[{},[0,0,0,2]]}],"é":[{"n":[{},[0,2,1,2]]}]},[2]],"s":[{"t":[{},[0,0,0,1]]}],"u":[{"r":[{},[0,0,0,0,2]],"t":[{},[0,2,1,2]]}],"z":[{"o":[{},[0,2,1]]}]}],"á":[{"b":[{"r":[{},[0,0,1]]},[2]],"g":[{".":[{},[0,0,1]],"a":[{},[0,2,1,2]],"r":[{},[0,0,1]]},[2]],"j":[{},[2]],"l":[{"l":[{"á":[{},[0,2,1]],"ó":[{},[0,2,1]]}],"m":[{},[0,2,1]]},[2]],"m":[{},[2]],"n":[{"a":[{"l":[{},[0,0,0,2]]}]}],"p":[{"o":[{"l":[{},[0,2,1,2]]}]}],"r":[{"a":[{"d":[{"a":[{},[0,0,0,2]],"o":[{},[0,0,0,2]]}],"m":[{"h":[{},[0,0,0,2]],"k":[{},[0,2]],"n":[{},[0,0,0,2]]}],"z":[{},[0,0,0,2,1]]}],"é":[{"t":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]}],"k":[{"á":[{"r":[{},[0,0,1]]}]}],"s":[{"á":[{"g":[{"á":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}]}],"t":[{"á":[{"s":[{},[0,0,1]]}]}]},[2]],"s":[{"á":[{"g":[{},[0,0,0,2,1,2]]}],"z":[{},[0,0,0,2]]},[2]],"t":[{"a":[{"l":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"b":[{},[0,2,1]],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,2,1]],"v":[{},[0,2,1]]}],"v":[{},[2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{"é":[{},[0,0,1,2]]}],"j":[{"e":[{"l":[{},[0,0,0,2]]}]}],"k":[{"é":[{"r":[{"e":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"ó":[{},[0,0,0,2]]}],"l":[{"a":[{},[0,2,1,2,1]],"b":[{},[0,2,1]],"c":[{},[0,0,1]],"d":[{},[0,2,1]],"e":[{"d":[{},[0,0,1,2]],"g":[{},[0,0,1]],"m":[{},[0,0,1,2]],"n":[{},[0,0,1,2,1]]}],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"j":[{"á":[{},[0,0,1]]}],"k":[{"ö":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{},[0,0,1]],"o":[{},[0,2,1,2]],"ő":[{"n":[{},[0,0,1,2]],"t":[{},[0,0,0,2]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"é":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"u":[{},[0,2,1]],"ű":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"m":[{"b":[{},[0,2,1]],"e":[{"l":[{},[0,0,1,2]]}],"é":[{},[0,2,1]],"l":[{},[0,2,1]],"ó":[{},[0,2,1]]}],"n":[{"c":[{},[0,2,1]],"e":[{},[0,2,1]]}],"p":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"r":[{"d":[{},[0,2,1]],"e":[{"c":[{},[0,0,1,2]]}],"é":[{"k":[{},[0,0,0,2,1]]}],"ő":[{},[0,2,1]]}],"s":[{"e":[{},[0,2,1,2]],"é":[{},[0,2,1]],"k":[{},[0,2]],"t":[{"á":[{},[0,0,0,0,2,1]],"ő":[{},[0,0,0,0,2]]}],"z":[{"m":[{},[0,0,1]],"ű":[{},[0,0,1]]}]}],"t":[{"o":[{"l":[{},[0,0,0,2]]}]}],"z":[{},[0,2,1,2]]}],"é":[{"g":[{"e":[{"t":[{},[0,0,0,2]]}]},[2]],"h":[{"e":[{},[0,2,1]]}],"k":[{"a":[{"l":[{},[0,0,0,2,1,2]]}],"e":[{".":[{},[0,2,1]],"l":[{},[0,0,0,0,1]]},[0,0,0,2,0,2]]}],"l":[{"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"m":[{},[0,2,1]],"v":[{},[0,2,1]]},[2]],"m":[{},[2]],"n":[{"e":[{},[0,0,0,2]]}],"p":[{"s":[{},[0,2,1]]}],"r":[{"á":[{},[0,0,0,2]],"d":[{"e":[{"k":[{},[0,2,1]]}]}],"i":[{"n":[{},[0,2,1]]}],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{"e":[{"l":[{},[0,2,1]]}]}],"v":[{"e":[{"k":[{},[0,0,1]]}]}],"z":[{},[0,2,1]]},[2]],"s":[{"z":[{"a":[{},[0,0,1]],"l":[{},[0,0,1]]}]}],"t":[{"é":[{"t":[{},[0,0,0,2]]}],"v":[{},[0,2,1]]},[2]]}],"f":[{"j":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"h":[{"u":[{"s":[{},[0,1,2]]}]}],"i":[{".":[{},[2]],"a":[{"t":[{},[0,2,1]]}],"d":[{"e":[{},[0,2,1,2]],"o":[{},[0,2,1]]}],"g":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{"e":[{},[0,0,1]]},[0,2]]}],"m":[{"á":[{"d":[{"á":[{},[0,0,2,3]]}]},[0,0,1,2]],"i":[{},[0,0,1,2]],"p":[{},[0,2,1]]}],"n":[{"g":[{".":[{},[0,2,1]],"a":[{},[0,2,1]],"b":[{},[0,2,1]],"e":[{},[0,2,1]]}],"ó":[{"r":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"t":[{"é":[{},[0,0,1]],"o":[{},[0,0,1]]}]},[2]],"p":[{"a":[{},[0,2,1,2]]},[2]],"r":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]]},[2]],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]],"z":[{"o":[{},[0,2,1]]},[0,0,0,2]]},[2]],"t":[{"a":[{},[0,2,1,2]]},[2]],"z":[{"é":[{},[0,2,1]],"g":[{},[0,2,1]],"m":[{"o":[{},[0,2]]}],"o":[{},[0,2,1,2]]}]}],"í":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"p":[{},[2]],"r":[{},[2]],"t":[{},[0,2,1,2]],"v":[{"e":[{"k":[{},[0,0,1,2]],"l":[{},[0,0,0,0,1,2]],"t":[{},[0,0,1,2]]}],"é":[{"t":[{},[0,0,0,2]]}]}],"z":[{},[0,2,1]]}],"k":[{"i":[{},[2]],"l":[{},[2,0,1]],"o":[{},[2]],"ö":[{},[2]],"u":[{},[2]],"v":[{},[0,0,1]]}],"o":[{"j":[{"t":[{},[0,0,1]]}],"k":[{"a":[{"l":[{},[0,2,1,2,1]]},[0,0,0,0,0,2]],"o":[{"s":[{"s":[{},[0,0,0,2]]}],"z":[{},[0,2,1,2]]}],"t":[{"a":[{},[0,2,1]]}],"u":[{},[0,2,1,2]]}],"l":[{"d":[{"á":[{},[0,0,1]],"ó":[{},[0,2,1]]}]}],"m":[{"á":[{},[0,0,0,2,1]],"b":[{"e":[{},[1]]}],"e":[{"r":[{},[0,0,0,2]]}],"j":[{},[1,2]],"l":[{},[0,2]],"o":[{"k":[{},[1,2]],"s":[{},[1,2]]}],"s":[{},[1,2]],"ú":[{},[1]]}],"p":[{"c":[{},[0,0,1]],"e":[{},[0,0,1]],"t":[{},[0,2,1]]}],"r":[{"á":[{"l":[{},[0,0,0,2]]}],"d":[{},[0,2,1]],"g":[{},[0,2,1]],"ú":[{},[0,0,0,2]],"v":[{},[0,2,1]],"z":[{"á":[{},[0,2,1]]}]},[2]],"s":[{"s":[{},[0,0,0,0,3]],"z":[{"f":[{},[0,0,0,1,0,2]],"l":[{},[0,2,1]]}]}]}],"ó":[{"p":[{},[0,0,0,1,2]],"r":[{"á":[{"k":[{},[0,2,1,2]],"n":[{},[0,0,0,2]]}],"i":[{"á":[{},[0,0,0,2]]}]}],"s":[{"t":[{"á":[{},[0,0,0,1]]}],"z":[{"á":[{"r":[{},[0,0,0,2,3]]}],"e":[{"n":[{"é":[{},[0,0,0,2,3]]}]}]},[0,0,0,1]]}],"t":[{"r":[{},[0,0,0,1]]}]}],"ö":[{"k":[{"o":[{},[0,0,1]]}],"l":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]},[0,0,0,2]],"n":[{"á":[{},[0,0,1]],"k":[{"a":[{},[0,0,0,0,2,1]]}]}],"r":[{"ö":[{"m":[{},[0,0,1,2]]}]}],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{"i":[{".":[{},[0,0,0,2]]}]}],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{"a":[{},[0,0,0,2]],"l":[{},[0,0,1]]}],"s":[{},[0,2,1,2]]}],"p":[{"e":[{"n":[{},[0,0,0,0,0,1]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"a":[{"c":[{"c":[{},[0,0,0,0,0,1]]}],"d":[{},[0,1,2]],"j":[{},[2]],"k":[{},[2]],"m":[{"b":[{},[0,0,2]]}],"p":[{},[0,1]],"u":[{},[0,1]],"v":[{},[0,1,2]]}],"é":[{"f":[{},[0,1,2]],"n":[{},[0,0,2]],"s":[{"z":[{"e":[{"l":[{},[0,0,0,0,2]]}]}]}]},[2]],"i":[{"l":[{},[0,1,2]]}],"o":[{"j":[{},[0,0,2]]}],"ó":[{"g":[{},[0,1,2]],"n":[{},[2]]}],"ü":[{},[0,1,2]]}],"s":[{"á":[{"n":[{},[0,0,2]]}],"h":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{"á":[{"m":[{"é":[{},[0,0,0,0,0,2,1]]}],"r":[{"a":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}]}],"t":[{"a":[{"d":[{"ó":[{},[0,0,0,1]]}],"k":[{"o":[{"k":[{},[1]]}]}],"s":[{"é":[{},[1]]}]}],"e":[{"g":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,0,1]]}]}],"ó":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{"e":[{},[0,0,1,2]]}]}],"u":[{"d":[{"v":[{},[0,2,1]]},[2]],"g":[{},[0,2,1]],"l":[{},[2]],"n":[{"d":[{},[0,2,1]],"i":[{},[0,2]]}],"r":[{},[2]],"t":[{"á":[{},[0,0,1]],"ó":[{},[0,0,1]]}]}],"ú":[{"j":[{},[0,2,1]],"l":[{},[2]],"s":[{"z":[{},[0,0,1,2]]}]}],"ü":[{"g":[{},[0,2,1]],"k":[{},[2]],"l":[{"é":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"n":[{},[2]],"s":[{"t":[{},[0,0,1]]}],"v":[{},[0,2,1,2]],"z":[{"e":[{"m":[{},[0,0,1]]}]},[2]]}],"ű":[{"r":[{"i":[{".":[{},[0,0,1]]}],"l":[{},[0,0,1]]}],"z":[{},[2]]}]}],"u":[{"b":[{"i":[{"n":[{},[0,0,2,1]]}],"o":[{"r":[{},[0,0,2]]}]}],"d":[{"á":[{},[0,2]],"e":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"h":[{},[0,2,0,2]],"o":[{},[0,0,2]]}],"k":[{"c":[{},[1,2]]}],"l":[{"l":[{},[0,0,0,2]],"t":[{"a":[{},[0,0,0,2,1]],"i":[{},[0,0,0,2]]}]}],"m":[{"a":[{"e":[{},[0,2]],"f":[{},[0,2]],"k":[{},[0,2]],"m":[{},[0,2]],"r":[{},[0,2]],"v":[{},[0,2]]}],"á":[{"b":[{},[0,2]],"d":[{},[0,2]],"é":[{},[0,2]],"h":[{},[0,2]],"i":[{},[0,2]],"m":[{},[0,2]],"n":[{},[0,2]],"r":[{},[0,2]],"v":[{},[0,2]]}]}],"p":[{"h":[{},[0,0,1]]}],"r":[{"a":[{"d":[{},[0,0,2]]}],"i":[{"k":[{"r":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]]}],"s":[{"z":[{"e":[{},[0,0,2,0,1]]}]}],"t":[{".":[{},[0,2]],"a":[{"d":[{},[0,0,2]],"l":[{},[0,0,2]],"m":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]},[2]],"i":[{},[0,2]],"o":[{"n":[{},[1,2]]}],"ó":[{"b":[{},[1]],"é":[{},[1]],"h":[{},[1]],"i":[{},[1]],"m":[{},[1]],"n":[{},[1]],"r":[{},[1]],"s":[{},[1]],"t":[{},[1]],"v":[{},[1]]},[0,2]],"r":[{},[0,2]],"t":[{},[0,2]],"u":[{},[0,0,2]]}],"z":[{"í":[{},[0,0,2]],"s":[{},[0,0,2]],"ú":[{},[0,2]],"ü":[{},[0,0,2,1]]}]},[0,1]],"ú":[{"j":[{"í":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"é":[{},[0,0,2]],"i":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[0,1]],"ü":[{"d":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"n":[{"ő":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"e":[{"m":[{".":[{},[0,0,2]],"b":[{},[0,0,2]],"e":[{"n":[{},[0,0,2]],"t":[{},[0,0,2]]}],"é":[{},[0,0,2]],"h":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"n":[{},[0,0,2]]}],"é":[{},[0,0,2]]}]},[0,1]],"ű":[{"r":[{"i":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[0,1]],"v":[{"a":[{"d":[{},[2]],"k":[{"t":[{"i":[{},[0,0,1]]}]},[2]],"n":[{"h":[{},[0,2,1]],"t":[{},[1,2]],"y":[{"a":[{},[0,2,1,2]]}],"z":[{},[0,2]]}],"r":[{"a":[{"c":[{},[0,0,0,2]],"g":[{},[0,0,0,2,1]]}],"e":[{},[0,0,0,2,1,2]],"é":[{"k":[{},[0,0,0,2]]}]}],"s":[{"z":[{"e":[{},[0,0,0,2]],"ü":[{},[0,0,0,2]]}]}],"t":[{"á":[{},[1,2]],"ó":[{},[1,2]]}]}],"á":[{"d":[{},[2]],"n":[{"a":[{"n":[{},[0,0,0,2]]}]}],"r":[{"a":[{"l":[{},[0,0,0,2,1]]}],"i":[{"a":[{".":[{},[0,0,0,2]],"i":[{},[0,0,0,2]]}],"á":[{},[0,2,1,2]]}]},[2]],"t":[{"a":[{},[0,2,1]],"t":[{},[0,2,1]]}],"z":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"l":[{"e":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"s":[{"t":[{},[0,0,1]]},[2]],"t":[{},[2]],"z":[{},[2]]}],"i":[{"c":[{"s":[{"e":[{},[0,0,0,2]]}]}],"n":[{"g":[{},[0,0,1]]}]}],"k":[{"r":[{},[0,0,1]]}],"o":[{"l":[{"d":[{},[0,2,1]],"t":[{"ó":[{},[0,0,1]]}]}],"s":[{},[0,0,0,1]],"x":[{},[0,2,1]]}],"ö":[{"m":[{},[0,2,1]],"s":[{},[0,2,1]]}],"ő":[{"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"u":[{"t":[{},[0,2,1]]}],"ü":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1]],"z":[{},[0,0,1,2]]}]}],"w":[{"a":[{"g":[{},[0,2]]}],"h":[{"i":[{"s":[{"k":[{"y":[{"k":[{},[0,0,0,0,0,0,0,0,2]]},[0,0,0,0,0,0,0,2]]}]}]},[0,0,2]]}]}],"x":[{"a":[{"b":[{},[0,2,1]],"d":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"n":[{},[0,2,1]],"v":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"g":[{},[0,0,1]],"l":[{},[0,0,1]]}],"i":[{"n":[{"f":[{},[0,0,1]],"g":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ó":[{"r":[{},[0,0,0,0,2]]}],"s":[{"e":[{},[0,0,0,2]]}]}],"í":[{"r":[{},[0,0,1]]}],"ö":[{"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"u":[{"t":[{},[0,2,1]]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"z":[{},[0,0,1]]}],"ű":[{"r":[{},[0,0,1]]}]}],"y":[{"e":[{".":[{},[0,1]],"d":[{},[0,1]],"i":[{},[0,1]],"k":[{},[0,1]],"l":[{},[0,0,1,2]],"n":[{},[0,1]],"s":[{},[0,1]],"t":[{},[0,0,0,0,2]]}],"f":[{"l":[{},[0,0,1]]}],"i":[{".":[{},[0,1]],"l":[{},[0,0,1]],"n":[{"g":[{},[0,0,1]]}],"t":[{},[0,1]]}],"m":[{"a":[{},[0,0,0,0,2]]}],"s":[{"t":[{},[0,0,1,2]]}]}],"z":[{"a":[{"c":[{"h":[{},[0,0,0,2]],"i":[{"k":[{},[0,0,0,2]]}]}],"i":[{"k":[{"o":[{},[0,0,0,0,2]]}]}],"l":[{"t":[{"a":[{},[0,0,0,0,2,1]]}]}],"p":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]]}],"á":[{"l":[{"l":[{},[0,0,1]],"t":[{},[0,0,1]]}],"n":[{"ö":[{},[0,0,0,2]]}],"r":[{"ó":[{"r":[{"a":[{},[0,0,0,2,1,2]]}]}]}],"s":[{"e":[{},[0,0,0,2,1]],"i":[{"k":[{"o":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"s":[{},[0,0,0,0,3]]}]}],"d":[{"u":[{},[0,0,2]]}],"e":[{"g":[{},[0,2,1,2]],"l":[{"e":[{},[0,0,1,2]],"j":[{},[0,0,1]],"m":[{},[0,0,1]],"ő":[{},[0,0,1]]}],"m":[{},[0,2,1]],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1]],"k":[{"e":[{},[0,0,0,2,1,2]],"o":[{"l":[{},[0,0,0,2]]}]}],"r":[{"t":[{"é":[{},[0,2,1]]}]}]}],"i":[{"n":[{"g":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"r":[{"á":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"m":[{"a":[{"g":[{},[0,0,0,0,1]]}]}],"o":[{"b":[{},[0,2,1]],"l":[{},[2]],"n":[{"a":[{"l":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2,1]],"t":[{},[0,0,0,0,0,2]]}],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"r":[{"í":[{},[0,1,2]]}],"s":[{"é":[{},[0,0,4]],"i":[{"k":[{"e":[{},[0,2,3]]}]}],"o":[{"r":[{},[0,0,3]]}],"p":[{},[0,0,3]],"ü":[{},[0,2,3]],"z":[{},[0,0,3]]}],"u":[{"t":[{},[0,0,1]]}],"ú":[{"j":[{},[0,2,1]],"r":[{"é":[{},[0,0,0,2,1]]}]}],"ü":[{"z":[{},[0,0,1]]}]}]}],"á":[{".":[{},[2]],"a":[{"d":[{"a":[{},[0,0,2]],"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"j":[{"á":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"u":[{"t":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]]}]},[0,1]],"á":[{"c":[{"s":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"y":[{},[0,0,2]]}],"j":[{"u":[{},[0,0,2]]}],"m":[{"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"u":[{},[0,0,2]]}],"s":[{"á":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"z":[{"o":[{},[0,0,2]],"u":[{},[0,0,2]]}]},[0,1]],"b":[{"a":[{"d":[{"u":[{},[0,2,1]]}],"k":[{"c":[{},[0,0,1]]}],"l":[{"a":[{},[0,2,1,2]],"k":[{},[0,2,1]]}],"m":[{"b":[{"u":[{},[0,2,1]]}]}],"n":[{"y":[{},[0,2,1,2]]}],"p":[{},[0,0,0,1]],"r":[{"t":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,0,3]]}]}],"á":[{"g":[{},[0,2,1,2]],"l":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"á":[{},[0,2,1]],"n":[{},[0,2,1]],"u":[{},[0,2,1,2]]}],"t":[{"j":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"v":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"b":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{"a":[{},[0,0,2,1]]},[0,0,0,0,2]],"n":[{"d":[{},[0,0,2,1]]}]}],"á":[{"r":[{},[0,0,2,1]]}],"e":[{"n":[{},[0,0,2]],"r":[{},[0,0,2,1,2]]}],"é":[{"l":[{},[0,0,2,1,2]]}],"i":[{"d":[{},[0,0,2]],"m":[{},[0,0,2]],"s":[{},[0,0,2,1,2]],"t":[{"a":[{},[0,0,2,1]]}]}],"o":[{"s":[{"o":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1]]}]}],"ö":[{"r":[{},[0,0,2]]}],"ü":[{"l":[{},[0,0,2,1]]}],"ű":[{},[0,0,2]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"l":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1]],"e":[{"g":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1,2]]}],"é":[{"g":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2,1]]}],"n":[{"ö":[{},[0,2]]}]}],"m":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{"o":[{},[0,0,1,2]],"ő":[{},[0,0,1]]}]}],"é":[{"c":[{},[1,2]],"g":[{},[0,2,1,2]],"k":[{"e":[{},[0,0,1,2]],"s":[{},[0,2,1]]}],"l":[{"e":[{"s":[{},[0,2,1,2]]}],"t":[{},[0,2,1]]}],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"i":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,0,1]],"é":[{},[0,0,1]]},[0,0,0,2]],"k":[{"r":[{},[0,2,1]]}],"l":[{"l":[{"a":[{},[0,0,1]]}]}],"m":[{},[0,2,1]],"n":[{"a":[{"i":[{},[0,0,0,2]],"s":[{},[0,2]]}],"d":[{},[0,2,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]]}],"s":[{},[0,2,1]],"z":[{"m":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"í":[{"v":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"a":[{"k":[{"r":[{},[0,0,0,0,1]]}],"p":[{},[0,0,0,0,1]]}]}],"o":[{"l":[{"d":[{"a":[{},[0,2,1]]}]}],"p":[{},[0,2,1]],"r":[{"a":[{"j":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]}]}],"s":[{"z":[{},[0,2,1]]}],"v":[{},[0,2,1,2]]}],"ö":[{"b":[{},[0,0,1]],"d":[{},[0,0,1,2]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"á":[{"i":[{},[1]]}],"e":[{"k":[{},[0,0,2]]}]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"j":[{"j":[{"a":[{"l":[{},[0,2,1]]}]}]}],"s":[{"z":[{},[0,0,0,1,0,2]]}]}],"ú":[{"r":[{".":[{},[0,0,1]]}]}],"ü":[{"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"c":[{"a":[{"g":[{},[0,2,1,2]],"j":[{"t":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,0,1,2]],"n":[{},[0,0,1]]}],"l":[{"a":[{},[0,2,1,2]],"m":[{},[0,0,1]]}],"n":[{"y":[{},[0,2,1,2]]}]}],"á":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]]}],"c":[{"s":[{"e":[{},[0,0,3]],"o":[{},[0,0,3]]}]}],"e":[{"l":[{"e":[{},[0,0,0,0,0,2]]},[0,0,1,2,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"é":[{"p":[{},[0,2,1]],"r":[{"e":[{},[0,2,1]]}]}],"h":[{"a":[{},[0,2,3]],"á":[{},[0,2,3]],"e":[{},[0,0,3]],"é":[{},[0,2,3]],"o":[{"n":[{},[0,0,3]]}],"u":[{},[0,2,3]]}],"i":[{"a":[{"s":[{},[0,0,0,2]]}],"l":[{},[0,2,1]],"n":[{"c":[{},[0,0,1]],"g":[{},[0,0,1]],"t":[{"i":[{"l":[{},[0,0,0,0,2]]}]}]}],"ó":[{"s":[{"ű":[{},[0,0,0,2]]}]}],"s":[{},[0,2,1,2]]}],"í":[{"v":[{},[0,0,1]]}],"o":[{"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"r":[{},[0,0,1]]}],"ö":[{"l":[{},[0,0,1,2]]}],"s":[{"a":[{"b":[{"l":[{},[0,0,0,1]]}],"g":[{},[0,2,0,1,2]],"j":[{"t":[{},[0,2,0,1]]}],"k":[{"a":[{},[0,2]],"n":[{},[0,2,0,1]]}],"l":[{"a":[{"p":[{},[0,0,0,1]]}],"j":[{},[0,0,0,1]],"o":[{"m":[{},[0,0,0,1]]}]}],"p":[{"p":[{},[0,0,0,1]]}],"t":[{"k":[{},[0,0,0,1]],"o":[{"m":[{},[0,2]]}]}]}],"á":[{"c":[{},[0,2,0,1,2]],"l":[{},[0,2,0,1]],"r":[{"g":[{},[0,0,3]],"k":[{},[0,2,0,1]],"n":[{},[0,2,0,1]],"u":[{},[0,2]]}],"t":[{"a":[{},[0,2,0,1,2]]}]}],"b":[{"o":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"e":[{"f":[{},[0,2]],"g":[{},[0,2,0,1,2]],"l":[{},[0,2,0,1,2]],"n":[{"e":[{},[0,2]],"t":[{},[0,2]]}],"r":[{},[0,2]],"t":[{},[0,0,0,0,2]],"v":[{},[0,2,0,1]]}],"é":[{"g":[{},[0,0,0,1,2]],"k":[{"i":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"n":[{},[0,0,0,1]]},[0,0,0,0,2]],"l":[{},[0,2]],"p":[{},[0,2]],"t":[{"e":[{},[0,0,0,1,2]]}]}],"i":[{"g":[{"a":[{},[0,2,0,1]]},[0,0,0,0,2]],"l":[{"l":[{"e":[{},[0,2,0,1]]}]}],"m":[{"i":[{},[0,2]]}],"n":[{"t":[{},[0,0,0,1]]}],"p":[{"a":[{},[0,2,0,1]]},[0,0,0,0,2]],"s":[{"k":[{},[0,0,0,1]]}]}],"í":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"o":[{"k":[{"t":[{"a":[{},[0,2]]}]}],"l":[{"a":[{"t":[{},[1,2]]}]}],"m":[{"k":[{},[1,2]]}],"r":[{"r":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,2]]}],"v":[{},[0,2,0,1]]}],"ó":[{".":[{},[0,0,3]],"r":[{},[0,0,0,1,2]],"t":[{},[0,0,3]],"v":[{},[0,0,3]]}],"ö":[{"k":[{},[0,0,0,1,2]],"l":[{},[0,2,0,1,2]],"s":[{},[0,2,0,1]],"t":[{},[0,2]]}],"ő":[{"s":[{},[0,0,0,1,2]]}],"s":[{},[0,0,0,1]],"u":[{"j":[{},[0,2]],"t":[{},[0,2]]}],"ú":[{"r":[{},[0,2,0,1]]}],"ü":[{"l":[{},[0,0,0,1,2]],"t":[{},[0,2,0,1,2]]}],"y":[{},[0,1]],"z":[{"e":[{"n":[{},[0,0,0,3]]}]}]}],"u":[{"t":[{},[0,2,1]]}],"ú":[{"r":[{},[0,0,1]]}],"ü":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}]}],"d":[{"a":[{"b":[{"l":[{},[0,0,1]]}],"d":[{"o":[{},[0,2,1,2]]}],"k":[{"c":[{},[0,2,1]]}],"l":[{"a":[{"p":[{},[0,0,1,2]]}],"b":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]]}],"n":[{"y":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]]}]}],"p":[{"á":[{},[0,2,1,2]]},[0,0,0,1]],"r":[{"c":[{},[0,0,1]]}],"t":[{"y":[{},[0,2,1]]}]}],"á":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]],"s":[{"z":[{},[0,0,1,2]]}],"t":[{"l":[{},[0,0,1]]}]}],"d":[{"r":[{},[0,0,1]],"z":[{},[0,0,3]]}],"e":[{"c":[{},[0,0,1,2]],"g":[{},[0,2,1,2]],"j":[{},[0,2,1]],"l":[{"e":[{"j":[{},[0,0,0,0,1]],"m":[{"e":[{},[0,0,0,0,1]]}]},[0,0,0,0,0,2]]},[0,2,1,2]],"m":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"á":[{},[0,0,0,2,1]],"ő":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1,2]]}]}],"é":[{"d":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"g":[{"e":[{},[0,2,1,2]]},[0,0,0,1,2]],"k":[{"r":[{"é":[{},[0,0,0,1]]}]}],"n":[{"e":[{},[0,0,1]]}],"r":[{"t":[{"e":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"s":[{"t":[{},[0,0,0,1]]}]}],"i":[{"c":[{"s":[{"e":[{},[0,0,0,2]]}]}],"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1,2]]}],"k":[{"o":[{},[0,0,1,2]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]],"t":[{},[0,2,1]]}],"ó":[{"d":[{"a":[{"r":[{},[0,0,0,2]]}]}],"é":[{"r":[{"a":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"i":[{"v":[{},[0,0,0,2,0,2]]}],"k":[{"o":[{},[0,0,0,2]],"r":[{"a":[{},[0,0,0,2,1,2]]}]}]}],"p":[{},[0,2,1,2]],"s":[{"t":[{},[0,0,1]]}]}],"í":[{"v":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"g":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2]]}],"r":[{"a":[{"k":[{},[0,0,0,2]]}]}],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"s":[{},[0,0,0,0,2]]}],"ö":[{"b":[{},[0,0,0,2]],"s":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"ó":[{"t":[{},[0,1,2]]}]}],"s":[{"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"d":[{"v":[{},[0,0,1]]}]}],"ú":[{"s":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"é":[{},[0,0,1,2]]}],"z":[{},[0,2,1]]}],"z":[{"a":[{},[0,0,3]],"á":[{},[0,2,3]],"e":[{},[0,2,3]],"ú":[{},[0,0,3]]}]}],"e":[{"c":[{"s":[{},[0,0,2]]}],"d":[{"z":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"m":[{"e":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"s":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[0,1]],"é":[{"d":[{"e":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"h":[{"e":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]]}],"n":[{"e":[{},[0,0,2]]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]]}]},[0,1]],"f":[{"a":[{"g":[{"y":[{"a":[{},[0,2,1,2]]}]}],"l":[{"g":[{},[0,2,1]]}]}],"á":[{"b":[{},[0,2]],"g":[{},[0,2,1]],"k":[{},[1,2]],"p":[{},[0,2,1]],"s":[{},[1,2]],"t":[{},[0,2]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"l":[{"m":[{},[0,0,1]]}],"m":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"é":[{"n":[{"e":[{},[0,0,1,2]]}]}],"i":[{"a":[{"d":[{},[0,0,0,2]],"m":[{},[0,0,0,2]]}],"d":[{},[0,2,1,2]],"m":[{},[0,2,1]],"n":[{"g":[{".":[{},[0,2,1]]}]}]}],"o":[{"r":[{"d":[{"á":[{},[0,2,1]]}]}],"s":[{"z":[{},[0,2,1]]}]}],"r":[{"e":[{"c":[{},[0,0,2]]}],"ö":[{},[0,1,2]]}],"u":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"ü":[{"n":[{},[0,2,1]]}]}],"g":[{"a":[{"b":[{"l":[{},[0,2,1]],"r":[{},[0,0,1]]}],"c":[{"é":[{},[0,0,1]],"s":[{"k":[{"a":[{},[1]]}]}]},[0,0,0,2]],"d":[{"á":[{},[0,0,1,2]],"d":[{},[1]],"ó":[{},[0,0,1,2]]},[0,2]],"j":[{},[0,2,1,2]],"k":[{"a":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]},[0,2]],"b":[{},[1,2]],"h":[{},[1,2]],"i":[{},[1,2]],"k":[{},[1,2]],"n":[{},[1,2]],"r":[{},[1,2]],"t":[{},[0,2]]}],"l":[{"a":[{},[0,2,1,2]],"j":[{},[0,2,1]],"l":[{},[0,2,1]],"t":[{},[0,0,1]]}],"m":[{},[1,2]],"n":[{"a":[{},[0,0,1]],"g":[{},[0,2,1]],"k":[{},[1,2]],"t":[{},[0,0,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"s":[{"p":[{},[0,0,1]],"z":[{},[0,2,1]]}],"t":[{"o":[{"l":[{},[0,0,0,2]]}]}],"u":[{},[0,2,1]],"z":[{"a":[{},[1,2]],"o":[{"n":[{},[0,0,0,2]]}]}]}],"á":[{"g":[{},[0,2,1,2]],"l":[{"d":[{},[0,2,1]],"m":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1,2]]}],"n":[{"y":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"p":[{},[0,2,1]],"r":[{"a":[{"d":[{},[0,2,1]]}],"b":[{},[0,2,1]],"é":[{},[0,2,1,2]],"h":[{},[0,2,1]],"i":[{"a":[{},[0,2,1,2]]}],"o":[{"k":[{"b":[{},[0,0,0,2]]}]}],"v":[{},[0,2,1]]}],"s":[{"ó":[{},[0,2,1]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2]]}],"t":[{"a":[{},[0,2,1,0,1,2]],"á":[{},[0,2,1]],"é":[{},[0,2,1]],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{"k":[{"k":[{},[0,0,0,2]]}]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"ü":[{},[0,0,1]],"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"c":[{},[0,2,1,2]],"d":[{},[0,2,1,2]],"f":[{},[0,0,1]],"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"n":[{"c":[{},[0,0,1]],"e":[{},[0,0,1]]},[0,2,0,2]],"p":[{},[0,2,1,2]],"r":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2,1]]}]}],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"h":[{"e":[{},[0,2,1,2]]}],"j":[{},[0,2,1]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{"e":[{},[0,2,1,2]]}],"p":[{"í":[{},[0,2,1]],"ü":[{},[0,0,1,2]]}],"r":[{".":[{},[0,2,1]],"á":[{},[0,2,1]],"é":[{},[0,2,1,2]],"i":[{},[0,2,1]],"m":[{},[0,0,1]],"ő":[{},[0,2,1,2]],"t":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]]}],"v":[{},[0,2,1]]}],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"v":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1]],"y":[{"a":[{"r":[{},[0,0,3]]}],"e":[{},[0,0,3]],"ú":[{},[0,0,3]]}]}],"h":[{"á":[{"n":[{"y":[{"i":[{},[0,0,0,0,2]]}]}]}]}],"i":[{"a":[{"l":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,2]]}]}],"d":[{"e":[{},[0,2,1]]},[0,0,0,2]],"f":[{},[0,2,1]],"g":[{"a":[{},[0,2,1]],"é":[{"n":[{},[0,2,1]]}]},[0,0,0,2]],"l":[{"l":[{},[0,2]]}],"m":[{"a":[{},[0,0,1]],"i":[{},[0,2,1,2]]}],"n":[{"a":[{".":[{},[0,2,1,2]]}],"f":[{},[0,0,1]],"g":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}],"r":[{"i":[{},[0,2,1]],"o":[{},[0,0,1]]}],"s":[{"t":[{},[0,2,1]],"z":[{},[0,2,1]]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{},[0,2,1]]}],"í":[{"g":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{"é":[{},[0,2]]}],"z":[{},[0,2,1]]}],"k":[{"á":[{"r":[{"o":[{"k":[{},[0,0,0,0,2]]}]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"o":[{"á":[{},[0,2,1]],"k":[{"l":[{},[0,2,1]]}],"l":[{"i":[{},[0,2,1,2]],"t":[{"ó":[{},[0,0,1]]}]}],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{"k":[{"o":[{},[0,2,1]]}],"s":[{},[0,0,0,0,3]],"z":[{"l":[{},[0,2,1]]}]}]}],"ó":[{"d":[{"r":[{},[0,0,0,1]]}],"r":[{"á":[{},[0,2,1,2]]}]}],"ö":[{"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{"t":[{},[0,0,1]]}],"r":[{"ö":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"o":[{"r":[{"t":[{"r":[{},[0,0,0,0,0,1]]},[0,0,0,0,0,0,2]]}]}],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{"h":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"d":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{"a":[{},[0,2,1]],"d":[{},[0,2,1]]},[0,0,0,2]],"r":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2]]}],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"t":[{},[0,0,1]]}]}],"ü":[{"d":[{},[0,0,1]],"g":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ű":[{"r":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"y":[{"a":[{"g":[{},[0,0,0,0,1]],"l":[{"j":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"m":[{},[0,0,0,1]]}],"s":[{"n":[{},[1,2]],"s":[{"a":[{},[0,2]]}]}]}],"á":[{"l":[{},[0,2,0,1,2]],"r":[{"a":[{"m":[{},[0,2,0,1,2]]}]}],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"e":[{},[0,2,0,1,2]],"é":[{"l":[{},[0,2]],"r":[{".":[{},[0,0,0,1]]}]}],"g":[{"y":[{"ű":[{},[1]]}]}],"i":[{"d":[{},[0,2]],"l":[{},[0,2]],"v":[{"a":[{"d":[{},[0,2]]}]}]}],"o":[{"b":[{},[0,2]],"s":[{"z":[{},[0,2]]}],"t":[{"t":[{"h":[{},[0,0,0,1]]}]}]}],"ó":[{"s":[{},[0,2,0,1,2]]}],"ö":[{"l":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1]]}],"u":[{"r":[{},[0,2]]}],"ú":[{"h":[{},[0,2]],"t":[{},[0,2]]}],"ü":[{},[0,2,0,1,2]]}]}],"h":[{"a":[{"j":[{"k":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,1]]}]}],"í":[{"t":[{},[1,2]]}],"o":[{"r":[{"s":[{},[0,2,1]]}]}]}],"i":[{"d":[{"o":[{"m":[{},[0,0,2]]}],"ő":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"a":[{},[0,0,2]]}],"j":[{"e":[{},[0,0,2]]}],"m":[{"á":[{},[0,0,2]]}],"r":[{"a":[{"m":[{},[0,0,2]]}],"á":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]]}],"v":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]]}],"z":[{"é":[{},[0,0,2]]}]},[0,1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[0,1]],"j":[{"a":[{"d":[{"ó":[{},[0,2,1]]}],"k":[{"c":[{},[0,2,1]],"v":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1,2]]}],"m":[{"b":[{"u":[{},[0,0,1]]}]}],"n":[{"a":[{},[0,2,1]],"t":[{},[0,0,1]],"y":[{},[0,2,1]]}],"r":[{},[0,2,1]],"t":[{"l":[{},[0,2,1]]}],"x":[{},[0,2,1]],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"a":[{},[0,2,1,0,1]],"á":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"h":[{},[0,0,2]]}],"e":[{"c":[{},[0,2,1,2]],"g":[{"é":[{},[0,0,1]]}],"l":[{"m":[{},[0,0,1]],"n":[{},[0,0,1]],"ő":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{},[0,0,1,2]],"v":[{},[0,2,1,2]],"x":[{},[0,0,1]]}],"é":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{"e":[{},[0,2,1]]},[0,0,0,2]],"t":[{"e":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"z":[{},[0,2,1]]}],"í":[{"j":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"k":[{"e":[{"l":[{"l":[{},[0,0,0,1]]}]}],"ő":[{},[0,0,2,1,2]],"ü":[{},[0,0,2]]}],"l":[{"a":[{"d":[{},[0,0,2]],"k":[{"t":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"i":[{"k":[{},[0,0,2]]}],"o":[{"b":[{},[0,0,2]]}]}],"n":[{"á":[{"r":[{},[0,0,2]]}],"i":[{"n":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"o":[{"b":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{},[0,2,1]]}],"ö":[{"b":[{},[0,2,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,2,1]]}],"ő":[{"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"n":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[0,2,1]]}],"ú":[{"s":[{"z":[{},[0,0,1]]}]}],"ü":[{"g":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ű":[{"r":[{},[0,0,1]]}],"z":[{"a":[{"b":[{},[0,0,2]],"j":[{},[0,0,2]]}],"s":[{"a":[{},[0,0,2,3]]}]}]}],"k":[{"a":[{"b":[{"r":[{},[0,0,1]]}],"d":[{},[0,2,1,2]],"j":[{},[0,2,1]],"k":[{"a":[{},[0,0,1]]}],"l":[{"a":[{"p":[{"í":[{},[0,2,1,2]]}]}],"e":[{},[0,0,1]],"j":[{},[0,0,1]]}],"n":[{"t":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"á":[{},[0,2,1,2]],"m":[{},[0,0,1]],"z":[{},[0,0,1]]}],"s":[{"s":[{},[0,2,1]]}],"t":[{"l":[{},[0,2,1]]}],"u":[{},[0,2,1,2]]}],"á":[{"c":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"t":[{"a":[{},[0,0,1]],"k":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"b":[{"é":[{},[0,0,1]]}],"g":[{},[0,2,1,2]],"l":[{"e":[{},[0,0,1,2]],"k":[{},[0,2,1]],"l":[{"e":[{"n":[{"e":[{},[0,2]]}]}]}],"m":[{},[0,2,1]],"ő":[{},[0,2,1,2]]}],"m":[{"b":[{},[0,0,1]]}],"r":[{"ő":[{},[0,0,1,2]]}],"v":[{"é":[{},[0,2,1,2]],"o":[{},[0,2,1,2]]}]}],"é":[{"l":[{},[0,2,1,2]],"n":[{"e":[{},[0,2,1,2]]}],"r":[{"m":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,1]]}],"t":[{"e":[{},[0,2,1,2]],"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"v":[{"e":[{},[0,2,1,2]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"a":[{},[0,0,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,0,1]]}],"m":[{},[0,2,1,2]],"n":[{"g":[{},[0,0,1]],"t":[{},[0,2,1]]}],"r":[{"o":[{},[0,0,1]]}],"s":[{},[0,2,1,2]],"t":[{"a":[{},[0,0,1]]},[0,0,0,2]],"v":[{},[0,2,1,2]]}],"í":[{"r":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"l":[{"a":[{"r":[{},[0,0,2]]}]}],"o":[{"k":[{"s":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1,2]],"d":[{},[0,2,1]],"i":[{},[0,2,1,2]],"l":[{},[0,2,1]]}],"p":[{"e":[{},[0,2,1,2]]}],"r":[{"v":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"t":[{},[0,2,1]]}]}],"ó":[{"n":[{"i":[{},[0,0,1]]}]}],"ö":[{"l":[{"ő":[{},[0,2,1]]},[0,0,0,2]],"r":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"á":[{"k":[{},[0,0,2]]}],"e":[{"á":[{},[0,1,2]]}],"i":[{"s":[{},[0,1,2]]}]}],"s":[{"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"j":[{},[0,2,1]],"n":[{"i":[{},[0,2]]}],"r":[{"a":[{},[0,0,1]]},[0,0,0,2]],"t":[{"ó":[{},[0,0,1]]}]}],"ú":[{"j":[{},[0,0,1]],"t":[{"o":[{},[0,2,1]]},[0,0,0,2]]}],"ü":[{"d":[{},[0,0,1]],"g":[{},[0,2,1]],"l":[{},[0,0,0,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ű":[{"r":[{},[0,0,1]]}],"v":[{"a":[{"t":[{},[0,1,2]]}]}]}],"l":[{"a":[{".":[{},[2]],"b":[{"l":[{},[0,0,1]]}],"c":[{"é":[{},[0,0,1]]}],"d":[{"a":[{"g":[{},[0,2,1]]}],"ó":[{},[0,2,1,2]]}],"j":[{"á":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"k":[{"a":[{"r":[{},[0,0,0,2]]}],"n":[{"a":[{".":[{},[0,2,1]]}]}]}],"l":[{"a":[{"k":[{},[0,0,1]]}],"á":[{"t":[{},[0,2,1]]}],"g":[{},[0,0,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]]},[2]],"n":[{"e":[{},[0,2,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]],"y":[{"a":[{},[0,2,1,2]],"á":[{"i":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"t":[{},[0,2,1,2]],"v":[{},[0,0,1,2]]}]}]}],"p":[{"o":[{"s":[{},[0,2,1,2]]}],"ó":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1,2]]}],"s":[{"z":[{"e":[{"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"é":[{"k":[{},[0,0,0,2,0,1]]}],"ö":[{},[0,0,0,2]],"ű":[{},[0,0,0,2]]}]}],"t":[{"a":[{"t":[{},[0,0,0,2]]}],"e":[{"t":[{},[0,0,0,2]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"i":[{"k":[{"r":[{},[0,0,0,2]]}],"n":[{"t":[{},[0,0,0,2]]}]}],"l":[{"é":[{},[0,0,1]]}],"o":[{"l":[{"d":[{},[0,0,0,2]]}]}],"ó":[{},[0,0,0,2,1,2]],"t":[{"i":[{},[0,2,1]]}],"y":[{},[0,2,1,2]]}],"u":[{"t":[{},[0,0,1]]}]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"g":[{".":[{},[0,0,1]],"i":[{},[0,0,1,2]],"ú":[{},[0,2,1,2]]}],"l":[{"l":[{},[0,0,1]]}],"r":[{"a":[{"k":[{},[0,2,1,2]]}],"f":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]]}],"s":[{"z":[{},[0,0,0,2,3]]}],"t":[{"c":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"ú":[{},[0,2,1]],"v":[{"á":[{},[0,2,1]]}]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"a":[{"i":[{},[0,0,0,0,0,2]]}]}],"d":[{"á":[{"s":[{},[1]]}],"o":[{"z":[{},[1]]}],"r":[{},[0,0,1,2]],"y":[{},[0,0,1]]}],"e":[{"c":[{},[0,2,1,2]],"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"l":[{"k":[{},[0,0,1]],"m":[{},[0,0,1]],"o":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"m":[{"u":[{},[0,0,1]]}],"r":[{},[0,2,1,2]],"s":[{"e":[{"m":[{},[0,0,1]]}],"ő":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"t":[{},[0,2,1,2]],"z":[{},[0,0,1]]}],"é":[{"g":[{},[0,2,1]],"h":[{"e":[{},[0,2,1,2]]}],"k":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}],"e":[{"l":[{},[0,0,0,2,1,2]]}],"ü":[{},[0,0,0,2]]}],"l":[{"e":[{},[0,0,1,2]],"ő":[{},[0,0,1,2]]}],"n":[{"e":[{},[0,2,1,2]]}],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"d":[{},[0,2,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"m":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"á":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"v":[{".":[{},[0,2,1]],"é":[{},[0,2,1,2]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"a":[{"j":[{"a":[{},[1]]}]}]}],"i":[{"a":[{"s":[{},[0,0,0,2]]}],"b":[{"o":[{},[0,0,1,2]]}],"d":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]]},[0,0,0,2]],"g":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,0,1]]}],"m":[{"p":[{},[0,0,1]]}],"n":[{"d":[{},[0,2,1]],"f":[{},[0,0,1]]}],"o":[{"n":[{"b":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}]}],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,0,1]],"o":[{},[0,2,1]]}],"s":[{"e":[{},[0,0,0,2,1]],"é":[{"k":[{},[0,0,0,2,1]]}],"i":[{"s":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]],"t":[{"e":[{},[0,0,1]]}]}],"z":[{},[0,2,1]]}],"í":[{"n":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1]],"v":[{},[0,0,1,2]]}],"k":[{"á":[{"r":[{"o":[{"k":[{},[0,0,0,0,2]]}]}]}],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"l":[{"a":[{"d":[{"ó":[{},[0,0,2,1,2]]}],"g":[{},[1]],"j":[{},[0,0,2]],"l":[{"a":[{"k":[{},[0,0,2,1,2]]}]}],"m":[{"á":[{},[1]],"e":[{},[0,0,0,0,2,1]],"o":[{"t":[{},[1]]}],"t":[{"i":[{},[1]]}]}],"p":[{"á":[{},[0,0,2,1,2]]}],"r":[{},[0,0,2,1,2]],"t":[{"a":[{"s":[{},[0,0,0,0,2]]},[1]],"e":[{},[0,0,0,0,2,1,2]],"o":[{"r":[{},[0,0,0,0,2,1]]}],"ö":[{},[0,0,0,0,2,1,2]],"u":[{},[1]]}]}],"á":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"r":[{"r":[{},[0,0,2,1]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}],"t":[{"h":[{},[0,0,2,1]],"m":[{},[0,0,2,1]]}]}],"e":[{"d":[{},[0,0,2]],"h":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]]}],"é":[{"k":[{"é":[{},[0,0,0,1]]}]}],"i":[{"z":[{},[0,0,2,1]]}],"o":[{"m":[{"á":[{},[1]]}]}],"ü":[{},[0,0,2]]}],"m":[{"a":[{"i":[{"m":[{},[1]]}]}],"o":[{"k":[{".":[{},[1]]}],"m":[{},[1]],"t":[{".":[{},[1]]}]}],"u":[{"k":[{},[1]],"n":[{"k":[{"b":[{},[1]]}]}]}]}],"o":[{"b":[{"j":[{},[0,0,1]]}],"k":[{"a":[{".":[{},[0,2,1,2]],"i":[{"h":[{},[1]],"n":[{},[1]],"r":[{},[1]]},[0,2,1,2]]}],"á":[{"n":[{},[1]],"t":[{},[1]],"u":[{},[1]]},[0,2,1,2]],"o":[{"k":[{},[0,0,0,2]],"n":[{"k":[{},[1]]}],"s":[{},[0,0,0,2]]}],"t":[{"a":[{},[0,2,1]]}],"u":[{},[1,2,1,2]]}],"l":[{},[0,2,1]],"m":[{"a":[{"d":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1]],"e":[{},[0,0,0,2,1]],"i":[{"t":[{},[0,0,0,2,1]]}],"o":[{"t":[{},[0,0,0,2]]}],"s":[{},[0,2]],"ú":[{},[0,0,0,2,1]]}],"n":[{"t":[{},[0,2,1]]}],"p":[{"c":[{},[0,0,1]],"e":[{},[0,2,1]]}],"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}],"x":[{},[0,2,1]]}],"ó":[{"a":[{},[0,0,0,0,2]],"á":[{},[0,0,0,0,2]],"ó":[{},[0,0,0,0,2]],"r":[{"á":[{"j":[{},[0,0,0,2]]}]}],"s":[{"ű":[{},[0,0,0,2,1,2]]}],"t":[{},[0,0,0,0,2]]}],"ö":[{"b":[{},[0,0,1]],"d":[{},[0,2,1]],"l":[{},[0,2,1,2]],"s":[{},[0,2,1]],"z":[{},[0,0,1]]}],"ő":[{"r":[{},[0,2,1]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{"a":[{"d":[{},[0,0,1]],"k":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"e":[{},[0,0,1,2]],"é":[{},[0,0,1]]}]}],"u":[{"g":[{},[0,2,1]],"n":[{"a":[{},[0,2,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{"j":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]]},[0,0,0,2]]}],"ü":[{"g":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ű":[{"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"y":[{"a":[{"d":[{"a":[{},[0,0,0,1]]}],"g":[{},[0,0,0,0,1,2]],"n":[{"t":[{},[0,0,0,1]],"y":[{"a":[{},[0,0,0,1]]}]}],"p":[{},[0,0,0,0,1]],"s":[{"s":[{},[0,0,0,1]]}]}],"á":[{"l":[{},[0,2]]}],"e":[{},[0,2,0,1,2]],"é":[{"j":[{},[0,2]],"l":[{},[0,2]],"n":[{"e":[{},[0,2,0,1,2]]}],"r":[{"e":[{},[0,2]]}],"v":[{"e":[{},[0,2]]}]}],"i":[{"d":[{"e":[{},[0,2]]}]}],"í":[{},[0,2]],"k":[{},[0,0,0,1,2]],"o":[{"d":[{"v":[{},[0,0,0,1]]}],"l":[{},[0,2]]}],"ó":[{},[0,2,0,1,2]],"ö":[{},[0,2,0,1]],"ő":[{},[0,2]],"s":[{},[0,0,0,1]],"u":[{"g":[{},[0,2]]}],"ü":[{},[0,2,0,1,2]],"ű":[{},[0,2,0,1,2]]}]}],"m":[{"a":[{"b":[{"l":[{},[0,2,1]],"r":[{},[0,2,1]]}],"c":[{"é":[{},[0,0,1,2]]}],"d":[{"m":[{},[0,0,1]]}],"g":[{"g":[{},[0,0,1]]}],"j":[{"t":[{},[0,2,1]]}],"k":[{"t":[{},[0,2,1]]}],"l":[{"a":[{"p":[{},[0,0,1,2]]}],"l":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ó":[{},[0,0,0,0,2]],"p":[{"p":[{},[0,2,1]]}],"r":[{"c":[{},[0,2,1]]}],"s":[{"z":[{"á":[{"l":[{},[0,0,0,2,0,1]]}],"e":[{"l":[{},[0,0,0,2]]}],"í":[{"v":[{},[0,0,0,2]]}],"o":[{"d":[{"v":[{},[0,0,0,2,0,1]]}]}],"ü":[{},[0,0,0,2,0,1,2]]}]}],"t":[{"l":[{},[0,0,1]],"t":[{},[0,2,1]],"y":[{},[0,2,1]]}],"u":[{"d":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1,2]]}]}],"á":[{"c":[{},[0,0,0,2]],"f":[{},[0,0,1]],"g":[{},[0,2,1]],"l":[{"l":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"n":[{"n":[{},[0,0,0,0,1]],"t":[{"r":[{},[0,0,0,0,1]]}]}],"r":[{"a":[{"k":[{},[0,2,1,2]],"m":[{},[0,0,1,2]],"s":[{},[0,2,1]]}],"á":[{},[0,2,1,2]],"b":[{},[0,2,1]],"i":[{},[0,2,1,2]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1]],"u":[{},[0,2,1,2]]}],"s":[{"v":[{},[0,0,1]]}],"t":[{"b":[{},[0,2,1]],"e":[{},[0,0,1,2,1]],"i":[{},[0,2,1]],"m":[{},[0,2,1]]}],"z":[{"ó":[{},[0,0,1,2]]}]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"b":[{},[0,2,1,2]],"j":[{},[0,2,1]],"l":[{"a":[{},[0,2,1]],"á":[{},[0,0,1]],"e":[{"m":[{},[0,0,1,2]]}],"é":[{},[0,0,1]],"h":[{},[0,2,1]],"í":[{},[0,0,1]],"j":[{},[0,2,1]],"k":[{},[0,0,1]],"m":[{},[0,2,1]],"o":[{},[0,0,1]],"ő":[{},[0,2,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"ü":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{},[0,2,1,2]],"r":[{"d":[{},[0,2,1]],"e":[{"k":[{},[0,0,1,2]]}],"k":[{},[0,2,1]],"o":[{},[0,2,1,2]],"ő":[{"k":[{},[0,0,0,2]],"t":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}]}],"s":[{"e":[{},[0,0,1,2]],"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"t":[{"i":[{},[0,2,1]],"ű":[{},[0,2,1]]},[0,0,0,2]],"v":[{},[0,2,1]],"x":[{},[0,2,1]],"z":[{},[0,2,1]]}],"é":[{"k":[{"e":[{},[0,0,1]]}],"l":[{"e":[{},[0,2,1,2]]}],"p":[{},[0,2,1]],"r":[{"c":[{},[0,2,1]],"d":[{},[0,2,1]],"t":[{"e":[{"l":[{},[0,2,1]]}]}]}],"t":[{"k":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"a":[{"b":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2]]}],"d":[{"e":[{},[0,2]],"é":[{},[0,2,1]],"ő":[{},[0,0,1,2]]}],"g":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"á":[{},[0,2]],"m":[{},[0,2]],"p":[{},[0,2,1]]}],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"p":[{"a":[{},[0,2,1,2]]}],"r":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]],"t":[{},[0,2,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]],"z":[{"á":[{},[0,0,1,2]]}]}],"z":[{},[0,2,1,2]]}],"í":[{"g":[{},[0,0,1]],"j":[{},[0,2,1]],"r":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"l":[{"a":[{"t":[{},[0,0,0,0,3,2]]}]}],"o":[{"b":[{},[0,2,1]],"f":[{},[0,2,1]],"k":[{"á":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{"a":[{},[0,2,1]]}]}],"l":[{"y":[{"a":[{"s":[{},[0,0,0,2]]}]}]}],"p":[{},[0,2,1]],"r":[{"á":[{"l":[{},[0,0,0,2,1,2]]}],"i":[{"s":[{},[0,0,0,2]]}],"o":[{"d":[{"v":[{},[0,0,0,2,1]]}]}]}],"s":[{"a":[{"s":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]],"t":[{"o":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"v":[{},[0,2,1]],"x":[{},[0,2,1]]}],"ó":[{"r":[{},[0,0,1,2]]}],"ö":[{"k":[{},[0,0,1,2]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"p":[{"a":[{"p":[{},[0,0,0,0,1,2]]}],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{"d":[{},[0,2,1]],"i":[{},[0,2]]}],"r":[{},[0,2,1,2]],"t":[{"á":[{},[0,2,1]]}]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"d":[{},[0,0,1]],"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ű":[{"t":[{},[0,3]],"z":[{},[0,0,1,2]]}],"v":[{"a":[{"s":[{"u":[{},[0,0,0,0,2,1,2]]}]}]}]}],"n":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"c":[{"é":[{},[0,2,1,2]],"h":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1]]}],"e":[{},[0,0,0,0,2]],"f":[{"r":[{},[0,0,1]]}],"g":[{"y":[{"a":[{},[0,0,1]]}]}],"j":[{"t":[{},[0,0,1]]}],"k":[{"á":[{},[0,2,1]],"c":[{},[0,2,1]],"r":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1,2]],"k":[{},[0,0,1]],"l":[{},[0,2,1]]}],"n":[{"ó":[{},[0,2,1]],"y":[{"a":[{},[0,0,1]]}]}],"o":[{},[0,2,1,2]],"p":[{"a":[{},[0,0,1]],"i":[{},[0,0,0,0,1]]},[0,0,0,2]],"r":[{"a":[{},[0,0,1]],"c":[{},[0,2,1]]}],"s":[{"s":[{"z":[{},[0,0,1]]}]}],"t":[{"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"o":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"ű":[{},[0,0,0,2,1]]}],"u":[{},[0,2,1,2]],"v":[{"a":[{},[0,0,1]]}]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"g":[{},[0,2,1]],"l":[{"l":[{},[0,2,1]]}],"r":[{".":[{},[0,0,1]],"a":[{"d":[{},[0,0,1]]}],"i":[{},[0,0,1,2]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"v":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1]]}],"z":[{},[0,2,1,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"a":[{"c":[{},[0,0,2]],"d":[{},[0,0,2,1]],"j":[{},[0,0,2]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2]],"u":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]],"r":[{"o":[{},[0,0,2,1,2]]}],"s":[{},[0,0,2]]}],"e":[{"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,0,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"é":[{"h":[{"e":[{},[0,0,0,1]]}],"n":[{"e":[{},[0,0,0,1,2]]}],"r":[{".":[{},[0,0,2,1]]}]}],"h":[{},[0,0,2,3]],"i":[{"l":[{"l":[{},[0,0,2,1]]}],"m":[{},[0,0,2]],"p":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1,2]]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1,2]],"ő":[{},[0,0,2]],"s":[{"a":[{"n":[{},[0,0,0,0,1]]}],"á":[{"s":[{},[0,0,0,3]]}],"e":[{"b":[{},[0,0,2,3]],"s":[{},[0,0,0,0,1]]}],"p":[{"o":[{},[0,0,0,3]]}],"z":[{"a":[{},[0,0,0,3]]}]}],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"e":[{"d":[{"é":[{},[0,0,1]]},[0,0,0,2]],"f":[{},[0,2,1]],"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"m":[{"b":[{},[0,0,1]],"i":[{},[0,0,1,2]],"l":[{},[0,0,1]],"u":[{},[0,0,1,2]]}],"n":[{},[0,2,1]],"p":[{},[0,2,1,2]],"s":[{},[0,0,1]],"t":[{},[0,2,1,2]],"u":[{},[0,0,1,2]],"x":[{},[0,2,1]],"z":[{},[0,0,1]]}],"é":[{"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"k":[{".":[{},[0,2,1]],"n":[{},[0,2,1]],"s":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"n":[{"e":[{},[0,2,1,2]]}],"p":[{"í":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"r":[{".":[{},[0,2,1]],"c":[{},[0,2,1]],"d":[{},[0,2]],"é":[{},[0,2,1]],"l":[{},[0,2,1]]}],"t":[{"e":[{},[0,0,1]]}],"v":[{"a":[{"d":[{},[0,2]]}],"e":[{},[0,2,1]],"é":[{},[0,2,1,2]]}]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"a":[{"b":[{},[0,0,2]],"r":[{},[0,0,2,1,2]]}],"á":[{"r":[{"a":[{},[0,0,2,1]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}],"t":[{},[0,0,2,1]]}],"e":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1]],"s":[{},[0,0,0,0,2]]}],"é":[{"r":[{".":[{},[0,0,2,1]]}],"s":[{},[0,0,2,1,2]]}],"g":[{},[0,0,0,3]],"i":[{"t":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ő":[{"r":[{},[0,0,2]]}],"u":[{"s":[{},[0,0,2,1]]}],"ü":[{},[0,0,2]],"y":[{".":[{},[1]],"a":[{"s":[{},[0,0,2]]}]}]}],"i":[{"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"a":[{},[0,2,1,2]],"é":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1]],"e":[{},[0,0,0,2]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{"d":[{},[0,0,1]],"n":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"r":[{"r":[{},[0,2]],"t":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]],"m":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"t":[{"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2,1,2]],"í":[{},[0,0,0,2,1]],"o":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2,1]]}]}],"z":[{"o":[{},[0,0,1]]}]}],"í":[{"g":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"k":[{"a":[{"j":[{},[0,0,2]],"r":[{"o":[{},[0,0,0,1]]}]}],"e":[{"r":[{"n":[{},[0,0,2]]}]}],"l":[{"i":[{},[0,0,1,2]],"o":[{},[0,0,1,2]],"u":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1,2]]}]}],"n":[{"y":[{"e":[{},[0,0,3]],"í":[{},[0,0,3]],"o":[{},[0,0,3]],"u":[{},[0,0,3]]}]}],"o":[{"b":[{},[0,2,1,2]],"k":[{"i":[{"r":[{},[0,2,1]]}],"t":[{"a":[{},[0,2,1]]}],"u":[{},[0,2,1,2]]}],"l":[{"d":[{},[0,0,1]],"i":[{},[0,0,1]]}],"m":[{},[0,3]],"n":[{"i":[{"m":[{},[0,0,0,2,1,2]]}]}],"r":[{},[0,2,1,2]],"s":[{"z":[{"l":[{},[0,0,1]]}]}],"t":[{"t":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"ó":[{"r":[{"i":[{},[0,0,1]]}]}],"ö":[{"k":[{},[0,0,1]],"l":[{},[0,2,1]],"m":[{},[0,0,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{"ö":[{},[0,0,1]]}]}],"ő":[{"r":[{},[0,2,1]],"s":[{},[0,0,1,2]],"z":[{},[0,2,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"e":[{"s":[{},[0,0,2]]}],"é":[{"r":[{},[0,0,2,1]]}],"i":[{"s":[{},[0,0,2]],"z":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,1,2]],"i":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1]]},[0,0,0,0,2]],"ü":[{"l":[{"d":[{},[0,0,0,1]]}]}],"z":[{"l":[{},[0,0,1]]}]}],"t":[{"a":[{"c":[{"é":[{},[0,0,0,1]]}],"n":[{"y":[{},[0,0,0,1,2]]}],"z":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2,1,2]],"p":[{},[0,0,0,0,2]],"r":[{"b":[{},[0,0,2,1]],"i":[{},[0,0,2,1]]}]}],"e":[{"d":[{},[0,0,2,1]],"k":[{"é":[{},[0,0,0,1]]}],"l":[{"h":[{},[0,0,0,1]]}],"z":[{},[0,0,2]]}],"é":[{"k":[{"e":[{},[0,0,0,1]]}],"r":[{"t":[{"e":[{},[0,0,2]]}]}]}],"i":[{"d":[{},[0,0,2]],"p":[{"a":[{},[0,0,2,1]]}],"s":[{"t":[{},[0,0,0,1]]}],"z":[{},[0,0,2,1]]}],"í":[{"v":[{},[0,0,2,1]]}],"ö":[{"k":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"r":[{"a":[{"k":[{},[0,0,1,2]],"n":[{},[0,0,1]]}]}],"ü":[{"l":[{},[0,0,2,1,2]]}]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"r":[{},[0,0,1]],"t":[{"j":[{},[0,0,1]],"o":[{},[0,2,1]],"t":[{},[0,0,1]]},[0,0,0,2]]}],"ü":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"ű":[{"z":[{},[0,0,1]]}],"y":[{"a":[{"d":[{"á":[{"s":[{},[0,0,0,1]]}],"ó":[{},[0,0,0,1,2]]}],"g":[{"g":[{},[0,0,0,1]]}],"k":[{"c":[{},[0,0,0,1]]}],"l":[{"a":[{"p":[{},[0,0,0,1]]}],"k":[{},[0,0,0,1]],"l":[{},[0,0,0,1]]}],"n":[{"y":[{"a":[{},[0,0,0,1]],"á":[{},[0,0,0,1]]}]}],"p":[{"á":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,0,0,1]],"á":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"s":[{"s":[{"z":[{},[0,0,0,1]]}],"z":[{"t":[{},[0,0,0,1]]}]}]}],"á":[{"l":[{},[0,2,0,1,2]],"r":[{"a":[{"s":[{},[0,0,0,1,2]]}],"á":[{},[0,2,0,1,2]],"b":[{},[0,2,0,1]],"c":[{},[0,0,0,1]],"f":[{},[0,2,0,1]],"h":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"n":[{},[0,2,0,1]],"o":[{},[0,2,0,1,2]],"r":[{},[0,2,0,1]],"s":[{},[0,2,0,1]],"t":[{},[0,2,0,1]],"u":[{},[0,0,0,1]],"ú":[{},[0,0,0,1]]}],"t":[{"l":[{},[0,2,0,1]]}],"z":[{},[0,2,0,1,2]]}],"e":[{"d":[{},[0,0,0,1]],"g":[{"y":[{"e":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]},[0,2,0,1,2]],"l":[{"e":[{},[0,0,0,0,2]]},[0,0,0,1]],"m":[{},[0,2,0,1,2]],"n":[{},[0,0,0,1]],"p":[{},[0,2,0,1]],"s":[{"ő":[{},[0,0,0,1]]}],"t":[{},[0,0,0,1]],"v":[{},[0,0,0,1,2]]}],"é":[{"d":[{},[0,2,0,1]],"g":[{},[0,2,0,1]],"h":[{"e":[{},[0,2]]}],"j":[{},[0,2,0,1,2]],"k":[{},[0,2,0,1,2]],"l":[{},[0,2,0,1]],"n":[{"e":[{},[0,2,0,1,2]]}],"r":[{"c":[{".":[{},[0,0,0,1]]}],"r":[{"e":[{},[0,0,0,1]]}],"t":[{"e":[{},[0,2,0,1]],"é":[{},[0,2,0,1]]}],"ü":[{},[0,0,0,0,2,1]],"v":[{"é":[{},[0,0,0,1]]}]}],"s":[{},[0,2,0,1]],"t":[{"e":[{},[0,2]],"k":[{},[0,2]],"t":[{},[0,2,0,1]]}],"v":[{"e":[{},[0,2]]}]}],"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"i":[{"d":[{},[0,2,0,1]],"g":[{"é":[{},[0,2]]}],"k":[{"e":[{},[0,2]],"r":[{},[0,2,0,1]]}],"r":[{"a":[{"t":[{},[0,2]]}],"o":[{},[0,2]]}],"s":[{"k":[{},[0,2]],"z":[{},[0,2,0,1]]}],"t":[{"a":[{},[0,2]]}]}],"í":[{"r":[{"ó":[{},[0,0,0,1,2]]}]}],"o":[{"m":[{"l":[{},[0,2,0,1]]}],"n":[{"t":[{},[0,2,0,1]]}],"r":[{},[0,2,0,1,2]],"s":[{"z":[{},[0,2]]}]}],"ö":[{"k":[{},[0,0,0,1]],"r":[{},[0,0,0,1,2]],"s":[{},[0,2,0,1]],"z":[{},[0,0,0,1]]}],"ő":[{},[0,2,0,1,2]],"t":[{"r":[{},[0,0,0,1]]}],"u":[{"g":[{},[0,2]],"r":[{},[0,2,0,1]],"t":[{},[0,0,0,1]]}],"ú":[{"t":[{"o":[{},[0,2]]}]}],"ü":[{},[0,2,0,1,2]],"ű":[{},[0,2,0,1,2]]}],"z":[{"á":[{"l":[{},[0,0,2]]}]}]}],"o":[{"c":[{"s":[{},[0,0,2]]}],"k":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]]}],"m":[{"o":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]]}],"s":[{"o":[{},[0,0,2]],"z":[{"a":[{"n":[{},[0,0,2]]}],"e":[{},[0,0,2,0,1]],"i":[{"s":[{},[0,0,2]],"v":[{},[0,0,2]]}],"ú":[{},[0,0,2]]}]}]},[0,1]],"ó":[{"h":[{"a":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]]}]},[0,1]],"ö":[{"l":[{"e":[{},[0,0,2]]}],"m":[{"ö":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}]},[0,1]],"ő":[{"s":[{"z":[{},[0,0,2]]}]},[0,1]],"p":[{"a":[{"d":[{"o":[{"t":[{},[0,2,1,2]]}]}],"t":[{"r":[{},[0,0,0,1]]}],"u":[{},[0,0,0,3,2]]}],"á":[{"g":[{},[0,2,1]],"l":[{"l":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]],"n":[{},[0,0,0,2]],"s":[{},[0,2,1,2]],"t":[{},[0,0,1,2]]}],"é":[{"g":[{},[0,2,1]],"t":[{"e":[{},[0,0,1,2]]}]}],"i":[{"a":[{"c":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"m":[{},[0,2,1]],"n":[{"j":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{},[0,2,1]]},[0,0,0,2]]}],"í":[{"n":[{},[0,2,1]]}],"o":[{"l":[{"l":[{},[0,2]]}],"r":[{"e":[{},[0,0,0,2,1]]}]}],"ő":[{"r":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"g":[{},[0,2,1]],"t":[{},[0,2,1,2]]}],"ú":[{"r":[{},[0,2,1]]}],"ü":[{"g":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"r":[{"a":[{"b":[{"l":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]]}],"d":[{"a":[{"g":[{},[0,0,1]],"t":[{"a":[{},[0,2]],"á":[{},[0,2]],"b":[{},[0,2]],"é":[{},[1]],"n":[{},[0,2]],"o":[{},[0,2]],"r":[{},[1,2]],"t":[{},[0,2]]}]}]}],"g":[{"á":[{},[0,0,1,2]]}],"j":[{"k":[{},[0,2,1]]}],"k":[{"a":[{"d":[{},[0,2,1,2]],"s":[{},[0,2,1,2]]}],"c":[{},[0,2,1]],"n":[{"a":[{".":[{},[0,2,1]]}],"á":[{"t":[{},[0,2]]}]}],"t":[{".":[{},[0,2,1]],"i":[{},[0,0,1]],"í":[{},[0,0,1]]}]}],"l":[{"á":[{},[0,0,1]],"j":[{".":[{},[0,2,1]],"a":[{".":[{},[0,2,1]],"k":[{},[0,2]]}],"á":[{},[0,2,1]]}],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,2,1]],"t":[{},[0,0,1]],"v":[{},[0,2,1]]}],"m":[{"a":[{".":[{},[1,2]],"i":[{},[1]]}],"á":[{"l":[{},[0,0,0,2]]},[1,2]],"e":[{"l":[{},[0,0,0,2,1]]}],"é":[{"r":[{"t":[{"é":[{},[0,0,0,2,1]]}]}]}],"i":[{"n":[{},[0,0,0,2,1]]},[1,2]],"k":[{"ö":[{},[1,2]]}],"o":[{"k":[{},[1,2]],"l":[{},[1,2]],"t":[{},[1,2]]}],"s":[{},[1,2]],"u":[{},[1,2]],"ú":[{},[1,2]]}],"n":[{"a":[{},[0,0,1]],"g":[{},[0,0,1]],"o":[{},[0,0,1,2]],"t":[{},[0,2,1]]}],"p":[{"á":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"r":[{"á":[{},[0,2,1,2]],"c":[{},[0,2,1]],"i":[{},[0,0,1,2]]}],"s":[{"p":[{},[0,2,1]]}],"t":[{"a":[{"j":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]]}],"i":[{"n":[{"f":[{},[0,0,0,2,1]]}]}],"l":[{"é":[{},[0,0,1]]}],"ü":[{},[0,0,0,2,1,2]],"y":[{},[0,0,1]]}]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"c":[{},[0,0,0,2]],"g":[{"a":[{},[0,0,1]],"r":[{},[0,0,1]],"y":[{},[0,0,1]]},[0,0,0,2]],"l":[{"o":[{},[0,0,1,2]]}],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,0,1]],"a":[{"k":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"b":[{},[0,2,1]],"f":[{},[0,2,1]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1]],"v":[{},[0,0,1]]}],"s":[{"á":[{"s":[{},[0,2,1]]}],"z":[{"ó":[{},[0,0,0,2]]}]}],"t":[{"a":[{"d":[{},[0,0,0,0,1,2]]},[0,2,1,2]],"á":[{},[0,2,1]],"b":[{},[0,0,1]],"c":[{},[0,2,1]],"d":[{},[0,2,1]],"e":[{},[0,0,1,2,1,2]],"é":[{},[0,2,1]],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"ö":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"ú":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"o":[{"c":[{},[1]]}],"r":[{},[0,0,1]]}],"d":[{"á":[{"l":[{},[0,0,2,1]]}],"e":[{"l":[{"l":[{},[0,0,0,1]]}],"m":[{"e":[{},[0,0,0,1]]}]}],"é":[{"n":[{},[0,0,2,1,2]]}],"ő":[{"r":[{},[0,0,2,1]]}],"r":[{"á":[{},[0,0,1]]}],"u":[{"d":[{},[0,0,2]]}]}],"e":[{"á":[{},[0,0,0,2]],"d":[{},[0,0,1,2]],"g":[{},[0,2,1,2]],"j":[{},[0,0,1]],"l":[{"ő":[{"i":[{"r":[{},[0,0,0,0,0,0,3]]}]}]},[0,2,1,2]],"m":[{"a":[{},[0,0,0,2]],"é":[{"l":[{},[0,0,0,2]]}]}],"n":[{"e":[{},[0,0,1]],"g":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{"é":[{},[0,0,1,2]],"ő":[{},[0,0,1,2]]}],"v":[{"é":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"é":[{"b":[{"r":[{},[0,0,1]]}],"d":[{"e":[{},[0,0,1]]}],"g":[{},[0,2,1,2]],"j":[{".":[{},[0,0,1]],"e":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"k":[{"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"s":[{},[0,2,1]]}],"l":[{},[0,2,1,2]],"n":[{"e":[{},[0,2,1,2]]}],"p":[{},[0,2,1]],"r":[{"é":[{},[0,2,1]],"i":[{},[0,2,1,2]]}],"s":[{"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"t":[{"k":[{},[0,2]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"v":[{".":[{},[0,2,1]],"e":[{"k":[{},[0,0,0,2]]}],"k":[{},[0,2,1]],"r":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"y":[{"á":[{"r":[{"v":[{},[0,0,2]]}]}],"i":[{"r":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]}],"ó":[{},[0,0,2]]}]}],"i":[{"d":[{"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"ő":[{"t":[{"l":[{},[0,3,2,3]]}]}]}],"f":[{"j":[{},[0,0,1]]}],"g":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"e":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,2,1]]}],"m":[{"á":[{},[0,2,1,2]],"b":[{},[0,0,1]],"i":[{},[0,2,1,2]]}],"n":[{"a":[{"s":[{},[0,2]]}],"c":[{},[0,2,1]],"d":[{},[0,2,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"n":[{},[0,0,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"o":[{},[0,2]],"p":[{"a":[{"r":[{"o":[{},[0,2,1,2]]}]}]}],"s":[{"e":[{},[0,0,0,2,1]],"k":[{"o":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,1,2]]}]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{"o":[{},[0,0,1,2]]}]}],"í":[{"r":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"k":[{"a":[{"k":[{},[0,0,0,0,1,2]]}],"á":[{"d":[{"o":[{},[1]]}]}],"l":[{},[0,0,1,2]],"o":[{"k":[{},[1]]}],"r":[{"é":[{},[0,0,1]]}],"v":[{},[0,0,1,2]]}],"n":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"y":[{"a":[{"n":[{"y":[{},[0,0,2,0,1]]},[0,0,0,0,0,2]]}],"e":[{"l":[{"e":[{},[0,0,2,0,1]],"ő":[{},[0,0,2]]},[0,0,0,0,0,2]],"m":[{},[0,0,2]],"s":[{},[0,0,2]]}],"o":[{"k":[{},[0,0,2]],"l":[{},[0,0,2,0,1]],"s":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}],"o":[{"d":[{"v":[{},[0,0,1]]}],"k":[{"á":[{},[0,2,0,2]],"e":[{},[0,0,0,2,1]],"h":[{"a":[{},[0,2]]}],"m":[{},[0,2]],"o":[{"l":[{},[0,0,0,2]],"z":[{},[0,2,1,2]]}],"r":[{"e":[{},[0,2]]}],"s":[{},[1,2]],"t":[{"a":[{},[0,2]]}]}],"l":[{"d":[{"a":[{},[0,2,1]]}]}],"m":[{"a":[{"j":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"á":[{"r":[{},[0,0,0,2]]}],"o":[{"k":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]}]}],"p":[{"t":[{},[0,0,1]]}],"r":[{},[0,2,1,2]],"s":[{"a":[{"s":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]],"t":[{"r":[{},[0,2,1]],"y":[{},[0,2,1]]}]}],"t":[{"t":[{"h":[{},[0,0,1]]}]}],"v":[{},[0,2,1,2]]}],"ó":[{"é":[{"r":[{},[0,0,0,0,2]]}],"n":[{"é":[{"t":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}]}],"p":[{},[0,0,0,1,2]],"r":[{"a":[{"k":[{},[0,2,1,2]]}],"á":[{"k":[{},[0,0,0,2]]}],"i":[{},[0,2,1]]}],"s":[{"k":[{"á":[{},[0,0,0,1]]}],"p":[{},[0,0,0,1,2]]}]}],"ö":[{"b":[{},[0,0,1,2]],"c":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,2,1,2]],"n":[{},[0,2,1]],"r":[{},[0,0,1]],"s":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"p":[{"a":[{".":[{},[1]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"s":[{"a":[{"l":[{"a":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,0,1]]}]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"é":[{"g":[{},[0,0,2,1,2]]}],"i":[{"p":[{},[0,0,2]],"r":[{"á":[{},[0,0,2]]}]}],"o":[{"k":[{"t":[{},[0,0,0,1]]}],"l":[{},[0,0,2,1]]}],"ó":[{"v":[{},[0,0,2]]}],"ö":[{"n":[{},[0,0,2,1]]}],"s":[{},[0,0,0,3]],"t":[{"a":[{"b":[{},[0,0,1,2]]}]}],"u":[{"t":[{},[0,0,2]]}],"z":[{"a":[{"k":[{"é":[{},[0,0,0,0,0,2]]}]}],"e":[{"n":[{"e":[{},[0,0,2,3]]}]}]}]}],"t":[{"a":[{"d":[{"o":[{},[0,0,2]]}],"j":[{},[0,0,2,1]],"l":[{"o":[{},[1]]}],"n":[{"á":[{"s":[{},[0,0,0,0,2,1,2]]}]}],"r":[{"á":[{},[0,0,0,1]],"i":[{"s":[{},[0,0,0,1,2]]}]}],"u":[{},[0,0,0,0,3,2]]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}],"r":[{"n":[{},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"h":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"l":[{},[0,0,0,1]],"n":[{},[0,0,0,1]],"ő":[{},[0,0,2,1]]}],"m":[{"b":[{},[0,0,0,1]]}],"r":[{"k":[{},[0,0,2,1]]}],"s":[{"e":[{},[0,0,0,1]],"t":[{"h":[{},[0,0,0,1]]}]},[0,0,0,0,2]],"t":[{"i":[{},[0,0,0,1]]}]}],"é":[{"l":[{"e":[{},[0,0,0,1]]}],"r":[{"d":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2,1]]}]}]}],"i":[{"d":[{},[0,0,2]],"f":[{},[0,0,2]],"n":[{"s":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"z":[{"g":[{},[0,0,0,1]]}]}],"í":[{"t":[{},[0,0,2]]}],"o":[{"k":[{"t":[{"a":[{},[0,0,2,1]]}]}],"p":[{},[0,0,2]],"t":[{"t":[{"h":[{},[0,0,0,1]]}]}]}],"ö":[{"n":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"u":[{"r":[{"a":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,0,1,2]]}],"t":[{},[0,0,2,1]]}]}],"u":[{".":[{},[1,2]],"a":[{},[1,2]],"á":[{},[0,0,0,0,2]],"b":[{},[1,2,0,1,2]],"c":[{},[1,2]],"d":[{"a":[{},[1]],"á":[{},[1]]},[0,2]],"e":[{},[1,2]],"é":[{},[1,2]],"f":[{},[1,2]],"g":[{"y":[{},[1]]}],"i":[{},[1,2]],"j":[{"á":[{},[1]]},[0,2]],"m":[{},[1,2]],"n":[{".":[{},[1,2]],"a":[{},[1,2]],"á":[{},[1,2]],"d":[{},[0,2,1]],"i":[{},[0,2]]}],"o":[{},[1,2]],"p":[{},[1,2,0,1,2]],"r":[{"a":[{".":[{},[1]]}],"á":[{},[0,0,1]]},[0,2]],"s":[{"s":[{},[0,0,0,0,3]]},[1,2]],"t":[{".":[{},[1]],"a":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"e":[{},[1]],"r":[{},[0,0,0,1]],"u":[{"n":[{},[0,0,0,2]]}]},[0,2]],"ü":[{},[1,2]],"v":[{},[1,2]],"z":[{},[0,0,1,2]]}],"ú":[{"é":[{},[1,2]],"k":[{},[1,2]],"r":[{"é":[{},[0,0,1]],"f":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1]]}],"t":[{"a":[{},[0,2,1]],"b":[{},[0,2,1]],"é":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"j":[{},[0,2,1]],"l":[{},[0,0,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}]}],"ü":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"ű":[{"r":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"v":[{"á":[{"c":[{},[1]]}]}]}],"s":[{"a":[{"b":[{"l":[{},[0,2,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"d":[{"a":[{"t":[{},[0,0,1,2]]}],"á":[{},[0,2,1,2]],"o":[{},[0,0,1,2]],"ó":[{},[0,2,1,2]]}],"j":[{"á":[{},[0,2,1,2]],"t":[{"ó":[{},[0,0,1]]}]}],"k":[{"a":[{"r":[{},[0,2,1,2]]}],"c":[{},[0,2,1]],"v":[{},[0,2,1]]}],"l":[{"a":[{},[0,0,1,2]],"g":[{},[0,0,1]],"i":[{},[0,0,1,2]],"j":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"t":[{},[0,2,1]]}],"m":[{"b":[{},[0,2,1]]}],"n":[{"a":[{},[0,2,1]],"ó":[{},[0,2,1]],"t":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"p":[{"á":[{},[0,0,1,2]],"p":[{},[0,0,1]],"u":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1,2]],"á":[{"n":[{},[0,0,1,2]]}],"c":[{},[0,2,1]],"é":[{},[0,2,1]],"i":[{},[0,2,1,2]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"s":[{},[0,2]]}],"t":[{"á":[{},[1,2]],"l":[{},[0,2,1]],"o":[{},[0,2]],"y":[{},[0,0,1]]}],"u":[{},[0,2,1,2]],"z":[{"o":[{},[0,2,1]]}]}],"á":[{"b":[{"é":[{},[0,2]],"r":[{},[0,2,1]]}],"g":[{"a":[{"i":[{},[0,0,0,2]]}],"b":[{},[0,2,1]],"i":[{"g":[{},[0,2,1,2]]}],"k":[{},[0,2,1]],"n":[{},[0,0,1]],"ú":[{},[0,2,1,2]]}],"l":[{},[0,2,1]],"p":[{},[0,2,1,2]],"r":[{"a":[{"s":[{},[0,0,1]]}],"é":[{"t":[{},[0,0,0,2]]}],"ó":[{"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"s":[{"b":[{},[1,2]],"i":[{},[1,2]],"k":[{},[1]],"v":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1,2]],"á":[{},[0,2,1]],"é":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1]],"j":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"s":[{"a":[{"p":[{"á":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"b":[{},[0,0,1,2]],"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"y":[{},[0,0,1,2]]}],"l":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"p":[{"i":[{},[0,0,1]]}],"r":[{"k":[{},[0,0,1]],"ő":[{},[0,0,1]]}],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"v":[{},[0,0,1,2]],"x":[{},[0,0,1]],"z":[{},[0,0,1]]}],"é":[{"g":[{},[0,2,1,2]],"h":[{"e":[{},[0,2,1]]}],"j":[{},[0,2,1]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{"e":[{},[0,2,1,2]]}],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"d":[{},[0,2,1]],"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"l":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"s":[{},[0,2,1,2]],"t":[{"e":[{},[0,2,1,2]],"k":[{},[0,0,1]],"t":[{},[0,0,1]]}],"v":[{"e":[{},[0,2,1,2]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]},[0,0,0,2]],"k":[{"e":[{},[0,0,0,2,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"á":[{},[0,2,1]],"p":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]],"f":[{},[0,0,1]],"g":[{},[0,2,1]],"i":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"r":[{"a":[{"t":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"o":[{},[0,0,1]],"t":[{},[0,0,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"í":[{"g":[{},[0,0,1]],"j":[{},[0,2,1]],"n":[{"s":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1]],"ó":[{},[0,0,1]]},[0,0,0,2]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"n":[{"u":[{},[1]]}],"o":[{"b":[{},[0,2,1]],"d":[{"a":[{"l":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]],"u":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{"l":[{},[0,0,0,2,1]]}]}],"k":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]]}]}],"l":[{"d":[{"ó":[{},[0,0,1]]}],"i":[{},[0,0,1]]}],"n":[{"t":[{},[0,2,1]]}],"p":[{},[0,2,1]],"r":[{"á":[{},[0,0,1,2]],"g":[{},[0,2,1]],"i":[{},[0,2]],"k":[{},[0,2,1]],"r":[{},[0,0,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"s":[{"z":[{},[0,0,1]]}],"v":[{},[0,2,1,2]]}],"ó":[{"b":[{},[1,2]],"é":[{},[1,2]],"g":[{},[1,2]],"i":[{},[1,2]],"j":[{},[1,2]],"k":[{},[1,2]],"n":[{},[1,2]],"p":[{},[0,0,0,1,2]],"r":[{"á":[{},[0,0,1,2]],"i":[{},[0,0,1]],"ó":[{},[1]]},[0,2]],"s":[{"á":[{},[0,0,1,2]]},[0,2]],"t":[{},[1,2]],"v":[{},[0,2]]}],"ö":[{"k":[{},[0,2,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1]],"v":[{},[0,0,1,2]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"p":[{"i":[{"c":[{},[0,1]]}],"l":[{},[0,0,1,2]],"ó":[{"r":[{},[0,1,2]]}],"r":[{},[0,0,0,2]],"s":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]],"z":[{"a":[{"b":[{},[0,0,3]],"g":[{},[0,0,3]],"k":[{"a":[{},[0,0,3]],"é":[{},[0,0,3]]}]}],"á":[{"j":[{},[0,0,3]],"m":[{},[0,0,3]],"z":[{},[0,0,3]]}],"e":[{},[0,0,3]],"é":[{"l":[{},[0,0,3]]}],"f":[{},[0,0,3]],"i":[{},[0,0,3]],"í":[{},[0,0,3]],"k":[{},[0,0,3]],"o":[{"c":[{},[0,0,3]],"k":[{},[0,0,3]],"l":[{},[0,0,3]],"r":[{},[0,0,3]]}],"ó":[{},[0,0,3]],"ö":[{},[0,0,3]],"t":[{},[0,0,3]],"ú":[{},[0,0,3]],"ű":[{},[0,0,3]]},[0,0,0,0,2]]}],"t":[{"e":[{"g":[{},[0,0,2]],"l":[{"e":[{"m":[{},[0,0,0,1]]}]}]}],"i":[{"r":[{},[0,0,2]]}],"ö":[{"s":[{},[0,0,2,1]]}],"r":[{"e":[{},[0,0,1,2]],"i":[{},[0,0,1]],"ó":[{"f":[{},[0,0,1]]}]}]}],"u":[{"d":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1,2]],"t":[{"a":[{},[0,0,1]],"á":[{},[0,2,1]],"ó":[{},[0,0,1]]},[0,0,0,2]],"z":[{},[0,2,1,2]]}],"ú":[{"r":[{".":[{},[0,0,1]],"n":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1,2]]}],"t":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"ü":[{"d":[{},[0,0,1]],"g":[{},[0,2,1]],"l":[{"d":[{},[0,0,1]],"e":[{},[0,0,1]]}],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"v":[{"e":[{},[0,0,1,2]]}],"z":[{},[0,2,1]]}],"ű":[{"r":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"z":[{"a":[{"c":[{},[0,2,3]],"d":[{},[0,2,0,1,2]],"g":[{"a":[{},[0,0,0,1]],"á":[{},[0,0,0,1]],"y":[{},[0,2,0,1]]}],"j":[{},[0,2]],"k":[{"c":[{},[0,2,0,1]],"o":[{"l":[{},[0,0,0,1,2]]}],"t":[{},[0,2,0,1]]}],"l":[{"e":[{},[0,0,0,1]],"k":[{},[0,2,0,1]]}],"n":[{"a":[{},[0,2]],"t":[{},[0,2,0,1]],"y":[{},[0,2,0,1]]},[0,0,0,0,2]],"p":[{},[0,2,0,1]],"s":[{"z":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"e":[{},[0,0,0,0,2,1]]}],"u":[{},[0,2,0,1]],"v":[{"a":[{"r":[{},[0,0,3]]}]}]}],"á":[{"g":[{"g":[{},[0,0,0,1]],"y":[{},[0,0,0,1]]}],"l":[{"o":[{},[0,0,0,1,2]]}],"p":[{},[0,0,3]],"r":[{"a":[{"s":[{},[0,0,0,0,2,1]]}],"i":[{"h":[{},[0,0,0,1,2]]}],"ú":[{},[0,2,0,1,2]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}],"t":[{"a":[{},[0,2]]}],"z":[{},[0,2,0,1]]}],"e":[{"b":[{"é":[{"d":[{"e":[{},[0,0,0,0,0,1]]}]},[0,0,0,0,0,0,2]]},[0,0,0,1,2]],"g":[{"é":[{},[0,0,0,1,2]],"y":[{},[0,0,0,1,2]]}],"l":[{"n":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]}],"m":[{"b":[{},[0,0,0,1]]}],"n":[{"e":[{},[0,0,3]],"é":[{},[0,0,3]],"g":[{},[0,0,0,1]]}],"p":[{},[0,0,0,1,2]],"r":[{"d":[{},[0,2,0,1]],"é":[{},[0,2,0,1,2]]}],"s":[{},[0,2,0,1,2]],"t":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]],"x":[{},[0,0,0,1]]}],"é":[{"j":[{},[0,2,0,1]],"k":[{"b":[{},[0,2,0,1]]}],"l":[{},[0,2,0,1,2]],"n":[{"e":[{},[0,2,0,1,2]]}],"p":[{},[0,2,0,1]],"r":[{"é":[{},[0,0,0,1]]}],"t":[{"e":[{},[0,2,0,1]],"t":[{},[0,2,0,1]]}],"v":[{"e":[{},[0,2,0,1]]}]}],"i":[{"d":[{},[0,2]],"f":[{},[0,2]],"l":[{"l":[{},[0,2,0,1]]}],"n":[{"d":[{},[0,2]],"g":[{},[0,0,0,1]]}],"p":[{"a":[{},[0,2,0,1]]},[0,0,0,0,2]],"r":[{"o":[{},[0,2]]}],"s":[{"k":[{},[0,2,0,1]],"m":[{},[0,2,0,1]],"t":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,0,0,1]]}],"z":[{},[0,2]]}],"í":[{"r":[{},[0,2]]}],"k":[{"á":[{"i":[{},[1]]}]},[0,0,0,1,2]],"o":[{"k":[{"l":[{},[0,2]],"m":[{},[0,2,0,1]]}],"r":[{"s":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,2,0,1]]}]}],"ó":[{"s":[{"p":[{},[0,0,0,0,1,2]]}]}],"ö":[{"b":[{},[0,2,0,1,2]],"l":[{"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,2,0,1,2]],"s":[{},[0,2,0,1]],"v":[{"é":[{},[0,0,0,1]]}]}],"ő":[{"r":[{},[0,0,0,1]],"s":[{},[0,0,0,1,2]]}],"s":[{"a":[{},[0,0,0,3]],"u":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"n":[{"i":[{},[0,2]]}],"r":[{},[0,2]],"t":[{},[0,2]]}],"ú":[{"s":[{},[0,0,0,1,2]]}],"ü":[{"g":[{},[0,2,0,1,2]],"n":[{},[0,2,0,1]],"z":[{},[0,2,0,1,2]]}],"z":[{},[0,0,0,1]]}]}],"t":[{"a":[{"b":[{"r":[{},[0,0,1]]}],"j":[{"á":[{},[0,0,1,2]],"k":[{},[0,0,1]],"t":[{},[0,0,1]]}],"k":[{"r":[{"é":[{},[0,0,0,1]]}],"t":[{".":[{},[0,2,1]],"o":[{},[0,2,1]]}]}],"l":[{"h":[{},[0,0,1]],"j":[{"a":[{},[0,2,1]]}],"m":[{},[0,2,1]],"s":[{},[0,0,1]],"u":[{},[0,0,1,2]],"v":[{"á":[{},[0,0,1]]}]}],"r":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1]],"c":[{},[0,2,1]],"z":[{},[0,0,1]]}],"s":[{"á":[{},[0,0,0,2]]}],"u":[{"t":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"c":[{},[0,0,0,2]],"g":[{".":[{},[0,0,1]]}],"l":[{},[0,0,1]],"p":[{"o":[{},[0,0,1]]},[0,0,0,2]],"r":[{"a":[{"d":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"m":[{},[0,0,1]]}],"á":[{},[0,2,1,2]],"b":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]],"t":[{},[0,2,1]],"u":[{},[0,2,1,2]]}],"s":[{"á":[{"s":[{},[1,2,1]]}],"z":[{},[0,0,0,2,3]]}],"t":[{"f":[{},[0,2,1]],"u":[{},[0,2,1]],"v":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"u":[{},[1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"c":[{},[0,0,1,2]],"j":[{},[0,0,1]],"l":[{"l":[{},[0,0,1]],"n":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,2,1]],"l":[{},[0,0,1]]}],"n":[{"g":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,0,2]],"i":[{"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"ő":[{},[0,0,1]]}],"x":[{},[0,0,1]]}],"é":[{"d":[{},[0,0,1,2]],"e":[{},[0,0,0,0,2]],"g":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]]},[0,0,0,2]],"k":[{"a":[{"j":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1,2]],"s":[{},[0,0,0,2]]}],"e":[{"m":[{},[0,0,0,0,1]],"s":[{},[0,0,0,0,1]]},[0,0,0,2]],"o":[{"l":[{},[0,0,0,2]]}],"ü":[{},[0,0,0,2,1]]}],"l":[{},[0,0,1,2]],"p":[{},[0,0,0,2]],"r":[{"b":[{},[0,2,1]],"i":[{},[0,2,1,2]],"r":[{},[0,2,1]],"z":[{},[0,2,1]]}],"t":[{"á":[{},[0,0,0,2,1,2]]}]}],"f":[{"é":[{"s":[{},[1]]}],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"i":[{".":[{},[0,0,2]],"a":[{},[0,0,2]],"d":[{},[1]]}]}],"i":[{"a":[{"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"d":[{},[0,0,0,2]],"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,0,1]]}],"n":[{"g":[{},[0,2,1]]}],"p":[{"a":[{},[0,0,1,2]]}],"r":[{"á":[{},[0,2,1]]}],"s":[{"k":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{"é":[{},[0,2,1]],"m":[{},[0,2,1]],"o":[{},[0,2,1,2]]}]}],"í":[{"g":[{},[0,0,1]],"r":[{},[0,2,1,2]],"v":[{},[0,0,1,2]]}],"k":[{"e":[{"l":[{},[1]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"l":[{"e":[{"g":[{"e":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,2,1]]}]}],"m":[{"ű":[{"t":[{"r":[{},[0,0,0,0,0,2]]}]}]}],"o":[{"j":[{},[0,0,1]],"k":[{"o":[{"l":[{".":[{},[0,0,1]]},[0,0,0,2]],"z":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,0,1]]}]}],"l":[{"j":[{},[2]],"t":[{},[2]]}],"m":[{"l":[{},[0,0,1]]}],"n":[{"t":[{},[0,0,1]]}],"p":[{},[0,0,1]],"r":[{"a":[{"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"á":[{"c":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"i":[{"s":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2,1]]}],"z":[{"á":[{},[0,0,1]]}]}],"x":[{},[0,2,1,2]]}],"ó":[{"i":[{"k":[{"o":[{},[0,0,0,0,2]]}]}],"p":[{},[0,0,0,1,2]],"r":[{"i":[{},[0,0,1]]}]}],"ö":[{"b":[{},[0,0,1]],"l":[{"é":[{},[0,0,1]]},[0,0,0,2]],"m":[{"l":[{},[0,0,1]]}],"n":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,2,1,2]],"z":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"i":[{"l":[{},[0,0,2]]}]}],"s":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{"ű":[{},[1]]}]}],"t":[{"e":[{"k":[{"i":[{},[1]]}]}],"é":[{},[0,0,3,2]],"r":[{},[0,0,1,2]]}],"u":[{"d":[{"v":[{},[0,2,1]]}],"g":[{},[0,2,1]],"h":[{},[0,2,1]],"j":[{},[0,2,1]],"m":[{"i":[{"n":[{},[0,0,0,2]]}]}],"n":[{},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{"z":[{"e":[{},[0,0,0,2]]}]}],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,0,1]],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,0,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1]]}],"s":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,2,1]],"l":[{},[0,0,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"ű":[{"r":[{},[0,0,1]]}],"v":[{"á":[{"r":[{},[1]]}],"e":[{"v":[{},[1]]}]}]}],"u":[{"g":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]]}],"n":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}]},[0,1]],"ú":[{"s":[{"z":[{},[0,0,2]]}]},[0,1]],"ü":[{"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"í":[{},[0,0,2]]}],"t":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"v":[{"ö":[{},[0,0,2]]}]},[0,1]],"ű":[{},[0,1]],"v":[{"a":[{"d":[{"m":[{},[0,0,1]]}],"j":[{"k":[{},[0,2,1]]}],"k":[{"t":[{},[0,0,1]]}],"l":[{"k":[{},[0,0,1]],"t":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,0,1]],"z":[{},[0,0,0,1,0,2]]}],"t":[{},[0,0,0,1,2]],"u":[{},[0,2,1]],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"l":[{"s":[{},[0,0,1]]}],"t":[{"e":[{},[0,0,1]],"f":[{},[0,0,1]],"h":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"u":[{},[0,2,1]]}]}],"e":[{"g":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"l":[{"é":[{},[0,0,0,0,1]]},[0,2,1,2]]}],"é":[{"d":[{"e":[{},[0,0,1,2]],"r":[{},[0,0,0,1]]}],"r":[{"i":[{},[0,2,1,2]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]]}],"n":[{"d":[{},[0,0,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]]}],"r":[{"á":[{},[0,2,1,2]],"o":[{},[0,2,1]]}],"s":[{"i":[{},[0,2,1,2]],"k":[{},[0,0,1]],"m":[{},[0,0,1]]}],"z":[{"m":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"í":[{"r":[{},[0,0,1]]}],"o":[{"b":[{},[0,2,1]],"l":[{"v":[{},[0,2,1]]}],"p":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"r":[{"á":[{},[0,0,1]]}]}],"ö":[{"r":[{},[0,0,1]],"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"g":[{},[0,2,1]],"r":[{},[0,2,1]]}],"ú":[{"s":[{"z":[{},[0,2,1,2]]}],"t":[{"i":[{},[0,2,1]],"o":[{},[0,2,1]]},[0,0,0,2]]}],"ü":[{"g":[{},[0,0,1]],"z":[{},[0,0,1,2]]}]}],"z":[{"a":[{"b":[{"l":[{},[0,2,1]],"s":[{},[0,0,1]]}],"d":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"o":[{"t":[{"t":[{},[0,0,0,2]]}]}],"ü":[{},[0,0,0,2]]}],"j":[{"t":[{},[0,0,1]]}],"k":[{"c":[{},[0,0,1]],"ó":[{},[0,2,1,2]],"t":[{".":[{},[0,2,1]],"a":[{},[0,2,1]],"á":[{},[0,0,1]],"u":[{},[0,2,1]]}]}],"l":[{"a":[{"p":[{},[0,0,1,2]]}],"e":[{},[0,2,1,2]],"k":[{},[0,2,1]]}],"n":[{"a":[{},[0,2,1]],"o":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,0,1,2]],"c":[{},[0,0,1]],"m":[{},[0,0,1]]}],"s":[{"s":[{"z":[{},[0,2,1]]}],"z":[{"t":[{},[0,2,1]]}]}],"t":[{"a":[{"l":[{},[0,0,0,2,1,2]],"n":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"é":[{"r":[{".":[{},[0,0,0,2,1]],"v":[{},[0,0,0,2,1]]}],"s":[{},[0,0,0,2]]}],"i":[{"k":[{},[0,0,0,2]]}],"í":[{},[0,0,0,2]],"y":[{},[0,0,1]]}],"u":[{},[0,2,1,2]]}],"á":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"r":[{"a":[{"i":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"á":[{"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"b":[{},[0,2,1]],"c":[{},[0,2,1]],"d":[{},[0,2,1]],"é":[{},[0,2,1,2]],"f":[{},[0,0,1]],"i":[{},[0,2,1,2]],"j":[{"á":[{"b":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"k":[{"a":[{},[0,2,1]]}],"o":[{"k":[{"k":[{},[0,2,1,2]],"r":[{},[0,2,1,2]]}]}],"p":[{},[0,2,1]],"r":[{"á":[{},[0,2,1]]}],"u":[{"n":[{"k":[{"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}]}],"s":[{".":[{},[0,0,0,3]]}]}]}],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2,1]],"b":[{},[0,0,1]],"e":[{},[0,2,1,2,1,2]],"é":[{},[0,2,1]],"h":[{},[0,0,1]],"r":[{},[0,2,1]],"s":[{},[0,0,1]],"ü":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"f":[{},[0,0,1]],"g":[{},[0,0,1,2]],"m":[{},[0,0,1,2]],"p":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"x":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"é":[{"g":[{},[0,2,1]],"l":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"ő":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"t":[{"e":[{},[0,2,1,2]]}],"v":[{"e":[{},[0,2,1]],"i":[{},[0,0,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"é":[{},[0,2,1]]}],"k":[{"o":[{"n":[{},[0,2,1,2]]}]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"á":[{},[0,2,1]],"i":[{},[0,2,1]],"p":[{},[0,0,1]]}],"n":[{"f":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{"a":[{"r":[{},[0,2,1,2]]}]}],"r":[{"á":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,0,2,1]],"i":[{"r":[{},[0,0,0,2]]}],"í":[{},[0,0,0,2,1,2]],"s":[{},[0,0,0,0,3]],"ü":[{},[0,0,0,2,1]],"z":[{"ó":[{},[0,0,0,2]]}]}],"z":[{"m":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]]}],"í":[{"j":[{},[0,0,1]],"v":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"o":[{"l":[{"d":[{"a":[{},[0,2,1]]}],"t":[{"a":[{"l":[{},[0,2]]}],"ó":[{},[0,2,1]]}]}],"m":[{"l":[{},[0,0,1]]}],"n":[{"t":[{},[0,2,1]]}],"r":[{},[0,2,1,2]],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"i":[{"k":[{"o":[{},[0,0,0,0,2]]}]}],"l":[{".":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1,2]],"i":[{},[0,2,1]]}],"s":[{"p":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1]]}]}],"ö":[{"b":[{},[0,0,1]],"d":[{},[0,0,1]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"s":[{"a":[{"b":[{},[0,2]],"d":[{},[0,2,0,1,2]],"g":[{},[0,2,0,1,2]],"j":[{"t":[{},[0,0,0,1]]}],"k":[{"n":[{},[0,2,0,1]]}],"l":[{"a":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"l":[{},[0,0,0,1]]}],"m":[{"u":[{},[0,2,0,1]]}],"n":[{"y":[{},[0,0,0,1]]}],"r":[{"á":[{},[0,0,0,1]]},[0,2]],"t":[{},[0,2]],"u":[{},[0,2,0,1]]}],"á":[{"l":[{"l":[{},[0,2,0,1]]}],"r":[{".":[{},[0,2,3]]}]}],"e":[{"b":[{},[0,0,3]],"c":[{},[0,0,0,1,2]],"f":[{},[0,0,0,1]],"g":[{},[0,0,0,1]],"l":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1]]},[0,2]],"é":[{"j":[{},[0,2]],"k":[{},[0,2,0,1,2]],"n":[{"e":[{},[0,0,0,1]]}],"r":[{"e":[{},[0,2,0,1]],"i":[{},[0,2,0,1]]}],"t":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{"a":[{},[0,2]],"á":[{},[0,2]],"d":[{"e":[{},[0,2]]}],"g":[{"a":[{},[0,2,0,1]],"á":[{},[0,0,0,1]],"e":[{},[0,2]]},[0,0,0,0,2]],"m":[{"m":[{},[0,2]]}],"n":[{"g":[{},[0,2,0,1]],"t":[{},[0,2,0,1]],"v":[{},[0,2]]}],"ó":[{},[0,2]],"p":[{},[0,2]],"s":[{"k":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,2,0,1]]}],"z":[{},[0,2]]}],"í":[{},[0,2,0,1,2]],"o":[{"r":[{},[0,0,3]]}],"ó":[{"h":[{},[0,0,3]],"r":[{},[0,0,0,1,2]]}],"ö":[{},[0,2]],"ő":[{},[0,2,0,1,2]],"s":[{},[0,0,0,1]],"u":[{"j":[{},[0,2,0,1]],"t":[{},[0,2,0,1]]}],"ú":[{"t":[{"o":[{},[0,2]]}]}],"ü":[{"v":[{},[0,0,0,1,2]]},[0,2]],"ű":[{},[0,2,3]],"z":[{"á":[{},[0,0,3]],"o":[{"n":[{},[0,0,0,3]]}]}]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,2,1]]}],"ü":[{"g":[{},[0,2,1,2]],"l":[{},[0,0,0,2]],"r":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"y":[{"i":[{},[0,0,0,1]]}],"z":[{"s":[{"e":[{},[0,0,3]]}]}]}]}],"b":[{".":[{},[2]],"a":[{"a":[{"d":[{},[0,0,0,2]]}],"b":[{"a":[{"d":[{"a":[{"t":[{},[0,0,2,1,2]]}]}],"j":[{"k":[{},[0,0,2,1]]}],"k":[{},[0,0,0,0,1,2]],"r":[{"a":[{},[0,0,2,1]],"c":[{},[0,0,2,1]]}],"s":[{"z":[{"t":[{},[0,0,2,1]]}]}]}],"á":[{"b":[{"r":[{},[0,0,2,1]]}],"c":[{"s":[{"i":[{},[0,0,2,1]]}]},[0,0,0,0,2]],"g":[{},[0,0,2,1]],"l":[{"l":[{},[0,0,0,1]]}],"r":[{"o":[{},[0,0,2,1,2]]}],"t":[{"v":[{},[0,0,2]]}]}],"é":[{"r":[{"c":[{},[0,0,2,1]]}],"t":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"v":[{},[0,0,2]]}],"i":[{"k":[{},[0,0,2]],"n":[{"a":[{".":[{},[0,0,2,1,2]]}]}]}],"o":[{"l":[{"a":[{},[0,0,2]],"d":[{},[0,0,0,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"u":[{"l":[{"t":[{},[0,0,2,1]]}]}],"ü":[{},[0,0,2]]}],"c":[{"h":[{"u":[{},[0,0,2,3]]}],"s":[{"o":[{"r":[{},[0,0,2]]}]}]}],"d":[{"a":[{"g":[{},[2,1,2]],"s":[{},[0,0,2]],"t":[{"o":[{},[2,1,2]]}]}],"á":[{"r":[{},[0,0,2,1]]}],"e":[{"g":[{},[0,0,2]],"s":[{},[0,0,2,1,2]]}],"o":[{"g":[{},[0,0,2]],"m":[{"á":[{},[2]]}]}],"ó":[{"d":[{},[0,0,2]],"i":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{},[0,0,2]],"t":[{},[0,0,2]]}],"u":[{"j":[{},[0,0,2]]}],"ú":[{"s":[{},[0,0,2]]}]}],"e":[{"g":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"r":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"a":[{"i":[{},[0,0,2]]}],"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"y":[{".":[{},[2,1]]}]}],"i":[{"z":[{},[0,0,0,2]]}],"j":[{"a":[{"g":[{},[0,0,2]]}],"á":[{"r":[{"u":[{},[0,0,2,1,2]]}],"t":[{"o":[{},[0,0,2,1,2]]}]}],"k":[{"ú":[{},[2]]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"k":[{"a":[{"p":[{"ó":[{},[0,0,2,1,2]]}],"s":[{"z":[{"t":[{},[0,0,2]]}]},[2]]}],"á":[{"c":[{"s":[{},[0,0,0,1,2]]},[2,0,2]],"l":[{"l":[{},[0,0,0,1]]}]}],"c":[{},[2]],"e":[{"g":[{},[0,0,2]]}],"é":[{"r":[{".":[{},[0,0,2,1]],"i":[{},[0,0,2,1]]}]}],"k":[{},[0,0,0,1]],"l":[{"i":[{},[0,0,1,2]],"u":[{},[0,0,1]]}],"o":[{"v":[{},[0,0,2,1,2]]}],"r":[{"i":[{},[0,0,1,2]]}],"t":[{"u":[{},[2,1]]},[0,0,0,1,2]],"u":[{"r":[{"a":[{},[0,0,0,1]],"á":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"y":[{},[0,0,2]]}],"l":[{"a":[{"n":[{"y":[{},[2,1]]}]}],"á":[{"l":[{},[2,1,2]]}],"e":[{"s":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2,1]],"l":[{"a":[{"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]],"z":[{},[0,0,0,2]]}],"e":[{"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1]],"m":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"é":[{"l":[{},[0,0,0,2,1,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}]}],"t":[{"é":[{},[0,0,0,2]],"i":[{"z":[{},[0,0,0,2]]}]}],"u":[{"d":[{},[0,0,2]]}]}],"m":[{"p":[{},[2,1]]}],"n":[{"a":[{"l":[{},[2]],"t":[{},[2,1,2]]}],"á":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"c":[{"e":[{},[0,0,0,2,1]],"s":[{},[0,0,0,0,3]]}],"g":[{"y":[{},[2,1]]}],"k":[{"a":[{"b":[{},[0,0,0,2]],"d":[{},[0,0,0,2,1,2]],"l":[{},[0,0,0,2,1,2]],"r":[{},[0,0,0,2]]}],"e":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"é":[{"p":[{},[0,0,0,2]],"r":[{"d":[{},[0,0,0,2]]}]}],"i":[{"r":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"u":[{"t":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"y":[{"ó":[{},[0,0,2]]}]}],"o":[{"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{"o":[{},[0,0,1]]}]}],"r":[{"c":[{".":[{},[2,1]],"é":[{},[2,1]],"n":[{},[2,1]],"o":[{},[2,1]],"r":[{},[2,1]],"s":[{"a":[{"d":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2]]}],"ú":[{},[2,1]]}],"g":[{"u":[{},[2,1]]}],"o":[{"m":[{"a":[{},[0,0,0,0,2]]}]}],"t":[{"é":[{},[2,1]]}]}],"s":[{"á":[{"g":[{"g":[{},[0,0,0,0,0,1]]}]}],"e":[{"b":[{},[0,0,2]]}],"l":[{"á":[{},[0,0,1]]}],"m":[{},[0,0,1,2]],"n":[{"i":[{},[0,0,1]]}],"p":[{"e":[{},[2,1]],"ó":[{},[0,0,1,2]]}],"s":[{"z":[{"e":[{},[0,0,0,3]]}]}],"t":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]]}]}],"t":[{"e":[{"s":[{"t":[{"i":[{},[0,0,2,1]]}]}]}],"r":[{"á":[{},[0,0,1,2]],"e":[{},[0,0,1]],"é":[{},[0,0,1]]}]}],"u":[{"d":[{},[0,0,2]],"l":[{},[2,1,2]],"r":[{},[0,0,0,2]]}],"v":[{"a":[{"t":[{},[2,1,2]]}]}],"y":[{"i":[{},[0,0,1]]}]},[1]],"á":[{"b":[{"a":[{"l":[{},[0,0,2]],"s":[{"s":[{},[0,0,2,1]]}]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"s":[{},[0,0,2,1]]}],"i":[{"k":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ü":[{},[0,0,2,1]]}],"c":[{"s":[{"o":[{"r":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}]}],"g":[{"a":[{},[2,1,2]],"ú":[{},[0,1,2]],"y":[{"a":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"o":[{"t":[{"t":[{},[0,0,2]]}]}],"ö":[{},[0,0,2]],"ú":[{},[0,0,2]]}]}],"j":[{"e":[{},[0,0,2,1,2]],"n":[{"á":[{},[0,0,0,2,1]]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1,2]],"t":[{"a":[{"k":[{},[0,0,0,2,1,2]]}]}],"ü":[{},[0,0,2]]}],"k":[{"o":[{"s":[{},[0,0,0,0,0,1]]}]}],"l":[{"a":[{"j":[{},[0,0,2]],"p":[{},[0,0,2,1]]}],"e":[{},[0,0,2,1,2]],"é":[{"j":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"d":[{},[0,0,2]],"n":[{"g":[{},[0,0,2,1]]}],"o":[{},[0,0,2,1,2]],"s":[{},[0,0,0,2]]}],"l":[{"í":[{},[2,1]],"o":[{},[2,1]],"v":[{},[2,1]]}],"m":[{},[2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]],"y":[{"a":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,0,1]],"n":[{},[0,0,2,0,1,2]]}],"á":[{"z":[{},[0,0,2,0,1,2]]}]}]}],"n":[{"i":[{"a":[{"s":[{},[0,0,0,0,2]]}]}],"r":[{"é":[{},[0,0,0,2]]}],"y":[{"a":[{"i":[{"é":[{},[0,0,0,0,0,2]]}]}]}]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[2,1,2]],"i":[{},[2,1,2]],"j":[{},[0,0,2,1]],"m":[{},[2,1,2]],"p":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[2,0,2,0,2]]}],"á":[{"b":[{},[2,1,2]],"g":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"t":[{},[2,1,2]]}],"d":[{"a":[{"s":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2,1]],"e":[{},[0,0,0,2]]}],"e":[{},[0,0,2,1]],"é":[{"n":[{},[0,0,2]]}],"i":[{"á":[{},[2,1,2]],"o":[{},[0,0,0,1,2]],"p":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"n":[{"y":[{},[2,1]]}],"ó":[{"n":[{"é":[{".":[{},[0,0,2,1,2]]}]}]}],"u":[{".":[{},[2]],"f":[{},[2]],"g":[{},[2,1,2]],"h":[{},[2,1,2]],"j":[{},[2,1]],"k":[{},[2,1,2]],"r":[{"a":[{".":[{},[0,0,0,1,2]]}]},[2,1]],"s":[{},[2]],"t":[{},[2,1]],"v":[{},[2]]}],"ú":[{"r":[{},[0,0,2]]},[2]],"ü":[{},[0,0,2]]}],"s":[{"á":[{"r":[{"é":[{},[0,0,2,1,2]]}]}],"e":[{},[0,0,2]],"i":[{"s":[{},[0,0,2]]}],"z":[{"a":[{"k":[{},[0,0,2,0,1]],"n":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,0,1]],"r":[{"u":[{},[0,0,2,0,1,2]]}]}],"e":[{},[0,0,2]],"i":[{"l":[{},[0,0,2]],"p":[{},[0,0,2]]}],"í":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}],"t":[{"a":[{"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]]}],"á":[{},[0,0,2,1,2]],"e":[{},[2,1,2,1,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[1]],"b":[{"a":[{"d":[{"a":[{},[0,0,1,2]],"d":[{},[0,0,1]]}],"k":[{"a":[{"s":[{},[0,0,1,2]]}]}],"l":[{"k":[{},[0,2,1]],"s":[{},[0,2,1]],"u":[{},[0,2,1]],"v":[{},[0,2,1]]}],"n":[{"y":[{},[0,2,1,2]]}],"p":[{},[0,2,1]],"r":[{"a":[{},[0,2,1,2]]}],"t":[{},[0,0,0,2]],"u":[{},[0,2,1]]}],"á":[{"g":[{"y":[{"a":[{"s":[{},[0,0,0,2]]}]}]}],"l":[{"l":[{},[0,2,1]],"m":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"n":[{},[0,0,1]],"u":[{},[0,0,1,2]]}],"s":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{},[0,0,0,2]],"k":[{"é":[{"n":[{},[0,2,1,2]]}]}],"l":[{"v":[{},[0,2,1]]}],"m":[{"b":[{},[0,2,1]]}],"n":[{"g":[{},[0,0,1]]}],"r":[{"j":[{},[0,0,1]],"n":[{},[0,0,1]],"ő":[{},[0,0,1]],"ű":[{},[0,0,1,2]]}],"s":[{"t":[{"é":[{},[0,0,1]]}]}],"t":[{"n":[{},[0,2,1]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1]],"l":[{".":[{},[0,0,1]],"e":[{},[0,0,1]],"h":[{},[0,0,1]],"j":[{},[0,0,1]],"n":[{},[0,0,1]],"t":[{},[0,0,1]],"ű":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"l":[{},[0,0,1]],"m":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}],"v":[{},[0,0,1]]}],"v":[{"i":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,0,1,2]]}],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]},[0,2,1]]}],"l":[{"l":[{"a":[{},[0,0,1]]}]}],"n":[{"d":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"t":[{"a":[{"t":[{},[0,0,0,2]]}],"t":[{},[0,2,1]]}]}],"í":[{"r":[{},[0,2,1,2]],"v":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"k":[{"t":[{},[0,2,1]]}],"l":[{"t":[{"á":[{},[0,0,1]]}],"v":[{},[0,2,1]]}],"p":[{},[0,2,1]],"t":[{"t":[{},[0,0,1]]}]}],"ó":[{"b":[{},[0,2,1]],"r":[{},[0,0,1,2]]}],"ö":[{"m":[{},[0,2,1,2]],"r":[{"ö":[{},[0,0,1]]},[0,0,0,2]],"s":[{},[0,2,1]]}],"ő":[{"r":[{"i":[{},[0,0,1]],"z":[{},[0,0,1]]}],"s":[{},[0,2,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"j":[{},[0,2,1]],"r":[{"a":[{},[0,0,1]]},[0,0,0,2]],"t":[{},[0,2,1,2]]}],"ú":[{"g":[{"á":[{"s":[{},[0,0,0,0,0,0,1]]}]}],"j":[{},[0,2,1]],"s":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,2,1]],"r":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,0,1,2]]}],"v":[{"í":[{},[0,0,2]]}]}],"c":[{"s":[{"z":[{},[0,0,3]]}]}],"d":[{"a":[{"c":[{"s":[{"a":[{"p":[{"á":[{},[0,0,0,2,0,1,2]]}]}]}]}],"d":[{},[0,0,0,1,2]],"p":[{},[0,0,0,1,2]],"s":[{"z":[{},[0,0,0,0,0,2]]},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]]}],"é":[{"n":[{},[0,0,0,2]]}],"r":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"e":[{"a":[{"c":[{},[0,0,2]],"d":[{},[0,0,0,2]],"j":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"t":[{"e":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2]]},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2]]}],"v":[{},[0,0,0,2]]}],"á":[{"j":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"z":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"c":[{"s":[{"a":[{"r":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2]]}],"é":[{"r":[{"t":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2,0,1,2]]}]}]}]}],"d":[{"é":[{"n":[{},[0,0,2]]}],"z":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,3]],"z":[{},[0,0,0,0,0,0,1]]}]}],"r":[{},[0,0,1,2]],"y":[{"e":[{"l":[{},[0,0,2]]}],"l":[{},[0,1]]}]}],"i":[{"g":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"í":[{"r":[{},[0,0,0,2]]}],"j":[{"e":[{"l":[{"t":[{},[0,0,2,1]]}]}],"t":[{},[2]]}],"k":[{"e":[{".":[{},[2,1,2]],"c":[{"s":[{"a":[{},[0,0,0,0,2]]}]}]}],"é":[{"t":[{"ő":[{},[2,1,2]]}]}],"r":[{"é":[{},[0,0,1,2]],"i":[{},[0,0,1]],"ó":[{},[0,0,1]]}],"v":[{},[0,0,1,2]]}],"l":[{"á":[{"l":[{},[0,0,2]]}],"e":[{"í":[{},[0,0,0,0,0,2]],"l":[{"s":[{},[0,0,0,1]]}],"m":[{"z":[{},[0,0,2]]}],"p":[{"r":[{},[0,0,0,0,1,2]]}],"t":[{"r":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}],"é":[{"k":[{},[0,0,2,1,2]],"r":[{".":[{},[0,0,2,1]],"e":[{"n":[{},[0,0,2,1,2]]}],"r":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2]],"o":[{"f":[{},[0,0,2]]}],"ö":[{"l":[{},[0,0,2]]}],"ő":[{"a":[{},[2,1,2]],"r":[{},[0,0,2]]}],"p":[{},[0,0,0,1,2]]}],"m":[{"e":[{"l":[{},[2]]}],"l":[{},[2,1]],"u":[{"s":[{},[0,1,2]]}]}],"n":[{"á":[{"l":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2,1]]}],"n":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2]],"e":[{"r":[{},[0,0,0,2,1,2]]}],"é":[{"g":[{},[0,0,0,2]]}]}],"y":[{"e":[{"g":[{},[0,0,2,0,1,2]]}]}]}],"o":[{"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2]]}],"ó":[{"v":[{},[0,0,0,2]]}],"ö":[{"r":[{},[0,0,0,2]]}],"p":[{"e":[{".":[{},[0,0,2]],"d":[{},[0,0,2]]}],"é":[{},[2,1,2]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"a":[{"d":[{},[0,0,2,1]],"l":[{"á":[{},[0,0,0,1]],"l":[{},[0,0,0,1]]}],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,1]]}],"t":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,3]],"l":[{"l":[{},[0,0,0,1]]}]}],"d":[{"e":[{"i":[{},[0,1]]}],"ő":[{},[2]]}],"e":[{"g":[{"é":[{},[0,0,0,1]],"y":[{},[0,0,0,1]]}],"k":[{"e":[{".":[{},[0,0,2,1,2]],"g":[{},[0,0,0,0,2,1]]}],"é":[{"k":[{},[0,0,2,1]]}]}],"l":[{"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"ő":[{"d":[{"ö":[{},[0,0,2]]}],"n":[{},[0,0,2,1]]}]}],"m":[{"é":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]]}],"p":[{"é":[{},[0,0,2,1,2]]}],"r":[{},[0,0,2,1,2]],"s":[{"z":[{"ü":[{},[0,0,0,1,2]]}]}],"t":[{"e":[{"t":[{},[0,0,2,1,2]]}]}]}],"é":[{"g":[{},[0,0,2]],"k":[{"k":[{},[0,0,2,1]]}],"s":[{"s":[{},[0,0,0,1]]}]}],"i":[{"n":[{"g":[{"ü":[{},[0,0,0,1]]}]}],"s":[{"m":[{},[0,0,2]],"t":[{},[0,0,2,1]],"z":[{"o":[{},[0,0,0,1]]}]}]}],"o":[{"l":[{"d":[{},[0,0,0,1]]}],"r":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,1]]}]}],"ó":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1,2]]}],"ő":[{"d":[{},[2,1]],"s":[{".":[{},[0,0,0,1]],"e":[{},[0,0,0,1,2]],"i":[{},[0,0,0,1,2]],"ü":[{},[0,0,0,1,2]]}]},[0,0,2]],"s":[{},[0,0,0,3,2]],"t":[{"a":[{"n":[{"á":[{"s":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"u":[{"b":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"ü":[{"g":[{},[0,0,2,1,2]],"l":[{"d":[{},[0,0,2,1]],"é":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]]}]}],"s":[{"e":[{"m":[{},[0,0,2]]}],"é":[{"l":[{},[2,1]],"s":[{},[2,1,2]]}],"k":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]]}],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]],"ő":[{},[2,1,2]],"p":[{},[0,0,1,2,2]],"s":[{"z":[{"a":[{},[0,0,0,0,0,1]],"á":[{},[0,0,0,0,0,1]]}]}],"t":[{"a":[{},[0,0,1,2]],"e":[{},[2]],"é":[{},[2]],"i":[{"l":[{},[0,0,1,2]]}],"o":[{},[0,0,1]]}],"z":[{"e":[{"t":[{},[2,1,2]]}],"é":[{"t":[{},[2,1,2]]}],"m":[{},[0,1]],"t":[{"a":[{},[0,0,0,0,2,1,2]],"á":[{},[0,0,0,0,2,1]]}]}]}],"t":[{"e":[{"g":[{"é":[{"r":[{".":[{},[0,0,0,0,0,1]]}]}]}]}],"é":[{"t":[{"e":[{"l":[{"b":[{},[0,0,0,0,2,1]],"k":[{},[0,0,0,0,2]]}]}]}]}],"h":[{"i":[{},[0,0,1,2]]}],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1]],"é":[{},[0,0,1,2]],"o":[{},[0,0,1,2]]}]}],"u":[{"g":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"ü":[{"t":[{},[0,0,0,2]]}],"v":[{"e":[{"z":[{"ő":[{},[0,0,2]]}]}],"o":[{"l":[{},[2,1,2]]}],"ő":[{},[2,1,2]]}],"z":[{"r":[{},[2,1]]}]},[1]],"é":[{"b":[{"r":[{},[2,1]]}],"c":[{"s":[{"ú":[{},[0,0,2]]}]}],"d":[{"a":[{"s":[{},[0,0,2,1]]}],"á":[{},[0,0,2,1]],"é":[{},[2]],"h":[{},[2]],"j":[{},[2]],"l":[{},[2]],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2]],"r":[{},[2]],"ü":[{},[2]],"v":[{},[2]]}],"g":[{"ő":[{},[0,0,2]]}],"k":[{"a":[{"l":[{"k":[{},[0,0,0,1]]}]}],"s":[{"z":[{},[2,1]]}]}],"l":[{"a":[{"k":[{"t":[{},[0,0,2,1]]}],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]]}],"á":[{"l":[{},[0,0,2]],"t":[{"o":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1,2]]}],"e":[{"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1,2]],"k":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"t":[{},[2,1,2]]}],"é":[{"j":[{},[0,0,2,1,2]]}],"i":[{"z":[{},[0,0,2]]}],"í":[{},[0,0,2]],"j":[{},[2]],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[2,1,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"l":[{},[0,0,2]]}],"ú":[{},[0,0,2]],"y":[{"e":[{"c":[{},[0,0,2,0,1]],"n":[{},[0,0,2,3]]}],"i":[{"n":[{},[0,0,2]]}],"ö":[{},[0,0,2]]}]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"a":[{"i":[{},[2,1,2]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"b":[{},[2,1]],"h":[{},[2,1]],"v":[{},[2,1]]},[0,0,2]],"d":[{"e":[{},[2,1]]}],"e":[{"b":[{},[0,0,2]],"l":[{"e":[{"m":[{"e":[{},[0,0,2,1]],"é":[{},[0,0,2,1,2]],"h":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]]}]}],"l":[{},[0,0,2,1]],"m":[{},[0,0,2]],"ő":[{"i":[{},[0,0,2,1]]}]}],"n":[{"g":[{},[0,0,2,1]]}],"s":[{"s":[{"z":[{},[0,0,0,1]]}],"z":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"n":[{"i":[{},[0,1]]}],"ö":[{},[0,0,2]],"s":[{},[0,0,0,1]],"t":[{"e":[{"l":[{},[2]]}],"é":[{"s":[{},[2,1]]}],"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"t":[{},[0,0,2]]}],"ú":[{},[0,0,2]]}],"s":[{"z":[{"a":[{},[0,0,2,0,1,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2,0,1]]}]}],"t":[{"a":[{"s":[{},[0,0,0,0,1]]}],"e":[{"l":[{},[2]]}],"h":[{},[0,0,1,2]],"k":[{},[2,1]],"t":[{},[2,1]]}],"v":[{".":[{},[2,1]],"e":[{"k":[{},[0,0,2]],"n":[{},[2,1,2]],"s":[{},[2,1,2]],"t":[{},[0,0,2]]}],"i":[{".":[{},[0,0,2]]}],"n":[{},[2,1]]}],"z":[{"s":[{"ú":[{},[0,0,2]]}]}]},[1]],"f":[{"e":[{"j":[{"e":[{"l":[{"s":[{},[0,0,0,0,1]]}]}]}],"l":[{"e":[{"n":[{},[0,0,0,2]]}]}]}],"é":[{"n":[{},[0,0,0,2]]}],"l":[{"a":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}]}],"g":[{"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"y":[{"ö":[{"k":[{"ö":[{"l":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}]}]}]}],"i":[{"a":[{"d":[{},[0,0,0,2]],"e":[{},[0,0,2]],"g":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,2]]}],"v":[{},[0,0,0,2]]}],"b":[{"r":[{},[0,0,1]],"y":[{},[0,0,1]]}],"c":[{"s":[{"z":[{},[0,0,0,3]]}]}],"d":[{"a":[{"d":[{},[0,0,2,1]],"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]]}],"ő":[{},[2,1,2]]}],"e":[{"d":[{},[0,0,2]],"l":[{},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"a":[{"z":[{},[0,0,2]]}],"á":[{"j":[{},[2,1,2]]}],"é":[{"n":[{},[2]]}]}],"h":[{"a":[{"t":[{},[2,1,2]]}]}],"k":[{"a":[{"l":[{"a":[{},[0,0,0,1]]}]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"m":[{},[0,0,2,1]]}],"i":[{"k":[{},[0,0,2]]}],"l":[{"u":[{},[0,0,1]]}],"ő":[{},[0,0,2,1,2]],"r":[{"o":[{},[0,0,1,2]]}],"s":[{},[0,0,0,1]]}],"l":[{"i":[{"m":[{"a":[{},[0,0,0,1]]}],"n":[{"t":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"l":[{"é":[{},[2]],"ő":[{},[2,1]],"u":[{},[2]]}],"ü":[{},[0,0,2]]}],"m":[{"a":[{".":[{},[0,0,2]]}],"i":[{},[2,1,2]],"p":[{},[2,1]]}],"n":[{"a":[{"b":[{},[0,0,2]],"d":[{},[2,1,2]],"j":[{},[0,0,2]],"t":[{".":[{},[2,1,2]]}]}],"á":[{"r":[{"b":[{},[0,0,2,1]]}]}],"d":[{"á":[{},[2,1]]}],"é":[{"t":[{"e":[{},[0,0,2,1]]}]}],"k":[{"á":[{},[2,1]]}],"n":[{},[0,0,0,3]],"ü":[{},[0,0,2]],"y":[{},[0,0,1]]}],"o":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{},[0,0,2]],"c":[{},[0,0,2]],"d":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{"e":[{},[0,0,2]]}],"k":[{},[0,0,2]],"l":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{},[2,1,2]],"r":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"a":[{"r":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"r":[{"a":[{"m":[{},[2,1,2]],"t":[{},[2,1,2]]}],"á":[{"n":[{},[2,1,2]]}],"k":[{"á":[{"i":[{},[2]]}]}],"o":[{"d":[{"á":[{},[2]]}]}],"r":[{},[2,1]],"t":[{"á":[{},[2,1]],"ó":[{},[2,1]]}]}],"s":[{"h":[{"i":[{},[0,0,0,2]]}],"i":[{},[2,1,2]],"m":[{},[2]],"ö":[{},[0,0,2]],"p":[{},[0,0,1,2]],"s":[{},[0,0,0,3]],"t":[{"o":[{},[0,0,1,2]]}]}],"t":[{"a":[{"r":[{"á":[{},[0,0,0,1]]}]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"h":[{},[0,0,0,1]],"r":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,0,0,0,2,1]]}]}],"i":[{"n":[{"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"o":[{},[0,0,2,1,2]]}],"o":[{"n":[{},[0,0,2,1]]}],"t":[{},[0,0,0,1,2]],"u":[{"r":[{"a":[{},[0,0,0,1]]}],"t":[{},[0,0,2,1]]}]}],"ú":[{"s":[{},[0,0,0,2]]}],"v":[{"a":[{"r":[{},[0,0,2]]}],"á":[{"s":[{},[2,1,2]]}]}]},[1]],"í":[{"j":[{"a":[{},[0,0,2]]}],"r":[{"ó":[{"é":[{"r":[{},[0,0,0,0,0,2]]}]}]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"z":[{"ü":[{},[2,1,2]]}]},[1]],"k":[{"é":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"l":[{"i":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"l":[{"a":[{"b":[{"l":[{},[1,2]]}],"i":[{"k":[{},[0,0,0,0,2]]}],"k":[{"a":[{"d":[{},[0,0,0,0,1,2]],"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}],"á":[{"t":[{"m":[{},[0,0,0,2,1]],"t":[{},[0,0,0,2,1]]}]}],"e":[{"m":[{},[0,0,0,2]]}],"i":[{"k":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2,1]]}],"ü":[{},[0,0,0,2]]}],"p":[{"e":[{},[0,0,0,0,1]],"l":[{},[0,0,0,1,2]]}],"s":[{"t":[{},[0,0,0,1,2]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,1]]}]}],"b":[{"e":[{},[0,0,2]]}],"e":[{"r":[{"i":[{},[0,0,0,2,1]]}],"s":[{},[0,0,0,0,2]],"t":[{"a":[{"k":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2,1,2]]}],"á":[{},[0,0,0,2,1,2]],"e":[{"l":[{},[0,0,0,2,1,2]],"r":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,2]]}]}],"é":[{"l":[{},[0,0,0,2]],"r":[{"d":[{},[0,0,0,2,1]]}],"t":[{"k":[{},[0,0,0,2,1]]}]}],"i":[{"g":[{"a":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"o":[{},[0,0,0,2,1]],"ó":[{},[0,0,0,2]],"ö":[{},[0,0,0,2,1,2]],"u":[{},[0,0,0,2]],"ü":[{"z":[{},[0,0,0,2]]}]}],"ü":[{},[0,0,0,0,2]],"v":[{"e":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}]}],"h":[{"e":[{},[0,0,2]]}],"i":[{"a":[{"f":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"o":[{"f":[{},[0,0,0,2]]}]}],"j":[{"a":[{"n":[{"a":[{},[0,1]]}]}]}],"n":[{"e":[{},[0,0,2]]}],"o":[{"k":[{"k":[{"ö":[{},[0,0,0,0,2,1,2]]}]},[1,2]],"n":[{"á":[{},[0,0,0,2,1]],"n":[{},[0,0,0,0,3]]}]}],"ő":[{"z":[{"é":[{},[0,2,1]]}]}],"r":[{"e":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"t":[{"ő":[{},[0,0,2]]}],"u":[{"e":[{"s":[{"z":[{},[0,0,0,2]]}]}]}]}],"o":[{"a":[{"á":[{},[0,0,2]],"b":[{},[0,0,2]],"d":[{},[0,0,2]],"e":[{},[0,0,2]],"f":[{},[0,0,2]],"h":[{},[0,0,2]],"j":[{},[0,0,2]],"m":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]]}],"c":[{"a":[{"k":[{},[0,0,2,1]]}],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"h":[{},[0,0,2,3]],"s":[{"é":[{},[0,0,2]]}]}],"d":[{"y":[{},[0,0,1]]}],"e":[{"i":[{},[0,0,2]]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"a":[{"k":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"á":[{"c":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"e":[{},[0,0,2,1]],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"s":[{"z":[{"á":[{},[0,0,0,0,2]]}]}]}],"y":[{"o":[{},[0,0,2]]}]}],"k":[{"a":[{"p":[{},[0,0,0,0,1]]}],"í":[{},[2,1,2]],"o":[{"z":[{},[0,1,2]]}],"s":[{"z":[{"a":[{"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2,0,1]]}],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2]]},[0,0,0,0,0,0,2]],"i":[{"n":[{},[0,0,0,2,0,1]]}],"ó":[{},[0,0,0,2]],"ő":[{},[0,0,0,2,0,1]]}]}],"t":[{"a":[{},[2,1]]}]}],"l":[{"a":[{"j":[{".":[{},[2]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"d":[{"ó":[{},[2,1]]}],"i":[{"m":[{},[2,1,2]]}],"o":[{"g":[{},[0,0,0,0,1,2]]}],"t":[{"e":[{},[0,0,0,2,1]],"ö":[{},[0,0,0,2,1,2]],"ü":[{},[0,0,0,2,1,2]]}],"v":[{"a":[{"s":[{},[2]]}]}]}],"n":[{"a":[{"v":[{"a":[{},[0,0,0,1]]}]},[0,0,0,0,1]],"c":[{"a":[{"n":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"h":[{},[0,0,0,2]]}],"d":[{},[2]],"e":[{},[0,0,2,1,2]],"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"o":[{"r":[{},[0,0,2,1]]}],"t":[{"i":[{},[0,0,0,2,1]]}],"ü":[{},[0,0,2]]}],"o":[{"g":[{},[0,0,2]],"k":[{},[0,0,2]],"m":[{},[0,0,2]],"t":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,2,1,2]],"k":[{"a":[{},[0,0,2,1]],"k":[{},[0,0,0,1]],"v":[{},[0,0,2,1]]}],"l":[{},[0,0,2,1,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,1]]}],"t":[{"r":[{},[0,0,0,1]]}],"u":[{},[0,0,2,1]],"v":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"á":[{"c":[{"s":[{},[0,0,0,1]]}],"l":[{"l":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"d":[{},[0,0,0,1,2]],"e":[{"c":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1]],"r":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1]]},[0,0,2]],"f":[{"i":[{"ú":[{"k":[{"é":[{},[0,0,0,0,0,2]]}]}]}]},[0,0,0,1,2]],"i":[{"k":[{"o":[{},[0,0,2,1,2]]}],"l":[{},[0,0,2,1]],"n":[{"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"s":[{"k":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"t":[{"t":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"k":[{},[0,0,0,1,2]],"n":[{"a":[{"m":[{},[2,1]]}]}],"o":[{"n":[{"d":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"r":[{".":[{},[2,1]],"ú":[{},[2,1]]}],"s":[{"e":[{"p":[{"r":[{"ű":[{},[0,0,0,2,1]]}]}]}],"o":[{"r":[{"s":[{},[0,0,0,2]]}]}],"t":[{"r":[{},[0,0,0,1]]}],"ü":[{"l":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}]}],"t":[{"r":[{"e":[{},[0,0,0,1]],"é":[{},[0,0,0,1]]}]}],"ü":[{},[0,0,2]],"v":[{"í":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"z":[{"á":[{"r":[{"a":[{"k":[{},[0,0,0,2,1,2]]}]}]}],"s":[{"a":[{},[0,0,0,2]],"e":[{},[0,0,0,2,3]]}]}]}],"s":[{"z":[{"t":[{},[2,1]]}]}],"t":[{"a":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2]],"u":[{},[0,0,2,1,2]]}],"á":[{"c":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"l":[{},[0,0,2,1]],"n":[{"f":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"p":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"u":[{"r":[{},[0,0,2]]}],"ú":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"u":[{"i":[{},[0,0,2]],"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"y":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"é":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}],"z":[{"a":[{"r":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"d":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"o":[{"l":[{"d":[{},[0,0,2,1]]}]}],"s":[{},[0,0,2,3]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"ó":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"b":[{"é":[{},[0,0,2]]}],"c":[{"a":[{"l":[{},[0,0,2]]}],"h":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"f":[{"l":[{},[0,0,1]]}],"k":[{"r":[{"é":[{},[0,0,1]]}]}],"l":[{"i":[{"a":[{},[0,0,0,0,2]]}],"m":[{},[0,1]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"a":[{"d":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"á":[{"s":[{"v":[{},[0,0,0,1]]},[0,0,2]]},[2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]]}],"i":[{"n":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2,1]]}],"ó":[{"s":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{},[0,0,2]],"t":[{},[0,0,0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"p":[{},[0,0,1,2]],"z":[{},[0,0,1]]}]},[1]],"ö":[{"c":[{"h":[{},[0,0,2]]}],"l":[{"á":[{},[0,0,2]],"b":[{},[2]],"c":[{"s":[{"ü":[{},[0,0,0,2]]}]}],"é":[{"r":[{},[2,1,2]]}],"h":[{"ö":[{},[2]]}],"i":[{"g":[{},[2]]}],"k":[{"ú":[{},[0,1]]},[2]],"r":[{},[2]],"t":[{"ö":[{},[2,1]],"ő":[{},[2]]}],"ú":[{},[0,0,2]],"y":[{"ö":[{"k":[{"ö":[{},[0,0,2]]}]}]}]}],"m":[{"l":[{},[0,1]]}],"n":[{"á":[{},[0,0,2]],"t":[{},[2,1]]}],"r":[{"a":[{},[0,0,2]],"e":[{},[0,0,2,1]],"o":[{},[0,0,2]]}],"s":[{"s":[{"z":[{},[2,1]]}]}],"t":[{"l":[{},[2,1]],"s":[{},[2,1]]}],"v":[{"e":[{},[0,0,2]]}]},[1]],"ő":[{"r":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]]}],"é":[{"g":[{},[0,0,2,1,2]],"k":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"i":[{"l":[{},[0,0,2]],"n":[{"g":[{},[0,0,2,1]]}],"p":[{},[0,0,2]],"s":[{},[0,0,2,1,2]],"z":[{"g":[{},[0,0,0,1]]},[0,0,2]]}],"l":[{},[2]],"o":[{},[0,0,2,1,2]],"ö":[{"l":[{},[0,0,0,1]]}],"ő":[{},[0,0,2]],"r":[{"e":[{"n":[{},[0,0,0,0,0,0,2]]}]}],"s":[{},[0,0,0,1,2]],"u":[{},[0,0,2,1]],"ú":[{},[0,0,2]],"ü":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]]}]}],"s":[{"i":[{},[2]]}]},[1]],"p":[{"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{"j":[{},[0,1]]},[0,0,2]],"ó":[{},[0,0,2]]}]}],"r":[{"a":[{"k":[{"á":[{},[0,0,0,2,1,2]],"ö":[{"s":[{},[0,0,0,2]]}]}],"p":[{},[0,0,0,1,2]],"t":[{"y":[{},[1]]}]}],"á":[{"n":[{"a":[{"g":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"á":[{"t":[{},[0,0,0,2,1]]}],"t":[{},[0,0,0,0,0,2]]}],"s":[{"z":[{"á":[{"l":[{},[0,0,0,2,0,1]]}],"e":[{},[0,0,0,2]]}]}]}],"i":[{"c":[{},[0,2]],"d":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{"r":[{},[0,0,0,2]]}]}],"g":[{},[1,2]],"n":[{"o":[{},[0,0,0,2]]}],"ó":[{"d":[{},[0,0,0,2]],"f":[{},[0,0,0,2]],"m":[{},[0,0,0,2]]}],"t":[{"e":[{"l":[{},[0,0,0,2]]}]}]}],"o":[{"s":[{"ú":[{},[0,2]]}]}],"ó":[{"m":[{"a":[{},[0,0,0,2,1]],"e":[{},[0,0,0,2]]}]}],"u":[{"m":[{},[1,2]]}]}],"s":[{"é":[{"g":[{"e":[{"l":[{},[0,0,0,2,1]]}]}]}],"k":[{"á":[{},[0,1,2]]}],"l":[{"á":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"z":[{"á":[{"r":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1,2]]}]}]}]}],"f":[{},[0,0,0,2]],"k":[{},[0,1,0,2]],"t":[{"á":[{},[0,0,0,2]]}]}]}],"t":[{"e":[{"r":[{"m":[{"o":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,2]]}]},[0,0,0,0,0,0,1]]}]}]}],"r":[{"á":[{},[0,0,2]],"e":[{},[0,1,2]],"é":[{},[0,0,2]],"i":[{},[0,1,2]],"o":[{},[0,1,2]],"ó":[{},[0,1,2]]}]}],"u":[{"c":[{"h":[{},[0,0,2]]}],"d":[{"v":[{},[2,1]]}],"é":[{"r":[{},[0,0,0,2]]}],"g":[{"i":[{},[0,0,2,1,2]]}],"i":[{"l":[{},[0,0,2]]}],"j":[{"j":[{".":[{},[2,1]],"a":[{".":[{},[2]],"d":[{"a":[{},[0,0,0,2,1,2]]},[2]],"i":[{},[2]],"k":[{},[2]],"m":[{},[2]],"s":[{},[2]],"t":[{},[2]]}],"á":[{},[2,1]],"b":[{},[2]],"c":[{},[2]],"d":[{},[2]],"e":[{},[2]],"é":[{},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"i":[{},[2]],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"o":[{},[2,1]],"p":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"u":[{},[2]],"ú":[{},[2]],"v":[{},[2]]}]}],"k":[{"j":[{"e":[{},[0,0,0,2,1]]}]}],"m":[{"a":[{"j":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2]]}],"i":[{"k":[{},[0,0,2,1,2]],"n":[{"a":[{},[0,0,2,1]]}],"s":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]}]}],"r":[{"a":[{"l":[{},[2,1]]}],"b":[{},[0,1]],"n":[{},[2]],"ú":[{},[2,1,2]]}],"s":[{"e":[{},[0,0,2]],"i":[{"n":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]}],"p":[{},[0,0,1,2]],"s":[{"z":[{"e":[{},[0,0,0,3]]}]}],"z":[{"a":[{"b":[{},[0,0,2]],"j":[{},[0,0,0,0,1]],"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,0,1]],"r":[{"a":[{"k":[{},[0,0,2,0,1,2]]}],"n":[{},[0,0,2,0,1]]}]}],"e":[{"n":[{},[0,0,0,0,1]]}],"é":[{"l":[{},[0,0,2,0,1]],"p":[{},[0,0,2,0,1,2]]}],"i":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,0,1]],"m":[{},[0,0,2]],"n":[{},[0,0,2]],"p":[{},[0,0,2]],"z":[{},[0,0,2]]}],"í":[{"j":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]],"s":[{},[0,0,0,0,3]],"ü":[{},[0,0,2]]}]}]},[1]],"ú":[{"j":[{"í":[{},[0,0,2]]}],"r":[{".":[{},[2]],"i":[{},[2,1,2]],"t":[{},[2]]}],"s":[{"z":[{"á":[{},[0,0,2]]},[2]]}],"t":[{"i":[{},[0,1,2]],"m":[{},[0,1]]}]},[1]],"ü":[{"d":[{"ü":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"k":[{"u":[{},[0,0,2]]}],"l":[{"d":[{},[2,1]],"é":[{"n":[{},[0,0,2,1,2]]}]}],"n":[{"e":[{},[0,0,2]]}],"r":[{"ü":[{},[2]]}],"t":[{"e":[{},[2,1,2]],"é":[{},[2,1,2]],"ő":[{},[0,1,2]]}],"v":[{"e":[{},[2,1,2]]}],"z":[{"e":[{},[0,0,2]]}]},[1]],"ű":[{"n":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2]],"m":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2,1,2]]}],"n":[{},[0,0,0,1]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ő":[{},[0,0,2,1,2]],"u":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"r":[{"i":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2,1,2]]}],"z":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"o":[{},[0,0,2]],"ő":[{},[0,0,2,1]],"s":[{},[0,0,2,3]]}]},[1]],"v":[{"á":[{"n":[{"y":[{"a":[{"d":[{},[0,0,0,2]]}],"í":[{},[0,0,0,2]]}]}]}]}],"y":[{"t":[{"e":[{},[0,0,2]]}]}]}],"c":[{".":[{},[2]],"a":[{"b":[{"l":[{},[2,1]],"r":[{},[0,0,1,2]]}],"c":[{"é":[{"l":[{},[0,0,2]]}],"h":[{},[0,0,2]]}],"d":[{"á":[{"s":[{},[0,0,2]]}],"ó":[{},[2,1,2]]}],"e":[{"s":[{},[0,0,2]]}],"é":[{"n":[{"e":[{},[0,0,0,0,0,2]]}]}],"f":[{"r":[{"o":[{},[0,0,1]]}]}],"g":[{"g":[{},[2,1]],"y":[{"a":[{"d":[{},[0,0,0,0,1,2]]},[0,0,2]],"u":[{},[0,0,2]]}]}],"j":[{"k":[{},[2,1]]}],"k":[{"a":[{"d":[{},[2,1,2]]}],"á":[{"c":[{},[0,0,2]],"z":[{},[0,0,2,1]]}],"c":[{},[2,1]],"k":[{"o":[{"l":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2,1]]}],"r":[{"i":[{},[0,0,1]]}]}],"l":[{"a":[{"g":[{},[0,0,0,0,2,1]],"n":[{},[0,0,2]],"s":[{},[0,0,2,1,2]]}],"b":[{"u":[{},[2,1]]}],"e":[{"s":[{"t":[{"e":[{},[0,0,2,1]]}]}]}],"é":[{"l":[{},[0,0,2,1,2]],"t":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{"m":[{},[0,0,2]],"p":[{},[0,0,2,1]]}],"o":[{"s":[{"z":[{},[0,0,0,1]]}]}],"p":[{},[0,0,0,1]],"s":[{},[0,0,0,1]],"ü":[{},[0,0,2]],"y":[{},[0,0,1]]}],"n":[{"a":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"i":[{},[2,1,2]],"n":[{"e":[{},[0,0,0,2]]}]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"ó":[{},[0,0,2]],"r":[{"ó":[{},[0,0,1,2]]}],"s":[{},[0,0,1,2]]}],"r":[{"a":[{"n":[{},[0,0,2]]}],"á":[{"n":[{},[0,0,2]]}],"c":[{},[2,1]],"i":[{"s":[{},[0,0,2]]}]}],"s":[{"p":[{},[0,0,1,2]],"s":[{"z":[{},[2,1]]}],"t":[{"o":[{},[0,0,1]],"r":[{},[0,0,1]]},[0,0,0,0,2]],"z":[{"t":[{},[2,1]]}]}],"t":[{"a":[{"u":[{},[0,0,2]]}],"e":[{"m":[{},[0,0,2]]}],"l":[{},[2,1]]}],"u":[{"k":[{},[0,1,2]],"n":[{},[0,0,0,2]]}],"v":[{"a":[{"t":[{},[0,0,2]]}]}],"z":[{"o":[{},[2,1,2]]}]},[1]],"á":[{"b":[{"r":[{},[2,1]]}],"g":[{"a":[{},[0,0,2]],"ú":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"l":[{"á":[{},[0,1]]}],"m":[{},[2,1]]}],"n":[{"e":[{},[0,0,2]],"é":[{"t":[{},[0,0,2]]}],"i":[{"r":[{},[0,0,2]]}]}],"p":[{"a":[{},[0,0,3,2,3]],"o":[{},[2,1,2]]}],"r":[{"a":[{"d":[{},[2,1,2]],"k":[{},[2,1,2]],"s":[{},[0,0,2,1]]}],"i":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"n":[{},[0,0,2,1,2]]}],"k":[{},[2]],"p":[{},[2,1]],"u":[{".":[{},[2]],"h":[{},[2,1,2]],"s":[{},[2]]}]}],"s":[{"á":[{"s":[{},[0,0,2]]}],"ó":[{},[2,1,2]],"v":[{},[2,1]],"z":[{"a":[{"i":[{},[2,1,2]]}],"o":[{},[2,1,2]]}]}],"t":[{"a":[{},[2,1,2,1,2]],"h":[{},[0,1]],"i":[{},[2,1,2,1,2]],"m":[{},[2,1]],"r":[{},[2,1]],"t":[{},[2,1]],"ü":[{},[2,1,2]],"v":[{},[2,1]]}]},[1]],"b":[{"l":[{"o":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]]}]}],"c":[{"a":[{"j":[{},[0,2,1,2]],"k":[{},[0,2,1]],"l":[{"b":[{},[0,0,1]]}],"n":[{"y":[{},[0,0,1,2]]}],"r":[{},[0,2,1,2]],"u":[{},[0,2,1]]}],"á":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"f":[{},[0,0,1]],"l":[{"m":[{},[0,2,1]]}],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}]}]}],"é":[{"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}]}]}],"h":[{"e":[{},[0,0,3]],"í":[{},[0,0,3]],"o":[{},[0,2,3]],"ő":[{},[0,0,3]],"ú":[{},[0,0,3]]}],"i":[{"m":[{},[0,2,1,2]],"n":[{"a":[{".":[{},[0,0,0,2]]}],"g":[{},[0,0,1]]}],"ó":[{"v":[{},[0,0,0,2]]}],"p":[{"a":[{},[0,0,1,2]]}],"r":[{"o":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"í":[{"r":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"o":[{"á":[{},[0,0,1]],"v":[{},[0,2,1]]}],"ö":[{"n":[{},[0,0,1]],"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"a":[{"p":[{},[0,3]],"r":[{},[0,3]],"s":[{},[0,0,0,1]],"t":[{},[0,3]]}],"á":[{"l":[{},[0,0,0,1]],"p":[{},[0,3]],"s":[{},[0,0,0,1]],"t":[{"l":[{},[0,0,0,1]]}]}],"e":[{"g":[{},[0,0,0,1]],"l":[{"e":[{"m":[{},[0,0,0,1]]}],"l":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]}],"m":[{"b":[{"e":[{},[0,0,0,1]]}],"l":[{},[0,0,0,1]]}],"p":[{},[0,3]]}],"é":[{"l":[{},[0,0,0,1]],"r":[{"t":[{"é":[{},[0,0,0,1]]}]}]}],"i":[{"v":[{},[0,0,0,1]]}],"o":[{"p":[{},[0,3]],"r":[{"k":[{},[0,0,0,1]],"o":[{},[0,0,3]]}]}],"ö":[{"l":[{},[0,0,0,1,2]],"n":[{"t":[{},[0,0,0,1]]}]}],"s":[{},[0,0,0,1]],"u":[{"t":[{},[0,0,0,1]]}],"ú":[{},[0,3]],"ű":[{},[0,3]],"z":[{"a":[{},[0,0,3]],"á":[{},[0,0,3]],"e":[{"n":[{},[0,0,0,3]]}],"ó":[{},[0,0,3]]}]},[0,2]],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"r":[{},[0,0,1]]}],"z":[{"á":[{},[0,0,3]],"e":[{},[0,0,3]],"s":[{},[0,0,3]]}]}],"d":[{"a":[{"l":[{"é":[{},[0,0,0,2,1,2]],"i":[{},[0,0,0,2,1]]}]}],"e":[{"m":[{"e":[{"k":[{"é":[{},[0,0,0,2,1,2]]}],"l":[{},[0,0,0,2,1]]}]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}]}],"e":[{"a":[{"l":[{},[0,0,0,2]],"t":[{},[0,0,2]],"u":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]}],"b":[{"é":[{"d":[{},[0,0,2]]}],"l":[{},[0,0,1]]}],"c":[{"h":[{"e":[{},[0,0,0,3]]},[0,0,2]]}],"d":[{"z":[{},[2,1,2]]}],"g":[{"a":[{"s":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"i":[{"n":[{"a":[{},[0,0,2]]}]}],"o":[{"r":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,1,2]]}],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"y":[{".":[{},[0,1]],"b":[{},[0,1]],"e":[{"n":[{},[0,0,2]]}],"i":[{},[0,1,2]],"m":[{},[0,1]],"r":[{},[0,1]],"s":[{},[2,1]]}]}],"k":[{"e":[{".":[{},[2,1,2]]}],"l":[{},[0,0,1]]}],"l":[{"a":[{"d":[{},[2,1]]}],"á":[{"g":[{},[2,1,2]]}],"é":[{"r":[{},[0,0,0,1]]}],"f":[{},[2,1]],"h":[{"a":[{},[2,1]]}],"j":[{"á":[{},[2,1]]}],"o":[{"s":[{},[2,1,2]]}],"ő":[{"a":[{},[0,1,2]],"d":[{"ö":[{"t":[{".":[{},[2]]}]}]}],"f":[{},[2,1,2]],"í":[{},[2,1,2]],"ő":[{},[0,1,2]]}],"s":[{"ő":[{},[2,1]]}],"t":[{"á":[{},[2,1]],"o":[{},[0,1]]}],"v":[{"á":[{},[2,1]]}]}],"m":[{"e":[{"l":[{"ő":[{},[2,1,2]]}]}],"l":[{},[2,1]]}],"n":[{"c":[{"c":[{},[0,0,0,0,1]],"e":[{"g":[{},[0,0,0,2,1]]}],"s":[{},[0,0,0,2,3]]}],"g":[{},[2,1]],"s":[{"é":[{"g":[{},[0,0,0,2,1]]}]}],"t":[{"a":[{"u":[{},[0,0,0,2]]}]}]}],"o":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"p":[{"e":[{".":[{},[2,1,2]]}],"i":[{},[2,1,2]],"r":[{},[0,0,1,2]],"s":[{"z":[{"a":[{},[0,0,0,2,0,1,2]],"é":[{"p":[{},[0,0,0,2,0,1,2]]}],"i":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,0,0,2,1,2]],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"i":[{"m":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2,1]]}]}]}],"r":[{"e":[{"j":[{},[2,1,2]]}],"ó":[{"z":[{},[0,0,2]]}],"ő":[{},[2,1,2]],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"e":[{"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1,2]],"m":[{"b":[{},[0,0,0,2,1]]}],"s":[{"t":[{},[0,0,0,2,1]]}]}],"é":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}],"o":[{"l":[{},[0,0,0,2,1]]}],"ö":[{},[0,0,0,2,1]],"u":[{},[0,0,0,2]],"ü":[{"z":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}],"s":[{"e":[{"m":[{},[0,0,2]]}],"é":[{"s":[{},[2,1,2]]}],"ő":[{},[2,1,2]],"t":[{"é":[{"j":[{},[0,0,0,2,1,2]],"k":[{},[0,0,0,2,1]]}],"r":[{"a":[{},[0,0,1]]}]}]}],"t":[{"e":[{"g":[{},[0,0,2,1,2]],"s":[{"s":[{"z":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}]}],"é":[{"t":[{},[0,0,2,1,2]]}],"h":[{},[2]],"i":[{"l":[{"l":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"n":[{},[2]],"o":[{"n":[{},[2]]}],"r":[{"a":[{},[0,0,1,2]]}],"u":[{"s":[{},[0,0,2,1]]}],"ű":[{"d":[{},[0,0,2]],"z":[{},[0,0,0,0,2]]}]}],"ü":[{"t":[{},[0,0,0,2]]}],"v":[{"é":[{"s":[{},[0,0,2]]}],"ő":[{},[0,0,2]]}],"z":[{"e":[{"r":[{},[2,1,2]]}],"r":[{"e":[{"d":[{"e":[{},[2]]}]}]}]}]},[1]],"é":[{"b":[{"r":[{},[2,1]]}],"d":[{"é":[{"l":[{},[0,0,2]]}]}],"g":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"r":[{"e":[{},[0,0,0,1]],"é":[{},[0,0,0,1]]},[0,0,2,0,2]],"s":[{"e":[{"m":[{},[0,0,2,1]]}]}],"t":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}]}],"é":[{"k":[{},[0,0,2,1]],"p":[{},[0,0,2]],"s":[{},[2,1,2]]}],"g":[{},[0,0,0,1]],"i":[{"d":[{},[0,0,2,1,2]],"g":[{"a":[{},[0,0,0,1]],"é":[{},[0,0,2]]}],"m":[{},[0,0,2]],"r":[{},[0,0,2]],"z":[{},[0,0,2,1]]}],"o":[{"k":[{},[0,0,2,1]],"l":[{},[0,0,2]]},[0,0,0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]]}],"h":[{"a":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]},[0,0,0,0,2]],"e":[{"d":[{},[0,0,2]],"g":[{},[0,0,2,1,2]]}],"i":[{"r":[{},[0,0,2]]}],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"k":[{"s":[{},[2,1]]}],"l":[{"a":[{"n":[{},[0,0,0,1,2]],"p":[{},[0,0,3]],"r":[{},[0,0,0,1,2]]},[0,0,2]],"á":[{"b":[{},[0,0,2]],"l":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"e":[{".":[{},[0,0,2]],"d":[{},[0,0,2]],"g":[{},[0,0,2]],"i":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"m":[{"b":[{},[0,0,0,1]]},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1,2]],"t":[{},[2,1,2]],"z":[{},[2,1,2]]}],"é":[{"b":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"n":[{"k":[{},[0,0,2]]}],"p":[{},[0,0,2]],"r":[{"e":[{},[0,0,2]]}],"s":[{},[0,0,2]]}],"i":[{"m":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"í":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2,1,2]],"ő":[{},[0,0,2,1,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[2,1,2]]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"a":[{"g":[{},[0,0,2]]}],"d":[{},[2,1]],"é":[{"s":[{},[2,1,2]]}],"i":[{"n":[{"t":[{},[2,1]]},[0,0,2]],"s":[{},[0,0,2]]}],"s":[{},[0,0,0,1]],"t":[{"é":[{},[2,1]],"ő":[{".":[{},[2,1]]}]}],"ú":[{},[0,0,2]],"z":[{},[2,1]]}],"s":[{"s":[{},[0,0,0,3]],"z":[{"h":[{},[2,1]]}]}],"t":[{"k":[{},[2,1]],"t":[{},[2,1]]}],"v":[{".":[{},[2,1]],"a":[{"d":[{},[2,1]]}],"e":[{".":[{},[2,1,2]],"i":[{},[2]],"k":[{},[2,1,2]],"n":[{},[2,1,2]],"s":[{},[2,1,2]],"t":[{},[2,1,2]]}],"é":[{"t":[{},[2,1,2]]}],"i":[{".":[{},[0,0,2]]}],"n":[{},[2,1]],"ü":[{},[2,1,2]]}]},[1]],"f":[{"l":[{"ó":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}]}],"g":[{"r":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]]}]}],"h":[{"a":[{"d":[{},[0,3]],"j":[{},[2,3]],"m":[{},[2]],"n":[{"g":[{},[2]]}],"r":[{"c":[{},[2,3]],"m":[{},[2]]}],"t":[{"á":[{},[2]]}],"v":[{},[2,3]]},[1]],"á":[{"m":[{},[2,3]],"n":[{"y":[{},[0,3]]}],"z":[{},[0,3]]},[1]],"b":[{"l":[{},[0,0,1]]}],"e":[{"g":[{},[2,3]],"v":[{},[2]],"z":[{},[2,3]]},[1]],"é":[{},[1]],"i":[{"b":[{},[2,3]],"ó":[{},[2,3]],"t":[{"e":[{"l":[{},[2]],"t":[{},[2]]}]}],"ú":[{},[0,3]]},[1]],"í":[{},[1]],"o":[{"d":[{},[0,0,0,1,2]],"r":[{},[2,3]],"s":[{"s":[{},[2,3]]}]},[1]],"ó":[{},[1]],"ö":[{},[1]],"ő":[{},[1]],"p":[{"r":[{},[0,0,1]]}],"s":[{"c":[{},[0,0,1]],"p":[{},[0,0,1]]}],"u":[{"r":[{},[0,0,0,2]],"z":[{},[2,3]]},[1]],"ú":[{},[1]],"ü":[{},[1]],"ű":[{},[1]]},[0,2]],"i":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]],"r":[{},[0,0,2]]},[0,0,0,1,2]],"c":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{"a":[{"g":[{},[0,0,0,2]]}],"r":[{},[0,0,2]]},[0,0,0,1]],"g":[{},[0,0,2,1,2]],"h":[{},[0,0,2]],"i":[{"k":[{},[0,0,2]]}],"í":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{"a":[{"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"é":[{"n":[{".":[{},[0,0,2]]}]}],"ó":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"o":[{},[0,0,2]]}],"m":[{},[0,0,2]],"n":[{"y":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"s":[{"z":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"o":[{},[0,0,2]],"ű":[{},[0,0,2]]},[0,0,0,1,2]],"u":[{},[0,0,2,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"l":[{"a":[{"n":[{},[0,0,0,2]]}]}],"n":[{"á":[{"r":[{},[0,0,0,2]]}]}],"ó":[{},[0,0,2]]}],"d":[{"e":[{"g":[{},[2,1,2]],"o":[{},[0,0,2]]}],"é":[{},[2,1,2]],"o":[{"m":[{},[2,1,2]]}],"ő":[{},[2,1,2]]}],"e":[{"r":[{},[0,0,0,2]]}],"f":[{"j":[{},[2,1]]}],"g":[{"a":[{".":[{},[2,1,2]],"z":[{},[2,1,2]]}],"e":[{".":[{},[0,0,2]]}],"r":[{},[0,0,1,2]]}],"k":[{"e":[{"r":[{},[0,0,2]]}],"k":[{"a":[{"j":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"o":[{},[0,0,0,2,1]]}],"l":[{"a":[{},[0,0,1,2]]}],"r":[{"á":[{},[2,1]]}]}],"l":[{"á":[{"t":[{},[0,0,2,1,2]]}],"l":[{"u":[{},[2]]}]}],"m":[{"i":[{"t":[{},[0,0,2]]}],"p":[{"u":[{},[2]]}]}],"n":[{"a":[{"l":[{},[0,0,2,1]]}],"á":[{"r":[{"t":[{},[0,0,2,1]]}]}],"d":[{},[0,0,0,1,2]],"e":[{"r":[{"e":[{},[0,0,2,1,2]]}]}],"f":[{},[2]],"g":[{"e":[{},[2,1]],"r":[{},[2,1]]}],"i":[{"m":[{},[0,0,2]]}],"k":[{"a":[{"c":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1,2]]}],"é":[{"r":[{"t":[{},[0,0,0,2]]}]}],"o":[{"l":[{},[0,0,0,2]],"r":[{"s":[{},[0,0,0,2]]}]}],"ö":[{},[0,0,0,2]]}],"ö":[{},[0,0,2]],"t":[{"a":[{"r":[{},[0,0,0,2]]}],"e":[{"s":[{},[0,0,0,2,1]]}]}],"u":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"ü":[{},[0,0,2]],"v":[{},[2,1]]}],"o":[{"d":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{"r":[{"a":[{},[0,0,0,1]]}]},[0,0,2]],"i":[{},[0,0,2]],"l":[{"o":[{},[0,0,3]]},[0,0,2]],"n":[{"n":[{},[2,1,2]]}],"p":[{},[0,0,2]],"v":[{},[0,0,0,2]]}],"ó":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"c":[{},[0,0,2]],"d":[{"a":[{"r":[{},[0,0,2]]}]}],"e":[{},[0,0,2]],"g":[{},[0,0,2]],"í":[{},[0,0,2]],"k":[{"a":[{"l":[{},[0,0,2]],"m":[{},[0,0,2]]}],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"l":[{},[0,0,2,1]],"o":[{"m":[{},[0,0,2]],"s":[{},[0,0,2]]}],"u":[{},[0,0,2]]}],"l":[{},[0,0,2]],"m":[{"a":[{"g":[{},[0,0,2]]}],"á":[{},[0,0,2]]}],"n":[{"é":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2,1]],"s":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{"r":[{},[0,0,0,2,1]]}],"k":[{"á":[{},[0,0,2,1,2]]}],"z":[{"o":[{},[0,0,2]]}]}],"t":[{"á":[{},[0,0,2]]}],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{"ó":[{"n":[{},[0,0,2]]}]}]}],"ő":[{"r":[{},[0,0,0,2]]}],"r":[{"a":[{"t":[{},[0,0,2]]}],"á":[{"n":[{},[2,1,2]]}],"o":[{"d":[{},[2,1,2]]}],"t":[{},[2,1]]}],"s":[{"i":[{".":[{},[0,0,2]]}],"k":[{"o":[{},[2,1]]}],"m":[{},[2,1]],"p":[{},[2,1]],"t":[{"a":[{"d":[{},[0,0,1]]}]}],"z":[{"i":[{},[0,0,2,0,1]]}]}],"t":[{"a":[{"j":[{},[0,0,2,1]]}],"á":[{"r":[{".":[{},[0,0,0,1]],"a":[{},[0,0,0,1]],"é":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"é":[{"r":[{"r":[{},[0,0,0,1]]}]}],"i":[{"k":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2,1]]}],"y":[{},[0,0,1]]}],"u":[{"m":[{"i":[{"n":[{},[0,0,0,2]],"o":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"t":[{},[0,0,0,2]]}],"v":[{"a":[{"d":[{},[2,1,2]]}],"á":[{"s":[{},[2,1,2]]}]}]},[1]],"í":[{"j":[{"a":[{},[0,0,2]],"é":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"e":[{"l":[{},[0,0,2,1,2]]}],"é":[{"l":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"v":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]]}],"z":[{"s":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[1]],"k":[{"a":[{"k":[{"a":[{},[0,0,0,0,0,2]]}],"l":[{"j":[{},[0,2,1]]}],"r":[{"c":[{},[0,2,1]],"o":[{"m":[{},[0,0,0,2]]}]}]}],"á":[{"g":[{},[0,2,1]],"l":[{"l":[{},[0,0,1]]}],"r":[{"n":[{},[0,2,1]]}]}],"e":[{"g":[{},[0,2,1,2]],"p":[{},[0,0,0,1]],"r":[{".":[{},[1]],"k":[{},[1]],"n":[{},[1]]}]}],"é":[{"p":[{"e":[{"l":[{},[0,0,0,2,1,2]]}]}],"r":[{"é":[{},[0,2,1,2]],"l":[{},[0,2,1]],"t":[{"é":[{},[0,2,1]]}]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"l":[{"l":[{},[0,0,1]]}]}],"í":[{"z":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"l":[{"u":[{},[0,0,2]]}],"o":[{"l":[{"a":[{},[0,2,1,2]]}],"p":[{"e":[{},[0,0,1,2]]}],"r":[{"r":[{"o":[{},[0,2,1]],"u":[{},[0,2]],"ú":[{},[0,2]]}]}],"s":[{"a":[{"k":[{},[1,2]]}]}],"u":[{},[0,2,1]]}],"ö":[{"b":[{},[0,2,1]],"s":[{"s":[{},[0,0,1]]}]}],"r":[{"e":[{"á":[{},[0,0,2]]}],"i":[{},[0,1,2]],"í":[{},[0,1,2]]}],"s":[{"p":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"t":[{},[0,0,1]]}],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"ű":[{"r":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,2]]}]}],"l":[{"i":[{"s":[{},[0,0,0,2]]}],"u":[{"b":[{"a":[{},[0,0,0,2,1]]}]}]}],"m":[{"e":[{"l":[{"o":[{},[0,0,0,0,0,1]]}]}]}],"n":[{"y":[{"a":[{"k":[{},[0,0,0,0,2]]}],"o":[{"l":[{"c":[{"a":[{"n":[{},[0,0,0,0,0,2,1]]}]}]}]}]}]}],"o":[{"a":[{"t":[{},[0,0,2]]}],"á":[{"z":[{},[0,0,2]]}],"b":[{"e":[{},[0,0,2]]}],"e":[{"u":[{},[0,0,2]]}],"k":[{"a":[{"r":[{},[0,0,2]]}],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{"l":[{},[0,0,2]],"p":[{},[0,0,2]]}],"í":[{},[2,1,2]]}],"l":[{"a":[{"j":[{},[2,1,2]]}],"á":[{"r":[{"o":[{},[0,0,2,1]]}]}],"d":[{"a":[{},[2,1]],"á":[{},[2,1]],"ó":[{},[2,1]]}],"e":[{},[0,0,2]],"i":[{"b":[{"r":[{},[0,0,2,1]]}],"m":[{"a":[{},[0,0,0,1]]},[0,0,2,0,2]],"n":[{"a":[{".":[{},[0,0,2,1,2]]}],"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"u":[{},[0,0,2,1]]}]}],"o":[{"r":[{},[0,0,2,1,2]]}],"v":[{"a":[{"d":[{},[2]],"s":[{},[2]]}]}]}],"m":[{"b":[{"a":[{"l":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"e":[{},[0,0,0,2,1,2]],"i":[{"z":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2]]}],"l":[{},[2,1]]}],"o":[{"l":[{},[0,0,2]]}],"p":[{"e":[{},[2,1,2]],"f":[{"ő":[{},[0,0,0,2,1]]}],"y":[{},[0,0,1]]}],"r":[{"c":[{},[2,1]],"i":[{},[2,1,2]],"m":[{},[2,1]],"o":[{"m":[{},[0,1,2]]}],"r":[{"o":[{},[2,1]],"ú":[{},[2,1]]}],"v":[{},[2]]}],"s":[{"k":[{"o":[{"l":[{},[2,1]]}]}],"o":[{"k":[{"u":[{},[0,0,2,1,2]]}]}],"s":[{},[0,0,0,3]],"z":[{"s":[{},[0,0,0,3]],"t":[{},[2,1]]}]}],"u":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]],"v":[{},[0,0,2]]}],"v":[{"i":[{},[0,0,2]]}]},[1]],"ó":[{"n":[{"i":[{},[0,1,2]]}],"r":[{"á":[{},[2,1,2]],"i":[{},[0,1,2]]}],"v":[{"ó":[{},[0,0,2]]}]},[1]],"ö":[{"l":[{"t":[{"ö":[{},[0,1]]}]}],"s":[{"v":[{},[0,1]],"z":[{},[0,1]]}],"t":[{"b":[{},[0,1]],"e":[{},[0,1,2,1]],"é":[{},[0,1,2]],"f":[{},[0,1]],"h":[{},[0,1]],"i":[{},[0,1,2]],"k":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"r":[{},[0,1]],"s":[{},[0,1]],"t":[{},[0,1]],"ü":[{},[0,1,2]]}],"v":[{".":[{},[0,1]]}],"z":[{"ö":[{},[0,0,2]]}]},[1]],"ő":[{"r":[{"ü":[{},[0,0,2]]}]},[1]],"p":[{"l":[{"a":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"s":[{"a":[{"b":[{"l":[{},[2]]}],"d":[{"a":[{"t":[{},[2,0,1,2]]}],"á":[{},[2,0,1,2]],"ó":[{},[2,0,1,2]]}],"k":[{"c":[{},[2,0,1]]}],"l":[{"a":[{"k":[{"j":[{},[0,0,0,2]]}],"p":[{"ú":[{},[0,0,0,2]]}]}],"á":[{"í":[{},[2]],"t":[{},[2]]}],"b":[{},[2]],"g":[{},[2,0,1]],"k":[{},[2,0,1]],"l":[{"e":[{},[0,0,1]]}],"m":[{},[2,0,1]],"o":[{"m":[{"b":[{},[0,0,0,2]]}]}]}],"m":[{"b":[{},[0,0,1]]}],"n":[{"t":[{},[2]]}],"p":[{"á":[{"l":[{},[0,0,0,2]]}],"k":[{"a":[{},[2]],"á":[{},[2]]}],"o":[{"r":[{},[0,0,0,2]]}],"ó":[{"k":[{"á":[{},[2]],"r":[{},[2]]}],"s":[{"a":[{"b":[{},[2]]}]}]}]}],"r":[{"c":[{},[2,0,1]],"g":[{},[2]],"k":[{},[2]],"z":[{},[2,0,1]]}],"s":[{"s":[{},[2,0,1]]}],"t":[{"ó":[{"r":[{},[0,0,0,2,1,2]]}]}],"v":[{"a":[{"r":[{"a":[{},[0,0,0,0,0,0,1,2]]}]}]}],"z":[{"o":[{},[0,0,1]]}]},[1]],"á":[{"b":[{"e":[{},[0,0,0,2]]}],"f":[{},[2]],"g":[{"a":[{"k":[{},[0,0,1,2]]}],"u":[{},[0,0,1,2]]},[2]],"r":[{"a":[{"d":[{},[2,0,1]],"k":[{},[2,0,1,2]],"m":[{},[2]],"t":[{},[2]]}],"á":[{"t":[{},[0,0,0,2]]}],"n":[{"y":[{},[2,0,1]]}],"u":[{"k":[{},[0,0,1,2]]}]}],"s":[{"á":[{},[2,0,1]],"i":[{},[2,3]],"ó":[{},[2,0,1]]}],"t":[{"á":[{"s":[{"á":[{"s":[{},[2]]}]}]}],"f":[{},[2]],"m":[{},[2]],"r":[{},[2]]}],"v":[{".":[{},[2]],"o":[{},[2,3]]}]},[1]],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"b":[{"é":[{},[2]]}],"c":[{"e":[{},[0,0,1,2]],"s":[{"a":[{},[0,0,0,2]]}]}],"d":[{"é":[{},[2,0,1,2]],"z":[{},[2,0,1]]}],"f":[{"f":[{},[0,0,1]]}],"g":[{"e":[{"s":[{},[0,0,1,2]]}],"í":[{},[2]]}],"k":[{"e":[{".":[{},[2,0,1,2]]}]}],"l":[{"f":[{},[2]],"l":[{"á":[{},[2]]}],"ő":[{"í":[{},[2]]}],"t":[{"a":[{},[2]],"á":[{},[2]]}],"v":[{".":[{},[2]]}],"y":[{},[2,3]]}],"m":[{"b":[{"e":[{"r":[{},[2,0,1]]}]}],"e":[{"l":[{},[2,0,1,2]]}],"l":[{},[2]],"u":[{},[2]]}],"n":[{"d":[{"ő":[{},[0,0,0,0,2,1,2]]}],"i":[{"s":[{},[0,0,0,2]]}],"y":[{"e":[{"n":[{},[0,0,0,2,3]]}]}],"z":[{},[2]]}],"p":[{"r":[{"é":[{},[0,0,0,1,2]]}]}],"r":[{"á":[{"l":[{},[0,0,0,2]]}],"e":[{"p":[{"e":[{"d":[{},[0,0,0,2,1,2]]}]}]}],"ó":[{},[2]],"ő":[{},[2]]}],"s":[{"ő":[{},[2]],"z":[{"m":[{},[2]]}]}],"t":[{"ü":[{"z":[{},[0,0,0,2]]}]}],"v":[{"ő":[{},[2]]}],"x":[{},[2,0,1]]},[1]],"é":[{"g":[{".":[{},[0,3]],"b":[{},[0,3]],"g":[{},[0,3]],"h":[{},[0,3]],"i":[{},[0,3]],"n":[{},[0,3]],"r":[{},[0,3]]},[2]],"h":[{"e":[{"s":[{},[2]]}],"s":[{},[2]]}],"k":[{"a":[{},[2,0,1,2]],"s":[{},[2]]}],"l":[{"e":[{},[2,0,1]]}],"m":[{"a":[{},[0,0,0,2,1]]}],"n":[{"e":[{"k":[{"b":[{},[2]],"e":[{},[2]],"é":[{},[2]],"k":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"ü":[{},[2]]}]}]}],"p":[{"í":[{},[2]],"ü":[{},[2]]}],"r":[{"d":[{"e":[{},[2]]}],"é":[{"s":[{"k":[{},[0,0,0,2]]}]}],"v":[{".":[{},[2,3]],"b":[{},[2]],"h":[{},[2]],"r":[{},[2]],"v":[{},[2]]}],"z":[{},[2]]}],"s":[{"z":[{"a":[{},[0,0,0,2]]}]}],"t":[{"a":[{"b":[{},[0,0,0,2]]}]}],"v":[{".":[{},[2]],"e":[{"k":[{},[2]]}],"n":[{},[2]],"r":[{},[2]],"v":[{},[2]]}]},[1]],"f":[{"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"á":[{},[0,0,0,0,2]],"d":[{"ő":[{},[2]]}],"g":[{"é":[{},[2]]}],"m":[{"í":[{},[2]],"o":[{"g":[{},[2]]}],"p":[{"o":[{},[2]]}]}],"n":[{"a":[{".":[{},[2,0,1,2]],"s":[{},[2]]}],"d":[{},[2,0,1]],"p":[{},[2,0,1]],"v":[{},[2,0,1]]}],"o":[{"n":[{"o":[{},[2]]}]}],"p":[{"í":[{},[2]]}],"v":[{"í":[{},[2]],"ó":[{},[2]]}]},[1]],"í":[{"k":[{"i":[{},[2]]}],"r":[{"b":[{},[2,3]],"j":[{},[2,3]],"ó":[{},[0,0,1,2]]}],"v":[{},[2,0,1,2]],"z":[{"e":[{},[2]],"l":[{},[2]],"n":[{},[0,0,1]],"t":[{},[2]],"ü":[{},[0,0,1]]}]},[1]],"k":[{"a":[{"s":[{"z":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,1]]}],"l":[{},[0,0,1]],"v":[{},[0,0,1]]}],"l":[{"á":[{"g":[{},[0,3]]}]}],"o":[{"á":[{},[2,0,1,2]],"b":[{"j":[{},[2]]}],"k":[{"á":[{},[0,0,0,2,1]],"k":[{".":[{},[2]]}],"o":[{"z":[{},[2]]}]}],"l":[{"a":[{"j":[{},[2]]}],"d":[{"a":[{},[2]],"á":[{},[2]],"ó":[{".":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2]],"r":[{},[2]],"t":[{},[2]],"v":[{},[2]]}]}],"i":[{},[2,0,1]],"l":[{"ó":[{},[2]]}],"v":[{"a":[{"s":[{},[2]]}]}]}],"m":[{"o":[{"r":[{},[0,0,0,2]]}]}],"n":[{"t":[{"a":[{},[0,0,0,0,2,1,2]]}]}],"p":[{"c":[{},[2]]}],"r":[{"c":[{},[2,0,1]],"i":[{},[2]],"k":[{},[2]],"v":[{},[2,3]]}],"s":[{"z":[{"l":[{},[2]],"t":[{},[2]]}]}]},[1]],"ó":[{"d":[{"á":[{},[0,0,1]]}],"k":[{"e":[{"s":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2,1,2]]}],"n":[{"é":[{},[2,0,1]]}]},[1]],"ö":[{"k":[{"r":[{"ü":[{},[2]]}]}],"m":[{"l":[{},[0,0,1]]}],"n":[{"n":[{},[0,0,0,0,3]]}],"r":[{".":[{},[2]],"e":[{},[0,3]]}],"s":[{"s":[{"z":[{},[2]]}]}],"v":[{".":[{},[2]]}],"z":[{"ö":[{"n":[{},[2]]}]}]},[1]],"ő":[{".":[{},[3]],"b":[{},[3]],"é":[{"h":[{},[0,0,0,0,2]]}],"r":[{"z":[{},[2]]}],"s":[{"z":[{"á":[{"r":[{"a":[{},[0,0,0,2,0,1,2]]}]}],"é":[{"k":[{},[0,0,0,2]]}],"ő":[{},[0,0,0,2]]}]}],"v":[{},[3]]},[1]],"p":[{"e":[{"k":[{},[0,3,2]]}],"l":[{},[0,0,1,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,1]]}],"s":[{"l":[{},[0,0,1]],"p":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"z":[{"a":[{"k":[{"ü":[{},[0,0,0,0,0,2]]}]}]},[0,0,3,0,2]]}],"t":[{"a":[{"b":[{},[0,3,2]]}],"o":[{"p":[{},[0,0,2]]}],"r":[{"u":[{},[0,3]]},[0,0,0,2]]}],"u":[{"d":[{"v":[{},[2]]}],"g":[{},[2]],"h":[{"o":[{},[2,3]]}],"j":[{"j":[{},[0,0,1]]}],"n":[{"a":[{},[2,0,1]],"i":[{},[2]]}],"r":[{"a":[{},[2,0,1]],"á":[{},[2,0,1,2]]}],"t":[{"a":[{"s":[{},[0,0,1,2]]}],"á":[{},[2,0,1]],"ó":[{},[0,0,1]]}]},[1]],"ú":[{"p":[{},[0,0,0,1,2]],"t":[{"n":[{},[2]]}]},[1]],"ü":[{"d":[{},[2]],"g":[{"é":[{},[2]],"y":[{},[2]]}],"n":[{"n":[{},[2,0,1]]}],"t":[{"e":[{},[0,0,1,2]]}],"v":[{},[2,3]],"z":[{},[2,0,1]]},[1]],"ű":[{},[1]],"z":[{"a":[{"c":[{},[0,4,3]],"j":[{},[0,0,3]],"k":[{"é":[{},[0,0,0,0,2]]}],"m":[{},[0,0,3]]}],"á":[{"l":[{},[0,3]],"m":[{},[0,3]],"p":[{},[0,0,3]],"t":[{},[0,0,3]],"z":[{},[0,3]]}],"c":[{},[0,3,0,2]],"e":[{"r":[{},[0,3]]}],"é":[{},[0,3]],"f":[{},[0,3,0,2]],"i":[{},[0,3]],"í":[{},[0,3]],"l":[{},[0,3,0,2]],"o":[{"b":[{},[0,3]],"k":[{"n":[{},[0,0,3]]}],"l":[{},[0,3]],"n":[{},[0,0,3]],"r":[{},[0,3]]}],"ó":[{"n":[{},[0,0,3]]}],"ő":[{},[0,3]],"s":[{},[0,0,3]],"t":[{},[0,0,0,2]],"u":[{"g":[{},[0,0,3]]}],"ú":[{},[0,0,3]],"ü":[{},[0,3]],"ű":[{},[0,3]],"v":[{},[0,3,0,2]]}]},[0,2]],"t":[{"r":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}],"u":[{"c":[{"c":[{"i":[{"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}]}],"k":[{"o":[{"r":[{"a":[{},[0,0,0,0,2,1]]}]}]}],"l":[{"a":[{"t":[{"e":[{},[0,0,0,0,2]]}]}],"ü":[{},[0,0,2]]}],"n":[{"d":[{},[2,1]],"o":[{},[2,1,2]]}],"r":[{"a":[{},[2,1,2]]}],"t":[{"á":[{},[2,1,2]]}]},[1]],"ú":[{"j":[{"í":[{},[0,0,2]]}],"r":[{".":[{},[0,1]],"r":[{},[0,1]]}],"t":[{"i":[{},[0,1,2]],"o":[{},[0,0,2]]}]},[1]],"ü":[{"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"é":[{},[2,1,2]],"ő":[{},[0,0,2]]}],"n":[{"n":[{},[0,1]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[1]],"ű":[{"z":[{"ő":[{},[0,0,2]]}]},[1]],"v":[{"a":[{"n":[{"e":[{"m":[{},[0,0,0,2]]}],"é":[{"v":[{},[0,0,0,2]]}]}]}],"e":[{"n":[{"é":[{"v":[{},[0,0,0,2]]}],"n":[{},[0,0,0,0,3]]}]}]}],"z":[{"a":[{"i":[{"b":[{},[0,0,0,2]],"é":[{},[0,0,0,2]],"h":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}]},[1]],"á":[{},[1]],"e":[{"n":[{},[2,3]]},[1]],"é":[{"h":[{},[0,3]]},[1]],"i":[{},[1]],"í":[{},[1]],"o":[{},[1]],"ó":[{},[1]],"ö":[{},[1]],"ő":[{},[1]],"u":[{},[1]],"ú":[{},[1]],"ü":[{},[1]],"ű":[{},[1]],"y":[{},[1]]},[0,2]]}],"d":[{".":[{},[2]],"a":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{"t":[{},[0,0,0,0,1]]}],"b":[{"l":[{"a":[{},[2,1]]}]}],"c":[{"i":[{"r":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"d":[{"a":[{"g":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,1]]}],"t":[{"o":[{},[2]]}]}],"ó":[{},[2,1,2]],"r":[{"á":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"e":[{"r":[{},[0,0,0,2]]}],"é":[{"d":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"f":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"g":[{"e":[{"l":[{},[0,0,2,1]]}],"g":[{},[0,0,0,3]]}],"h":[{"h":[{},[2,1]]}],"i":[{"r":[{"e":[{},[0,0,2]]}]}],"j":[{"á":[{"n":[{},[2,1,2]]}],"t":[{},[2,1]]}],"k":[{"a":[{"d":[{},[2,1,2]]}],"á":[{"r":[{},[0,0,0,0,2]]}],"k":[{"o":[{"r":[{"a":[{},[2,1]]}]}],"u":[{},[0,1]]}],"l":[{},[0,0,1]],"r":[{"é":[{},[0,0,1,2]],"i":[{},[0,0,1,2]]}],"t":[{"u":[{},[2,1]]}]}],"l":[{"a":[{"g":[{"a":[{},[0,0,0,1,2]]}],"j":[{"t":[{},[0,0,0,1]]}],"k":[{"j":[{},[0,0,2]],"t":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1]]}],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"z":[{},[2,1]]}],"l":[{},[0,0,2,1,2]],"p":[{"c":[{},[0,0,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2]],"ú":[{},[2,1,2]]}],"r":[{},[0,0,2]],"s":[{"z":[{},[0,0,2,1]]}],"t":[{"t":[{},[0,0,2]]}]}],"á":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]],"r":[{"a":[{"k":[{},[0,0,0,1,2]]}],"á":[{},[0,0,0,1]],"b":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,0,1,2]]}],"t":[{"i":[{},[0,0,2,1]]}]}],"e":[{"l":[{"á":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"l":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{"é":[{},[0,0,0,1,2]]}]}],"é":[{"k":[{"e":[{},[0,0,0,0,2,0,2]]}],"l":[{".":[{},[0,0,0,1]]}],"n":[{"e":[{},[0,0,2,1,2]]}],"r":[{".":[{},[0,0,2,1]]}]}],"f":[{},[0,0,0,1,2]],"i":[{"d":[{},[0,0,2]],"k":[{"o":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]]}],"m":[{},[0,0,2,1,2]],"n":[{"á":[{"t":[{},[0,0,2,1,2]]}],"d":[{},[0,0,2]],"f":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"t":[{},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}],"t":[{"t":[{},[0,0,2,1]]}],"z":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"j":[{"i":[{},[2,1]]}],"l":[{"o":[{},[2,1]]},[0,0,0,3]],"o":[{"m":[{"e":[{},[0,0,0,0,2,1]],"o":[{},[0,0,0,0,0,0,2]]}],"r":[{},[0,0,2,1]]}],"ő":[{"r":[{},[0,0,2]]}],"p":[{},[0,0,0,1,2]],"u":[{"d":[{},[0,0,0,1]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"ú":[{"t":[{"o":[{},[0,0,2,1]],"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ü":[{},[0,0,2]]}],"m":[{"c":[{},[2,1]],"f":[{},[2,1]]}],"n":[{"a":[{"l":[{},[2,1,2]]}],"g":[{},[2,1]],"y":[{"a":[{"g":[{},[0,1,2]]}],"ó":[{},[2,1,2]]}]}],"o":[{"k":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"p":[{"a":[{".":[{},[2,1,2]],"i":[{},[2,1,2]],"k":[{"é":[{},[0,0,2]]}]}],"á":[{"b":[{},[0,0,2]],"d":[{},[0,0,2]],"é":[{},[0,0,2]],"h":[{},[0,0,2]],"i":[{},[0,0,2]],"k":[{},[0,0,2]],"m":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]]}],"j":[{},[2,1]],"l":[{},[0,0,1,2]],"ó":[{".":[{},[0,0,2]]}],"p":[{},[2,1]],"r":[{"o":[{},[0,0,1]]}],"s":[{},[0,0,1,2]],"t":[{},[2]]}],"r":[{"a":[{"b":[{"e":[{},[0,0,0,0,2]]}],"d":[{"ó":[{},[0,0,2,1,2]]}],"l":[{"a":[{},[0,0,0,1]]}],"n":[{"t":[{},[0,0,2]]}],"z":[{"o":[{},[0,0,2,1]]}]}],"á":[{"t":[{"a":[{},[0,0,2,1]],"f":[{},[0,0,2,1]]}]}],"c":[{"e":[{},[0,0,0,2,1,2]],"h":[{},[0,0,0,2,3]],"s":[{"o":[{},[0,0,0,2]]}],"ú":[{},[2,1]]}],"d":[{"a":[{"l":[{},[0,0,0,2,1,2]]}],"á":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]]}],"ó":[{},[0,0,0,2,1,2]]}],"e":[{"l":[{},[0,0,2,1]]}],"i":[{"l":[{},[0,0,2,1]]}],"u":[{"s":[{"s":[{},[0,0,0,0,0,3]]}],"t":[{"a":[{},[0,0,0,1]]}]}],"ü":[{},[0,0,2,1]]}],"s":[{"á":[{"l":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"p":[{"e":[{},[0,0,1]]}],"s":[{"z":[{},[2,1]]}],"t":[{"a":[{},[0,0,1,2]]}],"z":[{"l":[{},[0,0,1]],"t":[{"á":[{},[0,0,0,0,2]]},[0,0,0,0,0,2]],"ú":[{},[2]]}]}],"t":[{"a":[{"k":[{"t":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"l":[{"a":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]]}],"p":[{"u":[{},[0,0,0,1]]}],"r":[{"á":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,1]]}],"t":[{"t":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}],"r":[{"a":[{"d":[{},[0,0,2,1]],"m":[{"m":[{},[0,0,0,0,2]],"r":[{},[0,0,0,0,2]]}]}]}],"t":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1]]}]}],"e":[{"l":[{"e":[{"m":[{},[0,0,2]]}],"é":[{},[0,0,0,1,2,1]],"í":[{},[0,0,0,1]],"k":[{},[0,0,2,1]],"l":[{},[0,0,0,1]],"ő":[{},[0,0,2,1]],"t":[{},[0,0,0,1]]}]}],"é":[{"g":[{},[0,0,2,1,2]],"r":[{"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2,1]],"h":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2]],"k":[{"o":[{},[0,0,2,1]]},[0,0,0,0,2]],"m":[{},[0,0,2]],"n":[{"f":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,0,1]]}]}],"s":[{"t":[{},[0,0,0,1]]}],"z":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,2,1]],"v":[{"e":[{},[0,0,0,1]]}]}],"k":[{},[0,0,0,1,2]],"l":[{"a":[{"s":[{},[2,1]]}]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"c":[{},[0,0,2]],"m":[{},[2]],"r":[{},[0,0,2,1,2]],"s":[{"á":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"t":[{},[0,0,0,1,2]],"u":[{"t":[{},[0,0,2,1,2]]}],"ú":[{"t":[{},[0,0,2]]}],"ű":[{"r":[{},[0,0,2]]}],"y":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}]}],"u":[{"k":[{},[2,1,2]],"p":[{},[0,0,2]],"r":[{},[2,1,2]],"s":[{},[0,0,0,2]],"t":[{"a":[{},[0,0,0,2]],"ó":[{"p":[{},[0,0,3,2]]}]}]}],"ü":[{"t":[{},[0,0,0,2]],"z":[{},[0,0,0,2]]}],"v":[{"a":[{"t":[{},[2,1,2]]}],"v":[{},[2,1]]}],"y":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]]}],"z":[{".":[{},[2,1]],"á":[{"l":[{},[0,0,2]]}],"é":[{},[2,1,2]],"o":[{"k":[{},[0,0,2]],"n":[{},[0,0,2]]}]}]},[1]],"á":[{"b":[{"é":[{},[2,1,2]],"r":[{},[2,1]]}],"c":[{"h":[{"o":[{},[0,0,2,3]]}]}],"f":[{"á":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"ú":[{},[0,0,2]],"y":[{},[2,1,2]]}],"l":[{"á":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"e":[{},[0,0,2,1]],"l":[{"í":[{},[2,1]]}],"ü":[{},[0,0,2]],"y":[{"a":[{"n":[{},[0,0,2,0,1,2]]}],"ú":[{"s":[{},[0,0,2,0,1]]},[0,0,0,0,0,2]]}]}],"m":[{"u":[{"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"ú":[{},[0,0,2,1]]}],"n":[{"y":[{"a":[{"d":[{},[0,0,2,0,1,2]],"l":[{},[0,0,2,0,1]],"n":[{},[0,0,2,0,1,2]],"z":[{},[0,0,2]]}],"ó":[{},[0,0,2]]}]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[2,1,2]],"g":[{},[0,0,2,1]],"i":[{},[2,1,2]],"j":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"m":[{},[2,1,2]],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,1]]},[0,0,2]],"t":[{"k":[{},[0,0,0,1]]},[0,0,2]]}],"á":[{"l":[{},[0,0,0,1]]},[0,0,2]],"e":[{},[0,0,2,1,2]],"é":[{"b":[{},[0,0,2]]}],"i":[{"a":[{".":[{},[2,1,2]]}],"j":[{},[0,0,2]],"l":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"s":[{"k":[{},[0,0,0,1]],"m":[{},[0,0,0,1]]}]}],"í":[{},[0,0,2]],"o":[{"d":[{},[0,0,2]],"n":[{"d":[{},[0,0,2,1]]}],"t":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{".":[{},[2]],"k":[{},[0,0,2]],"s":[{"á":[{"g":[{".":[{},[0,0,0,0,2,1]],"a":[{},[0,0,0,0,2,1,2]]}]}]}]}],"ú":[{".":[{},[2,1]]},[0,0,2,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"s":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2,1,2]],"r":[{"a":[{"d":[{},[0,0,2,1]]}],"h":[{},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}],"s":[{},[0,1,2]],"t":[{"a":[{},[0,0,0,0,0,1,2]]}]}],"e":[{},[0,0,2,1,2]],"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"i":[{"m":[{},[0,0,2]],"s":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,0,1]]},[0,0,2,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"t":[{},[0,0,2]]}],"ü":[{},[0,0,2,1,2]],"z":[{"a":[{"g":[{},[0,0,2]],"k":[{"a":[{},[0,0,2]]}],"l":[{},[0,0,2]],"r":[{},[0,0,2]],"v":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,0,1]],"r":[{"k":[{},[0,0,2]],"o":[{},[0,0,2,0,1,2]]}]}],"e":[{"l":[{},[0,0,0,0,1]],"m":[{},[0,0,0,0,1]],"r":[{},[0,0,0,0,1]]},[0,0,2]],"é":[{"b":[{},[0,0,2]]}],"i":[{"p":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{},[0,0,2,0,1,2]],"k":[{"á":[{"i":[{},[2]]}]}],"ö":[{},[0,0,2,0,1]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,0,3]],"u":[{"s":[{},[0,0,2,0,1]]}],"ú":[{},[0,0,2,0,1]],"ü":[{},[0,0,2,0,1,2]],"ű":[{},[0,0,2,0,1]]}]}],"t":[{"a":[{"l":[{},[0,0,0,1]]},[2,1,2]],"á":[{},[2,1,2]],"d":[{},[2,1]],"e":[{},[0,0,2,1,2]],"é":[{},[2,1,2]],"f":[{},[2,1]],"í":[{},[2,1,2]],"j":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"r":[{},[2,1]],"u":[{},[3]],"ú":[{},[2,1,2]],"v":[{},[2,1]]}]},[1]],"b":[{"a":[{"l":[{},[0,0,0,2,1]]}],"l":[{"o":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"r":[{"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"c":[{"l":[{"u":[{},[0,0,2]]}],"s":[{"a":[{"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]]}]}]}]}]}],"d":[{"e":[{"l":[{"h":[{},[0,0,1]]}]}],"i":[{"d":[{},[0,2,1,2]]}],"í":[{"s":[{},[0,0,0,2]]}],"o":[{"d":[{},[0,2,1,2]]}],"r":[{"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"z":[{"s":[{},[0,3]]},[0,2]]}],"e":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"c":[{},[0,0,2]],"d":[{},[0,0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"g":[{"y":[{},[0,0,2]]}],"h":[{},[0,0,2]],"í":[{},[0,0,2]],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]]}],"m":[{},[0,0,2]],"n":[{},[0,0,0,2]],"o":[{},[0,0,2]],"p":[{},[0,0,2]],"s":[{"z":[{"f":[{},[0,0,2]]},[0,0,0,1,0,2]]}],"t":[{},[0,0,2]]}],"b":[{"é":[{},[2,1,2]]}],"d":[{"e":[{"l":[{"l":[{},[0,0,0,1]]}]}],"é":[{"n":[{},[2,1,2]]}],"ó":[{"v":[{},[0,0,2,1,2]]}],"r":[{"a":[{},[0,0,1]]}],"ú":[{},[0,0,2,1,2]],"z":[{},[2,1,2]]}],"e":[{"p":[{},[0,0,2]],"s":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"f":[{},[2,1]],"r":[{},[0,0,1]]}],"g":[{"a":[{"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"l":[{},[0,0,2,1,2]],"n":[{"n":[{},[0,0,0,0,0,3]]}],"r":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2,1]],"r":[{"i":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,1]],"z":[{},[0,0,0,0,0,0,1]]},[0,0,2]]}],"g":[{},[0,0,0,3]],"i":[{"z":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2]]},[2]],"ö":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"ő":[{},[2,0,2]],"y":[{"e":[{"z":[{},[0,0,0,0,0,0,1]]},[2,1,2]]}],"z":[{},[2]]}],"h":[{"h":[{},[2,1]],"o":[{"g":[{},[0,0,0,0,2]]}]}],"i":[{"f":[{},[0,0,2]],"g":[{},[0,0,0,2]]}],"í":[{"r":[{},[0,0,0,2]]}],"k":[{"a":[{"k":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"l":[{"e":[{"n":[{},[0,0,2]]}]}]}],"p":[{},[0,0,2]],"r":[{"ő":[{},[0,0,0,1,2]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"é":[{"k":[{"b":[{},[0,0,0,1]],"e":[{},[0,0,0,1,2]]}],"l":[{},[0,0,2,1]],"r":[{"i":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1]],"z":[{},[0,0,2,1]]}]}],"l":[{"u":[{},[0,0,1]]}],"o":[{"l":[{"d":[{},[0,0,0,1]]}]}],"s":[{"z":[{},[0,0,0,0,0,2]]},[0,0,0,1]]}],"l":[{"a":[{"d":[{},[2,1]]}],"e":[{"f":[{},[0,0,2]],"g":[{"y":[{},[2,1,2]]}],"m":[{"a":[{},[0,0,0,0,2,1]],"á":[{},[0,0,0,0,2]],"e":[{"g":[{},[0,0,0,0,2]],"k":[{},[0,0,2]],"l":[{"e":[{},[0,0,0,0,0,1]]},[0,0,0,0,2]]}],"u":[{},[0,0,0,0,2]],"ű":[{},[2,1,2]],"z":[{},[2,1,2]]}],"t":[{"a":[{},[0,0,0,0,2,1,2]],"e":[{"t":[{"é":[{},[2,1]]}]}]}]}],"é":[{"k":[{},[2,1,2,1,2]],"l":[{},[2,1,2]],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"h":[{"a":[{},[2,1]],"o":[{},[2,1]]}],"k":[{"e":[{"z":[{"d":[{"é":[{},[2]],"ő":[{},[2]]}]}]}]}],"l":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}],"e":[{"g":[{},[0,0,0,2,1,2]],"l":[{"e":[{},[0,0,0,2,1]],"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"n":[{"á":[{},[2]],"e":[{},[2,1]],"t":[{},[0,0,0,2,1]]}],"r":[{},[0,0,0,2]]}],"é":[{"j":[{},[0,0,0,2,1,2]],"k":[{},[0,0,0,2,1,2]]}],"i":[{"n":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]}],"o":[{"s":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"ő":[{"r":[{},[0,0,0,2]]}]}],"m":[{"a":[{},[2,1]]}],"n":[{"ö":[{},[2,1]]}],"o":[{"s":[{},[0,0,2]]}],"ö":[{"l":[{},[0,0,2]]},[2]],"ő":[{"a":[{"d":[{},[0,0,2]]}],"k":[{"a":[{},[2,1,2]]}],"r":[{"e":[{"j":[{},[2]]}]}]}],"s":[{"a":[{},[2,1]]}],"t":[{"e":[{"t":[{"t":[{".":[{},[2,1]]}]}]}],"é":[{"r":[{},[2,1]]}]}],"v":[{".":[{},[2,1]],"á":[{},[2,1]],"e":[{"s":[{},[2,1]]}],"o":[{},[2,1]],"ű":[{".":[{},[2,1]],"e":[{},[2,1]],"k":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]]}]}]}],"m":[{"a":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"z":[{},[0,0,2]]}],"é":[{"r":[{"e":[{"m":[{},[0,0,2,1,2]]}],"m":[{},[0,0,2,1]]}]}],"i":[{"m":[{},[0,0,2]],"n":[{"g":[{},[0,0,0,1]]}]}],"o":[{"i":[{},[2]]}],"p":[{},[0,0,0,1]],"u":[{"s":[{},[0,0,2]]}],"ü":[{"l":[{},[0,0,0,0,2]]}]}],"n":[{"a":[{"l":[{},[0,0,2]]}],"e":[{"r":[{},[2,1,2]]}],"k":[{"i":[{"é":[{"n":[{"e":[{},[0,0,0,0,0,0,2]]}]}]}]}],"o":[{"l":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,1]]}]}],"o":[{"d":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{},[0,0,2,1,2]],"j":[{},[0,0,2]],"l":[{"o":[{},[0,0,2]]}],"m":[{},[0,0,2]],"t":[{},[0,0,2]]}],"p":[{"e":[{".":[{},[0,0,2]]}],"é":[{},[2,1,2]],"r":[{"e":[{},[0,0,1,2]],"o":[{},[0,0,1]]}],"s":[{},[0,0,1,2]]}],"r":[{"a":[{"d":[{},[0,0,2]],"k":[{"a":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,0,2]]}],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]]}],"á":[{"g":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2]],"z":[{"t":[{},[0,0,0,1]]}]}],"d":[{"ő":[{},[2]]}],"e":[{"c":[{},[0,0,0,0,2]],"d":[{"m":[{},[2]]}],"j":[{"e":[{},[2,1,2]],"é":[{"n":[{},[2]],"r":[{},[2]],"t":[{},[2,1,2]]}]}],"k":[{"e":[{"i":[{},[0,0,2,1,2]]}]}],"l":[{"e":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1]],"ő":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1]]}],"r":[{},[0,0,2]],"s":[{"ő":[{},[0,0,2,1,2]]}]}],"é":[{"l":[{},[0,0,2,1]]}],"i":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1,2]]}],"n":[{"é":[{"k":[{},[0,0,0,2]]}]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ő":[{".":[{},[0,1]],"s":[{".":[{},[0,0,0,1]]}],"t":[{},[0,1]],"v":[{},[0,1]]},[0,0,2]],"s":[{"p":[{},[0,0,0,1]]}],"u":[{"t":[{},[0,0,2]]},[0,0,0,0,2]],"ü":[{"g":[{},[0,0,2,1,2]],"l":[{"d":[{},[0,0,2,1]],"e":[{},[0,0,0,1]],"t":[{"e":[{"t":[{},[0,0,0,1]]}]}]}]}],"v":[{"i":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}]}],"s":[{"a":[{},[2,0,2,1,2]],"g":[{},[2]],"i":[{"p":[{},[0,0,2]]}],"k":[{"ü":[{},[2]]}],"t":[{"e":[{"s":[{},[2]]}],"o":[{},[0,0,1]]}],"u":[{"r":[{},[0,0,2]]}],"ú":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"z":[{"m":[{},[2,1]],"t":[{"a":[{},[0,0,1,0,2]]}],"ű":[{".":[{},[0,0,2]]}]}]}],"t":[{"é":[{"k":[{},[0,0,2,1]]}],"i":[{"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}]}]}],"v":[{"ő":[{},[2,1,2]],"v":[{},[2,1]]}],"x":[{"a":[{},[0,0,2]],"i":[{"n":[{},[0,0,2]],"z":[{},[0,0,2]]},[0,0,0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2]]}],"z":[{"a":[{"k":[{},[0,0,2]]},[2]],"é":[{"r":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,1]]}],"ő":[{"e":[{},[0,0,0,0,0,2]],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"r":[{},[2,1]]}]},[1]],"é":[{"b":[{"r":[{},[2,1]]}],"d":[{"a":[{"p":[{},[0,0,2]]}],"ő":[{},[0,0,2,1]],"u":[{},[0,0,2]]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"b":[{},[0,0,2,1,2]],"g":[{},[0,0,2,1]]}],"é":[{"p":[{},[0,0,2]],"r":[{"k":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,0,1]]},[0,0,2]]}],"g":[{},[0,0,0,3]],"i":[{"g":[{"a":[{},[0,0,0,1]],"é":[{},[0,0,2]]}],"n":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"k":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"s":[{},[0,0,0,1]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"h":[{"e":[{"s":[{},[2,1,2]]}],"s":[{},[2,1]]}],"j":[{".":[{},[2,1]],"b":[{},[2,1]]}],"k":[{"a":[{"b":[{},[0,0,2,1]],"c":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"u":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2,1]],"r":[{"t":[{},[0,0,2,1]]}],"s":[{},[0,0,2]],"t":[{"a":[{},[0,0,0,0,0,1,2]]}]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,2,1]],"l":[{},[0,0,0,1]],"ő":[{},[0,0,0,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}],"t":[{"i":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"é":[{"j":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"r":[{".":[{},[0,0,2,1]]}],"t":[{"e":[{},[0,0,2,1]]}]}],"i":[{"s":[{"z":[{},[0,0,0,1]]}],"v":[{"á":[{},[0,0,2]]}]}],"í":[{},[0,0,2]],"k":[{"u":[{"l":[{"c":[{"s":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"o":[{"l":[{"d":[{},[0,0,2,1]]}],"p":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{"v":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"r":[{"é":[{"m":[{},[0,0,0,2]]}]}],"u":[{"t":[{},[0,0,2,1]]}]}],"l":[{"a":[{"d":[{},[0,0,2]],"m":[{},[0,0,2]]}],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2]],"l":[{"ő":[{},[0,0,0,1]]},[0,0,2,0,2]],"s":[{"t":[{},[0,0,0,1]]},[0,0,2]],"t":[{},[2,1,2]]}],"i":[{"m":[{},[0,0,2]],"o":[{},[0,0,2]]}],"k":[{"ö":[{"z":[{"ö":[{"n":[{},[0,0,0,0,0,2,1]]}]}]}]}],"o":[{},[0,0,2]],"ö":[{},[0,0,2,1,2]],"ő":[{},[2,1,2]],"u":[{},[0,0,2,1,2]],"ü":[{"k":[{},[0,0,2]]}],"y":[{"ö":[{},[0,0,2]]}]}],"m":[{"e":[{"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1,2]]}]}],"n":[{"a":[{"c":[{},[0,0,0,1]]},[0,0,0,0,2]],"á":[{"r":[{"a":[{},[0,0,0,0,0,1,2]]}]}],"e":[{"k":[{"e":[{},[2,1,2]]}]}],"y":[{"e":[{"l":[{},[0,0,2,0,1]]}],"i":[{"d":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ö":[{},[0,0,2]]}]}],"p":[{"i":[{},[0,0,0,2]],"í":[{},[2,1,2]],"ü":[{},[2,1,2]]}],"r":[{"a":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{},[0,0,2]],"d":[{},[0,0,0,1,2]],"e":[{"g":[{},[0,0,2]],"m":[{"l":[{},[0,0,0,1]]}],"s":[{"é":[{},[0,0,0,1]],"t":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"é":[{"s":[{},[0,0,2]]}],"i":[{"f":[{},[0,0,2]],"k":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"o":[{"t":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{},[0,0,2]],"t":[{"é":[{},[2,1]],"h":[{},[2,1]]}],"ú":[{"t":[{},[0,0,2,1]]}],"y":[{},[0,0,1]],"z":[{"é":[{},[2,1]]}]}],"s":[{"a":[{"j":[{},[0,0,2,1]],"l":[{},[0,0,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2]],"z":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"t":[{"i":[{},[0,0,2,1]]}]}],"é":[{"g":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{"t":[{},[0,0,2,1,2]]}],"z":[{"a":[{"k":[{},[0,0,0,0,1]]}],"á":[{},[0,0,2,3]],"é":[{"k":[{},[0,0,2,0,1]],"v":[{},[0,0,2]]}],"o":[{},[0,0,2,0,1]],"ú":[{},[0,0,2]]}]}],"t":[{"a":[{"s":[{},[0,0,2,1]]}],"e":[{"g":[{},[0,0,2,1,2]]}],"i":[{"s":[{},[0,0,2,1]]}],"k":[{"e":[{},[2,1]]}],"ő":[{"r":[{},[0,0,2]]}]}],"v":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{".":[{},[2,1,2]],"i":[{},[2]],"k":[{},[2,1,2]],"m":[{},[2,1,2]],"n":[{},[2,1,2]],"s":[{".":[{},[2,1,2]],"b":[{},[2]],"e":[{"k":[{},[2,1,2]],"n":[{},[2,1,2]]}],"h":[{},[2,1,2]],"i":[{},[2]],"k":[{},[2]],"n":[{},[2,1,2]],"r":[{},[2]],"s":[{},[2,1,2]]}],"t":[{},[2,1,2]],"z":[{},[2,1]]}],"é":[{"b":[{},[2,1,2]],"i":[{},[2,1,2]],"n":[{},[2]],"r":[{},[2]],"t":[{},[2,1,2]],"v":[{},[2,1,2]]}],"f":[{},[2,1]],"h":[{},[2,1]],"i":[{},[2,1,2]],"k":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"u":[{},[2,1,2]],"ü":[{},[2,1,2]],"v":[{},[2,1]],"z":[{},[2,1]]}]},[1]],"f":[{"é":[{"n":[{"y":[{"e":[{"m":[{},[0,0,0,2]]}]}]}]}],"l":[{"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]]}]}],"g":[{"á":[{"z":[{"á":[{"r":[{},[0,0,0,2]],"t":[{},[0,0,0,0,0,0,1]]}],"i":[{},[0,0,0,2]],"ó":[{},[0,0,0,2]]}]}],"e":[{".":[{},[0,2]]}],"l":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"y":[{"u":[{},[0,2]]}]}],"h":[{"a":[{"l":[{"i":[{},[0,2]]}],"n":[{"g":[{"e":[{},[0,0,0,0,2,1]]}]}]}],"é":[{"t":[{},[0,0,0,2,1]]}],"i":[{".":[{},[0,2]],"é":[{},[0,2]],"h":[{},[0,2]],"i":[{},[0,2]],"j":[{},[0,2]],"k":[{},[0,2]],"r":[{},[0,2]]}],"ú":[{"s":[{"á":[{},[0,0,0,2,1,2]]}]}]}],"i":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]],"r":[{},[0,0,2]]},[0,0,0,1]],"c":[{},[0,0,2]],"d":[{"a":[{},[0,0,0,3]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]},[0,0,0,1,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{"a":[{},[0,0,2]]}],"g":[{"y":[{},[0,0,2]]}],"h":[{},[0,0,2]],"i":[{"k":[{},[0,0,2,0,2]]}],"í":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{"é":[{"p":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]}]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"m":[{},[0,0,2]],"n":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"r":[{"a":[{},[0,0,2]]}],"s":[{"z":[{"a":[{},[0,0,2]],"k":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"t":[{},[0,0,2,1,2]],"u":[{},[0,0,2,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"k":[{"e":[{},[0,0,0,2,1]],"o":[{"l":[{},[0,0,0,2]]}]}],"n":[{"n":[{},[0,0,0,0,3]]}]}],"c":[{"k":[{},[0,0,1,2]],"s":[{"a":[{"j":[{},[0,0,2,0,1]]}],"e":[{"r":[{},[0,0,2,0,1,2]]}]}]}],"d":[{"e":[{"g":[{},[2,1,2]],"j":[{},[2]],"o":[{},[0,0,2]]}],"é":[{"n":[{},[2,1,2]]}],"i":[{"o":[{},[0,0,2,1,2]]}],"ő":[{},[2,1,2]]}],"e":[{"u":[{},[0,0,2]]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"a":[{".":[{},[0,0,2]]}],"á":[{"n":[{"á":[{},[2,1,2]]}]}],"e":[{".":[{},[0,0,2]],"l":[{},[0,0,2,1,2]]}],"é":[{"n":[{},[2,1,2]],"t":[{},[0,0,2]]}]}],"j":[{"e":[{"s":[{},[2]]}]}],"k":[{"é":[{"p":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"o":[{"n":[{"h":[{},[2,1,2]]}]}],"r":[{"o":[{},[0,0,1,2]]}],"u":[{"t":[{"a":[{},[0,0,0,1,2]]}]}],"v":[{},[0,0,1,2]]}],"l":[{"a":[{"n":[{},[0,0,2]]}],"e":[{"m":[{},[0,0,0,0,2]]}],"i":[{"g":[{},[0,0,0,0,0,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2,1]],"ü":[{},[0,0,2]],"y":[{},[0,0,1]]}],"m":[{"a":[{".":[{},[0,0,2]]}],"á":[{},[2,1,2]],"i":[{"t":[{},[0,0,2]]}],"p":[{},[2,1]]}],"n":[{"a":[{"k":[{"a":[{},[2,1,2]]}]}],"d":[{},[2]],"f":[{},[2,1]],"g":[{"a":[{"l":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{},[2,1]],"e":[{"r":[{},[2,1]]}]}],"i":[{"c":[{},[2,1,2]],"n":[{"g":[{},[0,0,2,1]]}]}],"j":[{},[2,1]],"ó":[{"d":[{},[0,0,2]],"m":[{},[0,0,2,1]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]]}],"p":[{},[2,1]],"t":[{"é":[{},[2,1]]}],"v":[{},[2,1]]}],"o":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2]],"m":[{"e":[{},[0,0,2]]}],"v":[{},[0,0,2]]}],"ó":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"g":[{},[0,0,2]],"í":[{},[0,0,2]],"k":[{"a":[{"m":[{},[0,0,2]]}],"á":[{},[0,0,2]],"l":[{},[0,0,2,1]],"o":[{"k":[{},[0,0,2]]}],"u":[{},[0,0,2]]}],"m":[{"é":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"r":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"s":[{"i":[{"k":[{},[0,0,0,0,1]]},[0,0,0,2,0,2]],"o":[{"r":[{".":[{},[0,0,3]]}]}],"p":[{"e":[{},[0,0,2]]}],"z":[{"ű":[{},[0,0,2]]}]}],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"p":[{"a":[{"r":[{".":[{},[2]],"á":[{},[2,1,2]],"b":[{},[2]],"i":[{},[2,1,2]],"o":[{},[2,1,2]]}]}]}],"r":[{"a":[{"t":[{},[2,1,2]]}],"á":[{},[2,1,2]],"o":[{"d":[{},[2,1,2]]}],"t":[{},[2,1]]}],"s":[{"a":[{"j":[{},[0,0,2]]}],"i":[{".":[{},[2,1,2]]}],"k":[{"o":[{},[2,1]]}],"m":[{},[2,1]],"t":[{"e":[{},[2,1]]}]}],"t":[{"a":[{"l":[{"a":[{},[0,0,0,1,2]]},[0,0,2]],"r":[{"á":[{},[0,0,0,1]]}]}],"e":[{"g":[{},[0,0,2,1,2]]}],"t":[{},[0,0,0,1,2]],"ü":[{},[0,0,2]]}],"u":[{"m":[{"é":[{"n":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"i":[{"l":[{},[0,0,0,2]]}]}]}],"ú":[{"t":[{},[0,0,0,2]]}],"v":[{"a":[{"d":[{},[0,0,2]],"r":[{},[2,1,2]],"t":[{"a":[{},[0,0,0,0,2,1]]}]}]}],"z":[{"é":[{},[2,1,2]]}]},[1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"j":[{"á":[{"t":[{"o":[{},[0,0,2,1]]}]}],"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"á":[{},[2,1,2]],"i":[{"k":[{},[0,0,2]]},[0,0,0,0,2]],"ó":[{},[2,1,2]]}],"s":[{"z":[{"a":[{},[0,0,2,0,1]],"e":[{"r":[{},[0,0,2]]}],"ö":[{},[0,0,2]]}]}],"t":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}]}],"v":[{".":[{},[2,1]],"e":[{},[2,1,2]],"n":[{},[2]],"ü":[{},[2,1,2]],"ű":[{},[2,1,2]]}],"z":[{"i":[{},[0,0,2]],"s":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"j":[{"e":[{"g":[{"y":[{"a":[{},[0,0,0,2]]}]},[0,0,2]]}],"i":[{"s":[{},[0,0,1]]}],"o":[{"n":[{},[0,0,0,2,1]]}]}],"k":[{"a":[{"n":[{"á":[{},[0,0,0,2,1,2]]}]}],"i":[{"a":[{},[0,0,0,0,2]],"e":[{},[0,0,0,0,2]]}],"l":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]]}]}],"l":[{"á":[{"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}]}],"e":[{"í":[{},[0,0,0,0,2]]}],"ó":[{"g":[{},[0,0,0,1,2]],"t":[{},[0,0,0,0,2]]}],"ő":[{"k":[{"r":[{},[0,0,0,1]]}]}]}],"m":[{"e":[{"g":[{"é":[{"r":[{},[0,0,0,2,1]]}]}]}]}],"n":[{"a":[{"p":[{"e":[{},[0,0,0,2]]}]}],"é":[{"v":[{"á":[{},[0,0,0,2,1]]}]}],"ö":[{"k":[{"ö":[{"l":[{},[0,0,0,2,1,2]]}]}]}]}],"o":[{"á":[{"z":[{},[0,0,2]]}],"b":[{"a":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"n":[{"y":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"á":[{"r":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"l":[{"l":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2]],"j":[{"e":[{},[2]]}],"o":[{"á":[{},[0,0,2]],"l":[{"d":[{},[0,0,2,1]]}],"r":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"d":[{"ú":[{},[2,1,2]]}],"g":[{"a":[{"r":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"á":[{"r":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"r":[{"á":[{},[0,0,1,2]]}],"ü":[{},[0,0,2]]}],"k":[{"a":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"j":[{},[0,0,2]],"l":[{},[0,0,2,1]]}],"e":[{},[0,0,2,1]],"é":[{"l":[{},[0,0,2,1,2]],"p":[{},[0,0,2]]}],"k":[{"ö":[{"b":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"ő":[{},[0,0,0,2]]}],"o":[{"t":[{"t":[{},[0,0,2,1]]}],"z":[{},[2,1,2]]}],"ö":[{},[0,0,2]],"ú":[{"t":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ü":[{},[0,0,2]]}],"l":[{"a":[{"j":[{},[2,1,2]],"t":[{"a":[{"r":[{},[0,0,0,0,2]]}],"e":[{},[0,0,0,0,2,1]],"ö":[{"r":[{},[0,0,0,0,2,1]]}]}]}],"d":[{"a":[{},[2,1]],"á":[{},[2,1]],"o":[{},[2,1]],"ó":[{},[2,1]]}],"t":[{"á":[{"r":[{},[2,1]],"s":[{},[2,1]]}]}],"v":[{"a":[{"s":[{},[2]]}]}]}],"m":[{"a":[{"c":[{"é":[{},[0,0,0,1,2]]}]}],"á":[{"r":[{"b":[{},[0,0,2,1]],"é":[{},[0,0,2,1]],"h":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"o":[{"n":[{},[0,0,2,1,2]]}],"r":[{},[0,0,2,1]],"t":[{"ó":[{},[0,0,2,1]]}]}]}],"b":[{"a":[{"l":[{},[0,0,0,2,0,2]]}],"e":[{"l":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"ó":[{"n":[{},[0,0,0,2]]}]}],"e":[{"l":[{},[0,0,2]]}],"í":[{},[2]],"l":[{},[2]],"o":[{"n":[{"d":[{},[0,0,2,1]]}]}],"ő":[{},[0,0,2]],"ú":[{},[2]],"ü":[{},[0,0,2]]}],"n":[{"a":[{"d":[{},[0,0,2,1]],"l":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]],"t":[{"a":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}]}],"d":[{},[0,0,0,1,2]],"e":[{},[0,0,2,1]],"o":[{"s":[{"s":[{},[0,0,0,0,0,1]],"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ü":[{},[0,0,2]],"y":[{"a":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"e":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"p":[{"e":[{},[2,1,2]],"l":[{},[0,0,1,2]]}],"r":[{"a":[{"k":[{"n":[{},[0,0,0,1]]}],"l":[{},[0,0,2,1,2,1]],"p":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,0,1]],"o":[{},[0,0,2,1,2]]}]}],"d":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"e":[{},[0,0,2,1,2]],"i":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"t":[{"a":[{},[0,0,2,1]]}]}],"k":[{},[0,0,0,1,2]],"o":[{"k":[{"l":[{},[0,0,2,1]]}],"s":[{"z":[{"t":[{},[0,0,0,1]]}]}]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"r":[{"ú":[{},[2,1]]}],"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"r":[{"ó":[{},[0,0,0,1]]}]}],"ú":[{"t":[{},[0,0,0,0,2]]}],"ü":[{},[0,0,2]],"v":[{"o":[{"s":[{},[2]]}]}]}],"u":[{"g":[{},[0,0,2]],"t":[{},[0,0,2]]}],"v":[{"i":[{},[0,0,2]]}],"y":[{"e":[{},[0,0,1]]}]},[1]],"ó":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"z":[{},[2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"á":[{},[2]],"r":[{},[0,0,1,2]]}],"i":[{"g":[{},[0,0,0,2]]}],"í":[{"v":[{},[0,0,0,2]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{"é":[{},[0,0,1]]}],"v":[{},[0,0,1,2]]}],"m":[{"a":[{"b":[{},[0,0,2]],"k":[{},[0,0,2]]}],"o":[{"r":[{"g":[{},[0,0,0,1]]}]}],"ő":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"á":[{"d":[{},[0,0,2]],"k":[{},[0,1,2]]}],"i":[{"á":[{},[0,0,2]]}]}],"s":[{"a":[{"m":[{},[0,0,2]],"s":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2]]}],"i":[{".":[{},[3]],"p":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,2]]}],"k":[{"á":[{},[0,0,1,2]]}],"p":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1,2]]}],"s":[{},[0,0,0,3]],"t":[{"á":[{"b":[{},[0,0,1]]}],"r":[{},[0,0,1]]}],"ű":[{},[0,0,2,1,2]],"z":[{"f":[{},[0,0,1]],"p":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"v":[{"ó":[{},[2,1,2]]}]},[1]],"ö":[{"b":[{"l":[{},[0,1]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2,1]],"v":[{},[0,0,2]]}],"g":[{},[0,0,0,3]],"n":[{"a":[{},[0,0,0,0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{"l":[{"ő":[{},[0,0,0,1,2]]}]}],"ő":[{},[0,0,2,1]],"u":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]]}],"é":[{"k":[{},[0,0,2]],"r":[{".":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2]]}],"n":[{"t":[{"ö":[{"z":[{},[2]]}]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{"k":[{"s":[{},[2,1,2]]}]}]}],"s":[{"z":[{},[2,1]]}],"t":[{"l":[{},[0,1]],"t":[{"é":[{"r":[{"t":[{},[0,0,0,2]]}]}]}]}],"v":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]]}]},[1]],"ő":[{"a":[{"n":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"l":[{},[0,0,1]]}],"d":[{"r":[{"a":[{},[0,0,1]]}]}],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2]],"t":[{"e":[{},[0,0,0,2]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"é":[{"p":[{"e":[{"k":[{"é":[{},[0,0,0,0,2,1,2]]}]}]}]}],"r":[{},[0,0,1]]}],"i":[{"r":[{"á":[{},[0,0,0,0,0,2]]}],"t":[{"a":[{},[0,0,0,2]]}]}],"k":[{"l":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{"y":[{"a":[{},[0,0,2,0,1]],"e":[{"l":[{"e":[{},[0,0,2]]}]}]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"á":[{"b":[{},[2]],"l":[{},[2,1]]}],"e":[{"b":[{},[2,1,2]],"g":[{"y":[{},[0,0,0,1]]}],"l":[{"e":[{},[0,0,0,1]],"ő":[{},[0,0,0,1]]}],"m":[{},[2,1,2]]}],"é":[{".":[{},[2,1,2]],"h":[{},[2,1,2]],"k":[{},[2]],"l":[{},[2,1]],"n":[{},[2]]}],"h":[{},[2,1]],"i":[{"f":[{},[2,1]],"l":[{},[2,1,2]],"n":[{},[2,1,2,1]],"p":[{},[2,1,2]],"s":[{},[0,0,2,1]]}],"o":[{"k":[{},[2]],"r":[{},[2,1]],"s":[{},[2]]}],"ö":[{"d":[{},[0,0,2]],"z":[{},[0,0,2,1]]}],"ő":[{"r":[{},[2]]}],"u":[{"n":[{},[2]],"r":[{},[2]],"t":[{},[2,1,2]]}],"ü":[{"g":[{},[0,0,0,1]],"l":[{},[0,0,0,1]]},[2,1,2,0,2]],"z":[{},[2,1]]}],"s":[{"é":[{"r":[{"v":[{},[0,0,2,1]]}]}],"k":[{"á":[{},[0,0,1]]}],"m":[{},[0,0,1,2]],"n":[{"i":[{},[0,0,1]]}],"o":[{"d":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"p":[{"e":[{},[0,0,1]],"i":[{},[0,0,1,2]],"ó":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1,2]],"é":[{},[0,0,1]],"r":[{},[0,0,1]]}],"v":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"t":[{"á":[{"l":[{"l":[{},[0,0,0,1]]}]}],"r":[{},[0,0,1,2]]}]},[1]],"p":[{"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}]}],"r":[{"a":[{"p":[{"s":[{},[0,0,0,1]]}],"v":[{"a":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"á":[{"g":[{"g":[{},[0,0,0,0,1]]}],"s":[{"z":[{"á":[{"l":[{},[0,0,0,2,0,1]]}],"e":[{},[0,0,0,2]]}]}],"t":[{"a":[{"l":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"e":[{},[0,0,0,2,1,2]],"é":[{"r":[{},[0,0,0,2,1]]}]}]}],"e":[{"n":[{"d":[{"ő":[{},[0,0,0,0,2,1,2]]}]}],"s":[{"s":[{"z":[{".":[{},[1,2]],"b":[{},[1,2]],"e":[{},[1,2]],"h":[{},[1,2]],"k":[{},[1,2]],"r":[{},[1,2]],"ü":[{},[1,2]]}]}]}]}],"é":[{"s":[{"z":[{"á":[{},[0,0,0,2]]}]}]}],"o":[{"g":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2]],"e":[{"n":[{},[0,0,0,2]]}],"é":[{"n":[{"i":[{},[0,0,0,0,0,2,1,2]]}]}],"g":[{},[0,0,0,0,3]],"ó":[{},[0,0,0,2,1,2]]}],"n":[{"a":[{},[0,0,0,2,1,2]],"y":[{"i":[{},[0,0,0,2]]}]}],"s":[{"z":[{"f":[{},[0,0,0,1]]},[0,0,0,0,0,2]]}],"t":[{"r":[{},[0,0,0,1,2]]}]}],"ó":[{"b":[{"a":[{"j":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1,2]],"i":[{"s":[{},[0,0,0,2]]}],"ü":[{},[0,0,0,2,1,2]]}]}],"u":[{"i":[{},[0,2]],"s":[{"e":[{},[0,0,0,2]],"i":[{},[0,0,0,2]]}]}]}],"s":[{"á":[{"g":[{"g":[{},[0,0,0,0,1]]}]}],"é":[{"g":[{"e":[{"l":[{},[0,0,0,2,1]]}],"ü":[{"l":[{},[0,0,0,2]]}]}]}],"k":[{"á":[{},[0,0,2]]}],"l":[{"i":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"í":[{},[0,0,2]],"r":[{},[0,0,0,2]]}],"z":[{"a":[{"k":[{"é":[{},[0,0,0,0,2]]}]}],"á":[{"l":[{"a":[{"s":[{},[0,0,0,0,2]]}]}],"r":[{"a":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"e":[{"r":[{"a":[{},[0,0,0,0,2]],"á":[{},[0,0,0,0,2,1]],"e":[{"l":[{"v":[{},[0,0,0,0,2,1]]}]}],"o":[{},[0,0,0,0,2,1]],"t":[{},[0,0,0,0,0,0,2]]}]},[0,0,0,2]],"l":[{},[0,1,0,2]],"n":[{},[0,1]],"p":[{},[0,1,0,2]],"t":[{},[0,1,0,2,2]],"v":[{},[0,1,0,2]]}]}],"t":[{"a":[{"g":[{"a":[{},[0,0,0,2,1,2]]}],"l":[{"p":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]],"l":[{},[0,0,0,0,2,1]]}]}]}],"n":[{"á":[{"s":[{},[0,0,0,2,1,2]]}]}]}],"é":[{"k":[{"n":[{},[0,2,1]]}]}],"r":[{"á":[{},[0,1,2]],"é":[{},[0,1,2]],"i":[{},[0,1,2]],"o":[{},[0,1,2]],"ó":[{"f":[{},[0,1,2]]}]}],"ü":[{"l":[{},[0,2,1]]}]}],"u":[{"c":[{"e":[{"m":[{},[0,0,2]]}],"h":[{},[0,0,2,3]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,0,2]]}],"g":[{"a":[{"l":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2,1]]}],"r":[{},[2,1]]}],"i":[{"t":[{},[2]]}],"j":[{"j":[{},[2,1]]}],"l":[{"a":[{"k":[{},[0,0,0,0,1,2]],"t":[{"í":[{},[0,0,0,0,2,1]]}]}],"e":[{},[0,0,2,1]],"é":[{"p":[{},[0,0,2]]}],"i":[{"m":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2]]},[0,0,0,0,2]],"í":[{},[0,0,2]],"ö":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"n":[{"i":[{},[2,1,2]],"o":[{},[2,1,2]],"t":[{},[2,1]]}],"ó":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"d":[{},[0,0,2]],"f":[{},[0,0,2]],"l":[{},[0,0,2]],"p":[{},[0,0,2]]}],"r":[{"a":[{"i":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2]],"t":[{},[2,1,2]]}],"á":[{"b":[{},[0,0,2]],"h":[{},[0,0,2]],"t":[{},[0,0,2]]}],"u":[{"k":[{},[0,0,2]]}]}],"s":[{"a":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2]]}],"é":[{"r":[{"t":[{"é":[{},[0,0,2,1]]}]}]}],"i":[{"n":[{},[0,0,2]],"v":[{},[0,0,2,1]]}],"o":[{"l":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"ű":[{},[0,0,2,1]],"z":[{"o":[{"d":[{},[2,1,2]],"k":[{"a":[{},[2,1,2]],"b":[{},[2,1,2]],"é":[{},[2,1,2]],"h":[{},[2,1,2]],"k":[{},[2,1,2]],"n":[{},[2,1,2]],"o":[{},[2,1,2]],"r":[{},[2,1,2]],"t":[{},[2,1,2]]}],"m":[{},[2,1,2]]}],"s":[{},[0,0,0,3]]}]}],"t":[{"i":[{},[0,0,2,1]],"o":[{},[2,1,2]],"ó":[{".":[{},[0,0,2]],"r":[{},[0,0,2]]}],"u":[{},[0,0,2]]}]},[1]],"ú":[{"c":[{"e":[{},[0,0,2]],"h":[{},[0,0,2]],"s":[{"e":[{},[0,0,2]],"o":[{},[0,0,2,3]],"z":[{},[0,0,0,3]]}]}],"d":[{"r":[{},[0,0,1]]}],"j":[{"é":[{},[0,0,2,1,2]],"í":[{},[0,0,2]]}],"r":[{"a":[{"c":[{},[0,0,2,1,2]],"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"é":[{"n":[{},[0,0,2]]}],"o":[{"n":[{},[2,1,2]]}],"ö":[{},[0,0,2]]}],"s":[{"z":[{"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"t":[{"a":[{},[0,0,2,1,2]],"é":[{},[0,0,2]],"j":[{},[2,1]],"l":[{},[0,1]],"n":[{},[2,1]],"o":[{"n":[{},[0,0,2]]}],"r":[{},[2,1]]}]},[1]],"ü":[{"d":[{"ü":[{},[0,0,2]]}],"g":[{"y":[{"é":[{"r":[{"n":[{},[0,0,0,0,1]]}]}]},[0,0,2]]}],"h":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"k":[{"é":[{"t":[{},[0,0,2]]}]}],"l":[{"á":[{},[0,0,2]],"d":[{},[2,1]],"e":[{"p":[{},[0,0,2]]}],"ő":[{"s":[{},[0,0,0,0,0,2]]}]}],"n":[{"n":[{"e":[{},[2,1]]}]}],"r":[{"í":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]]}]},[1]],"ű":[{"p":[{"r":[{},[0,0,1]]}],"r":[{"l":[{},[0,1]]}],"s":[{"z":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1]]}],"z":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[1]],"v":[{"a":[{"r":[{"a":[{"j":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"ó":[{},[0,0,0,2,1,2]]}]}],"á":[{"n":[{"y":[{"a":[{"n":[{},[0,0,0,2]]}],"í":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}]}],"e":[{"c":[{"e":[{},[0,0,1]]}],"l":[{"e":[{"g":[{},[0,0,1,2]]}],"k":[{},[0,0,1]]}],"n":[{"t":[{"í":[{},[0,0,0,0,2,1]]}]}],"r":[{"a":[{"l":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]}],"i":[{"p":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,1]]}],"s":[{"é":[{"s":[{},[0,2,1,2]]}],"p":[{},[0,0,0,1,2]]}],"t":[{"e":[{"t":[{"é":[{},[0,2,1,2]]}]}]}]}],"é":[{"l":[{"m":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"d":[{},[0,2,1]],"i":[{},[0,2,1,2]],"t":[{"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"c":[{"s":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]]}]}],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]},[0,2,1]]}],"t":[{"é":[{"z":[{},[0,0,0,0,0,0,1]]}]}]}],"o":[{"r":[{},[0,0,1]]}],"ö":[{"l":[{"ő":[{},[0,0,1]]},[0,0,0,2]]}],"ő":[{"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"u":[{"n":[{},[0,0,1]]}],"ú":[{"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ű":[{"z":[{},[0,2,1]]}]}],"w":[{"a":[{"y":[{"i":[{},[0,0,0,1]]}]}]}],"y":[{"a":[{"s":[{},[0,0,1]]}],"é":[{"b":[{},[0,1]],"n":[{},[0,1]],"t":[{"ő":[{},[0,0,1]]}],"v":[{},[0,1]]}],"j":[{"é":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2]],"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"v":[{"é":[{},[0,0,2]]}]}],"z":[{"a":[{"é":[{},[0,0,0,0,2]],"j":[{},[2,3]],"k":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]},[1]],"á":[{"r":[{"ó":[{"r":[{"a":[{},[0,0,0,2,1,2]]}]}]}],"s":[{"s":[{},[0,0,0,0,1]],"z":[{},[0,3]]}]},[1]],"e":[{},[1]],"é":[{"s":[{"a":[{},[0,0,0,2]]}]},[1]],"i":[{"l":[{},[2,3]]},[1]],"í":[{},[1]],"o":[{},[1]],"ó":[{},[1]],"ö":[{},[1]],"ő":[{"a":[{},[0,0,0,0,2]],"b":[{"ő":[{},[2]]}],"d":[{},[2]],"j":[{},[2]],"n":[{"é":[{},[2]]}],"r":[{},[2]]},[1]],"s":[{"a":[{},[1]],"á":[{},[1]],"e":[{"g":[{},[2,0,0,1,2]],"s":[{"z":[{},[2,0,0,1]]}]},[1]],"é":[{},[1]],"i":[{"r":[{},[2]],"s":[{},[2,0,0,1]],"v":[{},[0,3]]},[1]],"í":[{},[1]],"o":[{"k":[{},[0,0,0,1]]},[2,0,0,0,2]],"ó":[{},[1]],"ö":[{},[1]],"ő":[{},[1]],"s":[{},[0,0,0,1]],"u":[{},[1]],"ú":[{"j":[{},[2]]},[1]],"ü":[{},[1]],"ű":[{},[1]]}],"u":[{},[1]],"ú":[{},[1]],"ü":[{},[1]],"ű":[{},[1]]},[0,2]]}],"e":[{".":[{},[2]],"a":[{"b":[{"á":[{"l":[{},[0,0,2]]}],"o":[{},[0,2]],"ő":[{},[0,2]]}],"d":[{"a":[{},[0,0,2]],"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]},[0,0,2]],"ó":[{},[0,0,2]],"r":[{},[0,0,1,2]],"u":[{},[0,0,2]]}],"é":[{"d":[{},[0,0,0,2]]}],"f":[{"á":[{},[0,2]],"e":[{},[0,2]],"i":[{},[0,2]],"o":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]]}],"g":[{"i":[{},[0,0,2]],"ó":[{},[0,2]]}],"i":[{"d":[{},[0,2]],"l":[{},[0,2]],"m":[{},[0,2]],"p":[{},[0,2]],"s":[{},[0,2]]}],"j":[{"a":[{},[0,0,2]]}],"k":[{".":[{},[0,2]],"a":[{"s":[{},[0,0,2]],"t":[{},[0,2]]}],"á":[{},[0,2]],"b":[{},[0,2]],"e":[{},[0,2]],"é":[{"p":[{},[0,2]]}],"h":[{},[0,2]],"i":[{},[0,2]],"í":[{},[0,2]],"l":[{},[0,2,1]],"o":[{},[0,2]],"ó":[{},[0,2]],"ö":[{},[0,2]],"r":[{},[0,2,1,2]],"ú":[{},[0,2]],"ü":[{},[0,2]]}],"l":[{"á":[{"n":[{},[0,2]]}],"e":[{"g":[{},[0,0,0,1]]}],"u":[{},[0,0,2]]}],"m":[{".":[{},[0,2]],"a":[{},[0,2]],"á":[{},[0,2]],"e":[{"l":[{},[0,2]],"r":[{},[0,2]]}],"é":[{},[0,2]],"i":[{"n":[{},[0,2]]}],"o":[{},[0,0,2]],"u":[{},[0,2]],"ú":[{},[0,2]],"ű":[{},[0,2]]}],"n":[{"e":[{},[0,2]],"é":[{},[0,2]],"ö":[{},[0,2]],"s":[{},[0,2]],"y":[{"a":[{},[0,0,2]]}]}],"p":[{"i":[{},[0,2]],"o":[{},[0,2]],"ó":[{},[0,2]],"r":[{"o":[{},[0,0,1,2]]}]}],"r":[{".":[{},[0,2]],"a":[{"n":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{},[0,0,2]],"b":[{},[0,2]],"e":[{},[0,2]],"h":[{},[0,2]],"j":[{},[0,2]],"n":[{},[0,2]],"ó":[{},[0,2]],"r":[{},[0,2]],"u":[{},[0,2]],"ü":[{},[0,2]]}],"s":[{"o":[{},[0,2]],"t":[{},[0,2,1,0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]],"z":[{"e":[{"m":[{},[0,2]]}],"é":[{},[0,2]]}]}],"t":[{"a":[{},[0,2]],"á":[{},[0,2]],"c":[{},[0,2]],"e":[{"g":[{},[0,0,2,1]]},[0,2]],"é":[{"l":[{},[0,0,2]],"n":[{"e":[{},[0,0,2,1]]}]},[0,2,0,0,2]],"f":[{},[0,2]],"g":[{},[0,2]],"h":[{},[0,2]],"i":[{"d":[{},[0,0,2]],"n":[{"g":[{},[0,0,0,1]]}],"p":[{},[0,0,2]],"r":[{},[0,0,2]]}],"m":[{"o":[{"s":[{"z":[{},[0,0,0,0,0,0,0,2]]},[0,0,0,0,0,1]]}]},[0,2]],"n":[{},[0,2]],"o":[{"r":[{},[0,0,2,1]]},[0,2]],"ó":[{},[0,2]],"ö":[{},[0,2]],"r":[{"a":[{"k":[{},[0,0,1,2]]}],"ó":[{"n":[{},[0,0,0,2]]}]}],"s":[{},[0,2]],"u":[{},[0,2]],"ü":[{},[0,2,2]],"ű":[{},[0,2]],"z":[{},[0,2]]}],"u":[{".":[{},[0,2]],"t":[{},[0,0,2]],"x":[{},[0,2,2]]}],"v":[{"i":[{},[0,2]],"y":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,2]]}]},[0,1]],"á":[{"b":[{"é":[{},[0,0,2]]}],"c":[{"s":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"í":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2,1]],"o":[{"s":[{"k":[{},[0,0,2,1]]}]}]}],"l":[{"a":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1,2]]}],"e":[{},[0,0,2,1,2]],"é":[{"l":[{},[0,0,2]]},[0,0,0,0,2]],"f":[{"e":[{},[0,0,0,0,0,2]]}],"i":[{"d":[{},[0,0,2]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{"m":[{},[0,0,2]]}]}],"o":[{"p":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]]}],"m":[{"u":[{},[0,0,2]]}],"n":[{"a":[{"c":[{},[0,0,2]],"l":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"á":[{"r":[{},[0,0,2]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"e":[{},[0,0,2,1,2]],"y":[{"a":[{"l":[{},[0,0,2,0,1,2]],"n":[{},[0,0,2,0,1,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,0,1]],"v":[{},[0,0,2]]}],"e":[{},[0,0,2,0,1,2]],"é":[{"n":[{},[0,0,2]],"r":[{".":[{},[0,0,2,0,1]]}]}],"i":[{"f":[{},[0,0,2]],"n":[{"g":[{},[0,0,2,0,1]]}],"s":[{},[0,0,2]]}],"o":[{"k":[{"u":[{},[0,0,2,0,1,2]]}]}],"ö":[{},[0,0,2]]}]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,2]],"m":[{},[0,0,2]],"s":[{},[0,0,2]],"z":[{},[0,0,2]]}],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"s":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"í":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]],"z":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,0,0,2]],"e":[{},[0,0,2,1,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]],"u":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[0,1]],"b":[{"a":[{"d":[{"ó":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]]}]},[0,2,0,2]],"g":[{"a":[{},[0,0,1]]}],"j":[{"k":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1,2]],"k":[{},[0,2,1]]}],"n":[{"t":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"t":[{"l":[{},[0,0,1]]}],"u":[{},[0,2,1]],"z":[{"o":[{},[0,0,1,2]]}]}],"á":[{"g":[{"g":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"a":[{},[0,0,1]]}]}],"e":[{"á":[{},[0,0,0,0,2]],"h":[{"e":[{},[0,2,1,2]]}],"j":[{"t":[{},[0,0,1]]}],"l":[{"á":[{},[0,0,0,2,1]],"e":[{"f":[{},[0,2,1,2]],"m":[{"e":[{},[0,0,0,2,1]]}]}],"h":[{"e":[{"l":[{},[0,2,1]]}]}]}],"n":[{"c":[{},[0,2,1]]}],"s":[{"t":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]]}],"z":[{"e":[{"k":[{},[0,0,0,2]]}]}]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1]],"p":[{},[0,0,1]],"r":[{"d":[{},[0,2,1]],"t":[{"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1]],"n":[{"a":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{},[0,2,1]]}],"r":[{"á":[{},[0,2,1]]}],"s":[{},[0,2,1,2]],"z":[{"z":[{},[0,2,1]]}]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"a":[{"t":[{},[0,0,2]]}],"ú":[{},[0,1,2]]}],"o":[{"k":[{"t":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1,2]]}],"r":[{"v":[{},[0,0,1]]}]}],"ö":[{"b":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"u":[{"s":[{},[0,0,2]]}]}],"s":[{"t":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"é":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1]],"z":[{},[0,0,1]]}]}],"c":[{"a":[{"j":[{"t":[{},[0,0,1]]}],"l":[{"k":[{},[0,0,1]]}],"n":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"á":[{"g":[{},[0,0,1]],"l":[{},[0,2,1]],"r":[{},[0,0,1]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"a":[{},[0,0,2,1,2]],"é":[{"r":[{},[0,0,2,1]]}],"h":[{},[0,0,2,3]],"i":[{},[0,0,2,1]],"s":[{"á":[{"t":[{},[0,0,0,0,1]]}],"o":[{},[0,0,3]]}],"ú":[{},[0,0,2]]}],"e":[{"g":[{},[0,2,1]],"l":[{"o":[{},[0,2,1]],"v":[{},[0,2,1]]}],"n":[{"t":[{"o":[{},[2]]}]}],"t":[{"b":[{},[0,2]],"o":[{},[0,0,0,2,1]],"s":[{},[1,2]],"t":[{},[1,2]],"ü":[{"z":[{},[0,0,0,2]]},[0,2]]}],"v":[{"é":[{},[0,2,1]]}]}],"h":[{"a":[{"r":[{},[0,0,3]]}],"e":[{"n":[{},[0,0,3]]}],"i":[{".":[{},[0,0,3]],"n":[{},[0,0,0,1]]}],"ó":[{},[1,2]],"u":[{},[0,0,0,1]]}],"l":[{"e":[{},[0,0,2]],"u":[{},[0,0,2]]}],"s":[{"a":[{"d":[{},[0,2]],"l":[{"a":[{},[0,2,0,1,2]]}],"n":[{},[0,2,0,1,2]],"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]],"k":[{},[0,2,0,1,2]]}]}],"r":[{"á":[{},[0,0,0,1]]}]}],"á":[{"r":[{"á":[{},[0,0,0,1]],"b":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{},[0,2,0,1,2]]}],"é":[{"l":[{},[0,2,0,1,2]],"r":[{".":[{},[0,2,0,1]],"t":[{"é":[{},[0,0,0,1]]}]}]}],"o":[{"l":[{},[0,2,0,1]]}],"ö":[{"l":[{},[0,2,0,1]]}],"s":[{},[0,0,0,1]],"ú":[{"s":[{"z":[{"ó":[{"s":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"ü":[{"k":[{"b":[{},[0,2,3]]}],"t":[{},[0,2,3]]}],"z":[{"e":[{},[0,0,3]]}]}],"u":[{"d":[{},[0,2,1]]}],"z":[{"á":[{},[0,0,3]],"e":[{},[0,0,3]]}]}],"d":[{"a":[{"b":[{},[0,2,1]],"d":[{"á":[{},[0,2,1,2]]}],"n":[{"y":[{},[0,0,1,2]]}],"z":[{},[0,2,1,2]]}],"á":[{"c":[{},[0,2,1,2]],"g":[{},[0,2,1]],"p":[{},[0,2,1]]}],"e":[{"g":[{"y":[{},[0,0,1]]}],"l":[{"e":[{"m":[{"e":[{},[0,0,0,0,0,0,0,2]]}]}],"o":[{},[0,2,1]]}],"m":[{"l":[{},[0,2,1]]}],"r":[{"a":[{"k":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2,1]]}],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"k":[{},[0,0,0,2,1]]}],"o":[{},[0,0,0,2,1]],"ü":[{"l":[{},[0,0,0,2,1,2]]}]}],"s":[{"o":[{},[0,0,0,2,1]]}],"t":[{"á":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}]}]}],"é":[{"j":[{},[0,2,1,2]],"k":[{"á":[{},[0,0,0,2]],"i":[{"s":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2,1]]}],"l":[{"y":[{"á":[{},[0,0,0,2]],"o":[{},[0,0,0,2]]}]}],"n":[{"n":[{},[1,2]],"y":[{},[1,2]]}],"p":[{},[0,2,1]],"r":[{"d":[{},[0,2,1]]}],"s":[{"a":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"v":[{"é":[{"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}]}]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"c":[{},[2]],"d":[{"e":[{},[0,2]]}],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]},[0,2,1,2]]}],"l":[{"l":[{},[0,0,1]]}],"n":[{"t":[{},[0,2,1]]}],"r":[{"a":[{},[0,2,1]],"o":[{},[0,0,1]]}]}],"í":[{"r":[{},[0,2,1]],"v":[{"n":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"o":[{"l":[{"d":[{},[0,0,1]]}],"r":[{"v":[{},[0,0,1]]}],"s":[{},[0,2,1]]}],"ö":[{"s":[{},[0,2,1]]}],"ő":[{"r":[{"s":[{},[0,2,1]]}],"s":[{"ü":[{},[0,0,0,2,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"m":[{},[0,0,2]]}],"o":[{"g":[{},[0,1,2]]}],"ó":[{},[0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"t":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}],"v":[{"a":[{},[0,0,2,1,2]],"á":[{"r":[{},[0,0,2,1]],"t":[{},[0,0,2]]},[0,0,0,0,2]],"é":[{"r":[{".":[{},[0,0,0,1]]}]}],"ö":[{"z":[{},[0,0,2,1]]}]}],"y":[{"i":[{},[0,0,0,1]]}],"z":[{"á":[{},[0,2,3]],"ő":[{"i":[{},[1,2]],"j":[{},[1]],"r":[{},[1]],"v":[{},[1,2]]}],"v":[{},[1]]}]}],"e":[{"b":[{"é":[{},[0,0,2]]}],"c":[{"s":[{},[0,0,2]]}],"d":[{"z":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{"s":[{"z":[{},[0,0,0,0,0,0,1]]}]},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"e":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2]]}],"l":[{".":[{},[0,2]],"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{"b":[{},[0,2]],"d":[{},[0,0,2]]}],"g":[{},[0,2]],"o":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"m":[{"e":[{"n":[{},[0,0,3]]},[0,0,2]],"é":[{},[0,0,2]],"u":[{},[0,0,2]]}],"n":[{".":[{},[0,2]],"b":[{},[0,2]],"j":[{},[0,2]],"t":[{},[0,2]],"w":[{},[0,2]],"y":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"s":[{"é":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"h":[{},[0,2,1,2]],"o":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"z":[{"ü":[{},[0,0,2]]}]},[0,1]],"é":[{"d":[{"e":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"h":[{"e":[{},[0,0,2]]}],"j":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"m":[{"e":[{},[0,0,2]]}],"n":[{"e":[{},[0,0,2]]}],"p":[{"í":[{"t":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,0,0,1]]}]}]}]},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[0,1]],"f":[{"a":[{"x":[{"i":[{},[0,0,0,2,1]]}]}],"e":[{"k":[{"t":[{"á":[{},[0,0,0,0,2]],"í":[{},[0,0,0,0,2,1,2]]}]}],"n":[{"y":[{"ő":[{"é":[{},[0,0,0,0,0,0,0,2]]}]}]}]}],"f":[{"i":[{"n":[{},[0,0,2,1]]}],"o":[{},[0,0,2,1]]}],"l":[{"a":[{},[0,1,2]],"e":[{"x":[{"i":[{"k":[{},[0,0,0,0,2,1,2]]}]}]}],"u":[{},[0,0,2]]}],"o":[{"n":[{"a":[{"l":[{"k":[{},[0,0,0,2,1]]}]}],"i":[{"k":[{},[0,0,0,2]]}]}],"r":[{"m":[{"a":[{"l":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}]}]}],"p":[{"l":[{},[0,0,1]]}],"r":[{"á":[{},[0,1,2]],"ö":[{},[0,0,2]]}]}],"g":[{"a":[{"b":[{"á":[{},[0,2,1,2]],"e":[{},[0,0,0,2]],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"é":[{},[0,2,1,2]],"s":[{},[0,0,0,2]]}],"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"i":[{},[0,0,0,2]],"j":[{},[0,2,1,2]],"k":[{"é":[{},[0,3]]},[0,2,1,2]],"l":[{"a":[{"c":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"p":[{},[0,0,1,2]]}],"á":[{},[0,2,1,2]],"h":[{},[0,2,1]],"j":[{},[0,2,1]],"m":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"m":[{},[0,2,1,2]],"n":[{"g":[{},[0,0,1]],"n":[{},[0,0,1]],"t":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"p":[{"a":[{},[0,2,1,2]],"á":[{},[0,0,1]],"o":[{},[0,0,0,2]],"ó":[{},[0,0,1,2]],"r":[{},[0,2,1]]}],"r":[{"c":[{},[0,0,1]],"i":[{},[0,0,0,2]],"o":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"s":[{"s":[{},[0,2,1]],"z":[{"a":[{},[0,2,1,2]],"o":[{},[0,2,1,2]],"ú":[{},[0,2]]}]}],"t":[{"k":[{},[0,0,1]],"r":[{},[0,0,0,1,2]],"y":[{},[0,3,2]]}],"u":[{},[0,2,1,2]],"v":[{"a":[{},[0,0,1,2]]}],"z":[{"o":[{"l":[{},[0,3]],"n":[{},[0,0,0,2]]}]}]}],"á":[{"b":[{"a":[{},[0,3]],"ó":[{},[0,3]]}],"c":[{"s":[{},[0,0,1,2]]}],"f":[{},[0,2,1]],"g":[{},[0,2,1,2]],"h":[{},[0,0,1]],"i":[{},[0,3,2]],"j":[{"a":[{},[0,3]],"á":[{},[0,3]],"u":[{},[0,0,0,2]]}],"m":[{},[0,0,0,2]],"n":[{},[0,3,2]],"p":[{},[0,2,1]],"r":[{"á":[{},[0,2,1,2]],"b":[{},[0,2,1]],"g":[{},[0,3,2]],"n":[{},[0,2,1]],"o":[{},[0,0,0,2]],"t":[{},[0,0,1]],"u":[{},[0,0,0,2]],"ú":[{},[0,0,0,2]]}],"s":[{"a":[{},[0,0,0,2]]}],"t":[{".":[{},[0,3]],"u":[{},[0,3,2]]}],"v":[{"a":[{},[0,3]]}],"z":[{"á":[{},[0,0,0,2]],"i":[{},[0,0,0,2]],"u":[{},[0,0,0,2]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"b":[{"é":[{},[0,2,1,2]]}],"c":[{"s":[{"ö":[{},[0,0,0,2,0,1,2]]}]}],"d":[{"z":[{},[0,0,1]]}],"g":[{"e":[{},[0,0,1,2]]}],"h":[{"e":[{},[0,0,1]]}],"k":[{"é":[{"s":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,2]],"e":[{"d":[{},[0,3]],"g":[{},[0,0,0,2]],"j":[{},[0,0,0,2]],"k":[{"t":[{},[0,2]]}],"m":[{"b":[{},[0,0,1,2]],"e":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"s":[{},[0,0,0,2,1,2]]}],"é":[{"g":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"f":[{},[0,2,1]],"g":[{},[0,3,2]],"h":[{"a":[{},[0,2,1]]}],"i":[{"t":[{},[0,3,2]]}],"j":[{"á":[{},[0,2,1]]}],"m":[{},[0,2,1]],"n":[{"e":[{},[0,3,2]]}],"o":[{},[0,2,1]],"ő":[{"á":[{},[0,3,2]],"b":[{"b":[{"e":[{},[0,0,0,2]]}]}],"d":[{},[0,3,2]],"f":[{},[0,3,2]],"i":[{},[0,3,2]],"m":[{},[0,3,2]],"n":[{"y":[{"e":[{},[0,3]]}]}]}],"t":[{"á":[{},[0,2,1]],"e":[{"t":[{},[0,3,2]]}],"ü":[{},[0,3,2]]}],"v":[{"á":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"m":[{"e":[{"l":[{},[0,2]]}]}],"n":[{"d":[{},[0,3]],"y":[{"e":[{},[0,3]]}]}],"p":[{"e":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"á":[{},[0,3]],"d":[{},[0,2]],"e":[{".":[{},[1]],"d":[{},[0,2]],"k":[{},[1,2]]}],"é":[{"n":[{"y":[{},[0,0,0,2]]}]},[0,2]],"k":[{},[0,0,1]],"l":[{},[0,3]],"ó":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"s":[{"e":[{"k":[{},[0,0,2]],"t":[{"e":[{},[0,2,1]]}]}],"z":[{"k":[{},[0,2,1]]}]}],"t":[{"a":[{"l":[{},[0,2]]}]}],"v":[{"e":[{},[0,0,1,2]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"m":[{"b":[{},[0,3]]}],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]],"k":[{},[0,2,1,2]]}]}],"y":[{"e":[{"l":[{},[0,0,0,2,0,1,2]]}]}]}],"p":[{"í":[{},[0,2,1]],"s":[{},[0,0,1]]}],"r":[{".":[{},[0,2]],"b":[{},[0,2]],"e":[{"s":[{},[0,0,0,2,1]],"t":[{"e":[{},[0,0,0,0,1]]},[0,0,0,2,0,2]],"z":[{},[0,0,0,2]]}],"é":[{"s":[{},[0,0,0,2]]},[0,2]],"g":[{},[0,2]],"i":[{".":[{},[0,0,0,2]]},[0,2]],"k":[{},[0,2]],"n":[{},[0,2]],"ő":[{".":[{},[0,0,1,2]]}],"r":[{},[0,2]],"s":[{},[0,2]],"t":[{"é":[{},[0,0,1]],"h":[{},[0,0,1]],"ő":[{},[0,2]]}],"v":[{},[0,2]]}],"s":[{"z":[{"l":[{},[0,0,1]],"s":[{},[1]]},[0,2]]}],"t":[{"e":[{},[0,0,1]]}]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"i":[{"m":[{},[0,0,2]]}],"y":[{"a":[{"l":[{},[0,0,3]],"n":[{},[0,0,3]]}],"á":[{"s":[{},[0,0,3]]}],"ú":[{},[0,0,3]]}]}],"i":[{".":[{},[0,3]],"b":[{"r":[{},[0,0,1]]}],"d":[{"d":[{},[0,0,1]],"e":[{},[0,0,1,2]]}],"e":[{},[0,3]],"g":[{".":[{},[0,3]],"a":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"j":[{},[0,0,1]],"k":[{"o":[{},[0,2,1,2]],"r":[{},[0,0,1]]}],"l":[{"l":[{},[0,2]]}],"m":[{"b":[{},[0,0,1]],"m":[{},[0,2]]}],"n":[{"f":[{},[0,0,1]],"g":[{},[0,2,1]],"o":[{},[0,0,1]],"s":[{},[0,0,1]]}],"o":[{},[0,3,2]],"r":[{"a":[{},[0,0,1]],"o":[{},[0,0,1,2]]}],"s":[{"s":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,0,2]]}],"t":[{"a":[{},[0,2,1,2]],"á":[{},[0,3]]}],"v":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"e":[{},[0,3]]}],"z":[{"é":[{},[0,0,1]],"g":[{},[0,0,1]],"m":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"í":[{"g":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1,2]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"o":[{"b":[{},[0,2,1]],"c":[{},[0,2]],"d":[{},[0,2,1,2]],"i":[{},[0,2]],"k":[{},[0,2,1,2]],"l":[{"a":[{},[0,0,1,2]],"d":[{},[0,2,1]],"v":[{},[0,0,1]],"y":[{},[0,3]]}],"m":[{"i":[{},[0,0,0,2]]},[2]],"n":[{"t":[{},[0,2]]}],"p":[{},[0,2,1]],"r":[{"g":[{},[0,0,1]],"o":[{"m":[{},[0,3,2]],"s":[{},[0,0,0,2]]}],"r":[{},[0,2,1]],"v":[{},[0,2,1]]}],"s":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"ó":[{".":[{},[0,3]],"b":[{},[0,3,2]],"d":[{"o":[{},[0,0,0,2]]}],"j":[{},[0,3,2]],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1]]}],"v":[{},[0,0,1]]}],"ö":[{"b":[{},[0,2,1]],"k":[{},[0,0,1]],"n":[{"t":[{},[0,0,1]]}],"r":[{"ö":[{"g":[{},[0,3]],"m":[{},[0,0,0,2]]},[0,0,1]]}],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"r":[{"e":[{},[0,3]],"i":[{},[0,0,1]],"ö":[{},[0,0,1]]}],"s":[{"z":[{"i":[{},[0,0,0,2]]}]}],"z":[{},[0,3,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"a":[{"t":[{},[0,1,2]]}],"ó":[{"f":[{},[0,1,2]]}]}],"s":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1,2]],"z":[{"t":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"b":[{},[0,3,2]],"d":[{},[0,0,1]],"m":[{},[0,3,2]],"n":[{},[0,0,1,2]],"r":[{"a":[{".":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"u":[{},[0,3]]}],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"z":[{},[0,0,1,2]]}],"ú":[{"j":[{},[0,0,1]],"n":[{},[0,3,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ü":[{"d":[{},[0,2,1]],"g":[{"y":[{"e":[{},[0,0,0,2]]}]}],"l":[{"e":[{},[0,2,1,2]],"i":[{},[0,0,1,2]]}],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}],"v":[{"á":[{"r":[{"o":[{"s":[{"i":[{},[0,0,0,0,0,0,0,0,2]]}]}]}]}]}],"y":[{"a":[{"d":[{},[0,2,0,1,2]],"g":[{},[0,0,0,1,2]],"j":[{},[0,2,0,1]],"k":[{"t":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,0,0,1,2]]}],"r":[{"á":[{},[0,2,0,1]]}],"s":[{},[0,2,0,1]],"t":[{},[0,0,0,1,2]],"u":[{},[0,2,0,1]],"z":[{},[0,0,0,1]]}],"á":[{"l":[{},[0,2,0,1]],"r":[{"á":[{},[0,0,0,1,2]],"f":[{},[0,0,0,1]]}],"t":[{},[0,2]]}],"e":[{"l":[{"e":[{"g":[{},[0,0,0,1]]}],"f":[{},[0,0,0,1]],"l":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"ő":[{"j":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1,2]]}],"z":[{},[0,0,0,1]]}],"n":[{"i":[{},[0,2]],"l":[{},[1,2]],"s":[{},[1,2]]}],"s":[{"z":[{"t":[{},[0,0,0,1]]}]}],"z":[{"m":[{},[1]]}]}],"é":[{"k":[{"s":[{},[0,0,0,1]]}],"n":[{"i":[{},[1]]}],"r":[{".":[{},[0,0,0,1]]}]}],"i":[{"p":[{},[0,2]],"s":[{},[0,2]],"z":[{},[0,2,0,1]]}],"o":[{"k":[{},[0,0,0,1]],"l":[{},[0,2,0,1]],"r":[{},[0,0,0,0,2]],"s":[{},[0,2,0,1]],"t":[{},[0,0,0,1]]}],"ó":[{"r":[{},[0,2,0,1,2]]}],"ö":[{"l":[{},[0,0,0,1,2]],"s":[{},[0,2,0,1]],"z":[{},[0,2,0,1]]}],"ő":[{"r":[{},[0,0,0,1,2]]}],"u":[{"r":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"ü":[{"t":[{},[1]]}]}],"z":[{"i":[{"s":[{},[1]]}]}]}],"h":[{"a":[{"d":[{"e":[{},[0,0,0,2]]}]}],"á":[{"z":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"e":[{"l":[{"l":[{"á":[{},[0,0,1]]}],"y":[{"e":[{"s":[{},[0,0,0,2]]}]}]}],"r":[{"á":[{"l":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2,1]],"m":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"i":[{"n":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}]}]}],"é":[{"j":[{"e":[{},[0,2,1,2]]}],"n":[{"á":[{},[0,0,0,2]],"é":[{"v":[{},[0,0,0,2]]}]}],"z":[{"á":[{},[0,0,0,2]],"o":[{},[0,0,0,2]]}]}],"o":[{"r":[{"s":[{},[0,2,1]]}]}],"s":[{"z":[{},[0,0,1]]}]}],"i":[{"á":[{"b":[{},[0,0,2]],"h":[{},[0,0,2]],"j":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]]}],"b":[{"n":[{},[0,2]]}],"d":[{"e":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"é":[{"n":[{},[0,0,2]]}],"o":[{"m":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"p":[{},[0,2]]}],"e":[{"r":[{},[0,2]]}],"g":[{"á":[{},[0,0,2]],"é":[{},[0,0,2]],"n":[{},[0,2,1,2]],"y":[{},[0,0,2]]}],"h":[{"a":[{},[0,0,2]]}],"l":[{"l":[{"e":[{".":[{},[0,0,0,2]]}]}]}],"m":[{"a":[{".":[{},[0,0,2]],"n":[{},[0,0,2]]}],"á":[{},[0,0,2]],"i":[{"t":[{},[0,0,2]]}],"k":[{},[0,2]],"s":[{},[0,2]],"z":[{},[0,2]]}],"n":[{"a":[{"d":[{},[0,0,0,1]]},[0,0,2,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2]]}],"é":[{"r":[{},[0,2]],"t":[{},[0,2]]}],"i":[{"t":[{"a":[{},[0,0,2,1]]}]}],"o":[{"l":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"t":[{"r":[{},[0,0,0,1,2]]}],"ü":[{},[0,0,2]]}],"o":[{"n":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,2]]}],"r":[{"a":[{"m":[{},[0,0,2]],"t":[{},[0,0,2]]}],"i":[{},[0,0,2]],"o":[{"d":[{},[0,0,2]]}],"ó":[{},[0,2]]}],"t":[{"a":[{},[0,0,2]],"b":[{},[0,2]],"j":[{},[0,2]],"n":[{},[0,2]],"r":[{},[0,2]]}],"v":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"z":[{"é":[{},[0,0,2]],"m":[{"i":[{},[0,2]]}],"o":[{},[0,0,2]]}]},[0,1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"j":[{"á":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{"s":[{"b":[{"e":[{},[0,0,3]]}],"i":[{"l":[{},[0,0,3]]}],"o":[{"c":[{},[0,0,3]],"n":[{"k":[{},[0,0,3]]}]}]}]},[0,0,2]],"ó":[{".":[{},[0,0,2]],"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{},[0,0,2]],"d":[{"n":[{},[0,0,2]]}],"f":[{},[0,0,2]],"g":[{},[0,0,2]],"h":[{},[0,0,2]],"i":[{".":[{},[0,0,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2]],"t":[{},[0,0,2]]}],"í":[{},[0,0,0,0,0,2]],"j":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"u":[{},[0,0,2]]}],"k":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{".":[{},[0,0,2]],"a":[{},[0,0,2]],"á":[{},[0,0,2]],"y":[{},[0,0,2]]}],"r":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]]}]}],"t":[{"é":[{},[0,0,2]]}],"v":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[0,1]],"j":[{"a":[{"b":[{},[0,0,1]],"d":[{},[0,2,1,2]],"g":[{},[0,0,1,2]],"k":[{"k":[{},[0,0,1]]},[0,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"r":[{},[0,0,1]],"u":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"á":[{"b":[{},[0,0,1]],"g":[{},[0,2,1,2]],"l":[{},[0,0,1]],"r":[{"t":[{"ó":[{},[0,2,1]]}]}],"t":[{"e":[{},[0,0,1,2,1,2]],"v":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"s":[{"a":[{"p":[{},[0,0,0,0,0,2,1]]}]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"c":[{"s":[{"e":[{},[0,2,1]]}]},[0,0,0,2]],"f":[{},[0,2,1]],"g":[{"e":[{"d":[{},[0,0,1,2]]}],"é":[{},[0,2,1,2]]}],"k":[{"c":[{},[0,2]]}],"l":[{"a":[{},[0,2,1]],"c":[{},[0,2,1]],"e":[{"d":[{"e":[{},[0,2]]}],"m":[{"b":[{},[0,2,1,2]],"e":[{},[0,2,1,2]],"é":[{},[0,0,1,2]],"n":[{},[0,2,1,2]]}]}],"f":[{},[0,2,1]],"h":[{"a":[{},[0,2,1]],"e":[{"l":[{},[0,2,1]]}]}],"o":[{},[0,2,1]],"s":[{"z":[{"á":[{},[0,0,1]]}]}],"t":[{"é":[{"r":[{},[0,0,1]]}]}],"u":[{},[0,2,1]]}],"n":[{"g":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"s":[{"z":[{},[0,2,1]]}],"z":[{},[0,0,0,2]]}],"x":[{},[0,2,1]]}],"é":[{"j":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"d":[{},[0,2,1,2]],"m":[{},[0,2,1]],"n":[{"a":[{},[0,0,1]],"t":[{},[0,2,1]]}],"p":[{},[0,2,1]],"z":[{},[0,2,1]]}],"í":[{"g":[{},[0,0,1]],"v":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{"o":[{"k":[{},[0,0,2]]}]}],"o":[{"l":[{},[0,0,1]],"p":[{},[0,0,1]]}],"ó":[{"c":[{},[0,0,1]],"n":[{},[0,0,1]],"s":[{"á":[{},[0,0,0,2]]}],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"ö":[{"b":[{},[0,2,1]],"l":[{},[0,2,1]],"v":[{"e":[{".":[{},[0,0,1,2]]}]}]}],"ő":[{"z":[{},[0,2,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1,0,2]]}],"t":[{"a":[{"d":[{},[0,0,2]],"u":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]],"t":[{},[0,0,2]]}],"e":[{"l":[{"k":[{},[0,0,2,1]]}],"s":[{"t":[{"e":[{},[0,0,2,1]]}]}],"v":[{},[0,0,2]]}],"é":[{"r":[{"é":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{"n":[{},[0,0,2]],"z":[{},[0,0,2]]}],"o":[{"s":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ö":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2]],"s":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,1]],"ó":[{},[0,0,1]]}],"ü":[{"r":[{},[0,0,2]]}]}],"ú":[{"j":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1,2]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}]}],"k":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"c":[{"é":[{},[0,0,1,2]]}],"d":[{"á":[{},[0,0,1,2]],"ó":[{},[0,2,1,2]]}],"g":[{"y":[{},[0,0,0,2]]}],"j":[{"a":[{},[0,0,1,2]],"t":[{"ó":[{".":[{},[0,2,1]],"i":[{},[0,2,1]],"k":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]]}]}]}],"k":[{"a":[{"r":[{},[0,0,1,2]]}]}],"l":[{"j":[{},[0,2,1]],"o":[{},[0,2,1,2]],"t":[{},[0,0,1]]}],"n":[{"g":[{},[0,0,1]],"i":[{},[0,2,1]],"y":[{"á":[{},[0,0,1,2]]}]}],"r":[{"c":[{".":[{},[0,0,1]],"a":[{},[0,0,1]],"r":[{},[0,0,1]],"ú":[{},[0,0,1]]}]}],"s":[{"i":[{"p":[{},[0,0,0,2]]}]}],"u":[{},[0,2,1]],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"g":[{},[0,2,1]],"l":[{"l":[{"o":[{},[0,0,1]]}],"m":[{},[0,0,1]]}],"r":[{"a":[{"d":[{},[0,0,1]],"i":[{},[0,0,0,2]],"k":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"á":[{},[0,2,1,2]],"d":[{},[0,2,1]],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{"n":[{},[0,2,1,2]]}],"r":[{},[0,2,1]],"u":[{},[0,2,1,2]],"ú":[{},[0,2,1,2]],"v":[{},[0,2,1]]}],"s":[{"ó":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"d":[{},[0,0,1]],"h":[{},[0,2,1]],"j":[{},[0,0,1]],"m":[{},[0,2,1]],"o":[{},[0,0,1,2]],"t":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"é":[{"m":[{},[1]]}],"i":[{"ó":[{"f":[{},[0,0,0,0,2]]}]}],"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"b":[{"é":[{},[0,2,1]]}],"d":[{"z":[{},[0,2,1,2]]}],"g":[{"g":[{},[0,2,1]],"y":[{"e":[{},[0,2,1,2]]}]}],"k":[{"é":[{"b":[{"ő":[{},[0,2,1,2]]}],"s":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,2]],"e":[{"g":[{},[0,2,1,2]],"m":[{"e":[{},[0,0,0,2]]}]}],"h":[{"a":[{},[0,0,1]]}],"k":[{},[0,2,1]],"l":[{"á":[{},[0,2]]}],"m":[{},[0,2,1]],"o":[{},[0,2,1]],"ő":[{"n":[{},[0,2,1]]}],"r":[{},[0,2,1]],"t":[{"a":[{},[0,0,1]],"é":[{"r":[{},[0,0,0,0,2,1,2]]}]}]}],"m":[{"a":[{},[0,2,1,2]],"e":[{"l":[{},[0,2,1,2]]}],"é":[{"s":[{},[0,0,1,2]]}]}],"p":[{"i":[{},[0,0,1,2]]}],"s":[{"t":[{"r":[{},[0,2,1]]}],"z":[{"e":[{"l":[{"e":[{},[0,0,0,2]]}]}],"o":[{},[0,0,0,2]]}]}],"v":[{"é":[{},[0,2,1,2]],"i":[{},[0,2,1]]}]}],"é":[{"é":[{"h":[{},[1,2]]}],"g":[{},[0,2,1]],"i":[{"k":[{},[1,2]]}],"k":[{"e":[{"k":[{},[0,0,1]]}],"t":[{},[0,2,1]]}],"l":[{"e":[{},[0,0,1,2]],"n":[{},[0,0,1]],"ő":[{},[0,0,1]]}],"p":[{"í":[{},[0,2,1]]}],"r":[{"i":[{"n":[{},[0,2,1]]}],"t":[{"é":[{"k":[{"b":[{},[0,0,1]]}]}]}],"ü":[{"l":[{},[0,0,0,2]]}]}],"s":[{"z":[{".":[{},[0,2,1]],"h":[{},[0,2,1]],"n":[{},[0,2,1]]}]}],"t":[{"e":[{"l":[{},[0,0,0,2]]}],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"t":[{},[0,2,1]]}],"v":[{"e":[{".":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"t":[{},[0,0,1,2]]}],"i":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"á":[{},[0,0,0,0,2]],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]},[0,0,1,2]],"e":[{},[0,0,1,2]],"é":[{},[0,2,1]]}],"i":[{},[0,0,0,0,2]],"l":[{"l":[{},[0,0,1]]}],"m":[{"a":[{},[0,2,1]],"á":[{"r":[{},[0,0,0,2]]}]}],"n":[{"á":[{},[0,2,1]],"d":[{},[0,0,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,0,1]],"p":[{},[0,2,1]]}],"z":[{"o":[{},[0,0,1,2]]}]}],"í":[{"j":[{},[0,2,1]],"r":[{"á":[{},[0,0,1]]}],"z":[{},[0,0,1]]}],"k":[{"a":[{"r":[{"ó":[{},[0,0,0,0,2,0,2]]}]}],"e":[{"l":[{"e":[{},[0,0,2,1]],"f":[{},[0,0,2,1]]}]}],"o":[{"s":[{"z":[{},[0,0,0,1]]}]}],"r":[{"i":[{},[0,0,1]]}],"ű":[{},[0,0,2]]}],"l":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"i":[{"m":[{},[0,0,2]]}]}],"n":[{"ő":[{},[0,0,3]]}],"o":[{"á":[{},[0,2,1]],"b":[{"j":[{},[0,0,1]]}],"d":[{"v":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1,2]],"l":[{"ó":[{},[0,0,1]]}],"v":[{},[0,2,1]]}],"p":[{"e":[{},[0,2,1,2]]}],"r":[{"d":[{"a":[{},[0,0,0,0,2]],"á":[{},[0,0,0,0,2,1,2]]}],"o":[{"m":[{},[0,0,1,2]]}],"r":[{"a":[{},[0,0,1]]}],"v":[{},[0,2,1]]}],"t":[{"t":[{"h":[{},[0,0,1]]}]}]}],"ó":[{"h":[{},[0,2,1,2]],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]]}]}],"ö":[{"k":[{"ö":[{},[0,2,1]]},[0,0,0,2]],"l":[{"é":[{},[0,2,1,2]],"ő":[{},[0,0,1,2]]}],"m":[{},[0,2,1]],"n":[{"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"r":[{"i":[{},[0,0,0,2]],"v":[{},[0,2,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"a":[{"m":[{},[0,1,2]]}],"é":[{"t":[{"á":[{},[0,1]]}]}],"i":[{"s":[{},[0,0,2]]}],"í":[{},[0,1,2]],"ó":[{"m":[{},[0,0,2]]}]}],"s":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{"a":[{"l":[{},[0,0,0,0,1]]}],"e":[{"s":[{},[0,0,0,0,0,0,1]]}],"i":[{"p":[{},[0,0,2]]}]}]}],"t":[{"a":[{"u":[{},[0,0,2]],"z":[{},[0,0,2]]}],"e":[{"l":[{"k":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"é":[{"r":[{"d":[{},[0,0,2,1]]}]}],"i":[{"l":[{},[0,0,2]],"m":[{},[0,0,2]],"o":[{},[0,0,2,1,2]]}],"o":[{"k":[{},[0,0,2,1]]}],"u":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"u":[{"d":[{},[0,2,1]],"r":[{"a":[{},[0,2,1,2]],"o":[{},[0,0,1]]}],"t":[{"á":[{},[0,2,1]],"ó":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"ú":[{"j":[{},[0,2,1]],"r":[{".":[{},[0,2,1]]}],"t":[{"o":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]]}],"ü":[{"n":[{"n":[{},[0,2,1]]}],"t":[{"ő":[{},[0,0,1]]},[0,0,0,2]],"z":[{"l":[{},[0,0,1]]}]}],"v":[{"ó":[{},[0,1,2]]}]}],"l":[{"a":[{"b":[{"a":[{},[0,0,1,2]],"l":[{},[0,0,1]],"o":[{"r":[{"t":[{},[0,0,1,2]]}]}]}],"c":[{},[0,2,1,2]],"d":[{},[0,2,1,2]],"g":[{"g":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"j":[{},[0,0,1,2]],"k":[{"a":[{"d":[{},[0,2,1]],"s":[{},[0,2,1,2]]}],"c":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"m":[{},[0,0,1,2]],"n":[{"a":[{},[0,0,1]],"d":[{"i":[{},[0,0,0,0,2]]}],"e":[{},[0,0,1,2]],"i":[{},[0,0,1,2]],"n":[{},[0,0,1]],"y":[{},[0,0,0,2]]}],"p":[{"a":[{},[0,0,1,2]]}],"r":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"é":[{},[0,0,1]]},[0,0,0,2]],"s":[{"z":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"ó":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"u":[{},[0,2,1,2]],"v":[{"a":[{},[0,0,1,2]],"e":[{},[0,0,1,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"b":[{"é":[{},[0,0,0,2]]}],"g":[{".":[{},[0,0,1]],"a":[{},[0,2,1,2]],"g":[{},[0,0,1]],"i":[{},[0,0,1,2]],"n":[{},[0,0,1]],"o":[{},[0,0,1,2]]}],"j":[{},[0,0,1,2]],"l":[{"d":[{},[0,0,1]],"l":[{},[0,0,1]],"o":[{},[0,0,1,2]]}],"m":[{"í":[{},[0,0,1]]},[0,0,0,2]],"n":[{"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2]],"ó":[{},[0,0,0,2]]},[0,0,2]],"p":[{},[0,0,1,2]],"r":[{".":[{},[0,0,1]],"á":[{},[0,0,1,2]],"b":[{},[0,0,1]],"c":[{},[0,0,1]],"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"f":[{},[0,0,1]],"h":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1,2]],"ö":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1,2]]}],"s":[{},[0,0,0,2]],"t":[{"a":[{},[0,0,0,0,0,2]],"e":[{},[0,0,1,0,1,2]],"f":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"r":[{},[0,0,1]]}],"z":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{".":[{},[2]],"r":[{},[0,0,1,2]]}],"e":[{"b":[{"r":[{"e":[{},[0,0,0,1]]}]}],"d":[{".":[{},[2]],"e":[{"l":[{},[1,2]]}]}],"f":[{"f":[{},[0,0,1]]}],"g":[{"e":[{"l":[{"é":[{},[0,0,0,2,1,2]]}]}],"y":[{"e":[{"n":[{"e":[{},[0,0,1,2]]}]}],"ü":[{},[0,2]]}],"z":[{},[0,0,1]]}],"í":[{"r":[{"a":[{"n":[{},[0,0,0,0,3]]}]}]}],"k":[{"l":[{},[0,0,0,1,2]],"o":[{"s":[{},[0,0,0,2,1]]}],"r":[{"á":[{},[0,0,0,1]]}],"t":[{"r":[{},[1]]}]}],"l":[{"b":[{},[0,2,1]],"e":[{"m":[{"b":[{},[0,2,1,2]]}]}],"m":[{},[0,2,1]],"ő":[{"z":[{},[0,2]]}],"r":[{},[0,0,1]]}],"m":[{"a":[{"d":[{},[0,0,0,2]]}],"b":[{"e":[{"r":[{},[0,2,1]]}]}],"e":[{".":[{},[1]],"i":[{},[1,2]],"k":[{},[1]],"l":[{"l":[{},[0,0,0,2]]}],"m":[{".":[{},[1,2]],"m":[{},[1,2]]}],"s":[{".":[{},[1,2]],"n":[{},[1,2]],"z":[{},[0,0,0,2]]}]}],"é":[{"l":[{"t":[{},[0,0,0,2]]}],"r":[{"d":[{},[0,0,0,2]]}]}],"ü":[{"k":[{},[1,2]],"n":[{"k":[{},[1,2]]}]}],"z":[{"é":[{},[1,2]],"ő":[{},[1,2]]}]}],"n":[{"d":[{},[2]],"e":[{"r":[{},[0,2]]}],"é":[{"l":[{},[0,0,0,2]]}]}],"ó":[{},[0,0,0,0,2]],"p":[{"a":[{"l":[{},[0,0,0,2]],"p":[{},[0,0,0,2]]}],"e":[{"l":[{"e":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}]}],"ő":[{"r":[{},[0,0,0,2,1,2]]}]}],"r":[{"d":[{},[0,2]],"e":[{"d":[{},[0,0,1,2]],"i":[{},[0,0,1,2]]}],"j":[{},[0,0,1]],"n":[{},[0,2,1]],"ó":[{"z":[{},[0,0,0,2]]}]}],"s":[{"e":[{"g":[{"e":[{},[0,0,0,2]]}]}],"é":[{"s":[{"b":[{},[0,0,0,2]],"e":[{},[0,0,0,2]],"é":[{},[0,0,0,2]],"h":[{},[0,0,0,2]],"i":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"t":[{},[0,0,0,2]],"ü":[{},[0,0,0,2]]}]}],"i":[{"k":[{".":[{},[0,0,0,2]]}]}],"n":[{"é":[{"n":[{},[0,2,1]]}]}],"ő":[{"b":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"s":[{"é":[{"l":[{},[0,2,1]]}]}],"t":[{"a":[{},[0,0,0,1]]}],"z":[{"e":[{"k":[{},[0,0,0,2]]}]}]}],"t":[{"e":[{"k":[{"é":[{"t":[{},[0,0,0,2,1,2]]}]}],"t":[{"i":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"ő":[{},[0,0,0,2]]}]}],"é":[{"k":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2]]}],"t":[{"é":[{"k":[{},[0,2,1]]}]}]}],"ü":[{},[0,0,0,0,2]],"v":[{"ő":[{"k":[{},[1,2,1,2]]}]}],"x":[{"i":[{},[0,0,1,2]]}]}],"é":[{"b":[{"b":[{},[0,2]]}],"d":[{"u":[{},[0,0,0,2]]}],"g":[{"e":[{"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"j":[{},[0,0,1]],"t":[{"e":[{"k":[{},[0,0,1]]}]}],"v":[{},[0,0,1]]}],"h":[{"e":[{"t":[{},[0,0,1,2]]}]}],"k":[{"a":[{"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1]],"e":[{"l":[{"e":[{},[0,0,0,2,1,2]]}],"v":[{},[0,0,0,2]],"z":[{"e":[{},[0,0,0,2]],"i":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}]}],"í":[{},[0,0,1]],"ö":[{},[0,0,0,2]],"u":[{},[0,0,0,2]]}],"l":[{".":[{},[0,0,1]],"d":[{},[0,0,1]],"e":[{"d":[{},[0,0,0,2]],"t":[{},[0,0,1,2]]}],"é":[{},[0,0,1,2]],"h":[{},[0,0,1]],"i":[{},[0,0,1,2]],"j":[{},[0,0,1]],"n":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]],"ü":[{},[0,0,1,2]],"v":[{},[0,2,1]]}],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]],"h":[{},[0,2,1,2]]}]}]}],"r":[{"e":[{"d":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"n":[{"d":[{},[0,0,0,2]]}],"z":[{},[0,2,1,2]]}],"é":[{"t":[{".":[{},[0,0,0,2]]}]}],"i":[{".":[{},[0,0,0,2]]}],"p":[{},[0,2,1]],"r":[{"ő":[{},[0,2,1]]}],"t":[{"e":[{"l":[{},[0,2]]}],"é":[{},[0,2,1]],"h":[{},[0,0,1]],"ő":[{},[0,2,1]]}],"ü":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"s":[{"é":[{"t":[{"ő":[{},[2]]}]}],"o":[{},[0,0,0,2]],"z":[{".":[{},[2]],"e":[{"l":[{},[2]],"m":[{},[2]]}],"n":[{"e":[{},[2]],"é":[{},[2]]}],"ő":[{},[2]],"ü":[{},[2]],"v":[{},[2]]}]}],"t":[{"e":[{"l":[{},[0,0,0,2]],"s":[{},[0,2,1,2]],"t":[{"e":[{},[0,0,0,2]]}]}],"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"v":[{".":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1]]}],"h":[{"a":[{"p":[{},[1]]}]}],"i":[{"b":[{},[0,0,2]],"d":[{"e":[{"g":[{},[0,0,1]]}],"é":[{},[0,0,1]],"o":[{},[0,0,1,2]]}],"g":[{"a":[{},[0,0,1]],"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"a":[{},[0,2,1,2]],"á":[{},[0,2]],"p":[{},[0,2,1]]}],"n":[{"t":[{"o":[{},[0,2,1]]}]}],"o":[{"n":[{},[0,0,1,2]]}],"ő":[{},[0,0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{"a":[{},[0,2,1]],"o":[{},[0,2,1,2]]}],"s":[{"i":[{},[0,2,1,2]],"m":[{},[0,2]],"s":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]]}]}],"t":[{"i":[{"n":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"u":[{},[0,0,0,0,0,2]]}],"v":[{"á":[{},[0,0,1,2]]}],"x":[{},[0,2,2]],"z":[{"o":[{},[0,0,1,2]]}]}],"í":[{"g":[{},[0,2,1]],"r":[{"á":[{},[0,0,1,2]]}],"v":[{},[0,0,1,2]]}],"k":[{"a":[{"r":[{"á":[{},[0,0,0,0,2,1]]}]}],"e":[{"z":[{"d":[{"é":[{},[1]],"ő":[{},[1]]}]}]}],"i":[{},[0,0,3]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"l":[{"a":[{"d":[{"á":[{},[0,0,2,1,2]],"ó":[{},[0,0,2,1,2]]}],"l":[{"k":[{},[0,0,0,1]]}],"m":[{"b":[{},[0,0,2,1]],"p":[{},[0,0,2]]}],"t":[{},[0,0,0,0,1]],"u":[{},[0,0,2]]}],"á":[{"b":[{"r":[{},[0,0,2,1]]}],"l":[{"l":[{},[0,0,2,1]]}],"t":[{"á":[{"s":[{"o":[{},[1]],"ü":[{},[1]]}]}],"m":[{},[1]]}]}],"e":[{"f":[{},[0,0,2]],"g":[{"ó":[{},[0,0,0,0,2,1,2]]}],"l":[{"k":[{"é":[{},[0,0,0,1]]}],"m":[{},[0,0,2]]}],"n":[{"á":[{},[1]],"e":[{"s":[{},[1]]}],"f":[{},[1]],"ő":[{},[1]],"s":[{},[1]],"z":[{},[1]]}]}],"i":[{"d":[{},[0,0,2]],"n":[{"f":[{},[0,0,0,1]],"g":[{".":[{},[0,0,0,1]]}],"t":[{},[0,0,0,1]]}]}],"o":[{"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,0,1]]}]}],"ó":[{"r":[{"á":[{},[0,0,0,1]]}]}],"ö":[{"n":[{},[0,0,2]],"s":[{},[0,0,2]]}],"ű":[{"r":[{},[0,0,2,1]]}]}],"m":[{"é":[{"é":[{"h":[{},[1]]}],"l":[{},[1]],"t":[{"e":[{},[1]]}]}]}],"n":[{"é":[{"p":[{},[1]]}],"ö":[{"k":[{},[1]]}]}],"o":[{"b":[{"j":[{},[0,0,1]]}],"f":[{"f":[{},[0,0,1]]}],"j":[{},[0,0,1]],"k":[{"á":[{},[0,2,1,2]],"m":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"m":[{"l":[{},[0,0,1]],"o":[{},[0,0,1]]}],"n":[{"t":[{},[0,0,1]]}],"p":[{"c":[{},[0,0,1]],"e":[{},[0,2,1]]}],"r":[{"o":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"z":[{},[0,2]]},[0,0,1]],"x":[{},[0,2,1]]}],"ó":[{"i":[{"g":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"r":[{"i":[{},[0,2,1,2]]}]}],"ö":[{"b":[{},[0,0,1]],"m":[{},[0,0,1,2]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ő":[{"á":[{"p":[{},[2]],"r":[{},[2]]}],"b":[{"é":[{},[2]],"i":[{},[2]],"o":[{},[2]]}],"d":[{"e":[{"i":[{},[1]]}],"í":[{},[0,0,0,2,1,2]],"j":[{"e":[{".":[{},[1]]}]}],"o":[{},[2]],"ö":[{"t":[{".":[{},[1]]}]}]}],"e":[{"r":[{},[0,0,0,0,2]]}],"f":[{"ú":[{},[1,2]],"ü":[{},[2]],"ű":[{},[2]]}],"h":[{"í":[{"v":[{},[1,2]]}],"ű":[{},[1]]}],"i":[{"b":[{},[2]],"k":[{},[2]],"m":[{},[2]],"v":[{},[2]]}],"j":[{"a":[{},[2]]}],"k":[{"é":[{".":[{},[2]],"r":[{"t":[{},[2]]}],"s":[{"e":[{},[1]],"t":[{},[1,2]]}]}],"l":[{},[2]],"ő":[{},[2]],"t":[{},[2]],"u":[{},[2]],"ü":[{},[2]]}],"m":[{"ö":[{},[2]],"ű":[{},[2]]}],"n":[{"a":[{},[2]],"n":[{},[1]],"ö":[{},[2]],"y":[{".":[{},[1]],"b":[{},[1]],"e":[{"r":[{},[2]]}],"h":[{},[1]],"i":[{},[2]],"k":[{},[1]],"n":[{},[1]],"ö":[{},[1]],"r":[{},[1]],"t":[{},[1]],"ü":[{},[1]]}]}],"ö":[{},[2]],"r":[{".":[{},[0,0,1]],"e":[{"g":[{},[1,2]],"h":[{},[1]],"j":[{},[1]]}],"i":[{"z":[{},[0,0,1]]}],"l":[{},[0,0,1]],"o":[{},[2]],"ü":[{},[0,2,1]]}],"s":[{"á":[{},[2]],"o":[{},[2]],"ö":[{},[2]],"p":[{},[0,0,0,1,2]],"z":[{"e":[{},[2]],"é":[{},[2]],"i":[{},[2]],"ó":[{},[2]]}]}],"t":[{"ü":[{},[2]]}],"ü":[{},[2]],"v":[{"i":[{"s":[{},[2]],"z":[{},[2]]}]}],"z":[{".":[{},[1,2]],"e":[{"n":[{"e":[{},[2,3]]}]},[0,2]],"m":[{},[1]]}]}],"p":[{"l":[{},[0,0,1,2]],"r":[{"ó":[{},[0,0,1]]}]}],"s":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"z":[{"t":[{},[0,0,1,0,2]]}]}],"t":[{"a":[{"j":[{},[0,0,2,1]]}],"á":[{"r":[{"a":[{"d":[{"a":[{},[0,0,0,0,0,1]]},[0,0,0,0,0,0,2]]}]}]}],"e":[{".":[{},[2]],"r":[{"e":[{"i":[{},[0,0,2,1,2]]}]}],"s":[{},[2]],"t":[{".":[{},[2]],"e":[{},[2]],"é":[{},[2]],"h":[{},[2]],"i":[{},[2]],"j":[{},[2]],"n":[{},[2]],"s":[{},[2]],"t":[{"k":[{},[1]]}],"ü":[{},[2]],"v":[{},[2]]}]}],"é":[{"b":[{},[2]],"l":[{},[2]],"t":[{},[2]]}],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1]],"é":[{},[0,0,1]]}],"ü":[{"k":[{},[2]]}]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,0,1,2]],"n":[{"d":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,0,1,2]],"t":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"ú":[{"j":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"c":[{},[0,0,1]],"d":[{},[0,2,1]],"g":[{"y":[{"é":[{"r":[{".":[{},[0,0,0,0,0,1]],"n":[{},[0,0,0,0,0,1]]}]}]}]},[0,2,1]],"k":[{"é":[{"n":[{},[0,0,0,2]]}]}],"l":[{"t":[{"e":[{"t":[{},[0,2,1]]}]}]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"r":[{"t":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"v":[{"a":[{"d":[{"a":[{},[0,0,0,1]],"ó":[{},[0,0,0,1,2]]}],"t":[{},[0,0,2,1]]}],"á":[{"r":[{"a":[{"i":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"á":[{"r":[{},[0,0,2,1]]}]}],"s":[{"z":[{},[0,0,0,1]]}],"t":[{},[0,0,2]]}],"e":[{"n":[{"c":[{},[0,0,2,1]]}]}],"é":[{"g":[{"ü":[{},[0,0,2,1]]}],"l":[{"e":[{},[0,0,0,1]]}],"r":[{".":[{},[0,0,2,1]],"i":[{},[0,0,2,1]]}]}],"i":[{"k":[{},[0,0,2]]}],"o":[{"l":[{"t":[{},[0,0,0,1]]}]}],"ó":[{},[0,0,2,1,2]],"ö":[{"d":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"y":[{"a":[{},[0,2,0,1,2]],"á":[{},[0,2,0,1,2]],"e":[{"k":[{"é":[{"n":[{".":[{},[0,2,0,1,2]]}]}]}],"l":[{},[0,2,0,1]],"r":[{},[0,2]],"s":[{"z":[{"t":[{},[0,0,0,1]]}]}]}],"é":[{"j":[{"é":[{},[0,0,0,1,2]]}],"k":[{"é":[{},[0,0,0,1,2]]}],"l":[{},[0,2,0,1]],"s":[{},[0,2]]}],"i":[{"k":[{"o":[{},[0,2,0,1,2]]}],"r":[{"a":[{},[0,2,0,1]]}]}],"k":[{"é":[{"j":[{},[0,0,0,2]]}]}],"o":[{},[0,2,0,1]],"ó":[{},[0,2,0,1]],"ö":[{"m":[{},[0,2]],"n":[{},[0,2]],"s":[{},[0,2]]}],"ő":[{},[0,2]],"u":[{"l":[{},[0,0,0,1]]}],"ü":[{"l":[{"é":[{},[0,2,0,1]]},[0,0,0,0,2]]}]}]}],"m":[{"a":[{"b":[{},[0,2,1]],"d":[{"a":[{"t":[{},[0,0,1,2]]}],"á":[{"s":[{},[0,0,1,2]]}],"o":[{},[0,2,1,2]],"ó":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"g":[{"i":[{},[0,2,1,2]]}],"j":[{"a":[{},[0,0,1,2]],"á":[{},[0,2,1]],"k":[{},[0,0,1]],"t":[{},[0,2,1]]}],"k":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1]],"u":[{},[0,2,1]]}],"l":[{"a":[{"p":[{},[0,0,1,2]]}],"l":[{},[0,2,1]],"m":[{"á":[{},[0,0,1]]}],"v":[{},[0,0,1]]}],"n":[{"a":[{},[0,2,1]],"á":[{},[1]],"y":[{},[0,2,1,2]]}],"p":[{"á":[{},[0,0,1]],"r":[{},[0,0,1]]},[0,0,0,2]],"r":[{"á":[{"n":[{},[0,0,1,2]]}]}],"s":[{"s":[{"z":[{"o":[{},[0,0,1]]}]}]}],"t":[{"l":[{},[0,2,1]]}],"u":[{},[0,2,1,2]],"v":[{},[0,2,1,2]],"z":[{"o":[{},[0,2,1,2]]}]}],"á":[{"b":[{},[0,2,1]],"l":[{"a":[{},[0,0,1]],"d":[{},[0,0,1]],"i":[{},[0,0,1]]},[0,0,0,2]],"p":[{},[0,2,1]],"r":[{"a":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1]],"u":[{},[0,2,1]],"v":[{},[0,0,1]]},[0,0,0,2]],"s":[{"á":[{},[0,2,1]]}],"t":[{"a":[{},[0,0,0,0,1,2]],"e":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,0,1]],"t":[{},[0,2,1]],"u":[{},[0,2,1]]}]}],"b":[{"a":[{"r":[{"g":[{},[1]]}]}],"e":[{"r":[{"e":[{"d":[{},[1]]}],"f":[{},[1]],"ő":[{},[0,0,0,0,0,1,2]],"s":[{},[1]]}]}],"l":[{"e":[{"n":[{},[0,0,0,2]]}],"é":[{},[1]]}],"r":[{"e":[{},[0,0,1]],"i":[{},[1]],"o":[{},[0,0,1]]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"f":[{},[0,2,1]],"g":[{"e":[{"r":[{},[0,0,0,3]]}],"i":[{},[0,0,0,3]],"y":[{"e":[{"t":[{},[0,0,1]]}],"é":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"k":[{"é":[{"s":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,2,1]],"b":[{},[0,0,1]],"e":[{"t":[{},[1]]}],"k":[{"e":[{},[1]]}],"l":[{"á":[{},[0,2,1]]}],"m":[{},[0,2,1]],"o":[{},[2,2,1]],"ő":[{"b":[{},[1]],"e":[{},[1]],"n":[{"y":[{},[0,0,1]]}],"s":[{},[1]],"v":[{},[1]]}],"t":[{"y":[{},[1]]}]}],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}],"e":[{"l":[{},[0,2,1,2]]}],"u":[{},[0,2,1]]}],"n":[{"e":[{"r":[{},[0,2]],"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"p":[{},[0,2,1,2]],"r":[{"é":[{"n":[{"y":[{},[0,2,1,2]]}]}],"ő":[{},[0,2,1,2]]}],"s":[{"a":[{},[0,0,0,2]],"e":[{"t":[{"é":[{},[0,0,1,2]]}]}],"é":[{"s":[{},[0,2,1,2]]}],"z":[{"e":[{"m":[{},[0,0,1,2]],"t":[{},[0,2,1,2]]}],"k":[{},[0,2,1]],"m":[{},[0,2,1]]}]}],"u":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1,2]],"o":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,3]]}]}],"é":[{"g":[{},[0,2,1]],"h":[{"e":[{".":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"s":[{},[0,2,1,2]]}],"s":[{},[0,2]]}],"j":[{},[0,2,1,2]],"k":[{"e":[{},[0,2,1]],"r":[{},[0,0,1]]},[0,0,0,2]],"l":[{"e":[{"t":[{},[0,0,1,2]]}]}],"n":[{"e":[{"k":[{"e":[{},[0,2]]}]}]}],"p":[{},[0,2,1]],"r":[{"t":[{"e":[{"l":[{},[0,2]]}],"é":[{"k":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"n":[{},[0,2,1]]}]}]}]}],"s":[{"z":[{"l":[{},[0,0,1]]}]}],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{"r":[{},[0,0,0,2]]}],"e":[{"k":[{},[0,2,1,2]],"l":[{".":[{},[0,2,1]],"h":[{},[0,0,0,0,1]],"s":[{},[0,0,0,0,1]]},[0,0,0,2]]}]}]}],"f":[{"l":[{},[0,0,1]],"o":[{"g":[{"a":[{"d":[{"a":[{},[0,0,0,0,2]]},[0,0,0,0,0,0,2]]}]}]}],"r":[{},[0,0,1,2]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{"é":[{},[0,2]],"ő":[{},[0,0,1,2]]}],"g":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"s":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"á":[{},[0,2]]},[0,0,0,2]],"n":[{"f":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}]}],"p":[{},[0,2,1,2]],"r":[{"a":[{},[0,2,1]],"á":[{},[0,2]],"o":[{},[0,2,1]],"t":[{},[0,2,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"z":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"o":[{},[0,0,0,2]]}]}],"z":[{"é":[{},[0,0,1]],"g":[{},[0,0,1]],"o":[{},[0,2,1,2]]}]}],"í":[{"g":[{},[0,2]],"j":[{},[0,2,1]],"r":[{},[0,2]],"v":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"é":[{"k":[{"m":[{},[1]],"v":[{},[1]]}]}]}],"o":[{"k":[{"l":[{},[0,2,1]],"o":[{},[0,0,1]],"t":[{},[0,2,1]]},[0,0,0,2]],"l":[{"a":[{},[0,0,1]],"d":[{},[0,2,1]],"l":[{},[0,0,1]],"t":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"k":[{},[0,2,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"t":[{},[0,0,0,1,2]]}],"ó":[{"r":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,1,2]]}]}],"ö":[{"b":[{},[0,2,1]],"k":[{"ö":[{},[0,2,1]]},[0,0,0,2]],"l":[{"d":[{},[0,2,1]],"é":[{},[0,0,1]]},[0,0,0,2]],"n":[{},[0,2,1]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{".":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,0,1]],"ö":[{},[0,0,1,2]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"p":[{"á":[{"t":[{},[1]]}],"c":[{},[0,0,1]],"r":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1]],"o":[{},[0,0,1]],"ó":[{},[0,0,1]]}],"s":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,0,1]],"m":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{".":[{},[1,2]],"d":[{},[0,2]],"g":[{},[0,2]],"j":[{},[0,2]],"k":[{},[1,2]],"l":[{"z":[{},[1]]}],"m":[{},[1,2]],"n":[{"o":[{},[0,0,1]]}],"r":[{},[0,2]],"s":[{"z":[{},[0,2]]}],"t":[{"a":[{"l":[{},[0,0,1]]}],"á":[{},[0,2,1,2]],"c":[{},[0,2]],"ó":[{},[0,2,1]]}]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,0,1]],"t":[{},[0,2,1]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{"ő":[{},[0,2,1,2]]}],"n":[{"n":[{},[0,2,1]]}],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}],"z":[{"r":[{},[0,0,1]]}]}],"n":[{"a":[{"b":[{},[0,2,1]],"d":[{"o":[{},[0,0,1,2]]}],"g":[{"i":[{},[0,0,1]]}],"j":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"l":[{"a":[{},[0,0,1,2]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]]}],"n":[{},[0,2,1,2]],"p":[{"á":[{},[0,0,1,2]],"e":[{},[0,0,0,2,1]]}],"r":[{"á":[{},[0,0,1,2]],"c":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1]]}],"t":[{"k":[{},[0,0,1]]}],"u":[{"t":[{},[0,0,1]]}]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"g":[{},[0,0,1]],"l":[{"d":[{},[0,0,1]],"m":[{},[0,0,1]]}],"r":[{"a":[{},[0,2,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1,2]],"u":[{},[0,2,1]]}],"t":[{"k":[{},[0,0,1]],"m":[{},[0,0,1]],"v":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"a":[{},[0,0,2,1,2]],"á":[{"r":[{},[0,0,2,1]]}],"h":[{},[0,0,2,3]],"i":[{"p":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"ö":[{},[0,0,2,1,2]],"s":[{"é":[{"g":[{},[0,0,0,3]]}],"o":[{"r":[{},[0,0,2,3]]}],"p":[{},[0,0,0,3,2]],"z":[{},[0,0,0,3]]}],"u":[{},[0,0,2]]}],"d":[{"a":[{"d":[{"á":[{},[0,0,2,1]]}],"l":[{"k":[{},[0,0,2,1]]}],"n":[{"o":[{},[0,0,2]]}]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}],"r":[{"n":[{},[0,0,2,1]]}],"t":[{"l":[{},[0,0,2,1]]}]}],"é":[{"j":[{"é":[{},[0,0,0,1,2]]}],"r":[{".":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{"ő":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}]}],"o":[{"r":[{},[0,0,2,1]]}],"ó":[{"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]]}],"ö":[{"s":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,1,2]]}],"ú":[{},[0,0,2]],"z":[{"a":[{},[0,0,2]]}]}],"e":[{"á":[{},[0,0,0,0,2]],"g":[{"é":[{"r":[{},[0,2,1]]}],"g":[{},[0,2,1]]}],"l":[{"e":[{"k":[{},[0,0,1,2]]}],"j":[{"á":[{},[0,0,1]]}],"k":[{},[0,0,1]],"l":[{},[0,2,1]],"m":[{},[0,0,1]],"n":[{"y":[{},[0,0,1]]}],"ü":[{},[0,0,1]],"v":[{"á":[{},[0,0,1]]}]}],"m":[{"l":[{},[0,2,1]]}],"ó":[{},[0,0,0,0,2]],"p":[{},[0,0,0,1,2]],"r":[{"á":[{},[2]],"g":[{},[1,2]],"n":[{},[0,2,1]],"v":[{},[0,2]]}],"s":[{"z":[{"t":[{"á":[{},[0,0,0,1]]}]}]},[2]],"t":[{"a":[{"l":[{},[0,0,0,2]]}],"o":[{"s":[{},[0,0,0,2]]}]}],"x":[{},[0,2,1]]}],"é":[{"k":[{"a":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"p":[{"í":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"r":[{".":[{},[0,2,1]],"d":[{},[0,2]],"é":[{},[0,2,1]],"i":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"s":[{"z":[{"a":[{},[0,0,0,2]],"e":[{"r":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2,0,1]]}]}]}],"t":[{"k":[{},[0,2,1]]}],"v":[{"e":[{"s":[{},[0,2,1]]}],"i":[{"g":[{},[0,0,0,2]]}]}]}],"f":[{"l":[{"u":[{"o":[{},[0,0,0,0,0,0,2]]}]},[0,0,1,2]]}],"g":[{"a":[{"n":[{},[0,0,2]]},[0,0,0,0,2]],"e":[{"d":[{"é":[{},[1]]}],"r":[{"ő":[{},[0,0,0,0,0,1,2]]}]}],"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"g":[{},[0,0,0,1]]}],"i":[{"d":[{"é":[{},[0,2]],"i":[{"o":[{},[0,0,0,0,0,2]]}]}],"g":[{"a":[{},[0,2,1,2]],"e":[{},[0,2,1]],"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"á":[{},[0,2]]}],"n":[{"a":[{},[0,2,1]],"d":[{},[0,0,1]],"f":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"r":[{"a":[{},[0,2,1]],"á":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,0,1]],"m":[{},[0,2,1]],"z":[{"a":[{},[0,0,0,2]],"e":[{"r":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]],"ó":[{},[0,0,0,2,0,1,2]]}]}]}],"í":[{"v":[{},[0,2,1]]}],"k":[{"j":[{},[0,0,1,2]]}],"n":[{"e":[{"m":[{"e":[{},[0,0,2,1]]}],"s":[{},[0,0,2]]}],"é":[{"g":[{"e":[{},[0,0,0,1]]}],"k":[{"e":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{},[0,0,2]]}],"i":[{"r":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2,1]]}],"ú":[{},[0,0,2]],"ü":[{"l":[{},[0,0,2,1]]}],"y":[{"a":[{"d":[{},[0,0,0,0,1,2]],"s":[{},[0,0,0,0,1]]}],"á":[{},[0,0,0,0,1]],"e":[{"r":[{},[0,0,3]]}],"í":[{},[0,0,0,0,1,2]],"u":[{},[0,0,3]]}]}],"o":[{"b":[{},[0,2,1]],"f":[{},[0,2,1]],"i":[{},[0,2,1]],"l":[{"d":[{},[0,0,1]],"v":[{},[0,2,1]]}],"n":[{"i":[{},[0,0,0,2]]}],"p":[{"t":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,0,2,1,2]]}],"s":[{"t":[{},[0,2,1]],"z":[{"t":[{},[0,0,1]]}]}],"x":[{},[0,2,1]]}],"ó":[{"t":[{"a":[{"l":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"e":[{},[0,0,0,2,1,2]]}]}],"ö":[{"b":[{},[0,2,1]],"l":[{},[0,2,1]],"n":[{},[0,0,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1,2]],"v":[{},[0,3]]}],"ő":[{"r":[{"ü":[{},[0,0,0,2]]}]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"y":[{},[0,0,1]]}],"s":[{"a":[{"b":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2,1]]}],"é":[{"r":[{"t":[{"é":[{},[0,0,2,1]]}]}]}],"s":[{"z":[{"á":[{},[0,0,0,3]]}]}],"z":[{"o":[{"n":[{},[0,0,2,3]]}]}]}],"t":[{"a":[{"c":[{},[0,0,2,1,2]],"d":[{"a":[{},[0,0,2]]}],"g":[{"y":[{},[0,0,0,1]]}],"k":[{},[0,0,0,0,1,2]],"l":[{"a":[{},[0,0,2,1,2]],"j":[{},[0,0,0,1]],"k":[{},[0,0,2,1]],"o":[{},[0,0,0,1,2]]}],"n":[{"d":[{},[0,0,0,1]],"y":[{},[0,0,2,1,2]]}],"s":[{"s":[{},[0,0,0,1]]}]}],"á":[{"r":[{"a":[{"k":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"á":[{},[0,0,2,1]],"ú":[{},[0,0,2,1,2]]}]}],"e":[{"l":[{"m":[{"é":[{},[0,0,2,1]]}]}],"r":[{"a":[{},[0,0,0,0,2,1]]}],"s":[{"t":[{"e":[{},[0,0,2,1]],"é":[{},[0,0,2,1]],"i":[{},[0,0,2,1]]}]}],"t":[{"r":[{},[0,0,0,0,1,2]]}]}],"é":[{"g":[{},[0,0,2,1,2]],"p":[{},[0,0,2]],"r":[{"m":[{},[0,0,2]]}],"v":[{"e":[{".":[{},[0,0,2,1,2]]}]}]}],"i":[{"g":[{"é":[{},[0,0,2]]}],"o":[{},[0,0,2,1,2]],"p":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{"z":[{},[0,0,0,0,2]]}]}],"o":[{"k":[{"t":[{},[0,0,2,1]]}]}],"ö":[{"n":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,1]],"n":[{},[0,0,0,2]]}]}],"u":[{"n":[{},[0,0,2]],"r":[{},[0,0,2,1,2]]}],"ü":[{"z":[{},[0,0,2,1,2]]}]}],"u":[{"t":[{"a":[{},[0,0,1]]}]}],"ú":[{"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ű":[{"z":[{},[0,2,1]]}],"y":[{"a":[{"b":[{},[0,2]],"d":[{},[0,2,0,1,2]],"e":[{},[0,2,0,1]],"g":[{"a":[{},[0,0,0,1]],"á":[{},[0,0,0,1]]},[0,0,0,0,2]],"j":[{},[0,2,0,1]],"l":[{"k":[{},[0,0,0,1]]}],"n":[{},[0,2,0,1,2]],"r":[{"é":[{},[0,0,0,1]]}],"s":[{},[0,2,0,1]],"t":[{},[0,2,0,1]],"u":[{},[0,2,0,1]]}],"d":[{},[0,0,0,1,2]],"e":[{"d":[{"z":[{"é":[{},[0,0,0,1,2]]}]}],"l":[{"m":[{},[0,2]],"ő":[{"n":[{},[0,0,0,1]]}],"v":[{"o":[{},[0,0,0,1]],"ű":[{},[0,0,0,1]]}]}],"r":[{"ő":[{},[0,2,0,1,2]]}],"v":[{"e":[{},[0,0,0,1]]}]}],"é":[{"v":[{"a":[{},[0,2]]}]}],"h":[{"i":[{".":[{},[1]]}],"ő":[{"s":[{},[0,0,0,2,1]]}]}],"i":[{"d":[{},[0,2,0,1]],"n":[{"g":[{},[0,2]]}],"r":[{"a":[{},[0,2,0,1]]}],"z":[{},[0,2]]}],"í":[{"r":[{"ó":[{},[0,0,0,1,2]]}]}],"o":[{"k":[{},[0,2]],"l":[{},[0,2,0,1,2]],"r":[{},[0,2,0,1]],"s":[{},[0,2,0,1]]}],"ó":[{},[0,2,0,1,2]],"ö":[{"k":[{"ö":[{},[0,2,0,1]]},[0,0,0,0,2]],"t":[{},[0,2]]}],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ú":[{"t":[{},[0,0,0,1]]}],"v":[{"a":[{"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"e":[{".":[{},[1]],"l":[{},[0,0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}]}],"z":[{"a":[{"l":[{},[0,0,2]]}],"i":[{"m":[{},[1]]}]}]}],"o":[{"á":[{"z":[{},[0,0,2]]}],"b":[{"o":[{},[0,2]]}],"d":[{"e":[{},[0,2]],"ú":[{},[0,0,2]]}],"g":[{"r":[{"a":[{"f":[{"i":[{},[0,0,0,2]]}]}]}]}],"k":[{"a":[{},[0,2]],"á":[{"d":[{},[0,0,2]],"r":[{},[0,2]]}],"é":[{},[0,2]],"l":[{},[0,2,1,2]],"o":[{"n":[{},[0,2]],"s":[{},[0,0,2]]}],"ö":[{},[0,0,2]]}],"l":[{"a":[{"j":[{},[0,0,2]]}],"ó":[{},[0,2]],"y":[{},[0,0,2]]}],"m":[{"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]]}],"n":[{"a":[{"l":[{},[0,0,2,1]],"n":[{"y":[{},[0,0,0,1]]},[0,0,2]],"t":[{"o":[{"m":[{},[0,0,2]]}]}],"u":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"d":[{},[0,0,0,1,2]],"e":[{"r":[{},[0,0,2]]}],"f":[{},[0,0,0,1,2]],"i":[{"z":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"t":[{"r":[{},[0,0,0,1,2]]}],"ú":[{},[0,0,2,1]],"ü":[{},[0,0,2]]}],"p":[{"a":[{},[0,2]],"e":[{},[0,0,2]],"l":[{},[0,2,1,2]],"r":[{"o":[{},[0,0,1]]}]}],"r":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"s":[{},[0,0,2]]}],"é":[{"s":[{},[0,0,2,1]]}],"g":[{"i":[{"a":[{},[0,0,0,0,0,2]],"á":[{"b":[{},[0,2,0,0,0,2]]}]}]}],"i":[{"t":[{"á":[{},[0,0,0,0,2]]}]}],"k":[{},[0,0,0,1,2]],"ö":[{},[0,0,2]],"s":[{},[0,0,0,1,2]]}],"s":[{"o":[{},[0,0,2]],"t":[{},[0,2]],"z":[{"a":[{},[0,2]],"f":[{},[0,0,1,0,2]]}]}],"t":[{"í":[{},[0,2]],"o":[{},[0,2]],"r":[{},[0,0,1,2]]}],"v":[{"i":[{},[0,0,2]]}]},[0,1]],"ó":[{"a":[{"d":[{},[0,0,0,2]]}],"b":[{"ö":[{},[0,2]]}],"c":[{"e":[{},[0,0,2]]}],"d":[{"á":[{},[0,0,2]]}],"f":[{"a":[{},[0,2]]}],"h":[{"e":[{},[0,2]]}],"j":[{"e":[{},[0,2]]}],"k":[{"a":[{"p":[{},[0,2]]}],"é":[{"p":[{},[0,2]]}],"o":[{"r":[{},[0,2]]}]}],"m":[{"i":[{},[0,2]],"ű":[{},[0,2]]}],"n":[{"é":[{},[0,2]],"o":[{},[0,0,2]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,2]],"e":[{},[0,2]]}],"s":[{"u":[{},[0,2]],"z":[{"o":[{},[0,2]]}]}],"t":[{"a":[{},[0,2]],"á":[{},[0,2]],"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"í":[{},[0,2]],"r":[{"é":[{},[0,0,1]]}]}],"v":[{"a":[{"k":[{},[0,0,2]]}],"e":[{},[0,2]],"é":[{},[0,2]],"í":[{},[0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]},[0,1]],"ö":[{"b":[{"ö":[{},[0,0,2]]}],"d":[{"é":[{},[0,0,2]]}],"k":[{"ö":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"m":[{"ö":[{},[0,0,2]]}],"n":[{"ö":[{},[0,0,2]]}],"r":[{"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{".":[{},[0,2]]}],"v":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"z":[{"ö":[{},[0,0,2]]}]},[0,1]],"ő":[{"r":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}]},[0,1]],"p":[{"a":[{"b":[{},[0,2,1]],"d":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2]],"ó":[{},[0,2,1,2]]}],"g":[{"y":[{},[0,0,1,2]]}],"k":[{"a":[{},[0,2,1]],"k":[{},[0,2,1]],"n":[{},[0,2,1]]}],"l":[{"a":[{"k":[{},[0,0,1,2]],"p":[{},[0,0,1,2]]}],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"o":[{"m":[{},[0,0,0,2]]}]}],"n":[{"y":[{},[0,2,1,2]]}],"r":[{"á":[{"n":[{},[0,0,0,2]]}]}],"t":[{"r":[{"ó":[{},[0,0,1]]}]}],"u":[{"t":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1,2]]}]}],"á":[{"b":[{},[0,2,1]],"g":[{},[0,2,1,2]],"l":[{"l":[{"á":[{},[0,0,1]]}]}],"r":[{"a":[{},[0,2,1,2]]}],"s":[{"a":[{},[0,2,1]]},[0,0,0,2]],"t":[{"a":[{},[0,0,1]],"c":[{},[0,0,1]],"é":[{},[0,2,1,2,1]],"f":[{},[0,0,1]],"m":[{},[0,2,1]],"o":[{},[0,0,1,2,1]],"t":[{},[0,0,1]],"ü":[{},[0,0,1]],"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"d":[{"z":[{},[0,2,1,2]]}],"l":[{"e":[{"m":[{"r":[{},[0,0,1,2]]}],"t":[{},[0,2,1,2]]}],"l":[{"á":[{},[0,2,1]]}],"o":[{},[0,2,1]]}],"n":[{"e":[{},[0,2,1]]}],"r":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{"c":[{},[0,0,0,2,1,2]],"v":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"ü":[{"l":[{},[0,0,0,2]]}]}],"s":[{"t":[{"i":[{},[0,2,1]]}],"z":[{"á":[{},[0,0,0,2]],"m":[{"é":[{},[0,2]]}]}]}],"x":[{},[0,2,1]]}],"é":[{"d":[{},[1,2]],"é":[{"b":[{},[1]],"i":[{},[1]],"n":[{},[1]]}],"g":[{},[0,2,1]],"i":[{"t":[{},[1,2]]}],"j":[{},[0,2]],"k":[{"h":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,1]],"m":[{},[0,0,1]]}],"n":[{"k":[{},[1,2]]}],"r":[{".":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]]}],"i":[{"d":[{"o":[{},[0,0,1]]}],"k":[{"o":[{},[0,2,1,2]]}],"n":[{"d":[{},[0,0,1]],"g":[{"a":[{},[0,2,1]]}]}],"r":[{"á":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"s":[{"m":[{},[0,2,1]]}],"z":[{},[0,2]]}],"í":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"v":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"a":[{"g":[{},[0,0,2]],"k":[{"á":[{},[0,1,2]]}],"n":[{},[0,1,2]]}],"á":[{"n":[{},[0,1,2]]}]}],"o":[{"b":[{},[0,2,1]],"c":[{"h":[{},[0,2]]}],"k":[{"t":[{},[0,0,1]]}],"l":[{"v":[{},[0,2,1]]}],"p":[{"e":[{},[0,0,1]]}],"r":[{"n":[{},[0,2,1]],"s":[{"ó":[{},[0,0,1]]}]}],"s":[{"z":[{".":[{},[1]],"a":[{},[1]],"á":[{},[1]],"t":[{".":[{},[1]],"á":[{},[0,0,1]]}]}]}]}],"ö":[{"l":[{},[0,2,1,2]],"n":[{"t":[{},[0,0,1]]}],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"ő":[{"r":[{"i":[{},[0,2,1]]}]}],"p":[{"a":[{"n":[{},[0,0,2]]}],"á":[{"t":[{},[0,0,2]]}],"e":[{"l":[{"e":[{},[0,0,2,1,2]],"h":[{},[0,0,2,1]]}],"r":[{"ó":[{},[0,0,0,1]]}]}],"ó":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{},[0,0,2]],"r":[{"o":[{},[0,0,1]],"ó":[{},[0,0,1]]}]}],"r":[{"e":[{"t":[{},[0,0,3]]}],"é":[{"d":[{},[0,1,2]]}],"i":[{"n":[{},[0,1,2]]}],"o":[{"j":[{},[0,1]],"t":[{},[0,1,2]]}]}],"s":[{"k":[{},[0,0,1,2]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{"d":[{},[0,0,2]],"j":[{},[0,0,2,1]]}],"í":[{"v":[{},[0,0,2,1,2]]}],"o":[{"p":[{},[0,0,2,1]]}]}],"u":[{"g":[{},[0,2,1]],"t":[{"a":[{},[0,2,1,2]],"ó":[{},[0,2,1]]}]}],"ú":[{"j":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}]}],"r":[{"a":[{"b":[{"l":[{"a":[{},[0,0,1]]}],"o":[{"r":[{},[0,0,1,2]]}],"r":[{},[0,2,1]],"s":[{},[0,0,1]]}],"d":[{"a":[{"t":[{},[0,0,0,2]]}],"á":[{},[0,2,1,2]],"m":[{},[0,0,1]],"o":[{},[0,0,1,2]],"ó":[{},[0,2,1,2]],"r":[{},[0,0,0,1]]}],"g":[{"e":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"j":[{"a":[{},[0,2,1,2]],"k":[{},[0,2,1]],"t":[{"ó":[{},[0,0,1]]}]}],"k":[{"a":[{"d":[{},[0,2,1,2]],"s":[{},[0,2,1,2]]}],"c":[{},[0,2,1]],"t":[{"i":[{},[0,2,1]]}]}],"l":[{"a":[{},[0,0,1,2]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,0,1]],"o":[{},[0,2,1,2]],"s":[{},[0,0,1]],"t":[{},[0,2,1]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,0,1]],"p":[{},[0,0,1]]}],"n":[{"g":[{"y":[{},[0,0,1]]}],"n":[{},[0,0,1]],"y":[{"a":[{},[0,0,1,2]]}]}],"p":[{"a":[{".":[{},[0,0,1,2]]}],"p":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"o":[{},[0,2,1,2]]}],"s":[{"p":[{},[0,2,1]],"z":[{"a":[{"l":[{},[0,0,0,2,0,1,2]],"v":[{},[0,0,0,2]]}],"á":[{"r":[{"n":[{},[0,0,0,2]]}]}],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"p":[{},[0,0,0,2,0,1,2]]}]}]}],"t":[{"k":[{},[0,2,1]],"l":[{},[0,2,1]],"r":[{},[0,0,0,1,2]],"t":[{},[0,0,1]]}],"u":[{"t":[{},[0,0,1]]}],"z":[{"o":[{},[0,2,1,2]]}]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"f":[{"é":[{},[0,0,0,2]]}],"g":[{"e":[{},[0,0,1]],"ú":[{},[0,0,1,2]],"y":[{},[0,2,1,2]]}],"l":[{"l":[{"á":[{},[0,0,1]],"é":[{},[0,0,1]],"o":[{},[0,0,1]],"ó":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"p":[{"o":[{},[0,0,1]]}],"r":[{".":[{},[0,2,1]],"a":[{"k":[{},[0,0,1,2]]}],"á":[{},[0,0,1,2]],"b":[{},[0,2,1]],"e":[{},[0,0,1]],"é":[{},[0,0,1]],"f":[{},[0,0,1]],"k":[{},[0,0,1]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,0,1]],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1]],"v":[{},[0,0,1]]}],"s":[{"á":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"t":[{"e":[{},[0,0,1,2,1,2]],"h":[{},[0,2,1]],"i":[{},[0,0,1,2]],"í":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,0,1]],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"b":[{"i":[{"n":[{"a":[{},[0,0,0,1,2]]}]}]}],"c":[{"a":[{"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"e":[{"l":[{"l":[{},[0,0,0,1]]}]}],"h":[{"o":[{},[0,0,2,3]]}],"i":[{"d":[{},[0,0,2]],"n":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1]]}],"p":[{"á":[{},[0,0,2,1,2]]}],"s":[{},[0,0,2]]}],"k":[{},[0,0,0,1,2]],"o":[{},[0,0,0,0,2]],"ö":[{},[0,0,2]],"s":[{"a":[{"d":[{},[0,0,2]],"n":[{},[0,0,2,0,1]]}],"á":[{"l":[{},[0,0,0,0,1]]}]}],"ú":[{},[0,0,2]],"z":[{},[0,0,2]]}],"d":[{"e":[{"j":[{},[1]]}],"ő":[{},[1]]}],"e":[{"á":[{},[0,0,0,0,2]],"d":[{"e":[{"t":[{"ű":[{},[1]]}]}],"é":[{"n":[{},[0,2]]}],"m":[{},[1,2]]}],"e":[{},[0,0,0,0,2]],"f":[{"f":[{},[0,0,1]]}],"g":[{"á":[{"l":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,2,1,2]]}]}],"i":[{"g":[{},[0,0,0,0,2]]}],"j":[{"é":[{"n":[{},[1,2]],"r":[{},[1,2]]}]}],"k":[{"e":[{"l":[{},[0,0,0,2,1]],"s":[{"z":[{"ű":[{},[0,0,0,0,1,2]]}]}]}],"é":[{"j":[{},[0,0,0,0,1,2]]}],"o":[{"t":[{},[0,0,0,2]]}],"t":[{},[0,0,0,0,1]],"ú":[{"s":[{},[0,0,0,2,1,2]]}]}],"l":[{"e":[{"g":[{},[0,2,1,2]]}],"é":[{"r":[{},[0,0,1]]}],"l":[{"e":[{"n":[{},[0,2,1]]}],"i":[{},[0,0,1]]}],"ö":[{},[0,2,1]],"r":[{},[0,2,1]]}],"m":[{"e":[{"g":[{"y":[{},[0,0,0,0,1]]}],"m":[{"b":[{},[0,0,0,2,1]]}]}],"é":[{"r":[{"t":[{"é":[{},[0,0,0,0,1]]}]}]}],"u":[{"t":[{},[0,0,0,2,1]]}]}],"n":[{"z":[{},[0,2,1]]}],"o":[{"g":[{"r":[{"a":[{},[0,0,0,0,1]]}]}]}],"p":[{"a":[{"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"e":[{"s":[{"é":[{},[0,0,0,2,1,2]]}]}],"i":[{"n":[{},[0,0,0,2]]}],"o":[{"s":[{},[0,0,0,2]]}]}],"r":[{"k":[{},[0,0,1]],"n":[{},[0,0,1]],"ó":[{},[0,0,1]]}],"s":[{"t":[{"i":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{},[0,2,1]]}],"z":[{"e":[{".":[{},[0,2]]}],"í":[{},[0,0,0,2]],"ü":[{},[0,2]]}]}],"t":[{"á":[{"l":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"e":[{"g":[{},[0,0,0,2,1]],"r":[{"j":[{},[0,0,0,2,1]]}]}],"é":[{"r":[{"ő":[{".":[{},[0,0,0,2,1,2]]}]}],"v":[{"e":[{".":[{},[0,0,0,2,1,2]]}]}]}],"ö":[{},[0,0,0,0,0,2]]}],"v":[{"é":[{"s":[{},[0,0,1,2]]}]}],"x":[{},[0,2,1]],"z":[{"e":[{"t":[{".":[{},[1,2]],"e":[{},[1,2]]}]}],"ő":[{"k":[{"h":[{},[1]]}]}]}]}],"é":[{"b":[{"e":[{"s":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"g":[{".":[{},[0,0,1]],"e":[{},[0,0,1,2]],"é":[{},[0,0,1]]}],"j":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"f":[{},[0,0,1]],"n":[{},[0,2,1]],"s":[{},[0,2,1]]}],"k":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2]],"o":[{"l":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2,1]]}],"n":[{"e":[{"k":[{"e":[{},[0,2]],"é":[{},[0,2,1,2]]}]}]}],"p":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2]]}],"r":[{"e":[{"n":[{},[0,2,1,2]]}],"é":[{},[0,2,1,2]],"i":[{},[0,2,1,2]]}],"s":[{"a":[{},[0,0,0,2]],"e":[{"l":[{"v":[{},[0,0,0,2,1]]}]}],"z":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"ö":[{},[0,0,0,2]]}]}],"t":[{"e":[{"r":[{},[0,0,1,2]]}],"k":[{},[0,2,1]]}],"v":[{".":[{},[0,2,1]],"e":[{".":[{},[0,0,1,2]],"k":[{},[0,2,1,2]],"n":[{},[0,2]],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"é":[{"n":[{},[0,2,1,2]],"t":[{},[0,0,1,2]]}],"f":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,2,1,2]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,2,1,2]]}]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1]]}],"i":[{"d":[{"e":[{"g":[{},[0,2,1,2]]}],"é":[{},[0,2]],"o":[{},[0,2,1]],"u":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,0,2]],"á":[{},[0,2,1,2]]}],"k":[{"o":[{"n":[{},[0,2,1,2]]}]}],"m":[{"i":[{},[0,2,1,2]]}],"n":[{"o":[{},[0,0,0,2]],"t":[{"e":[{"g":[{},[0,2]]}],"r":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}],"o":[{"n":[{},[0,2,1,2]],"s":[{},[0,0,0,2]]}],"p":[{"a":[{"r":[{},[0,2,1,2]]}]}],"r":[{"a":[{},[0,2,1]],"ó":[{},[0,0,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,0,1]],"z":[{"o":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,2,1]]}],"z":[{"é":[{},[0,2,1,2]],"g":[{},[0,2,1]]}]}],"í":[{"g":[{},[0,0,1]],"j":[{".":[{},[0,0,1]],"á":[{},[0,0,1]]}],"r":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"k":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"m":[{"e":[{"k":[{"a":[{},[0,0,0,0,2,1,2]],"á":[{},[0,0,0,0,2]],"e":[{"s":[{"z":[{},[0,0,0,0,2]]}]}],"o":[{},[0,0,0,0,2]],"ö":[{"l":[{},[0,0,0,0,2]]}]}],"s":[{"z":[{"á":[{},[0,0,0,0,2,0,1]]}]}]}],"i":[{"n":[{"d":[{},[0,0,2]]}],"s":[{"i":[{},[0,0,0,1]]}]}]}],"n":[{"a":[{"l":[{"a":[{},[0,0,0,1]]}]}],"é":[{"k":[{"n":[{},[0,0,0,1]]}]}],"n":[{},[0,0,0,3]],"ó":[{"d":[{},[0,0,2,1,2]]}],"y":[{"ő":[{},[1]]}]}],"o":[{"k":[{"l":[{},[0,0,1]],"m":[{},[0,2,1]]}],"l":[{"d":[{"a":[{},[0,0,1]]}],"i":[{},[0,2,1,2]]}],"n":[{"a":[{"l":[{},[0,0,0,2]]}]}],"p":[{"e":[{},[0,0,1]],"t":[{},[0,2,1]]}],"r":[{"c":[{},[0,0,1]],"d":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1,2]],"s":[{},[0,0,1]],"v":[{},[0,2,1]]}],"s":[{"z":[{"f":[{},[0,0,0,0,0,2]]}]}],"v":[{"e":[{},[0,2,1,2]],"i":[{},[0,2,1]]}]}],"ó":[{"c":[{},[0,2,1]],"d":[{"á":[{},[0,0,1,2]]}],"l":[{"o":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1,2]],"i":[{},[0,0,1]]}]}],"ö":[{"c":[{},[0,2,1,2]],"k":[{"l":[{},[0,0,1]],"o":[{},[0,0,1]],"ö":[{},[0,2,1]]},[0,0,0,2]],"l":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ő":[{"d":[{"d":[{},[0,2]]}],"é":[{"n":[{},[0,0,0,0,2]]}],"l":[{"t":[{},[1]]}],"m":[{"é":[{},[1,2]],"h":[{},[1]]}],"n":[{"ö":[{},[1,2]]}],"ö":[{},[1,2]],"r":[{"i":[{},[0,2,1]],"ö":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"r":[{"é":[{"v":[{},[0,0,2]]}],"y":[{},[0,0,1]]}],"s":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{"k":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"á":[{"g":[{"i":[{},[0,0,2,1,2]]}],"r":[{"a":[{},[0,0,0,1]]}]}],"e":[{"m":[{"l":[{},[0,0,0,1]]}]}],"é":[{"r":[{"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]]}]}]}],"i":[{"d":[{},[0,0,2]],"m":[{},[0,0,2,1]],"n":[{},[0,0,2,1,2]]}],"k":[{"á":[{},[0,0,1]]}],"o":[{"d":[{},[0,0,2,1]],"l":[{},[0,0,2,1]]}],"ó":[{"n":[{},[0,0,2,1]]}],"p":[{"o":[{"r":[{},[0,0,1]]}]}],"r":[{"á":[{},[0,0,1]]}],"t":[{"r":[{"a":[{},[0,0,1]]}]}],"u":[{"t":[{},[0,0,2]]}],"z":[{"t":[{"o":[{},[0,0,0,0,2]]}]}]}],"t":[{"a":[{"i":[{},[0,0,2,1]]}],"á":[{"p":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{"a":[{"d":[{"a":[{},[0,0,0,0,0,1]]},[0,0,0,0,0,0,2]]}]}]}],"e":[{"l":[{"k":[{"é":[{},[0,0,2,1]]}]}],"s":[{"t":[{"j":[{},[0,0,0,1]]}],"z":[{"e":[{},[0,0,0,1]]}]}]}],"é":[{"j":[{},[0,0,2,1,2]],"k":[{"n":[{},[0,0,2,1]]}],"v":[{"é":[{"n":[{},[0,0,2,1]],"v":[{},[0,0,2,1,2]]}]}]}],"i":[{"d":[{},[0,0,2]],"m":[{},[0,0,2,1,2]]}],"í":[{"z":[{},[0,0,2,1]]}],"o":[{"s":[{},[0,0,2]]}],"ó":[{"r":[{"á":[{},[0,0,0,1]]}]}],"ö":[{"s":[{},[0,0,2,1]],"z":[{},[0,0,2,1]]}],"r":[{"a":[{"n":[{},[0,0,1,2]]}],"é":[{"n":[{},[0,0,1]]}]}],"s":[{},[0,0,0,1]],"ú":[{"t":[{},[0,0,2,1]]}]}],"u":[{"b":[{"i":[{},[0,0,0,0,0,2]]}],"p":[{},[1,2]],"r":[{"a":[{},[0,2,1,2]],"á":[{},[0,0,1]],"u":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1,2]]}],"t":[{"á":[{},[0,0,1,2]]}]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1,2]],"t":[{"j":[{},[0,0,1]],"l":[{},[0,0,1]],"o":[{},[0,0,1,2]],"r":[{},[0,0,1]]}]}],"ü":[{"d":[{},[0,2,1]],"g":[{"g":[{},[0,2,1]],"y":[{"b":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}]}],"l":[{"e":[{"d":[{},[0,2,1]]}]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1,2]]}],"v":[{"a":[{"l":[{"a":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"á":[{"r":[{"u":[{},[0,0,2,1,2]]}],"s":[{"a":[{},[0,0,2]]}],"t":[{"k":[{},[0,0,2,1]]}]}],"e":[{"l":[{"ő":[{"k":[{"é":[{},[0,0,0,1,2]]}]}]}],"r":[{"e":[{"z":[{"e":[{},[0,0,2]]}]}]}],"s":[{"z":[{"e":[{},[0,0,2,1,2]]}]}]}],"é":[{"k":[{},[0,0,2]],"r":[{"t":[{"e":[{},[0,0,2]]}],"z":[{},[0,0,2,1]]}]}],"o":[{"s":[{},[0,0,2]]}],"ö":[{"s":[{},[0,0,2]]}],"ú":[{},[0,0,2]]}],"y":[{"a":[{},[0,0,1]]}]}],"s":[{"a":[{".":[{},[2]],"b":[{},[0,2,1,2]],"d":[{},[0,2,1,2]],"i":[{"t":[{},[2]]}],"l":[{"j":[{"a":[{},[0,2,1]]}],"m":[{},[0,0,1]]}],"n":[{"y":[{},[0,0,1]]},[0,0,0,2]],"p":[{"á":[{},[0,0,1]]},[0,0,0,2]],"r":[{"c":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"t":[{"y":[{},[0,0,1,2]]}],"u":[{},[0,2,1]]}],"á":[{"b":[{"ó":[{},[2]]}],"g":[{},[0,2,1,2]],"n":[{},[2]],"r":[{"a":[{},[0,0,1]],"u":[{},[0,0,1,2]]}],"t":[{},[2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"h":[{},[0,0,2]]}],"d":[{"ő":[{},[1]],"r":[{"ó":[{},[0,0,1]]}]}],"e":[{"d":[{"e":[{"z":[{},[1]]}]}],"f":[{"r":[{},[0,0,0,1]]}],"g":[{"y":[{"e":[{},[0,0,0,2]]}]}],"l":[{"m":[{},[0,2,1]]}],"n":[{"g":[{},[0,2]]}],"p":[{"r":[{"i":[{},[0,0,1]]}]}],"r":[{"d":[{},[0,2,1]],"e":[{"n":[{},[0,0,0,0,0,0,2]]}]}],"t":[{"t":[{"ü":[{},[1,2]]}]}]}],"é":[{".":[{},[2]],"g":[{"e":[{"l":[{},[0,0,0,2,1]]}]}],"l":[{"l":[{},[1]],"y":[{},[1]]}],"p":[{},[0,2,1]],"r":[{"c":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"i":[{"d":[{},[0,2,1,2]],"k":[{"e":[{"t":[{},[0,0,0,0,0,2,1]]}]}],"n":[{"a":[{},[0,2,1]]}],"p":[{"a":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,2,1]]}]}],"í":[{"t":[{"ő":[{"s":[{"t":[{},[1]]}]}]}],"z":[{"ű":[{},[0,0,1,2]]}]}],"k":[{"a":[{"t":[{},[0,1,2]]}],"á":[{"l":[{},[0,1,2]]}],"i":[{"c":[{},[0,0,2]]}],"ü":[{},[1]]}],"l":[{"a":[{"t":[{},[0,0,2]]}],"e":[{"g":[{"e":[{"l":[{},[0,0,0,0,0,0,2]]}]}],"t":[{"o":[{},[0,0,0,0,2,1]]}]}],"i":[{"n":[{},[0,0,2]]}],"u":[{},[0,1,2]]}],"m":[{"a":[{"c":[{},[0,1,2]]}]}],"n":[{"á":[{},[0,0,0,0,2]]}],"o":[{"k":[{".":[{},[2]],"a":[{},[2]],"b":[{"ó":[{},[2]]}],"k":[{},[2]],"r":[{},[2]]}],"n":[{},[2]],"p":[{},[0,2,1]],"s":[{".":[{},[2]],"a":[{},[2]],"z":[{},[0,0,1]]}],"t":[{"t":[{},[0,0,1]]}]}],"ó":[{"r":[{},[0,2,1,2]]}],"ő":[{"k":[{"á":[{},[0,0,0,0,0,2]]}],"z":[{},[0,2]]}],"p":[{"a":[{"n":[{},[0,0,2]]}],"e":[{"c":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"ó":[{},[0,1,2]]}],"r":[{"á":[{},[0,1,2]]}],"s":[{"t":[{"á":[{},[0,0,1]]}],"z":[{"a":[{"b":[{},[0,0,3]],"g":[{"a":[{},[0,0,0,0,1]]}],"r":[{},[0,0,0,0,1,2]]}],"e":[{"n":[{"c":[{},[1]]}],"r":[{"ű":[{},[0,0,3]]}]}],"é":[{"l":[{"e":[{"t":[{},[0,0,0,0,1]]}],"t":[{},[0,0,0,0,1]]}]}],"i":[{"n":[{"t":[{},[0,0,0,0,1]]}]}],"o":[{"k":[{},[0,0,0,0,1]]}],"ö":[{},[0,0,3]]}]}],"t":[{"a":[{"b":[{},[0,1,2]],"f":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"n":[{"a":[{},[0,0,2]],"y":[{},[0,0,2,1,2]]}],"p":[{"o":[{"l":[{"c":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"r":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,0,1]]}],"t":[{},[0,1,2]],"z":[{},[0,0,2]]}],"á":[{"p":[{},[0,0,2,1,2]],"r":[{"a":[{"m":[{},[0,0,0,1]]}],"i":[{},[0,0,2,1]],"n":[{},[0,0,2,1]]}],"t":[{},[0,0,2,1]]}],"e":[{"k":[{"o":[{},[1]]}],"n":[{"z":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,0,0,2,1]]}],"s":[{"t":[{"e":[{},[0,0,2,1]],"i":[{},[0,0,2,1]]}]}]}],"é":[{"i":[{"h":[{},[1]]}],"j":[{},[1]],"m":[{},[1]],"n":[{"k":[{},[1]]}],"r":[{".":[{},[0,0,2,1]],"i":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2]]}],"ü":[{},[0,0,2,1,2]]}]}],"i":[{"l":[{"l":[{},[0,0,2,1]]}],"n":[{"a":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"p":[{},[0,0,2]],"s":[{"z":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2,1]],"p":[{},[0,1,2]],"r":[{},[0,0,0,0,2]],"s":[{},[0,0,2,1]]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ö":[{"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"ő":[{"r":[{".":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"ö":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"u":[{"n":[{},[0,0,2]]}],"ú":[{},[0,0,2]],"ü":[{"r":[{},[0,0,2]],"z":[{},[0,0,2,1,2]]}]}],"u":[{"d":[{},[0,2,1]],"r":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]]},[0,0,0,2]],"t":[{"á":[{},[0,2,1]]}]}],"ú":[{"r":[{".":[{},[0,0,1]],"b":[{},[0,0,1]],"é":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{},[0,2,1,2]]}],"ü":[{"z":[{},[0,2,1]]}],"z":[{"a":[{"c":[{"é":[{},[0,0,0,1]]},[0,2,0,0,2]],"d":[{},[0,2]],"e":[{},[0,2,0,1,2]],"j":[{"t":[{},[0,0,0,1]]}],"k":[{"é":[{},[0,0,0,0,2,1]],"n":[{},[0,0,0,1]]}],"l":[{"j":[{},[0,0,0,1]]}],"n":[{"y":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,2,0,1]]}],"u":[{},[0,2,0,1]]}],"á":[{"r":[{"u":[{},[0,2]]}],"s":[{},[0,2,0,1]],"t":[{"s":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"e":[{"c":[{"e":[{},[0,2]]}],"g":[{"é":[{"r":[{},[0,0,0,0,0,1]]}],"y":[{},[0,2,0,1]]}],"k":[{"é":[{"s":[{},[0,0,0,1]]}]}],"l":[{"a":[{},[0,2,0,1]]}],"m":[{"e":[{"l":[{},[0,2,0,1,2]]}]}],"n":[{"c":[{},[1]]}],"r":[{"d":[{},[0,2,0,1]]}],"v":[{},[0,2]],"x":[{},[0,2,0,1]]}],"é":[{"d":[{"o":[{},[0,0,0,0,2]]}],"p":[{"í":[{},[0,0,0,1,2]]}],"r":[{"i":[{},[0,2,0,1,2]]}]}],"g":[{},[0,0,0,1,2]],"i":[{"p":[{"a":[{},[0,0,0,1,2]]}],"s":[{"k":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,2,0,1]]}],"z":[{},[0,2,0,1]]}],"k":[{"e":[{"l":[{},[0,0,0,0,0,2]]}]}],"m":[{"e":[{".":[{},[1]]}],"é":[{"b":[{},[1]],"i":[{},[1]],"j":[{},[1]],"k":[{},[1]],"n":[{},[1]],"t":[{},[1]],"v":[{},[1]]}]}],"o":[{"l":[{"d":[{},[0,2,0,1]]}]}],"ö":[{"l":[{"ő":[{},[0,0,0,1]]},[0,0,0,0,2]],"n":[{},[0,2,0,1]]}],"s":[{"á":[{},[0,0,3]],"e":[{},[0,0,0,3]]}],"t":[{"a":[{"b":[{},[0,0,0,2]],"d":[{},[0,0,0,2]],"g":[{"á":[{},[0,0,0,2,1,2]]}],"j":[{},[0,0,0,2]],"l":[{"a":[{},[0,0,0,2,1]],"j":[{},[0,0,0,2,1]]}],"p":[{},[0,0,0,2,1]]}],"á":[{"r":[{"f":[{},[0,0,0,0,1]],"n":[{},[0,0,0,2,1]]}]}],"e":[{"v":[{},[0,0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}],"s":[{"s":[{},[0,0,0,0,0,0,3]]}],"t":[{"i":[{},[1]]}]}],"i":[{"d":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2,1]]}],"ó":[{"r":[{},[0,0,0,2,1,2]]}],"ö":[{"l":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"ő":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"u":[{"t":[{},[0,0,0,2]]}],"ú":[{"t":[{},[0,0,0,2,1]]}],"ü":[{"z":[{},[0,0,0,2]]}]}],"ü":[{"g":[{},[0,2,0,1,2]],"z":[{},[0,2,0,1,2]]}],"ű":[{"s":[{},[1,2]],"t":[{},[1,2]]}],"z":[{},[0,0,0,1]]}]}],"t":[{"a":[{"b":[{"r":[{},[0,0,1]]}],"c":[{"é":[{},[0,0,1]]},[0,0,0,2]],"d":[{},[0,2,1,2]],"g":[{"á":[{},[0,2,1,2]],"y":[{},[0,2,1,2]]}],"j":[{},[0,2,1,2]],"k":[{"a":[{"s":[{},[0,0,1,2]]}],"c":[{},[0,2,1]],"ó":[{},[0,0,1]],"u":[{},[0,2,1]]}],"l":[{"a":[{"g":[{},[0,0,0,2]],"k":[{},[0,0,0,2]]}],"á":[{"s":[{},[0,0,1,2]]}],"b":[{},[0,2,1]],"d":[{},[0,0,1]],"f":[{},[0,0,1]],"g":[{},[0,2,1]],"j":[{},[0,0,1]],"k":[{},[0,2,1]],"o":[{},[1,2]]}],"n":[{"é":[{},[0,0,0,2,1]],"y":[{"a":[{"g":[{},[0,0,0,2]]}]}]}],"p":[{"r":[{},[0,2]]}],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,2,1]],"c":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"p":[{},[0,0,1]],"s":[{},[0,2,1]],"z":[{"á":[{},[0,0,1,2]]}]}],"t":[{"k":[{},[0,2,1]],"o":[{},[0,2,1,2]],"y":[{},[0,2,1]]}],"u":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"c":[{"s":[{},[0,2,1,2]]}],"f":[{},[0,2,1]],"g":[{".":[{},[0,0,1]],"a":[{},[0,2,1,2]],"b":[{},[0,0,1]],"g":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"h":[{},[0,2,1]],"j":[{"u":[{},[0,0,1]]}],"l":[{"l":[{},[0,0,1]],"m":[{},[0,2,1]]}],"r":[{"a":[{"d":[{},[0,2,1,2]]}],"e":[{},[0,0,1]],"n":[{"y":[{},[0,0,1]]}],"o":[{"n":[{},[0,0,0,2]]}],"ú":[{},[0,0,1,2]]}],"t":[{"a":[{"d":[{},[0,0,0,0,1,2]]},[0,2,1,2]],"h":[{},[0,2,1]],"l":[{},[0,0,1]],"s":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"h":[{},[0,0,2]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"a":[{},[0,0,0,0,2]],"g":[{"á":[{},[0,0,0,0,1]],"e":[{"l":[{},[0,0,0,2,1,2]]}],"ó":[{},[0,0,0,2]]}],"k":[{"e":[{".":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1,2]]}],"é":[{"k":[{},[0,0,0,2,1]],"n":[{"k":[{},[0,2,1,2]]}],"s":[{},[0,2,1,2]]}]}],"l":[{"c":[{},[0,2,1]],"d":[{"o":[{},[0,0,1]]}],"e":[{"g":[{"e":[{},[0,0,0,2]],"y":[{},[0,0,0,2]]}],"j":[{},[0,0,1,2]],"m":[{"z":[{},[0,2]]}],"s":[{"é":[{},[0,2,1,2]]}]}],"é":[{"r":[{"é":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}],"h":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"e":[{"l":[{},[0,0,1]]}]}],"i":[{"g":[{"a":[{},[0,2,1]]}]}],"j":[{"á":[{},[0,2,1]]}],"l":[{"á":[{},[0,2,1]],"e":[{"n":[{},[0,2]]}]}],"m":[{"e":[{},[0,2,1]],"é":[{"n":[{".":[{},[0,2,1]],"e":[{},[0,2,1]]}],"t":[{},[0,2,1]]}]}],"n":[{"e":[{"v":[{},[0,2,1]]}],"ö":[{},[0,2]],"y":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"ő":[{"a":[{"d":[{},[0,0,0,2]]}]}],"s":[{"z":[{"á":[{},[0,0,1]]}]}],"t":[{"á":[{},[0,2,1]],"e":[{"r":[{},[0,2,1]]}],"é":[{"r":[{"í":[{},[0,0,1]]}]}]}],"v":[{"á":[{},[0,2,1]],"e":[{"z":[{},[0,2,1]]}],"o":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"m":[{"a":[{"l":[{},[0,0,0,2]]}],"b":[{"e":[{"r":[{},[0,2,1]]}]}],"e":[{"l":[{},[0,0,0,2]]}]}],"n":[{"z":[{},[0,2,1]]}],"p":[{},[0,0,0,1,2]],"r":[{"d":[{},[0,2,1]],"é":[{"n":[{},[0,0,0,2]]}],"o":[{},[0,0,0,0,0,1]],"ő":[{},[0,2,1]]}],"s":[{"a":[{},[0,0,0,2,1]],"t":[{"e":[{".":[{},[0,2,1]]}]}],"z":[{"t":[{"é":[{},[0,2,1]]}]}]}],"t":[{"e":[{"t":[{"é":[{},[0,0,0,2]]}]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}],"s":[{"e":[{"n":[{},[1,2]]}],"n":[{},[1,2]]}]}],"o":[{"s":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2,1]],"r":[{"a":[{},[0,0,0,1]]}]}],"z":[{"r":[{},[0,2,1]]}]}],"é":[{"é":[{},[0,0,0,0,2]],"g":[{".":[{},[0,0,1]],"b":[{},[0,0,1]],"é":[{},[0,0,1,2]],"g":[{},[0,0,1]],"i":[{},[0,2,1,2]],"n":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1,2]],"e":[{"l":[{},[0,0,0,2,1,2]]}],"í":[{},[0,0,1]],"o":[{"s":[{},[0,0,0,2]]}]}],"l":[{"m":[{},[0,2,1]]}],"r":[{"c":[{},[0,2,1]],"é":[{".":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"i":[{"e":[{},[0,0,0,2]]}],"k":[{"e":[{},[0,2,1]]}],"m":[{},[0,2,1]],"ő":[{"s":[{},[0,2,1,2]]}],"t":[{"e":[{"l":[{},[0,2,1]]}]}],"z":[{},[0,2,1]]}],"s":[{"a":[{},[0,0,0,2]],"é":[{"g":[{},[0,0,0,2,1]]}],"o":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]],"z":[{"a":[{},[0,0,0,2]],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}]}],"t":[{"a":[{},[0,0,0,2,1,2]],"e":[{"r":[{".":[{},[0,0,0,2]],"e":[{},[0,0,0,2]]}]}],"r":[{"a":[{},[0,0,0,1]]}]}],"v":[{"e":[{"n":[{},[0,2,1,2]],"s":[{".":[{},[0,0,0,2]]}],"t":[{},[0,2,1,2]]}],"é":[{"h":[{},[0,2,1,2]],"i":[{"g":[{},[0,0,0,2]]}],"n":[{"e":[{},[0,2,1,2]]}],"t":[{"ő":[{},[0,0,0,2]]}]}],"h":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"h":[{"e":[{"i":[{},[0,0,2]]}]}],"i":[{"d":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"g":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,2]]}],"m":[{"a":[{},[0,0,1,2]],"á":[{},[0,2,1]],"i":[{},[0,2,1,2]],"o":[{},[1,2]],"p":[{},[0,2,1]]}],"n":[{"a":[{},[0,0,0,0,0,1]],"d":[{},[0,2,1]],"f":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"v":[{},[0,2,1]],"z":[{},[0,2]]}],"p":[{"a":[{},[0,2,1,2]]}],"r":[{"a":[{},[0,2,1,2]],"i":[{},[0,2,1]],"o":[{},[0,2,1]],"ó":[{},[0,2,1]]}],"s":[{"m":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"z":[{"a":[{},[0,2,1,2]],"o":[{"n":[{},[0,2,1,2]]}]}]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{"é":[{},[0,0,1]],"g":[{},[0,2,1]],"o":[{},[0,2,1]],"z":[{},[0,2,1]]}]}],"í":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1,2]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"n":[{"o":[{"l":[{},[1]]}]}],"o":[{"d":[{"a":[{},[0,0,1]]}],"k":[{"m":[{},[0,2,1]],"t":[{},[0,2,1]]}],"m":[{"l":[{},[0,2,1]]}],"n":[{"a":[{},[0,0,0,2,1,2]],"á":[{"l":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2,1]]}],"n":[{},[0,0,0,0,1]]}],"p":[{"c":[{},[0,0,1]],"e":[{},[0,0,1]],"t":[{},[0,2,1]]}],"r":[{"d":[{},[0,0,1]],"g":[{},[0,2,1]],"m":[{},[0,2,1]],"o":[{"m":[{},[0,0,1]]}],"s":[{},[0,2,1]],"v":[{},[0,2,1]]},[2]],"s":[{"t":[{},[0,0,1]],"z":[{"f":[{},[0,0,0,0,0,2]],"l":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"u":[{},[0,2,1]]}],"ó":[{"c":[{},[0,2,1,2]],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]]}],"v":[{},[0,2,1,2]]}],"ö":[{"k":[{"o":[{},[0,0,1]]}],"l":[{".":[{},[0,2,1]],"é":[{},[0,0,1]],"ő":[{},[0,2,1]]},[0,0,0,2]],"n":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{"ü":[{},[0,0,1,2]]}],"z":[{},[0,2,1,2]]}],"ő":[{"a":[{},[0,0,0,0,2]],"e":[{"l":[{},[0,0,0,0,2]]}],"é":[{"b":[{},[0,0,0,0,2]]}],"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"c":[{},[0,0,1]],"é":[{"h":[{},[0,0,1,2]]}],"i":[{".":[{},[0,0,0,2]]}],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,2,1]],"ö":[{"k":[{},[0,0,0,2]]}],"p":[{},[0,0,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"ü":[{},[0,0,1,2]]}],"s":[{"p":[{},[0,0,0,1,2]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"a":[{"p":[{},[0,1]],"u":[{},[0,1]]}],"á":[{"g":[{},[0,1,2]]}],"é":[{"f":[{},[0,1]]}],"i":[{"l":[{},[0,1,2]]}]}],"s":[{"k":[{},[0,0,1]],"n":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{"d":[{},[0,0,3]],"i":[{},[0,0,0,0,0,2]],"n":[{"ó":[{},[0,0,0,0,2,1,2]]}]}],"e":[{"l":[{"e":[{"m":[{},[0,0,2]]}]}]}],"i":[{"n":[{"g":[{},[0,0,2,1]]}]}],"í":[{"r":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,1,2]],"i":[{},[0,0,1]]}],"y":[{"á":[{},[0,0,0,0,1,2]]}]}],"u":[{"g":[{},[0,2,1]],"n":[{"a":[{},[0,0,1]],"d":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1,2]]}],"s":[{"z":[{},[0,0,0,2]]}],"t":[{"á":[{},[0,0,1]],"ó":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"ú":[{"j":[{},[0,2,1]],"r":[{"i":[{},[0,2,1,2]]}],"t":[{},[0,2,1]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{"d":[{},[0,2,1]]}],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{"e":[{"m":[{},[0,0,1,2]]}]}]}],"y":[{"a":[{},[0,0,3]]}]}],"u":[{"b":[{"o":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]]}],"k":[{"h":[{},[0,0,1,2]]}],"m":[{"a":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1]],"i":[{"m":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"s":[{},[0,0,2]],"z":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"ó":[{"r":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"p":[{},[0,0,0,1,2]],"ü":[{},[0,0,2]]}],"n":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"r":[{".":[{},[0,2]],"á":[{"z":[{},[0,0,0,1]]},[0,0,2]],"i":[{".":[{},[0,0,2]],"g":[{},[0,0,2]]}],"t":[{},[0,2]]}],"s":[{"z":[{"í":[{},[0,0,2]]}]}],"t":[{"a":[{"i":[{},[0,2]],"l":[{},[0,0,2]],"n":[{},[0,2]],"z":[{},[0,0,2]]}],"á":[{"i":[{},[0,2]],"j":[{"á":[{},[0,2]]}],"k":[{"a":[{},[0,2]],"k":[{},[0,2]],"n":[{"á":[{},[0,2]]}],"r":[{},[0,2]]}],"n":[{"k":[{},[0,2]]}],"r":[{},[0,2]]}],"ó":[{},[0,0,2]],"s":[{},[0,2]]}],"z":[{"s":[{},[0,0,2]]}]},[0,1]],"ú":[{"j":[{"í":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[0,1]],"ü":[{"d":[{"ü":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[0,1]],"ű":[{"r":[{"i":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[0,1]],"v":[{"á":[{"r":[{"a":[{"l":[{},[0,0,0,2,1]]}]}]}],"e":[{"s":[{"z":[{"ö":[{},[0,0,0,2]]}]}]}],"é":[{"l":[{"á":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2,1,2]]}]}],"n":[{"y":[{"e":[{"l":[{},[0,0,0,2]]}]}]}],"r":[{"e":[{"m":[{"b":[{},[0,0,0,2,1]]}]}],"ö":[{},[0,0,0,2]]}],"s":[{"o":[{},[0,0,0,2]],"z":[{"a":[{},[0,0,0,2]],"ö":[{},[0,0,0,2]]}]}]}],"í":[{"z":[{"i":[{"ó":[{"é":[{"t":[{},[0,0,0,0,0,2]]}]}]}]}]}]}],"x":[{"a":[{"b":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1]]}],"á":[{"b":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{},[0,2]],"l":[{"m":[{},[0,2,1]],"v":[{"á":[{},[0,2,1]]}]}],"r":[{},[0,2,1]]}],"é":[{"k":[{},[0,2,1]],"l":[{},[0,2,1]],"p":[{},[0,2,1]]}],"i":[{"d":[{"ő":[{},[0,0,1]]}],"g":[{"é":[{},[0,2,1]]}],"n":[{"f":[{},[0,0,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]]}],"z":[{"z":[{},[0,0,1]]}]}],"í":[{"j":[{},[0,2,1]],"r":[{},[0,2,1]]}],"o":[{"b":[{},[0,2,1]],"p":[{},[0,0,1]]}],"ö":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"p":[{"a":[{"n":[{},[1]]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}]}],"z":[{"a":[{"c":[{"é":[{},[0,0,1]]},[0,0,0,2]],"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"j":[{"t":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{"z":[{},[0,0,1]]}],"s":[{},[0,2,1]],"u":[{"t":[{},[0,0,1]]}]}],"á":[{"l":[{"l":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,0,2]]}],"r":[{"b":[{},[0,0,1]],"r":[{},[0,0,1]],"ú":[{},[0,0,1,2]]}],"t":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"á":[{"l":[{},[0,0,2]]}]}],"e":[{"g":[{"y":[{},[0,0,1,2]]}],"k":[{"é":[{"k":[{},[0,0,1,2]]}]}],"l":[{"a":[{},[0,2,1]],"e":[{"m":[{"e":[{},[0,2,1,2]]}]}],"é":[{"r":[{},[0,2,1]]}],"m":[{},[0,2,1]],"ö":[{},[0,2,1,0,1]]}],"m":[{"e":[{"l":[{},[0,2,1,2]]}]}],"n":[{"t":[{"e":[{},[0,0,0,0,2,1,2]]}]}],"r":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2]],"e":[{"d":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1]],"m":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]}],"o":[{},[0,0,0,2,1]],"ő":[{},[0,0,1]]}],"s":[{"t":[{"e":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1]],"e":[{"g":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2,1,2]],"s":[{"z":[{},[0,0,0,2,1]]}]}],"é":[{"r":[{".":[{},[0,0,0,2,1]],"ő":[{".":[{},[0,0,0,2,1,2]]}]}],"v":[{"e":[{".":[{},[0,0,0,2,1,2]]}]}]}],"o":[{},[0,0,0,2,1]],"u":[{},[0,0,0,2]]}]}],"é":[{"g":[{},[0,2,1]],"j":[{},[0,2,1,2]],"k":[{"á":[{},[0,0,0,2]],"o":[{},[0,0,0,2,1]]}],"l":[{},[0,2,1]],"r":[{"e":[{"m":[{"b":[{},[0,0,0,0,1]]}],"t":[{"t":[{},[0,0,0,2]]}]}],"u":[{},[0,0,0,2]]}],"s":[{"a":[{},[0,0,0,2]],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"t":[{"e":[{},[0,2,1,2]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{"o":[{},[0,0,1,2]]}],"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,2,1,2]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"p":[{},[0,0,1]]}],"n":[{"á":[{},[0,0,1]],"d":[{},[0,0,1]],"f":[{},[0,0,1]],"t":[{},[0,0,1]]}],"o":[{"n":[{},[0,0,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{},[0,0,1,2]],"s":[{"é":[{"g":[{"é":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"m":[{},[0,2,1]]}],"t":[{"a":[{},[0,0,0,2]]}]}],"í":[{"v":[{},[0,2,1,2]]}],"k":[{"r":[{},[0,0,1,2]],"u":[{"p":[{"a":[{"c":[{},[0,0,0,0,0,0,0,1]]}]}]}],"v":[{},[0,0,1]]}],"o":[{"b":[{},[0,2,1]],"l":[{"d":[{},[0,0,1]]}],"n":[{"á":[{"r":[{},[0,0,0,2]]}],"n":[{},[0,0,0,0,3]]}],"p":[{"t":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"ó":[{"l":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,0,1,2]]}],"ö":[{"b":[{},[0,0,1,2]],"s":[{},[0,0,1]],"v":[{},[0,0,1,2]]}],"ő":[{"e":[{"l":[{},[0,0,0,0,2]]}],"r":[{"i":[{},[0,2,1,2]],"l":[{},[0,0,1]],"s":[{},[0,2,1]],"ü":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"s":[{"o":[{"r":[{"r":[{"a":[{},[0,0,0,0,1]]}]}]}]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"r":[{"e":[{"d":[{"e":[{},[1]],"s":[{},[1]]}],"l":[{},[1]],"m":[{},[1]],"s":[{"n":[{},[1]]}]}],"ű":[{},[1]]}],"s":[{"a":[{"j":[{},[0,0,3]],"p":[{},[0,0,3]]}],"á":[{"t":[{},[0,0,3]],"v":[{},[0,0,3]]}],"é":[{},[0,2,3]],"i":[{"ó":[{},[0,0,0,0,0,2]]}],"l":[{},[0,0,3]],"o":[{"r":[{},[0,0,3]]}],"p":[{},[0,0,3,2]],"t":[{"a":[{},[0,0,3,2]],"r":[{},[0,0,3]]}],"ü":[{},[0,2,3]],"z":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"r":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"ú":[{"j":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"s":[{},[1,2]],"t":[{},[0,2,1]],"z":[{},[0,2,1,2]]}]}]}],"é":[{".":[{},[2]],"a":[{"d":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]]}],"j":[{"á":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2,1]]}],"n":[{"a":[{},[0,0,2]],"y":[{},[0,0,2]]}],"r":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"u":[{"k":[{},[0,0,2]]}]},[0,1]],"á":[{"f":[{"á":[{},[0,0,2]]}],"g":[{"y":[{},[0,0,2]]}],"j":[{"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}]},[0,1]],"b":[{"a":[{"g":[{},[0,2,1]],"j":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{"y":[{},[0,2,1]]},[0,0,0,2]],"v":[{},[0,2,1,2]]}],"á":[{"l":[{},[0,0,1]],"r":[{},[0,0,0,2]]}],"b":[{"á":[{},[0,0,2,1]]}],"e":[{"s":[{"z":[{"ű":[{},[0,0,1]]}]}]}],"é":[{"k":[{},[0,2,1,2]],"l":[{},[0,2,1]],"p":[{},[0,2,1]]}],"i":[{"é":[{},[0,0,0,0,2]],"s":[{"k":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1,2]]}]}],"í":[{"z":[{},[0,0,1]]}],"k":[{"r":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"e":[{"s":[{},[1]]}]}],"u":[{"g":[{},[0,2,1]]}],"ü":[{"g":[{},[0,0,1]]}]}],"c":[{"a":[{"d":[{},[0,0,1,2]],"j":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}],"á":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"e":[{"l":[{"e":[{"m":[{},[0,2,1,2]]}],"v":[{},[0,2,1]]}],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}],"e":[{"l":[{},[0,2,1,2]]}]}]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"a":[{},[0,0,3]],"á":[{},[0,0,3]],"í":[{},[0,0,3]],"o":[{},[0,0,3]]}],"i":[{"d":[{},[0,2,1,2]],"l":[{},[0,2,1]],"m":[{"a":[{},[0,0,1]]}]}],"o":[{"b":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"a":[{"b":[{},[0,0,3]]}],"o":[{"l":[{},[0,0,0,1]]}],"z":[{},[0,0,3]]}],"u":[{"t":[{},[0,2,1,2]]}],"ü":[{"l":[{},[0,2,1]]}],"z":[{"s":[{},[0,0,3]]}]}],"d":[{"a":[{"b":[{},[0,2,1]],"c":[{},[0,2,1,2]],"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"j":[{},[0,2,1,2]],"k":[{"c":[{},[0,0,1]],"t":[{},[0,0,1]],"u":[{},[0,0,1,2]]}],"l":[{"k":[{},[0,0,1]]}],"n":[{},[0,2,1,2]],"p":[{"a":[{},[0,0,1]],"á":[{},[0,0,1,2]]}],"r":[{"c":[{},[0,2,1]]}],"s":[{"p":[{},[0,0,1]],"s":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1,2]],"t":[{},[0,0,1]]}]}],"á":[{"g":[{},[0,2,1]],"p":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{},[0,2,1,2]],"j":[{},[0,2,1]],"k":[{"e":[{".":[{},[0,2,1,2]]}],"é":[{"t":[{"ő":[{},[0,0,0,2]]}]}]}],"l":[{"a":[{},[0,2,1,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"o":[{},[0,2,1]]}],"m":[{"b":[{"e":[{"r":[{},[0,0,1]]}]}],"l":[{},[0,2,1]]}],"n":[{"z":[{},[0,2,1]]}],"p":[{},[0,2,1]],"r":[{"d":[{},[0,0,1]],"e":[{"i":[{},[0,2]],"m":[{},[0,2]]}],"g":[{},[0,2]],"l":[{},[0,2]],"n":[{"é":[{},[0,2]]}],"ő":[{},[0,2,1]],"r":[{"á":[{},[0,2]],"ő":[{},[0,2]]}],"s":[{},[0,2]],"t":[{"ő":[{},[0,2]]}]}],"s":[{"a":[{},[1]],"e":[{"m":[{},[0,2]]}],"g":[{},[1]],"í":[{},[1,2]]}]}],"é":[{"g":[{},[0,2,1]],"j":[{},[0,2,1,2]],"k":[{"b":[{},[0,2,1]],"é":[{},[0,2,1,2]],"k":[{},[0,2,1]]}],"l":[{"e":[{},[0,2,1]],"m":[{},[0,2,1]]},[0,0,0,2]],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"i":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"a":[{"d":[{},[0,0,0,2]],"k":[{"a":[{},[0,0,0,2]]}],"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,0,0,0,2]]},[0,0,0,2,1]]}],"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1,2]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{},[0,2,1,2]],"n":[{"a":[{},[0,0,1,2]],"d":[{},[0,0,1]],"i":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"o":[{},[0,2,1]]}],"z":[{},[0,2,1,2]]}],"í":[{"n":[{},[0,2,1]],"r":[{},[0,2,1]],"v":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]]}],"o":[{"k":[{"t":[{"a":[{},[0,0,1]]}]}],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}],"t":[{"t":[{},[0,0,1]]}]}],"ó":[{"r":[{},[0,0,1,2]]}],"ö":[{"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,2,1,2]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ő":[{"r":[{"m":[{},[0,2,1]],"n":[{},[0,2,1]]}],"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"m":[{},[0,1,2]],"z":[{},[0,0,2]]}],"á":[{"m":[{},[0,1,2]]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[0,2,1]],"j":[{},[0,0,1]],"r":[{"a":[{},[0,0,1]]}],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1]]}],"z":[{"a":[{},[0,0,3]],"á":[{},[0,0,3]],"e":[{},[0,0,3]],"ó":[{},[0,0,3]],"ü":[{},[0,0,3]]}]}],"e":[{"b":[{"é":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"m":[{"e":[{},[0,0,2]]}],"p":[{"i":[{},[0,0,2]]}],"r":[{"ő":[{},[0,0,2]]}],"s":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]],"z":[{"a":[{},[0,0,2,0,1,2]],"á":[{},[0,0,2,0,1]],"e":[{"l":[{},[0,0,2]]}],"é":[{"p":[{},[0,0,2]]}],"i":[{"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"t":[{"r":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}]}],"u":[{"f":[{},[0,0,2]]}],"v":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[0,1]],"é":[{"g":[{"e":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]]}],"p":[{"í":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]]}]},[0,1]],"f":[{"a":[{"i":[{},[0,0,1]],"j":[{"t":[{"ó":[{},[0,0,1]]}]}]}],"i":[{"n":[{"g":[{},[0,0,1]]}],"s":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]]}],"o":[{"s":[{},[0,2,1]]}]}],"g":[{"a":[{"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{},[0,0,1,2]],"k":[{"a":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,0,1]]}],"l":[{"j":[{},[0,0,1]]}],"m":[{},[0,0,1]],"n":[{"y":[{},[0,0,1,2]]}],"p":[{},[0,0,1,2]],"r":[{},[0,2,1,2]],"u":[{"t":[{},[0,0,1]]}],"v":[{},[0,0,1,2]],"z":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1]],"p":[{},[0,0,1]],"r":[{"t":[{},[0,0,1]]}],"t":[{"a":[{"d":[{},[0,0,0,0,1,2]]}],"á":[{},[0,0,1]],"e":[{},[0,0,1,2,1,2]],"f":[{},[0,0,1]],"j":[{},[0,0,1]],"m":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"c":[{"e":[{},[0,0,1]]}],"d":[{"é":[{"n":[{},[0,2]]}],"z":[{},[0,2,1]]}],"g":[{"e":[{},[0,0,1,2]]}],"j":[{},[0,2,1]],"k":[{"é":[{"s":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,2,1]],"b":[{},[0,2,1]],"e":[{"g":[{},[0,0,0,2]],"k":[{},[0,0,2]],"m":[{"b":[{},[0,0,0,2]],"e":[{},[0,2,0,2]],"n":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}]}],"é":[{"r":[{},[0,2,1]]}],"f":[{},[0,2,1]],"h":[{"a":[{},[0,2,1]],"á":[{},[0,0,1]]}],"i":[{"n":[{},[0,0,0,2]],"s":[{},[0,2,1]]}],"j":[{"á":[{},[0,2,1]]}],"k":[{},[0,2,1]],"l":[{"á":[{},[0,2,1]],"e":[{"n":[{},[0,2,1]]}]}],"m":[{},[0,2,1]],"n":[{"ö":[{},[0,2]],"y":[{},[0,0,1]]}],"ö":[{},[0,2,1]],"ő":[{"a":[{},[0,2,1,2]],"m":[{},[0,0,0,2]],"n":[{},[0,2,1,2]],"t":[{},[0,0,1,2]]}],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{"a":[{},[0,2,1]],"z":[{"í":[{},[0,2,1]]}]}],"t":[{"a":[{},[0,0,1]],"á":[{},[0,2,1]]}],"v":[{"á":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"n":[{"c":[{},[0,2,1]],"e":[{},[0,2,1,2]],"g":[{},[0,2,1]]}],"p":[{"i":[{},[0,0,1]]},[0,0,0,1]],"r":[{"á":[{"l":[{},[0,0,0,2]]}],"e":[{"d":[{"e":[{},[0,2,1]]}],"l":[{},[0,0,0,2,1]]}],"i":[{"m":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"ó":[{},[0,2,1]],"ő":[{},[0,0,1]],"ü":[{"l":[{},[0,0,0,2]]}]}],"s":[{"d":[{},[1,2]],"s":[{"z":[{},[0,2,1]]}],"z":[{"e":[{},[0,0,0,2]],"k":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"t":[{"j":[{},[1,2]],"ő":[{"h":[{},[1,2]],"n":[{},[1,2]],"t":[{},[1,2]]}]}],"v":[{"a":[{},[0,0,1]],"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"o":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"k":[{},[0,2]],"n":[{},[0,2,1,2]]}]}]}],"p":[{"í":[{},[0,0,1]],"ü":[{},[0,2,1]]}],"r":[{"e":[{"t":[{},[0,0,1,2]],"z":[{},[0,2,1,2]]}],"é":[{".":[{},[0,0,0,2]]}],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"ő":[{".":[{},[0,0,1,2]],"k":[{},[0,0,1,2]]}],"t":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]]},[0,0,0,0,0,2]]}],"s":[{"é":[{},[1,2]],"n":[{},[1,2]],"t":[{},[0,2]]}],"v":[{"a":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"y":[{"o":[{},[0,0,3]]}]}],"h":[{"e":[{"s":[{},[1]]}],"ü":[{},[1]]}],"i":[{"a":[{"s":[{},[0,0,0,2]]}],"d":[{"e":[{"n":[{},[0,0,1,2]]}]}],"g":[{"a":[{".":[{},[0,2,1]],"p":[{},[0,0,0,0,1]],"s":[{},[0,0,0,0,1]],"z":[{},[0,0,1]]}],"á":[{},[0,0,0,0,1]]},[0,0,0,2]],"l":[{"l":[{},[0,2]]}],"m":[{"á":[{},[0,2,1]]}],"n":[{"a":[{},[0,0,1]],"f":[{},[0,0,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}],"r":[{"a":[{},[0,2,1]],"o":[{},[0,0,1]]}],"t":[{"a":[{},[0,2,1,2]]}],"v":[{"a":[{},[0,2,1]]}],"z":[{"é":[{"s":[{"n":[{},[0,2,1,2]]}]}],"g":[{},[0,2,1]]}]}],"í":[{"g":[{},[0,0,1]],"j":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"j":[{".":[{},[1]]}],"k":[{"i":[{"a":[{},[0,0,0,0,0,2]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{"e":[{".":[{},[1]]}],"é":[{"k":[{},[1]],"n":[{},[1]],"t":[{},[1]]}],"i":[{},[1]]}],"o":[{"b":[{},[0,2,1]],"k":[{"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]],"d":[{},[0,0,1]],"i":[{},[0,0,1]],"l":[{},[0,0,1]],"t":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{"t":[{},[0,0,1]]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"ó":[{"c":[{},[0,2,1]],"r":[{},[0,0,1,2]]}],"ö":[{"b":[{},[0,0,1]],"d":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{},[0,0,1]],"r":[{"ö":[{},[0,0,1]]},[0,0,0,2]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2]],"z":[{},[0,2,1,2]]}],"ő":[{".":[{},[1]],"k":[{},[1]],"r":[{"i":[{},[0,0,1]],"ö":[{},[0,0,1]]},[0,2]],"s":[{"i":[{},[0,0,1]]}],"t":[{},[1]],"v":[{},[1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1,2]],"z":[{".":[{},[1]],"á":[{"r":[{"a":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"d":[{},[0,2,1]],"n":[{},[0,0,1]],"t":[{},[0,2,1,2]]}],"ú":[{"g":[{},[0,0,1]],"j":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}],"v":[{"e":[{"z":[{"é":[{},[0,0,0,0,0,0,2]]}]}]}],"y":[{"a":[{},[0,2,0,1,2]],"á":[{"l":[{},[0,2]]}],"e":[{"d":[{"é":[{},[0,2]]}],"g":[{},[0,2,0,1]],"l":[{"e":[{"k":[{},[0,2]],"m":[{"e":[{},[0,2]]}]}]}],"m":[{"b":[{},[0,2,0,1]],"e":[{},[0,2,0,1]]},[0,0,0,0,2]],"s":[{"e":[{"k":[{"é":[{},[0,0,0,0,2]]}]}],"z":[{},[0,2,0,1]]}],"v":[{},[0,2,0,1,2]],"z":[{"e":[{},[0,2]]}]}],"é":[{"k":[{},[0,2,0,1]],"l":[{},[0,2]],"n":[{"e":[{},[0,0,0,1,2]]}]}],"i":[{"n":[{},[0,2]],"r":[{},[0,2]],"s":[{},[0,2,0,1]],"v":[{},[0,2,0,1]]},[0,0,0,0,2]],"í":[{},[0,2]],"o":[{"k":[{},[0,0,0,1]],"s":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"ó":[{},[0,2,0,1,2]],"ö":[{"l":[{},[0,0,0,1,2]]}],"u":[{},[0,2,0,1,2]],"ú":[{},[0,2,0,1]],"ü":[{"l":[{},[0,2,0,1,2]],"r":[{},[0,2]]}]}]}],"h":[{"a":[{"l":[{"a":[{},[0,0,1]]},[0,0,0,2]],"n":[{"y":[{},[0,0,1]]}],"r":[{"c":[{},[0,2,1]],"t":[{},[0,0,1]]}],"u":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"e":[{"d":[{"é":[{},[0,0,1]]}],"g":[{"é":[{},[0,0,1,2]]},[2]],"l":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1]],"f":[{},[0,0,1]],"h":[{},[0,0,1]],"l":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{"z":[{},[0,2,1]]}],"r":[{},[0,2,1,2]],"s":[{"e":[{"m":[{},[0,2,1]]}]}],"t":[{"o":[{},[0,2,1,2]]}],"v":[{"é":[{},[0,0,1]]}],"x":[{},[0,2,1]],"z":[{"e":[{},[0,2]],"é":[{},[1,2]],"ő":[{},[1]],"t":[{},[1,2]],"ü":[{},[0,2]],"v":[{},[0,2]]}]}],"é":[{"g":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"b":[{},[0,0,1]]}]}],"f":[{"l":[{},[0,0,1]]}],"i":[{"c":[{},[0,2,1]],"f":[{},[0,2,1]],"n":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"a":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,2]],"t":[{"a":[{},[0,0,1]]},[0,2]],"z":[{},[0,2,1]]}],"í":[{"n":[{},[0,0,1]]}],"k":[{"r":[{},[0,0,1]]}],"o":[{"d":[{},[0,2,1]],"l":[{"d":[{},[0,0,1]]}]}],"ö":[{"b":[{},[0,0,1]],"d":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"é":[{},[1]],"k":[{},[0,0,1]],"p":[{},[0,0,1]]}],"u":[{"d":[{},[0,0,1]]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]]}],"ű":[{"r":[{},[0,2,1]]}]}],"i":[{"d":[{"ő":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"é":[{},[0,0,2]]}],"m":[{"á":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]]}],"v":[{"á":[{"s":[{},[0,0,2]]}],"ó":[{},[0,0,2]]}]},[0,1]],"í":[{"r":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"v":[{"á":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[0,1]],"j":[{"a":[{"b":[{},[0,2,1]],"d":[{"a":[{},[0,2,1,2]]}],"l":[{},[0,2,1,2]],"n":[{"y":[{},[0,2,1]]}],"r":[{},[0,2,1,2]]}],"á":[{"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"n":[{},[0,2,1]]}]}],"e":[{"b":[{},[0,0,1]],"l":[{"e":[{"m":[{},[0,2,1,2]]}],"h":[{},[0,2,1]],"m":[{},[0,0,1]],"v":[{},[0,2,1]]}],"m":[{"b":[{},[0,0,1]]}],"s":[{"z":[{},[0,2,1]]}],"v":[{},[0,2,1,2]]}],"é":[{"g":[{},[0,2,1,2]],"j":[{},[0,0,0,2]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"t":[{"e":[{},[0,2,1,2]]}]}],"i":[{".":[{},[1,2]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{},[0,0,1,2]],"p":[{},[0,2,1]],"z":[{},[0,2,1]]}],"o":[{"l":[{},[0,2,1,2]]}],"ó":[{"r":[{},[0,0,1,2]]}],"ö":[{"d":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"z":[{},[0,0,1]]}],"u":[{"d":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{"a":[{},[0,0,1]]},[0,0,0,2]]}],"ú":[{"r":[{},[0,2,1]]}],"ü":[{"l":[{},[0,2]]}],"ű":[{"z":[{},[0,2,1]]}]}],"k":[{"a":[{"b":[{"l":[{},[0,0,1]]}],"c":[{"é":[{},[0,0,1,2]]}],"d":[{"a":[{"t":[{},[0,0,0,2]]}],"á":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]]}],"j":[{"t":[{},[0,0,1]]}],"k":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{},[0,2,1]],"k":[{},[0,2,1]],"n":[{},[0,2,1]]}],"l":[{"a":[{"g":[{},[0,0,0,2]],"k":[{},[0,0,1,2]]}],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{"o":[{},[0,0,1]]}],"l":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,0,1]]}],"m":[{"b":[{},[0,0,1]]}],"n":[{"g":[{},[0,0,1]]}],"p":[{"p":[{},[0,0,1]]}],"r":[{"á":[{},[0,2,1,2]],"c":[{},[0,0,1]],"é":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"s":[{"p":[{},[0,2,1]],"s":[{},[0,2,1]],"z":[{"t":[{},[0,0,1]]}]}],"t":[{"o":[{"m":[{},[0,0,1,2]]}]}],"v":[{"e":[{},[0,0,1,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"l":[{},[0,2,1]],"p":[{},[0,2,1,2]],"r":[{"a":[{"d":[{},[0,0,1]],"k":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"b":[{},[0,0,1]],"é":[{},[0,2,1,2]],"h":[{},[0,0,1]],"k":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]],"r":[{},[0,0,1]],"u":[{},[0,2,1,2]],"ú":[{},[0,0,1,2]]}],"s":[{"ó":[{},[0,0,1]],"v":[{},[0,0,1]]}],"t":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"c":[{},[0,2,1]],"d":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,0,1]],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1]],"í":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"ö":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,0,1]],"u":[{},[0,2,1]],"v":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{"é":[{},[0,0,1]]}],"k":[{"é":[{"s":[{},[0,2,1,2]]}]}],"l":[{"b":[{},[0,2,1]],"e":[{"g":[{},[0,2,1,2]],"m":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"m":[{},[0,0,0,2]]}]}],"é":[{"r":[{},[0,0,1,2]]}],"f":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{"á":[{},[0,2]],"e":[{"n":[{},[0,2,1]]}]}],"m":[{},[0,2,1]],"o":[{},[0,2,1]],"p":[{},[0,0,1]],"t":[{"a":[{},[0,2,1]],"á":[{},[0,0,1]],"é":[{"r":[{},[0,2,1]]}]}],"ü":[{"l":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}]}],"m":[{"e":[{"l":[{},[0,2,1,2]]}]}],"n":[{"g":[{},[0,0,1]]}],"p":[{},[0,0,0,1,2]],"r":[{"d":[{},[0,2,1]],"e":[{"c":[{},[0,2,1,2]],"d":[{},[0,2]],"i":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"g":[{},[0,2,1]],"ó":[{},[0,2,1,2]],"ő":[{},[0,2,1,2]]}],"s":[{"e":[{"t":[{"e":[{},[0,2,1,2]]}]}],"z":[{"k":[{},[0,0,1]],"l":[{},[0,0,0,1]]}]}],"t":[{"e":[{"t":[{},[0,2,1,2]]}],"i":[{"k":[{},[0,0,0,2]]}]}],"v":[{"é":[{"s":[{},[0,0,0,2]]}],"o":[{},[0,2,1,2]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1]],"j":[{"s":[{},[0,0,1]]}],"p":[{"í":[{},[0,2,1]],"ü":[{},[0,2,1]]}],"r":[{"c":[{},[0,2,1]],"e":[{"m":[{},[0,2,1,2]],"n":[{},[0,2,1,2]]}],"é":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"ő":[{".":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1,2]]}],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"ü":[{},[0,2,1,2]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{"l":[{},[0,0,1]]}]},[2]],"t":[{"k":[{},[0,2,1]],"v":[{},[0,0,1]]}],"v":[{"e":[{".":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"t":[{},[0,0,1,2]]}],"é":[{"b":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]]}],"i":[{},[0,2,1]]}]}],"f":[{"j":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"a":[{},[0,0,0,0,2]],"d":[{"e":[{},[0,2,1]],"é":[{},[0,0,1]],"o":[{},[0,0,1]],"ő":[{},[0,2,1]]},[0,0,0,2]],"g":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"i":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]],"g":[{},[0,2,1]],"h":[{},[0,2,1]],"n":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{"á":[{"n":[{},[0,2]]}],"o":[{},[0,2,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,0,1]],"t":[{},[0,2,1]],"z":[{"a":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{},[0,2,1,2]]}],"í":[{"j":[{},[0,0,1]],"r":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"k":[{"á":[{"l":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"l":[{"u":[{},[0,1,2]]}],"o":[{"b":[{},[0,2,1]],"f":[{},[0,0,1]],"k":[{"á":[{},[0,2,1]]}],"l":[{"a":[{"j":[{},[0,2,1,2]]}],"d":[{"a":[{},[0,2,1]]}],"t":[{"á":[{"s":[{},[0,0,1]]}]}]}],"m":[{"l":[{},[0,2,1]]}],"p":[{"c":[{},[0,0,1]],"e":[{},[0,0,1,2]]}],"r":[{"g":[{},[0,2,1]],"m":[{},[0,2,1]],"r":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"t":[{"o":[{},[0,2,1]]}]}],"t":[{"t":[{},[0,2,1]]}],"u":[{},[0,2,1]],"x":[{},[0,2,1]]}],"ó":[{"c":[{},[0,2,1]],"l":[{},[0,0,1,2]],"n":[{},[0,2,1]],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]]}],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"ö":[{"b":[{},[0,2,1,2]],"l":[{},[0,0,0,2]],"m":[{},[0,2,1]],"n":[{"t":[{},[0,0,1]]}],"r":[{"ö":[{},[0,0,1,2]]}],"s":[{},[0,2,1]],"t":[{"l":[{},[0,2,1]]}],"v":[{"ö":[{},[0,0,1,2]]}],"z":[{"ö":[{},[0,0,1,2]]}]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"e":[{"á":[{},[0,1,2]]}],"i":[{"m":[{},[0,0,2]]}]}],"s":[{"h":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{"d":[{},[0,2,1]],"i":[{},[0,2]]}],"t":[{"a":[{"c":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"l":[{},[0,0,1,2]],"s":[{},[0,2,1,2]]}],"á":[{},[0,2,1]]}]}],"ú":[{"j":[{},[0,2,1]],"r":[{".":[{},[0,0,1]],"n":[{},[0,0,1]]}],"t":[{"h":[{},[0,2,1]],"i":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2]]},[0,0,0,2]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{"e":[{},[0,0,1,2]]}],"n":[{"n":[{},[0,2,1]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"ű":[{"r":[{".":[{},[0,0,1]],"b":[{},[0,0,1]],"ö":[{},[0,0,1,2]]}],"z":[{},[0,2,1]]}]}],"l":[{"a":[{"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"é":[{},[0,0,1,2]]}],"d":[{"a":[{},[0,0,1,2]],"o":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]]}],"g":[{},[0,0,1,2]],"j":[{},[0,2,1,2]],"k":[{"a":[{},[0,0,1,2]],"c":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"m":[{"c":[{},[0,0,1]],"e":[{},[0,0,1,2]]}],"n":[{"d":[{},[0,0,1]]}],"p":[{"ó":[{},[0,0,1]]}],"r":[{"m":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"t":[{"o":[{},[0,0,1,2]]}],"u":[{},[0,0,1,2]],"v":[{"a":[{},[0,2,1,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"g":[{},[0,2,1,2]],"l":[{"l":[{},[0,2,1]],"m":[{"á":[{},[0,2,1]],"o":[{"t":[{},[0,2]]}]}],"o":[{},[0,2,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,0,1]],"á":[{},[0,0,1,2]],"b":[{},[0,0,1]],"f":[{},[0,0,1]],"i":[{},[0,0,1,2]],"k":[{},[0,0,1]],"n":[{},[0,2,1]],"o":[{},[0,0,1,2]],"r":[{},[0,0,1]],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1,0,1,2]],"c":[{},[0,0,1]],"e":[{},[0,0,0,0,1,2]],"f":[{},[0,2,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1,2]],"j":[{},[0,0,1]],"m":[{},[0,2,1]],"o":[{"k":[{},[0,0,0,2]]}],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"ü":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"s":[{"z":[{},[0,0,0,3]]}]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"b":[{"é":[{},[0,2,1]]},[0,0,0,2]],"d":[{"z":[{},[0,2,1,2]]}],"f":[{"f":[{},[0,0,1]]}],"g":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]},[0,0,1,2]],"y":[{},[0,0,1,2]]}],"k":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2,1,2]],"m":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]]}],"é":[{"s":[{},[0,2,1,2]]}],"i":[{"s":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]],"t":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2]],"ö":[{},[0,0,0,2,1,2]],"u":[{},[0,0,0,2]],"ú":[{},[0,0,0,2,1]]}],"l":[{"a":[{},[0,0,1,2,1]],"e":[{"g":[{},[0,2,1,2]]}],"f":[{},[0,0,1]],"o":[{},[0,2,1]],"ő":[{"e":[{},[0,2,1]],"j":[{},[0,0,0,2]],"k":[{},[0,2,1,2]],"t":[{},[0,0,0,2]]}]}],"m":[{"b":[{},[0,2]],"i":[{},[0,2,1,2]],"p":[{},[0,2,1]]}],"n":[{"e":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2]],"n":[{},[0,2,1]],"y":[{},[0,2,1]],"z":[{},[0,2,1]]},[0,0,0,2]],"r":[{"ó":[{},[0,0,1,2]]}],"s":[{"é":[{"s":[{},[0,2,1,2]]}],"z":[{"ü":[{},[0,0,0,2]],"ű":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1,2]],"e":[{"g":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2,1,2]],"r":[{},[0,0,0,2,1,2]],"s":[{"z":[{},[0,0,0,2]]}]}],"é":[{"k":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2]],"r":[{".":[{},[0,0,0,2,1]],"d":[{},[0,0,0,2,1]],"ő":[{".":[{},[0,0,0,2,1,2]]}],"ü":[{},[0,0,0,2]]}],"s":[{},[0,0,0,2]],"t":[{"e":[{},[0,0,0,2]],"é":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}],"v":[{"e":[{".":[{},[0,0,0,2,1,2]],"d":[{},[0,0,0,2,1,2]]}],"é":[{"n":[{},[0,0,0,2,1,2]]}]}]}],"i":[{"k":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,2]]}]}],"o":[{},[0,0,0,2,1]],"ó":[{},[0,0,0,2]],"ö":[{"l":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"u":[{},[0,0,0,2,1,2]],"ü":[{"z":[{},[0,0,0,2]]}],"ű":[{"z":[{},[0,0,0,2,1,2]]}]}],"v":[{"ő":[{},[0,2,1,2]]}],"x":[{},[0,2,1]]}],"é":[{"d":[{"e":[{},[0,2,1]]},[0,0,0,2]],"g":[{},[0,2,1,2]],"h":[{"e":[{"s":[{},[0,0,1,2]]}]}],"k":[{"e":[{"k":[{},[0,0,1]]}],"í":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"p":[{"ü":[{},[0,0,1]]}],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"d":[{},[0,2,1]],"e":[{"m":[{},[0,0,1,2]],"t":[{},[0,2,1,2]]}],"é":[{},[0,2,1,2]],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}],"ü":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"s":[{"a":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]]}],"t":[{"e":[{},[0,2,1,2]],"k":[{},[0,2,1]]}],"v":[{".":[{},[0,2,1]],"á":[{},[0,2,1,2,1]],"e":[{"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"é":[{"n":[{},[0,0,1,2]],"r":[{},[0,2,1,2]]}],"i":[{},[0,2,1,2]],"ü":[{},[0,0,1]]}]}],"f":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1]],"á":[{},[0,0,0,2]],"e":[{},[0,2,1,2]],"é":[{},[0,2,1]]}],"k":[{"o":[{},[0,2,1,2]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]],"i":[{},[0,0,1]],"p":[{},[0,0,1]]},[0,0,0,2]],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"o":[{"n":[{},[0,0,1,2]]}],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,2,1]],"o":[{},[0,0,1]]}],"s":[{"m":[{},[0,2]],"p":[{},[0,0,0,1,2]],"z":[{"á":[{},[0,2,1,2]]}]}],"v":[{"a":[{},[0,0,1,2]],"á":[{},[0,2,1,2]]}],"z":[{"g":[{},[0,0,1]],"m":[{},[0,2,1]],"o":[{},[0,2,1,2]]}]}],"í":[{"j":[{},[0,0,1]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"l":[{"y":[{"u":[{},[0,0,3]]}]}],"m":[{"a":[{"t":[{},[0,0,2]]}],"é":[{"n":[{},[1]]}]}],"o":[{"b":[{},[0,2,1]],"k":[{"m":[{},[0,2,1]],"s":[{},[0,2,1]]}],"l":[{},[0,2,1]],"r":[{},[0,2,1,2]],"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,2,1]]}]}],"ó":[{"c":[{},[0,2,1]],"n":[{},[0,0,1,2]],"r":[{},[0,2,1,2]]}],"ö":[{"b":[{},[0,0,1]],"c":[{},[0,0,1,0,1]],"k":[{},[0,0,0,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"ő":[{"e":[{},[0,0,0,0,2]],"r":[{"ü":[{},[0,0,1]]}],"s":[{"k":[{},[1,2]]}]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"á":[{"d":[{"i":[{},[0,0,0,0,0,0,2]]}]}],"e":[{"p":[{"r":[{},[0,0,0,0,1]]}]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{"á":[{"r":[{"n":[{"n":[{},[0,0,2,0,1]]}]}]}],"t":[{},[0,0,1]]}]}],"t":[{"a":[{"l":[{"p":[{"a":[{"l":[{},[0,0,0,0,0,2,1]]}]}]}]}],"r":[{"á":[{},[0,0,1]],"é":[{},[0,0,1]],"i":[{},[0,0,1]],"ó":[{},[0,0,1]]}]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"l":[{"t":[{},[0,0,1]]}],"r":[{},[0,0,1,2]],"t":[{"a":[{"s":[{},[0,2,1,2]]}],"ó":[{},[0,0,1]]}]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"l":[{},[0,0,1]],"t":[{},[0,0,1]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,0,1]]}],"v":[{"e":[{"z":[{"ő":[{},[1]]}]}]}],"y":[{"a":[{"b":[{},[0,2,0,1]],"d":[{},[0,2,0,1,2]],"j":[{},[0,2]],"l":[{},[0,2,0,1,2]],"n":[{},[0,0,0,1,2]],"p":[{},[0,2,0,1]],"r":[{},[0,0,0,1,2]],"s":[{},[0,2,0,1]],"u":[{},[0,0,0,1]],"v":[{},[0,2,0,1]],"z":[{},[0,0,0,1]]}],"á":[{"l":[{},[0,2,0,1,2]]}],"e":[{"c":[{},[0,0,0,0,2]],"f":[{},[0,2]],"g":[{"y":[{},[0,0,0,1]]}],"k":[{"é":[{"s":[{},[0,2]]}]}],"l":[{},[0,2,0,1]],"m":[{"l":[{},[0,2]]}],"n":[{"e":[{},[0,2]],"t":[{},[0,2,0,1]]}],"r":[{},[0,2]],"t":[{"i":[{},[0,2]]}]}],"é":[{"j":[{},[0,2,0,1,2]],"k":[{},[0,2,0,1]],"l":[{},[0,2]],"s":[{},[0,2]]}],"f":[{},[0,0,0,1,2]],"i":[{"r":[{"a":[{},[0,2,0,1]]}]}],"k":[{},[0,0,0,1,2]],"o":[{"l":[{},[0,2]]}],"ó":[{},[0,2,0,1]],"ö":[{"s":[{},[0,2]],"z":[{},[0,2,0,1]]}],"ő":[{},[0,2]],"s":[{},[0,0,0,1]],"ú":[{},[0,0,0,0,2]],"ü":[{"l":[{"t":[{"e":[{"t":[{},[0,2]]}]}]}],"t":[{},[0,2]]}]}]}],"m":[{"a":[{"b":[{"r":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]]},[0,0,0,1,2]],"e":[{},[0,0,0,0,2]],"i":[{"k":[{},[0,0,0,0,2]]}],"j":[{"t":[{},[0,0,1]]}],"k":[{"k":[{},[0,0,1]]}],"l":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]]}],"p":[{"p":[{},[0,0,1]]}],"r":[{"c":[{},[0,0,1]],"m":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"t":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1,2]]}]}],"á":[{"c":[{},[0,0,0,2]],"l":[{"m":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"p":[{},[0,2,1]],"r":[{"n":[{},[0,0,1]],"u":[{},[0,2,1]]}],"t":[{"a":[{},[0,0,0,0,1]],"t":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"c":[{},[0,0,0,2]],"g":[{},[0,0,0,2]],"k":[{"e":[{".":[{},[0,2,1,2]]}],"é":[{"s":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,0,1]],"e":[{"d":[{},[0,0,0,2]]}],"h":[{},[0,2,1]],"l":[{},[0,2,1]],"ő":[{},[0,0,1,2]],"s":[{},[0,0,1]],"v":[{},[0,2,1]]}],"r":[{"e":[{},[0,0,1,2]],"n":[{},[0,0,1]],"ő":[{},[0,0,1,2]]}],"s":[{"á":[{},[0,0,0,2,1]],"e":[{"m":[{"é":[{},[0,2,1]]}]}],"z":[{},[0,2,1]]}],"t":[{"a":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"k":[{},[0,0,0,2,1]]}],"o":[{},[0,0,0,2]]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"é":[{"k":[{"s":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"c":[{},[0,2,1]],"d":[{},[0,0,1]],"i":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{"é":[{},[0,2,1]]}]}],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1,2]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"a":[{"l":[{},[0,0,0,2]]}],"d":[{},[0,2,1,2]],"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"s":[{},[0,0,1]]}],"l":[{"l":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]],"f":[{},[0,0,1]],"v":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,0,1]],"h":[{},[0,0,1]],"o":[{},[0,2,1]]}],"s":[{"k":[{},[0,0,1]],"m":[{},[0,0,1]],"z":[{},[0,0,0,2]]}],"t":[{"a":[{},[0,0,1,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"í":[{"r":[{},[0,2,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"n":[{"a":[{"c":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"n":[{},[0,0,0,0,1]],"t":[{},[0,0,0,0,0,2]]}],"p":[{},[0,0,1,2]],"s":[{"t":[{},[0,0,1]]}],"x":[{},[0,0,1]]}],"ó":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"ö":[{"b":[{},[0,0,1]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"z":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"j":[{},[0,0,1]],"n":[{"a":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]]}],"ú":[{"r":[{},[0,2,1]]}],"ü":[{"g":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"w":[{"h":[{},[0,0,1]]}]}],"n":[{"a":[{"b":[{"b":[{},[0,0,1]],"l":[{},[0,2,1]]}],"d":[{"a":[{"l":[{},[0,2,0,2]]}],"á":[{},[0,0,1]],"o":[{},[0,0,1,2]]}],"g":[{"á":[{},[0,0,1]],"r":[{},[0,0,1]]}],"k":[{"c":[{},[0,0,1]],"n":[{},[0,2,1]],"t":[{},[0,0,1]]}],"l":[{"k":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"o":[{},[0,0,1]],"t":[{},[0,0,1]]}],"p":[{"r":[{"é":[{},[0,0,0,1]]}]}],"r":[{"c":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,0,1]],"s":[{},[0,2,1]]},[0,0,0,0,2]],"t":[{"m":[{},[0,0,1]],"o":[{"m":[{},[0,2,1,2]]}],"r":[{},[0,0,0,1,2]]}],"u":[{},[0,2,1]]}],"á":[{"g":[{},[0,2,1]],"l":[{"a":[{},[0,0,1]],"c":[{},[0,0,1]],"d":[{},[0,0,1]],"l":[{},[0,2,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{"a":[{"k":[{},[0,2,1,2]]}]}],"s":[{"s":[{},[0,0,0,0,1]],"v":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"b":[{},[0,0,1]],"e":[{},[0,0,1]],"k":[{},[0,0,1]],"ö":[{},[0,0,1]],"r":[{},[0,2,1]],"t":[{},[0,0,1]],"ü":[{},[0,0,1]],"v":[{},[0,2,1]]}]}],"b":[{"a":[{},[0,0,0,0,2]],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"f":[{},[0,2,1]],"g":[{"y":[{},[0,0,1,2]]}],"k":[{"a":[{},[1,2,0,2,1,2]],"d":[{},[1,2]],"e":[{".":[{},[0,2]],"i":[{},[1,2]],"k":[{},[1,2]],"m":[{},[1,2]],"r":[{},[0,0,0,2]],"s":[{},[1,2]]}],"é":[{"j":[{},[0,0,0,2,1,2]]}],"f":[{},[1,2]],"g":[{},[1,2]],"i":[{"z":[{},[0,0,0,2]]}],"í":[{},[1,2]],"j":[{},[1]],"k":[{"a":[{},[1]]}],"l":[{},[1,2]],"ó":[{},[0,0,0,2]],"ö":[{},[0,0,0,2,1]],"s":[{},[1,2]]}],"l":[{"a":[{},[0,0,1]],"g":[{},[0,0,1]],"h":[{},[0,0,1]],"j":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"p":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{"l":[{},[0,0,1]]}],"n":[{"e":[{},[0,2,1]]},[0,0,0,2]],"r":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1,2]],"e":[{"m":[{"e":[{},[0,0,0,2]]}]}],"ó":[{},[0,0,1]]}],"s":[{"z":[{},[0,2,1,2]]}],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1,2]],"e":[{"l":[{},[0,0,0,2,1,2]],"s":[{"t":[{},[0,0,0,2]]}]}],"o":[{},[0,0,0,2]]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"é":[{"j":[{"b":[{},[0,0,1]]}],"k":[{"b":[{},[0,0,1]],"é":[{},[0,0,1,2]],"i":[{},[0,0,1,2]],"ű":[{},[0,0,1,2]]}],"l":[{"e":[{},[0,2,1]],"ő":[{},[0,2,1]]},[0,0,0,2]],"m":[{"a":[{},[0,0,0,2,1]]}],"n":[{"e":[{"k":[{"e":[{},[0,0,1]]}]}]}],"r":[{".":[{},[0,2,1]],"c":[{},[0,2,1]],"é":[{},[0,2,1]]}],"t":[{"e":[{"r":[{},[0,0,0,2]]}]}],"z":[{},[2]]}],"f":[{"r":[{},[0,0,1,2]],"ü":[{"s":[{"t":[{"ö":[{"l":[{},[0,0,0,0,0,2,1]]},[0,0,0,0,0,0,0,2]]}]}]}]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"d":[{"o":[{},[0,0,1]]}],"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"d":[{},[0,0,1]],"f":[{},[0,0,1]],"h":[{},[0,0,1]],"t":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"s":[{"m":[{},[0,0,1]]}],"t":[{"a":[{},[0,2,1]]}],"v":[{"a":[{},[0,2,1]]}],"z":[{},[0,2,1,2]]}],"í":[{"j":[{},[0,0,1]],"n":[{},[0,0,1]],"v":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{"á":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"i":[{},[0,0,1]]}]}],"m":[{"ű":[{},[0,0,0,0,1]]}],"n":[{"y":[{"o":[{},[0,0,3]]}]}],"o":[{"l":[{},[0,2,1]],"m":[{"l":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]]}],"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}],"t":[{},[0,0,1]],"x":[{},[0,2,1]]}],"ó":[{"c":[{},[0,0,1]],"r":[{},[0,2,1,2]]}],"ö":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[2]],"z":[{},[0,2,1,2]]}],"ő":[{"s":[{},[0,0,1,2]]}],"p":[{"e":[{},[0,0,0,0,2]],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"a":[{"s":[{},[0,0,2]]}],"p":[{},[0,0,1,2]],"t":[{},[0,0,1,2,2]],"ú":[{},[0,0,2]]}],"t":[{"r":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"i":[{},[0,0,1,2]],"ó":[{},[0,0,1]]}]}],"u":[{"t":[{},[0,2,1,2]]}],"ú":[{"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1,2]],"l":[{"e":[{},[0,2,1]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"y":[{"a":[{},[0,2,0,1,2]],"á":[{},[0,2,0,1,2]],"e":[{"c":[{"e":[{},[0,2,0,1]],"s":[{"e":[{},[0,2]]}]},[0,0,0,0,2]],"d":[{"z":[{},[0,2,0,1,2]]}],"f":[{},[0,2]],"g":[{"y":[{},[0,2,0,1]]}],"k":[{"é":[{"s":[{},[0,2]]}]}],"l":[{"a":[{},[0,2]],"á":[{},[0,2]],"l":[{},[0,2,0,1]],"o":[{},[0,2,0,1]],"v":[{"á":[{},[0,2,0,1]],"ű":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]}]}],"m":[{"a":[{},[0,2]]}],"n":[{"c":[{},[0,0,0,1]]}],"p":[{},[0,2,0,1]],"r":[{"d":[{},[0,2]],"e":[{"d":[{},[0,0,0,1]]}],"ő":[{},[0,2,0,1,2]]}],"s":[{"e":[{"t":[{"t":[{},[0,2,0,1,2]]}]}],"é":[{"s":[{},[0,2,0,1,2]]}],"ő":[{},[0,2,0,1,2]],"s":[{"z":[{},[0,2,0,1]]}],"t":[{"é":[{},[0,2,0,1]]}],"z":[{},[0,2,0,1,2]]}],"t":[{"a":[{},[0,2]],"i":[{},[0,2]],"ű":[{},[0,2]]}],"v":[{},[0,2,0,1]]}],"é":[{"g":[{},[0,2,0,1]],"j":[{},[0,2,0,1,2]],"k":[{"e":[{},[0,0,0,1]],"h":[{},[0,0,0,1]],"n":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"l":[{},[0,2,0,1,2]],"r":[{".":[{},[0,2,0,1]],"d":[{},[0,2,0,1]],"é":[{},[0,2]],"i":[{},[0,2,0,1,2]],"n":[{},[0,2,0,1]],"t":[{"e":[{},[0,2]],"é":[{},[0,2,0,1]]}],"ü":[{},[0,2,0,1,2]],"v":[{},[0,2,0,1]],"z":[{},[0,2,0,1]]}],"s":[{},[0,2,0,1]],"t":[{"e":[{},[0,2,0,1,2]],"t":[{},[0,2,0,1]]}],"v":[{"a":[{},[0,2]]}]}],"i":[{"f":[{},[0,2,0,1]],"g":[{"é":[{},[0,2,0,1]]},[0,0,0,0,2]],"k":[{"o":[{},[0,2,0,1,2]]}],"n":[{"g":[{},[0,2,0,1]]}],"r":[{"a":[{},[0,2,0,1]],"o":[{},[0,2]]}],"s":[{"k":[{},[0,2]]}],"t":[{"a":[{},[0,2]]}],"z":[{},[0,2]]}],"í":[{"r":[{"á":[{},[0,0,0,1]],"ó":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"o":[{"k":[{},[0,2,0,1]],"l":[{},[0,2,0,1,2]],"r":[{},[0,2,0,1,2]],"s":[{},[0,2,0,1]]}],"ó":[{},[0,2,0,1,2]],"ö":[{"n":[{},[0,2]],"r":[{},[0,0,0,1]],"s":[{},[0,2,0,1]],"z":[{},[0,0,0,1]]},[0,0,0,0,2]],"ő":[{},[0,2,0,1,2]],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"r":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1]]},[0,2]],"ú":[{"j":[{},[0,2]],"t":[{},[0,0,0,1]]}],"ü":[{"l":[{"ő":[{},[0,2,0,1,2]]}],"s":[{},[0,2,0,1]],"v":[{},[0,2,0,1]],"z":[{},[0,2]]}]}],"z":[{"a":[{"d":[{},[0,0,2,1]],"g":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"u":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{"l":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"e":[{"r":[{},[0,0,2,1,2]]}],"i":[{"m":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{"r":[{},[0,0,2]]}],"ő":[{},[0,0,2,1]],"s":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]]}],"u":[{"r":[{},[0,0,2]]}],"ú":[{},[0,0,2]],"z":[{},[0,0,0,1]]}]}],"o":[{"l":[{"a":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}]},[0,1]],"ó":[{"r":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]]}]},[0,1]],"ö":[{},[0,1]],"ő":[{},[0,1]],"p":[{"a":[{"d":[{"o":[{},[0,0,1]]}],"j":[{},[0,2,1,2]],"l":[{"k":[{},[0,0,1]]}],"n":[{"y":[{},[0,0,0,2]]}],"p":[{"o":[{},[0,0,1]],"r":[{},[0,0,0,1]]}],"r":[{"c":[{},[0,0,1]],"é":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,1]]}],"t":[{"l":[{},[0,0,1]]}],"u":[{"s":[{},[0,0,0,0,2]],"t":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,1,2]]}]}],"á":[{"g":[{},[0,2,1,2]],"l":[{"l":[{"a":[{},[0,2,1]],"o":[{},[0,2,1]]}]}],"p":[{},[0,0,1]],"r":[{".":[{},[0,0,1]],"b":[{},[0,0,1]],"f":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1,2]],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1,2]]}],"t":[{"b":[{},[0,0,1]],"j":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"s":[{},[0,0,1]],"ü":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"b":[{},[0,2]],"g":[{"é":[{},[0,0,1,2]],"y":[{},[0,0,1,2]]}],"k":[{"é":[{"s":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]],"b":[{},[0,2,1]],"c":[{},[0,2,1]],"e":[{"m":[{"b":[{},[0,0,1,2]],"e":[{},[0,2,1,2]],"r":[{},[0,0,1,2]]}]}],"é":[{"r":[{},[0,2,1]]}],"f":[{},[0,2,1]],"i":[{"n":[{},[0,2,1,2]]}],"j":[{"á":[{},[0,0,1]]}],"k":[{},[0,2,1]],"l":[{"á":[{},[0,0,1]],"e":[{"n":[{},[0,2,1]]}]}],"m":[{},[0,2,1]],"o":[{},[0,2,1]],"ő":[{"k":[{"e":[{},[0,2,1,2]]}]}],"r":[{},[0,2,1]],"t":[{"é":[{"r":[{},[0,2,1]]}]}],"u":[{},[0,0,1]]},[2]],"n":[{"e":[{},[0,2,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{"ő":[{},[0,0,0,2]]},[0,2,1]],"s":[{"e":[{"m":[{},[0,2,1]],"r":[{},[0,2,1,2]],"t":[{"t":[{},[0,2,1,2]]}]}],"é":[{"s":[{},[0,2,1,2]]}],"ő":[{},[0,2,1,2]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"i":[{},[0,2,1]],"j":[{},[0,2,1]]}],"z":[{"e":[{},[0,2,1]],"k":[{},[0,2,1]]},[0,0,0,2]]}],"t":[{"a":[{},[0,2,1]],"e":[{"t":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,0,2]]}]}],"ű":[{},[0,2,1]]}],"v":[{"a":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]]}]}]}],"r":[{".":[{},[0,2,1]],"i":[{},[0,2,1]]}],"s":[{"a":[{},[0,0,0,2]]}],"t":[{"e":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"k":[{"o":[{},[0,2,1,2]]}],"m":[{"p":[{},[0,2,1]]}],"n":[{"d":[{},[0,0,1]],"g":[{},[0,0,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{"a":[{"i":[{},[0,0,1,2]]}]}],"r":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2]],"o":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"s":[{"k":[{},[0,0,1]],"m":[{},[0,2,1]],"t":[{},[0,2,1]]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{},[0,2,1]]}],"í":[{"n":[{},[0,0,1]],"r":[{},[0,2,1,2]],"t":[{"m":[{},[1]]}],"v":[{},[0,2,1]]}],"k":[{"á":[{"r":[{},[0,0,0,0,2]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"l":[{"e":[{"t":[{"ö":[{},[0,0,0,0,2,1]]}]}]}],"o":[{"b":[{},[0,0,1]],"k":[{},[0,2,1]],"l":[{"d":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{"m":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1]]}]}],"ó":[{"c":[{},[0,2,1]],"h":[{},[0,2,1,2]],"r":[{},[0,0,1,2]]}],"ö":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,0,2]],"s":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"p":[{"e":[{"k":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"l":[{},[0,0,1,2]],"o":[{"d":[{},[0,0,2,1]]}],"r":[{},[0,0,1,2]]}],"r":[{"o":[{"g":[{},[0,1]]}],"ó":[{"z":[{"á":[{},[0,0,2]]}]}]}],"s":[{"h":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,0,1,2]],"p":[{},[0,0,1]],"t":[{},[0,0,1,2]],"z":[{},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{"v":[{},[0,0,1]]}],"g":[{},[0,0,1]],"j":[{},[0,2,1]],"n":[{"o":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{},[0,0,0,2]],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{"d":[{},[0,2,1]],"e":[{},[1]]}],"r":[{},[0,2,1]],"s":[{},[0,0,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}]}],"r":[{"a":[{"b":[{"l":[{},[0,0,1]],"s":[{},[0,0,1]]}],"d":[{},[0,2,1,2]],"g":[{"á":[{},[0,0,1,2]],"g":[{},[0,0,1]],"y":[{},[0,0,1]]}],"j":[{"a":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"k":[{"a":[{},[0,2,1,2]],"c":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1,2]],"á":[{},[0,0,1]],"g":[{},[0,0,1]],"k":[{},[0,0,1]],"m":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,0,1]],"p":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"p":[{"á":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]],"p":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"c":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"s":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1,2]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"o":[{},[0,0,1,2]],"r":[{},[0,0,0,1,2]],"t":[{},[0,0,1]],"y":[{},[0,0,1]]}],"u":[{},[0,2,1,2]],"v":[{"a":[{},[0,0,1,2]]}],"x":[{},[0,2,1,2]],"z":[{"o":[{},[0,0,1,2]]}]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"g":[{".":[{},[0,0,1]],"a":[{},[0,2,1,2]],"b":[{},[0,0,1]],"g":[{},[0,0,1]],"y":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"p":[{},[0,0,1,2]],"r":[{"á":[{},[0,0,1]],"k":[{},[0,0,1]],"o":[{},[0,0,1,2]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"u":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,0,1,2,1,2]],"á":[{},[0,0,1,2,1,2]],"c":[{},[0,0,1]],"e":[{},[0,0,1,2,1,2]],"é":[{},[0,0,1]],"f":[{},[0,0,1]],"h":[{},[0,0,1]],"j":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"ö":[{},[0,0,1,2]],"r":[{},[0,0,1]],"ú":[{},[0,0,1]],"ü":[{},[0,0,1]],"v":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"b":[{"á":[{"n":[{},[1]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"a":[{"j":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]]}],"c":[{},[0,0,0,3]],"d":[{},[1]],"e":[{"d":[{"é":[{},[0,0,2]]}],"m":[{"b":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"h":[{},[0,0,2,3]],"i":[{"l":[{},[0,0,2]],"m":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"s":[{"e":[{"b":[{},[0,0,2,3]]}],"i":[{"s":[{},[0,0,2,3]]}]}],"ú":[{},[0,0,2]],"z":[{},[0,0,2]]}],"d":[{"a":[{"m":[{},[0,0,2,1]]}],"á":[{},[0,0,2,1,2]],"e":[{"k":[{"b":[{"ő":[{},[1]]}],"e":[{".":[{},[1]],"i":[{},[1]],"l":[{},[1]]}],"l":[{},[1]],"t":[{},[1]],"ü":[{},[1]],"ű":[{},[1]]}],"m":[{"é":[{},[1]]}],"r":[{"ő":[{},[0,0,2,1]]}],"s":[{"t":[{"e":[{},[0,0,0,1]]}]}]}],"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"i":[{"n":[{"á":[{},[0,0,2,1,2]]}],"z":[{},[0,0,2,1]]}],"r":[{"a":[{},[0,0,1]]}],"ü":[{"l":[{"é":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"z":[{},[0,0,2,3]]}],"e":[{"b":[{"a":[{},[0,0,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]],"r":[{},[0,2,1]]},[0,0,0,2]],"f":[{"f":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1]],"e":[{"d":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2,1,2]],"v":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2,1]]}],"g":[{},[0,0,0,0,1]],"i":[{"n":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]],"ö":[{},[0,0,0,2,1,2]],"y":[{"e":[{"z":[{},[0,0,0,0,0,0,0,1]]}]},[0,2,1,2]]}],"j":[{},[0,2,1]],"k":[{"é":[{"n":[{".":[{},[0,2,1,2]]}]}]}],"l":[{"á":[{},[0,2,1]],"e":[{"g":[{},[0,2,1,2]],"m":[{"z":[{},[0,2]]}]}],"é":[{"g":[{},[0,0,1,2]]}],"i":[{"s":[{},[0,2,1]]}],"k":[{},[0,2,1]],"o":[{},[0,2,1]],"ő":[{"a":[{},[0,2,1,2]],"i":[{"r":[{},[0,0,0,2]]}],"l":[{},[0,2,1,2]],"m":[{"e":[{},[0,2,1,2]]}],"n":[{},[0,2,1,2]]}],"r":[{},[0,0,1]],"t":[{"á":[{},[0,0,1]]}]}],"m":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2]],"b":[{"e":[{"r":[{},[0,2]]}]}],"e":[{"g":[{},[0,0,0,2,1]],"l":[{},[0,2,1]],"s":[{},[0,0,0,2]]}],"é":[{"s":[{},[0,2,1,2]]}],"i":[{"s":[{},[0,0,1,2]]}],"l":[{},[0,2]],"o":[{},[0,0,0,2,1]],"ó":[{},[0,0,0,2,1]],"u":[{},[0,2,0,2]]}],"n":[{"e":[{},[0,2,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{"ő":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,0,0,0,1,2]],"t":[{},[0,2,1]]},[0,0,0,2]],"t":[{"é":[{},[0,2,1]]}]}],"t":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2]],"e":[{"g":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2,1]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}],"v":[{"e":[{".":[{},[0,0,0,2,1,2]]}]}]}]}],"v":[{"e":[{},[0,0,1,2]],"é":[{},[0,2,1,2]]}]}],"é":[{"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"j":[{".":[{},[0,2,1]],"é":[{"t":[{},[0,2,1,2]]}]}],"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]]}]}]}],"p":[{},[0,2,1]],"r":[{"i":[{},[0,2,1,2]]}],"s":[{"e":[{"l":[{},[0,0,0,2,1]]}],"z":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]]}]}],"t":[{"e":[{"r":[{},[0,0,0,2]]}],"k":[{},[0,2,1]]}],"v":[{"e":[{".":[{},[0,0,1,2]]}],"n":[{},[0,2,1]],"v":[{},[0,0,1]]}]}],"f":[{"i":[{"á":[{},[0,0,0,0,0,2]]}],"l":[{},[0,0,1]],"o":[{"g":[{"ó":[{"n":[{".":[{},[0,0,0,0,2,1]]}],"s":[{},[0,0,0,0,2,1]]}]}],"t":[{"o":[{},[0,0,0,0,0,0,1]]}]}],"r":[{},[0,0,1,2]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"a":[{"l":[{},[0,0,0,2]]}],"c":[{"s":[{"i":[{},[0,0,0,2]]}]}],"d":[{"o":[{},[0,2,1]]}],"é":[{"n":[{},[0,0,0,0,2]]}],"f":[{"j":[{},[0,0,1]]}],"g":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,2,1,2]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2]],"i":[{},[0,2,1,2]]}],"n":[{"a":[{},[0,2,1,2]],"d":[{},[0,2,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2]],"v":[{},[0,0,1]],"z":[{},[0,2]]}],"o":[{},[0,2,1,2]],"p":[{"a":[{},[0,2,1,2]]}],"r":[{"a":[{},[0,0,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,0,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"t":[{"a":[{},[0,2,1,2]]}],"v":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]]}],"z":[{},[0,2,1,2]]}],"í":[{"g":[{},[0,0,1]],"j":[{},[0,0,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"j":[{"a":[{"n":[{},[0,0,2]]}]}],"k":[{"l":[{},[0,0,1,2]],"ö":[{"z":[{"e":[{"p":[{"é":[{},[0,0,0,0,2,1,2]]}]}]}]}],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"l":[{"e":[{"t":[{"ö":[{"l":[{},[0,0,0,0,2,1]]}]}]}]}],"m":[{"é":[{"é":[{},[1]],"j":[{},[1]],"k":[{},[1]]}],"i":[{".":[{},[1]]}]}],"o":[{"l":[{},[0,2,1,2]],"n":[{"t":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"t":[{"t":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}],"x":[{},[0,2,1,2]]}],"ó":[{"l":[{"o":[{},[0,0,1]]},[0,0,0,2]],"r":[{"i":[{},[0,0,1]]}]}],"ö":[{"b":[{},[0,2,1,2]],"c":[{},[0,2,1,2]],"k":[{"o":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"ő":[{"f":[{},[0,0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"s":[{"e":[{"k":[{},[1]]}],"k":[{},[0,0,1,2]],"l":[{},[0,0,1]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"z":[{"k":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"a":[{"t":[{},[0,0,2]]}],"e":[{"k":[{"e":[{"z":[{},[1]]}]}],"l":[{"a":[{},[0,0,2,1]],"m":[{},[1]]}],"s":[{"í":[{},[1]]}]}],"é":[{"k":[{"i":[{"l":[{},[1]]}],"m":[{},[1]]}],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"ö":[{"v":[{"e":[{},[0,0,0,1,2]]}]}],"ő":[{"c":[{},[1]],"g":[{},[1]],"ü":[{},[1]]}],"r":[{"a":[{"n":[{},[0,0,1,2]]}],"á":[{},[0,0,1]],"e":[{"n":[{},[0,0,1,2]]}],"é":[{},[0,0,1,2]],"o":[{},[1,0,1,2]],"ó":[{},[0,0,1]]}]}],"u":[{"g":[{"a":[{},[0,0,1]]}],"j":[{},[0,2,1]],"m":[{"e":[{},[0,0,0,2,1]]}],"n":[{"a":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{"é":[{"r":[{},[0,0,0,2,1]]}],"z":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"o":[{},[0,0,1,2]]}],"z":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"t":[{},[0,0,0,2]]}],"ü":[{"g":[{},[0,2,1,2]],"k":[{"é":[{".":[{},[0,0,0,2]]}]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1,2]]}],"v":[{"a":[{"d":[{"ó":[{},[0,0,0,1,2]]}],"l":[{"a":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1,2]]}],"á":[{"g":[{"y":[{},[0,0,2,1,2]]}]}],"e":[{"l":[{"e":[{"m":[{},[0,0,2,1]]}]},[1]]}],"é":[{"g":[{"b":[{},[0,0,2,1]],"h":[{},[0,0,2,1]]}],"k":[{},[0,0,2]],"l":[{},[0,0,2]]}],"u":[{},[0,0,2]]}],"z":[{"á":[{},[2]],"é":[{"k":[{".":[{},[1]],"b":[{},[1]],"é":[{},[1]],"h":[{},[1]],"k":[{},[1]],"n":[{},[1]],"r":[{},[1]],"t":[{},[1]],"ü":[{},[1]],"ű":[{},[1]]}],"s":[{"i":[{"l":[{},[1]]}]}]}]}]}],"s":[{"a":[{"b":[{"l":[{},[0,0,1]]}],"d":[{},[0,2,1,2]],"g":[{"y":[{},[0,0,1]]}],"j":[{"t":[{},[0,0,1]]}],"k":[{"a":[{},[0,0,1,2]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1]],"t":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1,2]],"g":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{"a":[{},[0,0,1]],"t":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"p":[{"a":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"á":[{},[0,0,1,2]],"c":[{},[0,0,1]],"é":[{},[0,0,1]],"m":[{},[0,0,1]],"z":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"s":[{},[0,0,1]]}],"u":[{},[0,2,1,2]]}],"á":[{"c":[{},[0,0,0,2]],"l":[{},[0,2,1]],"r":[{"t":[{},[0,0,1]]}],"s":[{},[0,0,0,2]],"t":[{"a":[{},[0,0,1]],"h":[{},[0,0,1]],"l":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"b":[{"é":[{},[0,2,1]]},[0,0,0,2]],"f":[{},[0,2,1]],"g":[{"e":[{},[0,0,1,2]],"y":[{},[0,0,1,2]]}],"k":[{"e":[{".":[{},[0,2,1,2]],"i":[{},[0,2,1,2]]}],"é":[{"s":[{},[0,2,1,2]]}],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"l":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"b":[{},[0,0,1]],"k":[{},[0,0,1]],"m":[{},[0,2,1]],"o":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{"é":[{},[0,2,1]]}],"z":[{},[0,0,1]]}],"m":[{"b":[{"e":[{"r":[{},[0,0,1]]}]}],"e":[{"l":[{},[0,2,1,2]]}],"l":[{},[0,2,1]]}],"n":[{"e":[{},[0,2,1]],"g":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{"ő":[{},[0,0,1]]}],"s":[{"z":[{},[0,2,1]]}],"t":[{"o":[{},[0,2,1]]}],"v":[{},[0,2,1]],"x":[{},[0,2,1]]}],"é":[{"g":[{"b":[{},[0,0,1]],"é":[{"b":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"h":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,2,1,2]]}],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"n":[{},[0,2,1]],"v":[{},[0,2,1]]}],"h":[{"e":[{"n":[{},[0,2,1,2]]}]}],"j":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"b":[{},[0,0,1]],"c":[{},[0,0,1]],"d":[{},[0,2,1]],"e":[{"m":[{},[0,2,1,2]],"n":[{},[0,2,1,2]]}],"é":[{},[0,2,1,2]],"h":[{},[0,2,1]],"l":[{},[0,2,1]],"n":[{},[0,2,1]],"ő":[{".":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"v":[{},[0,2,1,2]]}],"r":[{},[0,0,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"ü":[{},[0,2,1,2]],"v":[{},[0,2,1]]}],"s":[{"z":[{},[0,0,1]]}],"t":[{"e":[{},[0,2,1,2]]}],"v":[{"e":[{".":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"é":[{"b":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"c":[{},[0,2,1]],"d":[{"e":[{"t":[{},[0,3]]}]},[0,2,1]],"é":[{},[0,0,0,0,2]],"g":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]},[0,0,0,2]],"k":[{"t":[{},[0,2,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"i":[{},[0,2,1]],"p":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]],"f":[{},[0,0,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"r":[{"a":[{},[0,2,1]],"á":[{},[0,2,1,2]],"o":[{},[0,0,1]]}],"s":[{},[0,2,1,2]],"t":[{"a":[{},[0,2,1,2]]}],"v":[{"á":[{},[0,2,1,2]]}]}],"í":[{"r":[{},[0,2,1,2]],"v":[{},[0,2,1]]}],"k":[{"a":[{"t":[{"u":[{},[0,0,2]]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"l":[{"á":[{"g":[{},[0,1]]}]}],"o":[{"b":[{},[0,2,1]],"k":[{"o":[{},[0,0,1]],"t":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"m":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{"g":[{},[0,0,1]],"n":[{},[0,0,1]],"v":[{},[0,0,1]]},[2]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,0,1,2]]}],"ó":[{"c":[{},[0,0,1]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"ö":[{"l":[{},[0,2,1,2]],"n":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{"i":[{},[0,0,2]]},[0,0,1,2]],"s":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"z":[{"a":[{"b":[{},[0,0,3]],"g":[{},[0,0,3]],"k":[{},[0,0,3]],"p":[{},[0,0,3]]}],"á":[{},[0,0,3]],"e":[{"l":[{".":[{},[0,0,4]]}],"r":[{"e":[{},[0,0,3]]}]}],"é":[{"l":[{"e":[{},[0,0,3]]}]}],"f":[{},[0,0,3]],"i":[{},[0,0,3]],"í":[{},[0,0,3]],"o":[{},[0,0,3]],"ó":[{},[0,0,3]],"ö":[{},[0,0,3]],"ő":[{},[0,0,3]],"t":[{},[0,0,3]],"ú":[{},[0,0,3]],"ü":[{"l":[{},[0,0,3]]}],"ű":[{},[0,0,3]]},[0,0,0,0,2]]}],"t":[{"r":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"é":[{},[0,0,1]],"u":[{},[0,1]]},[0,0,0,2]]}],"u":[{"d":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"t":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,2,1]],"n":[{"n":[{},[0,2,1]]}],"r":[{},[0,2,1]],"t":[{"é":[{},[0,0,1,2]]}],"z":[{},[0,2,1]]}],"z":[{"a":[{"b":[{"l":[{},[0,0,0,1]]}],"d":[{},[0,2,0,1,2]],"g":[{"y":[{},[0,0,0,1]]}],"j":[{},[0,2]],"k":[{"á":[{"z":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]],"c":[{},[0,2]],"ü":[{},[0,0,0,0,2,1]]}],"l":[{"e":[{},[0,0,0,1]],"g":[{},[0,0,0,1]],"l":[{},[0,0,0,1]]}],"n":[{"t":[{},[0,0,0,1]],"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"p":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,2,0,1,2]],"s":[{},[0,2,0,1]],"t":[{"o":[{},[0,0,0,1,2]]}],"u":[{},[0,2,0,1]],"z":[{},[0,2]]}],"á":[{"b":[{},[0,2]],"g":[{},[0,2,0,1,2]],"l":[{"l":[{"á":[{},[0,0,0,1]]}]},[0,0,0,0,2]],"p":[{},[0,0,3]],"r":[{"a":[{"m":[{},[0,0,0,1]]}],"á":[{"n":[{},[0,0,0,1]]},[0,2]],"f":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"n":[{},[0,2,0,1]],"u":[{},[0,0,0,1,2]]}],"s":[{},[0,2]],"t":[{},[0,2,0,1,2]],"z":[{},[0,0,0,1,2]]},[2]],"e":[{"g":[{"e":[{".":[{},[0,2,0,1,2]],"i":[{},[0,2,0,1,2]]}],"y":[{},[0,2,0,1,2]]}],"j":[{},[0,2,0,1]],"k":[{"a":[{},[0,0,0,0,2,1,2]],"á":[{},[0,0,0,0,2]],"é":[{"s":[{},[0,0,0,1]]}],"ö":[{"v":[{},[0,0,0,0,2]]},[0,0,0,0,0,0,2]]}],"l":[{"a":[{},[0,2,0,1]],"e":[{"g":[{},[0,2,0,1,2]],"m":[{"b":[{},[0,0,0,1,2]],"e":[{},[0,0,0,1,2]],"é":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}]}],"k":[{},[0,2,0,1]],"ő":[{"d":[{},[0,0,0,1]],"r":[{},[0,2,0,1]],"z":[{},[0,2]]}]}],"m":[{"b":[{"e":[{"r":[{},[0,0,0,1]]}]}],"i":[{},[0,2,0,1]]}],"n":[{"é":[{},[0,2,3]],"g":[{},[0,2,0,1]]}],"p":[{},[0,2,0,1]],"r":[{"e":[{"z":[{},[0,0,0,1,2]]}],"é":[{"n":[{},[0,0,0,1,2]]}],"k":[{"ö":[{},[0,0,0,1]]}],"ő":[{},[0,2]]}],"s":[{"e":[{"t":[{"e":[{},[0,0,0,1,2]]}]}],"z":[{"t":[{},[0,0,0,1]]}]}],"t":[{"a":[{"k":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]],"e":[{"l":[{},[0,0,0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,0,0,2,1]]}]}],"o":[{},[0,0,0,0,2,1]],"ö":[{"r":[{},[0,0,0,0,2,1]]}]}],"v":[{"e":[{},[0,0,0,1,2]]}],"x":[{},[0,2,0,1]]}],"é":[{"g":[{},[0,2]],"k":[{"t":[{},[0,2,0,1]]}],"l":[{},[0,2,0,1,2]],"p":[{},[0,2,0,1,2]],"r":[{"é":[{},[0,0,0,1]],"ó":[{},[0,2]]}],"s":[{"z":[{},[0,2]]}],"t":[{"e":[{},[0,2,0,1,2]],"k":[{},[0,2,0,1]]}]}],"i":[{"d":[{},[0,2,0,1,2]],"f":[{},[0,2]],"k":[{"o":[{},[0,0,0,1,2]],"t":[{},[0,2,0,1]]}],"l":[{"l":[{},[0,2,0,1]]}],"m":[{},[0,2,0,1]],"n":[{"a":[{},[0,2]],"d":[{},[0,2,0,1]],"f":[{},[0,2,0,1]],"g":[{},[0,0,0,1]],"t":[{"é":[{},[0,2,0,1]]}]}],"o":[{},[0,0,0,1]],"p":[{},[0,2,0,1,2]],"r":[{"a":[{},[0,2]],"o":[{},[0,2]],"t":[{},[0,2]]}],"s":[{},[0,2,0,1,2]],"t":[{"a":[{},[0,2,0,1]]}],"z":[{},[0,2,0,1]]}],"í":[{"j":[{},[0,0,0,1,2]],"r":[{},[0,2]],"v":[{"á":[{},[0,0,0,1,2]],"é":[{},[0,0,0,1,2]],"ó":[{},[0,0,0,1,2]]}]}],"k":[{},[0,0,0,1,2]],"o":[{"k":[{"t":[{},[0,0,0,1]]}],"l":[{"d":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"p":[{},[0,2]],"r":[{"s":[{},[0,0,0,1]]}],"s":[{},[0,2,0,1]],"t":[{},[0,2,0,1]]}],"ó":[{"n":[{},[0,2,3]]}],"ö":[{"l":[{"d":[{},[0,0,3]],"t":[{},[0,0,0,1]]}],"n":[{},[0,2,0,1]],"s":[{},[0,2,0,1]],"t":[{},[0,2]]},[2]],"ő":[{"r":[{"s":[{},[0,0,0,1]]}]}],"p":[{},[0,0,0,1,2]],"s":[{"u":[{},[0,0,0,3]],"ű":[{},[0,0,0,3]]}],"t":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}],"o":[{"r":[{"s":[{},[0,0,0,2]],"z":[{},[0,0,0,0,0,0,0,1]]}]}],"r":[{"a":[{},[0,0,0,1]],"i":[{},[0,0,0,1]]}]}],"u":[{"l":[{},[0,0,3]],"t":[{},[0,0,0,1]]}],"ú":[{"r":[{"n":[{},[0,0,0,1]]}],"t":[{},[0,2,0,1]]}],"ü":[{"g":[{},[0,2,0,1,2]],"n":[{"n":[{},[0,2]]}],"t":[{},[0,2]],"z":[{},[0,2,0,1,2]]}],"ű":[{"z":[{},[0,2]]}],"z":[{},[0,0,0,1]]}]}],"t":[{"a":[{"b":[{"l":[{"a":[{},[0,0,1]]}]}],"d":[{"o":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"g":[{"g":[{},[0,0,1]],"r":[{},[0,0,0,1]]}],"i":[{"k":[{},[0,0,0,0,2]]}],"j":[{"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"k":[{"c":[{},[0,0,1]],"r":[{},[0,0,0,1]],"t":[{},[0,0,1]]}],"l":[{"j":[{},[0,2,1]],"k":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}],"n":[{"i":[{},[0,2,1]],"n":[{},[0,2,1]],"t":[{},[0,2,1]],"y":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]]}]}],"p":[{"s":[{},[0,2,1]]}],"r":[{"c":[{},[0,2,1]],"g":[{},[0,2,1]]}],"s":[{"z":[{"t":[{},[0,0,1]]}]}],"t":[{"o":[{"m":[{},[0,0,1]]}]},[0,0,0,0,2]],"ü":[{},[0,0,0,0,2]],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"g":[{},[0,2,1,2]],"l":[{"l":[{},[0,2,1]]}],"r":[{"a":[{"d":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"á":[{},[0,0,1,2]],"i":[{},[0,2,1,2]],"ú":[{},[0,2,1,2]],"v":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]],"r":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"a":[{},[0,0,0,0,2]],"d":[{"é":[{"n":[{},[0,2]]}]}],"g":[{"a":[{},[0,0,0,2,1,2]],"e":[{"l":[{"e":[{},[0,0,0,2]],"v":[{},[0,0,0,2,1]]}],"r":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]]}],"k":[{"e":[{".":[{},[0,2,1,2]],"i":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2,1,2]],"m":[{"ü":[{},[0,0,0,2]]}],"r":[{},[0,0,0,2,1]]}],"é":[{"k":[{},[0,0,0,2,1]],"r":[{".":[{},[0,0,0,2,1]],"e":[{"n":[{},[0,0,0,2,1,2]]}],"é":[{},[0,0,0,2]]}]}],"f":[{"o":[{"g":[{},[0,2]]}]}],"l":[{"e":[{"n":[{},[0,2]]}]}],"o":[{},[0,0,0,2]],"ő":[{"l":[{},[0,2,1,2]],"r":[{},[0,0,0,2,1,2]]}]}],"m":[{"e":[{"l":[{},[0,2,1,2]]}]}],"r":[{"a":[{"d":[{},[0,0,0,2]],"g":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1,2]],"e":[{"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"m":[{"o":[{},[0,0,0,0,0,0,1]]}],"ő":[{},[0,2,1]]}],"s":[{"i":[{"k":[{},[0,0,0,2]]}],"t":[{"ü":[{"n":[{},[0,2,1]]}]}],"v":[{},[0,2,1]],"z":[{"m":[{},[0,2,1]]}]}],"v":[{"i":[{},[0,0,1,2]]}]}],"é":[{"g":[{".":[{},[0,0,1]],"e":[{},[0,0,1]],"é":[{},[0,0,1]],"n":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,2]],"j":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"r":[{"e":[{"n":[{},[0,2,1,2]]}],"é":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"ő":[{"t":[{},[0,2,1,2]]}],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}],"ü":[{},[0,2,1,2]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"z":[{"l":[{},[0,0,1]]}]}],"t":[{"b":[{},[0,2,1]],"é":[{},[0,2,1,2]],"n":[{},[0,2,1]],"r":[{},[0,2,1]]}],"v":[{"e":[{"s":[{},[0,2,1,2]]}]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,2,1,2]]}],"m":[{},[0,2,1,2]],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{"a":[{},[0,2,1]]},[0,0,0,2]],"r":[{"á":[{},[0,2,1]],"o":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2]]}],"v":[{"á":[{},[0,2,1,2]]}],"z":[{"é":[{},[0,0,1]]}]}],"í":[{"r":[{},[0,2,1,2]],"v":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"ű":[{},[1]],"v":[{},[0,0,1]]}],"m":[{"e":[{"g":[{"g":[{},[0,0,0,0,0,1]]}]}]}],"o":[{"k":[{"á":[{},[0,0,1,2]],"i":[{},[0,0,1,2]],"m":[{},[0,0,1]]}],"l":[{"a":[{},[0,2]],"v":[{},[0,2]]},[0,0,1,2]],"m":[{"l":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"d":[{},[0,0,1]],"g":[{},[0,0,1]],"i":[{"s":[{},[0,0,0,2]]}],"m":[{},[0,0,1]],"s":[{},[0,0,1]]}]}],"ó":[{"c":[{},[0,2,1]],"h":[{"a":[{},[0,0,1,2]]}],"n":[{".":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1]]}]}],"ö":[{"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"m":[{"ö":[{},[0,2,1]]}],"n":[{},[0,2,1]],"r":[{"ü":[{"l":[{},[0,0,0,2]]}]}],"s":[{},[0,2,1]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{".":[{},[0,0,1]],"b":[{},[0,0,1]],"i":[{},[0,0,1]],"m":[{},[0,0,1]],"ö":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"s":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"p":[{"e":[{"n":[{},[0,0,0,0,0,1]]}],"f":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"f":[{"á":[{},[0,1,2]]}]}],"é":[{"f":[{},[0,0,2]]}],"o":[{"m":[{"é":[{},[0,0,0,0,2,1,2]]}]}]}],"s":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{"v":[{},[0,0,1]]}],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{"a":[{},[0,0,1]],"d":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"s":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"ű":[{"z":[{},[0,0,0,2]]}],"y":[{"e":[{},[0,2,3]]}]}],"u":[{"n":[{"i":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"z":[{"s":[{},[0,0,2]]}]},[0,1]],"ú":[{},[0,1]],"ü":[{"g":[{"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"r":[{"ü":[{},[0,0,2]]}],"t":[{"é":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[0,1]],"ű":[{},[0,1]],"v":[{"a":[{"d":[{".":[{},[1]],"ó":[{},[0,0,1]],"r":[{},[1]]},[0,2]],"g":[{"y":[{},[0,0,1]]}],"j":[{"á":[{},[0,0,1]]}],"l":[{"a":[{},[0,2,1,2]],"á":[{},[0,2]],"k":[{},[0,2,1]]}],"m":[{},[0,2,1]],"n":[{},[0,2,1,2]],"r":[{"c":[{},[0,0,1]]}],"u":[{},[0,0,1]],"v":[{"a":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"á":[{"l":[{"l":[{"o":[{},[0,2,1]]}]}],"t":[{"a":[{},[0,2,1]],"h":[{},[0,0,1]],"k":[{},[0,0,1]],"r":[{},[0,2,1]]}],"z":[{"á":[{},[0,0,1]]},[0,0,0,2]]}],"b":[{"e":[{"o":[{},[1]]}]}],"e":[{"g":[{},[0,2,1,2]],"i":[{},[1,2]],"k":[{"t":[{},[1,2]]}],"l":[{"a":[{},[0,0,1]],"f":[{},[1]],"i":[{},[1,2,1]],"l":[{},[0,2,1]],"n":[{},[0,0,1]],"o":[{},[0,2,1]],"ő":[{},[0,2]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"n":[{"g":[{},[0,2,1]],"k":[{},[1,2]],"t":[{},[1,2]]}],"r":[{"i":[{},[0,0,1,2]],"ő":[{},[0,2,1,2]]}],"s":[{"b":[{},[1,2]],"é":[{"s":[{},[0,0,1,2]]},[1]],"f":[{},[1]],"i":[{},[1,2]],"k":[{},[1,2]],"r":[{},[1,2]],"t":[{"é":[{},[0,0,1]]}]}],"v":[{"e":[{},[0,0,1]]}]}],"é":[{"g":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"r":[{".":[{},[0,0,1]],"é":[{},[0,0,1,2]],"i":[{".":[{},[0,0,0,2]]}],"r":[{},[0,0,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}]}],"s":[{"k":[{"a":[{},[0,0,0,1]]}],"p":[{},[0,0,0,1,2]],"t":[{"á":[{},[0,0,0,1]]}]}]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"g":[{"a":[{},[0,0,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"h":[{},[1,2]],"k":[{},[1,2]],"m":[{},[1,2]],"n":[{"d":[{},[0,0,1]],"e":[{},[1]],"é":[{},[1]],"g":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,2]],"s":[{"m":[{},[0,0,1]]}],"t":[{"ő":[{},[1,2]]}],"v":[{},[1,2]]}],"í":[{"r":[{},[0,2,1]]}],"k":[{"ö":[{"s":[{},[1]]}],"r":[{},[0,0,1]]}],"n":[{"y":[{},[1]]}],"o":[{"k":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ó":[{"r":[{},[0,0,1,2]]}],"ö":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ő":[{"d":[{},[1,2]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{"a":[{"k":[{"a":[{"s":[{},[0,0,0,0,0,2,1]]}]}]}]},[0,0,1]]}],"t":[{"á":[{"r":[{"a":[{"d":[{},[0,0,0,0,2,1,2]]}]}]}],"ő":[{".":[{},[1]]}]}],"u":[{"r":[{},[0,0,1]]}],"ú":[{"j":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"k":[{".":[{},[0,2]],"b":[{},[0,2]],"e":[{},[0,2]],"h":[{},[0,2]],"i":[{},[0,2]],"n":[{},[0,2]],"t":[{},[0,2]]}],"l":[{"j":[{},[0,2]]}],"t":[{},[0,2,1]],"z":[{},[0,2,1]]}],"z":[{"á":[{},[1]]}]}],"z":[{"a":[{"d":[{},[0,0,1,2]],"g":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]]}],"j":[{},[0,0,1,2]],"k":[{"r":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"n":[{"y":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,2,1,2]],"z":[{},[0,0,1]]}],"á":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"s":[{"v":[{},[0,0,1]]}],"z":[{},[0,0,1]]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"c":[{"e":[{},[0,0,1]]},[0,0,0,2]],"d":[{"é":[{},[0,2,1,2]]}],"g":[{"é":[{},[0,0,1,2]],"y":[{},[0,0,1,2]]}],"l":[{"a":[{},[0,2,1]],"d":[{},[0,2,1]],"e":[{"n":[{},[0,0,0,0,1]]},[0,2,1,2]],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"l":[{},[0,2,1]],"ő":[{"b":[{},[0,0,1]],"é":[{},[0,0,1]],"g":[{},[0,0,1]],"i":[{},[0,0,1]],"j":[{},[0,0,1]],"k":[{"é":[{},[0,2,1,2]]}],"n":[{},[0,0,1]],"p":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"m":[{"b":[{},[0,2,1]]}],"n":[{".":[{},[0,0,2]],"á":[{},[0,0,0,2,1]],"z":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"r":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2,1]],"p":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]],"ő":[{},[0,0,1]],"ű":[{},[0,0,1,2]]}],"s":[{"z":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2,1]],"e":[{"g":[{},[0,0,0,2,1]],"k":[{"é":[{"h":[{},[0,0,0,2,1,2]]}]}],"l":[{},[0,0,0,2,1]]}]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"é":[{"d":[{},[0,2,1,2]],"g":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"c":[{},[0,2,1]],"i":[{},[0,2,1,2]],"m":[{},[0,2,1]],"p":[{},[0,2,1]],"t":[{"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"é":[{},[0,0,0,0,2]],"r":[{},[0,0,1,2]]}],"i":[{"d":[{"o":[{},[0,0,1]]},[0,0,0,2]],"g":[{"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"p":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]],"g":[{},[0,0,1]],"t":[{},[0,2,1]]}],"o":[{"n":[{},[0,0,1]]},[0,0,0,2]],"p":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1]]}],"r":[{"e":[{},[0,3]],"ő":[{},[0,3]]},[0,2,1,2]],"s":[{"s":[{},[0,0,0,0,3]],"ú":[{},[0,0,0,2,1]],"z":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2,3]]}]}],"t":[{"a":[{},[0,0,1,2]]}],"v":[{"á":[{},[0,2,1,2]]}],"z":[{"m":[{},[0,0,1]],"o":[{},[0,0,1]],"z":[{},[0,2,1]]}]}],"í":[{"j":[{},[0,0,1,2]],"r":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"k":[{"a":[{"r":[{"c":[{"h":[{},[0,0,0,0,0,2,3]]}]}]}],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"o":[{"l":[{"a":[{},[0,0,1]],"d":[{},[0,0,1]]}],"p":[{},[0,0,1]],"r":[{},[0,2,1]],"s":[{"z":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"ö":[{"b":[{},[0,0,1]],"k":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1,2]]}],"ő":[{"a":[{},[0,0,0,0,2]],"r":[{".":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"s":[{"a":[{"j":[{},[0,0,3]],"r":[{},[0,0,3]]}],"e":[{"b":[{},[0,0,3]],"r":[{},[0,0,3]]}],"i":[{"k":[{},[0,0,3]]}],"í":[{"n":[{},[0,0,3]]}],"o":[{"d":[{},[0,0,3]]}],"ó":[{"k":[{},[0,2,3]],"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ö":[{},[0,0,3]],"p":[{"i":[{},[0,0,3]]}],"s":[{},[0,0,0,1]],"u":[{"g":[{},[0,0,3]]}],"ú":[{"r":[{},[0,0,0,1,2]]}],"ü":[{},[0,2,3]],"z":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"g":[{},[0,0,1]],"j":[{},[0,0,1]],"r":[{},[0,2,1,2]],"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ű":[{"r":[{},[0,0,1]]}],"z":[{"s":[{"a":[{},[0,0,3]]}]}]}]}],"f":[{".":[{},[2]],"a":[{"á":[{"t":[{},[0,0,0,0,1]]}],"b":[{"r":[{"o":[{},[0,0,1,2]]}]}],"c":[{"h":[{"i":[{".":[{},[0,0,0,3]]},[0,0,2]],"o":[{},[0,0,2,3]]}]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"g":[{"y":[{"e":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"l":[{"e":[{"k":[{},[0,0,0,3]]}]}],"r":[{},[0,0,0,2]]}],"é":[{"d":[{},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"r":[{},[0,0,1,2]],"y":[{"é":[{"k":[{},[0,0,2]]},[0,0,0,0,0,2]],"o":[{"l":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"ú":[{"r":[{},[0,0,2]]}]}]}],"i":[{"d":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"j":[{"a":[{"l":[{},[0,0,2,1,2]],"z":[{},[0,0,2,1]]}],"á":[{"g":[{},[0,0,2,1]],"r":[{"u":[{},[0,0,2,1,2]]}]}],"e":[{"g":[{"y":[{"s":[{},[0,0,2,1]]}]}],"l":[{"e":[{"m":[{},[0,0,2]]}],"k":[{},[0,0,2,1]],"m":[{},[0,0,2]],"n":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"s":[{},[0,0,2,1]]}],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"r":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ü":[{},[0,0,2]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"l":[{"a":[{"d":[{"á":[{},[0,0,2,1,2]],"ó":[{},[0,0,2,1,2]]}],"j":[{"á":[{},[0,0,2]]}],"k":[{"ó":[{},[0,0,2,1,2]]}],"l":[{},[0,0,2,1,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"v":[{},[0,0,2]],"z":[{"ú":[{},[0,0,2,1]]}]}],"á":[{"b":[{"r":[{},[0,0,2,1]]}],"l":[{},[0,0,2,1]],"r":[{"o":[{},[0,0,2,1,2]]}],"t":[{"h":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}]}],"e":[{"g":[{"y":[{},[0,0,0,1,2]]}],"l":[{"e":[{"m":[{},[0,0,2,1]]}],"ő":[{},[0,0,2,1]]}],"s":[{"e":[{},[0,0,0,1]]}]}],"é":[{"r":[{"i":[{},[0,0,2,1]]}]}],"f":[{},[0,0,0,1,2]],"i":[{"d":[{},[0,0,2]],"n":[{"j":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"í":[{},[0,0,2,1,2]],"o":[{"l":[{},[0,0,2,1]],"m":[{"l":[{},[0,0,2,1]]}],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"ó":[{"r":[{"á":[{},[0,0,0,1]]}]}],"ö":[{"k":[{},[0,0,2]],"v":[{},[0,0,2,1]]},[0,0,0,0,2]],"ő":[{"r":[{},[0,0,2,1]]}],"p":[{},[0,0,0,1,2]],"s":[{"í":[{"n":[{".":[{},[0,0,0,2,1]]}]}]}],"t":[{"a":[{"n":[{},[0,0,0,0,0,2]]}],"e":[{"m":[{},[0,0,0,2]]}],"i":[{"p":[{},[0,0,0,2]]}],"ü":[{"z":[{},[0,0,0,2]]}]}],"ü":[{},[0,0,2]]}],"n":[{"e":[{"v":[{"e":[{"t":[{},[0,0,2,1,2]]}]}]}],"é":[{"v":[{"b":[{},[0,0,0,1]],"r":[{},[0,0,0,1]]}]}],"y":[{"a":[{".":[{},[2,1,2]]}]}]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"a":[{"d":[{"á":[{},[0,0,2,1,2]]}],"g":[{"y":[{},[0,0,2]]}],"k":[{"ó":[{},[0,0,2,1,2]]}],"l":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1]],"v":[{},[0,0,2,1,2]]}],"á":[{"c":[{"c":[{},[0,0,2,1]]}],"l":[{},[0,0,2,1]],"z":[{},[0,0,2,1,2]]}],"e":[{"m":[{},[0,0,2,1]],"p":[{"e":[{},[0,0,2,1,2]]}]}],"i":[{"d":[{},[0,0,2,1]],"n":[{"á":[{},[0,0,2,1]],"g":[{},[0,0,2,1]]}],"z":[{"m":[{},[0,0,2,1]],"o":[{},[0,0,2,1]]}]}],"k":[{"a":[{"l":[{},[0,0,0,2,1]]}],"o":[{"l":[{},[0,0,0,2]]}]}],"m":[{"á":[{"l":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"u":[{"n":[{"k":[{"á":[{},[0,0,0,2,1]]}]}]}]}],"o":[{"k":[{"k":[{"e":[{},[0,0,2,1]]}]}],"s":[{"z":[{},[0,0,2,1]]}]}],"u":[{"t":[{},[0,0,2,1]]}]}],"s":[{"k":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"t":[{"a":[{},[0,0,1]],"é":[{},[0,0,1]]}],"z":[{"í":[{"v":[{".":[{},[0,0,2,0,1]]}]}]}]}],"t":[{"r":[{"i":[{},[0,0,1]]}]}],"u":[{"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"t":[{"á":[{},[0,0,0,2]]}]}],"ü":[{"t":[{},[0,0,0,2]],"z":[{},[0,0,0,2]]}],"x":[{"e":[{},[0,0,2]],"i":[{"k":[{},[0,0,2,1]],"n":[{},[0,0,2]]},[0,0,0,0,2]],"í":[{},[0,0,2]],"ö":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"y":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]]}]},[1]],"á":[{"b":[{"r":[{},[0,1]]}],"c":[{"h":[{},[0,0,2,3]]}],"g":[{"é":[{"p":[{},[0,0,2]]}]}],"j":[{"l":[{"a":[{"k":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2,1,2]],"í":[{},[0,0,0,2,1,2]]}]}],"n":[{"í":[{},[0,0,2]],"k":[{"a":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2]]}],"t":[{"a":[{"d":[{},[0,0,0,2]],"g":[{},[0,0,0,2,1,2]],"n":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2,1,2]],"e":[{},[0,0,0,2,1,2]],"i":[{"s":[{},[0,0,0,2]]}],"o":[{"r":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2]]}]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{"m":[{},[0,0,2]]}],"á":[{},[0,1,2]]}],"s":[{"s":[{},[0,0,0,3]]}],"t":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"e":[{},[0,0,2]],"é":[{"r":[{"d":[{},[0,0,2,1]]}]}],"i":[{"s":[{},[0,0,2,1,2]]}],"m":[{"ű":[{},[0,0,0,0,0,1]]}],"o":[{"l":[{},[0,0,2,1]]}],"ü":[{},[0,0,2,1,2]]}],"z":[{"i":[{"s":[{"á":[{"g":[{},[0,0,0,0,2,1]]}],"z":[{},[0,0,0,0,2,3]]}]}]}]},[1]],"b":[{"a":[{"l":[{},[0,0,0,2,1]]}]}],"c":[{"l":[{"u":[{},[0,0,2]]}]}],"d":[{"r":[{"ó":[{},[0,0,2]]}]}],"e":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{},[0,0,2]],"c":[{},[0,0,2]],"d":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{},[0,0,2]],"h":[{},[0,0,2]],"i":[{},[0,0,2]],"j":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]],"ú":[{},[0,0,2]],"v":[{},[0,0,2]]}],"d":[{"z":[{},[2,1,2]]}],"e":[{"d":[{},[0,0,2]],"l":[{},[0,0,2]]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"y":[{"i":[{},[0,0,2,0,1]],"ő":[{},[0,0,2]]}]}],"i":[{"n":[{"i":[{},[0,0,0,2,1]]}]}],"j":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{"y":[{},[0,0,2,1]]}],"l":[{"m":[{},[0,0,2,1]]}],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1,2]]}],"o":[{},[0,0,2,1]],"ö":[{"s":[{},[0,0,2,1]]}],"t":[{"r":[{},[0,0,0,1]]}],"u":[{},[0,0,2,1]],"ú":[{},[0,0,2]]}],"k":[{"t":[{"e":[{"m":[{"b":[{},[0,0,0,2,1]]}]}]}]}],"l":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"c":[{},[0,0,0,0,2]],"d":[{"z":[{},[0,0,2,1,2]]}],"g":[{},[0,0,2,1,2]],"h":[{},[0,0,2,1,2]],"l":[{"e":[{"v":[{},[0,0,2,1]]}]}],"m":[{"e":[{"l":[{},[0,0,2,1,2]],"n":[{},[0,0,3]],"t":[{},[0,0,3]]}],"é":[{"s":[{},[0,0,2,1,2]]}],"l":[{},[0,0,2,1]]}],"n":[{"g":[{},[0,0,2,1]],"n":[{},[0,0,2,1]]}],"r":[{"e":[{},[0,0,2,1,2]]}],"s":[{"d":[{},[0,0,2,1]],"e":[{"d":[{},[0,0,2]],"g":[{},[0,0,0,1]],"t":[{"t":[{},[0,0,2,1,2]]}]}],"é":[{"s":[{},[0,0,2,1]]}],"i":[{"k":[{},[0,0,2,1]]}],"k":[{},[0,0,2,1]],"n":[{"i":[{},[0,0,2,1]]}],"ő":[{},[0,0,2,1,2]],"s":[{"e":[{"n":[{},[0,0,2,1]]}]}],"t":[{"e":[{},[0,0,2,1]],"ü":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1,2]]}],"t":[{"e":[{"s":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"t":[{"e":[{"k":[{},[0,0,2,1]]}],"é":[{"l":[{},[0,0,2,1]]}]}]}],"v":[{"e":[{},[0,0,0,1,2]],"é":[{},[0,0,0,1,2]],"i":[{},[0,0,0,1]]}]}],"é":[{"d":[{"e":[{},[0,0,2,1]]},[0,0,0,0,2]],"g":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1,2]],"r":[{".":[{},[0,0,2,1]],"e":[{"k":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1]]}],"h":[{},[0,0,2,1]],"i":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"t":[{"e":[{"t":[{},[0,0,2,1]]}]}]}],"i":[{"b":[{},[0,0,3]]},[0,0,2,1,2]],"í":[{},[0,0,2,1,2]],"l":[{},[0,0,0,3]],"o":[{},[0,0,2,1,2]],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1,2]],"ő":[{"g":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"p":[{},[0,0,0,1,2]],"t":[{},[0,0,0,0,2]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]]}],"n":[{"e":[{"r":[{},[2,1,2]]}],"n":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2]],"e":[{"v":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"s":[{"c":[{},[0,0,0,1]]}]}],"r":[{"a":[{"b":[{"l":[{},[0,0,0,1]]}],"k":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}],"r":[{},[0,0,2,1,2]]}],"e":[{"g":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"o":[{"l":[{"d":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}]}],"s":[{"e":[{"m":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"é":[{},[2,1,2]]}],"u":[{"m":[{"é":[{},[0,0,0,2,1,2]]}]}],"v":[{"ő":[{},[0,0,2]]}],"z":[{"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2]],"s":[{},[0,0,2]]}]},[1]],"é":[{"k":[{"a":[{"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"s":[{},[0,0,2]],"u":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"l":[{},[0,0,0,1]]}],"r":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"r":[{".":[{},[0,0,2,1]]}]}],"o":[{"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]]}],"ö":[{"n":[{},[0,0,2]]}],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2,1]]}],"l":[{"a":[{},[0,0,2,1,2]],"á":[{"j":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]]}],"e":[{"g":[{},[0,0,2]],"k":[{"k":[{},[0,0,2,1]]}],"l":[{"é":[{},[0,0,0,1]],"l":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]]}],"m":[{"b":[{},[0,0,0,1]],"e":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{"e":[{},[0,0,2,1]],"z":[{},[0,0,2,1]]}],"t":[{},[2,1,2]],"z":[{},[0,0,2,1]]}],"é":[{"v":[{"a":[{},[0,0,2,1]]}]}],"i":[{"g":[{"a":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"v":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"k":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"ő":[{"r":[{},[0,0,2]]}],"p":[{"e":[{"n":[{},[0,0,0,0,0,0,1]]}]}],"t":[{"r":[{},[0,0,0,1,2]]}],"ú":[{},[0,0,2,1,2]]}],"m":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2]],"g":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1]],"u":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"c":[{},[0,0,2,1]],"l":[{},[0,0,2,1]]}],"e":[{"c":[{},[0,0,2,1]],"d":[{"é":[{},[0,0,2]]}],"k":[{"é":[{"t":[{".":[{},[0,0,2,0,2]]}]}]}],"l":[{},[0,0,2,1,2]],"m":[{"b":[{},[0,0,2,1]]}],"r":[{},[0,0,2]],"z":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2,1,2]],"r":[{"é":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"i":[{"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2]],"z":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2,1]],"ü":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"n":[{"y":[{"e":[{"g":[{},[0,0,2,0,1,2]],"l":[{},[0,0,2,0,1,2]],"r":[{},[0,0,2,0,1,2]]}],"i":[{"s":[{},[0,0,2,0,1]]}],"í":[{},[0,0,2,0,1]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"ú":[{},[0,0,2]]}]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"a":[{"á":[{},[2]],"f":[{},[2]],"i":[{},[2]],"l":[{},[2]],"r":[{},[2]]}],"á":[{"d":[{},[2]],"é":[{},[2]],"m":[{},[2]]}],"c":[{"e":[{"m":[{},[0,0,0,2]]}]}],"e":[{"g":[{"e":[{},[0,0,0,0,2,1,2]]}]}]}],"s":[{"o":[{"r":[{"r":[{},[0,0,2,1]]}]}],"z":[{"a":[{"l":[{},[0,0,0,0,1]]}],"á":[{"r":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,0,1]]}]}]}],"t":[{"a":[{"u":[{},[0,0,0,0,3,2]]}]}],"v":[{"k":[{},[2,1]]}],"z":[{"s":[{"e":[{},[0,0,0,0,1,2]],"o":[{},[0,0,0,0,1]]},[0,0,2]]}]},[1]],"f":[{"e":[{"l":[{"i":[{},[0,0,0,3]]}]}],"i":[{"a":[{"c":[{},[0,0,0,2]],"g":[{},[0,0,0,2]],"k":[{"a":[{},[0,0,0,2]]}],"m":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}]}],"l":[{"i":[{},[0,0,0,0,2]]}],"s":[{"h":[{},[0,0,1]]}],"y":[{},[1,2]]}],"g":[{"l":[{"ó":[{},[0,0,2]]}]}],"i":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{},[0,0,2]],"h":[{},[0,0,2]],"í":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"p":[{"a":[{},[0,0,2]]},[0,0,0,1]],"r":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"é":[{},[0,0,2]]}],"s":[{"z":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]]}]}],"u":[{},[0,0,2]],"ü":[{},[0,0,2]],"v":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]]}]}],"á":[{"l":[{},[0,0,0,2]]}],"c":[{"h":[{},[0,0,2,3]],"i":[{"t":[{"á":[{},[0,0,0,0,2,1]]}]}]}],"d":[{"a":[{"n":[{},[0,0,2]]}],"á":[{},[0,0,2,1]],"r":[{"á":[{},[0,0,1]]}]}],"e":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{"e":[{},[0,0,0,0,1]]},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"a":[{"z":[{},[2,1,2]]}]}],"k":[{"l":[{},[0,0,1,2]],"r":[{"á":[{},[0,0,1]],"é":[{},[0,0,1]],"i":[{},[0,0,1]]}],"v":[{},[0,0,1,2]]}],"l":[{"a":[{"c":[{},[0,0,2]],"d":[{"a":[{},[0,0,0,1]]}],"k":[{"n":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"l":[{},[0,0,2]],"m":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"e":[{"l":[{"t":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,0,1]]},[0,0,2]]}],"é":[{"r":[{"t":[{},[0,0,0,1]]}]}],"i":[{"d":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1]]}],"m":[{"a":[{"d":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]],"t":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2,1,2]],"o":[{"s":[{},[0,0,0,2]]}],"u":[{},[0,0,0,2]]}],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"m":[{"á":[{},[2,1,2]],"e":[{"g":[{},[0,0,0,0,0,1]]}]}],"n":[{"a":[{"s":[{},[2,1,2]]}],"d":[{},[2]],"o":[{"s":[{"z":[{},[0,0,0,1]]}]}],"ó":[{},[0,0,2,1]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]],"x":[{},[2]]}],"o":[{"v":[{},[0,0,0,2]]}],"ó":[{"k":[{"a":[{"l":[{},[0,0,0,2,1,2]],"r":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"é":[{"p":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2]]},[0,0,3]],"r":[{},[0,0,0,2]]}],"ő":[{"r":[{},[0,0,0,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"o":[{"d":[{},[0,0,2]]}],"s":[{},[0,0,0,2,1]]}],"s":[{"a":[{"r":[{"c":[{},[0,0,0,1]]}]}],"p":[{},[0,0,1,2]],"t":[{"r":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"a":[{"d":[{},[0,0,2,1]],"l":[{"a":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1]]}]}],"á":[{"g":[{},[0,0,2]],"r":[{"a":[{"k":[{},[0,0,0,1]]}]}],"t":[{"a":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"é":[{"h":[{},[0,0,2,1]],"r":[{"d":[{},[0,0,2,1]]}]}],"i":[{"k":[{},[0,0,2]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"z":[{},[0,0,2,1,2]]}],"o":[{"p":[{},[0,0,0,0,1,2]],"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{"n":[{},[0,0,2]]}],"ő":[{"r":[{},[0,0,2,1]]}],"u":[{"r":[{},[0,0,2,1]]}]}],"u":[{"m":[{"i":[{"n":[{},[0,0,0,2]]}]}],"t":[{},[0,0,0,2]]}],"ú":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{},[0,0,2]],"í":[{},[0,0,2]],"l":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2]],"s":[{"z":[{},[0,0,2]]}],"t":[{"i":[{},[0,0,2]]}],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"x":[{"á":[{"r":[{},[0,0,2,1]]}],"e":[{"l":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]]}]},[1]],"í":[{"r":[{"á":[{},[0,0,2]],"c":[{"s":[{"a":[{},[0,0,0,0,0,0,2]]}]}],"i":[{"n":[{},[0,0,2,1]]}],"ó":[{},[0,1,2]],"t":[{"r":[{},[0,0,0,1]]}],"ü":[{},[0,0,2]]}]},[1]],"j":[{"ú":[{"s":[{"z":[{},[0,0,0,1]]}]}]}],"k":[{"i":[{"s":[{},[0,0,0,2,1]]}],"l":[{"i":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"ó":[{},[0,0,2]]}]}],"l":[{"a":[{"k":[{},[0,2]],"n":[{},[0,2]]}],"e":[{"p":[{},[0,2]]}],"i":[{"p":[{},[0,2]],"s":[{"é":[{},[0,0,0,2,1]]}]}],"o":[{"n":[{"á":[{},[0,0,0,2,1]],"é":[{},[0,0,0,2]]}],"t":[{},[0,2]]}],"u":[{"k":[{},[0,2]]}]}],"o":[{"a":[{"m":[{},[0,0,2]]}],"g":[{"á":[{"c":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"r":[{"k":[{},[0,0,2,1]],"o":[{},[0,0,2,1]]}]}],"e":[{},[0,0,2,1]],"g":[{},[0,0,0,3]],"í":[{},[0,0,2]],"o":[{"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]],"u":[{"r":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"h":[{"á":[{"s":[{"z":[{"a":[{"t":[{},[0,0,0,0,2]]}]}]}]}]}],"k":[{"a":[{"l":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}],"r":[{"r":[{},[0,0,2,1]]}]}],"e":[{},[0,0,2,1,2]],"i":[{"n":[{"g":[{},[0,0,0,1]]}]}],"í":[{},[0,0,2]],"k":[{},[0,0,0,1,2]],"o":[{"l":[{"a":[{},[0,0,2]]}],"r":[{},[0,0,2,1]]}]}],"l":[{"t":[{"a":[{"n":[{},[0,0,0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"ö":[{},[0,0,0,2,1]]}]}],"n":[{"a":[{"d":[{"a":[{},[0,0,2,1]],"o":[{},[0,0,2]]}],"k":[{},[0,0,2]],"l":[{"a":[{"p":[{},[0,0,0,1]]}],"e":[{},[0,0,0,0,2,1,2]],"j":[{"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]}]}],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{"z":[{},[0,0,2,1]]}],"u":[{},[0,0,2,1]]}],"á":[{"r":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,0,1]]}],"t":[{},[0,0,2,1]]}],"d":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,0,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2]]}],"f":[{},[0,0,0,1,2]],"i":[{"k":[{"o":[{},[0,0,0,1,2]]}],"m":[{},[0,0,2,1,2]],"n":[{},[0,0,2]],"s":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"í":[{},[0,0,2]],"k":[{},[0,0,0,1]],"o":[{"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2,0,2]],"s":[{"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"i":[{"n":[{},[0,0,0,2,1,2]]}],"ó":[{"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"ü":[{},[0,0,2]],"y":[{"a":[{},[0,0,0,0,0,1]]}]}],"r":[{"a":[{"d":[{},[0,0,2,1]],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"l":[{"a":[{},[0,0,2,1]]}],"n":[{},[0,0,2,1,2]],"t":[{"o":[{},[0,0,0,1]]}]}],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"g":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"i":[{"l":[{},[0,0,2,1]],"o":[{},[0,0,2,1,2]]}],"m":[{"e":[{"l":[{},[0,0,0,2,1,2]],"m":[{},[0,0,0,2,1]],"r":[{"ő":[{},[0,0,0,2]]}],"s":[{},[0,0,0,2]]}],"é":[{"r":[{"t":[{"é":[{},[0,0,0,2,1]]}]}]}],"i":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}]}],"o":[{"l":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]],"r":[{"ú":[{},[2,1]]}],"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"á":[{"l":[{},[0,0,0,2,1]]}],"e":[{"l":[{},[0,0,0,2,1,2]]}],"é":[{"r":[{"d":[{},[0,0,0,2,1]]}]}],"ü":[{},[0,0,0,2]]}],"ü":[{},[0,0,2]]}],"t":[{"o":[{"s":[{},[0,0,0,0,1]]}]}],"v":[{"i":[{},[0,0,2]]}]},[1]],"ó":[{"r":[{"á":[{},[0,0,2]]}],"s":[{"z":[{"a":[{},[0,0,0,0,0,2]]}]}]},[1]],"ö":[{"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"d":[{"ö":[{"k":[{},[0,0,0,2]]}]}],"e":[{".":[{},[0,0,3]]},[0,0,2,1,2]],"é":[{"s":[{"b":[{"e":[{"l":[{},[2,1,2]]}]}]}]}],"i":[{"v":[{},[0,0,2]]}],"í":[{},[0,0,2]],"k":[{},[0,0,0,1,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{"n":[{},[0,0,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"n":[{"n":[{"e":[{},[0,0,0,0,0,2]]},[0,0,0,2,1]]}],"s":[{"á":[{},[0,0,2]]}]},[1]],"ő":[{"a":[{"n":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{"a":[{},[0,0,1]]}]}],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"é":[{"h":[{},[0,0,0,2]],"t":[{"e":[{},[0,0,0,2]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,0,0,2]],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"t":[{"a":[{},[0,0,0,2]]}]}],"í":[{"t":[{},[0,0,0,2]]}],"k":[{"l":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{"a":[{"g":[{},[0,0,2,1]],"p":[{"j":[{},[0,0,2,1]]}]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"j":[{},[0,0,2,1]]}],"e":[{"m":[{},[0,0,2]],"s":[{},[0,0,0,0,2]]}],"é":[{"k":[{},[0,0,2,1]]}],"i":[{"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"ü":[{"l":[{"é":[{},[0,0,0,1]]},[0,0,2]]}]}],"s":[{"l":[{},[0,0,1]],"ö":[{},[2]],"t":[{"a":[{},[0,0,1]],"r":[{},[0,0,1]]}],"z":[{"l":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"ü":[{"l":[{},[0,0,0,2]]}],"z":[{"ő":[{"é":[{},[0,0,0,0,0,2]]}]}]},[1]],"p":[{"l":[{"a":[{},[0,0,2]]}],"r":[{"o":[{},[0,0,2]]}]}],"r":[{"a":[{"s":[{},[0,0,0,1]]}],"á":[{"m":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2,1,2]]}],"n":[{"y":[{"e":[{},[0,0,0,2]]}]}],"s":[{},[0,2]]}],"e":[{"s":[{"k":[{},[0,2]]}]}],"é":[{"n":[{"á":[{},[0,0,0,2]],"é":[{"n":[{},[0,0,0,2]]}]}]}],"i":[{"c":[{"h":[{},[0,3]]},[1,2]],"g":[{},[0,2]],"p":[{},[0,3]],"s":[{},[1,2]]}],"o":[{"n":[{"t":[{"a":[{},[0,0,0,0,2,1,2]],"e":[{},[0,0,0,0,2,1,2]]}]}]}],"ö":[{"c":[{},[0,2]]}],"u":[{"s":[{},[0,2]]}]}],"s":[{"h":[{"o":[{},[0,0,2]]}],"p":[{"o":[{},[0,0,2]]}],"t":[{"í":[{},[0,0,2]],"r":[{},[0,0,0,2]]}]}],"t":[{"a":[{"j":[{},[0,0,1]],"k":[{"r":[{},[0,0,0,1]]}],"l":[{"j":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"f":[{},[0,2,1]],"m":[{"e":[{},[0,2,1]]},[0,0,0,2]]}],"é":[{"r":[{".":[{},[0,2,1]]}]}],"i":[{"g":[{"e":[{},[0,2,1]]},[0,0,0,2]],"n":[{"g":[{},[0,2,1]]}]}],"ö":[{"s":[{},[0,0,1]]}],"ú":[{"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"t":[{},[0,0,1]],"z":[{},[0,2,1,2]]}]}],"u":[{"g":[{"a":[{},[0,0,0,0,1]]}],"r":[{"a":[{"t":[{"e":[{},[0,0,0,0,2,1]]}]}]}],"s":[{"a":[{"s":[{},[0,0,2,1]]}],"e":[{"g":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2]]}],"z":[{"á":[{},[0,0,2,0,1,2]],"o":[{"l":[{},[0,0,2,0,1]]}],"ü":[{},[0,0,2]]}]}],"t":[{"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"s":[{"p":[{},[0,0,0,0,1,2]]}]}]}]},[1]],"ú":[{"j":[{"t":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"r":[{"é":[{},[2,1,2]],"r":[{},[2,1]]}],"z":[{"s":[{},[0,0,2]]}]},[1]],"ü":[{"g":[{"y":[{},[2,1,2]]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"c":[{},[0,0,0,0,2]],"m":[{"l":[{},[0,0,2,1]]}],"p":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1,2]]}],"é":[{"j":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"l":[{},[0,0,0,3]],"o":[{},[0,0,2]],"ő":[{"t":[{},[0,0,2]]},[2]],"t":[{},[0,0,0,3,2]]}],"m":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2,1]],"o":[{},[0,0,2]],"ő":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"n":[{"n":[{},[2,1]]}],"r":[{"t":[{"ő":[{},[0,0,0,2,1]]}]}],"s":[{"t":[{"ü":[{"l":[{"é":[{},[0,0,0,2,1]]}]},[0,0,0,0,0,2]]}]}],"t":[{"é":[{},[2,1,2]],"ő":[{},[2,1,2]]}],"z":[{"l":[{},[2,1]]}]},[1]],"ű":[{"d":[{"r":[{},[0,0,1]]}],"f":[{"r":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"r":[{},[0,0,1]],"z":[{"e":[{"r":[{"e":[{"l":[{},[0,0,0,0,0,2,1]]}]}]}]}]}],"t":[{"r":[{},[0,0,1,2]]}],"z":[{"á":[{},[0,0,2]],"i":[{"s":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ö":[{"l":[{"t":[{},[0,0,2,1]]}]}]}]},[1]],"v":[{"á":[{"r":[{"o":[{"s":[{"é":[{},[0,0,0,0,0,0,0,2]]}]}]}]}]}],"y":[{},[1]]}],"g":[{".":[{},[2]],"a":[{"b":[{"c":[{},[2,1]],"r":[{},[2]],"s":[{},[2,1]],"y":[{},[0,0,1]]}],"d":[{"a":[{"g":[{},[2,1,2]],"p":[{},[0,1]],"t":[{"a":[{},[2,1,2]],"b":[{},[2,1,2]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"m":[{},[2,1]],"o":[{"g":[{},[0,0,2]],"m":[{"á":[{},[2]]}]}],"ó":[{"i":[{"k":[{"o":[{},[0,0,0,0,0,2]]}]}],"s":[{"a":[{"t":[{},[2]]}]}]}],"u":[{".":[{},[2,1,2]],"k":[{},[2,1,2]]}]}],"e":[{"r":[{},[0,0,0,2]]}],"f":[{"f":[{},[2,1]],"l":[{},[0,0,1]]}],"g":[{"a":[{".":[{},[0,0,2]]}],"g":[{},[2,1]],"r":[{"á":[{},[0,0,1,2]]}],"y":[{".":[{},[0,1]],"u":[{},[0,0,2]],"ú":[{},[0,1,2]]}]}],"j":[{"á":[{"n":[{},[2,1]]}],"k":[{},[2,1]],"t":[{},[2,1]]}],"k":[{"a":[{"d":[{},[2,1,2]]}],"á":[{"c":[{},[0,0,2]]}],"c":[{},[2,1]],"é":[{"v":[{},[2]]},[0,2,3]],"l":[{},[0,0,1]],"n":[{"a":[{"i":[{},[2]]}]}],"t":[{"u":[{},[0,1]]}],"v":[{},[0,1]]}],"l":[{"a":[{"g":[{"ú":[{},[0,0,0,0,2,1]]}],"t":[{},[0,0,2]]}],"á":[{"f":[{},[2]],"í":[{},[2]],"v":[{},[0,0,2]]}],"b":[{},[2,1]],"c":[{},[2,1]],"e":[{"g":[{"e":[{},[0,0,0,0,2,1,2]]}]}],"k":[{},[2,1]],"o":[{"m":[{"e":[{},[0,0,0,0,2,1]]}],"p":[{},[3]],"s":[{},[0,1,2]]}],"u":[{"d":[{},[2,1,2]],"l":[{},[0,0,2]],"s":[{"z":[{},[0,0,2]]}]}],"v":[{"ó":[{},[2]]}]}],"m":[{"a":[{"g":[{"á":[{},[0,0,2,1,2]]}]}],"c":[{},[2,1]],"p":[{},[2,1]]}],"n":[{"a":[{"b":[{},[0,0,2]],"l":[{},[2,1,2]]}],"c":[{"s":[{"a":[{"l":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,0,0,1]]}],"e":[{},[0,0,0,2]]},[2]]}],"d":[{},[0,0,0,1,2]],"é":[{},[3,2]],"g":[{"a":[{},[0,0,0,2]]}],"i":[{"m":[{},[0,1,2]]}],"y":[{"a":[{"g":[{},[0,0,2]],"t":[{},[0,0,2,0,1]]}],"e":[{"l":[{},[0,0,0,0,0,2]]}],"é":[{"r":[{},[0,0,2]]}],"ó":[{},[0,1,2]],"ö":[{},[0,0,2]]}]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"a":[{".":[{},[0,0,2]],"á":[{},[0,0,2]],"c":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"n":[{},[0,0,2]],"t":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"o":[{"k":[{},[0,0,2]]}],"ó":[{".":[{},[0,0,2]],"b":[{},[0,0,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2]],"v":[{},[0,0,2]]}],"p":[{},[2,1]],"r":[{"é":[{},[0,0,1,2]],"o":[{},[0,0,1]]}]}],"r":[{"a":[{"t":[{"í":[{},[0,0,0,0,2,1]]}]}],"á":[{"k":[{},[2,1,2]],"n":[{"y":[{},[2,1,2]]}]}],"é":[{"n":[{},[0,0,2]]}],"k":[{},[0,0,0,1,2]],"ő":[{},[0,0,2]]}],"s":[{"e":[{"g":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2,1]]}],"í":[{"n":[{},[0,0,2,1]]}],"p":[{"i":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"s":[{"z":[{"e":[{},[0,0,0,3]],"í":[{},[0,0,0,3]]}]}],"t":[{"a":[{},[0,0,1,2]],"o":[{},[0,0,1]],"r":[{},[0,0,1]]},[0,0,0,0,2]],"z":[{"a":[{"g":[{"g":[{},[0,0,0,0,1]]}],"n":[{},[0,0,2,0,1]]}],"á":[{"g":[{},[0,0,2]],"s":[{},[0,0,2]]}],"e":[{"s":[{},[0,0,2,0,1]]}],"t":[{"á":[{"r":[{},[0,0,0,0,2]]}]}]}]}],"t":[{"a":[{"d":[{},[0,0,2,1,2]],"r":[{"á":[{},[0,0,0,1]]}],"v":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]],"r":[{"a":[{"m":[{},[0,0,2,1,2]]}]}]}],"e":[{"g":[{},[0,0,2,1]],"p":[{},[0,0,2]]}],"é":[{"s":[{},[0,0,0,0,2]]}],"h":[{"i":[{},[0,0,1]]}],"i":[{"m":[{},[0,0,2]]}],"o":[{"l":[{"d":[{},[0,0,0,1]]}],"m":[{"i":[{},[0,0,2]]}]}]}],"u":[{"k":[{},[0,1,2]],"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"v":[{"a":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"u":[{},[2,1,2]]}],"z":[{"a":[{"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"e":[{},[0,0,0,0,2]]}]}],"á":[{"l":[{},[0,0,2]]}],"d":[{},[3,2]],"e":[{"r":[{},[0,0,2]]},[3,2]],"g":[{},[2]],"í":[{"t":[{"á":[{},[2]]}]}],"m":[{"u":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"o":[{"d":[{},[2]],"n":[{},[2]]}],"ü":[{},[0,0,2]]}]},[1]],"á":[{"b":[{"a":[{},[0,2]],"é":[{},[2,1,2]],"ó":[{},[0,2]],"r":[{},[2,1]]}],"c":[{"i":[{},[3,2]],"s":[{"a":[{"v":[{"a":[{},[0,0,0,0,1,2]]}]}],"e":[{},[0,0,2]],"i":[{"l":[{},[0,0,2,0,1]]}],"ü":[{},[0,0,2]]}]}],"d":[{"a":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2]],"é":[{"l":[{},[0,0,2,1]]}],"i":[{"a":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"ü":[{},[0,0,2,1]]}],"f":[{"o":[{},[0,0,2]]}],"g":[{".":[{},[2,1]],"a":[{"k":[{},[0,0,2]],"t":[{},[0,0,2]],"z":[{},[0,0,2]]}],"g":[{},[2,1]],"i":[{},[2,1,2]],"ú":[{},[2,1,2]],"y":[{"a":[{"s":[{"z":[{},[0,0,0,0,1]]}]}]},[2,1,2]]}],"h":[{"í":[{},[2,1,2]]}],"j":[{"a":[{},[0,2]],"á":[{},[0,2]],"e":[{},[0,0,2,1,2]],"ü":[{},[0,0,2]]}],"l":[{"a":[{"p":[{},[0,0,0,0,1]]}],"c":[{},[2,1]],"d":[{"o":[{},[2,1]]}],"e":[{"s":[{},[0,0,2,1]]}],"i":[{"s":[{},[3]]},[0,2]],"l":[{".":[{},[2,1]],"í":[{},[2,1]],"u":[{},[2,1]]}],"m":[{"o":[{},[2,1]]}],"y":[{},[3,2]]}],"m":[{".":[{},[0,2]],"a":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"í":[{},[2,1,2]],"ü":[{},[0,0,2]]}],"n":[{"a":[{"c":[{},[0,0,2]],"l":[{},[0,0,2]],"p":[{},[0,0,2]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{"s":[{},[0,0,2]]}],"c":[{"s":[{"e":[{},[0,0,0,2]],"i":[{},[0,0,0,2]],"ö":[{},[0,0,0,2,0,1,2]]}]}],"d":[{},[0,0,0,1,2]],"e":[{},[0,0,2,1]],"g":[{"y":[{".":[{},[2]]}]}],"i":[{"g":[{},[0,0,2]],"o":[{},[0,0,2,1]],"s":[{},[0,0,2]],"z":[{},[2,1,2]]}],"o":[{"l":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,0,1,0,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ú":[{},[0,0,2,1]],"ü":[{},[0,0,2]],"y":[{"a":[{"n":[{},[0,0,2,0,1,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,0,1]]}],"e":[{},[0,0,2,0,1,2]],"é":[{"r":[{"d":[{},[0,0,2]],"z":[{},[0,0,2]]}]}],"i":[{"j":[{},[0,0,2]]}],"k":[{"á":[{},[0,0,0,0,0,0,2]]}],"ö":[{},[0,0,2]]}]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,2]],"g":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"m":[{},[2,1,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{"o":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,2,0,2]],"v":[{},[0,0,2,1]],"z":[{},[2,1,2]]}],"á":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"z":[{},[0,0,2,1,2]]}],"e":[{"m":[{},[0,0,0,1]],"s":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,2,0,2]],"é":[{"t":[{"e":[{},[0,0,0,1]]}]}],"i":[{"f":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"s":[{"k":[{},[0,0,2,1]],"m":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"n":[{"y":[{"é":[{},[2,1]]}]}],"o":[{"l":[{},[0,0,2,1]],"p":[{},[0,0,2]],"s":[{"t":[{},[0,0,0,1]],"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1,2]],"t":[{"r":[{},[0,0,0,1]]}],"u":[{".":[{},[2]],"d":[{},[2,1]],"g":[{},[0,0,2]],"h":[{},[2,1,2]],"l":[{"á":[{},[2,1,2]],"ó":[{},[2,1,2]]}],"r":[{},[2,1]],"s":[{},[2]],"t":[{"a":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}]}],"ú":[{"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"s":[{".":[{},[0,2]],"a":[{"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"t":[{"á":[{},[2]]}]}],"á":[{"g":[{},[0,0,2,1,2]],"r":[{"a":[{"d":[{},[0,0,2,1]]}],"n":[{},[0,0,2,1]]}],"s":[{},[2,1,2]],"t":[{"o":[{},[0,0,2,1,2]]}]}],"e":[{},[0,0,2,1,2]],"i":[{"m":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"r":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,0,1,2]]},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"z":[{"é":[{},[0,0,0,3]],"ü":[{},[0,0,0,3]]}]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"t":[{},[0,0,2]]}],"ü":[{},[0,0,2,1,2]],"ű":[{},[0,0,2]],"z":[{"a":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{"l":[{},[0,0,2]]}],"v":[{},[0,0,2,3]]}],"á":[{"l":[{},[0,0,2,0,1]]}],"e":[{},[0,0,2,0,1,2]],"i":[{"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"í":[{},[0,0,2]],"k":[{"á":[{},[2,1]],"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"o":[{"k":[{"t":[{"a":[{},[0,0,2,0,1]]}]}]}],"ó":[{"l":[{},[0,0,2,0,1]],"n":[{},[0,0,2,3]]}],"ö":[{"v":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}]}],"t":[{".":[{},[0,2]],"a":[{"d":[{},[2]],"j":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,1,2]],"j":[{},[0,0,0,1]]},[2,0,2]]}],"á":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2]]},[0,0,0,0,2]],"b":[{"o":[{},[2,1]]}],"e":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1,2]],"n":[{},[0,0,2]]}],"é":[{"l":[{},[0,0,2]],"r":[{".":[{},[0,0,2,1]],"e":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"f":[{"e":[{},[2]]}],"g":[{},[2,1]],"h":[{"a":[{},[2,1]]}],"i":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]],"z":[{},[0,0,2]]}],"í":[{},[2,1,2]],"m":[{"é":[{},[0,1]]}],"o":[{"l":[{"d":[{"a":[{},[0,0,2,1]]}]}]}],"ó":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{},[2,1,2,1]],"ő":[{},[0,0,2]],"t":[{"ű":[{},[2,1]]}],"ü":[{},[2,0,2,0,2]],"v":[{"i":[{},[0,1]]}]}],"v":[{"a":[{},[0,2]],"ó":[{},[0,1,2]]}],"z":[{"a":[{"d":[{},[0,0,2,1,2]],"k":[{"n":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1]]}],"á":[{"r":[{".":[{},[0,0,2,1]],"á":[{},[0,0,2,1]],"e":[{},[0,0,0,1]],"h":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"o":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]],"u":[{},[0,0,2]]}],"s":[{"o":[{"s":[{},[2,1,2]]}]}]}],"e":[{},[0,0,2,1,2]],"i":[{"g":[{"a":[{},[0,0,2,1]]},[0,0,0,0,2]],"m":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1,2]],"z":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"p":[{},[0,0,0,3]],"t":[{"a":[{},[0,0,0,3]],"e":[{},[0,0,0,3]]}],"u":[{"g":[{},[0,0,0,3]]}],"ú":[{},[0,0,2]],"ü":[{},[0,0,0,3]],"z":[{},[0,0,0,3]]}],"ü":[{},[0,0,2]]}]},[1]],"b":[{"e":[{"á":[{},[0,0,0,0,2]]}],"é":[{"l":[{"á":[{},[0,0,0,2]]}],"r":[{"e":[{"m":[{},[0,0,0,2]]}]}]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}]}],"c":[{"s":[{"a":[{"p":[{"á":[{"g":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}]}]}]}],"d":[{"a":[{"u":[{},[0,0,0,2]]}],"e":[{"l":[{"l":[{},[0,0,1]]}],"p":[{},[0,0,0,1,2]]}],"é":[{"k":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]]}]}],"i":[{"n":[{"a":[{".":[{},[0,0,1]]}],"á":[{"b":[{},[0,0,1]],"h":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}]}]}],"r":[{"á":[{},[0,1,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"z":[{"ö":[{},[0,2,3]]}]}],"e":[{"a":[{"c":[{},[0,0,0,2]],"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]}],"b":[{"e":[{},[0,2]]}],"c":[{"e":[{"t":[{},[0,1,2]]}],"i":[{},[3,2]]}],"d":[{"d":[{"z":[{},[0,1]]}],"é":[{"n":[{"n":[{},[2]],"y":[{},[2]]}]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]]}]}],"f":[{"f":[{},[2,1]]}],"g":[{"e":[{},[2]],"é":[{},[2,1,2]],"o":[{"m":[{},[3]]}],"y":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"o":[{},[0,0,2]],"ü":[{},[2,1,2]]}]}],"h":[{"e":[{"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"ü":[{},[2,1,2]]}],"j":[{"t":[{},[2,1]]}],"k":[{"e":[{".":[{},[2,1,2]],"i":[{},[2,1,2]],"k":[{},[2,1,2]]}],"é":[{"é":[{},[2,1,2]],"j":[{},[0,0,2]],"k":[{},[0,0,2]],"s":[{".":[{},[2,1,2]]}]}],"l":[{"i":[{},[0,0,1,2]]}],"s":[{},[2,1]]}],"l":[{".":[{},[3,2]],"a":[{"d":[{},[0,1]],"g":[{},[0,0,2]],"p":[{},[3,2]],"s":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"c":[{"s":[{},[2,1]]}],"d":[{".":[{},[3]],"o":[{},[2,1]],"ö":[{},[2,1]]}],"e":[{"f":[{},[0,0,2]],"g":[{"i":[{},[0,0,2]],"y":[{},[0,1]]}],"k":[{".":[{},[3,2]]}],"m":[{"é":[{},[2,0,2]],"i":[{},[0,0,2]],"k":[{},[2,0,2]],"m":[{},[2,1,2]],"z":[{},[2,1,2]]}],"n":[{"d":[{},[3]],"g":[{},[0,0,2,1]],"y":[{},[0,0,2,1]]},[0,0,0,0,2]],"s":[{"t":[{"e":[{},[0,0,0,1]]}]}],"v":[{},[0,0,2]]}],"é":[{"g":[{},[0,0,2]],"s":[{"b":[{},[3,2]],"e":[{"k":[{},[3,2]],"n":[{},[3,2]]}],"é":[{"n":[{},[3,2]],"r":[{},[3,2]]}],"h":[{},[3,2]],"i":[{".":[{},[3,2]]}],"k":[{},[3,2]],"r":[{"ő":[{},[3,2]]}],"s":[{},[3,2]],"t":[{"ő":[{},[3,2]]}],"ü":[{},[3,2]],"z":[{".":[{},[3]],"ő":[{},[3]],"ü":[{},[3]],"v":[{},[3]]},[2,1]]}]}],"h":[{"e":[{"l":[{},[2,1]],"s":[{},[3,2]],"t":[{},[3,2]]}]}],"i":[{".":[{},[3,2]],"k":[{},[3,2]],"n":[{"t":[{},[0,0,0,1]]}]}],"j":[{".":[{},[3,2]],"e":[{},[3,2]],"é":[{},[3,2]],"ü":[{},[3,2]]}],"k":[{"ü":[{},[2,1]]}],"l":[{"e":[{"n":[{"ő":[{},[2]]}]}]}],"m":[{"é":[{},[2,1]]}],"n":[{"e":[{"v":[{},[2,1]]}],"é":[{"n":[{},[3,2]]}],"i":[{},[3,2]]}],"o":[{"s":[{},[2,1,2]]}],"ö":[{},[0,0,2]],"ő":[{".":[{},[3,2]],"b":[{"b":[{"r":[{},[0,0,2]]}],"e":[{},[3,2]],"é":[{},[3]],"i":[{},[3]],"o":[{},[3]],"ő":[{},[3,2]]}],"c":[{},[3,2]],"e":[{},[3,2]],"é":[{},[3,2]],"g":[{},[3,2]],"h":[{},[3,2]],"j":[{"a":[{},[3]],"é":[{},[3,2]],"o":[{},[3,2]],"ü":[{},[3,2]],"ű":[{},[3,2]]}],"k":[{".":[{},[3,2]],"a":[{},[3,2]],"b":[{},[3,2]],"e":[{"l":[{},[0,0,2]],"r":[{},[3,2]],"t":[{},[3,2]],"z":[{},[3,2]]}],"é":[{".":[{},[3]],"n":[{},[3,2]],"s":[{},[2,1]]}],"h":[{},[3,2]],"i":[{},[3,2]],"k":[{},[3,2]],"l":[{},[3]],"n":[{},[3,2]],"ö":[{},[3,2]],"ő":[{},[3]],"r":[{},[3,2]],"t":[{},[3]],"u":[{},[3]],"ü":[{},[3]]}],"l":[{},[2,1,2]],"m":[{},[2,1]],"n":[{".":[{},[3,2]],"a":[{},[3]],"e":[{},[3,2]],"é":[{},[3,2]],"k":[{},[3,2]],"ö":[{},[3]],"y":[{"i":[{},[3]]}]}],"o":[{},[3,2]],"ö":[{},[3]],"ő":[{},[3,2]],"p":[{},[3,2]],"r":[{"e":[{".":[{},[0,2]]}],"é":[{"s":[{},[3,2]]}],"o":[{},[3]],"ő":[{},[3,2]]}],"s":[{".":[{},[3,2]],"á":[{},[3]],"o":[{},[3]],"ö":[{},[3]],"z":[{"a":[{},[3,2]],"e":[{},[3]],"é":[{},[3]],"i":[{},[3]],"ó":[{},[3]],"ö":[{},[0,0,2]]}]}],"t":[{".":[{},[3,2]],"á":[{},[3,2]],"é":[{},[2,1]],"ő":[{},[3,2]],"ü":[{},[3]]}],"ü":[{},[3]],"v":[{"á":[{},[3,2]],"e":[{},[3,2]],"é":[{},[3,2]],"i":[{"s":[{},[3]],"z":[{},[3]]}]}],"z":[{},[2,1,2]]}],"s":[{"ő":[{},[0,1]],"z":[{".":[{},[3,2]],"á":[{},[2,1]],"o":[{},[2,1]]}]}],"t":[{".":[{},[3,2]],"e":[{".":[{},[3]],"k":[{},[3,2]],"m":[{},[3,2]],"s":[{},[3]],"t":[{"t":[{".":[{},[2,1]],"n":[{},[2,1]]}]}]}],"é":[{"b":[{},[3]],"k":[{},[3,2]],"l":[{},[3]],"r":[{},[2,1]],"t":[{},[3]]}],"o":[{},[2,1]],"ű":[{},[2,1]]}],"ü":[{"l":[{},[0,0,2]],"n":[{},[3,2]]}],"v":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{"n":[{},[2,1]]}],"é":[{"t":[{},[2,1]]}],"h":[{},[2,1]],"n":[{},[2,1]],"o":[{},[2,1]],"r":[{},[2,1]],"ű":[{},[2,1]],"v":[{},[2,1]]}],"y":[{"e":[{"g":[{},[0,0,2,0,1,2]]}],"i":[{"d":[{},[0,0,2]]}]}]}],"m":[{"a":[{"n":[{},[0,0,2]]}],"b":[{"e":[{"r":[{},[2,1]]}],"l":[{},[2,1]]}],"e":[{"l":[{"é":[{},[2]],"k":[{},[2]],"l":[{},[0,0,3]],"ő":[{},[2]]},[0,1,2]]}],"é":[{"s":[{},[2,1,2]]}],"l":[{},[2,1]],"o":[{"c":[{},[0,0,2]]}],"p":[{},[2,1]]}],"n":[{"a":[{"d":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"u":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"d":[{},[0,2]],"e":[{"g":[{},[0,0,2,1]],"r":[{"á":[{},[3]],"e":[{},[0,0,2]],"g":[{},[2]]}],"s":[{"z":[{},[0,0,2,1]]}],"v":[{"e":[{"t":[{},[0,0,2,1,2]],"z":[{},[0,0,2,1,2]]}]}]}],"é":[{"k":[{"é":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"i":[{"d":[{},[0,0,0,0,2,1]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"k":[{},[0,0,0,1,2]],"n":[{"i":[{},[0,1]],"ü":[{},[0,1]],"y":[{"a":[{},[0,0,0,3]]}]}],"o":[{"p":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"s":[{"é":[{"r":[{"t":[{},[0,0,0,2]]}]}],"s":[{},[0,0,0,0,3]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"r":[{},[0,0,2,1]]}],"y":[{"e":[{},[0,2]],"h":[{},[2,1]],"v":[{},[0,1]]}],"z":[{},[2,1]]}],"o":[{"b":[{},[0,0,2]],"c":[{},[0,0,2]],"f":[{},[0,0,2]],"k":[{},[0,0,2]],"m":[{},[0,0,2]],"r":[{"g":[{"i":[{"a":[{},[0,0,2]]}]}]}],"t":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"e":[{"d":[{},[0,0,2]],"r":[{},[0,0,2]]}],"é":[{"s":[{},[0,0,2]]}],"i":[{},[2]],"o":[{"s":[{},[0,0,2]]}]}],"r":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]],"u":[{},[0,0,2]]}],"á":[{"b":[{},[0,0,2]],"g":[{},[0,0,2,1,2]],"l":[{"l":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,0,2,1]]},[0,0,0,0,2]],"t":[{},[0,0,2]]}],"d":[{"e":[{},[0,1]]}],"e":[{"b":[{},[3,2]],"d":[{"m":[{},[2]]}],"g":[{"e":[{},[0,1]],"y":[{},[0,0,0,1]]},[0,0,2]],"j":[{},[2,1,2]],"l":[{"ő":[{"k":[{},[0,0,2,1,2]]}]}],"m":[{"l":[{},[0,0,2,1]]}],"n":[{"y":[{},[0,0,2,1]]}],"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2]]}],"v":[{},[0,0,2,1,2]]}],"é":[{"j":[{},[0,0,2]],"k":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,0,1]],"é":[{},[0,0,0,1,2]]},[0,0,2]],"p":[{},[0,0,2,1]],"t":[{"t":[{},[0,0,2,1]]}]}],"i":[{"n":[{"a":[{},[0,0,2,1,2]],"g":[{},[0,0,2,1]]}],"p":[{},[0,0,2,1,2]],"s":[{},[0,0,0,2]],"z":[{},[0,0,2,1]]}],"o":[{"g":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,1]]}],"t":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"ö":[{"k":[{},[0,0,2]],"n":[{},[0,0,2,1]]}],"ő":[{".":[{},[0,1]],"k":[{},[0,1]],"v":[{},[0,1]],"z":[{},[0,0,0,1]]},[0,0,2]],"u":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ü":[{"g":[{},[0,0,2,1,2]],"l":[{"d":[{},[0,0,0,1]],"é":[{},[0,0,2,1,2]]}]}]}],"s":[{".":[{},[0,2]],"á":[{},[0,0,2,1]],"c":[{},[0,0,1]],"d":[{},[0,0,0,0,2]],"e":[{"b":[{},[0,2]],"i":[{},[3,2]],"l":[{},[0,0,2,1,2]],"m":[{"b":[{},[0,0,2,1]]}],"n":[{".":[{},[0,2]],"d":[{},[0,0,2]]}],"r":[{},[2,1,2,1]],"t":[{"b":[{},[2,1,2]],"e":[{"t":[{},[2,1,2]]}],"é":[{},[2,1,2]],"l":[{},[0,0,2]],"r":[{},[2,1,2]],"t":[{},[2,1,2]]}]}],"é":[{"l":[{},[2,1]],"s":[{},[2,1,2]]}],"i":[{"k":[{},[0,1,2]]}],"k":[{"ü":[{},[2]]}],"l":[{"e":[{"g":[{},[0,0,0,0,0,0,1]]}]}],"n":[{"i":[{},[0,1]]}],"ő":[{},[2,1,2]],"r":[{},[0,2]],"s":[{"é":[{".":[{},[3,2]],"g":[{},[3,2]]}]},[0,0,0,0,2]],"t":[{".":[{},[0,2]],"e":[{},[2,1]],"é":[{},[2,1]],"i":[{},[2,1]],"j":[{},[2,1]]}],"v":[{"é":[{},[0,1]]}],"z":[{"e":[{"k":[{},[2,1,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"l":[{},[0,1]],"m":[{},[2,1]]}]}],"t":[{"a":[{"k":[{},[0,0,2,1]],"l":[{},[0,0,2]],"n":[{"y":[{},[0,0,2,1,2]]}],"p":[{},[0,0,0,1]],"s":[{},[0,0,2,1]]}],"e":[{"g":[{"y":[{},[0,0,0,1,2]]}],"t":[{"ő":[{"n":[{},[2,1,2]]}]}]}],"é":[{"k":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{".":[{},[0,0,2,1]],"ü":[{},[0,0,2,1,2]]}],"v":[{"e":[{".":[{},[0,0,2,1,2]]}]}]}],"ó":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"r":[{"t":[{},[0,0,0,1]]}]}],"r":[{"ó":[{},[0,0,1,2]]}],"t":[{"e":[{"b":[{"b":[{"é":[{},[0,0,0,2,1]]}]}]}]}],"u":[{"t":[{},[0,0,2]]}],"ü":[{"z":[{},[0,0,2,1,2]]}]}],"u":[{"r":[{},[0,0,2]],"s":[{},[0,0,0,2]]}],"v":[{"i":[{"c":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]},[2]],"ő":[{},[2,1,2]]}],"y":[{"é":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,2]],"ő":[{"a":[{},[0,0,0,0,0,2]]}],"r":[{},[2,1]]}]},[1]],"é":[{"b":[{"e":[{"r":[{},[0,0,2]]}],"r":[{},[2,1]]}],"c":[{"c":[{},[0,0,0,3]]}],"d":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,2,1]]}]}],"i":[{"k":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2,1,2]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2,1,2]],"ü":[{"l":[{"é":[{},[0,0,2,1]]}]},[0,0,0,0,2]],"ű":[{},[0,0,2]],"z":[{},[0,0,2,3]]}],"g":[{"i":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"h":[{"e":[{".":[{},[2,1,2]],"k":[{},[2,1,2]],"n":[{},[2,1,2]],"s":[{},[2,1,2]],"t":[{},[2,1,2]]}],"h":[{},[2,1]],"s":[{},[2,1]]}],"j":[{".":[{},[2,1]],"é":[{"r":[{"t":[{},[0,0,2]]}]}],"h":[{},[2,1]],"j":[{},[2,1]],"s":[{},[2,1]]}],"k":[{"e":[{"i":[{},[0,0,2]],"l":[{},[0,1,2]],"s":[{"s":[{},[0,0,0,0,0,1]]},[0,1,2]],"z":[{},[0,1,2]]}],"s":[{},[2,1]]}],"l":[{"á":[{"l":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2]],"s":[{},[2]],"t":[{},[2,1,2]],"z":[{},[2,1,2]]}],"é":[{"n":[{},[0,0,2]]}],"m":[{},[2,1]],"v":[{"v":[{"á":[{},[0,0,0,0,0,0,2]]}]}],"y":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"g":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ú":[{},[0,0,2]]}]}],"m":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"b":[{},[0,2]],"e":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"é":[{"r":[{},[0,0,2]]}],"o":[{},[0,0,2,1]]}],"n":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1]],"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{"r":[{},[0,0,2,1]],"t":[{},[0,0,2]]},[0,0,0,0,2]],"d":[{},[3,2]],"e":[{"g":[{},[0,0,2]],"k":[{"e":[{"s":[{},[2]]}],"l":[{},[2]]}],"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"é":[{"g":[{},[0,0,2,1,2]]}],"i":[{"n":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"n":[{},[0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"t":[{},[0,0,0,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,0,0,2]],"y":[{"e":[{"g":[{},[0,0,2,0,1,2]]}],"i":[{"d":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"ú":[{},[0,0,2]]},[0,2]]}],"p":[{".":[{},[3]],"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"l":[{},[0,0,2,1]]},[3]],"s":[{"é":[{},[0,0,2,1]],"z":[{},[0,0,2,1]]}]}],"i":[{"k":[{},[0,0,2]]}],"í":[{"t":[{},[2,1]]},[0,0,2]],"o":[{},[0,0,2,1,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[3,2]],"t":[{"á":[{"v":[{},[0,0,0,0,0,2]]}]}],"u":[{},[0,0,2,1]],"ú":[{},[0,0,2]],"ü":[{"l":[{"é":[{},[0,0,2]]}]}]}],"r":[{"a":[{"g":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{},[0,0,2]],"c":[{".":[{},[2,1]]}],"d":[{},[2,1]],"e":[{"l":[{},[0,0,2,1]],"m":[{"l":[{},[0,0,0,1]]}],"t":[{},[2]]}],"é":[{".":[{},[2]]}],"i":[{"e":[{},[0,0,2]],"n":[{},[2,1,2]],"s":[{},[0,0,2]]}],"k":[{"á":[{},[0,0,0,0,0,2]]}],"l":[{},[2]],"m":[{},[2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{".":[{},[2]],"k":[{},[2]]}],"t":[{"e":[{},[2]],"é":[{},[2]],"h":[{},[2]],"i":[{},[0,1]],"j":[{},[0,1]],"l":[{},[0,1]],"ő":[{".":[{},[0,1]],"e":[{},[0,1]],"k":[{},[0,1]],"v":[{},[0,1]]}],"s":[{},[0,1]],"v":[{},[0,1]]}],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2,1]],"v":[{".":[{},[2,1]],"é":[{},[2]]}],"z":[{"á":[{},[3]]},[2,1]]}],"s":[{"a":[{"r":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]]}],"é":[{"g":[{},[0,0,2,1,2]]}],"i":[{"m":[{},[0,0,2]]}],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"s":[{"z":[{"a":[{},[0,0,0,3]]}]}],"z":[{"a":[{"v":[{},[0,0,0,3]]},[0,0,2]],"á":[{},[0,0,2]],"í":[{"t":[{"ő":[{"ü":[{},[3]]}]}]}],"o":[{},[0,0,2,0,1]],"ó":[{},[0,0,2]]}]}],"t":[{"e":[{"l":[{},[2,1,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"k":[{},[2,1]],"o":[{},[2,1,2]],"r":[{},[2,1]],"t":[{},[2,1]]}],"v":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{".":[{},[2,1,2]],"d":[{},[2,1,2]],"i":[{},[2]],"k":[{},[2,1,2]],"n":[{},[2,1,2]],"t":[{},[2,1,2]]}],"é":[{"b":[{},[0,0,2]],"n":[{},[2,1,2]],"t":[{},[2,1,2]],"v":[{},[2,1,2]]}],"f":[{},[2,1]],"i":[{},[2,1,2]],"j":[{},[2,1]],"k":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]]}],"z":[{"a":[{"n":[{},[0,0,2]]}],"ő":[{"r":[{},[0,0,2]]}],"s":[{},[0,0,0,3,2]]}]},[1]],"f":[{"a":[{"l":[{"a":[{"d":[{"a":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"e":[{},[0,0,0,2]]}]}],"i":[{"ú":[{"k":[{"é":[{},[0,0,0,2]]}]}]}],"l":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"ö":[{"l":[{"ü":[{"l":[{"e":[{},[0,0,0,2,1]]}]}]}]}],"r":[{"a":[{},[0,1,2]],"á":[{},[0,0,2]],"e":[{},[0,1,2]],"í":[{},[0,0,2]],"o":[{},[0,1,2]],"ö":[{},[0,1,2]],"u":[{},[0,0,2]]}]}],"g":[{"a":[{"p":[{},[0,2,1,2]],"r":[{"c":[{},[0,0,1]]}],"s":[{"z":[{"á":[{},[0,2,1]],"ó":[{},[0,2,1]]}]},[0,0,0,2]]}],"e":[{"l":[{"e":[{"s":[{"t":[{},[0,0,0,2]]}]}]}]}],"é":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"i":[{"t":[{"a":[{},[0,0,1,2]]}],"z":[{},[0,2,1]]}],"o":[{"r":[{"v":[{},[0,0,1]]}]}],"ó":[{"n":[{"i":[{},[0,2,1]]},[0,0,0,2]]}],"ő":[{"s":[{},[0,0,0,0,2]]}],"r":[{"a":[{"f":[{},[0,1,2]],"n":[{},[0,1,2]]}],"e":[{},[0,2]],"o":[{},[0,0,2]]}],"s":[{"p":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1,2]]}],"y":[{"a":[{"k":[{},[0,3]],"l":[{"á":[{},[0,3]]}],"p":[{},[0,3]],"r":[{"a":[{},[0,3]],"o":[{},[0,0,0,1]]}],"t":[{},[0,3]]}],"á":[{"r":[{},[0,3]],"v":[{},[0,3]],"z":[{},[0,0,0,1,2]]}],"e":[{"l":[{"ő":[{},[0,0,0,1,2]]}],"n":[{"g":[{},[0,3]]}],"p":[{},[0,3]],"r":[{},[0,3]]}],"é":[{"r":[{"ü":[{},[0,3]]}]}],"i":[{"l":[{},[0,3]]}],"o":[{"l":[{},[0,0,0,1]],"m":[{},[0,3]],"r":[{},[0,3]]}],"ó":[{},[0,3]],"ö":[{},[0,3]],"ő":[{},[0,3]],"u":[{},[0,3]],"ú":[{"t":[{},[0,4]]}],"ü":[{"l":[{"t":[{},[0,0,0,1]]}],"r":[{},[0,3]]}],"ű":[{},[0,3]]},[0,2]]}],"h":[{"a":[{"d":[{"e":[{},[0,0,0,2,1,2]]}],"j":[{"ó":[{"i":[{"k":[{"o":[{},[0,0,0,0,0,0,2]]}]}]}]}],"m":[{".":[{},[0,2]],"b":[{},[0,2]],"e":[{},[0,2]],"h":[{},[0,2]],"m":[{},[0,2]],"n":[{},[0,2]],"r":[{},[0,2]],"t":[{},[0,2]]}],"s":[{"á":[{"b":[{"r":[{},[0,0,0,2]]}]}]}]}],"i":[{"a":[{},[0,2]]}],"y":[{},[1]]}],"i":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]},[0,0,0,1,2]],"c":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{"r":[{},[0,0,2]]},[0,0,0,1]],"g":[{},[0,0,2,1,2]],"h":[{},[0,0,2]],"i":[{"m":[{},[0,0,2]]}],"í":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{"a":[{"r":[{},[0,0,2]],"s":[{},[0,0,2]]}]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]]}],"m":[{},[0,0,2]],"n":[{"ó":[{},[0,0,2]],"y":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"s":[{"z":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"m":[{},[0,0,2]]}],"é":[{},[0,0,2]],"f":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]},[0,0,0,1,0,2]]}],"t":[{"r":[{},[0,0,0,1,2]]},[0,0,2]],"u":[{},[0,0,2,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"b":[{"r":[{},[2]]}],"d":[{"e":[{"a":[{},[2,1,2]],"á":[{},[2,1,2]],"g":[{},[2,1,2]],"i":[{},[0,0,2]],"j":[{},[2]],"o":[{},[2,1,2]]}],"é":[{},[2,1,2]],"i":[{"ó":[{},[0,0,2]]}],"o":[{},[2,1,2]],"ő":[{},[2,1,2]]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"a":[{"d":[{},[0,0,0,1]],"r":[{"a":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,1]]}],"u":[{},[0,0,0,1]],"z":[{},[2]]}],"á":[{"l":[{},[0,0,0,1]]}],"e":[{".":[{},[2,1,2]],"c":[{},[0,0,0,1,2]],"g":[{},[0,0,0,1]],"h":[{},[0,0,0,1]],"n":[{"g":[{},[0,0,0,1]],"n":[{},[0,0,0,1]]}],"r":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1]],"v":[{},[0,0,0,1,2]]}],"é":[{"h":[{},[0,0,0,1]],"l":[{},[0,0,0,1,2]],"m":[{},[0,0,0,1]],"n":[{"e":[{},[0,0,0,1,2]]}],"r":[{},[0,0,0,1,2]],"z":[{},[2,1]]},[0,0,2]],"g":[{},[0,0,0,3]],"i":[{},[0,0,2,1,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2,1,2]],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1]],"u":[{},[0,0,2,1]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2,1]],"ű":[{},[0,0,2]],"y":[{},[0,1,2]]}],"h":[{"a":[{},[2,1,2]],"l":[{},[2,1]]}],"j":[{"e":[{"s":[{},[2]]}]}],"k":[{"e":[{"r":[{},[0,0,2]],"s":[{},[0,0,2]]}]}],"l":[{"e":[{},[3]],"l":[{},[0,1]]}],"m":[{"a":[{".":[{},[0,0,2]],"n":[{},[0,0,2]]}],"á":[{"b":[{},[0,0,2]],"d":[{},[2]],"r":[{},[0,0,2]],"z":[{},[2,1,2]]}],"e":[{".":[{},[0,0,2]]}],"p":[{},[2,1]]}],"n":[{"a":[{"p":[{},[0,0,0,0,1,2]],"s":[{},[0,0,2]]}],"á":[{"z":[{},[0,0,2,1,2]]}],"d":[{},[2,1]],"é":[{},[3]],"f":[{},[2]],"k":[{"v":[{},[2,1]]}],"n":[{"á":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]]}],"p":[{},[2,1]],"s":[{},[2]],"t":[{"a":[{},[2,1]],"c":[{},[3]],"e":[{},[2,1]],"é":[{},[2,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"ő":[{".":[{},[0,1]]}],"s":[{},[0,1]],"u":[{},[0,1]],"v":[{},[0,1]]}],"v":[{},[2,1]],"z":[{},[2,1]]}],"o":[{"n":[{"e":[{},[0,0,2]],"é":[{},[2,1]],"o":[{},[0,0,2]]}],"t":[{},[0,0,2]]}],"ó":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"c":[{},[0,0,2]],"e":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{},[0,0,2]],"k":[{"á":[{},[0,0,2]],"o":[{"m":[{},[0,0,2]]}]}],"l":[{},[0,0,2]],"p":[{},[0,0,2,1]],"r":[{"á":[{},[0,0,2]]}],"s":[{"p":[{},[0,0,2,1]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"p":[{"a":[{},[2,1,2]],"s":[{"z":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"o":[{},[0,0,0,2]]}]},[3,2]]}],"r":[{"a":[{"m":[{},[0,0,2]],"t":[{},[2,1,2]]}],"á":[{},[2,1,2]],"i":[{"g":[{},[0,0,2]]}],"o":[{"d":[{},[0,0,2]]},[2]],"ó":[{"n":[{},[2,1,2]]}],"t":[{},[2,1]]}],"s":[{"c":[{},[0,1]],"i":[{},[2,1,2]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"p":[{},[2,1]],"t":[{"á":[{"l":[{},[2,1]]}],"e":[{},[2,1]]}],"z":[{"á":[{},[2,1,2]],"o":[{},[2,1,2]],"u":[{},[0,0,2]]}]}],"t":[{"a":[{"s":[{},[0,0,2]]}],"á":[{"c":[{},[2]]},[0,2]],"i":[{},[3,2]],"t":[{"e":[{},[3]],"u":[{},[0,1]]}]}],"v":[{"a":[{"d":[{},[2,1,2]]}],"á":[{"s":[{},[2,1,2]]}],"o":[{},[0,1,2]],"ó":[{},[2,1,2]]}],"z":[{"é":[{".":[{},[2,1,2]],"v":[{},[0,0,2]]}],"o":[{},[2,1,2]]}]},[1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"j":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2]]}],"n":[{"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"t":[{"é":[{"s":[{"z":[{},[0,1,2]]}]}]}],"v":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"k":[{"a":[{"r":[{"ó":[{"r":[{},[0,0,0,2,0,2]]}]}]}],"é":[{"p":[{"e":[{"l":[{},[0,0,0,2,1,2]]}]}]}],"i":[{"a":[{"d":[{"ó":[{"n":[{"á":[{},[0,0,0,0,3]]}]}]}]}],"á":[{},[0,0,0,0,2]],"s":[{"s":[{},[0,0,0,0,1]]}]}],"l":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"ö":[{"z":[{"é":[{"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2,1]]}]}]}],"ő":[{"v":[{"á":[{},[0,0,0,0,0,2]]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"l":[{"a":[{"p":[{"l":[{},[0,0,0,1,2]]}],"s":[{"t":[{},[0,0,0,1,2]]}],"t":[{},[0,0,0,3]]}],"á":[{"s":[{"z":[{"a":[{},[0,0,0,2]]}]}]}],"e":[{"g":[{"a":[{},[0,0,0,2,1,2]],"e":[{"l":[{"é":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}],"í":[{},[0,0,0,0,2]],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2,1]]}],"é":[{"r":[{"ő":[{"t":[{},[0,0,0,2,1,2]]}]}],"t":[{"n":[{},[0,0,0,2,1]]}]}],"o":[{"s":[{},[0,0,0,2]]}]}],"ü":[{},[0,0,0,0,2]]}],"é":[{"n":[{"y":[{"e":[{"l":[{},[0,0,0,2]]}]}]}]}],"o":[{"r":[{},[0,2]],"s":[{},[1,2]]}],"ó":[{"ó":[{},[0,0,0,0,2]],"s":[{},[0,0,0,0,2]]}],"ő":[{"r":[{"e":[{"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"o":[{},[0,0,0,2]]}]}]}],"m":[{"e":[{"g":[{"a":[{},[0,0,0,2,1,2]],"e":[{},[0,0,0,2,1]],"é":[{},[0,0,0,2,1]]}],"n":[{"s":[{"s":[{},[0,0,0,0,0,1]],"z":[{},[0,0,0,0,2]]}]}]}],"u":[{"s":[{"s":[{},[0,0,0,0,3]]}]}]}],"n":[{"a":[{"d":[{"a":[{},[0,0,1]]},[0,0,0,2]],"j":[{},[0,2,1,2]],"l":[{"k":[{},[0,2,1]]}],"p":[{"e":[{},[0,0,0,2]]}],"r":[{},[0,2,1,2]]}],"á":[{"b":[{},[1,2]],"h":[{},[1,2]],"i":[{},[1,2]],"n":[{".":[{},[0,2]],"á":[{},[0,2]]}],"r":[{"a":[{},[0,2]]}],"s":[{"z":[{},[0,0,0,2,3]]}],"t":[{".":[{},[0,2]],"ó":[{},[0,2]]}],"v":[{},[1,2]]}],"b":[{"r":[{},[0,0,1]]}],"e":[{"i":[{},[0,0,0,2]],"l":[{},[0,2,1,2]],"m":[{"e":[{"l":[{},[0,0,0,2,1,2]]}]}],"s":[{"i":[{"r":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]],"z":[{"á":[{},[0,0,0,2]]}]}],"t":[{"o":[{},[0,0,0,0,0,1]]}]}],"é":[{"l":[{"e":[{},[0,2,1]]},[0,0,0,2]],"v":[{"a":[{},[0,0,0,0,1]],"á":[{},[0,0,0,2,1]]}]}],"i":[{"g":[{"a":[{},[0,2,1]]},[0,0,0,2]],"n":[{"g":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{"a":[{},[0,0,0,0,1,2]],"e":[{"l":[{},[0,0,0,2]]}]}]}],"o":[{"k":[{"t":[{},[0,2,1]]}],"l":[{"t":[{},[0,0,1]]},[0,2]],"r":[{"a":[{},[1,2]],"e":[{},[1,2]],"é":[{},[1,2]]}]}],"ö":[{"k":[{},[0,0,1]],"s":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"ú":[{"j":[{},[0,2]]}],"ü":[{"g":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"o":[{"á":[{"z":[{},[0,0,2]]}],"b":[{"e":[{},[0,0,2]],"j":[{},[2,1]]}],"d":[{"ú":[{},[2,1,2]]}],"e":[{"t":[{},[0,0,2]]}],"k":[{"a":[{".":[{},[0,1,2]],"d":[{},[0,0,0,1,2]],"i":[{},[0,1,2]],"l":[{},[2,1,2,1,2]]}],"á":[{},[2,1,2]],"i":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"l":[{"á":[{},[0,0,0,0,0,2]]}],"m":[{},[2,1]],"o":[{"k":[{},[0,1,2]],"s":[{},[2,1,2]],"t":[{},[0,1,2]],"z":[{},[2,1,2]]}],"t":[{"a":[{},[2,1]]}]}],"l":[{"a":[{"j":[{},[2,1,2]],"l":[{},[0,0,2,1,2]]}],"d":[{"a":[{},[2,1]],"á":[{},[2,1]],"ó":[{},[2,1]]}],"f":[{"a":[{},[0,0,0,2,1]],"e":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2]]}]}],"i":[{"m":[{},[0,0,2]]}],"ó":[{"r":[{"á":[{},[0,0,2,1,2]]}]}],"t":[{"a":[{"l":[{"o":[{},[2]]}]}],"á":[{"r":[{},[2,1]],"s":[{},[2,1]]}],"ó":[{".":[{},[2,1]]}],"v":[{},[2,1]]}],"v":[{"a":[{"d":[{},[2]],"s":[{},[2]]}]}]}],"m":[{"a":[{"s":[{},[0,0,2,1]]}],"b":[{"á":[{"r":[{"n":[{},[0,0,0,2,1]],"t":[{},[0,0,0,2,1]]}]}],"e":[{},[0,0,0,2,1,2]]},[3,2]],"e":[{},[3,2]],"l":[{},[2,1]]}],"n":[{"a":[{"t":[{"o":[{},[0,0,2,1,2]]}]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}]}],"c":[{"c":[{},[0,0,0,0,3]]}],"d":[{"á":[{},[0,0,0,2,1,2]],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"i":[{"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"o":[{"k":[{"s":[{},[0,0,0,2]]}],"r":[{},[0,0,0,2,1]]}],"ó":[{},[0,0,0,2]]}],"e":[{},[0,0,2,1,2]],"g":[{"a":[{},[0,0,0,2,1]],"á":[{"l":[{},[0,0,0,2]]}]}],"o":[{"l":[{},[0,0,2]]},[0,2]],"t":[{"o":[{},[2,1]]}],"ü":[{},[0,0,2]],"y":[{"e":[{},[0,0,2]]}]}],"o":[{"d":[{},[0,0,2]]}],"p":[{"á":[{},[0,0,2]],"e":[{},[2,1,2]]}],"r":[{"a":[{"s":[{"s":[{},[0,0,0,1]],"z":[{},[0,0,0,0,0,0,2]]}],"t":[{},[0,0,0,0,1,2]]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}]}],"c":[{},[2,1]],"e":[{"l":[{},[0,0,2,1]]}],"i":[{"e":[{},[2]]}],"m":[{},[2,1]],"o":[{"z":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"z":[{},[2]]}],"s":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]],"t":[{"o":[{},[2]],"r":[{},[2,1]],"y":[{},[0,1]]}],"ü":[{},[0,0,2]],"z":[{"a":[{},[0,0,2,3]],"á":[{},[0,0,2,3]],"ó":[{},[0,0,2]]}]}],"u":[{"a":[{},[0,0,2]],"b":[{},[0,0,2]],"d":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"v":[{"á":[{"c":[{},[0,0,2]]}],"e":[{},[2,1,2]]}],"x":[{"i":[{},[0,0,2]]}],"y":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]]}]},[1]],"ó":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"h":[{},[0,0,2,3]],"o":[{"l":[{},[0,0,2,1]]}],"s":[{"a":[{"p":[{"á":[{"g":[{},[0,0,0,0,0,2,1]]},[0,0,0,0,0,0,0,2]]}]}]}],"ü":[{},[0,0,2]]}],"d":[{"á":[{"n":[{},[2,1,2]]}],"i":[{"v":[{},[0,0,2]]}],"r":[{"u":[{},[0,0,1]]}]}],"f":[{"r":[{},[0,0,1,2]]}],"í":[{"v":[{},[0,0,0,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{"é":[{},[0,0,1]]}]}],"l":[{"a":[{"r":[{},[0,0,2]]}],"e":[{"l":[{"ő":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"é":[{"h":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"n":[{"u":[{},[2,1,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"a":[{"d":[{},[0,1,2]],"s":[{},[0,1,2]]}],"á":[{"k":[{"a":[{},[0,0,2]]}],"r":[{},[0,0,2]]}],"o":[{},[3,2]]}],"s":[{"a":[{"j":[{},[0,0,2,1]]},[3,2]],"k":[{"á":[{},[0,0,1,2]]}],"p":[{},[0,0,1,2]],"r":[{"á":[{},[0,0,1,2]]}],"s":[{},[0,0,0,3]],"t":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1]],"r":[{},[0,0,1]]}],"z":[{"á":[{"m":[{},[0,0,2,3]],"r":[{"a":[{"s":[{},[0,0,2,3]]}],"á":[{},[0,0,2,3]],"ú":[{},[0,0,0,3]]}]}]},[0,0,1,0,2]]}],"t":[{"a":[{"u":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2,1]]}],"r":[{"é":[{},[0,0,1]],"i":[{},[0,0,1]]}]}],"v":[{"a":[{"l":[{},[3,2]]}],"o":[{"d":[{},[2]]}],"ó":[{},[2,1,2]],"u":[{},[0,0,2]]}],"z":[{"á":[{},[3,2]],"i":[{},[3,2]],"o":[{},[3,2]],"u":[{},[3,2]]}]},[1]],"ö":[{"b":[{"l":[{},[2,1]]}],"k":[{"o":[{},[2,1,2]],"u":[{},[0,0,2]]}],"l":[{"á":[{},[2,1,2]],"b":[{},[2,1]],"e":[{},[0,1,2]],"r":[{},[2,1]]}],"m":[{"b":[{"a":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]},[3,2]],"l":[{},[2,1]]}],"n":[{"a":[{},[2,1,2]],"á":[{},[0,1,2]],"e":[{},[0,0,2]],"ö":[{},[0,0,2]],"t":[{},[2]]}],"r":[{"a":[{},[0,0,2]],"b":[{},[3,2]],"c":[{"s":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2]]}],"ő":[{},[0,0,0,2]]}]},[3,2]],"d":[{"í":[{},[3]],"ü":[{},[3]]}],"e":[{},[2,1,2]],"g":[{},[3,2]],"n":[{},[3,2]],"ö":[{"k":[{},[0,0,2]]}],"ü":[{},[0,1,2]],"v":[{},[2]]}],"s":[{"é":[{"n":[{},[0,0,2,1]]},[0,0,0,0,2]],"s":[{"z":[{},[2,1]]}],"z":[{},[2,1]]}],"t":[{"l":[{},[2,1]]}],"v":[{".":[{},[0,1]],"b":[{},[0,1]],"e":[{},[0,1,2]],"é":[{},[0,1,2]],"h":[{},[0,1]],"n":[{},[0,1]],"ö":[{},[0,1,2]],"r":[{},[0,1]],"t":[{},[0,1]],"ü":[{},[0,1,2]],"ű":[{},[0,1,2]],"v":[{},[0,1]]}]},[1]],"ő":[{"a":[{"n":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]]}],"b":[{"r":[{},[0,0,1]]}],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"b":[{},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"ő":[{},[0,0,2,1,2]]}],"i":[{"t":[{"a":[{},[0,0,0,2]]}]}],"k":[{"l":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{"y":[{"á":[{},[0,0,0,0,0,2]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{".":[{},[2,1]],"b":[{},[0,1]],"h":[{},[0,1]],"i":[{"t":[{},[0,2]],"z":[{},[0,0,2]]}],"j":[{},[2,1]],"k":[{},[0,1]],"l":[{},[2,1]],"n":[{},[0,1]],"ö":[{"k":[{},[0,0,2]]}],"r":[{},[2,1]],"s":[{},[0,1]],"t":[{},[0,1]],"ü":[{},[2,1,2]],"z":[{"ő":[{"s":[{"ö":[{},[3]]}]}]},[2,1]]}],"s":[{"e":[{"p":[{},[0,0,2,1]]}],"i":[{"b":[{},[0,0,2]]}],"p":[{"i":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]]}],"ü":[{"v":[{},[0,0,2,1,2]]}]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"t":[{},[0,0,0,2]]}],"ü":[{"l":[{},[0,0,0,2]]}],"z":[{"á":[{"t":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]]}],"o":[{},[0,0,2,1]],"ő":[{"s":[{},[0,0,0,0,2]]}],"s":[{"ö":[{},[0,0,2]],"u":[{},[0,0,2,3]],"ű":[{},[0,0,2,3]]}],"ú":[{},[0,0,2]]}]},[1]],"p":[{"e":[{"c":[{"h":[{},[0,0,0,2,3]]}],"l":[{"u":[{},[0,0,1,2]]}]}],"i":[{"a":[{"c":[{"i":[{"o":[{},[0,0,0,0,2,1,2]]}]}]}]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"u":[{},[0,0,2]]}],"o":[{"n":[{"g":[{"a":[{},[0,0,0,0,2]]}]}],"r":[{"e":[{},[0,0,0,2]]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}]}],"r":[{"a":[{"f":[{"f":[{},[1]],"o":[{},[0,0,0,0,0,1]]}],"m":[{"a":[{"d":[{},[0,0,0,2]],"j":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2,1,2]],"s":[{},[0,0,0,2,1]],"z":[{},[0,0,0,0,1,2]]}],"á":[{},[0,0,0,2,1,2]],"e":[{},[0,0,0,2,1,2]],"é":[{"r":[{"t":[{"é":[{},[0,0,0,2,1]]}]}]}],"i":[{"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]}],"m":[{"j":[{},[1]]}],"u":[{"t":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"p":[{},[1,2,0,1]],"v":[{"í":[{},[1,2]]}]}],"á":[{"c":[{"s":[{"i":[{},[0,0,0,2,0,1]]}]}],"f":[{"a":[{"n":[{},[1,2,0,2,1]]},[0,0,0,0,0,2]],"b":[{},[1,2]],"e":[{},[0,0,0,2,1,2]],"f":[{"e":[{},[1,2]]}],"i":[{"d":[{},[1]]}],"l":[{},[1,2]],"t":[{},[1,2]]}],"l":[{"á":[{"t":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]]}],"n":[{"á":[{},[0,2]],"d":[{},[0,0,0,0,1]],"i":[{},[0,2]]}],"r":[{"á":[{},[0,0,0,2]],"i":[{"p":[{},[0,0,0,2,1,2]]}]}],"s":[{"z":[{"a":[{},[0,0,0,2,3]]}]}]}],"e":[{"e":[{},[0,0,0,2]],"n":[{"d":[{"ő":[{},[0,0,0,0,2,1,2]]}]}]}],"i":[{"l":[{"l":[{"a":[{},[0,0,0,0,2,1]]}]},[0,2]],"s":[{"á":[{},[0,0,0,2,1]],"s":[{},[0,0,0,0,3]],"ü":[{"t":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}]}],"í":[{"z":[{},[0,2]]}],"ó":[{"a":[{},[0,0,0,0,2]],"á":[{},[0,0,0,0,2]],"f":[{"a":[{},[0,0,0,2,1]],"ú":[{},[0,0,0,2]]}],"p":[{},[0,0,0,1]]}],"u":[{"p":[{},[1,2]]}]}],"s":[{"á":[{"g":[{"g":[{},[0,0,0,0,1]]}]}],"é":[{"g":[{"e":[{"l":[{},[0,0,0,2]]}]}]}],"h":[{"o":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"r":[{},[0,0,0,2]]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"m":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]],"u":[{},[0,0,2]]}],"n":[{"á":[{},[0,0,2]]}],"o":[{"k":[{"o":[{},[0,0,0,2,1]]}],"r":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}]}],"p":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"r":[{},[0,0,0,2]]}],"r":[{"á":[{},[0,0,2]]}],"t":[{"a":[{},[0,1,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,1,2]],"í":[{},[0,1,2]],"o":[{},[0,0,0,0,2]],"r":[{"a":[{},[0,1]],"u":[{},[0,1]]},[0,0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,1,2]]}],"u":[{"g":[{"á":[{},[0,0,0,0,0,2]]}]}],"v":[{"é":[{},[0,0,2]]}],"z":[{"a":[{"k":[{"é":[{},[0,0,0,0,2]],"ü":[{},[0,0,0,0,2,1]]}]}],"á":[{"l":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}],"i":[{},[0,0,0,0,2]]}],"r":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1,2]]}]}]}]}],"c":[{},[0,1,0,2]],"é":[{"t":[{},[0,0,0,0,2]]}],"f":[{},[0,1,0,2]],"k":[{},[0,1,0,2]],"l":[{},[0,1,0,2]],"m":[{},[0,0,0,2]],"p":[{},[0,1,0,2]],"t":[{"á":[{},[0,1,0,2]]},[0,0,0,0,2]]}]}],"t":[{"a":[{"g":[{"a":[{"r":[{},[0,0,0,2,1]]}],"g":[{},[0,0,0,0,1]]}],"n":[{"ó":[{},[0,0,0,2,1,2]]}]}],"á":[{"r":[{"a":[{"d":[{"a":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}]}],"e":[{"r":[{"m":[{"o":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,2]]}]},[0,0,0,0,0,0,1]]}]}]}],"é":[{"r":[{"á":[{},[0,0,0,2]]}]}],"i":[{"m":[{},[0,0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"ű":[{"z":[{"ő":[{"r":[{},[0,0,0,2,1,2]]}]}]}]}],"u":[{"a":[{"t":[{},[0,0,2]],"y":[{},[0,0,2]]}],"b":[{"o":[{},[2,1,2]]}],"e":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,0,2]]}],"g":[{"a":[{},[0,1,2]],"g":[{},[3,2]],"o":[{},[0,1,2]],"r":[{},[2,1]]}],"i":[{"d":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"j":[{"j":[{},[2,1]]}],"l":[{"a":[{"t":[{"e":[{},[0,0,0,0,2]],"í":[{},[0,0,0,0,2,1]]}]}]}],"n":[{"á":[{},[0,0,2]],"i":[{},[2,1,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"í":[{},[3,2]]}],"s":[{"a":[{"b":[{"l":[{},[0,0,0,1]]}],"d":[{},[0,0,2]],"n":[{},[0,0,2,1,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"é":[{"r":[{"t":[{"é":[{},[0,0,2,1]]}]}]}],"i":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{},[0,0,2,1]],"o":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,0,0,2]]},[0,0,0,3,2]],"t":[{},[0,0,0,0,2]],"ü":[{},[0,0,2]],"z":[{"á":[{},[0,0,2]],"s":[{},[0,0,0,3]]}]}],"t":[{"a":[{"c":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]],"z":[{},[0,0,2]]}],"c":[{},[2,1]],"ó":[{"d":[{"o":[{"k":[{"u":[{},[0,0,0,0,2,1,2]]}]}]}]},[2,1,2]],"u":[{},[2,1,2]]}],"y":[{"a":[{},[0,0,1]]}]},[1]],"ú":[{"j":[{"a":[{},[0,0,2]],"í":[{},[0,0,2]],"u":[{},[0,0,2]]}],"n":[{"y":[{"e":[{},[0,0,2,0,1]],"í":[{},[0,0,2,0,1,2]]}]}],"r":[{".":[{},[2,1]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"n":[{},[2,1]],"o":[{},[0,0,2]]}],"s":[{"z":[{},[2,1,2]]}],"t":[{"a":[{},[2,0,2,1,2]],"á":[{},[2,1,2,1,2]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{},[2,1,2,1,2]],"é":[{},[2,1,2]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{".":[{},[2,1,2]],"a":[{},[2,1,2]],"g":[{},[2,1,2]],"h":[{},[2,1,2]],"j":[{},[2]],"k":[{"o":[{},[2]]}],"n":[{"a":[{},[2,1,2]],"á":[{},[2]]}],"r":[{},[2]],"s":[{},[0,0,2]],"t":[{},[2,1,2]],"v":[{},[2,1,2]],"z":[{},[2]]}],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{},[2,1,2]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2]],"v":[{},[2,1]],"z":[{},[2,1]]}],"z":[{"i":[{},[0,0,2]]}]},[1]],"ü":[{"c":[{"s":[{},[0,0,2]]}],"d":[{"é":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"y":[{"é":[{"r":[{".":[{},[0,0,0,0,1]]}]}],"i":[{},[2,1,2]],"l":[{},[2,1]],"v":[{},[2,1]]}]}],"l":[{"d":[{},[2,1]],"e":[{"n":[{},[0,0,2]],"p":[{},[0,0,2]]}],"i":[{"k":[{},[0,0,2]]}],"ö":[{"m":[{},[0,0,2]]}]}],"n":[{"n":[{},[2,1]]}],"r":[{"c":[{},[3,2]],"e":[{},[2,1,2]],"i":[{},[3,2]],"í":[{},[2,1,2]],"ü":[{},[2,1,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]]}]},[1]],"ű":[{"r":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{},[0,0,0,0,2]],"h":[{},[0,1]],"i":[{},[0,0,2]],"j":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"ö":[{},[2,1,2]],"t":[{},[2,1]],"u":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[1]],"v":[{"a":[{"s":[{"u":[{},[0,0,0,2,1,2]]}]}],"á":[{"g":[{"y":[{"a":[{"d":[{"a":[{},[0,0,0,2,0,1,2]]}]}]}]}],"n":[{"y":[{"a":[{"n":[{},[0,0,0,2]]}]}]}],"s":[{"s":[{},[0,0,0,0,1]]}]}],"e":[{"r":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,0,3]]}]}]}],"z":[{"é":[{"r":[{"e":[{"l":[{},[0,0,0,0,0,2]]}]}]}]}]}],"é":[{"n":[{"y":[{"e":[{"l":[{},[0,0,0,2]]}]}]}]}],"i":[{"n":[{"a":[{},[0,0,0,2]]}]}],"ó":[{"s":[{},[0,0,0,1,2]]}]}],"y":[{"a":[{"b":[{"l":[{},[0,0,1]]}],"c":[{"é":[{},[2,0,1,2]]}],"d":[{"a":[{"g":[{},[2]],"l":[{},[0,0,0,2]],"t":[{"b":[{},[2]]}]}],"ó":[{"t":[{},[0,0,1,2]]}]}],"g":[{".":[{},[2]],"b":[{},[2]],"e":[{},[0,0,0,2]],"é":[{"p":[{},[0,0,0,2]]}],"g":[{},[2]],"h":[{},[2]],"i":[{"s":[{},[0,0,0,2]]}],"k":[{},[2]],"n":[{},[2]],"o":[{"l":[{},[0,0,0,2,1]]}],"t":[{},[2]],"y":[{"a":[{},[2]],"u":[{},[0,0,1,2]]}]}],"j":[{"a":[{},[2,0,1]]}],"k":[{"c":[{},[2,0,1]],"n":[{"á":[{"k":[{},[2]]}]}],"t":[{".":[{},[2]],"u":[{},[2]]}]}],"l":[{"a":[{"j":[{},[0,0,0,2]],"k":[{"t":[{},[0,0,0,0,1]]}],"p":[{"o":[{},[0,0,0,2]],"p":[{},[0,0,0,2]]}],"t":[{},[0,0,1]]}],"á":[{"í":[{},[2]]}],"e":[{"l":[{},[0,0,0,2]]}],"i":[{"k":[{},[0,0,0,2]]}]}],"n":[{"a":[{"b":[{},[0,0,0,0,1]]}],"e":[{},[0,0,0,2,1]],"y":[{"a":[{},[2,0,1,2]],"á":[{},[0,0,1,2]]}]}],"p":[{"a":[{"k":[{},[0,0,0,2]]}],"á":[{"h":[{},[0,0,1,2]],"i":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2,0,1,2]],"s":[{},[0,0,1,2]],"t":[{"ó":[{},[2]]}]}],"j":[{"á":[{},[2]]}],"ó":[{"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"p":[{},[2]],"s":[{},[0,0,1]]}],"r":[{"a":[{"n":[{},[0,0,1]],"w":[{},[2]]}],"d":[{"o":[{"m":[{},[2]]}]},[0,0,0,0,0,2]],"e":[{"l":[{},[0,0,0,2]]}],"g":[{"ó":[{},[0,0,1]]}],"i":[{},[3]],"ó":[{"n":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1,2]],"v":[{},[0,0,0,2]]}],"ú":[{},[2]]}],"s":[{"a":[{"k":[{},[2]],"t":[{},[2]]}],"r":[{"a":[{},[2]]}]}],"t":[{"y":[{},[2]]}],"z":[{"á":[{},[2]]}]},[1]],"á":[{"b":[{"r":[{},[2]]}],"g":[{},[2,0,1]],"l":[{"c":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]]}],"m":[{},[3]],"p":[{},[2,0,1]],"r":[{"e":[{},[2]],"f":[{},[2]],"o":[{"k":[{},[2,0,1,2]]}],"u":[{"s":[{},[2]]}],"ú":[{},[2,0,1]]}],"s":[{"z":[{"ó":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[2]],"k":[{},[2]],"l":[{},[0,0,1]],"v":[{},[2]]}]},[1]],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"d":[{"ő":[{"s":[{},[0,0,0,2,1]]}],"z":[{},[2,0,1,2]]}],"g":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"y":[{"e":[{},[0,0,1,2]]}]}],"k":[{"e":[{".":[{},[2]]}],"é":[{"s":[{},[2,0,1,2]]}]}],"l":[{"e":[{"g":[{"y":[{},[0,0,0,2]]},[2]],"m":[{"ű":[{},[2]]}]}],"n":[{"ö":[{},[2]]}],"t":[{"é":[{"r":[{},[2]]}]}],"v":[{"á":[{},[2,0,1]],"ű":[{},[0,0,1]]}]}],"m":[{"b":[{"l":[{},[2]]}],"e":[{"l":[{},[2,0,1,2]]}],"l":[{},[0,0,1]]}],"n":[{"g":[{"e":[{"t":[{},[2]]}]}],"y":[{},[2,0,1,2]],"z":[{},[2]]}],"p":[{"a":[{"l":[{},[0,0,0,2]]}]}],"r":[{"d":[{},[2,0,1]],"e":[{"d":[{},[0,0,1,2]],"j":[{},[2]],"s":[{},[0,0,1,2]]}],"é":[{"n":[{},[0,0,0,2]]}],"n":[{},[2,0,1]],"o":[{},[2]],"ő":[{},[2,0,1,2]],"s":[{},[2,0,1]]}],"s":[{"e":[{"g":[{},[0,0,0,2]]}],"é":[{"l":[{},[2]]}],"g":[{},[2]],"ő":[{},[0,0,1,2]],"t":[{"e":[{},[2,0,1]],"é":[{"s":[{},[2]]}],"i":[{},[2,0,1]],"ű":[{},[2]]}],"z":[{"ü":[{},[0,0,0,2]]}]}],"t":[{"e":[{"m":[{},[2]],"t":[{},[2]]}]}],"z":[{"m":[{},[2]],"r":[{"e":[{"d":[{"e":[{},[2]]}],"l":[{},[2]]}]}],"s":[{},[2]]}]},[1]],"é":[{"b":[{"r":[{},[2]]}],"g":[{},[2,0,1]],"h":[{"e":[{"s":[{},[2]]}],"s":[{},[2]]}],"j":[{"i":[{},[2]]}],"k":[{"e":[{".":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}]}],"l":[{"e":[{},[2,0,1,2]],"t":[{},[2,0,1]],"v":[{},[0,0,1]]}],"m":[{},[3]],"n":[{"e":[{"k":[{"e":[{},[2]]}]}],"i":[{},[2]]}],"p":[{},[2,0,1]],"r":[{".":[{},[2]],"d":[{},[2,0,1]],"e":[{"m":[{},[2,0,1]],"z":[{},[2]]}],"é":[{"t":[{},[0,0,0,2]]}],"g":[{},[0,0,1]],"h":[{},[2,0,1]],"i":[{},[2,0,1,2]],"í":[{},[3]],"k":[{"e":[{},[0,0,1]]}],"m":[{},[2,0,1]],"n":[{},[2]],"r":[{},[2]],"t":[{"e":[{},[2,0,1]],"é":[{},[2,0,1]],"ő":[{},[0,0,1]]}],"v":[{},[2,0,1]],"z":[{},[2,0,1]]}],"t":[{"é":[{},[2,0,1]],"k":[{},[2]]}],"v":[{".":[{},[2]],"a":[{"d":[{},[2]]}],"b":[{},[2]],"e":[{".":[{},[2]],"i":[{},[2]],"k":[{},[2]],"n":[{},[2]],"s":[{},[2]],"t":[{},[2]]}],"h":[{},[2]],"i":[{},[2]],"n":[{},[2]],"r":[{},[2]],"t":[{},[2]],"ü":[{},[2]],"v":[{},[2]]}]},[1]],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[2,0,1]],"é":[{},[2]],"ő":[{},[2]]}],"g":[{"a":[{},[2]],"á":[{},[2]],"e":[{},[2,0,1]],"é":[{},[2,0,1,2]],"m":[{},[2]]}],"h":[{"a":[{},[0,0,1]]}],"k":[{"e":[{"r":[{},[2]]}]}],"l":[{"l":[{},[2,0,1]]}],"m":[{"á":[{},[2]]}],"n":[{"d":[{},[2]],"f":[{},[2]],"g":[{},[2,0,1]]}],"p":[{"a":[{},[2,0,1]]}],"r":[{"a":[{"t":[{},[2,0,1,2]]}],"á":[{},[2]],"o":[{},[2,0,1]],"t":[{},[2]]}],"s":[{"h":[{},[2]],"k":[{},[0,0,1]],"m":[{},[2]],"n":[{},[2,0,1]]}],"t":[{"a":[{},[2,0,1]]}],"v":[{"ó":[{},[2]]}],"z":[{"g":[{},[2]],"o":[{},[2,0,1,2]]}]},[1]],"í":[{"g":[{},[2,0,1]],"r":[{},[2,0,1,2]],"v":[{},[2,0,1]],"z":[{},[0,0,1]]},[1]],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"m":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"o":[{"k":[{"o":[{"s":[{},[2]]}]}],"l":[{"d":[{},[2,0,1]],"v":[{"a":[{"s":[{},[2]]}]}]}],"m":[{"a":[{"s":[{},[0,0,0,2,1]]}],"i":[{},[0,0,0,2]]}],"p":[{"e":[{},[2]]}],"r":[{"c":[{},[2,0,1]],"m":[{},[0,0,1]],"s":[{"ó":[{},[2]]}],"v":[{},[2,0,1]]}],"u":[{},[0,0,1]]},[1]],"ó":[{"d":[{"á":[{"r":[{},[2]],"s":[{"a":[{"k":[{},[2]]}]}]}]}],"r":[{"á":[{},[0,0,1,2]],"i":[{},[2]]}]},[1]],"ö":[{"b":[{},[2,0,1]],"d":[{"é":[{},[0,0,1]]}],"k":[{"l":[{},[2,0,1]]}],"t":[{"ö":[{"d":[{".":[{},[2]],"d":[{},[2]],"e":[{},[2]],"é":[{},[2]],"n":[{"e":[{},[2]]}],"ö":[{"t":[{},[2]]}],"r":[{},[2]],"ü":[{},[2]]}]}],"t":[{},[2]],"v":[{},[2]]}],"v":[{},[2]],"z":[{"ö":[{"n":[{},[2]]}]}]},[1]],"ő":[{"r":[{"e":[{},[0,0,1]],"ü":[{},[0,0,1]]}],"s":[{},[2,0,1,2]],"z":[{},[3]]},[1]],"p":[{"á":[{"r":[{"b":[{"a":[{},[0,0,0,0,0,0,0,2]]}]}]}],"e":[{"n":[{},[0,0,0,0,0,1]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"ö":[{"v":[{"i":[{"d":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"s":[{"c":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]],"u":[{"r":[{},[0,0,2]]}]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[2,0,1]],"g":[{},[2,0,1]],"j":[{},[2,0,1]],"n":[{"d":[{},[2]],"i":[{},[2]]}],"r":[{"a":[{},[2,0,1,2]],"á":[{},[2]],"u":[{},[2]]}]},[1]],"ú":[{"d":[{},[2]],"é":[{},[2]],"i":[{},[2]],"j":[{"í":[{},[2]],"r":[{},[2]],"s":[{},[2]]}],"m":[{},[2]],"r":[{"b":[{},[2]],"é":[{},[2]],"i":[{},[2]],"k":[{},[2]],"r":[{},[2]]}],"t":[{"i":[{},[0,0,1]]}],"ü":[{},[2]]},[1]],"ü":[{"d":[{},[2,0,1]],"g":[{},[2]],"l":[{"e":[{},[3]]}],"m":[{},[3]],"n":[{"n":[{},[2]]}],"r":[{"e":[{},[2]],"ü":[{},[2]]}],"s":[{"t":[{},[0,0,1]]},[2]],"t":[{},[2]],"v":[{"e":[{},[0,0,1]]},[2]],"z":[{},[2,0,1]]},[1]],"ű":[{"l":[{},[3]],"r":[{"é":[{".":[{},[2]]}]}],"z":[{},[2,0,1,2]]},[1]],"z":[{"r":[{},[0,0,1]]}]},[0,2]],"z":[{"a":[{"t":[{"á":[{"p":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"ö":[{},[0,0,0,2]],"ű":[{},[0,0,0,2,1,2]]}]}],"á":[{"r":[{"ó":[{"r":[{},[0,0,0,2,1,2]]}]}],"s":[{"e":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]]}]}],"e":[{"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1,2]],"e":[{"l":[{},[0,0,0,2,1]]}],"i":[{"n":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2,1]],"ő":[{},[0,0,0,2,1,2]]}]}],"ő":[{"a":[{},[0,0,0,0,2]]}]}]}],"h":[{".":[{},[2]],"a":[{"a":[{"d":[{},[0,0,0,2]]}],"b":[{".":[{},[3]],"a":[{"k":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]]}],"á":[{"g":[{},[0,0,2,1]],"r":[{"b":[{},[0,0,2,1]]}]}],"e":[{"d":[{},[0,0,2]]}],"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2]],"l":[{"l":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1]],"n":[{"a":[{".":[{},[0,0,2,1,2]]}],"t":[{},[0,0,2,1]]}]}],"o":[{"l":[{"d":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1]]}],"s":[{"t":[{},[0,0,2,1]]}]},[3]],"s":[{"z":[{},[0,0,0,1]]}],"u":[{"r":[{},[0,0,0,0,2]]}],"ü":[{},[0,0,2]]}],"d":[{"a":[{"g":[{},[0,0,2,1]],"l":[{"k":[{},[0,0,0,1]]}],"p":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"á":[{"c":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]],"s":[{"s":[{},[0,0,0,0,0,1]],"v":[{},[0,0,2,1]],"z":[{"o":[{},[0,0,2,1,2]]}]}]}],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2]]}],"é":[{"l":[{},[0,0,2]]}],"i":[{"a":[{},[0,0,0,0,0,2]],"é":[{},[0,0,0,0,0,2]],"n":[{"a":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"o":[{"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"u":[{"r":[{},[0,0,2,1,2]]}],"ú":[{"r":[{".":[{},[0,0,2,1]],"é":[{},[0,0,2,1,2]],"h":[{},[0,0,2,1]],"i":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"s":[{},[0,0,2]]}],"ü":[{},[0,0,2]],"z":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,3]]}]}],"e":[{"r":[{},[0,0,0,2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"o":[{"r":[{"e":[{},[2]]}]}]}],"i":[{"f":[{},[0,0,2]]}],"j":[{"á":[{"s":[{},[0,0,2,1,2]],"t":[{"o":[{},[0,0,2,1,2]]}],"z":[{},[0,0,2]]}],"i":[{"n":[{},[0,0,2,1]]}],"k":[{},[0,0,0,1,2]],"o":[{"m":[{"l":[{},[0,0,0,1]]}]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,0,1,2]]}],"ü":[{},[0,0,2]]}],"k":[{"á":[{"l":[{},[0,0,2,1]]}],"l":[{"i":[{},[0,0,1,2]]}],"r":[{},[0,0,1,2]],"t":[{},[0,1]],"v":[{},[0,0,1,2]]}],"l":[{"a":[{"c":[{"h":[{},[0,0,2,1]]}],"g":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{"z":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1]],"ó":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"t":[{"k":[{},[0,0,2,1]],"o":[{"m":[{},[0,0,2,1,2]]}],"t":[{},[0,0,2,1]]}]}],"á":[{"c":[{"s":[{},[0,0,0,1,2]]}],"g":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,0,0,2,1,2]]}],"r":[{"a":[{"k":[{},[0,0,0,1,2]]}],"á":[{},[0,0,0,1,2]],"b":[{},[0,0,2,1]],"o":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"v":[{"e":[{},[0,0,0,1]]}]}],"t":[{"e":[{},[0,0,0,1]]}]},[3]],"e":[{"b":[{},[0,0,2]],"c":[{},[0,0,2]],"g":[{"y":[{},[0,0,0,1,2]]}],"l":[{"e":[{},[0,0,0,1]],"ő":[{},[0,0,0,1]]},[0,0,0,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2,1]],"p":[{"e":[{},[0,0,0,1]]}],"s":[{"e":[{},[0,0,2,1]],"ő":[{},[0,0,2,1,2]]}],"t":[{"e":[{},[0,0,0,1]],"o":[{},[0,0,0,1,2]]}],"v":[{"o":[{},[0,0,0,1]],"ő":[{},[0,0,0,1,2]]}],"z":[{},[0,0,2]]}],"é":[{"l":[{},[0,0,2,1,2]],"r":[{".":[{},[0,0,2,1]]}],"t":[{"e":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1]],"m":[{},[0,0,2,1,2]],"n":[{"g":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"o":[{"n":[{"o":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}]}],"p":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,1]]},[0,0,0,0,2]],"v":[{},[0,0,2,1]],"z":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"k":[{"a":[{"p":[{"u":[{},[0,0,0,2,1,2]]}]}],"e":[{"l":[{"e":[{},[0,0,0,2,1]]},[0,0,0,0,0,2,1]]}]}],"l":[{"a":[{"s":[{"z":[{"t":[{},[0,0,0,2,1]]}]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}],"t":[{},[0,0,0,2,1,2]]}],"é":[{"j":[{},[0,0,0,2]]}],"y":[{},[0,0,0,3]]}],"m":[{"a":[{"z":[{"ó":[{},[0,0,0,0,0,2,1,2]]}]}]},[3]],"o":[{"l":[{},[0,0,2,1]]}],"ó":[{"r":[{"i":[{},[0,0,2,1,2]]}]}],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2,1,2]],"p":[{},[0,0,0,1,2]],"u":[{"g":[{},[0,0,2,1]],"s":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]],"y":[{"a":[{},[0,0,2,3]]}]}],"m":[{"á":[{"l":[{},[0,0,2,1]],"r":[{"b":[{},[0,0,2,1]]}]}],"b":[{},[0,0,0,0,2]],"e":[{"l":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{"z":[{},[0,0,0,1]]}],"z":[{},[0,0,2]]}],"i":[{"s":[{"m":[{},[0,0,0,1]]}]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"u":[{},[3]],"ü":[{},[0,0,2]]}],"n":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"c":[{"h":[{},[0,0,0,2]]}],"é":[{"s":[{"z":[{},[2]]}]}],"g":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"é":[{"l":[{},[0,0,0,2]]}],"g":[{},[0,0,0,0,3]],"ó":[{},[0,0,0,2,1,2]],"ö":[{},[0,0,0,2]],"u":[{"t":[{},[0,0,0,2]]}]},[3]],"t":[{"ó":[{},[0,0,0,2,1,2]]}],"y":[{"é":[{"l":[{},[0,0,2]]}]}]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"r":[{},[0,0,1,2]]}],"r":[{"a":[{"g":[{"ó":[{},[0,0,0,0,2,1,2]]}],"n":[{"g":[{"g":[{},[0,0,0,0,0,0,1]]}]}]}],"á":[{"l":[{},[0,0,2,1]]}],"c":[{"a":[{"l":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2]]}],"c":[{},[0,0,0,0,3]],"e":[{},[0,0,0,2,1,2]],"h":[{},[0,0,0,2,3]]}],"e":[{"l":[{},[0,0,2]],"t":[{},[0,0,2]]}],"m":[{"ó":[{},[3]]}],"o":[{"l":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2,1]]}],"ű":[{},[0,0,2]]}],"s":[{"a":[{},[3]],"á":[{"g":[{"g":[{},[0,0,0,0,0,1]]}]}],"i":[{"z":[{},[0,0,2,1]]}],"o":[{"l":[{},[0,0,2,1]],"r":[{"s":[{},[0,0,0,1]]}]}],"p":[{"e":[{},[0,0,1,2]],"o":[{},[0,0,1,2]]}],"ú":[{"t":[{},[0,0,3,2]]}],"ü":[{"r":[{},[0,0,2]]}],"ű":[{},[0,0,2,1,2]],"z":[{"p":[{},[0,0,1]]}]}],"t":[{"a":[{"b":[{},[0,0,2,1]],"g":[{"y":[{},[0,0,0,1]]}],"j":[{},[0,0,2,1]]}],"á":[{"r":[{"a":[{"d":[{"a":[{},[0,0,0,0,0,1]]},[0,0,0,0,0,0,2]]}]}]},[3]],"e":[{"v":[{},[0,0,2,1,2]]}],"é":[{"n":[{},[0,0,2,1]],"v":[{},[0,0,2,1,2]]}],"í":[{"v":[{},[0,0,2,1,2]]}],"o":[{"l":[{"d":[{"a":[{},[0,0,0,1]]}]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{"á":[{},[0,0,2,1]]}]}],"ö":[{"v":[{},[0,0,2,1,2]]}],"r":[{"á":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ü":[{"l":[{},[0,0,2]]}]}],"u":[{"e":[{},[0,0,2]],"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"t":[{},[0,0,2]]}],"ü":[{"z":[{},[0,0,0,2]]}]},[1]],"á":[{"b":[{"o":[{},[3]]}],"g":[{"y":[{},[0,0,2]]}],"j":[{"ú":[{"s":[{},[0,0,2]]}]}],"m":[{"a":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2,1]],"e":[{},[0,0,2,1,2]],"i":[{"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"o":[{"l":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]]}],"n":[{"c":[{"s":[{"e":[{},[0,0,0,2,0,1]],"i":[{},[0,0,0,2]]}]}],"y":[{"a":[{"l":[{},[0,0,2,0,1,2]],"n":[{},[0,0,0,0,0,2]],"r":[{},[0,0,2,0,1]]}],"á":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}],"e":[{},[0,0,2,0,1,2]],"ö":[{},[0,0,2]]}]}],"r":[{"a":[{"d":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"u":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"v":[{},[0,0,2,1]]},[0,0,0,0,2]],"í":[{},[3]],"k":[{},[0,0,0,1,2]],"m":[{"a":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"o":[{"m":[{"a":[{},[0,0,0,0,2,1]],"o":[{},[0,0,0,0,2]]}]}],"s":[{"a":[{"l":[{},[0,0,0,2,1]]}],"e":[{},[0,0,0,2]]}],"t":[{},[3]],"ü":[{},[0,0,2]],"y":[{},[0,0,1]]}],"s":[{"í":[{},[0,0,2]],"z":[{"a":[{"t":[{"o":[{"m":[{},[0,0,0,0,1,2]]}]}]}],"e":[{},[0,0,2,0,1]],"i":[{"v":[{},[0,0,2]]}],"k":[{"a":[{".":[{},[2,1]]}]}],"ő":[{},[0,0,2]]}]}],"t":[{"a":[{"d":[{"ó":[{},[0,0,0,1,2]]}],"l":[{"a":[{},[0,0,2,1,2]]}],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2]]}],"á":[{"p":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"é":[{"l":[{},[0,0,2]],"r":[{".":[{},[0,0,2,1]],"e":[{},[0,0,2,1]],"n":[{},[0,0,2,1]]}]},[0,0,0,0,2]],"i":[{"s":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]]}],"ó":[{"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"u":[{"s":[{"z":[{},[0,0,0,1,2]]}]}],"ü":[{},[0,0,2,1]],"ű":[{},[0,0,2]],"v":[{"é":[{"d":[{"e":[{"l":[{},[0,0,0,0,0,2,1]]}]}]}]}]}],"z":[{"a":[{"d":[{"ó":[{},[0,0,2,1,2]]}],"j":[{},[0,0,2]],"l":[{"a":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1]]}],"á":[{"p":[{},[0,0,2,1,2]],"r":[{"n":[{},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}]}],"e":[{},[0,0,2,1,2]],"i":[{"s":[{"k":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2,1]],"o":[{"k":[{"t":[{},[0,0,0,1]]}],"l":[{"d":[{},[0,0,0,1]]}],"s":[{},[0,0,2]],"t":[{"t":[{"h":[{},[0,0,0,1]]}]}]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"a":[{},[0,0,2,3]],"e":[{},[0,0,0,3]],"é":[{},[0,0,2,3]],"i":[{},[0,0,2,3]],"p":[{},[0,0,0,3]],"t":[{},[0,0,0,3]],"ü":[{},[0,0,0,3]],"z":[{},[0,0,0,3]]},[0,0,0,0,2]],"ü":[{},[0,0,2,1]],"y":[{},[0,0,1]]}]},[1]],"b":[{"l":[{"e":[{},[0,0,2]]}]}],"e":[{"a":[{"d":[{},[0,0,2]],"v":[{},[0,0,2]]}],"c":[{"c":[{"e":[{"m":[{"b":[{},[0,0,0,2,1]]}]}],"s":[{},[0,0,0,0,3]]}],"u":[{},[2]]}],"d":[{"é":[{"n":[{},[0,0,2]]}]}],"e":[{"s":[{},[0,0,2,2]]}],"f":[{"i":[{},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}],"g":[{"a":[{},[0,0,2,1,2]],"é":[{"s":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"y":[{"a":[{},[0,0,2,0,1]],"á":[{},[0,0,2]],"e":[{"g":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}],"o":[{},[0,0,2,0,1]],"ó":[{},[0,0,2]],"ő":[{},[0,0,2]],"ú":[{},[0,0,2]]}]}],"i":[{"d":[{"p":[{},[2]]}]}],"k":[{"é":[{"k":[{},[2,1,2]]}],"t":[{},[3]]}],"l":[{"é":[{"g":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"f":[{"r":[{},[0,0,0,2]]},[2]],"l":[{"á":[{},[2]],"e":[{"n":[{},[2]]}]}],"y":[{"e":[{"g":[{},[0,0,2]],"m":[{"l":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}]}],"é":[{"j":[{},[0,0,2,0,1,2]]}]}]}],"m":[{"a":[{},[2]],"b":[{"l":[{},[2,1]]}],"l":[{},[2,1]]}],"n":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"g":[{},[3]],"y":[{"e":[{"g":[{"e":[{".":[{},[0,0,2,0,1,2]]}]}]}],"o":[{},[0,0,2]]}]}],"o":[{"l":[{},[0,0,2]]}],"r":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]],"u":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,0,0,1,0,1,2]],"é":[{},[0,0,0,1]]}]}],"e":[{"n":[{"g":[{},[0,0,0,1]]}],"p":[{},[0,0,0,0,1]],"s":[{"e":[{},[0,0,0,1]]}],"v":[{"í":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"i":[{"n":[{"t":[{},[0,0,0,1]]}]}],"ö":[{},[0,0,2]],"s":[{},[0,0,0,1,2]],"u":[{"t":[{},[0,0,2]]}],"ű":[{},[0,0,2]]}],"s":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1]],"é":[{"s":[{},[0,1,2]]}],"t":[{"o":[{},[0,0,0,2,1]]}]}],"t":[{"y":[{},[3]]}],"u":[{"s":[{"z":[{},[2]]}]}],"v":[{"é":[{"s":[{},[0,0,2]]},[2]],"í":[{},[3]]}],"z":[{"á":[{},[0,0,2,1]],"h":[{},[2]],"i":[{},[2]],"n":[{},[2]],"ő":[{},[2]],"z":[{},[2]]}]},[1]],"é":[{"h":[{"é":[{},[0,0,2]]}],"i":[{".":[{},[3]],"t":[{},[3]]}],"j":[{"e":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"ö":[{},[0,0,2]]}],"k":[{"n":[{},[3]]}],"n":[{"a":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"t":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2,1]],"m":[{},[0,0,2]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"é":[{"v":[{".":[{},[0,0,0,1]]}]}],"i":[{"d":[{},[0,0,2]],"l":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"n":[{},[0,0,0,3]],"ö":[{},[0,0,2]],"t":[{},[0,0,0,0,2]],"u":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"p":[{"h":[{},[0,0,1]],"ü":[{},[0,0,2]]}],"r":[{"a":[{"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2]]},[0,0,0,0,2]],"i":[{"n":[{},[0,0,2]]}],"z":[{},[2,1]]}],"s":[{"z":[{"á":[{},[0,0,2]],"e":[{"g":[{},[0,0,2]],"s":[{"z":[{},[0,0,2]]}]}],"ö":[{},[0,0,2,0,1]]}]}],"t":[{"a":[{"b":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2]],"r":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{"l":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]],"z":[{"r":[{"e":[{"s":[{},[0,0,2,1]]}]}]}]}],"é":[{"v":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"ó":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"ö":[{},[0,0,2,1]],"u":[{},[0,0,2]],"ü":[{},[0,0,2,1,2]]}],"v":[{"á":[{},[0,0,2,1]],"e":[{".":[{},[0,0,2]]}],"é":[{"g":[{},[0,0,2]],"r":[{"z":[{},[0,0,2,1]]}]}]}],"z":[{"e":[{"k":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"o":[{},[0,0,2]],"p":[{},[0,0,2]]}],"o":[{},[0,0,0,0,2]],"s":[{},[0,0,2,3]]}]},[1]],"f":[{"l":[{"ó":[{},[0,0,2]]}]}],"i":[{"a":[{".":[{},[2]],"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{"e":[{"l":[{"i":[{"e":[{},[0,0,2]]}]}]}]}],"c":[{},[0,0,2]],"d":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"g":[{},[0,0,2]],"h":[{},[0,0,2]],"j":[{},[0,0,2]],"l":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{"t":[{},[0,0,2]]}],"p":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"d":[{"a":[{},[3]],"r":[{"o":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"é":[{"v":[{},[2]]}],"g":[{"a":[{"n":[{"y":[{"e":[{},[0,0,0,0,2]]}]}]}],"i":[{},[3]]}],"l":[{"a":[{},[2]]}],"m":[{".":[{},[2]],"e":[{},[2]],"é":[{},[2]]}],"n":[{"á":[{"n":[{},[2,1,2]],"s":[{},[3]]}],"g":[{".":[{},[0,1]]},[2]],"k":[{},[2]],"s":[{"p":[{},[0,1]]}]}],"o":[{"m":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,2]],"s":[{".":[{},[0,1]],"e":[{},[0,1]],"é":[{},[0,1]],"h":[{},[0,1]],"r":[{},[0,1]],"s":[{},[0,1]],"z":[{"e":[{"s":[{},[0,0,0,0,0,0,0,1]]}]}]},[2]]}],"s":[{"e":[{".":[{},[0,0,2]]},[2]],"n":[{},[2]],"o":[{},[2]]}],"t":[{"a":[{"k":[{},[0,0,0,1]],"l":[{},[0,0,0,0,2]],"n":[{},[0,0,0,1,2]]},[0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{"y":[{},[0,0,2,1,2]]}],"l":[{"e":[{"l":[{},[0,0,0,0,2,1,2]],"s":[{"é":[{},[0,0,2,1]]}]}],"ő":[{},[0,0,2,1]],"v":[{"e":[{".":[{},[0,0,2,1]]}]}]},[3]],"n":[{"g":[{},[0,0,2,1]]}],"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}],"t":[{},[3]]}],"é":[{"l":[{},[0,0,2]],"r":[{".":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1]]}],"t":[{"e":[{},[0,0,2,1,2]]}],"v":[{"e":[{".":[{},[0,0,2,1,2]]}]}]}],"i":[{"m":[{},[0,0,2,1]],"n":[{"t":[{},[0,0,2,1]]}]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"o":[{},[0,0,2,1]],"ó":[{"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"ö":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"ő":[{"r":[{},[0,0,2,1]]}],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]],"ü":[{"l":[{},[0,0,2]]}]}],"z":[{"o":[{},[0,0,2]]}]},[1]],"í":[{"d":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2,1]]}],"j":[{"é":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2,1]],"m":[{"b":[{},[0,0,2,1]]}],"r":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"i":[{"n":[{"g":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2]],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2,1,2]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1]],"u":[{},[0,0,2,1]],"ú":[{},[0,0,2]]}]},[1]],"k":[{"a":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"á":[{"r":[{},[0,0,0,2]]}],"r":[{"i":[{},[0,0,2]]}]}],"l":[{"e":[{"g":[{"e":[{"l":[{"é":[{},[0,0,0,2,1,2]]}]}]}],"t":[{"e":[{"l":[{},[0,0,0,2,1]]}],"ö":[{},[0,0,0,2]]}]}]}],"o":[{"d":[{"ú":[{},[0,0,2]]}],"e":[{"á":[{},[2,0,2]],"f":[{},[0,0,2]]}],"i":[{"i":[{},[0,0,2]],"t":[{},[0,0,2]]}],"k":[{"l":[{},[2]]}],"l":[{"a":[{"d":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2]],"t":[{},[0,0,2,1]],"u":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]]}],"d":[{"á":[{},[0,0,0,2]],"e":[{"m":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2,1,2]]}]}],"e":[{},[0,0,2,1,2]],"i":[{"g":[{},[0,0,2]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2]],"v":[{},[0,0,2,1,2]]}],"k":[{},[0,0,0,1,2]],"m":[{"e":[{"s":[{},[0,0,0,2]]}]}],"n":[{"i":[{"k":[{},[0,0,0,2]]}]}],"o":[{"r":[{},[0,0,2]],"s":[{"z":[{},[0,0,2,1]]}],"t":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ö":[{},[0,0,2]],"t":[{"a":[{"n":[{"y":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"ü":[{},[0,0,2]],"y":[{"a":[{"l":[{},[0,0,2,0,1]]}]}]}],"m":[{"b":[{},[3]],"o":[{"s":[{},[0,0,0,0,1]]},[3]]}],"n":[{"a":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1,2]],"u":[{},[0,0,2,1]],"v":[{},[0,0,2,1,2]]}],"á":[{"l":[{},[0,0,2,1]],"t":[{"a":[{},[0,0,2,1,0,1,2]],"o":[{},[0,0,2,1,2]]}]}],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"k":[{},[0,0,2,1]],"m":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"o":[{"r":[{"j":[{},[0,0,2,1]],"o":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"d":[{"e":[{},[0,0,0,2,1,2]]}],"e":[{},[0,0,2]],"y":[{},[2,0,1]]}],"s":[{"s":[{"z":[{"e":[{},[0,0,0,0,0,1,2]],"é":[{"k":[{},[0,0,0,0,0,1]]},[0,0,0,0,0,0,2]],"ü":[{},[0,0,0,0,0,1,2]]}]}],"z":[{},[2]]}],"t":[{"h":[{},[0,0,1]]}],"u":[{"s":[{},[0,0,2]]}],"w":[{"e":[{},[0,0,2]]}],"z":[{"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1]],"i":[{},[0,0,0,0,2]],"ü":[{},[0,0,2]]}]},[1]],"ó":[{"a":[{"k":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"a":[{"l":[{},[0,0,2]],"t":[{},[0,0,2]]}],"c":[{},[0,0,0,3]],"e":[{"l":[{},[0,0,2]]}],"é":[{"g":[{},[0,0,2,1,2]]}],"h":[{},[0,0,2,3]],"i":[{"m":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"s":[{"ü":[{},[0,0,2]]}],"z":[{},[0,0,2]]}],"d":[{"a":[{"r":[{"a":[{".":[{},[0,0,2,1,2]]}],"á":[{},[0,0,2,1,2]]}]}],"á":[{},[0,0,2,1,2]],"e":[{"m":[{},[0,0,2]]}],"é":[{},[0,0,2,1]],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{},[0,0,2,3]]}],"l":[{"e":[{"j":[{},[0,0,2,1]],"p":[{"e":[{"d":[{},[0,0,2,1,2]]}]}],"v":[{"e":[{"t":[{},[0,0,2,1,2]]}]}]}]}],"n":[{"a":[{"l":[{},[0,0,2]],"p":[{"a":[{},[0,0,0,1]]}]}]}],"r":[{"á":[{"r":[{},[0,0,2]]},[2]]}],"s":[{"h":[{},[0,0,1]]}],"v":[{"í":[{},[0,0,0,0,2]]}],"z":[{"a":[{"t":[{"e":[{},[0,0,0,0,2,1]]}]}]}]},[1]],"ö":[{"k":[{"ö":[{},[0,0,0,0,1]]}],"l":[{"g":[{"y":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2,0,1]],"e":[{"l":[{},[0,0,0,2]]}]}]}]}]},[1]],"ő":[{"a":[{"n":[{},[0,0,0,2]]}],"b":[{"r":[{},[0,0,1]]}],"e":[{"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"n":[{},[0,0,0,2]]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"k":[{"v":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"a":[{"l":[{},[0,0,2,1]],"s":[{},[0,0,2]],"v":[{},[0,0,2,1]]},[0,0,0,0,2]],"e":[{"l":[{},[0,0,2,1]],"p":[{},[0,0,2]],"s":[{},[0,0,2]]}],"i":[{"m":[{},[0,0,2]],"s":[{},[0,0,2]]}],"p":[{"i":[{},[0,0,1,2]]}],"s":[{},[0,0,0,3]],"t":[{"a":[{"b":[{},[0,0,1,2]]}],"r":[{},[0,0,0,1]]}],"u":[{"t":[{},[0,0,2]]}],"ú":[{},[0,0,2,1]],"ü":[{"l":[{"t":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1,2]]}],"ű":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1]]}],"ü":[{"l":[{},[0,0,0,2]]}]},[1]],"p":[{"l":[{"a":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"r":[{"u":[{"s":[{},[0,0,0,1,2]]}]}],"s":[{"c":[{"h":[{},[0,0,2]]}],"é":[{"g":[{"e":[{"l":[{},[0,0,0,2]]}]}]}],"k":[{"a":[{},[0,0,2]]}],"p":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"s":[{"t":[{},[0,0,1,2]]}],"z":[{"a":[{"k":[{"é":[{},[0,0,0,0,2]]}]}],"á":[{"j":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1,2]]}]}]}]}],"l":[{},[0,0,0,2]]}]}],"t":[{"c":[{"l":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]]}],"o":[{"l":[{},[0,2,1]]}],"r":[{"á":[{},[0,0,2]],"e":[{"f":[{},[0,1]]}]}],"u":[{"t":[{},[0,2,1,2]]}]}],"u":[{"h":[{"y":[{},[0,0,1]]}],"r":[{"á":[{},[2]],"t":[{"e":[{},[0,0,0,2,1]],"i":[{"t":[{},[0,0,0,2]]}]}]}],"s":[{".":[{},[2]],"i":[{},[2]],"z":[{"o":[{"n":[{},[0,0,0,0,0,0,1]]}]}]}]},[1]],"ú":[{"g":[{"y":[{"a":[{},[0,0,2,0,1,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"ú":[{},[0,0,2]]}]}],"r":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"e":[{},[0,0,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"s":[{"a":[{"k":[{},[0,0,2,1]],"l":[{},[0,0,2]],"n":[{},[0,0,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]]}],"e":[{},[0,0,2,1,2]],"i":[{"m":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"r":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"z":[{"a":[{"k":[{},[0,0,0,3]]}],"á":[{},[0,0,0,3]],"é":[{},[0,0,0,3]]}]}],"ü":[{},[0,0,2]],"z":[{"a":[{"b":[{},[0,0,2,3]]}],"á":[{"l":[{},[0,0,2,0,1]]}],"e":[{},[0,0,2,0,1,2]],"í":[{},[0,0,2,0,1,2]],"o":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"ó":[{},[0,0,2,0,1,2]],"ü":[{},[0,0,2,0,1,2]]}]}]},[1]],"ü":[{"g":[{"y":[{},[0,0,2]]}],"n":[{"n":[{},[2,1]]}],"r":[{"e":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"ő":[{},[0,0,2]]}],"v":[{"ö":[{},[0,1,2]]}]},[1]],"ű":[{"r":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]]}]},[1]],"y":[{"é":[{"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"i":[{"g":[{},[0,0,1]]}]}]}],"i":[{".":[{},[2]],"a":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{"t":[{"a":[{},[0,0,0,0,0,2]]},[0,0,0,0,1]]}],"b":[{"a":[{"j":[{},[0,2]]}],"e":[{"r":[{},[0,2]],"s":[{},[0,2]]}],"í":[{},[0,2]],"o":[{"n":[{},[0,2]],"r":[{},[0,2]]}],"ö":[{},[0,2]],"ő":[{},[0,2]],"u":[{},[0,2]],"ú":[{},[0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]]}],"c":[{"a":[{"l":[{},[0,0,2,1]]}],"c":[{},[0,0,0,3]],"e":[{"t":[{},[0,2]]}],"é":[{"l":[{"é":[{},[0,0,0,1]]}],"r":[{".":[{},[0,0,2,1]]}]}],"h":[{},[0,0,2,3]],"i":[{"d":[{},[0,0,2]],"k":[{"o":[{},[0,0,0,1,2]]}],"m":[{},[0,0,2,1]],"n":[{"t":[{},[0,0,2,1]]}]}],"í":[{},[0,2]],"o":[{"r":[{},[0,0,2,1]]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"é":[{},[0,0,2,3]],"p":[{},[0,0,0,3]],"t":[{},[0,0,0,3]],"z":[{},[0,0,0,3]]}],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"d":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"e":[{},[0,2]],"í":[{},[0,2]],"o":[{"t":[{},[0,0,2]]}],"ó":[{"e":[{},[0,0,2]],"s":[{"t":[{},[0,0,0,0,1]]}]}],"ö":[{},[0,2]],"ő":[{},[0,2]],"ú":[{},[0,2]]}],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"á":[{},[0,2]],"e":[{},[0,2]],"i":[{},[0,2]],"l":[{},[0,2,1]],"ó":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"r":[{"i":[{},[0,2]],"o":[{},[0,0,1]]}],"u":[{},[0,2]],"ú":[{},[0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]]}],"g":[{"á":[{},[0,2]],"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"u":[{},[0,2]],"y":[{"u":[{},[0,0,2]]}]}],"i":[{"g":[{},[0,2]],"p":[{},[0,2]],"z":[{},[0,2,0,2]]}],"j":[{"á":[{"n":[{},[0,0,2]]}],"e":[{},[0,2]],"o":[{},[0,2]]}],"k":[{"a":[{"d":[{},[0,0,2]]}],"á":[{},[0,2]],"e":[{},[0,2]],"í":[{},[0,2]],"l":[{},[0,2,1,2]],"ó":[{"d":[{},[0,2]],"r":[{},[0,2]]}],"ö":[{},[0,2]],"ő":[{},[0,2]],"r":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"i":[{},[0,0,1,2]],"í":[{},[0,0,1]]}],"u":[{},[0,2]],"ú":[{},[0,2]],"ü":[{},[0,2]],"v":[{},[0,2,1]]}],"l":[{"a":[{"n":[{},[0,0,3]],"t":[{},[0,0,2]]}],"e":[{"g":[{},[0,2]]}],"i":[{"b":[{},[0,2]]}],"í":[{},[0,2]],"o":[{"m":[{},[0,0,2]]}],"ö":[{},[0,2]],"u":[{"d":[{},[0,0,2]],"s":[{},[0,0,2]]}],"y":[{},[0,2]]}],"m":[{"á":[{},[0,2]],"e":[{},[0,2]],"ó":[{},[0,2]],"u":[{"r":[{},[0,0,2,1]]}],"ú":[{},[0,2]],"ű":[{},[0,2]]}],"n":[{"e":[{"k":[{},[0,0,2]]}],"é":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]]}],"o":[{"k":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"á":[{"t":[{},[0,0,2]]}],"e":[{},[0,2]],"é":[{},[0,2]],"l":[{},[0,0,1,2]],"o":[{},[0,2]],"s":[{},[0,0,1,2]]}],"r":[{"á":[{"d":[{"i":[{},[0,0,0,0,0,0,2]]}]}],"e":[{},[0,2]],"é":[{"n":[{},[0,0,2]]}],"o":[{},[0,2]],"ó":[{},[0,2]],"ö":[{},[0,2]],"u":[{},[0,2]],"ú":[{},[0,2]]}],"s":[{"e":[{},[0,2]],"h":[{},[0,2,1]],"i":[{},[0,2]],"k":[{"á":[{},[0,0,1,2]]}],"l":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"ó":[{},[0,2]],"ö":[{},[0,2]],"p":[{},[0,2,1,2]],"t":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"i":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{},[0,0,1]]},[0,0,0,0,2]],"ú":[{},[0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]],"z":[{"a":[{"n":[{},[0,0,2,0,1]]}],"e":[{"r":[{"ű":[{},[0,3]]}],"s":[{},[0,0,2]]}],"é":[{"p":[{},[0,0,2]]}],"k":[{"e":[{"r":[{},[0,0,0,0,2,1,2]]}]}],"o":[{"p":[{},[0,0,2]]}],"ú":[{},[0,2]]}]}],"t":[{"e":[{},[0,2]],"ó":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"r":[{"é":[{},[0,0,1]]}],"y":[{},[0,0,2]]}],"u":[{"d":[{},[0,2]],"r":[{},[0,2,0,2]],"s":[{},[0,0,0,2]]}],"ü":[{"z":[{},[0,0,0,2]]}],"v":[{"a":[{"t":[{},[0,0,2]]}],"é":[{},[0,2]],"i":[{},[0,2]],"í":[{},[0,2]],"o":[{},[0,2]]}],"z":[{"á":[{},[0,2]],"e":[{},[0,2]],"o":[{},[0,0,2]],"s":[{},[0,2]],"ú":[{},[0,2]]}]},[0,1]],"á":[{"c":[{"s":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"í":[{},[0,0,2]]}],"k":[{"a":[{"b":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"b":[{},[0,0,2]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,2,1]],"d":[{},[0,0,2,1]]}],"s":[{},[0,0,2]]}],"i":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]},[0,0,0,0,2]],"í":[{},[0,0,2]],"o":[{"p":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"u":[{"r":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"ú":[{},[0,0,2,1,2]],"ü":[{},[0,0,2,1]],"ű":[{},[0,0,2]]}],"l":[{"a":[{"n":[{"a":[{},[0,0,0,1]]}]},[0,0,0,0,2]],"á":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"e":[{},[0,0,2,1,2]],"i":[{"m":[{},[0,0,2]],"n":[{},[0,0,2,1]]}],"o":[{"p":[{},[0,0,2]]}]}],"n":[{"a":[{"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"e":[{"m":[{},[0,0,2]]}],"i":[{"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ü":[{},[0,0,2]],"y":[{"a":[{"d":[{},[0,0,2,0,1]],"l":[{},[0,0,2,0,1,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"e":[{},[0,0,2,0,1,2]],"é":[{"r":[{"z":[{},[0,0,2]]}]}],"ö":[{},[0,0,2]]}]}],"ó":[{"i":[{},[0,0,2]]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,2]],"k":[{},[0,0,2]],"m":[{},[0,0,2]]}],"d":[{"a":[{"s":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"z":[{},[0,0,0,2,3]]}],"e":[{},[0,0,2]],"i":[{"m":[{},[0,0,2]]}],"s":[{},[0,0,0,1,2]],"u":[{"n":[{},[0,0,3]]},[0,0,2]],"ú":[{},[0,0,2]]}],"s":[{"a":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"á":[{"g":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"k":[{"r":[{},[0,0,2]]}]}],"í":[{},[0,0,2]],"o":[{"r":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"z":[{"o":[{},[0,0,0,3]]}]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ü":[{},[0,0,2,1,2]],"ű":[{},[0,0,2]],"v":[{"í":[{},[0,0,0,0,0,2]]}],"z":[{"á":[{"s":[{},[0,0,2]]}],"e":[{},[0,0,2,3]],"s":[{},[0,0,0,3]]}]}],"t":[{"a":[{},[0,0,2]],"e":[{"l":[{},[0,0,2,1,2]]}],"i":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]]}]},[0,1]],"b":[{"a":[{"d":[{},[0,0,0,1,2]],"s":[{},[0,0,0,0,2]],"t":[{},[0,0,0,0,2]],"u":[{},[0,0,0,0,2]],"ü":[{},[0,0,0,0,2]]}],"á":[{"l":[{"a":[{},[0,0,0,2,1]]}]}],"e":[{"l":[{"é":[{"r":[{},[0,0,0,2]]}]}],"r":[{"i":[{"n":[{},[0,0,0,2,1]]}]}],"s":[{},[0,0,0,1]]}],"i":[{"o":[{},[0,0,0,2]]}],"l":[{"o":[{},[0,0,2]]}],"r":[{"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}]}],"c":[{"a":[{"f":[{},[0,0,0,1,2]],"g":[{},[0,0,0,1,2]],"k":[{"l":[{},[0,0,0,1]],"r":[{},[0,0,0,1,2]]}],"l":[{"o":[{"s":[{},[0,0,0,2]]}]}],"p":[{"r":[{},[0,0,0,1]]}],"t":[{},[0,0,0,1,2]]}],"c":[{"a":[{"l":[{},[0,0,0,0,2]],"n":[{},[0,0,2]]}],"á":[{},[0,0,2,1,2]],"h":[{},[0,0,2,3]],"i":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2,1]],"s":[{"e":[{"l":[{},[0,0,0,0,0,2]]}],"o":[{"l":[{},[0,0,0,0,1]]}],"ő":[{},[0,0,0,0,1,2]]}],"ú":[{},[0,0,2]],"z":[{},[0,0,2]]}],"h":[{"a":[{".":[{},[0,0,3]]}],"e":[{"k":[{},[0,0,3]]}],"i":[{"n":[{"á":[{},[0,2]]}]}],"o":[{"z":[{},[0,0,3]]}],"ű":[{},[0,2,3]]}],"i":[{"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{"r":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}]}]}],"l":[{"u":[{},[0,1,2]]}],"o":[{"l":[{},[0,2,1]]}],"s":[{"a":[{"d":[{},[0,2,0,1,2]],"l":[{"a":[{},[0,0,0,1,2]]}],"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]]}]}],"u":[{},[0,2,0,1]]}],"á":[{"g":[{},[0,0,0,1]],"l":[{"l":[{},[0,0,0,1]]}]}],"e":[{"b":[{},[0,2,0,1]],"g":[{},[0,2,0,1,2]],"t":[{"e":[{},[0,2,0,1]]},[0,0,0,0,2]],"v":[{},[0,2,0,1]]}],"é":[{"g":[{},[0,0,0,1,2]],"r":[{"é":[{".":[{},[0,2,0,1,2]]}]}]}],"i":[{"p":[{"a":[{},[0,0,0,1]]}]}],"s":[{},[0,0,0,1]],"ú":[{"t":[{},[0,0,0,1]]}],"ü":[{"l":[{},[0,2,0,1]],"t":[{},[0,2,0,1,2]]}],"z":[{"e":[{},[0,0,3]]}]}],"ü":[{"z":[{},[0,0,1]]}]}],"d":[{"a":[{"j":[{},[0,2,1,2]],"n":[{"a":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"u":[{},[0,2,1]]}],"á":[{"l":[{"l":[{},[0,0,1]]}],"r":[{"u":[{},[0,0,1]]}],"s":[{"v":[{},[0,2,1]]}]}],"b":[{"r":[{},[0,0,1]]}],"d":[{"o":[{},[1]],"z":[{},[0,0,3]]}],"e":[{"a":[{"v":[{},[0,0,0,2]]}],"g":[{"á":[{},[0,0,0,2,1]],"é":[{"l":[{},[0,0,0,2,1]],"r":[{".":[{},[0,0,0,0,1]]}]}]}],"j":[{},[1,2]],"k":[{"v":[{},[0,0,0,1,2]]}],"l":[{"j":[{},[0,0,1]],"m":[{},[0,0,1]],"o":[{},[0,0,1]],"t":[{},[0,0,1]]},[2]],"m":[{"b":[{},[0,2,1]]}],"p":[{},[0,0,0,1,2]],"r":[{"e":[{"d":[{},[0,0,0,2]]}],"o":[{},[0,2]]}],"s":[{"a":[{},[0,0,0,3]]}],"u":[{},[0,0,0,0,2]]}],"é":[{"g":[{},[0,2,1,2]],"k":[{"e":[{"l":[{},[0,0,0,2]]}]}],"n":[{"y":[{},[0,2]]}],"r":[{"c":[{"s":[{},[0,0,0,0,2,3]]}]}],"s":[{"z":[{},[2]]}],"z":[{},[1,2]]}],"g":[{"e":[{},[0,0,2]]}],"i":[{"a":[{"s":[{},[0,0,0,2]]}],"l":[{},[1,2]],"o":[{"n":[{"j":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"s":[{},[0,0,0,2]]}],"ó":[{"d":[{},[0,0,0,2]]}],"t":[{"a":[{},[0,2,1]]}]}],"í":[{"j":[{"a":[{"d":[{"a":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}]}],"k":[{"r":[{},[0,0,1]]}],"o":[{"l":[{"d":[{},[0,0,1]],"v":[{},[0,2,1]]}],"m":[{"a":[{"c":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}],"á":[{},[1,2]],"o":[{},[1,2]],"ú":[{},[1]]}]}],"ö":[{"s":[{},[0,0,1]]}],"ő":[{".":[{},[1,2]],"b":[{},[1,2]],"d":[{},[1,2]],"é":[{},[1,2]],"h":[{},[1,2]],"i":[{},[1,2]],"k":[{},[1,2]],"m":[{},[1,2]],"n":[{"e":[{},[0,2]],"é":[{},[0,2]],"k":[{},[0,2]]}],"p":[{},[1,2]],"r":[{},[1,2]],"s":[{"o":[{"d":[{},[0,0,0,2]]}],"p":[{},[0,0,0,1,2]]},[1,2]],"t":[{"á":[{"l":[{},[0,0,0,2]]}]},[1,2]],"v":[{},[1,2]],"z":[{},[0,2]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"ó":[{"t":[{},[0,0,2]]}],"u":[{},[0,1,2]]}],"s":[{"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,0,1]],"z":[{},[0,2,1]]}],"z":[{"á":[{},[0,2,3]],"e":[{},[0,2,3]],"ó":[{},[0,2,3]],"s":[{"a":[{},[0,2,0,0,1]],"á":[{},[0,2,0,0,1]],"e":[{"n":[{},[0,2]]}],"é":[{"l":[{},[0,2]]}],"í":[{},[0,2,0,0,1,2]]}]}]}],"e":[{"b":[{"e":[{},[0,0,2]]}],"c":[{"s":[{},[0,0,2]]}],"d":[{"z":[{},[0,0,2]]}],"f":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2,1]],"ü":[{},[0,0,2,1,2]]}],"g":[{"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"e":[{},[0,0,2]]}],"l":[{"d":[{},[0,2]],"o":[{},[0,0,2]],"ő":[{"a":[{},[0,0,2]]}]}],"m":[{"a":[{},[0,0,2]]}],"n":[{"s":[{"á":[{},[0,0,0,2]],"o":[{},[0,0,0,2,1]],"s":[{},[0,0,0,0,3]]}],"y":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,2,1,2]],"g":[{},[0,0,2]],"j":[{},[0,0,2,1]],"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"á":[{},[0,0,2,1]],"d":[{},[0,0,0,1,2]],"e":[{"g":[{"y":[{},[0,0,0,1]]},[0,0,2]],"l":[{},[0,0,2,1]],"m":[{"b":[{"e":[{"r":[{},[0,0,2,1]]}]}]}],"s":[{"t":[{},[0,0,2,1]]}]}],"i":[{"g":[{"a":[{},[0,0,2,1]]}],"n":[{},[0,0,2,1]],"s":[{"t":[{"e":[{},[0,0,2,1]]}]}]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,0,0,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2,1]],"ü":[{"g":[{},[0,0,2,1,2]]}]}],"s":[{"e":[{"l":[{},[0,0,2]],"m":[{},[0,0,2]],"t":[{"t":[{},[0,0,2]]}]}],"é":[{"s":[{},[0,0,2]]}],"i":[{"k":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"z":[{},[0,0,2]]}],"t":[{"é":[{"s":[{"z":[{},[0,0,0,0,1,0,2]]}]}],"z":[{},[0,0,0,0,1]]}],"u":[{"r":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[0,1]],"é":[{"d":[{"o":[{},[0,2]]}],"f":[{"e":[{},[0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"h":[{"a":[{},[0,2]],"e":[{"s":[{},[0,0,2]]}],"i":[{},[0,2]]}],"i":[{"l":[{},[0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"m":[{"e":[{},[0,2]],"é":[{},[0,2]],"o":[{},[0,2]]}],"n":[{"e":[{"k":[{"e":[{},[0,0,2]],"h":[{},[0,0,2]],"k":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"e":[{"k":[{},[0,0,2]],"n":[{},[0,2]],"z":[{},[0,0,2]]}],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{".":[{},[0,0,2]],"k":[{},[0,0,2]],"t":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"s":[{"z":[{"i":[{},[0,2]]}]}],"t":[{"a":[{"s":[{},[0,0,0,0,1]]}],"e":[{"l":[{},[0,0,2]]}],"ö":[{},[0,2]]}],"v":[{"e":[{".":[{},[0,0,2]],"k":[{},[0,0,2]]}]}]},[0,1]],"f":[{"a":[{"s":[{"t":[{},[0,0,0,1]]}],"t":[{},[0,0,0,1,2]]}],"e":[{".":[{},[0,2]],"n":[{"y":[{"ő":[{"é":[{"h":[{},[0,0,0,0,0,0,0,2]]}]}]}]}]}],"i":[{"o":[{},[0,0,0,0,2]]}],"í":[{"r":[{},[0,0,1]]}],"j":[{"í":[{},[1]],"u":[{},[1]],"ú":[{".":[{},[1]],"b":[{},[1]],"é":[{},[1]],"i":[{},[1]],"k":[{"é":[{},[1]]}],"n":[{},[1]],"r":[{},[1]],"s":[{},[1]],"t":[{},[1]],"v":[{},[1]]}]}],"l":[{"a":[{},[0,1,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2]]}],"o":[{"g":[{"o":[{},[0,0,0,0,0,2]]}],"n":[{"n":[{},[0,0,0,0,1]]}]}],"r":[{"i":[{},[0,1,2]],"o":[{},[0,1,2]],"ö":[{},[0,1,2]],"u":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1,2]],"e":[{"l":[{},[0,0,2,1,2]]}],"i":[{"n":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ú":[{},[0,0,2]]}]}],"g":[{"a":[{"g":[{"i":[{"t":[{},[0,0,1,2]]}]}],"k":[{"a":[{},[0,0,1,2]]}],"l":[{"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]],"y":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{"s":[{},[0,0,0,2,0,1]]},[0,0,0,0,0,0,2]]}]}],"r":[{"a":[{"s":[{},[0,0,0,2]]}],"z":[{},[1,2]]}],"s":[{"l":[{},[0,0,0,1]],"z":[{"a":[{"g":[{},[0,0,0,2]],"l":[{},[0,0,0,0,0,1]]}]}]}],"u":[{"r":[{},[0,0,0,0,2]]}],"z":[{".":[{},[1,2]],"í":[{},[1]]}]}],"á":[{"c":[{"s":[{},[0,0,1,2]]}],"l":[{"m":[{},[0,0,1]]}],"s":[{"h":[{},[0,0,1]],"z":[{},[0,3]]}],"t":[{"e":[{},[0,0,1,2,1,2]]}]}],"b":[{"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"d":[{"z":[{},[0,0,1]]}],"g":[{},[0,2]],"k":[{"l":[{},[0,0,0,1]]},[0,0,0,0,2]],"l":[{"e":[{},[0,0,1,2]],"l":[{},[0,0,1]],"m":[{},[0,0,1]]}],"n":[{"l":[{},[1,2]]}],"r":[{"á":[{},[0,0,0,2]],"ő":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1,2]],"i":[{},[0,0,1]]}],"t":[{"á":[{"l":[{},[0,0,0,2]]}],"e":[{"g":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2,1]],"ő":[{"r":[{},[0,0,0,2]]}]}],"v":[{"i":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"é":[{"d":[{},[1,2]],"g":[{},[0,0,1,2]],"l":[{"i":[{},[0,0,1,2]],"ő":[{},[0,0,1,2]],"ü":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"m":[{},[0,2]],"n":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"y":[{},[1,2]]}],"p":[{"e":[{},[0,3]],"í":[{},[0,0,1]]}],"r":[{".":[{},[0,0,1]],"j":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"ü":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1]]}],"ü":[{},[1,2]]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]]}],"í":[{"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"a":[{"c":[{},[0,0,2]]}]}],"n":[{"a":[{"d":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1,2]],"r":[{},[0,0,0,0,2]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"o":[{"r":[{"á":[{"l":[{},[0,0,0,2]]}]}],"s":[{},[0,0,1,2]]}],"ó":[{"é":[{},[0,0,0,0,2]]}],"ö":[{"b":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"a":[{"f":[{},[0,1,2]]}]}],"s":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"g":[{},[0,0,1]],"n":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"ú":[{"s":[{},[0,0,1]]}],"ü":[{"c":[{},[0,0,1]],"d":[{},[0,0,1]],"g":[{},[0,0,1,2]],"l":[{},[0,0,0,2]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"ű":[{"z":[{},[0,0,1]]}],"y":[{"a":[{".":[{},[0,2]],"m":[{},[0,2]]}],"á":[{"k":[{},[0,2]],"l":[{},[0,2]]}],"e":[{"g":[{},[0,2,0,1]],"k":[{"é":[{"h":[{},[0,2,0,1,2]]}]}]}],"é":[{"k":[{"t":[{},[0,2,0,1]]}],"r":[{".":[{},[0,0,0,1]],"t":[{},[0,2,0,1]]}]}]}]}],"h":[{"a":[{"r":[{"e":[{},[0,0,0,2]]}]}]}],"i":[{"d":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"a":[{},[0,0,2]]}],"j":[{"e":[{},[0,0,2]]}],"m":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,2]]}],"r":[{"a":[{"m":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{},[0,0,2]],"o":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]]}],"v":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"z":[{"é":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[0,1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"t":[{"é":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[0,1]],"j":[{"e":[{"d":[{},[1,2]],"g":[{"y":[{"á":[{},[0,0,0,2,0,1,2]]}]}],"s":[{},[1,2]]}]}],"k":[{"a":[{"b":[{"e":[{"j":[{"á":[{},[0,0,0,0,0,0,0,2]]},[0,0,0,0,0,2,1]]}],"l":[{},[0,2,1]]}],"j":[{"t":[{},[0,0,1]]}],"l":[{"a":[{"k":[{},[0,0,0,2]]}]}],"n":[{"g":[{},[0,0,1]]}],"ó":[{},[0,0,0,0,2]],"p":[{"l":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]}],"r":[{"ó":[{"r":[{},[0,0,0,2,0,2]]}]}],"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"r":[{},[0,0,0,1,2]]}]}],"á":[{"r":[{"k":[{},[0,2,1]],"u":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,1]]}],"t":[{"o":[{"l":[{},[0,0,0,2]]}]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"b":[{"é":[{},[0,0,1]]}],"g":[{},[0,2,1]],"l":[{"o":[{},[0,0,1]]}],"n":[{"g":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1,2]],"e":[{"d":[{"z":[{},[0,0,0,2,1,2]]}],"l":[{},[0,0,0,2,1,2]],"v":[{},[0,0,0,2,1]]}],"i":[{"s":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2,1]],"ő":[{},[0,0,1,2]],"s":[{},[0,0,0,0,1]],"u":[{},[0,0,0,2]]}],"t":[{"ü":[{"l":[{"t":[{},[0,0,0,2,1]]}]}]}],"v":[{"o":[{},[0,0,1]]}]}],"é":[{"k":[{"e":[{"k":[{"k":[{},[0,0,0,2]]}]}]}],"p":[{"í":[{},[0,2,1]],"ü":[{},[0,2,1]]}],"r":[{"z":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1]],"k":[{"o":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"n":[{"d":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"s":[{"k":[{},[0,0,1]]}]}],"k":[{"a":[{"l":[{"a":[{},[0,0,2,1]]},[0,0,0,0,2]],"n":[{"y":[{},[0,0,0,1]]}],"r":[{},[0,0,2,1,2]]}],"á":[{"r":[{"a":[{},[0,0,0,1]]}],"z":[{},[0,0,2]]}],"e":[{"v":[{},[0,0,2]]}],"é":[{"r":[{"d":[{"e":[{},[0,0,0,1]]}]}]}],"i":[{"n":[{},[0,0,2]],"p":[{},[0,0,2,1,2]]}],"o":[{"l":[{},[0,0,2,1]]}],"ó":[{},[0,0,2,1]],"ö":[{"s":[{},[0,0,2,1]],"t":[{},[0,0,2]],"z":[{},[0,0,2,1,2]]}],"u":[{},[0,0,2,1,2]],"ü":[{"z":[{},[0,0,2]]}]}],"l":[{"a":[{"t":[{"r":[{},[0,0,0,0,1]]}]}],"e":[{"r":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2]]}],"u":[{"b":[{},[0,1]],"m":[{},[0,0,2]]}]}],"n":[{"é":[{"d":[{},[0,1]]}]}],"o":[{"m":[{"a":[{"r":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"n":[{"b":[{"á":[{},[1]]}],"é":[{"n":[{},[1]]}],"l":[{},[1,2]],"t":[{"a":[{},[1,2]],"ö":[{},[1]],"ü":[{},[1,2]]}],"z":[{"s":[{},[1]]}]}]}],"ó":[{"p":[{},[0,0,0,1]],"r":[{"á":[{},[0,0,1,2]]}],"s":[{"z":[{"á":[{},[0,0,0,2,3]]}]}]}],"ő":[{"r":[{"e":[{"s":[{},[0,0,0,2]]}]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"e":[{"i":[{},[1]],"k":[{},[1]]}],"é":[{"m":[{},[0,0,2]]}],"ó":[{"m":[{},[0,1,2]]}],"u":[{},[0,1,2]]}],"s":[{"t":[{},[0,0,1]],"z":[{"i":[{"n":[{"d":[{},[0,0,0,0,0,0,0,2]]}]}],"t":[{},[0,0,0,0,2]]}]}],"t":[{"u":[{"s":[{"s":[{},[0,0,0,0,0,1]],"z":[{},[0,0,0,0,2]]}]}]}],"u":[{".":[{},[2]],"b":[{},[2]],"d":[{"v":[{},[0,0,1]]}],"f":[{},[2]],"h":[{},[2]],"i":[{},[2]],"í":[{},[2]],"j":[{},[2]],"k":[{},[2]],"r":[{},[2]],"s":[{"a":[{"v":[{},[0,0,0,2]]}]}],"t":[{},[2]],"v":[{},[2]]}],"ü":[{"v":[{},[0,0,1,2]]}]}],"l":[{"a":[{"b":[{"r":[{},[0,0,1]]}],"c":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]]}],"d":[{"ó":[{},[0,0,1,2]]}],"l":[{"a":[{},[0,0,1,2]],"d":[{},[0,0,1]],"k":[{},[0,2,1]]}],"m":[{"b":[{},[0,0,1]]}],"n":[{"a":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"p":[{"i":[{"n":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}]}],"r":[{},[0,2,1,2]]}],"á":[{"g":[{"e":[{},[0,0,0,2,1,2]],"g":[{},[0,0,0,0,3]],"ö":[{},[0,0,0,2]],"y":[{"o":[{},[0,0,1,2]]}]}],"n":[{"y":[{"f":[{"é":[{},[0,0,0,0,0,0,0,2]]}]}]}],"p":[{},[0,2,1,2]],"r":[{"n":[{},[0,2,1]],"o":[{},[0,0,1,2]],"u":[{},[0,0,1]],"ú":[{},[0,0,1,2]]}],"s":[{"z":[{"o":[{},[0,2,1]]},[0,0,0,2]]}],"t":[{"f":[{},[0,0,1]],"m":[{},[0,0,1]],"r":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"a":[{},[0,0,2,1,2]],"c":[{},[0,0,0,3]],"h":[{},[0,0,2]],"s":[{"a":[{"p":[{},[0,0,2,3]]}],"i":[{"k":[{},[0,0,2,3]]}],"z":[{},[0,0,0,3]]}],"z":[{},[0,0,2]]}],"e":[{"l":[{"e":[{"m":[{},[0,0,1,2]]}]}],"m":[{"b":[{},[0,2,1]],"l":[{},[0,2,1]]}],"x":[{"p":[{},[0,0,1]]}]}],"é":[{"n":[{"á":[{},[0,0,0,2,1]],"e":[{"k":[{"h":[{},[0,2,1,2]],"n":[{},[0,2,1,2]]}]}]}],"s":[{"p":[{},[0,0,0,1]]}]}],"f":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"c":[{"c":[{},[0,2,1]]}],"d":[{"e":[{},[0,0,1]]}],"g":[{"á":[{"h":[{},[0,2,1]],"j":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"r":[{"a":[{},[0,0,0,1]]}]}],"k":[{"o":[{"n":[{".":[{},[0,2,1,2]],"b":[{},[0,2,1,2]],"é":[{},[0,2]],"h":[{},[0,2,1,2]],"j":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"z":[{},[0,2]]}]}]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"a":[{".":[{},[0,0,0,2]]}],"i":[{},[0,0,1,2]],"p":[{},[0,0,1]]}],"n":[{"n":[{},[0,0,0,0,1]]}],"p":[{"á":[{},[0,0,0,2,1]]}],"r":[{"ó":[{},[0,0,1]]}]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"l":[{"a":[{"g":[{"ó":[{},[0,0,0,0,2,1,2]]}],"t":[{"b":[{},[1]],"r":[{},[1]],"t":[{},[1]]}]}],"e":[{"s":[{"t":[{"e":[{},[0,0,2,1]],"é":[{},[0,0,2,1]]}]}]}],"é":[{"s":[{"é":[{},[1]]}],"t":[{"e":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{"d":[{},[0,0,2,1]],"g":[{"r":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}],"ö":[{},[0,0,2,1]],"u":[{},[1]],"ú":[{},[1]]}],"m":[{"a":[{"d":[{"a":[{},[0,0,0,1]]}],"g":[{"y":[{},[0,0,2,1]]}],"j":[{},[0,0,2,1]],"k":[{"a":[{},[0,0,0,1]]}],"l":[{},[0,0,2,1,2]],"n":[{"k":[{},[0,0,0,1]],"y":[{},[0,0,0,1]]}],"p":[{},[0,0,2,1]],"r":[{"c":[{},[0,0,2,1]]}],"t":[{"l":[{},[0,0,0,1]]}],"z":[{},[0,0,2,1,2]]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"g":[{"é":[{},[0,0,2,1]],"y":[{},[0,0,2,1]]},[0,0,0,0,2]],"l":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,2,1]]}]}],"é":[{"j":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{".":[{},[0,0,2,1]],"d":[{},[0,0,2,1]],"é":[{"s":[{"t":[{},[0,0,0,1,2]]}]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2,1]]}]}],"s":[{},[0,0,2,1]]}],"i":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"m":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"í":[{},[0,0,2,1,2]],"o":[{"k":[{},[0,0,2,1]],"l":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,0,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"u":[{"t":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"o":[{"g":[{},[0,0,0,1,2]],"r":[{},[0,2,1]]}],"ó":[{"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ö":[{"b":[{},[0,0,1]],"s":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"s":[{"h":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"t":[{"e":[{},[2]]}],"u":[{"m":[{"i":[{"n":[{},[0,0,0,0,0,0,1]]},[0,0,0,0,0,2]]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"ü":[{"g":[{},[0,2,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1]]}],"v":[{"a":[{"k":[{},[0,0,0,0,1,2]]}]}]}],"m":[{"a":[{"g":[{"l":[{},[0,0,0,1]]}],"k":[{"k":[{},[0,0,1]]}],"ó":[{},[0,0,0,0,2]],"p":[{},[0,0,0,1]],"r":[{".":[{},[2]],"i":[{"t":[{},[0,2]]}]}]}],"á":[{"d":[{},[1,2]],"k":[{"t":[{},[0,2]]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{"g":[{},[0,0,0,0,1]]}],"l":[{"e":[{"m":[{},[0,0,1]]}]}],"m":[{"e":[{},[0,2,1]]},[0,0,0,2]],"r":[{"a":[{},[0,0,0,2]],"i":[{"n":[{},[0,0,0,2]]}]}]}],"é":[{"r":[{"d":[{},[0,2,1]]}]}],"i":[{"n":[{"h":[{},[0,0,1]],"t":[{"é":[{},[0,0,1]]}]}],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{"r":[{},[0,0,0,2,1,2]]}],"i":[{"n":[{},[0,0,0,2]]}]}]}],"m":[{"u":[{},[1]]}],"o":[{"l":[{"d":[{},[0,2,1]]}],"m":[{},[0,2,1]]}],"ó":[{"r":[{"á":[{},[0,0,1,2]]}],"t":[{},[0,0,0,0,2]]}],"ö":[{"s":[{},[0,0,1]]}],"p":[{"é":[{},[1]],"u":[{},[1]]}],"r":[{"e":[{"i":[{},[1]]}]}],"ü":[{"r":[{},[0,2,1]]}],"ű":[{"t":[{"r":[{},[0,0,0,0,2]]}]}]}],"n":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"c":[{"é":[{},[0,2,1,2]]}],"d":[{"á":[{},[0,2,1]],"e":[{},[0,0,1]],"o":[{},[0,2]]}],"j":[{"á":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"k":[{"a":[{"r":[{},[0,0,0,0,0,2]],"t":[{".":[{},[1,2]]}]}],"c":[{},[0,2,1]],"k":[{},[0,2]],"n":[{},[0,2]],"t":[{},[0,2]],"v":[{},[0,2,1]]}],"l":[{"d":[{},[0,0,1]],"k":[{},[0,2,1]],"l":[{},[0,0,1]]}],"m":[{".":[{},[1,2]],"i":[{"t":[{".":[{},[0,2,1,2]]}]}]}],"n":[{"a":[{},[0,0,1]]}],"p":[{"l":[{"a":[{},[0,0,0,1]]}]}],"r":[{"á":[{"n":[{},[0,0,0,2]]}]}],"s":[{".":[{},[1,2]],"i":[{"s":[{},[0,0,0,2]]}],"n":[{},[1,2]]}],"t":[{"e":[{"l":[{"l":[{},[0,0,0,2]]}]}]}]}],"á":[{"g":[{},[0,2,1]],"l":[{"a":[{"d":[{},[0,0,0,2]]}]}],"r":[{"a":[{"k":[{},[0,0,1,2]]}],"h":[{},[0,0,1]],"u":[{},[0,2]]}],"s":[{"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"a":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"n":[{},[0,0,0,0,2]]}],"e":[{"l":[{"t":[{},[0,0,0,1]]}]}],"é":[{"l":[{},[0,0,2,1]]}],"h":[{"i":[{},[0,0,2]],"o":[{},[0,0,2,3]]}],"i":[{"s":[{},[0,0,2,1]]}],"o":[{"s":[{},[0,0,2,1]]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"s":[{"a":[{"n":[{},[0,0,0,0,1]]}],"e":[{"r":[{},[0,0,2,0,1,2]]}],"é":[{"j":[{},[0,0,2,0,1,2]],"r":[{".":[{},[0,0,2,0,1]],"v":[{},[0,0,0,3]]}]}],"o":[{"r":[{".":[{},[0,0,0,3]]},[0,0,2]]}],"ú":[{},[0,0,2]],"ü":[{"t":[{},[0,0,0,3]]}],"z":[{"a":[{},[0,0,0,3]]}]}],"ú":[{},[0,0,2]]}],"d":[{"a":[{"b":[{},[0,0,2,1]],"i":[{},[1]],"z":[{},[0,0,2,1]]}],"e":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1,2]],"k":[{"ö":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1,2]],"t":[{"t":[{},[0,0,2,1]]}],"x":[{},[1]],"z":[{},[0,0,2,1,2]]}],"é":[{"g":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"i":[{"n":[{"k":[{},[0,0,0,1]]}],"v":[{},[1]]}],"í":[{"t":[{},[1]]}],"ö":[{"r":[{},[0,0,2,1]],"s":[{},[0,0,2]]},[0,0,0,0,2]],"r":[{"a":[{},[0,0,1]]}],"u":[{"l":[{},[1]]}]}],"e":[{".":[{},[2]],"d":[{"é":[{},[0,2,1,2]]}],"f":[{},[0,2,1]],"g":[{"g":[{},[0,0,0,0,1]],"y":[{},[0,0,1,2]]}],"k":[{"u":[{},[0,0,0,2]]}],"l":[{},[0,2,1,2]],"m":[{"u":[{},[0,0,1]]}],"n":[{"y":[{},[0,2,1]]}],"r":[{"d":[{},[0,2,1]],"j":[{},[0,2,1]]},[2]],"t":[{"a":[{},[0,0,0,2,1]],"é":[{"r":[{},[0,0,0,2,1]]}],"ü":[{"l":[{},[0,0,0,2]]}]}],"x":[{},[0,2,1]]}],"é":[{"b":[{},[2]],"g":[{"e":[{},[0,0,1,2]]}],"k":[{"r":[{"é":[{},[0,0,0,1]]}]}],"l":[{"e":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]},[0,0,0,2]],"p":[{"í":[{},[0,0,1]]}],"r":[{".":[{},[0,2,1]],"d":[{},[0,2]],"é":[{},[0,2,1]],"t":[{"e":[{},[0,0,1]]}]}],"t":[{"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2]]}],"v":[{},[2]]}],"f":[{"e":[{"k":[{},[1]]}],"l":[{},[1]]}],"g":[{"a":[{"d":[{"ó":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2,1]]}]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}],"r":[{"á":[{},[0,0,0,1]],"é":[{},[0,0,0,1]],"o":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"e":[{"c":[{},[1]],"g":[{},[0,0,2,1]],"i":[{},[1]],"l":[{"j":[{"á":[{},[0,0,0,1]]}],"k":[{},[0,0,0,1]],"l":[{},[0,0,2,1]],"s":[{},[0,0,0,1]]}],"n":[{"c":[{},[0,0,2,1]]}],"r":[{"b":[{},[1]],"c":[{},[1]],"é":[{"s":[{},[0,0,0,0,2,1]]},[1]],"g":[{},[1]],"h":[{},[1]],"i":[{},[1]],"k":[{},[1]],"m":[{},[1]],"n":[{},[1]],"p":[{},[1]],"r":[{},[1]],"s":[{},[1]],"t":[{},[1]],"ü":[{},[1]]}],"v":[{},[0,0,2,1,2]]}],"é":[{"j":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"g":[{},[0,0,0,3]],"i":[{"n":[{"a":[{},[0,0,0,1,2]]}]}],"í":[{},[0,0,2]],"l":[{"o":[{},[0,0,1]]}],"o":[{"r":[{},[0,0,2]]}],"ö":[{"l":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"r":[{"á":[{"d":[{".":[{},[0,0,0,2]],"b":[{},[0,0,0,2]],"d":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}]}]}],"u":[{"j":[{},[1]],"t":[{},[0,0,2,1,2]]}],"ú":[{},[0,0,2]],"ü":[{"l":[{"t":[{},[0,0,0,1]]}]}]}],"i":[{"e":[{},[2]],"é":[{},[2]],"g":[{"a":[{"r":[{},[0,2]]}],"e":[{},[0,2,1]]}],"k":[{"r":[{"a":[{},[0,0,1]],"o":[{},[0,0,0,1]]}]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"a":[{".":[{},[0,2,1,2]]}],"i":[{},[0,0,1,2]]}],"n":[{"d":[{},[0,0,1]],"g":[{},[2]],"h":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"r":[{},[2]],"s":[{"é":[{"g":[{},[0,0,0,2,1]]}],"k":[{},[0,2,1]],"m":[{},[0,2,1]]}],"t":[{"a":[{"l":[{},[0,2,1]]}]}],"u":[{},[2]]}],"í":[{"z":[{},[0,2,1]]}],"j":[{"e":[{"k":[{"c":[{},[1]]}]}]}],"k":[{"a":[{"c":[{"é":[{},[0,0,0,1]]}],"d":[{},[0,0,2,1,2]],"t":[{"o":[{},[0,0,2,1]]}]}],"á":[{"r":[{"n":[{},[0,0,2,1]]}]}],"e":[{"s":[{"z":[{},[0,0,2,1]]}]}],"é":[{"r":[{"t":[{"é":[{},[0,0,0,1]]}]}]}],"i":[{"o":[{},[0,0,2]]}],"o":[{"l":[{"d":[{},[0,0,0,1]]}],"r":[{"s":[{"ó":[{},[0,0,0,1]]}]}]}],"ö":[{"s":[{},[0,0,2]]}],"u":[{"b":[{},[1]]}]}],"n":[{"a":[{".":[{},[1]]}],"o":[{"r":[{},[0,0,2]]}]}],"o":[{"b":[{},[0,2,1]],"k":[{"l":[{},[0,2,1]]}],"l":[{"d":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"r":[{"g":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"ó":[{"d":[{"a":[{},[0,0,1]],"á":[{},[0,0,1,2]]}],"r":[{"á":[{},[0,0,0,2]]}]}],"ö":[{"l":[{},[0,2,1]],"n":[{},[0,0,1]]}],"ő":[{"z":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1,2]],"m":[{},[0,0,1,2]],"p":[{"i":[{},[1]],"r":[{},[0,0,1]]}],"t":[{"a":[{},[1]],"o":[{},[0,0,1,2]]}]}],"t":[{"a":[{"k":[{"t":[{"u":[{},[0,0,2,1]]}]}],"n":[{"n":[{},[0,0,0,1]]}]}],"á":[{"r":[{"a":[{"i":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"á":[{},[0,0,2,1,2]],"f":[{},[0,0,2,1]],"i":[{},[0,0,2,1]],"o":[{"n":[{},[0,0,0,1]]}],"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,0,1]]}],"u":[{},[0,0,2,1]]}],"t":[{"a":[{},[0,0,0,1,2]]}]}],"e":[{"g":[{"e":[{},[1]],"r":[{},[1]],"y":[{},[0,0,2,1,2]]}],"l":[{"ő":[{"t":[{},[0,0,0,1]]}],"t":[{"é":[{},[0,0,0,1]]}]}],"n":[{"n":[{},[0,0,2,1]],"y":[{},[0,0,2,1,2]],"z":[{},[1]]}],"r":[{"e":[{"z":[{},[0,0,2,1,2]]}],"f":[{"é":[{},[1]]}]}],"s":[{"s":[{"z":[{},[0,0,0,1]]}]}],"t":[{"ő":[{"s":[{},[0,0,0,0,2,1]]}]}]}],"é":[{"j":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,2,1]]}],"z":[{"é":[{},[1]],"k":[{},[1]],"m":[{},[1]],"ő":[{"c":[{},[2]]},[1]]}]}],"h":[{"o":[{"s":[{},[0,0,1,2]]}],"u":[{},[0,0,1]]}],"i":[{"d":[{},[0,0,2]],"g":[{"é":[{},[0,0,2]]}],"l":[{"l":[{"a":[{},[0,0,0,1]]}]}],"n":[{"g":[{},[0,0,2,1]]}],"p":[{},[0,0,2,1]],"v":[{"á":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1,2]]}],"o":[{"m":[{"l":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{"s":[{},[0,0,2,1]]}],"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"r":[{".":[{},[0,0,0,1]]}]}],"u":[{"r":[{"a":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}],"t":[{},[0,0,2,1]]}],"ú":[{"s":[{},[0,0,2]],"t":[{},[0,0,2,1]]}]}],"u":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]]}],"ú":[{"j":[{},[0,0,1]],"s":[{},[0,0,1,2]],"t":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,2,1,2]],"l":[{"t":[{},[0,0,1]]}],"n":[{"n":[{},[0,0,1]]}],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"ű":[{"r":[{},[0,0,1]]}],"v":[{"e":[{"n":[{},[1]]}]}],"x":[{"a":[{},[0,0,2]]}],"z":[{"u":[{},[1]]}]}],"o":[{"á":[{"r":[{},[0,0,0,2]]}],"b":[{"r":[{},[0,0,1,2]]}],"c":[{"s":[{},[0,0,2]]}],"d":[{"r":[{},[0,0,1,2]],"ú":[{},[0,0,2]]}],"g":[{"á":[{},[0,2]],"r":[{"a":[{"f":[{},[0,0,0,2]]}],"á":[{"f":[{".":[{},[0,0,1,2]],"f":[{},[0,0,1,2]]}]}]}],"y":[{},[0,2]]}],"i":[{"k":[{},[0,0,2]]}],"k":[{"á":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}],"l":[{"d":[{},[0,3]],"i":[{"v":[{},[0,0,2,1,2]]}],"k":[{},[0,0,0,1,2]],"o":[{"k":[{"k":[{},[0,0,0,1]]}]}],"ó":[{},[0,2]],"v":[{},[0,3]]}],"m":[{"a":[{"r":[{},[0,0,2]]}],"á":[{"r":[{"t":[{},[0,0,2,1]]}]}],"i":[{"l":[{},[0,0,2]]}],"ö":[{},[0,0,2]]}],"n":[{"a":[{"d":[{},[0,0,2]],"g":[{},[0,0,2,1,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1]]}],"á":[{"t":[{},[0,0,2,1]]}],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2]]}],"i":[{"m":[{},[0,0,0,0,0,1]],"n":[{},[0,0,2]]}],"k":[{},[0,0,0,1,2]],"o":[{"p":[{},[0,0,2]],"s":[{"z":[{"t":[{},[0,0,2,1]]}]}]}],"ö":[{},[0,0,2]],"s":[{"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"r":[{},[0,0,0,1,2]]}]}],"p":[{"e":[{},[0,0,2]],"r":[{},[0,0,1,2]]}],"r":[{"a":[{},[0,0,2,1]],"i":[{"k":[{"o":[{},[0,0,2,1,2]]}]}]}],"s":[{"o":[{},[0,0,2]],"z":[{"f":[{},[0,0,1,0,2]]}]}],"t":[{"e":[{},[0,2]]}],"x":[{"i":[{"d":[{"j":[{},[0,0,2]],"t":[{},[0,0,2]]}]}]}]},[0,1]],"ó":[{"a":[{"d":[{},[0,0,0,2]],"p":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"t":[{"a":[{},[0,0,0,0,1,2]]}]}],"b":[{"á":[{},[0,2]],"e":[{"s":[{},[0,2]]}],"é":[{},[0,2]],"í":[{},[0,2]],"l":[{},[0,2,1]],"o":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"r":[{},[0,2,1,2]],"u":[{},[0,2]],"ú":[{},[0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]]}],"c":[{"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"s":[{"k":[{},[0,3]]}],"u":[{},[0,2]]}],"d":[{"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"í":[{},[0,2]],"ó":[{},[0,2]],"ö":[{},[0,2]],"r":[{"á":[{},[0,0,1]]}],"ú":[{},[0,2]],"ü":[{},[0,2]],"z":[{},[0,2]]}],"é":[{"g":[{},[0,2]],"k":[{},[0,2]],"l":[{},[0,2]],"p":[{},[0,2]],"s":[{},[0,2]],"v":[{".":[{},[0,2]]}]}],"f":[{"á":[{},[0,2]],"e":[{},[0,2]],"i":[{},[0,2]],"l":[{},[0,2,1]],"ó":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"r":[{},[0,2,1,2]],"u":[{},[0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]]}],"g":[{"r":[{},[0,0,1,2]]}],"h":[{"a":[{},[0,2]],"á":[{},[0,2]],"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"í":[{},[0,2]],"ó":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"u":[{},[0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]]}],"i":[{"g":[{},[0,0,0,2]],"p":[{},[0,2]],"s":[{},[0,2]],"z":[{},[0,2]]}],"í":[{"v":[{},[0,0,0,2]]}],"j":[{"e":[{},[0,2]],"o":[{},[0,2]],"ó":[{},[0,2]]}],"k":[{"a":[{"d":[{},[0,0,2]],"j":[{},[0,0,2]],"r":[{"c":[{},[0,0,0,1]]}],"s":[{"z":[{"t":[{},[0,0,2,1]]}]}]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1,2]]}],"i":[{"d":[{},[0,0,2,1,2]]}],"í":[{},[0,2]],"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"o":[{"l":[{"d":[{},[0,0,0,1]]}],"r":[{"t":[{},[0,2]]}]}],"ö":[{},[0,2]],"ő":[{},[0,2]],"ü":[{"z":[{},[0,0,2]]}]}],"l":[{"a":[{},[0,2]],"á":[{},[0,2]],"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"o":[{},[0,2]]}],"m":[{"e":[{},[0,2]],"ó":[{},[0,2]],"u":[{},[0,2]],"ú":[{},[0,2]],"ű":[{},[0,2]]}],"n":[{"e":[{},[0,2]],"ó":[{},[0,2]],"ö":[{},[0,2]]}],"o":[{"k":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"s":[{},[0,0,1,2]]}],"r":[{"a":[{"b":[{},[0,0,2]],"g":[{},[0,2]],"k":[{},[0,2]],"n":[{},[0,2]],"p":[{},[0,2]],"s":[{},[0,0,2]]}],"á":[{"d":[{},[0,2]]}],"e":[{},[0,2]],"é":[{},[0,2]],"i":[{"a":[{},[0,2]]}],"o":[{},[0,2]],"ö":[{},[0,2]],"u":[{},[0,2]]}],"s":[{"a":[{"j":[{},[0,0,2,1]]}],"e":[{"l":[{},[0,0,2]]}],"i":[{".":[{},[0,0,2]]}],"l":[{"á":[{},[0,0,1]]}],"ó":[{},[0,0,2]],"s":[{},[0,0,0,3]],"t":[{"á":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"ú":[{},[0,2]],"z":[{},[0,0,1,0,2]]}],"t":[{"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"í":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"r":[{},[0,2,1,2]],"u":[{},[0,2]],"ú":[{},[0,2]],"ü":[{},[0,2]],"ű":[{},[0,2]]}],"u":[{"g":[{},[0,2]],"n":[{},[0,2]],"r":[{},[0,2]],"t":[{},[0,2]]}],"v":[{"á":[{"r":[{},[0,2]],"s":[{},[0,2]]}],"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"í":[{},[0,2]],"ö":[{},[0,2]]}],"z":[{"á":[{"r":[{},[0,2]]}],"e":[{},[0,2]],"s":[{},[0,2]]}]},[0,1]],"ö":[{"k":[{"ö":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"m":[{"ö":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"ö":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]]}],"z":[{"ö":[{},[0,0,2]]}]},[0,1]],"ő":[{"d":[{"r":[{},[0,0,1]]}],"h":[{"a":[{},[0,2]]}],"k":[{"é":[{},[0,2]],"u":[{},[0,2]]}],"r":[{"a":[{},[0,2]],"i":[{},[0,0,2,0,2]]}],"s":[{"p":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"t":[{"e":[{},[0,2]],"é":[{},[0,2]]}],"v":[{"a":[{},[0,2]],"á":[{},[0,2]]}]},[0,1]],"p":[{"a":[{"c":[{"s":[{"e":[{},[0,0,0,2]]}]}],"r":[{".":[{},[1,2]],"a":[{".":[{},[1]],"l":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]],"n":[{},[1,2]],"t":[{},[1,2]]}],"b":[{},[1]],"e":[{"n":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]}],"é":[{},[1,2]],"h":[{},[1,2]],"i":[{"l":[{},[1]],"n":[{},[1,2]],"s":[{},[0,0,0,2]]}],"m":[{},[1,2]],"n":[{},[1,2]],"o":[{"k":[{},[0,2]],"n":[{},[0,2]]}],"r":[{},[1]],"s":[{},[1,2]],"t":[{"a":[{},[0,2]],"á":[{},[1,2]],"e":[{},[1,2]],"ó":[{},[1,2]]}],"u":[{},[1,2]]}],"u":[{},[0,0,0,0,2]]}],"á":[{"n":[{"k":[{},[0,0,0,0,0,2]],"n":[{},[0,0,0,0,1]]}],"t":[{"m":[{},[0,0,1]]}]}],"e":[{"f":[{},[0,2,1]],"g":[{"y":[{},[0,0,1,2]]}],"l":[{"u":[{},[0,0,1,2]]}],"s":[{"é":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"f":[{"l":[{},[0,0,1]],"u":[{},[0,0,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"k":[{"l":[{},[0,0,0,1]]}],"r":[{"t":[{"e":[{"l":[{},[0,0,0,0,2]]}],"ő":[{},[0,0,0,0,2,1]]}]}]}],"ö":[{"l":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"p":[{"a":[{"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,0,1]]}]}],"ö":[{},[0,0,2]]}],"r":[{"o":[{"f":[{},[0,1]],"g":[{},[0,1]],"j":[{},[0,1]],"p":[{},[0,0,2]],"t":[{},[0,1,2]]}]}],"s":[{"z":[{"a":[{"l":[{},[0,0,0,0,1,2]]}],"á":[{"l":[{},[0,0,0,0,1]]}],"e":[{"m":[{"b":[{},[0,0,2,0,1]]}]}],"i":[{"p":[{},[0,0,2]]}],"í":[{},[0,0,2,0,1,2]],"o":[{"r":[{},[0,0,0,0,1]]}]}]}],"u":[{"g":[{},[0,2,1]]}]}],"r":[{"a":[{"l":[{"o":[{},[0,0,0,0,0,2]]}],"m":[{"a":[{},[1,2]],"á":[{},[1,2]],"i":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"t":[{"a":[{"l":[{},[0,0,0,2]],"n":[{"y":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"s":[{},[0,0,0,2,1]],"t":[{},[0,0,0,2,1]]}],"á":[{"l":[{},[0,0,0,2]]}],"b":[{},[1,2]],"c":[{},[1,2]],"d":[{},[1,2]],"e":[{"l":[{},[0,0,0,2]]}],"é":[{},[1,2]],"f":[{},[1,2]],"i":[{"l":[{"l":[{},[2,3]]}]},[1,2]],"m":[{},[1,2]],"o":[{"l":[{},[0,0,0,2,1]],"z":[{".":[{},[1]]}]}],"ö":[{},[0,0,0,2,1,2]],"p":[{},[1,2]],"r":[{},[1,2]],"ü":[{},[1,2]]}]}],"á":[{"d":[{"i":[{"ó":[{"k":[{},[0,0,0,0,0,2]],"t":[{},[0,0,0,0,0,2]]}]}]}],"f":[{"a":[{},[0,0,0,2,1,2]]}],"g":[{"a":[{"l":[{},[0,0,0,2,1]]}],"á":[{"l":[{},[0,0,0,2,1]],"r":[{"a":[{"k":[{},[0,0,0,2,1,2]]}],"o":[{},[0,0,0,2,1,2]]}],"t":[{"o":[{},[0,0,0,2,1]]}],"z":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"g":[{},[0,0,0,0,1]],"o":[{"l":[{},[0,0,0,2,1]]}],"ó":[{"r":[{},[0,0,0,2,1,2]]}],"ö":[{},[0,0,0,2]]}],"l":[{"a":[{},[0,0,0,2,1]],"e":[{},[0,0,0,2,1,2]]}],"n":[{"n":[{},[1,2]],"y":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,0,0,2]]},[1,2]]}]}],"c":[{"h":[{},[0,0,2]]}],"e":[{"i":[{},[0,2]]}],"g":[{"a":[{},[1]]}],"i":[{"n":[{"c":[{},[0,0,0,0,2]]}],"z":[{"o":[{},[0,0,0,2]]}]}],"k":[{"a":[{"s":[{"z":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,1]]}],"e":[{},[0,0,0,0,1]]}],"o":[{".":[{},[2]],"b":[{},[2]],"d":[{"a":[{".":[{},[1,2]]}],"á":[{},[1,2]]}],"g":[{"r":[{},[0,0,0,1,2]]}],"k":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2,1]],"é":[{"r":[{},[0,0,0,2]]}]}],"l":[{"a":[{},[0,0,0,2,1]]}],"m":[{"a":[{},[0,0,0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"ó":[{"k":[{"e":[{},[0,0,0,2]]}],"n":[{"o":[{},[0,2]]}]}],"r":[{"i":[{},[1]]}],"s":[{"a":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"i":[{"l":[{},[0,0,2]]}],"s":[{},[0,0,0,3]],"ü":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"t":[{"é":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"z":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,1,2]]}],"ö":[{},[0,0,2,1,2]],"ü":[{"r":[{},[0,0,2]]}]}],"u":[{"s":[{"z":[{"e":[{},[0,0,0,2]]}]}]}]}],"s":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"d":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"o":[{},[0,0,1,2]]}],"g":[{},[0,2,1,2]],"j":[{"a":[{},[0,0,1]],"k":[{},[0,0,1]]}],"k":[{"e":[{},[0,0,0,2,1]],"o":[{"l":[{},[0,0,0,2]]}]}],"l":[{"a":[{},[0,0,1,2]],"f":[{},[0,0,1]],"j":[{},[0,2,1]],"k":[{},[0,0,1]],"m":[{},[0,0,1]]}],"m":[{"b":[{},[0,0,1]]}],"n":[{"a":[{},[0,2,1]],"o":[{},[0,2,1]],"t":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"p":[{"á":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"r":[{"á":[{},[0,0,1,2]]}],"s":[{"s":[{},[0,0,1]]}],"u":[{"t":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"g":[{"g":[{"y":[{},[0,0,1]]}],"y":[{"ú":[{"t":[{},[0,0,0,0,0,1]]}]}]}],"l":[{"l":[{},[0,0,1]]}],"p":[{"o":[{},[0,0,1,2]]}],"r":[{"a":[{"k":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"b":[{},[0,2,1]],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"k":[{"é":[{},[0,2,1]]}],"n":[{},[0,2,1]],"o":[{"n":[{},[0,0,0,2]]}],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{"s":[{},[0,0,0,0,0,0,1]]},[0,2,1,2]]}],"t":[{"a":[{},[0,0,1,2,1,2]],"k":[{},[0,0,1]],"l":[{},[0,2,1]],"v":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"d":[{"z":[{},[0,0,1]]}],"f":[{"f":[{},[0,0,1]]}],"g":[{"e":[{},[0,2,1]],"é":[{"r":[{},[0,0,1,2]]}]}],"k":[{"e":[{".":[{},[0,2,1,2]]}]}],"l":[{"f":[{},[0,0,1]],"m":[{},[0,0,1]],"o":[{},[0,2,1]]}],"m":[{"l":[{},[0,2,1]]}],"n":[{"c":[{},[0,2,1]],"e":[{},[0,2,1]],"g":[{},[0,0,1]]}],"p":[{"i":[{},[0,2,1,2]],"r":[{"i":[{},[0,0,1]]}]}],"r":[{"ő":[{},[0,0,1]]}],"s":[{"e":[{"t":[{},[0,0,1,2]]}],"é":[{},[0,0,1]]}]}],"é":[{"g":[{"e":[{"l":[{},[0,0,0,2,0,2]]}],"é":[{"s":[{},[0,0,0,2]]}],"i":[{"d":[{},[0,0,0,2]]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"l":[{"v":[{},[0,0,1]]}],"r":[{".":[{},[0,2,1]],"i":[{},[0,2,1,2]],"t":[{"é":[{},[0,2,1]]}]}],"v":[{"e":[{".":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"é":[{"n":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"h":[{},[0,0,1]],"i":[{".":[{},[0,0,0,2]]}]}]}],"f":[{"ö":[{"l":[{},[0,0,0,0,0,2]]}],"r":[{},[0,0,1]]}],"h":[{"i":[{"n":[{},[0,0,2]],"s":[{},[0,0,2]]}]}],"i":[{"d":[{"o":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1]]},[0,0,0,2]],"n":[{"d":[{},[0,0,1]],"f":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"ó":[{},[0,0,0,0,2]],"p":[{"a":[{"r":[{},[0,0,0,2]]},[0,2]]}],"r":[{"o":[{},[0,0,1]]}],"s":[{"t":[{"e":[{"n":[{},[0,2,1]]}]}]}],"t":[{"a":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1,2]]}]}],"k":[{"a":[{"t":[{"u":[{},[0,1,2]]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"l":[{"a":[{"g":[{},[0,0,2]],"t":[{},[0,1,2]]}]}],"m":[{"e":[{".":[{},[1]],"k":[{},[1]],"r":[{"e":[{},[1]]}]}],"é":[{"r":[{"v":[{},[1]]}]}],"o":[{},[2]],"ű":[{},[2]]}],"o":[{"b":[{},[0,2,1]],"l":[{},[0,2,1,2]],"r":[{"c":[{},[0,2,1]],"d":[{},[0,2,1]],"o":[{"s":[{"z":[{},[0,0,0,2]]}]}],"r":[{"a":[{},[0,2,1]],"ó":[{},[0,2,1]]}],"v":[{},[0,0,1]]}],"s":[{"k":[{"o":[{},[0,2,1]]}],"z":[{},[0,0,1]]}],"t":[{"t":[{},[0,2,1]]}]}],"ó":[{"r":[{"á":[{},[0,0,1,2]]}]}],"ö":[{"b":[{},[0,2,1]],"c":[{},[0,2,1,2]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{"d":[{},[0,0,1]],"e":[{},[0,0,1]]},[0,0,0,2]],"s":[{},[0,0,1]],"v":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"e":[{"k":[{},[0,1,2]]}],"r":[{},[0,0,0,2]],"u":[{"r":[{},[0,1,2]]}]}],"s":[{"p":[{},[0,0,1,2]],"t":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]]}],"z":[{"e":[{"r":[{"e":[{"i":[{},[0,0,0,0,1,2]],"k":[{},[0,0,0,0,1,2]],"m":[{},[0,0,0,0,1]],"s":[{},[0,0,0,0,1,2]]}]}]}],"i":[{"g":[{},[0,0,3]],"l":[{},[0,0,3]]}],"í":[{},[0,0,3]],"ó":[{},[0,0,3]],"ö":[{},[0,0,3]],"ő":[{},[0,0,3]],"ú":[{},[0,0,3]],"ű":[{},[0,0,3]]}]}],"t":[{"a":[{"s":[{"z":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,1]]}],"á":[{"p":[{},[1]]}],"e":[{"n":[{"h":[{},[1]],"o":[{},[0,0,0,0,2,1]]}]}],"i":[{"l":[{},[0,1,2]]}],"r":[{"e":[{"z":[{},[0,0,1]]}],"é":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}],"v":[{},[1]]}],"u":[{"d":[{},[0,2,1]],"j":[{"j":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]]},[0,0,0,2]]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"g":[{},[0,2,1]],"s":[{"t":[{},[0,0,1]]}],"t":[{"ő":[{"t":[{},[0,2,1,2]]}]}],"z":[{},[0,2,1]]}],"v":[{"a":[{"d":[{"á":[{"s":[{"s":[{},[0,0,0,0,2,1]]}]}]}]}],"i":[{"n":[{},[0,1]]}],"í":[{"z":[{},[0,0,0,0,0,1]]}]}],"z":[{"a":[{"k":[{"o":[{},[0,0,0,0,2,1]]}],"p":[{"á":[{},[0,0,0,0,2,1,2]],"e":[{},[0,0,0,0,2,1]]}]}],"á":[{"r":[{"á":[{},[0,0,3]],"k":[{},[0,0,0,1]],"l":[{},[0,0,3]],"ú":[{},[0,0,3]]}]}],"e":[{"g":[{"y":[{},[0,0,0,1,2]]}],"l":[{"v":[{},[0,2,0,1]]}],"n":[{"e":[{},[0,0,3]]}],"s":[{"e":[{"m":[{},[0,0,0,1]]}]}]}],"é":[{"j":[{},[0,2]]}],"f":[{"é":[{"r":[{},[0,0,0,2]]}]}],"i":[{"m":[{"i":[{},[0,2]]}],"n":[{"g":[{},[0,0,0,1]]}],"s":[{"k":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}]}],"k":[{"l":[{},[0,0,0,1]],"ö":[{"v":[{},[0,0,0,2,1,2]]}],"ú":[{},[0,0,0,2,1]]}],"ö":[{"l":[{},[0,0,0,1]],"s":[{},[0,0,0,1]]}],"s":[{},[0,0,0,3]],"t":[{"a":[{"t":[{"i":[{},[0,0,0,2]]}]}],"á":[{"r":[{"a":[{"s":[{},[0,0,0,0,1]]}],"b":[{},[0,0,0,2,1]],"t":[{},[0,0,0,2]]}]}],"é":[{"k":[{"n":[{},[0,0,0,2,1]]}],"r":[{".":[{},[0,0,0,2,1]]}]}],"i":[{"l":[{"l":[{},[0,0,0,2,1]]}],"n":[{"a":[{"i":[{},[0,0,0,0,1,2]]}]}]}],"ö":[{"l":[{},[0,0,0,2,1]]}],"ő":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"ü":[{"z":[{},[0,0,0,2]]}]}],"ü":[{"g":[{},[0,2,0,1,2]],"t":[{},[0,2]]}],"ű":[{"r":[{"ö":[{"d":[{"n":[{},[0,0,3]]}]}]}]}]}]}],"t":[{"a":[{"c":[{"é":[{},[0,0,1,2]]}],"d":[{"ó":[{},[0,0,1,2]]},[0,0,0,1,2]],"g":[{"r":[{},[0,0,0,1,2]],"y":[{"a":[{},[0,0,1]]}]}],"k":[{"k":[{},[0,2,1]],"n":[{},[0,2,1]]}],"l":[{".":[{},[1,2]],"a":[{"d":[{},[0,0,0,2]]}],"á":[{"r":[{"ú":[{},[0,0,0,2,1,2]]}]}],"b":[{},[0,2]],"e":[{"l":[{},[0,0,0,2,1]]}],"é":[{},[0,0,0,0,0,2]],"h":[{},[0,2]],"i":[{"n":[{"a":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"j":[{},[0,2]],"k":[{},[0,2]],"l":[{"o":[{},[0,0,1]]}],"m":[{},[1,2]],"n":[{},[1,2]],"o":[{},[0,2]],"ó":[{},[0,0,0,2,1,2]],"r":[{},[1,2]],"t":[{},[0,2,0,0,0,2]],"u":[{},[0,2]]}],"n":[{"ó":[{},[0,0,1]],"t":[{},[0,0,1]]}],"r":[{"a":[{},[0,2,1]]}],"u":[{},[0,2,1]]}],"á":[{"c":[{"s":[{".":[{},[0,0,1]]}]}],"g":[{".":[{},[0,0,1]],"a":[{},[0,0,1,2]]}],"n":[{"a":[{"t":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"r":[{"a":[{"k":[{},[0,0,0,2]],"m":[{},[0,2,1,2]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"á":[{"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"i":[{"a":[{},[0,2,1,2]],"g":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"u":[{"k":[{},[0,0,0,2]]}],"ú":[{},[0,0,0,2]]}],"s":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"z":[{},[0,0,0,2,3]]}],"t":[{"a":[{"l":[{},[0,0,0,2]]}],"f":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"l":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1]],"e":[{"g":[{},[0,0,0,2]],"m":[{"z":[{},[0,2]]}],"n":[{"g":[{},[0,0,0,2]]}],"s":[{"é":[{},[0,0,0,2]]}],"x":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2]],"r":[{".":[{},[0,0,0,2,1]]}]}],"i":[{"n":[{"j":[{},[0,0,0,2]]}]}],"j":[{"á":[{},[0,0,1]]}],"l":[{"e":[{"n":[{},[0,2,1]]}]}],"m":[{"é":[{"l":[{"y":[{},[0,0,2]]}]}]}],"o":[{},[0,0,0,2]],"ő":[{"z":[{},[0,0,0,2]]}]}],"m":[{"e":[{"l":[{},[0,2,1,2]]}],"l":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"e":[{"z":[{},[0,2,1,2]]}],"ő":[{},[0,2,1]]},[2]],"s":[{"e":[{"t":[{"e":[{},[0,2,1,2]]}]}]}],"z":[{"r":[{},[0,0,1]]}]}],"é":[{"g":[{"e":[{},[0,2,1]]},[0,0,0,2]],"l":[{"e":[{},[0,0,1,2]],"m":[{},[0,0,1]]}],"r":[{"e":[{"t":[{},[0,2,1,2]]}],"z":[{},[0,2,1]]}],"t":[{"e":[{"k":[{},[0,0,0,2]]}],"t":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"h":[{"o":[{"t":[{},[0,1,2]]}]}],"i":[{"d":[{},[0,2,1]],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]}],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1,2]],"r":[{},[0,0,1]],"u":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"p":[{},[0,0,1]]}],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]]}],"p":[{"a":[{},[0,0,1,2]]}],"r":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]],"ó":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]],"m":[{},[0,2,1]],"z":[{"a":[{},[0,0,1]],"o":[{},[0,0,1,2]]}]}]}],"í":[{"g":[{},[0,2,1]],"z":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"o":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"r":[{},[0,0,1]]}],"o":[{"b":[{"e":[{},[0,0,1]]},[0,0,0,2]],"k":[{"a":[{"j":[{},[0,0,0,2,1]],"k":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2,1]]}]}],"n":[{"á":[{},[0,0,0,2,1,2]]}],"p":[{"l":[{"a":[{},[0,0,0,0,2]]}]}],"r":[{"a":[{"s":[{},[0,0,0,2,1]]}],"á":[{"l":[{},[0,0,0,2]]}],"i":[{"l":[{},[0,0,0,2]]}]}],"s":[{"z":[{"f":[{},[0,0,0,1,0,2]]},[2]]}],"v":[{},[0,2,1]]}],"ó":[{"a":[{},[0,0,0,0,2]],"f":[{},[0,0,0,1,2]],"k":[{"á":[{"n":[{},[1,2]]}]}],"n":[{"é":[{},[0,2,1,2]],"n":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{},[0,0,0,1,2]],"r":[{"á":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ö":[{"n":[{"t":[{},[0,0,1]]}],"s":[{},[0,2,1]]}],"ő":[{"r":[{"l":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]]}],"t":[{"a":[{"d":[{},[1]],"m":[{},[1]],"n":[{"á":[{"s":[{},[0,0,0,0,2,1,2]]}],"é":[{},[0,0,0,0,2,1]],"ó":[{},[0,0,0,0,2,1,2]]}]}],"e":[{"g":[{},[0,0,2,1]]},[2]],"i":[{"n":[{"a":[{},[0,0,2,1,2]],"g":[{},[0,0,2,1]]}]}],"r":[{"a":[{},[0,0,1]],"ó":[{},[0,0,1]]}],"u":[{"k":[{},[1]],"n":[{},[1]]}],"y":[{"i":[{},[0,0,0,0,1]]}]}],"u":[{"g":[{},[0,2,1]],"n":[{"d":[{},[0,2,1]],"i":[{},[0,0,0,2,1]]}],"r":[{"a":[{"l":[{},[0,0,0,2]]}],"á":[{"n":[{},[0,0,1,2]]}]}]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"d":[{},[0,0,1]]}],"s":[{"t":[{},[0,0,1]]}],"t":[{},[0,2,1]]}],"z":[{"é":[{},[0,1,2]],"i":[{},[0,1,2]]}]}],"u":[{"g":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]]}],"m":[{"a":[{"b":[{},[0,0,2]],"c":[{},[0,0,2]],"d":[{},[0,0,2,1]],"f":[{},[0,0,2]],"g":[{},[0,0,2,1]],"l":[{},[0,0,2]],"m":[{},[0,0,2,1]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1,2]]}],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"é":[{"l":[{},[0,0,2]],"r":[{"é":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2,1,2]],"l":[{"l":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1]],"n":[{"j":[{},[0,0,0,1]]}],"p":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]],"z":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,0,1,2]],"ü":[{},[0,0,2]]}],"n":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"u":[{},[0,0,2]]}],"s":[{"s":[{"z":[{"e":[{},[0,0,0,3]]}]}]}],"t":[{"a":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"z":[{"s":[{},[0,0,2]]}]},[0,1]],"ú":[{"b":[{"á":[{},[0,2]],"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"o":[{},[0,2]],"ö":[{},[0,2]],"r":[{},[0,2,1]]}],"c":[{"i":[{},[0,2]],"í":[{},[0,2]]}],"d":[{"á":[{},[0,2]],"e":[{},[0,2]],"o":[{},[0,2]],"z":[{},[0,2]]}],"é":[{"l":[{},[0,2]]}],"f":[{"r":[{},[0,0,1]]}],"h":[{"a":[{},[0,2]],"á":[{},[0,2]],"e":[{},[0,2]],"i":[{},[0,2]],"ö":[{},[0,2]],"ő":[{},[0,2]],"u":[{},[0,2]],"ú":[{},[0,2]]}],"i":[{"f":[{},[0,2]]}],"j":[{"e":[{},[0,2]],"í":[{},[0,0,2]],"ó":[{},[0,2]]}],"k":[{"e":[{},[0,2]],"í":[{},[0,2]],"l":[{},[0,2,1]],"ó":[{},[0,2]],"ö":[{},[0,2]],"u":[{},[0,2]]}],"m":[{"e":[{},[0,2]],"ó":[{},[0,2]],"u":[{},[0,2]],"ű":[{},[0,2]]}],"n":[{"e":[{},[0,2]],"é":[{},[0,2]],"ö":[{},[0,2]]}],"r":[{"e":[{},[0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,2]]}],"s":[{"e":[{},[0,2]],"o":[{},[0,2]],"p":[{},[0,2,1]]}],"t":[{"a":[{},[0,2]],"á":[{},[0,2]],"e":[{},[0,2]],"é":[{},[0,0,2]],"í":[{},[0,2]],"ö":[{},[0,2]],"ú":[{},[0,2]]}],"v":[{"e":[{},[0,2]],"é":[{},[0,2]],"i":[{},[0,2]],"o":[{},[0,2]]}],"z":[{"e":[{},[0,2]]}]},[0,1]],"ü":[{"c":[{"s":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[0,1]],"ű":[{"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[0,1]],"v":[{"a":[{"c":[{"s":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,0,1]]}]}],"d":[{"é":[{},[1,2]]}],"r":[{"a":[{"i":[{},[0,0,0,2,1]],"j":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"i":[{"n":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2]],"s":[{},[0,0,0,0,1]]}],"t":[{"a":[{"n":[{},[0,0,0,2,1,2]]}],"e":[{},[0,0,0,2,1,2]],"i":[{"n":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2,1,2]],"ö":[{},[0,0,0,2,1]]}]}],"á":[{"s":[{".":[{},[1,2]],"b":[{},[1,2]],"é":[{},[1,2]],"n":[{},[1,2]],"r":[{},[1,2]],"s":[{},[1,2]]}]}],"e":[{".":[{},[0,2]]}],"o":[{"t":[{},[1]]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"s":[{},[0,0,0,0,2]]}],"ő":[{"é":[{},[0,0,0,0,2]]}],"r":[{"é":[{},[0,0,2]]}]}],"x":[{"a":[{"b":[{},[0,2,1]],"d":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,0,1]]}],"á":[{"g":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"f":[{},[0,2,1]],"g":[{},[0,2,1]],"x":[{},[0,2,1]]}],"é":[{"p":[{},[0,2,1]]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"m":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,0,0,2]]}],"o":[{"b":[{},[0,2,1]],"p":[{},[0,2,1]]}],"ö":[{"d":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"l":[{},[0,2,1]]}]}],"z":[{"a":[{"k":[{"n":[{},[0,0,1]]}],"l":[{"a":[{"g":[{},[0,0,0,0,0,2,1]]}],"k":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"á":[{"r":[{"n":[{"y":[{},[0,0,1]]}]}]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"d":[{"á":[{},[0,0,0,2,1,2]],"é":[{"k":[{},[0,0,0,2,1]]}]}],"g":[{"y":[{},[0,0,1]]}],"l":[{"e":[{"m":[{},[0,2,1,2]],"t":[{"e":[{"l":[{},[0,0,0,0,0,2]]}]}]}],"é":[{"r":[{},[0,2,1,2]]}],"ő":[{"í":[{},[0,2,1,2]]}]}],"m":[{"b":[{"e":[{"r":[{},[0,0,1]]}]}]}],"n":[{"e":[{"g":[{},[0,0,0,0,0,2]]}],"n":[{},[0,0,0,0,3]]}],"s":[{"á":[{},[0,0,0,2,1,2]],"e":[{"m":[{"é":[{},[0,2,1]]}]}]}],"v":[{},[0,2,1]]}],"é":[{"d":[{},[0,2]],"g":[{},[0,2,1]],"j":[{},[1,2]],"k":[{},[1,2]],"l":[{},[0,2]],"p":[{},[0,2,1,2]],"s":[{"í":[{},[1,2]]}]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"a":[{"l":[{},[1]],"t":[{"o":[{"t":[{},[1]]}]}]}]}],"i":[{"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]]}],"n":[{"f":[{},[0,0,1]],"t":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]],"p":[{},[0,0,0,1,2]]}]}],"m":[{"o":[{"k":[{},[1]]}],"u":[{"k":[{},[1]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"ú":[{},[1]]}],"o":[{"k":[{"t":[{},[0,0,1]]}],"l":[{"á":[{},[1,2]]}],"m":[{"a":[{},[0,0,0,2,1]],"á":[{"l":[{},[0,0,0,2]]}],"b":[{},[1,2]],"é":[{},[1]],"f":[{},[1]],"m":[{},[1,2]],"n":[{},[1,2]],"r":[{},[1,2]],"s":[{},[1]],"t":[{},[1,2]],"z":[{},[1]]}],"p":[{},[0,0,0,1,2]],"s":[{"z":[{"t":[{"a":[{},[0,0,0,1]]}]}]},[0,2]],"t":[{"ó":[{},[1]]}]}],"ó":[{"d":[{"a":[{},[0,0,0,2,1,2]]}],"r":[{"á":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"a":[{"d":[{},[0,2,0,1]],"i":[{"k":[{},[0,0,0,0,2]]}],"k":[{"n":[{},[0,2]]}],"l":[{"l":[{},[0,2,0,1]]}],"r":[{"a":[{},[0,0,0,1]]}],"u":[{"t":[{"ó":[{"k":[{},[0,0,0,0,3,2]]}]}]}]}],"á":[{"g":[{},[0,0,4,1]],"l":[{},[0,2,0,1]]}],"e":[{"c":[{},[0,2]],"m":[{"b":[{"e":[{},[0,2,0,1]]}]}],"v":[{},[0,2]]}],"é":[{"t":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{"l":[{},[0,2]],"m":[{"p":[{},[0,2,0,1]]}],"s":[{"t":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,2]]}],"z":[{},[0,2]]}],"o":[{"r":[{},[0,0,3]]}],"ő":[{},[0,2,0,1]],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,3]]}],"ü":[{"l":[{},[0,2,0,1]]}],"z":[{"e":[{},[0,0,3]]}]}],"t":[{"o":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"u":[{"d":[{"v":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,0,0,0,1]]}]}],"ú":[{"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1,2]],"t":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"z":[{"i":[{},[1]],"í":[{},[1]],"o":[{"t":[{},[1]]}]}]}]}],"í":[{".":[{},[2]],"a":[{},[0,1]],"á":[{},[0,1]],"b":[{"a":[{"l":[{},[0,0,0,2,1]]}],"i":[{"s":[{},[0,2]]}],"o":[{"r":[{"a":[{"s":[{},[0,0,0,2,1]]}]}]}]}],"c":[{"i":[{"u":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}]}],"d":[{"a":[{"c":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"l":[{"a":[{"g":[{},[0,0,0,0,0,2,1]]}]},[0,0,1,2]],"n":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"á":[{"g":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"é":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"z":[{},[0,2,1]]}]}],"i":[{"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"n":[{},[0,2,1]],"r":[{},[0,2,1,2]]}],"í":[{"v":[{},[0,0,1]]}],"o":[{"l":[{},[0,2,1]],"m":[{},[0,2,1]],"s":[{},[0,2,1]]}],"ö":[{"s":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"t":[{},[0,0,1]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"g":[{},[0,0,1]],"n":[{},[0,0,1]],"z":[{},[0,0,1]]}],"z":[{"á":[{},[0,0,3]],"s":[{},[0,0,3]]}]}],"e":[{},[0,1]],"é":[{"l":[{"e":[{},[0,0,2]]}]},[0,1]],"g":[{"a":[{"g":[{},[0,2,1,2]]}],"e":[{"p":[{},[0,0,1,2]],"s":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,2,2]]}],"o":[{"p":[{},[0,2,1]]}],"t":[{"r":[{},[0,0,1]]}],"y":[{"á":[{},[0,0,0,0,2]]}]}],"i":[{"r":[{"o":[{},[0,0,2]]}]},[0,1]],"í":[{},[0,1]],"j":[{"a":[{"d":[{"á":[{},[0,2,1,2]],"ó":[{},[0,2,1,2]]}],"j":[{},[0,2,1,2]],"k":[{"c":[{},[0,2,1]]}],"l":[{},[0,2,1,2]],"n":[{"y":[{},[0,0,1]]}],"r":[{},[0,2,1,2]],"u":[{},[0,2,1,2]]}],"á":[{"c":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"r":[{"á":[{},[0,2,1]],"e":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,2,1]]}],"s":[{"z":[{"e":[{},[0,0,0,2]],"k":[{"a":[{},[0,0,1]]}]}]},[1,2]],"t":[{"a":[{},[0,2,1]],"e":[{},[0,2,1,2]],"h":[{},[0,2,1]],"l":[{},[0,2,1]],"o":[{"s":[{},[0,0,0,2]]}],"t":[{},[0,2,1]],"u":[{},[0,2,1]],"v":[{},[0,2,1]]}],"z":[{},[0,2,1,2]]}],"e":[{"g":[{},[0,0,1,2]],"l":[{"i":[{},[0,0,0,0,2]]},[0,0,1,2]],"m":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"é":[{"p":[{},[0,0,1]],"r":[{"e":[{},[0,2,1]]},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"m":[{},[0,2,1]],"n":[{"t":[{},[0,2,1]]}],"r":[{"á":[{},[0,0,0,0,0,2]]},[0,2,1]]}],"í":[{"g":[{},[0,0,1]],"n":[{},[0,0,1]]}],"k":[{"r":[{},[0,0,1]]}],"o":[{"d":[{},[0,2,1,2]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"ö":[{"n":[{},[0,0,1]],"s":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1,0,2]]}],"u":[{"g":[{},[0,2,1]],"t":[{},[0,2,1,2]]}],"ú":[{"t":[{},[0,2,1]]}],"ü":[{"g":[{},[0,0,1]],"t":[{},[0,0,1,2]]}]}],"k":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"c":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{},[0,2,1]],"r":[{},[0,0,1]],"s":[{"z":[{},[0,0,1]]},[0,0,0,2]],"v":[{},[0,0,1,2]]}],"á":[{"b":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{},[0,0,1]],"r":[{},[0,2,1,2]]}],"e":[{"g":[{},[0,2,1]],"l":[{},[0,2,1,2]],"m":[{},[0,0,1]],"s":[{},[0,2,1]],"v":[{},[0,0,1]]}],"é":[{"k":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"ő":[{},[0,2,1,2]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"n":[{"g":[{},[0,2,1]]}],"r":[{},[0,2,1,2]]}],"í":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"k":[{"r":[{},[0,0,1,2]]}],"l":[{"u":[{},[0,1,2]]}],"o":[{"l":[{"l":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]]}]}],"ö":[{"l":[{},[0,0,0,2]],"v":[{},[0,2,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"u":[{"g":[{},[0,2,1]],"n":[{"i":[{},[0,2]]}],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"t":[{},[0,2,1,2]]}],"ü":[{"v":[{},[0,0,1,2]]}]}],"l":[{"a":[{"j":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"á":[{"g":[{},[0,2,1,2]],"s":[{"i":[{"k":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"t":[{},[0,2,1]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"e":[{"g":[{},[0,0,1,2]]}],"é":[{"r":[{"z":[{},[0,2,1]]}]}],"i":[{"a":[{"s":[{},[0,0,0,2]]}],"m":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1]]}],"í":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"k":[{"r":[{},[0,0,1]]}],"ö":[{"s":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"s":[{"t":[{},[0,0,1]]}],"t":[{"á":[{"r":[{"k":[{},[0,0,2,1]],"o":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]},[0,0,0,0,2]],"e":[{},[0,0,2,1]],"é":[{},[0,0,2,1,2]]}],"u":[{"r":[{},[0,2,1,2]],"s":[{"a":[{"b":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}]}]}],"m":[{"a":[{"n":[{},[0,0,0,2]],"p":[{},[0,0,0,1]]}],"á":[{"l":[{},[0,2,1,2]],"r":[{"i":[{"s":[{},[0,0,0,2]]}]}],"s":[{"s":[{},[0,0,0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{},[0,2,1,2]],"l":[{"í":[{},[0,0,1]],"m":[{},[0,2,1]]}],"r":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1]],"e":[{"g":[{},[0,0,0,2]]}],"ő":[{},[0,0,1,2]]}],"s":[{"e":[{"m":[{},[0,2,1]]}]}],"v":[{},[0,2,1,2]]}],"é":[{"h":[{"e":[{"t":[{},[0,2,1,2]]}]}],"k":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"é":[{},[0,2,1,2]],"ő":[{".":[{},[0,2,1,2]],"i":[{},[0,2,1,2]]}],"r":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}]}]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,2,1]]}],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]]}],"r":[{"a":[{},[0,2,1]]}],"s":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"í":[{"r":[{},[0,0,1]]}],"k":[{"r":[{},[0,0,1]]}],"o":[{"k":[{},[0,0,1,2,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"p":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"ö":[{"k":[{},[0,0,1]],"l":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1,2]]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"u":[{"r":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"n":[{"n":[{},[0,2,1]]}],"t":[{},[0,2,1]]}]}],"n":[{"a":[{"b":[{},[0,2,1]],"c":[{"é":[{},[0,0,1,2]]}],"d":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"g":[{},[0,2,1,2]],"j":[{},[0,2,1,2]],"k":[{"a":[{},[0,2,1]],"k":[{},[0,2,1]]}],"l":[{"a":[{},[0,0,1,2]],"j":[{},[0,0,1]],"k":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,2,1,2]],"c":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,1]]}],"t":[{"l":[{},[0,0,1]],"t":[{},[0,0,1]]}],"u":[{},[0,2,1]],"z":[{},[0,2,1]]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"c":[{},[0,2,1,2]],"g":[{},[0,2,1]],"l":[{"h":[{"a":[{"j":[{},[0,2]]}]}],"m":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"t":[{"a":[{},[0,0,1,2,1,2]],"c":[{},[0,0,1]],"e":[{},[0,0,1]],"f":[{},[0,0,1]],"h":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"f":[{},[0,2,1]],"g":[{},[0,2,1,2]],"k":[{"e":[{".":[{},[0,2,1,2]]}]}],"l":[{"c":[{},[0,2,1]],"e":[{},[0,2,1,2]],"h":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{"y":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"ö":[{},[0,2,1]],"ő":[{"h":[{},[0,2,1,2]]}],"r":[{},[0,2,1]],"t":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]]}],"v":[{"á":[{},[0,2,1]]}]}],"m":[{"e":[{"l":[{},[0,2,1,2]]}],"l":[{},[0,2,1]],"u":[{},[0,2,1,2]]}],"n":[{"e":[{},[0,2,1]]},[0,0,0,2]],"s":[{"d":[{},[0,2]],"z":[{},[0,2,1,2]]}],"v":[{"é":[{},[0,2,1,2]]}]}],"é":[{"g":[{},[0,0,1]],"l":[{"e":[{},[0,2,1]],"é":[{},[0,0,1]],"ő":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"d":[{},[0,2]],"i":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"ü":[{},[0,2,1]]}],"s":[{"z":[{"a":[{},[0,0,0,2]],"e":[{"r":[{},[0,0,0,2]]}],"i":[{"n":[{"t":[{},[0,0,0,2]]}]}],"o":[{},[0,0,0,2]]}]}],"t":[{"e":[{},[0,2,1]]}],"v":[{"e":[{"n":[{},[0,2,1,2]]}]}]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,2,1,2]]}],"l":[{"l":[{},[0,2,1]]}],"n":[{"d":[{},[0,0,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]]}],"o":[{},[1,2]],"r":[{"á":[{},[0,0,1,2]],"o":[{},[0,2,1]]}],"s":[{"m":[{},[0,2,1]]}],"z":[{},[0,2,1,2]]}],"í":[{"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"n":[{"y":[{"ú":[{},[0,0,3]]}]}],"o":[{"b":[{},[0,2,1]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"l":[{},[0,0,1,2]]}],"ö":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1,2]],"o":[{"k":[{},[0,0,0,0,2,1]]}],"p":[{},[0,0,1,2]],"t":[{},[0,0,1,2,2]],"z":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"g":[{},[0,0,1]]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"l":[{"t":[{},[0,2,1]]}],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]]}],"y":[{"e":[{"c":[{},[0,0,0,1,2]],"g":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1]],"r":[{},[0,0,0,1,2]]}],"i":[{"n":[{"g":[{},[0,0,0,1]]}]}]}]}],"o":[{},[0,1]],"ó":[{"v":[{"o":[{},[0,0,2]]}]},[0,1]],"ö":[{},[0,1]],"ő":[{},[0,1]],"p":[{"a":[{"g":[{},[0,2,1,2]],"n":[{},[0,2,1,2]]}],"á":[{"l":[{"c":[{},[0,2,1]]}]}],"é":[{"l":[{},[0,2,1]],"s":[{"s":[{},[0,0,0,0,3]]}]}],"i":[{"z":[{},[0,2,1,2]]}],"r":[{"o":[{},[0,0,3]]}],"u":[{"j":[{},[0,2,1]],"s":[{"a":[{"n":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,0,3]]}]}]}],"r":[{"a":[{"d":[{"ó":[{},[0,0,1,2]]}],"k":[{"c":[{},[0,0,1]],"n":[{},[0,0,1]],"t":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1,2]],"j":[{},[0,0,1]],"k":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,0,1]],"r":[{},[0,0,0,1]]}],"r":[{"c":[{},[0,0,1]]}],"u":[{},[0,2,1,2]]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"g":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,0,1]],"a":[{"k":[{},[0,0,1]]}],"o":[{},[0,2,1,2]],"u":[{},[0,0,1,2]]}],"s":[{"á":[{"s":[{},[0,2,1]]}],"e":[{},[0,0,0,2]],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"s":[{},[0,0,0,0,3]],"z":[{},[0,2]]}],"t":[{"a":[{},[0,0,1,2,1]],"e":[{},[0,0,1,2,1,2]],"h":[{},[0,2,1]],"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"d":[{"é":[{},[0,0,1,2]]}],"g":[{},[0,2,1,2]],"k":[{"é":[{"s":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,0,0,0,1]]},[0,2,1,2]],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}],"l":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"e":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{"e":[{"m":[{},[0,2,1]]}],"ő":[{},[0,2,1,2]],"z":[{"k":[{},[0,2,1]]}]}],"v":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"j":[{},[0,2,1]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"i":[{},[0,2,1,2]]}],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1,2]]}],"v":[{"h":[{},[0,0,1]]}]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"i":[{"g":[{"a":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{},[0,2,1]],"n":[{"d":[{},[0,0,1]],"f":[{},[0,2,1]],"j":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"a":[{},[0,0,1]]}],"s":[{"z":[{"á":[{},[0,0,0,2,0,1]]}]},[0,2]],"z":[{},[0,2,1,2]]}],"í":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"n":[{"o":[{"k":[{},[1]]}]}],"o":[{"b":[{},[0,2,1,2]],"g":[{},[1]],"k":[{"l":[{},[0,2,1]],"m":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1]],"d":[{},[0,2,1]],"v":[{},[0,2,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{"z":[{},[0,2,1]]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1,2]]}],"ó":[{"á":[{},[0,0,0,0,2]],"d":[{"j":[{},[0,2]],"o":[{},[0,2]],"ó":[{},[0,2]],"t":[{},[0,2]]}],"í":[{},[0,2]],"p":[{},[0,0,0,1,2]],"s":[{"p":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ö":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,2,1,2]],"s":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"s":[{"h":[{},[0,0,1]],"k":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"z":[{"t":[{},[0,0,0,0,0,2]]},[0,0,0,0,2]]}],"t":[{"a":[{"g":[{},[0,0,2,1]],"l":[{"a":[{"p":[{},[0,0,0,1]]}]}]}],"é":[{"t":[{"e":[{},[0,0,0,1,2]]}]}],"h":[{"a":[{},[0,0,0,0,0,2]]}],"r":[{"a":[{"n":[{},[0,0,1]]}],"o":[{},[0,0,1]]}],"u":[{"r":[{},[0,0,2,1,2]]}]}],"u":[{"n":[{"d":[{},[0,2,1]],"i":[{},[0,2,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{"e":[{},[0,0,0,2,1,2]],"s":[{},[0,0,0,0,3]]}],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1,2]],"t":[{"j":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"ü":[{"g":[{},[0,2,1,2]],"l":[{},[0,0,0,2]],"r":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,0,1,2]]}]}],"s":[{"p":[{"o":[{},[0,0,2]]}],"t":[{"í":[{},[0,0,2]]}],"z":[{"a":[{"j":[{},[0,0,0,1]],"k":[{"o":[{},[0,0,0,0,0,1]]},[0,0,0,0,2]],"l":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1]],"t":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]}],"á":[{},[0,2,0,1,2]],"e":[{"b":[{},[0,2,0,1]],"d":[{"é":[{},[0,2]]}],"g":[{},[0,2,0,1,2]],"l":[{"e":[{"m":[{},[0,2,0,1,2]]}],"l":[{},[0,2,0,1]],"n":[{},[0,2]],"ő":[{},[0,2,0,1,2]],"v":[{},[0,2,0,1]]}],"m":[{"b":[{},[0,2,0,1]],"e":[{"l":[{},[0,2,0,1,2]]}],"l":[{},[0,2,0,1]]}],"r":[{"k":[{},[0,2,0,1]]}]}],"é":[{"g":[{},[0,2]],"l":[{},[0,2,0,1,2]],"p":[{},[0,2,0,1,2]],"r":[{"e":[{"m":[{},[0,0,0,1]]}],"t":[{},[0,2,0,1]]}],"t":[{"k":[{},[0,2,0,1]]}]}],"g":[{},[0,0,0,1,2]],"i":[{"d":[{},[0,2,0,1]],"n":[{},[0,2,0,1]]},[0,0,0,0,2]],"í":[{"r":[{},[0,2]],"v":[{},[0,2,0,1]]}],"k":[{},[0,0,0,1,2]],"o":[{},[0,2,0,1,2]],"ó":[{},[0,2,0,1,2]],"ö":[{"l":[{},[0,0,0,1]],"n":[{},[0,0,0,1]]}],"ő":[{},[0,2,0,1,2]],"p":[{},[0,0,0,1,2]],"s":[{},[0,0,0,3]],"t":[{"r":[{},[0,0,0,1]]}],"u":[{},[0,2,0,1]],"ú":[{},[0,2,0,1]],"ü":[{"l":[{"é":[{},[0,2,0,1]]},[0,0,0,0,2]],"n":[{"n":[{},[0,2]]}],"t":[{},[0,2]]}],"z":[{},[0,0,0,1]]}]}],"t":[{"a":[{"u":[{},[0,0,0,3,2]]}],"á":[{"s":[{"á":[{"g":[{},[0,0,0,2,1,2]]}]}]}],"é":[{"k":[{"a":[{"l":[{},[0,0,0,2,1,2]]}],"e":[{"l":[{},[0,0,0,2,1,2]]}]}],"l":[{},[1,2]],"s":[{"a":[{},[0,0,0,2]],"é":[{"g":[{".":[{},[0,0,0,2,1]],"é":[{},[0,0,0,2,1,2]],"r":[{},[0,0,0,2,1]]}]}],"z":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"s":[{},[0,0,0,0,0,3]]}]}]}],"ó":[{"a":[{},[0,0,0,0,2]],"f":[{},[0,0,0,1]],"g":[{"é":[{"p":[{"é":[{"s":[{},[0,0,0,0,0,2,1,2]]}]}]}]}],"p":[{},[0,0,0,1,2]],"s":[{"p":[{},[0,0,0,1]],"t":[{"a":[{},[0,0,0,1]]}]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"r":[{"é":[{},[0,0,2]]}],"u":[{"s":[{"s":[{},[0,0,0,0,3]]}]}]}],"u":[{},[0,1]],"ú":[{},[0,1]],"ü":[{"d":[{"ü":[{},[0,0,2]]}]},[0,1]],"ű":[{},[0,1]],"v":[{"a":[{"d":[{},[0,2,1,2]],"j":[{"á":[{},[0,0,1,2]],"k":[{},[0,0,1]],"t":[{},[0,0,1]]}],"l":[{"a":[{},[0,2,1,2]],"j":[{},[0,2,1]]}],"n":[{"a":[{},[0,2,1,2]],"g":[{},[0,0,1]],"ó":[{},[0,2,1]],"y":[{},[0,2,1,2]]}],"r":[{"c":[{},[0,0,1]],"i":[{},[0,0,1,2]]}],"s":[{"z":[{"t":[{},[0,2,1]]}]}]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"g":[{},[0,2,1,2]],"l":[{},[0,2,1]],"r":[{"a":[{"d":[{},[0,0,1,2]],"m":[{},[0,2,1,2]]}],"k":[{},[0,2,1]],"n":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,2]]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"t":[{"a":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"c":[{},[0,0,0,2]],"d":[{"z":[{},[0,2,1,2]]}],"g":[{},[0,2,1,2]],"j":[{},[0,2,1]],"l":[{"e":[{"k":[{},[0,2]],"m":[{"b":[{},[0,0,1,2]],"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}]}],"g":[{},[0,2]],"ő":[{"l":[{},[0,0,1,2]]}]}],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}]}],"n":[{"d":[{},[0,2,1]],"e":[{},[0,2,1]]},[0,0,0,2]],"r":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]],"ő":[{},[0,0,1]]},[0,0,0,2]],"s":[{"e":[{"m":[{"é":[{},[0,2,1]]}]}],"z":[{},[0,2,1]]}],"t":[{"e":[{"t":[{},[0,2,1,2]]}]}]}],"é":[{"g":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"l":[{"e":[{},[0,2,1,2]],"m":[{},[0,2,1]],"ő":[{},[0,2,1,2]],"t":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"d":[{},[0,2,1]],"i":[{},[0,2,1,2]],"r":[{},[0,2,1]],"t":[{"é":[{},[0,0,1]]}],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"t":[{"e":[{},[0,2,1,2]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1]]},[0,0,0,2]],"k":[{"e":[{},[0,0,1]]},[0,0,0,2]],"l":[{"l":[{},[0,2,1]]}],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"p":[{},[0,2,1,2]],"r":[{"o":[{},[0,0,1]]}],"s":[{"e":[{"l":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,1]]}],"v":[{"a":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"l":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}],"x":[{},[0,2,1]]}],"ó":[{"s":[{"p":[{},[0,0,0,1,2]]}]}],"ö":[{"b":[{},[0,2,1]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"e":[{"n":[{"d":[{"e":[{},[0,0,0,0,0,2]]}]}]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{"k":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"g":[{},[0,2,1]],"l":[{"t":[{},[0,0,1]]}],"r":[{},[0,2,1]],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}]}],"z":[{"a":[{"b":[{},[0,0,1]],"d":[{},[0,0,1,2]],"g":[{},[0,0,1,2]],"j":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,1]],"u":[{},[0,0,1,2]]}],"á":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1]],"p":[{},[0,0,1,2]],"r":[{"ó":[{},[0,0,0,0,1,2]]},[0,0,1,2]],"s":[{"s":[{},[0,0,0,0,1]]}],"t":[{"a":[{"d":[{},[0,0,0,0,1,2]]}],"á":[{},[0,0,0,0,1]],"e":[{},[0,0,0,0,1,2]]},[0,0,1,2]]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"f":[{},[0,2,1]],"g":[{},[0,2,1,2]],"j":[{},[0,2,1]],"l":[{"á":[{},[0,3]],"e":[{"l":[{},[0,0,0,2,1]]}],"ö":[{},[0,0,0,2]],"ő":[{},[0,0,0,2]]}],"m":[{"e":[{"l":[{},[0,2,1]]}],"é":[{},[0,2]]}],"n":[{"e":[{},[0,2,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{"í":[{},[1,2]],"z":[{},[0,2,1,2]]}],"t":[{"i":[{},[0,2,1,2]]}],"u":[{},[0,2,1]],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"é":[{"g":[{},[0,2,1]],"k":[{"k":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"d":[{},[0,2,1]],"e":[{"l":[{},[0,2,1]],"n":[{},[0,2,1,2]]}],"h":[{},[0,2,1]],"i":[{},[0,2,1,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"a":[{},[0,0,0,2]],"z":[{},[0,0,1]]}],"v":[{"i":[{},[0,0,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]]}],"i":[{"c":[{"c":[{},[0,0,1]]}],"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"á":[{},[0,2]],"i":[{},[0,2,1]],"p":[{},[0,2,1]]}],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]],"t":[{},[0,2,1]]}],"ó":[{"é":[{"r":[{"a":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"t":[{"o":[{},[0,0,0,2]]}]}],"p":[{"a":[{},[0,2,1,2]]}],"r":[{"a":[{},[0,2,1]],"á":[{},[0,0,1]]}],"s":[{"o":[{},[0,0,0,2]],"z":[{"a":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"ó":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,2,1,2]]}],"v":[{"á":[{},[0,2,1,2]]}]}],"í":[{"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"o":[{"k":[{},[0,0,0,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ó":[{"r":[{"á":[{},[0,0,1,2]]}]}],"ö":[{"b":[{},[0,0,1]],"d":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"p":[{"e":[{"n":[{},[0,0,0,0,0,1]]}],"f":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"s":[{"a":[{"l":[{},[0,0,0,1]],"s":[{},[0,0,0,1]],"u":[{},[0,0,0,1]]},[0,2,0,0,2]],"á":[{"g":[{},[0,0,4,1]],"r":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]],"v":[{},[0,0,3]]}],"e":[{"b":[{},[0,0,3]],"l":[{},[0,2,0,1,2]],"s":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{"n":[{},[0,2,0,1]],"t":[{},[0,2,0,1]]}],"í":[{},[0,0,3]],"o":[{"k":[{},[0,0,0,1]],"r":[{},[0,0,3]]},[0,2]],"ó":[{},[0,2,0,1,2]],"ö":[{},[0,2]],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,3]]}],"u":[{},[0,2,3]],"ú":[{},[0,2]],"z":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"m":[{"e":[{},[0,0,0,2]],"i":[{},[0,0,0,2,1]]}],"n":[{"d":[{},[0,0,1]]}],"r":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"ú":[{"r":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1,2]],"l":[{"e":[{},[0,2]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ű":[{"e":[{},[0,2]],"n":[{},[0,2]],"r":[{},[1,2]],"v":[{},[0,2]]}]}]}],"j":[{".":[{},[2]],"a":[{"c":[{"é":[{},[0,1,2]]}],"d":[{"a":[{"g":[{},[2,1,2]],"l":[{},[2,1,2]],"t":[{"á":[{},[0,0,2]],"o":[{},[2,1,2]]}]}],"m":[{},[2,1]],"o":[{"m":[{},[2,1,2]],"t":[{},[2,1,2]]}],"ó":[{"h":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"u":[{"s":[{},[0,0,2]]}]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"a":[{".":[{},[0,0,2]]}],"g":[{},[2,1]],"i":[{},[2,1,2]]}],"k":[{"a":[{"d":[{"é":[{},[0,0,2]]},[2]]}],"á":[{"l":[{},[0,0,2,1]],"p":[{},[0,0,2,1,2]],"r":[{"n":[{},[0,0,2,1]]}]}],"c":[{"i":[{},[2,1]]}],"e":[{"c":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"é":[{"r":[{"e":[{},[0,0,0,1]],"i":[{},[0,0,2,1]]}]}],"f":[{},[2]],"i":[{"m":[{".":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"í":[{"r":[{},[0,0,2,1,2]]}],"k":[{"u":[{},[2,1]]},[0,0,0,1,2]],"o":[{"v":[{"i":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ó":[{"k":[{},[0,0,2]]}],"ö":[{"l":[{"t":[{"s":[{},[0,0,2,1]]}]}],"s":[{},[0,0,2,1]]}],"r":[{"o":[{},[2,1]]}],"t":[{".":[{},[2,1]],"i":[{},[2,1]],"u":[{},[2,1]]},[0,0,0,0,2]]}],"l":[{"g":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]]}],"m":[{"b":[{"e":[{},[0,0,0,2]],"u":[{},[2]]}],"e":[{"s":[{},[0,0,2]]}]}],"n":[{"a":[{".":[{},[2]],"i":[{},[2,0,0,0,2]],"l":[{},[0,0,2]],"t":[{},[0,0,2]]}],"o":[{},[2,1,2]],"s":[{"z":[{"e":[{},[0,0,0,2]],"ü":[{},[0,0,0,2]]}]}],"y":[{"a":[{},[0,0,2]]}]}],"r":[{"a":[{"n":[{},[0,0,2]]}],"á":[{},[2,1,2]],"c":[{},[2,1]],"o":[{"m":[{},[0,0,2]]}]}],"s":[{"z":[{"á":[{"s":[{},[2,1,2]]}]}]}],"t":[{"k":[{},[2,1]],"r":[{"ó":[{},[2,1]]}]}],"u":[{"r":[{},[0,0,2]],"t":[{"o":[{},[0,0,2]]}]}],"v":[{"a":[{"t":[{},[2]]}]}],"x":[{"i":[{},[0,0,2]]}],"z":[{"o":[{"n":[{},[0,0,2]]}]}]},[1]],"á":[{"a":[{"r":[{},[0,0,2]]}],"b":[{"é":[{},[2,1,2]],"r":[{},[2,1]]}],"g":[{".":[{},[2,1]],"a":[{".":[{},[2,1,2]],"d":[{},[2,1,0,1,2]],"i":[{},[2,1,2]],"k":[{},[2,1,2]],"s":[{},[2,1,2]],"t":[{},[2,1,2]],"z":[{},[2,1,2]]}],"á":[{},[2,1,2]],"b":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"i":[{},[2,1,2]],"k":[{},[2,1]],"r":[{},[2,1]],"y":[{},[2,1,2]]}],"í":[{"r":[{},[0,0,0,2]]}],"l":[{"l":[{},[2,1]]}],"n":[{"e":[{},[0,0,2,1]],"é":[{"k":[{},[0,0,2]]}],"l":[{},[2]]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{"d":[{"a":[{},[2,1,2]]}],"i":[{},[2,1,2]],"k":[{},[2,1,2]],"m":[{},[2,1,2]],"r":[{},[0,0,2]],"v":[{},[0,0,2,1]]}],"á":[{"n":[{},[2,1,2]],"s":[{"s":[{},[0,0,0,0,0,3]],"z":[{},[0,0,0,0,2,3]]}],"t":[{},[2,1,2]],"v":[{},[2,1,2]]}],"e":[{"m":[{},[0,0,2,1]],"s":[{},[0,0,2]]},[0,0,0,0,2]],"é":[{"r":[{},[0,0,2]]}],"i":[{"g":[{},[2,1,2]],"s":[{},[0,0,2,1]]}],"k":[{"i":[{},[2,1]],"o":[{},[2,1]]}],"n":[{"y":[{},[2,1]]}],"o":[{"n":[{},[2,1,2]],"t":[{},[0,0,2,1]]}],"ó":[{},[0,0,3]],"ő":[{},[0,0,2]],"t":[{"a":[{"l":[{},[2,1]]}],"á":[{"s":[{},[2,1]]}]}],"u":[{"k":[{},[2,1,2]],"s":[{},[2]],"t":[{},[0,1]]}],"v":[{"á":[{"l":[{},[2,1]]}]}],"z":[{},[2,1]]}],"s":[{"a":[{"d":[{},[0,0,2,1]],"l":[{},[0,0,2]],"n":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2,1]],"r":[{"a":[{"i":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]]}]}],"s":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"t":[{},[0,0,2]]}],"í":[{},[0,0,2,1]],"o":[{"l":[{},[0,0,2,1]]}],"ó":[{},[2,1,2]],"ö":[{},[0,0,2]],"t":[{},[0,0,0,0,2]],"ü":[{},[0,0,2,1,2]],"z":[{"a":[{"l":[{},[0,0,2,0,1]]}],"e":[{},[0,0,0,0,0,2]],"i":[{"s":[{},[0,0,2]]}],"o":[{"k":[{"t":[{"a":[{},[0,0,2,0,1]]}]}]}],"ó":[{"i":[{},[0,0,0,0,1]],"n":[{},[0,0,0,0,1]],"r":[{},[0,0,0,0,1,2]]}]}]}],"t":[{"a":[{"d":[{"ó":[{".":[{},[0,0,0,1,2]],"k":[{".":[{},[0,0,0,1,2]]}],"n":[{".":[{},[0,0,0,1,2]]}],"t":[{},[0,0,0,1,2]]}]}],"l":[{},[2,1,2]]}],"á":[{"z":[{},[2,1]]},[0,0,2,1,2]],"é":[{"k":[{"e":[{},[0,0,0,0,0,1,2]]}]}],"f":[{"e":[{},[2,1]]}],"h":[{"á":[{},[2,1]]}],"i":[{},[2,1,2]],"í":[{"r":[{},[2,1]]}],"l":[{"é":[{},[2,1]]}],"m":[{},[2,1]],"o":[{"s":[{"z":[{},[0,0,0,1]]}]}],"ö":[{},[2,1,2,1]],"s":[{"z":[{"ű":[{},[2]]}]}],"ü":[{},[2,1,2]],"v":[{"é":[{},[2,1]],"i":[{},[2,1]]}]}],"z":[{"s":[{},[0,0,3]]}]},[1]],"b":[{"a":[{"l":[{},[0,0,0,2,1]]}],"l":[{"o":[{},[0,0,2]]}],"r":[{"i":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"ű":[{"n":[{"ü":[{},[0,0,0,2,1,2]]}]}]}],"c":[{"h":[{"o":[{},[0,0,3]]}],"s":[{"a":[{"p":[{"á":[{},[0,0,0,0,0,0,2]]}]}],"s":[{},[0,0,0,1]]}]}],"d":[{"o":[{"n":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"r":[{"á":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{},[0,1,2]]}],"ú":[{"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,1]]}]}]}]}],"e":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"b":[{"é":[{},[0,0,2]]}],"d":[{"é":[{"n":[{},[2,1,2]]}],"z":[{},[2,1,2]]}],"e":[{"n":[{},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"e":[{"d":[{},[2]]}],"é":[{"s":[{"z":[{},[0,0,0,0,0,0,1]]},[0,0,2]]}],"y":[{"e":[{"g":[{},[0,0,2]],"l":[{"s":[{},[0,0,0,0,1]],"v":[{},[0,0,0,0,1]]},[0,0,2]],"s":[{"í":[{},[2,1,2]]}]}],"é":[{"k":[{},[0,0,2,0,1,2]]}],"i":[{"n":[{},[0,0,2,0,1]]}],"o":[{},[0,0,2,0,1]],"ő":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2,0,1]],"ű":[{"r":[{"ű":[{},[0,0,2,0,1,2]]}]}]}]}],"k":[{"c":[{"é":[{},[0,1]]}],"r":[{"i":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{"r":[{},[0,0,0,2,1,2]]}],"e":[{"l":[{},[0,0,0,2,1,2]],"r":[{},[0,0,0,2]]}]}]}],"l":[{"a":[{"j":[{},[0,0,2]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2,1]],"r":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"b":[{},[0,0,2,1]],"g":[{},[0,0,2]],"l":[{},[0,0,2]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1,0,1]],"z":[{},[0,0,2]]},[0,0,0,0,2]],"e":[{"g":[{"y":[{},[0,0,0,1,2]]}],"l":[{"e":[{"v":[{},[0,0,2,1,2,1,2]]}],"k":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"ő":[{"á":[{},[0,0,2,1,2]],"b":[{},[0,0,2,1,2]]}],"s":[{},[0,0,2,1]]}],"m":[{"e":[{"l":[{},[0,0,2,1]]}],"é":[{},[2]],"l":[{},[0,0,2,1]],"z":[{},[2,1,2]]}],"n":[{"g":[{},[0,0,2,1]]}],"r":[{},[0,0,2,1,2]],"s":[{"é":[{"s":[{},[0,0,0,1]]}],"i":[{"k":[{},[0,0,0,1]]}],"n":[{"i":[{},[0,0,2,1]]}],"ő":[{},[0,0,2,1,2]],"t":[{"e":[{},[0,0,0,1]]}],"z":[{},[0,0,2,1]]}],"t":[{"e":[{"t":[{},[0,0,2,1]]}]}],"v":[{"o":[{},[0,0,0,1]]}]}],"é":[{"g":[{},[0,0,2]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2]],"p":[{},[0,0,2,1]],"r":[{"t":[{"e":[{},[0,0,2]]}]}]}],"i":[{"g":[{"e":[{},[0,0,2,1]]}],"m":[{},[0,0,2]],"n":[{"a":[{},[0,0,2,1,2]],"f":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2,1,2]],"l":[{"e":[{"n":[{},[2,1]]}]}],"o":[{},[0,0,2,1,2]],"ö":[{"v":[{},[0,0,2,1]]}],"ő":[{"a":[{},[0,0,2]],"f":[{"e":[{},[2,1,2]]}],"í":[{},[0,0,2]],"t":[{"u":[{},[2,1,2]]}]}],"p":[{},[0,0,0,1,2]],"s":[{"z":[{"á":[{},[2]],"o":[{},[2]]}]}],"t":[{"e":[{"t":[{"t":[{".":[{},[2,1]]}]}]}],"é":[{"r":[{},[2]]}]}],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"m":[{"b":[{"a":[{},[2,1]],"e":[{"r":[{},[2,1]]}]}],"e":[{"l":[{},[2,1,2]]}],"u":[{},[0,0,2]]}],"n":[{"á":[{},[0,0,2,1]],"d":[{},[0,0,0,1,2]],"e":[{"k":[{"e":[{".":[{},[0,0,2,1,2]]}]}],"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{"z":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"i":[{"n":[{},[0,0,2,1]]}],"o":[{},[0,0,2,1]],"ő":[{"r":[{"e":[{},[0,0,2,1,2]]}],"s":[{},[0,0,2,1]]}],"ü":[{},[0,0,2,1]]}],"p":[{"r":[{},[0,0,1,2]]}],"r":[{"d":[{},[2,1]],"e":[{"d":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"ő":[{},[2,1,2]]}],"s":[{"a":[{},[0,0,2,1]],"e":[{"m":[{"b":[{},[0,0,2,1]]}],"t":[{"b":[{},[2,1,2]],"t":[{},[2,1,2]]}]}],"é":[{"r":[{},[0,0,2,1]]}],"ő":[{},[0,0,2]],"t":[{"a":[{},[0,0,1]],"r":[{},[0,0,1]]},[0,0,0,0,2]],"u":[{},[0,0,2]],"ü":[{"v":[{},[0,0,2,1,2]]}],"z":[{"a":[{"c":[{},[0,0,0,3]]}]}]}],"t":[{"a":[{"m":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"l":[{"l":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2,1]]}],"o":[{},[0,0,2,1]],"r":[{"a":[{},[0,0,1]]}],"u":[{"n":[{},[0,0,2]],"t":[{},[0,0,2]]}]}],"u":[{"r":[{},[0,0,0,2]]}],"v":[{"ő":[{},[2,1,2]]}],"z":[{"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}]}]},[1]],"é":[{"b":[{"r":[{},[2,1]]}],"g":[{"a":[{},[0,0,2,1,2]],"á":[{"r":[{"a":[{"d":[{},[0,0,0,0,0,1,2]]}]}]},[0,0,2,1,2]],"e":[{"c":[{},[0,0,2]],"d":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"r":[{"k":[{},[0,0,2,1]]}],"s":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"é":[{"p":[{},[0,0,2]],"r":[{".":[{},[0,0,2,1]]}],"s":[{},[0,0,2]]}],"g":[{},[0,0,0,3]],"i":[{"d":[{},[0,0,2,1]],"g":[{"é":[{},[0,0,2]]}],"m":[{},[0,0,2]],"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[2,0,2]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]]}],"h":[{"e":[{"n":[{},[2,1,2]],"s":[{},[2,1,2]]}],"s":[{},[2,1]]}],"k":[{"o":[{"s":[{},[0,0,2,1]]}],"ü":[{},[0,0,2]]}],"l":[{"e":[{},[2,1,2]],"ő":[{},[0,0,2]],"t":[{},[2,1]]}],"n":[{"a":[{"d":[{},[0,0,2]]}],"e":[{"s":[{"s":[{},[0,0,2,1]]}]}],"é":[{"g":[{},[0,0,2,1,2]]}],"i":[{"l":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{".":[{},[2,1]],"b":[{},[2,1]],"d":[{},[2,1]],"e":[{"g":[{},[0,0,2]],"n":[{},[2,1,2]]}],"é":[{},[2,1,2]],"h":[{},[2,1]],"i":[{},[2,1,2]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]],"t":[{"e":[{},[2,1]],"é":[{},[2,1]],"ő":[{},[2,1]]}],"ü":[{},[2,1,2]],"v":[{},[2,1]],"z":[{},[2,1]]}],"t":[{"e":[{"l":[{},[0,0,2]]}],"k":[{},[2,1]],"t":[{},[2,1]]}],"v":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{".":[{},[0,0,2]],"k":[{},[2,1,2]],"t":[{},[2,1,2]]}],"é":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"h":[{},[0,1]],"i":[{},[0,1,2]],"k":[{},[0,1]],"n":[{},[2,1]],"r":[{},[2,1]],"t":[{},[0,1]],"ü":[{},[2,1,2]],"v":[{},[0,1]]}]},[1]],"f":[{"e":[{"l":[{"e":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}]}],"l":[{"e":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"ö":[{"l":[{"ö":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}]}],"r":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"u":[{"n":[{"a":[{},[0,0,0,2]]}]}]}],"g":[{"l":[{"e":[{},[0,1,2]],"ó":[{},[0,1,2]]}],"r":[{"u":[{},[0,0,2]]}]}],"h":[{"á":[{"r":[{"e":[{},[0,0,0,2,1]]}]}]}],"i":[{"d":[{"o":[{},[0,0,2]],"ő":[{},[0,1,2]]}],"g":[{"a":[{},[2,1,2]],"é":[{},[2,1,2]]}],"j":[{"e":[{},[0,0,2]]}],"k":[{"r":[{},[2,1]]}],"l":[{"l":[{},[2,1]]}],"m":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"n":[{"a":[{".":[{},[2,1,2]]}],"á":[{"b":[{},[0,0,2]]}],"d":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"j":[{},[2,1]],"s":[{},[2,1]],"t":[{"e":[{},[2,1]],"é":[{},[2,1]]}]}],"o":[{"n":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,2]]}],"r":[{"a":[{"t":[{},[2,1,2]]}],"á":[{},[2,1,2]],"o":[{},[2,1,2]],"r":[{},[2,1]],"t":[{},[2,1]]}],"s":[{"k":[{},[2,1]],"m":[{},[2,1]],"t":[{},[2,1]]}],"t":[{"a":[{},[2,1,2]]}],"v":[{"á":[{},[2,1,2]],"ó":[{},[2,1,2]]}],"z":[{"é":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"t":[{"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"j":[{"a":[{"l":[{"j":[{},[0,2,1]]}],"z":[{},[0,2,1,2]]}],"á":[{"s":[{},[0,0,0,1]]}],"e":[{"l":[{"e":[{"s":[{"é":[{},[0,0,0,2]],"i":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}]}],"ü":[{"l":[{},[0,0,0,2,1]]}]}],"r":[{},[0,0,1,2]]}],"i":[{"m":[{},[0,2,1]],"z":[{},[0,2,1]]}],"í":[{"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"o":[{"l":[{},[0,2,1]],"s":[{},[0,2,1]]}],"p":[{"r":[{},[0,0,1]]}],"ü":[{"g":[{},[0,0,1]]}]}],"k":[{"a":[{"p":[{"r":[{},[0,0,0,1]]}],"r":[{"d":[{},[0,0,1]]}],"u":[{},[0,0,0,0,2]]}],"e":[{"g":[{},[0,2,1,2]],"l":[{"ő":[{},[0,2,1,2]]}],"s":[{},[0,2,1,2]]}],"é":[{"p":[{"e":[{"k":[{"é":[{},[0,0,0,2,1,2]]}]}]}]}],"i":[{"a":[{},[0,0,0,0,2]],"á":[{},[0,0,0,0,2]],"d":[{},[0,2,1]],"e":[{},[0,0,0,0,2]]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,1,2]],"o":[{},[0,1,2]]}],"m":[{"e":[{},[0,0,0,0,2]]}],"o":[{"l":[{"d":[{},[0,2,1]]}],"r":[{"á":[{"s":[{},[0,0,0,2,1,2]]}],"i":[{"n":[{},[0,0,0,2,1]]}]}]}],"ó":[{"r":[{"á":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"é":[{},[0,1,2]],"i":[{},[0,1,2]],"í":[{},[0,1,2]]}],"s":[{"t":[{},[0,0,1]]}],"u":[{"s":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,0,1]]}],"v":[{"a":[{},[0,0,2]],"ó":[{},[0,1,2]]}]}],"l":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"d":[{"a":[{},[0,0,1,2]]}],"l":[{"a":[{"p":[{},[0,2,1,2]]}],"l":[{},[0,2,1]]}],"r":[{},[0,2,1]],"t":[{"e":[{},[0,0,0,2,1,2]]}],"z":[{"o":[{},[0,2,1]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"a":[{},[0,0,1,2,1]],"n":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"g":[{"y":[{},[0,0,1,2]]}],"í":[{},[0,0,0,0,2]],"l":[{"é":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]]}],"t":[{"é":[{"t":[{"e":[{},[0,0,0,2,1,2]]}]}]}]}],"é":[{"c":[{"e":[{"l":[{},[0,0,0,2]]}],"s":[{},[0,0,0,2,3]]}],"v":[{".":[{},[0,2,1]]}]}],"i":[{"k":[{"o":[{},[0,0,1]]},[0,0,0,2]],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"o":[{"b":[{"j":[{},[0,0,1]]}],"l":[{},[0,2,1]],"n":[{"á":[{},[0,0,0,2,1]],"i":[{},[0,0,0,2]]}]}],"ö":[{"s":[{},[0,2,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}]}],"m":[{"e":[{"g":[{},[0,0,0,2]]}],"o":[{"k":[{"á":[{},[0,0,1]]}],"l":[{"d":[{},[0,2,1]]}]}]}],"n":[{"a":[{"l":[{"e":[{},[0,0,0,2,1]],"é":[{"g":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]}]}]}],"á":[{"r":[{"á":[{},[0,0,1,2]],"u":[{},[0,0,1,2]]}]}],"é":[{"v":[{"a":[{},[0,0,0,0,1]]}]}],"i":[{"n":[{"g":[{},[0,0,1]]}]}],"s":[{"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,0,1,2]]}]}],"o":[{"g":[{"a":[{"d":[{},[0,0,2,1,2]],"k":[{"a":[{},[0,0,2,1]]}],"l":[{},[0,0,2]],"n":[{},[0,0,2,1]],"z":[{},[0,0,2,1,2]]}],"á":[{"c":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]]}],"e":[{},[0,0,2,1,2]],"g":[{},[0,0,0,3]],"í":[{},[0,0,2,1]],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"v":[{},[0,0,2,1]]},[0,0,0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"u":[{"r":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"k":[{"o":[{"z":[{},[2,1,2]]}],"s":[{},[2,1]],"t":[{"a":[{},[2,1]]}]}],"l":[{"a":[{"j":[{},[0,0,2]]}],"i":[{"m":[{},[0,0,2]]}]}],"m":[{"a":[{"g":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2,1]],"e":[{},[0,0,2,1,2]],"é":[{"t":[{},[0,0,2,1,2]],"v":[{},[0,0,2]]}],"f":[{},[0,0,0,1,2]],"i":[{"j":[{},[0,0,2]],"k":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,0,1,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"n":[{"c":[{"c":[{},[0,0,0,0,1]],"h":[{},[0,0,0,2]],"i":[{"l":[{},[0,0,0,2]]}],"s":[{},[0,0,0,2,3]]}],"d":[{},[2,1]]}],"ó":[{"b":[{},[0,0,2]]}],"p":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]]}],"r":[{"i":[{"n":[{"g":[{},[0,0,2,1]]}]}],"r":[{".":[{},[2,1]]}],"ü":[{},[0,0,2]]}],"s":[{"t":[{"o":[{},[2,1]]}],"z":[{},[2,1]]}],"u":[{"i":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]]}]},[1]],"ó":[{"a":[{"k":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"c":[{"e":[{},[0,0,2]]}],"d":[{"a":[{"d":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{"l":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1,2]],"t":[{"o":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"e":[{"l":[{},[0,0,2]]},[0,0,0,0,2]],"i":[{"g":[{},[0,0,2]],"z":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2,1]]}],"ó":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ü":[{},[0,0,2]],"z":[{},[0,0,2,3]]}],"f":[{"l":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{"o":[{},[0,0,1]]}]}],"l":[{"e":[{"s":[{},[0,0,2,1,2]]}]}],"n":[{"n":[{},[2,1]]}],"p":[{"r":[{},[0,0,1,2]]}],"r":[{"á":[{"k":[{},[0,0,2]]}],"i":[{},[2,1,2]]}],"s":[{"a":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]],"r":[{"k":[{},[0,0,0,1]]}]}],"e":[{"g":[{},[0,0,2]],"m":[{},[0,0,2]]}],"é":[{"n":[{},[0,0,2]]}],"i":[{"p":[{},[0,0,2]],"s":[{},[0,0,2]]}],"o":[{"d":[{"o":[{},[0,0,2,1,2]]}]}],"ö":[{},[0,0,2]],"s":[{},[0,0,0,3]],"ü":[{"l":[{"d":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1]]}],"z":[{"á":[{"r":[{},[0,0,2,3]]}]}]}],"t":[{"r":[{},[0,0,1,2]]}]},[1]],"ö":[{"d":[{"é":[{},[0,0,2]]}],"k":[{"o":[{},[0,0,2]]}],"l":[{"é":[{},[0,0,2]]}],"n":[{"t":[{},[2,1]]}],"r":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"s":[{"v":[{},[0,1]]}],"t":[{"v":[{},[0,1]]}],"v":[{".":[{},[2,1]],"e":[{".":[{},[2]],"z":[{},[0,1,2]]}],"é":[{"n":[{},[2,1,2]]}]}],"z":[{"ö":[{},[0,0,2]]}]},[1]],"ő":[{"r":[{"l":[{},[0,1]],"ö":[{},[0,0,2]],"t":[{},[2,1]],"ü":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[1]],"p":[{"á":[{"r":[{"b":[{"a":[{},[0,0,0,0,0,0,2]]}]}]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"r":[{"a":[{"d":[{},[0,0,0,3,2]],"f":[{},[0,0,0,1]],"i":[{},[0,0,0,0,2]],"p":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"u":[{},[0,0,0,0,2]]}],"é":[{"s":[{"z":[{"e":[{"l":[{},[0,0,0,2,0,1,2]]}],"í":[{},[0,0,0,2]]}]}]}]}],"s":[{"a":[{"v":[{"e":[{},[0,0,0,2,1]],"é":[{},[0,0,0,2,1]],"o":[{},[0,0,0,2]],"ó":[{"n":[{".":[{},[0,0,0,2,1]]}],"r":[{},[0,0,0,2,1,2]]}]}]}],"á":[{"g":[{"g":[{},[0,0,0,0,1]]}]}],"h":[{"o":[{},[0,0,2]]}],"k":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"n":[{"i":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"r":[{},[0,0,0,2]]}],"t":[{"a":[{},[0,1,2]],"i":[{},[0,0,2]],"í":[{},[0,1,2]],"o":[{},[0,1,2]],"r":[{"a":[{},[0,1,0,2]],"u":[{},[0,1,0,2]]}],"ú":[{},[0,1,2]]}],"z":[{"a":[{"b":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"á":[{"l":[{"a":[{"d":[{"a":[{},[0,0,0,0,2,1,2]]}]}]}],"r":[{"a":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"í":[{"n":[{"n":[{},[0,0,0,0,0,3]]}]}],"k":[{},[0,0,0,2]],"t":[{},[0,0,0,0,2]]}]}],"t":[{"a":[{"d":[{"a":[{},[0,2,1,2]],"o":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]]}],"k":[{"n":[{},[0,0,1]]}],"l":[{"a":[{"p":[{},[0,0,1,2]]}],"k":[{},[0,0,1]],"l":[{},[0,2,1]],"v":[{},[0,2,1]]}],"n":[{"y":[{"a":[{"g":[{},[0,0,1,2]]}]}]}],"p":[{"á":[{},[0,2,1,2]]},[0,0,0,1,2]],"r":[{"o":[{"m":[{},[0,0,1,2]]}],"z":[{},[0,2,1]]}],"s":[{"p":[{},[0,0,0,1]]}],"t":[{"k":[{},[0,2,1]]}],"u":[{"t":[{},[0,2,1,2]]}]}],"á":[{"c":[{},[0,2,1]],"g":[{"a":[{},[0,0,1]]}],"l":[{"l":[{},[0,2,1]]}],"r":[{"a":[{"i":[{},[0,0,0,2]],"k":[{},[0,2,1,2]]}],"k":[{"a":[{},[0,2,1]]}]}],"s":[{"z":[{},[0,0,0,2,3]]}],"t":[{"a":[{},[0,0,1,2,1]]}]}],"e":[{"g":[{"y":[{},[0,2,1,2]]}],"k":[{"e":[{".":[{},[0,2,1,2]]}]}],"l":[{"e":[{"g":[{},[0,2,1,2]],"m":[{"e":[{},[0,2,1,2]],"z":[{},[0,2]]}]}],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"j":[{"á":[{},[0,0,1]]}],"l":[{},[0,2,1]],"m":[{"é":[{"l":[{},[0,2]]}]}],"o":[{},[0,2,1,2]],"ő":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"m":[{"l":[{},[0,2,1]]}],"n":[{"e":[{"r":[{},[0,2]]}],"z":[{},[0,2,1]]}],"r":[{"e":[{"d":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"ő":[{},[0,2,1]]}],"t":[{"e":[{"t":[{"ő":[{"e":[{},[0,2,1,2]]}]}]}]}],"v":[{"é":[{"s":[{},[0,0,1,2]]}],"o":[{},[0,0,1]],"ő":[{},[0,2,1,2]]}]}],"é":[{"l":[{"e":[{},[0,2,1,2]],"m":[{},[0,0,1]]}],"r":[{"l":[{},[0,2,1]],"m":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"m":[{"á":[{},[0,2]],"i":[{},[0,2,1]],"p":[{},[0,2,1]]},[0,0,0,2]],"n":[{"f":[{},[0,0,1]],"g":[{},[0,2,1]],"t":[{},[0,0,1]]}],"p":[{"a":[{},[0,2,1,2]]}],"r":[{},[0,2,1]],"s":[{"i":[{},[0,0,1]]},[0,0,0,2]],"z":[{"g":[{},[0,2,1]],"o":[{},[0,0,1,2]]}]}],"í":[{"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"l":[{"d":[{"a":[{},[0,2,1]]}]}],"r":[{"j":[{"á":[{"b":[{},[0,2,1]]}]}],"s":[{},[0,2,1]]}],"s":[{"z":[{},[0,0,1]]}],"x":[{},[0,2,1,2]]}],"ó":[{"a":[{},[0,0,0,0,2]],"é":[{"r":[{"a":[{},[0,0,0,0,2]]}]}],"p":[{},[0,0,0,1,2]],"s":[{"p":[{"o":[{},[0,0,0,1,2]]}],"t":[{"a":[{},[0,0,0,1]],"r":[{},[0,0,0,1]]}],"z":[{},[0,0,0,1]]}],"t":[{"r":[{},[0,0,0,1]]}]}],"ö":[{"d":[{"é":[{},[0,0,1]]}],"n":[{"g":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,1]]}]}],"ő":[{"a":[{},[0,0,0,0,2]],"e":[{},[0,0,0,0,2]],"é":[{},[0,0,0,0,2]],"s":[{"p":[{},[0,0,0,1,2]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"n":[{},[0,1,2]]}],"á":[{"d":[{"i":[{},[0,0,0,0,0,0,2]]}],"g":[{},[0,1,2]]}],"i":[{},[0,0,2]],"o":[{"j":[{},[0,1,2]]}],"ó":[{"f":[{},[0,0,2]]}]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{"v":[{},[0,2,1]]}],"n":[{"d":[{},[0,2,1]]}],"t":[{"á":[{},[0,0,1]]}]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"g":[{},[0,2,1]],"l":[{},[0,2,1,2]],"t":[{},[0,2,1]]}]}],"u":[{"g":[{"a":[{},[0,0,2]],"o":[{},[0,0,0,0,1]]}],"h":[{"a":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1,2]],"r":[{"a":[{},[0,0,0,0,2]]}],"t":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"é":[{"j":[{},[0,0,2,1]]}],"i":[{"s":[{},[0,0,2,1]]}],"o":[{"r":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"l":[{"a":[{},[2]],"s":[{},[2]]}],"r":[{"a":[{"l":[{},[2]]}],"u":[{},[0,0,2]]}],"s":[{"z":[{"a":[{"v":[{},[0,0,2,0,1,2]]}],"i":[{"m":[{},[0,0,2]]}],"í":[{},[0,0,2,0,1,2]]}]}],"t":[{"a":[{"k":[{},[0,0,2]]}],"á":[{"l":[{},[2,1,2]]}]}]},[1]],"ú":[{"f":[{"r":[{},[0,0,1]]}],"j":[{"í":[{},[0,0,2]],"j":[{"á":[{"é":[{},[0,0,0,0,0,0,3]]}]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"s":[{"p":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"z":[{"ó":[{},[0,0,2]],"v":[{},[0,0,1]]}]}],"t":[{"b":[{},[2,1]],"o":[{"n":[{},[0,0,2]]}],"v":[{},[2,1]]}]},[1]],"ü":[{"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,1,2]],"t":[{},[0,1]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"ő":[{},[0,1,2]]}],"v":[{"e":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[1]],"ű":[{"r":[{"i":[{},[0,0,2]]}],"z":[{"ő":[{},[0,0,2]]}]},[1]],"z":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"d":[{},[0,2,1,2]],"j":[{"á":[{},[0,2,1]],"t":[{},[0,0,1]]},[0,0,0,2]],"k":[{"a":[{"d":[{},[0,0,0,2]]}],"c":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"n":[{"y":[{},[0,2,1,2]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"a":[{"n":[{},[0,0,0,2]]}]}]}],"á":[{"l":[{},[0,2,1]],"r":[{"a":[{"d":[{},[0,2,1,2]]}],"á":[{"n":[{},[0,2,1,2]]}]}]}],"e":[{"l":[{},[0,2,1,2]],"m":[{},[0,2,1]],"r":[{"é":[{},[0,0,1]]},[0,0,0,2]],"s":[{},[0,2,1]]}],"é":[{"l":[{},[0,2,1]],"r":[{"t":[{"é":[{},[0,2,1]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,2]]}],"n":[{"t":[{},[0,2,1]]}],"r":[{},[0,2,1,2]],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]]}]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"o":[{"b":[{},[0,2,1]],"k":[{"t":[{"a":[{},[0,0,1]]}]}],"l":[{"d":[{"a":[{},[0,2,1]]}],"v":[{"a":[{"s":[{},[0,2]]}]}]}],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"d":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"s":[{},[0,0,0,1,2]]}],"ö":[{"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"s":[{"a":[{"b":[{},[0,0,3]],"l":[{},[0,2,0,1,2]]}],"á":[{"l":[{},[0,2,0,1]]}],"c":[{"s":[{"a":[{"p":[{},[0,0,0,0,0,0,2,1]]}]}]}],"e":[{"g":[{},[0,2,0,1]],"n":[{},[0,2]],"r":[{},[0,2,0,1]]}],"i":[{"n":[{},[0,2,0,1]]}],"í":[{"n":[{},[0,0,3]]}],"o":[{"r":[{},[0,0,3]]}],"ö":[{},[0,2,0,1,2]],"ő":[{},[0,2,0,1]],"s":[{},[0,0,0,1]],"u":[{"t":[{},[0,2,0,1,2]]}],"z":[{"a":[{},[0,0,3]],"á":[{},[0,0,3]],"e":[{},[0,0,3]]}]}],"u":[{"t":[{},[0,2,1]]}],"ü":[{"g":[{},[0,0,1,2]]}]}]}],"k":[{".":[{},[2]],"a":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{"t":[{"a":[{},[0,0,0,0,0,2]]},[0,0,0,0,1]]}],"b":[{"a":[{},[0,0,0,2]],"b":[{"a":[{"h":[{},[2]]}]}],"h":[{"á":[{},[2,1]]}],"i":[{"n":[{"á":[{},[0,0,0,0,2]]}]}],"l":[{"a":[{"k":[{".":[{},[2,1]],"a":[{},[2,1]],"á":[{},[2]],"b":[{},[2,1]],"h":[{},[2]],"k":[{},[2]],"o":[{"k":[{},[2,1]],"n":[{},[2,1]],"s":[{},[2]],"t":[{},[2,1]]}],"r":[{},[2]]}]}],"e":[{},[0,0,1,2]]}],"r":[{"e":[{},[0,0,1]]}],"s":[{},[2,1]]}],"c":[{"é":[{"l":[{".":[{},[0,0,2]]}]}],"h":[{},[0,0,2,3]],"s":[{"á":[{"g":[{},[0,0,0,0,1,2]]}],"ú":[{"s":[{},[0,0,2,0,1]]}]}],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"d":[{"a":[{"p":[{},[0,1]]}],"á":[{"l":[{},[2]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"o":[{"t":[{},[2,1,2]]}],"ó":[{"i":[{},[0,0,2]],"j":[{},[0,0,2]],"s":[{"o":[{},[2,1,2]]}],"u":[{},[0,0,2]],"z":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,1,2]]}]}],"e":[{"g":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"a":[{"n":[{},[0,0,2]]}],"g":[{},[2,1]],"r":[{},[0,0,1,2]],"y":[{".":[{},[2,1]],"u":[{},[0,0,2]]}]}],"i":[{"z":[{},[0,0,0,2]]}],"j":[{"á":[{"n":[{"l":[{},[2]]}]}],"k":[{},[2,1]],"t":[{"ó":[{"h":[{},[2,1]]}]}]}],"k":[{"a":[{"d":[{"é":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"á":[{"c":[{},[0,0,2]]}],"c":[{},[2,1]],"l":[{},[0,0,1,2]],"ó":[{".":[{},[0,0,2]]}],"r":[{"é":[{},[0,0,1,2]],"i":[{},[0,0,1]]}],"t":[{".":[{},[2,1]],"i":[{},[2,1]]}],"v":[{"a":[{},[0,0,1,2]]}]}],"l":[{"a":[{"p":[{"a":[{},[0,0,2]],"í":[{"t":[{"v":[{},[2]]}]}]}]}],"b":[{},[2,1]],"e":[{"g":[{"y":[{},[0,0,0,1]]}]}],"f":[{},[2,1]],"j":[{".":[{},[2,1]],"i":[{},[2,1]]}],"k":[{"a":[{},[2,1]],"o":[{},[2]]}],"l":[{"e":[{},[2,1]]}],"t":[{"i":[{},[2,1]]}]}],"m":[{"a":[{"t":[{"e":[{},[0,0,0,0,2]]}]}],"b":[{"u":[{},[2,1]]}]}],"n":[{"a":[{"g":[{},[0,0,0,0,2]],"l":[{"í":[{},[0,0,2]]}],"m":[{},[2,1,2]],"t":[{},[0,1,2]]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]]}],"g":[{},[2]],"i":[{"m":[{},[0,0,2]],"o":[{},[0,0,2]],"v":[{},[0,0,2,1]]}],"o":[{"l":[{},[0,0,2]]}],"ó":[{"d":[{},[0,0,2]]}],"t":[{"e":[{},[2]]}],"ű":[{},[0,0,2]],"y":[{"a":[{".":[{},[2,1,2]],"g":[{},[2,1,2]],"i":[{},[2,1,2]]}],"á":[{"b":[{},[0,0,2]]}],"ó":[{},[0,0,2]]}]}],"ó":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"c":[{},[0,0,2]],"e":[{},[0,0,2]],"g":[{},[0,0,2]],"h":[{"a":[{},[0,0,2]]}],"í":[{},[0,0,2]],"k":[{"o":[{},[0,0,2]],"r":[{},[0,0,2]]}],"p":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"p":[{"á":[{"d":[{},[2]],"t":[{"o":[{},[0,0,2]]}]}],"p":[{},[2]],"r":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"í":[{},[2,1]],"o":[{"f":[{},[0,0,1]]}]}]}],"r":[{"a":[{"d":[{},[0,0,2,1,2]],"k":[{"k":[{},[0,0,2]],"ó":[{},[0,0,2,1,2]]}],"l":[{"a":[{"p":[{},[0,0,0,1,2]]}]}],"n":[{"k":[{},[2,1]]}],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[2,0,2]]},[0,0,0,0,2]],"t":[{".":[{},[2]],"n":[{},[2]],"o":[{},[2]]}],"u":[{},[0,0,2]]}],"á":[{"c":[{"s":[{"h":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"l":[{},[0,0,2,1]],"n":[{"y":[{},[2,1,2]]}]}],"c":[{"e":[{"l":[{},[0,0,0,2,1]]}]}],"d":[{"a":[{"c":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]]}],"z":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,2]],"v":[{},[0,0,2]]}],"é":[{"k":[{"e":[{},[0,0,0,1]],"o":[{"r":[{},[0,0,0,0,2]]}]}],"l":[{},[0,0,2]],"n":[{"e":[{},[0,0,2,1]]}]}],"f":[{"e":[{"l":[{},[0,0,0,0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2]],"k":[{"o":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]]}],"n":[{"d":[{},[0,0,2]],"g":[{".":[{},[0,0,2,1]],"b":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"g":[{},[0,0,0,1]],"r":[{},[0,0,0,1]]}]}],"s":[{"k":[{},[0,0,2,1]],"m":[{},[0,0,2,1]]}],"z":[{"o":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"o":[{"m":[{"a":[{".":[{},[2,1,2]]}],"á":[{},[2]]}],"r":[{},[0,0,2]]}],"s":[{},[0,0,0,0,2]],"t":[{"i":[{},[2,1]]}]}],"s":[{"a":[{"g":[{},[0,0,2]]}],"á":[{"g":[{"g":[{},[0,0,0,0,0,1]]}],"l":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2]],"p":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"z":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2,1]]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"p":[{"o":[{},[0,0,1,2]]}],"s":[{"z":[{"e":[{},[0,0,0,3]],"é":[{},[0,0,0,3]],"i":[{},[2,1]],"o":[{"n":[{"y":[{},[2]]}]}],"ő":[{},[0,0,0,3]]}]}],"t":[{"r":[{},[0,0,1]]},[0,0,0,0,2]],"ü":[{"r":[{},[0,0,2]]}],"z":[{"a":[{"j":[{"t":[{},[0,0,0,0,1]]}],"t":[{},[2]]}],"á":[{"g":[{},[0,0,2]]}]}]}],"t":[{"a":[{"r":[{"á":[{},[0,0,0,1]]}]}],"é":[{"l":[{},[0,0,2]]}],"i":[{"k":[{"o":[{},[0,0,0,1]]}],"n":[{"t":[{},[0,0,0,1]]}],"o":[{},[0,0,2,1,2]]}],"k":[{"á":[{},[2,1]]}],"o":[{"l":[{"d":[{"a":[{},[0,0,2]]}]}]}],"r":[{"á":[{"d":[{"i":[{},[0,0,0,0,0,0,0,2]]}]}],"i":[{},[0,0,1,2]]}],"y":[{"á":[{},[0,0,2]]}]}],"u":[{"d":[{},[0,0,2]],"l":[{},[2,1,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"t":[{"a":[{},[0,0,0,2]],"o":[{},[2,1,2]],"ó":[{".":[{},[2,1]],"b":[{},[2]],"c":[{},[0,0,3]],"é":[{},[2]],"h":[{},[2]],"i":[{},[2]],"j":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2]],"n":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]]}]}]}],"ü":[{"t":[{},[0,0,0,2]],"z":[{},[0,0,0,2]]}],"v":[{"a":[{"t":[{},[2,1,2]]}]}],"z":[{"o":[{"n":[{},[2,1,2]]}]}]},[1]],"á":[{"b":[{"é":[{},[2]],"r":[{},[2,1]]}],"c":[{"a":[{"k":[{},[0,0,2]]}],"e":[{},[0,0,2]],"h":[{},[2,0,2,3]],"ó":[{},[0,0,2]],"s":[{"a":[{"r":[{},[0,0,2,3]],"t":[{},[0,0,2]]}],"e":[{},[0,0,2]],"é":[{"k":[{},[0,0,2,0,1]]}],"i":[{"p":[{},[0,0,2]],"s":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,3]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"d":[{"a":[{"b":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"c":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2]]}],"í":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"ü":[{},[0,0,2,1,2]],"z":[{},[0,0,2,3]]}],"f":[{"á":[{},[0,0,2]]}],"g":[{".":[{},[2,1]],"a":[{".":[{},[2,1]],"c":[{"s":[{"k":[{"a":[{},[2]],"á":[{},[0,0,3]]}]}]}],"i":[{},[2,1]],"k":[{},[2,1]],"t":[{},[2,1]],"z":[{},[2,1]]},[0,0,2]],"á":[{},[2,1,2]],"b":[{},[2,1]],"e":[{},[2,1,2]],"é":[{},[0,1,2]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{},[2,1,2]],"k":[{},[2,1]],"n":[{},[2,1]],"o":[{},[2,1,2]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"u":[{},[2,1,2]],"ú":[{},[2,1,2]],"y":[{},[2,1,2]]}],"h":[{"í":[{},[2,1,2]]}],"j":[{"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"l":[{"á":[{"g":[{},[0,0,2]],"i":[{},[2]],"k":[{},[2]],"n":[{},[2]],"v":[{},[2]],"z":[{},[2]]}],"c":[{},[2,1]],"d":[{"o":[{},[0,1]]}],"e":[{},[0,0,2,1,2]],"é":[{"n":[{},[0,0,2]]}],"l":[{"a":[{"m":[{"t":[{"i":[{},[2]]}]}],"p":[{},[2,1]]}],"á":[{"s":[{},[2,1]]}],"e":[{},[0,0,0,2,1,2]],"é":[{"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"í":[{},[2,1]],"o":[{"m":[{},[2,1]]}]}],"ü":[{},[0,0,2]],"y":[{"o":[{"d":[{},[0,0,2]]}]}]}],"m":[{"í":[{},[2,1,2]],"u":[{},[2,1,2]]}],"n":[{"a":[{"g":[{},[0,0,2,1]],"n":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]]}],"e":[{"m":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2,1]]}],"ó":[{},[0,0,2,1,2]],"y":[{"a":[{"g":[{},[0,0,2,0,1]],"l":[{},[0,0,2,0,1,2]],"n":[{},[0,0,2,0,1,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"t":[{"o":[{},[0,0,2,0,1,2]]}]}],"e":[{},[0,0,2,0,1,2]],"i":[{"s":[{},[0,0,2]],"v":[{},[0,0,2]]}],"ö":[{},[0,0,2]]}]}],"p":[{"o":[{"l":[{"á":[{},[2,1,2]],"ó":[{},[0,0,2]]}]}]}],"r":[{"a":[{"d":[{},[2,0,2]],"g":[{},[0,0,2,1,2]],"k":[{"r":[{},[2,1,2]],"t":[{"a":[{},[0,0,0,1]],"á":[{},[0,0,0,1]]},[0,0,2]]}],"l":[{},[0,0,2,1,2]],"m":[{},[2,1,2]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,1]]},[0,0,2]],"t":[{},[2,1,2]],"z":[{"o":[{},[0,0,0,1]]},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}],"z":[{},[0,0,2,1,2]]}],"d":[{},[0,0,0,1,2]],"e":[{},[0,0,2,1,2]],"é":[{"t":[{"e":[{},[0,0,0,1]]}]}],"i":[{"á":[{},[2,1,2]]}],"k":[{"á":[{},[0,1]],"i":[{"é":[{"h":[{},[0,0,0,0,0,0,2]]}]}]}],"o":[{"l":[{"d":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{"s":[{"z":[{"i":[{"c":[{},[0,0,0,0,0,0,0,0,3]]},[0,0,0,0,0,0,0,2]]}]}]}],"s":[{},[0,0,0,1,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"h":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"s":[{"a":[{"j":[{"t":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,1]]}]}],"á":[{"g":[{"o":[{},[0,0,2,1,2]]}],"r":[{"a":[{"i":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]]}],"á":[{},[0,0,2,1,2]],"b":[{},[0,0,2,1]],"o":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"v":[{},[0,0,2,1]],"z":[{},[0,0,2,1]]}],"s":[{"á":[{},[2,1,2]],"t":[{},[2]]}]}],"e":[{},[0,0,2,1,2]],"i":[{"k":[{},[0,0,2,1,2]],"m":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,2]]}],"k":[{"á":[{"r":[{},[0,0,0,0,0,2]]}]}],"o":[{"l":[{},[0,0,2,1]],"t":[{"t":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"t":[{},[0,0,2]]}],"ü":[{},[0,0,2,1,2]],"z":[{"á":[{"b":[{},[2,1,2]],"r":[{".":[{},[0,0,0,3]]},[0,0,2]],"t":[{},[2,1,2]]}],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{"s":[{},[0,0,2]],"v":[{},[0,0,2]]}],"o":[{"m":[{},[2,1,2]]}],"ü":[{},[0,0,2,3]]}]}],"t":[{"a":[{"b":[{},[0,0,2]],"d":[{},[2,1]],"j":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,1,2]]},[0,0,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"u":[{},[0,0,2]]}],"á":[{},[0,0,2,1,2]],"b":[{"e":[{},[2,1]]}],"e":[{},[0,0,2,1,2]],"é":[{"g":[{},[0,0,2]]}],"f":[{"o":[{},[0,1]]}],"i":[{"p":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"í":[{},[0,0,2]],"l":[{"ó":[{},[0,1]]}],"m":[{"e":[{},[2,1]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{},[0,0,2,1]],"ü":[{},[0,0,2]],"v":[{"á":[{},[0,1]]}]}]},[1]],"b":[{"a":[{"l":[{},[0,0,0,2,1]]}],"é":[{"r":[{"e":[{"l":[{},[0,0,0,2]]}]}]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"c":[{"i":[{"ó":[{"f":[{"a":[{},[0,0,0,2]]}],"s":[{"i":[{},[0,0,0,2]],"p":[{"e":[{},[0,0,0,2]]}]}]}]}],"l":[{"u":[{},[0,0,2]]}],"s":[{"a":[{"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]]}]}]}]}]}],"d":[{"i":[{"a":[{"l":[{},[0,0,0,2]]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}]}],"e":[{"a":[{"j":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2,1]]}],"b":[{".":[{},[2,1]],"e":[{"i":[{},[0,0,2]],"k":[{},[0,0,2]]}],"é":[{"d":[{},[0,0,2]]}]}],"c":[{"s":[{"a":[{"l":[{"j":[{},[0,0,0,0,1]]}]}],"ó":[{"n":[{},[0,0,0,0,1]],"r":[{},[0,0,0,0,1,2]]}]}]}],"d":[{"r":[{"a":[{},[0,0,1,2]]}]}],"e":[{"g":[{"y":[{"e":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"n":[{},[0,0,0,2]],"p":[{},[0,0,2]],"s":[{},[0,0,0,2]]}],"f":[{"f":[{},[2,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"é":[{"r":[{},[2,1,2]],"s":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"y":[{"b":[{},[2]],"é":[{"k":[{},[0,0,2]]}],"i":[{"n":[{},[0,0,2,0,1]]}],"l":[{},[2,1]],"n":[{},[2]],"ö":[{},[0,0,2]],"r":[{},[2]],"s":[{},[2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2,0,1]],"ü":[{},[2]]}]}],"k":[{"e":[{".":[{},[2,1,2]],"i":[{},[2,1,2]],"k":[{},[2,1,2]]}],"é":[{"é":[{},[2,1,2]],"k":[{},[2,1,2]]}],"l":[{},[0,0,1,2]],"r":[{"é":[{},[0,0,1,2]]}],"s":[{"z":[{"a":[{},[0,0,0,2]]}]}],"v":[{},[2,1]]}],"l":[{"a":[{"d":[{},[2,1]],"n":[{},[0,0,2,1]],"t":[{},[0,0,2,1,2]],"v":[{},[2,1]]}],"á":[{"g":[{},[0,0,2,1,2]]}],"e":[{"f":[{},[2,1,2]],"k":[{"c":[{},[0,0,2]],"t":[{},[2,1,2]]}],"l":[{},[0,0,2,1,2]],"m":[{"b":[{},[0,1,2]],"e":[{},[2]],"é":[{},[2]],"h":[{},[0,1,2]],"m":[{},[2]],"n":[{},[2,1,2]],"r":[{},[0,1,2]],"z":[{},[2,1,2]]}],"p":[{"e":[{".":[{},[0,0,2,1,2]],"i":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,0,0,2,1,2]]}],"s":[{"é":[{},[0,0,2,1,2]],"z":[{"e":[{},[0,0,2,1]]}]}],"t":[{"e":[{"l":[{},[0,0,0,0,2,1]]}],"o":[{},[0,0,0,0,2,1]]}],"y":[{},[2]]}],"é":[{"k":[{},[0,0,2,1,2]],"l":[{},[2,1,2]],"r":[{"h":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,0,0,3]],"z":[{},[0,0,0,0,2,3]]}]}],"h":[{"e":[{"l":[{},[2,1]]}],"o":[{},[2,1]]}],"i":[{"d":[{},[0,0,0,1]],"g":[{},[0,0,0,2]],"m":[{},[2,1,2]],"o":[{},[0,0,2]],"s":[{"m":[{},[2,1]]}]}],"í":[{},[2,1,2,1,2]],"j":[{"á":[{},[2,1]]}],"l":[{"á":[{"t":[{},[2]]},[0,1]],"e":[{"n":[{"á":[{},[2]],"ő":[{},[2]],"t":[{},[2,1]]}]}]}],"n":[{"e":[{"v":[{},[2,1]]}],"y":[{},[2,1]]}],"o":[{"s":[{},[2,1,2]]}],"ö":[{"l":[{},[2,0,2,0,2]]}],"ő":[{"a":[{},[2,1,2]],"é":[{},[0,0,0,0,0,2]],"f":[{"ú":[{},[2]]}],"h":[{"í":[{},[0,0,2]]}],"í":[{},[2,1,2]],"k":[{"é":[{"p":[{"z":[{},[2,1,2]]}],"s":[{},[2,1,2]]}]}],"l":[{},[2,1,2]],"n":[{"y":[{},[0,0,2]]}],"o":[{},[2,1,2]],"t":[{"é":[{},[0,0,2]],"t":[{},[2,1,2]]}],"z":[{},[0,1,2]]}],"r":[{"a":[{},[0,1]]}],"s":[{"a":[{},[2,1]],"ő":[{},[2,1]],"z":[{"á":[{},[2,1]]}]}],"t":[{"é":[{"r":[{"ő":[{".":[{},[0,0,0,2,1,2]]}]}]}],"o":[{},[2,1]],"ű":[{},[2]]}],"ü":[{"l":[{},[2]]}],"ű":[{"r":[{},[0,0,2]]}],"v":[{".":[{},[2,1]],"á":[{},[2,1]],"e":[{"i":[{},[2,1]],"k":[{},[2,1]],"n":[{},[2,1]]}],"i":[{},[2]],"k":[{},[0,1]],"o":[{},[2,1]],"t":[{},[2,1]],"ű":[{},[2,1]]}],"y":[{"e":[{"m":[{"b":[{},[0,0,2]]}]}],"é":[{"k":[{"n":[{},[0,0,2,0,1]]}]}],"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"z":[{},[2,1]]}],"m":[{"b":[{"e":[{"r":[{},[2,1]]}],"l":[{},[2,1]],"r":[{},[2,1]]}],"l":[{},[2,1]],"u":[{"l":[{},[2,1]]}]}],"n":[{"a":[{"l":[{},[0,0,2]]}],"c":[{"i":[{},[2,1]]}],"d":[{"e":[{"r":[{"ü":[{"l":[{},[0,0,0,0,0,2]]}]}]}],"é":[{"k":[{},[0,0,0,2,1]]}],"o":[{},[2,1]]}],"e":[{"r":[{},[2,1,2]]}],"g":[{"e":[{},[2,1]]}],"i":[{"p":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"o":[{},[0,0,2,1]],"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,0,0,2]]}],"y":[{"v":[{},[2,1]]}]}],"o":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"ó":[{"d":[{},[0,0,0,2]],"h":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"p":[{"i":[{"k":[{},[0,0,2]]}]}],"r":[{"a":[{"l":[{},[0,0,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]],"u":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2]]}],"c":[{"s":[{"á":[{},[0,0,0,2]],"e":[{"l":[{"l":[{},[0,0,0,2]]}]}],"í":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,0,2]]}]}],"d":[{"e":[{},[2]],"ő":[{},[2]]}],"e":[{"g":[{"e":[{},[2,1,2]]}],"j":[{},[2,1,2]],"k":[{"e":[{"g":[{},[0,0,0,0,2,1]],"s":[{"s":[{},[0,0,0,0,0,0,0,3]]}]}]}],"l":[{"l":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]}],"m":[{"b":[{"e":[{"r":[{},[0,0,2,1]]}]}]}],"r":[{},[0,0,2,1]],"t":[{"a":[{},[0,0,0,0,2]],"e":[{"l":[{},[0,0,0,0,2,1,2]]}],"ö":[{},[0,0,0,0,2,1]]}]}],"é":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,0,1]]}]}],"i":[{"d":[{},[0,0,2,1]],"g":[{"a":[{},[0,0,0,1]]}],"l":[{"l":[{},[0,0,2,1]]}],"m":[{},[0,0,2]],"n":[{"d":[{},[0,0,2,1]],"t":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"o":[{},[0,0,2]],"s":[{"t":[{},[0,0,0,1]]}],"z":[{},[0,0,2,1]]}],"k":[{},[0,0,0,1,2]],"n":[{"e":[{"l":[{".":[{},[2]]}]}]}],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"ó":[{"d":[{},[0,0,2]],"r":[{},[0,0,2,1,2]]}],"ő":[{"d":[{"e":[{},[0,0,2]]}],"e":[{},[0,0,2]],"k":[{"é":[{},[0,0,2]]}],"o":[{},[0,0,2]],"s":[{"í":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]]}]}],"s":[{"p":[{},[0,0,0,1]],"t":[{},[0,0,0,1]],"z":[{},[0,0,0,0,0,2]]},[0,0,0,0,2]],"t":[{"a":[{"j":[{},[0,0,0,2]]}],"á":[{"p":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"e":[{"b":[{"b":[{"é":[{},[0,0,0,2,1]]}]}],"g":[{},[0,0,0,2]],"s":[{"t":[{"e":[{},[0,0,0,2,1]]}],"z":[{},[0,0,0,2,1]]}]}],"é":[{"l":[{"v":[{},[0,0,0,2]]}],"v":[{"é":[{"t":[{},[0,0,0,2,1,2]]}]}]}],"ö":[{"n":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"ő":[{"r":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]}],"r":[{"ó":[{},[0,0,0,1]]}]}],"ú":[{"t":[{},[0,0,2]]}],"ü":[{"g":[{},[0,0,0,0,2]]}]}],"s":[{"e":[{"m":[{"é":[{},[2,1]]}],"t":[{"é":[{},[0,0,2]],"t":[{},[2,1,2]]}]}],"é":[{"l":[{},[2,1]],"s":[{},[2,1,2]]}],"i":[{"s":[{},[0,0,2]]}],"í":[{"t":[{"ő":[{"s":[{"t":[{},[2]]}]}]}]}],"k":[{"ü":[{},[2]]}],"ő":[{},[2,1,2]],"p":[{"o":[{},[0,0,1,2]]}],"s":[{"z":[{"é":[{"k":[{"e":[{},[0,0,0,3]]}]}],"ó":[{},[0,0,0,3]]}]}],"t":[{"a":[{},[0,0,1]],"e":[{},[2,1]],"é":[{},[2,1]],"i":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"n":[{},[2,1]],"r":[{"a":[{},[0,0,1]],"e":[{},[2,1]]}],"t":[{},[2,1]],"ü":[{"n":[{},[2,1]]}]}],"z":[{"a":[{"j":[{},[0,0,2]]}],"é":[{"p":[{},[0,0,2]]}],"m":[{"é":[{"n":[{},[2]]}]}]}]}],"t":[{"á":[{"l":[{},[0,0,2]]}],"c":[{},[0,0,1]],"e":[{"k":[{"é":[{"h":[{},[0,0,2,1,2]]}]}],"t":[{"é":[{},[2,1,2]]}]}],"i":[{"d":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"i":[{},[0,0,1,2]]}],"t":[{"e":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"ű":[{"d":[{},[0,0,2]]}]}],"u":[{"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"v":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"i":[{"d":[{},[0,0,2]]}],"ő":[{},[2,1,2]]}],"z":[{"e":[{"t":[{"é":[{"s":[{},[0,0,0,0,2]]}]}]}],"ő":[{"a":[{},[0,0,0,0,0,2]],"e":[{},[0,0,0,0,0,2]],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"r":[{},[2,1]]}]},[1]],"é":[{"b":[{"e":[{"r":[{},[2,1,2]]}],"r":[{},[2,1]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"h":[{"e":[{"m":[{},[2,1,2]],"n":[{},[2,1,2]],"s":[{},[2,1,2]],"z":[{"é":[{},[2]],"t":[{},[2]]}]}],"s":[{},[2,1]]}],"j":[{"a":[{"k":[{},[0,0,2,1]]}],"e":[{"l":[{"é":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]],"u":[{"t":[{},[0,0,2]]}]}],"k":[{"e":[{".":[{},[2,1,2]],"i":[{},[2,1,2]],"k":[{"k":[{},[2]]}],"m":[{},[2]],"r":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,0,3]],"z":[{},[0,0,0,0,2,3]]}]}],"é":[{"n":[{},[0,0,2]]}],"o":[{},[0,0,2,1,2]],"ü":[{"k":[{},[2,1,2]]}],"ű":[{},[2,1,2]]}],"l":[{"e":[{"l":[{},[0,0,2]],"s":[{},[2]],"t":[{"e":[{"k":[{},[2,1,2]],"t":[{},[2,1,2]]}]}]}],"m":[{},[2,1]],"ő":[{"d":[{},[0,0,2]],"l":[{},[2,1,2]]}],"r":[{},[2,1]],"ű":[{},[2,1,2]],"y":[{"a":[{},[0,0,2]],"e":[{"s":[{"z":[{},[0,0,2,0,1]]}]}],"i":[{"d":[{},[0,0,2]]}],"ü":[{"l":[{},[0,0,2,0,1,2]]}]}]}],"m":[{"a":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2]],"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2,1]],"i":[{"a":[{"s":[{},[0,0,0,0,2]]}],"n":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"u":[{},[0,0,2,1,2]]}],"n":[{"a":[{"l":[{},[0,0,2,1]],"n":[{},[0,0,2]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"d":[{"i":[{"o":[{},[0,0,0,0,0,0,2]]}]}],"e":[{"k":[{"e":[{},[2,1,2]],"h":[{},[2,1,2]],"i":[{},[2,1,2]],"k":[{},[2,1,2]],"l":[{},[2]]}],"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"é":[{"t":[{"e":[{},[0,0,0,1]]}]}],"i":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]],"n":[{"g":[{},[0,0,2,1]]}]}],"o":[{},[0,0,2]],"y":[{"e":[{"g":[{},[0,0,2,0,1,2]],"l":[{"v":[{},[0,0,2,0,1]]}]}],"ú":[{},[0,0,2]]}]}],"p":[{"a":[{},[0,0,2,1,2]],"á":[{"r":[{},[0,0,0,0,2]]},[0,0,2,1]],"e":[{"g":[{},[0,0,2]],"l":[{"ő":[{},[0,0,2,1,2]],"t":[{"é":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1]]}],"r":[{},[0,0,0,0,2]]}],"i":[{"l":[{"l":[{},[0,0,2,1]]}],"m":[{},[0,0,2]],"p":[{},[0,0,2,1,2]]}],"í":[{"t":[{},[2,1]]},[0,0,2]],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{"l":[{"é":[{},[0,0,2,1,2]],"ő":[{},[0,0,2,1,2]]}]}]}],"r":[{"a":[{"b":[{},[0,0,2]],"l":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"d":[{"e":[{"k":[{"e":[{},[2,1]]}]}],"r":[{},[0,0,0,1]]}],"e":[{"t":[{"t":[{"s":[{},[2,1,2]]}]}]}],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"t":[{"e":[{"l":[{"m":[{},[2]]}]}],"é":[{"k":[{"b":[{},[2]],"e":[{},[2,1]],"h":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]]}],"s":[{},[2,1]]}],"ő":[{"i":[{"k":[{"é":[{},[0,0,0,0,0,2]]}]}]}]}],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2,1]],"ü":[{"l":[{"é":[{},[0,0,0,1]]}]},[0,0,0,0,2]],"v":[{"e":[{"k":[{},[2,1]]}]}],"z":[{"é":[{},[2,1]]}]}],"s":[{"a":[{"n":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"é":[{"g":[{},[0,0,2,1,2]]}],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"s":[{"z":[{"a":[{},[0,0,0,3]],"e":[{"r":[{},[0,0,0,3]]}],"é":[{"l":[{},[0,0,0,3]]}]}]}],"u":[{},[0,0,2]],"ü":[{"t":[{},[0,0,2]]}],"z":[{"a":[{"l":[{},[0,0,0,0,1]]},[0,0,2,0,0,2]],"á":[{},[0,0,2,0,1,2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,0,0,0,2]],"m":[{"l":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}]}],"é":[{"d":[{},[0,0,2]],"k":[{"n":[{"é":[{},[0,0,2,0,1]]}]}]}],"i":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2,0,1,2]],"ö":[{},[0,0,2]],"ő":[{"r":[{},[0,0,2]]}],"t":[{},[0,0,0,0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2,0,1]]}]}],"t":[{"a":[{"k":[{"a":[{"r":[{},[0,0,0,1]]}],"n":[{},[0,0,2]],"ó":[{},[0,0,2,1]]}],"l":[{"a":[{},[0,0,0,1]]}],"s":[{"p":[{},[0,0,0,1]]}]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"l":[{".":[{},[0,0,2]],"n":[{},[0,0,2]]}],"m":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1]],"r":[{"e":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"ű":[{},[0,0,0,1]]},[2,0,2,0,2]],"s":[{"é":[{},[0,0,2]],"t":[{"é":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1,2]]}],"é":[{},[0,0,2,1,2]],"i":[{},[0,0,2,1,2]],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"ó":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"ö":[{},[0,0,2,1]],"u":[{"d":[{},[0,0,2]]}],"ü":[{},[0,0,2,1,2]],"v":[{},[2]]}],"v":[{".":[{},[2,1]],"a":[{"d":[{},[2,1]]}],"b":[{},[2,1]],"e":[{"i":[{},[2]],"m":[{},[2,1,2]],"n":[{},[2,1,2]],"t":[{},[2]]}],"f":[{},[2,1]],"h":[{},[2,1]],"i":[{".":[{},[2,1,2]],"g":[{},[0,0,2]],"n":[{},[2,1]]}],"k":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"ü":[{},[2,1,2]],"v":[{},[2,1]]}],"z":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2]],"l":[{"t":[{},[0,0,0,1]]}],"m":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1,2]]}],"i":[{"s":[{"m":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2]],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2]],"s":[{"é":[{},[0,0,2,3]],"t":[{},[0,0,0,3]],"u":[{},[0,0,2]]},[0,0,0,0,2]],"u":[{},[0,0,2,1,2]]}]},[1]],"f":[{"e":[{"l":[{"e":[{"m":[{},[0,0,0,2,1]]}]}]}],"i":[{"l":[{"m":[{"é":[{"r":[{},[0,0,0,0,2]]}]}]}],"s":[{"a":[{"r":[{},[0,0,0,2]]}]}]}],"j":[{"o":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"o":[{"l":[{"y":[{"ó":[{"i":[{"k":[{},[0,0,0,0,0,0,0,2]]}]}]}]}],"n":[{"ó":[{},[0,0,0,2,1,2]]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2]]}]}],"g":[{"l":[{"a":[{},[0,0,2]]}],"n":[{"ó":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{"f":[{".":[{},[0,1,2]]}]}],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"u":[{},[0,0,2]]}]}],"h":[{"á":[{"t":[{"a":[{"l":[{},[0,0,0,2,1]]}]}]}],"e":[{"l":[{"y":[{"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}]}],"i":[{"a":[{},[1,2]],"á":[{"b":[{},[0,0,0,0,2]]}],"l":[{},[0,2]]}],"m":[{"e":[{},[0,0,2]]}]}],"i":[{"a":[{"d":[{},[0,0,0,2]],"é":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{},[0,0,0,2]],"j":[{},[0,0,0,2]],"k":[{"a":[{"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}]}],"l":[{"a":[{"p":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2]]}],"n":[{},[0,0,0,2]],"p":[{},[0,0,0,2]],"r":[{"a":[{},[0,0,0,2]]}],"s":[{"z":[{},[0,0,0,2]]}],"ú":[{},[0,0,2]],"v":[{},[0,0,0,2]]}],"á":[{"z":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"d":[{"e":[{"á":[{},[2,1,2]],"g":[{},[2,1,2]],"j":[{},[2]]}],"é":[{"t":[{},[2,1,2]],"z":[{},[2]]}],"i":[{"o":[{},[0,0,2]]},[2]],"ő":[{"b":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2,1,2]],"t":[{},[2]]}],"r":[{"ó":[{},[0,0,1]]}]}],"e":[{"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{"e":[{"t":[{".":[{},[0,0,2]]}]}]}],"t":[{},[0,0,0,2]],"w":[{},[0,0,2]]}],"é":[{"d":[{},[0,0,0,2]],"k":[{},[0,0,0,2]]}],"f":[{"j":[{},[2,1]],"r":[{},[0,0,1,2]]}],"g":[{"a":[{".":[{},[0,0,2]]},[2]],"á":[{"t":[{},[0,0,2]]},[2]],"e":[{},[2]],"é":[{"n":[{},[0,0,2]],"z":[{},[0,0,2]]}],"r":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"o":[{"n":[{"n":[{},[0,0,2]],"o":[{},[0,0,2]]}]}],"r":[{"é":[{},[0,0,1,2]],"i":[{},[0,0,1,2]]}],"v":[{},[0,0,1,2]]}],"l":[{"l":[{"e":[{},[2,1]]}],"y":[{"e":[{},[0,0,2]]},[2]]}],"m":[{"a":[{".":[{},[2,1,2]],"i":[{},[2,1,2]],"k":[{},[0,0,2]]}],"á":[{"b":[{},[0,0,2]],"d":[{},[2]],"i":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{},[0,0,2]],"m":[{},[2,1,2]],"n":[{},[0,0,2]],"r":[{},[2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]]}],"i":[{"t":[{},[0,0,2]]}],"p":[{},[2,1]]}],"n":[{"a":[{".":[{},[2,1,2]],"i":[{},[2,1,2]]}],"á":[{"b":[{},[2,1,2]],"r":[{},[2,1,2]]}],"c":[{"s":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]]}]}],"d":[{},[2]],"f":[{},[2,1]],"g":[{"a":[{"s":[{},[0,0,0,2]]}]}],"j":[{},[2,1]],"t":[{"e":[{"g":[{},[2,1]]}]}]}],"o":[{"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2]],"n":[{"n":[{},[2,1,2]],"o":[{},[2,1,2]],"t":[{".":[{},[2]]}]}]}],"ó":[{"h":[{},[0,0,3]],"n":[{".":[{},[2,1,2]]}]}],"p":[{"a":[{"r":[{},[2]]}],"f":[{},[0,0,1]],"l":[{"a":[{},[0,0,1,2]],"e":[{},[0,0,1]]}],"r":[{},[0,0,1,2]],"s":[{},[2,1]]}],"r":[{"a":[{"t":[{},[2,1,2]]}],"á":[{"n":[{"n":[{},[2]],"y":[{},[2]]}]}],"g":[{},[2]],"h":[{},[2,1]],"k":[{},[2,1]],"o":[{"d":[{},[2,1,2]],"m":[{},[2]]}],"r":[{},[2,1]],"t":[{},[2,1]]}],"s":[{"a":[{"d":[{},[0,0,2]],"j":[{"t":[{"ó":[{},[0,0,2,1]]}]}],"k":[{"n":[{},[0,0,2,1]]}],"l":[{},[0,0,2]],"p":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"c":[{},[0,0,2,1,2]],"l":[{"ő":[{},[0,0,2,1]]}],"m":[{"b":[{},[0,0,2,1]]}],"s":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2,1,2]]}],"i":[{".":[{},[0,0,2]],"n":[{},[0,0,2,1]],"p":[{"a":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,0,2,1,2]]}],"s":[{"k":[{},[0,0,2,1]]}]}],"k":[{"á":[{"l":[{},[0,0,1]]}]}],"m":[{"á":[{"r":[{},[0,0,1]]}],"i":[{"n":[{},[0,0,1,2]]}]},[2]],"n":[{"y":[{"á":[{},[0,0,0,2]]}]}],"o":[{"k":[{"o":[{},[0,0,0,1]]}],"r":[{"o":[{"s":[{},[0,0,2,1]]}]}]}],"ö":[{"r":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"p":[{"l":[{},[0,0,0,1]],"o":[{"r":[{},[0,0,1,2]]}],"ó":[{},[0,0,1,2]]},[0,0,0,0,2]],"s":[{"z":[{},[0,0,0,3]]}],"t":[{"a":[{"r":[{},[0,0,1,2]]}],"e":[{"r":[{"i":[{},[0,0,1]]}]}],"í":[{},[0,0,1]],"o":[{"p":[{},[0,0,1]]}],"r":[{},[0,0,1]],"u":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1,2]],"t":[{"e":[{"r":[{},[0,0,0,2,1]]}],"ö":[{},[0,0,0,2,1]]}]}],"u":[{"s":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"ú":[{"s":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"v":[{"í":[{"z":[{},[0,0,0,0,0,1]]}],"ó":[{},[2,1,2]]}]},[1]],"í":[{"g":[{"é":[{},[2,1,2]],"y":[{".":[{},[0,1]]}]}],"j":[{"a":[{},[0,0,2]]}],"n":[{"a":[{"l":[{},[0,0,2]]}],"á":[{"r":[{"b":[{},[0,0,2,1]]}]}],"e":[{},[0,0,2,1]],"é":[{"l":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]]}],"r":[{"á":[{},[0,0,2]],"e":[{},[2,1,2]],"ó":[{},[2,1,2]]}],"t":[{"m":[{},[2]],"ő":[{"a":[{},[0,0,0,0,0,2]],"e":[{},[0,0,0,0,0,2]]}]}],"v":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{},[2,1,2]],"é":[{},[2,1,2]],"ű":[{},[2,1,2]]}],"z":[{"é":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"k":[{"a":[{"b":[{"l":[{},[0,0,1]]}],"d":[{"a":[{},[0,2,1,2]]}],"j":[{"t":[{},[0,0,1]]}],"k":[{"a":[{"d":[{},[0,2,1,2]]}],"k":[{},[0,2,1]]}],"l":[{"á":[{},[0,2]],"j":[{},[0,2,1]],"m":[{},[0,2,1]]}],"r":[{"ó":[{"r":[{"a":[{},[0,0,0,2,0,2]]}]}]}],"u":[{},[0,2,1,2]],"z":[{"o":[{},[0,2,1]]}]}],"á":[{"l":[{"l":[{},[0,2,1]]}],"r":[{"f":[{},[0,0,1]],"o":[{"k":[{},[0,0,0,2]]}],"u":[{},[0,2,1,2]]}],"s":[{"á":[{},[0,2,1]]},[0,0,0,2]],"t":[{"h":[{},[0,2,1]],"l":[{},[0,2,1]],"u":[{},[0,0,1]],"v":[{},[0,2,1]]}],"z":[{"ó":[{},[0,0,1,2]]}]}],"b":[{"r":[{},[0,0,1]]}],"e":[{"c":[{"s":[{"e":[{},[0,0,1]]}]},[0,0,0,2]],"d":[{"z":[{},[0,0,1,2]]}],"g":[{"é":[{},[0,0,1,2]]}],"l":[{"e":[{"g":[{},[0,0,0,2,1,2]],"m":[{},[0,2,1,2]]}],"l":[{"ő":[{},[0,2,1]]}],"ő":[{"á":[{},[0,0,0,2]]}]}],"m":[{"u":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,0,2]],"d":[{},[0,0,1]],"ó":[{},[0,0,0,2]],"ő":[{},[0,2,1,2]]}],"t":[{"i":[{},[0,0,1,2]]}],"v":[{"é":[{},[0,0,1,2]]}]}],"é":[{"g":[{},[0,2,1]],"l":[{},[0,2,1,2]],"p":[{"í":[{},[0,2,1]]}],"r":[{"t":[{"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"á":[{},[0,0,0,0,2]],"d":[{"o":[{},[0,0,1,2]]}],"e":[{},[0,0,0,0,2]],"g":[{"a":[{},[0,0,1,2]],"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,2]]}],"n":[{"d":[{},[0,0,1]],"g":[{},[0,2,1]],"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{"a":[{"r":[{},[0,0,1,2]]}]}],"r":[{"o":[{},[0,2,1,2]]}],"s":[{"k":[{"o":[{},[0,0,1]]}],"m":[{},[0,0,1]]}]}],"í":[{"r":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"l":[{"í":[{},[0,1,2]],"ó":[{".":[{},[0,0,2]]}],"u":[{},[0,1,2]]}],"o":[{"l":[{"a":[{"j":[{},[0,0,0,2]]}],"l":[{"ó":[{},[0,0,1]]}]}],"p":[{"e":[{},[0,2,1,2]]}],"r":[{"d":[{"á":[{},[0,0,0,0,2]]}],"g":[{},[0,2,1]],"o":[{"s":[{},[0,0,0,2,1]]}],"ú":[{"t":[{},[0,0,0,2,1]]}],"z":[{},[0,2,1]]}],"s":[{"z":[{"l":[{},[0,2,1]]}]}]}],"ó":[{"p":[{},[0,0,0,1,2]],"r":[{"á":[{},[0,0,1,2]]}]}],"ö":[{"l":[{"ő":[{},[0,0,1]]},[0,0,0,2]],"n":[{"t":[{},[0,2,1]]}],"t":[{"l":[{},[0,0,1]]}]}],"ő":[{"r":[{"i":[{},[0,0,1,2]],"ö":[{},[0,0,1,2]],"s":[{},[0,0,1]],"ü":[{},[0,0,1]]}]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"i":[{"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"í":[{},[0,0,2]]}],"s":[{"m":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{"v":[{},[0,0,1]]}],"r":[{"t":[{},[0,0,1]]}],"t":[{"á":[{},[0,2,1]]}]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"ő":[{},[0,0,1,2]]}],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]],"z":[{"l":[{},[0,0,1]]}]}],"ű":[{"r":[{},[0,0,1]]}],"v":[{"ó":[{},[0,0,2]]}]}],"l":[{"a":[{"g":[{},[0,0,0,1]],"k":[{"o":[{},[0,0,0,3]],"r":[{"i":[{},[0,0,0,1]]}]}],"p":[{"á":[{"t":[{"a":[{},[0,0,0,2,1]]}]}],"l":[{"a":[{},[0,0,0,1]]}]}],"s":[{"k":[{},[0,0,0,1,2]]}],"u":[{"z":[{"á":[{},[0,0,0,2]]}]}]}],"á":[{"m":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{"r":[{"a":[{"d":[{},[0,0,0,0,0,0,1,2]]}]}]},[0,0,0,2,1,2]],"e":[{"g":[{},[0,0,0,2,1,2]],"h":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]],"t":[{"é":[{},[0,0,0,2,1]]}]}]}],"i":[{"k":[{},[0,0,0,2,1,2]],"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}]}]}],"e":[{"í":[{},[0,0,0,0,2]],"t":[{"a":[{"n":[{},[0,0,0,2,1,2]]}],"á":[{"l":[{},[0,0,0,2]]}],"e":[{"l":[{"v":[{},[0,0,0,2,1]]}],"r":[{},[0,0,0,2,1,2]],"v":[{},[0,0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}],"t":[{"b":[{"e":[{},[0,0,0,2,1]]}],"é":[{},[0,0,0,2,1,2]]}],"v":[{"e":[{".":[{},[0,0,0,2,1,2]]}]}]}],"i":[{"n":[{},[0,0,0,2]]}]}]}],"i":[{"n":[{"i":[{},[0,2]]}],"ó":[{},[0,0,0,0,2]],"p":[{"e":[{"l":[{},[0,0,0,2]]}]}],"s":[{"é":[{},[0,2]],"ó":[{},[0,0,0,2]]}]}],"í":[{"m":[{},[1,2]]}],"o":[{"á":[{},[0,2]],"p":[{"f":[{},[0,2]]}],"t":[{"y":[{},[0,2]]}]}],"ó":[{"r":[{"a":[{"d":[{},[0,0,0,2]],"j":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}]}]}],"u":[{"b":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2,1]],"i":[{"r":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}]},[0,2]],"s":[{"e":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}]}]}],"m":[{"a":[{"b":[{},[0,0,0,1]],"i":[{"k":[{"o":[{},[0,0,0,0,2]]}]}],"s":[{},[0,0,0,0,2]]}],"á":[{"n":[{"y":[{"a":[{"n":[{},[0,0,0,2]]}]}]}]}]}],"n":[{"a":[{"g":[{},[0,0,0,0,2]],"k":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{"a":[{},[0,0,0,2,2]],"k":[{"a":[{"l":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"s":[{"z":[{},[0,0,0,1,0,2]]}]}],"ő":[{"c":[{"c":[{},[0,0,0,0,1]]}],"r":[{},[0,0,2,3]]}]}],"o":[{"á":[{"z":[{},[0,0,2]]}],"b":[{"e":[{},[0,0,2]],"s":[{},[2,1]]}],"c":[{"h":[{"o":[{},[0,0,2]]}]}],"d":[{"a":[{"v":[{},[2,1,2]]}],"ú":[{},[2,1,2]]}],"g":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"r":[{"a":[{},[0,0,1,2]]}]}],"k":[{"á":[{"d":[{},[0,0,2]]}],"e":[{"r":[{},[0,0,2,1]]},[2,0,0,0,2]],"i":[{"r":[{},[2,1,2,1]]}],"í":[{},[2,1,2]],"l":[{},[2,1]],"m":[{},[2,1]],"o":[{"l":[{},[2,1,2]],"v":[{},[0,0,2,1,2]],"z":[{},[2,1,2]]}],"s":[{"z":[{"e":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[2,1]]}]}],"l":[{"a":[{"j":[{"t":[{},[0,0,0,1]]}]}],"á":[{"r":[{"o":[{},[0,0,0,1]]}]}],"d":[{"a":[{"l":[{},[2,1]]}],"á":[{},[2,1]],"ó":[{},[2,1]]}],"i":[{"d":[{},[0,0,2]],"g":[{"á":[{},[0,0,2,1]]}],"m":[{"p":[{},[0,0,2]]}],"n":[{"a":[{".":[{},[0,0,2,1,2]]}]}],"t":[{"a":[{},[0,0,2]]}]}],"l":[{"a":[{"d":[{},[0,0,0,2,1]]}],"á":[{"l":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"é":[{"t":[{},[0,0,0,2,1]]}]}],"ö":[{},[0,0,2]],"t":[{"á":[{"r":[{},[2,1]]}]}],"v":[{"a":[{"s":[{},[2]]}]}]}],"m":[{"b":[{"u":[{},[2,1]]}],"i":[{"l":[{},[0,0,2]]}],"p":[{"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"o":[{"l":[{},[0,0,0,2,1]]}]}]}],"n":[{"a":[{"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"u":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]]}],"b":[{"á":[{},[2]],"e":[{"t":[{},[2]]}]}],"c":[{"c":[{},[0,0,0,0,1]],"é":[{},[0,0,0,0,0,2]],"h":[{},[0,0,0,2]],"s":[{"á":[{},[0,0,0,2]],"o":[{"r":[{".":[{},[0,0,0,2,3]],"o":[{},[0,0,0,2,3]]}]}]}]}],"e":[{},[0,0,2,1]],"é":[{"n":[{},[2]],"r":[{".":[{},[0,0,2,1]]}]}],"g":[{"u":[{},[2]]}],"h":[{"a":[{"b":[{},[2]]}]}],"i":[{"r":[{},[0,0,2]]}],"o":[{"g":[{},[2]],"l":[{"a":[{},[2]]},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{"n":[{},[2]],"r":[{},[2]],"t":[{},[2]]}]}],"p":[{"a":[{},[2]],"r":[{},[2]]}],"r":[{"é":[{"t":[{},[2]]}]}],"t":[{"ö":[{},[2]]}],"ü":[{},[0,0,2]],"y":[{"a":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]]}],"e":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"z":[{"s":[{},[2]]},[0,0,0,0,2]]}],"ó":[{"n":[{},[0,0,2]]}],"p":[{"á":[{"s":[{"é":[{},[0,0,0,0,2]]}]}],"c":[{},[2]],"r":[{"o":[{},[0,0,1]]}],"t":[{"i":[{},[2]]}]}],"r":[{"a":[{"d":[{},[0,0,2,1,2]],"g":[{},[0,0,2]],"j":[{},[0,0,2,1]],"n":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,1]],"z":[{"t":[{},[0,0,2,1]]}]}]}],"á":[{"t":[{"l":[{},[0,0,2,1]]}]}],"c":[{"h":[{},[2,1]],"s":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"d":[{"a":[{"d":[{},[0,0,0,2]],"g":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1,2]]}],"á":[{"c":[{},[0,0,0,2]]}],"d":[{},[0,0,0,0,1]],"e":[{"l":[{},[0,0,0,2,1,2]],"m":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"í":[{"t":[{},[0,1]]}],"ö":[{},[0,0,0,2,1]],"z":[{},[0,0,0,2,3]]}],"e":[{"c":[{},[0,0,2,1,2]],"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"f":[{},[0,0,0,1,2]],"g":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}],"i":[{"e":[{},[2]],"l":[{"l":[{},[0,0,0,1]]}],"n":[{"g":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2,1]]}]}],"s":[{"k":[{},[0,0,0,1]]}],"z":[{"o":[{"m":[{},[0,0,2,1,2]]}]}]}],"o":[{"s":[{"z":[{},[0,0,2]]}],"v":[{},[0,0,2,1,2]]}],"ó":[{"i":[{},[0,0,2,1]],"n":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"r":[{".":[{},[2,1]],"k":[{},[2]],"t":[{},[2,1]]}],"s":[{},[0,0,0,1,2]],"t":[{"r":[{},[0,0,0,1,2]]}],"ú":[{"t":[{"o":[{},[0,0,2,1]]}]}],"ü":[{},[0,0,2]]}],"s":[{"a":[{"s":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2]],"s":[{"z":[{"e":[{},[0,0,0,3]],"o":[{},[0,0,0,3]],"ü":[{},[0,0,0,3]]}]}],"t":[{"r":[{},[2,1]]}],"ü":[{},[0,0,2]],"z":[{"a":[{"l":[{},[0,0,2]]}],"e":[{"r":[{},[0,0,2]]}],"i":[{"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{},[0,2]],"ó":[{},[0,0,2]],"t":[{"á":[{},[2]]}]}]}],"t":[{"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"s":[{"t":[{},[0,0,0,0,1]]}]}]}],"u":[{"t":[{},[0,0,2]]}],"v":[{"a":[{"r":[{"i":[{"a":[{},[2]]}]}]}],"i":[{"é":[{},[0,0,2]]}]}],"x":[{"i":[{},[0,0,2]]}],"z":[{"a":[{"t":[{"a":[{"l":[{},[0,0,0,0,2]]}]}]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}],"ö":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}],"ö":[{},[2]]}]}]},[1]],"ó":[{"a":[{"d":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"c":[{},[0,0,0,3]],"e":[{"m":[{},[0,0,2]]}],"h":[{},[0,0,2]]}],"d":[{"a":[{"b":[{},[0,0,2,1]],"k":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"d":[{},[0,0,0,1]],"e":[{"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]]}],"é":[{"s":[{},[0,0,2,1]]}],"i":[{"n":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{"á":[{},[0,0,2]]}]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1,2]]}],"i":[{"g":[{},[0,0,0,2]]}],"í":[{"v":[{},[0,0,0,2]]}],"k":[{"r":[{"é":[{},[0,0,1]]}],"v":[{},[0,0,1]]}],"n":[{"é":[{".":[{},[2,1,2]],"t":[{},[0,0,2]]}],"i":[{".":[{},[2,1,2]]}],"o":[{},[2,1,2]]}],"p":[{"a":[{"n":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"e":[{"l":[{},[0,0,2,1,2]]}],"i":[{"r":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"a":[{"a":[{},[2,1,2]],"c":[{},[0,0,2,1,2]],"i":[{},[2,1,2]],"n":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"á":[{"b":[{},[0,0,2]],"d":[{},[0,0,2]],"g":[{},[0,0,2]],"i":[{},[0,0,2]],"j":[{},[0,1,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2]],"s":[{},[0,0,0,0,2]]}],"é":[{"j":[{},[0,0,2]],"v":[{"e":[{},[0,0,2,1]]}]}],"i":[{"r":[{},[0,0,2,1]]}],"o":[{"k":[{"a":[{},[0,0,0,0,2]],"o":[{},[0,0,0,0,2]]},[0,0,2,1]],"s":[{"t":[{"o":[{},[0,0,0,1]]}]}]}],"ó":[{"d":[{"á":[{},[0,0,2,1]]},[2]]}],"ő":[{},[0,0,2]]}],"s":[{"á":[{"g":[{"ú":[{},[2,1,2]]}]}],"l":[{"á":[{},[0,0,1]]}],"o":[{"s":[{},[0,0,2,1]]}],"p":[{"e":[{},[0,0,1,2]],"i":[{},[0,0,1]],"o":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1]]}],"ü":[{},[0,0,2,1,2]],"z":[{"á":[{"r":[{"a":[{},[0,0,2,3]]}]}]}]}],"v":[{"ó":[{},[2,1,2]]}],"z":[{"a":[{"m":[{},[0,0,2,1,2]]}]}]},[1]],"ö":[{"b":[{"a":[{},[0,0,2]],"ö":[{"l":[{"l":[{},[0,0,0,1]],"n":[{},[0,0,0,1]],"r":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}]}]}],"d":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]],"v":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"z":[{},[0,0,2]]}],"k":[{"o":[{},[2,1,2]],"r":[{"ö":[{},[2,1]]}]}],"l":[{"c":[{"s":[{"a":[{"l":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2]]}],"ő":[{},[0,0,0,2,0,1,2]]}]}],"e":[{"l":[{},[2,1]],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"é":[{"s":[{"s":[{"z":[{},[2,1,2]]}]}]}],"í":[{},[0,0,2]],"ő":[{"e":[{},[0,0,2]]}],"t":[{"a":[{"l":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"e":[{"v":[{},[0,0,0,2,1,2]]}]}]}],"n":[{"g":[{},[2,1]],"t":[{"é":[{},[0,1]],"ő":[{},[0,1]],"v":[{},[0,1]]}],"y":[{"v":[{"a":[{},[0,0,0,0,2,1]],"á":[{},[0,0,0,0,2]]}]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"d":[{"ö":[{},[0,1]]}],"e":[{"d":[{},[0,0,2]],"g":[{},[0,0,2,1,2]]}],"é":[{"k":[{},[0,0,2]],"t":[{"t":[{},[0,0,2,1]]}]}],"f":[{},[0,0,0,1,2]],"i":[{"k":[{},[0,0,2]],"z":[{},[0,0,2,1]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{"l":[{},[0,0,2,1,2]]}],"ő":[{},[0,0,2,1,2]],"p":[{},[0,0,0,1,2]],"s":[{},[0,0,0,1,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{"l":[{"e":[{"t":[{},[0,0,0,0,2,1]]}],"é":[{"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"ő":[{".":[{},[0,0,2,1]]},[0,0,0,0,2]]}]}],"v":[{".":[{},[2]],"b":[{},[2]],"h":[{},[2]],"n":[{},[2]],"ö":[{},[2,1]],"r":[{},[2]],"t":[{},[2]],"ü":[{},[2]],"ű":[{},[2]],"v":[{},[2]]}]}],"s":[{"z":[{"t":[{},[0,1]]}]}],"t":[{"l":[{"é":[{},[2]]}],"v":[{"ö":[{},[0,1]]}]}],"v":[{".":[{},[2,1]],"b":[{},[2,1]],"h":[{},[2,1]],"i":[{"g":[{},[2,1,2]]}],"r":[{},[2,1]],"v":[{},[2,1]]}],"z":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"n":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2,1]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ő":[{"e":[{},[0,0,0,0,0,2]]}],"s":[{},[0,0,2,3]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{"l":[{"é":[{},[0,0,2,1,2]],"ő":[{},[0,0,2,1,2]]}]}]}]},[1]],"ő":[{"a":[{"n":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"h":[{},[0,0,2]]}],"d":[{"r":[{"a":[{},[0,0,1]]}]}],"e":[{"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2]],"n":[{"e":[{},[0,0,0,2]]}]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"t":[{},[0,0,0,2]]}],"k":[{"r":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"n":[{},[0,0,0,1]]}],"e":[{"i":[{},[0,1,2]],"s":[{"z":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"i":[{".":[{},[0,1,2]],"l":[{},[0,0,2]],"p":[{},[0,0,2]],"v":[{},[0,0,2]]}],"l":[{},[0,1]],"s":[{},[0,0,0,1,2]],"ü":[{"l":[{},[0,0,2]]}],"z":[{},[2,1]]}],"s":[{"k":[{},[0,0,1,2]],"ö":[{},[0,0,2]],"t":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"t":[{},[0,0,0,2]]}]},[1]],"p":[{"á":[{"r":[{"a":[{"d":[{},[0,0,0,2]],"t":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"á":[{"l":[{},[0,0,0,2,1]]}],"ú":[{"t":[{},[0,0,0,2,1]]}]}]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"u":[{},[0,0,2]]}],"ó":[{"t":[{},[0,0,0,2]]}],"r":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}]}],"r":[{"a":[{"c":[{"h":[{"i":[{},[0,0,0,2]]},[0,2]]}],"j":[{"c":[{},[1,2]]}],"k":[{"k":[{},[0,2]]}],"p":[{},[0,0,0,1]]}],"á":[{"s":[{"z":[{"e":[{},[0,0,0,2,0,1]]}]}]}],"e":[{"n":[{"d":[{"ő":[{},[0,0,0,0,2,1,2]]}]}],"o":[{},[0,2]],"p":[{"á":[{},[0,2]]}]}],"é":[{"m":[{"h":[{},[1,2]],"l":[{},[1,2]],"r":[{},[1,2]]}],"p":[{},[0,0,0,3,2]]}],"i":[{"s":[{"t":[{},[1,2]]}],"t":[{"i":[{},[1,2]]}]}],"o":[{"g":[{},[0,0,0,1,2]],"k":[{"e":[{"t":[{"t":[{".":[{},[1]]}]}]}],"o":[{"d":[{},[1]]}]}],"n":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2]],"d":[{},[0,0,0,0,1,2]],"e":[{},[0,0,0,2,1]]}],"p":[{},[0,0,0,1,2]],"s":[{"t":[{"r":[{},[0,0,0,1]]}],"z":[{"f":[{},[0,0,0,1,0,2]]}]}]}],"ó":[{"m":[{"a":[{"r":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"i":[{"s":[{},[0,0,0,2]]}],"o":[{},[0,2]]}],"n":[{"i":[{"k":[{},[1,2]]}]}]}],"u":[{"p":[{},[0,2]]}]}],"s":[{"a":[{"r":[{"á":[{},[0,2,1,2]]}]}],"e":[{"l":[{"o":[{},[0,0,1]]}]}],"é":[{"g":[{"e":[{"l":[{"e":[{},[0,0,0,2]]}]}],"i":[{"s":[{},[0,0,0,2]]}],"ü":[{"l":[{"é":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}]}],"k":[{"á":[{},[0,1,2]],"o":[{},[0,0,2]]}],"l":[{"a":[{},[0,1,2]],"á":[{},[0,0,2]],"u":[{},[0,0,2]]}],"m":[{"i":[{},[0,0,2]]}],"n":[{"i":[{},[0,1,2]]}],"p":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"r":[{},[0,0,0,2]]}],"r":[{"á":[{},[0,0,2]]}],"t":[{"a":[{},[0,1,2]],"á":[{},[0,1,2]],"i":[{},[0,0,2]],"í":[{},[0,1,2]],"o":[{},[0,0,2]],"r":[{},[0,1,0,2]],"u":[{},[0,1,2]],"ú":[{},[0,1,2]]}],"z":[{"a":[{"d":[{},[0,2,0,1,2]],"e":[{},[0,0,0,0,0,2]],"g":[{"y":[{},[0,2]]}],"j":[{},[0,2,0,1]],"k":[{"e":[{},[0,0,0,0,2]],"é":[{},[0,0,0,0,2]],"ü":[{},[0,0,0,0,2,1]]}],"m":[{},[0,2,0,1]],"n":[{"y":[{},[0,0,0,1]]}],"r":[{"é":[{},[0,0,0,1]]}]}],"á":[{"g":[{},[0,2,0,1]],"r":[{"a":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"e":[{"g":[{"y":[{},[0,2,0,1,2]]}],"l":[{"a":[{},[0,2,0,1]]}],"m":[{"u":[{},[0,2]]}],"n":[{"g":[{},[0,2,0,1]]}],"v":[{},[0,2]]}],"é":[{"l":[{"e":[{"t":[{},[0,0,0,1]]}]}],"t":[{},[0,0,0,0,2,1]]}],"i":[{"d":[{},[0,2,0,1]],"l":[{"á":[{},[0,0,0,0,0,0,2]]}],"p":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{"k":[{},[0,0,0,1]]}]}],"í":[{"r":[{},[0,2]]}],"o":[{"l":[{"d":[{},[0,2,0,1]],"t":[{"ó":[{},[0,2]]}]}],"s":[{"z":[{},[0,2,0,1]]}]}],"ö":[{"g":[{"e":[{"l":[{"l":[{},[0,0,0,0,2,1]],"v":[{},[0,0,0,0,2,1]]}]}]}]}],"t":[{},[0,0,0,0,2]],"u":[{"n":[{"i":[{},[0,2]]}],"t":[{},[0,2]]}],"ü":[{"g":[{},[0,2,0,1]],"t":[{},[0,2]],"z":[{},[0,2,0,1,2]]}],"z":[{},[0,0,0,1]]}]}],"t":[{"a":[{"d":[{"a":[{},[0,0,1,2]]}],"j":[{"á":[{},[0,0,1]]}],"l":[{"a":[{"p":[{},[0,0,1,2]]}],"b":[{},[0,2,1]],"l":[{},[0,2,1]]}],"n":[{"á":[{"s":[{},[0,0,0,2,1,2]]}],"ó":[{},[0,0,0,2,1,2]]}],"p":[{},[0,0,0,1,2]],"r":[{"m":[{},[0,2,1]]}],"u":[{"d":[{},[0,0,1,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"l":[{"a":[{"l":[{},[0,0,0,2]]}],"l":[{"ó":[{},[0,0,1]]}],"m":[{},[0,2,1]]}],"r":[{"a":[{"d":[{"a":[{},[0,0,0,2,1]],"ó":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]],"j":[{},[0,0,0,2]],"z":[{},[0,0,0,2,1]]}]}],"t":[{"f":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"e":[{"g":[{},[0,2,1,2]],"l":[{"g":[{},[0,2,1]],"h":[{},[0,2,1]],"j":[{"á":[{},[0,0,1]]}],"l":[{},[0,2,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"n":[{"z":[{},[0,2,1]]}],"r":[{"a":[{"d":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"e":[{"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1,2]]}],"i":[{"n":[{},[0,0,0,2,1]]}],"o":[{"s":[{"z":[{},[0,0,0,2]]}]}]}],"s":[{"e":[{"m":[{},[0,2,1]]}]}]}],"é":[{"l":[{"ő":[{},[0,0,0,2]]}],"r":[{"l":[{},[0,2,1]],"m":[{"i":[{},[0,2]]}],"t":[{"e":[{},[0,2,1]]}]}],"s":[{"s":[{},[0,2,1]]}],"v":[{"e":[{"t":[{},[0,2,1,2]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1]],"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,1]]},[0,0,0,2]],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]]}],"r":[{},[0,2,1,2]],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]]}],"v":[{"á":[{"s":[{},[0,2,1,2]]}]}]}],"í":[{"g":[{},[0,2,1]],"r":[{},[0,2,1,2]],"v":[{"e":[{"l":[{},[0,0,0,0,1,2]]}]}]}],"o":[{"g":[{"r":[{"a":[{},[0,0,0,1,2]]}]}],"n":[{"á":[{},[0,0,0,2,1]]}],"p":[{"e":[{},[0,0,1]]}],"r":[{"a":[{"s":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]],"o":[{"l":[{},[0,0,0,2]]}]}]}],"ö":[{"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"a":[{"n":[{},[0,1,2]],"u":[{},[0,1]]}],"é":[{"f":[{},[0,1]],"n":[{},[0,1,2]]}],"i":[{"ó":[{},[0,1,2]]}],"o":[{"n":[{"á":[{},[0,0,0,0,2]]}]}],"ó":[{"n":[{},[0,1,2]]}]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"m":[{"e":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2]]}]}],"s":[{"a":[{"b":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}],"z":[{"á":[{"r":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"é":[{},[0,0,0,2]]}]}]}],"ü":[{"l":[{"é":[{},[0,2,1]]},[0,0,0,2]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]]}]}],"u":[{"á":[{"r":[{},[0,0,0,2]]}],"c":[{"c":[{},[2,1]]}],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"o":[{},[2,1,2]],"r":[{},[2,1]],"y":[{"a":[{},[0,0,2]]}]}],"j":[{"j":[{".":[{},[2,1]],"a":[{".":[{},[2]],"d":[{"a":[{},[0,0,0,2,1,2]]},[2]],"i":[{},[2]],"k":[{},[2]],"l":[{},[2,1]],"m":[{},[2]],"s":[{},[2]],"t":[{},[2]]}],"á":[{},[2,1]],"b":[{},[2]],"g":[{},[2]],"h":[{},[2]],"i":[{},[2]],"k":[{},[2]],"n":[{},[2]],"o":[{},[2,1]],"p":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"u":[{},[2]],"ú":[{},[2]]}]}],"k":[{"k":[{"ó":[{},[0,0,0,2,1,2]]}]}],"l":[{"a":[{"k":[{},[0,0,0,0,1]]}],"c":[{"s":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]]}]}],"u":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"m":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"n":[{"a":[{"d":[{},[0,0,2]],"l":[{},[0,0,2]]}],"á":[{"s":[{},[0,0,2,1]]}],"e":[{},[0,0,2]],"i":[{"n":[{},[0,0,2,1]]}],"n":[{},[0,0,0,3]],"o":[{"r":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]],"ü":[{},[0,0,2]]}],"p":[{".":[{},[2,1]],"r":[{},[2]],"u":[{},[2]]}],"r":[{"a":[{"d":[{},[0,0,2]],"i":[{},[2,1,2]],"k":[{},[0,0,2]],"l":[{},[2]],"m":[{},[0,0,2]]}],"á":[{"u":[{},[0,0,2]]}],"n":[{},[2,1]],"o":[{"l":[{},[0,0,2]]}],"u":[{"c":[{"s":[{},[0,0,0,0,2,3]]}]}]}],"s":[{"a":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"s":[{},[0,0,2]],"z":[{},[0,0,2,1,2]]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"s":[{"z":[{"e":[{},[0,0,0,3]]}]}],"ú":[{},[0,0,2,1]],"ü":[{},[0,0,2]],"z":[{"a":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]]}],"e":[{"s":[{},[0,0,0,0,1]]}],"é":[{"l":[{},[0,0,2,0,1,2]],"p":[{},[0,0,2,0,1,2]],"t":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2,0,1]],"s":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}]}],"t":[{"a":[{"l":[{"ó":[{},[2]]}],"s":[{"í":[{},[2,1,2]]}],"z":[{},[2,1,2]]}],"á":[{"l":[{},[0,0,2]],"n":[{},[2,1,2]]}],"c":[{},[2,1]],"o":[{"l":[{},[2,1,2]]}],"ó":[{"d":[{},[2,1,2]],"p":[{},[0,0,2]]}]}],"z":[{"s":[{},[0,0,2]]}]},[1]],"ú":[{"j":[{"í":[{},[0,0,2]],"s":[{},[2,1]]}],"p":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"e":[{},[0,0,2,1]]}],"t":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{},[0,0,2,1]],"f":[{"é":[{"l":[{},[0,0,0,0,0,0,1]]},[0,0,0,0,0,2]]}],"o":[{"s":[{},[0,0,2]]}],"ő":[{},[0,0,2,1]],"u":[{},[2,0,2]],"ü":[{},[0,0,2,1,2]]}]},[1]],"ü":[{"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"e":[{"p":[{},[2,1,2]]}],"o":[{},[0,0,2]],"t":[{"á":[{},[0,0,0,2,1]]}]}],"r":[{"e":[{"g":[{},[2]]}],"í":[{},[2,1,2]],"ü":[{},[0,0,2]]}],"s":[{"t":[{},[2,1]],"z":[{"á":[{},[0,0,2]],"í":[{},[0,0,2]]}]}],"t":[{"k":[{},[2,1]]}],"v":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"ö":[{},[2,1,2]]}],"z":[{"e":[{},[2,1,2]]}]},[1]],"ű":[{"r":[{"h":[{},[2,1]],"m":[{},[2,1]],"o":[{},[0,0,2]],"ő":[{"s":[{},[0,0,2,1]]}]}],"z":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[1]],"v":[{"a":[{"n":[{},[1,2]],"r":[{"c":[{},[0,2]],"k":[{},[1,2]]}]}],"á":[{"n":[{"y":[{"o":[{"l":[{},[0,0,0,2]]}]}]}],"r":[{"o":[{"s":[{"i":[{},[0,0,0,0,0,0,0,2]]}]}]}]}],"é":[{"s":[{"e":[{"l":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]]}]}],"i":[{"n":[{},[1,2]],"t":[{"t":[{},[1,2]]}]}],"ó":[{"c":[{},[0,2]],"t":[{"a":[{},[0,2]],"á":[{},[0,2]]}]}],"ő":[{"c":[{"s":[{"a":[{},[0,0,0,0,0,0,2]]}]}]}]}],"y":[{"d":[{"n":[{},[0,0,0,2]]}],"f":[{"a":[{"j":[{"t":[{"á":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}]}]}]}]}],"i":[{"s":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"k":[{"k":[{},[0,0,0,2]],"n":[{"e":[{},[0,0,0,2]]}]}],"s":[{"e":[{},[0,0,2]],"ü":[{},[0,0,2,1,2]]}],"ü":[{"z":[{},[0,0,1]]}]},[1]],"z":[{"a":[{"t":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"ó":[{},[0,0,0,2,1,2]]}]}]}]}],"l":[{".":[{},[2]],"a":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{"t":[{"a":[{},[0,0,0,0,0,2]]},[0,0,0,0,1]]}],"b":[{"á":[{"r":[{},[2]]}],"d":[{},[3]],"r":[{},[2]],"s":[{},[2,1]]}],"c":[{"a":[{"g":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2,1]]}],"e":[{"m":[{},[0,0,2]],"t":[{"e":[{},[0,0,2,1]]}]}],"h":[{"a":[{},[0,0,2,3]],"é":[{},[0,0,2]]}],"i":[{"t":[{"a":[{},[0,0,0,1]]}]}],"k":[{"o":[{"r":[{"r":[{},[0,0,0,2,1]]}]}]}],"o":[{"r":[{"r":[{},[0,0,0,1]]}]}],"ö":[{},[0,0,2,1,2]],"ő":[{},[0,0,2]],"s":[{"a":[{"l":[{"j":[{},[0,0,2]]}]}],"á":[{"g":[{},[0,0,0,3]]}],"o":[{"r":[{},[0,0,2,3]]}],"ü":[{"l":[{},[0,0,0,3]],"t":[{},[0,0,0,3]]}],"z":[{},[0,0,0,3]]}],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"d":[{"a":[{"t":[{"a":[{},[2,1,2]],"b":[{},[2,1,2]],"k":[{},[2,1,2]],"n":[{},[2,1,2]],"o":[{},[2,1,2]],"r":[{},[2,1,2]],"t":[{},[2,1,2]],"u":[{},[2,1,2]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"l":[{},[2,1]],"o":[{"g":[{},[2,1,2]],"m":[{"á":[{},[2]]}],"n":[{},[3,2,3]]}],"ó":[{"i":[{"k":[{"o":[{},[0,0,0,0,0,2]]}]}]}],"u":[{"k":[{},[2,1,2]]}],"y":[{},[0,0,1,0,2]]}],"e":[{"d":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"d":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"f":[{"f":[{},[2]],"l":[{},[0,0,1]]}],"g":[{"a":[{"c":[{},[0,0,2]],"d":[{"ó":[{},[0,0,0,1,2]]}],"n":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,1]]}],"t":[{},[0,0,2,1,2]],"u":[{},[0,0,2]],"v":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2]],"l":[{"l":[{},[0,0,0,1]]}],"r":[{".":[{},[0,0,0,1]],"á":[{},[0,0,0,1]],"b":[{},[0,0,0,1]],"e":[{},[0,0,0,1]],"é":[{},[0,0,0,1,2]],"f":[{},[0,0,0,1]],"h":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"m":[{},[0,0,0,1]],"n":[{},[0,0,0,1]],"o":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1]],"s":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}]}],"e":[{"r":[{"e":[{},[0,0,2,1]]}]}],"é":[{"s":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"m":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"n":[{"t":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"c":[{},[0,0,2]],"r":[{"á":[{},[0,0,2,1,2]]}],"v":[{"á":[{},[0,0,2]]}]}],"ö":[{"n":[{},[0,0,2]]}],"u":[{"d":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"ü":[{},[0,0,2,1]],"ű":[{},[0,0,2]],"y":[{"ú":[{},[0,0,2]]}]}],"i":[{"r":[{"e":[{},[0,0,2]]}]}],"j":[{"a":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{"s":[{},[0,0,0,1]],"z":[{},[0,0,0,1,2]]}],"z":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]],"n":[{"l":[{},[2]]}],"r":[{".":[{},[0,0,2,1]],"h":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"s":[{},[0,0,2]],"t":[{"h":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}]}],"e":[{"l":[{"t":[{},[0,0,2,1]]}],"n":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"i":[{"n":[{},[0,0,2]],"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2,1]],"m":[{"l":[{},[0,0,2,1]]}],"r":[{},[0,0,2,1]],"z":[{},[2]]}],"ó":[{"r":[{},[0,0,2,1]]}],"ö":[{"s":[{},[0,0,2,1]]}],"ő":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,1]]},[0,2]],"u":[{"t":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,2,1,2]]}],"k":[{"a":[{"d":[{},[0,0,2]],"l":[{"j":[{},[0,0,0,1]],"m":[{},[0,0,2,1]],"o":[{},[0,0,2,1,2]]}],"t":[{"a":[{"n":[{},[0,0,0,0,2,1,2]]}]}]}],"á":[{"c":[{},[0,0,2,1]],"l":[{"k":[{},[0,0,2,1]],"l":[{},[0,0,0,1]]}],"r":[{"n":[{},[0,0,2,1]]}],"s":[{"á":[{"s":[{},[0,0,0,1]]}]}]}],"c":[{"i":[{},[2]]}],"e":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2]]}]}]}],"i":[{"k":[{"o":[{},[0,0,2,1]]}]}],"í":[{"r":[{},[0,0,2,1]]}],"k":[{"a":[{"s":[{},[0,0,0,2,1]]}],"e":[{"c":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]],"r":[{},[2,1]]}],"ö":[{"l":[{},[0,0,0,2]]}]}],"l":[{"u":[{},[0,0,1]]}],"n":[{"á":[{"b":[{},[2]],"h":[{},[2]],"s":[{},[2]]}]}],"o":[{"b":[{},[0,0,2]],"p":[{},[0,0,2,1]],"r":[{"m":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1]]}],"ó":[{"z":[{},[2]]}],"ö":[{"s":[{},[0,0,2,1]]}],"r":[{"é":[{"m":[{},[0,0,1,2]]}],"i":[{"p":[{},[0,0,0,2]]}],"u":[{},[0,0,1,2]]}],"t":[{".":[{},[2,1]],"i":[{"v":[{},[2,1]]}]},[0,0,0,0,2]],"u":[{"j":[{},[0,0,2]],"l":[{"á":[{},[2]],"g":[{},[2]],"h":[{},[2]],"j":[{},[2]],"n":[{},[2]],"o":[{},[2]],"ó":[{},[2]],"s":[{},[2]],"u":[{},[2]],"v":[{},[2]]}]}],"ú":[{"s":[{},[2]],"t":[{"o":[{},[0,0,2,1,2]]}],"v":[{},[2]]}],"z":[{"a":[{},[2]]}]}],"l":[{"a":[{"g":[{},[0,0,2,0,2,1]],"k":[{"u":[{},[0,0,2]]}]}],"á":[{"í":[{},[2]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"f":[{},[2,1]],"j":[{"n":[{},[2]]}],"k":[{"a":[{},[2,1]],"o":[{"t":[{},[2,1]]}],"u":[{},[2,1]]}],"l":[{"e":[{},[2,1]]}],"t":[{"á":[{"r":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"i":[{".":[{},[2,1]]}],"o":[{"n":[{"k":[{},[2]]}]}],"ó":[{},[0,0,0,2,1,2]],"ü":[{},[0,0,0,2,1,2]],"v":[{"é":[{},[2]]}]}],"v":[{"i":[{},[2,1]]}]}],"m":[{"a":[{"d":[{"a":[{},[0,0,0,1]]}],"k":[{"a":[{},[0,0,2,1]]}],"n":[{"y":[{},[0,0,2,1]]}],"p":[{},[0,0,2,1,2]],"r":[{"á":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1,2]]}],"e":[{"g":[{"y":[{},[0,0,2,1]]},[0,0,0,0,2]],"l":[{"e":[{},[0,0,2,1]]}],"m":[{"b":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"é":[{"k":[{},[0,0,2]],"l":[{"e":[{},[0,0,0,1]]}],"n":[{"e":[{},[0,0,2]]}],"r":[{"v":[{},[0,0,2,1]]}]}],"i":[{"n":[{"v":[{},[0,0,2]]}],"s":[{"m":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2,1,2]],"m":[{"ó":[{},[2,1]]}],"o":[{"l":[{},[0,0,2,1]],"r":[{"g":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ö":[{},[0,0,2]],"u":[{"r":[{},[0,0,2,1]]}],"ü":[{},[0,0,2,1]]}],"n":[{"a":[{"d":[{},[0,0,2,1,2]],"g":[{},[0,0,0,0,2]],"j":[{},[0,0,2,1]],"l":[{"a":[{},[0,0,0,1]]},[0,0,2]],"m":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}],"r":[{".":[{},[0,0,2,1]],"a":[{"i":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]]}],"á":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"c":[{"s":[{"e":[{"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2]]}],"i":[{},[0,0,0,2]],"o":[{"l":[{},[0,0,0,2]]}]}]}],"d":[{"á":[{"l":[{},[0,0,0,2,1]]}],"e":[{"l":[{},[0,0,0,2,1]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"i":[{"z":[{},[0,0,0,2]]}]}],"e":[{"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"é":[{"p":[{},[0,0,2,1]]}],"g":[{"a":[{"s":[{},[0,0,0,2,1]]}],"e":[{"n":[{},[0,0,0,2]]}],"g":[{},[0,0,0,0,3]],"i":[{"n":[{},[2,1]]}]}],"i":[{"l":[{},[0,0,2]],"p":[{},[0,0,2]],"s":[{},[0,0,2]]}],"k":[{"é":[{"t":[{},[2,1]]}],"r":[{},[0,0,0,1]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"s":[{},[0,0,0,0,2]],"t":[{"a":[{"g":[{},[0,0,0,2]]}],"á":[{"c":[{},[2]]}]}],"ü":[{},[0,0,2]],"y":[{"a":[{"g":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,0,1,2]]}],"u":[{},[0,0,2]]}],"á":[{"i":[{},[2]],"l":[{},[0,0,2,0,1]],"n":[{},[2]],"s":[{},[0,0,2]],"v":[{},[2]]}],"e":[{"l":[{"e":[{"m":[{},[0,0,2,0,1,2]]}]}],"r":[{"ő":[{},[0,0,0,0,1,2]]}]}],"í":[{"r":[{},[0,0,2,0,1,2]]}],"o":[{"l":[{},[0,0,2,0,1]]}],"ó":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"a":[{".":[{},[2,1,2]],"k":[{"k":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1]]}],"t":[{"m":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"u":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"á":[{"b":[{},[0,0,2]],"g":[{},[0,0,2,1,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{"á":[{},[0,0,0,1,2]],"h":[{},[0,0,0,1]],"r":[{},[0,0,2,1]]}]}],"e":[{"l":[{"e":[{},[0,0,0,1]]},[0,0,2,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2,1]],"s":[{},[0,0,2,1]]}],"i":[{"k":[{},[0,0,2]],"l":[{"l":[{"a":[{},[0,0,0,1]],"e":[{},[0,0,0,1]]}]}],"m":[{},[0,0,2,1]],"n":[{"a":[{".":[{},[0,0,2,1,2]]}],"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"p":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1,2]],"t":[{"a":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"l":[{"a":[{"t":[{},[0,0,0,2]]}]}],"o":[{"k":[{"u":[{},[0,0,2,1,2]]}],"r":[{"g":[{},[0,0,0,1]],"n":[{},[0,0,0,1]],"z":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"ó":[{".":[{},[0,0,2]],"b":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{"a":[{"r":[{},[2]]}]}],"r":[{"í":[{},[2]]}],"s":[{},[0,0,0,1,2]],"ú":[{"n":[{},[2]],"v":[{},[2]]}],"ű":[{},[0,0,2]]}],"r":[{"a":[{".":[{},[0,0,2]],"n":[{},[0,0,2]]}],"c":[{"c":[{},[0,0,0,0,3]]},[2,1]],"é":[{"n":[{},[2,1,2]]}],"m":[{"e":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2]]}]}],"t":[{},[2,1]],"z":[{},[2,1]]}],"s":[{"p":[{"a":[{},[0,0,1,2]],"i":[{},[0,0,1,2]]}],"t":[{"r":[{"a":[{},[0,0,1]]}]}],"z":[{"a":[{"b":[{"l":[{},[0,0,2,0,1]]}],"l":[{"t":[{".":[{},[0,0,0,0,1]]}]}],"s":[{},[0,0,2]],"t":[{},[2,1,2]]}],"á":[{"s":[{},[0,0,2]]}],"é":[{"n":[{},[0,0,2,0,1]]}],"ó":[{"d":[{},[0,0,2]]}],"s":[{},[0,0,0,0,3]],"t":[{"a":[{"l":[{"j":[{},[0,0,0,0,2,1]]}],"m":[{},[0,1]]}]}],"ú":[{"t":[{},[0,0,2,0,1]]}]}]}],"t":[{"a":[{"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"l":[{"a":[{"k":[{},[0,0,0,1]]}],"k":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"r":[{"á":[{},[0,0,0,1]],"o":[{},[0,0,2,1,2]],"t":[{"i":[{},[0,0,0,1]]}]}],"s":[{"z":[{"t":[{},[0,0,0,1]]}]}],"t":[{"t":[{},[0,0,0,1]]}],"u":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"j":[{},[0,0,2,1]],"l":[{"l":[{},[0,0,0,1]]}],"r":[{"a":[{"d":[{},[0,0,2,1]],"i":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"á":[{"b":[{},[0,0,2,1,2]],"h":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]]}],"é":[{},[0,0,2,1,2]],"h":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"o":[{"k":[{},[0,0,2,1,2]]}],"r":[{},[0,0,2,1]],"t":[{"á":[{},[0,0,0,1]],"ó":[{},[0,0,2,1]]}],"ú":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,0,2,1]]}]}],"d":[{"i":[{"a":[{"l":[{},[0,0,0,0,0,2]]}]}]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"e":[{"m":[{},[0,0,2]]}],"l":[{},[0,0,2,1]]}],"p":[{},[0,0,2]],"r":[{"k":[{},[0,0,2,1]]}],"s":[{"s":[{},[0,0,2,1]],"z":[{"e":[{},[0,0,2]]}]},[0,0,0,0,2]],"t":[{"i":[{},[0,0,2,1]],"o":[{},[0,0,2,1]]}],"v":[{"ő":[{},[0,0,2,1,2]]}]}],"é":[{"k":[{"e":[{},[0,0,2,1]],"é":[{},[0,0,0,1,2]],"k":[{},[0,0,0,1]]}],"r":[{"é":[{},[0,0,2,1,2]],"ő":[{},[0,0,2,1,2]],"t":[{"e":[{},[0,0,2]]}],"v":[{},[0,0,2,1]]}],"s":[{"s":[{},[0,0,0,1]]}]}],"i":[{"k":[{"o":[{},[0,0,2,1,2]],"r":[{"a":[{},[0,0,0,1]]}]}],"n":[{"t":[{"e":[{},[0,0,0,1]]}],"v":[{},[0,0,2,1]]}],"s":[{"t":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1]]}],"í":[{"r":[{},[0,0,2,1]],"v":[{"é":[{},[0,0,0,1]]}]}],"k":[{},[0,0,0,1,2]],"o":[{"j":[{},[0,0,2]],"k":[{"m":[{},[0,0,2,1]]}],"l":[{"d":[{"a":[{},[0,0,0,1]]}],"l":[{},[0,0,2]]}],"m":[{"l":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,2,1]]}],"t":[{"t":[{"h":[{},[0,0,2,1]]}]}]}],"ó":[{"r":[{"á":[{},[0,0,2,1]],"i":[{},[0,0,2,1]]}]}],"ö":[{"v":[{"i":[{},[0,0,2,1]],"ö":[{},[0,0,2,1,2]]}]}],"ő":[{"r":[{},[0,0,2,1]]}],"t":[{"a":[{"k":[{"o":[{},[2,1]]}],"n":[{"ó":[{},[0,0,0,0,0,2,1,2]]}]}],"v":[{},[2]]}],"u":[{"t":[{},[0,0,2]]}],"ü":[{"l":[{},[0,0,2]],"z":[{"e":[{},[0,0,0,1]]}]}],"ű":[{"z":[{"ő":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"y":[{"á":[{},[0,0,2]]}]}],"u":[{"b":[{},[0,0,2]],"k":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{"o":[{},[0,0,2]]}]}],"ü":[{"z":[{},[0,0,0,2]]}],"v":[{"a":[{"t":[{},[0,0,2]]}],"u":[{},[2,1,2]]}],"y":[{"é":[{},[0,0,1]],"i":[{"g":[{},[0,0,1]]}],"r":[{"ő":[{},[2]]}]}],"z":[{"a":[{"c":[{"c":[{},[0,0,0,0,0,1]],"s":[{},[0,0,0,0,2,3]]}]}],"m":[{"a":[{},[0,0,0,0,0,1]],"á":[{},[2]]}],"o":[{"n":[{},[2,1,2]]}]}]},[1]],"á":[{"b":[{"a":[{"r":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2,1,2]]}],"i":[{"n":[{"a":[{},[0,0,2,1]]}],"z":[{},[0,0,2,1,2]]}],"o":[{"r":[{"g":[{},[0,0,0,1]],"r":[{},[0,0,0,1]]}]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"r":[{"á":[{},[2]]}],"u":[{"s":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,2]]}],"c":[{"s":[{"é":[{"t":[{},[0,0,2]]},[0,0,0,0,0,2]],"i":[{"l":[{},[0,0,2,0,1]],"p":[{},[0,0,2]]}],"í":[{},[0,0,2]]}]}],"d":[{"a":[{"s":[{},[0,0,0,0,1]],"z":[{},[0,0,2,1]]}],"e":[{"r":[{},[0,0,2,1,2]],"t":[{},[0,0,2]]}],"i":[{"m":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,1]],"t":[{"t":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2,1]],"ü":[{"l":[{},[0,0,2]]}],"z":[{},[0,0,2]]}],"g":[{"a":[{"b":[{},[0,0,2]],"c":[{},[0,0,2]],"d":[{"a":[{},[0,0,0,1,2]]}],"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,1]]},[0,0,2]],"t":[{"l":[{},[0,0,2,1]],"o":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,0,1]]},[0,0,2]],"m":[{},[0,0,2]],"r":[{"a":[{"k":[{},[0,0,2,1,2]]}],"o":[{},[0,0,2,1,2]]}],"t":[{"o":[{},[0,0,2,1,2]]}]}],"é":[{"p":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2]],"g":[{"é":[{},[0,0,2]]}],"m":[{},[0,0,2]]}],"o":[{"t":[{"t":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2,1,2]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]],"y":[{"á":[{},[2]],"o":[{},[2]]}]}],"h":[{"a":[{"s":[{},[0,0,2]]}],"e":[{},[2]]}],"í":[{"r":[{},[0,0,0,2]]}],"l":[{"a":[{"d":[{},[0,0,2]],"k":[{"a":[{},[0,0,2,1]]}],"l":[{},[0,0,2,1]],"n":[{"y":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1]],"u":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,0,1]]}],"t":[{"j":[{},[0,0,2,1]]}]}],"d":[{"á":[{"s":[{},[2]]}],"o":[{"z":[{},[2]]}]}],"e":[{"l":[{},[0,0,2]],"s":[{"t":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1,2]]}],"é":[{"l":[{},[0,0,2]]}],"i":[{"m":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"l":[{"a":[{"m":[{},[2,1]],"t":[{},[2,1]]}],"á":[{"s":[{},[2,1]]}],"k":[{},[2,1]],"o":[{"m":[{},[2,1]]}],"v":[{},[2,1]]}],"m":[{"a":[{"i":[{"m":[{},[2]]}]}],"o":[{"k":[{".":[{},[2]]}],"m":[{},[2]],"s":[{},[2,1]]}],"u":[{"k":[{},[2]],"n":[{"k":[{"b":[{},[2]]}]}]}]}],"o":[{"k":[{"a":[{"i":[{"h":[{},[2]],"n":[{},[2]],"r":[{},[2]]}]}],"á":[{"n":[{},[2]],"t":[{},[2]],"u":[{},[2]]}],"o":[{"n":[{"k":[{},[2]]}]},[0,0,2,1,2]],"u":[{},[2]]}]}],"ó":[{"r":[{"á":[{},[0,0,0,1]]}]}],"ö":[{"v":[{},[0,0,2,1]]},[0,0,0,0,2]],"u":[{"t":[{},[2,1]]}],"ú":[{"t":[{},[0,0,2,1]]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"m":[{"a":[{"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"s":[{"s":[{},[0,0,0,1]]}],"u":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]],"z":[{},[0,0,2,1,2]]}],"b":[{},[0,0,0,1,2]],"e":[{"l":[{"l":[{},[0,0,0,1]]}],"r":[{"ő":[{},[0,0,0,1]]}],"s":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2]],"r":[{"v":[{},[0,0,2,1]]}]}],"i":[{"n":[{"t":[{},[0,0,2,1]]}],"s":[{"t":[{},[0,0,0,1]]}]}],"í":[{},[0,0,2]],"o":[{"r":[{},[0,0,2,1]]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ú":[{"t":[{".":[{},[0,0,2,1]]}]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"n":[{"a":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"c":[{"c":[{},[0,0,0,0,3]],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"g":[{},[0,0,0,2,1]]}],"s":[{"á":[{},[0,0,0,2]]}]}],"e":[{"m":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"é":[{"p":[{},[0,0,2]]}],"g":[{"a":[{"t":[{},[0,0,0,2,1]]}],"á":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1]]}],"i":[{"l":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"k":[{"e":[{"l":[{},[0,0,0,2,1,2]]}],"ó":[{"r":[{"a":[{},[0,0,0,2,1,2]]}]}],"ö":[{"v":[{},[0,0,0,2,1,2]]}]}],"o":[{"k":[{},[0,0,3]],"l":[{},[0,0,2]]}],"s":[{"p":[{},[0,0,0,1]],"z":[{},[0,0,0,1]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ü":[{},[0,0,2]],"y":[{"a":[{"j":[{},[0,0,2]],"l":[{"a":[{},[0,0,2]]}],"m":[{},[0,0,2]],"n":[{},[0,0,0,0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,0,1]],"v":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2]]}],"é":[{"r":[{".":[{},[0,0,2,0,1]]}]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]]}]}],"p":[{"é":[{"t":[{},[0,0,2]]}],"i":[{},[0,0,0,0,2]],"o":[{"l":[{},[2,1,2]]}]}],"r":[{"a":[{"d":[{},[0,0,2]],"i":[{},[2,1,2]],"k":[{"a":[{},[0,0,2]],"b":[{},[0,1,2]],"k":[{},[0,1,2]],"r":[{},[0,1,2]]}],"l":[{},[0,0,2,1,2]],"m":[{},[2,1,2]],"t":[{},[2,1,2]],"v":[{},[0,0,2,1]],"z":[{},[0,1,2]]}],"e":[{"n":[{},[2]],"s":[{},[0,0,2]]}],"k":[{"o":[{"t":[{},[0,1]]}]}],"n":[{"y":[{"a":[{},[2,1]]}]}],"s":[{},[0,0,0,1,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{".":[{},[2]],"g":[{},[0,0,2]],"h":[{},[2,1,2]],"k":[{},[2,1,2]],"l":[{},[2,1,2]],"s":[{},[2]],"t":[{},[2,1]],"v":[{},[2]]}],"ú":[{"a":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"s":[{"a":[{"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2,1,2]],"r":[{"a":[{"i":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]]}],"á":[{},[0,0,2,1,2]],"b":[{},[0,0,2,1]],"é":[{},[0,0,2,1,2]],"h":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"s":[{},[2,1,2]],"t":[{"o":[{},[0,0,2,1,2]]}]}],"e":[{"g":[{"y":[{"e":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]},[0,0,2]],"í":[{"r":[{},[0,0,2]]}],"o":[{"t":[{"t":[{"h":[{},[0,0,0,1]]},[0,0,2]]}]}],"ó":[{".":[{},[2,1,2]],"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ő":[{},[0,0,2]],"s":[{"z":[{"é":[{},[0,0,0,3]]}]}],"u":[{"t":[{},[0,0,2]]}],"ű":[{},[0,0,2]],"z":[{"a":[{"s":[{},[0,0,2]],"v":[{},[0,0,0,3]]}],"e":[{"d":[{},[2]],"g":[{},[0,0,2]],"m":[{},[0,0,2,0,1,2]],"n":[{},[0,0,2]]}],"i":[{"p":[{},[0,0,2]]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"ö":[{"l":[{},[0,0,2]],"v":[{},[0,0,2]]},[0,0,0,0,0,2]],"s":[{},[0,0,0,0,3]],"ü":[{},[0,0,2]]}]}],"t":[{"a":[{"j":[{},[0,0,2]]}],"e":[{"r":[{"e":[{},[0,0,2,1,2]]}]}],"é":[{"t":[{"e":[{"l":[{},[0,0,0,0,2]]}]}]}],"h":[{"e":[{},[2,1]]}],"i":[{"o":[{},[0,0,2,1,2]]}],"í":[{},[2,1,2]],"k":[{"ö":[{},[2]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"r":[{"á":[{},[0,0,1,2]],"i":[{},[0,0,1]]}],"t":[{"e":[{},[2,1]],"ö":[{},[2,1]],"ű":[{},[2,1]]}],"ú":[{"s":[{},[0,1]]}],"v":[{"é":[{},[2,1]],"i":[{},[0,1]]}]}],"v":[{"i":[{"z":[{},[0,0,2]]},[2]],"ó":[{},[2,1,2]],"u":[{},[2]]}],"z":[{"a":[{"d":[{"o":[{"t":[{},[0,0,2,1]]}]}],"l":[{},[0,0,2,1]]}],"á":[{"r":[{"h":[{},[0,0,2,1]],"u":[{"s":[{},[0,0,0,2]]}]}]}],"b":[{},[3]],"e":[{"l":[{},[0,0,2,1]]}],"i":[{"s":[{},[0,0,2,1,2]]}],"o":[{"l":[{"t":[{},[0,0,2,1]]}]},[0,0,0,0,2]],"s":[{"a":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"z":[{},[0,0,0,3]]}]}]},[1]],"b":[{"i":[{"s":[{},[0,2,1]]}],"l":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}]}],"c":[{"a":[{"j":[{"t":[{},[0,0,1]]}],"l":[{"k":[{},[0,0,1]]}],"t":[{"o":[{},[0,2,1,2]]}]}],"á":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]]}],"c":[{"s":[{"i":[{},[0,0,3]],"o":[{},[0,0,3]],"ö":[{},[0,0,3]]}]}],"e":[{"l":[{"e":[{},[0,2,1,2]],"r":[{},[0,0,1]]}],"m":[{"b":[{},[0,2,1]],"e":[{"l":[{},[0,0,1]]}]}],"s":[{"z":[{},[0,0,1]]}],"v":[{},[0,2,1,2]],"z":[{"e":[{},[0,2,1]]},[0,0,0,2]]}],"é":[{"p":[{},[0,2,1]],"v":[{"i":[{},[0,0,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"h":[{"a":[{},[0,0,3]],"á":[{},[0,0,3]],"o":[{},[0,0,3]],"u":[{},[0,0,3]],"ú":[{},[0,0,3]],"ü":[{},[0,0,3]]}],"i":[{"d":[{},[0,2,1,2]],"t":[{"é":[{"r":[{},[0,0,0,2]]}]}]}],"í":[{"v":[{},[0,0,1]]}],"k":[{"r":[{},[0,0,1,2]]}],"l":[{"u":[{},[0,1,2]]}],"o":[{"s":[{"t":[{},[0,2,1]],"z":[{},[0,2,1]]}]}],"ó":[{"r":[{},[0,0,1,2]]}],"ö":[{"k":[{},[0,0,1]],"s":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"a":[{"d":[{},[0,2,0,1,2]],"k":[{"t":[{},[0,2]]}],"l":[{"a":[{"p":[{},[0,0,0,1]]}]}],"n":[{},[0,2,0,1,2]],"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]]}],"r":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{},[0,2,0,1,2]],"z":[{},[0,2]]}],"á":[{"g":[{},[0,0,0,1]],"l":[{},[0,2,0,1]],"t":[{"a":[{},[0,2,0,1,2,1,2]],"á":[{},[0,2]],"h":[{},[0,2,0,1]],"j":[{},[0,2,0,1]],"v":[{},[0,2]]}]}],"e":[{"c":[{},[0,2]],"g":[{},[0,2,0,1,2]],"j":[{},[0,2,3]],"l":[{"f":[{},[0,0,0,1]],"t":[{},[0,2,0,1]],"v":[{},[0,2,0,1]]}],"m":[{"b":[{},[0,0,0,1]],"l":[{},[0,0,0,1]]}],"r":[{"d":[{},[0,2]],"e":[{"l":[{},[0,0,0,0,2,1,2]]}],"ő":[{},[0,0,0,1]]}],"s":[{"e":[{},[0,0,0,1]]}],"t":[{"e":[{},[0,2,0,1]]},[0,0,0,0,2]]}],"é":[{"l":[{},[0,2]],"r":[{"é":[{"s":[{},[0,2,0,1,2]]}],"l":[{"e":[{},[0,2]]}],"t":[{"e":[{},[0,2]],"é":[{},[0,2,0,1]]}],"v":[{"e":[{},[0,0,0,1]],"é":[{},[0,2,0,1]]}]}],"s":[{"z":[{"é":[{"k":[{},[0,0,0,0,2,0,1]]}]}]}],"t":[{"e":[{},[0,2,0,1,2]],"k":[{},[0,2,0,1]]}],"v":[{"é":[{"t":[{},[0,2,0,1,2]]}]}]}],"i":[{"d":[{"é":[{},[0,2]]}],"m":[{"i":[{},[0,2]]}],"n":[{"f":[{},[0,2,0,1]],"g":[{},[0,2,0,1]],"t":[{},[0,2,0,1]]}],"p":[{"a":[{},[0,2,0,1,2]]}],"r":[{"t":[{},[0,2,0,1]]}],"s":[{"k":[{},[0,2,0,1]],"m":[{},[0,2,0,1]]}],"t":[{"a":[{},[0,2]]}]}],"í":[{"z":[{},[0,2,0,1,2]]}],"k":[{},[0,0,0,1,2]],"o":[{"k":[{"m":[{},[0,2,0,1]]}],"r":[{"s":[{},[0,0,0,1]]}]}],"ö":[{"l":[{},[0,2,0,1,2]]}],"ő":[{"s":[{"é":[{},[0,0,0,1,2]]}]}],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,3]]}],"u":[{"g":[{},[0,0,3]]}],"ü":[{"l":[{"t":[{},[0,0,0,1]]}]}],"z":[{"o":[{},[0,0,3]],"ó":[{},[0,0,3]]}]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"j":[{},[0,2,1]]}],"ü":[{"l":[{},[0,0,1]],"t":[{},[0,0,1]]}],"z":[{"á":[{},[0,0,3]],"o":[{},[0,0,3]]}]}],"d":[{"a":[{"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"é":[{},[0,2,1,2]]}],"d":[{"a":[{"t":[{"o":[{},[0,0,1,2]]}]}],"á":[{},[0,2,1,2]]}],"i":[{},[0,0,0,0,2]],"l":[{"a":[{"g":[{},[0,0,0,2]],"j":[{},[0,0,0,2]]}],"e":[{"g":[{},[0,0,0,2,1,2]],"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2,1,2]]}],"i":[{"z":[{},[0,0,0,2]]}],"í":[{},[0,0,0,2,1,2]],"o":[{"s":[{},[0,0,0,2]]}],"t":[{},[0,0,0,0,0,2]]}],"n":[{"t":[{},[0,2,1]],"y":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]]}]}],"p":[{"ó":[{},[0,0,1]]}],"r":[{"a":[{"n":[{},[0,2,1]]}],"c":[{},[0,2,1]],"k":[{},[0,2,1]]}],"t":[{"a":[{"s":[{},[0,0,0,2,1]]}],"e":[{"g":[{},[0,0,0,2,1]]}],"i":[{"n":[{},[0,0,0,2,1]]}],"ó":[{"s":[{},[0,0,0,2]]}]}]}],"á":[{"g":[{},[0,0,1]],"l":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]]}],"r":[{"n":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"b":[{"r":[{},[0,0,1]]}],"e":[{"g":[{"y":[{},[0,0,1]]}],"k":[{"é":[{"k":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"t":[{"ő":[{},[0,2,1,2]]}]}]}],"l":[{"a":[{},[0,2,1,2,1]],"e":[{"m":[{"e":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"n":[{},[0,2,1,2]]}]}],"é":[{"r":[{},[0,2,1]]}],"k":[{},[0,2,1]],"l":[{"á":[{},[0,2,1]]}],"o":[{},[0,2,1]],"ő":[{"h":[{},[0,2,1,2]],"v":[{"e":[{"z":[{},[0,2,1,2]]}]}]}],"s":[{},[0,2,1]],"t":[{"á":[{},[0,2,1]]}],"v":[{"é":[{},[0,2,1]]}]}],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}],"e":[{"l":[{},[0,2,1,2]]}],"l":[{},[0,2,1]]}],"p":[{"e":[{},[0,0,1]]},[0,0,0,1,2]],"r":[{"ő":[{},[0,2,1]]}],"v":[{"é":[{},[0,0,1,2]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"j":[{"é":[{"r":[{},[0,2,1,2]]}]}],"l":[{"m":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"c":[{},[0,2,1]],"é":[{},[0,2,1]],"i":[{},[0,2,1,2]],"t":[{"e":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"s":[{"z":[{},[0,2,1]]}],"v":[{"e":[{"s":[{},[0,0,0,2]]}]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"g":[{"a":[{},[0,2,1,2]],"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"i":[{},[0,2,1]]}],"n":[{"d":[{},[0,0,1]],"t":[{},[0,2,1]]}],"p":[{"a":[{},[0,0,1]]},[0,0,0,2]],"s":[{"z":[{"a":[{},[0,2,1]]}]}]}],"í":[{"n":[{},[0,2,1]],"r":[{},[0,2,1]],"z":[{},[0,2,1]]}],"k":[{"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"o":[{"g":[{"a":[{"s":[{},[0,0,0,2,1]]}]}],"l":[{"a":[{},[0,2,1]],"d":[{},[0,2,1]],"t":[{},[0,2,1]]}],"m":[{"l":[{},[0,0,1]]}],"r":[{"c":[{},[0,0,1]],"g":[{},[0,0,1]]}],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"r":[{"á":[{},[0,2,1,2]],"i":[{},[0,2,1]]}]}],"ö":[{"b":[{},[0,2,1]],"k":[{"l":[{"e":[{},[0,0,1]]}]}],"r":[{"ö":[{"k":[{},[0,2,1]]}]}],"v":[{},[0,2,1]]}],"ő":[{"r":[{"i":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"ó":[{"t":[{},[0,0,2]]}]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"u":[{"d":[{"v":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]]},[0,0,0,2]],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"e":[{},[0,2,1]]}],"r":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"r":[{},[0,2,1]]}],"z":[{"á":[{},[0,0,3]],"ó":[{},[0,0,3]],"u":[{},[0,0,3]]}]}],"e":[{"a":[{"b":[{"á":[{},[0,0,0,2]]}],"d":[{},[0,0,0,2]],"g":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"p":[{},[0,0,0,2]],"r":[{"é":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,0,2]]}],"v":[{},[0,0,0,2]]}],"á":[{"j":[{},[0,0,0,2]],"s":[{},[0,0,0,2]],"z":[{},[0,0,0,2]]}],"b":[{"é":[{"d":[{},[2,1,2]]}],"i":[{"n":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"e":[{"k":[{},[0,0,0,2]]}]}],"s":[{},[0,0,0,2]]}],"c":[{"c":[{},[2]],"e":[{"t":[{},[2,1,2]]}],"s":[{"e":[{"t":[{},[2,1]]}]}]}],"d":[{"d":[{"i":[{},[0,1]]}],"r":[{"e":[{"s":[{},[0,0,1,2]]}],"o":[{},[0,0,1]]}]}],"e":[{"s":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"o":[{"n":[{"a":[{"l":[{},[0,0,0,0,2]]},[0,0,0,0,0,0,2]]}]}],"r":[{},[0,0,1]],"t":[{},[2,1]]}],"g":[{"a":[{"l":[{"a":[{},[0,0,2]]}],"r":[{},[0,0,0,0,2]],"s":[{},[0,0,2,1,2]]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}],"t":[{"o":[{},[0,0,3,2]]}],"z":[{},[0,0,3,2]]}],"e":[{"b":[{},[0,0,3]],"g":[{},[0,0,2,1,2]],"l":[{"e":[{"m":[{".":[{},[0,0,3,2]]}]}],"l":[{},[0,0,0,1]],"ő":[{"a":[{},[0,0,3,2]],"j":[{},[0,0,3,2]],"k":[{"é":[{},[0,0,3,2]]}],"t":[{},[0,0,3,2]],"z":[{"e":[{},[0,0,3]]}]}],"v":[{"e":[{".":[{},[0,0,3,2]]}],"é":[{},[0,0,3,2]]}]}],"n":[{"e":[{},[0,0,2]]}],"r":[{"j":[{},[0,0,3,2]]}],"s":[{".":[{},[0,0,3]],"e":[{"b":[{},[0,0,3]],"k":[{},[0,0,3]],"n":[{".":[{},[0,0,3]]}]}],"n":[{},[0,0,3,2]],"r":[{},[0,0,3]],"t":[{},[0,0,3]],"z":[{},[0,0,2,1,2]]}]}],"é":[{"d":[{},[0,0,0,0,2]],"l":[{},[0,0,0,0,2]],"n":[{},[0,0,3]]}],"g":[{},[0,0,0,0,2]],"i":[{"d":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"m":[{"e":[{"g":[{},[0,0,0,0,0,0,1]]}]}],"o":[{"n":[{},[0,0,3,2]]}],"ó":[{"v":[{},[0,0,2]]}],"ö":[{"n":[{"g":[{},[0,0,3]]}],"s":[{},[0,0,2,1]]}],"p":[{"e":[{"c":[{},[0,0,0,0,0,0,1]]}]}],"v":[{"í":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"y":[{"á":[{},[0,0,0,0,0,2]],"b":[{},[2]],"e":[{"d":[{},[2]],"l":[{"ő":[{"r":[{},[0,0,0,0,1,2]]}]},[0,1,2]],"n":[{"g":[{"e":[{},[0,1,2]]}]}]}],"é":[{"k":[{},[0,1,2]]}],"i":[{},[0,0,3]],"í":[{},[2]],"l":[{},[2,1]],"o":[{},[0,0,3]],"s":[{"é":[{},[0,1]]},[2]],"ú":[{},[0,0,3]],"ű":[{},[0,0,3]],"v":[{},[2,1]]}]}],"i":[{"c":[{},[0,0,2]],"g":[{},[0,0,0,2]],"r":[{"á":[{},[0,0,0,2]]}],"s":[{},[0,0,0,2]]}],"j":[{"t":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2,1]]}]}],"k":[{"a":[{"d":[{},[0,0,2]],"p":[{"u":[{".":[{},[0,0,2,1,2]]}]}]}],"á":[{"l":[{},[0,0,2,1]],"p":[{},[0,0,0,0,2]],"r":[{".":[{},[0,0,2,1]],"a":[{},[0,0,2,1]],"b":[{},[0,0,2,1]]}]}],"e":[{".":[{},[2,1,2]],"g":[{},[0,0,2,1]],"l":[{"s":[{},[0,0,0,1]]}],"m":[{"b":[{},[0,0,0,1]],"e":[{},[0,0,0,1]]}],"r":[{"j":[{},[0,0,0,1]],"ő":[{},[0,0,0,1,2]]}]}],"é":[{"r":[{"t":[{"ő":[{},[0,0,2,1]]}]}],"s":[{".":[{},[2,1,2]]}]}],"i":[{"d":[{},[0,0,2,1]],"j":[{},[0,0,2]],"k":[{},[0,0,2,1]],"s":[{"t":[{},[0,0,0,1]]}],"z":[{},[0,0,2]]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"l":[{"i":[{},[0,0,1]]}],"o":[{"l":[{"t":[{},[0,0,0,1]]}],"r":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ő":[{},[0,0,2,1,2]],"t":[{"r":[{"o":[{},[2]],"ó":[{},[2]]}]}],"ú":[{"t":[{},[0,0,2,1]]}],"ü":[{"d":[{},[0,0,2]]}]}],"l":[{"a":[{"d":[{},[2,1]]}],"d":[{"o":[{},[0,1]]}],"e":[{"k":[{"t":[{},[2,1,2]]}],"m":[{"a":[{},[0,0,0,0,2]],"e":[{"i":[{},[2]],"k":[{},[2,0,2]],"s":[{},[2,1,2]]}],"z":[{},[2]]}],"t":[{"a":[{},[0,0,0,0,2,1,2]],"e":[{"l":[{},[0,0,0,0,2]]}],"o":[{},[0,0,0,0,2]]}]}],"é":[{"g":[{},[2]],"r":[{},[2,1,2,1]],"s":[{"s":[{},[0,0,0,0,0,1]],"z":[{},[0,0,0,0,2,3]]}]}],"g":[{"o":[{},[2,1]]}],"h":[{"a":[{},[2,1]],"á":[{},[2,1]],"e":[{"l":[{},[2,1]]}],"o":[{},[0,1]]}],"i":[{"m":[{},[0,0,2]],"n":[{"g":[{},[0,0,0,1]]}],"z":[{},[0,0,2,1]]}],"j":[{"á":[{},[2,1]]}],"l":[{"á":[{},[2,1]],"é":[{},[2,1]],"ő":[{},[2,1]]}],"m":[{"é":[{"j":[{},[2,1]],"s":[{},[2,1]]}]}],"n":[{"e":[{"v":[{},[2,1]]}],"ö":[{},[2,1]],"y":[{},[2,1]]}],"o":[{"s":[{},[2,1,2]]}],"ö":[{"l":[{},[2,1,2,1,2]]}],"ő":[{"é":[{"l":[{},[2,1,2]]}],"f":[{"o":[{},[2,1,2]]}],"í":[{},[0,0,2]],"s":[{"z":[{"ű":[{},[0,0,2]]}]}]}],"s":[{"o":[{},[0,1]],"ö":[{},[0,1]],"z":[{"á":[{},[2,1]]}]}],"t":[{"a":[{},[2,1]],"á":[{"v":[{},[0,1]]}],"é":[{"r":[{},[2,1]]}],"o":[{},[2,1]],"ö":[{},[0,1]]}],"v":[{".":[{},[2,1]],"á":[{},[2,1]],"é":[{"t":[{},[2,1]]}],"h":[{},[2,1]],"n":[{},[0,1]],"s":[{},[2,1]]}],"z":[{},[2,1]]}],"m":[{"e":[{"l":[{".":[{},[2,1,2]],"d":[{},[2,1,2]],"e":[{"d":[{},[0,1]],"k":[{},[0,1]]}],"é":[{"s":[{},[0,1]]},[2,0,2]],"g":[{},[2,1,2]],"h":[{"e":[{},[0,1]]},[0,0,2]],"i":[{},[2,1,2]],"j":[{},[2,1,2]],"l":[{"e":[{"k":[{},[0,1]]}]}],"n":[{},[2,1,2]],"ő":[{".":[{},[2,1]],"s":[{},[2]]},[0,0,2]],"s":[{},[0,0,2]],"t":[{".":[{},[0,1]],"é":[{},[0,1]],"ü":[{},[0,1]]},[0,0,2]],"ü":[{},[2,1,2]],"v":[{"e":[{},[0,1]]},[0,0,2]]}],"r":[{"k":[{},[0,0,0,1]]}],"s":[{"s":[{"z":[{},[0,0,2,1]]}],"z":[{"t":[{},[0,0,0,1]]}]}],"t":[{"i":[{},[0,0,2,1,2]]}]}],"é":[{"k":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,0,1]]}],"v":[{},[0,0,2,1]]}],"r":[{"d":[{"e":[{},[0,0,0,1]]}]}],"s":[{"s":[{},[2,1,2]]}]}],"i":[{"l":[{"l":[{},[0,0,2,1]]}],"n":[{"d":[{},[0,0,2]],"g":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2,1]]}],"t":[{"a":[{},[0,0,2]],"t":[{},[0,0,2,1]]}]}],"l":[{"e":[{"g":[{"e":[{},[0,1]]}]}]}],"o":[{"k":[{},[0,0,2]],"l":[{},[0,0,2]],"r":[{"g":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ö":[{"l":[{},[0,0,2]]}],"ő":[{},[0,0,2,1,2]],"p":[{},[0,0,0,1,2]],"u":[{"r":[{},[0,0,0,1,2]]}]}],"n":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"c":[{"c":[{},[0,0,0,0,1]],"e":[{"l":[{},[0,0,0,2]],"m":[{"e":[{},[0,0,0,2]]}]}]}],"d":[{},[0,2]],"e":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"t":[{"e":[{"l":[{},[0,0,0,0,2]]}]}]}],"é":[{"k":[{"e":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"l":[{"é":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{"s":[{},[0,0,0,0,0,3]],"z":[{},[0,0,2,1]]}],"v":[{".":[{},[0,0,2,1]]}]}],"g":[{"e":[{"l":[{},[0,0,0,2,1,2]]}]}],"i":[{"d":[{},[0,0,2]],"p":[{},[0,0,2,1]]}],"o":[{"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"ó":[{"v":[{},[0,0,2,1]]}],"ő":[{"r":[{"é":[{},[0,0,0,1]]}]}],"s":[{"p":[{},[0,0,0,1,2]],"t":[{"a":[{},[0,0,0,1]]}]}],"t":[{"r":[{"a":[{},[0,0,0,1]],"e":[{"n":[{},[0,0,0,1,2]]}]}]}],"u":[{"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"ü":[{"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"y":[{"v":[{},[2,1]]}]}],"o":[{"a":[{},[0,0,2]],"c":[{},[0,0,2]],"k":[{},[0,0,0,2]],"l":[{"i":[{},[0,0,2]]}],"m":[{},[0,0,0,2]],"z":[{},[0,0,2]]}],"ó":[{"c":[{},[0,0,0,2]]}],"ö":[{"r":[{},[0,0,0,2]]}],"p":[{"a":[{"j":[{},[0,0,2,1]],"p":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"á":[{"l":[{"l":[{"a":[{},[0,0,0,1]]}]}]}],"e":[{"g":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,0,0,2]]}]}],"é":[{"k":[{},[0,0,2]],"l":[{},[0,0,2]]}],"i":[{"l":[{"l":[{"é":[{},[0,0,0,1]]}]}],"z":[{},[0,0,0,1]]}],"l":[{"o":[{},[0,0,1,2]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"d":[{},[0,0,2,1,2]]}],"p":[{"e":[{"l":[{"v":[{},[0,0,0,2,1]]}]}]}],"r":[{"é":[{"s":[{"e":[{},[0,0,1,2]]}]}],"i":[{},[0,0,1,2]],"o":[{},[0,0,1]],"ó":[{},[0,0,1]]}],"ü":[{"l":[{"ő":[{"h":[{},[0,0,2,1,2]]}]}]}]}],"r":[{"d":[{"ő":[{},[2]]}],"e":[{"d":[{"m":[{},[2]]}],"j":[{"é":[{},[0,0,2]]}]}],"é":[{"k":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,0,1]]}]}],"i":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"ó":[{"z":[{},[2]]}],"ő":[{},[2,1,2]]}],"s":[{"a":[{"l":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]]}],"d":[{"é":[{},[0,1]]}],"e":[{"g":[{"e":[{},[2]]}],"k":[{"é":[{"h":[{},[0,0,2,1,2]]}]}],"m":[{"é":[{},[2,1]]}],"t":[{"b":[{},[0,1,2]],"e":[{"i":[{},[2,1,2]],"l":[{},[0,0,0,0,2]]}],"é":[{},[2,1,2]],"h":[{},[0,1,2]],"i":[{},[0,1,2]],"k":[{},[0,1,2]],"n":[{},[0,1,2]],"o":[{},[0,0,0,0,2,1,2]],"r":[{},[0,1,2]]}]}],"é":[{"s":[{"ű":[{},[0,0,2]]}]}],"k":[{"a":[{},[0,0,1,2]],"i":[{},[0,0,1]],"ü":[{},[2]]}],"l":[{"a":[{},[0,0,1]],"i":[{},[0,0,1,2]]}],"m":[{"a":[{},[0,0,1]],"i":[{},[0,0,1,2]]}],"p":[{},[0,0,1,2,2]],"s":[{"z":[{"a":[{},[0,0,0,3]],"á":[{},[0,0,0,3]]}]}],"t":[{"a":[{"r":[{},[0,0,1,2]]}],"e":[{"m":[{"p":[{},[0,0,1]]}],"n":[{},[2,1]]}],"é":[{"b":[{"e":[{},[0,1]]}]}],"i":[{".":[{},[2]],"l":[{},[0,0,1,2]]}],"j":[{},[2,1]],"o":[{"r":[{},[0,0,0,2,1]]}],"r":[{},[2]],"t":[{},[0,1]]}],"z":[{"k":[{"ö":[{},[2,1]]}],"t":[{"o":[{},[0,0,1]]}]}]}],"t":[{"a":[{"b":[{},[0,0,2,1]],"c":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,1,2]],"l":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1]],"n":[{"a":[{},[0,0,2,1]]}],"p":[{"r":[{},[0,0,0,1]]}]}],"e":[{"k":[{"é":[{"b":[{},[0,0,2,1,2]]}]}],"l":[{"a":[{},[0,0,2,1,2]],"b":[{},[0,0,2,1]],"e":[{"g":[{},[0,0,0,1]]}],"f":[{},[0,0,2,1]],"k":[{},[0,0,0,1]],"ő":[{"a":[{},[0,0,0,1]],"k":[{"é":[{},[0,0,2,1,2]]}]}],"r":[{},[0,0,0,1]]}],"m":[{"e":[{"l":[{},[0,0,0,1]]}],"l":[{},[0,0,2,1]]}],"n":[{"e":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"r":[{"e":[{"d":[{},[0,0,0,1]]}],"é":[{},[0,0,2,1]],"k":[{},[0,0,2,1]]}],"s":[{"t":[{"é":[{},[0,0,2]]}],"z":[{"k":[{},[0,0,0,1]]}]}],"t":[{"é":[{},[2,1,2]],"h":[{},[2,1,2]],"j":[{},[2,1,2]],"v":[{},[2,1,2]]}]}],"é":[{"d":[{},[0,0,2,1]],"j":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,0,1]],"é":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]},[0,0,0,0,2]],"n":[{"e":[{"k":[{"n":[{},[0,0,2,1,2]]}]}]}],"r":[{"b":[{},[0,0,2,1]],"e":[{"n":[{},[0,0,2,1,2]]}],"i":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"t":[{"ő":[{},[0,0,2,1]]}],"ü":[{"l":[{},[0,0,0,1,2]]}]}],"s":[{"z":[{},[0,0,0,0,2]]}],"t":[{"e":[{"r":[{},[0,0,0,1]]}],"é":[{".":[{},[0,0,0,1,2]]}]}],"v":[{"e":[{"d":[{"e":[{},[0,0,0,0,2]]}],"s":[{},[0,0,0,1]]}],"é":[{"b":[{},[0,0,2,1,2]],"i":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1,2]]}]}]}],"i":[{"d":[{},[0,0,2]],"k":[{"r":[{},[0,0,0,1]]}],"l":[{"l":[{},[0,0,0,1]]}],"m":[{},[0,0,2]],"n":[{"g":[{},[0,0,2,1]]}],"s":[{"t":[{},[0,0,2,1]],"z":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"v":[{"á":[{},[0,0,2]]}]}],"o":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1]],"r":[{"a":[{},[0,0,0,1]]}],"x":[{},[0,0,2,1]]}],"ö":[{"v":[{},[0,0,2,1,2]]}],"ő":[{"e":[{"d":[{},[0,0,0,0,0,3]]}],"r":[{"i":[{},[0,0,2,1]]}]}],"r":[{"a":[{"f":[{},[0,0,1]]}]}],"t":[{"e":[{"g":[{},[0,0,0,2]]}]}],"ü":[{"l":[{"é":[{},[0,0,2,1]]},[0,0,0,0,2]],"z":[{"é":[{},[0,0,0,1]]}]}],"y":[{},[2]]}],"u":[{"g":[{},[0,0,0,2]],"k":[{},[0,0,2]],"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"v":[{"e":[{"n":[{"e":[{},[2]],"í":[{},[2]],"ü":[{},[2]]}],"z":[{".":[{},[0,1,2]],"g":[{},[0,1,2]],"h":[{},[0,1,2]],"n":[{},[0,1,2]],"t":[{},[0,1,2]],"ü":[{},[0,0,2]],"v":[{},[0,1,2]]}]}],"é":[{"l":[{"l":[{},[0,0,0,0,0,1]]}]}],"o":[{"l":[{"ú":[{},[0,0,2]]}]}]}],"x":[{"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2,1]],"p":[{},[0,0,2,1,2]]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"ö":[{},[0,0,2]]}],"y":[{"é":[{},[0,0,1]]}],"z":[{"e":[{"r":[{},[0,0,2]]}],"ő":[{"a":[{},[0,0,0,0,0,2]],"e":[{"r":[{},[0,0,0,0,0,2]]}],"é":[{"n":[{},[0,0,0,0,0,2]]}],"s":[{"p":[{},[0,0,0,0,1,2]]}]}],"r":[{},[2,1]]}]},[1]],"é":[{"b":[{"r":[{},[2,1]]}],"c":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"c":[{},[0,0,0,3]],"é":[{"k":[{},[0,0,2,1]]}],"h":[{},[0,0,2,3]],"i":[{"m":[{},[0,0,2]]},[0,0,0,0,2]],"o":[{},[0,0,2]],"s":[{"k":[{},[0,0,0,3]]},[0,0,0,0,2]]}],"d":[{"a":[{"s":[{},[0,0,2,1]]}],"e":[{"l":[{},[0,0,2,1]],"m":[{"b":[{},[0,0,2,1]]}]}],"é":[{"l":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"i":[{"l":[{},[0,0,2]]}],"o":[{"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2,1,2]]}],"e":[{"r":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{"a":[{"l":[{},[0,0,2]]}],"e":[{"c":[{},[0,0,2,1,2]],"d":[{},[2]],"g":[{},[0,0,2,1]],"l":[{"l":[{},[0,0,0,1]],"s":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,0,1]]}],"s":[{},[2,1,2]]}],"h":[{"e":[{"t":[{},[0,1]]}]}],"i":[{"l":[{},[0,0,2]]}],"í":[{},[2]],"ö":[{},[0,0,2,1]],"ő":[{},[2,0,2]],"r":[{"á":[{"f":[{},[0,0,1,2]]}]}],"t":[{"e":[{"m":[{},[0,1]],"t":[{},[0,1]]}],"é":[{"l":[{},[0,1]]}]}],"ú":[{},[0,0,2]],"ü":[{"n":[{},[0,1,2]]},[2]],"y":[{"e":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{},[3]]}],"h":[{"a":[{"s":[{"z":[{},[0,0,0,1]]}]}],"e":[{".":[{},[2,1,2]],"d":[{},[0,0,2]],"m":[{},[0,0,2,1]],"s":[{},[2]],"t":[{},[2]],"z":[{"ő":[{},[2]]}]}],"é":[{},[0,0,2,1]],"o":[{"l":[{},[0,0,2]]}],"s":[{},[2]]}],"j":[{".":[{},[2,1]],"i":[{},[2,1,2]],"j":[{},[2,1]],"s":[{},[2,1]]}],"k":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"g":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"k":[{"a":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,0,2,1,2]]}],"p":[{"o":[{},[0,0,2,1]]},[0,0,0,0,2]],"s":[{},[0,0,2,1]],"t":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{},[0,0,2,1]],"v":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1]],"s":[{"í":[{},[0,0,2]],"z":[{},[0,0,2,1,2]]}],"v":[{"é":[{},[0,0,0,1]]}]}],"é":[{"k":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]},[0,0,0,0,2]],"t":[{"e":[{},[0,0,2,1,2]]}]}],"i":[{"d":[{},[0,0,2]]}],"í":[{"t":[{},[0,0,2]]}],"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"o":[{"r":[{"s":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"z":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"u":[{"r":[{},[0,0,2,1,2]]}],"ü":[{"l":[{"é":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"v":[{"e":[{"g":[{},[0,0,0,0,0,2]]}]}]}],"l":[{"c":[{},[0,1]],"e":[{".":[{},[2,1,2]],"i":[{},[2,1,2]],"s":[{},[2,1,2]]}],"é":[{"b":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"m":[{},[2,1]],"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"r":[{},[2,1]],"ü":[{"k":[{},[0,0,2]]}],"ű":[{},[2,1,2]]}],"m":[{"e":[{"l":[{},[2,1,2]]}]}],"n":[{"a":[{"g":[{},[0,0,2]]}],"á":[{},[0,0,0,0,2]],"e":[{"g":[{},[0,0,2]],"k":[{"b":[{},[0,0,2]],"l":[{},[2]]}],"l":[{},[0,0,2]]}],"k":[{"í":[{},[2]]}],"o":[{},[0,0,2]],"y":[{"ö":[{},[0,0,2]]}]}],"p":[{"a":[{"l":[{},[0,0,2,1,2]]}],"e":[{"l":[{},[0,0,2,1]]}],"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"í":[{},[2,1,2]],"ó":[{},[0,0,2]],"ü":[{"l":[{"é":[{},[0,0,2]]},[2]]}]}],"r":[{"a":[{"d":[{},[0,0,3]],"l":[{},[0,0,2]],"p":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]]}],"á":[{},[0,0,2,1]],"c":[{".":[{},[2,1]],"b":[{},[2,1]]}],"d":[{"e":[{},[2,1]]}],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"s":[{"ő":[{},[0,0,2,1]]}],"z":[{".":[{},[2,1,2]],"v":[{},[2,1,2]]}]}],"é":[{"j":[{},[0,0,2,1,2]],"s":[{},[2,1,2]]}],"i":[{"k":[{},[2,1,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"í":[{},[0,0,2]],"n":[{"i":[{},[2,1]],"ü":[{},[2,1]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]],"ő":[{".":[{},[2,1,2]],"d":[{},[0,0,2]],"e":[{},[2,1,2]],"i":[{},[0,0,2]],"j":[{},[2,1,2]],"k":[{},[2,1,2]],"n":[{},[0,0,2]],"t":[{},[2,1,2]],"v":[{},[2,1,2]]}],"t":[{"e":[{"l":[{"m":[{},[2]]}]}],"é":[{"k":[{},[2,1]]}],"j":[{},[2,1]],"ő":[{".":[{},[2,1]]}]}],"u":[{"t":[{},[0,0,2]]}],"v":[{"e":[{"l":[{},[2]]}],"é":[{"n":[{},[2,1]]}]}],"z":[{"e":[{},[2,1]],"é":[{},[2,1]]}]}],"s":[{"a":[{"j":[{},[0,0,2,1]],"k":[{},[0,0,2]],"l":[{},[0,0,2]],"r":[{},[0,0,2]],"z":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"t":[{"i":[{},[0,0,2,1]]}]}],"é":[{"g":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"i":[{"k":[{"r":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2]],"ő":[{},[0,0,2,1]],"s":[{"z":[{"a":[{},[0,0,0,3]],"e":[{"r":[{},[0,0,0,3]]}]}]}],"ü":[{"l":[{"é":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]]},[0,0,0,0,2]],"t":[{},[0,0,2,1]]}],"z":[{"é":[{"k":[{},[0,0,0,0,1]],"s":[{"t":[{},[2]]}]}],"l":[{},[2,1]],"s":[{"e":[{},[0,0,0,3]]}]}]}],"t":[{"a":[{"g":[{},[0,0,2]],"z":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1]],"l":[{".":[{},[0,0,2]],"e":[{"k":[{"o":[{},[0,0,0,0,2]]},[0,0,2]],"m":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"h":[{"a":[{},[0,0,0,1]]},[0,0,2]],"m":[{},[0,0,2]],"o":[{},[0,0,0,1]],"ő":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"n":[{"e":[{},[0,0,2]]}],"s":[{"é":[{},[0,0,2]]}],"t":[{"h":[{},[2,1,2]],"i":[{},[0,0,2]],"n":[{},[2,1,2]]}],"v":[{},[0,0,2]]}],"é":[{"r":[{".":[{},[0,0,2,1]]}],"t":[{"e":[{},[0,0,2,1,2]]}]}],"i":[{"s":[{},[0,0,2,1]]}],"í":[{"t":[{},[0,0,2]]}],"l":[{},[2]],"o":[{"k":[{},[0,0,2,1,2]]}],"ó":[{"h":[{},[0,0,2]],"l":[{},[0,0,3]],"r":[{},[0,0,2,1,2]]},[3,2]],"ö":[{"r":[{"ö":[{},[0,0,0,1]]}]},[0,0,0,0,2]],"r":[{"á":[{"g":[{},[0,0,0,2]]}]}],"u":[{"n":[{},[0,0,2]]}]}],"v":[{"a":[{"d":[{},[2,1]]}],"b":[{},[2,1]],"e":[{".":[{},[2,1,2]],"d":[{},[2,1,2]],"i":[{},[2]],"k":[{},[2,1,2]],"l":[{"f":[{},[2]],"i":[{},[2]]}],"m":[{},[2,1,2]],"n":[{},[2,1,2]],"t":[{".":[{},[2,1,2]]}]}],"é":[{"b":[{},[2,1,2]],"h":[{},[2,1,2]],"i":[{},[2,1,2]],"n":[{},[2]],"r":[{"t":[{},[0,0,0,1]]}],"t":[{},[2,1,2]],"v":[{},[2,1,2]]}],"f":[{},[2,1]],"h":[{},[2,1]],"i":[{".":[{},[2,1,2]],"g":[{},[2,1,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"ó":[{},[2,1,2]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"ü":[{"k":[{},[0,0,2]],"n":[{},[0,0,2]]},[2]],"ű":[{},[2,1,2]],"v":[{},[2,1]],"z":[{},[2,1]]}]},[1]],"f":[{"a":[{"l":[{"e":[{},[0,0,0,2,1,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"t":[{},[0,0,1]]}]}],"á":[{"t":[{"i":[{},[0,0,0,2,1,2]]}]}],"c":[{"l":[{},[0,0,1]]}],"e":[{"s":[{"e":[{},[0,0,1]]}],"t":[{"i":[{},[0,0,1]]},[0,0,0,2]]}],"é":[{"l":[{"é":[{"v":[{},[0,0,0,2,1,2]]}],"m":[{},[0,2,1]]}],"m":[{"e":[{"k":[{"é":[{},[0,0,0,2,1,2]]}]}]}]}],"i":[{"d":[{"é":[{},[0,0,0,2,1]]}],"n":[{"n":[{},[0,0,0,0,3]],"o":[{"s":[{},[0,0,0,2]]}]}],"r":[{"o":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]]}]}],"k":[{"l":[{},[0,0,1]]}],"l":[{"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2]]}],"o":[{"k":[{"t":[{"a":[{},[0,2,1]]}]}]}],"ó":[{"r":[{},[0,2,1,2]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"i":[{},[0,0,2]],"í":[{},[0,1,2]],"o":[{},[0,1,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"s":[{"p":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"ü":[{"l":[{"ő":[{},[0,0,1]]}]}]}],"g":[{"a":[{"p":[{},[0,0,0,1,2]],"t":[{"ó":[{"i":[{"k":[{"o":[{},[0,0,0,0,0,0,2]]}]}]}]}],"u":[{},[0,0,0,0,2]]}],"á":[{"r":[{"a":[{"s":[{},[0,0,0,0,1]]}]}]}],"é":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"i":[{"a":[{"s":[{},[0,0,0,2]]}]}],"l":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"ö":[{"r":[{"c":[{"s":[{"o":[{},[0,0,0,0,2]]}]}]}]}],"r":[{"a":[{},[0,1,2]],"u":[{},[0,0,2]]}],"y":[{"a":[{"d":[{},[0,2,0,1]],"g":[{},[0,2,0,1]],"j":[{},[0,2]],"l":[{"a":[{},[0,0,0,1]],"j":[{},[0,0,0,1]]}],"n":[{"y":[{},[0,0,0,1]]}],"s":[{},[0,2,0,1,2]],"u":[{},[0,2,0,1]]}],"á":[{"b":[{},[0,2]],"l":[{},[0,2]],"t":[{},[0,2]]}],"e":[{"g":[{},[0,2,0,1,2]],"l":[{"á":[{},[0,2]],"e":[{},[0,2,0,1,2]],"z":[{},[0,2,0,1]]}],"m":[{"b":[{"e":[{},[0,2]]}]}],"r":[{"é":[{},[0,0,0,1]]}],"s":[{"e":[{"m":[{},[0,2,0,1]]}]}],"v":[{},[0,2,0,1,2]]}],"é":[{"l":[{},[0,2]],"r":[{".":[{},[0,0,0,1]]}],"s":[{},[0,2,0,1]]}],"i":[{"d":[{},[0,2]],"k":[{"r":[{},[0,2]]}],"p":[{},[0,2]],"s":[{},[0,2]]}],"o":[{"k":[{},[0,2,0,1]],"l":[{},[0,2,0,1]],"p":[{},[0,2]],"s":[{},[0,2,0,1]]}],"ó":[{"r":[{},[0,2,0,1,2]]}],"ö":[{"r":[{},[0,2,0,1,2]],"s":[{},[0,2,0,1]]}],"u":[{"t":[{},[0,2,0,1,2]]}],"ú":[{"t":[{},[0,2,0,1]]}]}]}],"h":[{"a":[{"i":[{},[0,0,0,0,2]]}],"ó":[{"n":[{"a":[{"l":[{},[0,0,0,0,1]]}]}]}]}],"i":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"c":[{"é":[{},[0,0,0,2]],"i":[{},[0,0,2]],"s":[{},[0,0,2]],"u":[{},[0,0,2]]}],"d":[{},[0,0,2,1,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"g":[{},[0,0,2]],"h":[{},[0,0,2]],"i":[{"d":[{},[0,0,2]]}],"í":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{"é":[{"p":[{},[0,0,2]]}]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]]}],"m":[{"é":[{},[0,0,2]],"o":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2]],"r":[{"a":[{},[0,0,2]],"é":[{},[0,0,2]]}],"s":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]],"z":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{},[0,0,2]],"i":[{},[0,0,2]]},[0,0,0,1]]}],"t":[{},[0,0,2,1,2]],"ü":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"b":[{"e":[{},[0,0,3]]}],"c":[{"s":[{"z":[{},[0,0,0,3]]}],"ü":[{},[0,0,2]],"y":[{},[0,0,1]]}],"d":[{"e":[{"á":[{},[0,0,2]],"g":[{},[2,0,2]]}],"é":[{"n":[{},[0,0,2]],"t":[{},[0,0,2]]}],"i":[{},[2,1,2]],"ő":[{},[2,1,2]]}],"e":[{"c":[{},[0,0,2]],"d":[{},[0,0,0,2]],"n":[{},[2]]}],"é":[{"d":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"v":[{"é":[{},[0,0,0,2]]}]}],"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,2,1,2]]}]}]}],"í":[{},[0,0,2]],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{".":[{},[0,2]],"a":[{"z":[{},[2,1,2]]}],"á":[{"n":[{"n":[{},[0,0,0,0,0,1]]}]}],"e":[{".":[{},[0,0,2]],"b":[{},[2,1,2]],"k":[{},[2,1,2]],"p":[{},[2,1,2]]}],"é":[{"b":[{},[0,0,2]],"h":[{},[0,0,2]],"i":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}]}],"h":[{"a":[{"t":[{},[0,0,2]]}],"l":[{},[2,1]]}],"k":[{"e":[{"r":[{".":[{},[2,1,2]],"b":[{},[2,1,2]]}]}],"k":[{"e":[{"l":[{"l":[{},[0,0,0,2,1]],"v":[{},[0,0,0,2,1]]}],"r":[{},[0,0,0,2,1,2]]}],"é":[{"r":[{"d":[{},[0,0,0,2]]}]}]}],"l":[{},[0,0,1,2]],"o":[{"n":[{"c":[{},[2,1,2]],"f":[{},[2,1,2]],"g":[{},[2,1,2]],"i":[{"g":[{},[2,1,2]]}],"k":[{},[2,1,2]],"l":[{},[2]],"m":[{},[2,1,2]],"p":[{},[2,1,2]],"s":[{},[2,1,2]]}]}],"r":[{"é":[{},[0,0,1]]}]}],"l":[{"l":[{},[2]]}],"m":[{"a":[{".":[{},[2]]}],"á":[{"d":[{},[2]],"k":[{},[0,0,2]],"v":[{},[0,0,2]]}],"b":[{"o":[{},[0,1]]}],"e":[{".":[{},[0,0,2]],"r":[{"á":[{},[0,0,0,0,2]]}]}],"p":[{"o":[{},[2]]},[0,0,0,1,2]],"ű":[{},[0,0,0,0,1]]}],"n":[{"a":[{"k":[{"r":[{},[0,0,2]]}],"l":[{},[0,0,2]],"n":[{"y":[{},[0,0,0,1]]}],"r":[{"á":[{},[0,0,0,1]]}],"s":[{".":[{},[2]]}]}],"c":[{"s":[{"ö":[{},[0,0,0,2,0,1,2]]}]}],"d":[{"u":[{},[2,1]]}],"e":[{".":[{},[0,0,2]],"g":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,0,0,0,2]]}],"g":[{"e":[{"r":[{},[2,1]]}],"r":[{"á":[{"d":[{"i":[{},[0,0,0,0,2]]}]},[0,0,0,1]],"é":[{},[2,1]]}]}],"i":[{"n":[{"g":[{},[0,0,0,1]],"j":[{},[0,0,0,1]]}]}],"k":[{"l":[{},[0,0,0,1]]}],"n":[{"y":[{},[0,0,0,3]]}],"o":[{"r":[{},[0,0,2]]}],"t":[{"e":[{"g":[{},[2,1]]}],"é":[{"z":[{},[2,1]]}]}],"u":[{"s":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1]]}],"ú":[{},[2,1,2]]}],"o":[{"c":[{},[0,0,2]],"l":[{},[0,0,0,2]],"n":[{"i":[{},[0,0,2]]}]}],"ó":[{"k":[{"e":[{},[0,0,2]]}],"r":[{"a":[{"j":[{},[0,0,0,2]]}]}]}],"ő":[{"á":[{},[0,0,2]],"d":[{},[0,0,2]],"e":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{},[0,0,2]],"m":[{},[0,0,2]],"p":[{},[0,0,2]]}],"p":[{"a":[{".":[{},[0,0,2]],"i":[{},[0,0,2]],"j":[{},[0,0,2,1]]}],"á":[{"r":[{},[0,0,2,1,2]],"t":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2]],"l":[{"e":[{},[0,0,0,1]],"v":[{},[0,0,2,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2,1,2]],"r":[{"o":[{},[0,0,1]]}]}],"r":[{"a":[{"m":[{},[2,1,2]],"t":[{},[2,1,2]]}],"á":[{"n":[{},[2,1,2]]}],"h":[{},[2,1]],"i":[{"g":[{},[0,0,2]]}],"o":[{"d":[{},[0,0,2]]}],"r":[{},[2,1]],"t":[{},[2,1]]}],"s":[{"á":[{"l":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2,1]],"s":[{},[0,0,0,0,2]]}],"i":[{"d":[{},[0,0,2]],"s":[{"k":[{},[0,0,0,1]]}]}],"k":[{"o":[{"l":[{},[2,1]]}]}],"m":[{},[0,1]],"p":[{"á":[{},[2,1]]},[0,0,0,1,2]],"t":[{"e":[{"n":[{},[2,1]]}],"r":[{},[2,1]]}],"ü":[{"t":[{},[0,0,2,1,2]],"v":[{},[0,0,0,1,2]]}],"z":[{"l":[{},[2,1]],"t":[{"á":[{"z":[{},[0,0,0,0,2,1,2]]}],"i":[{"r":[{},[0,0,1]]}]}]}]}],"t":[{"a":[{"g":[{},[0,0,2,1,2]],"l":[{".":[{},[2]],"a":[{},[0,0,2]],"k":[{},[0,0,0,1]]}]}],"á":[{"t":[{"a":[{},[0,0,2,1]]}]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"m":[{"b":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"é":[{"r":[{"d":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2]]}]}]}],"i":[{"l":[{},[0,0,2]],"n":[{"t":[{},[0,0,0,1]]}],"o":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]]}],"o":[{"k":[{"t":[{},[0,0,2,1]]}],"l":[{"d":[{},[0,0,2,1]]}]}],"ö":[{"n":[{},[0,0,2]]}],"ő":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"t":[{"a":[{"k":[{},[0,1]],"s":[{},[0,1]],"t":[{},[0,1]]}]}],"u":[{"r":[{"a":[{},[0,0,2,1]]}]}]}],"ú":[{"t":[{},[0,0,0,2]]}],"v":[{"a":[{"d":[{},[2,1,2]]}],"o":[{"t":[{},[0,0,2]]}],"ó":[{},[0,1,2]]}],"x":[{".":[{},[3]]}],"z":[{"é":[{"l":[{},[0,1]],"n":[{},[2,1,2]],"s":[{"í":[{},[2]]}]}],"g":[{"u":[{},[0,1]]}],"m":[{"o":[{},[2,1]]}],"z":[{"í":[{},[2]],"ó":[{},[2,1]]}]}]},[1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"j":[{"a":[{},[0,0,2]],"u":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,0,0,1]]}],"n":[{"s":[{},[2,1]],"y":[{"e":[{"n":[{"c":[{},[0,0,0,0,0,0,0,1]]}]}]},[0,1,2]]}],"r":[{"d":[{},[0,1]],"h":[{},[0,1]],"j":[{},[0,1]],"l":[{},[0,1]],"o":[{"d":[{},[0,0,2]],"g":[{},[0,0,2]],"k":[{},[0,0,2]],"m":[{},[0,0,2]]}],"ó":[{},[2,1,2]],"s":[{},[0,1]],"u":[{},[0,1,2]]}],"t":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"ő":[{"a":[{},[0,0,0,0,0,2]],"p":[{"r":[{},[0,0,0,0,2,3]]}]}]}],"v":[{".":[{},[2]],"a":[{"k":[{},[0,0,0,0,0,2]]},[0,0,0,0,1]]}],"z":[{".":[{},[2,1]],"e":[{},[2,1,2]],"i":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]},[0,2]],"l":[{},[2,1]],"ü":[{},[2,1,2]],"ű":[{},[0,1,2]]}]},[1]],"j":[{"a":[{"d":[{"a":[{},[0,2,1,2]]}]}],"e":[{"l":[{"ő":[{},[0,2,1,2]]}],"r":[{},[0,2,1]],"s":[{"s":[{},[0,0,0,0,1]]}]}],"h":[{"a":[{"r":[{"c":[{},[0,0,0,0,0,0,1]]}]}]}],"i":[{"p":[{},[0,2,1]],"r":[{},[0,2,1]],"z":[{},[0,2,1]]}],"í":[{"r":[{},[0,0,1]]}],"o":[{"r":[{},[0,2,1]],"s":[{},[0,2,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]]}],"ü":[{"z":[{},[0,0,1]]}]}],"k":[{"a":[{"s":[{"l":[{},[0,0,0,1]]}],"t":[{"e":[{"l":[{},[0,0,0,2]]}],"é":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2,1,2]]}]}],"é":[{"p":[{"e":[{"l":[{"l":[{},[0,0,0,2,1]]}]}]}],"s":[{"z":[{"e":[{"l":[{},[0,0,0,2]]}]}]}]}],"i":[{"a":[{"k":[{},[0,0,0,0,2]]}],"á":[{},[0,0,0,0,2]]}],"l":[{"i":[{"n":[{},[0,1,2]]}],"í":[{},[0,0,2]],"u":[{},[0,1,2]]}],"ö":[{"z":[{"ö":[{"n":[{".":[{},[0,0,0,2,1]]}]}]}]}],"r":[{"á":[{},[0,1,2]],"e":[{"á":[{},[0,0,2]]}],"é":[{"m":[{"b":[{},[0,1,2]]}]}],"i":[{},[0,1,2]],"í":[{},[0,1,2]],"o":[{"m":[{},[0,0,2]]}],"ó":[{},[0,1,2]]}],"s":[{"h":[{},[0,0,1]]}],"u":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"v":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"l":[{"a":[{"d":[{"ó":[{"j":[{},[0,0,0,2]]}]}],"f":[{},[0,0,0,1,2]],"g":[{"a":[{"d":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1,2]]}],"á":[{"l":[{},[0,0,0,2]]}],"e":[{"n":[{},[0,0,0,2]]}],"é":[{"p":[{},[0,0,0,2]]}],"g":[{},[0,0,0,0,3]],"o":[{"l":[{},[0,0,0,2]]}]}],"j":[{"a":[{},[0,0,1,2]]}],"k":[{"a":[{"d":[{},[0,0,1]]}],"c":[{},[0,2,1]],"ó":[{"z":[{},[0,0,1,2]]}],"t":[{"i":[{},[0,2,1]]}]}],"l":[{"a":[{"p":[{},[0,2,1,2]]}],"m":[{},[0,2,1]]}],"m":[{"a":[{"d":[{},[0,0,0,2]],"l":[{},[0,0,0,2]]}],"e":[{"m":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2]]}],"o":[{"r":[{},[0,0,0,2]]}]}],"n":[{"a":[{"l":[{},[0,2,1]]}],"y":[{"e":[{"r":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,0,0,1,2]]}]}],"p":[{"a":[{"l":[{},[0,0,0,2]]}]}],"s":[{"z":[{"f":[{},[0,0,1]]}]}],"t":[{"a":[{"l":[{"a":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"n":[{"y":[{},[0,0,0,0,1]]}]}],"á":[{"l":[{},[0,0,0,2,1]],"r":[{".":[{},[0,0,0,2,1]],"a":[{"d":[{},[0,0,0,0,0,0,1,2]]}],"b":[{},[0,0,0,2,1]]}]}],"é":[{"s":[{},[0,0,0,2]]}],"i":[{"n":[{"t":[{},[0,0,0,2]]}]}],"o":[{"l":[{"t":[{},[0,0,0,2,1]]}],"m":[{"o":[{},[0,2]]}],"r":[{"s":[{},[0,0,0,2]]}]}],"ű":[{},[0,0,0,2,1]],"y":[{},[0,2,1]]}],"u":[{"t":[{},[0,2,1]]}]}],"á":[{"g":[{"a":[{},[0,2,1,2]],"b":[{},[0,2,1]],"g":[{},[0,2,1]],"y":[{".":[{},[0,0,1]],"á":[{},[0,0,1]]}]}],"l":[{"l":[{"o":[{},[0,2,1]]}],"m":[{},[0,2,1]]}],"m":[{"a":[{"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1]]}],"e":[{},[0,0,0,2,1,2]],"é":[{"r":[{"t":[{"é":[{},[0,0,0,2,1]]}]}]}],"i":[{"k":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"u":[{"t":[{},[0,0,0,2,1]]}]}],"n":[{"k":[{"e":[{},[0,0,0,0,2,1,2]]}]}],"p":[{},[0,2,1,2]],"r":[{"a":[{"d":[{},[0,0,0,0,1]],"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1,2]]}],"s":[{"i":[{"k":[{"r":[{},[0,0,0,2,1]]}]}],"ü":[{},[0,0,0,2]],"z":[{"a":[{},[0,0,0,2]]}]}],"t":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"d":[{"z":[{},[0,2,1,2]]}],"f":[{"f":[{},[0,0,1]]}],"g":[{"e":[{"r":[{},[0,0,0,2]]}],"g":[{},[0,0,0,0,1]],"y":[{"é":[{},[0,0,0,2]]}]}],"í":[{},[0,0,0,0,2]],"k":[{"é":[{"s":[{},[0,2,1,2]]}]}],"l":[{"a":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2]]}],"l":[{},[0,2,1]],"ő":[{"a":[{},[0,2,1,2]],"d":[{},[0,2,1,2]]}]}],"m":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1]],"e":[{"g":[{},[0,0,0,2,1,2]],"l":[{"é":[{},[0,0,1]],"l":[{},[0,0,0,0,1]]},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2,1]],"r":[{".":[{},[0,0,0,2,1]],"t":[{"é":[{},[0,0,0,2,1]]}]}]}],"o":[{},[0,0,0,2,1,2]],"u":[{},[0,0,0,2]]}],"n":[{"a":[{},[0,0,0,2]],"n":[{},[0,0,0,0,3]],"ő":[{"r":[{},[0,0,0,2,1,2]]}],"s":[{},[0,0,0,0,0,2]]}],"r":[{"i":[{"n":[{},[0,0,0,2,1]]}],"ó":[{},[0,2,1,2]]}],"s":[{"ő":[{"t":[{},[0,2,1,2]]}],"t":[{"r":[{},[0,0,1]]}]}],"t":[{"o":[{"s":[{},[0,0,0,2]]}]}],"v":[{"e":[{"t":[{},[0,2,1,2]]}]}],"x":[{},[0,2,1]]}],"é":[{"h":[{"e":[{"t":[{},[0,0,1,2]]}]}],"j":[{"e":[{"k":[{},[0,2,1,2]]}]}],"k":[{"a":[{"p":[{"s":[{},[0,0,0,2,1]]}]}],"á":[{"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"o":[{"l":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2]],"ú":[{"t":[{},[0,0,0,2,1]]}]}],"l":[{"e":[{"t":[{".":[{},[0,2,1,2]],"b":[{},[0,2,1,2]],"e":[{},[0,2,1,2]],"é":[{"n":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"k":[{},[0,2,1,2]]}]}],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"n":[{"y":[{"a":[{},[0,0,0,3]]}]}],"s":[{"p":[{},[0,0,0,1]]}],"t":[{"e":[{"r":[{},[0,2,1,2]]}],"o":[{},[0,0,0,0,2]]}],"v":[{".":[{},[0,2,1]],"é":[{"n":[{},[0,0,1,2]]}]}]}],"f":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"d":[{"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,2,1,2]],"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"a":[{},[0,2,1,2]],"p":[{},[0,2,1]]}],"n":[{"a":[{".":[{},[0,0,1]]}],"d":[{},[0,2,1]],"g":[{"a":[{},[0,0,1]],"f":[{},[0,2,1]],"m":[{},[0,2,1]],"s":[{},[0,2,1]]}],"i":[{"n":[{},[0,0,0,2]]}],"v":[{},[0,2,1]]}],"p":[{"a":[{},[0,2,1,0,0,2]]},[0,0,0,2]],"r":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]]}],"s":[{"i":[{},[0,2,1]],"k":[{"o":[{},[0,0,1]]}],"m":[{},[0,2]],"t":[{"e":[{},[0,2,1]]}]}],"t":[{"a":[{".":[{},[0,2,1]],"l":[{},[0,2]]},[0,0,0,2]]}],"z":[{"é":[{},[0,2,1]],"m":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]]}],"o":[{},[0,2,1,2]]}]}],"í":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"o":[{"á":[{},[0,2,1]],"b":[{"j":[{},[0,0,1]]}],"f":[{"f":[{},[0,2,1]]}],"l":[{},[0,2,1,2]],"p":[{"e":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"ó":[{"á":[{},[0,0,0,0,2]],"g":[{"r":[{},[0,0,0,1]]}],"ó":[{},[0,0,0,0,2]],"r":[{"á":[{"k":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"i":[{"á":[{},[0,0,0,2]]}]}],"v":[{"o":[{},[0,2]]}]}],"ö":[{"b":[{},[0,2,1]],"l":[{},[0,2,1]],"n":[{"t":[{},[0,0,1]]}],"r":[{},[0,2,1]],"s":[{"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{".":[{},[0,2,1]],"e":[{"i":[{},[0,0,1,2]]}],"ö":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"s":[{"i":[{},[0,2,1,2]]}],"z":[{"e":[{".":[{},[0,2,1,2]]}]}]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"s":[{"i":[{".":[{},[0,0,2]]}],"k":[{},[0,0,1]],"p":[{},[0,0,1]],"s":[{},[0,0,0,3]],"z":[{"t":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"r":[{"é":[{},[0,0,1]],"i":[{},[0,0,1]],"ó":[{},[0,0,1]]}]}],"u":[{"b":[{"o":[{},[0,0,1,2]]}],"g":[{},[0,2,1]],"l":[{"t":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,1]]}],"t":[{},[0,2,1,2]]}],"ú":[{"s":[{},[0,2,1]],"t":[{"o":[{},[0,2,1,2]]}]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}],"v":[{"é":[{"d":[{"e":[{"l":[{},[0,0,0,0,2,1,2]]}]}]}]}],"y":[{"ö":[{},[0,0,0,1]],"w":[{},[0,3]]},[0,2]]}],"m":[{"a":[{"k":[{"a":[{"d":[{},[0,0,0,2]]}],"r":[{"é":[{},[0,0,0,1]]}]}],"n":[{"t":[{},[0,2,1]]}],"t":[{"r":[{"á":[{},[0,0,0,1]]}],"t":[{},[0,2,1]]}]}],"á":[{"l":[{"m":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"n":[{"y":[{"a":[{"n":[{},[0,0,0,2]]}],"ú":[{"t":[{},[0,0,0,2,0,1]]}]}]}],"r":[{"i":[{"s":[{},[0,0,0,2]]}]}],"t":[{"k":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"c":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{"o":[{"n":[{},[0,0,0,3]]}]}],"k":[{"l":[{},[0,0,0,1]]}],"l":[{"b":[{},[0,0,1]],"i":[{},[0,0,1,2]],"m":[{},[0,0,1]],"ő":[{},[0,0,1,2]]}],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}]}],"n":[{"c":[{},[0,2,1]],"g":[{},[0,2,1]]}],"ó":[{},[0,0,0,0,2]],"p":[{"i":[{},[0,0,1]]}],"s":[{"e":[{"t":[{"é":[{},[0,0,1,2]]}]}],"s":[{"z":[{},[0,2,1]]}]}],"t":[{"n":[{},[0,2,1]],"ű":[{},[0,2,1]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1]],"l":[{"v":[{},[0,2,1]]}],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]]}]}]}],"p":[{},[0,2,1]],"r":[{"t":[{"ő":[{},[0,2,1]]}]}],"v":[{"a":[{},[0,2,1]]}]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{"ő":[{},[0,0,1,2]]}],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]},[0,2,1]]},[0,0,0,2]],"n":[{"d":[{},[0,2,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,0,1]],"o":[{},[0,0,1]]}],"s":[{"k":[{},[0,0,1]]}],"z":[{"z":[{},[0,0,1]]}]}],"í":[{"g":[{},[0,0,1]],"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"l":[{"d":[{},[0,0,1]],"v":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"r":[{"s":[{},[0,0,1]]}],"v":[{},[0,2,1]]}],"ó":[{"d":[{"á":[{},[0,2,1]]}],"r":[{"á":[{},[0,0,1,2]]}]}],"ö":[{"k":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"g":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{"ó":[{},[0,0,1]]}]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"g":[{},[0,2,1]],"n":[{"n":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"n":[{"a":[{"k":[{},[0,0,0,0,2]],"p":[{"e":[{},[0,0,0,2,1]]}]}],"á":[{"r":[{"i":[{"s":[{},[0,0,0,2]]}]}]}],"é":[{"v":[{"á":[{},[0,0,0,2,1]]}]}],"i":[{"k":[{"e":[{"r":[{},[0,0,0,2]]}]}],"s":[{},[0,0,0,2,1]]}]}],"o":[{"á":[{"z":[{},[0,0,2]]}],"b":[{"a":[{"r":[{},[0,0,2,1,2]]}],"á":[{"c":[{},[0,0,2,1,2]]},[2]],"e":[{},[2,0,2]],"i":[{"v":[{},[0,0,2,1]]}],"ó":[{},[0,0,2,1,2]],"u":[{},[2]],"y":[{},[0,0,1]]}],"c":[{"h":[{},[0,0,2]],"y":[{},[0,0,1]]}],"é":[{"c":[{},[0,0,2]],"o":[{},[0,0,2]],"p":[{},[0,0,2]],"z":[{},[0,0,2]]}],"g":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"e":[{"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"r":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]],"r":[{"á":[{"f":[{".":[{},[0,0,1,2]],"f":[{},[0,0,1,2]]}]}]}],"ú":[{},[0,0,2,1]],"ü":[{},[0,0,2]]}],"i":[{"r":[{},[0,0,2]]}],"k":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"k":[{},[2,1,2]]}],"á":[{"r":[{"b":[{},[0,0,2]],"o":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"u":[{},[0,0,2,1]]}],"t":[{"j":[{},[0,0,2,1]]}],"u":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"é":[{"k":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2]],"s":[{},[0,0,0,1]],"z":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"k":[{"a":[{"l":[{"a":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2,1]]}],"ó":[{},[0,0,0,2,1,2]],"ö":[{"s":[{},[0,0,0,2]]}],"u":[{"t":[{},[0,0,0,2,1]]}]}],"o":[{"l":[{},[0,0,2,1]],"n":[{"k":[{},[0,0,2]]}],"r":[{},[0,0,2]],"z":[{},[2,1,2]]}],"ü":[{},[0,0,2]]}],"l":[{"a":[{"j":[{},[0,0,2]]}],"d":[{},[2,1]],"i":[{},[2,1,2]],"l":[{"ó":[{},[2,1]]}],"t":[{"á":[{"r":[{},[2,1]]}]}]}],"m":[{"a":[{"d":[{"á":[{},[0,0,0,1]]}],"g":[{"a":[{},[0,0,0,1]]}],"j":[{"t":[{},[0,0,2,1]]}],"k":[{"a":[{},[0,0,0,1]]}],"l":[{"a":[{"p":[{},[0,0,0,1,2]]}],"o":[{},[0,0,0,1,2]]}],"r":[{"á":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,1]]}],"t":[{"t":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"á":[{"c":[{"s":[{},[0,0,0,1]]}],"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"r":[{"é":[{},[0,0,2,1]],"i":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"n":[{},[0,0,2,1]],"o":[{},[0,0,2,1,2]]}]}],"b":[{"a":[{"l":[{"a":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"v":[{},[0,0,0,2]]}]}],"e":[{"d":[{},[0,0,2]],"g":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{"k":[{},[0,0,0,1]],"ő":[{},[0,0,0,1]]}],"s":[{},[0,0,2,1]]}],"é":[{"d":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2]],"n":[{"e":[{},[0,0,0,1,2]]}],"r":[{"i":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1]],"n":[{"k":[{},[0,0,2]],"t":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,0,1]]},[0,0,0,0,2]],"z":[{},[0,0,2]]}],"í":[{},[0,0,2,1,2]],"l":[{"ó":[{},[0,1]]}],"o":[{"k":[{"o":[{"z":[{},[0,0,2,1]]}]}],"l":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,2,1]]}],"t":[{"t":[{},[0,0,0,1]]}]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{"l":[{},[0,0,0,1,2]]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"n":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"g":[{},[0,0,2,1,2]],"j":[{},[0,0,2]],"k":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"u":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"á":[{"z":[{},[0,0,2,1,2]]}],"c":[{"h":[{},[0,0,0,2]],"i":[{"l":[{},[0,0,0,2]]}]}],"d":[{"ó":[{},[0,0,0,2,1,2]]}],"e":[{"l":[{},[0,0,2,1]]}],"i":[{"r":[{},[0,0,2,1]]}],"k":[{},[0,0,0,1,2]],"o":[{"l":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"s":[{},[0,0,0,1,2]],"t":[{"r":[{},[0,0,0,1]]}],"ü":[{},[0,0,2]]}],"o":[{"i":[{},[0,0,2]],"j":[{},[0,0,2]],"r":[{},[0,0,2]]}],"ó":[{"s":[{},[0,0,2]]}],"p":[{"a":[{"p":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,0,1]]}],"e":[{"l":[{},[0,0,0,1,2]]},[0,0,2]],"i":[{"z":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2]],"p":[{"i":[{"n":[{},[0,0,0,2,1]]}]}],"t":[{"i":[{},[2,1]]},[0,0,0,1,2]],"ü":[{},[0,0,2]]}],"r":[{"d":[{"i":[{"n":[{},[0,0,0,2]]}]}],"e":[{"t":[{},[0,0,0,0,2]]}],"g":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2]],"s":[{},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]]}],"s":[{".":[{},[0,2]],"a":[{},[0,2]],"b":[{},[0,2]],"e":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"h":[{"a":[{},[0,0,1,2]]}],"t":[{"l":[{},[2]]}]}],"x":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]]}]},[1]],"ó":[{"a":[{"d":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"c":[{},[0,0,0,3]],"e":[{"m":[{},[0,0,2]]}],"h":[{},[0,0,2]],"s":[{"a":[{"p":[{"á":[{"g":[{},[0,0,0,0,0,2,1,2]]}]}]}]}]}],"d":[{"á":[{"t":[{},[2,1,2]]}],"r":[{"o":[{},[0,0,1]]}]}],"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,2,1,2]]}]}]}],"i":[{"ú":[{"k":[{"é":[{},[0,0,0,0,2]]}]}]}],"l":[{},[0,0,1]]}],"g":[{"g":[{},[0,0,0,1]],"í":[{},[0,0,2]],"r":[{"á":[{},[0,0,1]]}]}],"í":[{"v":[{},[0,0,0,2]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{"é":[{},[0,0,1]]}]}],"n":[{"a":[{"r":[{},[0,0,2]]}],"i":[{".":[{},[2,1,2]]}],"n":[{},[2]],"o":[{},[2]],"r":[{},[2]],"t":[{},[2]]}],"p":[{"á":[{"r":[{"b":[{"a":[{},[0,0,0,0,0,0,0,2]]}]}]}],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"a":[{"c":[{},[0,0,2]],"d":[{"a":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,0,0,1,2]]}],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2]]}],"á":[{"i":[{},[2]],"j":[{},[2]],"m":[{"r":[{},[0,0,2]]}],"r":[{},[2]],"t":[{},[2]]}],"e":[{"m":[{},[0,0,2]],"s":[{},[0,0,2,1,2]]}],"é":[{"r":[{},[0,0,2,1]]}],"i":[{"n":[{"g":[{},[0,0,2,1]]}],"s":[{"m":[{},[0,0,0,1]]}]}],"í":[{},[0,0,2]],"o":[{"l":[{"d":[{},[0,0,0,1]]}]}],"ü":[{},[0,0,2]]}],"s":[{"a":[{"j":[{},[0,0,2,1]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"k":[{"i":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"p":[{"e":[{},[0,0,1]],"o":[{},[0,0,1,2]]}],"r":[{"á":[{},[0,0,1,2]]}],"s":[{},[0,0,0,3]],"t":[{"a":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"z":[{},[0,0,1]]}],"t":[{"r":[{"á":[{},[0,0,1,2]],"e":[{},[0,0,1]],"é":[{},[0,0,1]],"i":[{},[0,0,1]],"o":[{},[0,0,1]]}]}],"v":[{"o":[{"d":[{},[2]]}],"ó":[{},[0,1,2]]}],"z":[{"a":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"e":[{},[0,0,0,0,2,1]]}]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"s":[{},[0,0,2,1]]}],"i":[{"m":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{"k":[{},[0,0,0,1]],"m":[{},[0,0,0,1]]}]}],"o":[{"l":[{"v":[{},[0,0,2]]}]}],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2,1]]}]},[1]],"ö":[{"b":[{"ö":[{},[0,0,2]]}],"c":[{"a":[{},[0,0,2]],"c":[{},[0,0,0,3]],"h":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"d":[{"é":[{},[2,1,2]]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]]}],"l":[{"d":[{"ö":[{},[0,1]]}],"t":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2]],"é":[{"s":[{},[2,1]]}],"h":[{"e":[{},[0,1]]}],"o":[{},[0,0,0,2]],"ö":[{"t":[{},[0,1]],"z":[{},[0,1]]}],"ő":[{},[0,1]]}]}],"m":[{"l":[{},[2,1]],"ö":[{"l":[{},[0,0,2]]}]}],"n":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{"é":[{"k":[{"é":[{"t":[{},[0,0,0,2,1]]}]}]}]}],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"ö":[{"l":[{},[0,0,2]]}],"ü":[{"l":[{"é":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]]}]},[0,0,0,0,2]]}],"r":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"s":[{"s":[{"z":[{"á":[{},[0,0,0,3]],"e":[{},[2]]}]}],"ü":[{},[0,0,2]],"z":[{"e":[{},[0,0,2]],"i":[{"s":[{},[0,0,2]]}]}]}],"t":[{"l":[{},[2,1]],"t":[{"e":[{"r":[{},[0,0,0,2]]}]}],"v":[{},[2,1]]}],"v":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{".":[{},[0,1,2]],"z":[{},[0,1,2]]}],"h":[{},[2,1]],"n":[{},[2,1]],"ö":[{"n":[{},[0,1,2]]}],"r":[{},[2,1]],"ü":[{"k":[{},[0,1,2]]}],"v":[{},[2,1]]}]},[1]],"ő":[{"a":[{"c":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"a":[{"d":[{},[0,0,2]]}],"á":[{},[0,0,2]],"e":[{".":[{},[2]],"i":[{},[2]],"l":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2,1]]}],"i":[{"n":[{},[0,0,2]],"v":[{},[0,0,2,1]]}],"j":[{"e":[{".":[{},[2]]}],"é":[{"t":[{},[2]]}]}],"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"ö":[{"k":[{"e":[{},[2]],"n":[{},[2]],"r":[{},[2]]}],"t":[{".":[{},[2]]}]}],"z":[{"e":[{},[0,0,2,3]]}]}],"e":[{"l":[{},[0,0,0,2]],"s":[{"é":[{},[2]]},[0,0,0,2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"é":[{"p":[{"i":[{"p":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}]}],"y":[{"e":[{"l":[{},[0,1]]}]}]}],"h":[{"ű":[{},[2]]}],"i":[{"t":[{"a":[{},[0,0,0,2]]}]}],"í":[{"t":[{},[2]]}],"k":[{"é":[{"s":[{"e":[{},[2]]}]}],"l":[{},[0,0,1]],"o":[{"r":[{"ú":[{"t":[{},[0,0,0,0,2,1]]}]}]}],"v":[{},[0,0,1]]}],"l":[{"e":[{"g":[{"e":[{},[2]]}]}]}],"n":[{"n":[{},[2]],"y":[{".":[{},[2]],"a":[{"l":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2]]}],"b":[{},[2]],"e":[{".":[{},[2]],"i":[{},[2]],"l":[{"v":[{"i":[{},[0,0,2,0,1]]}]}]}],"é":[{"b":[{},[2]],"n":[{},[2]],"r":[{},[2]],"t":[{},[2]],"v":[{},[2]]}],"h":[{},[2]],"k":[{},[2]],"n":[{},[2]],"ö":[{},[2]],"r":[{},[2]],"t":[{},[2]],"ü":[{},[2]]}]}],"ő":[{"r":[{"s":[{"é":[{"g":[{},[0,0,0,0,2,1,2]]}]}]}]}],"p":[{"á":[{"n":[{},[2]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"e":[{"h":[{},[2]],"j":[{},[2]],"m":[{},[0,0,0,0,3]],"t":[{},[2]]}],"é":[{"b":[{},[2]]}],"i":[{"s":[{},[0,0,2,1]]}],"ü":[{"l":[{},[0,0,2]]}],"z":[{},[2,1]]}],"s":[{"á":[{"l":[{},[0,0,2]]}],"i":[{"n":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1]]}],"ó":[{"r":[{},[0,0,2]],"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"ő":[{},[0,0,2]],"p":[{"i":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1]]}],"s":[{},[0,0,0,3]],"t":[{"a":[{"r":[{},[0,0,0,2]]}],"r":[{},[0,0,1]]}],"y":[{},[0,0,1]],"z":[{"á":[{"r":[{"a":[{},[0,0,0,3]],"r":[{},[0,0,0,3]]}]}],"f":[{},[0,0,1]],"í":[{"t":[{},[0,1,2]]}],"t":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"é":[{"t":[{".":[{},[2]]}]}],"o":[{"l":[{"á":[{},[2]]}]}],"r":[{"e":[{},[0,0,1]]}]}],"u":[{"t":[{},[0,0,0,2]]}],"ü":[{"l":[{},[0,0,0,2]]}],"v":[{"i":[{"g":[{},[2]]}]}],"z":[{"é":[{"t":[{},[2,1,2]]}],"i":[{"é":[{},[2]]}],"l":[{},[2]],"m":[{},[2]],"ü":[{"k":[{},[2,1,2]]}]}]},[1]],"p":[{"a":[{"l":[{"a":[{"g":[{},[0,0,1,2]],"p":[{},[0,2,1,2]]}],"á":[{"t":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"k":[{},[0,2,1]]}],"n":[{"t":[{"o":[{},[0,0,0,0,0,0,1]]}],"y":[{},[0,2,1]]}]}],"á":[{"l":[{"l":[{},[0,2,1]]}],"t":[{"m":[{},[0,2,1]],"s":[{},[0,2,1]]}]}],"c":[{"s":[{"a":[{"p":[{},[0,0,0,0,0,2,1]]}]}]}],"e":[{"g":[{},[0,2,1]],"l":[{"u":[{},[0,0,1,2]]}],"m":[{},[0,2,1,2]],"n":[{"n":[{},[0,0,0,0,1]]}],"r":[{"ő":[{},[0,2,1,2]]}]}],"é":[{"g":[{},[0,2,1]],"l":[{"e":[{},[0,2,1]]},[0,0,0,2]],"r":[{"i":[{},[0,2,1]]},[0,0,0,2]]}],"i":[{"d":[{},[0,2,1,2]],"n":[{"a":[{},[0,2,1,2]]}],"z":[{"m":[{},[0,0,1]],"o":[{},[0,0,1,2]]}]}],"í":[{"v":[{},[0,2,1]]}],"l":[{"á":[{},[0,1,2]]}],"o":[{"l":[{"d":[{},[0,2,1]]}],"n":[{"á":[{},[0,0,0,0,1]]},[0,0,0,2]]}],"p":[{"r":[{},[0,0,1,2]]}],"r":[{"d":[{},[0,1]],"i":[{},[0,1,2]],"o":[{},[0,1,2]],"ó":[{"b":[{},[0,1,2]]}]}],"u":[{"s":[{"z":[{"o":[{},[0,0,1]]}]},[0,0,0,2]]}]}],"r":[{"á":[{"k":[{"e":[{},[0,0,0,2,1]]}]}],"e":[{"i":[{},[0,0,0,0,2]],"p":[{"r":[{"é":[{},[0,0,0,1,2]]}]}],"s":[{"z":[{},[0,0,0,1]]}],"ü":[{},[0,0,0,0,2]]}]}],"s":[{"a":[{"v":[{"a":[{"m":[{},[0,0,0,2,1,2]]}]}]}],"á":[{"g":[{"g":[{},[0,0,0,0,3]]}]}],"e":[{"p":[{"r":[{"i":[{"k":[{},[0,0,1]]}]}]}]}],"h":[{"o":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]]}],"o":[{"r":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"ó":[{"é":[{"r":[{},[0,0,0,0,2]]}]}],"ő":[{"s":[{"z":[{},[0,0,0,1,0,2]]}]}],"p":[{"a":[{},[0,1,2]],"e":[{},[0,1,2]],"é":[{},[0,1,2]],"i":[{},[0,1,2]],"o":[{},[0,1,2]],"ó":[{},[0,1,2]],"r":[{},[0,1,0,2]]}],"r":[{"á":[{},[0,1,2]],"ó":[{},[0,1,2]]}],"t":[{"a":[{},[0,1,2]],"á":[{},[0,0,2]],"e":[{"i":[{},[0,0,0,0,2]]}],"i":[{},[0,1,2]],"í":[{},[0,1,2]],"o":[{},[0,1,2]],"r":[{},[0,1,0,2]],"u":[{},[0,1,2]],"ú":[{},[0,1,2]]}],"z":[{"a":[{"k":[{"é":[{},[0,0,0,0,2]],"ü":[{},[0,0,0,0,2,1]]}]}],"á":[{"r":[{"ú":[{},[0,0,0,0,2]]}]}],"e":[{"g":[{"ű":[{},[0,2,0,1,2]]}]}],"f":[{},[0,1,0,2]],"l":[{},[0,1,0,2]],"p":[{},[0,1,0,2]],"t":[{"á":[{},[0,0,0,2]],"r":[{},[0,1]]},[0,0,0,0,2]],"v":[{},[0,1,0,2]]}]}],"t":[{"a":[{"g":[{"y":[{"á":[{},[0,0,0,2]]}]}],"j":[{"á":[{},[0,0,1]]}],"l":[{"a":[{"p":[{"b":[{},[0,0,0,2]]}]}],"á":[{"s":[{},[0,0,0,2,1,2]],"z":[{},[0,0,0,2,1,2]]}],"e":[{"n":[{},[0,0,0,2]],"v":[{},[0,0,0,2,1]]}],"é":[{},[0,0,0,2,1,2]],"i":[{"z":[{},[0,0,0,2]]}],"l":[{},[0,0,0,0,1]],"ö":[{},[0,0,0,2]]}],"m":[{"p":[{},[0,2,1]]}],"p":[{"r":[{},[0,2,1]]}],"r":[{"á":[{},[0,0,1]],"c":[{},[0,2,1]],"i":[{"á":[{},[0,0,0,2]]}]}],"s":[{"s":[{"z":[{},[0,0,1]]}],"z":[{"t":[{},[0,0,1]]}]}],"u":[{},[0,2,1,2]],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"g":[{".":[{},[0,0,1]],"a":[{},[0,0,1,2]],"b":[{},[0,0,1]],"g":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"l":[{},[0,2,1]]}],"n":[{"a":[{"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}],"r":[{"a":[{"d":[{"a":[{},[0,0,0,2]]}]}],"s":[{"á":[{"g":[{},[0,0,0,0,2,1]]}]}],"u":[{"r":[{},[0,0,1]]}]}],"s":[{"á":[{"g":[{},[0,0,0,2,1,2]]}]}],"t":[{"a":[{"l":[{},[0,0,0,2]]}],"r":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"e":[{"l":[{"l":[{},[0,2,1]],"ö":[{},[0,2,1]]}],"m":[{"u":[{},[0,2,1]]}],"r":[{"a":[{"d":[{},[0,0,0,2]]}],"e":[{"i":[{"k":[{},[0,2,1,2]]}]}],"ő":[{},[0,2,1]],"u":[{},[0,2]]}],"t":[{"a":[{},[0,0,0,2,1,2]],"é":[{"k":[{},[0,0,0,2]]}]}]}],"é":[{"k":[{"n":[{"é":[{},[0,2,1]]}]}],"l":[{"e":[{},[0,0,1]],"m":[{},[0,0,1]]},[0,0,0,2]],"r":[{"c":[{},[0,0,1]],"z":[{},[0,2,1]]}],"s":[{"a":[{},[0,0,0,2]],"é":[{"g":[{},[0,0,0,2,1,2]]}],"s":[{},[0,0,0,0,3]]}],"t":[{"é":[{},[0,0,0,2,1,2]]}],"v":[{"e":[{"s":[{".":[{},[0,0,0,2]]}]}]}]}],"f":[{"l":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,0,1]]}],"g":[{"é":[{},[0,2,1,2]]},[0,0,0,0,2]],"k":[{"l":[{},[0,0,0,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"p":[{},[0,0,1]]}],"n":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"s":[{"i":[{},[0,2,1]],"m":[{},[0,0,1]],"t":[{},[0,2,1]]}],"t":[{"a":[{},[0,2,1,2]]}]}],"í":[{"n":[{},[0,2,1]],"r":[{},[0,2,1,2]],"t":[{},[0,0,1]],"v":[{"e":[{"l":[{},[0,0,0,0,1,2]]}]},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"k":[{"r":[{},[0,0,1]]}],"o":[{"m":[{"l":[{},[0,2,1]]}],"r":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}],"x":[{},[0,2,1,2]]}],"ó":[{"p":[{},[0,0,0,1]],"s":[{"p":[{},[0,0,0,1,2]],"z":[{},[0,0,0,1]]}],"t":[{},[0,0,0,0,2]]}],"ö":[{"l":[{"é":[{},[0,2,1]]},[0,0,0,2]],"n":[{"t":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,1]]}]}],"ő":[{"a":[{},[0,0,0,0,2]],"e":[{"l":[{},[0,0,0,0,2]]}],"r":[{"ö":[{},[0,0,1,2]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"s":[{},[0,0,0,0,1]]}],"á":[{"g":[{},[0,0,2]]}],"é":[{"n":[{},[0,0,2]]}],"i":[{"k":[{},[0,0,2]],"l":[{},[0,0,2]]}],"ó":[{"f":[{},[0,0,2]],"n":[{},[0,1,2]],"p":[{},[0,0,2]]}]}],"s":[{"é":[{"g":[{"e":[{"l":[{},[0,0,0,0,2,1]]}]}]}],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{"v":[{},[0,2,1]]}],"n":[{"a":[{},[0,2,1]],"i":[{},[0,0,0,2,1]]}],"r":[{"a":[{},[0,0,1]]}],"s":[{"z":[{"e":[{},[0,0,0,2]]}]}],"t":[{},[0,2,1,2]]}],"ú":[{"r":[{"i":[{},[0,0,0,2]]}]}],"ü":[{"g":[{},[0,2,1]],"l":[{"é":[{},[0,0,1,2]]}],"s":[{"t":[{},[0,0,1]]}],"v":[{},[0,2,1,2]],"z":[{"e":[{"m":[{},[0,0,1,2]]}]}]}]}],"u":[{"a":[{"g":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]}],"b":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"n":[{},[0,0,0,0,2]],"s":[{},[0,0,2,1]]}],"á":[{"r":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1,2]],"r":[{},[0,0,0,0,2]],"s":[{},[0,0,2]]}],"é":[{"l":[{},[0,0,2]]}],"i":[{"n":[{},[0,0,2,1]]}],"ó":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{},[0,0,2]],"t":[{},[0,0,0,1,2]],"ü":[{},[0,0,2]]}],"d":[{"j":[{},[2]],"v":[{},[2]],"y":[{},[0,0,1]]}],"e":[{"l":[{},[0,0,0,2]],"s":[{"é":[{},[0,0,2]]}]}],"g":[{"a":[{"s":[{"s":[{},[0,0,0,0,0,1]]}],"t":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"o":[{"r":[{},[2,1,2]]}],"r":[{},[2,1]]}],"i":[{"r":[{},[0,0,0,2]]}],"j":[{"j":[{},[2,1]]}],"k":[{"l":[{},[0,0,1]],"o":[{"s":[{},[0,0,2,1]],"v":[{},[0,0,2,1,2]]}]}],"l":[{"i":[{"n":[{"f":[{},[0,0,2,1]]}]}],"í":[{},[0,0,2]],"r":[{},[2]]}],"m":[{"a":[{"d":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"n":[{"n":[{},[0,0,0,0,0,1]]}],"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"i":[{"k":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1]]}],"í":[{},[2]],"p":[{"e":[{"l":[{},[0,0,0,2]]}]}]}],"n":[{"d":[{},[2]],"h":[{},[0,1]],"i":[{},[2,1,2]],"j":[{},[0,1]],"l":[{},[0,1]],"n":[{},[0,1]],"o":[{},[0,1,2]],"ó":[{},[0,1,2]],"v":[{},[0,1]]}],"r":[{"a":[{"k":[{},[0,0,2]],"m":[{},[0,0,2]],"t":[{},[0,0,2]]}],"u":[{},[2,1,2]],"ú":[{},[2,1,2]]}],"s":[{"a":[{"d":[{},[0,0,2]],"k":[{"a":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"l":[{},[0,0,2]],"n":[{},[0,0,2,1,2]]}],"á":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2]]}],"e":[{"r":[{},[0,0,2,1,2]]}],"é":[{"r":[{"t":[{"é":[{},[0,0,2,1]]}]}]}],"i":[{"m":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,2]]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"ó":[{},[0,0,2,1,2]],"ö":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ő":[{},[0,0,2]],"s":[{"z":[{"e":[{},[0,0,0,3]],"i":[{},[0,0,0,3]]}]}],"t":[{},[0,0,0,0,2]]}],"t":[{"á":[{"n":[{"z":[{},[2]]}]}],"c":[{},[2,1]],"h":[{},[0,0,1,2]],"ó":[{"d":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,1]]}]}],"z":[{"s":[{},[0,0,2]]}]},[1]],"ú":[{"d":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{"t":[{},[0,0,2]]}],"z":[{},[0,0,2,3]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,1]],"e":[{},[0,0,2]],"g":[{},[0,0,0,3]],"i":[{},[0,0,2]],"o":[{"l":[{},[0,0,2]]}]}],"j":[{"d":[{},[2,1]],"í":[{},[2,1,2]],"u":[{},[0,0,2]]}],"r":[{"i":[{},[0,0,2]],"u":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"z":[{},[2,1,2]]}],"t":[{"é":[{".":[{},[0,0,2]]}],"v":[{},[2,1]]}],"z":[{"a":[{"n":[{},[0,0,2,1,2]]}]}]},[1]],"ü":[{"c":[{"s":[{},[0,0,2]]}],"d":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"á":[{},[0,0,2]],"d":[{"ö":[{},[0,1]]}],"e":[{"l":[{},[0,0,2]],"m":[{},[0,0,2,1,2]],"p":[{},[0,1]]}],"é":[{"r":[{},[0,0,0,1]],"s":[{},[2,1]]},[0,0,2]],"h":[{"e":[{"t":[{".":[{},[2,1]],"n":[{"e":[{},[2,1]]}],"s":[{},[2,1]]}]}]}],"í":[{},[0,0,2]],"j":[{"e":[{"k":[{},[2,1]]}]}],"n":[{"e":[{"k":[{},[2,1]]}],"é":[{"k":[{},[2,1]]}],"i":[{},[2,1]]}],"ö":[{},[2,1,2]],"ő":[{},[2,1,2]],"s":[{"z":[{".":[{},[2,1]]}]}],"t":[{".":[{},[2,1]],"e":[{".":[{},[0,1]],"k":[{},[2,1]],"m":[{},[2,1]],"s":[{},[2,1]],"t":[{".":[{},[2,1]],"e":[{},[2,1]],"i":[{},[2,1]],"j":[{},[2,1]],"l":[{},[2]],"n":[{},[2,1]],"s":[{},[2]],"t":[{},[2,1]],"ü":[{},[2,1]],"v":[{},[2,1]]}]}],"é":[{"i":[{},[0,1]],"k":[{},[0,1]],"l":[{},[0,1]],"n":[{},[0,1]],"r":[{},[0,1]],"t":[{},[0,1]]},[2]],"n":[{},[0,1]],"ü":[{},[2,1]]}],"ú":[{},[0,0,2]],"ü":[{"n":[{},[2,1]]},[0,0,2]],"v":[{"e":[{".":[{},[2,1]]}]}]}],"n":[{"n":[{},[2,1]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]]}]},[1]],"ű":[{"r":[{"á":[{},[0,0,2]],"b":[{},[2,1]],"i":[{},[2,1,2]],"l":[{},[0,1]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[1]],"v":[{"a":[{"d":[{"a":[{"t":[{},[0,0,0,2]]}],"m":[{},[0,2,1]]}],"j":[{"a":[{"k":[{},[0,0,0,0,1]]}],"e":[{},[0,0,0,2,1]]}],"k":[{"a":[{"d":[{},[0,0,1]]}],"c":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1,2]],"g":[{},[0,2,1]],"k":[{},[0,2,1]]}],"n":[{"t":[{},[0,2,1]],"y":[{},[0,2,1,2]]}],"r":[{"á":[{"s":[{},[0,2,1,2]]}]}],"z":[{},[0,2,1,2]]}],"á":[{"g":[{"y":[{"ó":[{"n":[{},[0,0,0,2,0,1]]}]}]}],"l":[{"l":[{"a":[{"t":[{},[0,2,1]]}],"t":[{},[0,2,1]]}]}],"p":[{},[0,2,1]],"r":[{"a":[{"i":[{"n":[{},[0,0,0,2]]}],"k":[{".":[{},[0,2,1,2]]}],"s":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]}],"n":[{"y":[{},[0,2,1]]}],"o":[{"l":[{},[0,0,0,2]]}],"u":[{"l":[{},[0,2,1,2]]}]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{"i":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,0,1]],"h":[{},[0,0,1]],"k":[{},[0,0,1]]}]}],"b":[{"r":[{},[0,0,1]]}],"e":[{"d":[{"z":[{},[0,2,1,2]]}],"g":[{"y":[{"s":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"k":[{"é":[{"b":[{},[0,0,1,2]]}]}],"l":[{"e":[{"m":[{"e":[{},[0,2,0,2]]}]}],"k":[{},[0,2,1]],"l":[{},[0,2,1]]}],"r":[{"ó":[{},[0,2,1]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{"é":[{"s":[{},[0,2,1,2]]}],"ü":[{"l":[{},[0,0,0,2]]}]}],"l":[{"m":[{},[0,2,1]]}],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]]}]}]}],"p":[{},[0,2,1]],"r":[{"i":[{".":[{},[0,0,0,2]]}],"t":[{"e":[{"l":[{},[0,2]]}],"é":[{},[0,2,1]]}],"ü":[{},[0,2,1,2]],"z":[{"é":[{"s":[{"i":[{},[0,2]]}]}]}]}],"s":[{"z":[{"a":[{},[0,0,0,2]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,2,1,2]],"o":[{},[0,2,1,2]]}],"g":[{"a":[{},[0,2,1]]}],"k":[{"o":[{},[0,0,1]]}],"m":[{},[0,2,1,2]],"n":[{"t":[{"é":[{},[0,0,1]]}]}],"p":[{"a":[{},[0,0,1,2]]}],"r":[{"o":[{},[0,2,1]],"t":[{},[0,2,1]]}],"s":[{"k":[{"o":[{},[0,2,1]]}],"m":[{},[0,2,1]]}],"z":[{"m":[{},[0,2,1]],"o":[{},[0,2,1]]}]}],"í":[{"v":[{"e":[{},[0,2,1,2]]}],"z":[{"e":[{"s":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"k":[{},[0,2,1]],"l":[{"d":[{},[0,2,1]],"v":[{},[0,2,1]]}],"n":[{"t":[{"o":[{},[0,2,1]]}]}],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]]}],"ö":[{"d":[{"é":[{},[0,0,1]]}],"l":[{"é":[{},[0,2,1]],"t":[{},[0,2,1]]},[0,0,0,2]],"n":[{},[0,2,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"u":[{"t":[{},[0,2,1]]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"y":[{"a":[{"d":[{"a":[{"t":[{},[0,0,0,2]]}],"m":[{},[2,0,1]],"ó":[{},[2,0,1,2]]}],"g":[{"y":[{".":[{},[2]],"r":[{},[2]]}]}],"j":[{"t":[{},[2]]}],"k":[{"a":[{"s":[{},[2,0,1,2]]}],"c":[{},[0,0,1]],"n":[{"á":[{},[2,0,1]]}],"ó":[{"s":[{},[2]]}],"t":[{},[2]]}],"l":[{"a":[{"t":[{},[0,0,1,2]]}],"b":[{},[2,0,1]],"k":[{},[2,0,1]],"m":[{},[2,0,1]],"o":[{"m":[{},[0,0,1,2]]}],"t":[{},[0,0,1]]}],"m":[{"a":[{"j":[{},[0,0,0,2]],"r":[{"á":[{},[0,0,0,2]]}]}],"e":[{"l":[{},[0,0,0,2,1]],"m":[{},[0,0,0,2]]}],"é":[{"r":[{"t":[{"é":[{},[0,0,0,2,1]]}]}]}]}],"n":[{"g":[{},[2]],"i":[{},[2]],"y":[{"a":[{"g":[{},[0,0,0,2]]}],"á":[{},[0,0,1,2]]}]}],"p":[{"á":[{"n":[{},[0,0,1,2]]}],"r":[{},[0,0,0,1,2]]}],"r":[{"c":[{},[2,0,1]]}],"s":[{"a":[{"l":[{},[0,0,0,2]]}],"p":[{"e":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1]]}]}],"t":[{"l":[{},[2,0,1]],"r":[{},[0,0,0,1,2]],"y":[{},[2]]}],"z":[{"o":[{},[2]]}]},[1]],"á":[{"b":[{"é":[{},[2]],"r":[{},[2]]}],"g":[{},[2,0,1]],"l":[{"d":[{},[0,0,1]],"l":[{},[0,0,1]]}],"p":[{},[2,0,1]],"r":[{"a":[{"d":[{},[2,0,1,2]],"k":[{},[2,0,1,2]],"m":[{},[2,0,1,2]],"t":[{},[2,0,1,2]]}],"k":[{},[0,0,1]],"n":[{},[2,0,1]],"r":[{},[2,0,1]],"u":[{},[2,0,1,2]]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2]]}],"t":[{"a":[{},[2]],"f":[{},[2]],"h":[{},[2]],"l":[{"á":[{},[2]],"é":[{},[2]]}],"m":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]]}]},[1]],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{"a":[{},[0,0,0,2]],"y":[{"e":[{"z":[{},[0,0,0,0,0,0,0,1]]},[0,0,1,2]]}]}],"j":[{},[0,0,1]],"k":[{"e":[{".":[{},[2]],"k":[{},[2]]}],"é":[{"b":[{},[2,0,1,2]],"r":[{"ő":[{},[2,0,1,2]]}]}]}],"l":[{"e":[{},[0,0,1,2]],"f":[{},[0,0,1]],"h":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"ü":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"m":[{"a":[{},[0,0,0,2,1]],"b":[{"e":[{"r":[{},[2]]}]}],"e":[{"l":[{},[2,0,1,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"l":[{"í":[{},[2]]}]}],"n":[{"g":[{},[2,0,1]]}],"r":[{"k":[{},[0,0,1]],"ő":[{},[0,0,1,2]]}],"s":[{"d":[{},[2,0,1]],"e":[{"m":[{"é":[{},[2,0,1]]}],"t":[{"e":[{},[2,0,1,2]],"é":[{},[2]],"t":[{},[2,0,1,2]]}]}],"é":[{"l":[{},[2]],"s":[{},[2,0,1,2]]}],"t":[{"e":[{},[2,0,1]]}],"z":[{"k":[{},[2]],"m":[{},[2]],"ű":[{},[2]]}]}],"t":[{"e":[{"t":[{},[2]]}]}],"v":[{"ő":[{},[2]]}],"x":[{},[2,0,1]]},[1]],"é":[{"g":[{},[2,0,1]],"h":[{"e":[{".":[{},[2]],"n":[{},[2]],"t":[{},[2]]}]}],"l":[{"e":[{},[0,0,1]],"m":[{},[0,0,1]]},[0,0,0,2]],"n":[{"e":[{"k":[{"e":[{},[2]]}]}]}],"p":[{},[2,0,1]],"r":[{".":[{},[2,0,1]],"c":[{},[2,0,1]],"d":[{},[2,0,1]],"é":[{},[2,0,1,2]],"m":[{},[2,0,1]],"ő":[{".":[{},[2]],"i":[{},[2]],"k":[{},[2]]}],"r":[{},[2,0,1]],"t":[{"e":[{},[2,0,1]],"é":[{},[2,0,1]]}],"ü":[{},[2,0,1,2]],"v":[{},[2,0,1]],"z":[{},[2,0,1]]}],"s":[{"z":[{},[0,0,1]]}],"t":[{"t":[{},[2,0,1]]}],"v":[{".":[{},[2]],"e":[{".":[{},[2]],"i":[{},[2]],"k":[{},[2]],"n":[{},[2]],"t":[{},[2]]}],"é":[{"v":[{},[2]]}],"i":[{},[2]],"r":[{},[2]],"v":[{},[2]]}]},[1]],"f":[{"l":[{},[0,0,1]],"ö":[{"l":[{"t":[{},[0,0,0,1]]}]}]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"b":[{"o":[{},[2]]}],"d":[{"e":[{"á":[{},[2]],"g":[{},[2]],"n":[{},[2]]}],"i":[{},[2]],"o":[{},[2,0,1]],"ő":[{},[2]]}],"é":[{"h":[{},[0,0,0,0,2]]}],"g":[{"a":[{},[2]],"á":[{},[2]],"e":[{},[2,0,1]],"é":[{},[2,0,1]]},[0,0,0,2]],"h":[{"a":[{},[2,0,1]]}],"l":[{"l":[{},[2,0,1]]}],"m":[{"a":[{},[0,0,1]],"á":[{},[2]],"p":[{},[2]]}],"n":[{"d":[{},[2]],"f":[{},[2]],"g":[{},[2,0,1]],"i":[{},[2,0,1]],"t":[{},[2,0,1]],"v":[{},[2]]}],"p":[{},[2,0,1,2]],"r":[{"a":[{"t":[{},[0,0,1,2]]}],"á":[{},[2]],"i":[{},[2]],"o":[{},[2,0,1]],"r":[{},[2]],"t":[{},[2]]}],"s":[{"k":[{},[2,0,1]],"m":[{},[2]],"p":[{},[2]],"t":[{},[2]]}],"t":[{"a":[{},[2,0,1]]}],"v":[{"a":[{"d":[{},[2]]}]}],"z":[{},[2,0,1,2]]},[1]],"í":[{"g":[{},[2,0,1]],"n":[{},[2,0,1]],"r":[{},[2,0,1,2]],"v":[{},[0,0,1]]},[1]],"k":[{"i":[{"z":[{},[0,0,2]]}],"l":[{},[0,0,1]],"r":[{"ó":[{},[0,0,1]]}]}],"n":[{".":[{},[1]]}],"o":[{"b":[{},[2,0,1]],"d":[{"ú":[{},[2]]}],"f":[{},[2,0,1]],"k":[{"a":[{"l":[{},[2]]}],"l":[{},[2,0,1]],"m":[{},[2]],"o":[{"z":[{},[2]]}],"t":[{"a":[{},[2]]}]}],"l":[{"a":[{},[0,0,1]],"d":[{},[0,0,1]],"l":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]],"m":[{"a":[{"s":[{},[0,0,0,2,1]]}]}],"p":[{},[2,0,1]],"r":[{},[2,0,1,2]],"s":[{"z":[{},[2,0,1]]}],"t":[{"t":[{},[2,0,1]]}]},[1]],"ó":[{"d":[{"á":[{},[0,0,1]]}],"s":[{"á":[{},[0,0,0,2,1]]}]},[1]],"ö":[{"b":[{},[2,0,1]],"l":[{},[2,0,1,2]],"r":[{},[2,0,1,2]],"s":[{"s":[{},[0,0,1]]}],"v":[{},[2,0,1]]},[1]],"ő":[{"r":[{},[0,0,1,2]]},[1]],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"á":[{"d":[{"i":[{},[0,0,0,0,0,0,2]]}]}],"e":[{"p":[{},[0,0,0,0,1]]}]}],"s":[{".":[{},[1]],"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,0,2]],"z":[{"á":[{"m":[{"é":[{},[0,0,0,0,0,2,1]]}]}]}]}],"t":[{"a":[{"c":[{},[0,0,2]]}],"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[2,0,1]],"g":[{"r":[{},[2]]}],"h":[{},[2,0,1]],"j":[{},[2,0,1]],"k":[{"á":[{"s":[{},[0,0,0,2]]}]}],"n":[{"i":[{},[2]]}],"r":[{},[2,0,1,2]],"t":[{},[2,0,1,2]]},[1]],"ú":[{"j":[{"s":[{},[2]]}],"r":[{".":[{},[2,0,1]]}],"t":[{"h":[{},[2]],"r":[{},[2]],"t":[{},[2]],"v":[{},[2]]}]},[1]],"ü":[{"d":[{},[2,0,1]],"g":[{},[2,0,1]],"n":[{"n":[{},[2]]}],"r":[{},[2,0,1]],"v":[{},[2,0,1,2]],"z":[{},[2,0,1]]},[1]],"ű":[{"r":[{".":[{},[2,0,1]],"h":[{},[2,0,1]],"l":[{},[2,0,1]]}]},[1]],"w":[{"o":[{},[1]]}],"z":[{"e":[{"t":[{"e":[{"l":[{},[0,0,0,0,2,1]]}]}]}]}]},[0,2]],"z":[{"á":[{"s":[{"s":[{},[0,0,0,0,1]]}]}],"e":[{"t":[{"a":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}]}]}],"é":[{"s":[{"a":[{},[0,0,0,2]]}]}],"ő":[{"a":[{},[0,0,0,0,2]],"e":[{},[0,0,0,0,2]],"s":[{"o":[{"r":[{"r":[{},[0,0,0,2,1]]}]}]}]}],"u":[{"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}]}]}]}],"m":[{".":[{},[2]],"a":[{"a":[{"d":[{},[0,0,0,2]]}],"b":[{"r":[{"a":[{},[0,0,1]]}],"s":[{},[2,1]]}],"c":[{"é":[{"l":[{".":[{},[0,0,2]],"b":[{},[0,0,2]],"t":[{},[0,0,2]]}]}]}],"d":[{"a":[{"g":[{},[2]],"p":[{},[2,1]],"t":[{"b":[{},[0,0,2]],"o":[{},[0,0,2]],"t":[{},[0,0,2]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"é":[{"v":[{},[0,0,2,1,2]]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"z":[{},[0,0,2]]}],"z":[{},[3,2,3]]}],"e":[{"r":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"r":[{"a":[{},[0,0,1,2]],"i":[{},[0,0,1]]}]}],"g":[{"a":[{"c":[{},[0,0,2]],"d":[{"a":[{"t":[{"o":[{},[0,0,2,1,2]]}]}],"á":[{},[0,0,2,1,2]],"ó":[{},[0,0,2,1,2]],"u":[{},[0,0,2,1,2]]}],"l":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,2,0,2]],"r":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{"s":[{},[0,0,0,0,0,1]],"z":[{"a":[{},[0,0,2,1]]}]}],"z":[{"o":[{},[0,0,0,1]]}]}],"á":[{"g":[{},[0,0,2]],"l":[{"l":[{},[0,0,0,1]]}],"r":[{"é":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1]],"r":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,0,0,1]],"o":[{},[0,0,2,1]]}]}],"e":[{"b":[{},[0,0,2]],"l":[{},[0,0,2,1]]}],"g":[{"r":[{},[2,1]]}],"i":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2,1]],"k":[{"i":[{"a":[{"d":[{"ó":[{},[0,0,0,0,0,0,3]]}]}]}]}],"o":[{"r":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"r":[{"a":[{},[0,0,0,1]]}],"v":[{},[0,0,2,1]]}],"u":[{"r":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,2,1,2]],"y":[{".":[{},[2,1]],"b":[{},[2,1]],"u":[{},[2,1,2]]}]}],"h":[{"h":[{},[0,1]]}],"i":[{"l":[{".":[{},[0,0,2]],"t":[{},[0,0,2]]}],"z":[{},[0,0,0,2]]}],"j":[{"t":[{"a":[{},[2,1]],"i":[{},[0,0,0,2]]}]}],"k":[{"a":[{"r":[{"á":[{},[0,0,2]]}]}],"á":[{"c":[{},[0,0,2]]}],"c":[{},[2,1]],"k":[{"e":[{},[0,0,0,2,1,2]],"r":[{},[2]],"u":[{},[2,1]]}],"l":[{"u":[{},[0,0,1]]}],"o":[{"l":[{".":[{},[2,1,2]]}]}],"r":[{"é":[{"m":[{},[0,0,1,2]]}],"i":[{},[0,0,1,2]],"o":[{},[2]]}],"t":[{"i":[{},[0,1]]}],"u":[{"s":[{},[0,0,2]]}]}],"l":[{"a":[{"c":[{"h":[{"á":[{},[0,0,0,0,0,3]]}],"s":[{},[0,0,0,0,2,3]]}],"g":[{"ú":[{},[0,0,0,0,2,1]]},[2]],"k":[{"u":[{},[0,0,2]],"z":[{},[2,1]]}],"n":[{},[2,1,2]],"p":[{"í":[{},[2,1,2]]}],"s":[{"z":[{"t":[{"a":[{},[0,0,0,0,0,0,2,1]]}]}]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"g":[{"o":[{},[0,1]]},[2]],"j":[{},[2,1]],"k":[{},[2,1]],"o":[{"m":[{"e":[{},[0,0,0,0,2,1]]}],"s":[{},[0,0,0,1]]}],"r":[{},[0,1]],"t":[{".":[{},[2,1]],"h":[{},[0,0,0,1]]}],"u":[{},[2,1,2]],"v":[{},[2]]}],"m":[{"p":[{},[2,1]]}],"n":[{"a":[{"l":[{},[2,1,2]],"t":[{},[0,0,2]]}],"á":[{},[2]],"e":[{"g":[{},[0,0,2,1]]}],"g":[{"i":[{},[2,1]]}],"t":[{"o":[{},[2,1]],"r":[{},[2,1]]}],"y":[{"a":[{".":[{},[2,1,2]],"g":[{},[0,0,2]]}],"á":[{},[2,1,2]],"ó":[{},[2,1,2]]}]}],"o":[{"k":[{},[0,0,0,2]]}],"p":[{"a":[{".":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"t":[{},[2,1,2]]}],"l":[{},[0,0,1,2]],"r":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"i":[{},[0,0,1,2]],"o":[{},[0,0,1,2]]}],"s":[{},[2,1]]}],"r":[{"á":[{"n":[{"y":[{},[2,1,2]]}]}],"b":[{},[2,1]],"c":[{".":[{},[2,1]],"c":[{},[2,1]],"h":[{},[2,1]],"k":[{"o":[{},[0,0,0,1]]}],"u":[{},[2,1]],"ú":[{},[2,1]]}],"é":[{"n":[{},[2,1,2]]}],"i":[{"s":[{"i":[{},[0,0,2,1,2]]}]}],"k":[{"a":[{"l":[{},[0,0,0,2,1]]}],"i":[{"n":[{},[0,0,0,2,1]]}],"ó":[{"n":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1,2]]}]}],"m":[{},[2]],"o":[{"k":[{},[0,0,0,0,2,1]],"m":[{"á":[{},[0,0,2]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"ó":[{"k":[{"h":[{},[0,0,0,0,1]],"k":[{},[0,0,0,0,1]],"n":[{},[0,0,0,0,1]],"r":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}],"y":[{},[0,0,1]],"z":[{},[2,1]]}],"s":[{"k":[{"á":[{},[0,0,1,2]]}],"p":[{"e":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,0,1,2]],"e":[{},[0,0,1]],"r":[{},[0,0,1]]},[0,0,0,0,2]],"z":[{"e":[{"g":[{"y":[{},[0,0,0,0,1]]}],"m":[{"e":[{},[0,0,0,0,1,2]]}]}],"é":[{"t":[{},[0,0,2,0,1]],"v":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2]]}],"í":[{"v":[{"e":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}],"ö":[{"s":[{},[0,0,0,0,1]]}]}]}],"t":[{"a":[{"d":[{"a":[{},[0,0,0,1]]}],"l":[{"a":[{"p":[{},[0,0,0,1]]}]}],"n":[{"y":[{"a":[{},[0,0,0,1]]}]}],"z":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2]],"r":[{"a":[{"k":[{"a":[{},[0,0,0,0,2]]}],"s":[{},[0,0,2,1,2]]}],"á":[{"r":[{},[0,0,0,1,2]]}],"n":[{},[0,0,2,1]],"ú":[{},[0,0,2,1,2]]}],"z":[{},[0,0,2,1]]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"i":[{},[0,0,0,1]],"l":[{},[0,0,2,1]],"ő":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"m":[{"e":[{},[0,0,2,1]]}],"s":[{},[0,0,0,0,2]]}],"é":[{"l":[{},[0,0,2]],"r":[{"t":[{"e":[{},[0,0,2,1]]}]}]}],"f":[{"é":[{"l":[{"é":[{},[0,0,0,0,0,0,0,2]]},[0,0,0,0,0,0,1]]},[0,0,0,0,0,2]]}],"i":[{"d":[{},[0,0,2]],"n":[{"d":[{},[0,0,2,1]],"f":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}]}],"ö":[{"r":[{"ö":[{},[0,0,2,1]]}]}],"r":[{"a":[{"n":[{},[0,0,1,2]]}],"á":[{"g":[{},[0,0,0,2]]}]}],"t":[{"i":[{"n":[{},[0,0,0,2]]}]}],"u":[{"t":[{},[0,0,2,1]]}],"y":[{"a":[{},[2,1,2]],"á":[{},[0,0,2]]}]}],"u":[{"k":[{},[2,1,2]],"r":[{"a":[{},[0,0,0,2]],"i":[{},[0,0,2]]}],"s":[{},[0,0,2]],"t":[{"a":[{},[0,0,0,2]],"o":[{},[2,1,2]]}]}],"v":[{"a":[{"t":[{},[2,1,2]]}]}],"z":[{"a":[{"l":[{},[0,0,2,1,2]]}],"á":[{"l":[{},[0,0,2]],"t":[{"l":[{},[0,0,2,1]]}]}],"e":[{"l":[{},[0,0,2]]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"s":[{"ű":[{},[0,0,2,3]]}]}]},[1]],"á":[{"b":[{"é":[{},[2,1,2]],"r":[{},[2,1]]}],"c":[{"s":[{"a":[{"s":[{},[0,0,2,0,1]]}],"e":[{},[0,0,2,0,1,2]],"i":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}],"f":[{"á":[{},[0,0,2]]}],"g":[{".":[{},[2,1]],"a":[{},[2,1,2]],"á":[{},[2,1,2]],"b":[{},[2,1]],"é":[{},[2,1,2]],"g":[{},[2,1]],"i":[{".":[{},[0,0,2]],"g":[{},[2,1,2]]}],"k":[{},[2,1]],"n":[{"a":[{},[0,1]]}],"o":[{},[2]],"ó":[{},[2]],"r":[{},[2,1]],"u":[{"k":[{},[0,0,2]],"n":[{},[0,0,2]]}],"ú":[{},[2,1,2]],"y":[{"a":[{"d":[{"a":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}]},[2,1,2]]}],"h":[{"í":[{},[0,0,2]]}],"j":[{"a":[{"n":[{},[0,0,2]]}],"á":[{"r":[{"t":[{},[0,0,2,1]]}]}],"e":[{},[0,0,2,1,2]],"o":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{"e":[{"n":[{},[0,0,0,0,0,0,2]]}]}],"u":[{"l":[{},[0,0,2,1]]}],"ü":[{},[0,0,2]]}],"k":[{"a":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]},[0,0,0,0,2]],"e":[{},[0,0,2,1,2]],"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"i":[{"l":[{},[0,0,2]]}],"ó":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2,1]]}],"l":[{"a":[{"l":[{},[0,0,2,1,2]],"r":[{},[2,1]]}],"á":[{"l":[{},[0,0,2]]}],"c":[{},[2,1]],"e":[{},[0,0,2,1,2]],"é":[{"r":[{"t":[{},[0,0,0,1]]}]}],"l":[{"a":[{"m":[{},[2,1]],"p":[{},[0,1]],"t":[{},[0,1]]}],"í":[{},[2,1]],"o":[{"m":[{},[0,1]]}]}],"m":[{"a":[{},[2,1]],"o":[{},[2,1]]}],"o":[{"s":[{},[0,0,2]]}]}],"m":[{"a":[{"s":[{},[0,0,2,1]]}],"í":[{},[2,1,2]]}],"n":[{"a":[{"s":[{},[0,0,2,1]],"v":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{"r":[{},[0,0,2]]}],"c":[{"c":[{},[0,0,0,0,1]],"e":[{},[0,0,0,2]],"é":[{"g":[{},[0,0,0,2,1]]}],"i":[{"p":[{},[0,0,0,2]]}],"s":[{"é":[{},[0,0,0,2]]}]}],"e":[{},[0,0,2,1]],"i":[{"n":[{},[0,0,2,1]],"s":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"ö":[{},[0,0,2,1,2]],"ő":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"a":[{"c":[{},[0,0,0,2]],"g":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]}],"á":[{},[0,0,0,0,0,2]],"é":[{"k":[{},[0,0,0,2,1]]}],"ö":[{"l":[{},[0,0,0,2,1]]}]}],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]],"y":[{"a":[{"d":[{},[0,0,2,0,1,2]],"g":[{},[0,0,2,0,1,2]],"j":[{},[0,0,2]],"k":[{"a":[{},[0,0,2,0,1]]}],"l":[{},[0,0,2,0,1,2]],"n":[{"y":[{},[0,0,2]]},[0,0,0,0,0,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2]],"u":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"e":[{},[0,0,2,0,1,2]],"é":[{"r":[{".":[{},[0,0,2,0,1]],"d":[{},[0,0,2]],"z":[{},[0,0,2]]}]}],"í":[{},[0,0,2,0,1,2]],"ó":[{},[0,0,2,0,1,2]],"ö":[{},[0,0,2]]}]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[2,1,2]],"g":[{},[0,0,2,1,2]],"m":[{},[2]],"n":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,1]]},[0,0,2]],"t":[{},[2,1,2]],"u":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"m":[{},[0,0,0,1]]},[0,0,2,0,2]],"é":[{"s":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"p":[{},[0,0,2,1,2]],"s":[{"i":[{},[0,0,2,1,2]],"k":[{},[0,0,0,1]],"t":[{"á":[{},[0,0,0,1]]}]}]}],"í":[{},[0,0,2]],"k":[{"o":[{"k":[{},[2]]}]}],"o":[{"l":[{},[2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"u":[{"g":[{},[0,0,2]],"h":[{},[0,1,2]],"k":[{},[0,0,2]],"r":[{},[0,1]]}],"ü":[{},[0,0,2]]}],"s":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"p":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"á":[{"r":[{"á":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1]]}],"s":[{"á":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]]},[0,0,2]]}],"b":[{"e":[{"j":[{"á":[{},[0,0,0,0,0,0,0,2]]},[0,0,0,0,0,2,1]]}]}],"e":[{},[0,0,2,1,2]],"í":[{"r":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2]]}],"ó":[{},[2,1,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ü":[{},[0,0,2,1,2]],"z":[{"a":[{"v":[{},[0,0,0,3]]}]}]}],"t":[{"a":[{"k":[{},[0,0,0,1,2]]},[2,1,2]],"á":[{},[2,1,2]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"n":[{},[0,0,2]]},[0,0,0,0,2]],"é":[{},[2]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"r":[{},[2,1,2]]}],"í":[{},[2,1,2]],"j":[{},[0,1]],"l":[{"ó":[{},[2,1]]}],"n":[{},[2,1]],"o":[{"l":[{},[0,0,2,1]]}],"ö":[{},[2,1,2,1]],"p":[{},[2,1]],"r":[{"e":[{},[2,1]]}],"s":[{},[2,1]],"t":[{"e":[{},[2,1]]}],"ú":[{},[2,1,2]],"ü":[{},[2,1,2]],"v":[{},[2,1]]}],"z":[{"a":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2]],"i":[{"a":[{},[0,0,0,0,2]],"é":[{},[0,0,0,0,2]],"s":[{},[0,0,2,1,2]]}],"ő":[{},[0,0,2]],"s":[{"a":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,0,0,1]],"z":[{},[0,0,0,3]]}]}]},[1]],"b":[{"a":[{"k":[{"c":[{},[0,0,1]],"k":[{},[0,2,1]],"r":[{},[0,0,0,1,2]],"v":[{},[0,0,1]]}],"l":[{"a":[{"g":[{},[0,2,1,2]]}],"j":[{},[0,2,1]],"k":[{},[0,2,1]]}],"n":[{"a":[{},[0,2,1,2]],"y":[{"a":[{},[0,2,1,2]]}]}],"p":[{},[0,0,0,1]],"v":[{"a":[{"r":[{},[0,0,1,2]]}]}],"z":[{"o":[{},[0,0,1,2]]}]}],"á":[{"g":[{"y":[{},[0,0,1,2]]}],"l":[{"l":[{},[0,2,1]]}],"r":[{"o":[{"n":[{},[0,2,1,2]]}],"r":[{"ó":[{},[0,2,1]]}]}],"s":[{"z":[{"á":[{"v":[{},[0,0,0,2]]}],"n":[{"á":[{},[0,2,1]]}],"o":[{"k":[{"a":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1,2]]}]}]}]}],"t":[{"a":[{},[0,2,1]],"h":[{},[0,2,1]]}]}],"e":[{"á":[{},[0,0,0,0,2]],"c":[{"e":[{},[0,0,1,2]]}],"k":[{},[0,0,0,1,2]],"l":[{"e":[{"d":[{},[0,0,0,2]],"g":[{},[0,0,1,2]]}],"l":[{},[0,2,1]],"r":[{},[0,0,1]],"s":[{"z":[{},[0,0,1]]}]}],"p":[{"e":[{},[0,0,1]]}],"r":[{"a":[{"g":[{},[0,0,0,2,1,2]],"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2]],"e":[{"g":[{},[0,0,0,2]],"s":[{"z":[{"ű":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}],"v":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1,2]]}],"i":[{"m":[{"á":[{},[0,0,0,2]]}],"n":[{"g":[{},[0,0,0,2]]}],"s":[{"z":[{},[0,0,0,2]]}]}],"o":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"t":[{},[0,0,0,0,0,2]],"ú":[{},[0,0,0,2,1]]}]}],"é":[{"g":[{},[0,2,1,2]],"k":[{"e":[{},[0,0,1,2]],"í":[{},[0,2,1]]}],"p":[{},[0,2,1]],"r":[{"e":[{"s":[{"s":[{},[0,0,0,2]]}]}],"t":[{"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,2,1]]}],"k":[{"a":[{"l":[{},[0,0,0,2,1]]}],"e":[{},[0,0,0,2]]}],"l":[{"l":[{"a":[{},[0,2,1]]}]}],"n":[{"a":[{".":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"m":[{},[0,2]]}],"d":[{},[0,0,1]],"f":[{},[0,2,1]],"g":[{".":[{},[0,2,1]]}],"v":[{},[0,0,1]]}],"p":[{"a":[{},[0,2,1]]}],"z":[{"m":[{},[0,2,1]],"o":[{"m":[{},[0,0,1,2]]}],"z":[{},[0,2,1]]}]}],"í":[{"v":[{},[0,2,1]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]]}],"l":[{"ú":[{},[0,1,2]],"y":[{},[0,0,1]]}],"o":[{"b":[{},[0,2,1]],"l":[{"d":[{"a":[{},[0,0,1]]}],"y":[{"a":[{"k":[{},[0,0,0,2]]}]}]}],"n":[{"d":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"m":[{"á":[{},[0,2,1]],"ú":[{},[0,2,1]]}],"o":[{"z":[{},[0,2,1,2]]}]}],"s":[{"z":[{"l":[{},[0,2,1]]}]}]}],"ö":[{"l":[{"e":[{},[0,0,1]]}],"v":[{},[0,2,1]]}],"ő":[{"s":[{"i":[{},[0,0,1,2]],"z":[{},[0,2,1,2]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"á":[{"d":[{"i":[{},[0,0,0,0,0,0,2]]}]}],"e":[{"v":[{},[0,0,2]]}],"o":[{"k":[{},[0,0,2]],"n":[{},[0,0,2]]}]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1,0,2]],"z":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"s":[{"z":[{"e":[{},[0,0,0,2]],"í":[{},[0,0,0,2]]}]}],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1]]}],"v":[{"e":[{"z":[{"é":[{},[0,0,0,0,0,0,2]]}]}]}]}],"c":[{"l":[{"u":[{},[0,0,2]]}],"s":[{"a":[{"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]]}]}]}]}]}],"d":[{"a":[{"b":[{},[0,0,0,1,2]],"g":[{},[0,0,0,1,2]],"p":[{},[0,0,0,1,2]]}],"i":[{"a":[{"l":[{"e":[{},[0,0,0,2]]}],"p":[{},[0,0,0,3]]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"e":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"v":[{},[0,0,2]]}],"b":[{"é":[{"d":[{},[0,0,2]]}]}],"d":[{"e":[{"r":[{"e":[{},[0,0,0,0,2,1,2]]}]}],"é":[{"n":[{"y":[{},[2]]}]}],"r":[{"á":[{},[0,0,1,2]]}],"z":[{},[2,1,2]]}],"e":[{"s":[{},[0,0,0,2]],"t":[{},[0,0,2]]}],"f":[{"f":[{},[2,1]]}],"g":[{"a":[{"b":[{"a":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2,1]],"u":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,0,0,1,0,2]]}],"v":[{},[0,0,2]]}],"á":[{"m":[{},[0,0,3]],"s":[{},[0,0,0,0,2]],"t":[{},[0,0,0,0,2]],"z":[{},[0,0,0,0,2]]},[0,0,2,1]],"e":[{"g":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,0,0,2]],"ő":[{},[0,0,0,0,2]]},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{"e":[{"m":[{},[0,0,2,1]]}],"z":[{"t":[{},[0,0,0,1]]}]}],"t":[{"a":[{},[0,0,2]],"e":[{},[0,0,2,1,2]]}],"z":[{},[0,0,2]]}],"é":[{"l":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,0,3]],"z":[{},[0,0,0,0,0,0,1]]}]}],"f":[{},[0,0,0,1]],"g":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"i":[{"g":[{"á":[{},[0,0,0,1]]}],"n":[{"n":[{},[0,0,0,1]]}],"r":[{},[0,0,0,1]],"s":[{},[0,0,0,1]],"t":[{"t":[{},[0,0,0,1]]}]},[0,0,2]],"í":[{},[0,0,2,1]],"o":[{},[0,0,2,1]],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1,2]],"ő":[{"r":[{},[0,0,2]]}],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]],"ü":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]]}],"y":[{"e":[{"z":[{},[2]]}],"h":[{},[2,1]],"l":[{},[2,1]],"s":[{},[2,1]],"ü":[{"t":[{},[2]]}]}]}],"h":[{"e":[{"t":[{"ő":[{},[0,0,2]]}]}]}],"i":[{"r":[{"á":[{},[0,0,0,2]]}]}],"k":[{"a":[{"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"l":[{"k":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1]],"r":[{"c":[{},[0,0,0,1]]}],"s":[{},[0,0,2,1,2]],"t":[{"t":[{},[0,0,2,1]]}]}],"á":[{"l":[{},[0,0,2,1,2]],"p":[{},[0,0,2,1,2]],"r":[{".":[{},[0,0,2,1]],"a":[{},[0,0,2,1]]}],"t":[{},[0,0,2]]}],"e":[{"g":[{"y":[{},[0,0,0,1]]}],"l":[{"l":[{},[0,0,0,1]]}],"p":[{},[0,0,2]],"r":[{"s":[{},[0,0,2,1]]}],"s":[{"z":[{"e":[{},[0,0,2,1]],"m":[{},[0,0,2]],"t":[{"e":[{},[0,0,0,1]]}]},[0,0,0,0,2]]}],"v":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2,1]],"l":[{},[0,0,2]],"r":[{".":[{},[0,0,2,1]],"d":[{"e":[{},[0,0,0,1]]}],"k":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2,1]],"é":[{},[0,0,2,1]]}]}],"s":[{"s":[{},[0,0,2,1]]}],"t":[{"e":[{},[0,0,2,1]]}]}],"i":[{"d":[{"o":[{},[0,0,2]]}],"j":[{},[0,0,2]],"m":[{"á":[{},[0,0,0,1]]}],"n":[{"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"p":[{},[0,0,2,1,2]],"s":[{"t":[{},[0,0,2,1]]}],"t":[{"a":[{},[0,0,2,1]]}]}],"í":[{"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"k":[{},[0,0,0,1,2]],"l":[{"u":[{},[0,0,0,3]]}],"o":[{"b":[{},[0,0,2]],"k":[{},[0,0,2,1]],"l":[{"d":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"n":[{"k":[{},[0,0,2,1]]}],"p":[{},[0,0,2]],"r":[{"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{},[0,0,2,1]],"t":[{"t":[{},[0,0,0,1]]}]}],"ó":[{"v":[{},[0,0,2,1,2]]}],"ö":[{"l":[{"t":[{"ö":[{},[0,0,0,1]]}]}],"n":[{},[0,0,2]],"r":[{"ö":[{"m":[{},[0,0,0,1]]}]}],"t":[{},[0,0,2,1]]}],"ő":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,0,0,0,2]]},[0,0,0,1]],"t":[{},[0,0,0,1,2]],"u":[{"j":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"ú":[{},[0,0,2,1,2]],"ü":[{"d":[{},[0,0,2]],"g":[{},[0,0,2,1]],"l":[{"d":[{},[0,0,2,1]],"é":[{},[0,0,2,1,2]],"ő":[{},[0,0,2,1,2]]}],"z":[{},[0,0,2]]}]}],"l":[{"a":[{"d":[{},[0,1]],"k":[{},[0,0,0,1]]}],"á":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]]}],"b":[{},[2]],"e":[{"f":[{},[2,1,2]],"k":[{"t":[{},[0,0,2]]}],"l":[{},[0,0,0,1,2]],"m":[{"e":[{},[2,1,2]],"z":[{},[2,1,2]]}],"s":[{},[2,1,2]],"t":[{"é":[{"r":[{".":[{},[0,0,0,0,2,1]]}]}]},[2]]}],"é":[{"g":[{},[2,1,2]],"l":[{},[2,1,2,1,2]],"r":[{},[2,1,2,1]],"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"f":[{},[2,1]],"g":[{"o":[{},[2,1]]}],"h":[{"a":[{},[0,1]],"á":[{},[2,1]],"e":[{"l":[{},[2,1]]}]}],"i":[{"t":[{".":[{},[0,0,2]]}]}],"í":[{},[2,0,2,1,2]],"j":[{"á":[{},[2,1]]}],"k":[{"é":[{},[0,1]],"í":[{},[0,1]],"ö":[{},[0,1]]},[2]],"l":[{"á":[{"l":[{},[0,0,0,2]]}],"e":[{"n":[{"e":[{},[0,1]]}],"r":[{},[0,0,0,2]]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"i":[{"n":[{"g":[{},[0,0,0,2]]}],"z":[{},[0,0,0,2,1]]}],"o":[{},[0,0,0,2]],"ö":[{},[0,0,0,2]],"u":[{},[0,0,0,2,1,2]]}],"m":[{"é":[{},[2,1]]}],"n":[{"ö":[{},[2,1]]}],"o":[{"s":[{},[0,0,2]]}],"ő":[{"d":[{"e":[{},[0,1]]}],"í":[{},[2,1,2]],"l":[{"e":[{},[0,1,2]]}],"t":[{"t":[{},[0,1,2]]}],"z":[{"ő":[{},[0,0,2]]},[2]]}],"r":[{},[2,1]],"s":[{"z":[{"á":[{},[2,1]]}]}],"t":[{"a":[{},[2,1]],"á":[{},[2,1]],"e":[{"r":[{},[0,1]],"t":[{"t":[{".":[{},[2,1]],"n":[{},[2,1]]}]}]}],"é":[{"r":[{},[2,1]]}],"i":[{},[2,1]],"y":[{},[2]]}],"v":[{".":[{},[2,1]],"á":[{},[2,1]],"e":[{"s":[{},[2,1]]}],"n":[{},[2,1]],"o":[{},[2,1]]}],"y":[{"é":[{"k":[{},[0,0,2,0,1]]}]}],"z":[{},[2,1]]}],"m":[{"l":[{},[2,1]],"u":[{"l":[{},[2,1,2]]}]}],"n":[{"a":[{"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"r":[{},[0,0,2]],"u":[{},[0,0,2]]}],"á":[{"t":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"t":[{"á":[{},[0,0,0,0,2,1,2]],"ö":[{},[0,0,0,0,2]]}]}],"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"g":[{"e":[{"s":[{},[2,1]]}]}],"i":[{"l":[{},[0,0,2]],"p":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"ö":[{},[0,0,2]],"s":[{"é":[{"g":[{},[0,0,0,2,1,2]]}]}],"t":[{"e":[{"l":[{"l":[{},[0,0,0,2,1]]}]}],"i":[{"p":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]]}]}],"u":[{},[0,0,2,1]],"ú":[{},[0,0,2]],"y":[{"a":[{},[0,0,2]],"e":[{"m":[{"a":[{},[0,0,0,0,0,2]]}]}]}]}],"o":[{"m":[{},[0,0,2]]}],"ó":[{"e":[{},[0,0,2]]}],"p":[{"h":[{},[0,0,1,2]],"i":[{"k":[{},[0,0,2]]}],"o":[{"s":[{},[0,0,2]]}],"r":[{},[0,0,1,2]]}],"r":[{"a":[{"p":[{},[0,0,0,0,1,2]],"s":[{"s":[{},[0,0,0,1]]}]}],"d":[{"ő":[{},[2]]}],"e":[{"c":[{},[2,1,2]],"d":[{"m":[{},[2]]}],"g":[{"y":[{},[0,0,0,1]]}],"j":[{},[2,1,2]],"l":[{},[0,0,2,1,2]],"m":[{"l":[{},[0,0,2,1]]}],"t":[{"a":[{},[0,0,0,0,2,1]],"e":[{"l":[{},[0,0,0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,0,0,2,1]]}]}]}],"z":[{"ő":[{"k":[{"h":[{},[2]]}]}]}]}],"é":[{"p":[{},[0,0,2,1]]}],"i":[{"l":[{},[0,0,2,1]],"m":[{},[0,0,2]],"n":[{"f":[{},[0,0,0,1]],"g":[{},[0,0,0,1]]}],"p":[{},[0,0,2,1]]}],"n":[{"y":[{"ő":[{},[2]]}]}],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]],"v":[{},[0,0,2]]}],"ő":[{"l":[{},[2]],"s":[{"í":[{},[2]]}]}],"s":[{"t":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"r":[{"ó":[{},[0,0,0,1]]}]}],"ü":[{"g":[{},[0,0,2,1,2]]}]}],"s":[{"a":[{"s":[{},[0,0,2]]}],"e":[{"m":[{"b":[{},[0,0,2,1]],"é":[{"n":[{},[2,1]]}]}],"s":[{},[0,0,0,0,1]],"t":[{"é":[{},[2]],"t":[{},[2,1,2]]}]}],"é":[{"l":[{"y":[{},[2]]}],"s":[{"é":[{},[2,1,2]],"h":[{},[2,1,2]],"k":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]]}]}],"ő":[{},[2,1,2]],"p":[{"o":[{},[0,0,1,2]]}],"t":[{"b":[{},[2,1]],"e":[{".":[{},[2,1]],"k":[{},[2,1]]}],"é":[{},[2,1]],"f":[{},[2,1]],"ó":[{},[0,0,1,2]],"r":[{},[2,1]],"ü":[{"n":[{},[2,1]]}]}],"z":[{"a":[{"n":[{},[0,0,2]]}],"e":[{"m":[{},[2]]}],"t":[{"á":[{},[0,0,1,0,2]]}]}]}],"t":[{"a":[{"n":[{"y":[{"a":[{},[0,0,0,1]]}]}],"s":[{"z":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,1]]}],"e":[{"g":[{"y":[{},[0,0,2,1,2]]}],"l":[{"l":[{},[0,0,0,1]]}],"t":[{"é":[{},[2,1,2]]}]}],"i":[{"n":[{"g":[{},[0,0,0,1]]}]}],"ó":[{"r":[{},[0,0,2]]}],"ú":[{},[0,0,2]],"ű":[{"d":[{},[0,0,2]]}]}],"u":[{"g":[{},[2,1,2]],"k":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{},[0,0,0,2]]}],"v":[{"ő":[{},[0,0,2]]}],"z":[{"a":[{"c":[{},[0,0,2]],"j":[{},[0,0,2,1]],"k":[{},[0,0,0,0,2]],"u":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"d":[{"é":[{},[0,0,2]]}],"g":[{},[0,0,2]],"l":[{"j":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"ő":[{"h":[{},[0,0,2]]}]}],"r":[{"e":[{},[0,0,0,1]]},[0,0,2]]}],"é":[{"k":[{},[0,0,2,1]],"r":[{".":[{},[0,0,2,1]],"d":[{},[0,0,2,1]],"e":[{"t":[{},[0,0,0,1]]}],"i":[{},[0,0,2,1,2]]}]}],"i":[{"d":[{},[0,0,2,1]],"m":[{},[0,0,2]],"n":[{},[0,0,2]],"o":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"ö":[{},[0,0,2,1]],"ő":[{"e":[{},[0,0,0,0,0,2]],"r":[{"ö":[{},[0,0,2,1,2]]}],"s":[{"s":[{},[0,0,2,1]]}]}],"r":[{"e":[{"m":[{},[2]],"s":[{"e":[{},[0,1]],"r":[{},[0,1]],"t":[{},[0,1]]}]}]}],"s":[{"a":[{},[0,0,2,3]],"á":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}]},[1]],"é":[{"b":[{"e":[{"r":[{},[0,0,2]]}],"r":[{},[2,1]]}],"c":[{"s":[{"a":[{},[0,0,2,0,1,2]],"o":[{},[0,0,2]]}]}],"g":[{"a":[{},[0,0,2,1]],"e":[{"g":[{},[0,0,0,1]]},[0,0,2]],"é":[{},[0,0,2]],"i":[{"s":[{},[0,0,0,1]]},[0,0,2]],"o":[{},[0,0,2,1,2]],"ő":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"h":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]]}],"i":[{"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"o":[{"r":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]],"r":[{"e":[{"n":[{},[0,0,0,0,0,0,2]]}]}],"s":[{"é":[{},[2]]}]}],"j":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{"s":[{},[0,0,2]]}],"s":[{},[2,1]]}],"k":[{"a":[{"d":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"z":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"h":[{},[0,0,0,1]],"l":[{},[0,0,0,1]],"ő":[{},[0,0,0,1,2]]}],"s":[{"e":[{},[0,0,2,1]]}],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]]}],"i":[{"d":[{},[0,0,2]],"r":[{"á":[{},[0,0,2]]}]}],"í":[{},[0,0,2]],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2,1]]}],"l":[{"e":[{".":[{},[0,0,2]],"l":[{},[2,1,2]],"s":[{},[0,0,2]],"z":[{},[0,0,2]]}],"é":[{"n":[{},[2,1,2]]}],"m":[{},[2,1]],"y":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"g":[{},[0,0,2]]}],"ú":[{},[0,0,2,0,1]]}]}],"n":[{"a":[{"r":[{},[0,0,2,1,2]],"t":[{},[0,0,2,1,2]]}],"e":[{"k":[{"b":[{},[2]],"h":[{},[2]],"l":[{},[2]]}],"l":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]]}],"i":[{"d":[{},[0,0,2]],"n":[{},[0,0,2]],"s":[{},[0,0,2,1]],"v":[{},[0,0,2]]}],"t":[{},[0,0,0,0,2]],"y":[{"e":[{"g":[{},[0,0,2,0,1,2]],"l":[{},[0,0,2,0,1,2]],"r":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2]]}],"i":[{"m":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,2]]}],"o":[{},[0,0,2,0,1]],"ö":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{"l":[{"é":[{},[0,0,2,0,1]]},[0,0,0,0,0,2]]}]}]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"c":[{".":[{},[2,1]]}],"e":[{"t":[{"t":[{"s":[{},[2,1,2]]}]}]}],"é":[{"n":[{},[2,1,2]],"r":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,0,1]]}],"v":[{},[2,1,2]]}],"i":[{"e":[{},[2,1,2]],"n":[{},[2,1,2]]}],"k":[{"é":[{},[2,1]]}],"l":[{"e":[{"l":[{},[2,1]]}]}],"ó":[{"n":[{},[0,0,2,1]]}],"t":[{"e":[{"k":[{"e":[{},[2]]}],"s":[{},[2,1]]}],"é":[{"r":[{},[2,1]],"s":[{},[2,1]]}]}],"ü":[{"l":[{},[2,1,2]]}],"v":[{"a":[{},[0,0,0,2,1,2]]}],"z":[{},[2,1]]}],"s":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"i":[{"n":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"s":[{"z":[{"a":[{},[0,0,0,3]]}]}],"z":[{"a":[{"l":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]],"á":[{"l":[{},[0,0,2,0,1]],"r":[{"a":[{},[0,0,2,0,1,2]]}]}],"e":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,0,1]]}],"l":[{},[2]],"ő":[{},[0,0,2,0,1]],"s":[{},[0,0,0,0,3]],"t":[{"é":[{},[2]],"h":[{},[2]],"i":[{},[2]],"j":[{},[2]],"l":[{},[2]],"ü":[{},[2]],"v":[{},[2]]}],"ü":[{},[0,0,2,0,1,2]]}]}],"t":[{"a":[{"d":[{},[0,0,2,1]],"k":[{},[0,0,2,1]],"n":[{},[0,0,2,1,2]]}],"á":[{"r":[{"t":[{},[0,0,0,1]]}]}],"e":[{"l":[{"h":[{"o":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,0,0,1]]}]}],"v":[{},[0,0,2,1,2]]}],"é":[{"g":[{},[0,0,2]]}],"j":[{"e":[{},[2,1]],"é":[{"r":[{},[2,1]],"v":[{},[2,1]]}],"ü":[{},[2,1]]}],"k":[{"e":[{".":[{},[2,1]]}]}],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2]],"ő":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"u":[{},[0,0,2,1]],"ű":[{},[0,0,2,1]]}],"v":[{".":[{},[2,1]],"b":[{},[2,1]],"e":[{".":[{},[2,1,2]],"i":[{},[2]],"k":[{},[2,1,2]],"n":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[2,1,2]]}],"é":[{"b":[{},[2,1,2]],"n":[{},[0,0,2]]}],"f":[{},[2,1]],"h":[{},[2,1]],"i":[{},[2,1,2]],"k":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]]}],"z":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2]],"s":[{"m":[{},[0,0,0,1]]}],"t":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{},[0,0,2,1]],"s":[{},[0,0,2,3]],"u":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"f":[{"a":[{"l":[{"e":[{},[0,0,0,2,1,2]],"o":[{"m":[{},[0,0,0,2]]}]}],"s":[{},[0,0,0,1,2]]}],"é":[{"m":[{"a":[{},[0,0,0,2,1,2]]}]}],"i":[{"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"l":[{"a":[{},[0,0,2]],"o":[{},[0,1,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"o":[{"g":[{"a":[{"d":[{"a":[{"t":[{},[0,0,0,0,1]]}]}]}]}]}],"r":[{"a":[{"k":[{},[0,1,2]],"n":[{},[0,1,2]]}],"á":[{},[0,0,2]],"e":[{},[0,1,2]],"i":[{},[0,1,2]],"í":[{},[0,1,2]],"o":[{},[0,1,2]],"ö":[{},[0,1,2]]}]}],"g":[{"é":[{"p":[{"e":[{"l":[{},[0,0,0,2,1,2]]}],"i":[{"p":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}],"l":[{"i":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"ö":[{"r":[{"c":[{"s":[{"o":[{},[0,0,0,0,2]]}]}]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}]}],"h":[{"a":[{"s":[{"á":[{"b":[{"r":[{},[0,0,0,2]]}]}]}]}],"o":[{"s":[{"s":[{"z":[{"ú":[{"t":[{},[0,0,0,0,0,0,1]]}]}]}]}]}]}],"i":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{"o":[{},[0,0,2]]}],"c":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{"r":[{},[0,0,2]]},[0,0,0,1,2]],"g":[{},[0,0,2]],"h":[{},[0,0,2]],"í":[{},[0,0,2]],"l":[{"e":[{},[0,0,2]]}],"m":[{"é":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2,1]],"r":[{"é":[{},[0,0,2]]}],"s":[{"z":[{"á":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ó":[{},[0,0,2]]}]},[0,0,0,0,2]],"t":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"ü":[{},[0,0,2]],"v":[{},[0,0,2]]}],"á":[{"z":[{},[2,1,2]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"s":[{"a":[{"p":[{},[0,0,0,0,0,2,1]]}]}]}],"d":[{"e":[{"á":[{},[2,1,2]],"g":[{},[2,1,2]],"i":[{},[2,1,2]],"j":[{},[2]],"n":[{"t":[{},[0,0,2]]},[2]],"o":[{},[2,1,2]]}],"é":[{"n":[{},[0,0,2]]}],"i":[{"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]}],"ő":[{"z":[{},[0,1]]},[2]]}],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"f":[{},[0,0,2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"a":[{"z":[{},[2,1,2]]}],"é":[{"n":[{},[2,1,2]]}],"r":[{"i":[{},[0,0,1]]}]}],"h":[{"l":[{},[2,1]]}],"i":[{"d":[{},[0,0,0,2]]}],"k":[{"l":[{"i":[{},[0,0,1,2]],"u":[{},[0,0,1]]}],"o":[{"n":[{"o":[{},[0,0,2]],"t":[{},[0,0,2]]}]}],"s":[{},[2]]}],"l":[{"a":[{"l":[{},[0,0,2]]}],"l":[{"e":[{},[2]],"u":[{},[2]],"ú":[{},[2]]}]}],"m":[{"a":[{".":[{},[0,0,2]]}],"á":[{"h":[{},[0,0,2]]}],"i":[{"t":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,2]]}]}],"n":[{"a":[{"j":[{},[0,0,2]],"m":[{},[2,1,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{},[2,1,2]]}],"á":[{"r":[{"a":[{},[0,0,2,1]]}]}],"c":[{"e":[{},[0,0,0,2,1,2]],"h":[{},[0,0,0,2]]}],"d":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[2,1]],"e":[{"k":[{},[0,0,0,2]],"r":[{},[0,0,0,2,1]]}],"i":[{"n":[{},[0,0,0,2]]}],"í":[{},[2,1]],"u":[{},[2]]}],"e":[{"g":[{},[0,0,2]],"s":[{},[0,0,0,0,2]]}],"f":[{"l":[{},[2]],"ú":[{},[2,1]]}],"g":[{"á":[{},[0,0,0,2,1]],"é":[{},[2,1]],"h":[{},[0,0,0,1,2]]}],"i":[{"n":[{"j":[{},[0,0,0,1]]}]}],"k":[{"a":[{"l":[{},[0,0,0,2,1,2]],"n":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,1]]}],"e":[{"c":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2]],"ö":[{},[0,0,0,2]]}],"s":[{"p":[{},[2,1]]}],"u":[{"k":[{},[2,1,2]]}],"ü":[{},[0,0,2]],"z":[{},[2,1]]}],"o":[{"n":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1]]}],"r":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"a":[{"m":[{},[0,0,2]],"t":[{},[2,1,2]]}],"á":[{"n":[{},[2,0,2]]}],"g":[{},[2]],"h":[{},[2]],"i":[{"g":[{"y":[{"e":[{"l":[{},[0,0,0,0,2]]}]}]}]}],"k":[{},[2,1]],"o":[{"d":[{},[2,1,2]],"m":[{},[2,1,2]]}],"ó":[{"n":[{},[0,0,2]]}],"r":[{},[2,1]]}],"s":[{"a":[{"l":[{},[0,0,2]]}],"e":[{"l":[{"v":[{},[0,0,0,1]]}],"p":[{"e":[{},[0,0,0,1]]}]}],"i":[{"n":[{"g":[{},[0,0,0,1]]}],"t":[{},[2]]}],"í":[{"r":[{},[0,0,2,1,2]]}],"p":[{"i":[{},[0,0,1,2]]}],"s":[{"z":[{"a":[{"b":[{},[0,0,0,3]]}],"e":[{"r":[{},[0,0,0,3]]}]}]}],"ü":[{"t":[{},[0,0,2,1,2]],"v":[{},[0,0,2,1,2]]}],"ű":[{},[0,0,2,1]],"z":[{"á":[{"r":[{".":[{},[0,0,0,3]]},[0,0,2]]}],"f":[{},[0,0,1,0,2]]}]}],"t":[{"a":[{"c":[{},[0,0,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{},[2,1,2]]}],"á":[{"c":[{},[2]],"r":[{".":[{},[0,0,0,1]],"á":[{},[0,0,0,1]],"h":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"n":[{},[0,0,0,1]],"r":[{},[0,0,0,1]],"t":[{},[0,0,0,1]],"ú":[{},[0,0,0,1]]}]}],"b":[{"o":[{},[2]]}],"i":[{"n":[{"g":[{},[0,0,0,1]]}],"s":[{},[0,0,0,0,2]]}],"l":[{"á":[{},[2]]}],"ö":[{"k":[{},[0,0,2]]}],"r":[{"i":[{},[0,0,1]],"o":[{},[2]],"ú":[{},[2]]}],"ü":[{"r":[{},[0,0,2]]}]}],"u":[{"m":[{"é":[{},[0,0,0,0,0,2]],"i":[{"n":[{},[0,0,0,2]]}]}],"s":[{},[0,0,0,2]]}],"v":[{"a":[{"d":[{},[2,1,2]]}],"ó":[{},[2,1,2]]}],"x":[{"i":[{},[0,0,2,1]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"z":[{"é":[{".":[{},[0,0,2]],"t":[{},[0,0,2]]}]}]},[1]],"í":[{"g":[{"é":[{},[0,1,2]]}],"j":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"n":[{"s":[{},[0,1]]}],"r":[{"á":[{},[2,1,2]],"ó":[{},[2,1,2]]}],"v":[{".":[{},[0,1]],"á":[{},[0,0,2]],"b":[{},[0,1]],"é":[{},[0,0,2]],"h":[{},[0,1]],"r":[{},[0,1]],"v":[{},[0,1]]}],"z":[{"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"j":[{"é":[{"n":[{"á":[{},[0,0,0,2]]}]}],"o":[{"b":[{"b":[{"o":[{},[0,0,0,0,0,1]]}]}],"g":[{"á":[{"s":[{},[0,0,0,2,1,2]]}]}],"l":[{},[0,2,1]]}],"ó":[{"s":[{"á":[{},[0,0,1]]}]}],"ő":[{"s":[{},[0,0,1]]}]}],"k":[{"a":[{"r":[{"ó":[{"r":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}],"e":[{"p":[{},[0,0,0,1]]}],"i":[{"a":[{},[0,0,0,0,2]],"á":[{},[0,0,0,0,2]],"e":[{},[0,0,0,0,2]]}],"l":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}],"ó":[{"r":[{"o":[{"s":[{"t":[{},[0,0,0,2]]}]}]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]],"ó":[{},[0,0,2]]}]}],"l":[{"a":[{"f":[{},[0,0,0,1]],"p":[{"á":[{"r":[{"o":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"i":[{"n":[{},[0,0,0,2]]}]}],"s":[{"t":[{},[0,0,0,1,2]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}]}],"e":[{"g":[{},[0,0,0,1,2]],"í":[{},[0,0,0,0,2]],"k":[{"n":[{},[0,0,0,1]]}],"p":[{"l":[{"a":[{},[0,0,0,1]]}]}]}],"é":[{"k":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2,1]],"s":[{"t":[{".":[{},[0,0,0,2,1]]}]}]}],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"o":[{"l":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2]],"ú":[{},[0,0,0,2,1,2]]}],"s":[{"z":[{"é":[{},[0,0,0,2]]}]}]}],"o":[{"k":[{"á":[{"l":[{},[0,0,0,2,1]]}],"é":[{},[0,0,0,2]]}]}],"ő":[{"s":[{"a":[{},[0,0,0,2,1,2]],"ű":[{},[0,0,0,2,1,2]]}]}]}],"m":[{"a":[{"g":[{"g":[{},[0,0,0,0,1]],"l":[{},[0,0,0,1]]}],"i":[{},[0,0,0,0,2]],"s":[{},[0,0,0,0,2]],"t":[{"k":[{},[0,2,1]]}]}],"e":[{".":[{},[0,2]],"g":[{"é":[{},[0,0,0,2,1]]}]}],"i":[{"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,0,2,1,2]]}]}]}]}]}]}],"o":[{"b":[{"e":[{},[0,0,2]],"j":[{},[2,1]]}],"c":[{"i":[{},[0,0,0,0,1]]}],"f":[{"f":[{},[2,1]]}],"g":[{"r":[{"á":[{"f":[{".":[{},[0,0,1,2]],"f":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"n":[{},[0,0,1,2]]}]}]}],"y":[{"a":[{},[0,0,2,0,1,2]]}]}],"h":[{"u":[{},[0,0,0,0,2]]}],"i":[{"s":[{},[0,0,2]]}],"k":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1]],"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2]]}],"á":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1]],"s":[{},[0,0,2,1,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"l":[{},[0,0,2,1]]}],"k":[{},[0,0,0,1,2]],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"t":[{"a":[{"t":[{},[2,1]]}]},[0,0,0,1]],"u":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ú":[{"s":[{},[0,0,2]],"t":[{"o":[{},[0,0,2,1]]}]},[0,0,0,0,2]],"ü":[{},[0,0,2]]}],"l":[{"a":[{"j":[{},[2,1,2]]}],"d":[{"a":[{},[2,1]],"ó":[{},[0,1]]}],"i":[{"m":[{},[2,1,2]]}],"l":[{"i":[{"n":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"ó":[{},[2,1]]}],"ó":[{"i":[{"k":[{"o":[{},[0,0,0,0,0,2]]}]}]}],"t":[{"á":[{"r":[{},[2,1]],"s":[{},[2,1]]}]}],"v":[{"a":[{"d":[{},[2]],"s":[{},[2]]}]}]}],"m":[{"l":[{},[2,1]]}],"n":[{"a":[{"c":[{"é":[{},[0,0,0,1]]}],"d":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2,1,2]],"r":[{},[0,0,0,0,2]],"s":[{},[0,0,2,1]]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}]}],"e":[{"g":[{},[0,0,2]],"r":[{},[0,0,2,1]]}],"i":[{"s":[{},[0,0,2,1]]}],"o":[{"r":[{},[0,0,0,2]]}],"ö":[{},[0,0,2]],"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]],"t":[{"r":[{"é":[{},[0,0,0,1]]}]}],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]],"y":[{"á":[{"z":[{},[0,0,2]]},[0,0,0,0,0,2]]}]}],"o":[{"r":[{},[0,0,2]]}],"p":[{"c":[{},[2,1]],"e":[{"r":[{},[0,0,2]]},[2]],"l":[{},[0,0,1,2]],"t":[{},[2,1]]}],"r":[{"a":[{"d":[{},[0,0,2,1]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"á":[{"l":[{"a":[{},[0,0,0,0,2]]}]}],"d":[{"í":[{},[2,1]]}],"e":[{"l":[{},[0,0,2,1]],"n":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{"t":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2]],"e":[{},[2]],"s":[{"k":[{},[0,0,2,1]],"z":[{"o":[{},[0,0,2,1]]}]},[0,0,0,0,2]],"z":[{"g":[{},[0,0,0,1]]}]}],"j":[{"a":[{"i":[{"a":[{},[2]],"é":[{},[2]],"t":[{},[2,1]]}]}]}],"o":[{"l":[{},[0,0,2,1]],"n":[{"t":[{},[0,0,2,1]]}]}],"ó":[{"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"r":[{".":[{},[2,1]]}],"s":[{},[0,0,0,1,2]],"t":[{"á":[{},[0,0,0,3]],"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"s":[{"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1]],"t":[{"o":[{},[2]],"r":[{},[2,1]],"y":[{},[2,1]]}],"ü":[{},[0,0,2]],"z":[{"a":[{"l":[{},[0,0,2]]}],"i":[{"s":[{},[0,0,2]]}],"l":[{"o":[{},[2,1]]}]}]}],"t":[{"h":[{},[0,0,1,2]],"t":[{"h":[{"a":[{},[2,1]]}],"o":[{},[0,0,0,2]]}]}],"u":[{"n":[{},[0,0,2]],"s":[{},[0,0,2,0,2]]}],"v":[{"i":[{},[0,0,2]]}],"x":[{"i":[{},[0,0,2]]}],"z":[{"s":[{"o":[{},[0,0,3]]}]}]},[1]],"ó":[{"á":[{"g":[{},[0,0,0,2]]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"h":[{},[0,0,2]],"s":[{"a":[{"p":[{"á":[{},[0,0,0,0,0,0,0,2]]},[0,0,0,0,0,2,1]]}]}]}],"d":[{"a":[{"l":[{},[0,0,2,1,2]],"u":[{},[0,0,2]]}],"á":[{"k":[{},[0,0,2]],"r":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"p":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,1,2]]}],"ó":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"u":[{"s":[{},[0,0,0,0,0,1]]},[0,0,0,0,2]]}],"f":[{"l":[{},[0,0,1]]}],"i":[{"k":[{"o":[{},[0,0,0,2]]}]}],"k":[{"l":[{},[0,0,1,2]],"u":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"l":[{"a":[{"r":[{},[0,0,2]]}]}],"p":[{"r":[{},[0,0,1,2]]}],"r":[{"a":[{"k":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2]],"i":[{},[0,0,2]],"j":[{},[0,0,2]],"m":[{},[0,0,2]]}],"i":[{"a":[{"s":[{},[0,0,0,0,2]]}]}],"ó":[{"n":[{},[0,0,2,1]]},[0,0,0,0,2]],"ö":[{},[0,0,2]]}],"s":[{"k":[{},[0,0,1,2]]}],"t":[{"h":[{"e":[{},[0,0,1]]}]}]},[1]],"ö":[{"b":[{"ö":[{},[0,0,2]]}],"k":[{"o":[{},[0,0,2]]}],"l":[{"c":[{"s":[{"a":[{},[0,0,0,2,0,1]],"á":[{},[0,0,0,2]],"e":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2,0,1]]}],"é":[{"r":[{".":[{},[0,0,0,2,0,1]]}]}],"i":[{"l":[{},[0,0,0,2,0,1]]}],"o":[{},[0,0,0,2,0,1]],"ő":[{},[0,0,0,2,0,1]]}]}],"e":[{},[0,0,2]]}],"n":[{"u":[{},[0,0,2]]}],"r":[{"o":[{},[0,0,2]],"ő":[{},[0,0,2,1]]}],"t":[{"l":[{},[0,1]]}],"v":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"ő":[{"a":[{"n":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2]],"t":[{"e":[{},[0,0,0,2]]}]}],"k":[{"l":[{},[0,0,1]]}],"p":[{"s":[{},[0,0,1]]}],"r":[{"á":[{"r":[{},[0,0,2,1,2]]}],"h":[{},[2,1]],"i":[{},[2,1,2]]}],"s":[{"i":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{"á":[{"r":[{},[0,0,0,3]]}]}]}],"ü":[{"l":[{},[0,0,0,2]]}],"z":[{"i":[{},[0,0,2]]}]},[1]],"p":[{"a":[{"d":[{"r":[{},[0,0,0,1]]}],"k":[{"c":[{},[0,2,1]],"t":[{"á":[{},[0,2,1]]}]}]}],"á":[{"l":[{"l":[{},[0,2,1]]}],"r":[{"k":[{"o":[{},[0,2,1]]}]}],"t":[{"j":[{},[0,2,1]],"k":[{},[0,2,1]]}]}],"c":[{"i":[{},[0,0,2]]}],"e":[{"l":[{"t":[{},[0,0,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"n":[{"d":[{},[0,0,1]]}],"r":[{"e":[{},[0,0,0,2]]}]}],"l":[{"a":[{"k":[{},[0,0,2]]}],"o":[{"m":[{"a":[{"l":[{},[0,0,0,0,2]]}]}]}],"u":[{},[0,1,2]]}],"o":[{"n":[{"d":[{},[0,0,0,0,1,2]]}],"r":[{"d":[{},[0,2,1]],"t":[{"a":[{"l":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]],"á":[{"r":[{},[0,0,0,0,2,1,2]]}],"e":[{},[0,0,0,0,2,1,2]]}]}],"s":[{"z":[{"t":[{"á":[{"s":[{},[0,2,1]]}]}]}]}]}],"ö":[{"s":[{},[0,2,1]]}],"r":[{"e":[{"f":[{},[0,1,2]],"p":[{},[0,1,2]]}],"é":[{"s":[{},[0,1,2]]}],"i":[{"b":[{},[0,1]],"c":[{},[0,1,2]],"o":[{},[0,0,2]]}],"o":[{"d":[{},[0,1,2]],"f":[{},[0,1]],"g":[{},[0,1]],"j":[{},[0,1]],"p":[{},[0,1,2,0,1]],"t":[{},[0,1,2]]}],"ó":[{"b":[{},[0,1,2]]}],"u":[{},[0,1,2]]}],"s":[{"z":[{"i":[{},[0,1,2]]}]}],"u":[{"t":[{"a":[{},[0,2,1,2]],"ó":[{},[0,2,1]]}]}],"ü":[{"z":[{},[0,2,1]]}]}],"r":[{"a":[{"p":[{},[0,0,0,1]]}],"e":[{"n":[{"d":[{"ő":[{},[0,0,0,0,2,1,2]]}]}]}],"é":[{"m":[{},[0,0,0,2,1]]}]}],"s":[{"a":[{"v":[{"o":[{},[0,0,0,2]]}]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"l":[{"á":[{},[0,0,2]]}],"m":[{"i":[{},[0,0,2]]}],"n":[{"i":[{},[0,0,2]]}],"o":[{"n":[{"d":[{},[0,0,1]]}]}],"p":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"r":[{},[0,0,0,2]],"ú":[{},[0,0,2]]}],"z":[{"a":[{"k":[{"é":[{},[0,0,0,0,2]],"ü":[{},[0,0,0,0,2,1]]}]}],"á":[{"r":[{"a":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"c":[{},[0,0,0,2]],"é":[{"d":[{"e":[{"m":[{},[0,0,0,0,2]]}]}]}],"f":[{},[0,1,0,2]],"í":[{"n":[{"n":[{},[0,0,0,0,0,3]]}]}],"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2]],"p":[{},[0,1,0,2]],"t":[{"á":[{},[0,0,0,2]]}],"v":[{},[0,1,0,2]]}]}],"t":[{"a":[{"n":[{"ó":[{},[0,0,0,2,1,2]]}]}],"á":[{"r":[{"a":[{"d":[{"a":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}]}],"é":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"r":[{"a":[{"n":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]},[0,0,0,0,0,2]]}]}],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ó":[{},[0,1,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}],"u":[{"d":[{"v":[{},[2,1]]}],"g":[{"r":[{},[2,1]]}],"j":[{"j":[{},[0,1]]}],"l":[{"e":[{"t":[{},[2]]}],"z":[{},[2]]}],"m":[{"a":[{"d":[{},[0,0,2,1]]}],"e":[{"l":[{},[0,0,2,1]]}],"é":[{"l":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"i":[{"n":[{},[0,0,2]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2]],"v":[{},[0,0,2,1]]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"u":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"n":[{"g":[{},[0,0,0,1]],"o":[{"k":[{},[0,0,2]]}]}],"r":[{".":[{},[2]],"a":[{"l":[{},[0,0,2]],"m":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"i":[{"z":[{"m":[{},[0,0,0,1]]}]}],"u":[{},[0,0,2,1,2]]}],"s":[{"a":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2,1,2]],"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1]],"é":[{"r":[{"t":[{"é":[{},[0,0,2,1]]}]}]}],"i":[{"r":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]],"ő":[{},[0,0,2]],"s":[{"z":[{"e":[{},[0,0,0,3]]}]},[0,0,0,0,2]],"t":[{"á":[{"r":[{"á":[{},[0,0,0,2]]}]}],"e":[{"r":[{"j":[{},[0,0,0,2,1]]}]}]}],"z":[{"a":[{"l":[{},[0,0,2]],"v":[{},[0,0,0,3]]}],"á":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]]}]}]}],"t":[{"a":[{"g":[{},[0,0,2,1,2]],"l":[{"a":[{},[0,0,0,1,2]],"á":[{},[2,1]],"v":[{},[2]]},[0,0,2]],"n":[{"y":[{},[0,0,2,1]]},[0,0,0,0,2]],"s":[{"í":[{},[0,0,2]]}],"z":[{},[0,1,2]]}],"á":[{"r":[{"a":[{},[0,0,2,1,2]],"b":[{},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}],"s":[{},[2,1,2]]}],"c":[{"a":[{},[2]]}],"e":[{"l":[{},[0,0,2,1]]}],"i":[{"l":[{},[0,0,2]],"n":[{},[0,0,2,1]]}],"o":[{"l":[{},[2,1,2]]}],"ó":[{"d":[{},[2,1,2]],"p":[{},[2,1,2]]}],"ö":[{},[0,0,2,1]],"ü":[{},[0,0,2]]}]},[1]],"ú":[{"j":[{"í":[{},[0,0,2]]}],"l":[{"t":[{"e":[{},[0,0,0,2,1,2]],"o":[{"l":[{},[0,0,0,2]]}]}]}],"r":[{".":[{},[2,1]],"i":[{},[0,0,2]],"n":[{},[2,1]]}],"s":[{"z":[{},[2,1,2]]}],"t":[{"b":[{},[2,1]],"h":[{},[0,1]],"i":[{},[2,1,2]],"j":[{},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{},[2,1,2]],"r":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]]}]},[1]],"ü":[{"d":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"g":[{"y":[{},[0,0,2]]}],"n":[{"á":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]],"z":[{},[0,0,1]]}],"v":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[1]],"ű":[{"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"l":[{},[2,1]]}],"s":[{"p":[{},[0,0,1]],"ú":[{},[0,0,0,0,2]],"z":[{},[0,0,1]]}],"t":[{"ő":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}]}],"v":[{"e":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}]}],"z":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[1]],"v":[{"a":[{"d":[{"o":[{"t":[{},[0,2,1,2]]}]}]}],"á":[{"g":[{"y":[{"a":[{"d":[{"a":[{},[0,0,0,2,0,1]]},[0,0,0,0,0,0,2]]}]}]}]}],"e":[{"r":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,0,3]]}]}]}]}]}],"w":[{"h":[{"i":[{},[0,0,2]]}]}],"z":[{"a":[{"t":[{"e":[{},[0,0,0,2,1]]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"e":[{"r":[{"o":[{},[0,0,0,2,1]]}],"t":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1,2]],"e":[{"g":[{},[0,0,0,2,1,2]],"l":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,2]]}]}],"é":[{"k":[{},[0,0,0,2,1,2]],"r":[{"d":[{},[0,0,0,2,1]]}]}],"o":[{},[0,0,0,2]],"ö":[{},[0,0,0,2,1,2]],"ő":[{},[0,0,0,2,1,2]]}]}],"é":[{"s":[{"a":[{},[0,0,0,2,1]],"o":[{},[0,0,0,2]]}]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"ő":[{"e":[{"r":[{},[0,0,0,0,2]]}]}],"r":[{"í":[{},[0,0,2]]}]}]}],"n":[{".":[{},[2]],"a":[{"a":[{"d":[{},[0,0,0,2]]}],"b":[{"b":[{"ó":[{},[0,1]]}],"r":[{},[2,1]],"s":[{},[2,1]]}],"c":[{"l":[{},[0,0,1]]}],"d":[{"a":[{"g":[{},[2,1,2]]}],"á":[{"s":[{},[2,1,2]]}],"d":[{},[2,1]],"e":[{"k":[{},[0,0,2]]}],"m":[{},[2,1]],"ó":[{},[2,1,2]],"r":[{"e":[{},[0,0,1,2]]}],"t":[{},[2,1]],"u":[{".":[{},[0,0,2]],"s":[{},[0,0,2]]}]}],"e":[{"i":[{},[0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"f":[{},[2,1]]}],"g":[{"a":[{".":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2]]}],"i":[{"t":[{},[0,0,2]]}],"ó":[{"n":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,1]]}],"y":[{"a":[{"g":[{"g":[{},[0,0,0,0,1]]}],"l":[{},[0,0,2,0,1,2]],"p":[{"j":[{},[0,0,2]]}],"s":[{},[0,0,2,0,1]],"v":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2,0,1,2]]}],"ú":[{"r":[{},[0,0,0,0,1]],"t":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}]}],"i":[{"r":[{"e":[{},[0,0,2]]}]}],"j":[{"i":[{},[0,0,2]],"k":[{},[2,1]]}],"k":[{"a":[{"d":[{},[2,1,2]],"r":[{"ó":[{},[0,0,0,0,0,0,2]]}]}],"á":[{"s":[{"z":[{},[0,0,0,1,2]]}],"t":[{},[0,0,2,1]]}],"k":[{"o":[{},[0,1]]}],"l":[{"i":[{},[0,0,1]],"u":[{},[0,0,1]]}],"o":[{"l":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ó":[{".":[{},[2,1,2]]}],"r":[{"é":[{},[0,0,1,2]]}],"t":[{"i":[{},[0,1]]}],"u":[{"s":[{},[2,1,2]]}],"ú":[{"t":[{"n":[{},[0,0,2,1]]}]}]}],"l":[{"a":[{"d":[{"ó":[{},[0,0,2,1,2]]}],"g":[{},[2,1,2,0,2,1]],"j":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"n":[{"a":[{},[0,0,2]]}],"p":[{"a":[{},[2,1,2]],"d":[{},[2,1,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"r":[{},[0,0,2]],"v":[{},[0,0,2]]}],"á":[{"b":[{"r":[{},[0,0,2,1]]}],"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"r":[{"o":[{},[0,0,2,1,2]]}],"t":[{"ö":[{},[0,0,0,1,2,1]],"s":[{},[0,0,2,1]]}]}],"e":[{"l":[{"á":[{},[0,0,2,1]],"l":[{},[0,0,2,1]]}],"n":[{"g":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}]}],"é":[{"g":[{".":[{},[0,0,0,1]]}],"k":[{},[0,0,2,1]],"r":[{"i":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2]],"n":[{"g":[{},[0,0,2,1]]}],"o":[{},[0,0,2,1,2]]}],"í":[{"r":[{},[0,0,2,1,2]],"z":[{"i":[{"s":[{"b":[{},[2]],"e":[{},[2]],"é":[{},[2]],"h":[{},[2]],"i":[{},[2]],"k":[{},[2]],"n":[{},[2]],"r":[{},[2]],"t":[{},[2]],"ü":[{},[2]]}]}]}]}],"j":[{".":[{},[2]],"a":[{".":[{},[0,1]],"c":[{},[3]],"d":[{},[0,1]],"i":[{},[0,1]],"k":[{},[2]],"m":[{},[0,1]],"t":[{},[0,1]]}],"i":[{},[0,1]],"o":[{"n":[{},[2]]}],"u":[{},[2]],"z":[{},[2]]}],"k":[{"a":[{"t":[{},[2,1]]}]}],"o":[{"b":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"p":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ő":[{},[0,0,2,1]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"l":[{"j":[{},[0,0,2]]}],"t":[{},[0,0,2,1]]}],"ü":[{},[0,0,2]]}],"m":[{"e":[{"r":[{},[0,0,2]]}],"i":[{"t":[{"b":[{"o":[{},[2]]}],"e":[{},[2,1,2]],"g":[{},[2,1,2]],"h":[{"a":[{},[2]]}],"k":[{},[2,1,2]],"l":[{},[2,1]],"m":[{},[2]],"ö":[{},[2]],"p":[{},[2,1,2]],"r":[{"o":[{},[2]],"ú":[{},[2]]}],"s":[{},[2]],"t":[{"á":[{},[2]],"ö":[{},[2]]}]}]}],"ö":[{},[2,1]],"p":[{},[2,1]]}],"n":[{"a":[{"l":[{},[2,1,2]]}],"g":[{},[2,1]],"h":[{},[2,1]],"o":[{"g":[{},[0,0,0,0,0,2]]},[0,0,0,0,1]],"ó":[{"d":[{},[0,0,2]]}],"y":[{"a":[{"g":[{},[2,1,2]]}]}]}],"o":[{"l":[{},[0,0,0,2]]}],"ó":[{"r":[{},[0,0,0,2]]}],"p":[{"a":[{".":[{},[2]],"d":[{"ó":[{},[0,0,0,1]]}],"g":[{},[0,0,2,1,2]],"l":[{"a":[{},[0,0,2,1]],"k":[{},[0,0,2,1]]}],"p":[{"a":[{},[0,0,0,1,2]],"á":[{},[0,0,0,1]]}],"r":[{"á":[{},[0,0,0,1]]}],"s":[{},[0,0,2,1]]}],"á":[{"d":[{},[0,0,2]],"g":[{},[0,0,2,1,2]],"k":[{},[0,0,2]],"l":[{"l":[{},[0,0,0,1]]}],"m":[{},[0,0,2]],"r":[{"b":[{},[0,0,2,1]]}],"t":[{"m":[{},[0,0,2,1]]}]}],"e":[{"l":[{"l":[{},[0,0,0,1]]},[0,0,0,0,2]],"m":[{},[0,0,2]],"s":[{"t":[{},[0,0,0,1]]}]}],"i":[{"l":[{"l":[{},[0,0,2,1]]}],"n":[{"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"s":[{"k":[{},[0,0,0,1]]}]}],"í":[{},[0,0,2]],"l":[{"a":[{"t":[{},[0,0,0,2]]}]}],"o":[{"l":[{"a":[{},[0,0,2,1]]}],"r":[{"m":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,0,0,1]],"t":[{"á":[{},[0,0,2,1]]}]}],"t":[{"t":[{},[0,0,2,1]]}]}],"ó":[{".":[{},[0,0,2]],"r":[{},[0,0,2,1,2]]}],"p":[{"o":[{},[2]],"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{"í":[{},[0,1]],"ó":[{"z":[{},[2]]}]}],"u":[{"t":[{},[0,0,2,1,2]]}],"ú":[{"r":[{},[0,0,2,1]]}]}],"r":[{"a":[{"i":[{},[2,1,2]],"n":[{"n":[{},[2]],"y":[{".":[{},[2,1]],"a":[{".":[{},[2,1,2]]}],"á":[{},[2,1,2]],"b":[{},[2]],"h":[{},[2]],"k":[{},[2]],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2,1]]}]}]}],"c":[{".":[{},[2,1]],"á":[{},[2,1]],"h":[{"i":[{"a":[{"b":[{},[0,0,0,0,0,0,2]]}]}]}],"o":[{},[2,1]],"u":[{},[2,1]],"ú":[{},[2,1]]}],"r":[{"ó":[{},[0,1]]}],"z":[{},[2,1]]}],"s":[{"é":[{"v":[{},[0,0,2]]}],"i":[{"s":[{"k":[{},[0,0,0,1]]}]}],"k":[{"a":[{},[0,0,1,2]]},[2]],"r":[{"á":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"r":[{},[0,0,1]]},[0,0,0,0,2]],"z":[{"a":[{"n":[{},[0,0,2,0,1]]}],"á":[{"r":[{"a":[{"d":[{},[0,0,2,0,1]]}]}]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"ü":[{"g":[{},[0,0,0,0,1]]}]}]}],"t":[{"a":[{"b":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"l":[{"k":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"r":[{"á":[{},[0,0,0,1]]}]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}],"r":[{"é":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1]]}]}],"e":[{"g":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,0,0,3]],"é":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,0,1]]}]}]}],"é":[{"l":[{},[0,0,2]],"r":[{"k":[{"e":[{},[0,0,0,1]]}],"v":[{},[0,0,2,1]]}]}],"i":[{"m":[{},[0,0,2,1,2]],"n":[{"g":[{},[0,0,2,1]]}]}],"o":[{"l":[{"d":[{},[0,0,2,1]]}],"r":[{"s":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"u":[{"t":[{},[0,0,2,1,2]]}],"ü":[{"l":[{},[0,0,2]]}],"ű":[{"z":[{},[0,0,0,0,2]]}],"y":[{},[2,1,2]]}],"u":[{"c":[{},[0,0,2]],"l":[{},[0,0,2]],"r":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,2]]}],"s":[{},[0,0,0,2]],"t":[{"o":[{},[0,0,2]]}]}],"ü":[{"z":[{},[0,0,0,2]]}],"v":[{"a":[{"r":[{"t":[{},[0,0,2]]}],"t":[{},[0,0,2]]}],"v":[{},[2,1]]}],"w":[{"h":[{},[0,0,1]]}],"z":[{"b":[{},[2,1]],"é":[{},[0,0,2]],"o":[{},[2,1,2]]}]},[1]],"á":[{"b":[{"é":[{},[2,1,2]],"r":[{},[2]]}],"c":[{"a":[{"j":[{},[0,0,2]]}],"h":[{},[0,0,2,3]],"í":[{},[0,0,2]],"s":[{"a":[{"l":[{},[0,0,2]],"p":[{},[0,0,2]],"s":[{},[0,0,2,0,1]]}],"e":[{},[0,0,2]],"i":[{"k":[{},[0,0,0,3]],"s":[{},[0,0,2]]}],"o":[{"l":[{"a":[{"t":[{},[2]]}]}],"r":[{},[0,0,0,3]]}],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]],"z":[{},[0,0,0,3]]}]}],"d":[{"a":[{"l":[{"a":[{},[0,0,2,1]]}],"p":[{},[0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1,2]]}],"á":[{},[0,0,2]],"d":[{},[0,0,0,1]],"e":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1]],"u":[{"d":[{},[0,0,2]]}],"ü":[{},[0,0,2,1,2]],"z":[{},[0,0,2,3]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"í":[{},[2,1,2]]}],"k":[{"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"o":[{"l":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"l":[{"a":[{"b":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"n":[{"a":[{},[0,0,2]]}],"r":[{},[0,1]],"t":[{"e":[{},[0,0,0,0,2]]}],"z":[{},[0,0,2,1]]}],"á":[{"t":[{},[0,0,2,1]]}],"e":[{"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2]],"s":[{},[0,0,2]]},[0,0,0,0,2]],"é":[{"p":[{},[0,0,2,1]]},[0,2]],"i":[{"n":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,0,2]]}],"í":[{},[0,0,2]],"l":[{".":[{},[2,1]],"a":[{".":[{},[2,1]],"p":[{},[2,1]],"t":[{},[2,1]]}],"í":[{},[2,1]],"o":[{"m":[{},[2,1]]}],"ó":[{"k":[{"ö":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"ü":[{},[0,0,2]]}],"m":[{"í":[{},[0,0,2]],"u":[{},[0,0,2]]}],"n":[{"a":[{"d":[{},[0,0,2]],"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2,1,2]]}],"c":[{"e":[{},[0,0,0,2,1]]}],"e":[{},[0,0,2,1,2]],"é":[{"t":[{},[0,0,2]]},[0,0,0,0,2]],"i":[{"n":[{},[0,0,2]]}],"í":[{},[0,0,2]],"s":[{"e":[{},[0,0,0,2]]}],"ü":[{},[0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,2]],"k":[{"a":[{},[2,1,2]],"b":[{},[2,1,2]],"h":[{},[2,1,2]],"k":[{},[2,1,2]],"n":[{},[2,1,2]],"o":[{},[2,1,2]],"r":[{},[2,1,2]],"t":[{},[2,1,2]]}],"m":[{},[2,1,2]],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,1]]},[0,0,2]],"t":[{".":[{},[2,1,2]],"t":[{},[0,0,2,1]]}],"v":[{},[0,0,2,1]]}],"á":[{"c":[{},[0,0,2,1]],"l":[{},[0,0,2,1]]}],"e":[{},[0,0,2,1,2]],"é":[{"v":[{"e":[{},[0,0,2,1]]}]}],"i":[{"a":[{"i":[{},[2,1,2]]}],"á":[{},[2,1,2]],"p":[{},[0,0,2,1,2]]}],"í":[{},[0,0,2]],"ó":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"d":[{},[2,1]],"g":[{},[0,0,2]],"n":[{".":[{},[2]]}],"r":[{},[0,0,0,1]],"s":[{},[2]],"t":[{"á":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ú":[{"t":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"s":[{"a":[{"s":[{},[0,0,2,1]]}],"á":[{"r":[{"é":[{},[0,0,0,1]],"u":[{},[0,0,2,1,2]]}],"s":[{},[2,1,2]]}],"e":[{},[0,0,2,1,2]],"i":[{"k":[{},[0,0,2,1,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"z":[{"a":[{"n":[{},[0,0,2]],"s":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]]}],"e":[{},[0,0,2]],"é":[{"n":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]],"s":[{},[0,0,2]]}],"k":[{"a":[{".":[{},[2,1]]}]}],"o":[{"k":[{"s":[{},[2,1]]}]}],"ö":[{},[0,0,2,0,1]],"ú":[{},[0,0,2,0,1]],"ü":[{},[0,0,2,0,1]]}]}],"t":[{"a":[{"l":[{"a":[{},[0,0,2]]}],"n":[{},[0,0,2,1,2]]}],"á":[{"l":[{},[0,0,2]],"s":[{"v":[{},[0,0,0,1]]}]}],"e":[{},[0,0,2,1,2]],"h":[{"i":[{},[2,1]]}],"i":[{"o":[{},[0,0,2,1,2]],"r":[{},[2,1,2,1]]}],"í":[{},[2,1,2]],"l":[{"é":[{},[2,1]]}],"ö":[{},[0,0,2,1]],"r":[{"u":[{},[2,1]]}],"u":[{"g":[{},[2,1]],"t":[{},[2,1]]}],"ú":[{},[2,1,2]],"ü":[{},[0,0,2]],"v":[{"i":[{},[2,1]]}]}]},[1]],"b":[{"a":[{"k":[{"á":[{},[0,0,0,2]],"e":[{},[0,0,0,2,1,2]]}]}],"é":[{"k":[{"é":[{"b":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"v":[{},[0,2,1,2]]}]}]}],"l":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"o":[{"n":[{"a":[{},[0,0,0,2,1,2]]}]}],"r":[{"a":[{},[0,0,2]],"i":[{},[0,1,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"u":[{"r":[{"g":[{"h":[{"i":[{},[0,0,0,0,0,2]]}]}]}]}]}],"c":[{"a":[{"c":[{"é":[{},[0,0,1]]}],"j":[{"á":[{},[0,2,1]],"t":[{},[0,0,1]]}],"k":[{"n":[{},[0,2,1]],"t":[{},[0,2,1]]}],"l":[{"a":[{},[0,0,1,2]],"j":[{},[0,0,1]],"k":[{},[0,2,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,1]],"t":[{},[0,0,1]],"y":[{"a":[{},[0,0,1,2]]}]}],"r":[{"i":[{},[0,0,1]]}],"t":[{"t":[{},[0,0,1]]}],"u":[{},[0,0,0,2]],"v":[{"a":[{},[0,2,1]]}]}],"á":[{"g":[{},[0,2,1]],"r":[{"b":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{},[0,2,1]],"t":[{},[0,0,1]]}],"s":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"s":[{"i":[{},[0,0,3]],"o":[{},[0,0,3]],"ö":[{},[0,0,3]],"u":[{},[0,0,3]]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"a":[{},[0,0,0,0,2]],"g":[{"g":[{},[0,0,1]]}],"l":[{"d":[{},[0,2,1]],"e":[{"k":[{},[0,0,1,2]],"m":[{},[0,0,1,2]]}],"m":[{},[0,0,1]],"v":[{},[0,2,1]]}],"r":[{"e":[{"d":[{},[0,0,1,2]]}],"ó":[{},[0,0,1]]}],"s":[{"z":[{"t":[{},[0,2,1]]}]}],"t":[{"n":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"é":[{"g":[{"é":[{"r":[{},[0,0,0,2,1]]}]}],"h":[{"e":[{"s":[{},[0,0,0,2]]}]}],"p":[{},[0,2,1]],"v":[{"i":[{},[0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"a":[{},[0,2,3]],"á":[{},[0,2,3]],"e":[{".":[{},[0,2]],"l":[{},[0,0,3]],"t":[{},[0,0,3]]}],"é":[{},[0,2,3]],"i":[{"á":[{},[0,0,3]]}],"í":[{},[0,0,3]],"o":[{"l":[{},[0,0,3]],"n":[{},[0,0,3]],"z":[{},[0,2,3]]}],"ó":[{},[0,2,3]],"ö":[{},[0,0,3]],"u":[{},[0,2,3]],"ú":[{},[0,2,3]]}],"i":[{"a":[{"l":[{"i":[{"s":[{},[0,0,0,2]]}]}],"s":[{"o":[{},[0,0,0,2]]}]}],"g":[{"e":[{},[0,2,1]],"é":[{},[0,2,1,2]]}],"k":[{"o":[{},[0,2,1,2]]}],"m":[{"á":[{},[0,0,1,2]]}],"n":[{"a":[{".":[{},[0,2,1,2]]}],"d":[{},[0,2,1]],"f":[{},[0,0,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]]}],"r":[{"á":[{},[0,2,1]],"o":[{},[0,0,1]]}],"s":[{"t":[{},[0,2,1]]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{},[0,2,1,2]]}],"í":[{"j":[{},[0,0,1]],"r":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{"e":[{},[0,0,1]]}]}],"o":[{"b":[{},[0,2,1]],"k":[{"t":[{"a":[{},[0,2,1]]}]}],"l":[{"i":[{},[0,2,1,2]]}],"r":[{"v":[{},[0,0,1]]}],"t":[{"t":[{},[0,2,1]]}]}],"ö":[{"l":[{"t":[{".":[{},[0,2,1]]}]}],"s":[{"s":[{},[0,0,1]]}],"t":[{},[0,0,0,2]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"a":[{"b":[{},[0,2,0,1]],"c":[{},[0,2]],"d":[{},[0,2]],"g":[{},[0,2,0,1]],"j":[{"t":[{},[0,2,0,1]]}],"k":[{"t":[{},[0,2]]}],"l":[{"a":[{"p":[{},[0,0,0,1]]}],"j":[{},[0,2,0,1]]}],"m":[{},[0,2]],"n":[{},[0,2]],"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]]}]}],"r":[{"a":[{},[0,0,0,1]],"g":[{},[0,0,0,1]],"o":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{},[0,2,0,1]],"z":[{},[0,2]]}],"á":[{"g":[{"r":[{},[0,0,0,1]]}],"l":[{},[0,2,0,1]],"r":[{".":[{},[0,2,3]],"á":[{},[0,2,0,1,2]],"b":[{},[0,0,0,1]],"n":[{},[0,2,0,1]],"r":[{},[0,0,0,1]],"u":[{},[0,2]]}],"t":[{"a":[{},[0,2]],"á":[{},[0,2]],"v":[{},[0,2]]}]}],"e":[{"l":[{"f":[{},[0,0,0,1]]}]}],"é":[{"r":[{"é":[{"s":[{},[0,0,0,1,2]]}],"t":[{"e":[{},[0,2]],"é":[{},[0,2,0,1]]}],"ü":[{},[0,2,3]]}],"t":[{"a":[{},[0,2,3]]}]}],"i":[{"k":[{"o":[{"n":[{},[0,0,0,1,2]]}]}],"n":[{"t":[{},[0,0,0,1]]}],"o":[{},[0,2,0,1]],"p":[{"a":[{},[0,2]]}],"r":[{"á":[{},[0,2]],"t":[{},[0,0,0,1]]}],"s":[{"m":[{},[0,2,0,1]]}],"t":[{"a":[{},[0,2]]}],"z":[{"z":[{},[0,0,0,1]]}]}],"í":[{"k":[{"i":[{},[0,0,3]]}],"r":[{"á":[{},[0,2,0,1,2]]}],"z":[{"t":[{},[0,0,0,1]]}]}],"o":[{"b":[{},[0,2]],"k":[{"s":[{},[0,2,0,1]],"t":[{"a":[{},[0,2]]}]}],"s":[{"z":[{},[0,2]]}]}],"ö":[{"l":[{"é":[{},[0,2,0,1,2]]}],"s":[{},[0,2,0,1]],"z":[{},[0,2,0,1]]}],"ő":[{"r":[{".":[{},[0,2,0,1]],"ö":[{},[0,0,0,1]]}]}],"s":[{},[0,0,0,1]],"u":[{"r":[{},[0,2]],"t":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ú":[{"t":[{},[0,2]]}],"ü":[{"g":[{},[0,2]],"t":[{},[0,2]]}],"z":[{"á":[{"r":[{},[0,0,0,3]]}],"e":[{},[0,0,3]],"ó":[{},[0,0,3]],"ö":[{},[0,0,3]]}]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,0,1]],"r":[{},[0,2,1]]}],"ú":[{"j":[{},[0,2,1]],"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1]]}],"ű":[{"r":[{},[0,2,1]]}],"y":[{"a":[{},[0,0,1]]}],"z":[{"á":[{},[0,2,3]],"e":[{},[0,0,3]],"ó":[{},[0,2,3]],"ö":[{},[0,0,3]],"s":[{},[0,0,3]],"ü":[{},[0,0,3]],"y":[{"i":[{},[0,0,0,0,1]]}]}]}],"d":[{"a":[{"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,0,1]]}],"d":[{"a":[{"t":[{},[0,0,1,2]]}],"á":[{"s":[{},[0,0,0,2]]}],"d":[{},[0,0,1]]}],"j":[{"á":[{},[0,2,1]]}],"k":[{"c":[{},[0,2,1]],"k":[{},[0,2,1]],"t":[{},[0,0,1]]}],"l":[{"j":[{},[0,2,1]],"r":[{},[0,2,1]]}],"n":[{"n":[{},[0,0,1]]}],"p":[{"ó":[{},[0,0,1]]}],"r":[{"á":[{"n":[{},[0,0,1,2]]}],"r":[{},[0,0,1]]}],"t":[{"a":[{"n":[{"y":[{},[0,0,0,0,1]]}],"p":[{},[0,0,0,2]]}],"e":[{"g":[{},[0,0,0,2,1]]}],"i":[{"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}]}],"z":[{"o":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"á":[{"r":[{"a":[{"k":[{},[0,0,1,2]]}]}],"s":[{"s":[{},[0,0,0,0,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"c":[{"l":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"b":[{"b":[{},[0,0,1]]}],"k":[{"é":[{"b":[{},[0,2,1,2]],"i":[{"n":[{},[0,2,1,2]]}]}],"ö":[{"z":[{},[0,0,0,2]]}]}],"l":[{"f":[{},[0,2,1]],"l":[{"e":[{"n":[{},[0,2,1]]}]}],"m":[{},[0,2,1]],"ö":[{},[0,0,1]]}],"m":[{"e":[{"r":[{},[0,0,0,2]]}],"u":[{},[0,0,0,2]],"ü":[{},[0,0,0,2,1]]}],"n":[{"á":[{},[0,0,0,2]],"n":[{"e":[{"k":[{},[0,2]]}]}]}],"p":[{},[0,0,0,1,2]],"r":[{"a":[{},[0,0,0,2,1]],"á":[{"l":[{},[0,0,0,2]],"z":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]],"ő":[{},[0,2,1]]}],"s":[{"e":[{"t":[{"t":[{},[0,2,1,2]]}]}],"é":[{"s":[{},[0,2,1,2]]}],"ő":[{},[0,2,1,2]],"z":[{"a":[{},[0,0,0,2]],"ü":[{},[0,2,1,2]]}]}],"z":[{"a":[{},[0,0,1]]}]}],"é":[{"g":[{"o":[{},[0,0,0,2]]}],"k":[{"e":[{"l":[{},[0,0,0,2]],"z":[{},[0,0,1]]}],"ö":[{},[0,0,0,2]]}],"l":[{"e":[{},[0,2,1]],"m":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"a":[{"j":[{},[0,0,0,2]]}]}],"s":[{"s":[{"z":[{},[0,2,1]]}],"z":[{"h":[{},[0,2,1]],"l":[{},[0,2,1]],"r":[{},[0,2,1]]}]}],"t":[{"e":[{},[0,2,1,2]],"t":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"g":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]]}],"l":[{"l":[{},[0,2,1]]}],"n":[{"a":[{".":[{},[0,2,1,2]]}],"g":[{},[0,2,1]],"s":[{},[0,2,1]]}],"o":[{"n":[{"j":[{},[0,2,1,2]]}]}],"ó":[{"é":[{},[0,0,0,2,0,2]],"f":[{},[0,0,0,2]],"m":[{},[0,0,0,2]]}],"s":[{"z":[{"a":[{},[0,2,1]]}]}]}],"í":[{"j":[{"a":[{"d":[{"a":[{},[0,0,0,2,1,2]]}]}]}]}],"k":[{"l":[{},[0,0,1]]}],"o":[{"á":[{},[0,2,1]],"k":[{"ú":[{"t":[{},[0,0,0,2,1]]}]}],"r":[{"á":[{"l":[{},[0,0,0,2]]}],"n":[{"i":[{},[0,2,1]]}],"ú":[{},[0,0,0,2,1]]}],"u":[{},[0,2,1]],"v":[{},[0,2,1]]}],"ó":[{"é":[{"r":[{},[0,0,0,0,2]]}],"n":[{"i":[{},[0,0,1,2]]}],"r":[{"á":[{},[0,2,1,2]]}]}],"ö":[{"b":[{},[0,0,0,2]],"s":[{"s":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{".":[{},[0,2,1]],"a":[{},[0,2,1,2,1,2]],"b":[{},[0,2,1]],"c":[{},[0,2,1]],"d":[{},[0,2,1]],"e":[{"g":[{},[0,0,1,2]],"i":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]]}],"é":[{"k":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"i":[{"g":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{"k":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ö":[{},[0,2,1,2]],"ő":[{"s":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"ú":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"a":[{"z":[{},[0,0,2]]}],"u":[{"k":[{},[0,1,2]]}]}],"s":[{"l":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{"á":[{"m":[{"ú":[{"t":[{},[0,0,0,0,0,2,1]]}]}]}],"e":[{"r":[{"e":[{"l":[{},[0,0,0,0,0,2,1,2]]}]}]}]}]}],"t":[{"á":[{"r":[{"s":[{"a":[{"d":[{},[0,0,0,0,0,2,1,2]]}]}]}]}]}],"u":[{"t":[{"a":[{},[0,2,1]]},[0,0,0,2]]}],"ú":[{"j":[{},[0,0,1]],"r":[{"á":[{},[0,0,0,2]]}],"s":[{"z":[{},[0,0,1]]}]}],"ü":[{"g":[{},[0,2,1]],"n":[{"n":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"ű":[{"r":[{".":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"y":[{"b":[{},[0,0,0,2]],"h":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"z":[{"a":[{"v":[{},[0,0,3]]}],"á":[{"r":[{},[0,0,3]]}],"e":[{},[0,2,3]],"ó":[{},[0,2,3]],"u":[{},[0,2,3]]}]}],"e":[{"a":[{"j":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"l":[{"a":[{},[0,0,0,2]],"o":[{},[0,0,2]]}],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"b":[{"é":[{},[0,0,2]],"l":[{},[0,0,1]]}],"d":[{"r":[{"a":[{},[0,0,1]],"á":[{},[0,0,1,2]]}],"v":[{"e":[{"l":[{},[0,0,0,2,1]]}]}],"y":[{},[0,0,1]],"z":[{"é":[{},[2,1,2]]}]}],"f":[{"f":[{},[2]]}],"g":[{"e":[{"r":[{},[2,1,2]]}],"é":[{"r":[{".":[{},[2,1]]}]}],"ö":[{},[0,0,2,1]],"y":[{".":[{},[0,1]],"b":[{},[0,1]],"e":[{"k":[{},[0,0,2]],"n":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]],"z":[{},[0,0,2]]}],"é":[{},[2,1,2]],"f":[{},[0,1]],"h":[{},[0,1]],"i":[{"g":[{},[0,0,2]]}],"k":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"r":[{},[0,1]],"s":[{},[2,1]],"t":[{},[0,1]],"ü":[{"n":[{},[0,0,2]]}]}]}],"h":[{"é":[{"z":[{},[0,0,0,0,0,1]]}],"h":[{},[2,1]]}],"i":[{"g":[{},[0,0,0,2]]}],"í":[{"r":[{},[0,0,0,2]]}],"k":[{"a":[{"j":[{},[0,0,2,1]],"n":[{},[0,0,2,1,2]]}],"á":[{"t":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1,2]],"r":[{"ő":[{},[0,0,0,1]]}]}],"é":[{"j":[{"é":[{},[0,0,0,1,2]]}],"k":[{"n":[{},[0,0,0,1]]},[0,0,2]]}],"i":[{"e":[{},[0,0,0,0,0,2]]}],"j":[{},[2]],"k":[{"a":[{},[2]],"i":[{},[2]]},[0,0,0,1,2]],"l":[{"u":[{},[0,0,1]]}],"o":[{"k":[{},[0,0,2,1]]}],"ö":[{"r":[{},[0,0,0,0,2]]}],"r":[{"e":[{"á":[{},[0,0,1]]}]}],"t":[{},[0,0,0,1,2]],"ü":[{"g":[{},[0,0,2,1]],"l":[{"d":[{"ö":[{},[0,0,0,1]]}]}]}]}],"l":[{"a":[{"g":[{},[0,0,2]],"j":[{},[0,0,2]],"n":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2]],"r":[{},[0,0,0,0,2]]}],"e":[{"f":[{},[0,0,2]],"g":[{"y":[{".":[{},[0,1]]}]},[0,0,2]],"l":[{"e":[{},[0,0,0,1,2]]}],"m":[{"a":[{},[0,0,0,0,2]],"e":[{"l":[{},[0,0,0,0,0,1]]}],"é":[{"s":[{},[0,0,0,1,2]]}]}],"n":[{"g":[{},[0,0,0,1]]}],"r":[{},[0,0,2]]}],"é":[{"p":[{},[0,0,2,1]]}],"f":[{"é":[{},[0,0,0,0,0,2]]}],"g":[{},[0,0,0,1,2]],"h":[{"a":[{},[2,1]]}],"i":[{"d":[{},[0,0,2,1]],"m":[{},[0,0,2]],"n":[{},[0,0,2,1]]}],"l":[{"ó":[{},[0,1]]}],"n":[{"e":[{"v":[{},[2,1]]}]}],"o":[{"t":[{},[0,0,2,1]]}],"ó":[{},[0,0,2,1,2]],"ö":[{},[0,0,2,1,2]],"ő":[{"a":[{},[2,1,2]],"á":[{},[2,1,2]],"d":[{},[0,0,2]],"f":[{},[0,0,2]],"h":[{"í":[{},[0,0,2]]}],"í":[{},[2,1,2]],"k":[{"é":[{},[2,1,2]]}],"l":[{},[0,0,2]],"n":[{"y":[{},[2,1]]}],"r":[{"e":[{"j":[{},[2]]}]}],"t":[{"é":[{},[2,1,2]]}]}],"t":[{"é":[{"r":[{},[2,1]]}]}],"ü":[{"l":[{},[0,0,2,1]]}],"z":[{},[2,1]]}],"m":[{"a":[{"k":[{},[0,0,2]]}],"b":[{"a":[{},[2]],"e":[{"r":[{},[2,1]]}]}],"e":[{"g":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"l":[{"e":[{},[2]],"k":[{},[2,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2,1]],"s":[{"z":[{},[0,0,0,1]]}]}],"s":[{},[2]],"u":[{"l":[{},[2]]}]}],"n":[{"g":[{},[2,1]],"n":[{},[2,1]],"s":[{"a":[{},[0,0,0,2]],"e":[{"s":[{"e":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"y":[{"v":[{},[2,1]]}],"z":[{},[2,1]]}],"o":[{"b":[{},[0,0,2]],"d":[{},[0,0,2]],"f":[{},[0,0,2]],"g":[{},[0,0,2]],"h":[{},[0,0,2]],"k":[{"o":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]]}],"r":[{"o":[{},[0,0,2]]}]}],"p":[{"a":[{"d":[{},[0,0,2]]}],"e":[{"l":[{"m":[{},[0,0,2]]}],"s":[{"t":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"u":[{"t":[{},[0,0,2,1]]}]}],"r":[{"a":[{"d":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"á":[{"b":[{},[0,0,2]]}],"c":[{"o":[{},[0,0,0,2]]}],"e":[{"g":[{},[0,0,2,1,2]],"j":[{},[0,1,2]],"k":[{"e":[{".":[{},[0,0,2,1,2]]}]}],"l":[{},[0,0,2,1,2]],"m":[{"e":[{"l":[{},[0,0,0,1]]}]}],"r":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"é":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1]],"p":[{},[0,0,2,1]],"t":[{"t":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2,1]],"g":[{"a":[{},[0,0,2,1]]}],"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1,2]],"n":[{"f":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"s":[{},[0,0,2]]}],"k":[{},[0,0,0,1,2]],"o":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"ó":[{},[0,0,2]],"ö":[{"n":[{},[0,0,2,1]]}],"ő":[{"k":[{"ü":[{},[3,2,3]]}]},[2,1,2]],"s":[{},[0,0,0,1]],"t":[{"r":[{},[0,0,0,1]]}],"u":[{},[0,0,2,1,2]],"ü":[{"g":[{},[0,0,2,1]]}]}],"s":[{"a":[{"l":[{"j":[{"á":[{},[0,0,2,1]]}]}],"s":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"e":[{"t":[{"b":[{},[2,1,2]],"r":[{},[2,1,2]]}]}],"é":[{"s":[{},[2,1,2]]}],"ő":[{},[2,1,2]],"s":[{"z":[{"a":[{},[0,0,0,3]],"á":[{},[0,0,0,3]]}]}],"t":[{"é":[{},[2,1]],"i":[{},[2,1]]}],"ü":[{"v":[{},[0,0,2,1,2]]}],"z":[{"á":[{"l":[{},[0,0,0,0,1]],"r":[{},[0,0,2,3]]}],"é":[{"l":[{},[0,0,2,0,1]]}],"ű":[{},[0,0,2,0,1,2]]}]}],"t":[{"a":[{"b":[{},[0,0,2,1]],"l":[{"a":[{},[0,0,0,1,2]]}],"n":[{"y":[{},[0,0,2,1,2]]}]}],"á":[{"l":[{},[0,0,2]],"t":[{},[0,0,2,1,0,1]]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"á":[{},[0,0,0,1]],"m":[{},[0,0,0,1]],"ő":[{"a":[{},[0,0,2,1]]}]}],"m":[{"l":[{},[0,0,2,1]]}],"s":[{"t":[{"e":[{},[0,0,0,1]]}],"z":[{},[0,0,2,1]]}],"t":[{"e":[{"t":[{},[0,0,2,1]]}],"i":[{},[0,0,2,1]]}]}],"é":[{"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2,1,2]],"r":[{".":[{},[0,0,2,1]],"d":[{},[0,0,2,1]],"é":[{},[0,0,2,1]],"ő":[{".":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]]}],"r":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2]],"ő":[{},[0,0,2,1]]}],"ü":[{},[0,0,2,1,2]]}],"s":[{"z":[{},[0,0,2,1]]}],"v":[{"e":[{".":[{},[0,0,2,1,2]]}]}]}],"i":[{"d":[{},[0,0,2]],"k":[{"o":[{},[0,0,2,1,2]]}],"n":[{"t":[{},[0,0,2,1]]}],"p":[{},[0,0,2]]}],"k":[{"é":[{"s":[{"z":[{"ü":[{},[0,0,0,0,0,2,0,1]]}]}]}]}],"o":[{"k":[{},[0,0,2,1,2]],"l":[{"d":[{},[0,0,0,1]]},[0,0,2]]}],"ő":[{},[0,0,2,1,2]],"t":[{"é":[{"v":[{},[0,0,0,2]]}]}],"u":[{"n":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"ü":[{"l":[{"é":[{},[0,0,0,1]]},[0,0,0,0,2]],"z":[{},[0,0,2,1,2]]}]}],"v":[{"ő":[{},[2,1,2]],"v":[{},[2,1]]}],"x":[{"p":[{"o":[{"r":[{"t":[{"ő":[{},[0,0,0,0,0,0,2,1,2]]}]}]}]}]}],"y":[{"é":[{},[0,0,1]]}],"z":[{"e":[{"r":[{},[2,1,2]]}],"r":[{"e":[{"d":[{},[2,1]]}]}],"ü":[{"s":[{},[2]]}]}]},[1]],"é":[{"b":[{"r":[{},[2,1]]}],"d":[{"l":[{},[2]]}],"f":[{"r":[{},[0,0,1,2]]}],"g":[{".":[{},[2,1]],"e":[{"k":[{},[2,1,2]],"t":[{"é":[{},[2,1,2]],"ő":[{".":[{},[2,1,2]],"h":[{},[2]],"k":[{},[2,1,2]],"n":[{},[2]],"t":[{},[2]]}]}]}],"é":[{},[2,1,2]],"j":[{},[2,1]],"n":[{},[2,1]],"ő":[{},[2,1,2]],"s":[{},[2,1]],"t":[{},[2,1]],"ü":[{},[2,1,2]],"y":[{"e":[{"r":[{},[0,0,2]]}],"é":[{"n":[{},[0,0,2]]}],"o":[{},[0,0,2,0,1]],"ö":[{"k":[{},[0,0,2]]}]}]}],"h":[{"e":[{"s":[{},[2,1,2]]}],"s":[{},[2,1]]}],"k":[{"a":[{"j":[{},[0,0,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2,1,2]],"r":[{},[0,0,2]]}],"á":[{},[0,0,2,1]],"e":[{"l":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2]]}],"é":[{"v":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2]],"s":[{"z":[{},[0,0,0,1]]}]}],"í":[{},[2,1,2]],"ó":[{},[0,0,2]],"ü":[{"l":[{},[0,0,2]]},[0,0,0,0,2]]}],"l":[{"e":[{"s":[{},[0,1,2]],"t":[{},[2,1,2]]}],"m":[{},[2,1]],"ő":[{"i":[{},[0,0,2]],"n":[{},[0,0,2]]}]}],"n":[{"e":[{"k":[{"e":[{},[2]],"é":[{},[2,1,2]]}]}]}],"p":[{"a":[{"d":[{},[0,0,2]],"k":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"p":[{},[0,0,2]],"s":[{},[0,0,2,1]],"u":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2]],"z":[{},[0,0,2,1]]},[0,0,0,0,2]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]],"r":[{},[0,0,0,0,2]],"t":[{"e":[{"t":[{},[0,0,0,1]]}],"n":[{},[0,0,2,1]]}],"v":[{},[0,0,2]]}],"é":[{"s":[{},[0,0,2,1]]}],"f":[{},[0,0,0,1,2]],"í":[{},[2,0,2]],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1]],"u":[{"s":[{},[0,0,2,1]]}],"ú":[{},[0,0,2]],"ü":[{"l":[{},[2]]}]}],"r":[{"a":[{"j":[{},[0,0,2]],"n":[{},[0,0,2,1]]},[0,0,0,0,2]],"d":[{"e":[{},[2]]},[0,1]],"e":[{"m":[{},[2,1,2]]}],"é":[{".":[{},[0,0,2]],"s":[{},[0,0,2]]}],"i":[{".":[{},[0,0,2]],"n":[{},[0,0,2]],"p":[{},[0,0,2]]}],"ö":[{},[0,0,2]],"ő":[{".":[{},[2,1,2]]}],"t":[{"é":[{},[2,1]]}],"ü":[{},[0,0,2]],"z":[{},[2,1]]}],"s":[{"e":[{"l":[{},[0,0,2,1,2]]}],"é":[{"g":[{},[0,0,2,1]]}],"s":[{"z":[{"e":[{"r":[{},[0,0,0,3]]}]}]}],"z":[{"a":[{"k":[{},[0,0,0,0,1]],"l":[{},[0,0,0,0,1]]}],"á":[{},[0,0,2,0,1]],"e":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,0,1,2]],"m":[{"b":[{},[0,0,2,0,1]]}],"s":[{"z":[{},[0,0,2,0,1,2]]}]}],"é":[{"k":[{},[0,0,2,0,1]]}],"i":[{"k":[{},[0,0,2]]}],"í":[{},[0,0,2,0,1]],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2,0,1,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2,0,1]],"ü":[{"l":[{},[0,0,2]]}]}]}],"t":[{"e":[{"g":[{},[0,0,2,1]],"l":[{},[2,1,2]],"s":[{},[0,0,2,1]],"t":[{},[2,1,2]]}],"i":[{"r":[{},[0,0,2]]},[0,0,0,0,2]],"ö":[{},[0,0,2]],"r":[{},[0,0,1,2]]}],"v":[{"a":[{"d":[{"a":[{},[0,0,0,1]],"á":[{},[0,0,0,1]]}],"j":[{},[0,0,2]],"r":[{},[0,0,2]],"v":[{},[0,0,2]]},[0,0,0,0,2]],"á":[{"g":[{},[0,0,2,1]]}],"b":[{"ú":[{},[2,1]]}],"e":[{".":[{},[2,1,2]],"i":[{},[2]],"k":[{},[2,1,2]],"l":[{"e":[{},[0,0,2,1]],"ő":[{},[0,0,0,1]]},[0,0,0,0,2]],"m":[{},[2,0,2]],"n":[{"k":[{},[2]],"t":[{},[2]]}],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,0,1]]},[0,0,2]],"t":[{},[2,0,2]]}],"é":[{"b":[{},[2]],"l":[{},[0,0,2,1,2]],"r":[{"i":[{},[0,0,2,1]],"ő":[{},[0,0,2]],"z":[{},[0,0,2,1]]}]}],"i":[{"s":[{},[0,0,2]]}],"n":[{"y":[{},[2]]}],"o":[{},[0,0,2,1]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"u":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]],"ü":[{"n":[{},[0,0,2]]}]}],"z":[{"a":[{},[0,0,2]],"i":[{"u":[{"m":[{"i":[{},[0,0,0,0,0,2,1,2]]}]}]}]}]},[1]],"f":[{"e":[{"l":[{"e":[{"m":[{"é":[{},[0,0,0,2]]}]}]}]}],"l":[{"a":[{},[0,1,2]],"o":[{},[0,1,2]],"u":[{"o":[{"r":[{"e":[{},[0,0,0,0,0,0,1]]}]}]}]}],"o":[{"l":[{"t":[{"a":[{},[0,0,0,0,2]]}]}]}],"r":[{"a":[{"k":[{},[0,1,2]]}],"á":[{},[0,1,2]],"e":[{"k":[{},[0,1,2]]}],"i":[{},[0,1,2]],"í":[{},[0,1,2]],"ö":[{},[0,1,2]],"u":[{},[0,1,2]]}],"ü":[{"s":[{"t":[{"ö":[{"l":[{"é":[{},[0,0,0,0,2,1]]}]}]}]}]}]}],"g":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"d":[{"a":[{"t":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"ó":[{".":[{},[0,2]],"a":[{},[0,2]],"b":[{},[0,2]],"i":[{},[0,2]],"j":[{},[0,2]],"k":[{},[0,2]],"r":[{},[0,2]],"s":[{},[0,2]],"t":[{},[0,2]],"v":[{},[0,2]]},[0,0,1,2]]}],"k":[{"n":[{},[0,0,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]]}],"l":[{"a":[{"g":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"p":[{},[0,0,0,2]]}],"á":[{"t":[{},[0,0,1]]}],"e":[{"l":[{},[0,0,1]]}],"g":[{},[0,2,1]],"j":[{},[0,2,1]]}],"n":[{"y":[{},[0,2,1,2]]}],"p":[{},[0,0,0,1,2]],"r":[{"á":[{"n":[{},[0,2,1,2]]}],"c":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"p":[{},[0,2,1]],"s":[{"z":[{},[0,0,1]]}],"z":[{"t":[{},[0,2,1]]}]}],"t":[{"r":[{},[0,0,0,1]]}],"u":[{},[0,2,1,2]],"v":[{"a":[{},[0,2,1]]}],"z":[{"o":[{"n":[{},[0,0,0,2]]}]}]}],"á":[{"c":[{},[0,0,0,2]],"g":[{},[0,2,1,2]],"l":[{"l":[{"á":[{},[0,0,1]],"o":[{},[0,0,1]],"ó":[{},[0,0,1]]}]}],"p":[{},[0,2,1]],"r":[{"a":[{"k":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]}],"á":[{"t":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"é":[{},[0,0,0,2]],"n":[{"y":[{"a":[{},[0,2,1]]}]}],"t":[{"a":[{},[0,2,1]]}],"u":[{"k":[{},[0,0,0,2]]}],"ú":[{},[0,2,1,2]]}],"s":[{"z":[{"a":[{"i":[{"b":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}]}],"á":[{"v":[{},[0,2,1,2]]}],"é":[{},[0,2,1,2]],"i":[{".":[{},[0,2,1,2]],"g":[{},[0,2,1,2]]}],"o":[{"k":[{"é":[{},[0,2,1,2]]}],"s":[{},[0,2,1,2]]}]}]}],"t":[{"á":[{},[0,2,1]],"c":[{},[0,0,1]],"e":[{},[0,2,1,2,1,2]],"i":[{},[0,2,1,2]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"z":[{"ó":[{"j":[{},[0,2,1,2]],"s":[{},[0,2,1,2]]}],"t":[{"a":[{"t":[{"o":[{},[0,2,1]]}]}]}]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"d":[{"z":[{},[0,0,1]]}],"g":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"l":[{"a":[{},[0,2,1]],"i":[{"s":[{},[0,0,0,2]]}]}],"r":[{"a":[{},[0,0,0,2,1]],"á":[{"l":[{},[0,0,0,2]]}],"e":[{"s":[{"z":[{},[0,0,0,0,1,2]]}]}],"i":[{"m":[{},[0,0,0,0,2]]}],"o":[{},[0,0,0,2]]}],"s":[{"e":[{"m":[{},[0,2,1]]}],"z":[{"k":[{},[0,2,1]]}]}],"t":[{"i":[{"k":[{"a":[{},[0,0,0,2]]}]}]}],"x":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"l":[{"e":[{"s":[{},[0,0,0,2]]}]}],"p":[{"í":[{},[0,2,1]]}],"r":[{"c":[{},[0,2,1]],"l":[{},[0,0,1]],"ő":[{".":[{},[0,0,1,2]]}],"t":[{"é":[{},[0,0,1]]}]}],"s":[{"a":[{},[0,0,0,2]]}],"t":[{"e":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]],"y":[{"i":[{},[0,0,3]],"o":[{},[0,0,3]]}]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1,2]],"r":[{},[0,2,1]]}],"l":[{"l":[{},[0,2]]}],"m":[{"i":[{},[0,0,1]]},[0,0,0,2]],"n":[{"f":[{},[0,0,1]],"g":[{},[0,2,1]],"s":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}],"z":[{"g":[{},[0,2,1]]}]}],"í":[{"g":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"l":[{"e":[{"c":[{},[0,1]]}]}],"m":[{"e":[{"g":[{},[0,0,0,0,0,1]]}]}],"n":[{"ó":[{},[0,1,2]]}],"o":[{"f":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{"a":[{},[0,0,0,0,0,1]],"d":[{},[0,2,1]],"g":[{},[0,2,1]],"k":[{},[0,2,1]]}],"s":[{"t":[{"o":[{},[0,0,1]]}],"z":[{"t":[{},[0,0,1]]}]}],"t":[{"t":[{"h":[{},[0,2,1]]}]}]}],"ó":[{"r":[{"i":[{"á":[{},[0,0,0,2]]}]}]}],"ö":[{"b":[{},[0,2,1]],"n":[{"t":[{},[0,0,1]]}],"r":[{"ö":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]],"v":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{"ö":[{},[0,0,1]]}],"z":[{"ő":[{"s":[{},[0,0,0,2,1]]}]}]}],"p":[{"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"a":[{"m":[{},[0,1,2]]}],"á":[{"d":[{"i":[{"h":[{},[0,0,2]]}],"j":[{},[0,0,2]]}],"f":[{},[0,1,2]]}],"u":[{"n":[{},[0,0,2]]}]}],"s":[{"h":[{},[0,0,1]],"k":[{},[0,0,1]],"p":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{"d":[{},[0,2,1]]}],"r":[{"a":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,2,1]]}]}],"ú":[{"j":[{},[0,2,1]],"t":[{"t":[{},[0,0,1]]}]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,2,1]]}],"ű":[{"r":[{},[0,0,1]]}],"y":[{"a":[{"g":[{"y":[{"a":[{},[0,0,0,1,2]]}]}],"l":[{"ó":[{},[0,0,0,0,2,1,2]]}],"s":[{"s":[{},[0,0,0,1]]}]}],"á":[{"l":[{},[0,2,0,1,2]]}],"e":[{"m":[{},[0,2,0,1]],"s":[{},[0,2,0,1]],"z":[{},[0,2]]}],"é":[{"d":[{},[0,2,0,1,2]],"k":[{"s":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"r":[{".":[{},[0,0,0,1]]}]}],"i":[{"d":[{},[0,2]],"m":[{},[0,2]]}],"u":[{"t":[{},[0,2,0,1]]}],"ü":[{"l":[{"ő":[{},[0,2,0,1,2]]}]}]}]}],"h":[{"a":[{"b":[{"i":[{},[0,0,0,2,1]]}],"l":[{"k":[{},[0,0,0,0,1,2]]}],"s":[{"á":[{"b":[{"r":[{},[0,0,0,2]]}]}]}]}],"á":[{"z":[{"a":[{"l":[{"t":[{},[0,0,0,2,1]]}]}],"i":[{"p":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2]],"s":[{},[0,0,0,2,3]]}]}],"e":[{"d":[{"z":[{},[0,0,0,2,3]]}],"i":[{},[0,0,0,2]]}],"ú":[{"s":[{"á":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]]}]}]}],"i":[{"a":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"b":[{"o":[{},[0,0,2]]}],"c":[{},[0,0,2]],"d":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"f":[{"o":[{},[0,0,2]]}],"g":[{"y":[{},[0,0,2]]},[0,0,0,1,2]],"h":[{},[0,0,2]],"í":[{},[0,0,2]],"j":[{},[0,0,2]],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"m":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"p":[{},[0,0,2,1]],"r":[{},[0,0,2]],"s":[{"z":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}]}],"t":[{"o":[{},[0,0,2]],"r":[{},[0,0,2]]},[0,0,0,1,2]],"u":[{},[0,0,0,3]],"ü":[{},[0,0,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"t":[{"a":[{},[0,0,0,0,1,2]]}]}],"b":[{"o":[{},[2,1,2]],"r":[{},[0,0,1]]}],"c":[{"e":[{"l":[{},[0,0,2,1,2]]}],"h":[{"a":[{},[0,0,2]],"e":[{},[0,0,2,3]],"é":[{},[0,0,2,3]],"o":[{},[0,0,2,3]]}]}],"d":[{"e":[{".":[{},[0,0,2]],"g":[{},[2,1,2]]}],"ő":[{},[2,1,2]],"ü":[{},[0,0,2]]}],"e":[{"t":[{},[0,0,2]]}],"f":[{"j":[{},[2,1]]}],"g":[{"a":[{"l":[{},[2,1,2]],"z":[{".":[{},[2]]}]}],"á":[{},[2,1,2]],"e":[{".":[{},[0,0,2]]}],"é":[{"j":[{},[0,0,2]],"n":[{},[2,1,2]],"z":[{},[0,0,2]]}],"m":[{},[2]]}],"h":[{"l":[{},[2,1]]}],"k":[{"e":[{"b":[{},[0,0,2]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1]]}],"é":[{"r":[{"t":[{"é":[{},[0,0,2,1]]}]}]}],"k":[{},[0,0,0,0,2]],"l":[{"u":[{},[0,0,1]]}],"o":[{"n":[{"r":[{},[0,0,2]]}]}],"r":[{"i":[{"t":[{".":[{},[2,1]]}]}]}],"u":[{"d":[{},[0,0,2]]}]}],"l":[{"l":[{"e":[{},[0,1]],"u":[{},[2]]}],"y":[{},[2,1,2]]}],"m":[{"á":[{"d":[{},[2]],"é":[{},[0,1,2]]}],"p":[{},[2,1]]}],"n":[{"a":[{".":[{},[2,1,2]],"s":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}]}],"d":[{},[2]],"f":[{"o":[{},[2,1]],"ú":[{},[2,1]]}],"g":[{"a":[{"s":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2]],"e":[{".":[{},[2,1]],"i":[{},[2]],"l":[{},[0,0,0,2,1,2]]}],"ó":[{},[0,0,0,2,1,2]],"r":[{"á":[{},[0,0,0,1,2]]}],"u":[{},[0,0,0,2]],"ü":[{"k":[{},[2,1]]}]}],"i":[{"p":[{},[0,0,2,1,2]]}],"o":[{"l":[{},[0,0,2]]}],"t":[{"é":[{},[2,1]]}]}],"o":[{"n":[{"b":[{},[2,1,2]],"c":[{},[0,0,2]],"h":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{},[0,0,2]],"n":[{},[2,1,2]],"o":[{},[2,1,2]],"r":[{},[2,1,2]],"t":[{},[2,1,2]]}]}],"ó":[{"a":[{},[0,0,2]],"d":[{},[0,0,2]],"e":[{},[0,0,2]],"p":[{},[0,0,2]],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"ü":[{},[0,0,2]],"v":[{"á":[{},[0,0,0,0,0,2]]}]}],"p":[{"p":[{"i":[{},[0,0,0,2,1]]}],"r":[{},[0,0,1]]}],"r":[{"a":[{"t":[{},[0,0,2]]}],"á":[{},[2]],"é":[{"s":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"o":[{"d":[{},[2,1,2]]}],"ó":[{"n":[{},[0,0,2]]}]}],"s":[{"i":[{".":[{},[0,0,2]],"n":[{},[0,0,2,1]]}],"ü":[{"v":[{},[0,0,0,0,2]]}],"z":[{"a":[{"k":[{},[0,0,0,0,1]]}],"e":[{"g":[{},[0,0,2]],"m":[{"l":[{},[0,0,2]]}],"s":[{"e":[{},[0,0,2]]}]}],"é":[{"l":[{},[0,0,2,0,1,2]]}],"i":[{"p":[{},[0,0,2]],"s":[{},[0,0,2]]}],"o":[{"k":[{"t":[{},[0,0,0,0,1]]}],"l":[{},[0,0,0,0,1]],"n":[{},[2,1]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2,0,1]],"u":[{},[0,0,2]]}]}],"t":[{"a":[{"d":[{},[0,0,2,1,2]],"g":[{},[0,0,2,1]],"j":[{},[0,0,2,1]],"l":[{"a":[{},[0,0,0,1,2]]},[0,0,2]],"s":[{},[0,0,2,1]],"t":[{},[2,1,2]]}],"e":[{"l":[{"l":[{},[0,0,0,1]]}]}],"é":[{"p":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"i":[{"m":[{},[0,0,2]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2]]}],"o":[{"b":[{},[0,0,2]],"l":[{"d":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"s":[{"z":[{},[0,0,2,1]]}]}],"ü":[{"r":[{},[0,0,2]]}]}],"u":[{"m":[{"i":[{"o":[{},[0,0,0,2,1,2]]}]}]}],"v":[{"a":[{"d":[{},[2,1,2]],"r":[{},[2,1,2]]}],"ó":[{},[2,1,2]]}],"x":[{"a":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"z":[{"é":[{"n":[{},[0,0,2]]}],"g":[{},[2,1]],"m":[{"á":[{},[2,1]]}],"o":[{"m":[{},[0,1]]}],"s":[{"o":[{"l":[{},[0,0,2]]}]}]}]},[1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"j":[{"a":[{},[0,0,2]],"u":[{},[0,0,2]]}],"l":[{"i":[{"a":[{},[0,0,0,0,2]]}]}],"r":[{"a":[{},[0,0,2,0,2]],"á":[{},[2,1,2]],"é":[{},[0,0,2,1,2]],"o":[{"t":[{},[0,0,2,1]]}],"ó":[{},[2,1,2]],"ú":[{},[0,0,2,1]]}],"t":[{"é":[{"l":[{},[2]]}],"ő":[{"a":[{},[0,0,0,0,0,2]]}]}],"v":[{"e":[{},[0,0,2]],"i":[{},[2,1,2]]}],"z":[{"e":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[1]],"k":[{"a":[{"d":[{"ó":[{"s":[{},[0,0,1,2]]}]}],"i":[{"k":[{},[0,0,0,0,2]]}],"j":[{"t":[{},[0,0,1]]}],"k":[{"k":[{},[0,2,1]]}],"l":[{"v":[{},[0,2,1]]}],"n":[{"ó":[{},[0,2,1]],"y":[{"á":[{},[0,0,0,2]]}]}],"ó":[{},[0,0,0,0,2]],"p":[{"l":[{},[0,0,0,1,2]],"p":[{},[0,0,1]]}],"r":[{"i":[{"s":[{},[0,0,0,2]]}]}],"s":[{"k":[{},[0,0,0,1,2]],"p":[{},[0,0,0,1]]}],"t":[{"o":[{"m":[{},[0,0,0,2]]}],"r":[{},[0,0,0,1,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"g":[{},[0,2,1]],"r":[{"a":[{"d":[{},[0,0,1]]}],"á":[{"l":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}],"u":[{"k":[{},[0,0,0,2]]}]}],"s":[{"a":[{"d":[{},[0,0,0,2]],"l":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"t":[{"a":[{},[0,0,0,0,0,2]],"j":[{},[0,2,1]],"m":[{},[0,2,1]],"s":[{},[0,2,1]],"u":[{},[0,2,1]]}]}],"b":[{"r":[{},[0,0,1]]}],"c":[{"i":[{"ó":[{"s":[{"ű":[{},[0,0,0,0,2]]}]}]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"c":[{"s":[{"e":[{},[0,0,1,2]]}]}],"d":[{"z":[{},[0,0,1,2]]}],"l":[{"a":[{},[0,0,1]],"l":[{"á":[{},[0,2]]}],"t":[{"á":[{},[0,2,1]]}]}],"r":[{"a":[{},[0,0,0,2,1]],"e":[{"d":[{},[0,0,1]]}],"ő":[{},[0,2,1,2]]}],"t":[{"i":[{},[0,2,1,2]]}],"v":[{"é":[{},[0,2,1,2]]}]}],"é":[{"l":[{},[0,2,1,2]],"p":[{"e":[{"l":[{},[0,0,0,2,1]]}],"é":[{"s":[{},[0,0,0,2,1]]}],"í":[{},[0,2,1]]}],"r":[{"c":[{},[0,2,1]]}],"s":[{"z":[{"é":[{},[0,0,1,2]]}]}]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"a":[{},[0,0,0,0,2]],"á":[{},[0,0,0,0,2]],"g":[{"a":[{},[0,0,1,2]],"é":[{},[0,2,1]]}],"m":[{"i":[{},[0,2,1]]}],"n":[{"d":[{},[0,0,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2]]}],"o":[{"n":[{},[0,0,1,2]]}],"s":[{"i":[{},[0,0,0,2,1,2]],"m":[{},[0,0,1]]}]}],"k":[{"á":[{},[0,0,0,0,2]],"r":[{},[0,0,1,2]]}],"l":[{"a":[{"r":[{},[0,0,2]]}],"ó":[{},[0,1,2]]}],"o":[{"b":[{},[0,2,1]],"k":[{"e":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{"l":[{},[0,2,1]]}]}],"x":[{},[0,2,1]]}],"ó":[{"n":[{"é":[{},[0,2,1]],"i":[{},[0,2,1]]}],"p":[{},[0,0,0,1,2]],"r":[{"i":[{},[0,2,1,2]]}]}],"ö":[{"l":[{"é":[{},[0,2,1,2]],"ő":[{},[0,2,1,2]]}],"s":[{"s":[{},[0,0,1]]}],"t":[{"l":[{},[0,0,1]]}]}],"ő":[{"r":[{"s":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"c":[{},[0,0,2]]}],"i":[{"s":[{},[0,1,2]]}],"í":[{},[0,1,2]],"o":[{"m":[{"a":[{},[0,0,2]]}],"n":[{"n":[{},[0,0,0,0,0,1]]}]}]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1,0,2]]}],"u":[{"d":[{},[0,2,1]],"r":[{"a":[{},[0,2,1,2]]}],"s":[{},[0,2,1,2]],"t":[{"a":[{"l":[{},[0,0,1]]}],"á":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"ú":[{"j":[{},[0,2,1]],"s":[{},[0,2,1]]}],"ü":[{"g":[{},[0,2,1]]}]}],"l":[{"a":[{"c":[{},[0,0,0,0,1]],"p":[{"a":[{},[0,0,0,2]],"e":[{},[0,0,0,0,1]],"o":[{"s":[{"z":[{},[0,0,0,2,1]]}]}]}],"t":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1,2]]}],"e":[{},[0,0,0,2,1,2]],"é":[{"t":[{"e":[{},[0,0,0,2,1,2]]}]}]}]}],"á":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"e":[{"g":[{"á":[{},[0,0,0,2,1]]}],"í":[{},[0,0,0,0,2]],"t":[{"o":[{},[0,0,0,2,1]],"ü":[{"z":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}]}],"é":[{"t":[{"é":[{"s":[{},[0,0,0,2]],"v":[{"e":[{".":[{},[0,0,0,2,1,2]]}]}]}]}]}]}],"m":[{"e":[{"g":[{"a":[{},[0,0,0,2,1,2]],"é":[{},[0,0,0,2,1]]}]}],"ű":[{"é":[{"n":[{},[0,0,0,0,2]]}],"t":[{},[0,0,0,0,2]]}]}],"n":[{"a":[{"i":[{"é":[{},[0,0,0,2]]}],"k":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"l":[{"v":[{},[0,0,1]]}],"p":[{"r":[{"é":[{},[0,0,0,1,2]]}]}],"s":[{},[0,0,0,1,2]]}],"á":[{"l":[{"l":[{},[0,0,1]]}]}],"e":[{"m":[{"l":[{},[0,2,1]]}],"p":[{"a":[{},[0,0,0,2,1,2]]}],"s":[{"e":[{},[0,0,0,2]],"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"t":[{"e":[{"t":[{},[0,2,1,2]]}],"t":[{},[0,2,1]]}],"v":[{"e":[{"z":[{},[0,0,1]]}]}]}],"é":[{"g":[{"e":[{"t":[{},[0,0,0,2]]}]}],"r":[{"i":[{},[0,0,1]]}]}],"i":[{"d":[{},[0,2,1]],"r":[{"t":[{},[0,0,1]]}]}],"o":[{"r":[{"s":[{},[0,0,1]]}]}],"ő":[{"é":[{"h":[{},[0,0,0,0,2]],"n":[{},[0,0,0,0,2]]}]}],"s":[{"y":[{},[0,0,1]]}],"u":[{"g":[{},[0,2,1]]}],"ú":[{"s":[{},[0,0,1,2]]}],"ü":[{"c":[{},[0,2,1,2]],"l":[{"ő":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]]}],"y":[{"a":[{"k":[{},[0,3]],"l":[{"á":[{},[0,3]]}],"n":[{},[0,0,0,1,2]],"r":[{},[0,3]]}],"á":[{"r":[{},[0,0,0,0,2]],"z":[{},[0,0,0,1]]}],"d":[{"r":[{},[0,3]]}],"e":[{"l":[{"l":[{},[0,0,0,1]],"ő":[{},[0,3]],"t":[{},[0,0,0,1]],"v":[{"á":[{},[0,0,0,1]],"e":[{"z":[{},[0,0,0,1]]}]}]}],"s":[{"e":[{"t":[{"t":[{},[0,0,0,1,2]]}]}],"é":[{"s":[{},[0,0,0,1,2]]}],"ő":[{},[0,0,0,1,2]]}]}],"é":[{"g":[{},[0,0,0,1]],"k":[{"é":[{},[0,0,0,1,2]],"i":[{},[0,0,0,1,2]]}]}],"i":[{"é":[{"h":[{},[0,0,0,0,0,2]],"n":[{"e":[{},[0,0,0,0,0,2]]}]}],"g":[{"é":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"j":[{"é":[{},[0,3]]}],"o":[{"l":[{"d":[{},[0,0,0,1]]}],"n":[{},[0,0,0,1]]}],"ö":[{"z":[{},[0,0,0,1]]}],"s":[{"t":[{},[0,3]]}]},[0,2]]}],"o":[{"d":[{"r":[{"á":[{},[0,0,1,2]]}],"ú":[{},[2,1,2]]}],"g":[{".":[{},[2]],"h":[{},[2]],"j":[{},[2]],"n":[{},[2]],"o":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]]}],"i":[{"r":[{},[0,0,2]]}],"k":[{"a":[{"l":[{"a":[{},[0,0,0,1]]},[2]],"r":[{},[0,0,2,1,2]],"u":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]]}],"é":[{"l":[{},[0,0,2,1,2]],"p":[{},[0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,2,1]]}],"s":[{"t":[{},[0,0,0,1]]}]}],"k":[{"e":[{},[2,1]]},[0,0,0,1,2]],"o":[{"z":[{},[2,1,2]]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"r":[{"o":[{},[0,0,1,2]]}],"s":[{"z":[{},[0,0,0,0,0,2]]},[0,0,0,1]],"u":[{"r":[{},[0,0,2]]}],"ú":[{"r":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"l":[{"a":[{},[2,1,2]],"f":[{},[0,0,0,1,2]],"i":[{"m":[{},[2,1,2]]}],"l":[{"ó":[{},[2,1]]}],"y":[{},[2,1,2]]}],"m":[{"a":[{"c":[{},[0,0,2,1,2]]}],"p":[{},[0,0,0,1]]}],"n":[{"a":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]],"c":[{"c":[{},[0,0,0,0,3]],"h":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,0,3]]}]}],"e":[{},[0,0,2,1]],"k":[{},[0,0,0,1,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{},[0,0,0,1,2]],"y":[{},[0,0,1]]}],"o":[{"k":[{},[0,0,2]]}],"p":[{"e":[{},[2,1,2]],"l":[{"a":[{},[0,0,1,2]]}]}],"r":[{"a":[{"l":[{},[0,0,2,1]],"t":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"e":[{"l":[{},[0,0,2,1]]}],"i":[{"v":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"m":[{"o":[{},[2,1]]}],"r":[{"é":[{},[2,1]]}],"s":[{},[0,0,0,1,2]],"ü":[{},[0,0,2]],"v":[{"o":[{},[2,1]]}]}],"s":[{"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2]],"s":[{"z":[{"e":[{},[0,0,0,3]],"f":[{},[0,0,0,3]],"i":[{},[0,0,0,3]]},[0,0,0,0,0,2]]}],"t":[{"a":[{"b":[{},[0,0,1,2]]}]}],"z":[{"a":[{"u":[{},[0,0,0,0,0,2]]}],"f":[{},[0,0,1,0,2]],"l":[{},[2]]}]}],"t":[{"r":[{},[0,0,1,2]],"t":[{"h":[{},[2,1]]}],"y":[{},[0,0,1]]}],"u":[{"i":[{},[0,0,2]]}],"v":[{"i":[{".":[{},[2,1,2]]}]}],"x":[{"i":[{},[0,0,2]]}]},[1]],"ó":[{"a":[{"k":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]}],"c":[{"e":[{},[0,0,2]],"h":[{},[0,0,2]]}],"d":[{"a":[{".":[{},[0,0,2]],"n":[{},[0,0,2,1,2]]}],"á":[{"k":[{},[0,0,2]]}],"e":[{"s":[{},[0,0,2,1,2]]}],"i":[{"s":[{},[0,0,2,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1,2]]}],"m":[{"a":[{"c":[{},[0,0,2]]}],"e":[{"m":[{},[0,0,2,1]]}],"i":[{"k":[{},[0,0,2]]}],"u":[{"t":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,2]]}],"n":[{"i":[{"b":[{},[0,0,2]]}],"o":[{"n":[{},[0,0,2]]}]}],"p":[{"r":[{},[0,0,1,2]]}],"r":[{"a":[{"c":[{},[0,1,2]],"d":[{},[0,0,2,1]],"f":[{},[0,1,2]],"i":[{},[2,1,2]],"l":[{},[0,0,2,1,2]],"r":[{},[0,1,2]],"s":[{},[0,1,2]],"t":[{},[0,1,2]]}],"á":[{"d":[{"i":[{},[0,0,0,0,0,0,2]]}],"s":[{},[0,0,2]]}],"i":[{"á":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"s":[{"a":[{"k":[{"k":[{},[0,0,0,1]]}]}],"e":[{"g":[{},[0,0,2]]}],"l":[{},[0,0,1]],"p":[{},[0,0,1,2]],"r":[{"á":[{},[0,0,1,2]]}],"s":[{},[0,0,0,3]],"t":[{"a":[{},[0,0,1,2]]}],"z":[{"e":[{"n":[{"e":[{},[0,0,0,3]],"é":[{},[0,0,0,3]]}]}]},[0,0,1,0,2]]}],"t":[{"a":[{"l":[{"a":[{},[0,0,0,1]]}]}],"i":[{"l":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,1]]}]}],"v":[{"ó":[{},[0,0,2]]}]},[1]],"ö":[{"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"l":[{},[0,0,2,1]],"t":[{"i":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"é":[{"j":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"r":[{".":[{},[0,0,2,1]],"i":[{},[0,0,2,1]],"t":[{"é":[{},[0,0,2,1]]}]}]}],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"l":[{"e":[{},[0,1,2]],"é":[{},[0,1,2]],"ő":[{},[0,0,2]]}],"m":[{"l":[{},[0,1]]}],"n":[{"ö":[{},[2,1,2]],"z":[{},[2,1]]}],"r":[{"ö":[{},[0,0,2]]}],"s":[{"s":[{"z":[{},[2,1]]}],"z":[{},[2,1,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"l":[{},[0,1]],"t":[{},[0,0,0,1,2]],"ü":[{},[0,0,2]]}],"v":[{".":[{},[2,1]],"b":[{},[0,1]],"e":[{".":[{},[0,1,2]]}],"ö":[{"n":[{},[0,0,2]]}],"r":[{},[2,1]]}],"z":[{"ö":[{"n":[{},[2,1,2]]}]}]},[1]],"ő":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"á":[{"g":[{},[0,0,0,2]]}],"b":[{"r":[{},[0,0,1]]}],"c":[{"a":[{},[0,0,2]],"h":[{},[0,0,2]],"s":[{"á":[{"r":[{},[0,0,2]]}],"ő":[{"s":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}]}],"e":[{"r":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2]]}],"f":[{"é":[{"l":[{"é":[{},[0,0,0,0,2,1,2]]}]}]}],"k":[{"l":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{".":[{},[2,1]],"a":[{"n":[{},[2,1,2,1]],"s":[{},[2,1]]}],"b":[{},[2,1]],"c":[{},[2,1]],"e":[{"i":[{},[2,1,2]]}],"é":[{"h":[{},[2,1,2]],"n":[{},[2,1,2]],"t":[{".":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"v":[{},[2,1,2]]}],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{},[2,1,2]],"k":[{},[2,1]],"l":[{},[2,1]],"n":[{},[2,1]],"ö":[{},[2,1,2]],"r":[{},[2,1]],"s":[{},[0,1]],"t":[{},[2,1]],"ü":[{"l":[{},[0,0,2]],"n":[{},[0,0,2]]},[2,1]],"v":[{},[2,1]],"z":[{},[2,1]]}],"s":[{"a":[{"l":[{},[0,0,2,1,2]]}],"e":[{"l":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,2,1,2]]}],"o":[{"k":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,1]]}],"s":[{},[0,0,0,3]],"z":[{"t":[{},[0,0,1,0,2]]}]}],"t":[{"r":[{},[0,0,1,2]],"t":[{"i":[{"n":[{},[0,0,0,2]]}]}]}],"u":[{"t":[{},[0,0,0,2]]}],"ü":[{"l":[{},[0,0,0,2]]}]},[1]],"p":[{"a":[{"d":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"e":[{"s":[{"z":[{},[0,0,0,0,0,1]]},[0,0,0,2]]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"o":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"o":[{"n":[{"t":[{"a":[{},[0,0,0,0,2,1,2]]}]}],"r":[{"a":[{},[0,0,0,2,1]]}]}],"r":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"u":[{"t":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1,2]],"e":[{},[0,0,0,2,1,2]],"i":[{},[0,0,0,2,1]]}]}]}],"r":[{"e":[{"f":[{"l":[{"e":[{"x":[{"í":[{},[0,0,0,0,0,0,2,1,2]]}]}]}]}],"n":[{"d":[{"a":[{},[0,0,0,0,2]]}]}]}]}],"s":[{"a":[{"d":[{},[0,2,1,2]],"k":[{"c":[{},[0,2,1]]}],"l":[{"k":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1,2]]}],"s":[{"s":[{},[0,0,1]]}],"u":[{},[0,2,1]],"v":[{"á":[{"r":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"i":[{"l":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}]}],"z":[{},[0,2,1,2]]}],"á":[{"g":[{"g":[{},[0,0,0,0,1]]}],"l":[{"l":[{},[0,0,1]]}],"r":[{"a":[{"k":[{},[0,2,1,2]]}]}],"t":[{"a":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"c":[{"h":[{"e":[{".":[{},[0,0,0,3]],"i":[{},[0,0,0,3]]}],"é":[{},[0,0,0,3]]},[0,0,2]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"l":[{"é":[{},[0,0,1,2]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1]],"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"n":[{"e":[{},[0,2,1]]}],"s":[{"z":[{},[0,2,1]]}]}],"é":[{"g":[{"e":[{"l":[{},[0,0,0,2]]}],"é":[{"j":[{},[0,0,0,2,1]]}],"ü":[{"k":[{"é":[{"t":[{},[0,0,0,0,0,2]]}]}]}]}],"k":[{},[0,2,1]],"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"v":[{"e":[{".":[{},[0,0,1,2]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"m":[{"p":[{},[0,0,1]]}],"n":[{"f":[{},[0,0,1]],"g":[{},[0,2,1]]}],"r":[{"ó":[{},[0,2,1]]}],"s":[{"k":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]]},[0,0,0,2]]}],"í":[{"r":[{},[0,2,1,2]],"v":[{},[0,2,1,2]]}],"k":[{"á":[{"l":[{},[0,1,2]]}],"l":[{},[0,0,1]]}],"o":[{"b":[{},[0,2,1]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"s":[{"z":[{},[0,0,1]]}],"t":[{"t":[{},[0,2,1]]}]}],"ó":[{"r":[{},[0,2,1,2]]}],"ö":[{"s":[{},[0,2,1]]}],"p":[{"e":[{"c":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"o":[{"r":[{},[0,0,2]]}]}],"r":[{"á":[{},[0,1,2]]}],"s":[{"t":[{},[0,0,1]],"y":[{},[0,0,1]],"z":[{"e":[{"r":[{},[0,0,3]]}],"i":[{},[0,0,3]],"o":[{},[0,0,3]],"ö":[{},[0,0,3]]}]}],"t":[{"a":[{"b":[{},[0,1,2]]}],"á":[{"c":[{},[0,1,2]]}],"e":[{"i":[{},[0,0,0,0,2]]}],"i":[{"m":[{},[0,1,2]]}],"o":[{"p":[{},[0,0,2]]}]}],"u":[{"r":[{"a":[{},[0,0,1]]},[0,0,0,2]],"t":[{},[0,2,1,2]]}],"ú":[{"r":[{},[0,0,1]]}],"z":[{"a":[{"d":[{},[0,2,0,1,2]],"k":[{"ü":[{},[0,0,0,0,2,1]]}],"l":[{"k":[{},[0,0,0,1]]}],"n":[{},[0,2,0,1,2]],"r":[{"á":[{},[0,0,3]]}]}],"á":[{"b":[{"a":[{".":[{},[0,2,0,1,2]]}]}],"r":[{"á":[{},[0,0,3]],"u":[{},[0,0,0,1,2]]}]}],"i":[{"t":[{},[0,2,0,1]],"z":[{},[0,2]]}],"o":[{"m":[{"m":[{},[0,2,0,1]]}]}],"p":[{},[0,0,0,1,2]],"u":[{"t":[{},[0,2]]}],"ü":[{"z":[{},[0,2,0,1,2]]}],"z":[{},[0,0,0,1]]}]}],"t":[{"a":[{"b":[{"l":[{"a":[{},[0,0,1]]}],"r":[{},[0,2,1]]}],"c":[{"é":[{"l":[{},[0,0,0,2]]}]}],"d":[{"ó":[{},[0,0,1,2]]},[0,0,0,0,2]],"g":[{"a":[{".":[{},[0,0,1,2]]}],"g":[{},[0,2,1]],"y":[{"u":[{},[0,0,0,2]],"ú":[{},[0,0,0,2]]}]}],"i":[{"k":[{},[0,0,0,0,2]]}],"j":[{"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"k":[{"c":[{},[0,2,1]],"t":[{"á":[{},[0,2,1]]}]}],"l":[{"á":[{"t":[{},[0,0,1]]}],"e":[{"l":[{},[0,0,1]]}],"f":[{},[0,2,1]]}],"n":[{"t":[{"a":[{},[0,0,1]]}]}],"r":[{"a":[{".":[{},[0,0,1,2]],"n":[{},[0,0,0,2]]}],"á":[{},[0,2,1,2]],"c":[{},[0,2,1]],"k":[{},[0,2,1]]}],"s":[{"p":[{},[0,0,0,1,2]],"s":[{"z":[{},[0,0,1]]}]}],"t":[{"y":[{},[0,2,1]]}],"u":[{"r":[{"a":[{},[0,0,1,2]]}]}],"ü":[{},[0,0,0,0,2]],"z":[{"o":[{},[0,2,1]]}]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"c":[{"s":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,0,2,1,2]],"m":[{},[0,2]]}],"á":[{"v":[{},[0,0,0,2]]}],"n":[{"y":[{},[0,0,1]]}],"u":[{"k":[{},[0,0,0,2]]}]}],"s":[{"ó":[{},[0,2,1]],"v":[{"á":[{},[0,2,1]]}]}],"t":[{"i":[{},[0,2,1]],"l":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"v":[{},[0,2,1]]}],"z":[{"s":[{"i":[{},[0,0,0,2]]}]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"b":[{"e":[{},[0,0,1]]}],"d":[{"é":[{"n":[{},[0,2]]}],"i":[{},[0,0,1]]}],"g":[{"á":[{},[0,0,0,3]]}],"l":[{"a":[{},[0,2,1]],"b":[{},[0,2,1]],"e":[{"m":[{"é":[{},[0,0,0,0,0,2]]}]}],"f":[{},[0,0,1]],"j":[{"á":[{},[0,2,1]]}],"k":[{},[0,2,1]],"l":[{"e":[{"n":[{},[0,2,1]]}]}],"m":[{"é":[{"l":[{},[0,2]]}]}],"n":[{"ö":[{},[0,2]]}],"o":[{},[0,2,1,2]],"ő":[{"á":[{},[0,0,0,2]]}],"r":[{},[0,2,1]],"t":[{"o":[{},[0,2,1]]}],"v":[{"á":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}],"e":[{"l":[{},[0,2,1,2]]}],"l":[{},[0,2,1]],"u":[{},[0,2,1]]}],"n":[{"d":[{"r":[{},[0,2,1]]}],"t":[{},[0,2,1]]}],"r":[{"á":[{"l":[{},[0,0,0,2]]}],"e":[{"l":[{"e":[{},[0,0,0,2]]}]}],"i":[{"n":[{},[0,0,0,2,1]]}],"v":[{"e":[{"l":[{},[0,0,0,0,2,1,2]]}]}],"z":[{},[0,2,1]]}],"s":[{"t":[{"h":[{},[0,2,1]]}],"z":[{"k":[{},[0,2,1]]}]}],"v":[{"a":[{},[0,2,1]],"e":[{"t":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}]}]}],"é":[{"g":[{".":[{},[0,0,1]],"é":[{},[0,0,1,2]]}],"k":[{"e":[{"k":[{},[0,2,1,2]],"s":[{},[0,0,0,2]]}],"é":[{},[0,0,0,2]],"s":[{},[0,2,1]]}],"l":[{"e":[{},[0,2,1,2]],"é":[{"s":[{},[0,2,1,2]]}],"m":[{},[0,2,1]],"t":[{},[0,2,1]],"ű":[{},[0,0,1]]}],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]]}]}]}],"p":[{"ü":[{},[0,2,1]]}],"r":[{"i":[{"n":[{},[0,2,1]]}],"m":[{"é":[{},[0,2,1]]}],"t":[{"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"e":[{"r":[{},[0,0,0,2]]}]}],"v":[{"e":[{"n":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"é":[{"b":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"h":[{},[0,0,1]],"k":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"o":[{"n":[{},[0,0,2]]}]}],"i":[{"a":[{"n":[{},[0,0,0,0,2]],"t":[{},[0,0,0,0,2]]}],"d":[{"o":[{},[0,0,1]]}],"g":[{"e":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,0,1,2]]}],"l":[{"l":[{"á":[{"t":[{".":[{},[0,0,0,0,2]]}]}],"e":[{},[0,2,1]]}]}],"m":[{"p":[{},[0,2,1]]}],"n":[{"f":[{"o":[{},[0,2,1]]}],"g":[{".":[{},[0,2,1]],"a":[{},[0,2,1]]}],"k":[{".":[{},[0,0,0,1]]}],"t":[{"é":[{},[0,2,1]]}]}],"ó":[{},[0,0,0,0,1]],"p":[{"a":[{"r":[{},[0,0,0,2]]}]}],"r":[{"á":[{},[0,2,1]],"o":[{},[0,2,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}]}],"v":[{"á":[{"s":[{},[0,0,0,2]]}]}],"z":[{"o":[{},[0,0,1]]}]}],"í":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{"á":[{},[0,0,1]]}],"v":[{"b":[{},[0,2,1]]}],"z":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"f":[{},[0,2,1]],"k":[{"a":[{"l":[{},[0,2,1,2,1]]},[0,0,0,0,0,2]],"l":[{},[0,2,1]]}],"l":[{"d":[{"a":[{},[0,2,1]],"ó":[{},[0,2,1]]}],"y":[{},[0,2,1,2]]}],"m":[{"e":[{},[0,0,0,2,1,2]]}],"p":[{"c":[{},[0,0,1]]}],"r":[{"a":[{"s":[{},[0,0,0,2]]}],"é":[{"k":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"m":[{"á":[{},[0,0,1]]}],"r":[{"o":[{},[0,0,1]]}]}],"s":[{"z":[{"l":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"t":[{"t":[{"h":[{},[0,2,1]]}]}]}],"ó":[{"p":[{},[0,0,0,1]],"r":[{"á":[{},[0,2,1,2]],"i":[{},[0,2,1,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ö":[{"k":[{"l":[{},[0,0,1]],"ö":[{},[0,0,1,2]]}],"l":[{"ő":[{},[0,0,1,2]]}],"n":[{"t":[{},[0,0,1]]}],"r":[{"d":[{},[0,2,1]]}]}],"ő":[{"a":[{},[0,0,0,0,2]],"é":[{"n":[{},[0,0,0,0,2]]}],"r":[{"b":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"n":[{"s":[{"z":[{"k":[{},[0,0,0,0,0,0,0,0,2]]},[0,0,0,0,0,0,0,1]]},[0,0,2]]}]}],"é":[{"f":[{},[0,1,2]]}],"ó":[{"f":[{},[0,1,2]]}],"y":[{},[0,0,1]]}],"s":[{"h":[{},[0,0,1]],"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{"á":[{"m":[{"é":[{},[0,0,0,0,0,2,1]]}]}],"v":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"d":[{"v":[{},[0,2,1]]}],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"m":[{"o":[{"r":[{},[0,0,0,2]]}]}],"n":[{"a":[{},[0,2,1]],"d":[{},[0,0,1]],"i":[{},[0,0,0,0,1]]},[0,0,0,2]],"r":[{"á":[{},[0,0,1,2]]}],"s":[{"z":[{"a":[{},[0,0,0,2]]}]}],"t":[{"á":[{},[0,0,1]]}]}],"ú":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{"a":[{"l":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}]}],"s":[{"z":[{},[0,0,1,2]]}]}],"ü":[{"g":[{},[0,2,1]],"l":[{"ő":[{},[0,2,1,2]],"t":[{},[0,0,1]]}],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"y":[{"a":[{"l":[{},[0,2,0,1,2]],"n":[{},[0,2,0,1,2]]}],"á":[{"l":[{},[0,2]]}],"e":[{"l":[{},[0,2,0,1,2]]}],"é":[{"l":[{},[0,2,0,1]]}],"i":[{"k":[{},[0,2,0,1]],"n":[{"t":[{},[0,2,0,1]]}],"v":[{},[0,2,0,1]]}],"í":[{},[0,2]],"ő":[{"r":[{},[0,2,0,1,2]]}],"u":[{"t":[{},[0,2]]}]}]}],"u":[{"c":[{"c":[{},[0,1]]}],"g":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]]}],"j":[{"j":[{},[2,1]]}],"k":[{"l":[{"a":[{},[0,0,1,2]],"u":[{},[0,0,1]]}]}],"m":[{"ü":[{},[0,0,2]]}],"n":[{"d":[{},[2,1]],"i":[{},[2,1,2]],"o":[{},[2,1,2]],"t":[{},[2,1]]}],"r":[{"a":[{"m":[{},[0,0,2]]}],"á":[{},[0,0,2]]}],"s":[{"a":[{"l":[{},[0,0,2]],"s":[{},[0,0,2]],"v":[{},[0,0,2,1]]}],"e":[{},[0,0,2,1]],"é":[{"r":[{"t":[{"é":[{},[0,0,2,1]]}]}]}],"i":[{"k":[{},[0,0,2]]}],"o":[{"l":[{},[0,0,2]]}],"p":[{"o":[{},[0,0,1,2]]}],"s":[{"z":[{"i":[{},[0,0,0,3]]}]},[0,0,0,0,2]],"z":[{"a":[{"b":[{},[0,0,2]],"v":[{},[0,0,2,3]]}],"i":[{"r":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2,0,1]]}]}]}],"t":[{"a":[{"l":[{},[0,0,2]],"t":[{},[0,0,2]],"z":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2]]}]},[1]],"ú":[{"j":[{"d":[{},[0,1]],"í":[{},[0,0,2]],"s":[{},[2,1]]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,1]]}]}]}],"p":[{"r":[{},[0,0,1]]}],"r":[{".":[{},[2,1]],"b":[{},[2,1]],"h":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]],"t":[{},[2,1]]}],"s":[{"z":[{"á":[{},[2,1,2]]}]}],"t":[{"b":[{},[2]],"h":[{},[2]],"j":[{},[2]],"k":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2]],"s":[{},[2,1]],"t":[{},[2]],"v":[{},[2,1]]}]},[1]],"ü":[{"b":[{"l":[{},[0,0,1]]}],"d":[{"í":[{},[2,1,2]],"v":[{},[2,1]]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"g":[{},[2,1]],"r":[{},[0,0,1]],"y":[{".":[{},[2,1]],"b":[{},[2,1]],"c":[{},[2,1]],"e":[{".":[{},[2,1,2]],"i":[{},[2,1,2]],"k":[{},[2,1,2]],"s":[{},[2,1,2]],"t":[{},[2,1,2]]}],"é":[{"s":[{},[0,0,0,0,1]]},[2,1,2]],"h":[{},[2,1]],"i":[{},[2,1,2]],"k":[{},[2,1]],"l":[{},[2,1]],"n":[{},[2,1]],"r":[{},[2,1]]}]}],"l":[{"d":[{},[2,1]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"í":[{},[0,0,2]]}],"s":[{"t":[{"r":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"e":[{"m":[{},[2,1,2]]}],"é":[{"s":[{},[0,0,2]]}],"i":[{},[0,0,2]],"ő":[{".":[{},[0,0,2]],"k":[{},[0,0,2]],"s":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"v":[{"ö":[{},[0,0,2]]}],"z":[{"é":[{},[0,0,2]],"l":[{},[2,1]]}]},[1]],"ű":[{"z":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[1]],"v":[{"a":[{"s":[{"u":[{},[0,0,0,2]]}]}],"á":[{"g":[{"y":[{"a":[{"d":[{"a":[{},[0,0,0,2,0,1]]},[0,0,0,0,0,0,2]]}],"ó":[{"n":[{},[0,0,0,2,0,1]]}]}]}],"r":[{"a":[{"l":[{},[0,0,0,2,1]]}]}],"t":[{},[0,2,1]]}],"e":[{"n":[{"t":[{"a":[{},[0,0,0,0,2]]}]}]}],"é":[{"d":[{"a":[{},[0,0,0,2,1]],"ő":[{"r":[{},[0,0,0,2,1,2]]}]}]}],"i":[{"n":[{"d":[{},[0,0,1]]}]}],"o":[{"n":[{"a":[{"l":[{"ú":[{"t":[{},[0,0,0,0,0,2,1]]}]}]}]}],"s":[{},[0,2,1]]}],"s":[{"k":[{},[0,0,1]]}]}],"x":[{"a":[{"r":[{},[0,0,1]]}]}],"y":[{"a":[{"b":[{"l":[{},[2,0,1]],"r":[{},[2,0,1]]}],"c":[{"é":[{"l":[{},[0,0,0,2]]}]}],"d":[{"a":[{"g":[{},[2,0,1]]}],"á":[{"s":[{},[2]]}],"ó":[{"z":[{},[0,0,0,2]]},[2]]}],"f":[{"f":[{},[2]]}],"g":[{"a":[{"r":[{},[0,0,0,2]]}],"á":[{"h":[{},[2]],"r":[{},[2]],"v":[{},[2]]}],"c":[{},[2]],"e":[{"n":[{},[0,0,0,2]]}],"i":[{},[2]],"j":[{},[2]],"m":[{},[2]],"o":[{"s":[{},[2]]}],"t":[{"a":[{},[2]]}],"u":[{"k":[{},[2]]}],"ú":[{},[2]]}],"j":[{"á":[{"n":[{},[2]]}],"k":[{},[2]],"t":[{},[2]]}],"k":[{".":[{},[3]],"a":[{"l":[{"a":[{},[0,0,0,2,1]]}],"r":[{"a":[{},[0,0,0,2]]}]}],"c":[{},[2]],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"k":[{},[0,0,0,2,1,2]]}],"i":[{"z":[{},[0,0,0,2]]}],"t":[{".":[{},[2]],"á":[{},[2]],"b":[{},[2]],"i":[{},[2]],"j":[{},[2]],"o":[{},[2]],"u":[{},[2]]}]}],"l":[{"a":[{"g":[{},[2,0,1,2]],"k":[{".":[{},[2,0,1,2]],"j":[{},[2]],"k":[{},[2]],"r":[{},[2,0,1,2]]}],"n":[{"y":[{},[2]]}],"p":[{"b":[{},[0,0,0,2]],"h":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"p":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}]}],"á":[{"s":[{"z":[{},[2,0,1]]}]}],"b":[{},[2,0,1]],"é":[{"p":[{},[0,0,1]]}],"m":[{},[2,0,1]],"t":[{"e":[{},[0,0,1]],"ú":[{},[2]]}]}],"m":[{"a":[{"l":[{},[2]]}]}],"n":[{"a":[{"l":[{},[2]]}],"g":[{},[2]],"t":[{},[2,0,1]]}],"o":[{"t":[{},[2]]}],"p":[{"a":[{"d":[{},[0,0,1,2]]}],"á":[{"t":[{},[0,0,0,2]]}],"p":[{},[2]]}],"r":[{"é":[{"n":[{},[0,0,0,2]]}],"m":[{"a":[{},[2,0,1]]}],"z":[{},[2,0,1]]}],"s":[{"p":[{},[0,0,0,1]],"s":[{"z":[{},[2]]}],"z":[{"t":[{},[2]]}]}],"t":[{"k":[{"á":[{},[2]]}],"r":[{"á":[{},[0,0,0,1]]}],"y":[{},[2]]}],"u":[{"k":[{},[2]]}],"v":[{"a":[{"t":[{},[2]]}]}]},[1]],"á":[{"b":[{"r":[{},[2]]}],"d":[{"n":[{"á":[{},[2]]}],"t":[{},[2]]}],"é":[{"k":[{},[2]]}],"g":[{},[2,0,1]],"l":[{"d":[{},[2]],"l":[{"í":[{},[2]]}],"o":[{"m":[{},[0,0,0,2]]}]}],"m":[{"é":[{"k":[{},[2]]}],"n":[{"á":[{},[2]]}]}],"p":[{},[2]],"r":[{"a":[{"d":[{},[2,0,1,2]],"i":[{},[2,0,1,2]],"k":[{},[2,0,1,2]],"m":[{},[2,0,1,2]],"s":[{},[2]],"t":[{},[2,0,1,2]]}],"á":[{"b":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"t":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"c":[{},[2]],"e":[{},[2]],"h":[{},[2]],"j":[{},[2,0,1]],"k":[{},[2]],"p":[{},[2]],"t":[{".":[{},[3]]}],"u":[{},[2,0,0,2]],"ú":[{},[2]],"v":[{},[2]]}],"s":[{"ó":[{},[2]],"z":[{"a":[{"k":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2]]}]}]}],"t":[{"a":[{},[2]],"á":[{},[2]],"é":[{},[2]],"f":[{},[2]],"h":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2]],"ö":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"ü":[{},[2]],"v":[{},[2]]}]},[1]],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"v":[{},[0,0,1]]}],"d":[{"r":[{"e":[{".":[{},[1]]}]}]}],"e":[{"d":[{"é":[{"n":[{},[2]]}],"z":[{"é":[{},[2]]}]}],"f":[{"f":[{},[2]]}],"g":[{"y":[{"l":[{},[2]],"s":[{},[2]]}]}],"k":[{"e":[{".":[{},[2]],"i":[{},[2]]}],"é":[{"é":[{},[2]]}]}],"l":[{"b":[{},[2,0,1]],"c":[{},[2]],"e":[{"f":[{},[2]],"m":[{"z":[{},[2]]}]}],"f":[{},[2,0,1]],"h":[{"a":[{},[0,0,1]]}],"j":[{"á":[{},[2]]}],"k":[{},[0,0,1]],"l":[{"á":[{},[2,0,1]]}],"m":[{"a":[{},[0,0,1]]}],"n":[{"ö":[{},[2]]}],"ő":[{"í":[{},[2]],"ő":[{},[2,0,1,2]],"z":[{},[2]]}],"r":[{},[2,0,1]],"s":[{"ő":[{},[2]]}],"t":[{"á":[{},[2,0,1]],"é":[{"r":[{},[2]]}],"o":[{},[2]]}],"ü":[{"l":[{},[2,0,1]]}],"v":[{"e":[{"s":[{"z":[{},[0,0,0,0,2]]}],"v":[{},[2]]}]}]}],"m":[{"b":[{"e":[{"r":[{},[2]]}],"l":[{},[2]],"r":[{},[2]]}],"e":[{"l":[{},[2]]}],"i":[{"t":[{},[2,0,1]]}],"l":[{},[2,0,1]]}],"n":[{"c":[{},[2]],"e":[{},[2]],"g":[{},[2,0,1]]}],"p":[{},[0,0,0,1]],"r":[{"d":[{"ő":[{},[2]]}],"e":[{"j":[{},[2]],"k":[{"l":[{},[0,0,0,2]]}]}],"k":[{},[2,0,1]],"n":[{"y":[{},[2]]}],"ő":[{"m":[{},[2]]}]}],"s":[{"e":[{"m":[{"é":[{},[2,0,1]]}],"r":[{},[0,0,1]],"t":[{"é":[{},[2]]}]}],"é":[{"l":[{},[2]]}],"t":[{"j":[{},[2]]}],"z":[{"k":[{},[2]]}]}],"t":[{"i":[{"k":[{},[2]]}]}],"v":[{"e":[{"z":[{},[0,0,0,2]]},[2]],"é":[{},[2]],"o":[{},[2]],"ő":[{},[2]]}],"x":[{},[2,0,1]],"z":[{"r":[{},[2]],"ü":[{"s":[{},[2]]}]}]},[1]],"é":[{"b":[{"r":[{},[2,0,1]]}],"h":[{"e":[{"n":[{},[2]],"s":[{},[2]]}],"s":[{},[2]]}],"j":[{"e":[{"k":[{},[0,0,1,2]]}]}],"l":[{"e":[{"t":[{},[2]]}],"m":[{},[2]]}],"n":[{"e":[{"k":[{"e":[{},[2]],"é":[{},[2,0,1,2]],"n":[{},[2,0,1,2]]}]}]}],"p":[{},[2,0,1]],"r":[{"c":[{".":[{},[2]]}],"e":[{"m":[{".":[{},[2]]}],"s":[{},[0,0,0,2,1,2]]}],"i":[{"n":[{},[2]]}],"ő":[{".":[{},[2]],"i":[{},[2]],"t":[{},[2]]}],"t":[{"é":[{"k":[{},[2]]}]}],"ü":[{},[0,0,0,0,0,2]],"v":[{".":[{},[2]]}],"z":[{"é":[{},[2]]}]}],"t":[{"e":[{"l":[{},[2]]}],"k":[{"e":[{},[2]]}],"l":[{},[2]]}],"v":[{".":[{},[2]],"b":[{},[2]],"e":[{".":[{},[2]],"i":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2]],"s":[{},[2]],"t":[{},[2]],"z":[{},[2]]}],"é":[{"b":[{},[2]],"r":[{},[2]],"t":[{},[2]],"v":[{},[2]]}],"f":[{},[2]],"i":[{},[2]],"k":[{},[2]],"m":[{},[2]],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"ü":[{},[2]],"ű":[{},[2]],"v":[{},[2]]}]},[1]],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"b":[{"o":[{},[2]]}],"d":[{"e":[{"g":[{},[2]],"j":[{},[2]]}],"ő":[{},[2]]}],"é":[{"b":[{},[0,0,0,0,2]]}],"f":[{"j":[{"ú":[{".":[{},[2]],"b":[{},[2]],"é":[{},[2]],"i":[{},[2]],"k":[{"é":[{},[2]]}],"n":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[2]]}]}]}],"g":[{"a":[{},[2]]}],"h":[{"a":[{},[2]],"l":[{},[2]]}],"l":[{"l":[{},[2,0,1]]}],"m":[{"a":[{},[2,0,1]],"á":[{},[2]],"b":[{},[2,0,1]],"p":[{},[2]]}],"n":[{"a":[{"s":[{},[2]]}],"c":[{},[2]],"d":[{},[2]],"f":[{},[2]],"g":[{".":[{},[0,0,1]]}],"j":[{},[2]],"s":[{},[2]],"t":[{},[2,0,1]],"v":[{},[2]]}],"p":[{},[2,0,1,2]],"r":[{"á":[{},[2]],"i":[{},[2]],"o":[{"d":[{},[2]]}],"t":[{},[2]]}],"s":[{"k":[{"o":[{},[2]]}],"m":[{},[2]],"p":[{},[2]],"t":[{},[2]]}],"v":[{"a":[{"d":[{},[2]]}],"á":[{"s":[{},[2]]}],"ó":[{},[2]]}],"z":[{"n":[{},[2,0,1]],"t":[{},[2,0,1]]}]},[1]],"í":[{"g":[{},[2,0,1]],"j":[{},[2,0,1]],"l":[{},[3]],"n":[{},[2,0,1]],"v":[{},[2,0,1]],"z":[{},[2,0,1]]},[1]],"j":[{"é":[{"b":[{},[1]]}]}],"k":[{".":[{},[3]],"a":[{"r":[{"ó":[{"r":[{"a":[{},[0,0,0,0,0,1]]}]}]}]}],"e":[{"t":[{".":[{},[1]]}]}],"k":[{},[1]],"l":[{},[0,0,1]],"n":[{},[1]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"m":[{".":[{},[1]],"e":[{"t":[{".":[{},[1]]}]}],"t":[{},[1]]}],"n":[{".":[{},[1]]}],"o":[{"b":[{},[2,0,1]],"d":[{"ú":[{},[2]]}],"f":[{},[2,0,1]],"k":[{"k":[{"e":[{},[2,0,1]]}],"l":[{},[2,0,1]],"o":[{"s":[{},[2]],"z":[{},[2]]}],"t":[{"a":[{},[2]]}]}],"l":[{"a":[{"j":[{},[2,0,1,2]]}],"c":[{"c":[{},[0,0,0,0,0,1]]}],"d":[{"a":[{},[2,0,1]],"á":[{},[2]],"ó":[{},[2]]}],"l":[{"ó":[{},[0,0,1]]}],"t":[{"á":[{"r":[{},[2,0,1]],"s":[{},[2]]}]}],"v":[{"a":[{"s":[{},[2]]}]}]}],"m":[{".":[{},[3]],"a":[{"t":[{".":[{},[3]],"k":[{},[3]],"o":[{"m":[{},[3]]}]}]}],"o":[{},[3]],"t":[{},[3]]}],"p":[{},[2,0,1]],"r":[{"c":[{},[0,0,1]],"m":[{},[0,0,1]],"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"s":[{"k":[{"o":[{},[2,0,1]]}],"t":[{"o":[{},[2]]}],"z":[{"l":[{},[2]],"t":[{},[2]]}]}],"t":[{"t":[{},[2,0,1]]}],"v":[{},[2,0,1]],"x":[{},[2,0,1]]},[1]],"ó":[{"n":[{"i":[{},[0,0,1,2]]}],"r":[{"á":[{"c":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"i":[{},[2]]}],"s":[{"ü":[{},[0,0,0,2,1]]}]},[1]],"ö":[{"b":[{},[2,0,1]],"c":[{},[2,0,1]],"l":[{},[2,0,1,2]],"n":[{"t":[{},[0,0,1]]}],"v":[{},[2,0,1]]},[1]],"ő":[{"r":[{"s":[{},[2]]}]},[1]],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{".":[{},[3]],"c":[{},[0,0,1]],"e":[{"k":[{},[3]]}],"h":[{},[0,0,1]],"k":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{".":[{},[1]],"a":[{},[0,0,1]],"á":[{},[0,0,1]]},[0,0,0,2]]}],"u":[{"d":[{},[2]],"j":[{},[2]],"k":[{"á":[{},[2]],"r":[{"á":[{},[2,0,1]]}]}],"l":[{},[3]],"n":[{"i":[{},[2]],"o":[{},[2]]}],"r":[{"á":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]]},[2]]},[1]],"ú":[{"j":[{"d":[{},[2]],"é":[{},[2]],"í":[{},[2]],"s":[{},[2]]}],"l":[{"ő":[{},[0,0,0,2]]},[3]],"r":[{".":[{},[2,0,1]],"b":[{},[2]],"h":[{},[2,0,1]],"i":[{},[2]],"k":[{},[2]],"n":[{},[2,0,1]],"o":[{},[2,0,1,2]],"r":[{},[2]]}],"s":[{"z":[{},[2,0,1,2]]}],"t":[{"b":[{},[2]],"é":[{},[2,0,1]],"h":[{},[2]],"i":[{},[2,0,1]],"j":[{},[2]],"k":[{},[2]],"l":[{},[0,0,1]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"r":[{},[2]],"t":[{},[2]],"v":[{},[2]]}]},[1]],"ü":[{"d":[{},[2,0,1]],"g":[{},[2,0,1,2]],"l":[{"d":[{},[2,0,1]],"e":[{},[0,0,1]]}],"n":[{"n":[{},[2]]}],"r":[{},[2,0,1]],"t":[{},[2,0,1]],"z":[{"e":[{},[2]]}]},[1]],"ű":[{"r":[{".":[{},[2,0,1]],"b":[{},[2]],"é":[{},[2,0,1]],"h":[{},[2,0,1]],"i":[{},[2,0,1,2]],"j":[{},[2,0,1]],"l":[{},[2,0,1]],"n":[{},[2,0,1]],"ö":[{},[2,0,1,2]],"r":[{},[2]],"t":[{},[2,0,1]]}],"z":[{"é":[{},[2,0,1,2]],"ő":[{".":[{},[2,0,1,2]],"b":[{},[2]],"e":[{"n":[{},[2]]}],"é":[{},[2]],"h":[{},[2]],"k":[{},[2]],"n":[{},[2]],"r":[{},[2]],"t":[{},[2]],"v":[{},[2]]}]}]},[1]],"v":[{"é":[{"k":[{},[0,0,2]]}],"i":[{"s":[{"k":[{},[0,0,2,1]]}]}],"ó":[{},[0,0,2]],"ö":[{"s":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"z":[{"é":[{"k":[{"e":[{},[0,0,0,0,2]]}]}]}]},[0,2]],"z":[{"a":[{"c":[{"é":[{},[0,2,1]]},[0,0,0,2]],"d":[{"á":[{},[0,0,1]],"o":[{},[0,0,1]],"ó":[{},[0,0,1]]}],"g":[{"a":[{},[0,0,1,2]],"g":[{},[0,0,1]]}],"j":[{"t":[{"a":[{},[0,0,1]]}]}],"k":[{"c":[{},[0,0,1]],"k":[{},[0,0,1]],"o":[{},[0,0,0,0,2]],"t":[{},[0,2,1]]}],"l":[{"d":[{},[0,0,1]],"k":[{},[0,2,1]]}],"n":[{"g":[{},[0,0,1]],"y":[{},[0,2,1,2]]}],"p":[{"p":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1]],"á":[{},[0,0,1]],"c":[{},[0,0,1]],"i":[{},[0,0,1]]}],"u":[{"t":[{},[0,0,1]]}]}],"á":[{"g":[{"y":[{},[0,0,1,2]]}],"l":[{"l":[{},[0,0,1]]}],"r":[{"a":[{"d":[{},[0,2,1,2]]}],"n":[{"y":[{},[0,0,1]]}],"ó":[{"r":[{"a":[{},[0,0,0,2,1,2]]}]}],"u":[{},[0,2,1,2]]}],"s":[{"e":[{},[0,0,0,2,1,2]],"ó":[{},[0,0,1]],"s":[{},[0,0,0,0,3]]}],"t":[{"a":[{},[0,0,1,0,1,2]]}]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"g":[{},[0,2,1,2]],"l":[{"b":[{},[0,2,1]],"e":[{"m":[{"e":[{},[0,2,0,2]]}]}],"é":[{"r":[{},[0,2,1,2]]}],"f":[{},[0,2,1]],"h":[{"a":[{},[0,2,1]]}],"i":[{"s":[{},[0,2,1]]}],"k":[{},[0,2,1]],"l":[{"á":[{},[0,2,1]],"e":[{"n":[{},[0,0,1]]}]}],"m":[{},[0,2,1]],"n":[{"y":[{},[0,2,1]]}],"o":[{},[0,2,1]],"ő":[{"á":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"z":[{},[0,2]]}],"s":[{},[0,2,1]],"t":[{"a":[{},[0,2,1]],"ü":[{},[0,2,1]]}],"v":[{"e":[{"r":[{},[0,2,1]]}],"é":[{},[0,2,1]],"o":[{},[0,2,1]]}]}],"m":[{"b":[{"e":[{"r":[{},[0,0,1]]}]}],"e":[{"l":[{},[0,2,1,2]]}],"é":[{"s":[{},[0,0,1,2]]}],"i":[{},[0,2,1]],"l":[{},[0,0,1]]}],"n":[{"e":[{"r":[{},[0,2]]}]}],"r":[{"ő":[{},[0,0,1]],"t":[{"a":[{},[0,0,0,0,2,1,2]]}],"v":[{"a":[{"d":[{},[0,0,0,0,2,1,2]]}],"é":[{"t":[{"e":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}],"i":[{},[0,0,0,0,2]]}]}],"s":[{"u":[{},[0,0,0,2]],"z":[{"k":[{},[0,0,1]]}]}],"z":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1]],"k":[{"e":[{"l":[{},[0,0,0,2,1]]}]}],"l":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"d":[{},[0,2,1]],"e":[{"m":[{},[0,2,1,2]]}],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{"é":[{},[0,2,1]]}],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"t":[{"v":[{},[0,0,1]]}]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"a":[{},[0,0,0,2]],"g":[{"a":[{},[0,2,1,2]],"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2]],"i":[{},[0,0,0,2]]}],"n":[{"á":[{},[0,0,0,2,1,2]],"o":[{},[0,0,0,2,1]],"ó":[{},[0,0,0,2,1,2]]}],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,0,1]]}],"s":[{"m":[{},[0,0,1]],"t":[{},[0,2,1]]}],"t":[{"á":[{"r":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"í":[{"v":[{"e":[{".":[{},[0,0,0,2,1,2]]}]}]}]}]}],"í":[{"b":[{},[0,2,1]],"g":[{},[0,0,1]],"n":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"k":[{"l":[{},[0,2,1]]}],"l":[{"i":[{"n":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2]]}],"n":[{"a":[{},[0,0,0,2,1]],"é":[{},[0,0,0,2]]}],"r":[{"i":[{"n":[{},[0,0,0,2]]}]}],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}]}],"ö":[{"n":[{},[0,2,1]],"r":[{"ö":[{},[0,0,1]]},[0,0,0,2]],"s":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"a":[{"j":[{},[0,0,3]]}],"á":[{"r":[{},[0,2,3]],"t":[{},[0,2,3]],"v":[{},[0,2]]}],"e":[{"g":[{},[0,0,3]],"r":[{},[0,2,3]]}],"i":[{"k":[{},[0,0,3]],"s":[{},[0,2,3]]}],"o":[{"d":[{},[0,2,3]],"r":[{},[0,0,3]]}],"ó":[{},[0,2,3]],"p":[{},[0,0,3,2]],"t":[{},[0,0,3,2]],"z":[{},[0,0,3]]}],"t":[{"á":[{"r":[{"a":[{"d":[{},[0,0,0,0,2,1,2]]}]}]}],"r":[{},[0,0,1,2]]}],"u":[{"j":[{},[0,2,1]],"l":[{"a":[{},[0,0,0,2,1]]}],"m":[{"é":[{},[0,0,0,2]]}],"r":[{"a":[{},[0,0,1,2]]}],"s":[{"a":[{"n":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]]}],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"s":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,2,1,2]]}],"z":[{"s":[{},[0,0,3]]}]}]}],"o":[{".":[{},[2]],"a":[{"c":[{"é":[{},[0,0,2]]}],"f":[{"r":[{},[0,0,1]]}],"k":[{"i":[{},[0,2]],"v":[{},[0,2,1,2]]}],"m":[{"i":[{},[0,2]]}],"n":[{"a":[{"l":[{"i":[{},[0,0,2]]}]}]}],"s":[{"i":[{},[0,2]],"z":[{"ó":[{},[0,2]]}]}]},[0,1]],"á":[{"g":[{"a":[{},[0,0,2]]}],"r":[{"a":[{"n":[{},[0,0,2,1,2]]}],"i":[{"l":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2,1]]}]}],"z":[{"s":[{},[0,0,2]]}]},[0,1]],"b":[{"a":[{"b":[{},[0,0,0,1,2]],"d":[{},[0,0,0,1,2]],"l":[{"j":[{},[0,2,1]],"t":[{"a":[{},[0,0,0,0,2,1,2]]}]}],"p":[{},[0,0,0,1]],"r":[{"a":[{},[0,0,1,2]]}],"u":[{},[0,0,0,0,2]]}],"á":[{"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"m":[{},[0,0,1]]}]}],"b":[{"e":[{"g":[{},[0,0,2,1]]}],"ö":[{},[0,0,2]]}],"e":[{"g":[{},[0,2,1]],"l":[{"e":[{},[0,0,1]]}],"m":[{},[0,2,1,2]],"r":[{"ő":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"r":[{"z":[{},[0,2,1]]}]}],"i":[{"k":[{"i":[{},[0,0,0,2]],"ó":[{},[0,0,0,2,1,2]]}],"l":[{"i":[{"n":[{},[0,0,0,2]],"p":[{},[0,0,0,2]]}]}],"n":[{"a":[{".":[{},[0,0,1]],"l":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"g":[{},[0,2,1]]}],"s":[{},[0,2,1,2]]}],"í":[{"v":[{},[0,0,1]]}],"j":[{"e":[{"k":[{},[1]]}]}],"k":[{"l":[{},[0,0,1]]}],"o":[{"a":[{},[1,2]],"l":[{"l":[{},[0,2,1]]}],"r":[{"a":[{},[0,0,0,2,1]],"i":[{"n":[{},[0,0,0,2]]}],"o":[{"s":[{},[0,0,0,2,1]]}]}],"t":[{"á":[{},[0,0,0,2,1,2]],"i":[{"n":[{},[0,0,0,2]]}]}]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"n":[{"é":[{},[0,2,1,2]]}],"r":[{"á":[{},[0,0,1,2]]}]}],"ö":[{"t":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"t":[{},[1]]}],"u":[{"t":[{},[0,2,1]]}],"ú":[{"s":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ű":[{"r":[{},[0,0,1]]}]}],"c":[{"a":[{"k":[{"é":[{},[0,0,0,2]]}]}],"á":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]]}],"e":[{"r":[{},[0,0,1]]}],"é":[{"k":[{},[0,0,1,2]]}],"h":[{"i":[{".":[{},[0,2,3]]}],"o":[{"k":[{},[0,0,3]],"t":[{},[0,0,3]]}]}],"i":[{"a":[{},[0,0,0,3]],"e":[{},[0,0,0,0,2]],"k":[{"r":[{},[0,0,0,1,2]]}],"ó":[{},[0,0,0,0,2]],"p":[{},[0,0,0,1]],"s":[{"z":[{},[0,0,0,1,0,2]]}]}],"k":[{"e":[{"f":[{},[0,1,2]]}],"é":[{"l":[{},[0,0,2,1,2]],"n":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,1,2]],"t":[{},[0,1,2]]}],"i":[{".":[{},[0,1,2]],"a":[{},[0,0,2]],"g":[{},[0,1,2]],"n":[{},[0,1,2]],"t":[{},[0,1,2]],"v":[{},[0,1,2]]}],"o":[{"p":[{},[0,0,2]],"s":[{"n":[{},[0,1,2]],"o":[{},[0,1,2]],"r":[{},[0,1,2]],"s":[{},[0,1,2]]}]}]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"a":[{"p":[{},[0,2,3]]}],"á":[{"l":[{},[0,2,0,1]],"s":[{"z":[{},[0,2,0,1]]},[0,0,0,0,2]],"z":[{},[0,2,0,1,2]]}],"e":[{},[0,2,0,1,2]],"é":[{"r":[{},[0,0,3]]}],"i":[{"é":[{"r":[{"a":[{},[0,0,0,0,0,2]]}]}],"n":[{"g":[{},[0,2,0,1]]}],"z":[{"m":[{},[0,0,0,1]]}]}],"í":[{"n":[{},[0,0,3]]},[0,2,0,0,2]],"o":[{"p":[{},[0,2]]}],"s":[{},[0,0,0,1]],"t":[{},[0,0,0,1]],"u":[{"j":[{},[0,2]]}],"ü":[{},[0,2,0,1,2]],"z":[{"a":[{},[0,0,3]],"á":[{},[0,0,0,3]],"e":[{},[0,0,3]]}]}],"z":[{"s":[{},[0,0,3]]}]}],"d":[{"a":[{"a":[{"d":[{},[0,2]]}],"b":[{},[0,0,0,1,2]],"d":[{"j":[{},[0,2,1]],"r":[{},[0,0,0,1]]}],"k":[{"k":[{},[0,2,1]]}],"l":[{"j":[{},[0,2,1]]}],"p":[{},[0,0,0,1,2]],"s":[{"s":[{},[0,2,1]],"z":[{"t":[{},[0,0,1]]}]},[0,0,0,0,2]],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"u":[{"t":[{"ó":[{},[0,0,1]]}]}]}],"á":[{"b":[{},[0,0,0,0,2]],"l":[{"l":[{"á":[{},[0,0,1]]}]}],"r":[{"u":[{},[0,2]]}],"s":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"z":[{},[1,2]]}],"e":[{"d":[{},[0,0,1]],"l":[{"l":[{"a":[{},[0,0,0,0,2,1]]}]},[0,0,0,2]],"m":[{"i":[{"n":[{},[0,0,0,2]]}]}],"v":[{},[0,0,1,2]]}],"é":[{"g":[{},[0,2,1,2]],"n":[{"e":[{},[0,0,1,2]]}],"p":[{},[0,2,1]],"r":[{"d":[{},[0,2,1]]}],"t":[{"e":[{},[0,2,1,2]]}],"v":[{"e":[{},[0,2,1,2]],"é":[{},[0,0,1,2]]}],"z":[{},[2]]}],"i":[{"d":[{"e":[{},[0,0,1]]}],"g":[{"a":[{},[0,2,1]]},[0,0,0,2]],"k":[{"r":[{"e":[{},[0,2,1]]}]}],"l":[{"e":[{},[0,0,0,2,1]],"i":[{"d":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1]]}]}],"n":[{"t":[{},[0,2,1]]}],"r":[{"o":[{},[0,2,1]]}],"s":[{"p":[{},[0,0,1]]}]}],"í":[{"z":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1]]}],"o":[{"b":[{"o":[{},[0,0,1]]}],"k":[{"t":[{},[0,2,1]]}],"p":[{},[0,2,1]],"r":[{"a":[{"k":[{},[0,0,0,2]]}],"o":[{"s":[{"z":[{},[0,0,0,2]]}]}]}]}],"ö":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"a":[{"m":[{},[0,1,2]]}],"á":[{"m":[{"a":[{},[0,1,2]]}]}]}],"s":[{"t":[{},[0,0,1]]}],"u":[{"l":[{"a":[{"l":[{},[0,0,0,2,1,2]]}]}],"r":[{},[0,2,1,2]]}],"ú":[{"n":[{},[1]]}],"ü":[{"g":[{},[0,0,1]],"n":[{},[0,0,1]],"z":[{},[0,0,1]]}],"v":[{"á":[{"b":[{},[1]]}]}],"z":[{"e":[{},[0,0,3]],"o":[{},[0,0,3]]}]}],"e":[{"i":[{"r":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]]}],"m":[{"u":[{},[0,0,2]]}],"n":[{"e":[{},[0,0,2]]}],"t":[{"h":[{"e":[{},[0,0,1,2]]}]}],"u":[{"r":[{},[0,0,2]],"v":[{},[0,0,2]]}]},[0,1]],"é":[{"f":[{"a":[{},[0,2]],"á":[{},[0,2]],"o":[{},[0,2]]}],"k":[{"e":[{},[0,2]],"i":[{},[0,2]]}],"n":[{"a":[{"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"á":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"s":[{},[0,0,2]]}]}],"s":[{"z":[{},[0,2]]}],"v":[{"i":[{},[0,2]]}]},[0,1]],"f":[{"i":[{"l":[{"a":[{"d":[{},[0,0,0,2]],"k":[{},[0,0,0,2]]}],"á":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"i":[{"g":[{"a":[{},[0,0,0,2,1]],"á":[{},[0,0,0,2,1]]}],"s":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"o":[{"s":[{"z":[{},[0,0,0,2,1]]}]}]}],"t":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]]}]}],"l":[{"a":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"o":[{"n":[{"a":[{"l":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1]],"é":[{"r":[{".":[{},[0,0,0,2,1]]}]}],"n":[{},[0,0,0,0,3]],"ó":[{},[0,0,0,2,1,2]]}],"r":[{"m":[{"á":[{},[0,0,0,0,2,1,2]]}]}]}],"ő":[{"r":[{"e":[{},[0,0,0,2,1]],"ü":[{},[0,0,0,0,0,2]]}]}],"r":[{"í":[{},[0,0,2]]}]}],"g":[{"a":[{"b":[{"r":[{},[0,0,1]]}],"g":[{},[0,2,1,2]],"k":[{"a":[{"r":[{},[0,0,0,2]]}],"á":[{},[0,2,1]]}],"l":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2]],"j":[{},[0,2,1]],"l":[{},[0,0,1]],"t":[{},[0,0,1]],"u":[{},[0,0,1]]}],"n":[{"y":[{},[0,2,1,2]]}],"p":[{},[0,2,1]],"r":[{"a":[{"n":[{},[0,2,1,2]]}],"c":[{},[0,0,1]]}],"s":[{"z":[{},[0,2,1,2]]}],"t":[{"a":[{"g":[{},[0,0,0,2,1,2]]}],"e":[{},[0,0,0,2,1,2]],"i":[{"n":[{},[0,0,0,2,1,2]]}],"y":[{},[0,0,1,2]]}],"z":[{},[2]]}],"á":[{"g":[{},[0,2,1,2]],"l":[{"l":[{},[0,0,1]],"m":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{"a":[{"k":[{},[0,2,1,2]]}],"e":[{},[0,2,1]],"j":[{"a":[{},[0,2,1]],"á":[{"t":[{},[0,2,1]]}]}],"o":[{"k":[{},[0,2,1,2]],"s":[{},[0,0,0,2]]}],"u":[{},[0,2,1,2]]}],"s":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"ó":[{},[0,2]]}],"t":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"ü":[{},[0,0,1]],"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"í":[{"j":[{"a":[{"d":[{},[0,0,0,0,2,1,2]]}]}]}],"r":[{},[0,0,1]]}],"e":[{"d":[{},[0,2,1,2]],"g":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]},[0,2,1,2]],"l":[{},[0,2,1,2]],"m":[{},[0,2,1]],"p":[{},[0,2,1,2]],"r":[{"e":[{},[0,0,1]],"n":[{},[0,0,1]],"ő":[{},[0,0,1]]},[0,0,0,2]],"s":[{"e":[{},[0,2,1]]},[0,0,0,2]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"n":[{"n":[{},[0,0,0,0,1]]}],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"t":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]],"ő":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"s":[{},[0,2,1]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1,2]]}],"i":[{"c":[{},[0,2,1]],"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,2]]}],"n":[{"f":[{},[0,0,1]],"g":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}],"p":[{},[0,2,1]],"r":[{"o":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,0,1]]}]}],"í":[{"j":[{},[0,2,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"i":[{"c":[{},[0,1,2]]}]}],"n":[{"a":[{"i":[{},[0,1,2]]}]}],"o":[{"d":[{"v":[{},[0,2,1]]}],"r":[{"g":[{},[0,0,1]],"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"s":[{"z":[{"l":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"v":[{},[0,2,1,2]]}],"ö":[{"b":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"a":[{"f":[{"i":[{},[2]]}],"p":[{},[2]]}],"á":[{"f":[{".":[{},[2]],"f":[{"a":[{},[0,1,2]]},[2]],"h":[{},[0,1,2]],"j":[{},[0,1,2]],"r":[{},[0,1,2]]}],"l":[{},[0,1,2]]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"r":[{"a":[{},[0,0,1,2]],"u":[{},[0,0,1,2]]}],"s":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ű":[{"z":[{},[0,0,1]]}],"y":[{"a":[{"c":[{},[0,0,0,1,2]],"p":[{},[0,0,0,1,2]]}],"i":[{"s":[{".":[{},[0,0,0,1]]}]}],"o":[{"s":[{},[0,0,0,1]]}],"ó":[{"é":[{},[0,0,0,0,0,2]]}]}]}],"h":[{"a":[{"m":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]}]}],"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"á":[{"g":[{},[0,2,1]],"l":[{},[0,2,1]],"n":[{"y":[{"a":[{"d":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}]}]}],"r":[{"e":[{},[0,0,0,2,1]]}],"s":[{"z":[{"i":[{},[0,0,0,2]],"o":[{"d":[{"v":[{},[0,0,0,2,0,1]]}]}]}]}],"z":[{},[0,2,1,2]]}],"e":[{"c":[{},[0,0,1,2]]}],"i":[{"n":[{"g":[{},[0,0,1]]}]}],"n":[{"i":[{},[0,0,2]]}],"o":[{"r":[{"r":[{},[0,2,1]]}]}],"ó":[{"c":[{"s":[{"i":[{},[0,0,0,2]]}]}],"r":[{"á":[{},[0,0,1]]}]}],"ö":[{"v":[{},[0,0,1,2]]}],"u":[{"r":[{"á":[{},[0,0,1]]}]}]}],"i":[{"a":[{"e":[{},[0,0,2]],"f":[{},[0,0,2]],"n":[{},[0,0,2]],"v":[{},[0,0,2]]}],"á":[{"b":[{"a":[{},[0,0,2]]}]}],"d":[{"a":[{"d":[{},[0,0,2,1]],"n":[{},[0,0,2]]},[0,0,0,0,1]],"á":[{"l":[{},[0,0,2]]}],"e":[{},[0,0,2,1,2]],"o":[{"l":[{},[0,0,2]]}],"z":[{},[0,0,2,3]]}],"l":[{"e":[{"t":[{},[0,0,0,0,0,2]]}]}],"n":[{"a":[{"d":[{},[0,0,2,1]]},[0,0,0,0,2]],"e":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]]}],"s":[{"e":[{"l":[{},[0,0,0,0,0,2]]}]}],"z":[{"o":[{},[0,0,2]]}]},[0,1]],"í":[{},[0,1]],"j":[{"á":[{"r":[{"a":[{"s":[{},[0,0,0,2,1]]}]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,0,3]]}]}],"e":[{"k":[{"t":[{"á":[{},[0,0,0,0,2,1,2]],"í":[{},[0,0,0,0,2,1,2]],"o":[{},[0,0,0,0,2,1,2]]}]}]}],"i":[{"n":[{},[0,0,1]]}],"t":[{"á":[{"r":[{"a":[{},[0,0,2,1]]}]}],"o":[{"r":[{"j":[{"á":[{"k":[{},[0,0,2,1]]}]}]}]}],"ó":[{"á":[{},[0,0,0,0,0,2]]}]}]}],"k":[{"a":[{"b":[{"l":[{},[0,0,1]]}],"c":[{"é":[{},[0,0,1,2]]}],"d":[{"a":[{"t":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]],"ó":[{},[0,2,1,2]]}],"k":[{"a":[{"r":[{},[0,2,1,2]]}],"v":[{},[0,0,1]]}],"l":[{"j":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,0,1]],"t":[{},[0,0,1]]}],"n":[{"g":[{},[0,0,1]],"i":[{},[0,0,1]],"t":[{},[0,2,1]]}],"p":[{"l":[{},[0,0,0,1,2]],"p":[{},[0,0,1]]}],"r":[{"a":[{},[0,0,1,2]],"c":[{},[0,0,1]],"i":[{"s":[{},[0,0,0,2]]}]}],"s":[{"p":[{},[0,2,1]],"s":[{},[0,2,1]],"z":[{"f":[{},[0,0,1]],"t":[{},[0,0,1]]}]}],"t":[{"t":[{},[0,2,1]],"y":[{},[0,2,1]]}],"u":[{"t":[{},[0,0,1]]},[0,0,0,2]],"v":[{"a":[{},[0,2,1]]}]}],"á":[{"g":[{},[0,2,1]],"j":[{"t":[{},[0,0,1]]}],"r":[{"a":[{"d":[{},[0,0,1]],"k":[{},[0,2,1,2]]}],"u":[{"l":[{},[0,0,0,2]]}],"v":[{},[0,2,1]]}],"s":[{"a":[{"l":[{},[0,0,0,2]]}],"ó":[{},[0,0,1]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,1]]}],"t":[{"e":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{".":[{},[0,2]],"b":[{},[0,0,1,2]],"c":[{},[0,2,1,2]],"d":[{"é":[{},[0,0,1]]},[0,0,0,2]],"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"r":[{"é":[{},[0,0,1]],"k":[{},[0,0,1]],"n":[{"e":[{"l":[{".":[{},[0,0,1]]}]}]}],"ő":[{},[0,0,1,2]]}],"s":[{"é":[{},[0,0,1]]},[0,2,0,2]],"v":[{},[0,2,1,2]],"z":[{},[0,0,1,2]]}],"é":[{"g":[{},[0,2,1]],"k":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]]}],"l":[{".":[{},[0,2,1]],"e":[{"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"é":[{},[0,0,1,2]],"n":[{},[0,0,1]],"t":[{},[0,0,1]]}],"n":[{"e":[{},[0,2,1,2]]}],"p":[{"á":[{},[0,0,0,3]],"í":[{},[0,0,1]],"ü":[{},[0,2,1]]},[0,0,0,2]],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"c":[{},[0,2,1]],"d":[{},[0,2,1]],"g":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"m":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{"á":[{},[0,0,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ö":[{},[0,0,1]]}],"z":[{},[0,2,1]]}],"s":[{"z":[{},[0,0,0,0,0,2]]},[0,0,0,1,2]],"t":[{"k":[{},[0,2,1]],"t":[{},[0,2,1]]}],"v":[{"e":[{},[0,2,1,2]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,2,1,2]],"o":[{},[0,2,1,2]]}],"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]},[0,0,1,2]],"á":[{},[0,0,1]],"é":[{},[0,2,1]]}],"n":[{"d":[{},[0,0,1]],"t":[{},[0,2,1]]}],"r":[{"á":[{},[0,2,1,2]],"o":[{},[0,2,1,2]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,0,1]],"p":[{},[0,2,1]],"t":[{"e":[{},[0,0,1]]}]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{"m":[{},[0,2,1]]}]}],"í":[{"j":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"k":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,2,1]],"k":[{},[0,0,0,1]]}],"s":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"e":[{"l":[{"h":[{},[0,0,0,1]],"ö":[{},[0,0,0,1]],"ő":[{},[0,0,0,1]],"r":[{},[0,0,0,1]]}],"r":[{"é":[{},[1]]}],"s":[{},[0,0,2,1]]}],"é":[{"p":[{"ü":[{},[0,0,2]]}]}],"i":[{"d":[{},[0,0,2]]}],"l":[{"ó":[{},[0,0,1]]}],"o":[{"b":[{},[0,0,2]]}],"ö":[{"s":[{"s":[{},[0,0,0,1]]}],"v":[{"ű":[{},[0,0,0,1,2]]}]}],"r":[{"i":[{},[0,0,1]]}],"u":[{"d":[{},[0,0,2]],"r":[{},[0,0,2,1]]}]}],"l":[{"í":[{},[0,1,2]],"o":[{"r":[{},[0,0,2]]}]}],"o":[{"b":[{},[0,2,1]],"l":[{"a":[{},[0,0,0,0,0,2]],"á":[{"r":[{},[0,0,0,2]]}],"t":[{"á":[{"s":[{},[0,2,1]]}]}]}],"n":[{"n":[{},[0,0,0,0,1]],"o":[{"k":[{"s":[{},[0,0,0,2,1]]}]}]}],"r":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2,1]],"i":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"m":[{"ú":[{},[0,2,1]]}],"o":[{},[0,0,1,2]]}],"s":[{"z":[{},[0,2,1]]}],"v":[{"a":[{"r":[{"i":[{"a":[{},[0,0,1,2]]}]}]}],"i":[{},[0,2,1,2]]}]}],"ö":[{"b":[{},[0,2,1]],"d":[{},[0,2,1,2]],"k":[{},[0,0,1,2]],"l":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,0,0,2]],"s":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"i":[{"s":[{},[0,1,2]]}],"ó":[{"m":[{},[0,1,2]]}]}],"s":[{"e":[{"l":[{},[0,0,2]]}],"p":[{},[0,0,1]],"z":[{"a":[{"l":[{"m":[{},[0,0,0,0,1]]}],"n":[{},[0,0,2]]}],"e":[{"s":[{},[0,0,2,0,1]]}],"i":[{"s":[{},[0,0,2,0,1]]}]}]}],"t":[{"á":[{"n":[{},[1]]}]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{"a":[{},[0,0,1,2]]}],"t":[{},[0,2,1,2]]}],"ú":[{"r":[{".":[{},[0,0,1]],"b":[{},[0,0,1]],"h":[{},[0,0,1]],"r":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1]]}],"t":[{"b":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,0,1]],"v":[{},[0,2]]}]}],"ü":[{"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"ű":[{"z":[{},[0,0,1]]}]}],"l":[{"a":[{".":[{},[0,3]],"b":[{"l":[{},[0,0,1]]}],"d":[{},[0,0,0,1,2]],"f":[{},[0,0,0,1,2]],"j":[{".":[{},[1,2]],"b":[{},[1,2]],"f":[{},[1,2]],"g":[{},[1,2]],"h":[{},[1,2]],"i":[{},[1,2]],"j":[{},[1,2]],"k":[{},[1,2]],"m":[{},[1,2]],"n":[{},[1,2]],"p":[{},[1,2]],"r":[{},[1,2]],"s":[{},[1,2]],"t":[{},[0,2]],"u":[{},[0,2]],"ú":[{},[1,2]],"v":[{},[0,2]]}],"k":[{"r":[{},[0,0,0,1,2]]}],"l":[{"g":[{},[0,2,1]],"k":[{},[0,0,1]]}],"m":[{"n":[{},[0,0,1]]}],"n":[{"y":[{"a":[{},[0,0,1]]}]}],"p":[{},[0,0,0,1,2]],"s":[{"p":[{},[0,0,0,1,2]],"t":[{},[0,0,0,1,2]]}],"t":[{"a":[{"l":[{"a":[{},[0,0,0,2,1]]}],"n":[{"y":[{},[0,0,0,0,1]]}]}],"á":[{"l":[{},[0,0,0,2]],"p":[{},[0,0,0,2]]}],"é":[{"k":[{},[0,0,0,2]]}],"i":[{"n":[{"f":[{},[0,0,0,2,1]]}]}],"í":[{"v":[{},[0,0,0,2,1,2]]}],"o":[{"l":[{},[0,0,0,2,1]],"r":[{"n":[{},[0,0,0,2,1]]}]}],"ö":[{"l":[{},[0,0,0,2,1]]}],"ü":[{"z":[{},[0,0,0,2]]}]}],"u":[{"r":[{},[0,0,0,0,2]]}]}],"á":[{"b":[{"r":[{"á":[{},[0,0,1]]}]}],"g":[{},[0,2,1,2]],"h":[{"a":[{},[0,0,0,2]]}],"l":[{"l":[{},[0,0,1]]}],"r":[{"b":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{"a":[{},[0,2,1,2]],"á":[{},[0,0,0,2]]}],"k":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,2,1,2]]}],"s":[{"z":[{"a":[{},[0,0,0,2]]}]}],"t":[{"i":[{},[0,2,1,2]],"v":[{},[0,2,1]]}]}],"c":[{"a":[{"j":[{},[0,0,2]],"l":[{},[0,0,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"e":[{"k":[{},[0,0,2,1,2]],"l":[{},[0,0,2]],"s":[{},[0,0,2]]}],"é":[{"v":[{},[0,0,2,1]]}],"h":[{},[0,0,2,3]],"i":[{"k":[{"o":[{},[0,0,0,1]]}]}],"í":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"s":[{"o":[{"r":[{},[0,0,2,3]]}],"ű":[{},[0,0,2]],"z":[{},[0,0,0,3]]}],"ü":[{},[0,0,2]],"z":[{},[0,0,2]]}],"d":[{"a":[{"b":[{},[0,0,2]],"l":[{".":[{},[1]],"á":[{},[1]],"b":[{},[1]],"e":[{},[0,0,0,0,2]],"h":[{},[1]],"k":[{},[1]],"l":[{},[1]],"n":[{},[1]],"o":[{},[1]],"r":[{},[1]],"t":[{},[1]],"u":[{},[1]],"ú":[{},[1]]}],"n":[{"y":[{},[0,0,2,1]]}],"p":[{},[0,0,2]],"t":[{"e":[{"l":[{},[0,0,0,0,2]]}]}],"u":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2]],"l":[{"é":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"m":[{"b":[{},[0,0,0,1]]}],"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1,2]],"v":[{},[0,0,2]],"z":[{},[0,0,2]]}],"é":[{"s":[{},[0,0,2]],"v":[{"e":[{},[0,0,2,1]]}]}],"i":[{"p":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"o":[{"r":[{},[0,0,2]]}],"ó":[{"s":[{},[1]]}],"ö":[{},[0,0,2,1,2]],"u":[{"d":[{},[0,0,2]],"g":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,2,1]],"ű":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,1,2]],"l":[{},[0,2,1,2]]}],"é":[{"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"l":[{},[0,2,1]],"r":[{".":[{},[0,0,1]],"d":[{},[0,0,1]],"e":[{},[0,0,1,2]],"é":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1,2]],"j":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"ő":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{"é":[{},[0,2,1]]}],"ü":[{},[0,0,1,2]],"v":[{},[0,0,1]],"z":[{},[0,2,1]]}]}],"f":[{"a":[{"k":[{},[0,0,0,0,2]],"u":[{},[0,0,2]]}],"á":[{"r":[{},[0,0,2,1]]}],"e":[{"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,0,1]]}],"r":[{},[0,0,2]],"s":[{},[0,0,2]]}],"u":[{"t":[{},[0,0,2,1]]},[0,0,0,0,2]],"ú":[{"j":[{},[0,0,2]]}]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"i":[{"b":[{},[2]],"d":[{"u":[{},[0,2,1,2]]}],"g":[{"a":[{},[1,2]],"á":[{"z":[{},[0,0,0,2]]}],"é":[{},[0,2,1]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"a":[{".":[{},[0,0,1,2]]}],"á":[{},[0,2,1,2]],"p":[{},[1]]}],"n":[{"u":[{},[0,0,0,2]]}],"p":[{"a":[{},[0,2,1,2]],"e":[{"t":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"s":[{"k":[{},[0,2,1]],"z":[{"á":[{"l":[{},[0,0,0,2]]}]}]}]}],"í":[{"v":[{".":[{},[0,0,1]]}]}],"l":[{"a":[{"g":[{"y":[{},[0,0,0,1,2]]}],"j":[{},[0,0,2,1]],"l":[{"a":[{},[0,0,2,1]],"j":[{},[0,0,2,1]]},[0,0,0,0,2]],"n":[{"d":[{"ó":[{},[0,0,0,0,0,2,1,2]]}],"y":[{},[0,0,0,1]]}],"t":[{"k":[{},[0,0,2,1]],"t":[{},[0,0,0,1]]}]}],"á":[{"g":[{},[0,0,2,1,2]]}],"e":[{"c":[{},[0,0,2,1,2]],"g":[{"e":[{},[0,0,0,1]],"é":[{},[0,0,0,1]],"y":[{},[0,0,2,1,2]]}],"h":[{},[0,0,2,1,2]],"l":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"m":[{"b":[{},[0,0,2,1]]}],"s":[{"e":[{},[0,0,0,1]]}]}],"é":[{"k":[{},[0,0,2,1,2]],"r":[{"i":[{},[0,0,2,1]]}]}],"i":[{"n":[{"f":[{},[0,0,2,1]],"g":[{"e":[{},[0,0,0,1]],"é":[{},[0,0,0,1]],"i":[{},[0,0,0,1]],"j":[{},[0,0,0,1]],"n":[{},[0,0,0,1]],"r":[{},[0,0,0,1]]}],"j":[{},[0,0,0,1]],"s":[{},[0,0,2]],"t":[{},[0,0,2,1]]}],"s":[{"k":[{},[0,0,0,1]]}]}],"o":[{"b":[{},[0,0,2]],"r":[{},[0,0,2]],"s":[{"z":[{},[0,0,2,1]]}]}],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2,1,2]],"s":[{},[0,0,0,1]],"u":[{"b":[{},[0,0,2]],"l":[{},[0,0,2]],"s":[{},[0,0,2,1,2]]}],"ü":[{},[0,0,2]],"y":[{"u":[{},[0,0,3]]}]}],"n":[{"i":[{"k":[{"e":[{},[0,0,0,1]]}]}]}],"o":[{"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"e":[{},[0,0,0,2,1]]}],"t":[{"t":[{},[0,0,1]]}],"x":[{},[0,2,1]]}],"ó":[{"e":[{"d":[{"é":[{"n":[{"n":[{},[0,0,0,0,3]]}]}]}]}],"f":[{},[0,0,0,1,2]],"n":[{"é":[{},[0,2,1,2]],"n":[{},[0,0,1]],"o":[{},[0,0,1,2]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"r":[{"á":[{"i":[{},[0,0,0,2]],"j":[{},[0,0,0,2]],"k":[{},[0,0,0,2]],"n":[{},[0,0,0,2]],"r":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"i":[{},[0,0,1,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ö":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,0,1]]}],"t":[{"a":[{"j":[{},[0,0,2,1]],"l":[{"m":[{},[1]],"o":[{},[1]]}],"r":[{"i":[{},[0,0,2,1]]}]}],"á":[{"g":[{},[0,0,2,1]],"t":[{"a":[{},[0,0,2,1]]}]}],"e":[{"g":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"r":[{"e":[{},[0,0,2,1]]},[0,0,0,0,2]],"s":[{},[0,0,0,0,2]],"v":[{},[0,0,2,1,2]]}],"é":[{"p":[{},[0,0,2,1]],"r":[{".":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"s":[{},[0,0,2,1]]}],"i":[{"d":[{},[0,0,2]],"m":[{},[0,0,2]],"s":[{},[0,0,2]],"z":[{},[0,0,2]]}],"o":[{"l":[{"d":[{},[0,0,2,1]]}]}],"ó":[{"é":[{},[1]],"h":[{},[1]],"k":[{"é":[{},[1]]}],"l":[{"o":[{},[1]]}],"m":[{},[1]],"n":[{},[1]]}],"ö":[{"r":[{},[0,0,0,0,2]]}],"ő":[{"r":[{},[0,0,2,1]]}],"ü":[{"r":[{},[0,0,2]]}]}],"u":[{"g":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{"á":[{},[0,2,1,2]]}]}],"ú":[{"s":[{},[0,0,1]]}],"ü":[{"g":[{},[0,0,1]],"l":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"v":[{"a":[{"d":[{},[1]],"s":[{},[1]]}]}],"y":[{"a":[{"b":[{"r":[{},[0,2]]}],"d":[{"a":[{},[0,0,0,1]]}],"g":[{"g":[{"y":[{},[0,0,0,1]]}]}],"m":[{"e":[{"s":[{},[0,0,0,0,2]]},[0,0,0,0,0,0,2]]}],"s":[{"z":[{"t":[{},[0,0,0,1]]}]}]}],"á":[{"l":[{},[0,2]]}],"e":[{},[0,2,0,1,2]],"é":[{"b":[{},[1,2]],"h":[{},[1,2]],"i":[{},[1,2]],"l":[{},[0,2]],"n":[{".":[{},[1,2]]}]}],"i":[{"é":[{"r":[{},[1,2]]}],"m":[{},[0,2]]}],"ó":[{},[2]],"ö":[{},[0,2,0,1]],"ő":[{},[0,2]],"u":[{"g":[{},[0,2]]}],"ü":[{},[0,2,0,1,2]],"ű":[{},[0,2,0,1,2]]}]}],"m":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"d":[{"a":[{"t":[{},[0,0,1,2]]}],"m":[{},[0,2,1]],"ó":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"f":[{},[0,0,0,1]],"g":[{"a":[{".":[{},[0,0,0,2]],"d":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1,2]],"e":[{},[0,0,0,2]],"i":[{"n":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"y":[{"a":[{},[0,2,1,2]],"ú":[{},[0,0,1]]}]}],"j":[{"á":[{},[0,2,1]],"k":[{},[0,2,1]]}],"k":[{"r":[{"é":[{},[0,0,0,1]]}],"t":[{},[0,2,1]]}],"l":[{"a":[{"g":[{},[0,0,1,2]],"p":[{"o":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}]}],"m":[{},[0,2,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,2,1]]}],"n":[{"g":[{},[0,0,1]],"n":[{},[0,2,1]]}],"p":[{"a":[{"d":[{},[0,0,1]]}],"p":[{},[0,2,1]],"r":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,2,1,2]],"c":[{},[0,2,1]],"g":[{},[0,2,1]]}],"t":[{"á":[{"r":[{"a":[{"k":[{},[0,0,0,2,1]]}]}]}],"k":[{"á":[{},[0,2,1]]}],"y":[{},[0,2,1]]}],"u":[{},[0,2,1]],"z":[{"o":[{},[0,0,1,2]]}]}],"á":[{"c":[{"s":[{},[0,0,0,2]]}],"g":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"n":[{"y":[{"a":[{"n":[{},[0,0,0,2]]}],"k":[{"á":[{},[0,0,0,0,0,0,0,2]]}]}]}],"p":[{},[0,2,1]],"r":[{"a":[{"i":[{},[0,2,1,2]],"k":[{},[0,0,1,2]],"m":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"á":[{},[0,2,1,2]],"d":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{".":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}],"g":[{},[0,2,1]],"i":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]]}],"m":[{},[0,2,1]],"u":[{},[0,2,1,2]]}],"s":[{"í":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]],"z":[{"ó":[{},[0,0,0,0,3]]},[0,0,0,2]]}],"t":[{"e":[{},[0,2,1,2,1]],"é":[{},[0,0,1,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"o":[{"l":[{},[0,0,1]]}],"r":[{},[0,2,1]]}]}],"b":[{"a":[{"l":[{"o":[{},[0,0,2,1,2]]}]}],"á":[{"g":[{},[0,0,2]]}],"e":[{"g":[{},[0,0,2,1]],"l":[{"h":[{},[0,0,0,1]],"t":[{},[0,0,2,1]]}]}],"é":[{"n":[{"e":[{},[0,0,0,1]]}],"r":[{"i":[{},[0,0,2,1]]}]}],"ó":[{"n":[{".":[{},[0,0,0,1]]}],"r":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"r":[{"o":[{},[0,0,1]]}],"u":[{"j":[{},[0,0,2]]}]}],"d":[{"i":[{"o":[{},[0,0,0,0,0,2]]}],"r":[{},[0,0,1]]}],"e":[{"b":[{},[0,2,1,2]],"c":[{"e":[{},[0,2,1,2]]}],"d":[{"é":[{},[0,2,1,2]]}],"f":[{},[0,0,1]],"g":[{"á":[{},[0,0,0,3]],"e":[{},[0,0,1]],"é":[{},[0,0,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"l":[{"a":[{},[0,2,1]],"á":[{},[0,0,1]],"b":[{},[0,0,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]],"k":[{},[0,0,1]],"l":[{"á":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1]],"ő":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,0,1]]}],"u":[{},[0,2,1]],"v":[{},[0,2,1]]},[0,0,0,2]],"m":[{},[0,2,1,2]],"n":[{"e":[{},[0,0,1]],"g":[{},[0,0,1]],"y":[{},[0,0,1]],"z":[{},[0,0,1]]}],"o":[{},[0,0,0,2]],"p":[{},[0,2]],"r":[{"d":[{},[0,0,1]],"e":[{"d":[{},[0,2,1,2]],"i":[{},[0,2,1,2]]}],"n":[{"y":[{},[0,2,1]]}],"o":[{},[0,0,1,2]],"ő":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"h":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{"í":[{},[0,0,1]],"s":[{},[0,0,0,0,1]]}],"t":[{},[0,2,1]],"v":[{},[0,2,1]]},[0,0,0,2]],"ű":[{},[0,0,1,2]]}],"s":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,2]],"t":[{"i":[{},[0,2,1,2]],"n":[{},[0,2,1]],"ű":[{},[0,2,1]]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]],"z":[{"e":[{},[0,2,1]],"r":[{"e":[{"d":[{},[0,2,1]]}]}]},[0,0,0,2]]}],"é":[{"b":[{"e":[{},[0,2,1]]}],"d":[{"e":[{},[0,0,1,2]]}],"g":[{},[0,2,1]],"h":[{"e":[{},[0,2,1,2]],"s":[{},[0,2]]}],"j":[{"e":[{},[0,0,1]]}],"k":[{"e":[{},[0,2,1,2]]}],"l":[{"e":[{},[0,2,1,2]],"é":[{},[0,0,1]],"ő":[{},[0,0,1,2]]}],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"c":[{},[0,2,1]],"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"i":[{".":[{},[0,0,0,2]]}],"m":[{},[0,2,1]],"ő":[{},[0,2,1,2]],"r":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"s":[{},[0,2,1,2]],"t":[{"e":[{"l":[{},[0,0,0,2]]}],"t":[{},[0,2,1]]}],"v":[{"e":[{},[0,2,1]],"é":[{},[0,0,1]]}]}],"f":[{"l":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,0,1]],"i":[{},[0,0,0,0,1,2]],"ő":[{},[0,0,1,2]]}],"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"s":[{},[0,0,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{"á":[{},[0,0,1]],"e":[{"l":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"é":[{},[0,0,0,2,1]]}],"n":[{"a":[{".":[{},[0,0,1,2]]}],"á":[{"b":[{},[0,0,0,2]],"v":[{},[0,0,0,2]]}],"d":[{},[0,2,1]],"f":[{},[0,0,1]],"g":[{},[0,2,1]],"v":[{},[0,0,1]]}],"o":[{"n":[{"o":[{},[0,2,1,2]]}]}],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,2,1]],"i":[{},[0,2,1,2]],"o":[{},[0,2,1]],"t":[{},[0,2,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"z":[{"á":[{},[0,0,0,2,0,1]]}]}],"t":[{"a":[{"l":[{},[0,0,1,2]],"n":[{},[0,0,0,2]]}],"á":[{"s":[{},[0,0,0,2,1]]}],"e":[{},[0,0,0,2,1]],"i":[{"s":[{},[0,0,0,2]]}]}],"z":[{"é":[{},[0,0,1]],"o":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"í":[{"j":[{},[0,0,1]],"r":[{},[0,2,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"j":[{"ó":[{},[0,0,0,0,2]],"ő":[{},[0,0,2]]}],"k":[{"á":[{"r":[{"o":[{"k":[{".":[{},[0,0,0,0,2]]}]}]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"á":[{"b":[{"ú":[{"t":[{},[0,0,0,0,2,1]]}]}]}]}],"o":[{"d":[{"o":[{"r":[{},[0,0,0,2]]}]}],"k":[{"a":[{"s":[{},[0,0,0,2]]}]}],"l":[{"y":[{},[2]]}],"n":[{"t":[{},[0,2,1]]}],"p":[{"e":[{},[0,0,1]]}],"r":[{"a":[{"s":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"i":[{"z":[{},[0,0,0,2]]}],"j":[{"á":[{},[0,2,1]]}]}],"s":[{"t":[{"o":[{},[0,0,1]]}],"z":[{"f":[{},[0,0,0,0,0,2]],"t":[{},[0,2,1]]}]}],"x":[{},[0,2,1]]}],"ö":[{"k":[{},[0,0,1]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"p":[{"e":[{"l":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,1]]}],"o":[{"r":[{"s":[{},[0,0,2,1]]}]}],"ő":[{},[0,0,2]],"u":[{"t":[{"á":[{},[0,0,2,1,2]]}]}]}],"s":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"e":[{".":[{},[0,0,2]],"s":[{"s":[{},[0,0,0,0,0,2]]}]}],"r":[{},[0,0,1,2]]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{"o":[{},[0,2,1]]},[0,0,0,2]],"r":[{},[0,2,1]],"t":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"d":[{},[0,0,1]],"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ű":[{"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"y":[{"a":[{},[0,0,1]]}]}],"n":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"c":[{"é":[{"l":[{},[0,0,0,2]]}]}],"d":[{"a":[{"t":[{},[0,0,0,2]]}],"r":[{},[0,0,0,1]],"s":[{},[0,0,1]]}],"e":[{},[0,0,0,0,2]],"g":[{"g":[{},[0,0,1]],"i":[{},[0,0,1]],"ó":[{},[0,0,1]],"y":[{"h":[{},[0,0,1]]}]}],"j":[{"n":[{},[0,0,1]],"t":[{},[0,2,1]]}],"k":[{"c":[{},[0,0,1]],"k":[{},[0,2,1]],"n":[{},[0,0,1]],"t":[{},[0,2,1]]},[2]],"l":[{"e":[{"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2,1,2]]}],"i":[{"n":[{"t":[{},[0,0,0,2]]}]}],"j":[{".":[{},[0,0,1]],"u":[{},[0,0,1]]}],"o":[{"k":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}]}],"n":[{"i":[{},[1]],"o":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"p":[{"p":[{},[0,0,1]],"r":[{},[0,0,0,1]],"s":[{},[0,0,0,1]]}],"r":[{"á":[{"c":[{},[0,0,0,2]],"d":[{"i":[{},[0,0,0,0,0,0,0,2]]}]}]}],"s":[{"p":[{},[0,0,0,1,2]]}],"t":[{"á":[{"l":[{},[0,0,0,2]]}],"ü":[{"z":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"c":[{},[2]],"g":[{},[0,2,1]],"l":[{"l":[{"o":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"p":[{},[0,2,1,2]],"r":[{"a":[{"d":[{},[0,0,1]],"k":[{},[0,2,1,2]],"t":[{},[0,0,1,2]]}],"b":[{},[0,0,1]],"k":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1,2]],"t":[{},[0,2,1]],"u":[{},[0,2,1,2]],"ú":[{},[0,2,1,2]],"v":[{},[0,0,1]]}],"s":[{"z":[{"a":[{},[0,2,1,2]],"o":[{"k":[{"r":[{},[0,2,1,2]]}]}]}]}],"t":[{"á":[{"l":[{},[0,2,1]],"s":[{},[0,0,0,2]]}],"c":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{"r":[{},[0,0,0,2,1]]}],"f":[{},[0,2,1]],"h":[{"e":[{},[0,2,1]]}],"m":[{},[0,2,1]],"r":[{"e":[{},[0,2,1]]}]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"a":[{"l":[{},[0,0,2]]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"g":[{},[0,0,2,1,2]],"s":[{},[0,0,0,0,2]],"z":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2,1]],"r":[{".":[{},[0,0,2,1]],"é":[{},[0,0,2,1]]}]}],"h":[{"e":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2]],"k":[{"r":[{},[0,0,2,1]]}],"l":[{"l":[{},[0,0,0,1]]}]}],"ö":[{"s":[{},[0,0,2]]}],"s":[{"á":[{"g":[{},[0,0,0,3]]}],"e":[{"g":[{},[0,0,2]],"m":[{"b":[{},[0,0,0,0,1]]}]}],"é":[{"g":[{},[0,0,0,0,1]],"r":[{".":[{},[0,0,2,0,1]]}]}],"i":[{"k":[{"k":[{},[0,0,0,3]]}],"m":[{},[0,0,2,0,1]]}]}],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"d":[{"e":[{".":[{},[0,0,2]]}],"i":[{"k":[{"o":[{},[0,0,0,1]]}]}],"o":[{"k":[{"o":[{"s":[{},[0,0,2,1,2]]}],"s":[{"á":[{},[0,0,0,1]]}]}],"s":[{"z":[{},[0,0,2,1]]}],"z":[{},[2]]}],"ö":[{"l":[{},[0,0,2,1]]}]}],"e":[{"b":[{},[0,0,1,2]],"d":[{},[0,2,1,2]],"g":[{"e":[{},[0,0,1,2]],"g":[{},[0,0,1]],"y":[{},[0,2,1,2]]}],"h":[{},[0,0,1,2]],"l":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,0,1,0,1]],"h":[{},[0,2,1]],"j":[{},[0,0,1]],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{},[0,2,1]],"ő":[{},[0,0,1]],"r":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,2,1]]},[0,0,0,2]],"m":[{},[0,2,1,2]],"n":[{"e":[{},[0,0,1]]},[0,0,0,2]],"r":[{"j":[{},[0,0,1]],"k":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{"e":[{},[0,2,1]],"s":[{},[0,0,0,0,2]],"t":[{},[0,0,1]]},[0,0,0,2]],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"é":[{"b":[{},[2]],"d":[{"e":[{},[0,0,1]]},[0,0,0,2]],"g":[{},[0,2,1,2]],"h":[{"e":[{},[0,2,1,2]]}],"k":[{"e":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"n":[{"e":[{},[0,0,1,2]]}],"p":[{},[0,2,1,2]],"r":[{"b":[{"e":[{},[0,2,1]]}],"c":[{},[0,2,1]],"d":[{},[0,2]],"i":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"p":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"v":[{".":[{},[0,2,1]],"a":[{"d":[{},[0,2]]}],"b":[{},[0,2,1]],"e":[{},[0,2,1,2]],"i":[{},[0,0,1,2]],"k":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,0,1]]}]}],"g":[{"á":[{"l":[{"l":[{},[0,0,2,1]]}],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"e":[{"c":[{},[0,0,2,1,2]],"d":[{},[0,0,2]],"g":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]]}],"i":[{"k":[{},[0,0,2]]}],"l":[{"ó":[{},[0,0,1,2]]}],"ü":[{},[0,0,2]],"y":[{"a":[{"d":[{},[0,0,2]]}],"ő":[{},[0,0,2]]}]}],"h":[{"á":[{"r":[{"o":[{"m":[{},[0,0,0,0,0,0,0,1]]},[0,0,0,0,0,0,2]]}]}]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"j":[{},[0,2,1]],"k":[{"e":[{},[0,0,1,2]]}],"l":[{"l":[{},[0,2,1]]}],"n":[{"b":[{},[0,2,1]],"d":[{},[0,0,1]],"f":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,0,1,2]],"o":[{},[0,2,1]],"t":[{},[0,2,1]]}],"s":[{"k":[{},[0,2,1]],"m":[{},[0,2,1]],"t":[{"e":[{},[0,0,1]]}]}],"t":[{"a":[{},[0,0,0,0,0,2]]}],"z":[{"é":[{},[0,2,1,2]],"o":[{},[0,0,1]],"z":[{},[0,2,1]]}]}],"í":[{"g":[{},[0,0,1]],"n":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,0,1]]}],"k":[{"á":[{"l":[{"l":[{},[0,0,0,1]]}],"r":[{"o":[{"k":[{".":[{},[0,0,0,0,2]]}]}]}]}],"é":[{"t":[{},[0,0,0,0,2,1]]}]}],"n":[{"e":[{".":[{},[0,0,2]]}],"y":[{"á":[{"r":[{},[0,0,3]]}],"e":[{},[0,0,3]],"o":[{},[0,0,3]],"ú":[{},[0,0,3]],"ü":[{},[0,0,3]]}]}],"o":[{"b":[{},[0,2,1]],"g":[{"r":[{"á":[{"f":[{".":[{},[0,0,0,1,2]],"n":[{},[0,0,0,1,2]]}]}]}]}],"k":[{"a":[{"l":[{},[0,0,1,2]]},[0,0,0,0,0,2]],"o":[{"s":[{},[0,0,1,2]]}],"t":[{"a":[{},[0,2,1]]}]}],"l":[{"d":[{},[0,2,1]],"l":[{},[0,0,1]]}],"p":[{"t":[{},[0,0,1]]}],"s":[{"z":[{"l":[{},[0,0,1]],"t":[{"r":[{},[0,0,0,1]]}]}]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]]}],"ó":[{"r":[{"i":[{},[0,2,1]]}],"s":[{"a":[{"k":[{},[0,0,0,2]]}],"i":[{},[0,0,0,2]],"z":[{"e":[{"n":[{},[0,0,0,2]]}]}]}]}],"ö":[{"b":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"ő":[{"s":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{".":[{},[2]],"a":[{"v":[{"a":[{"m":[{},[0,0,0,0,2,1,2]]}]}]}],"k":[{},[0,0,1,2]],"l":[{},[0,0,1]],"m":[{},[0,0,1,2]],"p":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{},[0,0,1]],"t":[{"o":[{},[0,0,1]]}],"z":[{"f":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,0,2]]}],"t":[{"a":[{"g":[{"y":[{},[0,0,0,1]]}],"j":[{},[0,0,2,1]],"l":[{"k":[{},[0,0,2,1]]}],"r":[{"a":[{},[0,0,2,1]]}],"t":[{"r":[{},[0,0,2,1]]}],"z":[{},[0,0,2]]}],"á":[{"l":[{"l":[{},[0,0,2,1]]}],"r":[{"v":[{},[0,0,0,1]]}]}],"e":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1]],"g":[{},[0,0,2,1,2]],"l":[{"á":[{},[0,0,0,1]],"d":[{},[0,0,0,1]],"h":[{},[0,0,0,1]],"l":[{},[0,0,0,1]],"m":[{},[0,0,0,1]],"n":[{},[0,0,2]],"ő":[{},[0,0,2,1]],"t":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]}],"m":[{"b":[{},[0,0,0,1]]}],"s":[{"e":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"é":[{"k":[{"é":[{},[0,0,0,1]]}],"l":[{},[0,0,2]]}],"i":[{"g":[{"é":[{},[0,0,2]]}],"k":[{"o":[{},[0,0,2,1,2]],"r":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1,2]],"n":[{"f":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"s":[{"z":[{"o":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"z":[{},[0,0,2,1]]}],"í":[{"v":[{},[0,0,2,1,2]]}],"o":[{"m":[{"l":[{},[0,0,2,1]]}],"r":[{"s":[{},[0,0,2,1]]}]}],"ó":[{"n":[{"i":[{},[0,0,0,1]]}],"s":[{"t":[{},[1]]}]}],"ö":[{"s":[{},[0,0,2,1]],"z":[{},[0,0,2,1]]}],"ü":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]],"z":[{},[0,0,2,1]]}],"y":[{"e":[{},[0,0,2]]}]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"n":[{"a":[{},[0,2,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]],"s":[{},[0,2,1,2]],"t":[{"b":[{},[0,0,1]],"é":[{},[0,0,1]],"h":[{},[0,0,1]],"i":[{},[0,0,1]],"j":[{},[0,0,1]],"o":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]},[0,0,0,2]]}],"ü":[{"c":[{},[0,0,1,2]],"g":[{},[0,2,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1,2]],"v":[{},[0,0,1,2]],"z":[{},[0,2,1,2]]}],"ű":[{"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"y":[{"a":[{"c":[{"é":[{},[0,2,0,1]]}],"d":[{"ó":[{},[0,0,0,1,2]]}],"k":[{"c":[{},[0,0,0,1]]}],"l":[{"j":[{},[0,0,0,1]],"k":[{},[0,2,0,1]],"t":[{},[0,0,0,1]]}],"n":[{"y":[{"a":[{},[0,0,0,1]]}]}],"p":[{"ó":[{},[0,2,0,1]]},[0,0,0,0,1,2]]}],"á":[{"l":[{},[0,2,0,1]],"r":[{"k":[{},[0,0,0,1]],"n":[{},[0,2,0,1]]}],"z":[{"ó":[{},[0,0,0,1]]}]}],"e":[{"c":[{},[0,0,0,1,2]],"g":[{},[0,0,0,1,2]],"l":[{},[0,2,0,1,2]],"m":[{},[0,2,0,1,2]],"n":[{},[0,2]],"r":[{},[0,2,0,1,2]],"s":[{},[0,0,0,1,2]]}],"é":[{"g":[{},[0,2,0,1]],"j":[{},[0,2,0,1,2]],"k":[{},[0,2,0,1,2]],"l":[{},[0,2,0,1]],"n":[{"e":[{},[0,2,0,1,2]]}],"r":[{".":[{},[0,2,0,1]],"é":[{},[0,2]]}]}],"g":[{"ó":[{"c":[{},[0,0,0,0,0,0,1]]}]}],"i":[{"g":[{"é":[{},[0,2]]}],"k":[{"o":[{},[0,0,0,1]]}],"n":[{"g":[{},[0,0,0,1]]}],"t":[{"a":[{},[0,2]],"ó":[{"k":[{},[0,2]]}]}]}],"í":[{"r":[{},[0,2,0,1,2]]}],"o":[{"l":[{"d":[{},[0,0,0,1]]}],"m":[{"l":[{},[0,0,0,1]]}],"r":[{},[0,2,0,1,2]],"s":[{"z":[{},[0,2]]}]}],"ó":[{"r":[{},[0,0,0,1,2]]}],"ö":[{},[0,2,0,1]],"ő":[{},[0,2,0,1,2]],"u":[{"g":[{},[0,2]],"r":[{},[0,2,0,1]]}],"ü":[{},[0,2,0,1,2]]}],"z":[{"a":[{"b":[{"l":[{},[0,0,0,1]]}],"g":[{},[0,0,2]],"j":[{"t":[{"ó":[{},[0,0,0,1]]}]}],"r":[{},[0,0,2]]}],"á":[{"g":[{},[0,0,2]],"l":[{},[0,0,2,1,2]]}],"e":[{"d":[{},[0,0,2,1]],"l":[{},[0,0,2,1,2]],"m":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2,1]],"r":[{"e":[{},[0,0,2,1]]}]}],"i":[{"m":[{},[0,0,2,1]],"n":[{"g":[{},[0,0,0,1]]}]}],"s":[{"e":[{"l":[{},[0,0,0,3]]}]}],"ü":[{},[0,0,2]]}]}],"o":[{"i":[{"b":[{},[0,0,2]],"n":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]]}],"x":[{"i":[{},[0,0,2]]}]},[0,1]],"ó":[{},[0,1]],"ö":[{},[0,1]],"ő":[{},[0,1]],"p":[{"a":[{"b":[{},[0,2,1,2]],"d":[{},[0,2,1,2]],"l":[{"a":[{},[0,0,1,2]]},[0,2]],"n":[{"y":[{},[0,2,1]]}],"p":[{"o":[{},[0,0,1,2]]}],"r":[{},[0,0,1,2]],"u":[{},[0,0,0,2]],"z":[{},[0,2,1,2]]}],"á":[{"l":[{},[0,2]],"m":[{},[0,2,1]],"r":[{"a":[{"t":[{},[0,2,1,2]]}]}],"s":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"t":[{"h":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"d":[{"é":[{},[0,0,1,2]]}],"g":[{},[0,0,1,2]],"j":[{"t":[{},[0,0,1]]}],"l":[{"ő":[{},[0,0,1]]}],"m":[{},[0,0,1]],"r":[{"a":[{"s":[{"z":[{},[0,0,0,0,0,0,0,2]]},[0,0,0,0,0,1]]}],"d":[{},[0,0,1]],"k":[{},[0,0,1]],"ő":[{},[0,0,1]]}],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"é":[{"l":[{},[0,2,1,2]],"n":[{},[0,2,1,2]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"k":[{"o":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{"d":[{},[0,0,1]],"g":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"a":[{"m":[{},[0,2]]}],"á":[{},[0,2,1,2]]}],"s":[{"i":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{},[0,2,1,2]]}],"z":[{"o":[{},[0,0,1]],"z":[{},[0,0,1]]},[0,0,0,2]]}],"í":[{"v":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"o":[{"b":[{},[0,2,1]],"l":[{},[2]],"r":[{"j":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{"a":[{},[0,0,0,0,2,1,2]],"á":[{},[0,0,0,0,2,1,2]],"e":[{},[0,0,0,0,2,1,2]],"é":[{"r":[{"d":[{},[0,0,0,0,2,1]]}]}],"ö":[{},[0,0,0,0,2]]}],"z":[{"ó":[{},[0,2,1]]}]}],"s":[{"z":[{"f":[{},[0,0,0,0,0,2]]}]}],"v":[{},[0,2,1]]}],"ö":[{"s":[{},[0,0,1]]}],"p":[{"é":[{},[0,0,2]],"i":[{"s":[{},[0,0,2,1]]}],"y":[{},[0,0,1]]}],"r":[{"o":[{"c":[{},[0,0,2]],"d":[{},[0,0,2]]},[2]]}],"s":[{"l":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"u":[{"d":[{},[0,2,1]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,0,1]],"s":[{},[0,2,1]]}],"ü":[{"d":[{},[0,0,1]],"g":[{},[0,0,1]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]}]}],"r":[{"a":[{"b":[{"l":[{},[0,2,1]],"r":[{},[0,2,1]]}],"d":[{"a":[{"t":[{},[0,0,0,2]]}],"á":[{},[0,2,1,2]],"m":[{},[0,0,1]],"ó":[{},[0,2,1,2]]}],"f":[{"f":[{},[0,0,1]]}],"g":[{"g":[{},[0,0,1]],"ó":[{},[0,0,1,2]]}],"k":[{"a":[{"d":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"c":[{},[0,2,1]],"l":[{},[0,0,0,1]],"o":[{"l":[{},[0,0,0,2]]}],"t":[{},[0,2,1]]}],"l":[{"g":[{},[0,0,1]],"j":[{},[0,2,1]],"k":[{},[0,0,1]],"m":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"m":[{"p":[{},[0,0,1]]}],"n":[{"a":[{},[0,2,1]],"e":[{},[0,2,1]],"k":[{},[0,2,1]],"o":[{},[0,2,1,2]],"t":[{},[0,2,1]],"y":[{"a":[{},[0,0,1,2]]}]}],"ó":[{},[0,0,0,0,2]],"p":[{"p":[{},[0,0,1]]}],"r":[{"á":[{},[0,2,1,2]],"c":[{},[0,2,1]],"i":[{},[0,0,1,2]]}],"s":[{"z":[{"k":[{},[0,0,1]]}]}],"t":[{"k":[{},[0,2,1]],"l":[{},[0,2,1]],"t":[{},[0,0,1]],"y":[{},[0,0,1]]}],"z":[{"o":[{},[0,2,1,2]]}]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"c":[{"s":[{".":[{},[0,0,1]],"a":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]]}],"g":[{},[0,2,1,2]],"l":[{"e":[{},[0,0,0,2]],"l":[{"ó":[{},[0,0,1]],"v":[{},[0,2,1]]}],"ö":[{},[0,0,0,2]]}],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"a":[{"k":[{},[0,2,1,2]]}],"á":[{},[0,2,1]],"b":[{},[0,2,1]],"k":[{},[0,2,1]],"o":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1]],"v":[{},[0,2,1]]}],"s":[{"v":[{},[0,2,1]],"z":[{"e":[{},[0,0,0,2]]}]}],"t":[{"a":[{},[0,2,1]],"e":[{},[0,2,1,2,1,2]],"f":[{},[0,2,1]],"h":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"m":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"a":[{"l":[{},[0,0,2,1,2]],"r":[{},[0,0,2]]}],"á":[{"d":[{},[1]]}],"h":[{"á":[{},[0,0,2]],"é":[{},[0,0,2,3]],"o":[{},[0,0,2,3]]}],"s":[{"á":[{"g":[{},[0,0,0,3]]}],"e":[{"b":[{},[0,0,2,3]]}],"é":[{},[0,0,2,3]]}],"ú":[{},[0,0,2]],"z":[{},[0,0,2]]}],"d":[{"a":[{"u":[{},[0,0,2,1]]}],"e":[{"m":[{"e":[{},[0,0,0,1]]}],"s":[{"ő":[{},[0,0,0,1,2]]}],"x":[{},[0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,2,1]]}]}]}],"e":[{"a":[{},[2]],"á":[{},[0,3]],"b":[{},[0,2,1,2]],"c":[{"s":[{},[0,0,1]]}],"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"y":[{},[0,2,1,2]]}],"k":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]]},[2,0,0,2]],"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"h":[{},[0,0,1]],"j":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"o":[{},[0,0,1]],"ő":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]],"m":[{},[0,2,1,2]],"n":[{"e":[{},[0,0,1]],"g":[{},[0,2,1]],"y":[{},[0,0,1]]},[0,0,0,2]],"p":[{},[0,2,1]],"r":[{"ó":[{},[0,0,1]]}],"s":[{"e":[{},[0,0,1]],"é":[{},[0,0,1]],"ő":[{},[0,0,1]],"s":[{},[0,2,1]],"z":[{"e":[{},[0,2,1]]}]},[0,0,0,2]],"v":[{},[0,2,1,2]],"z":[{},[0,0,1]]}],"é":[{"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"j":[{},[0,2,1,2]],"k":[{"á":[{"s":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"n":[{"é":[{},[0,0,1]]}]}],"l":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"n":[{"e":[{},[0,2,1,2]]}],"p":[{},[0,2,1]],"r":[{"é":[{},[0,2,1]]}],"t":[{"e":[{},[0,2,1,2]],"k":[{},[0,2,1]]}],"v":[{".":[{},[0,2,1]],"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"i":[{},[0,2,1,2]],"n":[{},[0,2,1]],"r":[{},[0,2,1]]}]}],"f":[{"é":[{"l":[{"é":[{"v":[{},[0,0,0,0,2,1,2]]}]}]}],"i":[{"ú":[{"é":[{"r":[{},[0,0,0,0,2]]}]}]}]}],"g":[{"i":[{"a":[{"i":[{},[2]]}]}],"l":[{},[0,0,1]]}],"i":[{"b":[{"o":[{},[0,2,1]]}],"d":[{"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"i":[{"o":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"e":[{},[1,2]],"f":[{"j":[{},[0,2,1]]}],"g":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2]],"y":[{},[0,2,1,2]]}],"h":[{"a":[{},[0,0,1]]}],"m":[{"a":[{".":[{},[0,2,1,2]]}],"á":[{},[0,2,1,2]]}],"n":[{"a":[{".":[{},[0,2,1,2]],"s":[{},[0,2]]}],"á":[{"n":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"v":[{},[0,0,1,2]]}],"d":[{},[0,2,1]],"f":[{},[0,2,1]],"g":[{".":[{},[0,2,1]],"c":[{},[0,2,1]],"é":[{},[0,2,1]],"i":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]]}],"h":[{},[0,0,1]],"j":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"a":[{},[0,0,0,0,2,1,2]],"e":[{"l":[{},[0,0,0,0,2]]}],"ő":[{},[0,0,0,0,2,1]]}]}],"o":[{"g":[{},[0,0,0,2]]}],"p":[{},[0,2,1,2]],"s":[{"i":[{},[0,2,1,2]],"m":[{},[0,2,1]],"p":[{},[0,0,1]],"t":[{"e":[{},[0,2,1]]}],"z":[{"á":[{},[0,2,1,2]]}]}],"t":[{"a":[{"n":[{},[0,0,0,2]]}]}],"z":[{"é":[{},[0,2,1,2]]}]}],"í":[{"g":[{},[0,2,1]],"j":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"j":[{"a":[{"i":[{"a":[{},[1]],"é":[{},[1]]}]}],"á":[{},[0,0,3]]}],"k":[{"l":[{},[0,0,1,2]],"ö":[{"z":[{"e":[{"p":[{},[0,0,0,0,2,1,2]]}]}]}],"v":[{},[0,0,1,2]]}],"m":[{"a":[{"p":[{"p":[{},[0,0,2,1]]}],"t":[{"r":[{"e":[{},[0,0,0,0,1,2]]}],"t":[{},[0,0,2,1]]}],"z":[{"o":[{},[0,0,2,1]]}]}],"e":[{"b":[{},[0,0,2,1]],"g":[{"y":[{},[0,0,2,1]]},[0,0,0,0,2]],"l":[{"i":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]}],"r":[{"ő":[{"k":[{},[0,0,0,1]]}]}],"s":[{"z":[{},[0,0,0,1]]}]}],"é":[{"t":[{"e":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"o":[{"s":[{"z":[{},[0,0,2,1]]}]}],"ó":[{"v":[{},[0,0,2]]}],"ö":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]],"ü":[{},[0,0,2]]}],"n":[{"e":[{".":[{},[0,0,2]]}],"i":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]}]}],"o":[{"á":[{},[0,2,1,2]],"g":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"k":[{"á":[{},[0,0,0,2,1,2]],"o":[{"r":[{},[0,0,0,2]]}]}],"l":[{"d":[{"a":[{},[0,2,1]]}],"i":[{},[0,2,1,2]],"t":[{"ó":[{"l":[{},[0,2]]}]}]}],"n":[{"t":[{"ó":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"é":[{},[0,0,1]],"i":[{"g":[{},[0,0,1]]}],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}]}],"y":[{"a":[{},[0,0,0,2]],"o":[{},[0,0,0,2]]}]}],"p":[{"e":[{},[0,0,1]],"t":[{},[0,0,1]]}],"r":[{},[0,2,1,2]],"s":[{"k":[{"o":[{},[0,2,1]]}],"t":[{"o":[{},[0,2,1]]}],"z":[{"i":[{},[1,2]],"r":[{},[1,2]],"t":[{"á":[{},[0,2]]}]}]}],"x":[{},[0,2,1,2]]}],"ó":[{"i":[{"a":[{},[0,0,1,2]]}],"n":[{"i":[{},[0,0,1,2]]}],"r":[{"á":[{},[0,0,1,2]],"i":[{},[0,0,1]]}],"s":[{"á":[{},[0,0,1,2]],"o":[{"r":[{"o":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}]}]}],"ö":[{"b":[{},[0,0,1,2]],"c":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]]}],"p":[{"h":[{},[0,0,1]],"l":[{},[0,0,1]],"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"r":[{"a":[{"b":[{"l":[{},[0,0,0,1]]}],"r":[{},[0,0,2,1,2]]}],"á":[{"t":[{"a":[{},[0,0,2,1]]}]}],"b":[{},[1]],"i":[{".":[{},[1]],"n":[{},[0,0,2]],"z":[{},[0,0,2]]}],"k":[{},[1]],"u":[{"k":[{},[1]]}],"ú":[{".":[{},[1]],"c":[{},[1]]}]}],"s":[{"a":[{"d":[{},[0,0,2,1,2]],"j":[{"t":[{"ó":[{"k":[{},[0,0,2,1]]}]}]}],"l":[{"k":[{},[0,0,0,1]]}],"s":[{"s":[{},[0,0,0,1]]}]}],"á":[{"l":[{},[0,0,2,1]]}],"e":[{"d":[{},[0,0,2]],"s":[{},[0,0,2,1,2]]}],"é":[{"n":[{"e":[{},[0,0,2,1,2]]}],"r":[{"t":[{"e":[{},[0,0,2]]}]}],"t":[{"á":[{"t":[{},[0,0,0,1,2]]}]}]}],"í":[{"r":[{},[0,0,2,1,2]]}],"ö":[{"n":[{},[0,0,2]]}],"ő":[{},[0,0,2]],"r":[{"á":[{},[0,0,1]]}],"t":[{"a":[{"b":[{},[0,0,1,2]]}]}],"ü":[{"l":[{"t":[{},[0,0,0,1]]}],"t":[{"ő":[{},[0,0,0,1,2]]}]}],"z":[{"á":[{"g":[{},[1]]}],"i":[{"l":[{},[0,0,0,0,0,2,1]]}],"ó":[{"n":[{"á":[{},[0,0,0,3]]}]}],"t":[{},[0,0,1,0,2]]}]}],"t":[{"a":[{"g":[{"g":[{},[0,0,2,1]]}],"l":[{"m":[{},[0,0,2,1]]}],"n":[{"a":[{},[0,0,2]],"á":[{"c":[{},[0,0,0,0,2,1,2]]}]}],"r":[{"é":[{},[0,0,2,1]]}]}],"á":[{"g":[{},[0,0,2]],"r":[{"a":[{"d":[{},[0,0,0,1]],"m":[{},[0,0,0,1,2]]}],"á":[{"n":[{},[0,0,0,1,2]],"r":[{},[0,0,0,1,2]]}],"b":[{"e":[{},[0,0,0,1]]}],"n":[{"á":[{},[0,0,0,1]]}],"u":[{"k":[{},[0,0,0,1,2]]}],"ú":[{},[0,0,2,1,2]]}]}],"e":[{"g":[{},[0,0,2,1,2]],"j":[{"t":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,0,2,1]],"e":[{"m":[{},[0,0,0,1,2]]}],"é":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"o":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]],"t":[{},[0,0,2,1]],"v":[{},[0,0,0,1]]}],"m":[{"b":[{},[0,0,0,1]]}],"n":[{"e":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,0,0,2,1]]}],"s":[{"s":[{},[0,0,2,1]]}],"t":[{"i":[{},[0,0,0,1]]}]}],"é":[{"l":[{"e":[{},[0,0,0,1]],"é":[{},[0,0,0,1]],"t":[{},[0,0,0,1]],"v":[{},[0,0,0,1]]}],"r":[{"m":[{},[0,0,2,1]]}]}],"i":[{"d":[{},[0,0,2]],"k":[{"u":[{},[0,0,0,1,2]]}],"n":[{"t":[{},[0,0,2,1]]}],"s":[{"t":[{},[0,0,2,1]]}],"t":[{"a":[{},[0,0,2,1]]}]}],"í":[{"t":[{},[0,0,2]]}],"o":[{"k":[{"m":[{},[0,0,2,1]],"o":[{"l":[{},[0,0,2,1,2]]}],"t":[{"a":[{},[0,0,2,1]]}]}],"l":[{"d":[{},[0,0,2,1]]}],"r":[{"m":[{},[0,0,2,1]]}],"t":[{"t":[{},[0,0,2,1]]}]}],"ó":[{"r":[{},[0,0,2,1,2]]}],"ö":[{"n":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"v":[{},[0,0,2,1,2]]}],"u":[{"r":[{"a":[{},[0,0,0,1]]}]}],"ú":[{"r":[{".":[{},[0,0,0,1]]}]}],"ü":[{"z":[{"é":[{"r":[{},[0,0,2,1,2]]}]}]}]}],"u":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"t":[{"b":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"o":[{"n":[{},[0,2,1,2]]}],"r":[{},[0,2,1]],"s":[{},[0,0,1]],"t":[{},[0,2,1]]}]}],"ü":[{"d":[{},[0,0,1]],"g":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"ű":[{"r":[{},[0,0,1]]}],"v":[{".":[{},[1]],"a":[{"n":[{},[0,0,2,1,2]]}],"á":[{},[2]],"i":[{"s":[{"i":[{},[0,0,0,1]]}]}],"o":[{"s":[{},[1]]}],"ő":[{},[0,0,2]],"v":[{},[1]]}],"z":[{"a":[{"v":[{"a":[{"r":[{".":[{},[0,0,2,1,2]]}]}]}]}],"e":[{"c":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"s":[{"a":[{"n":[{},[0,0,2]]}]}],"z":[{},[0,0,0,1]]}]}],"s":[{"a":[{"b":[{"l":[{},[0,2,1]]}],"d":[{"a":[{},[0,2,1,2]],"ó":[{},[0,2,1,2]]}],"k":[{"c":[{},[0,2,1]]}],"l":[{},[0,2,1,2]],"n":[{"g":[{},[0,2,1]],"t":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"p":[{},[0,2,1,2]],"r":[{"c":[{},[0,0,1]]}],"s":[{"s":[{"z":[{},[0,0,1]]}]}],"t":[{"y":[{},[0,0,1,2]]}],"u":[{},[0,2,1]]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"g":[{},[0,2,1,2]],"l":[{"d":[{},[0,0,1]],"l":[{},[0,2,1]],"o":[{"m":[{},[0,0,1,2]]}]}],"r":[{"a":[{"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"i":[{"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"o":[{"k":[{},[0,0,0,2]]}],"u":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,1]]}],"t":[{"a":[{},[0,0,1,2,1]],"é":[{},[0,0,1]],"j":[{},[0,0,1]],"k":[{},[0,0,1]],"r":[{},[0,2,1]]}]}],"e":[{"d":[{},[0,0,1,2]],"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"m":[{"b":[{},[0,0,1]]}],"n":[{},[0,0,1,2]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,0,1,2]],"x":[{},[0,0,1]],"z":[{},[0,0,1]]}],"é":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"d":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}]}]}],"g":[{"é":[{},[0,0,0,0,2]]}],"i":[{"d":[{"e":[{},[0,2,1]]}],"f":[{},[0,2,1]],"g":[{"a":[{},[0,0,1]]},[0,0,0,2]],"k":[{"r":[{},[0,0,1]]}],"n":[{"f":[{},[0,0,1]],"t":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"á":[{},[0,2,1,2]],"o":[{},[0,0,1]],"t":[{},[0,0,1]]}],"s":[{"m":[{},[0,2,1]],"p":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}]}],"í":[{"j":[{},[0,2,1]],"r":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1]],"r":[{"ó":[{},[0,0,1]]}]}],"o":[{"k":[{},[2]],"n":[{"h":[{},[0,2]],"n":[{},[0,2]],"o":[{},[0,2]],"t":[{},[1,2]],"u":[{},[0,2]],"v":[{},[1]]}],"r":[{},[0,2,1,2]],"s":[{"z":[{},[0,0,1]]}]}],"ó":[{"p":[{},[0,0,0,1]]}],"ö":[{"k":[{},[0,0,1]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1]],"v":[{},[0,0,1,2]]}],"ő":[{"r":[{},[0,0,1,2]]}],"p":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"s":[{"t":[{"a":[{},[0,0,1]]}],"u":[{"r":[{},[0,0,2,1]]},[0,0,0,0,2]],"z":[{"á":[{"l":[{"l":[{},[0,0,0,0,1]]}],"r":[{"o":[{},[0,0,0,0,1,2]]}]}],"e":[{"s":[{},[0,0,0,0,1]]}],"í":[{"j":[{},[0,0,0,0,1]]}],"ó":[{},[0,0,0,0,0,2]],"ő":[{},[0,0,3]]}]}],"t":[{"e":[{"t":[{"e":[{},[0,0,0,1,2]]}]}],"i":[{"p":[{},[0,0,2]],"r":[{},[0,0,2]],"z":[{},[0,0,2]]}],"o":[{"b":[{},[1]],"l":[{"d":[{},[0,0,0,1]]}]}],"ö":[{"s":[{},[0,0,2,1]]}],"u":[{},[2]],"ü":[{},[0,0,2,1,2]],"y":[{"a":[{},[1]]}]}],"u":[{"d":[{},[0,2,1]],"j":[{},[0,2,1]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"r":[{".":[{},[0,0,1]]}],"s":[{},[0,2,1,2]]}],"ü":[{"g":[{},[0,2,1]],"n":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"z":[{"a":[{"b":[{"á":[{},[0,0,3]]}],"j":[{},[0,2]],"l":[{"á":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{"é":[{},[0,0,0,1]]},[0,2]],"t":[{"e":[{},[0,0,0,0,2,1,2]]}]}],"á":[{"l":[{},[0,2,0,1]]}],"e":[{"d":[{},[0,2,0,1]],"g":[{},[0,2,0,1,2]],"l":[{},[0,2,0,1,2]],"n":[{},[0,2,3]],"p":[{},[0,0,0,1]],"s":[{},[0,0,0,1]]}],"é":[{"g":[{},[0,2]],"j":[{},[0,2]],"l":[{},[0,2,0,1,2]],"p":[{},[0,2,0,1,2]],"s":[{},[0,2,0,1]]}],"i":[{"g":[{"e":[{},[0,2]]}],"n":[{"g":[{},[0,0,0,1]]}],"s":[{"m":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]}]}],"í":[{"v":[{},[0,0,0,1]]},[0,0,0,0,2]],"k":[{"l":[{},[0,1]]}],"o":[{"r":[{"o":[{},[0,2,0,1,2]],"s":[{},[0,0,0,1]],"z":[{},[0,2,0,1]]}]}],"ó":[{"n":[{},[0,0,3]],"r":[{},[0,0,0,1,2]]}],"ö":[{"l":[{},[0,0,3]]},[0,2]],"t":[{"a":[{"l":[{"m":[{},[0,0,0,2,1]]}],"n":[{"y":[{},[0,0,0,0,1]]}],"p":[{"o":[{},[0,0,0,2,1]]}]}],"á":[{"r":[{".":[{},[0,0,0,2]],"n":[{},[0,0,0,2,1]]}]}],"e":[{"d":[{},[0,0,0,2]],"l":[{"l":[{},[0,0,0,2]]}],"m":[{},[0,0,0,2,1]]}],"é":[{"r":[{"é":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"í":[{"v":[{},[0,0,0,2,1]]}],"o":[{"s":[{"z":[{},[0,0,0,2,1]]}]}]}],"u":[{"r":[{},[0,2]]}],"ú":[{"r":[{},[0,0,0,1]]}],"ü":[{"g":[{},[0,0,0,1]],"l":[{},[0,0,3]]},[0,2]]}]}],"t":[{"a":[{"b":[{"l":[{},[0,0,1]]}],"d":[{"a":[{},[0,0,1,2]]}],"g":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]],"k":[{},[0,0,0,1]],"n":[{"a":[{},[0,0,1]],"t":[{},[0,2,1]],"y":[{},[0,0,1,2]]}],"p":[{},[0,0,0,1,2]],"r":[{"c":[{},[0,0,1]],"z":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"á":[{"b":[{"r":[{},[0,0,1]]}],"g":[{},[0,2,1,2]],"r":[{"a":[{"k":[{},[0,0,1,2]]}],"á":[{},[0,2,1,2]],"b":[{},[0,2,1]],"é":[{},[0,2,1,2]],"n":[{},[0,0,1]]}]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"b":[{},[0,2]],"g":[{},[0,2,1,2]],"l":[{"a":[{},[0,0,0,0,1]],"á":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2]]}],"ő":[{},[0,0,0,2]]}],"m":[{"á":[{},[0,0,0,2,1]],"o":[{},[0,0,0,2,1]]}],"v":[{},[0,0,1,2]]}],"é":[{"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"t":[{"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"r":[{},[0,0,0,2]]}],"i":[{"d":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{"a":[{".":[{},[0,0,1,2]],"r":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"á":[{"r":[{},[0,0,0,2]]}],"d":[{},[0,2,1]],"k":[{"á":[{},[0,0,0,0,0,0,2]]}]}],"p":[{"a":[{},[2]],"i":[{},[2]],"n":[{},[2]],"t":[{},[2]]}],"r":[{"á":[{},[0,2,1]]}],"s":[{},[0,2,1]],"z":[{"é":[{},[0,2,1]]}]}],"í":[{"j":[{},[0,0,1]],"n":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"o":[{"b":[{},[0,2,1]],"g":[{"r":[{"a":[{"m":[{},[0,0,0,1]]}]}]}],"l":[{"a":[{},[0,0,1]]}],"n":[{"a":[{},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1]],"i":[{"n":[{".":[{},[0,0,0,2,1]]}],"s":[{},[0,0,0,2]]}],"n":[{},[0,0,0,0,3]]}],"r":[{"a":[{"k":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"i":[{"m":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2]]}]}],"s":[{"z":[{"f":[{},[0,0,0,0,0,2]]}]}]}],"ó":[{"f":[{},[0,0,0,1,2]],"p":[{"a":[{"n":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]]}],"o":[{"s":[{"z":[{},[0,0,0,2,1]]}]}]},[2]],"s":[{"é":[{"t":[{"á":[{},[0,0,0,2]]}]}],"s":[{},[0,0,0,0,3]],"t":[{"a":[{},[0,0,0,1]]}],"z":[{"á":[{"r":[{},[0,0,0,2,3]]}]},[0,0,0,1]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ö":[{"l":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"r":[{"a":[{"g":[{},[0,1,2]]}]}],"s":[{"p":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{"g":[{},[0,0,0,0,1,2]]}],"é":[{"g":[{},[0,0,2,1,2]]}],"l":[{},[1]]}],"u":[{"r":[{"a":[{},[0,0,1]]}],"s":[{"z":[{},[0,0,1,2]]}]}],"ú":[{"j":[{},[0,2,1]],"r":[{"i":[{},[0,0,1]]}]}],"ü":[{"l":[{},[0,0,1,2]],"t":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"ű":[{"r":[{},[0,0,1]]}],"v":[{"a":[{"k":[{},[0,0,0,0,1,2]]}]}],"y":[{"a":[{},[0,0,0,0,1]]}]}],"u":[{"a":[{"g":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]]}]},[0,1]],"ú":[{},[0,1]],"ü":[{},[0,1]],"ű":[{},[0,1]],"v":[{"a":[{"g":[{"a":[{},[0,0,0,2]],"i":[{"n":[{},[0,0,0,2,1,2]]}]}],"r":[{"a":[{"n":[{},[0,0,0,2,1]]}],"á":[{"t":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2,1]]}],"é":[{"k":[{},[0,0,0,2]],"s":[{},[0,0,0,2]]}],"i":[{"s":[{},[0,0,0,2]]}]}],"s":[{"s":[{},[0,0,0,0,3]]}],"u":[{},[0,0,0,0,2]]}],"á":[{"b":[{"b":[{"o":[{},[0,0,0,0,2,1]]}]}],"s":[{"á":[{"r":[{"á":[{},[0,0,0,2,1,2]]}]}],"i":[{"k":[{},[0,0,0,2]]}]}]}],"i":[{"o":[{},[0,0,0,0,2]]}]}],"w":[{"e":[{"l":[{},[0,0,1]]}]}],"x":[{"i":[{"d":[{"b":[{},[1]],"r":[{},[1]]}],"g":[{"é":[{},[0,2]]}],"l":[{"c":[{},[1]]}]}]}],"y":[{"c":[{"e":[{},[0,0,2]]}]}],"z":[{"a":[{"g":[{"a":[{},[0,0,0,0,1]],"i":[{},[0,0,1]]},[0,0,0,2]],"l":[{},[0,2,1,2]],"m":[{"a":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"é":[{"r":[{"t":[{"é":[{},[0,0,0,2,1]]}]}]}],"i":[{"n":[{},[0,0,0,2]]}]}],"n":[{"y":[{},[0,2,1]]},[0,0,0,2]],"r":[{"a":[{},[0,0,1]]},[0,0,0,2]],"t":[{"a":[{"t":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"é":[{"s":[{},[0,0,0,2]],"t":[{"e":[{},[0,0,0,2,1,2]]}]}],"i":[{"l":[{"l":[{},[0,0,0,0,1]]}]}],"í":[{},[0,0,0,2,1,2]],"o":[{"l":[{},[0,0,0,2,1]]}]}],"u":[{},[0,2,1]]}],"á":[{"g":[{},[0,2,1,2]],"k":[{"e":[{},[0,0,0,2]]}],"l":[{"l":[{},[0,0,1]]}],"r":[{"o":[{},[0,2,1,2]],"u":[{},[0,2,1]]}],"s":[{"e":[{},[0,0,0,2,1]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"t":[{"l":[{},[0,2,1]]}]}],"e":[{"g":[{},[0,0,1,2]],"m":[{},[0,0,1,2]],"n":[{},[0,0,1]]}],"é":[{"k":[{"e":[{},[0,0,0,2,1,2]]}],"l":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{"é":[{},[0,2,1,2]]}]}],"i":[{"d":[{"o":[{},[0,0,1,2]]}],"p":[{"a":[{"r":[{},[0,2,1,2]]}]}],"r":[{"o":[{},[0,0,1]]}],"s":[{"a":[{"j":[{},[0,0,0,2,1]]}],"l":[{},[0,0,0,1]],"t":[{},[0,0,0,1]],"z":[{},[0,0,0,1,0,2]]}],"t":[{"a":[{},[0,0,0,2,1,2]]}]}],"í":[{"n":[{},[0,0,1,2]]}],"o":[{"r":[{"s":[{},[0,0,1]]},[0,2]],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"e":[{"g":[{"y":[{"e":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}]}],"f":[{"i":[{"a":[{},[2]],"á":[{"b":[{},[2]],"h":[{},[2]],"j":[{"a":[{},[2]]}],"n":[{".":[{},[2]],"a":[{},[2]]}],"r":[{},[2]],"t":[{".":[{},[2]],"ó":[{},[2]]}],"v":[{"a":[{},[2]]}]}]}]}],"t":[{"a":[{"n":[{},[0,0,0,2]]}]}]}],"p":[{"r":[{},[0,0,1,2]]}],"s":[{"a":[{"l":[{},[0,2,0,1,2]],"n":[{"y":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ő":[{},[0,2,0,1]],"s":[{},[0,0,0,1]],"ü":[{},[0,2]]}],"ü":[{"n":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"ű":[{"r":[{},[0,0,1]]}],"z":[{"á":[{"s":[{},[0,0,0,0,1,2]]}]}]}]}],"ó":[{".":[{},[2]],"a":[{"c":[{"é":[{},[0,0,2]]}],"d":[{"a":[{"g":[{},[0,0,2]]}],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"y":[{},[0,0,2]]}],"j":[{"á":[{},[0,0,2]],"t":[{"ó":[{"i":[{},[0,0,0,0,0,0,2]]}]}]}],"k":[{"a":[{"d":[{},[0,0,2]],"r":[{},[0,0,2]]}],"á":[{},[0,0,2]],"u":[{},[0,0,2]]}],"l":[{"a":[{"g":[{},[0,0,0,0,2,1]]},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2,1]],"m":[{"a":[{"n":[{"a":[{"c":[{},[0,0,0,0,0,0,0,0,3]]},[0,0,0,0,0,0,0,2]]}]}]}],"o":[{"s":[{},[0,0,0,1]]},[0,0,2]],"u":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,2]]}],"n":[{"a":[{},[0,0,2]],"ó":[{},[0,0,2]],"y":[{},[0,0,2]]}],"p":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"t":[{"o":[{"m":[{},[0,0,0,0,0,1]]},[0,0,2,0,2]],"y":[{},[0,0,2]]}],"u":[{"k":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]]}],"x":[{"i":[{},[0,0,2]]}],"z":[{"o":[{},[0,0,2]]}]},[0,1]],"á":[{"b":[{"é":[{},[0,0,2]]}],"c":[{"s":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"y":[{"ú":[{},[0,0,2]]}]}],"h":[{"í":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"s":[{"a":[{},[0,0,2]],"ó":[{},[0,0,2]],"z":[{},[0,0,2]]}],"t":[{"a":[{"d":[{"ó":[{".":[{},[0,0,0,1,2]]}]}]},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2,1,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2,1,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2,1]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[0,1]],"b":[{"a":[{"b":[{},[2]],"j":[{},[2]],"k":[{},[2]],"l":[{},[2]],"n":[{"d":[{},[2]],"k":[{},[2]]}],"p":[{},[0,0,0,1,2]],"r":[{"á":[{},[2]],"k":[{},[2]],"n":[{"a":[{},[2]]}]}],"s":[{},[0,0,0,0,2]],"t":[{"r":[{},[0,0,0,1,2]]}],"u":[{},[0,0,0,0,2]]}],"e":[{"c":[{},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"j":[{},[2]],"k":[{},[2]],"l":[{"e":[{},[2]],"é":[{},[2]],"s":[{},[2]]}],"m":[{},[2]],"o":[{},[2]],"r":[{},[2]],"t":[{},[2]],"v":[{},[2]],"z":[{},[2]]}],"é":[{"g":[{},[0,2]]}],"i":[{"l":[{},[2]],"o":[{},[2]],"r":[{},[2]],"t":[{},[2]],"z":[{},[2]]}],"l":[{"e":[{},[0,1,2]],"o":[{},[0,1,2]]}],"ó":[{"j":[{},[2]],"l":[{"é":[{},[2]]}]}],"r":[{"á":[{},[0,0,2]],"o":[{},[0,1,2]],"ó":[{"k":[{},[0,0,2]]}],"u":[{},[0,1,2]]}],"u":[{"d":[{"a":[{"i":[{"k":[{},[0,0,0,0,0,2]]}]}]}],"s":[{"z":[{"t":[{},[0,0,0,0,0,0,2]],"ú":[{},[0,0,0,2,0,1]]}]}]}]}],"c":[{"a":[{"j":[{},[0,2,1]],"k":[{"r":[{},[0,2,1]]}],"l":[{"a":[{},[0,0,1,2]],"k":[{},[0,0,1]]}],"r":[{},[0,2,1]],"s":[{"s":[{},[0,2,1]]}],"t":[{"t":[{},[0,0,1]]}]}],"á":[{"l":[{},[0,2,1]]}],"e":[{"á":[{},[1,2]],"g":[{},[0,2,1,2]],"l":[{"e":[{},[0,0,1]],"m":[{},[0,0,1]],"ő":[{},[0,0,1]]},[0,0,0,2]],"m":[{"b":[{},[0,0,1]]}],"v":[{},[0,2,1,2]]}],"é":[{"p":[{},[0,2,1]],"t":[{},[0,2,1]]}],"h":[{"á":[{},[0,0,3]],"e":[{},[0,0,3]],"o":[{},[0,0,3]]}],"i":[{"m":[{"i":[{},[0,0,1]]},[0,0,0,2]],"n":[{"g":[{},[0,0,1]]}],"p":[{"a":[{},[0,2,1,2]]}],"s":[{},[0,2,1]]}],"l":[{"u":[{},[0,0,2]]}],"o":[{"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"r":[{},[0,0,1,2]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"a":[{},[2]],"á":[{"g":[{},[0,0,3]],"r":[{"u":[{},[0,2,0,1]]}]}],"e":[{},[2]],"é":[{},[2]],"i":[{"t":[{},[0,2]]},[2]],"í":[{},[2]],"o":[{},[2]],"ö":[{},[2]],"ő":[{},[2]],"p":[{"á":[{},[0,0,3,2]]},[0,0,0,1]],"z":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"d":[{},[0,2,1]]}],"ü":[{"n":[{},[0,0,1]],"z":[{},[0,0,1]]}],"z":[{"a":[{},[0,0,3]],"e":[{},[0,0,3]],"u":[{},[0,0,3]]}]}],"d":[{"a":[{"d":[{"a":[{},[0,0,1]],"á":[{},[0,0,1,2]]}],"j":[{"á":[{},[0,0,1]]},[0,0,0,2]],"k":[{"t":[{},[0,0,1]]}],"l":[{".":[{},[2]],"a":[{},[2]],"g":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{"a":[{},[0,0,1]]}],"r":[{"a":[{"b":[{"k":[{},[2]]}]}],"á":[{},[2]]}],"u":[{"t":[{},[0,0,1]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"f":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{},[0,2,1]],"p":[{},[0,2,1]],"r":[{"n":[{},[0,2,1]],"u":[{},[0,0,1,2]]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"e":[{"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"l":[{"e":[{"m":[{},[0,0,1,2]]}],"h":[{},[0,2,1]],"j":[{},[0,0,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"o":[{},[0,2,1]],"ő":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,2,1]]}],"m":[{"b":[{},[0,0,1]],"e":[{},[0,0,1]]}],"p":[{},[0,0,1]],"r":[{"a":[{},[0,0,0,2]],"ő":[{},[0,0,1]]}],"s":[{"é":[{"s":[{},[0,0,0,2]]}]}],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"t":[{"e":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"é":[{},[0,2,1]]}],"n":[{"t":[{},[0,2,1]]}],"p":[{"a":[{},[0,2,1]]},[0,0,0,2]],"r":[{"o":[{},[0,2,1]]}],"s":[{"z":[{},[0,0,0,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"í":[{"r":[{},[0,2,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"o":[{"b":[{},[2]],"g":[{"a":[{},[0,0,0,2]]}],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"p":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}],"x":[{},[0,2,1,2]]}],"ó":[{"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]}]}]}],"r":[{"á":[{},[0,0,1]]}]}],"ö":[{"l":[{},[0,2,1,2]],"s":[{},[0,0,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"a":[{"m":[{},[2,1,2]]}],"á":[{"m":[{},[0,0,2]]},[2]],"o":[{"g":[{},[0,1,2]]}],"ó":[{"t":[{},[0,1,2]]}],"u":[{"k":[{},[0,0,2]]}]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"u":[{"g":[{},[2]],"r":[{"a":[{},[0,2,1]]},[0,0,0,2]],"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"t":[{},[0,2,1,2]]}],"ú":[{"j":[{},[0,2,1]],"r":[{".":[{},[0,0,1]]}]}],"ü":[{"g":[{},[0,0,1]],"r":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"z":[{"á":[{"r":[{},[0,0,3]]}],"e":[{},[0,2,3]],"s":[{"o":[{},[0,0,3]]}]}]}],"e":[{"b":[{"é":[{},[0,0,2]]}],"c":[{"h":[{},[0,0,2]],"s":[{},[0,0,2]]}],"d":[{"é":[{},[0,0,2]],"z":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{"s":[{"z":[{},[0,0,0,0,0,0,1]]}]},[0,0,2]],"y":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"n":[{},[0,0,0,1]]},[0,0,2]],"é":[{"r":[{},[0,0,0,1]]},[0,0,2]],"i":[{},[0,0,2,2]],"í":[{},[0,0,2,1,2]],"o":[{},[0,0,2]],"ő":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"m":[{"b":[{"e":[{"r":[{"é":[{"k":[{},[0,0,0,0,0,2,1]]}]}]}]}],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"u":[{},[0,0,2]]}],"n":[{"e":[{},[0,0,2]]}],"p":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ó":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"s":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]],"z":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"z":[{"ü":[{},[0,0,2]]}]},[0,1]],"é":[{"b":[{"e":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"h":[{"e":[{},[2,0,2]],"s":[{},[2]]}],"k":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"n":[{"e":[{},[2,0,2]]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{".":[{},[2]],"d":[{},[2]],"e":[{},[2,0,2]],"é":[{},[2,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]],"t":[{"e":[{},[2]],"é":[{},[2]]}],"z":[{},[2]]}],"t":[{"e":[{},[0,0,2]],"k":[{},[2]]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ü":[{},[0,0,2]]}]},[0,1]],"f":[{"a":[{".":[{},[2]],"a":[{},[2]],"á":[{},[2]],"b":[{},[2]],"c":[{},[2]],"d":[{},[2]],"e":[{},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2]],"k":[{},[2]],"l":[{},[2]],"o":[{},[2]],"p":[{},[2]],"r":[{},[2]],"s":[{"t":[{},[0,0,0,1]]},[2]],"t":[{},[2,0,0,1,2]],"ü":[{},[2]],"v":[{},[2]],"z":[{},[2]]}],"e":[{"l":[{"e":[{"m":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2]]}]}],"v":[{},[0,2,1]]}],"é":[{"k":[{},[2]],"l":[{"ő":[{},[2]],"t":[{},[2]]}],"n":[{},[2]],"r":[{".":[{},[0,2,1]]}]}],"i":[{"a":[{"b":[{},[0,0,0,2]],"d":[{},[0,0,0,2]],"g":[{},[0,0,0,2]]}]}],"l":[{"a":[{},[0,1,2]],"o":[{},[0,1,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2]]}],"o":[{"c":[{},[2]],"g":[{},[2]],"k":[{},[2]],"l":[{},[2]],"r":[{"d":[{},[2]],"g":[{},[2]],"m":[{"á":[{"c":[{},[2]],"j":[{},[2]],"l":[{},[2]]}]}],"r":[{},[2]]}],"s":[{},[2]],"t":[{},[2]],"v":[{},[0,2,1]]}],"r":[{"a":[{"k":[{},[0,1,2]]}],"i":[{},[0,1,2]],"í":[{},[0,1,2]],"o":[{},[0,1,2]],"ö":[{},[0,1,2]]}],"u":[{"d":[{},[0,2,1]],"r":[{"a":[{},[0,0,1]]},[0,0,0,2]]}],"ú":[{"r":[{".":[{},[0,0,1]],"n":[{},[0,0,1]]}]}]}],"g":[{"a":[{"p":[{},[0,0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"o":[{},[0,0,0,2]]}],"é":[{"p":[{"i":[{"p":[{},[0,0,0,2,1,2]]}]}]}],"g":[{"y":[{},[0,0,3]]}],"i":[{"a":[{"l":[{},[0,0,0,2]]}]}],"í":[{"r":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]]}],"o":[{"r":[{"a":[{"s":[{},[0,0,0,2]]}]}]}],"r":[{"a":[{"f":[{},[0,1,2]]}],"á":[{"n":[{},[0,0,2]]}]}],"u":[{"s":[{"a":[{"b":[{},[0,0,0,2]]}],"z":[{},[0,0,0,2,3]]}]}],"y":[{"e":[{"l":[{},[0,2,0,1]],"s":[{},[0,2,0,1]]}],"i":[{".":[{},[0,3]],"n":[{"t":[{},[0,0,0,1]]}]}],"ö":[{"k":[{"é":[{"r":[{"b":[{},[0,0,0,0,2,1]]}]}]}]}],"t":[{"a":[{"n":[{"á":[{},[0,0,0,0,0,2,1,2]]}]}],"e":[{"a":[{},[0,0,0,0,0,2]]}]}],"ú":[{"s":[{},[0,0,0,1]]}]}]}],"h":[{"a":[{"d":[{"e":[{},[0,0,0,2]]}],"l":[{},[2]],"n":[{},[2]],"s":[{},[2]],"t":[{},[2]]}],"á":[{"z":[{"a":[{"d":[{"a":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}]}],"o":[{"n":[{},[2]],"r":[{},[2]],"s":[{},[2]]}],"ú":[{"s":[{"s":[{},[0,0,0,0,1]]}]}]}],"i":[{"d":[{"e":[{},[2,0,2]],"é":[{"n":[{},[0,0,2]]},[2]],"i":[{},[0,0,2]],"o":[{"m":[{},[2,0,2]]}],"ő":[{},[2,0,2]]}],"g":[{"a":[{},[2,0,2]],"e":[{},[2,0,2]],"é":[{"b":[{},[0,0,2]],"i":[{},[0,0,2]],"j":[{},[0,0,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]],"v":[{},[0,0,2]]},[2]]}],"k":[{"o":[{"n":[{"b":[{},[0,0,2]],"j":[{},[2,0,2]],"n":[{},[2,0,2]],"o":[{},[2,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}]}]}],"l":[{"e":[{},[0,0,0,0,2]],"l":[{},[2]]}],"m":[{"a":[{".":[{},[0,0,2]]}],"á":[{},[2,0,2]],"i":[{},[0,0,2]],"p":[{},[2]]}],"n":[{"a":[{".":[{},[2,0,2]],"i":[{},[0,0,2]],"k":[{"a":[{},[0,0,2]]}],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"d":[{},[2]],"f":[{},[2]],"g":[{},[2]],"i":[{},[2,0,2]],"j":[{},[2]],"p":[{},[2]],"t":[{},[2]],"v":[{},[2]]}],"p":[{"a":[{},[0,0,2]]}],"r":[{"a":[{"t":[{},[2,0,2]]}],"á":[{},[2,0,2]],"o":[{},[2,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"a":[{},[2,0,2]],"ó":[{"k":[{},[0,0,2]]}]}],"v":[{"a":[{"d":[{},[0,0,2]]}]}],"z":[{"é":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[0,1]],"í":[{"r":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"t":[{"é":[{},[0,0,2]]}],"v":[{"é":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[0,1]],"j":[{"a":[{"g":[{},[0,0,0,1,2]],"k":[{"é":[{"n":[{".":[{},[2]]}]}],"r":[{},[0,0,0,0,2]]}],"m":[{},[2]],"p":[{},[0,0,0,1,2]],"v":[{},[2]]}],"á":[{"r":[{"á":[{},[2]],"m":[{},[2]],"ó":[{".":[{},[2]]}],"u":[{},[2]],"v":[{},[2]]}],"t":[{"é":[{},[2]],"s":[{},[2]]}]}],"e":[{"g":[{"y":[{"á":[{},[0,0,0,2,0,1,2]]}]}]}],"u":[{"t":[{},[2]]}]}],"k":[{"a":[{"b":[{},[2]],"d":[{"a":[{},[0,0,1,2]]}],"j":[{"t":[{},[0,0,1]]}],"k":[{"ó":[{},[0,2,1]]}],"l":[{"j":[{},[0,2,1]],"k":[{"o":[{},[0,0,1]]}],"ó":[{},[2]]}],"m":[{"p":[{},[2]],"r":[{},[2]]}],"p":[{"a":[{},[2]],"c":[{},[2]],"s":[{},[2]]}],"r":[{".":[{},[2]],"a":[{},[2]],"r":[{},[2]],"t":[{},[2]]}],"t":[{"a":[{},[2]],"e":[{},[2]],"r":[{},[0,0,0,1,2]]}],"u":[{"t":[{},[0,0,1]]}],"v":[{},[2]],"z":[{},[2]]}],"á":[{"l":[{"l":[{},[0,2,1]]}],"r":[{"a":[{"d":[{},[0,0,1]]}],"i":[{},[0,2,1,2]],"n":[{},[0,2,1]],"u":[{},[0,2,1]]}]}],"e":[{"d":[{"z":[{},[0,2,1]]},[2,0,0,2]],"g":[{"é":[{},[0,0,1]]}],"m":[{"b":[{},[0,2,1]]},[2]],"r":[{"e":[{"s":[{"t":[{"e":[{},[0,0,0,0,1]]}]}]}],"é":[{"k":[{"n":[{"é":[{},[0,0,0,2,1]]}]}]}],"i":[{"g":[{},[0,0,0,2]]}],"ő":[{},[0,2,1,2]],"ü":[{"g":[{},[0,0,0,2,1]]}]},[2]],"s":[{"z":[{"e":[{},[0,0,1]]},[0,0,0,2]]}],"t":[{"e":[{},[0,0,1]]},[0,0,0,2]],"v":[{},[2]],"z":[{},[2]]}],"é":[{"l":[{},[0,2,1,2]],"m":[{},[2]],"n":[{"y":[{},[2]]}],"p":[{".":[{},[2]],"b":[{},[2]],"e":[{"l":[{},[0,0,0,2,1,2]]},[2]],"é":[{},[2]],"l":[{},[2]],"n":[{},[2]],"p":[{"e":[{"l":[{},[2]]}]}],"r":[{},[2]],"t":[{},[2]],"z":[{},[2]]}],"r":[{".":[{},[0,2,1]],"d":[{},[2]],"e":[{},[2]],"é":[{},[2]],"ő":[{},[2]]}],"s":[{},[2]],"t":[{"t":[{},[0,2,1]],"v":[{},[0,0,1]]}]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"i":[{"á":[{},[0,0,2]]}]}],"i":[{"a":[{},[2]],"á":[{},[2]],"c":[{},[2]],"e":[{},[2,0,0,0,2]],"é":[{},[2]],"f":[{},[2]],"g":[{"a":[{},[0,0,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"í":[{},[2]],"j":[{},[2]],"l":[{"l":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]]},[2]],"n":[{"c":[{},[2]],"e":[{},[2]],"t":[{},[0,2,1]],"y":[{},[2]]}],"o":[{},[2]],"s":[{"k":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[2]]}],"t":[{},[2]],"v":[{"a":[{},[0,0,1,2]]},[2]]}],"k":[{"r":[{},[0,0,1,2]]}],"l":[{"i":[{"m":[{},[0,0,2]]}],"í":[{},[0,1,2]],"ó":[{},[2,1,2]],"u":[{},[2,1,2]]}],"o":[{"c":[{"k":[{},[2]],"o":[{},[2]]}],"e":[{},[2]],"h":[{},[2]],"l":[{"l":[{},[2]]}],"m":[{"é":[{},[2]],"f":[{},[2]],"p":[{},[2]]}],"n":[{"c":[{},[2]],"f":[{},[2]],"j":[{},[2]],"s":[{},[2]],"t":[{},[2]],"y":[{},[2]],"z":[{},[2]]}],"o":[{},[2]],"p":[{},[2]],"r":[{"á":[{"s":[{},[0,0,0,2,1,2]]},[2]],"b":[{},[2]],"e":[{},[2]],"g":[{},[0,2,1]],"i":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"o":[{},[2]],"r":[{},[2]],"s":[{},[2]],"u":[{},[2]]}],"s":[{"z":[{"l":[{},[0,2,1]]}]}]}],"ó":[{"d":[{},[2]],"l":[{},[0,0,1,2]],"r":[{},[2]],"v":[{},[0,2,1]]}],"ö":[{"l":[{"é":[{},[0,0,1,2]],"ő":[{},[0,0,1,2]]},[2]],"r":[{"d":[{},[0,0,1]]}],"t":[{"l":[{},[0,0,1]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"r":[{"á":[{},[0,1,2]],"e":[{"á":[{},[0,0,2]]}],"é":[{"m":[{},[2,1,2]],"t":[{},[0,0,2]]}],"i":[{},[2,1,2]],"í":[{},[0,1,2]],"o":[{"n":[{},[0,0,2]],"s":[{},[0,0,2]]}],"ó":[{"n":[{},[2,1,2]]}]}],"s":[{"k":[{},[0,0,1]],"t":[{},[0,0,1]]}],"u":[{"g":[{},[0,2,1]],"m":[{},[0,2]],"p":[{},[2]],"r":[{},[2]],"s":[{"z":[{"á":[{"l":[{},[0,0,0,2,0,1]]}],"e":[{},[0,0,0,2]]}]}],"t":[{},[2]]}],"ú":[{"r":[{},[2]]}],"ü":[{"g":[{},[0,2,1]],"l":[{},[2]],"s":[{},[2]],"z":[{"l":[{},[0,0,1]]}]}],"v":[{"ó":[{},[2,1,2]]}]}],"l":[{"a":[{"j":[{"t":[{},[0,0,1]]}],"m":[{"a":[{"n":[{},[0,0,0,2]]}]}],"p":[{"a":[{},[0,0,0,2]],"á":[{"l":[{},[0,2,1,2]]}],"o":[{"l":[{},[0,0,0,2]],"s":[{"z":[{},[0,0,0,2,1]]}]}]}],"r":[{"á":[{},[0,0,1,2]]}],"z":[{"o":[{},[0,0,1]]}]}],"á":[{"b":[{"ú":[{"t":[{},[0,0,0,2,1]]}]}],"l":[{},[1,2]],"s":[{"s":[{},[0,0,0,0,3]],"ü":[{},[0,0,0,2]]}],"t":[{"l":[{},[0,0,1]]}]}],"e":[{"í":[{},[0,0,0,0,2]],"s":[{"e":[{},[0,0,1,2]],"é":[{},[0,0,1,2]],"h":[{},[0,0,1]],"n":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{},[0,0,0,2]],"e":[{"v":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}],"é":[{"r":[{"z":[{},[0,2,1]]}],"t":[{"e":[{"l":[{},[0,0,0,2]]}],"é":[{"s":[{},[0,0,0,2]]}]}]}],"i":[{"a":[{"k":[{"o":[{},[0,0,0,2]]}],"m":[{},[0,0,0,2]]}],"s":[{"z":[{"o":[{},[0,0,1]]}]},[0,0,0,2]]}],"í":[{"n":[{},[0,0,1]]}],"o":[{"m":[{"a":[{"l":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]],"á":[{},[0,0,0,2,1]],"e":[{},[0,0,0,2,1]],"i":[{"s":[{},[0,0,0,2]]}],"r":[{},[1,2]]}],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"á":[{},[0,0,0,0,2]],"s":[{"l":[{},[0,0,0,1]],"p":[{},[0,0,0,1]]}],"t":[{},[0,0,0,0,2]]}],"ö":[{"l":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"p":[{"r":[{},[0,0,1,2]]}],"u":[{"m":[{"e":[{},[0,0,0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{"á":[{},[0,0,0,2]]}]}]}],"ü":[{"t":[{},[0,0,1]],"v":[{},[0,0,1]]}],"y":[{"a":[{"g":[{"a":[{},[0,0,0,0,2]],"g":[{},[0,0,0,0,0,1]]}]}],"á":[{},[0,0,0,2]]}]}],"m":[{"a":[{"b":[{"l":[{},[0,0,1]]}],"c":[{"é":[{},[0,2,1,2]]}],"g":[{"n":[{},[2]]}],"k":[{"n":[{},[0,0,1]]}],"l":[{"l":[{},[0,0,1]]}],"n":[{},[2]],"r":[{"a":[{},[2]],"c":[{},[2]],"e":[{"n":[{},[0,0,0,0,0,0,2]]}],"h":[{},[2]],"k":[{},[2]]}],"s":[{"p":[{},[0,0,0,1]],"s":[{},[2]]},[0,0,0,0,2]],"t":[{"e":[{},[2]],"o":[{},[0,0,1,2]]}],"u":[{},[0,2,1]],"x":[{},[2]]}],"á":[{"g":[{},[2]],"l":[{"l":[{},[0,0,1]]}],"r":[{"k":[{},[2]],"t":[{},[2]]}],"z":[{},[2]]}],"b":[{"r":[{},[0,0,1,2]]}],"e":[{"g":[{"y":[{},[0,0,1,2]]}],"n":[{".":[{},[0,2]]}]}],"é":[{"d":[{},[2]],"l":[{"e":[{},[0,0,1]]},[2]],"p":[{},[0,2,1]],"r":[{"e":[{},[2]],"é":[{},[2]],"g":[{},[2]],"k":[{},[2]],"n":[{},[2]],"ő":[{},[2]],"s":[{},[2]],"t":[{"é":[{},[2]]}]}]}],"i":[{"a":[{"c":[{},[0,0,0,0,0,1]],"s":[{},[0,0,0,2]]}],"b":[{},[0,2,1,2]],"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1]]},[2,0,0,2]],"n":[{},[2]],"o":[{"n":[{"o":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}]}],"p":[{},[0,2,1,2]],"s":[{"k":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,0,0,2]]},[2]],"z":[{},[0,2,1,2]]}],"o":[{"d":[{},[2]],"g":[{},[2]],"h":[{},[2]],"l":[{"a":[{},[0,2,1]],"d":[{},[0,2,1]]}],"n":[{"d":[{},[2]],"i":[{},[2]],"o":[{},[2]],"t":[{},[2]]}],"r":[{},[2]],"s":[{"z":[{},[0,2,1]]},[2]],"t":[{},[2]],"x":[{},[0,2,1]],"z":[{},[2]]}],"ö":[{"t":[{},[0,0,1]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"ü":[{"t":[{},[0,0,1]],"z":[{},[0,0,1]]}],"ű":[{"t":[{},[0,0,0,0,2]]}]}],"n":[{"a":[{"d":[{},[2]],"g":[{},[2]],"k":[{"á":[{"s":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2,1,2]],"o":[{"l":[{},[0,0,0,2]]}]}],"l":[{"j":[{".":[{},[0,0,1]],"a":[{"k":[{},[0,0,1]]}],"á":[{},[0,0,1]],"o":[{},[0,0,1]],"u":[{},[0,0,1]]}]}],"p":[{"a":[{".":[{},[0,0,0,2]]}],"á":[{"b":[{"a":[{},[0,2,1]]}]},[0,0,0,2]],"e":[{},[0,0,0,2]]},[2]],"r":[{"c":[{},[0,0,1]]}],"s":[{"p":[{},[0,2,1]],"z":[{"t":[{},[0,0,1]]}]}],"t":[{},[0,0,0,1,2]],"v":[{},[2]]}],"á":[{"l":[{"l":[{},[0,2,1]],"o":[{},[0,2,1]]},[0,0,0,2]],"s":[{"s":[{},[0,0,0,0,1]]}]}],"b":[{"r":[{},[0,0,1]]}],"e":[{"d":[{},[0,0,0,2]],"z":[{},[0,0,1]]}],"é":[{"é":[{},[1,2]],"m":[{},[2]],"p":[{"í":[{},[0,0,1]]}],"r":[{"a":[{},[1,2]],"c":[{},[0,0,1]],"d":[{},[0,2]],"ó":[{},[1,2]]}],"v":[{"á":[{},[0,0,0,2,1]]}],"z":[{},[2]]}],"i":[{"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"s":[{"t":[{},[0,2,1]]}]}],"o":[{"d":[{"v":[{},[0,0,1]]}],"k":[{"u":[{"l":[{},[1,2]]}]}],"r":[{},[2]],"x":[{},[0,0,1]]}],"ö":[{"n":[{},[0,0,1]],"r":[{},[0,2,1]],"t":[{},[0,0,1]]}],"ő":[{"é":[{"h":[{},[0,0,0,0,2]]}]}],"p":[{"r":[{},[0,0,1]]}],"u":[{"t":[{},[0,2,1,2]]}],"ü":[{"r":[{},[0,0,1]]}],"y":[{"a":[{},[2]],"e":[{},[2]],"i":[{"l":[{},[2]],"t":[{"á":[{},[2]],"ó":[{".":[{},[2]]}]}]}],"í":[{},[2]],"o":[{},[2]],"u":[{},[2]],"ú":[{},[2]]}]}],"o":[{"d":[{"ú":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2,1,2]],"u":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]]}],"p":[{"e":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"v":[{"i":[{},[0,0,2]]}],"x":[{"i":[{},[0,0,2]]}]},[0,1]],"ó":[{"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"i":[{},[0,0,2]]}],"s":[{"á":[{},[0,0,2]]}],"v":[{"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}]},[0,1]],"ö":[{"b":[{"ö":[{},[0,0,2]]}],"k":[{"o":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"l":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"r":[{"ö":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]]}],"z":[{"ö":[{},[0,0,2]]}]},[0,1]],"ő":[{"r":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"é":[{},[0,0,2]],"ö":[{},[0,0,2]]}]},[0,1]],"p":[{"a":[{"d":[{"a":[{},[0,2,1,2]]}],"l":[{"k":[{},[0,2,1]]}],"n":[{"a":[{"l":[{},[0,0,1]]}],"o":[{},[0,2,1,2]],"t":[{},[0,0,1]],"y":[{},[0,2,1]]}],"r":[{"á":[{"n":[{},[0,0,1,2]]}]}]}],"á":[{"l":[{"l":[{},[0,0,1]]}]}],"c":[{"s":[{"a":[{"p":[{},[0,0,0,0,0,2,1]]}]}]}],"e":[{"f":[{},[0,2,1]],"g":[{},[0,2,1,2]],"l":[{"o":[{},[0,0,1]]}]}],"i":[{"d":[{},[0,2,1]],"n":[{"d":[{},[0,0,1]]}],"o":[{},[0,2,1,2]],"r":[{"á":[{},[0,0,1,2]]}]}],"l":[{"a":[{"k":[{},[0,1,2]],"s":[{},[0,1,2]]}],"u":[{},[0,1,2]]}],"o":[{"b":[{},[0,2,1]],"l":[{"a":[{},[0,2,1,2]]}],"r":[{"a":[{"d":[{},[0,0,0,2]]}]}]}],"ó":[{"r":[{"a":[{},[0,0,1]]}]}],"r":[{"i":[{},[0,1,2]],"o":[{"d":[{},[0,0,2]],"p":[{},[0,0,2]]}],"ó":[{"b":[{},[0,1]]}]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"ú":[{"j":[{},[0,2,1]]}],"ü":[{"v":[{},[0,0,1]]}]}],"r":[{"a":[{"b":[{"é":[{},[0,2]]}],"c":[{"e":[{},[0,0,1]]}],"d":[{"a":[{"t":[{},[0,0,0,2]]},[2]]}],"i":[{"b":[{},[0,2]],"é":[{"r":[{},[0,0,0,2]]},[0,2]],"h":[{},[0,2]],"i":[{},[0,2]],"j":[{},[0,2]],"k":[{"é":[{},[0,0,0,2]],"o":[{},[0,0,0,2]]},[0,2]],"m":[{},[0,2]],"n":[{},[0,2]],"p":[{},[0,2]],"s":[{},[0,2]],"t":[{},[0,2]],"v":[{},[0,2]]}],"j":[{"e":[{},[1,2]],"o":[{},[2]],"z":[{},[2]]}],"k":[{"v":[{},[0,0,0,1]]}],"l":[{"a":[{},[0,2]],"k":[{},[0,0,1]]}],"m":[{"o":[{},[0,2]]}],"n":[{"i":[{},[0,2,1]],"t":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,0,1,2]]}],"r":[{"c":[{},[0,0,1]],"e":[{},[1]]}],"s":[{"p":[{},[0,0,0,1,2]]}],"t":[{"o":[{"m":[{},[0,2,1,2]]}]}],"ü":[{},[1,2]]}],"á":[{"é":[{"n":[{},[1]]}],"g":[{"g":[{},[0,0,1]],"y":[{},[0,0,1,2]]}],"k":[{"h":[{},[1]],"i":[{},[1,2]]}],"l":[{},[0,2,1]],"m":[{"é":[{},[1,2]],"o":[{},[1,2]],"r":[{},[1]]}],"p":[{},[0,2,1,2]],"s":[{"e":[{},[0,0,0,2]]}],"t":[{"a":[{},[2]],"v":[{},[0,0,1]]}]}],"b":[{"r":[{},[0,0,1]]}],"e":[{"g":[{"e":[{},[0,0,1]],"y":[{},[0,2,1,2]]}],"l":[{"e":[{},[0,2,1,2]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"o":[{},[0,2,1]],"ő":[{},[0,2,1,2]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,0,1]],"l":[{},[0,0,1]]}],"r":[{},[0,2,1,2]],"s":[{"e":[{"t":[{},[0,2,1,2]]}]}],"t":[{"á":[{},[0,2,1,2]],"é":[{},[0,2,1,2]]}],"z":[{"ü":[{},[0,2]]}]}],"é":[{"j":[{"e":[{},[0,0,1,2]]}],"l":[{},[0,2,1,2]],"r":[{"i":[{},[0,0,1,2]]}],"v":[{"e":[{"k":[{},[0,0,0,2]]}]}]}],"f":[{"l":[{},[0,0,1]]}],"h":[{"á":[{"z":[{"o":[{"t":[{},[0,0,0,0,2]]}]}]}]}],"i":[{"a":[{"k":[{"a":[{},[0,0,0,2]]}],"l":[{},[0,0,0,2]]}],"á":[{"s":[{"i":[{},[0,2]],"s":[{},[0,0,0,0,0,3]]}]}],"c":[{"h":[{},[0,0,0,2]]}],"d":[{},[0,2,1]],"n":[{"t":[{},[0,2,1]]}],"o":[{"n":[{"n":[{},[0,0,1,2]],"o":[{},[0,0,1,2]]}]}],"p":[{"a":[{},[0,2,1,2]]},[2]],"s":[{"i":[{},[0,2,1,2]],"m":[{"e":[{},[0,2,1]]}]}],"t":[{},[2]],"z":[{"o":[{},[0,0,1]]},[0,0,0,2]]}],"í":[{"j":[{},[0,0,1,2]],"r":[{},[0,2,1]],"z":[{},[0,0,1,2]]}],"k":[{"l":[{},[0,0,1]]}],"m":[{"é":[{"s":[{},[0,0,0,0,2]]}]}],"o":[{"k":[{"á":[{},[0,0,1,2]],"é":[{},[0,3]],"i":[{},[0,0,1,2]],"o":[{"k":[{},[0,0,0,2]],"z":[{},[0,0,0,2]]}],"u":[{},[0,0,1,2]],"ú":[{},[0,0,1]]}],"s":[{"z":[{},[0,2,1]]}],"x":[{},[0,2,1,2]]}],"ó":[{"d":[{"a":[{},[0,2,1]],"á":[{"j":[{},[0,0,0,2]]}]}],"i":[{"k":[{"o":[{},[0,0,0,0,2]]}]}],"p":[{},[0,0,0,1]],"s":[{"á":[{},[0,0,1]]}],"z":[{},[2]]}],"ö":[{"l":[{},[0,2,1,2]],"m":[{"l":[{},[0,2,1]]}],"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1,2]]}],"t":[{"r":[{"á":[{},[0,0,1]]}]}],"u":[{"m":[{"a":[{"g":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]]}],"r":[{},[0,2,1,2]],"s":[{"a":[{"b":[{},[0,0,0,2]],"n":[{},[0,0,0,2]]}],"e":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]],"ü":[{},[0,0,0,2]],"z":[{},[0,0,0,2,3]]}],"t":[{"a":[{},[0,2,1]]}]}],"ú":[{"s":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"ü":[{"n":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}]}],"s":[{"a":[{"b":[{"l":[{},[2]]}],"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"l":[{"j":[{},[0,2,1]],"t":[{},[0,0,1]]}],"m":[{"n":[{},[0,0,1]]}],"p":[{"r":[{},[0,2,1]]}],"r":[{"c":[{"o":[{"t":[{},[0,2,1]]}]}]},[2]],"s":[{"p":[{},[0,2,1]],"s":[{},[0,0,1]]}],"t":[{"l":[{},[0,2,1]]}],"u":[{},[0,2,1]],"v":[{"o":[{},[0,0,0,2]]}]}],"á":[{"b":[{"r":[{},[0,2,1]]}],"f":[{},[0,2,1]],"g":[{"g":[{},[0,0,0,0,1]]}],"l":[{"l":[{},[0,2,1]],"o":[{},[0,0,1,2]]}],"r":[{"o":[{},[0,2,1,2]]}],"t":[{"i":[{},[0,0,1]],"o":[{},[2]]}]}],"b":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"c":[{"s":[{"a":[{"p":[{"á":[{},[0,0,0,0,0,0,1,2]]}]}]}]}],"e":[{"b":[{},[2]],"g":[{"y":[{},[0,0,1,2]]}],"j":[{},[2]],"l":[{"j":[{},[0,0,1]],"m":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,0,1]],"i":[{},[0,0,1]]},[0,0,0,2]],"n":[{},[0,2,1]],"p":[{"o":[{},[0,0,1]]},[0,0,0,2]],"r":[{"ő":[{},[0,0,1]]}],"s":[{},[0,2,1]],"t":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"é":[{"l":[{},[0,2,1,2]],"m":[{},[2]],"n":[{"e":[{},[0,0,1,2]]}],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}]}],"t":[{"á":[{"k":[{"a":[{},[0,0,0,2]]}]}],"e":[{},[0,2,1,2]],"k":[{},[0,0,1]],"t":[{},[0,0,1]]},[2]]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"e":[{},[0,0,1]]},[0,0,0,2]],"k":[{"e":[{"r":[{"b":[{},[0,0,0,2]]}]}],"l":[{},[2]]}],"n":[{"d":[{},[0,0,1]],"f":[{},[0,0,1]]}],"p":[{"a":[{},[0,0,1]]},[0,0,0,2]],"r":[{"o":[{},[0,0,1]]}],"s":[{"k":[{},[0,2,1]],"t":[{},[0,0,1]]}]}],"í":[{"k":[{},[2]],"n":[{"h":[{},[0,2,1]]}],"r":[{"á":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]]}]}],"k":[{"a":[{"t":[{},[0,1,2]]}],"i":[{"c":[{},[0,0,2]],"s":[{},[0,0,0,0,2]]}],"l":[{},[0,0,1]],"v":[{},[0,0,1]]}],"l":[{"a":[{"g":[{},[0,0,2]]}],"á":[{},[2]]}],"n":[{"i":[{},[0,1,2]]}],"o":[{"k":[{"a":[{"s":[{},[2]]}],"k":[{"o":[{},[2]]}],"s":[{},[2]]}],"l":[{"i":[{},[0,0,1]]}],"r":[{"g":[{},[0,2,1]],"j":[{},[0,2,1]],"m":[{},[0,2,1]]},[2]],"t":[{"t":[{},[0,2,1]]}],"v":[{},[0,2,1]]}],"ó":[{"r":[{},[0,2,1,2]]}],"ö":[{"l":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{},[0,2,1]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"e":[{"c":[{},[0,1,2]],"k":[{},[2,1,2]]}],"i":[{"r":[{},[2,1,2]]}],"l":[{},[0,0,1]],"u":[{},[0,1,2]]}],"s":[{"k":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"z":[{"e":[{},[0,0,3]],"ö":[{},[0,0,3]]}]}],"t":[{"a":[{"b":[{},[2,1,2]],"d":[{},[0,1,2]],"f":[{},[0,1,2]],"n":[{"d":[{},[2,1]]}],"t":[{},[2,1,2]]}],"á":[{"b":[{"b":[{},[0,0,2]]}],"d":[{},[0,1,2]],"t":[{},[0,1,2]]},[2]],"é":[{"g":[{},[0,1,2]]}],"í":[{},[2]],"o":[{"p":[{"o":[{},[0,0,2]]}]}],"r":[{"é":[{},[0,0,1]],"i":[{},[0,0,1]],"u":[{},[0,1]]},[2,0,0,2]],"ú":[{},[2]]}],"u":[{"g":[{},[2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"r":[{".":[{},[0,0,1]],"i":[{},[0,0,1,2]],"n":[{},[0,0,1]]}]}],"ü":[{"l":[{},[2]],"r":[{},[2]],"s":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"r":[{"í":[{},[2]]}]}],"z":[{"a":[{"c":[{},[0,2,3]],"k":[{"ü":[{},[0,0,0,0,2,1]]}],"l":[{"a":[{"p":[{},[0,2,0,1,2]]}]}]},[2]],"á":[{"g":[{"o":[{"l":[{},[0,0,0,0,2]]}]}]},[2]],"e":[{"d":[{},[2]],"g":[{"ű":[{},[0,2,0,1,2]]},[2]],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"r":[{".":[{},[2]],"e":[{"p":[{"é":[{},[0,0,0,0,2,1,2]]}]},[2]],"k":[{},[2]],"v":[{},[2]],"z":[{},[2]]}],"z":[{},[2]]}],"é":[{"n":[{"é":[{},[0,0,0,0,2,1,2]]}]},[2]],"i":[{"m":[{"a":[{},[0,2]]}]},[2]],"í":[{},[2]],"k":[{},[2]],"l":[{},[0,0,0,2]],"o":[{"b":[{},[2]],"c":[{},[2]],"f":[{},[2]],"l":[{},[2]],"n":[{},[2]]}],"ó":[{},[2]],"ö":[{"s":[{},[0,2,0,1]]},[2]],"ő":[{},[2]],"p":[{},[2]],"s":[{},[0,0,3]],"t":[{"á":[{},[0,1,0,2]],"r":[{"á":[{},[0,0,0,0,2]]}]},[2]],"ú":[{},[2]],"ü":[{"g":[{},[0,2,0,1]]},[2]],"ű":[{"k":[{},[2]],"r":[{"é":[{},[2]],"ő":[{},[2]],"t":[{},[0,2,3]]}]}],"v":[{},[0,0,0,2]]}]}],"t":[{"a":[{"d":[{"ó":[{},[0,0,1]]}],"g":[{".":[{},[2]],"a":[{"l":[{},[0,0,0,2]]},[2]],"b":[{},[2]],"g":[{},[2,0,0,0,1]],"i":[{},[2]],"j":[{},[2]],"k":[{},[2]],"n":[{},[2]],"o":[{},[2]],"s":[{},[2]],"u":[{},[2]]}],"j":[{"k":[{},[0,0,1]]}],"l":[{"a":[{"p":[{},[2]]}],"á":[{},[2]],"k":[{},[0,0,1]],"m":[{},[0,2,1]]}],"n":[{"t":[{"i":[{},[0,0,1]]}]},[2]],"p":[{},[2]],"r":[{},[2]],"s":[{"s":[{},[0,2,1]]},[0,0,0,0,2]],"t":[{},[2]],"u":[{"r":[{},[0,0,1,2]]}],"x":[{},[2]]}],"á":[{"g":[{"a":[{},[0,0,1,2]],"g":[{},[0,0,1]]},[2]],"p":[{},[2]],"r":[{"a":[{"d":[{"a":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"o":[{},[2]],"s":[{},[2]]}],"v":[{"c":[{},[2]],"i":[{"r":[{},[0,0,0,2,1]]},[2,0,0,0,0,2]],"í":[{},[2]],"k":[{},[2]]}]}],"e":[{"g":[{},[0,2,1,2]],"l":[{"h":[{},[0,2,1]],"ő":[{},[0,2,1,2]]}],"m":[{"b":[{},[0,2,1]]}],"r":[{"d":[{},[0,2]]}]}],"é":[{"g":[{"é":[{},[0,0,1]]}],"k":[{"é":[{},[0,2,1,2]]}],"t":[{"ö":[{},[0,0,0,2,1,2]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{"g":[{},[0,2,1]]}],"p":[{"a":[{},[0,0,1,2]]}],"s":[{"z":[{},[0,0,0,2]]}]}],"í":[{"r":[{},[0,2,1,2]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"k":[{"r":[{},[0,0,1]]}],"l":[{"é":[{"k":[{"e":[{},[0,0,0,0,2]]}]}]}],"o":[{"j":[{},[2]],"l":[{"l":[{"a":[{"d":[{},[0,0,0,0,2,1,2]]}]}]},[2]],"m":[{"l":[{},[0,0,1]]}],"n":[{},[2]],"r":[{"s":[{},[0,2,1]]},[2]],"v":[{},[2]]}],"ó":[{".":[{},[2]],"n":[{},[2]]}],"ö":[{"k":[{"o":[{},[0,0,1]]}]}],"ő":[{"e":[{},[0,0,0,0,2]]}],"r":[{"a":[{"d":[{},[0,0,2]],"f":[{},[0,0,2]],"k":[{},[0,0,2]],"n":[{},[0,0,2]]}],"é":[{"n":[{},[0,0,2]]}],"i":[{"k":[{},[0,0,2]],"l":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"o":[{"m":[{},[0,0,2]]}]}],"s":[{"l":[{},[0,0,1]],"p":[{},[0,0,1]],"z":[{"e":[{"r":[{"e":[{"p":[{},[0,0,0,0,0,2,1]]}]}]}]}]}],"u":[{"s":[{"z":[{"e":[{},[0,0,0,2]]}]}]}],"ü":[{"l":[{"é":[{},[0,0,1]],"ő":[{},[0,0,1,2]]}],"s":[{"t":[{},[0,0,1]]}],"v":[{},[0,2,1,2]]}],"ű":[{"z":[{"s":[{},[0,0,0,2,3]]}]}]}],"u":[{"b":[{"o":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"r":[{"á":[{"s":[{"s":[{},[0,0,0,0,0,0,1]]}]}]}]}],"j":[{"j":[{"a":[{"d":[{"a":[{},[0,0,0,2,1,2]]}]}]}]}],"n":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}]},[0,1]],"ú":[{"j":[{"í":[{},[0,0,2]]}],"r":[{"é":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[0,1]],"ü":[{"g":[{"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"n":[{"ő":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[0,1]],"ű":[{"z":[{"ő":[{},[0,0,2]]}]},[0,1]],"v":[{"a":[{"d":[{},[2]],"g":[{},[2]],"j":[{},[2]],"k":[{".":[{},[2]],"s":[{},[2]],"u":[{},[2]]}],"l":[{"ó":[{},[2]]}],"r":[{},[2]],"s":[{},[2]],"t":[{},[0,2]]}],"á":[{"g":[{},[2]],"k":[{},[2]],"l":[{},[2]],"n":[{},[2]],"r":[{"a":[{"l":[{},[0,0,0,2,1]]}],"o":[{"s":[{"i":[{"h":[{},[0,0,0,0,0,0,0,2]]}]}]}]}],"s":[{"a":[{},[0,2]],"i":[{},[1,2]],"o":[{},[0,2]],"r":[{},[1,2]],"s":[{},[1,2]],"t":[{},[1,2]]}],"z":[{},[2]]}],"e":[{"r":[{"a":[{},[0,0,0,2,1]],"i":[{"p":[{},[0,0,0,2]]},[0,0,0,0,0,2]]}]}],"i":[{"n":[{},[0,0,1]]}],"o":[{"d":[{},[1,2]],"m":[{},[0,2]],"n":[{},[2]]}]}],"z":[{"a":[{"d":[{"á":[{},[0,0,1,2]],"ó":[{},[0,0,1,2]]},[0,0,0,1,2]],"j":[{},[2]],"k":[{"c":[{},[0,0,1]],"r":[{},[0,0,0,1]],"t":[{},[0,0,1]]}],"l":[{"a":[{},[0,0,1,2]]}],"r":[{"c":[{},[0,0,1]]}],"s":[{},[0,0,0,1]],"t":[{"a":[{"l":[{},[0,0,0,2,1,2]],"n":[{},[0,0,0,2]]}],"á":[{"l":[{},[0,0,0,2]]}],"é":[{"s":[{},[0,0,0,2]]}],"o":[{"l":[{"d":[{},[0,0,0,2]]}]}],"ü":[{},[0,0,0,2,1,2]]}],"v":[{},[2]]}],"á":[{"g":[{},[0,2,1,2]],"l":[{"l":[{},[0,0,1]]}],"r":[{"u":[{},[0,2,1,2]],"ú":[{},[0,2,1,2]]}]}],"b":[{"l":[{},[0,0,1]]}],"d":[{"i":[{},[1]]}],"e":[{"g":[{},[0,2,1,2]],"l":[{},[0,2,1]],"m":[{},[0,0,1]],"r":[{"ő":[{},[0,0,1]]}],"x":[{},[0,2,1]],"z":[{},[0,0,1]]}],"é":[{"l":[{},[0,2,1,2]],"t":[{"e":[{},[0,2,1,2]]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"h":[{"a":[{"j":[{"ó":[{"i":[{},[0,0,0,0,0,0,0,2]]}]}]}]}],"i":[{"m":[{"p":[{},[0,0,1]]}],"n":[{"g":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"s":[{"e":[{},[0,0,0,2,1,2]],"i":[{"r":[{},[0,0,0,2]]}],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}]}],"o":[{"l":[{"d":[{},[0,2,1]]}],"n":[{"a":[{},[0,0,0,2,1,2]],"á":[{},[0,0,0,2,1]],"i":[{},[0,0,0,2]]}]}],"ó":[{"s":[{"p":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"ő":[{"r":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"a":[{"k":[{},[0,0,0,0,1,2]]}],"e":[{"r":[{},[0,2,3]]}],"o":[{"r":[{},[0,0,3]]}],"z":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"h":[{},[2]],"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"ú":[{"s":[{},[0,0,1,2]],"t":[{},[0,2,1]]}],"ü":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1]],"z":[{},[0,0,1,2]]}]}]}],"ö":[{".":[{},[2]],"a":[{},[0,1]],"á":[{},[0,1]],"b":[{"a":[{"n":[{},[0,0,1,2]]}],"á":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"b":[{"a":[{},[0,0,2,1,2]],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2,1]],"l":[{"e":[{},[0,0,2,1]]},[0,0,0,0,2]],"m":[{"e":[{},[0,0,0,1]]},[0,0,0,0,2]],"r":[{},[0,0,2,1,2]],"s":[{"z":[{},[0,0,2,1]]}],"v":[{"e":[{},[0,0,0,1]]}]}],"é":[{"l":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"í":[{},[0,0,2]],"o":[{"l":[{},[0,0,2,1]],"s":[{},[0,0,2,1]],"t":[{},[0,0,2]]}],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"ü":[{"l":[{},[0,0,2,1]]},[0,0,0,0,2]]}],"e":[{"f":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"n":[{},[0,2,1,2]],"r":[{},[0,2,1]]}],"é":[{"l":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"t":[{"é":[{},[0,2,1]]}],"z":[{},[0,2,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"n":[{"g":[{},[0,2,1]],"t":[{},[0,2,1]]}]}],"l":[{"i":[{},[1]],"ö":[{},[1]]}],"o":[{"r":[{},[0,0,1]]}],"ó":[{"n":[{},[0,0,1]]}],"ö":[{"l":[{"l":[{},[0,2]],"t":[{"ő":[{},[1]]}]}]}]}],"c":[{"a":[{"j":[{},[0,0,1]]}],"c":[{"s":[{"a":[{},[0,0,0,0,1,2]],"i":[{},[0,0,0,0,1]]}]}],"é":[{"p":[{},[0,2,1]],"v":[{"e":[{},[0,2,1]]}]}],"h":[{"e":[{},[0,0,3]],"ö":[{},[0,0,3]]}],"i":[{"ó":[{},[0,0,0,0,2]]}],"ő":[{"r":[{},[0,0,1]]}],"s":[{"a":[{},[0,2,0,1]],"é":[{"j":[{},[0,0,0,1]],"k":[{},[0,0,0,1]],"t":[{"e":[{},[0,2,0,1,2]]}]}],"i":[{"z":[{"z":[{},[0,0,0,1]]},[0,2]]}],"ó":[{},[0,0,0,1]],"ö":[{"l":[{},[0,2,0,1,2]]}],"ű":[{"r":[{},[0,0,0,1,2]]}],"z":[{},[0,0,3]]}]}],"d":[{"a":[{"l":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"á":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1]]}],"e":[{"f":[{},[0,2,1]],"l":[{"l":[{},[0,0,1]]}],"m":[{},[0,2,1]],"v":[{"é":[{},[0,0,1,2]]}]}],"é":[{"m":[{"o":[{},[0,0,0,2,1]]}],"s":[{"a":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}],"v":[{"e":[{"s":[{},[0,2,1,2]]}],"é":[{"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}]}]}],"g":[{"r":[{},[0,0,1]]}],"í":[{"z":[{},[0,0,1]]}],"o":[{"s":[{},[0,0,1]]}],"ó":[{"c":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"s":[{"p":[{},[0,0,1]]}],"u":[{"s":[{},[0,0,1,2]]}],"ú":[{"j":[{},[0,0,1]],"s":[{},[0,0,1,2]]}],"ü":[{"v":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}],"z":[{"á":[{"r":[{"ó":[{},[0,0,0,0,0,0,2]]}]},[0,0,3]],"u":[{},[0,0,3]]}]}],"e":[{},[0,1]],"é":[{},[0,1]],"f":[{"é":[{"s":[{"s":[{},[0,0,0,0,3]]}]}]}],"g":[{"a":[{"b":[{},[0,0,1]],"c":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"g":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"á":[{"b":[{},[0,0,1]],"g":[{},[0,0,1]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"g":[{},[0,2,1,2]],"k":[{"é":[{"i":[{},[0,2,1,2]]}]}],"l":[{"b":[{},[0,0,1]],"e":[{"m":[{"e":[{},[0,2,0,2]]}]}],"f":[{},[0,2,1]],"h":[{"a":[{},[0,2,1]]}],"m":[{},[0,2,1]],"o":[{},[0,2,1]]}],"m":[{"e":[{"l":[{},[0,2]]}]}],"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}],"v":[{"é":[{},[0,0,1,2]]}]}],"é":[{"g":[{},[0,2,1,2]],"k":[{"t":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"é":[{},[0,0,1]]}]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1]],"m":[{},[0,2,1,2]],"n":[{"f":[{},[0,0,1]]}],"s":[{"t":[{},[0,2,1]]}],"v":[{"a":[{},[0,2,1]]}],"z":[{},[0,2,1,2]]}],"í":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]],"v":[{},[0,0,1]]}],"k":[{"r":[{},[0,0,1]]}],"o":[{"l":[{},[0,0,1,2]],"p":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"ó":[{"r":[{},[0,0,1,2]]}],"ö":[{"l":[{"i":[{},[0,0,1]],"ö":[{},[0,0,1]]}],"v":[{},[0,2,1]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"e":[{"p":[{},[0,0,0,0,1,2]]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"d":[{},[0,0,1]],"n":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}],"y":[{"a":[{},[0,0,3]]}]}],"i":[{},[0,1]],"í":[{},[0,1]],"j":[{"t":[{"é":[{"l":[{},[0,0,2]]}],"o":[{},[0,0,2,1]]}]}],"k":[{"a":[{"b":[{},[0,0,1]],"g":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]],"u":[{},[0,0,1]],"v":[{},[0,0,1,2]]}],"á":[{"g":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1]],"z":[{},[0,0,1]]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"d":[{},[0,2,1,2]],"g":[{},[0,2,1,2]],"k":[{"e":[{},[0,2,1]]}],"l":[{"a":[{},[0,0,1]],"e":[{},[0,0,1]],"h":[{},[0,0,1]],"m":[{},[0,0,1]],"n":[{},[0,0,1]],"ő":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]],"m":[{},[0,2,1,2]],"n":[{"é":[{},[0,0,0,2]],"s":[{},[0,0,0,0,1]]}],"r":[{"d":[{},[0,0,1]],"e":[{"s":[{"z":[{},[0,2,1,2]]}]}],"ő":[{},[0,2,1,2]]}],"s":[{},[0,2,1]],"v":[{"é":[{"s":[{},[0,0,0,2]]}]}],"z":[{},[0,2,1]]}],"é":[{"g":[{},[0,2,1]],"k":[{"n":[{},[0,2,1]],"s":[{},[0,0,1]]}],"l":[{"e":[{"s":[{},[0,0,1,2]]}]}],"p":[{},[0,2,1]],"r":[{"e":[{"l":[{},[0,0,0,2,1,2]],"m":[{},[0,0,0,2,1]],"z":[{},[0,2,1,2]]}],"é":[{"s":[{},[0,2,1,2]]}]}],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"e":[{},[0,2,1,2]]}],"v":[{"e":[{".":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"t":[{},[0,0,1,2]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"l":[{},[0,0,1]]}],"i":[{"d":[{"e":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"g":[{"a":[{},[0,0,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"k":[{"t":[{},[0,2,1]]}],"n":[{"a":[{},[0,2,1,2]],"d":[{},[0,0,1]],"g":[{},[0,2,1]],"t":[{},[0,2,1]]}],"o":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{"o":[{},[0,2,1]]}],"s":[{},[0,2,1]],"z":[{},[0,2,1]]}],"í":[{"j":[{},[0,0,1]],"r":[{},[0,2,1]],"v":[{},[0,0,1]],"z":[{},[0,0,1]]}],"k":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"l":[{"ű":[{},[1]]}],"o":[{"k":[{},[0,0,1]],"l":[{"d":[{},[0,0,1]],"ó":[{},[1]]}],"n":[{},[1]],"p":[{},[0,0,1,2]],"r":[{"o":[{},[0,0,1,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"v":[{},[0,0,1,2]]}],"ó":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"ö":[{"r":[{".":[{},[1]],"ö":[{},[0,0,0,2]]}]}],"ő":[{"á":[{"r":[{"a":[{"d":[{},[0,0,0,0,0,1,2]]}]}]}],"é":[{},[0,0,0,0,2]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"ö":[{"s":[{},[1]]}],"ü":[{},[1]],"ű":[{},[1]]}],"s":[{"p":[{},[0,0,1]],"r":[{},[0,0,1]],"z":[{"i":[{"l":[{},[0,0,0,0,0,2,1]]}]}]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ú":[{"j":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,2,1]],"l":[{"é":[{},[0,2,1]],"t":[{},[0,2,1]]},[0,0,0,2]],"t":[{},[0,2,1,2]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}]}],"l":[{"a":[{"d":[{},[0,0,1,2]],"g":[{},[0,0,1]],"j":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1,2]],"u":[{},[0,0,1]],"v":[{},[0,0,1,2]]}],"á":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1]],"m":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1]]}],"c":[{"s":[{"a":[{"l":[{},[0,0,0,0,0,2]]}],"á":[{"p":[{},[0,0,0,0,1,2]],"r":[{},[0,0,0,0,1,2]]}],"e":[{"l":[{"l":[{},[0,0,0,0,1]]}],"v":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2]],"z":[{},[0,0,2]]}],"o":[{"k":[{},[0,0,2,0,1]],"l":[{},[0,0,0,0,1]],"s":[{},[0,0,2]]}],"ü":[{"g":[{},[0,0,2]],"l":[{},[0,0,2]]}]}]}],"d":[{"a":[{"b":[{},[0,0,2]],"d":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1,2]],"l":[{"a":[{},[0,0,2,1,2]],"j":[{},[0,0,2,1]],"k":[{},[0,0,2,1]]}],"n":[{},[0,0,2,1,2]],"p":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"á":[{},[0,0,2,1,2]],"e":[{"g":[{},[0,0,2]],"p":[{},[0,0,2]],"v":[{},[0,0,2]]}],"é":[{"d":[{},[0,0,2,1]],"l":[{},[0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,2,1]]}],"p":[{},[0,0,2]]}],"o":[{"r":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"ó":[{},[0,0,2,1,2]],"ő":[{"r":[{},[0,0,2]],"s":[{},[0,0,2]]},[0,0,0,0,2]],"r":[{"ó":[{},[0,0,1]]}],"u":[{"r":[{},[0,0,2]]}],"z":[{},[0,0,2,3]]}],"e":[{"b":[{},[1,2,1,2]],"g":[{"e":[{"l":[{},[0,0,0,2]]}],"g":[{},[0,0,0,0,1]]}],"l":[{},[0,2]],"r":[{},[0,2,1,2]],"s":[{"ü":[{},[0,3,2,3]]}],"t":[{"á":[{},[0,0,0,2,1,2]],"e":[{"l":[{},[0,0,0,2,1]]}],"o":[{},[0,0,0,2]],"u":[{},[0,0,0,2,1]]}],"v":[{},[0,2,1,2]]}],"é":[{"d":[{"e":[{},[0,2,1]]},[0,0,0,2]],"é":[{},[1,2]],"g":[{},[0,2,1,2]],"k":[{"e":[{"s":[{},[0,2,1,2]]}],"í":[{},[0,2,1]]}],"l":[{".":[{},[0,2,1]],"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"j":[{},[0,2,1]],"n":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"m":[{"e":[{},[0,2,1]]}],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]]}]}]}],"p":[{},[0,2,1,2]],"r":[{".":[{},[0,2,1]],"e":[{"d":[{},[0,2,1,2]],"k":[{},[0,2,1,2]],"z":[{"n":[{},[0,2,1,2]]}]}],"é":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"l":[{},[0,2,1]],"n":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]],"ü":[{},[0,2,1]]}],"ü":[{},[0,2,1,2]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}],"t":[{"e":[{"t":[{},[0,2,1,2]]}]}]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"y":[{"á":[{},[0,0,0,0,0,2]],"e":[{"r":[{},[0,0,2]]}]}]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1]],"é":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"j":[{},[0,2,1]],"l":[{},[0,2,1]],"m":[{},[0,2,1]],"n":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1,2]],"t":[{"a":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"í":[{"r":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"o":[{"c":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1,2]]}],"ó":[{"v":[{},[0,0,1,2]]}],"ö":[{"k":[{"i":[{},[0,0,0,2]],"l":[{},[0,2,1]]}],"l":[{},[0,2,1]],"n":[{"t":[{},[0,0,1]]}],"r":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"ő":[{"r":[{"l":[{},[0,0,1]],"ö":[{},[0,0,1]]}]}],"p":[{"á":[{"r":[{"b":[{"a":[{},[0,0,0,0,0,0,0,2]]}]}]}],"r":[{},[0,0,1,2]]}],"s":[{"k":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{"d":[{},[0,0,2,1]],"j":[{},[0,0,2]],"l":[{"a":[{},[0,0,0,1]],"j":[{},[0,0,0,1]]}],"n":[{},[0,0,0,0,2]]}],"i":[{"d":[{},[0,0,2]],"l":[{},[0,0,2]]}],"í":[{},[0,0,2]],"r":[{"o":[{},[0,0,1]]}],"u":[{"r":[{},[0,0,2]]}]}],"u":[{"g":[{},[0,0,1,2]],"j":[{},[0,0,1]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"ú":[{"j":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"l":[{"e":[{},[0,0,0,2]],"t":[{"é":[{},[0,0,1]],"ö":[{},[0,2,1]]}],"v":[{"e":[{},[0,2,1]]}]}],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}],"y":[{"a":[{},[0,2,0,1,2]],"á":[{},[0,2,0,1]],"e":[{"g":[{},[0,0,0,1,2]],"l":[{},[0,2]]}],"f":[{"ö":[{"l":[{},[0,0,0,2]]}]}]}]}],"m":[{"a":[{"d":[{},[0,0,1,2]],"g":[{},[0,0,1,2]],"l":[{},[0,0,1]],"n":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1]],"u":[{},[0,0,1]]}],"á":[{"b":[{},[0,0,1]],"g":[{},[0,0,1]],"h":[{},[0,0,1]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"b":[{"a":[{"c":[{},[0,0,2,1,2]],"k":[{},[0,0,2,1]],"l":[{},[0,0,0,0,2]],"n":[{},[0,0,2,1,2]],"z":[{},[0,0,2]]}],"á":[{},[0,0,2,1]],"e":[{"c":[{},[0,0,2]],"l":[{"e":[{},[0,0,0,1]]}],"m":[{},[0,0,2,1,2]],"s":[{},[0,0,2,1]]}],"é":[{"k":[{},[0,0,2]]}],"i":[{"d":[{},[0,0,2,1,2]],"n":[{},[0,0,2]]}],"í":[{},[0,0,2]],"o":[{"s":[{},[0,0,2,1]]}],"ó":[{},[0,0,2,1,2]],"ú":[{},[0,0,2]],"ü":[{"r":[{},[0,0,2]]}]}],"e":[{"b":[{},[0,2,1,2]],"g":[{"a":[{},[0,0,0,2,1,2]],"e":[{"r":[{},[0,0,0,0,1,2]],"s":[{"z":[{},[0,0,0,2]]}]}],"é":[{"k":[{},[0,0,0,2,1]],"p":[{},[0,0,0,2]]}],"g":[{},[0,0,0,0,3]],"y":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"m":[{"b":[{"e":[{"r":[{},[0,2,1]]}]}],"e":[{"l":[{},[0,2,1]]}]}],"r":[{},[0,2,1,2]],"s":[{"e":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]]}]},[0,0,0,2]]}],"é":[{"g":[{},[0,2,1]],"h":[{"s":[{},[0,2]]}],"l":[{},[0,2,1,2]],"n":[{"e":[{"k":[{"b":[{},[0,0,1,2]],"e":[{},[0,2,1,2]],"é":[{},[0,2,1,2]],"h":[{},[0,0,1,2]],"k":[{},[0,2,1,2]],"r":[{},[0,2,1,2]]}]}],"y":[{"ü":[{},[0,0,0,2,0,1]]}]}],"p":[{},[0,2,1]],"r":[{".":[{},[0,2,1]],"t":[{"e":[{},[0,2,1]],"é":[{},[0,2,1]]}]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"g":[{"é":[{},[0,2,1]]},[0,0,0,2]],"n":[{},[0,2,1]],"p":[{},[0,2,1,2]],"t":[{"a":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"z":[{"m":[{},[0,2,1]],"o":[{},[0,2,1,2]]}]}],"í":[{"z":[{},[0,0,1,2]]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,1]]}]}],"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"l":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"ö":[{"t":[{},[1]]}]}],"o":[{"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ó":[{"d":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"ö":[{"n":[{"t":[{},[0,2,1]]}]}],"p":[{"r":[{},[0,0,1,2]]}],"s":[{"p":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1]]}],"u":[{"g":[{},[0,0,1,2]],"j":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"n":[{"n":[{},[0,2,1]]}],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"ű":[{"z":[{},[0,2,1]]}]}],"n":[{"a":[{"b":[{},[0,0,1]],"d":[{},[0,0,1,2]],"g":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1]],"n":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"u":[{},[0,0,1]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1]]}],"á":[{"b":[{},[0,0,1]],"g":[{},[0,0,1]],"l":[{},[0,0,1]],"m":[{},[0,0,1]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{"a":[{"d":[{"ó":[{".":[{},[0,0,0,0,1,2]]}]}]}],"é":[{},[0,0,0,0,1]]},[0,0,1,2]],"z":[{},[0,0,1]]}],"b":[{"é":[{"k":[{"é":[{"t":[{".":[{},[0,0,0,0,2]]}]}]}]}],"l":[{},[0,0,1]]}],"c":[{"á":[{"l":[{},[0,0,2,1]]}],"h":[{},[0,0,2]],"ő":[{},[0,0,2]],"s":[{"é":[{"g":[{},[0,0,0,3]]}],"z":[{},[0,0,0,3]]}],"z":[{},[0,0,2]]}],"d":[{"a":[{"b":[{},[0,0,2]],"p":[{},[0,0,2]]}],"e":[{"m":[{},[0,0,0,0,2]]}],"é":[{"r":[{".":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{"ő":[{},[0,0,2,1]]}]}]}],"o":[{"r":[{},[0,0,2,1]]}],"ő":[{},[0,0,2,1]],"z":[{},[0,0,2]]}],"e":[{"b":[{},[0,2,1]],"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"m":[{},[0,2,1,2]],"n":[{"e":[{},[0,0,1]]},[0,0,0,2]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1]],"v":[{},[0,0,1,2]],"x":[{},[0,0,1]]}],"é":[{"g":[{},[0,0,1,2]],"j":[{},[0,2,1]],"k":[{},[0,2,1,2]],"l":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{"d":[{},[0,2]],"i":[{},[0,0,1]],"l":[{},[0,0,1]],"t":[{"e":[{},[0,0,1]]}],"v":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]],"z":[{},[0,0,1]]}],"t":[{"e":[{},[0,2,1]],"t":[{},[0,2,1]]}],"v":[{".":[{},[0,2,1]],"e":[{"s":[{},[0,2,1]],"t":[{},[0,0,1]]}],"é":[{"r":[{},[0,2,1,2]],"t":[{},[0,2,1,2]]}],"v":[{},[0,2,1]]}]}],"f":[{"e":[{"l":[{"e":[{"m":[{},[0,0,0,0,2]]}]}]}],"r":[{},[0,0,1,2]]}],"g":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"y":[{"a":[{"s":[{},[0,0,0,0,1]]}],"é":[{"k":[{},[0,0,2]]}],"ó":[{"r":[{},[0,0,0,0,1,2]]}],"ö":[{},[2]],"ő":[{},[0,0,2]]}]}],"i":[{"d":[{},[0,2,1,2]],"f":[{},[0,0,1]],"g":[{"a":[{},[0,2,1]],"e":[{},[0,0,1]],"é":[{},[0,2,1]]},[0,0,0,2]],"l":[{"l":[{},[0,0,1]]}],"m":[{},[0,2,1]],"n":[{},[0,2,1]],"p":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1]],"t":[{"a":[{},[0,0,1]]}],"z":[{},[0,2,1,2]]}],"í":[{"j":[{},[0,0,1]],"r":[{},[0,2,1]],"z":[{},[0,2,1]]}],"k":[{"a":[{"g":[{},[0,0,2,1]],"n":[{"y":[{},[0,0,2,1]]}]}],"á":[{"r":[{"u":[{},[0,0,0,1]]}],"t":[{},[0,0,2]]}],"o":[{"l":[{"t":[{},[0,0,0,1]]}]}],"ú":[{},[0,0,2,1]],"ü":[{},[0,0,0,0,2]]}],"m":[{"e":[{"g":[{"g":[{},[0,0,0,0,0,1]]}]}]}],"n":[{"a":[{"k":[{},[0,0,0,0,2]]}],"á":[{},[0,0,2,1]],"y":[{"a":[{"d":[{},[0,0,0,0,1,2]]}],"á":[{},[0,0,0,0,1]],"e":[{"d":[{"z":[{},[0,0,0,0,1,2]]}]}],"ú":[{},[0,0,3]]}]}],"o":[{"d":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"p":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]],"x":[{},[0,0,1]]}],"ó":[{"c":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"ö":[{"b":[{},[0,0,1]],"r":[{},[0,2,1]],"v":[{},[0,2,1,2]]}],"ő":[{"r":[{"e":[{},[0,0,0,2]]},[0,0,1]],"z":[{},[0,0,1]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"s":[{"é":[{"g":[{"ü":[{"k":[{"é":[{},[0,0,0,0,0,0,2]]}]}]}]}],"p":[{},[0,0,1,2]],"t":[{},[0,0,1,2,2]],"z":[{},[0,0,0,0,2]]}],"t":[{"e":[{"l":[{"l":[{},[0,0,2,1]]}]}],"g":[{"e":[{"n":[{"n":[{},[0,0,0,0,0,0,1]]}]}]}],"ö":[{"s":[{"s":[{},[0,0,0,0,0,3]]}],"z":[{},[1]]}],"r":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"é":[{},[0,0,1,2]]}]}],"u":[{"d":[{},[0,0,1]],"n":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"ú":[{"j":[{},[0,0,1]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"ü":[{"d":[{},[0,0,1]],"g":[{},[0,2,1,2]],"r":[{},[0,2,1]],"t":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"y":[{"a":[{},[0,2,0,1,2]],"á":[{},[0,2,0,1]],"d":[{},[0,0,0,1]],"e":[{"l":[{},[0,2,0,1]]}],"i":[{"d":[{},[0,2,0,1]],"n":[{},[0,2,0,1]]}],"í":[{},[0,2]],"o":[{},[0,2,0,1]],"ü":[{"z":[{},[0,2]]}],"v":[{"a":[{"j":[{},[0,0,0,2]],"l":[{},[0,0,0,2,1,2]],"n":[{},[0,0,0,2]]}],"á":[{"r":[{},[0,0,0,2,1,2]]}],"e":[{"g":[{},[0,0,0,2,1,2]],"r":[{},[0,0,0,2,1]],"s":[{"z":[{},[0,0,0,2,1]]}],"v":[{},[0,0,0,2]]}],"é":[{"g":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2]],"r":[{".":[{},[0,0,0,2,1]]}]}],"i":[{"l":[{"l":[{},[0,0,0,2,1]]}]}],"í":[{},[0,0,0,2,1]],"o":[{},[0,0,0,2,1]]}]}]}],"o":[{},[0,1]],"ó":[{},[0,1]],"ö":[{},[0,1]],"ő":[{},[0,1]],"p":[{"a":[{"j":[{},[0,0,1]],"l":[{},[0,0,1,2]]}],"á":[{"l":[{},[0,0,1]]}],"e":[{"l":[{},[0,0,1,2]],"n":[{"y":[{"á":[{},[0,0,0,2]]}]}],"r":[{},[0,0,1,2]]}],"é":[{"p":[{},[0,2,1]]}],"ö":[{"l":[{"ő":[{},[0,0,1,2]]}]}]}],"r":[{"a":[{"b":[{},[0,0,1]],"c":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"g":[{},[0,0,1,2]],"j":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]],"u":[{},[0,0,1,2]],"x":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"á":[{"b":[{},[0,0,1]],"c":[{},[0,0,1,2]],"g":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"b":[{"r":[{},[0,0,1]]}],"c":[{"s":[{"á":[{"l":[{},[0,0,0,0,1]]}],"e":[{"l":[{"l":[{},[0,0,0,0,1]]}]}],"k":[{"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,1]]}]}]}],"o":[{"s":[{},[0,0,2]]}]}]}],"d":[{"í":[{},[2]],"r":[{},[0,0,1,2]],"ü":[{},[2]]}],"e":[{"c":[{},[0,2,1,2]],"d":[{"z":[{},[0,0,1,2]]}],"f":[{},[0,2,1]],"g":[{"a":[{},[0,0,0,2]],"é":[{"k":[{},[0,0,0,2,1]]}],"y":[{},[0,0,1,2]]}],"j":[{"á":[{},[0,0,0,2,1]]}],"k":[{"e":[{"s":[{"z":[{},[0,0,0,2,1,2]]}]}],"é":[{},[0,0,0,0,0,2]]}],"l":[{},[0,2,1,2]],"m":[{},[0,2,1]],"n":[{"c":[{},[0,0,1]]}],"p":[{},[0,2,1,2]],"r":[{},[0,2,1,2]],"s":[{"e":[{},[0,0,1,2]]}],"t":[{"e":[{"t":[{"ő":[{},[0,2,1,2]]}]}]}],"v":[{},[0,2,1,2]],"x":[{},[0,2,1]],"z":[{},[0,2,1]]}],"é":[{"d":[{"e":[{},[0,2,1,2]]}],"g":[{},[0,2,1,2]],"j":[{".":[{},[0,2,1]]}],"k":[{"s":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"n":[{"e":[{"k":[{"e":[{},[0,2,1]]}]}]}],"p":[{},[0,2,1]],"r":[{"é":[{},[0,2,1]],"i":[{},[0,2,1,2]]}],"s":[{"e":[{"l":[{},[0,0,0,2]]}]}],"t":[{"e":[{"g":[{},[0,0,0,2,1,2]]}],"v":[{},[0,2,1]]}],"v":[{"e":[{".":[{},[0,0,1,2]]}],"k":[{},[0,2,1]]}]}],"f":[{"á":[{},[0,0,2]],"é":[{"v":[{},[0,0,2,1]]}],"i":[{"p":[{},[0,0,2,1,2]],"s":[{},[0,0,2]]}],"o":[{"s":[{},[0,0,2,1]]}],"ő":[{"r":[{},[0,0,2]]}]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"d":[{},[0,2,1,2]],"g":[{"a":[{},[0,2,1]],"á":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,0,1]]},[0,0,0,2]],"l":[{"l":[{},[0,2,1]]}],"m":[{},[0,2,1]],"n":[{"d":[{},[0,2,1]],"g":[{},[0,2,1]],"j":[{},[0,2,1]],"k":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1]]}],"p":[{},[0,2,1,2]],"r":[{"a":[{},[0,2,1]]}],"s":[{},[0,2,1,2]],"t":[{"a":[{},[0,2,1,2]],"t":[{},[0,0,1]]}],"v":[{"á":[{},[0,2,1]]}],"z":[{"o":[{},[0,0,1,2]]}]}],"í":[{"r":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"k":[{"l":[{},[0,0,1,2]],"ö":[{"l":[{"t":[{"ő":[{},[0,0,2,1]]}]}]}],"r":[{},[0,0,1,2]]}],"l":[{"e":[{"t":[{"a":[{},[0,0,0,0,2]]}]}],"i":[{"n":[{},[0,0,2,1]]}]}],"n":[{"y":[{"a":[{"l":[{},[0,0,0,0,1,2]],"n":[{},[0,0,0,0,1,2]],"s":[{},[0,0,0,0,1]]}],"e":[{"l":[{"e":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]],"r":[{},[0,0,2,0,1]]}],"é":[{"j":[{},[0,0,2]],"s":[{},[0,0,2]]}],"í":[{"r":[{},[0,0,0,0,1,2]]}],"ó":[{},[0,0,2]]}]}],"o":[{"b":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"p":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1]]}],"ó":[{"r":[{},[0,0,1,2]]}],"ö":[{"g":[{"e":[{},[0,0,0,3,2]]},[2]],"m":[{"ü":[{},[1]]}],"n":[{"t":[{},[0,2,1]]}],"r":[{},[0,2,1]],"s":[{"s":[{"z":[{"e":[{},[0,2]]}]}],"z":[{},[0,2,1]]}]}],"p":[{"e":[{"t":[{},[0,0,0,0,1,2]]}]}],"s":[{"p":[{},[0,0,1,2]],"v":[{},[0,0,1,2]]}],"t":[{"a":[{"r":[{},[0,0,0,0,2]]}],"á":[{"v":[{},[0,0,0,0,2,1]]}],"é":[{"k":[{"s":[{},[0,0,2,1]]}],"l":[{"é":[{},[0,0,2,1]],"ő":[{},[0,0,2,1]]},[0,0,0,0,2]],"r":[{"n":[{"e":[{},[0,0,0,1]]}]}],"s":[{"z":[{},[0,0,0,0,2]]}]}],"í":[{"v":[{},[0,0,2]]}],"o":[{"k":[{},[0,0,2,1]],"p":[{},[0,0,2]]}]}],"u":[{"d":[{},[0,0,1]],"j":[{},[0,0,1]],"n":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"s":[{},[0,0,1,2]],"t":[{},[0,0,1,2]]}],"ú":[{"j":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"l":[{"é":[{"k":[{},[0,0,0,2,1]]}]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"v":[{".":[{},[1]],"a":[{"s":[{},[0,0,0,0,2]]}],"b":[{},[1]],"e":[{"k":[{},[1]],"m":[{},[1]],"t":[{},[1]]}],"é":[{"b":[{},[1]],"h":[{},[1]],"v":[{},[1]]}],"h":[{},[1]],"n":[{},[1]],"r":[{},[1]],"t":[{},[1]],"ü":[{},[1]],"ű":[{},[1]],"v":[{},[1]]}],"z":[{"s":[{"á":[{},[0,0,2,0,1,2]],"e":[{"l":[{},[0,0,2,0,1,2]]}],"i":[{"d":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]]}],"í":[{},[0,0,2,0,1,2]],"o":[{},[0,0,2,0,1]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]},[0,0,0,4]]}]}],"s":[{"a":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1]]}],"á":[{"r":[{},[0,0,1]]}],"e":[{"l":[{},[0,2,1]],"s":[{"s":[{},[0,0,0,0,3]]}],"z":[{},[0,2,1]]}],"i":[{"é":[{},[0,0,0,0,2]],"p":[{},[0,2,1,2]]}],"k":[{"r":[{},[0,0,1,2]]}],"o":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"s":[{"z":[{"á":[{"r":[{},[0,0,0,0,0,2]]}],"e":[{"g":[{},[1]],"m":[{"b":[{},[0,0,0,0,1]]}],"s":[{},[1]]}],"í":[{},[0,0,3]]}]}],"t":[{"a":[{"r":[{"c":[{},[0,0,0,1]]}]}]}],"ü":[{"v":[{},[0,2,1,2]]}],"z":[{"a":[{},[0,2,0,1,2]],"e":[{"r":[{},[0,0,0,1,2]]}],"i":[{"s":[{"z":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"o":[{},[0,2,0,1,2]],"ő":[{},[0,2,0,1]],"t":[{"e":[{"l":[{"l":[{},[0,0,0,2,1]]}]}]}]}]}],"t":[{"a":[{"b":[{},[0,0,1]],"j":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"á":[{"b":[{},[0,0,1]],"g":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1,2]]}],"e":[{"k":[{"é":[{},[0,0,1]]}],"m":[{},[0,0,1,2]],"p":[{},[0,0,1]],"s":[{},[0,0,1]],"t":[{"a":[{},[0,0,0,2,1,2]],"e":[{"l":[{},[0,0,0,2]]}]}],"u":[{},[0,0,0,2]],"v":[{},[0,0,1,2]],"z":[{},[0,0,1,2]]}],"é":[{"l":[{"é":[{"k":[{},[0,0,0,2]]},[0,0,0,0,0,2]],"o":[{},[0,0,0,2,1]]}],"r":[{"t":[{"é":[{},[0,0,1]]}],"z":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,0,0,3]]}],"v":[{"e":[{"s":[{},[0,0,1,2]]}]}]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1]]}],"i":[{"r":[{},[0,0,1,2]]}],"í":[{"v":[{},[0,0,1,2]]}],"k":[{"r":[{},[0,0,1]]}],"l":[{"e":[{"t":[{"á":[{},[0,0,0,0,2,1]]},[1]]}],"é":[{},[1]]}],"o":[{"k":[{},[0,0,1]],"l":[{},[0,0,1]],"r":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ó":[{"r":[{},[0,0,1,2]]}],"ö":[{"d":[{"b":[{},[0,2]],"d":[{},[1,2]],"n":[{"e":[{},[1,2]]}],"ö":[{"t":[{},[1]]}],"r":[{},[1,2]],"ü":[{},[1]]}],"s":[{},[0,2]]}],"ő":[{"a":[{},[0,0,0,0,2]],"e":[{},[0,0,0,0,2]],"é":[{},[0,0,0,0,2]]}],"p":[{"r":[{},[0,0,1]]}],"s":[{"c":[{},[0,0,1]],"t":[{},[0,0,1]]}],"t":[{"a":[{"c":[{},[0,0,2,1,2]],"r":[{},[0,0,2]],"s":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1]],"r":[{},[0,0,0,0,2]]}],"e":[{"r":[{"k":[{},[0,0,0,1]]}]}],"é":[{"r":[{"t":[{"e":[{},[0,0,0,1]]}]}]}],"u":[{"t":[{},[0,0,2,1]]}]}],"u":[{"j":[{},[0,0,1]],"n":[{},[0,0,1]],"t":[{},[0,0,1,2]]}],"ü":[{"l":[{},[0,0,1,2]]}],"v":[{"e":[{"n":[{"e":[{"z":[{},[0,0,0,0,2,1]]}]}]}]}]}],"u":[{},[0,1]],"ú":[{},[0,1]],"ü":[{},[0,1]],"ű":[{},[0,1]],"v":[{"a":[{"b":[{},[0,0,1]],"k":[{},[0,0,1]]}],"á":[{"r":[{},[0,0,1,2]]}],"e":[{"d":[{"z":[{},[0,0,1,2]]}],"g":[{"a":[{},[0,0,0,2,1,2]],"é":[{"s":[{},[0,0,0,0,1]]}],"g":[{},[0,0,0,0,1]],"o":[{},[0,0,0,2]]}],"r":[{},[0,0,1,2]],"t":[{"a":[{},[0,0,0,2,1,2]],"e":[{"g":[{},[0,0,0,2]]}],"é":[{"l":[{},[0,0,0,2,1,2]]}],"o":[{},[0,0,0,2]],"ú":[{},[0,0,0,2,1]],"ü":[{"l":[{"é":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}]}]}],"é":[{".":[{},[0,2]],"g":[{},[0,0,1]],"j":[{},[0,0,1,2]],"n":[{"y":[{"e":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"ö":[{},[0,0,0,2]]}]}],"s":[{"z":[{"a":[{},[0,0,0,2]],"á":[{},[0,0,0,2]],"e":[{"r":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2]],"ö":[{},[0,0,0,2]],"ü":[{"l":[{},[0,0,0,2]]}]}]}]}],"i":[{"d":[{"á":[{},[0,0,0,2]]}],"h":[{},[0,2]],"s":[{"s":[{},[0,0,0,0,3]]}],"v":[{},[0,2]]}],"o":[{"r":[{},[0,0,1]]}],"ó":[{"d":[{},[0,0,1,2]]}],"ö":[{"l":[{"t":[{},[0,0,1]]}]}],"ő":[{"r":[{"é":[{"s":[{"s":[{},[0,0,0,0,0,0,3]]}]}]}]}],"u":[{"t":[{},[0,0,1]]}]}],"z":[{"a":[{"b":[{},[0,0,1]],"c":[{},[0,0,1,2]],"d":[{},[0,0,1,2]],"j":[{},[0,0,1,2]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1,2]],"m":[{},[0,0,1,2]],"n":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{},[0,0,1]],"u":[{},[0,0,1]],"z":[{},[0,0,1]]}],"á":[{"g":[{},[0,0,1,2]],"l":[{},[0,0,1]],"m":[{},[0,0,1,2]],"p":[{},[0,0,1,2]],"r":[{},[0,0,1,2]],"t":[{"é":[{},[0,0,0,0,1]]},[0,0,1,2]]}],"d":[{"r":[{},[0,0,1,2]]}],"e":[{"b":[{},[0,2,1,2]],"d":[{},[0,2,1,2]],"g":[{"e":[{"l":[{},[0,0,0,2]]}],"é":[{"s":[{"z":[{},[0,0,0,0,0,0,0,1]]},[0,2,1]]}],"y":[{},[0,2,1,2]]}],"l":[{"a":[{},[0,2,1]],"e":[{"m":[{"e":[{},[0,0,0,2]]}]}]}],"m":[{},[0,2,1,2]],"n":[{"g":[{},[0,0,1]],"t":[{},[0,0,1]]}],"p":[{"r":[{},[0,0,1]]}],"r":[{},[0,2,1]],"s":[{},[0,2,1]],"t":[{"é":[{"k":[{},[0,0,0,2,1,2]]}],"ő":[{"r":[{},[0,0,0,2,1]]},[0,0,0,0,0,2]]}],"v":[{},[0,2,1,2]]}],"é":[{"g":[{},[0,2,1]],"j":[{"e":[{},[0,2,1,2]]}],"k":[{"e":[{"l":[{},[0,0,0,2,1,2]]}]}],"l":[{"e":[{"l":[{},[0,0,1]],"t":[{".":[{},[0,0,1,2]]}]}],"é":[{},[0,0,1,2]],"m":[{},[0,0,1]],"t":[{},[0,0,1]]}],"m":[{"e":[{},[0,0,1]]},[0,0,0,2]],"p":[{"a":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2,1]],"m":[{},[0,0,0,2,1]]}],"í":[{"t":[{},[0,0,1]]},[0,0,0,2]],"o":[{},[0,0,0,2,1]]}],"r":[{".":[{},[0,2,1]],"b":[{},[0,2,1]],"d":[{},[0,2,1]],"h":[{},[0,2,1]],"i":[{},[0,2,1,2]],"t":[{"e":[{"h":[{},[0,0,0,0,2,1,2]],"l":[{"e":[{},[0,2,1]]}]}],"é":[{},[0,2,1]],"ő":[{},[0,2,1]]}],"v":[{},[0,2,1]],"z":[{},[0,2,1]]}],"t":[{"k":[{},[0,0,1]]}]}],"f":[{"r":[{},[0,0,1]]}],"i":[{"g":[{"a":[{"z":[{},[0,0,0,0,0,0,1]]},[0,2,1]],"á":[{},[0,2,1]],"é":[{},[0,2,1]],"y":[{},[0,2,1]]},[0,0,0,2]],"k":[{"o":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"l":[{"l":[{},[0,2,1]]}],"m":[{},[0,2,1,2]],"n":[{"f":[{},[0,2,1]],"g":[{},[0,2,1]],"p":[{},[0,2,1]],"t":[{},[0,2,1]],"ú":[{},[0,2,1]],"v":[{},[0,2,1]]}],"r":[{"a":[{},[0,2,1]],"á":[{},[0,0,1]],"i":[{},[0,2,1,2]],"o":[{},[0,0,1]],"ó":[{},[0,2,1]]}],"s":[{"k":[{"o":[{},[0,0,1]]}],"m":[{},[0,2,1]],"p":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"z":[{},[0,2,1]]}],"í":[{"r":[{},[0,0,1]],"z":[{},[0,0,1]]}],"m":[{"e":[{"g":[{"g":[{},[0,0,0,0,0,1]]}]}]}],"o":[{"b":[{},[0,0,1]],"k":[{},[0,0,1,2]],"l":[{},[0,0,1]],"p":[{},[0,0,1]],"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"ó":[{"h":[{},[0,0,1,2]],"n":[{},[0,0,1]]}],"ö":[{"n":[{"t":[{},[1]]}],"r":[{},[0,2,1,2]],"s":[{"s":[{"z":[{},[0,0,1]]}]}],"v":[{},[0,2,1]]}],"ő":[{"a":[{},[0,0,0,0,2]],"e":[{"r":[{},[0,0,0,0,2]]}],"r":[{".":[{},[0,0,1]],"k":[{},[0,0,1]],"ö":[{},[0,0,1,2]]}]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"s":[{"a":[{},[0,0,3]],"á":[{},[0,0,3]],"e":[{},[0,0,3]],"é":[{},[0,0,3]],"k":[{},[0,0,3,2]],"o":[{},[0,0,3]],"p":[{},[0,0,3,2]],"ú":[{},[0,0,3]],"z":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,1,2]]}],"u":[{"g":[{},[0,0,1]],"n":[{},[0,0,1,2]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"ú":[{"r":[{},[0,0,1,2]],"t":[{},[0,0,1]]}],"ü":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"n":[{"n":[{},[0,0,1]]}],"t":[{},[0,2,1]],"v":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"z":[{"s":[{},[0,0,3]]}]}]}],"ő":[{".":[{},[2]],"a":[{"d":[{"a":[{},[0,0,2]],"á":[{"s":[{"s":[{},[0,0,0,0,0,1]],"z":[{},[0,0,0,0,2]]}]},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"y":[{"a":[{"g":[{},[0,0,0,0,0,0,1]]}]},[0,0,2]]}],"j":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]]}],"k":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"l":[{"a":[{"g":[{},[0,0,0,0,2,1]]},[0,0,2]],"e":[{},[0,0,2,1]],"o":[{},[0,0,2]]}],"m":[{"ő":[{},[0,0,2]]}],"n":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"y":[{"á":[{},[0,0,2]]}]}],"p":[{"a":[{"r":[{},[0,2]]},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"o":[{},[0,0,2]],"y":[{},[0,0,2]]}],"u":[{"l":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{"ó":[{"i":[{"k":[{},[0,0,0,0,0,0,2]]}]}]},[0,0,2]]}],"v":[{"a":[{},[0,0,2]]}],"x":[{"i":[{},[0,0,2]]}],"z":[{"o":[{},[0,0,2]]}]},[0,1]],"á":[{"c":[{"s":[{},[0,0,2]]}],"g":[{"a":[{"i":[{},[0,0,2]],"k":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ú":[{},[0,0,2]],"y":[{},[0,0,2]]}],"h":[{"í":[{},[0,0,2]]}],"l":[{"a":[{},[0,0,2]],"o":[{},[0,0,2]]}],"m":[{"í":[{},[0,0,2]]}],"p":[{"o":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{"m":[{},[0,0,0,1]]},[0,0,2,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]],"ú":[{},[0,0,2]]}],"s":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]],"z":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{},[0,0,2,1,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"v":[{"ó":[{},[0,0,2]]}]},[0,1]],"b":[{"a":[{"p":[{},[0,0,0,1]]}],"l":[{"e":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}]}],"c":[{"a":[{"p":[{},[0,0,1]]}],"c":[{"s":[{"o":[{},[0,0,3]]}]}],"g":[{"r":[{},[0,0,1]]}],"h":[{"á":[{},[0,0,3]],"é":[{},[0,0,3]],"ö":[{},[0,0,3]]}],"l":[{"u":[{},[0,0,2]]}],"s":[{"a":[{"l":[{"a":[{},[0,2,0,1]]}],"p":[{"á":[{"g":[{},[0,0,0,0,2,1,2]]}]}]}],"é":[{"j":[{},[0,2,0,1,2]],"r":[{"ü":[{},[0,2,0,1,2]]}]}],"ő":[{"s":[{"t":[{},[0,0,0,1]]}]}],"s":[{},[0,0,0,1]],"z":[{},[0,0,3]]}]}],"d":[{"a":[{"d":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]]}],"l":[{"a":[{"p":[{},[0,2,1,2]]}]}],"u":[{},[0,2,1]]}],"á":[{"l":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"e":[{"a":[{},[0,0,0,0,2]],"g":[{},[0,2,1,2]],"l":[{"d":[{},[0,0,1]],"j":[{},[0,0,1]],"k":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"s":[{},[0,0,1]]}]}],"é":[{"p":[{},[0,2,1]],"r":[{"t":[{"e":[{},[0,2,1]]}],"z":[{},[0,2,1]]}],"s":[{"a":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"s":[{},[0,0,0,0,3]],"z":[{},[0,0,0,2,3]]}]}],"i":[{"d":[{},[0,2,1]],"g":[{"a":[{},[0,2,1]]},[0,0,0,2]],"n":[{"d":[{},[0,0,1]],"t":[{},[0,0,1]]}],"s":[{"k":[{},[0,2,1]]}]}],"o":[{"p":[{},[0,2,1]],"s":[{"t":[{},[0,0,1]]}]}],"ö":[{"l":[{},[0,2,1,2]],"v":[{},[0,2,1]]}],"ő":[{"r":[{".":[{},[0,0,1]],"é":[{},[0,0,1,2]],"n":[{},[0,0,1]],"r":[{},[0,0,1]],"t":[{},[0,0,1]]}],"s":[{"t":[{},[0,2,1]]}]}],"p":[{"r":[{},[0,0,1]]}],"r":[{"a":[{"m":[{},[0,0,2]],"p":[{},[0,0,2]]}],"á":[{},[0,1,2]],"e":[{"s":[{},[0,1,2]]}],"o":[{"g":[{},[0,1,2]]}],"ó":[{},[0,1,2]],"u":[{},[0,1,2]]}],"s":[{"t":[{},[0,0,1]]}],"t":[{"r":[{},[0,0,1,2]]}],"ü":[{"g":[{},[0,2,1]],"z":[{},[0,2,1]]}],"z":[{"á":[{},[0,2,3]]}]}],"e":[{"c":[{"e":[{},[0,0,2]],"s":[{},[0,0,2]]}],"d":[{"é":[{},[0,0,2]],"z":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"k":[{"e":[{".":[{},[0,0,2]]}],"é":[{"k":[{},[0,0,2]]}]}],"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2,1,2]],"e":[{"k":[{},[0,0,2]],"m":[{"é":[{},[0,0,2]],"g":[{},[0,0,2]],"h":[{},[0,0,2]],"m":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"ü":[{},[0,0,2]]}]}],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{"d":[{},[0,0,2]]}],"ü":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"u":[{},[0,0,2]]}],"n":[{"e":[{},[0,0,2]]}],"p":[{"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"ő":[{"d":[{},[0,0,2]],"é":[{},[0,0,2]],"h":[{},[0,0,2]],"i":[{".":[{},[0,0,2]]}],"k":[{},[0,0,2]],"m":[{},[0,0,2]],"r":[{"ő":[{},[0,0,2]]}]}],"ü":[{},[0,0,2]]}],"s":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]]}],"u":[{"n":[{},[0,0,2]]}],"v":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]]}]},[0,1]],"é":[{"d":[{"e":[{},[0,0,2]]}],"e":[{"t":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"h":[{"e":[{"m":[{},[0,0,2]],"s":[{},[0,0,2]]}]}],"j":[{"i":[{},[0,0,2]]}],"k":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"í":[{},[0,0,2]]}],"l":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]],"ű":[{},[0,0,2]]}],"n":[{"e":[{"k":[{"b":[{},[0,0,2]],"e":[{"s":[{"t":[{},[0,0,0,0,2]]}]},[0,0,2]],"é":[{},[0,0,2]],"k":[{},[0,0,2]],"r":[{},[0,0,2]]}]}]}],"p":[{"í":[{},[0,0,2]],"ü":[{},[0,0,2]]}],"r":[{"e":[{"m":[{},[0,0,2]],"n":[{},[0,0,2]],"z":[{},[0,0,2]]}],"é":[{},[0,0,2]],"i":[{},[0,0,2]]}],"t":[{"e":[{"k":[{},[0,0,2]]}]}],"v":[{"a":[{},[0,0,2]],"e":[{".":[{},[0,0,2]],"k":[{},[0,0,2]],"s":[{},[0,0,2]],"t":[{},[0,0,2]]}],"é":[{"b":[{},[0,0,2]],"n":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,2]]}],"i":[{},[0,0,2]]}]},[0,1]],"f":[{"a":[{"l":[{"a":[{"d":[{},[0,0,0,2,1,2]]}]}]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"ö":[{},[0,0,2]],"u":[{},[0,0,2]]}],"o":[{"k":[{"á":[{"l":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"i":[{"n":[{},[0,0,0,2]]}]}]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,1,2]],"ö":[{},[0,0,2]]}]}],"g":[{"é":[{"p":[{"e":[{"l":[{},[0,0,0,2,1,2]]}],"ü":[{"l":[{"é":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}]}],"s":[{"s":[{},[0,0,0,0,3]]}]}],"l":[{"e":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"n":[{"ó":[{},[0,0,2]]}],"ö":[{"l":[{},[0,2,1,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"u":[{"b":[{"a":[{},[0,0,0,0,0,2]]}]}],"y":[{"a":[{"l":[{"a":[{},[0,0,0,1,2]]}],"r":[{"t":[{},[0,0,0,1]]}]}],"e":[{"g":[{},[0,2]],"l":[{"ő":[{},[0,0,0,1,2]],"v":[{},[0,0,0,1]],"z":[{},[0,0,0,1]]},[0,2]]}],"i":[{"n":[{},[0,2]]}],"ö":[{"r":[{},[0,2,0,1]]}]}]}],"h":[{"a":[{"n":[{"g":[{"á":[{"r":[{"a":[{},[0,0,0,0,2,1]]}]},[0,0,0,0,0,0,2]]}]}]}]}],"i":[{"d":[{"e":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"g":[{},[0,0,2]],"o":[{},[0,0,2]]}],"é":[{"n":[{},[0,0,2]]}],"o":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"g":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"y":[{},[0,0,2]]}],"k":[{"o":[{},[0,0,2]]}],"m":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"p":[{"l":[{},[0,0,0,1,2]]}]}],"n":[{"a":[{"s":[{},[0,0,2]]}]}],"o":[{"n":[{},[0,0,2]]}],"p":[{"a":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,2]]}],"s":[{"i":[{},[0,0,2]],"z":[{},[0,0,2]]}],"t":[{"a":[{"l":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"l":[{},[0,0,2]]}]}]}],"v":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"z":[{"é":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[0,1]],"í":[{"g":[{"é":[{},[0,0,2]]}],"j":[{"a":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"v":[{"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ü":[{"k":[{"b":[{},[0,0,2]],"e":[{},[0,0,2]]}],"n":[{},[0,0,2]]}],"ű":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"ü":[{},[0,0,2]],"ű":[{},[0,0,2]]}]},[0,1]],"j":[{"e":[{"g":[{"y":[{"á":[{},[0,0,0,2,0,1,2]]}]}]}],"o":[{"b":[{"b":[{"o":[{"l":[{},[0,0,0,0,2,1]]}],"ó":[{},[0,0,0,0,2,1]]}]}],"g":[{"á":[{"s":[{"z":[{"i":[{},[0,0,0,0,0,2]]}]}]}]}]}]}],"k":[{"e":[{"k":[{},[0,0,0,1,2]],"p":[{},[0,0,0,1,2]],"s":[{"p":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"é":[{"p":[{"e":[{"l":[{},[0,0,0,2,1]]}]}],"s":[{"e":[{"l":[{},[0,0,0,2,1]]}]}]}],"i":[{"á":[{},[0,0,0,0,2]],"e":[{},[0,0,0,0,2]]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,2]],"í":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}],"ó":[{"r":[{"o":[{},[0,0,0,0,0,2]]}]}],"r":[{"a":[{},[0,1,2]],"á":[{},[0,1,2]],"e":[{"á":[{},[0,1,2]],"d":[{},[0,0,2]]}],"é":[{},[0,1,2]],"i":[{},[0,1,2]],"í":[{},[0,1,2]],"o":[{},[0,1,2]],"ó":[{},[0,1,2]]}],"v":[{"a":[{},[0,0,2]]}]}],"l":[{"e":[{"í":[{},[0,0,0,0,2]]}],"é":[{"s":[{"s":[{},[0,0,0,0,3]]}]}],"ő":[{"é":[{"r":[{},[0,0,0,0,2]]}],"t":[{"r":[{},[0,0,0,1]]},[0,0,0,0,2]]}]}],"m":[{"a":[{"g":[{"á":[{"r":[{},[0,0,0,2]]}],"g":[{},[0,0,0,0,1]],"ó":[{},[0,0,0,2,1,2]]}]}],"ű":[{"é":[{"h":[{},[0,0,0,0,2]],"n":[{},[0,0,0,0,2]]}],"t":[{},[0,0,0,0,2]]}]}],"n":[{"e":[{"k":[{"e":[{},[0,2,1,2]]}],"m":[{"s":[{},[0,0,1]]}]}],"é":[{"v":[{"e":[{"s":[{},[0,0,0,0,1]]},[0,0,0,0,0,2]]}]}],"y":[{"a":[{"d":[{},[0,2,0,1,2]],"g":[{"a":[{},[0,2,0,1]]},[0,0,0,0,2]],"l":[{"a":[{},[0,0,0,1,2]]}]}],"á":[{"r":[{"a":[{},[0,0,0,1]],"o":[{},[0,0,0,1,2]]}],"t":[{},[0,2]]}],"e":[{"f":[{},[0,2]],"l":[{"e":[{"m":[{},[0,0,0,0,2]]}],"h":[{},[0,2,0,1]],"l":[{},[0,2,0,1]],"o":[{},[0,2,0,1]]}],"m":[{},[0,2,0,1]]}],"é":[{"l":[{"v":[{},[0,2,0,1]]}]}],"ő":[{},[0,2,0,1]],"ü":[{"z":[{},[0,2]]}]}]}],"o":[{"á":[{"z":[{},[0,0,2]]}],"b":[{"e":[{},[0,0,2]]}],"d":[{"ú":[{},[0,0,2]]}],"k":[{"á":[{},[0,0,2]],"i":[{},[0,0,2,1,2]],"í":[{},[0,0,2]],"o":[{},[0,0,2]]}],"l":[{"a":[{"j":[{"á":[{"r":[{},[0,0,0,0,2,1,2]]}],"e":[{},[0,0,0,0,2]]}]},[0,0,2]]}],"p":[{"e":[{},[0,0,2]]}],"r":[{"á":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"s":[{"o":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]]}],"x":[{"i":[{},[0,0,2]]}]},[0,1]],"ó":[{"c":[{"e":[{},[0,0,2]]}],"h":[{"a":[{},[0,0,2]]}],"n":[{"o":[{},[0,0,2]],"u":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"i":[{},[0,0,2]]}],"v":[{"a":[{},[0,0,2]],"ó":[{},[0,0,2]]}]},[0,1]],"ö":[{"b":[{"ö":[{},[0,0,2]]}],"d":[{"é":[{},[0,0,2]]}],"k":[{"o":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"l":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"n":[{"a":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"ö":[{},[0,0,2]]}]},[0,1]],"ő":[{"r":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"s":[{"é":[{"g":[{"b":[{},[0,0,0,2,1]],"n":[{},[0,0,0,2,1]]}]}]}]}],"s":[{"e":[{},[0,0,2]],"i":[{},[0,0,2]]}]},[0,1]],"p":[{"á":[{"r":[{"b":[{"a":[{"j":[{"o":[{},[0,0,0,0,0,0,2]]}]}]}]}]}],"l":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]]}],"n":[{"e":[{},[0,0,2]]}],"o":[{"n":[{"c":[{},[0,0,0,0,0,1]]}],"r":[{"a":[{"l":[{},[0,0,0,2]]}]}]}],"r":[{"e":[{},[0,0,2]],"é":[{"s":[{"s":[{},[0,0,0,0,0,1]]}]},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]],"ó":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}]}],"r":[{"a":[{"d":[{"ó":[{},[0,0,1,2]]}],"g":[{"á":[{},[0,0,1,2]],"g":[{},[0,0,1]]}],"j":[{"k":[{},[0,0,1]],"t":[{"ó":[{"l":[{},[0,0,0,0,2,1]]}]}]}],"k":[{"c":[{},[0,0,1]]}],"l":[{"e":[{},[0,0,0,0,1]]},[0,2,1,2]],"n":[{"y":[{},[0,0,1]]},[0,0,0,2]],"p":[{},[0,0,1]],"r":[{},[0,2,1,2]],"s":[{},[0,2,1,2]],"t":[{},[0,2,1]],"u":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"á":[{"b":[{},[1,2,1]],"d":[{"i":[{"ó":[{"k":[{},[0,0,0,0,0,2]]}]}]}],"g":[{"y":[{},[0,0,1]]}],"k":[{"e":[{},[0,0,0,2,1]]}],"l":[{},[0,2,1,2]],"p":[{},[0,2,1,2]],"r":[{"u":[{},[0,0,1,2]]}]}],"b":[{"í":[{},[1]],"l":[{},[1,0,1]],"r":[{},[1,0,1]]}],"e":[{"a":[{},[2]],"á":[{"l":[{"i":[{},[0,0,0,0,2]]}]}],"e":[{},[0,0,0,0,2]],"g":[{"e":[{"t":[{},[0,0,0,2]]}],"y":[{"e":[{},[0,0,1,2]]}]}],"i":[{"g":[{},[0,0,0,0,2]]}],"k":[{"c":[{},[0,2,1]],"h":[{},[0,2,1]]}],"l":[{"e":[{"m":[{},[0,0,0,2]]}],"h":[{},[0,0,1]],"l":[{},[0,2,1]],"ő":[{"a":[{},[0,0,1,2]]}],"s":[{},[0,0,1]],"t":[{},[0,0,1]],"v":[{},[0,2,1]]}],"m":[{"b":[{},[0,2,1]],"l":[{},[0,0,1]]}],"n":[{"d":[{"ő":[{},[0,0,0,0,2,1,2]]}],"z":[{},[0,0,1]]}],"o":[{},[0,0,0,0,2]],"p":[{"r":[{"o":[{"g":[{},[0,0,0,1]]}]}]}],"s":[{"ő":[{},[0,2,1,2]]}],"u":[{},[0,0,0,0,2]],"ü":[{},[0,0,0,0,2]],"x":[{},[0,2,1]],"z":[{"r":[{},[1]]}]}],"é":[{"g":[{".":[{},[1,2,1]],"n":[{},[1]],"t":[{},[1,0,1]]}],"k":[{"h":[{},[1,2,1]],"n":[{"é":[{},[0,0,1]]}],"s":[{},[0,0,1]]}],"l":[{},[0,2,1,2]],"p":[{"ü":[{},[0,0,1]]}],"r":[{"i":[{},[0,2,1,2]]}],"s":[{"a":[{},[0,0,0,2]],"z":[{"a":[{},[0,0,0,2]]}]}],"ü":[{},[1,2]],"v":[{"e":[{".":[{},[0,0,1,2]],"k":[{},[0,0,1,2]]}]}]}],"f":[{"l":[{},[0,0,1]],"ő":[{},[1]],"r":[{},[0,0,1]]}],"g":[{"r":[{},[0,0,1,2]]}],"i":[{"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"a":[{},[0,2,1,2]],"á":[{},[0,2,1,2]]}],"h":[{"a":[{},[0,0,1]]}],"l":[{"l":[{},[0,0,1]]}],"m":[{"i":[{},[0,0,1]]},[0,2]],"n":[{"a":[{},[0,0,1,2]],"d":[{},[0,0,1]],"f":[{},[0,2,1]],"t":[{},[0,2,1]]}],"p":[{"a":[{},[0,0,1,2]]}],"s":[{"á":[{},[0,0,0,2,1]]}],"v":[{"á":[{},[0,0,1]]}],"z":[{"é":[{".":[{},[0,0,1,2]]}],"g":[{},[0,2]],"m":[{},[0,0,1]],"o":[{},[0,0,1,2]]}]}],"í":[{"r":[{},[0,0,1]]}],"j":[{"ö":[{},[1]]}],"k":[{"l":[{},[0,0,1,2]],"r":[{},[0,0,1,2]]}],"l":[{"ö":[{},[1]]}],"o":[{"k":[{"t":[{},[0,2,1]]}],"l":[{"d":[{},[0,0,1]],"i":[{},[1,2,1,2]],"l":[{},[0,0,1]]}],"r":[{},[0,2,1]],"s":[{"z":[{},[0,2,1]]}]}],"ó":[{"r":[{},[0,2,1,2]]}],"ö":[{"g":[{},[0,3]],"k":[{"ü":[{},[1,2]]}],"l":[{},[0,2]],"m":[{"ü":[{},[1]]}],"n":[{"g":[{},[0,0,1]]}],"r":[{},[0,2,1]],"s":[{"s":[{"z":[{"e":[{},[0,2,1]]}]}]}]}],"ő":[{"r":[{},[1,2,1]],"s":[{"r":[{},[1]]},[0,2,1,2]],"z":[{},[0,2,1,2]]}],"p":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"s":[{},[1,0,1,2]]}],"s":[{".":[{},[1]],"á":[{"l":[{},[0,0,2,1]]}],"í":[{},[1]],"ö":[{},[1]],"p":[{"e":[{},[0,0,1,2]],"i":[{},[0,0,1]]}],"r":[{"á":[{},[0,0,1]]}],"s":[{},[0,0,0,3]],"z":[{"e":[{"n":[{},[1]]}],"ö":[{"m":[{},[0,0,2,3]]}]},[0,0,1,0,2]]}],"t":[{"r":[{},[1,0,1,2]]}],"u":[{"n":[{},[1,2,1]],"r":[{},[1,2,1,2]],"t":[{"á":[{},[0,0,1]]}]}],"ú":[{"j":[{},[0,2,1]],"r":[{},[0,0,1]],"t":[{},[0,2,1]]}],"ü":[{"d":[{},[0,2,1]],"l":[{"d":[{},[0,0,1]],"e":[{},[1,2]]}],"s":[{},[0,2,1]],"t":[{},[0,2,1]],"z":[{},[0,2,1]]}],"z":[{"ő":[{"s":[{"ö":[{},[2]]}]}]}]}],"s":[{"a":[{"d":[{},[0,2,1]],"g":[{},[0,2,1,2]],"j":[{"t":[{"ó":[{"b":[{},[0,0,1]],"k":[{},[0,2,1]]}]}]}],"n":[{"a":[{},[0,0,1]]},[0,0,0,2]],"p":[{},[0,0,0,2]],"r":[{"c":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,1]]}],"u":[{},[0,0,1]]}],"á":[{"b":[{},[0,2,1]],"g":[{},[0,2,1,2]],"l":[{"l":[{},[0,0,1]]},[0,0,0,2]],"r":[{"a":[{},[0,0,1]],"v":[{},[0,0,1]]}]}],"d":[{"r":[{},[0,0,1]]}],"e":[{"d":[{},[0,0,1,2]],"g":[{"e":[{},[0,2,1,2]],"y":[{},[0,2,1,2]]}],"l":[{"m":[{},[0,0,1]],"ő":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"m":[{},[0,2,1,2]],"n":[{"e":[{},[0,0,1]]},[0,0,0,2]],"p":[{"i":[{},[0,0,1]],"o":[{},[0,0,1]]},[0,0,0,2]],"r":[{"e":[{"j":[{},[0,0,1,2]]}],"ő":[{},[0,0,1]]}],"s":[{"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"t":[{"n":[{},[0,0,1]]}],"v":[{},[0,2,1,2]],"z":[{},[0,2,1]]}],"é":[{"g":[{"e":[{"l":[{},[0,0,0,2,1,2]],"r":[{},[0,2,1]]}],"é":[{"s":[{},[0,0,0,2]]}]}],"k":[{},[0,2,1]],"l":[{},[0,2,1,2]],"p":[{},[0,0,1]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1]]}],"g":[{"n":[{},[0,0,1]],"r":[{},[0,0,1]]}],"i":[{"d":[{},[0,2,1,2]],"f":[{},[0,2,1]],"g":[{"a":[{},[0,0,1]]},[0,0,0,2]],"m":[{"a":[{},[0,0,1,2]],"á":[{},[0,0,1,2]],"i":[{},[0,0,1]]}],"n":[{"f":[{},[0,0,1]],"g":[{},[0,0,1]],"t":[{},[0,0,1]]}],"p":[{"a":[{},[0,2,1,2]]}],"r":[{"a":[{},[0,0,1,2]]}],"s":[{"t":[{},[0,0,1]],"z":[{},[0,0,1,2]]}],"z":[{},[0,2,1,2]]}],"í":[{"k":[{"a":[{},[0,0,0,2]]}],"r":[{"ó":[{},[0,0,1,2]]}],"z":[{},[0,0,1,2]]}],"k":[{"á":[{"l":[{},[0,0,2]]}],"l":[{},[0,0,1]],"r":[{},[0,0,1,2]],"v":[{},[0,0,1]]}],"l":[{"a":[{"t":[{},[0,0,2]]}]}],"n":[{"i":[{"t":[{},[0,0,2]]}]}],"o":[{"b":[{},[0,0,1]],"k":[{"o":[{},[0,0,1]]},[0,0,0,2]],"l":[{},[0,2,1,2]],"p":[{},[0,2,1]],"r":[{"g":[{},[0,2,1]]}],"s":[{},[0,2,1]]}],"ó":[{"c":[{},[0,0,1]],"r":[{"i":[{},[0,0,1]]}]}],"ö":[{"l":[{},[0,2,1,2]],"n":[{"z":[{},[0,0,1]]}],"r":[{"d":[{},[0,0,1]],"e":[{},[0,0,1]],"ö":[{},[0,0,1]],"v":[{},[0,0,1]]},[0,0,0,2]],"z":[{},[0,2,1,2]]}],"ő":[{"r":[{},[0,0,1]],"s":[{},[0,0,1,2]]}],"p":[{"e":[{"c":[{},[0,0,2]],"k":[{},[0,0,2]]}],"l":[{},[0,0,1,2]],"ó":[{"r":[{},[0,0,2]]}],"r":[{},[0,0,0,2]]}],"r":[{"á":[{"c":[{},[0,0,2]]}]}],"s":[{"k":[{},[0,0,1]],"p":[{},[0,0,1,2]],"t":[{},[0,0,1,2]],"z":[{"a":[{},[0,0,3]],"á":[{},[0,0,3]],"e":[{"g":[{},[0,0,3]],"k":[{},[0,0,3]],"l":[{"l":[{},[0,0,3]]}],"m":[{},[0,0,3]],"n":[{},[0,0,3]],"r":[{},[0,0,3]],"s":[{},[0,0,3]]}],"é":[{"k":[{},[0,0,3]],"n":[{},[0,0,3]]}],"f":[{},[0,0,3]],"i":[{},[0,0,3]],"í":[{},[0,0,3]],"l":[{},[0,0,3]],"o":[{},[0,0,3]],"ó":[{},[0,0,3]],"ö":[{},[0,0,3]],"ő":[{},[0,0,3]],"u":[{},[0,0,3]],"ü":[{},[0,0,3]]},[0,0,0,0,2]]}],"t":[{"a":[{"d":[{},[0,0,2]],"t":[{},[0,0,2]]}],"á":[{"t":[{},[0,1,2]]}],"e":[{"r":[{"i":[{},[0,1,2]]}]}],"é":[{"g":[{},[0,0,2]]}],"i":[{"l":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,1]]},[0,0,0,2]]}],"u":[{"n":[{},[0,0,1]],"t":[{"a":[{},[0,0,1]]},[0,0,0,2]]}],"ú":[{"r":[{".":[{},[0,0,1]]}],"s":[{},[0,0,1,2]]}],"z":[{"a":[{"k":[{"e":[{},[0,0,0,0,2,1]],"ü":[{},[0,0,0,0,2,1]]}]}],"e":[{"l":[{"ő":[{},[0,0,0,1,2]]}],"r":[{"k":[{},[2]],"ő":[{},[0,2]]}],"s":[{"t":[{},[0,0,0,1]]}]}],"i":[{"l":[{"i":[{},[0,0,0,0,2,1,2]],"l":[{},[0,0,0,1]]}],"s":[{"t":[{},[0,0,0,1]]}]}],"ö":[{"l":[{"é":[{},[0,0,0,1]],"ő":[{},[0,0,0,1]],"t":[{},[0,0,0,1]]},[0,0,0,0,2]]}],"s":[{"e":[{},[0,0,3]],"i":[{"r":[{},[0,0,0,3]]}]}],"t":[{},[0,0,0,0,2]],"ű":[{"r":[{"ű":[{},[0,2,3]]}]}]}]}],"t":[{"e":[{"r":[{"m":[{"o":[{"s":[{"z":[{},[0,0,0,0,0,0,0,0,2]]}]},[0,0,0,0,0,0,1]]}]}],"s":[{"t":[{"ő":[{},[0,0,0,0,2,1]]}]}]}],"o":[{"l":[{"l":[{"a":[{"d":[{},[0,0,0,0,2,1,2]]}]}]}]}],"r":[{"a":[{},[0,1,2]],"é":[{},[0,1,2]],"i":[{},[0,1,2]],"o":[{},[0,0,2]],"ó":[{},[0,1,2]]}],"t":[{"e":[{"s":[{"s":[{},[0,0,0,0,0,3]]}]}],"é":[{"s":[{},[0,0,2]]}],"i":[{"n":[{"t":[{},[0,0,0,1]]}]}],"o":[{},[0,0,2,1,2]],"u":[{},[0,0,2,1,2]]}],"ű":[{"f":[{"é":[{"l":[{},[0,0,0,0,0,0,1]]},[0,0,0,0,0,2]]}]}]}],"u":[{"g":[{"o":[{},[0,0,2]]}],"n":[{"i":[{},[0,0,2]]}],"r":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"u":[{},[0,0,2]]}],"t":[{"a":[{},[0,0,2]],"ó":[{},[0,0,2]],"u":[{},[0,0,2]]}]},[0,1]],"ú":[{"j":[{"o":[{},[0,0,2]]}],"r":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"o":[{},[0,0,2]]}]},[0,1]],"ü":[{"d":[{"ü":[{},[0,0,2]]}],"g":[{"e":[{},[0,0,2]],"y":[{},[0,0,2]]}],"l":[{"e":[{},[0,0,2]]}],"r":[{"e":[{},[0,0,2]],"í":[{},[0,0,2]]}],"s":[{"z":[{},[0,0,2]]}],"t":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]]}],"v":[{"e":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]]}]},[0,1]],"ű":[{"r":[{"é":[{},[0,0,2]],"i":[{},[0,0,2]],"ö":[{},[0,0,2]]}],"z":[{"é":[{},[0,0,2]],"ő":[{},[0,0,2]]}]},[0,1]],"v":[{"a":[{"s":[{"f":[{"é":[{"l":[{},[0,0,0,0,0,0,0,1]]},[0,0,0,0,0,0,2]]}]}]}],"á":[{"r":[{"a":[{"l":[{},[0,0,0,0,1]]}]}]}],"e":[{"r":[{"a":[{},[0,0,0,2,1]]}],"t":[{},[2]]}],"é":[{"r":[{"e":[{"s":[{},[0,0,0,2]],"t":[{},[0,0,0,2]]}]}]}]}],"z":[{"a":[{"b":[{"s":[{},[0,0,1]]}],"d":[{},[0,2,1,2]],"g":[{},[0,0,1,2]],"k":[{},[0,2,1]],"l":[{},[0,2,1,2]],"t":[{},[0,2,1,2]],"u":[{},[0,2,1]]}],"á":[{"l":[{},[0,2,1]],"t":[{"e":[{},[0,0,1,2,1,2]]}]}],"b":[{"l":[{},[0,0,1]]}],"e":[{"g":[{"g":[{},[0,0,0,0,1]],"i":[{},[0,0,0,2,1]],"y":[{},[0,0,1,2]]}],"k":[{"n":[{},[1,2]]}],"l":[{"o":[{},[0,0,1]],"s":[{},[0,0,1]],"v":[{},[0,0,1]]}],"m":[{"b":[{},[0,0,1]],"e":[{"l":[{},[0,0,1,2]]}]},[0,2]],"r":[{},[0,2,1,2]],"t":[{"a":[{},[0,0,0,2,1,2]],"e":[{"g":[{},[0,0,0,2,1]],"l":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2]]}],"o":[{},[0,0,0,2,1]]}]}],"é":[{"r":[{".":[{},[0,2,1]],"e":[{"m":[{},[0,0,0,2]]}],"i":[{},[0,2,1,2]],"l":[{},[0,2,1]],"t":[{"é":[{},[0,0,1]]}]}]}],"i":[{"é":[{},[1,2]],"g":[{"é":[{},[0,0,1]]},[0,2,0,2]],"n":[{},[0,2,1]],"z":[{},[0,2,1]]}],"k":[{"r":[{},[0,0,1,2]]}],"o":[{"k":[{},[0,0,1,2]],"l":[{},[0,0,1]],"s":[{},[0,0,1]]}],"ö":[{"s":[{"s":[{"z":[{},[0,0,1]]}]}]}],"ő":[{"a":[{},[0,0,0,0,2]],"e":[{"l":[{},[0,0,0,0,2]],"r":[{},[0,0,0,0,2]]}]}],"p":[{"r":[{},[0,0,1,2]]}],"s":[{"a":[{"j":[{},[0,0,3]],"p":[{},[0,0,3]]}],"á":[{"t":[{},[0,0,3]]}],"i":[{"k":[{},[0,0,3]],"s":[{},[0,0,3]]}],"t":[{},[0,0,3,2]],"ü":[{},[0,2,3]],"z":[{},[0,0,3]]}],"t":[{"r":[{},[0,0,1,2]]}],"ú":[{"t":[{},[0,0,1]]}],"ü":[{"g":[{},[0,0,1]],"s":[{},[0,2,1]],"z":[{},[0,2,1,2]]}],"ű":[{"z":[{},[0,0,1,2]]}]}]}],"p":[{".":[{},[2]],"a":[{"b":[{"l":[{},[2,1]]}],"c":[{"e":[{"m":[{},[0,0,2]]}],"h":[{},[0,0,2]],"l":[{},[0,0,1]],"s":[{"ú":[{},[0,0,2]]}]}],"d":[{"a":[{"g":[{},[0,1,2]],"l":[{"a":[{},[0,0,0,1]]}],"s":[{},[0,0,2,1]]}],"á":[{"l":[{},[0,0,2,1,2]]}],"e":[{"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1]]},[0,0,0,0,2]],"i":[{"d":[{},[0,0,2,1]],"g":[{"a":[{},[0,0,2,1]]}]}],"o":[{"t":[{"t":[{},[0,1,2]]}]}],"u":[{".":[{},[0,0,2]],"t":[{},[0,0,2]]}],"ü":[{"l":[{},[0,0,2]]}]}],"e":[{"r":[{},[0,0,0,2]]}],"é":[{"r":[{},[0,0,0,2]]}],"f":[{"l":[{},[0,0,1]],"r":[{},[0,0,1,2]]}],"g":[{"a":[{".":[{},[0,0,2]]}]}],"i":[{"d":[{"é":[{},[0,0,0,2]]}]}],"j":[{"t":[{"ó":[{},[2,1]]}]}],"k":[{"a":[{"d":[{},[0,0,2]],"r":[{"ó":[{},[0,0,0,0,2,1]]}]}],"e":[{"m":[{},[0,0,2,1,2]]}],"é":[{"r":[{".":[{},[0,0,2,1]]}]}],"k":[{"u":[{},[2]]}],"l":[{"u":[{},[0,0,1]]}],"ó":[{},[0,0,2,1,2]],"r":[{"é":[{},[0,0,1,2]]}],"t":[{"a":[{".":[{},[2,1]],"l":[{},[0,0,0,2]]}],"e":[{"l":[{},[0,0,0,2,1,2]],"s":[{},[0,0,0,2,1]],"v":[{},[0,0,0,2,1,2]]}],"i":[{},[2,1]],"o":[{"r":[{".":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]]}],"s":[{},[0,0,0,2]]}]}]}],"l":[{"a":[{"g":[{"ú":[{},[0,0,0,0,2,1]]},[2]],"p":[{"í":[{},[0,0,2]]}]}],"á":[{"z":[{"a":[{"d":[{"á":[{},[0,0,0,0,2,1]]},[0,0,0,0,0,0,2]]}]}]}],"é":[{"l":[{},[0,0,2,1,2]]}],"f":[{},[2,1]],"g":[{},[2,1]],"l":[{"e":[{},[2,1]]}],"m":[{"á":[{},[2,1]]}],"u":[{"d":[{},[0,0,0,1]]}]}],"m":[{"a":[{"s":[{"s":[{},[0,0,0,1]]}]}],"u":[{"r":[{},[0,0,2,1]],"t":[{"a":[{},[0,0,0,0,2]]}]}]}],"n":[{"a":[{"d":[{},[0,0,0,0,2]],"g":[{},[0,0,2,1]],"l":[{"a":[{},[0,0,0,1]]},[0,0,2]]}],"á":[{"r":[{},[0,0,2,1,2]],"s":[{"s":[{},[0,0,0,0,0,1]]}]}],"d":[{},[0,0,0,1,2]],"g":[{"g":[{},[0,0,0,0,1]]}],"i":[{"l":[{},[0,0,2,1]]}],"k":[{"r":[{"o":[{},[0,0,0,1]]}]}],"n":[{"y":[{},[0,1]]}],"o":[{"l":[{},[0,0,2]]}],"s":[{"z":[{"t":[{},[0,0,0,1]]},[0,0,0,0,0,2]]},[0,0,0,0,2]],"ü":[{},[0,0,2]],"y":[{"a":[{},[2,1,2]],"u":[{},[0,1,2]]}]}],"p":[{"a":[{"d":[{},[0,0,2,1]],"p":[{"a":[{},[0,0,2,1,2]]}],"r":[{"a":[{},[0,0,0,1]]},[0,0,0,0,2]],"s":[{"z":[{"t":[{},[0,0,2,1]]}]}]}],"á":[{"l":[{"l":[{},[0,0,0,1]]}]}],"i":[{"l":[{},[0,0,2,1]],"n":[{"a":[{".":[{},[0,0,2,1,2]]}]}],"p":[{},[0,0,2,1,2]]}],"o":[{"k":[{"u":[{},[0,0,2,1,2]]}]}],"ö":[{},[0,0,2]],"p":[{},[0,0,0,1,2]],"u":[{"r":[{},[0,0,2,1]],"t":[{},[0,0,2,1,2]]}],"ú":[{},[0,0,2]]}],"r":[{"a":[{".":[{},[2]],"j":[{"e":[{},[0,0,0,0,2]]}],"l":[{"a":[{},[0,0,0,1,2]]}],"n":[{"n":[{},[2]],"y":[{},[2,1,2]]}],"r":[{},[2,0,2,1,2]]}],"á":[{"g":[{"á":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"o":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"h":[{},[2]],"j":[{},[2,1,2]],"l":[{"l":[{},[0,0,0,1]]}],"r":[{},[2]],"v":[{},[2]]}],"b":[{},[2]],"c":[{".":[{},[2,1]],"a":[{},[2,1]],"c":[{},[2,1]],"h":[{},[2,1]],"i":[{},[2]],"o":[{},[2,1]],"t":[{},[2,1]],"u":[{},[2,1]],"ú":[{},[2,1]]}],"e":[{"l":[{},[0,0,2,1]]}],"é":[{"l":[{},[0,0,2,1,2]]}],"i":[{"g":[{},[2]],"l":[{"l":[{},[0,0,2,1]]},[2]],"s":[{"k":[{},[0,0,0,1]]}]}],"k":[{"a":[{"l":[{},[0,0,0,2,1,2]]}],"á":[{},[0,0,0,2,1]],"e":[{"l":[{},[0,0,0,2]]}],"i":[{"n":[{"g":[{},[0,0,0,2,1]]}]}],"o":[{"v":[{},[0,0,0,2]]}],"ó":[{},[0,0,0,2]],"ö":[{"n":[{},[0,0,0,2]],"v":[{},[0,0,0,2,1,2]]}],"ő":[{},[0,0,0,2,1,2]],"ü":[{},[0,0,0,2,1]]}],"o":[{"s":[{".":[{},[2]],"i":[{},[2]],"o":[{},[2]]}]}],"ö":[{},[0,0,2]],"ő":[{},[0,0,2]],"r":[{},[2]],"s":[{},[0,0,0,0,2]],"t":[{"e":[{"m":[{},[0,0,0,2]]}],"o":[{"l":[{},[0,0,0,2,1]]}],"ő":[{},[0,0,0,2,1,2]]}],"ü":[{},[0,0,2,1,2]],"ű":[{},[0,0,2]]}],"s":[{"t":[{},[0,0,0,0,2]],"z":[{"a":[{"l":[{"j":[{},[0,0,0,0,1]],"t":[{},[0,0,0,0,1]]}],"s":[{},[0,0,2]]}]}]}],"t":[{"a":[{"d":[{"a":[{},[0,0,0,1]]}],"k":[{"ö":[{},[0,0,0,0,0,0,2]]}],"l":[{"k":[{},[0,0,2,1]]}],"n":[{"y":[{"a":[{},[0,0,0,1]]}]}],"r":[{"a":[{},[0,0,2,1]]}]}],"á":[{"l":[{"c":[{},[0,0,0,1]]}],"r":[{"k":[{},[0,0,2,1]]}]}],"e":[{"g":[{},[0,0,2,1,2]],"l":[{"l":[{},[0,0,2,1]]}],"s":[{},[0,0,0,0,2]]}],"é":[{"l":[{},[0,0,2]],"r":[{".":[{},[0,0,2,1]],"d":[{},[0,0,2,1]],"e":[{},[0,0,2,1]],"t":[{"e":[{},[0,0,2,1]]}]}]}],"i":[{"d":[{},[0,0,2]],"n":[{"t":[{},[0,0,2,1]]}],"r":[{},[0,0,2]]}],"k":[{"a":[{".":[{},[2,1]]}],"á":[{"n":[{"k":[{},[2,1]]}]}]}],"o":[{"l":[{"d":[{},[0,0,2,1]],"t":[{},[0,0,2,1]]}],"m":[{"b":[{"e":[{},[2]]}]}],"s":[{"z":[{},[0,0,2,1]]}],"t":[{"t":[{"h":[{},[0,0,2,1]]}]}]}],"u":[{"t":[{},[0,0,2,1]]}],"ú":[{"s":[{},[0,0,2]]}],"ü":[{"z":[{},[0,0,2,1]]},[0,0,0,0,2]],"y":[{"a":[{},[2,1,2]],"á":[{},[2,1,2]]}]}],"u":[{"r":[{"a":[{},[0,0,0,2]]},[2]]}],"v":[{"a":[{"t":[{},[0,1,2]]}]}],"w":[{"h":[{},[0,0,1]]}],"x":[{"i":[{},[2,1