(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsLaXLiturgic = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"a":[{"b":[{"æ":[{"q":[{},[0,3,3]]}],"a":[{"l":[{"i":[{},[0,2,1]]}],"u":[{"u":[{},[0,2,1]]}]}],"c":[{},[0,2,3]],"e":[{"o":[{},[0,2,1]],"r":[{},[0,2,1]],"s":[{},[0,4,3]],"u":[{},[0,2,1]],"ú":[{},[0,2,1]]}],"é":[{"r":[{},[0,2,1]],"u":[{},[0,2,1]]}],"f":[{"u":[{},[0,2]]}],"í":[{},[0,2,1]],"i":[{"c":[{},[0,2,1]],"e":[{"c":[{},[0,2,1,2]],"r":[{},[0,2,3]]}],"é":[{"c":[{},[0,2,1,2]],"r":[{},[0,2,3]]}],"g":[{},[0,2,1]],"i":[{},[0,2,1,2]],"í":[{},[0,2,1,2]],"n":[{},[0,2,1,0,1]],"r":[{},[0,2,1]],"t":[{},[0,2,1]],"u":[{},[0,2,1,4]],"ú":[{},[0,2,1,4]],"v":[{},[0,2,1]]}],"j":[{},[0,2]],"l":[{},[0,2,3]],"o":[{"l":[{},[0,2,1]],"m":[{},[0,2,1]],"r":[{"t":[{},[0,2,1]]},[0,2,1]]}],"ó":[{"l":[{},[0,2,1]],"r":[{},[0,2,1]]}],"r":[{"a":[{"h":[{},[0,3,4]]}],"u":[{},[0,2,3]]},[0,2,3]],"s":[{"c":[{"e":[{},[0,0,5,4]],"é":[{},[0,0,5,4]],"i":[{"s":[{},[0,0,5,4]],"n":[{},[0,0,5,4]]},[0,0,5,4]],"í":[{"n":[{},[0,0,5,4]]},[0,0,5,4]]},[0,0,4,3]],"e":[{"n":[{},[0,0,3,2]]}],"é":[{"n":[{},[0,0,3,2]]}],"i":[{"d":[{},[0,0,5,4,3]],"l":[{},[0,0,5,0,3]],"m":[{},[0,0,5,0,3]]},[0,0,3,0,2]],"o":[{"n":[{},[0,0,5,4]]},[0,0,3]],"ó":[{"n":[{},[0,0,5,4]]},[0,0,3]],"t":[{"e":[{"m":[{},[0,0,4,3]],"n":[{},[0,0,3,2]],"r":[{},[0,0,4,3]]}],"é":[{"m":[{},[0,0,4,3]],"r":[{},[0,0,4,3]]}],"i":[{"n":[{},[0,0,4,3]]}],"í":[{"n":[{},[0,0,4,3]]}],"r":[{},[0,0,4,3]],"u":[{},[0,0,4,3]],"ú":[{},[0,0,4,3]]}],"u":[{"m":[{},[0,0,5,0,3]]},[0,0,3,0,2]]}],"u":[{"n":[{"d":[{},[0,2,3]]}],"s":[{},[0,2,3]],"t":[{},[0,2,3]]}],"ú":[{"n":[{"d":[{},[0,2,3]]}],"t":[{},[0,2,3]]}]}],"d":[{"æ":[{"q":[{},[0,4,5]]},[0,3,4]],"a":[{"m":[{".":[{},[0,3,4]]}],"s":[{"c":[{"r":[{},[0,2,3,3,4]]}]}]}],"e":[{"p":[{"s":[{},[0,3,4]]}],"r":[{},[0,0,0,0,2]]}],"f":[{"u":[{},[0,2]]}],"i":[{"a":[{"b":[{},[0,3,4,3]]},[0,0,0,2]],"á":[{"b":[{},[0,3,4,3]]},[0,0,0,2]],"e":[{"u":[{},[0,0,0,3]]},[0,0,0,2]],"é":[{},[0,0,0,2]],"i":[{},[0,0,3,2]],"í":[{},[0,0,3,2]],"o":[{},[0,0,0,2]],"p":[{"i":[{"s":[{"c":[{},[0,4,5]]}]}],"í":[{"s":[{"c":[{},[0,4,5]]}]}]},[0,3,4]],"s":[{".":[{},[0,0,5]]}],"t":[{".":[{},[0,0,5]]}],"u":[{},[0,0,3,2]],"ú":[{},[0,0,3,2]]}],"í":[{"p":[{},[0,3,4]]}],"o":[{"l":[{"e":[{},[0,4,3]]}],"n":[{},[0,3,4]]}],"ó":[{"n":[{},[0,3,4]]}],"r":[{"a":[{"n":[{},[0,3,4]]}],"á":[{"n":[{},[0,3,4]]}]}],"s":[{"c":[{"r":[{},[0,0,3,2]]}],"i":[{},[0,0,3]],"t":[{},[0,2,5,2]],"u":[{"e":[{},[0,0,0,0,3]]}]}],"u":[{"a":[{},[0,3,4,3]],"á":[{},[0,3,4,3]],"l":[{},[0,4,5]],"r":[{"n":[{},[0,3,4]]}]}],"y":[{},[0,3,4]],"ý":[{},[0,3,4]]},[0,2,3]],"l":[{"t":[{"e":[{"r":[{"c":[{},[0,0,0,0,4]],"n":[{},[0,0,0,0,4]],"p":[{},[0,0,0,0,4]],"t":[{},[0,0,0,0,4]],"u":[{"t":[{},[0,0,0,0,4,3]]}],"ú":[{"t":[{},[0,0,0,0,4,3]]}]},[0,0,0,0,3]]}],"é":[{"r":[{"c":[{},[0,0,0,0,4]],"n":[{},[0,0,0,0,4]],"p":[{},[0,0,0,0,4]],"u":[{"t":[{},[0,0,0,0,4,3]]}]},[0,0,0,0,3]]}]}]}],"n":[{"i":[{"m":[{"a":[{"d":[{},[0,0,0,2,3]]}]}]}],"t":[{"i":[{"m":[{"n":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,1]]}]}],"p":[{"e":[{"r":[{"u":[{},[0,0,0,3,2]]}]}]}],"r":[{"c":[{"h":[{"i":[{"e":[{},[0,0,0,0,0,3]]}]}]}]}],"s":[{"c":[{},[0,3,2]],"p":[{"i":[{"d":[{},[0,4,3]]}],"e":[{"r":[{"g":[{},[0,5,4]],"n":[{},[0,5,4]]},[0,4,3]]}]},[0,3,2]],"t":[{"e":[{"r":[{"n":[{},[0,5,4]]}]}],"i":[{"p":[{},[0,5,4]]}],"r":[{},[0,5,4]],"u":[{},[0,5,4]],"ú":[{},[0,5,4]]},[0,5,2]]}]}],"á":[{"b":[{"e":[{"o":[{},[0,2,1]]}],"i":[{"g":[{},[0,2,3]],"i":[{},[0,2,1,2]],"t":[{},[0,2,1]]}],"l":[{"u":[{},[0,2,3]]}],"r":[{"a":[{"h":[{},[0,3,4]]}]},[0,2,3]],"s":[{"c":[{},[0,0,4,3]],"i":[{"d":[{},[0,0,5,4,3]]}],"o":[{"n":[{},[0,0,5,4]]}],"t":[{"i":[{"n":[{},[0,0,4,3]]}],"r":[{},[0,0,4,3]]}]}]}],"d":[{"i":[{"a":[{},[0,0,0,2]],"o":[{},[0,0,0,2]],"p":[{},[0,3,4]],"u":[{},[0,0,0,2]]}],"r":[{"a":[{"n":[{},[0,3,4]]}]}],"s":[{"t":[{"r":[{},[0,2,5,2]]}]}],"y":[{},[0,3,4]]},[0,2,3]],"l":[{"t":[{"e":[{"r":[{},[0,0,0,0,3]]}]}]}],"s":[{"c":[{},[0,3,2]],"p":[{"i":[{"d":[{},[0,4,3]]}],"e":[{"r":[{},[0,4,3]]}]},[0,3,2]]}]}],"b":[{"e":[{"n":[{"i":[{"a":[{},[0,0,0,0,4]]}]}],"t":[{"h":[{"l":[{},[0,0,4,0,5]]}]}]}],"é":[{"n":[{"i":[{"a":[{},[0,0,0,0,4]]}]}],"t":[{"h":[{"l":[{},[0,0,4,0,5]]}]}]}]},[0,2]],"c":[{"e":[{"u":[{".":[{},[0,0,4]]}]}],"i":[{"r":[{"c":[{"u":[{"m":[{"i":[{"a":[{},[0,0,0,0,0,0,0,2]],"á":[{},[0,0,0,0,0,0,0,2]],"e":[{},[0,0,0,0,0,0,0,2]],"i":[{},[0,0,0,0,0,0,0,2]],"í":[{},[0,0,0,0,0,0,0,2]],"n":[{"i":[{"i":[{},[0,0,0,0,0,0,0,2,3,4]]}]}],"o":[{},[0,0,0,0,0,0,0,2]],"u":[{},[0,0,0,0,0,0,0,2]]}],"s":[{},[0,0,0,0,0,0,5,4]]},[0,0,0,0,0,4,1]]}],"ú":[{"m":[{"s":[{},[0,0,0,0,0,4,5,4]]},[0,0,0,0,0,4,1]]}]}]}],"s":[{},[0,0,2,3]]}],"o":[{"e":[{"l":[{"e":[{"c":[{},[0,0,3,2]]}],"i":[{"g":[{},[0,0,3,2]]}]}],"m":[{"e":[{"n":[{},[0,0,3]]}]}],"n":[{},[0,0,2,1]],"r":[{},[0,0,3,2]],"x":[{"s":[{},[0,0,0,0,3,2]]},[0,0,3,2,3]]},[0,0,1]],"g":[{"n":[{"o":[{"s":[{},[0,0,3,2]]}],"ó":[{"s":[{},[0,0,3,2]]}]}]}],"i":[{"e":[{},[0,0,1,2]],"u":[{},[0,0,0,3]]},[0,0,1]],"m":[{"e":[{"d":[{},[0,0,2,3]],"s":[{".":[{},[0,0,2,3]]}]}],"é":[{"d":[{},[0,0,2,3]]}],"i":[{"t":[{},[0,0,2,3]]}],"í":[{"t":[{},[0,0,2,3]]}]}],"n":[{"a":[{},[0,0,3,2]],"á":[{},[0,0,3,2]],"e":[{},[0,0,3,2]],"é":[{},[0,0,3,2]],"i":[{"a":[{},[0,0,0,0,2]],"c":[{},[0,0,0,3]],"e":[{"c":[{},[0,0,6,5,4]]},[0,0,0,0,2]],"é":[{"c":[{},[0,0,6,5,4]]}],"i":[{},[0,0,6,3,4]],"í":[{},[0,0,6,3,4]],"u":[{},[0,0,4,3,2]],"ú":[{},[0,0,4,3,2]]},[0,0,3,2]],"í":[{},[0,0,3,2]],"o":[{},[0,0,3,2]],"ó":[{},[0,0,3,2]],"s":[{"c":[{"r":[{},[0,0,0,3,2]]}],"p":[{},[0,0,0,3,2,2]],"t":[{},[0,0,0,5,4]]}],"u":[{},[0,0,3,2]],"ú":[{},[0,0,3,2]]},[0,0,2,1]]}],"ó":[{"m":[{"e":[{"d":[{},[0,0,2,3]]}],"i":[{"t":[{},[0,0,2,3]]}]}],"n":[{"i":[{"u":[{},[0,0,4,3,2]]}],"s":[{"c":[{"r":[{},[0,0,0,3,2]]}],"p":[{},[0,0,0,3,2,2]],"t":[{},[0,0,0,5,4]]}]},[0,0,2,1]]}],"u":[{"m":[{"s":[{"c":[{"r":[{},[0,0,4,5,4]]}]}]}],"s":[{"p":[{},[0,0,4]]}]}]},[0,2]],"d":[{"e":[{"í":[{"n":[{},[0,0,1]]},[0,0,1]],"i":[{"n":[{},[0,0,1]],"t":[{},[0,0,1]]}],"p":[{"e":[{"r":[{},[0,0,0,0,4,5]]}],"é":[{"r":[{},[0,0,0,0,4,5]]}]}],"s":[{"c":[{},[0,0,3,2]],"p":[{},[0,0,3,2]],"q":[{},[0,0,3,2]],"t":[{"i":[{"t":[{},[0,0,5,2]],"l":[{},[0,0,5,2]]}],"í":[{"t":[{},[0,0,5,2]],"l":[{},[0,0,5,2]]}],"r":[{"u":[{},[0,0,5,2]],"ú":[{},[0,0,5,2]]}]}]}],"u":[{"t":[{"e":[{"r":[{},[0,0,4]]}]}]}]}],"é":[{"i":[{},[0,0,1]],"s":[{"p":[{},[0,0,3,2]],"t":[{"r":[{"u":[{},[0,0,5,2]]}]}]}]}],"i":[{"g":[{"n":[{"o":[{"s":[{"c":[{},[0,0,3,2]]}]}]}]}],"i":[{"u":[{},[0,0,3,4]],"ú":[{},[0,0,3,4]]}],"œ":[{},[0,0,3]],"r":[{"i":[{"m":[{},[0,0,2,1]]}],"í":[{"m":[{},[0,0,2,1]]}]}],"s":[{"c":[{"e":[{"d":[{},[0,0,5,4]],"n":[{},[0,0,5,4]],"p":[{},[0,0,5,4]],"r":[{},[0,0,5,4]],"s":[{},[0,0,5,4]]}],"é":[{"d":[{},[0,0,5,4]],"n":[{},[0,0,5,4]],"p":[{},[0,0,5,4]],"r":[{},[0,0,5,4]],"s":[{},[0,0,5,4]]}],"i":[{"d":[{},[0,0,5,4]],"n":[{},[0,0,5,4]],"p":[{},[0,0,5,4]],"s":[{"s":[{},[0,0,5,4]]}],"t":[{},[0,0,5,4]]}],"í":[{"d":[{},[0,0,5,4]],"n":[{},[0,0,5,4]],"p":[{},[0,0,5,4]],"s":[{"s":[{},[0,0,5,4]]}]}],"r":[{"e":[{},[0,0,6,5]],"é":[{},[0,0,6,5]],"i":[{"m":[{},[0,0,6,5]]}],"í":[{"m":[{},[0,0,6,5]]}],"u":[{"c":[{},[0,0,6,5]]},[0,0,6,5]],"ú":[{"c":[{},[0,0,6,5]]}]},[0,0,5,4]]}],"e":[{"r":[{"t":[{},[0,0,5,4]]}]}],"é":[{"r":[{"t":[{},[0,0,5,4]]}]}],"i":[{"c":[{},[0,0,0,0,3]]},[0,0,2,1,2]],"í":[{"c":[{},[0,0,0,0,3]]},[0,0,2,1,2]],"j":[{},[0,0,2]],"p":[{"e":[{"n":[{},[0,0,6,5]],"r":[{"e":[{},[0,0,0,0,0,4,5]],"i":[{},[0,0,0,0,0,4,5]],"s":[{},[0,0,7,6]],"g":[{},[0,0,7,6]]},[0,0,6,5]]},[0,0,5,4]],"é":[{"n":[{},[0,0,6,5]],"r":[{"e":[{},[0,0,0,0,0,4,5]],"i":[{},[0,0,0,0,0,4,5]],"s":[{},[0,0,7,6]],"g":[{},[0,0,7,6]]},[0,0,6,5]]},[0,0,5,4]],"i":[{},[0,0,5,4]],"í":[{},[0,0,5,4]]}],"t":[{"a":[{},[0,0,5,4]],"á":[{},[0,0,5,4]],"i":[{"n":[{"e":[{},[0,0,6,5]]},[0,0,5,4]],"r":[{},[0,0,5,4]]}],"í":[{"n":[{"e":[{},[0,0,6,5]]},[0,0,5,4]],"r":[{},[0,0,5,4]]}],"o":[{".":[{},[0,0,5,4]]}],"r":[{"i":[{"c":[{},[0,0,5,4]],"n":[{},[0,0,5,4]]}],"í":[{"c":[{},[0,0,5,4]],"n":[{},[0,0,5,4]]}]}]}]},[0,0,4,3]],"u":[{},[0,0,3]],"ú":[{},[0,0,3]]}],"í":[{"s":[{"c":[{"i":[{"t":[{},[0,0,5,4]]}]}]},[0,0,4,3]]}]}],"e":[{"l":[{"e":[{"u":[{"t":[{"h":[{},[0,0,0,2]]}]}]}],"é":[{"u":[{"t":[{"h":[{},[0,0,0,2]]}]}]}]}],"t":[{"e":[{"n":[{},[0,2,3]]}],"i":[{"a":[{"m":[{},[0,2,3,3]]}],"á":[{"m":[{},[0,2,3,3]]}]}]}],"u":[{"m":[{},[0,5]],"n":[{"u":[{},[0,6]]},[0,5]],"s":[{".":[{},[0,5]]}]},[0,4]],"ú":[{"m":[{},[0,5]],"n":[{"u":[{},[0,6]]},[0,5]]},[0,4]],"x":[{"e":[{"d":[{},[0,3,4]],"g":[{"e":[{"t":[{},[0,3,4]]}],"é":[{"t":[{},[0,3,4]]}]}]}],"é":[{"d":[{},[0,3,4]]}],"o":[{"d":[{},[0,3,4]],"r":[{"c":[{},[0,3,4]]}]}],"ó":[{"d":[{},[0,3,4]]}],"s":[{"c":[{},[0,0,5,4]],"p":[{},[0,0,0,2]],"t":[{},[0,0,5,2]]}]},[0,2,3]]}],"é":[{"t":[{"e":[{"n":[{},[0,2,3]]}],"i":[{"a":[{"m":[{},[0,2,3,3]]}]}]}],"u":[{},[0,4]],"x":[{"e":[{"d":[{},[0,3,4]]}],"o":[{"d":[{},[0,3,4]]}],"s":[{"c":[{},[0,0,5,4]],"p":[{},[0,0,0,2]],"t":[{},[0,0,5,2]]}]},[0,2,3]]}],"f":[{},[0,2]],"g":[{},[0,2]],"h":[{"a":[{"r":[{"u":[{"s":[{"p":[{},[0,0,0,0,3,4]]}]}],"ú":[{"s":[{"p":[{},[0,0,0,0,3,4]]}]}]}]}],"e":[{"i":[{".":[{},[0,0,3]]}],"u":[{".":[{},[0,0,3]]}]}],"i":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]]}],"u":[{"c":[{"u":[{"s":[{},[0,0,0,0,4]]}]}],"i":[{"u":[{},[0,0,1,2]],"ú":[{},[0,0,1,2]]}]}]},[0,2]],"i":[{"a":[{"i":[{"u":[{},[0,0,0,2]]}]},[0,4]],"á":[{},[0,4]],"b":[{"i":[{},[0,3]],"í":[{},[0,3]],"o":[{},[0,3]],"ó":[{},[0,3]],"u":[{},[0,3]],"ú":[{},[0,3]]}],"c":[{"o":[{},[0,3]],"ó":[{},[0,3]]}],"d":[{"c":[{"i":[{},[0,2]]}],"e":[{"m":[{},[0,4,3]],"n":[{},[0,5]],"o":[{".":[{},[0,4,3]],"q":[{},[0,4,3]]}],"ó":[{"q":[{},[0,4,3]]}],"s":[{},[0,4,3]]},[0,3,2]],"é":[{},[0,3,2]],"i":[{"b":[{},[0,3,2]],"o":[{"g":[{},[0,3,0,2]]}]}],"o":[{"l":[{},[0,3,2]],"n":[{},[0,3,2]]}],"ó":[{"l":[{},[0,3,2]],"n":[{},[0,3,2]]}],"u":[{"s":[{},[0,3,2]]}]},[0,2,1]],"e":[{"i":[{"u":[{},[0,0,0,2]]}]},[0,2]],"é":[{},[0,2]],"i":[{},[0,3]],"í":[{},[0,3]],"n":[{"a":[{"b":[{"r":[{},[0,0,0,2,3]],"s":[{},[0,0,0,0,3,2]]}],"c":[{"r":[{},[0,0,0,2]]}],"d":[{"f":[{},[0,0,0,2]]}],"n":[{},[0,3,2]]}],"á":[{"n":[{},[0,3,2]]}],"c":[{"i":[{"r":[{"c":[{"u":[{"m":[{},[0,0,0,0,0,0,0,4]]}]}]}]}]}],"d":[{"e":[{"p":[{},[0,0,4,3]]}],"é":[{"p":[{},[0,0,4,3]]}],"i":[{"g":[{"n":[{},[0,0,5,4]]},[0,0,4,3]],"p":[{"i":[{"s":[{},[0,0,4,3]]}],"í":[{"s":[{},[0,0,4,3]]}]}],"s":[{},[0,0,5,4]]}],"í":[{"g":[{"n":[{},[0,0,5,4]]}]}],"u":[{"c":[{},[0,0,5,4]],"l":[{},[0,0,5,4]],"m":[{},[0,0,5,4]],"s":[{},[0,0,5,4]],"x":[{},[0,0,5,4]]},[0,0,4,3]],"ú":[{"c":[{},[0,0,5,4]],"l":[{},[0,0,5,4]],"m":[{},[0,0,5,4]],"s":[{},[0,0,5,4]],"x":[{},[0,0,5,4]]},[0,0,4,3]]}],"e":[{"r":[{"s":[{},[0,3,2]],"t":[{},[0,3,2]]}],"x":[{"s":[{"t":[{},[0,0,0,0,0,2]]}]},[0,0,0,2,3]]}],"f":[{"r":[{"a":[{"s":[{},[0,0,0,0,0,3,4]]}]}]}],"i":[{"e":[{},[0,0,0,2]],"é":[{},[0,0,0,2]],"í":[{},[0,0,0,2]],"t":[{},[0,3,2]],"u":[{},[0,0,0,2]],"ú":[{},[0,0,0,2]]}],"o":[{"b":[{"o":[{"e":[{},[0,0,0,3,2]]}],"œ":[{},[0,0,0,2,3]],"s":[{"c":[{},[0,0,0,0,3,2]]}]},[0,0,0,2,3]]}],"p":[{"e":[{"r":[{"i":[{"u":[{"r":[{},[0,0,0,0,2,3]]}]}]}]}]}],"s":[{"c":[{"r":[{},[0,0,3,4]]}],"p":[{},[0,0,3,2]],"t":[{},[0,0,5,2]]}],"t":[{"e":[{"r":[{"e":[{"m":[{},[0,0,0,0,3,4]],"n":[{},[0,0,0,0,3,4]],"r":[{},[0,0,0,0,3,4]],"s":[{"s":[{},[0,0,0,0,4,5]]},[0,0,0,0,3,4]],"t":[{},[0,0,0,0,3,4]]},[0,0,0,0,2,3]],"é":[{"m":[{},[0,0,0,0,3,4]],"n":[{},[0,0,0,0,3,4]],"r":[{},[0,0,0,0,3,4]],"t":[{},[0,0,0,0,3,4]]},[0,0,0,0,2,3]],"i":[{"a":[{},[0,0,0,0,0,0,2]],"á":[{},[0,0,0,0,0,0,2]],"e":[{},[0,0,0,0,0,0,2]],"é":[{},[0,0,0,0,0,0,2]],"i":[{},[0,0,0,0,0,0,2]],"í":[{},[0,0,0,0,0,0,2]],"o":[{"r":[{},[0,0,0,0,3,4,3]]}],"ó":[{"r":[{},[0,0,0,0,3,4,3]]}],"u":[{"s":[{".":[{},[0,0,0,0,3,4]]}]},[0,0,0,0,0,0,2]],"ú":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,2,3]],"í":[{"e":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,2,3]],"s":[{"p":[{"e":[{},[0,0,0,0,2,3,4]],"é":[{},[0,0,0,0,2,3,4]]}]}]}]}],"é":[{"r":[{"e":[{"r":[{},[0,0,0,0,3,4]]},[0,0,0,0,2,3]],"i":[{"o":[{"r":[{},[0,0,0,0,3,4,3]]}],"u":[{"s":[{".":[{},[0,0,0,0,3,4]]}]}]},[0,0,0,0,2,3]]}]}],"r":[{"o":[{"i":[{"e":[{},[0,0,0,0,0,3,3]],"é":[{},[0,0,0,0,0,3,3]]}],"s":[{"p":[{},[0,0,0,0,0,3,4]]}]}]}]}],"u":[{"a":[{},[0,0,0,2]],"e":[{},[0,0,0,2]],"i":[{},[0,0,0,2]],"l":[{"c":[{},[0,4,3]]},[0,3,2]],"o":[{},[0,0,0,2]],"u":[{},[0,0,0,2]]}]},[0,4,3]],"o":[{},[0,2]],"ó":[{},[0,2]],"u":[{"s":[{"i":[{"u":[{"r":[{},[0,0,2,3,2]]}]}]}]},[0,4]],"ú":[{},[0,4]]}],"í":[{"d":[{"e":[{"o":[{".":[{},[0,4,3]]}]},[0,3,2]]}],"i":[{},[0,3]],"n":[{"d":[{"i":[{"g":[{},[0,0,4,3]]}],"u":[{},[0,0,4,3]]}],"s":[{"t":[{},[0,0,5,2]]}],"t":[{"e":[{"r":[{"i":[{},[0,0,0,0,2,3]]}]}]}]},[0,4,3]]}],"j":[{},[0,2]],"l":[{"a":[{"u":[{},[0,0,4]]}],"e":[{"c":[{"t":[{"i":[{"s":[{"t":[{},[0,0,0,0,0,5,4]]}]}]}]}]}],"o":[{"n":[{"g":[{"a":[{"n":[{},[0,0,0,2,1]]}],"á":[{"n":[{},[0,0,0,2,1]]}]}]}]}],"u":[{"x":[{"q":[{},[0,0,4,3]],"u":[{},[0,0,3,2]],"ú":[{},[0,0,3,2]]}]}]},[0,2]],"m":[{"a":[{"i":[{"u":[{},[0,0,0,4]]}]}]},[0,2]],"n":[{"e":[{"c":[{"o":[{"p":[{},[0,0,2,1]]}],"ó":[{"p":[{},[0,0,2,1]]}]}],"g":[{"o":[{"t":[{},[0,0,2,1]]}],"ó":[{"t":[{},[0,0,2,1]]}]}],"u":[{".":[{},[0,0,2]],"t":[{},[0,0,2]]}]}],"é":[{"u":[{"t":[{},[0,0,2]]}]}]},[0,2]],"o":[{"b":[{"e":[{"d":[{},[0,3,2]],"l":[{},[0,3,2]],"s":[{},[0,3,2]]}],"é":[{"d":[{},[0,3,2]]}],"i":[{"a":[{},[0,0,0,2]],"c":[{"i":[{},[0,4,3]]},[0,3,2]],"e":[{"r":[{},[0,0,0,3]]},[0,0,0,2]],"é":[{},[0,0,0,2]],"g":[{},[0,3,2]],"i":[{},[0,0,3,4]],"í":[{},[0,0,3,4]],"u":[{},[0,0,3,2]],"ú":[{},[0,0,3,2]]}],"l":[{},[0,0,3]],"œ":[{},[0,4,3]],"r":[{"u":[{"z":[{},[0,3,4]]}]},[0,0,3]],"s":[{"c":[{"u":[{},[0,0,3,2]]},[0,0,3,2]],"t":[{},[0,0,5,2]]}],"t":[{"r":[{},[0,0,3]]}],"u":[{"a":[{},[0,0,0,2]],"e":[{},[0,0,0,2]],"i":[{},[0,0,0,2]],"o":[{},[0,0,0,2]]}]},[0,2,1]]}],"ó":[{"b":[{"l":[{},[0,0,3]],"r":[{"u":[{},[0,0,3]]},[0,0,3]],"s":[{"t":[{},[0,0,5,2]]}]},[0,2,1]]}],"p":[{"æ":[{"n":[{"i":[{"n":[{"s":[{},[0,0,2,3]]}]}],"í":[{"n":[{"s":[{},[0,0,2,3]]}]}]}]}],"a":[{"r":[{"a":[{"i":[{},[0,0,0,0,1]],"u":[{},[0,0,0,0,1]]}]}]}],"e":[{"i":[{"o":[{"r":[{},[0,0,1,6]]}],"ó":[{"r":[{},[0,0,1,6]]}]}],"r":[{"a":[{"b":[{"s":[{"u":[{},[0,0,2,1]]}]}],"c":[{},[0,0,2,1]],"d":[{"p":[{},[0,0,2,1,2]],"u":[{},[0,0,2,1,2,1]]}],"e":[{},[0,0,2,1]],"g":[{},[0,0,2,3]],"m":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1]],"b":[{},[0,0,2,1]]}],"n":[{"t":[{},[0,0,4,3]]}],"r":[{},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}],"á":[{"c":[{},[0,0,2,1]],"g":[{},[0,0,2,3]],"m":[{"b":[{},[0,0,2,1]]}],"r":[{},[0,0,2,1]]}],"c":[{"o":[{"q":[{},[0,0,2,1]]}],"u":[{},[0,0,2,1]]}],"e":[{"a":[{"s":[{},[0,0,2,3]]},[0,0,2,3]],"á":[{"m":[{},[0,0,2,3]],"t":[{},[0,0,2,3]]}],"c":[{},[0,0,4,3]],"d":[{},[0,0,4,1]],"f":[{"f":[{},[0,0,2,1]]}],"g":[{"r":[{},[0,0,6,3]]}],"l":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"n":[{"d":[{},[0,0,4,5]],"n":[{},[0,0,4,3]]}],"o":[{},[0,0,2,3]],"r":[{"r":[{},[0,0,4,3]],"u":[{},[0,0,2,1]]}],"s":[{".":[{},[0,0,2,3]]}],"u":[{},[0,0,2,3]],"ú":[{},[0,0,2,3]],"x":[{},[0,0,4,1,2,3]]}],"é":[{"g":[{},[0,0,2,3]],"m":[{},[0,0,2,1]],"n":[{"d":[{},[0,0,4,5]],"n":[{},[0,0,4,3]]}],"r":[{"r":[{},[0,0,4,3]]}]}],"h":[{},[0,0,2,3]],"i":[{"a":[{"c":[{},[0,0,2,1,2]],"n":[{},[0,0,3,4]]},[0,0,3,4]],"á":[{},[0,0,3,4]],"b":[{},[0,0,2,3]],"c":[{"l":[{},[0,0,3,4]],"u":[{},[0,0,3,4]]}],"e":[{"b":[{},[0,0,3,4]],"m":[{},[0,0,3,4]],"n":[{"s":[{},[0,0,4,5]]},[0,0,3,4]],"r":[{"a":[{"t":[{},[0,0,5,6]]},[0,0,4,5]]},[0,0,3,4]],"i":[{},[0,0,0,0,0,3]],"t":[{},[0,0,3,4]],"c":[{},[0,0,2,1,2]]},[0,0,2,3]],"é":[{"b":[{},[0,0,3,4]],"m":[{},[0,0,3,4]],"n":[{},[0,0,3,4]],"r":[{},[0,0,3,4]],"t":[{},[0,0,3,4]],"i":[{},[0,0,0,0,0,3]]},[0,0,2,3]],"i":[{"t":[{},[0,0,0,5]]}],"m":[{"i":[{},[0,0,5,4]],"u":[{"s":[{},[0,0,6,5]]},[0,0,5,4]]},[0,0,4,3]],"n":[{"t":[{},[0,0,3,4]]},[0,0,2,3]],"o":[{"d":[{},[0,0,3,4]]},[0,0,3,4]],"ó":[{"d":[{},[0,0,3,4]]}],"p":[{"s":[{},[0,0,0,0,3,2]],"t":[{},[0,0,0,0,3,2]]}],"r":[{"e":[{"m":[{"u":[{"r":[{},[0,0,3,4]]}],"i":[{},[0,0,3,4]]}],"n":[{"t":[{"u":[{"r":[{},[0,0,3,4]]}]}]}],"r":[{},[0,0,3,4]],"t":[{".":[{},[0,0,4,5]],"i":[{"s":[{},[0,0,4,5]]}]},[0,0,3,4]]}],"é":[{"m":[{"u":[{"r":[{},[0,0,3,4]]}],"i":[{},[0,0,3,4]]}],"n":[{"t":[{"u":[{"r":[{},[0,0,3,4]]}]}]}],"r":[{},[0,0,3,4]],"t":[{"i":[{"s":[{},[0,0,4,5]]}]},[0,0,3,4]]}],"i":[{},[0,0,3,4]]},[0,0,2,3]],"s":[{"c":[{},[0,0,3,4,3,2]],"t":[{},[0,0,0,0,3,2]]}],"t":[{"ú":[{"r":[{},[0,0,4,5]]}],"u":[{"r":[{},[0,0,4,5]]}],".":[{},[0,0,4,5]],"o":[{"t":[{"e":[{},[0,0,4,5]]}]}],"ó":[{"t":[{"e":[{},[0,0,4,5]]}]}]},[0,0,3,4]],"u":[{"n":[{},[0,0,3,4,5]]},[0,0,2,3,4]],"ú":[{"n":[{},[0,0,3,4,5]]},[0,0,2,3,4]]},[0,0,2,3,1]],"í":[{"b":[{},[0,0,2,3]],"c":[{"l":[{},[0,0,3,4]],"u":[{},[0,0,3,4]]}],"e":[{"r":[{"a":[{"t":[{},[0,0,5,6]]},[0,0,4,5]]},[0,0,3,4]],"i":[{},[0,0,0,0,0,3]]},[0,0,2,3]],"m":[{"i":[{},[0,0,5,4]],"u":[{"s":[{},[0,0,6,5]]},[0,0,5,4]]},[0,0,4,3]],"n":[{"t":[{},[0,0,3,4]]},[0,0,2,3]],"r":[{"e":[{"r":[{},[0,0,3,4]]}],"i":[{},[0,0,3,4]]},[0,0,2,3]],"s":[{"c":[{},[0,0,3,4,3,2]]}],"t":[{"u":[{"r":[{},[0,0,4,5]]}]},[0,0,3,4]]},[0,0,2,3,1]],"j":[{},[0,0,4,3]],"o":[{"b":[{"s":[{"c":[{},[0,0,2,1,2,3,2]]}]}],"d":[{},[0,0,2,1]],"f":[{},[0,0,2,1]],"l":[{},[0,0,2,1]],"p":[{},[0,0,2,1]],"r":[{},[0,0,4,3]]}],"ó":[{"r":[{},[0,0,4,3]]}],"r":[{"e":[{"g":[{},[0,0,2,3]]}]}],"s":[{"c":[{},[0,0,2,3,2]],"p":[{},[0,0,2,3,2]],"t":[{},[0,0,2,7,2]]}],"t":[{"r":[{"a":[{"n":[{"s":[{},[0,0,2,3,0,0,0,2,1]]}]}],"á":[{"n":[{"s":[{},[0,0,2,3,0,0,0,2,1]]}]}]}]}],"u":[{"a":[{},[0,0,2,1,2]],"e":[{},[0,0,2,1,2]],"i":[{},[0,0,2,1,2]],"l":[{},[0,0,3,4]],"o":[{},[0,0,2,1,2]]},[0,0,2,3]],"ú":[{"l":[{},[0,0,3,4]]},[0,0,2,3]]}]}],"é":[{"r":[{"a":[{"g":[{},[0,0,2,3]]}],"e":[{"a":[{"m":[{},[0,0,2,3]],"n":[{"t":[{},[0,0,2,3]]}],"t":[{},[0,0,2,3]],"s":[{},[0,0,2,3]]}],"g":[{"r":[{},[0,0,6,3]]}],"o":[{},[0,0,2,3]],"u":[{},[0,0,2,3]]}],"h":[{},[0,0,2,3]],"i":[{"e":[{"n":[{"s":[{},[0,0,4,5]]}],"r":[{"a":[{"t":[{},[0,0,5,6]]},[0,0,4,5]]}]}],"i":[{"t":[{},[0,0,0,5]]},[0,0,2,3]],"m":[{},[0,0,4,3]]}],"j":[{},[0,0,4,3]],"s":[{"t":[{},[0,0,2,7,2]]}]}]}],"n":[{"e":[{"u":[{},[0,0,0,4]]}]}],"o":[{"e":[{"t":[{},[0,0,3]]}],"s":[{"t":[{"e":[{"a":[{},[0,0,0,4,3]],"á":[{},[0,0,0,4,3]],"r":[{},[0,0,0,4,3]]}],"é":[{"r":[{},[0,0,0,4,3]]}],"h":[{"a":[{"c":[{},[0,0,4,4,3]]}]},[0,0,0,4,3]],"i":[{"l":[{},[0,0,0,4,3]]}],"í":[{"l":[{},[0,0,0,4,3]]}]}],"u":[{"í":[{},[0,0,0,0,3]]}]}],"t":[{"e":[{},[0,0,2,3]],"é":[{},[0,0,2,3]],"u":[{"e":[{},[0,0,4,3]],"i":[{},[0,0,4,3]],"é":[{},[0,0,4,3]],"í":[{},[0,0,4,3]]}],"ú":[{"e":[{},[0,0,4,3]],"i":[{},[0,0,4,3]]}]}]}],"ó":[{"s":[{"t":[{"e":[{"a":[{},[0,0,0,4,3]],"r":[{},[0,0,0,4,3]]}]}],"u":[{"i":[{},[0,0,0,0,3]]}]}],"t":[{"e":[{},[0,0,2,3]],"u":[{"i":[{},[0,0,4,3]]}]}]}],"r":[{"æ":[{"a":[{"u":[{},[0,0,0,3,2]]}],"e":[{"s":[{},[0,0,0,3]]}],"i":[{"a":[{},[0,0,0,0,4]],"á":[{},[0,0,0,0,4]],"e":[{"c":[{},[0,0,0,0,4]]}],"o":[{},[0,0,0,0,4]],"i":[{},[0,0,0,0,4]],"í":[{},[0,0,0,0,4]],"u":[{},[0,0,0,0,4]],"ú":[{},[0,0,0,0,4]]}],"s":[{"c":[{},[0,0,0,3,2]],"p":[{},[0,0,0,3,2]],"t":[{},[0,0,0,5,2]]}],"t":[{"e":[{"r":[{},[0,0,0,0,0,2,1]]}],"é":[{"r":[{},[0,0,0,0,0,2,1]]}]}]},[0,0,0,1]],"i":[{"m":[{"i":[{"s":[{"c":[{},[0,0,0,0,0,3,2]]}]},[0,0,0,0,0,1]]}]}],"o":[{"d":[{"e":[{"a":[{"m":[{"b":[{},[0,0,0,1,0,1]]}]},[0,0,0,2,1]],"o":[{},[0,0,0,2,1]],"s":[{"s":[{},[0,0,0,2,1,0,3]]}],"u":[{"n":[{},[0,0,0,2,1]]}]}],"é":[{"s":[{"s":[{},[0,0,0,2,1,0,3]]}]}],"f":[{"u":[{},[0,0,0,2,1,0,2]]}],"i":[{"b":[{},[0,0,0,2,1]],"d":[{},[0,0,0,3,2,3]],"e":[{"n":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]]}],"é":[{"n":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]]}],"g":[{},[0,0,0,2,1]],"i":[{".":[{},[0,0,0,2,3]]}],"m":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,3]],"t":[{"i":[{},[0,0,0,3,6]],"o":[{},[0,0,0,3,6]],"r":[{},[0,0,0,3,6]]},[0,0,0,2,5]]}],"í":[{"d":[{},[0,0,0,3,2,3]],"g":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]],"s":[{},[0,0,0,2,3]],"t":[{"i":[{},[0,0,0,3,6]],"o":[{},[0,0,0,3,6]]},[0,0,0,2,5]]}]}],"g":[{"n":[{},[0,0,0,3,2]]}],"i":[{"e":[{},[0,0,0,3,4]],"é":[{},[0,0,0,3,4]],"i":[{},[0,0,0,3,4]],"í":[{},[0,0,0,3,4]],"n":[{},[0,0,0,3]]}],"p":[{"t":[{"e":[{"r":[{},[0,0,0,0,0,0,2,3]]}],"é":[{"r":[{},[0,0,0,0,0,0,2,3]]}]}]}],"s":[{"c":[{},[0,0,0,3,2]],"p":[{},[0,0,0,3,2]],"t":[{"a":[{"n":[{},[0,0,0,5,4]],"r":[{},[0,0,0,5,4]]}],"i":[{"t":[{},[0,0,0,4,3]]}],"r":[{"a":[{},[0,0,0,4,3]],"á":[{},[0,0,0,4,3]]}]},[0,0,0,5,2]]}],"u":[{},[0,0,0,3]]}],"ó":[{"d":[{"e":[{"a":[{},[0,0,0,2,1]],"o":[{},[0,0,0,2,1]]}],"i":[{"e":[{"n":[{},[0,0,0,2,1]],"r":[{},[0,0,0,2,1]]}],"g":[{},[0,0,0,2,1]],"i":[{".":[{},[0,0,0,2,3]]}]}]}],"i":[{"i":[{},[0,0,0,3,4]]}],"s":[{"p":[{},[0,0,0,3,2]]}]}]}],"s":[{"e":[{"u":[{"d":[{"o":[{},[0,0,0,4]]}]}]}]}]},[0,2]],"q":[{"u":[{"a":[{"m":[{"o":[{"b":[{},[0,0,0,2,3,2,3]]}]}]}],"e":[{"m":[{"a":[{"d":[{"m":[{},[0,0,0,2,3,2,3]]}]}],"á":[{"d":[{"m":[{},[0,0,0,2,3,2,3]]}]}]}]}],"i":[{"n":[{"c":[{"u":[{"n":[{},[0,0,0,0,2,3]]}]}]}]}],"o":[{"a":[{"d":[{"u":[{"s":[{"q":[{},[0,0,0,0,2,3]]}]}],"ú":[{"s":[{"q":[{},[0,0,0,0,2,3]]}]}]}]}],"d":[{"l":[{},[0,0,0,6,5]]}],"n":[{"i":[{"a":[{"m":[{},[0,0,0,6,3]]}]}]}],"t":[{"a":[{"n":[{},[0,0,0,2,1]]}],"e":[{"n":[{"n":[{},[0,0,0,2,1]]}]}],"l":[{"i":[{},[0,0,0,2,3]]}]}]}],"ó":[{"n":[{"i":[{"a":[{"m":[{},[0,0,0,6,3]]}]}]}]}]}]}],"r":[{"a":[{"y":[{},[0,0,2]]}],"e":[{"d":[{"a":[{"c":[{},[0,0,2,1]],"d":[{},[0,0,2,1]],"m":[{"b":[{},[0,0,2,1]]},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{"g":[{},[0,0,2,1]]},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}],"á":[{"c":[{},[0,0,2,1]],"d":[{},[0,0,2,1]],"m":[{"b":[{},[0,0,2,1]]},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{"g":[{},[0,0,2,1]]},[0,0,2,1]],"u":[{},[0,0,2,1,2]]}],"e":[{"a":[{},[0,0,2,1]],"á":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"o":[{},[0,0,2,1]],"u":[{},[0,0,2,1]],"ú":[{},[0,0,2,1]]}],"é":[{"g":[{},[0,0,2,1]],"m":[{},[0,0,2,1]]}],"h":[{},[0,0,2,1]],"i":[{".":[{},[0,0,2,1]],"b":[{},[0,0,2,1]],"c":[{},[0,0,3,2]],"e":[{"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]]}],"é":[{"r":[{},[0,0,2,1]]}],"i":[{},[0,0,2,1]],"í":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"m":[{"i":[{},[0,0,4,3]]},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"s":[{},[0,0,2,5]],"t":[{},[0,0,2,5]],"v":[{},[0,0,2,1]]}],"í":[{"b":[{},[0,0,2,1]],"e":[{"r":[{},[0,0,2,1]]}],"i":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"r":[{},[0,0,2,1]],"t":[{},[0,0,2,5]],"v":[{},[0,0,2,1]]}],"o":[{"l":[{},[0,0,2,1]],"p":[{},[0,0,2,1]],"r":[{"d":[{},[0,0,2,1]],"m":[{},[0,0,3,2]],"n":[{},[0,0,2,1]]}]}],"ó":[{"l":[{},[0,0,2,1]],"p":[{},[0,0,2,1]],"r":[{"d":[{},[0,0,2,1]],"n":[{},[0,0,2,1]]}]}],"u":[{"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}],"ú":[{"l":[{},[0,0,2,1]],"n":[{},[0,0,2,1]],"v":[{},[0,0,2,1]]}]}],"e":[{"x":[{},[0,0,0,2]]}],"i":[{"e":[{"c":[{},[0,0,3,2]]},[0,0,1]],"n":[{},[0,0,1]],"p":[{"s":[{},[0,0,3]]}],"t":[{"e":[{},[0,0,3]]}]}],"p":[{"a":[{"u":[{},[0,0,0,0,2]]}]}],"s":[{"c":[{"r":[{},[0,0,3,2]],"u":[{},[0,0,3,2]],"ú":[{},[0,0,3,2]]}],"p":[{"u":[{"b":[{"l":[{"i":[{"c":[{},[0,0,4,3,0,4,3,4]]}]}]}]}],"ú":[{"b":[{"l":[{"i":[{"c":[{},[0,0,4,3,0,4,3,4]]}]}]}]}],"e":[{"c":[{},[0,0,3,2]]}],"é":[{"c":[{},[0,0,3,2]]}]},[0,0,3,2]],"t":[{"a":[{"g":[{},[0,0,5,2]],"u":[{},[0,0,5,4,0,2]]},[0,0,5,4]],"á":[{},[0,0,5,4]],"e":[{"r":[{},[0,0,5,2]]}],"é":[{"r":[{},[0,0,5,2]]}],"i":[{"b":[{},[0,0,5,2]],"c":[{"u":[{},[0,0,6,3]]},[0,0,5,2]],"l":[{},[0,0,5,2]],"n":[{},[0,0,5,2]],"p":[{},[0,0,5,2]],"t":[{},[0,0,5,4]]}],"í":[{"b":[{},[0,0,5,2]],"n":[{},[0,0,5,2]],"p":[{},[0,0,5,2]],"t":[{},[0,0,5,4]]}],"o":[{},[0,0,5,2]],"r":[{},[0,0,5,4]]}]}]}],"é":[{"d":[{"e":[{"a":[{},[0,0,2,1]],"o":[{},[0,0,2,1]],"u":[{},[0,0,2,1]]}],"i":[{"e":[{"n":[{},[0,0,2,1]]}],"i":[{},[0,0,2,1]],"g":[{},[0,0,2,1]],"m":[{},[0,0,2,1]],"t":[{},[0,0,2,5]]}],"o":[{"l":[{},[0,0,2,1]]}]}],"s":[{"p":[{},[0,0,3,2]],"t":[{"i":[{"t":[{},[0,0,5,4]]}],"r":[{},[0,0,5,4]]}]}]}]},[0,2]],"s":[{"a":[{"t":[{"a":[{"g":[{},[0,0,2,1]]}],"á":[{"g":[{},[0,0,2,1]]}],"i":[{"s":[{},[0,0,0,0,2,1]]}]}],"u":[{"l":[{".":[{},[0,0,3]]}]}]}],"e":[{"m":[{"e":[{"t":[{"i":[{"p":[{},[0,0,0,0,2,3]]}]}]}],"u":[{"n":[{},[0,0,2,3]],"s":[{},[0,0,2,3]]}]}],"s":[{"c":[{"e":[{"n":[{},[0,0,3,4]]}],"u":[{"n":[{},[0,0,0,2,1,4]]}]}]}],"u":[{".":[{},[0,0,4]]}]}],"i":[{"c":[{"u":[{"t":[{},[0,0,2,1]]}]}],"s":[{"t":[{"e":[{"n":[{},[0,0,3,2]]}]}]}]}],"í":[{"c":[{"u":[{"t":[{},[0,0,2,1]]}]}]}],"m":[{},[0,2]],"t":[{"a":[{"g":[{"n":[{},[0,0,0,3,2]]}]}]}],"u":[{"b":[{"i":[{"a":[{},[0,0,0,0,4]],"á":[{},[0,0,0,0,4]],"e":[{},[0,0,0,0,4]],"é":[{},[0,0,0,0,4]],"i":[{},[0,0,0,0,4]],"í":[{},[0,0,0,0,4]],"u":[{},[0,0,0,0,4]],"ú":[{},[0,0,0,0,4]]}],"s":[{"c":[{"r":[{},[0,0,0,5,4]]}],"t":[{},[0,0,0,5,4]]}],"t":[{"e":[{"r":[{"h":[{},[0,0,0,0,0,2,3]]}]}]}],"u":[{"l":[{"c":[{},[0,0,4,5]],"t":[{},[0,0,4,5]]},[0,0,3,4]]}]},[0,0,2,3]],"p":[{"e":[{"r":[{"a":[{"b":[{"a":[{},[0,0,0,0,3,2]],"á":[{},[0,0,0,0,3,2]],"e":[{},[0,0,0,0,3,2]],"i":[{},[0,0,0,0,3,2]],"í":[{},[0,0,0,0,3,2]],"l":[{},[0,0,0,0,0,0,2,3]],"o":[{},[0,0,0,0,3,2]],"u":[{"m":[{},[0,0,0,0,4,3,2,3]],"n":[{"d":[{},[0,0,0,0,4,3,2,3]]}]},[0,0,0,0,3,2]],"ú":[{"n":[{"d":[{},[0,0,0,0,4,3,2,3]]}]},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"c":[{},[0,0,0,0,2,1]],"d":[{"i":[{"i":[{},[0,0,0,0,0,0,2,1,2]],"í":[{},[0,0,0,0,0,0,2,1,2]]}],"s":[{"t":[{},[0,0,0,0,2,1,0,3,2]]}]},[0,0,0,0,2,1]],"g":[{},[0,0,0,0,2,1]],"l":[{"l":[{},[0,0,0,0,2,1]]}],"m":[{"b":[{},[0,0,0,0,4,3]]},[0,0,0,0,3,2]],"n":[{"d":[{},[0,0,0,0,3,2]]}],"p":[{},[0,0,0,0,4,3]],"r":[{"g":[{},[0,0,0,0,2,1]]}],"s":[{"c":[{},[0,0,0,0,2,1]],"p":[{},[0,0,0,0,2,1,3,2]],"t":[{},[0,0,0,0,2,1,3,2]]}],"t":[{"t":[{},[0,0,0,0,2,1]]}]}],"á":[{"b":[{"a":[{},[0,0,0,0,3,2]],"e":[{},[0,0,0,0,3,2]],"i":[{},[0,0,0,0,3,2]],"l":[{},[0,0,0,0,0,0,2,3]],"o":[{},[0,0,0,0,3,2]],"u":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"d":[{},[0,0,0,0,2,1]],"g":[{},[0,0,0,0,2,1]],"l":[{"l":[{},[0,0,0,0,2,1]]}],"m":[{"b":[{},[0,0,0,0,4,3]]}],"n":[{"d":[{},[0,0,0,0,3,2]]}]}],"æ":[{".":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"b":[{"i":[{"b":[{},[0,0,0,0,2,1]],"f":[{},[0,0,0,0,2,1]],"l":[{},[0,0,0,0,2,1]]}]}],"c":[{},[0,0,0,0,2,1]],"d":[{},[0,0,0,0,2,1]],"e":[{"d":[{},[0,0,0,0,2,1]],"f":[{"f":[{},[0,0,0,0,2,1]]}],"g":[{},[0,0,0,0,2,1]],"l":[{},[0,0,0,0,2,1]],"m":[{".":[{},[0,0,0,0,3,2]],"i":[{"n":[{"i":[{".":[{},[0,0,0,0,3,2]]}]}]}],"u":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"n":[{"t":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"r":[{".":[{},[0,0,0,0,3,2]],"e":[{".":[{},[0,0,0,0,3,2]]}],"i":[{"s":[{".":[{},[0,0,0,0,3,2]]}]}]},[0,0,0,0,2,1]],"s":[{".":[{},[0,0,0,0,0,3]]},[0,0,0,0,2,1]],"u":[{},[0,0,0,0,2,1]],"v":[{},[0,0,0,0,2,1]],"x":[{},[0,0,0,0,2,1,2,3]]}],"é":[{"f":[{"f":[{},[0,0,0,0,2,1]]}],"l":[{},[0,0,0,0,2,1]],"m":[{"i":[{"n":[{"i":[{".":[{},[0,0,0,0,3,2]]}]}]}],"u":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"n":[{"t":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"s":[{},[0,0,0,0,2,1]],"v":[{},[0,0,0,0,2,1]]}],"h":[{},[0,0,0,0,2,3]],"i":[{".":[{},[0,0,0,0,3,4]],"l":[{},[0,0,0,0,2,1]],"m":[{"i":[{"n":[{"i":[{".":[{},[0,0,0,0,3,4,3]]}]}]}]},[0,0,0,0,2,1]],"n":[{"i":[{"i":[{},[0,0,0,0,0,0,0,3,4]],"í":[{},[0,0,0,0,0,0,0,3,4]]}]},[0,0,0,0,2,1]],"o":[{},[0,0,0,0,3,4,3]],"ó":[{},[0,0,0,0,3,4,3]],"r":[{},[0,0,0,0,2,1]],"s":[{".":[{},[0,0,0,0,3,4]]}],"u":[{"m":[{"e":[{},[0,0,0,0,4,5,4]]}]},[0,0,0,0,3,4,3]]},[0,0,0,0,2,3,2]],"í":[{"l":[{},[0,0,0,0,2,1]]}],"o":[{"b":[{"d":[{},[0,0,0,0,2,1,2,1]],"r":[{},[0,0,0,0,2,1,2,3]],"u":[{},[0,0,0,0,2,1,2,1]],"ú":[{},[0,0,0,0,2,1,2,1]]}],"c":[{},[0,0,0,0,2,1]],"p":[{},[0,0,0,0,2,1]],"r":[{"d":[{},[0,0,0,0,4,3]]},[0,0,0,0,3,2]]}],"ó":[{"b":[{"r":[{},[0,0,0,0,2,1,2,3]]}],"c":[{},[0,0,0,0,2,1]]}],"s":[{"c":[{},[0,0,0,0,2,3,2]],"p":[{},[0,0,0,0,2,3,2]],"t":[{},[0,0,0,0,2,5,4]],"u":[{"b":[{"s":[{"t":[{},[0,0,0,0,2,1,0,0,3,2]]}]}]}]}],"u":[{"m":[{".":[{},[0,0,0,0,3,4]]}],"s":[{".":[{},[0,0,0,0,3,2]]}]},[0,0,0,0,2,3]],"ú":[{},[0,0,0,0,2,3]]}]}],"é":[{"r":[{"a":[{"b":[{"u":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"d":[{"s":[{"t":[{},[0,0,0,0,2,1,0,3,2]]}]},[0,0,0,0,2,1]],"g":[{},[0,0,0,0,2,1]],"m":[{},[0,0,0,0,3,2]],"r":[{"g":[{},[0,0,0,0,2,1]]}],"s":[{"p":[{},[0,0,0,0,2,1,3,2]],"t":[{},[0,0,0,0,2,1,3,2]]}],"t":[{"t":[{},[0,0,0,0,2,1]]}]}],"æ":[{".":[{},[0,0,0,0,3,2]]},[0,0,0,0,2,1]],"b":[{"i":[{"b":[{},[0,0,0,0,2,1]],"f":[{},[0,0,0,0,2,1]],"l":[{},[0,0,0,0,2,1]]}]}],"c":[{},[0,0,0,0,2,1]],"d":[{},[0,0,0,0,2,1]],"e":[{"d":[{},[0,0,0,0,2,1]],"f":[{"f":[{},[0,0,0,0,2,1]]}],"g":[{},[0,0,0,0,2,1]],"m":[{},[0,0,0,0,2,1]],"n":[{},[0,0,0,0,2,1]],"r":[{"i":[{"s":[{".":[{},[0,0,0,0,3,2]]}]}]},[0,0,0,0,2,1]],"x":[{},[0,0,0,0,2,1,2,3]]}],"i":[{".":[{},[0,0,0,0,3,4]],"o":[{},[0,0,0,0,3,4,3]],"s":[{".":[{},[0,0,0,0,3,4]]}],"u":[{},[0,0,0,0,3,4,3]]},[0,0,0,0,2,3,2]],"s":[{"t":[{},[0,0,0,0,2,5,4]]}]}]}],"r":[{"a":[{"s":[{"c":[{},[0,0,0,0,0,3,2]]}]}]}]}],"s":[{"c":[{"r":[{},[0,0,5,4]]}],"p":[{"e":[{"c":[{},[0,0,3,2]],"n":[{},[0,0,4,3]]}],"é":[{"c":[{},[0,0,3,2]],"n":[{},[0,0,4,3]]}],"i":[{"c":[{},[0,0,3,2]],"r":[{},[0,0,3,2]]}],"í":[{"c":[{},[0,0,3,2]],"r":[{},[0,0,3,2]]}]}]}]}],"ú":[{"b":[{"i":[{"i":[{},[0,0,0,0,4]]}],"s":[{"t":[{},[0,0,0,5,4]]}],"u":[{"l":[{},[0,0,3,4]]}]},[0,0,2,3]],"p":[{"e":[{"r":[{"e":[{"s":[{".":[{},[0,0,0,0,0,3]]},[0,0,0,0,2,1]]}]}]}]}],"s":[{"p":[{"i":[{"c":[{},[0,0,3,2]]}]}]}]}]},[0,2]],"t":[{"a":[{"m":[{},[0,0,2,3]]}],"e":[{"r":[{"i":[{"u":[{},[0,0,2,1,2]]}],"p":[{"s":[{},[0,0,0,0,2]]}],"u":[{"n":[{},[0,0,2,1]]}],"ú":[{"n":[{},[0,0,2,1]]}]}],"t":[{"r":[{"a":[{"e":[{"t":[{},[0,0,0,0,0,3,2]]}],"g":[{"n":[{},[0,0,0,0,0,3,2]]}],"s":[{"t":[{},[0,0,0,0,0,3,2]]}]}]}]}],"u":[{"t":[{},[0,0,2]]}]}],"h":[{"e":[{"o":[{"g":[{"n":[{},[0,0,0,0,3,2]]}]},[0,0,0,2]],"s":[{"p":[{},[0,0,0,3,2]],"t":[{},[0,0,0,3,2]]}]}],"i":[{"s":[{"b":[{},[0,0,0,3,2]]}]}]}],"r":[{"a":[{"i":[{"a":[{},[0,0,0,1,2]],"e":[{},[0,0,0,1,2]],"i":[{},[0,0,0,1]]}],"n":[{"s":[{"a":[{"b":[{"e":[{},[0,0,0,0,0,1,2,1,2]],"é":[{},[0,0,0,0,0,1,2,1,2]],"i":[{},[0,0,0,0,0,1,2,1]],"í":[{},[0,0,0,0,0,1,2,1]]}],"c":[{"t":[{},[0,0,0,0,0,1]]}],"d":[{},[0,0,0,0,0,1,2,1]],"u":[{},[0,0,0,0,0,1,2]]},[0,0,0,0,0,0,2]],"c":[{},[0,0,0,0,3,2]],"e":[{"a":[{},[0,0,0,0,0,3]],"n":[{},[0,0,0,0,3,2]],"u":[{},[0,0,0,0,0,0,2]],"ú":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,0,1]],"i":[{"e":[{},[0,0,0,0,0,0,3]],"é":[{},[0,0,0,0,0,0,3]],"l":[{},[0,0,0,0,3,4]]},[0,0,0,0,0,3]],"í":[{"b":[{},[0,0,0,0,0,3]],"l":[{},[0,0,0,0,3,4]]},[0,0,0,0,0,3]],"o":[{},[0,0,0,0,0,1,2]],"u":[{"m":[{},[0,0,0,0,3,2]]},[0,0,0,0,0,1,2]]},[0,0,0,0,2]],"u":[{"e":[{},[0,0,0,2,1]]}]}]}],"á":[{"n":[{"s":[{"e":[{"a":[{},[0,0,0,0,0,3]],"u":[{},[0,0,0,0,0,0,2]]},[0,0,0,0,0,1]],"i":[{"e":[{},[0,0,0,0,0,0,3]],"i":[{},[0,0,0,0,0,3,4]]},[0,0,0,0,0,3]]},[0,0,0,0,2]]}]}],"i":[{"e":[{"n":[{},[0,0,0,3]]}]}]}]},[0,2]],"u":[{"n":[{"i":[{"a":[{"n":[{},[0,0,0,3]]}],"á":[{"n":[{},[0,0,0,3]]}],"u":[{"s":[{"c":[{"u":[{},[0,3,2,3]]}]}]}]}]}],"t":[{"e":[{"r":[{"u":[{"i":[{},[0,0,0,2,3]]}]}]}]}]}],"v":[{"e":[{"l":[{"u":[{"t":[{},[0,0,2,1]]}]}]}]}],"x":[{},[0,2]],"z":[{"a":[{"i":[{"e":[{"u":[{},[0,0,2,3]]}]}]}],"e":[{"u":[{"g":[{"m":[{},[0,0,0,3,2]]}]}]}]},[0,2]]}],"a":[{"e":[{".":[{},[0,1]]}],"i":[{"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,4]],"o":[{"r":[{".":[{},[0,0,6]]}]},[0,0,2]],"ó":[{},[0,0,2]],"s":[{},[0,1]],"t":[{".":[{},[0,3]]}],"u":[{"n":[{"t":[{".":[{},[0,0,4]]}]}]},[0,0,2]]}],"í":[{"s":[{},[0,1]]}],"m":[{"u":[{"i":[{},[0,2,3]]}]}],"u":[{"m":[{".":[{},[0,3]]}],"s":[{".":[{},[0,3]]}]},[0,2]],"ú":[{},[0,5]],"x":[{".":[{},[2]]}],"y":[{},[0,2]]},[0,1]],"á":[{"i":[{"t":[{".":[{},[0,3]]}],"u":[{},[0,0,2]]}],"u":[{"m":[{".":[{},[0,3]]}],"s":[{".":[{},[0,3]]}]},[0,2]],"y":[{},[0,2]]},[0,1]],"æ":[{"a":[{},[0,3]],"á":[{},[0,3]],"e":[{},[0,3]],"é":[{},[0,3]],"i":[{},[0,3]],"í":[{},[0,3]],"o":[{},[0,3]],"ó":[{},[0,3]],"u":[{},[0,3]],"ú":[{},[0,3]]},[0,1]],"ǽ":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]]},[0,1]],"b":[{".":[{},[2]],"b":[{},[2]],"d":[{},[2]],"h":[{},[2]],"j":[{},[2]],"l":[{},[0,2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"r":[{},[0,2]],"s":[{"t":[{},[0,3,2]]},[2]],"t":[{},[2]],"u":[{"i":[{"s":[{".":[{},[0,0,3]]}]}],"u":[{},[0,0,3]]}]},[1]],"c":[{".":[{},[4]],"c":[{},[2]],"d":[{},[2]],"h":[{".":[{},[2]],"l":[{},[0,0,4]],"m":[{},[4,0,3]],"o":[{"e":[{},[0,0,0,3]]}],"r":[{},[0,0,4]],"t":[{},[4,0,3]]},[0,2]],"i":[{"e":[{"n":[{"t":[{},[0,0,3]]}],"t":[{},[0,0,3]]}]}],"l":[{},[0,4]],"m":[{},[2]],"n":[{},[2]],"q":[{},[2]],"r":[{},[0,6]],"s":[{},[2]],"t":[{},[2]],"u":[{"i":[{"ú":[{"s":[{},[0,0,0,4]]}]}],"l":[{"c":[{},[0,0,4]],"n":[{},[0,0,4]],"p":[{},[0,0,4]]}],"m":[{"b":[{},[0,0,4]]}],"n":[{"c":[{},[0,0,4]],"t":[{},[0,0,4]]}],"r":[{"s":[{},[0,0,4]]}]},[0,0,3]],"ú":[{"l":[{"c":[{},[0,0,4]],"n":[{},[0,0,4]],"p":[{},[0,0,4]]}]}],"z":[{},[2]]},[1]],"d":[{".":[{},[2]],"æ":[{".":[{},[0,2]]}],"a":[{"m":[{".":[{},[0,2]]}]}],"c":[{},[2]],"d":[{},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[2,3]],"i":[{"t":[{".":[{},[0,4]]}]}],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"q":[{},[2]],"r":[{},[0,2]],"s":[{},[2]],"u":[{"u":[{},[0,0,3]]}],"v":[{},[4]],"w":[{},[2,3]]},[1]],"e":[{"a":[{"m":[{".":[{},[0,3]]}],"n":[{"t":[{".":[{},[0,5]]}]}],"t":[{".":[{},[0,3]]}]}],"i":[{"a":[{},[0,0,2]],"á":[{},[0,0,2]],"e":[{},[0,0,2]],"é":[{},[0,0,2]],"i":[{},[0,0,4]],"í":[{},[0,0,2]],"o":[{},[0,0,4]],"s":[{".":[{},[0,3]]}],"u":[{"s":[{".":[{},[0,0,4]]}]},[0,0,2]],"ú":[{},[0,0,2]]}],"l":[{"u":[{"e":[{},[0,2,3]]}]}],"m":[{".":[{},[2]]}],"s":[{".":[{},[2]],"r":[{},[0,2,3]]}],"t":[{".":[{},[2]]}],"ú":[{},[0,5]],"x":[{".":[{},[2]]}],"y":[{},[0,3]]},[0,1]],"é":[{"a":[{"m":[{".":[{},[0,3]]}],"n":[{"t":[{".":[{},[0,5]]}]}],"t":[{".":[{},[0,3]]}]}],"i":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"i":[{},[0,0,4]],"o":[{},[0,0,4]],"s":[{".":[{},[0,3]]}],"u":[{"s":[{".":[{},[0,0,4]]}]},[0,0,2]]}]},[0,1]],"ë":[{},[0,1]],"f":[{".":[{},[2]],"f":[{},[2]],"l":[{},[0,2]],"n":[{},[2]],"r":[{},[0,2]],"t":[{},[2]]},[1]],"g":[{".":[{},[2]],"d":[{},[2]],"e":[{"n":[{"u":[{"a":[{},[0,0,3,2]]}]}]}],"f":[{},[2]],"g":[{},[2]],"l":[{},[0,2]],"m":[{},[2]],"n":[{"e":[{".":[{},[0,4]]}]},[0,2]],"r":[{},[0,2]],"s":[{},[2]]},[1]],"h":[{".":[{},[2]],"m":[{},[0,3]],"p":[{},[2]],"t":[{},[2]],"u":[{"c":[{"u":[{"s":[{},[0,0,2,5]]}]}]}]},[1]],"i":[{"e":[{"l":[{".":[{},[0,1]]}],"m":[{".":[{},[0,3]],"s":[{".":[{},[0,3]]}]}],"n":[{"s":[{".":[{},[0,3]]}],"t":[{".":[{},[0,3]]}]}],"s":[{".":[{},[0,3]]}],"t":[{".":[{},[0,3]]}]}],"i":[{".":[{},[0,5]],"s":[{".":[{},[0,3]]}],"t":[{".":[{},[0,5]]}]}],"m":[{".":[{},[2,2]]}],"o":[{"i":[{"u":[{},[0,2,0,2]]}],"r":[{".":[{},[0,5]]}]}],"s":[{".":[{},[2,2]]}],"t":[{".":[{},[2,2]]}],"u":[{"d":[{".":[{},[0,3]]}],"m":[{".":[{},[0,3]]}],"n":[{"t":[{".":[{},[0,3]]}]}],"r":[{".":[{},[0,3]]}],"s":[{".":[{},[0,3]],"l":[{},[0,2,2,3]],"v":[{},[0,2,2,3]]}]}],"ú":[{"s":[{"l":[{},[0,2,2,3]],"v":[{},[0,2,2,3]]}]}],"x":[{".":[{},[2,2]]}]},[0,1]],"í":[{"a":[{},[0,5]],"æ":[{},[0,5]],"e":[{},[0,5]],"i":[{},[0,5]],"o":[{},[0,5]],"u":[{},[0,5]]},[0,1]],"ï":[{},[0,1]],"j":[{},[1]],"k":[{},[1]],"l":[{".":[{},[4]],"a":[{"n":[{"g":[{"u":[{"i":[{".":[{},[0,0,0,0,0,5]],"t":[{".":[{},[0,0,0,0,0,5]]}],"m":[{"u":[{"s":[{".":[{},[0,0,0,0,0,5]]}]}]}]}]}]}]}]}],"á":[{"n":[{"g":[{"u":[{"i":[{".":[{},[0,0,0,0,0,5]],"t":[{".":[{},[0,0,0,0,0,5]]}],"m":[{"u":[{"s":[{".":[{},[0,0,0,0,0,5]]}]}]}]}]}]}]}]}],"b":[{},[2]],"c":[{},[2]],"d":[{},[2]],"f":[{"t":[{},[0,3,2]]},[2]],"g":[{},[2]],"k":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"q":[{},[2]],"r":[{},[2]],"s":[{},[2]],"t":[{},[4]],"u":[{"i":[{"a":[{".":[{},[0,0,3,2]]}]}],"u":[{"n":[{},[0,0,1]]}],"ú":[{"n":[{},[0,0,1]]}]}],"ú":[{"i":[{"a":[{".":[{},[0,0,3,2]]}]}]}],"v":[{},[4]],"z":[{},[4]]},[1]],"m":[{".":[{},[4]],"b":[{},[2]],"c":[{},[2]],"e":[{"t":[{"i":[{"p":[{"s":[{},[0,0,4,3]]}]}]}]}],"d":[{},[2]],"f":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"q":[{},[4]],"r":[{},[2]],"s":[{},[2]],"t":[{},[2]],"v":[{},[6]]},[1]],"n":[{".":[{},[2]],"b":[{},[2]],"c":[{"o":[{"i":[{},[0,0,0,3]]}]},[2]],"d":[{},[4]],"e":[{".":[{},[3]]}],"f":[{},[2]],"g":[{"u":[{"a":[{},[0,0,0,6]],"á":[{},[0,0,0,2]],"æ":[{},[0,0,0,2]],"ǽ":[{},[0,0,0,2]],"e":[{"r":[{"a":[{},[0,0,0,7]],"i":[{"s":[{},[0,0,0,8]],".":[{},[0,0,0,8]]},[0,0,0,7]],"o":[{".":[{},[0,0,0,7]]}],"u":[{"n":[{"t":[{".":[{},[0,0,0,7]]}]}]}]}]},[0,0,0,6]],"é":[{"r":[{"u":[{"n":[{"t":[{".":[{},[0,0,0,7]]}]}]}]}]},[0,0,0,6]],"i":[{"a":[{},[0,0,0,4,3]],"s":[{"s":[{"e":[{".":[{},[0,0,0,6]]}]},[0,0,0,5]],"t":[{},[0,0,0,5]]}]},[0,0,0,4]],"í":[{},[0,0,0,4]],"o":[{},[0,0,0,6]],"ó":[{},[0,0,0,6]],"u":[{},[0,0,0,6]],"ú":[{},[0,0,0,6]]}],"ú":[{"a":[{},[0,0,0,7]],"æ":[{},[0,0,0,7]],"e":[{},[0,0,0,7]],"i":[{},[0,0,0,7]],"o":[{},[0,0,0,7]],"u":[{},[0,0,0,7]]}]},[2]],"h":[{},[2]],"j":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"q":[{},[2]],"r":[{},[2]],"s":[{"f":[{},[0,2,3]],"m":[{},[0,2,3]]},[2]],"t":[{},[2]],"u":[{"i":[{"s":[{".":[{},[0,0,3]]}]}]}],"v":[{},[4]],"x":[{},[2,0,2]],"z":[{},[2]]},[1]],"o":[{"i":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}],"u":[{"m":[{".":[{},[0,3]]}]}],"x":[{".":[{},[2]]}],"y":[{},[0,3]]},[0,1]],"ó":[{"i":[{"a":[{},[0,0,2]],"e":[{},[0,0,2]],"o":[{},[0,0,2]],"u":[{},[0,0,2]]}]},[0,1]],"œ":[{},[0,1]],"u":[{"s":[{"q":[{"u":[{"e":[{},[0,2,3]]}]}]}],"é":[{},[0,3]],"e":[{".":[{},[0,3]],"m":[{".":[{},[0,3]]}],"n":[{},[0,3]],"s":[{".":[{},[0,3]]}],"t":[{".":[{},[0,3]]}]}],"i":[{".":[{},[2]],"a":[{},[0,1,2]],"e":[{},[0,1,2]],"é":[{},[0,1,2]],"o":[{},[0,1,2]],"s":[{".":[{},[0,3]]}],"t":[{".":[{},[0,3]]}],"u":[{"s":[{".":[{},[0,0,4]]}]},[0,0,2]]}],"o":[{".":[{},[0,5]],"u":[{"s":[{},[0,0,3]]},[0,0,3]],"ú":[{"s":[{},[0,0,3]]}]}],"u":[{"m":[{".":[{},[0,5]]}],"s":[{".":[{},[0,5]]}]}],"x":[{".":[{},[2]]}]},[0,1]],"p":[{".":[{},[2]],"h":[{".":[{},[2]],"a":[{"e":[{"l":[{},[0,0,0,3]]}]}],"p":[{"h":[{},[0,0,3]]},[2]],"t":[{},[2]]},[0,2]],"l":[{},[0,2]],"n":[{"e":[{"u":[{},[3,2]]}]},[2]],"o":[{"t":[{"e":[{"n":[{},[0,0,2,3]],"r":[{},[0,0,2,3]],"s":[{},[0,0,2,3]]}],"é":[{"n":[{},[0,0,2,3]],"r":[{},[0,0,2,3]],"s":[{},[0,0,2,3]]}]}]}],"p":[{},[4]],"r":[{},[0,2]],"s":[{"i":[{"c":[{},[3,2]]}]},[2]],"t":[{"r":[{},[3,2]]},[4,3]],"z":[{},[2]]},[1]],"q":[{"u":[{"i":[{"a":[{},[1,0,0,3]],"á":[{},[1,0,0,3]],"æ":[{},[1,0,0,3]],"ǽ":[{},[1,0,0,3]],"e":[{},[1,0,0,3]],"é":[{},[1,0,0,3]],"o":[{},[1,0,0,3]],"ó":[{},[1,0,0,3]],"u":[{},[1,0,0,5]],"ú":[{},[1,0,0,5]]}],"o":[{".":[{},[0,0,6]]}],"u":[{"m":[{".":[{},[0,0,6]]}]},[0,0,6]]},[1,0,4]]}],"r":[{".":[{},[4]],"æ":[{".":[{},[0,2]]}],"b":[{},[2]],"c":[{"h":[{"m":[{},[0,2]]}]},[2]],"d":[{},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{},[0,2]],"i":[{"e":[{".":[{},[0,0,3]]}],"i":[{"t":[{".":[{},[0,4]]}]}]}],"l":[{},[2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"q":[{},[2]],"r":[{},[4,3]],"s":[{},[2]],"t":[{},[2]],"u":[{"i":[{"s":[{".":[{},[0,0,3]]}],"t":[{".":[{},[0,0,3]]}]}],"s":[{".":[{},[0,4]]}]}],"v":[{},[4]],"x":[{},[2,1]],"z":[{},[2]]},[1]],"s":[{".":[{},[4]],"b":[{},[2]],"c":[{"æ":[{},[3,2]],"ǽ":[{},[3,2]],"e":[{},[3,2]],"é":[{},[3,2]],"i":[{},[3,2]],"í":[{},[3,2]],"œ":[{},[3,2]],"y":[{},[3,2]],"ý":[{},[3,2]]},[2]],"d":[{"e":[{"m":[{".":[{},[2,3]]}]}]},[2]],"f":[{},[2]],"g":[{},[2]],"l":[{},[2]],"m":[{},[2]],"n":[{"e":[{".":[{},[2]]}]},[2]],"p":[{},[2]],"q":[{"u":[{"e":[{".":[{},[2,3]]}]}]},[2]],"r":[{},[2]],"s":[{"e":[{".":[{},[0,3]]}]},[4]],"t":[{".":[{},[2]],"k":[{},[0,4,1]],"l":[{},[0,2,3]],"n":[{},[2,3]],"p":[{},[2,0,3]],"q":[{},[0,2,3]],"r":[{"a":[{".":[{},[6,5]]}],"i":[{".":[{},[6,5]],"s":[{".":[{},[6,5]]}]}],"o":[{".":[{},[6,5]],"r":[{"u":[{"m":[{".":[{},[6,5]]}]}]}]}],"ó":[{"r":[{"u":[{"m":[{".":[{},[6,5]]}]}]}]}],"u":[{"m":[{".":[{},[6,5]]}]}]}],"s":[{},[0,2,3]],"t":[{},[0,2,3]]},[4]],"u":[{"b":[{"s":[{"t":[{"a":[{"n":[{},[0,0,2,5,4]]}]}]}]}],"i":[{"s":[{".":[{},[0,0,3]]}]}]}],"v":[{},[2]]},[1]],"t":[{".":[{},[4]],"b":[{},[2]],"c":[{},[2]],"d":[{},[2]],"f":[{},[2]],"g":[{},[2]],"h":[{".":[{},[2]],"m":[{},[0,0,4]],"o":[{"s":[{"t":[{},[0,0,0,3,4]]}]}],"ó":[{"s":[{"t":[{},[0,0,0,3,4]]}]}],"p":[{},[2,0,5]],"s":[{},[2,0,5]]},[0,2,4]],"i":[{"n":[{"u":[{"i":[{},[0,0,3,2]]}]}],"o":[{".":[{},[0,0,1]]}]}],"í":[{"p":[{"s":[{},[2,1]]}]}],"l":[{},[0,2]],"m":[{},[2]],"n":[{},[2]],"p":[{},[2]],"q":[{},[2]],"r":[{"u":[{"u":[{"m":[{".":[{},[0,0,0,3]]}],"s":[{".":[{},[0,0,0,3]]}]}]}]},[0,4]],"s":[{},[2]],"t":[{},[2]]},[1]],"ú":[{"a":[{},[0,5]],"e":[{},[0,5]],"i":[{},[0,5]],"o":[{},[0,5]],"u":[{},[0,5]]},[0,1]],"ü":[{},[0,1]],"v":[{},[1]],"x":[{".":[{},[2]],"i":[{"t":[{".":[{},[0,2]]}]}],"q":[{},[2]],"t":[{},[2]],"u":[{"i":[{"t":[{".":[{},[0,2,3]]}]}],"m":[{".":[{},[0,2]]}],"s":[{".":[{},[0,2]]}]}],"ú":[{"i":[{"t":[{".":[{},[0,2,3]]}]}]}],"y":[{"s":[{"t":[{},[0,0,4,3]]}]},[0,2]]},[1]],"y":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"æ":[{},[0,3]],"y":[{},[0,3]],".":[{},[2]],"s":[{".":[{},[2]]}],"x":[{".":[{},[2]]}]},[0,1]],"ý":[{},[0,1]],"z":[{".":[{},[2]],"z":[{},[2]]},[1]],"́":[{},[8]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
