(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsLt = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"a":[{"p":[{"i":[{},[0,0,0,1]],"r":[{},[0,0,3]]},[0,0,1]],"r":[{"b":[{"i":[{},[0,0,0,0,1]]}],"t":[{"i":[{},[0,0,0,0,1]]}]}],"s":[{"p":[{},[0,0,3]]}],"t":[{"a":[{},[0,0,0,1]],"r":[{},[0,0,3]]},[0,0,1]],"š":[{"v":[{},[0,0,3]]}]}],"d":[{"i":[{"n":[{"a":[{},[0,0,0,0,1]]}]}]}],"e":[{"k":[{"r":[{},[0,0,3]]}]}],"i":[{"š":[{"i":[{},[0,0,0,2]]},[0,2,3]]}],"k":[{"i":[{"r":[{"t":[{"i":[{},[0,0,0,0,0,1]]}]}]}]}],"n":[{"u":[{"s":[{"i":[{},[0,0,0,0,1]]}]},[0,0,1]]}],"p":[{"i":[{"e":[{"č":[{},[0,0,0,2]]}]}]}],"s":[{"a":[{"m":[{},[0,0,0,1]]}],"i":[{"d":[{"a":[{},[0,0,0,0,1]]}]}],"k":[{},[0,0,4]],"t":[{},[0,0,4]],"u":[{"k":[{"r":[{},[0,0,5]]}]}]}],"t":[{"e":[{"s":[{},[0,0,3,2]]}]}],"u":[{"k":[{},[0,0,3]],"š":[{},[0,2,3]],"ž":[{},[0,0,1]]}],"į":[{"s":[{},[0,0,4]]}],"š":[{"v":[{"e":[{"n":[{},[0,0,0,0,1]]}]}]}]}],"a":[{"a":[{},[0,1,2]],"b":[{},[0,1]],"c":[{"h":[{},[0,2]]},[0,1]],"d":[{"r":[{"a":[{},[0,4]]}]},[0,1]],"e":[{"l":[{},[0,0,2]]},[0,1]],"f":[{},[0,1]],"g":[{"r":[{"a":[{},[0,0,3]],"i":[{"o":[{},[0,5]]}],"o":[{},[0,5]]},[0,4]]},[2,1]],"h":[{},[0,1]],"i":[{"n":[{"f":[{},[0,5]]}],"s":[{"k":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,4]]}]}],"j":[{},[0,1]],"k":[{"l":[{},[0,0,2]],"v":[{"i":[{},[0,0,2]]}],"ė":[{"t":[{},[0,2]]}]},[0,1]],"l":[{"i":[{},[0,3]],"o":[{},[0,5,0,1]],"y":[{},[0,3]],"ė":[{},[0,3]],"ū":[{},[0,3]]},[0,1]],"m":[{},[0,1]],"n":[{"k":[{"l":[{},[0,0,3,2]]}],"s":[{"k":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,4]]}]},[0,1]],"o":[{},[0,2]],"p":[{"a":[{"k":[{},[0,0,1,4]]}],"e":[{"i":[{},[0,0,3]]}],"i":[{"m":[{},[0,0,3,2]]}],"l":[{},[0,0,3]],"r":[{},[0,3]],"s":[{},[0,0,3,2]]},[0,1]],"r":[{"e":[{"i":[{"t":[{},[0,0,1]]}]}],"g":[{},[0,4]],"i":[{"s":[{},[0,0,0,4]]}]},[0,1]],"s":[{"i":[{"s":[{},[0,0,0,5]]},[0,0,0,1]],"k":[{"l":[{},[0,0,3]]},[0,4]],"l":[{},[0,3]],"m":[{"i":[{},[0,0,2]],"u":[{},[0,0,2]]}],"n":[{},[0,5,4]],"t":[{"u":[{},[0,4]]}]},[0,1]],"t":[{"a":[{"u":[{"g":[{},[0,0,3]]}]}],"e":[{"i":[{"s":[{"t":[{},[0,0,0,5]]}]}]}],"i":[{"m":[{},[0,0,3,2]]}],"o":[{},[0,0,0,1]],"p":[{},[0,0,0,4]],"r":[{"u":[{},[0,4]]}],"ė":[{},[0,0,1,2]],"ū":[{"ž":[{},[0,0,0,2]]}]},[0,1]],"u":[{"k":[{"l":[{},[0,0,4]]}],"s":[{"k":[{},[0,0,4]],"l":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,4,3]]}]},[0,4]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[2,1]],"ę":[{},[0,1]],"ė":[{},[0,1,2]],"į":[{},[0,1]],"š":[{"n":[{},[0,3]],"t":[{"r":[{},[0,0,4]]}],"v":[{},[0,0,2]]},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1,2]],"ž":[{"l":[{},[0,0,2]]},[0,1]]}],"b":[{"a":[{"c":[{},[0,0,3]],"l":[{"t":[{"a":[{},[0,0,0,0,0,1]]}]}],"s":[{"l":[{},[0,0,4]]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[4,3]],"e":[{"p":[{},[0,0,0,4]],"s":[{"i":[{},[0,0,0,0,1]]},[0,0,3,2]],"t":[{},[0,0,3,2]]}],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"j":[{},[0,1]],"k":[{},[2,1]],"l":[{"a":[{},[0,2]],"i":[{"z":[{},[0,2]]}],"o":[{},[3,2]],"u":[{},[0,2]]},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{"i":[{},[0,3]]},[2,2]],"s":[{},[2,1]],"t":[{},[2,3]],"u":[{"k":[{},[0,0,4]]}],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"c":[{"a":[{"r":[{},[0,0,0,4]]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{"i":[{},[3]]}],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"u":[{"k":[{},[0,0,0,5]]},[0,0,4]],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"d":[{"a":[{"b":[{},[0,0,3,4]]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"k":[{},[0,0,4]],"m":[{"a":[{},[0,0,0,0,1]]}],"p":[{"r":[{},[0,0,4]]}],"s":[{"p":[{},[0,0,4]]}]}],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"p":[{},[0,0,4]],"s":[{"k":[{},[0,0,0,5]]},[0,0,4]]}],"j":[{},[2,1]],"k":[{},[2,3]],"l":[{},[4,3]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{"r":[{"i":[{},[0,0,3]]}]}],"p":[{},[2,1]],"r":[{"o":[{"b":[{},[0,0,0,2]]},[0,0,0,1]],"ė":[{},[0,2]],"ų":[{},[4]]},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"u":[{"a":[{},[0,0,2]],"k":[{"a":[{},[0,0,5]]},[0,0,4]],"s":[{"l":[{},[0,0,4]]}]}],"v":[{"a":[{},[0,3]],"i":[{"a":[{},[0,0,0,3]]}]},[2,1]],"w":[{},[2,1]],"z":[{},[0,4]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{"i":[{"o":[{},[0,0,0,0,1]]}]},[0,4]]}],"e":[{"a":[{"l":[{},[0,2,3]],"p":[{"i":[{},[0,0,0,0,1]]}],"t":[{},[0,0,0,1]]},[0,1,2]],"b":[{"e":[{},[0,0,0,1]],"l":[{},[0,3]],"r":[{},[0,0,3]]},[0,1,2]],"c":[{"h":[{},[0,2]]},[0,1]],"d":[{"r":[{"i":[{},[0,0,3]],"o":[{},[0,4]],"ė":[{},[0,0,3]]}]},[0,3,2]],"e":[{},[0,1]],"f":[{},[0,1]],"g":[{"r":[{"a":[{},[0,0,3]]}]},[0,1]],"h":[{},[0,1]],"i":[{"e":[{},[0,1]],"k":[{"l":[{},[0,0,4,3]]}],"n":[{},[1]],"s":[{"k":[{},[0,0,4]],"l":[{},[0,0,4]],"t":[{"r":[{"a":[{},[0,0,0,0,2]]}]},[2,0,0,3]]}],"š":[{},[0,0,2,1]]}],"j":[{},[0,1]],"k":[{"r":[{},[0,3]]},[0,1]],"l":[{},[0,1]],"m":[{"a":[{"s":[{},[0,0,0,5,4]]}]},[0,1]],"n":[{"k":[{"l":[{"a":[{},[0,0,0,4]]},[0,0,3,2]]}],"o":[{},[0,0,0,1]],"s":[{},[0,0,0,4]],"t":[{"a":[{},[4]]}],"u":[{},[0,0,0,1]]},[2,1]],"o":[{"r":[{},[0,3]],"š":[{},[0,3,2]]},[0,2]],"p":[{"l":[{"i":[{},[0,0,4]]}],"r":[{"a":[{},[0,0,0,0,1]],"i":[{},[0,0,0,0,1]]},[0,0,4]]},[0,3]],"r":[{"e":[{"a":[{},[0,0,0,3,4]]}],"i":[{"s":[{},[0,0,0,4]]}],"o":[{},[0,0,0,1]],"ė":[{},[0,0,0,2]]},[0,1]],"s":[{"i":[{"s":[{},[0,0,0,5]]}],"k":[{"a":[{},[0,0,0,0,1]],"o":[{},[0,5]]},[0,0,4]],"v":[{},[0,3,2]]},[0,1]],"t":[{},[0,1]],"u":[{"ž":[{},[0,0,0,3]]},[0,1,4]],"v":[{"i":[{},[0,3]]},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1]],"į":[{"p":[{},[0,0,0,3]],"s":[{"k":[{},[0,0,0,3]]}],"t":[{"r":[{},[0,0,0,3]]}]},[0,1,4]],"š":[{"n":[{},[0,3]],"v":[{},[0,0,2]],"ė":[{},[0,0,0,3]]},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"f":[{"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"s":[{},[0,0,4,5]]}],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{"i":[{},[0,0,0,1]]},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"g":[{"a":[{"š":[{},[0,0,0,3]]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"o":[{},[0,0,4,1]]}],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"l":[{"e":[{},[0,2]],"o":[{},[0,2]]},[2,1]],"m":[{},[2,1]],"n":[{"ų":[{},[3,2]]},[2,1]],"p":[{},[2,1,2]],"r":[{"a":[{"i":[{},[0,0,0,0,2]],"n":[{},[0,3]]}],"e":[{"i":[{},[0,4]]},[5,3]],"i":[{"o":[{},[4,4]]},[0,3]],"o":[{".":[{},[0,3]]}],"ą":[{},[0,4]],"į":[{},[5]],"ų":[{},[4]]},[3,2]],"s":[{},[2,1]],"t":[{},[4,1]],"u":[{},[3]],"v":[{},[2,1]],"w":[{},[2,1]],"y":[{"v":[{"a":[{},[0,0,0,0,1]]}]}],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"h":[{"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"b":[{},[0,0,4]]}],"k":[{},[2,1]],"l":[{},[2,2]],"m":[{"e":[{},[0,2]]},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"i":[{"a":[{"g":[{},[0,0,5,4]],"i":[{"š":[{},[0,3]]}],"k":[{},[0,0,3]],"n":[{"t":[{"ę":[{},[0,3]],"ė":[{},[0,3]]}]}],"p":[{},[0,0,0,4]],"r":[{},[0,3]]},[0,2]],"b":[{},[0,3,2]],"c":[{"e":[{},[0,0,0,1]]},[0,1]],"d":[{"r":[{"ė":[{},[0,0,3]]},[0,0,2]],"ė":[{"m":[{},[0,2]]}]},[0,1]],"e":[{"d":[{"r":[{},[0,0,4,3]]}],"g":[{},[0,0,3]],"i":[{},[0,3]],"k":[{"l":[{},[0,0,3]]}],"n":[{"t":[{},[0,3]]}],"p":[{"r":[{},[0,0,4,5]]}],"s":[{"k":[{},[0,0,4]]}]},[0,2]],"f":[{},[0,1]],"g":[{"l":[{},[0,3,2]],"r":[{"u":[{},[0,0,3]]}]},[2,1]],"h":[{},[2,1]],"i":[{},[0,1,2]],"j":[{},[0,1]],"k":[{"n":[{},[0,3,2]],"r":[{},[0,0,3]]},[0,1]],"l":[{"o":[{},[0,0,0,1]]},[0,1]],"m":[{"d":[{},[1]]},[0,1]],"n":[{"k":[{"l":[{},[0,0,4]]}],"v":[{},[5]]},[4,1]],"o":[{"g":[{"r":[{},[0,0,4,3]]}],"k":[{},[0,0,0,2]],"p":[{"l":[{},[0,0,4]]}],"r":[{},[0,3]]},[0,2]],"p":[{"j":[{},[0,2,1]],"r":[{"u":[{},[0,0,3]]}]},[0,1]],"r":[{"a":[{"s":[{},[0,0,0,3,2]]}],"i":[{},[0,3]]},[0,1]],"s":[{"a":[{},[0,5]],"i":[{},[0,5]],"k":[{},[0,0,4]],"l":[{"i":[{},[0,0,4]]},[0,3]],"n":[{},[0,5,4]],"t":[{"e":[{},[0,4]],"o":[{},[0,0,0,0,1]]}]},[4,1]],"t":[{},[2,3,2]],"u":[{},[0,2]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,2]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1,2]],"į":[{},[0,1]],"š":[{"n":[{},[0,3]],"t":[{},[0,0,5]],"v":[{},[0,4]],"ė":[{},[0,0,0,2]],"š":[{},[1]]},[0,1]],"ų":[{},[0,2]],"ū":[{},[0,2]],"ž":[{},[0,3]]}],"j":[{"a":[{".":[{},[3]],"u":[{"n":[{"a":[{},[0,0,0,0,0,1]]}]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{"t":[{"v":[{},[0,0,4]]},[0,0,0,3]]}],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"u":[{},[1]],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ū":[{},[1]],"ž":[{},[2,1]]}],"k":[{"a":[{".":[{},[3]],"d":[{},[5,0,3]],"k":[{"l":[{},[0,0,4]]},[0,0,0,3]],"p":[{"r":[{},[0,0,4]]}],"r":[{},[3]],"s":[{},[3]],"t":[{"i":[{},[3]]}],"v":[{"a":[{"r":[{},[0,0,0,0,0,1]]}]},[5]],"z":[{},[0,0,3,2]]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"b":[{},[0,0,4,3]],"r":[{"e":[{"n":[{},[0,0,0,0,0,1]]}]}]},[3]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{".":[{},[5]],"a":[{},[5]],"b":[{},[3]],"l":[{},[3]],"t":[{},[5]]},[0,4]],"k":[{},[2,1]],"l":[{"a":[{"n":[{},[0,4]]},[3,2]],"e":[{".":[{},[4]],"l":[{},[0,2]]}],"o":[{".":[{},[4]]}],"u":[{".":[{},[4]]}],"y":[{},[0,2]],"ą":[{},[4]],"ų":[{},[4]]},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{},[3]],"p":[{},[2,1]],"r":[{"a":[{"u":[{},[0,4]]}],"i":[{"s":[{"t":[{},[0,0,0,5]]},[0,0,0,0,2]]}],"o":[{"v":[{},[0,4]]},[0,3]],"u":[{"n":[{},[5]]},[4,3]],"y":[{},[0,4]],"ą":[{},[0,5]]},[2,2]],"s":[{"k":[{},[0,4]],"l":[{},[0,0,3]],"p":[{},[0,4,3]]},[2,1]],"t":[{"a":[{},[0,3]]},[4,1]],"u":[{"b":[{},[4]],"k":[{},[0,0,4]],"p":[{"r":[{},[0,0,4]]}]},[3]],"v":[{"a":[{},[0,2]],"o":[{},[0,3]],"ė":[{},[0,2]]},[2,1]],"w":[{},[2,1]],"y":[{"t":[{},[3]]}],"z":[{},[2,1]],"ą":[{},[5]],"č":[{},[2,1]],"š":[{"l":[{"y":[{},[0,0,2]]}],"ė":[{},[0,0,0,3]]},[2,1]],"ž":[{},[2,1]]}],"l":[{"a":[{".":[{},[3]],"p":[{"s":[{"t":[{"o":[{},[0,0,0,4,3]]}]}]}]}],"b":[{"r":[{},[0,0,3]]},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{".":[{},[3]],"c":[{},[0,0,3]],"g":[{"r":[{},[0,0,4]]}],"č":[{},[4]]}],"f":[{},[2,1]],"g":[{"s":[{"t":[{},[0,0,3,2]]}]},[2,1]],"h":[{},[2,1]],"i":[{".":[{},[3]],"a":[{},[0,0,4]],"o":[{},[5,0,4]],"ų":[{},[3]]}],"j":[{},[2,1]],"k":[{"o":[{},[0,0,0,1]]},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{".":[{},[3]],"g":[{},[0,0,0,4]],"p":[{},[4]]}],"p":[{"n":[{"a":[{},[0,0,0,0,1]]}]},[4,1]],"r":[{},[2,1]],"s":[{"k":[{},[0,4]],"p":[{},[0,4,3]]},[4,1]],"t":[{},[4,3]],"u":[{".":[{},[3]],"p":[{},[2]]}],"v":[{},[4,1]],"w":[{},[2,1]],"y":[{"č":[{},[3]]}],"z":[{},[2,1]],"ą":[{},[3]],"č":[{},[2,1]],"ę":[{"s":[{},[3]]}],"ė":[{"m":[{},[3]],"s":[{},[3]],"č":[{},[2]]}],"į":[{},[3,0,4]],"š":[{},[4,1]],"ų":[{},[3]],"ž":[{},[2,1]]}],"m":[{"a":[{"i":[{"d":[{},[2,3]]}],"s":[{"k":[{"i":[{},[0,0,0,3]]}]},[3]]},[0,2]],"b":[{"r":[{},[0,0,3]]},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"c":[{},[0,0,3]],"i":[{"s":[{},[0,0,0,0,1]]}]}],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"g":[{"l":[{},[0,0,4]],"r":[{},[0,0,4]]}],"n":[{"s":[{},[0,0,0,4]]}],"t":[{"r":[{},[0,0,4]]}]}],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{"d":[{},[2]]},[0,2]],"p":[{"l":[{},[0,4]],"r":[{},[0,3]]},[2,1]],"r":[{},[2,1]],"s":[{},[4,1]],"t":[{"a":[{},[0,3]]},[2,1]],"u":[{"o":[{},[3]]}],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"n":[{"a":[{"s":[{},[0,0,3,2]],"t":[{},[0,0,3,2]]}],"b":[{},[2,1]],"c":[{"e":[{"n":[{},[0,0,0,0,1]]}]},[2,1]],"d":[{"r":[{"ė":[{},[0,3]]}]},[2,1]],"e":[{"g":[{},[0,0,0,4]],"i":[{"m":[{},[0,0,0,2]]}],"o":[{"r":[{},[0,0,0,0,2]]},[0,0,4,3]],"r":[{"ė":[{},[0,0,0,0,3]]}],"s":[{"i":[{},[0,0,0,0,1]],"l":[{},[0,0,3]],"t":[{},[0,0,3,2]]}],"t":[{},[0,0,3,2]],"į":[{"s":[{"t":[{},[0,0,0,0,3]]}]}]},[0,0,1]],"f":[{},[2,1]],"g":[{"l":[{},[0,0,3]],"r":[{},[0,0,4]]},[4,1]],"h":[{},[2,1]],"i":[{"s":[{},[0,0,4]]}],"j":[{},[2,1]],"k":[{"l":[{"a":[{},[0,0,3]]}],"r":[{"y":[{},[0,3]]},[0,0,3]]},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{},[5]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{"k":[{"u":[{},[0,0,4]]}],"l":[{},[0,0,3]],"p":[{},[0,4,3]],"t":[{"r":[{},[0,0,0,3]]}]},[4,1]],"t":[{"a":[{},[0,3]],"p":[{"l":[{},[0,0,4]]}],"r":[{"u":[{"o":[{},[0,0,2]]},[0,3]]}]},[4,1]],"u":[{"a":[{},[0,0,0,4]],"b":[{},[0,0,3,2]],"g":[{},[0,0,3]],"i":[{},[0,0,1]],"k":[{},[0,0,0,2]],"o":[{"s":[{},[0,0,0,0,2]]},[0,0,4,3]],"s":[{},[0,0,5,4]]}],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[4,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"o":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{"r":[{},[0,3]]},[0,1]],"e":[{"t":[{},[0,2]]},[0,1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{"r":[{},[0,3]]},[0,1]],"l":[{"e":[{"n":[{},[0,0,0,0,1]]}]},[0,1]],"m":[{"p":[{"r":[{},[0,0,4]]}]},[0,1]],"n":[{"o":[{},[0,0,0,1]]},[0,1]],"o":[{},[0,1,2]],"p":[{},[0,1]],"r":[{"i":[{"e":[{},[0,2]],"s":[{},[0,0,0,4]]}],"t":[{"r":[{},[0,0,4]]}],"ę":[{},[0,2]]},[0,1]],"s":[{"l":[{"e":[{},[0,0,3]],"o":[{},[0,0,4]]},[0,3]],"v":[{},[0,3,2]]},[0,1]],"t":[{"o":[{},[0,0,0,1]]},[0,3,2]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1]],"į":[{},[0,1]],"š":[{"v":[{},[0,0,2]]},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"p":[{"a":[{"d":[{},[0,0,0,2]],"i":[{"l":[{},[0,0,0,2]],"m":[{},[0,0,0,2]],"r":[{},[0,0,0,2]]}],"n":[{},[3]],"p":[{},[0,0,0,4]],"r":[{"s":[{"i":[{},[0,0,0,0,0,1]]}],"ė":[{},[0,0,4,1,2]]},[0,2]],"s":[{"r":[{},[0,0,5]]},[0,0,0,2]],"t":[{},[0,2,0,2]]},[0,0,3]],"b":[{},[2,1]],"c":[{},[4,1]],"d":[{},[4,3,2]],"e":[{"r":[{"e":[{},[0,0,2]],"i":[{"m":[{},[0,0,2,3]]}],"s":[{},[0,0,0,3]],"ė":[{},[0,0,2]]},[0,0,0,1]]},[0,2]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"e":[{"š":[{},[0,3]]}]},[0,2]],"k":[{},[2,3,2]],"l":[{"e":[{},[0,3]],"i":[{"o":[{},[4]],"u":[{},[0,4]]},[0,3]],"o":[{"j":[{},[0,4]]},[0,3]],"u":[{},[0,4]],"y":[{},[0,4]]},[3,2]],"m":[{},[2,1]],"n":[{},[4,1]],"o":[{"g":[{},[0,0,4]],"l":[{"i":[{},[0,0,0,0,1]]}]},[3]],"p":[{},[2,1]],"r":[{"a":[{"i":[{},[0,3]],"u":[{"s":[{"i":[{},[0,0,0,0,2]]}]}],"š":[{},[0,3]]}],"i":[{"s":[{},[0,0,0,0,2]]},[0,3]],"o":[{".":[{},[0,5]],"m":[{},[0,3]]}],"y":[{},[0,3]],"ą":[{},[4]],"ė":[{},[0,3]],"ū":[{},[0,3]]},[2,2]],"s":[{"i":[{},[0,0,0,1]],"k":[{},[0,5,4]],"t":[{"y":[{},[0,4,3]]}],"v":[{},[0,3,2]]},[4,1]],"t":[{},[4,3,2]],"u":[{"s":[{"i":[{"a":[{"u":[{},[0,0,0,0,0,0,1]]}]}],"k":[{},[0,0,4]],"l":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,4]]}]},[3,4]],"v":[{},[2,1]],"w":[{},[2,1]],"y":[{},[0,2]],"z":[{},[2,1]],"č":[{},[2,1]],"ė":[{},[0,2]],"š":[{},[4,3,2]],"ž":[{},[4,3]]}],"r":[{"a":[{".":[{},[3]],"b":[{},[0,0,3]],"c":[{},[3]],"i":[{"m":[{},[0,0,1]],"t":[{"į":[{},[0,0,0,4]]}]}],"k":[{"r":[{},[0,0,3]]}],"l":[{},[3]],"m":[{},[3]],"s":[{"l":[{},[0,0,0,4]],"m":[{},[0,0,3]]}],"u":[{"k":[{"a":[{".":[{},[0,0,0,4]]}]}]}],"v":[{},[3]]},[0,2]],"b":[{"o":[{},[0,0,0,1]],"r":[{},[0,3,4]]},[2,1]],"c":[{},[2,1]],"d":[{},[4,1]],"e":[{"b":[{},[2]],"i":[{"n":[{},[4]],"t":[{},[4]]}],"l":[{},[3]],"p":[{},[0,0,4,5]],"s":[{"l":[{},[0,0,0,3]]},[5]],"t":[{},[3]]}],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{".":[{},[3]],"d":[{},[0,0,3]],"j":[{},[3]],"k":[{"r":[{},[0,0,3]]}],"l":[{},[2]],"m":[{"a":[{".":[{},[0,0,2]]}],"t":[{},[2,3]]}],"o":[{},[3]],"p":[{},[0,0,3]],"s":[{"i":[{},[0,0,0,0,1]],"t":[{},[0,0,3]]}],"v":[{"i":[{"n":[{},[0,0,0,0,0,1]]}]}],"ą":[{},[3]],"ų":[{},[3]],"ū":[{},[2]]},[0,2]],"k":[{"l":[{"y":[{},[0,0,3]]}],"r":[{},[0,3,4]]},[4,1]],"l":[{},[4,1]],"m":[{},[2,1]],"n":[{},[4,1]],"o":[{"d":[{},[3,0,0,2]],"g":[{"r":[{},[0,0,4]]}],"j":[{},[3]],"k":[{},[3]],"n":[{},[3]],"p":[{},[3]],"r":[{"g":[{},[2,3]]}],"s":[{},[5]]},[0,2]],"p":[{"r":[{},[0,3,4]]},[2,1]],"r":[{},[2,1]],"s":[{"k":[{"o":[{".":[{},[0,0,4]]}]}],"p":[{},[0,0,4]]},[4,1]],"t":[{"i":[{"k":[{},[0,0,0,5,4]],"s":[{},[0,0,0,3,2]]}],"r":[{},[0,3,2]],"v":[{},[0,3,2]]},[4,1]],"u":[{"k":[{},[2]],"l":[{},[3]],"n":[{},[4]],"o":[{"s":[{},[3]]}],"p":[{},[2]],"s":[{"k":[{},[0,0,4]]},[3]],"t":[{"o":[{},[4]]}]},[0,2]],"v":[{},[4,1]],"w":[{},[2,1]],"z":[{},[2,1]],"ą":[{"s":[{},[4]]},[3]],"č":[{},[4,1]],"š":[{"l":[{},[0,3,2]],"m":[{},[0,3,2]]},[4,1]],"ų":[{},[5]],"ž":[{},[2,1]]}],"s":[{"a":[{"l":[{"a":[{},[0,0,0,0,1]]}],"m":[{"ž":[{},[2,1]]}],"n":[{"t":[{},[0,0,0,5]]}],"r":[{"k":[{"a":[{},[0,0,0,0,0,1]]}]}]}],"b":[{},[2,3]],"c":[{},[2,1]],"d":[{},[2,3]],"e":[{"k":[{"r":[{},[0,0,4]]}],"n":[{"a":[{"t":[{},[0,0,0,0,0,4]]}]}]},[0,2]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"a":[{"u":[{"k":[{},[0,0,3]]}],"v":[{},[0,0,3,2]],"š":[{},[0,0,3,2]]}],"d":[{},[0,0,3]],"k":[{},[0,0,3,4]],"p":[{},[0,0,3,4]],"s":[{},[0,0,3,2]],"š":[{"v":[{},[0,0,5,2]]}]}],"k":[{".":[{},[4]],"a":[{".":[{},[0,5]]}],"e":[{"n":[{},[5,4]]},[4]],"i":[{},[5]],"l":[{"e":[{},[5,4]]}],"r":[{},[5,0,4]],"u":[{"b":[{},[5]]}],"v":[{"a":[{},[0,0,3]],"i":[{},[0,0,3]]}],"y":[{},[5]],"ą":[{},[4]],"ę":[{},[5]]},[3,2,2]],"l":[{"e":[{},[3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[4,3]],"ū":[{},[4,3]]},[2,2]],"m":[{"e":[{".":[{},[4]]}],"ę":[{},[4]]},[2,1]],"n":[{},[4,3]],"o":[{"d":[{"r":[{},[0,0,4]]}]}],"p":[{"e":[{},[0,3]],"n":[{},[4]],"u":[{},[4]]},[3,2]],"r":[{"i":[{},[0,3]]},[4,1]],"s":[{},[2,1]],"t":[{"a":[{"l":[{},[0,2]]}],"e":[{"n":[{},[0,2]]}],"i":[{"n":[{},[4]]}],"o":[{"d":[{},[0,2]],"j":[{},[0,2]],"v":[{},[3,2]]}],"r":[{"a":[{"i":[{},[0,0,2]]}]}],"v":[{},[0,0,2]],"ę":[{},[4]],"ė":[{},[4,3]],"ų":[{},[4]],"ū":[{},[0,2]]},[2,1]],"u":[{"b":[{"l":[{},[0,0,3]]}],"d":[{},[0,0,3,2]],"g":[{},[0,0,3,2]],"k":[{"l":[{},[0,0,0,2]]}],"s":[{"i":[{},[0,0,0,0,1]]},[0,0,3,2]],"ž":[{},[0,0,0,4]]},[0,0,1]],"v":[{"e":[{},[0,2]],"y":[{},[3,2]]},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"ą":[{},[0,0,3]],"č":[{},[4,3]],"ė":[{},[5]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"t":[{"a":[{"b":[{},[2]],"k":[{"r":[{},[0,0,3]]}],"s":[{},[0,0,5]],"t":[{},[2]],"u":[{"r":[{"a":[{},[0,0,0,0,0,1]]}]}],"č":[{},[2]]},[0,2]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"b":[{},[2]],"m":[{},[3]],"o":[{},[0,0,4]],"t":[{},[0,0,3,2]]}],"f":[{},[2,1]],"g":[{},[4,3]],"h":[{},[2,1]],"i":[{"g":[{"r":[{},[0,0,4]]}],"k":[{"l":[{},[0,0,4,3]]}],"n":[{},[3]],"p":[{},[2]]},[0,2]],"j":[{},[4,3]],"k":[{"l":[{},[0,4]]},[4,3]],"l":[{},[4,3]],"m":[{},[4,3]],"n":[{},[2,1]],"o":[{"j":[{"e":[{},[3]]}],"l":[{"į":[{},[2]]}],"s":[{},[0,0,3,2]],"w":[{},[2]]},[0,2]],"p":[{"j":[{},[0,4]],"l":[{"ū":[{},[0,0,3]]}],"r":[{},[0,0,4]]},[2,3]],"r":[{"i":[{"o":[{},[4]],"š":[{},[0,2]]}],"o":[{},[4]],"ą":[{},[4]],"ų":[{},[4]]},[2,1]],"s":[{"i":[{},[0,0,0,1]],"k":[{"r":[{"i":[{},[0,0,0,0,0,1]]}]}]},[4,3,4]],"t":[{},[4,1]],"u":[{"a":[{},[0,0,0,4]],"r":[{},[3]]}],"v":[{"o":[{},[0,2]],"ė":[{"j":[{},[4]]}]},[2,1]],"w":[{},[2,1]],"y":[{"d":[{},[3]]}],"z":[{},[2,1]],"č":[{},[2,1]],"ę":[{},[3]],"ė":[{"m":[{"u":[{},[0,3]],"ę":[{},[0,3]],"ė":[{},[0,3]]},[0,2]]}],"š":[{},[2,3,2]],"ž":[{},[2,3]]}],"u":[{"a":[{"i":[{},[0,3]]},[0,1,2]],"b":[{"j":[{},[0,2]]},[0,1]],"c":[{},[0,1]],"d":[{},[0,1]],"e":[{},[0,1,2]],"f":[{},[0,1]],"g":[{"r":[{"i":[{"o":[{},[0,0,5]]}]},[0,0,4]]},[0,1]],"h":[{},[0,1]],"i":[{"m":[{},[0,1,2]],"n":[{},[0,5]],"r":[{},[0,0,2]]}],"j":[{},[0,1]],"k":[{"l":[{"e":[{},[0,0,2]]},[0,3]],"r":[{},[0,3]],"v":[{},[0,3]],"ų":[{},[0,5]]},[0,1]],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{"r":[{},[0,3]],"s":[{"l":[{},[0,0,4]]}]},[0,2]],"p":[{"l":[{},[0,0,4]],"r":[{"o":[{},[0,0,3]]}]},[0,3]],"r":[{"k":[{"l":[{},[0,0,3]]},[0,0,0,2]],"o":[{},[0,5,0,1]],"s":[{},[0,0,3,2]]},[0,1]],"s":[{"a":[{"l":[{},[0,2,1]]}],"l":[{"a":[{},[0,0,3]],"e":[{},[0,0,3]]},[0,3]],"v":[{"a":[{},[0,0,0,0,1]],"e":[{},[0,0,3]]}]},[0,1]],"t":[{"o":[{},[0,0,0,1]],"r":[{},[2]]},[0,3,2]],"u":[{},[0,1]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1,2]],"į":[{},[0,1]],"š":[{"l":[{},[0,3,2]],"n":[{},[0,3,2]],"v":[{},[0,0,2]]},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1,2]],"ž":[{"i":[{"m":[{},[0,0,0,2]]}],"l":[{},[0,3]],"v":[{},[0,0,3]],"ė":[{},[0,0,1,2]]},[0,1]]}],"v":[{"a":[{".":[{},[3]],"p":[{},[0,0,0,4]],"t":[{},[0,0,3]]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"p":[{},[2]],"s":[{},[3]]},[0,2]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"e":[{"s":[{"i":[{"a":[{},[0,0,0,0,0,0,1]]}]}]}],"s":[{"k":[{},[0,0,4,5]]}],"t":[{"r":[{},[0,0,4,3]]}]}],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,4]],"t":[{},[2,1]],"v":[{},[2,1]],"w":[{},[2,1]],"y":[{"d":[{"a":[{"u":[{},[2]]}]}]}],"z":[{},[2,1]],"ą":[{},[3]],"č":[{},[2,1]],"ė":[{"p":[{},[4]]},[3]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"w":[{"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"y":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{},[0,1]],"e":[{},[0,1]],"f":[{},[0,1]],"g":[{"i":[{"a":[{},[0,0,0,0,1]]}]},[0,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{"l":[{},[0,4,3]]},[0,1]],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{},[0,1]],"p":[{},[0,1]],"r":[{},[0,3]],"s":[{"k":[{},[0,4]]},[0,1]],"t":[{},[0,1]],"u":[{},[0,1]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1]],"į":[{},[0,1]],"š":[{},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"z":[{"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"ą":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{},[0,1]],"e":[{},[0,1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{},[0,1]],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{},[0,1]],"p":[{},[0,1]],"r":[{},[0,1]],"s":[{},[0,1]],"t":[{},[0,1]],"u":[{},[0,1]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1]],"į":[{},[0,1]],"š":[{},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"č":[{"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"k":[{"o":[{},[0,0,0,0,1]]}]}],"f":[{},[2,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"n":[{},[0,0,0,1]]}],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"p":[{},[2,1]],"r":[{},[2,1]],"s":[{},[2,1]],"t":[{},[2,1]],"v":[{},[2,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"š":[{},[2,1]],"ž":[{},[2,1]]}],"ę":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{},[0,1]],"e":[{},[0,1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{},[0,1]],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{},[0,1]],"p":[{},[0,1]],"r":[{},[0,1]],"s":[{},[0,1]],"t":[{},[0,1]],"u":[{},[0,1]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1]],"į":[{},[0,1]],"š":[{},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"ė":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{},[0,1]],"e":[{},[0,1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{"l":[{},[0,4,3]]},[0,1]],"l":[{},[2,3]],"m":[{"e":[{},[0,3]]},[0,1]],"n":[{},[0,1]],"o":[{},[0,1]],"p":[{},[0,1]],"r":[{},[0,1]],"s":[{"l":[{},[0,0,3]]},[2,1]],"t":[{"r":[{},[0,4]]},[2,3]],"u":[{},[0,1]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1]],"į":[{},[0,1]],"š":[{},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"į":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{},[0,1,2]],"e":[{},[0,2]],"f":[{},[0,1]],"g":[{},[0,4]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{},[0,2,4]],"l":[{},[0,2]],"m":[{},[0,2]],"n":[{},[0,1]],"o":[{},[0,1]],"p":[{},[0,4]],"r":[{},[0,2]],"s":[{"i":[{},[0,0,0,1]],"l":[{},[0,0,3]],"m":[{},[0,0,2]],"r":[{},[0,0,2]],"t":[{},[0,0,0,2]]},[0,1]],"t":[{},[0,2,2]],"u":[{},[0,1]],"v":[{},[0,2]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1,2]],"į":[{},[0,1]],"š":[{},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"š":[{"b":[{},[2,1,2]],"c":[{},[2,1]],"d":[{},[2,3,2]],"e":[{"i":[{},[0,1]],"v":[{},[0,0,2]]}],"f":[{},[2,1]],"g":[{},[2,1,4]],"h":[{},[2,1]],"i":[{"s":[{"t":[{},[2,5]]}],"u":[{"k":[{},[0,0,0,0,1]]}]}],"k":[{},[2,1,2]],"l":[{"i":[{"j":[{},[0,2]]}],"u":[{},[0,2]],"y":[{},[3]]},[2,1]],"m":[{},[2,1]],"n":[{"e":[{},[0,2]],"o":[{},[0,0,0,1]]},[2,1]],"o":[{"r":[{},[0,0,2]]}],"p":[{},[2,1,4]],"r":[{},[2,1]],"s":[{"i":[{"k":[{"a":[{"p":[{},[0,0,0,0,0,0,1]]}]}]},[0,0,0,1]]},[2,3,4]],"t":[{},[4,3,2]],"u":[{"š":[{},[0,0,4]]}],"v":[{"i":[{},[0,2]],"y":[{"d":[{},[0,4]]}]},[3,1]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[4,3]],"ė":[{"j":[{},[0,0,2]]}],"š":[{},[2,1]],"ž":[{},[2,1]]}],"ų":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{},[0,1]],"e":[{},[0,1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{},[0,1]],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{},[0,1]],"p":[{},[0,1]],"r":[{},[0,1]],"s":[{},[0,1]],"t":[{},[0,1]],"u":[{},[0,1]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1]],"į":[{},[0,1]],"š":[{},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"ū":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{},[0,1]],"d":[{},[0,1]],"e":[{},[0,1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{"l":[{},[0,4,3]]},[0,1]],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{},[0,1]],"p":[{},[0,1]],"r":[{},[0,1]],"s":[{"k":[{},[0,4,3]],"l":[{},[0,0,3]],"t":[{},[0,0,3]]},[0,1]],"t":[{},[0,1]],"u":[{},[0,1]],"v":[{},[0,1]],"w":[{},[0,1]],"y":[{},[0,1]],"z":[{},[0,1]],"ą":[{},[0,1]],"č":[{},[0,1]],"ę":[{},[0,1]],"ė":[{},[0,1]],"į":[{},[0,1]],"š":[{},[0,1]],"ų":[{},[0,1]],"ū":[{},[0,1]],"ž":[{},[0,1]]}],"ž":[{"a":[{"n":[{"t":[{"s":[{},[0,0,0,0,0,5]]},[0,0,0,0,4]]}]}],"b":[{},[2,3,2]],"c":[{},[2,1]],"d":[{},[2,3,2]],"e":[{"n":[{},[0,0,0,1]]}],"f":[{},[2,3,4]],"g":[{},[2,3]],"h":[{},[2,1]],"i":[{"m":[{"u":[{},[0,0,3]]}],"o":[{},[0,0,0,3]]}],"j":[{},[0,1]],"k":[{},[2,3,2]],"l":[{"u":[{},[0,2]]},[2,1]],"m":[{},[4,1]],"n":[{},[2,1]],"p":[{},[2,3]],"r":[{},[2,1]],"s":[{"i":[{},[0,0,0,1]],"k":[{},[0,4]],"l":[{},[0,4,5]],"t":[{},[0,0,3]]},[2,1]],"t":[{},[4,3,2]],"u":[{"s":[{},[0,0,3,2]]},[0,2]],"v":[{"i":[{},[0,4]],"o":[{},[0,3]]},[3,2]],"w":[{},[2,1]],"z":[{},[2,1]],"č":[{},[2,1]],"į":[{"s":[{},[0,0,0,3]]}],"š":[{},[2,1]],"ž":[{},[2,1]]}]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
