export declare const FHIR_INTERACTIONS: {
    INSTANCE: {
        READ: string;
        VREAD: string;
        UPDATE: string;
        DELETE: string;
        HISTORY: string;
    };
    TYPE: {
        CREATE: string;
        SEARCH: string;
        HISTORY: string;
    };
    SYSTEM: {
        CAPABILITIES: string;
        TRANSACTION: string;
        HISTORY: string;
        SEARCH: string;
    };
    INTERNAL: {
        MATERIALISE: string;
    };
};
export declare const FHIR_SEARCH_PARAMETERS: {
    NUMBER: string;
    DATE: string;
    STRING: string;
    TOKEN: string;
    REFERENCE: string;
    COMPOSITE: string;
    QUANTITY: string;
    URI: string;
    SPECIAL: string;
};
export declare const FHIR_SEARCH_TOKEN_TYPES: {
    VALUE: string;
    CODING: string;
    STRING: string;
    BOOLEAN: string;
    PRESENCE: string;
};
export declare const FHIR_SEARCH_PREFIXES: {
    EQ: string;
    NE: string;
    GT: string;
    LT: string;
    GE: string;
    LE: string;
};
export declare const FHIR_PATIENT_LINK_TYPES: {
    REPLACES: string;
    REPLACED_BY: string;
    SEE_ALSO: string;
};
export declare const FHIR_MAX_RESOURCES_PER_PAGE = 20;
export declare const FHIR_DATETIME_PRECISION: {
    SECONDS_WITH_TIMEZONE: string;
    MINUTES_WITH_TIMEZONE: string;
    HOURS_WITH_TIMEZONE: string;
    SECONDS: string;
    MINUTES: string;
    HOURS: string;
    DAYS: string;
    MONTHS: string;
    YEARS: string;
};
export declare const FHIR_BUNDLE_TYPES: {
    DOCUMENT: string;
    MESSAGE: string;
    TRANSACTION: string;
    TRANSACTION_RESPONSE: string;
    BATCH: string;
    BATCH_RESPONSE: string;
    HISTORY: string;
    SEARCHSET: string;
    COLLECTION: string;
};
export declare const FHIR_RESOURCE_TYPES: {
    BUNDLE: string;
    COMPOSITION: string;
    PATIENT: string;
    MEDICATION_STATEMENT: string;
    ALLERGY_INTOLERANCE: string;
    CONDITION: string;
    IMMUNIZATION: string;
};
export declare const FHIR_ISSUE_SEVERITY: {
    INFORMATION: string;
    WARNING: string;
    ERROR: string;
    FATAL: string;
};
export declare const FHIR_ISSUE_TYPE: {
    INVALID: {
        _: string;
        STRUCTURE: string;
        REQUIRED: string;
        VALUE: string;
        INVARIANT: string;
    };
    SECURITY: {
        _: string;
        LOGIN: string;
        UNKNOWN: string;
        EXPIRED: string;
        FORBIDDEN: string;
        SUPPRESSED: string;
    };
    PROCESSING: {
        _: string;
        NOT_SUPPORTED: string;
        DUPLICATE: string;
        MULTIPLE_MATCHES: string;
        NOT_FOUND: {
            _: string;
            DELETED: string;
        };
        TOO_LONG: string;
        CODE_INVALID: string;
        EXTENSION: string;
        TOO_COSTLY: string;
        BUSINESS_RULE: string;
        CONFLICT: string;
    };
    TRANSIENT: {
        _: string;
        LOCK_ERROR: string;
        NO_STORE: string;
        EXCEPTION: string;
        TIMEOUT: string;
        INCOMPLETE: string;
        THROTTLED: string;
    };
    INFORMATIONAL: string;
};
export declare const FHIR_REQUEST_STATUS: {
    DRAFT: string;
    ACTIVE: string;
    ON_HOLD: string;
    REVOKED: string;
    COMPLETED: string;
    ENTERED_IN_ERROR: string;
    UNKNOWN: string;
};
export declare const FHIR_REQUEST_INTENT: {
    PROPOSAL: string;
    PLAN: string;
    DIRECTIVE: string;
    ORDER: {
        _: string;
        ORIGINAL: string;
        REFLEX: string;
        FILLER: {
            _: string;
            INSTANCE: string;
        };
    };
    OPTION: string;
};
export declare const FHIR_REQUEST_PRIORITY: {
    ROUTINE: string;
    URGENT: string;
    ASAP: string;
    STAT: string;
};
export declare const FHIR_DIAGNOSTIC_REPORT_STATUS: {
    REGISTERED: string;
    PARTIAL: {
        _: string;
        PRELIMINARY: string;
        MODIFIED: string;
    };
    FINAL: string;
    AMENDED: {
        _: string;
        CORRECTED: string;
        APPENDED: string;
    };
    CANCELLED: string;
    ENTERED_IN_ERROR: string;
    UNKNOWN: string;
};
export declare const FHIR_IMAGING_STUDY_STATUS: {
    REGISTERED: string;
    AVAILABLE: string;
    FINAL_INVALID_LEGACY: string;
    CANCELLED: string;
    ENTERED_IN_ERROR: string;
    UNKNOWN: string;
};
export declare const FHIR_ENCOUNTER_CLASS_DISPLAY: {
    IMP: string;
    AMB: string;
    OBSENC: string;
    EMER: string;
    HH: string;
    VR: string;
};
export declare const FHIR_ENCOUNTER_CLASS_CODE: {
    [k: string]: string;
};
export declare const FHIR_ENCOUNTER_STATUS: {
    PLANNED: string;
    IN_PROGRESS: string;
    ON_HOLD: string;
    DISCHARGED: string;
    COMPLETED: string;
    CANCELLED: string;
    DISCONTINUED: string;
    ENTERED_IN_ERROR: string;
    UNKNOWN: string;
};
export declare const FHIR_ENCOUNTER_LOCATION_STATUS: {
    PLANNED: string;
    ACTIVE: string;
    RESERVED: string;
    COMPLETED: string;
};
export declare const FHIR_LOCATION_PHYSICAL_TYPE_CODE: {
    SITE: string;
    BUILDING: string;
    WING: string;
    WARD: string;
    LEVEL: string;
    CORRIDOR: string;
    ROOM: string;
    BED: string;
    VEHICLE: string;
    HOUSE: string;
    CABINET: string;
    ROAD: string;
    AREA: string;
    JURISDICTION: string;
    VIRTUAL: string;
};
export declare const FHIR_LOCATION_PHYSICAL_TYPE_DISPLAY: {
    [k: string]: string;
};
export declare const IPS_REQUEST_STATUSES: {
    QUEUED: string;
    PROCESSED: string;
    ERROR: string;
    IGNORE: string;
};
export declare const HTTP_BODY_DATA_PATHS: {
    DIAGNOSTIC_REPORT_ATTACHMENT: string;
};
export declare const SCRUBBED_DATA_MESSAGE = "Raw data removed from logs";
export declare const SUPPORTED_CONTENT_TYPES: {
    PDF: string;
};
export declare const DEFAULT_REASON_CANCELLED_BY_API = "cancelled externally via api";
