export declare const PROGRAM_DATA_ELEMENT_TYPES: {
    TEXT: string;
    MULTILINE: string;
    RADIO: string;
    SELECT: string;
    MULTI_SELECT: string;
    AUTOCOMPLETE: string;
    DATE: string;
    DATE_TIME: string;
    SUBMISSION_DATE: string;
    INSTRUCTION: string;
    NUMBER: string;
    BINARY: string;
    CHECKBOX: string;
    CALCULATED: string;
    CONDITION: string;
    RESULT: string;
    SURVEY_ANSWER: string;
    SURVEY_RESULT: string;
    SURVEY_LINK: string;
    PHOTO: string;
    PATIENT_DATA: string;
    USER_DATA: string;
    PATIENT_ISSUE: string;
    GEOLOCATE: string;
};
export declare const PROGRAM_DATA_ELEMENT_TYPE_VALUES: string[];
export declare const NON_ANSWERABLE_DATA_ELEMENT_TYPES: string[];
export declare const ACTION_DATA_ELEMENT_TYPES: string[];
export declare const SURVEY_TYPES: {
    PROGRAMS: string;
    REFERRAL: string;
    OBSOLETE: string;
    VITALS: string;
};
export declare const VITALS_DATA_ELEMENT_IDS: {
    dateRecorded: string;
    temperature: string;
    weight: string;
    height: string;
    sbp: string;
    dbp: string;
    heartRate: string;
    respiratoryRate: string;
    spo2: string;
    avpu: string;
};
export declare const BLOOD_PRESSURE = "BLOOD_PRESSURE";
export declare const LINE = "LINE";
export declare const VITAL_CHARTS: {
    "pde-PatientVitalsTemperature": string;
    "pde-PatientVitalsWeight": string;
    "pde-PatientVitalsHeight": string;
    "pde-PatientVitalsSBP": string;
    "pde-PatientVitalsDBP": string;
    "pde-PatientVitalsHeartRate": string;
    "pde-PatientVitalsRespiratoryRate": string;
    "pde-PatientVitalsSPO2": string;
    "pde-PatientVitalsAVPU": string;
};
type PatientDataFieldLocationsType = {
    [key: string]: Array<string>;
};
export declare const PATIENT_DATA_FIELD_LOCATIONS: PatientDataFieldLocationsType;
export declare const READONLY_DATA_FIELDS: {
    AGE: string;
    AGE_WITH_MONTHS: string;
    FULL_NAME: string;
};
export declare const PROGRAM_REGISTRY_FIELD_LOCATIONS: string[];
export declare const RESULT_COLORS: {
    green: string;
    yellow: string;
    orange: string;
    red: string;
    deepred: string;
    purple: string;
};
export {};
