"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "checkConfig", {
    enumerable: true,
    get: function() {
        return checkConfig;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _logging = require("@tamanu/shared/services/logging");
const _configSelectors = require("@tamanu/shared/utils/configSelectors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function checkConfig({ settings, models }) {
    const ensureExists = async (modelName, code)=>{
        const found = await models[modelName].findOne({
            where: {
                code
            }
        });
        if (!found) {
            _logging.log.error(`Default survey ${modelName} with code ${code} could not be found`);
        }
    };
    const facilityIds = (0, _configSelectors.selectFacilityIds)(_config.default);
    for (const facilityId of facilityIds){
        const { department, location } = await settings[facilityId].get('survey.defaultCodes');
        await Promise.all([
            ensureExists('Department', department),
            ensureExists('Location', location)
        ]);
    }
}

//# sourceMappingURL=checkConfig.js.map