"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getImagingProvider", {
    enumerable: true,
    get: function() {
        return getImagingProvider;
    }
});
const _constants = require("@tamanu/constants");
const _MerlinProvider = require("./MerlinProvider");
const _TestProvider = require("./TestProvider");
async function getImagingProvider(models, settings) {
    const config = await settings.get(_constants.SETTING_KEYS.INTEGRATIONS_IMAGING);
    if (!config || !config.enabled) return false;
    switch(config.provider){
        case 'test':
            return new _TestProvider.TestProvider(models, config);
        case 'merlin':
            return new _MerlinProvider.MerlinProvider(models, config);
        default:
            throw new Error(`unsupported provider: ${config.provider}`);
    }
}

//# sourceMappingURL=getImagingProvider.js.map