"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "attachment", {
    enumerable: true,
    get: function() {
        return attachment;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sync = require("../../sync");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const attachment = _express.default.Router();
attachment.get('/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('read', 'Attachment');
    const { query, params, deviceId } = req;
    const { base64 } = query;
    const { id } = params;
    const localAttachment = await req.models.Attachment.findByPk(params.id);
    if (localAttachment) {
        if (base64 === 'true') {
            res.send({
                data: Buffer.from(localAttachment.data).toString('base64')
            });
        } else {
            res.setHeader('Content-Type', localAttachment.type);
            res.setHeader('Content-Length', localAttachment.size);
            res.send(Buffer.from(localAttachment.data));
        }
        return;
    }
    const centralServer = new _sync.CentralServerConnection({
        deviceId
    });
    const response = await centralServer.fetch(`attachment/${id}?base64=${base64}`, {
        method: 'GET'
    });
    res.send(response);
}));

//# sourceMappingURL=attachment.js.map