"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MedicationDiscontinuer", {
    enumerable: true,
    get: function() {
        return MedicationDiscontinuer;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _datefns = require("date-fns");
const _sequelize = require("sequelize");
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
const _dateTime = require("@tamanu/shared/utils/dateTime");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let MedicationDiscontinuer = class MedicationDiscontinuer extends _tasks.ScheduledTask {
    getName() {
        return 'MedicationDiscontinuer';
    }
    async run() {
        // Get start of day
        const startOfToday = (0, _dateTime.toDateTimeString)((0, _datefns.startOfDay)(new Date()));
        // // Get all encounters with the same facility ID as this facility server
        // // (found in the config). Note that the facility ID will be read from
        // // the department associated to each encounter.
        // const encounters = await this.models.Encounter.findAll({
        //   include: [
        //     {
        //       association: 'department',
        //       required: true,
        //       include: [{ model: this.models.Facility, where: { id: selectFacilityIds(config) } }],
        //     },
        //   ],
        // });
        // // Get all the encounter IDs
        // const encounterIds = encounters.map(row => row.id);
        // Query interface expects database naming scheme
        // (snake case, table column fields)
        // Values to be updated when autodiscontinuing a medication
        const values = {
            discontinued: true,
            discontinuing_reason: 'Finished treatment',
            updated_at: _sequelize.Sequelize.literal('CURRENT_TIMESTAMP')
        };
        // Find all medications that:
        // - Are not discontinued
        // - Belong to an encounter from that matches the current facility
        // - Have an end date (not null) and said end date is previous than today
        const identifier = {
            discontinued: {
                [_sequelize.Op.not]: true
            },
            encounter_id: {
                [_sequelize.Op.in]: _sequelize.Sequelize.literal(`(
            -- Get all encounters with the same facility ID as this facility server (from local_system_facts).
            -- Note that the facility ID will be read from the department associated to each encounter.
            SELECT encounters.id
            FROM encounters
            INNER JOIN
              departments ON encounters.department_id = departments.id
            WHERE departments.facility_id in (
              SELECT jsonb_array_elements_text(value::jsonb)
              FROM local_system_facts
              WHERE key = 'facilityIds'
            )
          )`)
            },
            end_date: {
                [_sequelize.Op.and]: [
                    {
                        [_sequelize.Op.lt]: startOfToday
                    },
                    {
                        [_sequelize.Op.not]: null
                    }
                ]
            }
        };
        // Discontinue medications that match the conditions from
        // the identifier with the values provided
        const queryInterface = this.sequelize.getQueryInterface();
        await queryInterface.bulkUpdate('encounter_medications', values, identifier);
    }
    constructor(context, isDebug){
        const { schedule, jitterTime, enabled } = _config.default.schedules.medicationDiscontinuer;
        super(schedule, _logging.log, jitterTime, enabled);
        this.models = context.models;
        this.sequelize = context.sequelize;
        // Run once on startup (in case the server was down when it was scheduled)
        if (!isDebug) {
            this.run();
        }
    }
};

//# sourceMappingURL=MedicationDiscontinuer.js.map