import * as yup from 'yup';
export declare const centralSettings: {
    name: string;
    description: string;
    properties: {
        disk: {
            name: string;
            description: string;
            properties: {
                freeSpaceRequired: {
                    name: string;
                    description: string;
                    properties: {
                        gigabytesForUploadingDocuments: {
                            name: string;
                            description: string;
                            type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                            defaultValue: number;
                        };
                    };
                };
            };
        };
        questionCodeIds: {
            deprecated: boolean;
            description: string;
            properties: {
                passport: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: any;
                };
                nationalityId: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: any;
                };
                email: {
                    type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                    defaultValue: any;
                };
            };
        };
        reportProcess: {
            properties: {
                timeOutDurationSeconds: {
                    description: string;
                    type: yup.NumberSchema<number, import("yup/lib/types").AnyObject, number>;
                    defaultValue: number;
                    unit: string;
                };
                runInChildProcess: {
                    description: string;
                    type: yup.BooleanSchema<boolean, import("yup/lib/types").AnyObject, boolean>;
                    defaultValue: boolean;
                };
                processOptions: {
                    description: string;
                    type: import("yup/lib/array").OptionalArraySchema<yup.StringSchema<string, import("yup/lib/types").AnyObject, string>, import("yup/lib/types").AnyObject, string[]>;
                    defaultValue: any;
                };
                childProcessEnv: {
                    description: string;
                    type: import("yup/lib/object").OptionalObjectSchema<import("yup/lib/object").ObjectShape, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<import("yup/lib/object").ObjectShape>>;
                    defaultValue: any;
                };
                sleepAfterReport: {
                    description: string;
                    properties: {
                        duration: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                        ifRunAtLeast: {
                            description: string;
                            type: yup.StringSchema<string, import("yup/lib/types").AnyObject, string>;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
    };
};
export declare const centralDefaults: any;
