/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _configSelectors = require("../utils/configSelectors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DEFAULT_SETTINGS = {
    'features.reminderContactModule.enabled': 'false'
};
async function up(query) {
    //this setting only exists on the server
    const isFacilityServer = !!(0, _configSelectors.selectFacilityIds)(_config.default);
    if (isFacilityServer) return;
    await query.bulkInsert('settings', Object.entries(DEFAULT_SETTINGS).map(([key, value])=>({
            key,
            value,
            facility_id: null
        })));
}
async function down(query) {
    const isFacilityServer = !!(0, _configSelectors.selectFacilityIds)(_config.default);
    if (isFacilityServer) return;
    await query.bulkDelete('settings', {
        key: {
            [_sequelize.Op.in]: Object.keys(DEFAULT_SETTINGS)
        },
        facility_id: null
    });
}

//# sourceMappingURL=1712735425293-addFeatureFlagForReminderContactModule.js.map