"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Department", {
    enumerable: true,
    get: function() {
        return Department;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("../errors");
const _Model = require("./Model");
let Department = class Department extends _Model.Model {
    static init({ primaryKey, ...options }) {
        const validate = {
            mustHaveFacility () {
                if (!this.deletedAt && !this.facilityId) {
                    throw new _errors.InvalidOperationError('A department must have a facility.');
                }
            }
        };
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            name: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            visibilityStatus: {
                type: _sequelize.Sequelize.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            validate,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.hasMany(models.Encounter, {
            foreignKey: 'departmentId'
        });
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Department.js.map