"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabTest", {
    enumerable: true,
    get: function() {
        return LabTest;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _Model = require("./Model");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
const LAB_TEST_STATUS_VALUES = Object.values(_constants.LAB_TEST_STATUSES);
let LabTest = class LabTest extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _dateTimeTypes.dateType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateString
            }),
            status: {
                type: _sequelize.Sequelize.STRING(31),
                allowNull: false,
                defaultValue: _constants.LAB_TEST_STATUSES.RECEPTION_PENDING,
                isIn: [
                    LAB_TEST_STATUS_VALUES
                ]
            },
            result: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false,
                defaultValue: ''
            },
            laboratoryOfficer: {
                type: _sequelize.Sequelize.STRING
            },
            verification: {
                type: _sequelize.Sequelize.STRING
            },
            completedDate: (0, _dateTimeTypes.dateTimeType)('completedDate')
        }, {
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            ...options
        });
    }
    static initRelations(models) {
        this.belongsTo(models.LabRequest, {
            foreignKey: 'labRequestId',
            as: 'labRequest'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'categoryId',
            as: 'category'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'labTestMethodId',
            as: 'labTestMethod'
        });
        this.belongsTo(models.LabTestType, {
            foreignKey: 'labTestTypeId',
            as: 'labTestType'
        });
    }
    static getListReferenceAssociations() {
        return [
            'category',
            'labTestType',
            'labTestMethod'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable, sessionConfig) {
        if (sessionConfig.syncAllLabRequests) {
            return ''; // include all lab tests
        }
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'lab_requests',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id',
                isLabRequestValue: 'TRUE'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'lab_requests',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=LabTest.js.map