"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientAllergy", {
    enumerable: true,
    get: function() {
        return PatientAllergy;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("./buildPatientSyncFilterViaPatientId");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let PatientAllergy = class PatientAllergy extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: _sequelize.Sequelize.STRING,
            recordedDate: (0, _dateTimeTypes.dateTimeType)('recordedDate', {
                defaultValue: _dateTime.getCurrentDateTimeString,
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
        this.belongsTo(models.User, {
            foreignKey: 'practitionerId'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'allergyId',
            as: 'allergy'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'reactionId',
            as: 'reaction'
        });
    }
    static getListReferenceAssociations() {
        return [
            'allergy',
            'reaction'
        ];
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
    static buildPatientSyncFilter = _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId;
};

//# sourceMappingURL=PatientAllergy.js.map