"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientIssue", {
    enumerable: true,
    get: function() {
        return PatientIssue;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("./buildPatientSyncFilterViaPatientId");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let PatientIssue = class PatientIssue extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: _sequelize.Sequelize.STRING,
            recordedDate: (0, _dateTimeTypes.dateTimeType)('recordedDate', {
                defaultValue: _dateTime.getCurrentDateTimeString,
                allowNull: false
            }),
            type: {
                type: _sequelize.Sequelize.ENUM(Object.values(_constants.PATIENT_ISSUE_TYPES)),
                defaultValue: _constants.PATIENT_ISSUE_TYPES.ISSUE,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
    static buildPatientSyncFilter = _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId;
};

//# sourceMappingURL=PatientIssue.js.map