"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProgramDataElement", {
    enumerable: true,
    get: function() {
        return ProgramDataElement;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _parseornull = require("../utils/parse-or-null");
const _Model = require("./Model");
let ProgramDataElement = class ProgramDataElement extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: _sequelize.Sequelize.STRING,
            name: _sequelize.Sequelize.STRING,
            indicator: _sequelize.Sequelize.STRING,
            defaultText: _sequelize.Sequelize.STRING,
            defaultOptions: _sequelize.Sequelize.TEXT,
            visualisationConfig: _sequelize.Sequelize.TEXT,
            type: {
                type: _sequelize.Sequelize.STRING(31),
                allowNull: false
            }
        }, {
            ...options,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ],
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    forResponse() {
        const { defaultOptions, ...values } = this.dataValues;
        return {
            ...values,
            defaultOptions: (0, _parseornull.parseOrNull)(defaultOptions)
        };
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ProgramDataElement.js.map