"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirOrganization", {
    enumerable: true,
    get: function() {
        return FhirOrganization;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("../Resource");
const _getQueryOptions = require("./getQueryOptions");
const _getValues = require("./getValues");
const _getQueryToFindUpstreamIds = require("./getQueryToFindUpstreamIds");
const _searchParameters = require("./searchParameters");
let FhirOrganization = class FhirOrganization extends _Resource.FhirResource {
    static init(options, models) {
        super.init({
            identifier: _sequelize.DataTypes.JSONB,
            name: _sequelize.DataTypes.TEXT,
            active: _sequelize.DataTypes.BOOLEAN
        }, options);
        this.UpstreamModels = [
            models.Facility
        ];
        this.upstreams = [
            models.Facility
        ];
    }
    static CAN_DO = new Set([
        _constants.FHIR_INTERACTIONS.INSTANCE.READ,
        _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
        _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
    ]);
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _getQueryOptions.getQueryOptions)(this.sequelize.models));
        const values = await (0, _getValues.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id, deletedRow = null) {
        const { Facility } = this.sequelize.models;
        if (upstreamTable === Facility.tableName) {
            return (0, _getQueryToFindUpstreamIds.fromFacilities)(this.sequelize.models, table, id, deletedRow);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._searchParameters.searchParameters
        };
    }
};

//# sourceMappingURL=FhirOrganization.js.map