"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirPractitioner", {
    enumerable: true,
    get: function() {
        return FhirPractitioner;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("../Resource");
const _getQueryOptions = require("./getQueryOptions");
const _getValues = require("./getValues");
const _getQueryToFindUpstreamIds = require("./getQueryToFindUpstreamIds");
const _searchParameters = require("./searchParameters");
let FhirPractitioner = class FhirPractitioner extends _Resource.FhirResource {
    static init(options, models) {
        super.init({
            name: _sequelize.DataTypes.JSONB,
            identifier: _sequelize.DataTypes.JSONB,
            telecom: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.User
        ];
        this.upstreams = [
            models.User
        ];
    }
    static CAN_DO = new Set([
        _constants.FHIR_INTERACTIONS.INSTANCE.READ,
        _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
        _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
    ]);
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _getQueryOptions.getQueryOptions)(this.sequelize.models));
        const values = await (0, _getValues.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id, deletedRow = null) {
        const { User } = this.sequelize.models;
        if (upstreamTable === User.tableName) {
            return (0, _getQueryToFindUpstreamIds.fromUsers)(this.sequelize.models, table, id, deletedRow);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._searchParameters.searchParameters
        };
    }
};

//# sourceMappingURL=FhirPractitioner.js.map